## An Image is Worth 16x16 Words: Transformers for Image Recognition At Scale

Implementation of ViT architecture proposed in the paper _An Image is Worth 16x16 Words: Transformers for Image Recognition At Scale_.

## Usage

```python
import torch
from model import ViT

model = ViT(
    image_size = 256,
    patch_size = 32,
    num_classes = 1000,
    dim = 1024,
    depth = 6,
    heads = 16,
    mlp_dim = 2048,
    dropout = 0.1,
    emb_dropout = 0.1
)

img = torch.randn(1, 3, 256, 256)

preds = model(img)# (1, 1000)
```

## Training

Training procedure is explained in test_sample_ViT.ipynb

## Citations

```bibtex
@article{dosovitskiy2020image,
  title={An image is worth 16x16 words: Transformers for image recognition at scale},
  author={Dosovitskiy, Alexey and Beyer, Lucas and Kolesnikov, Alexander and Weissenborn, Dirk and Zhai, Xiaohua and Unterthiner, Thomas and Dehghani, Mostafa and Minderer, Matthias and Heigold, Georg and Gelly, Sylvain and others},
  journal={arXiv preprint arXiv:2010.11929},
  year={2020}
}
```
