(function (root, factory) {
  if (typeof define === 'function' && define.amd) define(factory);
  else if (typeof exports !== 'undefined') module.exports = factory();
  else root.Ammo = factory();
})(this, function () {
var Ammo = function(Module) {
  Module = Module || {};

var Module;if(!Module)Module=(typeof Ammo!=="undefined"?Ammo:null)||{};var moduleOverrides={};for(var key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_WEB=false;var ENVIRONMENT_IS_WORKER=false;var ENVIRONMENT_IS_NODE=false;var ENVIRONMENT_IS_SHELL=false;if(Module["ENVIRONMENT"]){if(Module["ENVIRONMENT"]==="WEB"){ENVIRONMENT_IS_WEB=true}else if(Module["ENVIRONMENT"]==="WORKER"){ENVIRONMENT_IS_WORKER=true}else if(Module["ENVIRONMENT"]==="NODE"){ENVIRONMENT_IS_NODE=true}else if(Module["ENVIRONMENT"]==="SHELL"){ENVIRONMENT_IS_SHELL=true}else{throw new Error("The provided Module['ENVIRONMENT'] value is not valid. It must be one of: WEB|WORKER|NODE|SHELL.")}}else{ENVIRONMENT_IS_WEB=typeof window==="object";ENVIRONMENT_IS_WORKER=typeof importScripts==="function";ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function"&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER;ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER}if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=console.log;if(!Module["printErr"])Module["printErr"]=console.warn;var nodeFS;var nodePath;Module["read"]=function read(filename,binary){if(!nodeFS)nodeFS=require("fs");if(!nodePath)nodePath=require("path");filename=nodePath["normalize"](filename);var ret=nodeFS["readFileSync"](filename);if(!ret&&filename!=nodePath["resolve"](filename)){filename=path.join(__dirname,"..","src",filename);ret=nodeFS["readFileSync"](filename)}if(ret&&!binary)ret=ret.toString();return ret};Module["readBinary"]=function readBinary(filename){var ret=Module["read"](filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};Module["load"]=function load(f){globalEval(read(f))};if(!Module["thisProgram"]){if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}else{Module["thisProgram"]="unknown-program"}}Module["arguments"]=process["argv"].slice(2);if(typeof module!=="undefined"){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}));Module["inspect"]=(function(){return"[Emscripten Module object]"})}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=read}else{Module["read"]=function read(){throw"no read() available (jsc?)"}}Module["readBinary"]=function readBinary(f){if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}var data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};Module["readAsync"]=function readAsync(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response)}else{onerror()}};xhr.onerror=onerror;xhr.send(null)};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function printErr(x){console.warn(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(ENVIRONMENT_IS_WORKER){Module["load"]=importScripts}if(typeof Module["setWindowTitle"]==="undefined"){Module["setWindowTitle"]=(function(title){document.title=title})}}else{throw"Unknown runtime environment. Where are we?"}function globalEval(x){abort("NO_DYNAMIC_EXECUTION=1 was set, cannot eval")}if(!Module["load"]&&Module["read"]){Module["load"]=function load(f){globalEval(Module["read"](f))}}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}if(!Module["thisProgram"]){Module["thisProgram"]="./this.program"}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(var key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}moduleOverrides=undefined;var Runtime={setTempRet0:(function(value){tempRet0=value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),STACK_ALIGN:16,prepVararg:(function(ptr,type){if(type==="double"||type==="i64"){if(ptr&7){assert((ptr&7)===4);ptr+=4}}else{assert((ptr&3)===0)}return ptr}),getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),dynCall:(function(sig,ptr,args){if(args&&args.length){if(!args.splice)args=Array.prototype.slice.call(args);args.splice(0,0,ptr);return Module["dynCall_"+sig].apply(null,args)}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){assert(sig);if(!Runtime.funcWrappers[sig]){Runtime.funcWrappers[sig]={}}var sigCache=Runtime.funcWrappers[sig];if(!sigCache[func]){sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,arguments)}}return sigCache[func]}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+15&-16;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+15&-16;return ret}),dynamicAlloc:(function(size){var ret=DYNAMICTOP;DYNAMICTOP=DYNAMICTOP+size|0;DYNAMICTOP=DYNAMICTOP+15&-16;if(DYNAMICTOP>=TOTAL_MEMORY){var success=enlargeMemory();if(!success){DYNAMICTOP=ret;return 0}}return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:16))*(quantum?quantum:16);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module["Runtime"]=Runtime;var ABORT=false;var EXITSTATUS=0;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}function getCFunc(ident){var func=Module["_"+ident];if(!func){abort("NO_DYNAMIC_EXECUTION=1 was set, cannot eval")}assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)");return func}var cwrap,ccall;((function(){var JSfuncs={"stackSave":(function(){Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore()}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){ret=Runtime.stackAlloc((str.length<<2)+1);writeStringToMemory(str,ret)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};ccall=function ccallFunc(ident,returnType,argTypes,args,opts){var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0){if(opts&&opts.async){EmterpreterAsync.asyncFinalizers.push((function(){Runtime.stackRestore(stack)}));return}Runtime.stackRestore(stack)}return ret};cwrap=function cwrap(ident,returnType,argTypes){return(function(){return ccall(ident,returnType,argTypes,arguments)})}}))();Module["ccall"]=ccall;Module["cwrap"]=cwrap;function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}Module["setValue"]=setValue;function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for setValue: "+type)}return null}Module["getValue"]=getValue;var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;Module["ALLOC_NORMAL"]=ALLOC_NORMAL;Module["ALLOC_STACK"]=ALLOC_STACK;Module["ALLOC_STATIC"]=ALLOC_STATIC;Module["ALLOC_DYNAMIC"]=ALLOC_DYNAMIC;Module["ALLOC_NONE"]=ALLOC_NONE;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[typeof _malloc==="function"?_malloc:Runtime.staticAlloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var ptr=ret,stop;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}Module["allocate"]=allocate;function getMemory(size){if(!staticSealed)return Runtime.staticAlloc(size);if(typeof _sbrk!=="undefined"&&!_sbrk.called||!runtimeInitialized)return Runtime.dynamicAlloc(size);return _malloc(size)}Module["getMemory"]=getMemory;function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return Module["UTF8ToString"](ptr)}Module["Pointer_stringify"]=Pointer_stringify;function AsciiToString(ptr){var str="";while(1){var ch=HEAP8[ptr++>>0];if(!ch)return str;str+=String.fromCharCode(ch)}}Module["AsciiToString"]=AsciiToString;function stringToAscii(str,outPtr){return writeAsciiToMemory(str,outPtr,false)}Module["stringToAscii"]=stringToAscii;function UTF8ArrayToString(u8Array,idx){var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}Module["UTF8ArrayToString"]=UTF8ArrayToString;function UTF8ToString(ptr){return UTF8ArrayToString(HEAPU8,ptr)}Module["UTF8ToString"]=UTF8ToString;function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}Module["stringToUTF8Array"]=stringToUTF8Array;function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}Module["stringToUTF8"]=stringToUTF8;function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}Module["lengthBytesUTF8"]=lengthBytesUTF8;function demangle(func){var hasLibcxxabi=!!Module["___cxa_demangle"];if(hasLibcxxabi){try{var buf=_malloc(func.length);writeStringToMemory(func.substr(1),buf);var status=_malloc(4);var ret=Module["___cxa_demangle"](buf,0,0,status);if(getValue(status,"i32")===0&&ret){return Pointer_stringify(ret)}}catch(e){return func}finally{if(buf)_free(buf);if(status)_free(status);if(ret)_free(ret)}}Runtime.warnOnce("warning: build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling");return func}function demangleAll(text){return text.replace(/__Z[\w\d_]+/g,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){return demangleAll(jsStackTrace())}Module["stackTrace"]=stackTrace;function alignMemoryPage(x){if(x%4096>0){x+=4096-x%4096}return x}var HEAP;var buffer;var HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;function updateGlobalBufferViews(){Module["HEAP8"]=HEAP8=new Int8Array(buffer);Module["HEAP16"]=HEAP16=new Int16Array(buffer);Module["HEAP32"]=HEAP32=new Int32Array(buffer);Module["HEAPU8"]=HEAPU8=new Uint8Array(buffer);Module["HEAPU16"]=HEAPU16=new Uint16Array(buffer);Module["HEAPU32"]=HEAPU32=new Uint32Array(buffer);Module["HEAPF32"]=HEAPF32=new Float32Array(buffer);Module["HEAPF64"]=HEAPF64=new Float64Array(buffer)}var STATIC_BASE=0,STATICTOP=0,staticSealed=false;var STACK_BASE=0,STACKTOP=0,STACK_MAX=0;var DYNAMIC_BASE=0,DYNAMICTOP=0;function abortOnCannotGrowMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value "+TOTAL_MEMORY+", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which adjusts the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ")}function enlargeMemory(){abortOnCannotGrowMemory()}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||67108864;var totalMemory=64*1024;while(totalMemory<TOTAL_MEMORY||totalMemory<2*TOTAL_STACK){if(totalMemory<16*1024*1024){totalMemory*=2}else{totalMemory+=16*1024*1024}}if(totalMemory!==TOTAL_MEMORY){TOTAL_MEMORY=totalMemory}if(Module["buffer"]){buffer=Module["buffer"]}else{buffer=new ArrayBuffer(TOTAL_MEMORY)}updateGlobalBufferViews();HEAP32[0]=255;if(HEAPU8[0]!==255||HEAPU8[3]!==0)throw"Typed arrays 2 must be run on a little-endian system";Module["HEAP"]=HEAP;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Runtime.dynCall("v",func)}else{Runtime.dynCall("vi",func,[callback.arg])}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}Module["addOnPreRun"]=addOnPreRun;function addOnInit(cb){__ATINIT__.unshift(cb)}Module["addOnInit"]=addOnInit;function addOnPreMain(cb){__ATMAIN__.unshift(cb)}Module["addOnPreMain"]=addOnPreMain;function addOnExit(cb){__ATEXIT__.unshift(cb)}Module["addOnExit"]=addOnExit;function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}Module["addOnPostRun"]=addOnPostRun;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}Module["intArrayFromString"]=intArrayFromString;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}Module["intArrayToString"]=intArrayToString;function writeStringToMemory(string,buffer,dontAddNull){var array=intArrayFromString(string,dontAddNull);var i=0;while(i<array.length){var chr=array[i];HEAP8[buffer+i>>0]=chr;i=i+1}}Module["writeStringToMemory"]=writeStringToMemory;function writeArrayToMemory(array,buffer){for(var i=0;i<array.length;i++){HEAP8[buffer++>>0]=array[i]}}Module["writeArrayToMemory"]=writeArrayToMemory;function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}Module["writeAsciiToMemory"]=writeAsciiToMemory;if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];if(!Math["clz32"])Math["clz32"]=(function(x){x=x>>>0;for(var i=0;i<32;i++){if(x&1<<31-i)return i}return 32});Math.clz32=Math["clz32"];if(!Math["trunc"])Math["trunc"]=(function(x){return x<0?Math.ceil(x):Math.floor(x)});Math.trunc=Math["trunc"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_min=Math.min;var Math_clz32=Math.clz32;var Math_trunc=Math.trunc;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}Module["addRunDependency"]=addRunDependency;function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["removeRunDependency"]=removeRunDependency;Module["preloadedImages"]={};Module["preloadedAudios"]={};var ASM_CONSTS=[(function($0,$1,$2,$3,$4,$5,$6,$7){{var self=Module["getCache"](Module["ConcreteContactResultCallback"])[$0];if(!self.hasOwnProperty("addSingleResult"))throw"a JSImplementation must implement all functions, you forgot ConcreteContactResultCallback::addSingleResult.";return self["addSingleResult"]($1,$2,$3,$4,$5,$6,$7)}})];function _emscripten_asm_const_diiiiiiii(code,a0,a1,a2,a3,a4,a5,a6,a7){return ASM_CONSTS[code](a0,a1,a2,a3,a4,a5,a6,a7)}STATIC_BASE=8;STATICTOP=STATIC_BASE+23344;__ATINIT__.push({func:(function(){__GLOBAL__sub_I_btConeTwistConstraint_cpp()})},{func:(function(){__GLOBAL__sub_I_btQuickprof_cpp()})});allocate([36,32,0,0,209,32,0,0,76,32,0,0,183,32,0,0,8,0,0,0,0,0,0,0,76,32,0,0,168,32,0,0,16,0,0,0,0,0,0,0,36,32,0,0,20,33,0,0,76,32,0,0,251,32,0,0,48,0,0,0,0,0,0,0,76,32,0,0,233,32,0,0,56,0,0,0,0,0,0,0,36,32,0,0,48,33,0,0,36,32,0,0,71,33,0,0,76,32,0,0,90,33,0,0,8,0,0,0,0,0,0,0,76,32,0,0,109,33,0,0,96,0,0,0,0,0,0,0,76,32,0,0,130,33,0,0,96,0,0,0,0,0,0,0,76,32,0,0,152,33,0,0,96,0,0,0,0,0,0,0,36,32,0,0,175,33,0,0,36,32,0,0,190,33,0,0,76,32,0,0,214,33,0,0,56,0,0,0,0,0,0,0,76,32,0,0,245,33,0,0,216,0,0,0,0,0,0,0,36,32,0,0,118,34,0,0,76,32,0,0,138,34,0,0,216,0,0,0,0,0,0,0,36,32,0,0,248,34,0,0,76,32,0,0,100,35,0,0,88,0,0,0,0,0,0,0,76,32,0,0,133,35,0,0,248,0,0,0,0,0,0,0,76,32,0,0,162,35,0,0,40,1,0,0,0,0,0,0,36,32,0,0,181,35,0,0,76,32,0,0,220,35,0,0,168,0,0,0,0,0,0,0,76,32,0,0,244,35,0,0,216,0,0,0,0,0,0,0,36,32,0,0,14,36,0,0,36,32,0,0,61,36,0,0,136,32,0,0,54,37,0,0,0,0,0,0,2,0,0,0,96,6,0,0,2,0,0,0,104,6,0,0,2,4,0,0,76,32,0,0,74,37,0,0,144,1,0,0,0,0,0,0,76,32,0,0,96,37,0,0,160,1,0,0,0,0,0,0,36,32,0,0,122,37,0,0,36,32,0,0,149,37,0,0,76,32,0,0,178,37,0,0,64,7,0,0,0,0,0,0,76,32,0,0,69,38,0,0,64,7,0,0,0,0,0,0,76,32,0,0,218,38,0,0,96,0,0,0,0,0,0,0,76,32,0,0,88,39,0,0,240,1,0,0,0,0,0,0,36,32,0,0,221,39,0,0,76,32,0,0,65,40,0,0,80,7,0,0,0,0,0,0,76,32,0,0,240,40,0,0,80,7,0,0,0,0,0,0,76,32,0,0,181,41,0,0,40,2,0,0,0,0,0,0,36,32,0,0,82,42,0,0,76,32,0,0,141,42,0,0,144,1,0,0,0,0,0,0,76,32,0,0,165,42,0,0,160,1,0,0,0,0,0,0,76,32,0,0,191,42,0,0,64,4,0,0,0,0,0,0,76,32,0,0,217,42,0,0,248,0,0,0,0,0,0,0,76,32,0,0,248,42,0,0,96,0,0,0,0,0,0,0,76,32,0,0,17,43,0,0,96,2,0,0,0,0,0,0,76,32,0,0,56,43,0,0,96,0,0,0,0,0,0,0,36,32,0,0,89,43,0,0,76,32,0,0,122,43,0,0,248,0,0,0,0,0,0,0,76,32,0,0,158,43,0,0,96,6,0,0,0,0,0,0,76,32,0,0,185,43,0,0,24,6,0,0,0,0,0,0,76,32,0,0,238,43,0,0,96,6,0,0,0,0,0,0,76,32,0,0,140,44,0,0,160,2,0,0,0,0,0,0,76,32,0,0,180,44,0,0,248,0,0,0,0,0,0,0,76,32,0,0,206,44,0,0,24,3,0,0,0,0,0,0,36,32,0,0,83,45,0,0,76,32,0,0,131,45,0,0,24,3,0,0,0,0,0,0,76,32,0,0,16,46,0,0,64,4,0,0,0,0,0,0,76,32,0,0,43,46,0,0,88,0,0,0,0,0,0,0,76,32,0,0,77,46,0,0,96,3,0,0,0,0,0,0,36,32,0,0,111,46,0,0,76,32,0,0,138,46,0,0,160,2,0,0,0,0,0,0,76,32,0,0,188,46,0,0,160,2,0,0,0,0,0,0,76,32,0,0,245,46,0,0,160,2,0,0,0,0,0,0,76,32,0,0,34,47,0,0,160,2,0,0,0,0,0,0,76,32,0,0,87,47,0,0,160,2,0,0,0,0,0,0,76,32,0,0,139,47,0,0,160,2,0,0,0,0,0,0,76,32,0,0,172,47,0,0,160,2,0,0,0,0,0,0,76,32,0,0,221,47,0,0,160,2,0,0,0,0,0,0,76,32,0,0,16,48,0,0,160,2,0,0,0,0,0,0,76,32,0,0,59,48,0,0,160,2,0,0,0,0,0,0,76,32,0,0,107,48,0,0,88,0,0,0,0,0,0,0,76,32,0,0,126,48,0,0,80,1,0,0,0,0,0,0,76,32,0,0,142,48,0,0,24,4,0,0,0,0,0,0,36,32,0,0,169,48,0,0,76,32,0,0,195,48,0,0,24,3,0,0,0,0,0,0,36,32,0,0,214,48,0,0,76,32,0,0,29,49,0,0,248,0,0,0,0,0,0,0,76,32,0,0,64,49,0,0,248,0,0,0,0,0,0,0,76,32,0,0,101,49,0,0,40,1,0,0,0,0,0,0,76,32,0,0,126,49,0,0,24,6,0,0,0,0,0,0,76,32,0,0,143,49,0,0,144,6,0,0,0,0,0,0,76,32,0,0,208,49,0,0,176,0,0,0,0,0,0,0,76,32,0,0,62,50,0,0,176,0,0,0,0,0,0,0,76,32,0,0,166,50,0,0,176,0,0,0,0,0,0,0,76,32,0,0,23,51,0,0,112,5,0,0,0,0,0,0,76,32,0,0,72,51,0,0,216,4,0,0,0,0,0,0,76,32,0,0,99,51,0,0,216,4,0,0,0,0,0,0,36,32,0,0,126,51,0,0,76,32,0,0,166,51,0,0,8,5,0,0,0,0,0,0,76,32,0,0,238,51,0,0,8,5,0,0,0,0,0,0,76,32,0,0,255,51,0,0,112,5,0,0,0,0,0,0,76,32,0,0,34,52,0,0,48,5,0,0,0,0,0,0,76,32,0,0,55,52,0,0,48,5,0,0,0,0,0,0,76,32,0,0,76,52,0,0,40,6,0,0,0,0,0,0,76,32,0,0,125,52,0,0,136,5,0,0,0,0,0,0,36,32,0,0,149,52,0,0,76,32,0,0,170,52,0,0,8,5,0,0,0,0,0,0,76,32,0,0,186,52,0,0,40,6,0,0,0,0,0,0,76,32,0,0,228,52,0,0,104,6,0,0,0,0,0,0,76,32,0,0,1,53,0,0,112,5,0,0,0,0,0,0,76,32,0,0,49,53,0,0,184,5,0,0,0,0,0,0,76,32,0,0,78,53,0,0,184,5,0,0,0,0,0,0,76,32,0,0,107,53,0,0,240,0,0,0,0,0,0,0,76,32,0,0,124,53,0,0,104,6,0,0,0,0,0,0,76,32,0,0,224,53,0,0,104,6,0,0,0,0,0,0,76,32,0,0,59,54,0,0,112,5,0,0,0,0,0,0,76,32,0,0,85,54,0,0,24,6,0,0,0,0,0,0,76,32,0,0,122,54,0,0,112,5,0,0,0,0,0,0,76,32,0,0,145,54,0,0,32,5,0,0,0,0,0,0,36,32,0,0,201,54,0,0,36,32,0,0,99,55,0,0,36,32,0,0,120,55,0,0,76,32,0,0,154,55,0,0,88,6,0,0,0,0,0,0,76,32,0,0,183,55,0,0,112,6,0,0,0,0,0,0,76,32,0,0,200,55,0,0,32,5,0,0,0,0,0,0,76,32,0,0,235,55,0,0,104,6,0,0,0,0,0,0,76,32,0,0,81,56,0,0,96,6,0,0,0,0,0,0,76,32,0,0,105,56,0,0,224,6,0,0,0,0,0,0,76,32,0,0,135,56,0,0,24,3,0,0,0,0,0,0,36,32,0,0,154,56,0,0,76,32,0,0,169,56,0,0,224,6,0,0,0,0,0,0,76,32,0,0,187,56,0,0,8,7,0,0,0,0,0,0,36,32,0,0,220,56,0,0,76,32,0,0,253,56,0,0,40,1,0,0,0,0,0,0,76,32,0,0,17,57,0,0,8,7,0,0,0,0,0,0,76,32,0,0,53,57,0,0,24,3,0,0,0,0,0,0,76,32,0,0,224,57,0,0,96,6,0,0,0,0,0,0,76,32,0,0,252,57,0,0,96,6,0,0,0,0,0,0,76,32,0,0,27,58,0,0,224,6,0,0,0,0,0,0,76,32,0,0,52,58,0,0,128,7,0,0,0,0,0,0,76,32,0,0,85,58,0,0,144,7,0,0,0,0,0,0,36,32,0,0,118,58,0,0,76,32,0,0,138,58,0,0,168,7,0,0,0,0,0,0,76,32,0,0,184,58,0,0,40,2,0,0,0,0,0,0,76,32,0,0,234,58,0,0,200,7,0,0,0,0,0,0,136,32,0,0,2,59,0,0,0,0,0,0,1,0,0,0,224,7,0,0,2,4,0,0,36,32,0,0,22,59,0,0,76,32,0,0,99,59,0,0,200,7,0,0,0,0,0,0,76,32,0,0,153,59,0,0,200,7,0,0,0,0,0,0,76,32,0,0,186,59,0,0,232,7,0,0,0,0,0,0,76,32,0,0,252,59,0,0,200,7,0,0,0,0,0,0,76,32,0,0,43,60,0,0,200,7,0,0,0,0,0,0,76,32,0,0,102,60,0,0,72,8,0,0,0,0,0,0,36,32,0,0,140,60,0,0,76,32,0,0,235,60,0,0,200,7,0,0,0,0,0,0,76,32,0,0,50,61,0,0,112,8,0,0,0,0,0,0,76,32,0,0,76,61,0,0,88,1,0,0,0,0,0,0,76,32,0,0,239,61,0,0,168,7,0,0,0,0,0,0,76,32,0,0,212,62,0,0,160,8,0,0,0,0,0,0,36,32,0,0,242,62,0,0,76,32,0,0,32,63,0,0,80,1,0,0,0,0,0,0,76,32,0,0,111,63,0,0,144,7,0,0,0,0,0,0,76,32,0,0,130,63,0,0,216,8,0,0,0,0,0,0,36,32,0,0,158,63,0,0,76,32,0,0,179,63,0,0,240,1,0,0,0,0,0,0,76,32,0,0,250,63,0,0,0,9,0,0,0,0,0,0,36,32,0,0,26,64,0,0,76,32,0,0,110,65,0,0,24,9,0,0,0,0,0,0,36,32,0,0,133,65,0,0,76,32,0,0,149,65,0,0,48,0,0,0,0,0,0,0,36,32,0,0,50,76,0,0,76,32,0,0,16,76,0,0,88,9,0,0,0,0,0,0,76,32,0,0,189,75,0,0,56,9,0,0,0,0,0,0,76,32,0,0,226,75,0,0,104,9,0,0,0,0,0,0,36,32,0,0,3,76,0,0,76,32,0,0,248,76,0,0,48,9,0,0,0,0,0,0,76,32,0,0,56,77,0,0,88,9,0,0,0,0,0,0,76,32,0,0,20,77,0,0,128,9,0,0,0,0,0,0,76,32,0,0,90,77,0,0,56,9,0,0,0,0,0,0,0,0,0,0,32,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,0,0,0,0,16,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,0,0,0,0,72,0,0,0,5,0,0,0,6,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,4,0,0,0,6,0,0,0,5,0,0,0,3,0,0,0,6,0,0,0,2,0,0,0,7,0,0,0,4,0,0,0,5,0,0,0,0,0,0,0,104,0,0,0,7,0,0,0,8,0,0,0,2,0,0,0,7,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,4,0,0,0,6,0,0,0,8,0,0,0,9,0,0,0,8,0,0,0,7,0,0,0,9,0,0,0,0,0,0,0,120,0,0,0,10,0,0,0,11,0,0,0,9,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,136,0,0,0,10,0,0,0,12,0,0,0,10,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,152,0,0,0,10,0,0,0,13,0,0,0,10,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,184,0,0,0,14,0,0,0,15,0,0,0,3,0,0,0,2,0,0,0,11,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,12,0,0,0,13,0,0,0,13,0,0,0,11,0,0,0,14,0,0,0,4,0,0,0,14,0,0,0,12,0,0,0,13,0,0,0,0,0,0,0,200,0,0,0,16,0,0,0,17,0,0,0,3,0,0,0,0,0,0,0,224,0,0,0,16,0,0,0,18,0,0,0,4,0,0,0,0,0,0,0,240,0,0,0,19,0,0,0,20,0,0,0,3,0,0,0,15,0,0,0,5,0,0,0,14,0,0,0,15,0,0,0,0,0,0,0,8,1,0,0,21,0,0,0,22,0,0,0,3,0,0,0,1,0,0,0,16,0,0,0,0,0,0,0,24,1,0,0,23,0,0,0,24,0,0,0,4,0,0,0,0,0,0,0,48,1,0,0,25,0,0,0,26,0,0,0,4,0,0,0,6,0,0,0,17,0,0,0,18,0,0,0,7,0,0,0,8,0,0,0,5,0,0,0,16,0,0,0,5,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,6,0,0,0,19,0,0,0,0,0,0,0,64,1,0,0,16,0,0,0,27,0,0,0,7,0,0,0,0,0,0,0,80,1,0,0,28,0,0,0,29,0,0,0,20,0,0,0,8,0,0,0,20,0,0,0,9,0,0,0,21,0,0,0,0,0,0,0,88,1,0,0,30,0,0,0,31,0,0,0,32,0,0,0,33,0,0,0,22,0,0,0,21,0,0,0,34,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,23,0,0,0,35,0,0,0,24,0,0,0,0,0,0,0,96,1,0,0,36,0,0,0,37,0,0,0,9,0,0,0,10,0,0,0,252,255,255,255,96,1,0,0,38,0,0,0,39,0,0,0,11,0,0,0,0,0,0,0,128,1,0,0,40,0,0,0,41,0,0,0,9,0,0,0,0,0,0,0,168,1,0,0,1,0,0,0,25,0,0,0,15,0,0,0,42,0,0,0,43,0,0,0,0,0,0,0,176,1,0,0,44,0,0,0,45,0,0,0,12,0,0,0,1,0,0,0,0,0,0,0,192,1,0,0,44,0,0,0,46,0,0,0,12,0,0,0,2,0,0,0,0,0,0,0,208,1,0,0,10,0,0,0,47,0,0,0,10,0,0,0,26,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,224,1,0,0,48,0,0,0,49,0,0,0,10,0,0,0,1,0,0,0,0,0,0,0,248,1,0,0,44,0,0,0,50,0,0,0,13,0,0,0,1,0,0,0,0,0,0,0,8,2,0,0,44,0,0,0,51,0,0,0,13,0,0,0,2,0,0,0,0,0,0,0,24,2,0,0,52,0,0,0,53,0,0,0,11,0,0,0,2,0,0,0,0,0,0,0,48,2,0,0,40,0,0,0,54,0,0,0,12,0,0,0,0,0,0,0,64,2,0,0,40,0,0,0,55,0,0,0,13,0,0,0,0,0,0,0,80,2,0,0,56,0,0,0,57,0,0,0,16,0,0,0,17,0,0,0,1,0,0,0,0,0,0,0,96,2,0,0,58,0,0,0,59,0,0,0,5,0,0,0,2,0,0,0,27,0,0,0,0,0,0,0,112,2,0,0,10,0,0,0,60,0,0,0,10,0,0,0,28,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,128,2,0,0,61,0,0,0,62,0,0,0,6,0,0,0,3,0,0,0,29,0,0,0,0,0,0,0,144,2,0,0,10,0,0,0,63,0,0,0,18,0,0,0,30,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,168,2,0,0,64,0,0,0,65,0,0,0,7,0,0,0,4,0,0,0,31,0,0,0,0,0,0,0,184,2,0,0,66,0,0,0,67,0,0,0,14,0,0,0,0,0,0,0,200,2,0,0,68,0,0,0,69,0,0,0,15,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,32,0,0,0,22,0,0,0,1,0,0,0,23,0,0,0,33,0,0,0,2,0,0,0,2,0,0,0,24,0,0,0,10,0,0,0,34,0,0,0,20,0,0,0,21,0,0,0,1,0,0,0,16,0,0,0,17,0,0,0,25,0,0,0,22,0,0,0,14,0,0,0,26,0,0,0,27,0,0,0,18,0,0,0,23,0,0,0,28,0,0,0,19,0,0,0,1,0,0,0,20,0,0,0,0,0,0,0,216,2,0,0,44,0,0,0,70,0,0,0,21,0,0,0,0,0,0,0,232,2,0,0,71,0,0,0,72,0,0,0,5,0,0,0,0,0,0,0,248,2,0,0,73,0,0,0,74,0,0,0,8,0,0,0,5,0,0,0,35,0,0,0,0,0,0,0,8,3,0,0,56,0,0,0,75,0,0,0,24,0,0,0,25,0,0,0,2,0,0,0,0,0,0,0,32,3,0,0,56,0,0,0,76,0,0,0,26,0,0,0,27,0,0,0,3,0,0,0,0,0,0,0,48,3,0,0,56,0,0,0,77,0,0,0,16,0,0,0,17,0,0,0,4,0,0,0,0,0,0,0,64,3,0,0,78,0,0,0,79,0,0,0,9,0,0,0,6,0,0,0,36,0,0,0,0,0,0,0,80,3,0,0,80,0,0,0,81,0,0,0,29,0,0,0,30,0,0,0,11,0,0,0,31,0,0,0,0,0,0,0,104,3,0,0,82,0,0,0,83,0,0,0,6,0,0,0,0,0,0,0,120,3,0,0,82,0,0,0,84,0,0,0,7,0,0,0,0,0,0,0,136,3,0,0,82,0,0,0,85,0,0,0,8,0,0,0,0,0,0,0,152,3,0,0,82,0,0,0,86,0,0,0,9,0,0,0,0,0,0,0,168,3,0,0,82,0,0,0,87,0,0,0,10,0,0,0,0,0,0,0,184,3,0,0,82,0,0,0,88,0,0,0,11,0,0,0,0,0,0,0,200,3,0,0,82,0,0,0,89,0,0,0,12,0,0,0,0,0,0,0,216,3,0,0,82,0,0,0,90,0,0,0,13,0,0,0,0,0,0,0,232,3,0,0,82,0,0,0,91,0,0,0,14,0,0,0,0,0,0,0,248,3,0,0,82,0,0,0,92,0,0,0,15,0,0,0,0,0,0,0,8,4,0,0,93,0,0,0,94,0,0,0,10,0,0,0,7,0,0,0,37,0,0,0,0,0,0,0,24,4,0,0,95,0,0,0,96,0,0,0,20,0,0,0,8,0,0,0,20,0,0,0,9,0,0,0,21,0,0,0,28,0,0,0,22,0,0,0,0,0,0,0,40,4,0,0,97,0,0,0,98,0,0,0,20,0,0,0,8,0,0,0,20,0,0,0,9,0,0,0,21,0,0,0,29,0,0,0,23,0,0,0,0,0,0,0,56,4,0,0,99,0,0,0,100,0,0,0,12,0,0,0,13,0,0,0,32,0,0,0,0,0,0,0,64,4,0,0,56,0,0,0,101,0,0,0,16,0,0,0,17,0,0,0,5,0,0,0,0,0,0,0,80,4,0,0,102,0,0,0,103,0,0,0,30,0,0,0,38,0,0,0,0,0,0,0,88,4,0,0,104,0,0,0,105,0,0,0,11,0,0,0,8,0,0,0,39,0,0,0,0,0,0,0,104,4,0,0,106,0,0,0,107,0,0,0,12,0,0,0,9,0,0,0,40,0,0,0,0,0,0,0,120,4,0,0,23,0,0,0,108,0,0,0,13,0,0,0,0,0,0,0,136,4,0,0,68,0,0,0,109,0,0,0,24,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,41,0,0,0,22,0,0,0,2,0,0,0,33,0,0,0,33,0,0,0,3,0,0,0,2,0,0,0,24,0,0,0,10,0,0,0,34,0,0,0,31,0,0,0,32,0,0,0,1,0,0,0,25,0,0,0,17,0,0,0,34,0,0,0,33,0,0,0,14,0,0,0,35,0,0,0,36,0,0,0,26,0,0,0,34,0,0,0,37,0,0,0,27,0,0,0,2,0,0,0,35,0,0,0,0,0,0,0,152,4,0,0,110,0,0,0,111,0,0,0,28,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,42,0,0,0,38,0,0,0,3,0,0,0,39,0,0,0,33,0,0,0,4,0,0,0,3,0,0,0,40,0,0,0,14,0,0,0,34,0,0,0,29,0,0,0,36,0,0,0,37,0,0,0,43,0,0,0,44,0,0,0,0,0,0,0,168,4,0,0,112,0,0,0,113,0,0,0,38,0,0,0,0,0,0,0,184,4,0,0,112,0,0,0,114,0,0,0,39,0,0,0,0,0,0,0,200,4,0,0,112,0,0,0,115,0,0,0,40,0,0,0,0,0,0,0,216,4,0,0,116,0,0,0,117,0,0,0,30,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,45,0,0,0,22,0,0,0,4,0,0,0,41,0,0,0,46,0,0,0,5,0,0,0,2,0,0,0,42,0,0,0,15,0,0,0,34,0,0,0,20,0,0,0,41,0,0,0,1,0,0,0,31,0,0,0,17,0,0,0,43,0,0,0,42,0,0,0,0,0,0,0,232,4,0,0,116,0,0,0,118,0,0,0,30,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,45,0,0,0,22,0,0,0,4,0,0,0,44,0,0,0,46,0,0,0,5,0,0,0,2,0,0,0,42,0,0,0,15,0,0,0,34,0,0,0,20,0,0,0,41,0,0,0,1,0,0,0,31,0,0,0,17,0,0,0,43,0,0,0,42,0,0,0,0,0,0,0,248,4,0,0,116,0,0,0,119,0,0,0,30,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,45,0,0,0,22,0,0,0,4,0,0,0,45,0,0,0,46,0,0,0,5,0,0,0,2,0,0,0,42,0,0,0,15,0,0,0,34,0,0,0,20,0,0,0,41,0,0,0,1,0,0,0,31,0,0,0,17,0,0,0,43,0,0,0,42,0,0,0,0,0,0,0,16,5,0,0,120,0,0,0,121,0,0,0,32,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,47,0,0,0,46,0,0,0,5,0,0,0,47,0,0,0,33,0,0,0,6,0,0,0,4,0,0,0,48,0,0,0,16,0,0,0,34,0,0,0,48,0,0,0,122,0,0,0,0,0,0,0,48,5,0,0,116,0,0,0,123,0,0,0,33,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,49,0,0,0,22,0,0,0,6,0,0,0,49,0,0,0,50,0,0,0,2,0,0,0,2,0,0,0,50,0,0,0,17,0,0,0,34,0,0,0,43,0,0,0,44,0,0,0,1,0,0,0,34,0,0,0,17,0,0,0,43,0,0,0,42,0,0,0,0,0,0,0,64,5,0,0,116,0,0,0,124,0,0,0,33,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,49,0,0,0,22,0,0,0,6,0,0,0,51,0,0,0,51,0,0,0,2,0,0,0,2,0,0,0,50,0,0,0,17,0,0,0,34,0,0,0,43,0,0,0,44,0,0,0,1,0,0,0,34,0,0,0,17,0,0,0,43,0,0,0,42,0,0,0,0,0,0,0,80,5,0,0,116,0,0,0,125,0,0,0,33,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,49,0,0,0,22,0,0,0,6,0,0,0,52,0,0,0,52,0,0,0,2,0,0,0,2,0,0,0,50,0,0,0,17,0,0,0,34,0,0,0,43,0,0,0,44,0,0,0,1,0,0,0,34,0,0,0,17,0,0,0,43,0,0,0,42,0,0,0,0,0,0,0,96,5,0,0,126,0,0,0,127,0,0,0,35,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,53,0,0,0,22,0,0,0,7,0,0,0,53,0,0,0,33,0,0,0,2,0,0,0,2,0,0,0,54,0,0,0,18,0,0,0,34,0,0,0,45,0,0,0,46,0,0,0,2,0,0,0,36,0,0,0,17,0,0,0,43,0,0,0,42,0,0,0,14,0,0,0,55,0,0,0,56,0,0,0,37,0,0,0,47,0,0,0,57,0,0,0,38,0,0,0,3,0,0,0,0,0,0,0,128,5,0,0,128,0,0,0,129,0,0,0,0,0,0,0,152,5,0,0,68,0,0,0,130,0,0,0,35,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,54,0,0,0,58,0,0,0,7,0,0,0,59,0,0,0,33,0,0,0,2,0,0,0,2,0,0,0,24,0,0,0,10,0,0,0,34,0,0,0,48,0,0,0,49,0,0,0,1,0,0,0,39,0,0,0,17,0,0,0,43,0,0,0,42,0,0,0,14,0,0,0,60,0,0,0,61,0,0,0,40,0,0,0,50,0,0,0,62,0,0,0,41,0,0,0,4,0,0,0,0,0,0,0,168,5,0,0,131,0,0,0,132,0,0,0,42,0,0,0,0,0,0,0,184,5,0,0,116,0,0,0,133,0,0,0,43,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,55,0,0,0,22,0,0,0,8,0,0,0,63,0,0,0,56,0,0,0,7,0,0,0,2,0,0,0,64,0,0,0,19,0,0,0,34,0,0,0,51,0,0,0,52,0,0,0,1,0,0,0,44,0,0,0,17,0,0,0,43,0,0,0,42,0,0,0,5,0,0,0,0,0,0,0,200,5,0,0,116,0,0,0,134,0,0,0,43,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,55,0,0,0,22,0,0,0,8,0,0,0,65,0,0,0,56,0,0,0,7,0,0,0,2,0,0,0,64,0,0,0,19,0,0,0,34,0,0,0,51,0,0,0,53,0,0,0,1,0,0,0,45,0,0,0,17,0,0,0,43,0,0,0,42,0,0,0,6,0,0,0,0,0,0,0,216,5,0,0,116,0,0,0,135,0,0,0,43,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,55,0,0,0,22,0,0,0,8,0,0,0,66,0,0,0,56,0,0,0,7,0,0,0,2,0,0,0,64,0,0,0,19,0,0,0,34,0,0,0,51,0,0,0,54,0,0,0,1,0,0,0,46,0,0,0,17,0,0,0,43,0,0,0,42,0,0,0,7,0,0,0,0,0,0,0,232,5,0,0,136,0,0,0,137,0,0,0,3,0,0,0,15,0,0,0,5,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,0,0,0,0,248,5,0,0,131,0,0,0,138,0,0,0,47,0,0,0,0,0,0,0,8,6,0,0,131,0,0,0,139,0,0,0,48,0,0,0,0,0,0,0,24,6,0,0,68,0,0,0,140,0,0,0,33,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,32,0,0,0,22,0,0,0,7,0,0,0,1,0,0,0,33,0,0,0,2,0,0,0,2,0,0,0,24,0,0,0,10,0,0,0,34,0,0,0,20,0,0,0,55,0,0,0,1,0,0,0,49,0,0,0,17,0,0,0,43,0,0,0,42,0,0,0,14,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,56,6,0,0,116,0,0,0,141,0,0,0,50,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,32,0,0,0,22,0,0,0,9,0,0,0,67,0,0,0,33,0,0,0,8,0,0,0,8,0,0,0,24,0,0,0,10,0,0,0,34,0,0,0,56,0,0,0,57,0,0,0,1,0,0,0,51,0,0,0,17,0,0,0,43,0,0,0,42,0,0,0,0,0,0,0,72,6,0,0,142,0,0,0,143,0,0,0,52,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,57,0,0,0,68,0,0,0,10,0,0,0,69,0,0,0,33,0,0,0,4,0,0,0,3,0,0,0,70,0,0,0,20,0,0,0,34,0,0,0,53,0,0,0,0,0,0,0,112,6,0,0,144,0,0,0,145,0,0,0,54,0,0,0,1,0,0,0,2,0,0,0,58,0,0,0,59,0,0,0,71,0,0,0,60,0,0,0,61,0,0,0,72,0,0,0,58,0,0,0,59,0,0,0,73,0,0,0,21,0,0,0,0,0,0,0,128,6,0,0,146,0,0,0,147,0,0,0,54,0,0,0,1,0,0,0,2,0,0,0,58,0,0,0,59,0,0,0,71,0,0,0,62,0,0,0,63,0,0,0,72,0,0,0,58,0,0,0,59,0,0,0,73,0,0,0,21,0,0,0,0,0,0,0,144,6,0,0,148,0,0,0,149,0,0,0,28,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,64,0,0,0,38,0,0,0,3,0,0,0,74,0,0,0,33,0,0,0,4,0,0,0,3,0,0,0,75,0,0,0,22,0,0,0,34,0,0,0,55,0,0,0,36,0,0,0,37,0,0,0,0,0,0,0,160,6,0,0,131,0,0,0,150,0,0,0,56,0,0,0,0,0,0,0,176,6,0,0,44,0,0,0,151,0,0,0,57,0,0,0,0,0,0,0,192,6,0,0,152,0,0,0,153,0,0,0,1,0,0,0,0,0,0,0,208,6,0,0,56,0,0,0,154,0,0,0,60,0,0,0,61,0,0,0,6,0,0,0,0,0,0,0,232,6,0,0,152,0,0,0,155,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,248,6,0,0,156,0,0,0,157,0,0,0,1,0,0,0,0,0,0,0,16,7,0,0,23,0,0,0,158,0,0,0,14,0,0,0,0,0,0,0,32,7,0,0,156,0,0,0,159,0,0,0,2,0,0,0,0,0,0,0,48,7,0,0,56,0,0,0,160,0,0,0,62,0,0,0,63,0,0,0,7,0,0,0,10,215,163,60,0,0,0,0,80,7,0,0,44,0,0,0,161,0,0,0,13,0,0,0,1,0,0,0,0,0,0,0,96,7,0,0,152,0,0,0,162,0,0,0,3,0,0,0,0,0,0,0,112,7,0,0,163,0,0,0,164,0,0,0,2,0,0,0,65,0,0,0,66,0,0,0,3,0,0,0,67,0,0,0,68,0,0,0,69,0,0,0,4,0,0,0,76,0,0,0,165,0,0,0,77,0,0,0,70,0,0,0,0,0,0,0,152,7,0,0,52,0,0,0,166,0,0,0,15,0,0,0,3,0,0,0,0,0,0,0,184,7,0,0,167,0,0,0,168,0,0,0,169,0,0,0,1,0,0,0,71,0,0,0,72,0,0,0,8,0,0,0,1,0,0,0,4,0,0,0,78,0,0,0,23,0,0,0,64,0,0,0,0,0,0,0,200,7,0,0,167,0,0,0,170,0,0,0,171,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,79,0,0,0,24,0,0,0,0,0,0,0,232,7,0,0,167,0,0,0,172,0,0,0,173,0,0,0,1,0,0,0,73,0,0,0,74,0,0,0,9,0,0,0,2,0,0,0,5,0,0,0,80,0,0,0,25,0,0,0,174,0,0,0,81,0,0,0,0,0,0,0,248,7,0,0,167,0,0,0,175,0,0,0,176,0,0,0,1,0,0,0,75,0,0,0,76,0,0,0,9,0,0,0,3,0,0,0,6,0,0,0,82,0,0,0,26,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,8,8,0,0,167,0,0,0,177,0,0,0,173,0,0,0,1,0,0,0,73,0,0,0,77,0,0,0,9,0,0,0,2,0,0,0,5,0,0,0,83,0,0,0,27,0,0,0,174,0,0,0,81,0,0,0,65,0,0,0,0,0,0,0,24,8,0,0,167,0,0,0,178,0,0,0,179,0,0,0,1,0,0,0,78,0,0,0,79,0,0,0,9,0,0,0,4,0,0,0,7,0,0,0,84,0,0,0,28,0,0,0,85,0,0,0,0,0,0,0,40,8,0,0,167,0,0,0,180,0,0,0,181,0,0,0,1,0,0,0,80,0,0,0,81,0,0,0,9,0,0,0,5,0,0,0,8,0,0,0,86,0,0,0,29,0,0,0,87,0,0,0,0,0,0,0,56,8,0,0,182,0,0,0,183,0,0,0,66,0,0,0,1,0,0,0,67,0,0,0,184,0,0,0,88,0,0,0,58,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,80,8,0,0,167,0,0,0,185,0,0,0,171,0,0,0,1,0,0,0,82,0,0,0,83,0,0,0,9,0,0,0,6,0,0,0,9,0,0,0,89,0,0,0,30,0,0,0,90,0,0,0,0,0,0,0,96,8,0,0,186,0,0,0,187,0,0,0,32,0,0,0,33,0,0,0,22,0,0,0,21,0,0,0,188,0,0,0,6,0,0,0,7,0,0,0,59,0,0,0,84,0,0,0,35,0,0,0,85,0,0,0,1,0,0,0,68,0,0,0,86,0,0,0,87,0,0,0,88,0,0,0,89,0,0,0,90,0,0,0,189,0,0,0,91,0,0,0,60,0,0,0,92,0,0,0,93,0,0,0,91,0,0,0,92,0,0,0,16,0,0,0,17,0,0,0,93,0,0,0,190,0,0,0,94,0,0,0,95,0,0,0,96,0,0,0,97,0,0,0,9,0,0,0,10,0,0,0,191,0,0,0,98,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,99,0,0,0,192,0,0,0,100,0,0,0,14,0,0,0,0,0,0,0,168,7,0,0,52,0,0,0,193,0,0,0,15,0,0,0,10,0,0,0,0,0,0,0,128,8,0,0,52,0,0,0,194,0,0,0,18,0,0,0,11,0,0,0,0,0,0,0,144,8,0,0,195,0,0,0,196,0,0,0,3,0,0,0,0,0,0,0,168,8,0,0,197,0,0,0,198,0,0,0,20,0,0,0,8,0,0,0,94,0,0,0,31,0,0,0,101,0,0,0,0,0,0,0,184,8,0,0,199,0,0,0,200,0,0,0,5,0,0,0,102,0,0,0,15,0,0,0,16,0,0,0,61,0,0,0,0,0,0,0,200,8,0,0,201,0,0,0,202,0,0,0,17,0,0,0,0,0,0,0,224,8,0,0,48,0,0,0,203,0,0,0,19,0,0,0,12,0,0,0,28,88,0,0,0,0,0,0,240,8,0,0,204,0,0,0,205,0,0,0,20,0,0,0,1,0,0,0,0,0,0,0,8,9,0,0,206,0,0,0,207,0,0,0,103,0,0,0,104,0,0,0,0,0,0,0,32,9,0,0,208,0,0,0,209,0,0,0,32,0,0,0,18,0,0,0,69,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,0,0,0,34,0,0,0,41,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,56,9,0,0,210,0,0,0,211,0,0,0,212,0,0,0,213,0,0,0,35,0,0,0,4,0,0,0,15,0,0,0,62,0,0,0,0,0,0,0,72,9,0,0,210,0,0,0,214,0,0,0,212,0,0,0,213,0,0,0,35,0,0,0,5,0,0,0,16,0,0,0,63,0,0,0,0,0,0,0,112,9,0,0,215,0,0,0,216,0,0,0,96,0,0,0,0,0,0,0,160,9,0,0,210,0,0,0,217,0,0,0,212,0,0,0,213,0,0,0,35,0,0,0,6,0,0,0,17,0,0,0,64,0,0,0,49,50,98,116,65,120,105,115,83,119,101,101,112,51,0,50,48,98,116,65,120,105,115,83,119,101,101,112,51,73,110,116,101,114,110,97,108,73,116,69,0,50,49,98,116,66,114,111,97,100,112,104,97,115,101,73,110,116,101,114,102,97,99,101,0,49,53,98,116,78,117,108,108,80,97,105,114,67,97,99,104,101,0,50,50,98,116,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,0,50,53,98,116,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,108,108,98,97,99,107,0,50,48,98,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,78,54,98,116,68,98,118,116,56,73,67,111,108,108,105,100,101,69,0,49,54,98,116,68,98,118,116,66,114,111,97,100,112,104,97,115,101,0,49,56,98,116,68,98,118,116,84,114,101,101,67,111,108,108,105,100,101,114,0,49,57,66,114,111,97,100,112,104,97,115,101,82,97,121,84,101,115,116,101,114,0,50,48,66,114,111,97,100,112,104,97,115,101,65,97,98,98,84,101,115,116,101,114,0,49,50,98,116,68,105,115,112,97,116,99,104,101,114,0,50,49,98,116,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,0,90,78,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,51,55,114,101,109,111,118,101,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,115,67,111,110,116,97,105,110,105,110,103,80,114,111,120,121,69,80,49,55,98,116,66,114,111,97,100,112,104,97,115,101,80,114,111,120,121,80,49,50,98,116,68,105,115,112,97,116,99,104,101,114,69,49,56,82,101,109,111,118,101,80,97,105,114,67,97,108,108,98,97,99,107,0,49,55,98,116,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,90,78,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,49,57,99,108,101,97,110,80,114,111,120,121,70,114,111,109,80,97,105,114,115,69,80,49,55,98,116,66,114,111,97,100,112,104,97,115,101,80,114,111,120,121,80,49,50,98,116,68,105,115,112,97,116,99,104,101,114,69,49,55,67,108,101,97,110,80,97,105,114,67,97,108,108,98,97,99,107,0,49,52,98,116,81,117,97,110,116,105,122,101,100,66,118,104,0,98,116,79,112,116,105,109,105,122,101,100,66,118,104,78,111,100,101,68,97,116,97,0,98,116,81,117,97,110,116,105,122,101,100,66,118,104,78,111,100,101,68,97,116,97,0,98,116,66,118,104,83,117,98,116,114,101,101,73,110,102,111,68,97,116,97,0,98,116,81,117,97,110,116,105,122,101,100,66,118,104,70,108,111,97,116,68,97,116,97,0,51,48,98,116,65,99,116,105,118,97,116,105,110,103,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,50,54,98,116,66,111,120,66,111,120,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,49,54,98,116,66,111,120,66,111,120,68,101,116,101,99,116,111,114,0,51,54,98,116,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,111,114,73,110,116,101,114,102,97,99,101,0,50,49,98,116,67,111,108,108,105,115,105,111,110,68,105,115,112,97,116,99,104,101,114,0,50,51,98,116,67,111,108,108,105,115,105,111,110,80,97,105,114,67,97,108,108,98,97,99,107,0,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,0,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,70,108,111,97,116,68,97,116,97,0,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,0,117,112,100,97,116,101,65,97,98,98,115,0,1,79,118,101,114,102,108,111,119,32,105,110,32,65,65,66,66,44,32,111,98,106,101,99,116,32,114,101,109,111,118,101,100,32,102,114,111,109,32,115,105,109,117,108,97,116,105,111,110,0,73,102,32,121,111,117,32,99,97,110,32,114,101,112,114,111,100,117,99,101,32,116,104,105,115,44,32,112,108,101,97,115,101,32,101,109,97,105,108,32,98,117,103,115,64,99,111,110,116,105,110,117,111,117,115,112,104,121,115,105,99,115,46,99,111,109,10,0,80,108,101,97,115,101,32,105,110,99,108,117,100,101,32,97,98,111,118,101,32,105,110,102,111,114,109,97,116,105,111,110,44,32,121,111,117,114,32,80,108,97,116,102,111,114,109,44,32,118,101,114,115,105,111,110,32,111,102,32,79,83,46,10,0,84,104,97,110,107,115,46,10,0,99,97,108,99,117,108,97,116,101,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,115,0,49,55,68,101,98,117,103,68,114,97,119,99,97,108,108,98,97,99,107,0,49,57,98,116,83,105,110,103,108,101,82,97,121,67,97,108,108,98,97,99,107,0,50,51,98,116,66,114,111,97,100,112,104,97,115,101,82,97,121,67,97,108,108,98,97,99,107,0,50,52,98,116,66,114,111,97,100,112,104,97,115,101,65,97,98,98,67,97,108,108,98,97,99,107,0,78,49,50,98,116,67,111,110,118,101,120,67,97,115,116,49,48,67,97,115,116,82,101,115,117,108,116,69,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,50,57,66,114,105,100,103,101,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,50,57,66,114,105,100,103,101,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,95,48,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,57,82,97,121,84,101,115,116,101,114,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,49,53,76,111,99,97,108,73,110,102,111,65,100,100,101,114,50,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,112,101,114],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE);allocate([102,111,114,109,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,105,111,110,0,100,105,115,112,97,116,99,104,65,108,108,67,111,108,108,105,115,105,111,110,80,97,105,114,115,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,51,50,66,114,105,100,103,101,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,51,50,66,114,105,100,103,101,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,95,48,0,99,111,110,118,101,120,83,119,101,101,112,67,111,109,112,111,117,110,100,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,49,52,76,111,99,97,108,73,110,102,111,65,100,100,101,114,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,99,111,110,118,101,120,83,119,101,101,112,84,101,115,116,0,50,49,98,116,83,105,110,103,108,101,83,119,101,101,112,67,97,108,108,98,97,99,107,0,50,51,98,116,83,105,110,103,108,101,67,111,110,116,97,99,116,67,97,108,108,98,97,99,107,0,50,51,98,116,66,114,105,100,103,101,100,77,97,110,105,102,111,108,100,82,101,115,117,108,116,0,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,50,50,98,116,67,111,109,112,111,117,110,100,76,101,97,102,67,97,108,108,98,97,99,107,0,51,54,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,51,48,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,76,101,97,102,67,97,108,108,98,97,99,107,0,51,48,98,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,67,114,101,97,116,101,70,117,110,99,0,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,50,52,98,116,67,111,110,118,101,120,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,49,53,98,116,84,114,105,97,110,103,108,101,83,104,97,112,101,0,84,114,105,97,110,103,108,101,0,98,116,67,111,110,118,101,120,73,110,116,101,114,110,97,108,83,104,97,112,101,68,97,116,97,0,90,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,50,49,99,97,108,99,117,108,97,116,101,84,105,109,101,79,102,73,109,112,97,99,116,69,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,83,49,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,51,49,76,111,99,97,108,84,114,105,97,110,103,108,101,83,112,104,101,114,101,67,97,115,116,67,97,108,108,98,97,99,107,0,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,0,90,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,54,112,114,111,99,101,115,115,67,111,108,108,105,115,105,111,110,69,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,83,50,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,49,51,98,116,68,117,109,109,121,82,101,115,117,108,116,0,78,51,54,98,116,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,111,114,73,110,116,101,114,102,97,99,101,54,82,101,115,117,108,116,69,0,90,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,54,112,114,111,99,101,115,115,67,111,108,108,105,115,105,111,110,69,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,83,50,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,50,49,98,116,87,105,116,104,111,117,116,77,97,114,103,105,110,82,101,115,117,108,116,0,50,52,98,116,80,101,114,116,117,114,98,101,100,67,111,110,116,97,99,116,82,101,115,117,108,116,0,51,49,98,116,67,111,110,118,101,120,80,108,97,110,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,51,49,98,116,68,101,102,97,117,108,116,67,111,108,108,105,115,105,111,110,67,111,110,102,105,103,117,114,97,116,105,111,110,0,50,52,98,116,67,111,108,108,105,115,105,111,110,67,111,110,102,105,103,117,114,97,116,105,111,110,0,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,55,83,119,97,112,112,101,100,67,114,101,97,116,101,70,117,110,99,69,0,78,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,51,54,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,55,83,119,97,112,112,101,100,67,114,101,97,116,101,70,117,110,99,69,0,78,49,54,98,116,69,109,112,116,121,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,51,50,98,116,83,112,104,101,114,101,83,112,104,101,114,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,51,52,98,116,83,112,104,101,114,101,84,114,105,97,110,103,108,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,50,54,98,116,66,111,120,66,111,120,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,51,49,98,116,67,111,110,118,101,120,80,108,97,110,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,49,54,98,116,69,109,112,116,121,65,108,103,111,114,105,116,104,109,0,49,51,98,116,71,104,111,115,116,79,98,106,101,99,116,0,50,52,98,116,80,97,105,114,67,97,99,104,105,110,103,71,104,111,115,116,79,98,106,101,99,116,0,50,51,98,116,72,97,115,104,101,100,83,105,109,112,108,101,80,97,105,114,67,97,99,104,101,0,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,0,50,53,98,116,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,77,97,110,97,103,101,114,0,105,115,108,97,110,100,85,110,105,111,110,70,105,110,100,65,110,100,81,117,105,99,107,83,111,114,116,0,112,114,111,99,101,115,115,73,115,108,97,110,100,115,0,51,50,98,116,83,112,104,101,114,101,83,112,104,101,114,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,51,52,98,116,83,112,104,101,114,101,84,114,105,97,110,103,108,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,50,50,83,112,104,101,114,101,84,114,105,97,110,103,108,101,68,101,116,101,99,116,111,114,0,49,48,98,116,66,111,120,83,104,97,112,101,0,66,111,120,0,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,66,86,72,84,82,73,65,78,71,76,69,77,69,83,72,0,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,68,97,116,97,0,90,78,75,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,57,112,114,111,99,101,115,115,65,108,108,84,114,105,97,110,103,108,101,115,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,90,78,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,52,112,101,114,102,111,114,109,82,97,121,99,97,115,116,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,90,78,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,55,112,101,114,102,111,114,109,67,111,110,118,101,120,99,97,115,116,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,83,52,95,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,49,52,98,116,67,97,112,115,117,108,101,83,104,97,112,101,0,67,97,112,115,117,108,101,83,104,97,112,101,0,98,116,67,97,112,115,117,108,101,83,104,97,112,101,68,97,116,97,0,49,53,98,116,67,97,112,115,117,108,101,83,104,97,112,101,88,0,67,97,112,115,117,108,101,88,0,49,53,98,116,67,97,112,115,117,108,101,83,104,97,112,101,90,0,67,97,112,115,117,108,101,90,0,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,0,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,68,97,116,97,0,49,53,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,0,67,111,109,112,111,117,110,100,0,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,67,104,105,108,100,68,97,116,97,0,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,68,97,116,97,0,49,52,98,116,67,111,110,99,97,118,101,83,104,97,112,101,0,49,49,98,116,67,111,110,101,83,104,97,112,101,0,67,111,110,101,0,98,116,67,111,110,101,83,104,97,112,101,68,97,116,97,0,49,50,98,116,67,111,110,101,83,104,97,112,101,90,0,67,111,110,101,90,0,49,50,98,116,67,111,110,101,83,104,97,112,101,88,0,67,111,110,101,88,0,49,55,98,116,67,111,110,118,101,120,72,117,108,108,83,104,97,112,101,0,67,111,110,118,101,120,0,98,116,67,111,110,118,101,120,72,117,108,108,83,104,97,112,101,68,97,116,97,0,50,49,98,116,67,111,110,118,101,120,73,110,116,101,114,110,97,108,83,104,97,112,101,0,49,56,98,116,67,111,110,118,101,120,80,111,108,121,104,101,100,114,111,110,0,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,0,50,53,98,116,67,111,110,118,101,120,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,67,111,110,118,101,120,84,114,105,109,101,115,104,0,50,54,76,111,99,97,108,83,117,112,112,111,114,116,86,101,114,116,101,120,67,97,108,108,98,97,99,107,0,49,53,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,0,67,121,108,105,110,100,101,114,89,0,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,68,97,116,97,0,49,54,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,88,0,67,121,108,105,110,100,101,114,88,0,49,54,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,90,0,67,121,108,105,110,100,101,114,90,0,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,0,90,78,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,53,98,117,105,108,100,69,80,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,98,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,57,81,117,97,110,116,105,122,101,100,78,111,100,101,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,90,78,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,53,98,117,105,108,100,69,80,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,98,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,48,78,111,100,101,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,50,51,98,116,80,111,108,121,104,101,100,114,97,108,67,111,110,118,101,120,83,104,97,112,101,0,51,52,98,116,80,111,108,121,104,101,100,114,97,108,67,111,110,118,101,120,65,97,98,98,67,97,99,104,105,110,103,83,104,97,112,101,0,49,51,98,116,83,112,104,101,114,101,83,104,97,112,101,0,83,80,72,69,82,69,0,49,56,98,116,83,116,97,116,105,99,80,108,97,110,101,83,104,97,112,101,0,83,84,65,84,73,67,80,76,65,78,69,0,98,116,83,116,97,116,105,99,80,108,97,110,101,83,104,97,112,101,68,97,116,97,0,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,0,98,116,73,110,116,73,110,100,101,120,68,97,116,97,0,98,116,83,104,111,114,116,73,110,116,73,110,100,101,120,84,114,105,112,108,101,116,68,97,116,97,0,98,116,67,104,97,114,73,110,100,101,120,84,114,105,112,108,101,116,68,97,116,97,0,98,116,86,101,99,116,111,114,51,68,111,117,98,108,101,68,97,116,97,0,98,116,77,101,115,104,80,97,114,116,68,97,116,97,0,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,68,97,116,97,0,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,51,49,98,116,73,110,116,101,114,110,97,108,84,114,105,97,110,103,108,101,73,110,100,101,120,67,97,108,108,98,97,99,107,0,50,54,98,116,84,114,105,97,110,103,108,101,73,110,100,101,120,86,101,114,116,101,120,65,114,114,97,121,0,49,52,98,116,84,114,105,97,110,103,108,101,77,101,115,104,0,49,57,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,84,82,73,65,78,71,76,69,77,69,83,72,0,90,78,75,49,57,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,57,112,114,111,99,101,115,115,65,108,108,84,114,105,97,110,103,108,101,115,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,49,54,70,105,108,116,101,114,101,100,67,97,108,108,98,97,99,107,0,50,49,83,117,112,112,111,114,116,86,101,114,116,101,120,67,97,108,108,98,97,99,107,0,50,55,98,116,67,111,110,116,105,110,117,111,117,115,67,111,110,118,101,120,67,111,108,108,105,115,105,111,110,0,49,54,98,116,80,111,105,110,116,67,111,108,108,101,99,116,111,114,0,49,50,98,116,67,111,110,118,101,120,67,97,115,116,0,49,53,98,116,71,106,107,67,111,110,118,101,120,67,97,115,116,0,51,48,98,116,71,106,107,69,112,97,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,51,48,98,116,67,111,110,118,101,120,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,49,55,98,116,71,106,107,80,97,105,114,68,101,116,101,99,116,111,114,0,51,51,98,116,77,105,110,107,111,119,115,107,105,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,90,78,51,51,98,116,77,105,110,107,111,119,115,107,105,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,49,50,99,97,108,99,80,101,110,68,101,112,116,104,69,82,50,50,98,116,86,111,114,111,110,111,105,83,105,109,112,108,101,120,83,111,108,118,101,114,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,83,52,95,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,55,95,82,57,98,116,86,101,99,116,111,114,51,83,57,95,83,57,95,80,49,50,98,116,73,68,101,98,117,103,68,114,97,119,69,50,48,98,116,73,110,116,101,114,109,101,100,105,97,116,101,82,101,115,117,108,116,0,50,53,98,116,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,0,50,56,98,116,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,0,50,50,98,116,83,117,98,115,105,109,112,108,101,120,67,111,110,118,101,120,67,97,115,116,0,51,48,98,116,75,105,110,101,109,97,116,105,99,67,104,97,114,97,99,116,101,114,67,111,110,116,114,111,108,108,101,114,0,51,48,98,116,67,104,97,114,97,99,116,101,114,67,111,110,116,114,111,108,108,101,114,73,110,116,101,114,102,97,99,101,0,49,55,98,116,65,99,116,105,111,110,73,110,116,101,114,102,97,99,101,0,52,51,98,116,75,105,110,101,109,97,116,105,99,67,108,111,115,101,115,116,78,111,116,77,101,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,55,67,108,111,115,101,115,116,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,50,49,98,116,67,111,110,101,84,119,105,115,116,67,111,110,115,116,114,97,105,110,116,0,49,55,98,116,84,121,112,101,100,67,111,110,115,116,114,97,105,110,116,0,49,51,98,116,84,121,112,101,100,79,98,106,101,99,116,0,98,116,67,111,110,101,84,119,105,115,116,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,98,116,71,101,110,101,114,105,99,54,68,111,102,83,112,114,105,110,103,50,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,50,51,98,116,71,101,110,101,114,105,99,54,68,111,102,67,111,110,115,116,114,97,105,110,116,0,98,116,71,101,110,101,114,105,99,54,68,111,102,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,51,48,98,116,71,101,110,101,114,105,99,54,68,111,102,83,112,114,105,110,103,50,67,111,110,115,116,114,97,105,110,116,0,50,57,98,116,71,101,110,101,114,105,99,54,68,111,102,83,112,114,105,110,103,67,111,110,115,116,114,97,105,110,116,0,98,116,71,101,110,101,114,105,99,54,68,111,102,83,112,114,105,110,103,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,49,55,98,116,72,105,110,103,101,67,111,110,115,116,114,97,105,110,116,0,98,116,72,105,110,103,101,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,50,51,98,116,80,111,105,110,116,50,80,111,105,110,116,67,111,110,115,116,114,97,105,110,116,0,98,116,80,111,105,110,116,50,80,111,105,110,116,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,51,53,98,116,83,101,113,117,101,110,116,105,97,108,73,109,112,117,108,115,101,67,111,110,115,116,114,97,105,110,116,83,111,108,118,101,114,0,49,56,98,116,67,111,110,115,116,114,97,105,110,116,83,111,108,118,101,114,0,115,111,108,118,101,71,114,111,117,112,0,115,111,108,118,101,71,114,111,117,112,67,97,99,104,101,70,114,105,101,110,100,108,121,83,101,116,117,112,0,115,111,108,118,101,71,114,111,117,112,67,97,99,104,101,70,114,105,101,110,100,108,121,73,116,101,114,97,116,105,111,110,115,0,49,56,98,116,83,108,105,100,101,114,67,111,110,115,116,114,97,105,110,116,0,98,116,83,108,105,100,101,114,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,98,116,84,121,112,101,100,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,50,51,98,116,68,105,115,99,114,101,116,101,68,121,110,97,109,105,99,115,87,111,114,108,100,0,49,53,98,116,68,121,110,97,109,105,99,115,87,111,114,108,100,0,100,101,98,117,103,68,114,97,119,87,111,114,108,100,0,98,116,68,121,110,97,109,105,99,115,87,111,114,108,100,70,108,111,97,116,68,97,116,97,0,115,116,101,112,83,105,109,117,108,97,116,105,111,110,0,115,121,110,99,104,114,111,110,105,122,101,77,111,116,105,111,110,83,116,97,116,101,115,0,112,114,101,100,105,99,116,85,110,99,111,110,115,116,114,97,105,110,116,77,111,116,105,111,110,0,105,110,116,101,103,114,97,116,101,84,114,97,110,115,102,111,114,109,115,0,67,67,68,32,109,111,116,105,111,110,32,99,108,97,109,112,105,110,103,0,51,52,98,116,67,108,111,115,101,115,116,78,111,116,77,101,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,97,112,112,108,121,32,115,112,101,99,117,108,97,116,105,118,101,32,99,111,110,116,97,99,116,32,114,101,115,116,105,116,117,116,105,111,110,0,117,112,100,97,116,101,65,99,116,105,118,97,116,105,111,110,83,116,97,116,101,0,105,110,116,101,114,110,97,108,83,105,110,103,108,101,83,116,101,112,83,105,109,117,108,97,116,105,111,110,0,99,114,101,97,116,101,80,114,101,100,105,99,116,105,118,101,67,111,110,116,97,99,116,115,0,114,101,108,101,97,115,101,32,112,114,101,100,105,99,116,105,118,101,32,99,111,110,116,97,99,116,32,109,97,110,105,102,111,108,100,115,0,112,114,101,100,105,99,116,105,118,101,32,99,111,110,118,101,120,83,119,101,101,112,84,101,115,116,0,117,112,100,97,116,101,65,99,116,105,111,110,115,0,50,55,73,110,112,108,97,99,101,83,111,108,118,101,114,73,115,108,97,110,100,67,97,108,108,98,97,99,107,0,78,50,53,98,116,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,77,97,110,97,103,101,114,49,52,73,115,108,97,110,100,67,97,108,108,98,97,99,107,69,0,49,49,98,116,82,105,103,105,100,66,111,100,121,0,98,116,82,105,103,105,100,66,111,100,121,70,108,111,97,116,68,97,116,97,0,99,97,108,99,117,108,97,116,101,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,115,0,115,111,108,118,101,67,111,110,115,116,114,97,105,110,116,115,0,49,54,98,116,82,97,121,99,97,115,116,86,101,104,105,99,108,101,0,50,53,98,116,68,101,102,97,117,108,116,86,101,104,105,99,108,101,82,97,121,99,97,115,116,101,114,0,49,56,98,116,86,101,104,105,99,108,101,82,97,121,99,97,115,116,101,114,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,52,67,108,111,115,101,115,116,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,98,116,86,101,99,116,111,114,51,70,108,111,97,116,68,97,116,97,0,82,111,111,116,0,50,57,67,111,110,99,114,101,116,101,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,123,32,118,97,114,32,115,101,108,102,32,61,32,77,111,100,117,108,101,91,39,103,101,116,67,97,99,104,101,39,93,40,77,111,100,117,108,101,91,39,67,111,110,99,114,101,116,101,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,39,93,41,91,36,48,93,59,32,105,102,32,40,33,115,101,108,102,46,104,97,115,79,119,110,80,114,111,112,101,114,116,121,40,39,97,100,100,83,105,110,103,108,101,82,101,115,117,108,116,39,41,41,32,116,104,114,111,119,32,39,97,32,74,83,73,109,112,108,101,109,101,110,116,97,116,105,111,110,32,109,117,115,116,32,105,109,112,108,101,109,101,110,116,32,97,108,108,32,102,117,110,99,116,105,111,110,115,44,32,121,111,117,32,102,111,114,103,111,116,32,67,111,110,99,114,101,116,101,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,58,58,97,100,100,83,105,110,103,108,101,82,101,115,117,108,116,46,39,59,32,114,101,116,117,114,110,32,115,101,108,102,91,39,97,100,100,83,105,110,103,108,101,82,101,115,117,108,116,39,93,40,36,49,44,36,50,44,36,51,44,36,52,44,36,53,44,36,54,44,36,55,41,59,32,125,0,50,48,98,116,68,101,102,97,117,108,116,77,111,116,105,111,110,83,116,97,116,101,0,49,51,98,116,77,111,116,105,111,110,83,116,97,116,101,0,49,57,98,116,71,104,111,115,116,80,97,105,114,67,97,108,108,98,97,99,107,0,17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,45,43,32,32,32,48,88,48,120,0,84,33,34,25,13,1,2,3,17,75,28,12,16,4,11,29,18,30,39,104,110,111,112,113,98,32,5,6,15,19,20,21,26,8,22,7,40,36,23,24,9,10,14,27,31,37,35,131,130,125,38,42,43,60,61,62,63,67,71,74,77,88,89,90,91,92,93,94,95,96,97,99,100,101,102,103,105,106,107,108,114,115,116,121,122,123,124,0,73,108,108,101,103,97,108,32,98,121,116,101,32,115,101,113,117,101,110,99,101,0,68,111,109,97,105,110,32,101,114,114,111,114,0,82,101,115,117,108,116,32,110,111,116,32,114,101,112,114,101,115,101,110,116,97,98,108,101,0,78,111,116,32,97,32,116,116,121,0,80,101,114,109,105,115,115,105,111,110,32,100,101,110,105,101,100,0,79,112,101,114,97,116,105,111,110,32,110,111,116,32,112,101,114,109,105,116,116,101,100,0,78,111,32,115,117,99,104,32,102,105,108,101,32,111,114,32,100,105,114,101,99,116,111,114,121,0,78,111,32,115,117,99,104,32,112,114,111,99,101,115,115,0,70,105,108,101,32,101,120,105,115,116,115,0,86,97,108,117,101,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,100,97,116,97,32,116,121,112,101,0,78,111,32,115,112,97,99,101,32,108,101,102,116,32,111,110,32,100,101,118,105,99,101,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,82,101,115,111,117,114,99,101,32,98,117,115,121,0,73,110,116,101,114,114,117,112,116,101,100,32,115,121,115,116,101,109,32,99,97,108,108,0,82,101,115,111,117,114,99,101,32,116,101,109,112,111,114,97,114,105,108,121,32,117,110,97,118,97,105,108,97,98,108,101,0,73,110,118,97,108,105,100,32,115,101,101,107,0,67,114,111,115,115,45,100,101,118,105,99,101,32,108,105,110,107,0,82,101,97,100,45,111,110,108,121,32,102,105,108,101,32,115,121,115,116,101,109,0,68,105,114,101,99,116,111,114,121,32,110,111,116,32,101,109,112,116,121,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,112,101,101,114,0,79,112,101,114,97,116,105,111,110,32,116,105,109,101,100,32,111,117,116,0,67,111,110,110,101,99,116,105,111,110,32,114,101,102,117,115,101,100,0,72,111,115,116,32,105,115,32,100,111,119,110,0,72,111,115,116,32,105,115,32,117,110,114,101,97,99,104,97,98,108,101,0,65,100,100,114,101,115,115,32,105,110,32,117,115,101,0,66,114,111,107,101,110,32,112,105,112,101,0,73,47,79,32,101,114,114,111,114,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,32,111,114,32,97,100,100,114,101,115,115,0,66,108,111,99,107,32,100,101,118,105,99,101,32,114,101,113,117,105,114,101,100,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,0,78,111,116,32,97,32,100,105,114,101,99,116,111,114,121,0,73,115,32,97,32,100,105,114,101,99,116,111,114,121,0,84,101,120,116,32,102,105,108,101,32,98,117,115,121,0,69,120,101,99,32,102,111,114,109,97,116,32,101,114,114,111,114,0,73,110,118,97,108,105,100,32,97,114,103,117,109,101,110,116,0,65,114,103,117,109,101,110,116,32,108,105,115,116,32,116,111,111,32,108,111,110,103,0,83,121,109,98,111,108,105,99,32,108,105,110,107,32,108,111,111,112,0,70,105,108,101,110,97,109,101,32,116,111,111,32,108,111,110,103,0,84,111,111,32,109,97,110,121,32,111,112,101,110,32,102,105,108,101,115,32,105,110,32,115,121,115,116,101,109,0,78,111,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,115,32,97,118,97,105,108,97,98,108,101,0,66,97,100,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,0,78,111,32,99,104,105,108,100,32,112,114,111,99,101,115,115,0,66,97,100,32,97,100,100,114,101,115,115,0,70,105,108,101,32,116,111,111,32,108,97,114,103,101,0,84,111,111,32,109,97,110,121,32,108,105,110,107,115,0,78,111,32,108,111,99,107,115,32,97,118,97,105,108,97,98,108,101,0,82,101,115,111,117,114,99,101,32,100,101,97,100,108,111,99,107,32,119,111,117,108,100,32,111,99,99,117,114,0,83,116,97,116,101,32,110,111,116,32,114,101,99,111,118,101,114,97,98,108,101,0,80,114,101,118,105,111,117,115,32,111,119,110,101,114,32,100,105,101,100,0,79,112,101,114,97,116,105,111,110,32,99,97,110,99,101,108,101,100,0,70,117,110,99,116,105,111,110,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,78,111,32,109,101,115,115,97,103,101,32,111,102,32,100,101,115,105,114,101,100,32,116,121,112,101,0,73,100,101,110,116,105,102,105,101,114,32,114,101,109,111,118,101,100,0,68,101,118,105,99,101,32,110,111,116,32,97,32,115,116,114,101,97,109,0,78,111,32,100,97,116,97,32,97,118,97,105,108,97,98,108,101,0,68,101,118,105,99,101,32,116,105,109,101,111,117,116,0,79,117,116,32,111,102,32,115,116,114,101,97,109,115,32,114,101,115,111,117,114,99,101,115,0,76,105,110,107,32,104,97,115,32,98,101,101,110,32,115,101,118,101,114,101,100,0,80,114,111,116,111,99,111,108,32,101,114,114,111,114,0,66,97,100,32,109,101,115,115,97,103,101,0,70,105,108,101,32,100,101,115,99,114,105,112,116,111,114,32,105,110,32,98,97,100,32,115,116,97,116,101,0,78,111,116,32,97,32,115,111,99,107,101,116,0,68,101,115,116,105,110,97,116,105,111,110,32,97,100,100,114,101,115,115,32,114,101,113,117,105,114,101,100,0,77,101,115,115,97,103,101,32,116,111,111,32,108,97,114,103,101,0,80,114,111,116,111,99,111,108,32,119,114,111,110,103,32,116,121,112,101,32,102,111,114,32,115,111,99,107,101,116,0,80,114,111,116,111,99,111,108,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,80,114,111,116,111,99,111,108,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,83,111,99,107,101,116,32,116,121,112,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,78,111,116,32,115,117,112,112,111,114,116,101,100,0,80,114,111,116,111,99,111,108,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,65,100,100,114,101,115,115,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,112,114,111,116,111,99,111,108,0,65,100,100,114,101,115,115,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,78,101,116,119,111,114,107,32,105,115,32,100,111,119,110,0,78,101,116,119,111,114,107,32,117,110,114,101,97,99,104,97,98,108,101,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,110,101,116,119,111,114,107,0,67,111,110,110,101,99,116,105,111,110,32,97,98,111,114,116,101,100,0,78,111,32,98,117,102,102,101,114,32,115,112,97,99,101,32,97,118,97,105,108,97,98,108,101,0,83,111,99,107,101,116,32,105,115,32,99,111,110,110,101,99,116,101,100,0,83,111,99,107,101,116,32,110,111,116,32,99,111,110,110,101,99,116,101,100,0,67,97,110,110,111,116,32,115,101,110,100,32,97,102,116,101,114,32,115,111,99,107,101,116,32,115,104,117,116,100,111,119,110,0,79,112,101,114,97,116,105,111,110,32,97,108,114,101,97,100,121,32,105,110,32,112,114,111,103,114,101,115,115,0,79,112,101,114,97,116,105,111,110,32,105,110,32,112,114,111,103,114,101,115,115,0,83,116,97,108,101,32,102,105,108,101,32,104,97,110,100,108,101,0,82,101,109,111,116,101,32,73,47,79,32,101,114,114,111,114,0,81,117,111,116,97,32,101,120,99,101,101,100,101,100,0,78,111,32,109,101,100,105,117,109,32,102,111,117,110,100,0,87,114,111,110,103,32,109,101,100,105,117,109,32,116,121,112,101,0,78,111,32,101,114,114,111,114,32,105,110,102,111,114,109,97,116,105,111,110,0,0,40,110,117,108,108,41,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,0,105,110,102,0,73,78,70,0,110,97,110,0,78,65,78,0,46,0,99,97,110,110,111,116,32,122,101,114,111,32,111,117,116,32,116,104,114,101,97,100,32,118,97,108,117,101,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,112,116,104,114,101,97,100,32,107,101,121,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,112,116,104,114,101,97,100,95,111,110,99,101,32,102,97,105,108,117,114,101,32,105,110,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,95,102,97,115,116,40,41,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,83,116,57,116,121,112,101,95,105,110,102,111,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,83,116,57,101,120,99,101,112,116,105,111,110,0,117,110,99,97,117,103,104,116,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,58,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,102,111,114,101,105,103,110,32,101,120,99,101,112,116,105,111,110,0,116,101,114,109,105,110,97,116,105,110,103,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,114,101,116,117,114,110,101,100,0,83,116,57,98,97,100,95,97,108,108,111,99,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,57,95,95,112,111,105,110,116,101,114,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,112,98,97,115,101,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,49,95,95,118,109,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+10240);var tempDoublePtr=STATICTOP;STATICTOP+=16;Module["_i64Subtract"]=_i64Subtract;Module["_i64Add"]=_i64Add;function __ZSt18uncaught_exceptionv(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:(function(adjusted){if(!adjusted||EXCEPTIONS.infos[adjusted])return adjusted;for(var ptr in EXCEPTIONS.infos){var info=EXCEPTIONS.infos[ptr];if(info.adjusted===adjusted){return ptr}}return adjusted}),addRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount++}),decRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];assert(info.refcount>0);info.refcount--;if(info.refcount===0){if(info.destructor){Runtime.dynCall("vi",info.destructor,[ptr])}delete EXCEPTIONS.infos[ptr];___cxa_free_exception(ptr)}}),clearRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount=0})};function ___resumeException(ptr){if(!EXCEPTIONS.last){EXCEPTIONS.last=ptr}EXCEPTIONS.clearRef(EXCEPTIONS.deAdjust(ptr));throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function ___cxa_find_matching_catch(){var thrown=EXCEPTIONS.last;if(!thrown){return(asm["setTempRet0"](0),0)|0}var info=EXCEPTIONS.infos[thrown];var throwntype=info.type;if(!throwntype){return(asm["setTempRet0"](0),thrown)|0}var typeArray=Array.prototype.slice.call(arguments);var pointer=Module["___cxa_is_pointer_type"](throwntype);if(!___cxa_find_matching_catch.buffer)___cxa_find_matching_catch.buffer=_malloc(4);HEAP32[___cxa_find_matching_catch.buffer>>2]=thrown;thrown=___cxa_find_matching_catch.buffer;for(var i=0;i<typeArray.length;i++){if(typeArray[i]&&Module["___cxa_can_catch"](typeArray[i],throwntype,thrown)){thrown=HEAP32[thrown>>2];info.adjusted=thrown;return(asm["setTempRet0"](typeArray[i]),thrown)|0}}thrown=HEAP32[thrown>>2];return(asm["setTempRet0"](throwntype),thrown)|0}function ___cxa_throw(ptr,type,destructor){EXCEPTIONS.infos[ptr]={ptr:ptr,adjusted:ptr,type:type,destructor:destructor,refcount:0};EXCEPTIONS.last=ptr;if(!("uncaught_exception"in __ZSt18uncaught_exceptionv)){__ZSt18uncaught_exceptionv.uncaught_exception=1}else{__ZSt18uncaught_exceptionv.uncaught_exception++}throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}Module["_memset"]=_memset;function ___gxx_personality_v0(){}Module["_bitshift64Shl"]=_bitshift64Shl;function _abort(){Module["abort"]()}function _pthread_once(ptr,func){if(!_pthread_once.seen)_pthread_once.seen={};if(ptr in _pthread_once.seen)return;Runtime.dynCall("v",func);_pthread_once.seen[ptr]=1}var PTHREAD_SPECIFIC={};function _pthread_getspecific(key){return PTHREAD_SPECIFIC[key]||0}var PTHREAD_SPECIFIC_NEXT_KEY=1;var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};function _pthread_key_create(key,destructor){if(key==0){return ERRNO_CODES.EINVAL}HEAP32[key>>2]=PTHREAD_SPECIFIC_NEXT_KEY;PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY]=0;PTHREAD_SPECIFIC_NEXT_KEY++;return 0}var _llvm_pow_f32=Math_pow;function _pthread_setspecific(key,value){if(!(key in PTHREAD_SPECIFIC)){return ERRNO_CODES.EINVAL}PTHREAD_SPECIFIC[key]=value;return 0}function _malloc(bytes){var ptr=Runtime.dynamicAlloc(bytes+8);return ptr+8&4294967288}Module["_malloc"]=_malloc;function ___cxa_allocate_exception(size){return _malloc(size)}Module["_bitshift64Ashr"]=_bitshift64Ashr;Module["_bitshift64Lshr"]=_bitshift64Lshr;function ___cxa_pure_virtual(){ABORT=true;throw"Pure virtual function called!"}function _pthread_cleanup_push(routine,arg){__ATEXIT__.push((function(){Runtime.dynCall("vi",routine,[arg])}));_pthread_cleanup_push.level=__ATEXIT__.length}function _pthread_cleanup_pop(){assert(_pthread_cleanup_push.level==__ATEXIT__.length,"cannot pop if something else added meanwhile!");__ATEXIT__.pop();_pthread_cleanup_push.level=__ATEXIT__.length}function ___cxa_begin_catch(ptr){__ZSt18uncaught_exceptionv.uncaught_exception--;EXCEPTIONS.caught.push(ptr);EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));return ptr}function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}Module["_memcpy"]=_memcpy;var SYSCALLS={varargs:0,get:(function(varargs){SYSCALLS.varargs+=4;var ret=HEAP32[SYSCALLS.varargs-4>>2];return ret}),getStr:(function(){var ret=Pointer_stringify(SYSCALLS.get());return ret}),get64:(function(){var low=SYSCALLS.get(),high=SYSCALLS.get();if(low>=0)assert(high===0);else assert(high===-1);return low}),getZero:(function(){assert(SYSCALLS.get()===0)})};function ___syscall6(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD();FS.close(stream);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function _sbrk(bytes){var self=_sbrk;if(!self.called){DYNAMICTOP=alignMemoryPage(DYNAMICTOP);self.called=true;assert(Runtime.dynamicAlloc);self.alloc=Runtime.dynamicAlloc;Runtime.dynamicAlloc=(function(){abort("cannot dynamically allocate, sbrk now has control")})}var ret=DYNAMICTOP;if(bytes!=0){var success=self.alloc(bytes);if(!success)return-1>>>0}return ret}Module["_memmove"]=_memmove;function _gettimeofday(ptr){var now=Date.now();HEAP32[ptr>>2]=now/1e3|0;HEAP32[ptr+4>>2]=now%1e3*1e3|0;return 0}Module["_llvm_bswap_i32"]=_llvm_bswap_i32;function _llvm_trap(){abort("trap!")}Module["_pthread_self"]=_pthread_self;function ___syscall140(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),offset_high=SYSCALLS.get(),offset_low=SYSCALLS.get(),result=SYSCALLS.get(),whence=SYSCALLS.get();var offset=offset_low;assert(offset_high===0);FS.llseek(stream,offset,whence);HEAP32[result>>2]=stream.position;if(stream.getdents&&offset===0&&whence===0)stream.getdents=null;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall146(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.get(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();var ret=0;if(!___syscall146.buffer){___syscall146.buffers=[null,[],[]];___syscall146.printChar=(function(stream,curr){var buffer=___syscall146.buffers[stream];assert(buffer);if(curr===0||curr===10){(stream===1?Module["print"]:Module["printErr"])(UTF8ArrayToString(buffer,0));buffer.length=0}else{buffer.push(curr)}})}for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];for(var j=0;j<len;j++){___syscall146.printChar(stream,HEAPU8[ptr+j])}ret+=len}return ret}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}__ATEXIT__.push((function(){var fflush=Module["_fflush"];if(fflush)fflush(0);var printChar=___syscall146.printChar;if(!printChar)return;var buffers=___syscall146.buffers;if(buffers[1].length)printChar(1,10);if(buffers[2].length)printChar(2,10)}));STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);staticSealed=true;STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=DYNAMICTOP=Runtime.alignMemory(STACK_MAX);var cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_DYNAMIC);function invoke_viiiii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vid(index,a1,a2){try{Module["dynCall_vid"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vi(index,a1){try{Module["dynCall_vi"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiidii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiidii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vii(index,a1,a2){try{Module["dynCall_vii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{return Module["dynCall_iiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_ii(index,a1){try{return Module["dynCall_ii"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viidi(index,a1,a2,a3,a4){try{Module["dynCall_viidi"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viddiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viddiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidii(index,a1,a2,a3,a4){try{Module["dynCall_vidii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiii(index,a1,a2,a3,a4){try{return Module["dynCall_iiiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidi(index,a1,a2,a3){try{Module["dynCall_vidi"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8){try{return Module["dynCall_diiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiddddiid(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11){try{Module["dynCall_viiiiddddiid"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_diiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiid(index,a1,a2,a3){try{return Module["dynCall_iiid"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_di(index,a1){try{return Module["dynCall_di"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiidii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_diiidii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viidii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viidii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{Module["dynCall_viiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{Module["dynCall_viiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iii(index,a1,a2){try{return Module["dynCall_iii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diii(index,a1,a2,a3){try{return Module["dynCall_diii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{return Module["dynCall_diiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiid(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiid"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{return Module["dynCall_diiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_did(index,a1,a2){try{return Module["dynCall_did"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiidddddidi(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12){try{Module["dynCall_viiiidddddidi"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diidii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_diidii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiii(index,a1,a2,a3,a4){try{return Module["dynCall_diiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{return Module["dynCall_iiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiid(index,a1,a2,a3,a4){try{Module["dynCall_viiid"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viii(index,a1,a2,a3){try{Module["dynCall_viii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_v(index){try{Module["dynCall_v"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viid(index,a1,a2,a3){try{Module["dynCall_viid"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iidid(index,a1,a2,a3,a4){try{return Module["dynCall_iidid"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiii(index,a1,a2,a3,a4){try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity};Module.asmLibraryArg={"abort":abort,"assert":assert,"invoke_viiiii":invoke_viiiii,"invoke_vid":invoke_vid,"invoke_vi":invoke_vi,"invoke_viiidii":invoke_viiidii,"invoke_vii":invoke_vii,"invoke_iiiiiiiiiii":invoke_iiiiiiiiiii,"invoke_ii":invoke_ii,"invoke_viidi":invoke_viidi,"invoke_viddiii":invoke_viddiii,"invoke_vidii":invoke_vidii,"invoke_iiiii":invoke_iiiii,"invoke_vidi":invoke_vidi,"invoke_diiiiiiii":invoke_diiiiiiii,"invoke_viiiiddddiid":invoke_viiiiddddiid,"invoke_diiiii":invoke_diiiii,"invoke_iiii":invoke_iiii,"invoke_viiiiii":invoke_viiiiii,"invoke_iiid":invoke_iiid,"invoke_di":invoke_di,"invoke_iiiiiii":invoke_iiiiiii,"invoke_diiidii":invoke_diiidii,"invoke_viidii":invoke_viidii,"invoke_viiiiiii":invoke_viiiiiii,"invoke_viiiiiiiii":invoke_viiiiiiiii,"invoke_viiiiiiiiii":invoke_viiiiiiiiii,"invoke_iii":invoke_iii,"invoke_diii":invoke_diii,"invoke_diiiiiiiiii":invoke_diiiiiiiiii,"invoke_viiiid":invoke_viiiid,"invoke_diiiiiiiii":invoke_diiiiiiiii,"invoke_did":invoke_did,"invoke_viiiidddddidi":invoke_viiiidddddidi,"invoke_diidii":invoke_diidii,"invoke_diiii":invoke_diiii,"invoke_iiiiiiiiii":invoke_iiiiiiiiii,"invoke_viiid":invoke_viiid,"invoke_viii":invoke_viii,"invoke_v":invoke_v,"invoke_viid":invoke_viid,"invoke_iidid":invoke_iidid,"invoke_viiii":invoke_viiii,"_pthread_cleanup_pop":_pthread_cleanup_pop,"_abort":_abort,"___gxx_personality_v0":___gxx_personality_v0,"___cxa_allocate_exception":___cxa_allocate_exception,"__ZSt18uncaught_exceptionv":__ZSt18uncaught_exceptionv,"_sbrk":_sbrk,"_llvm_pow_f32":_llvm_pow_f32,"___cxa_begin_catch":___cxa_begin_catch,"_emscripten_memcpy_big":_emscripten_memcpy_big,"___resumeException":___resumeException,"___cxa_find_matching_catch":___cxa_find_matching_catch,"_pthread_getspecific":_pthread_getspecific,"_pthread_once":_pthread_once,"_llvm_trap":_llvm_trap,"_pthread_key_create":_pthread_key_create,"_emscripten_asm_const_diiiiiiii":_emscripten_asm_const_diiiiiiii,"_pthread_setspecific":_pthread_setspecific,"___cxa_throw":___cxa_throw,"___syscall6":___syscall6,"_pthread_cleanup_push":_pthread_cleanup_push,"_gettimeofday":_gettimeofday,"___syscall140":___syscall140,"___cxa_pure_virtual":___cxa_pure_virtual,"___syscall146":___syscall146,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"cttz_i8":cttz_i8};// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer) {
"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.cttz_i8|0;var n=0;var o=0;var p=0;var q=0;var r=global.NaN,s=global.Infinity;var t=0,u=0,v=0,w=0,x=0.0,y=0,z=0,A=0,B=0.0;var C=0;var D=0;var E=0;var F=0;var G=0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=global.Math.floor;var N=global.Math.abs;var O=global.Math.sqrt;var P=global.Math.pow;var Q=global.Math.cos;var R=global.Math.sin;var S=global.Math.tan;var T=global.Math.acos;var U=global.Math.asin;var V=global.Math.atan;var W=global.Math.atan2;var X=global.Math.exp;var Y=global.Math.log;var Z=global.Math.ceil;var _=global.Math.imul;var $=global.Math.min;var aa=global.Math.clz32;var ba=env.abort;var ca=env.assert;var da=env.invoke_viiiii;var ea=env.invoke_vid;var fa=env.invoke_vi;var ga=env.invoke_viiidii;var ha=env.invoke_vii;var ia=env.invoke_iiiiiiiiiii;var ja=env.invoke_ii;var ka=env.invoke_viidi;var la=env.invoke_viddiii;var ma=env.invoke_vidii;var na=env.invoke_iiiii;var oa=env.invoke_vidi;var pa=env.invoke_diiiiiiii;var qa=env.invoke_viiiiddddiid;var ra=env.invoke_diiiii;var sa=env.invoke_iiii;var ta=env.invoke_viiiiii;var ua=env.invoke_iiid;var va=env.invoke_di;var wa=env.invoke_iiiiiii;var xa=env.invoke_diiidii;var ya=env.invoke_viidii;var za=env.invoke_viiiiiii;var Aa=env.invoke_viiiiiiiii;var Ba=env.invoke_viiiiiiiiii;var Ca=env.invoke_iii;var Da=env.invoke_diii;var Ea=env.invoke_diiiiiiiiii;var Fa=env.invoke_viiiid;var Ga=env.invoke_diiiiiiiii;var Ha=env.invoke_did;var Ia=env.invoke_viiiidddddidi;var Ja=env.invoke_diidii;var Ka=env.invoke_diiii;var La=env.invoke_iiiiiiiiii;var Ma=env.invoke_viiid;var Na=env.invoke_viii;var Oa=env.invoke_v;var Pa=env.invoke_viid;var Qa=env.invoke_iidid;var Ra=env.invoke_viiii;var Sa=env._pthread_cleanup_pop;var Ta=env._abort;var Ua=env.___gxx_personality_v0;var Va=env.___cxa_allocate_exception;var Wa=env.__ZSt18uncaught_exceptionv;var Xa=env._sbrk;var Ya=env._llvm_pow_f32;var Za=env.___cxa_begin_catch;var _a=env._emscripten_memcpy_big;var $a=env.___resumeException;var ab=env.___cxa_find_matching_catch;var bb=env._pthread_getspecific;var cb=env._pthread_once;var db=env._llvm_trap;var eb=env._pthread_key_create;var fb=env._emscripten_asm_const_diiiiiiii;var gb=env._pthread_setspecific;var hb=env.___cxa_throw;var ib=env.___syscall6;var jb=env._pthread_cleanup_push;var kb=env._gettimeofday;var lb=env.___syscall140;var mb=env.___cxa_pure_virtual;var nb=env.___syscall146;var ob=0.0;
// EMSCRIPTEN_START_FUNCS
function Oy(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0;s=i;i=i+16|0;c[5637]=(c[5637]|0)+1;f=qG(1479)|0;if(!f)r=0;else{c[(f+4+15&-16)+-4>>2]=f;r=f+4+15&-16}if(!(a[19880]|0)){a[19880]=1;c[s>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;c[s+12>>2]=0;Cr(21260,0.0,0,0,s)}c[5366]=c[5366]|1;g[5407]=0.0;t=+g[5417]*0.0;u=+g[5418]*0.0;g[5412]=+g[5416]*0.0;g[5413]=t;g[5414]=u;g[5415]=0.0;c[5420]=0;c[5421]=0;c[5422]=0;c[5423]=0;u=+g[5409]*0.0;t=+g[5410]*0.0;g[5461]=+g[5408]*0.0;g[5462]=u;g[5463]=t;g[5464]=0.0;c[r+4>>2]=12;c[r+8>>2]=-1;c[r+12>>2]=-1;g[r+16>>2]=3402823466385288598117041.0e14;a[r+20>>0]=1;a[r+21>>0]=0;c[r+24>>2]=-1;l=r+28|0;c[l>>2]=21260;m=r+32|0;c[m>>2]=b;g[r+36>>2]=0.0;g[r+40>>2]=.30000001192092896;c[r+44>>2]=0;c[r>>2]=7300;n=r+112|0;c[n>>2]=c[d>>2];c[n+4>>2]=c[d+4>>2];c[n+8>>2]=c[d+8>>2];c[n+12>>2]=c[d+12>>2];o=r+128|0;c[o>>2]=c[d+16>>2];c[o+4>>2]=c[d+16+4>>2];c[o+8>>2]=c[d+16+8>>2];c[o+12>>2]=c[d+16+12>>2];p=r+144|0;c[p>>2]=c[d+32>>2];c[p+4>>2]=c[d+32+4>>2];c[p+8>>2]=c[d+32+8>>2];c[p+12>>2]=c[d+32+12>>2];q=r+160|0;c[q>>2]=c[d+48>>2];c[q+4>>2]=c[d+48+4>>2];c[q+8>>2]=c[d+48+8>>2];c[q+12>>2]=c[d+48+12>>2];f=r+728|0;d=r+760|0;h=r+908|0;j=r+680|0;k=j+48|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(k|0));c[f>>2]=1045220557;c[r+732>>2]=1045220557;c[r+736>>2]=1045220557;j=r+740|0;c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[j+16>>2]=0;c[d>>2]=1063675494;c[r+764>>2]=1063675494;c[r+768>>2]=1063675494;j=r+772|0;g[r+804>>2]=0.0;g[r+820>>2]=0.0;a[r+836>>0]=0;g[r+840>>2]=0.0;a[r+856>>0]=0;g[r+860>>2]=0.0;g[r+876>>2]=0.0;g[r+892>>2]=0.0;g[r+808>>2]=0.0;g[r+824>>2]=0.0;a[r+837>>0]=0;g[r+844>>2]=0.0;a[r+857>>0]=0;g[r+864>>2]=0.0;g[r+880>>2]=0.0;g[r+896>>2]=0.0;g[r+812>>2]=0.0;g[r+828>>2]=0.0;a[r+838>>0]=0;g[r+848>>2]=0.0;a[r+858>>0]=0;g[r+868>>2]=0.0;g[r+884>>2]=0.0;g[r+900>>2]=0.0;c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[j+16>>2]=0;c[j+20>>2]=0;c[j+24>>2]=0;a[j+28>>0]=0;j=h;k=j+60|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(k|0));g[r+968>>2]=1.0;g[r+972>>2]=-1.0;g[r+976>>2]=0.0;g[r+980>>2]=.20000000298023224;g[r+984>>2]=0.0;g[r+988>>2]=.8999999761581421;g[r+992>>2]=0.0;a[r+996>>0]=0;g[r+1e3>>2]=0.0;g[r+1004>>2]=.10000000149011612;a[r+1008>>0]=0;g[r+1012>>2]=0.0;a[r+1016>>0]=0;g[r+1020>>2]=0.0;a[r+1024>>0]=0;g[r+1028>>2]=0.0;a[r+1032>>0]=0;k=r+1036|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;g[r+1056>>2]=1.0;g[r+1060>>2]=-1.0;g[r+1064>>2]=0.0;g[r+1068>>2]=.20000000298023224;g[r+1072>>2]=0.0;g[r+1076>>2]=.8999999761581421;g[r+1080>>2]=0.0;a[r+1084>>0]=0;g[r+1088>>2]=0.0;g[r+1092>>2]=.10000000149011612;a[r+1096>>0]=0;g[r+1100>>2]=0.0;a[r+1104>>0]=0;g[r+1108>>2]=0.0;a[r+1112>>0]=0;g[r+1116>>2]=0.0;a[r+1120>>0]=0;k=r+1124|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;g[r+1144>>2]=1.0;g[r+1148>>2]=-1.0;g[r+1152>>2]=0.0;g[r+1156>>2]=.20000000298023224;g[r+1160>>2]=0.0;g[r+1164>>2]=.8999999761581421;g[r+1168>>2]=0.0;a[r+1172>>0]=0;g[r+1176>>2]=0.0;g[r+1180>>2]=.10000000149011612;a[r+1184>>0]=0;g[r+1188>>2]=0.0;a[r+1192>>0]=0;g[r+1196>>2]=0.0;a[r+1200>>0]=0;g[r+1204>>2]=0.0;a[r+1208>>0]=0;k=r+1212|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[r+1232>>2]=e;c[r+1456>>2]=0;H=+g[n>>2];N=+g[b+4>>2];G=+g[o>>2];M=+g[b+8>>2];F=+g[p>>2];L=+g[b+12>>2];E=+g[r+116>>2];D=+g[r+132>>2];C=+g[r+148>>2];B=+g[r+120>>2];z=+g[r+136>>2];x=+g[r+152>>2];K=+g[b+20>>2];J=+g[b+24>>2];I=+g[b+28>>2];A=+g[b+36>>2];y=+g[b+40>>2];w=+g[b+44>>2];P=+g[q>>2];O=+g[r+164>>2];u=+g[r+168>>2];v=+g[b+52>>2]+(N*P+M*O+L*u);t=K*P+J*O+I*u+ +g[b+56>>2];u=A*P+y*O+w*u+ +g[b+60>>2];g[r+48>>2]=H*N+G*M+F*L;g[r+52>>2]=N*E+M*D+L*C;g[r+56>>2]=N*B+M*z+L*x;g[r+60>>2]=0.0;g[r+64>>2]=H*K+G*J+F*I;g[r+68>>2]=E*K+D*J+C*I;g[r+72>>2]=B*K+z*J+x*I;g[r+76>>2]=0.0;g[r+80>>2]=H*A+G*y+F*w;g[r+84>>2]=E*A+D*y+C*w;g[r+88>>2]=B*A+z*y+x*w;g[r+92>>2]=0.0;g[r+96>>2]=v;g[r+100>>2]=t;g[r+104>>2]=u;g[r+108>>2]=0.0;pp(r,(c[l>>2]|0)+4|0,(c[m>>2]|0)+4|0);i=s;return r|0}function Py(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0,k=0,l=0;c[5637]=(c[5637]|0)+1;i=qG(1479)|0;if(!i)l=0;else{c[(i+4+15&-16)+-4>>2]=i;l=i+4+15&-16}c[l+4>>2]=12;c[l+8>>2]=-1;c[l+12>>2]=-1;g[l+16>>2]=3402823466385288598117041.0e14;a[l+20>>0]=1;a[l+21>>0]=0;c[l+24>>2]=-1;k=l+28|0;c[k>>2]=b;j=l+32|0;c[j>>2]=d;g[l+36>>2]=0.0;g[l+40>>2]=.30000001192092896;c[l+44>>2]=0;c[l>>2]=7300;i=l+48|0;c[i>>2]=c[e>>2];c[i+4>>2]=c[e+4>>2];c[i+8>>2]=c[e+8>>2];c[i+12>>2]=c[e+12>>2];i=l+64|0;c[i>>2]=c[e+16>>2];c[i+4>>2]=c[e+16+4>>2];c[i+8>>2]=c[e+16+8>>2];c[i+12>>2]=c[e+16+12>>2];i=l+80|0;c[i>>2]=c[e+32>>2];c[i+4>>2]=c[e+32+4>>2];c[i+8>>2]=c[e+32+8>>2];c[i+12>>2]=c[e+32+12>>2];i=l+96|0;c[i>>2]=c[e+48>>2];c[i+4>>2]=c[e+48+4>>2];c[i+8>>2]=c[e+48+8>>2];c[i+12>>2]=c[e+48+12>>2];i=l+112|0;c[i>>2]=c[f>>2];c[i+4>>2]=c[f+4>>2];c[i+8>>2]=c[f+8>>2];c[i+12>>2]=c[f+12>>2];i=l+128|0;c[i>>2]=c[f+16>>2];c[i+4>>2]=c[f+16+4>>2];c[i+8>>2]=c[f+16+8>>2];c[i+12>>2]=c[f+16+12>>2];i=l+144|0;c[i>>2]=c[f+32>>2];c[i+4>>2]=c[f+32+4>>2];c[i+8>>2]=c[f+32+8>>2];c[i+12>>2]=c[f+32+12>>2];i=l+160|0;c[i>>2]=c[f+48>>2];c[i+4>>2]=c[f+48+4>>2];c[i+8>>2]=c[f+48+8>>2];c[i+12>>2]=c[f+48+12>>2];i=l+728|0;b=l+760|0;d=l+908|0;e=l+680|0;f=e+48|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(f|0));c[i>>2]=1045220557;c[l+732>>2]=1045220557;c[l+736>>2]=1045220557;e=l+740|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[b>>2]=1063675494;c[l+764>>2]=1063675494;c[l+768>>2]=1063675494;e=l+772|0;g[l+804>>2]=0.0;g[l+820>>2]=0.0;a[l+836>>0]=0;g[l+840>>2]=0.0;a[l+856>>0]=0;g[l+860>>2]=0.0;g[l+876>>2]=0.0;g[l+892>>2]=0.0;g[l+808>>2]=0.0;g[l+824>>2]=0.0;a[l+837>>0]=0;g[l+844>>2]=0.0;a[l+857>>0]=0;g[l+864>>2]=0.0;g[l+880>>2]=0.0;g[l+896>>2]=0.0;g[l+812>>2]=0.0;g[l+828>>2]=0.0;a[l+838>>0]=0;g[l+848>>2]=0.0;a[l+858>>0]=0;g[l+868>>2]=0.0;g[l+884>>2]=0.0;g[l+900>>2]=0.0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;a[e+28>>0]=0;e=d;f=e+60|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(f|0));g[l+968>>2]=1.0;g[l+972>>2]=-1.0;g[l+976>>2]=0.0;g[l+980>>2]=.20000000298023224;g[l+984>>2]=0.0;g[l+988>>2]=.8999999761581421;g[l+992>>2]=0.0;a[l+996>>0]=0;g[l+1e3>>2]=0.0;g[l+1004>>2]=.10000000149011612;a[l+1008>>0]=0;g[l+1012>>2]=0.0;a[l+1016>>0]=0;g[l+1020>>2]=0.0;a[l+1024>>0]=0;g[l+1028>>2]=0.0;a[l+1032>>0]=0;f=l+1036|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;g[l+1056>>2]=1.0;g[l+1060>>2]=-1.0;g[l+1064>>2]=0.0;g[l+1068>>2]=.20000000298023224;g[l+1072>>2]=0.0;g[l+1076>>2]=.8999999761581421;g[l+1080>>2]=0.0;a[l+1084>>0]=0;g[l+1088>>2]=0.0;g[l+1092>>2]=.10000000149011612;a[l+1096>>0]=0;g[l+1100>>2]=0.0;a[l+1104>>0]=0;g[l+1108>>2]=0.0;a[l+1112>>0]=0;g[l+1116>>2]=0.0;a[l+1120>>0]=0;f=l+1124|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;g[l+1144>>2]=1.0;g[l+1148>>2]=-1.0;g[l+1152>>2]=0.0;g[l+1156>>2]=.20000000298023224;g[l+1160>>2]=0.0;g[l+1164>>2]=.8999999761581421;g[l+1168>>2]=0.0;a[l+1172>>0]=0;g[l+1176>>2]=0.0;g[l+1180>>2]=.10000000149011612;a[l+1184>>0]=0;g[l+1188>>2]=0.0;a[l+1192>>0]=0;g[l+1196>>2]=0.0;a[l+1200>>0]=0;g[l+1204>>2]=0.0;a[l+1208>>0]=0;f=l+1212|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[l+1232>>2]=h;c[l+1456>>2]=0;pp(l,(c[k>>2]|0)+4|0,(c[j>>2]|0)+4|0);return l|0}function Qy(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function Ry(b,c,d){b=b|0;c=c|0;d=d|0;if((c|0)<3){a[b+798+c>>0]=d&1;return}else{a[b+968+((c+-3|0)*88|0)+48>>0]=d&1;return}}function Sy(a){a=a|0;return +(+g[a+16>>2])}function Ty(a,b){a=a|0;b=b|0;return a+968+(b*88|0)|0}function Uy(a){a=a|0;return a+680|0}function Vy(a,b){a=a|0;b=b|0;var c=0.0;c=+oG(+g[b>>2]);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+968>>2]=c;c=+oG(+g[b+4>>2]);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+1056>>2]=c;c=+oG(+g[b+8>>2]);if(c<-3.1415927410125732){c=c+6.2831854820251465;a=a+1144|0;g[a>>2]=c;return}if(!(c>3.1415927410125732)){a=a+1144|0;g[a>>2]=c;return}c=c+-6.2831854820251465;a=a+1144|0;g[a>>2]=c;return}function Wy(a,b){a=a|0;b=b|0;var c=0.0;c=+oG(+g[b>>2]);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+972>>2]=c;c=+oG(+g[b+4>>2]);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+1060>>2]=c;c=+oG(+g[b+8>>2]);if(c<-3.1415927410125732){c=c+6.2831854820251465;a=a+1148|0;g[a>>2]=c;return}if(!(c>3.1415927410125732)){a=a+1148|0;g[a>>2]=c;return}c=c+-6.2831854820251465;a=a+1148|0;g[a>>2]=c;return}function Xy(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function Yy(b,c,d){b=b|0;c=c|0;d=+d;if((c|0)<3){g[b+840+(c<<2)>>2]=d;a[b+856+c>>0]=1;return}else{g[b+968+((c+-3|0)*88|0)+60>>2]=d;a[b+968+((c+-3|0)*88|0)+64>>0]=1;return}}function Zy(a,b){a=a|0;b=b|0;c[a+680>>2]=c[b>>2];c[a+680+4>>2]=c[b+4>>2];c[a+680+8>>2]=c[b+8>>2];c[a+680+12>>2]=c[b+12>>2];return}function _y(a,b){a=a|0;b=b|0;c[a+696>>2]=c[b>>2];c[a+696+4>>2]=c[b+4>>2];c[a+696+8>>2]=c[b+8>>2];c[a+696+12>>2]=c[b+12>>2];return}function $y(b,c,d){b=b|0;c=c|0;d=+d;if((c|0)<3){g[b+820+(c<<2)>>2]=d;a[b+836+c>>0]=1;return}else{g[b+968+((c+-3|0)*88|0)+52>>2]=d;a[b+968+((c+-3|0)*88|0)+56>>0]=1;return}}function az(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function bz(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;c[5637]=(c[5637]|0)+1;f=qG(1407)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}mp(f,b,d,e);c[f>>2]=7364;c[f+4>>2]=9;a[f+1309>>0]=0;g[f+1316>>2]=0.0;g[f+1340>>2]=0.0;g[f+1364>>2]=1.0;a[f+1310>>0]=0;g[f+1320>>2]=0.0;g[f+1344>>2]=0.0;g[f+1368>>2]=1.0;a[f+1311>>0]=0;g[f+1324>>2]=0.0;g[f+1348>>2]=0.0;g[f+1372>>2]=1.0;a[f+1312>>0]=0;g[f+1328>>2]=0.0;g[f+1352>>2]=0.0;g[f+1376>>2]=1.0;a[f+1313>>0]=0;g[f+1332>>2]=0.0;g[f+1356>>2]=0.0;g[f+1380>>2]=1.0;a[f+1314>>0]=0;g[f+1336>>2]=0.0;g[f+1360>>2]=0.0;g[f+1384>>2]=1.0;return f|0}function cz(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0;c[5637]=(c[5637]|0)+1;i=qG(1407)|0;if(!i)i=0;else{c[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}lp(i,b,d,e,f,h);c[i>>2]=7364;c[i+4>>2]=9;a[i+1309>>0]=0;g[i+1316>>2]=0.0;g[i+1340>>2]=0.0;g[i+1364>>2]=1.0;a[i+1310>>0]=0;g[i+1320>>2]=0.0;g[i+1344>>2]=0.0;g[i+1368>>2]=1.0;a[i+1311>>0]=0;g[i+1324>>2]=0.0;g[i+1348>>2]=0.0;g[i+1372>>2]=1.0;a[i+1312>>0]=0;g[i+1328>>2]=0.0;g[i+1352>>2]=0.0;g[i+1376>>2]=1.0;a[i+1313>>0]=0;g[i+1332>>2]=0.0;g[i+1356>>2]=0.0;g[i+1380>>2]=1.0;a[i+1314>>0]=0;g[i+1336>>2]=0.0;g[i+1360>>2]=0.0;g[i+1384>>2]=1.0;return i|0}function dz(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function ez(b,c,d){b=b|0;c=c|0;d=d|0;a[b+1309+c>>0]=d&1;if((c|0)<3){a[b+788+c>>0]=d&1;return}else{a[b+868+(c+-3<<6)+44>>0]=d&1;return}}function fz(a){a=a|0;return +(+g[a+16>>2])}function gz(a,b){a=a|0;b=b|0;var c=0.0;c=+oG(+g[b>>2]);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+868>>2]=c;c=+oG(+g[b+4>>2]);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+932>>2]=c;c=+oG(+g[b+8>>2]);if(c<-3.1415927410125732){c=c+6.2831854820251465;a=a+996|0;g[a>>2]=c;return}if(!(c>3.1415927410125732)){a=a+996|0;g[a>>2]=c;return}c=c+-6.2831854820251465;a=a+996|0;g[a>>2]=c;return}function hz(a,b){a=a|0;b=b|0;var c=0.0;c=+oG(+g[b>>2]);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+872>>2]=c;c=+oG(+g[b+4>>2]);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+936>>2]=c;c=+oG(+g[b+8>>2]);if(c<-3.1415927410125732){c=c+6.2831854820251465;a=a+1e3|0;g[a>>2]=c;return}if(!(c>3.1415927410125732)){a=a+1e3|0;g[a>>2]=c;return}c=c+-6.2831854820251465;a=a+1e3|0;g[a>>2]=c;return}function iz(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function jz(a,b,c){a=a|0;b=b|0;c=+c;g[a+1364+(b<<2)>>2]=c;return}function kz(a,b){a=a|0;b=b|0;c[a+680>>2]=c[b>>2];c[a+680+4>>2]=c[b+4>>2];c[a+680+8>>2]=c[b+8>>2];c[a+680+12>>2]=c[b+12>>2];return}function lz(a,b){a=a|0;b=b|0;c[a+696>>2]=c[b>>2];c[a+696+4>>2]=c[b+4>>2];c[a+696+8>>2]=c[b+8>>2];c[a+696+12>>2]=c[b+12>>2];return}function mz(a,b,c){a=a|0;b=b|0;c=+c;g[a+1340+(b<<2)>>2]=c;return}function nz(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function oz(a){a=a|0;if(c[a+204>>2]&3|0)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function pz(a,b){a=a|0;b=b|0;if(!b?c[a+204>>2]&3|0:0)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function qz(){var b=0,d=0;c[5637]=(c[5637]|0)+1;b=qG(327)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}c[b+164>>2]=1065353216;c[b+168>>2]=1065353216;c[b+172>>2]=1065353216;g[b+176>>2]=0.0;c[b+180>>2]=0;g[b+184>>2]=999999984306749440.0;d=b+188|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[b+204>>2]=1;c[b+208>>2]=-1;c[b+212>>2]=-1;c[b+216>>2]=1;g[b+220>>2]=0.0;g[b+224>>2]=.5;g[b+228>>2]=0.0;g[b+232>>2]=0.0;c[b+240>>2]=0;c[b+244>>2]=-1;g[b+248>>2]=1.0;g[b+252>>2]=0.0;g[b+256>>2]=0.0;c[b+260>>2]=0;a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0;c[b+284>>2]=0;c[b+4>>2]=1065353216;d=b+8|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[b+24>>2]=1065353216;d=b+28|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[b+44>>2]=1065353216;d=b+48|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[b>>2]=4344;a[b+304>>0]=1;c[b+300>>2]=0;c[b+292>>2]=0;c[b+296>>2]=0;c[b+236>>2]=4;return b|0}function rz(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function sz(a){a=a|0;return c[a+204>>2]|0}function tz(a){a=a|0;return c[a+192>>2]|0}function uz(a){a=a|0;return c[a+292>>2]|0}function vz(a,b){a=a|0;b=b|0;return c[(c[a+300>>2]|0)+(b<<2)>>2]|0}function wz(a){a=a|0;return a+4|0}function xz(a){a=a|0;a=c[a+216>>2]|0;return (a|0)!=5&(a|0)!=2|0}function yz(a){a=a|0;return (c[a+204>>2]&2|0)!=0|0}function zz(a,b){a=a|0;b=b|0;if((c[a+216>>2]&-2|0)==4)return;c[a+216>>2]=b;return}function Az(a,b,d){a=a|0;b=b|0;d=d|0;c[a+164>>2]=c[b>>2];c[a+164+4>>2]=c[b+4>>2];c[a+164+8>>2]=c[b+8>>2];c[a+164+12>>2]=c[b+12>>2];if(!(+g[b>>2]!=1.0)?!(+g[b+4>>2]!=1.0):0)d=+g[b+8>>2]!=1.0?d:0;c[a+180>>2]=d;return}function Bz(a,b){a=a|0;b=+b;g[a+256>>2]=b;return}function Cz(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function Dz(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function Ez(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+8>>2]&127](a,b);return}function Fz(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function Gz(a,b){a=a|0;b=+b;c[a+284>>2]=(c[a+284>>2]|0)+1;g[a+224>>2]=b;return}function Hz(a,b){a=a|0;b=+b;c[a+284>>2]=(c[a+284>>2]|0)+1;g[a+228>>2]=b;return}function Iz(a,b){a=a|0;b=+b;c[a+284>>2]=(c[a+284>>2]|0)+1;g[a+232>>2]=b;return}function Jz(a,b){a=a|0;b=b|0;c[a+284>>2]=(c[a+284>>2]|0)+1;c[a+4>>2]=c[b>>2];c[a+4+4>>2]=c[b+4>>2];c[a+4+8>>2]=c[b+8>>2];c[a+4+12>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+20+4>>2]=c[b+16+4>>2];c[a+20+8>>2]=c[b+16+8>>2];c[a+20+12>>2]=c[b+16+12>>2];c[a+36>>2]=c[b+32>>2];c[a+36+4>>2]=c[b+32+4>>2];c[a+36+8>>2]=c[b+32+8>>2];c[a+36+12>>2]=c[b+32+12>>2];c[a+52>>2]=c[b+48>>2];c[a+52+4>>2]=c[b+48+4>>2];c[a+52+8>>2]=c[b+48+8>>2];c[a+52+12>>2]=c[b+48+12>>2];return}function Kz(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Lz(){var a=0,b=0;while(1){a=qG(4)|0;if(a|0){b=6;break}a=c[5831]|0;c[5831]=a+0;if(!a){b=5;break}_b[a&3]()}if((b|0)==5){b=Va(4)|0;c[b>>2]=8308;hb(b|0,2416,215)}else if((b|0)==6){c[a>>2]=8084;return a|0}return 0}function Mz(a){a=a|0;return}function Nz(a){a=a|0;rG(a);return}function Oz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=c[b>>2]|0;a=c[d>>2]|0;a=(c[a+236>>2]|0)==4?a:0;if(!((e|0)==0?1:(c[e+236>>2]|0)!=4))Zb[c[(c[e>>2]|0)+28>>2]&127](e,d,b);if(!a)return 0;Zb[c[(c[a>>2]|0)+28>>2]&127](a,b,d);return 0}function Pz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=c[b>>2]|0;a=c[d>>2]|0;a=(c[a+236>>2]|0)==4?a:0;if(!((f|0)==0?1:(c[f+236>>2]|0)!=4))bc[c[(c[f>>2]|0)+32>>2]&127](f,d,e,b);if(!a)return 0;bc[c[(c[a>>2]|0)+32>>2]&127](a,b,e,d);return 0}function Qz(a,b,c){a=a|0;b=b|0;c=c|0;return}function Rz(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Sz(a,b){a=a|0;b=b|0;var d=0;c[5637]=(c[5637]|0)+1;d=qG(787)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}Lp(d,a,b,0);return d|0}function Tz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;c[5637]=(c[5637]|0)+1;e=qG(787)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}Lp(e,a,b,d);return e|0}function Uz(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0;c[5637]=(c[5637]|0)+1;h=qG(787)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}c[h+4>>2]=4;c[h+8>>2]=-1;c[h+12>>2]=-1;g[h+16>>2]=3402823466385288598117041.0e14;a[h+20>>0]=1;a[h+21>>0]=0;c[h+24>>2]=-1;c[h+28>>2]=b;c[h+32>>2]=d;g[h+36>>2]=0.0;g[h+40>>2]=.30000001192092896;c[h+44>>2]=0;c[h>>2]=7428;d=h+552|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=h+568|0;c[d>>2]=c[e+16>>2];c[d+4>>2]=c[e+16+4>>2];c[d+8>>2]=c[e+16+8>>2];c[d+12>>2]=c[e+16+12>>2];d=h+584|0;c[d>>2]=c[e+32>>2];c[d+4>>2]=c[e+32+4>>2];c[d+8>>2]=c[e+32+8>>2];c[d+12>>2]=c[e+32+12>>2];d=h+600|0;c[d>>2]=c[e+48>>2];c[d+4>>2]=c[e+48+4>>2];c[d+8>>2]=c[e+48+8>>2];c[d+12>>2]=c[e+48+12>>2];e=h+616|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=h+632|0;c[e>>2]=c[f+16>>2];c[e+4>>2]=c[f+16+4>>2];c[e+8>>2]=c[f+16+8>>2];c[e+12>>2]=c[f+16+12>>2];e=h+648|0;c[e>>2]=c[f+32>>2];c[e+4>>2]=c[f+32+4>>2];c[e+8>>2]=c[f+32+8>>2];c[e+12>>2]=c[f+32+12>>2];e=h+664|0;c[e>>2]=c[f+48>>2];c[e+4>>2]=c[f+48+4>>2];c[e+8>>2]=c[f+48+8>>2];c[e+12>>2]=c[f+48+12>>2];g[h+688>>2]=0.0;g[h+692>>2]=-1.0;g[h+696>>2]=.8999999761581421;g[h+700>>2]=.30000001192092896;g[h+704>>2]=1.0;g[h+708>>2]=0.0;g[h+712>>2]=0.0;a[h+716>>0]=0;a[h+736>>0]=0;a[h+737>>0]=0;a[h+738>>0]=0;a[h+739>>0]=1;a[h+740>>0]=0;f=h+748|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;g[h+732>>2]=1.0;return h|0}function Vz(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0;c[5637]=(c[5637]|0)+1;i=qG(787)|0;if(!i)i=0;else{c[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}c[i+4>>2]=4;c[i+8>>2]=-1;c[i+12>>2]=-1;g[i+16>>2]=3402823466385288598117041.0e14;a[i+20>>0]=1;a[i+21>>0]=0;c[i+24>>2]=-1;c[i+28>>2]=b;c[i+32>>2]=d;g[i+36>>2]=0.0;g[i+40>>2]=.30000001192092896;c[i+44>>2]=0;c[i>>2]=7428;d=i+552|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=i+568|0;c[d>>2]=c[e+16>>2];c[d+4>>2]=c[e+16+4>>2];c[d+8>>2]=c[e+16+8>>2];c[d+12>>2]=c[e+16+12>>2];d=i+584|0;c[d>>2]=c[e+32>>2];c[d+4>>2]=c[e+32+4>>2];c[d+8>>2]=c[e+32+8>>2];c[d+12>>2]=c[e+32+12>>2];d=i+600|0;c[d>>2]=c[e+48>>2];c[d+4>>2]=c[e+48+4>>2];c[d+8>>2]=c[e+48+8>>2];c[d+12>>2]=c[e+48+12>>2];e=i+616|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=i+632|0;c[e>>2]=c[f+16>>2];c[e+4>>2]=c[f+16+4>>2];c[e+8>>2]=c[f+16+8>>2];c[e+12>>2]=c[f+16+12>>2];e=i+648|0;c[e>>2]=c[f+32>>2];c[e+4>>2]=c[f+32+4>>2];c[e+8>>2]=c[f+32+8>>2];c[e+12>>2]=c[f+32+12>>2];e=i+664|0;c[e>>2]=c[f+48>>2];c[e+4>>2]=c[f+48+4>>2];c[e+8>>2]=c[f+48+8>>2];c[e+12>>2]=c[f+48+12>>2];g[i+688>>2]=0.0;g[i+692>>2]=-1.0;g[i+696>>2]=.8999999761581421;g[i+700>>2]=.30000001192092896;g[i+704>>2]=1.0;g[i+708>>2]=0.0;g[i+712>>2]=0.0;a[i+716>>0]=0;a[i+736>>0]=0;a[i+737>>0]=0;a[i+738>>0]=0;a[i+739>>0]=1;a[i+740>>0]=h&1;f=i+748|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;g[i+732>>2]=h?-1.0:1.0;return i|0}function Wz(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0;c[5637]=(c[5637]|0)+1;h=qG(787)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}Kp(h,a,b,d,e,f,g,0);return h|0}function Xz(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0;c[5637]=(c[5637]|0)+1;i=qG(787)|0;if(!i)i=0;else{c[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}Kp(i,a,b,d,e,f,g,h);return i|0}function Yz(b,c,d,e){b=b|0;c=c|0;d=+d;e=+e;a[b+737>>0]=c&1;g[b+680>>2]=d;g[b+684>>2]=e;return}function Zz(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function _z(a){a=a|0;return +(+g[a+16>>2])}function $z(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function aA(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;g[a+692>>2]=(c-b)*.5;b=+oG((c-b)*.5+b);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+688>>2]=b;g[a+696>>2]=d;g[a+700>>2]=e;g[a+704>>2]=1.0;return}function bA(a,b,c,d,e,f){a=a|0;b=+b;c=+c;d=+d;e=+e;f=+f;g[a+692>>2]=(c-b)*.5;b=+oG((c-b)*.5+b);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+688>>2]=b;g[a+696>>2]=d;g[a+700>>2]=e;g[a+704>>2]=f;return}function cA(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function dA(b,d,e){b=b|0;d=d|0;e=+e;var f=0,h=0;c[5637]=(c[5637]|0)+1;f=qG(203)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}c[f>>2]=7044;h=f+60|0;a[f+144>>0]=1;c[f+140>>2]=0;c[f+132>>2]=0;c[f+136>>2]=0;c[f+176>>2]=1;g[f+56>>2]=.019999999552965164;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;a[f+170>>0]=1;c[f+8>>2]=b;g[f+52>>2]=e;g[f+48>>2]=0.0;c[f+12>>2]=d;a[f+171>>0]=1;g[f+172>>2]=0.0;g[f+16>>2]=0.0;g[f+20>>2]=0.0;g[f+44>>2]=29.399999618530273;g[f+24>>2]=55.0;g[f+28>>2]=10.0;a[f+168>>0]=0;a[f+169>>0]=0;a[f+180>>0]=1;g[f+36>>2]=.7853981852531433;g[f+40>>2]=.7071067690849304;g[f+108>>2]=0.0;a[f+181>>0]=0;a[f+182>>0]=0;return f|0}function eA(b,d,e,f){b=b|0;d=d|0;e=+e;f=f|0;var h=0,i=0;c[5637]=(c[5637]|0)+1;h=qG(203)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}c[h>>2]=7044;i=h+60|0;a[h+144>>0]=1;c[h+140>>2]=0;c[h+132>>2]=0;c[h+136>>2]=0;c[h+176>>2]=f;g[h+56>>2]=.019999999552965164;c[i>>2]=0;c[i+4>>2]=0;c[i+8>>2]=0;c[i+12>>2]=0;a[h+170>>0]=1;c[h+8>>2]=b;g[h+52>>2]=e;g[h+48>>2]=0.0;c[h+12>>2]=d;a[h+171>>0]=1;g[h+172>>2]=0.0;g[h+16>>2]=0.0;g[h+20>>2]=0.0;g[h+44>>2]=29.399999618530273;g[h+24>>2]=55.0;g[h+28>>2]=10.0;a[h+168>>0]=0;a[h+169>>0]=0;a[h+180>>0]=1;g[h+36>>2]=.7853981852531433;g[h+40>>2]=.7071067690849304;g[h+108>>2]=0.0;a[h+181>>0]=0;a[h+182>>0]=0;return h|0}function fA(a){a=a|0;return vb[c[(c[a>>2]|0)+40>>2]&127](a)|0}function gA(a){a=a|0;return c[a+8>>2]|0}function hA(a){a=a|0;return +(+g[a+44>>2])}function iA(a){a=a|0;return +(+g[a+36>>2])}function jA(a){a=a|0;rb[c[(c[a>>2]|0)+44>>2]&255](a);return}function kA(a){a=a|0;return vb[c[(c[a>>2]|0)+48>>2]&127](a)|0}function lA(a,b,d){a=a|0;b=b|0;d=+d;$b[c[(c[a>>2]|0)+36>>2]&7](a,b,d);return}function mA(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+32>>2]&127](a,b);return}function nA(a,b){a=a|0;b=+b;g[a+24>>2]=b;return}function oA(a,b){a=a|0;b=+b;g[a+44>>2]=b;return}function pA(a,b){a=a|0;b=+b;g[a+28>>2]=b;return}function qA(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function rA(a,b){a=a|0;b=+b;g[a+36>>2]=b;g[a+40>>2]=+Q(+b);return}function sA(a,b){a=a|0;b=b|0;b=(b|0)<0?0:b;c[a+176>>2]=(b|0)>2?2:b;return}function tA(b,c){b=b|0;c=c|0;a[b+170>>0]=c&1;return}function uA(a,b,d){a=a|0;b=b|0;d=+d;$b[c[(c[a>>2]|0)+20>>2]&7](a,b,d);return}function vA(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+16>>2]&127](a,b);return}function wA(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+28>>2]&127](a,b);return}function xA(a){a=a|0;if(!a)return;rG(a);return}function yA(a){a=a|0;return +(+g[a+80>>2])}function zA(a){a=a|0;return a+48|0}function AA(a){a=a|0;return a+32|0}function BA(a){a=a|0;return a|0}function CA(a){a=a|0;return a+16|0}function DA(a){a=a|0;return a+64|0}function EA(a){a=a|0;return a+48|0}function FA(a){a=a|0;return a+32|0}function GA(a,b){a=a|0;b=b|0;c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];return}function HA(a,b){a=a|0;b=b|0;c[a+16>>2]=c[b>>2];c[a+16+4>>2]=c[b+4>>2];c[a+16+8>>2]=c[b+8>>2];c[a+16+12>>2]=c[b+12>>2];return}function IA(a,b){a=a|0;b=b|0;c[a+64>>2]=c[b>>2];c[a+64+4>>2]=c[b+4>>2];c[a+64+8>>2]=c[b+8>>2];c[a+64+12>>2]=c[b+12>>2];return}function JA(a,b){a=a|0;b=b|0;c[a+48>>2]=c[b>>2];c[a+48+4>>2]=c[b+4>>2];c[a+48+8>>2]=c[b+8>>2];c[a+48+12>>2]=c[b+12>>2];return}function KA(a,b){a=a|0;b=b|0;c[a+32>>2]=c[b>>2];c[a+32+4>>2]=c[b+4>>2];c[a+32+8>>2]=c[b+8>>2];c[a+32+12>>2]=c[b+12>>2];return}function LA(a){a=a|0;if(!a)return;rG(a);return}function MA(a,b){a=a|0;b=b|0;_f(a,b);return}function NA(b,d){b=b|0;d=d|0;if(!(a[19920]|0))a[19920]=1;c[5696]=c[b+(d<<4)>>2];c[5697]=c[b+(d<<4)+4>>2];c[5698]=c[b+(d<<4)+8>>2];c[5699]=c[b+(d<<4)+12>>2];return 22784}function OA(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;var e=0.0,f=0.0,h=0.0;f=+Q(+b);e=+Q(+c);h=+Q(+d);b=+R(+b);c=+R(+c);d=+R(+d);g[a>>2]=e*h;g[a+4>>2]=c*(h*b)-f*d;g[a+8>>2]=f*h*c+b*d;g[a+12>>2]=0.0;g[a+16>>2]=e*d;g[a+20>>2]=f*h+c*(b*d);g[a+24>>2]=c*(f*d)-h*b;g[a+28>>2]=0.0;g[a+32>>2]=-c;g[a+36>>2]=e*b;g[a+40>>2]=f*e;g[a+44>>2]=0.0;return}function PA(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function QA(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+8>>2]&127](a,b);return}function RA(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+12>>2]&127](a,b);return}function SA(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function TA(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+60>>2]&127](a,b);return}function UA(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function VA(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function WA(a){a=a|0;if(c[a+204>>2]&3|0)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function XA(a,b){a=a|0;b=b|0;if(!b?c[a+204>>2]&3|0:0)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function YA(){var a=0;c[5637]=(c[5637]|0)+1;a=qG(331)|0;if(!a)a=0;else{c[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16}oi(a);return a|0}function ZA(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function _A(a){a=a|0;return c[a+204>>2]|0}function $A(a){a=a|0;return c[a+192>>2]|0}function aB(a){a=a|0;return c[a+292>>2]|0}function bB(a,b){a=a|0;b=b|0;return c[(c[a+300>>2]|0)+(b<<2)>>2]|0}function cB(a){a=a|0;return a+4|0}function dB(a){a=a|0;a=c[a+216>>2]|0;return (a|0)!=5&(a|0)!=2|0}function eB(a){a=a|0;return (c[a+204>>2]&2|0)!=0|0}function fB(a,b){a=a|0;b=b|0;if((c[a+216>>2]&-2|0)==4)return;c[a+216>>2]=b;return}function gB(a,b,d){a=a|0;b=b|0;d=d|0;c[a+164>>2]=c[b>>2];c[a+164+4>>2]=c[b+4>>2];c[a+164+8>>2]=c[b+8>>2];c[a+164+12>>2]=c[b+12>>2];if(!(+g[b>>2]!=1.0)?!(+g[b+4>>2]!=1.0):0)d=+g[b+8>>2]!=1.0?d:0;c[a+180>>2]=d;return}function hB(a,b){a=a|0;b=+b;g[a+256>>2]=b;return}function iB(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function jB(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function kB(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+8>>2]&127](a,b);return}function lB(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function mB(a,b){a=a|0;b=+b;c[a+284>>2]=(c[a+284>>2]|0)+1;g[a+224>>2]=b;return}function nB(a,b){a=a|0;b=+b;c[a+284>>2]=(c[a+284>>2]|0)+1;g[a+228>>2]=b;return}function oB(a,b){a=a|0;b=+b;c[a+284>>2]=(c[a+284>>2]|0)+1;g[a+232>>2]=b;return}function pB(a,b){a=a|0;b=b|0;c[a+284>>2]=(c[a+284>>2]|0)+1;c[a+4>>2]=c[b>>2];c[a+4+4>>2]=c[b+4>>2];c[a+4+8>>2]=c[b+8>>2];c[a+4+12>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+20+4>>2]=c[b+16+4>>2];c[a+20+8>>2]=c[b+16+8>>2];c[a+20+12>>2]=c[b+16+12>>2];c[a+36>>2]=c[b+32>>2];c[a+36+4>>2]=c[b+32+4>>2];c[a+36+8>>2]=c[b+32+8>>2];c[a+36+12>>2]=c[b+32+12>>2];c[a+52>>2]=c[b+48>>2];c[a+52+4>>2]=c[b+48+4>>2];c[a+52+8>>2]=c[b+48+8>>2];c[a+52+12>>2]=c[b+48+12>>2];return}function qB(a){a=a|0;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function rB(){var b=0,d=0;c[5637]=(c[5637]|0)+1;b=qG(791)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}c[b>>2]=1025;c[b+116>>2]=0;a[b+120>>0]=0;d=b+124|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[b+300>>2]=0;a[b+304>>0]=0;d=b+308|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[b+484>>2]=0;a[b+488>>0]=0;d=b+492|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[b+668>>2]=0;a[b+672>>0]=0;d=b+676|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[b+740>>2]=0;c[b+744>>2]=0;c[b+748>>2]=0;c[b+768>>2]=0;return b|0}function sB(a){a=a|0;return c[a+740>>2]|0}function tB(a){a=a|0;return c[a+744>>2]|0}function uB(a,b){a=a|0;b=b|0;return a+4+(b*184|0)|0}function vB(a){a=a|0;return c[a+748>>2]|0}function wB(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function xB(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0;c[5637]=(c[5637]|0)+1;e=qG(379)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}yq(e,3,b);c[e>>2]=7484;l=e+300|0;c[l>>2]=c[d>>2];c[l+4>>2]=c[d+4>>2];c[l+8>>2]=c[d+8>>2];c[l+12>>2]=c[d+12>>2];k=+g[d>>2];j=+g[d+4>>2];i=+g[d+8>>2];h=k*+g[b+20>>2]+j*+g[b+24>>2]+i*+g[b+28>>2]+ +g[b+56>>2];f=k*+g[b+36>>2]+j*+g[b+40>>2]+i*+g[b+44>>2]+ +g[b+60>>2];g[e+316>>2]=k*+g[b+4>>2]+j*+g[b+8>>2]+i*+g[b+12>>2]+ +g[b+52>>2];g[e+320>>2]=h;g[e+324>>2]=f;g[e+328>>2]=0.0;c[e+332>>2]=0;a[e+344>>0]=0;g[e+348>>2]=.30000001192092896;g[e+352>>2]=1.0;g[e+356>>2]=0.0;return e|0}function yB(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0;c[5637]=(c[5637]|0)+1;h=qG(379)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}c[h+4>>2]=3;c[h+8>>2]=-1;c[h+12>>2]=-1;g[h+16>>2]=3402823466385288598117041.0e14;a[h+20>>0]=1;a[h+21>>0]=0;c[h+24>>2]=-1;c[h+28>>2]=b;c[h+32>>2]=d;g[h+36>>2]=0.0;g[h+40>>2]=.30000001192092896;c[h+44>>2]=0;c[h>>2]=7484;d=h+300|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=h+316|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];c[h+332>>2]=0;a[h+344>>0]=0;g[h+348>>2]=.30000001192092896;g[h+352>>2]=1.0;g[h+356>>2]=0.0;return h|0}function zB(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function AB(a){a=a|0;return +(+g[a+16>>2])}function BB(a){a=a|0;return a+300|0}function CB(a){a=a|0;return a+316|0}function DB(a){a=a|0;return a+348|0}function EB(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function FB(a,b){a=a|0;b=b|0;c[a+300>>2]=c[b>>2];c[a+300+4>>2]=c[b+4>>2];c[a+300+8>>2]=c[b+8>>2];c[a+300+12>>2]=c[b+12>>2];return}function GB(a,b){a=a|0;b=b|0;c[a+316>>2]=c[b>>2];c[a+316+4>>2]=c[b+4>>2];c[a+316+8>>2]=c[b+8>>2];c[a+316+12>>2]=c[b+12>>2];return}function HB(a,b){a=a|0;b=b|0;c[a+348>>2]=c[b>>2];c[a+348+4>>2]=c[b+4>>2];c[a+348+8>>2]=c[b+8>>2];return}function IB(a){a=a|0;if(!a)return;rG(a);return}function JB(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function KB(a,b){a=a|0;b=+b;g[a>>2]=b;return}function LB(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function MB(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function NB(a){a=a|0;return +(+g[a+12>>2])}function OB(a){a=a|0;return +(+g[a>>2])}function PB(a){a=a|0;return +(+g[a+4>>2])}function QB(a){a=a|0;return +(+g[a+8>>2])}function RB(a){a=a|0;if(!a)return;rG(a);return}function SB(a,b,d,e){a=+a;b=+b;d=+d;e=+e;var f=0,h=0;while(1){f=qG(16)|0;if(f|0){h=6;break}f=c[5831]|0;c[5831]=f+0;if(!f){h=5;break}_b[f&3]()}if((h|0)==5){h=Va(4)|0;c[h>>2]=8308;hb(h|0,2416,215)}else if((h|0)==6){g[f>>2]=a;g[f+4>>2]=b;g[f+8>>2]=d;g[f+12>>2]=e;return f|0}return 0}function TB(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0.0,f=0.0;f=+g[a>>2];e=+g[a+4>>2];d=+g[a+8>>2];c=+g[a+12>>2];b=1.0/+O(+(f*f+e*e+d*d+c*c));g[a>>2]=f*b;g[a+4>>2]=e*b;g[a+8>>2]=d*b;g[a+12>>2]=c*b;return}function UB(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=e;return}function VB(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function WB(a,b){a=a|0;b=+b;g[a>>2]=b;return}function XB(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function YB(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function ZB(a){a=a|0;return +(+g[a+12>>2])}function _B(a){a=a|0;return +(+g[a>>2])}function $B(a){a=a|0;return +(+g[a+4>>2])}function aC(a){a=a|0;return +(+g[a+8>>2])}function bC(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function cC(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=+f;g=g|0;h=h|0;return Wr(a,b,c,d,e,f,g,h)|0}function dC(a,b,d){a=a|0;b=+b;d=d|0;g[(c[a+136>>2]|0)+(d*284|0)+252>>2]=b;return}function eC(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;while(1){b=qG(144)|0;if(b|0){f=6;break}b=c[5831]|0;c[5831]=b+0;if(!b){f=5;break}_b[b&3]()}if((f|0)==5){e=Va(4)|0;c[e>>2]=8308;hb(e|0,2416,215)}else if((f|0)==6){c[b>>2]=7952;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;c[b+92>>2]=e;g[b+96>>2]=0.0;a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;c[b+108>>2]=d;c[b+112>>2]=0;c[b+116>>2]=2;c[b+120>>2]=1;g[b+104>>2]=0.0;g[b+100>>2]=0.0;return b|0}return 0}function fC(a){a=a|0;return c[a+128>>2]|0}function gC(a){a=a|0;return c[a+108>>2]|0}function hC(a,b){a=a|0;b=b|0;return (c[a+136>>2]|0)+(b*284|0)|0}function iC(a,b){a=a|0;b=b|0;return (c[a+136>>2]|0)+(b*284|0)+92|0}function jC(a,b,d){a=a|0;b=+b;d=d|0;g[(c[a+136>>2]|0)+(d*284|0)+256>>2]=b;return}function kC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bc[c[(c[a>>2]|0)+24>>2]&127](a,b,d,e);return}function lC(a,b,d){a=a|0;b=+b;d=d|0;g[(c[a+136>>2]|0)+(d*284|0)+232>>2]=b;return}function mC(a,b,d){a=a|0;b=b|0;d=d|0;Mr(c[a+108>>2]|0,c[a+136>>2]|0,b,d);return}function nC(a){a=a|0;if(!a)return;rG(a);return}function oC(b,d,e){b=+b;d=d|0;e=e|0;var f=0,h=0;while(1){f=qG(140)|0;if(f|0){h=6;break}f=c[5831]|0;c[5831]=f+0;if(!f){h=5;break}_b[f&3]()}if((h|0)==5){e=Va(4)|0;c[e>>2]=8308;hb(e|0,2416,215)}else if((h|0)==6){g[f>>2]=b;c[f+4>>2]=d;c[f+72>>2]=e;c[f+76>>2]=0;c[f+76+4>>2]=0;c[f+76+8>>2]=0;c[f+76+12>>2]=0;c[f+76+16>>2]=0;c[f+76+20>>2]=0;g[f+100>>2]=.5;g[f+104>>2]=0.0;g[f+108>>2]=0.0;g[f+112>>2]=.800000011920929;g[f+116>>2]=1.0;a[f+120>>0]=0;g[f+124>>2]=.004999999888241291;g[f+128>>2]=.009999999776482582;g[f+132>>2]=.009999999776482582;g[f+136>>2]=.009999999776482582;c[f+8>>2]=1065353216;c[f+12>>2]=0;c[f+12+4>>2]=0;c[f+12+8>>2]=0;c[f+12+12>>2]=0;c[f+28>>2]=1065353216;c[f+32>>2]=0;c[f+32+4>>2]=0;c[f+32+8>>2]=0;c[f+32+12>>2]=0;c[f+48>>2]=1065353216;c[f+52>>2]=0;c[f+52+4>>2]=0;c[f+52+8>>2]=0;c[f+52+12>>2]=0;c[f+52+16>>2]=0;return f|0}return 0}function pC(b,d,e,f){b=+b;d=d|0;e=e|0;f=f|0;var h=0,i=0;while(1){h=qG(140)|0;if(h|0){i=6;break}h=c[5831]|0;c[5831]=h+0;if(!h){i=5;break}_b[h&3]()}if((i|0)==5){f=Va(4)|0;c[f>>2]=8308;hb(f|0,2416,215)}else if((i|0)==6){g[h>>2]=b;c[h+4>>2]=d;c[h+72>>2]=e;c[h+76>>2]=c[f>>2];c[h+76+4>>2]=c[f+4>>2];c[h+76+8>>2]=c[f+8>>2];c[h+76+12>>2]=c[f+12>>2];g[h+92>>2]=0.0;g[h+96>>2]=0.0;g[h+100>>2]=.5;g[h+104>>2]=0.0;g[h+108>>2]=0.0;g[h+112>>2]=.800000011920929;g[h+116>>2]=1.0;a[h+120>>0]=0;g[h+124>>2]=.004999999888241291;g[h+128>>2]=.009999999776482582;g[h+132>>2]=.009999999776482582;g[h+136>>2]=.009999999776482582;c[h+8>>2]=1065353216;c[h+12>>2]=0;c[h+12+4>>2]=0;c[h+12+8>>2]=0;c[h+12+12>>2]=0;c[h+28>>2]=1065353216;c[h+32>>2]=0;c[h+32+4>>2]=0;c[h+32+8>>2]=0;c[h+32+12>>2]=0;c[h+48>>2]=1065353216;c[h+52>>2]=0;c[h+52+4>>2]=0;c[h+52+8>>2]=0;c[h+52+12>>2]=0;c[h+52+16>>2]=0;return h|0}return 0}function qC(a){a=a|0;return +(+g[a+136>>2])}function rC(a){a=a|0;return +(+g[a+132>>2])}function sC(a){a=a|0;return +(+g[a+124>>2])}function tC(b){b=b|0;return (a[b+120>>0]|0)!=0|0}function uC(a){a=a|0;return +(+g[a+128>>2])}function vC(a){a=a|0;return +(+g[a+96>>2])}function wC(a){a=a|0;return +(+g[a+116>>2])}function xC(a){a=a|0;return +(+g[a+100>>2])}function yC(a){a=a|0;return +(+g[a+92>>2])}function zC(a){a=a|0;return +(+g[a+112>>2])}function AC(a){a=a|0;return +(+g[a+108>>2])}function BC(a){a=a|0;return +(+g[a+104>>2])}function CC(a,b){a=a|0;b=+b;g[a+136>>2]=b;return}function DC(a,b){a=a|0;b=+b;g[a+132>>2]=b;return}function EC(a,b){a=a|0;b=+b;g[a+124>>2]=b;return}function FC(b,c){b=b|0;c=c|0;a[b+120>>0]=c&1;return}function GC(a,b){a=a|0;b=+b;g[a+128>>2]=b;return}function HC(a,b){a=a|0;b=+b;g[a+96>>2]=b;return}function IC(a,b){a=a|0;b=+b;g[a+116>>2]=b;return}function JC(a,b){a=a|0;b=+b;g[a+100>>2]=b;return}function KC(a,b){a=a|0;b=+b;g[a+92>>2]=b;return}function LC(a,b){a=a|0;b=+b;g[a+112>>2]=b;return}function MC(a,b){a=a|0;b=+b;g[a+108>>2]=b;return}function NC(a,b){a=a|0;b=+b;g[a+104>>2]=b;return}function OC(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function PC(a){a=a|0;if(c[a+204>>2]&3|0)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function QC(a,b){a=a|0;b=b|0;if(!b?c[a+204>>2]&3|0:0)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function RC(a,b){a=a|0;b=b|0;var c=0.0,d=0.0;d=+g[b+4>>2]*+g[a+376>>2];c=+g[b+8>>2]*+g[a+380>>2];g[a+436>>2]=+g[b>>2]*+g[a+372>>2]+ +g[a+436>>2];g[a+440>>2]=d+ +g[a+440>>2];g[a+444>>2]=c+ +g[a+444>>2];return}function SC(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0;e=+g[a+368>>2];d=+g[b+4>>2]*+g[a+376>>2]*e;c=e*(+g[b+8>>2]*+g[a+380>>2]);g[a+336>>2]=+g[b>>2]*+g[a+372>>2]*e+ +g[a+336>>2];g[a+340>>2]=d+ +g[a+340>>2];g[a+344>>2]=c+ +g[a+344>>2];return}function TC(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;d=+g[a+372>>2];h=+g[a+376>>2];f=+g[b+4>>2]*h;i=+g[a+380>>2];j=+g[b+8>>2]*i;g[a+436>>2]=+g[b>>2]*d+ +g[a+436>>2];g[a+440>>2]=f+ +g[a+440>>2];g[a+444>>2]=j+ +g[a+444>>2];d=d*+g[b>>2];h=h*+g[b+4>>2];i=i*+g[b+8>>2];j=+g[c+4>>2];f=+g[c+8>>2];k=+g[c>>2];e=(d*f-i*k)*+g[a+572>>2];d=(h*k-d*j)*+g[a+576>>2];g[a+452>>2]=(j*i-h*f)*+g[a+568>>2]+ +g[a+452>>2];g[a+456>>2]=e+ +g[a+456>>2];g[a+460>>2]=d+ +g[a+460>>2];return}function UC(a,b,c){a=a|0;b=b|0;c=c|0;Uo(a,b,c);return}function VC(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0,h=0.0;h=+g[b>>2];f=+g[b+4>>2];e=+g[b+8>>2];d=(h*+g[a+304>>2]+f*+g[a+308>>2]+e*+g[a+312>>2])*+g[a+572>>2];c=(h*+g[a+320>>2]+f*+g[a+324>>2]+e*+g[a+328>>2])*+g[a+576>>2];g[a+352>>2]=(+g[a+288>>2]*h+ +g[a+292>>2]*f+ +g[a+296>>2]*e)*+g[a+568>>2]+ +g[a+352>>2];g[a+356>>2]=d+ +g[a+356>>2];g[a+360>>2]=c+ +g[a+360>>2];return}function WC(a,b){a=a|0;b=b|0;var c=0.0,d=0.0;d=+g[b+4>>2]*+g[a+572>>2];c=+g[b+8>>2]*+g[a+576>>2];g[a+452>>2]=+g[b>>2]*+g[a+568>>2]+ +g[a+452>>2];g[a+456>>2]=d+ +g[a+456>>2];g[a+460>>2]=c+ +g[a+460>>2];return}function XC(b){b=b|0;var d=0,e=0;c[5637]=(c[5637]|0)+1;d=qG(659)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}c[d+164>>2]=1065353216;c[d+168>>2]=1065353216;c[d+172>>2]=1065353216;g[d+176>>2]=0.0;c[d+180>>2]=0;g[d+184>>2]=999999984306749440.0;e=d+188|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[d+204>>2]=1;c[d+208>>2]=-1;c[d+212>>2]=-1;c[d+216>>2]=1;g[d+220>>2]=0.0;g[d+224>>2]=.5;g[d+228>>2]=0.0;g[d+232>>2]=0.0;c[d+236>>2]=1;c[d+240>>2]=0;c[d+244>>2]=-1;g[d+248>>2]=1.0;g[d+252>>2]=0.0;g[d+256>>2]=0.0;c[d+260>>2]=0;a[d+280>>0]=1;c[d+276>>2]=0;c[d+268>>2]=0;c[d+272>>2]=0;c[d+284>>2]=0;c[d+4>>2]=1065353216;e=d+8|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[d+24>>2]=1065353216;e=d+28|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[d+44>>2]=1065353216;e=d+48|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[d>>2]=7916;a[d+524>>0]=1;c[d+520>>2]=0;c[d+512>>2]=0;c[d+516>>2]=0;Br(d,b);return d|0}function YC(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function ZC(a){a=a|0;return a+352|0}function _C(a){a=a|0;return a+4|0}function $C(a){a=a|0;return c[a+204>>2]|0}function aD(a){a=a|0;return c[a+192>>2]|0}function bD(a){a=a|0;return a+336|0}function cD(a){a=a|0;return c[a+504>>2]|0}function dD(a){a=a|0;return a+4|0}function eD(a){a=a|0;a=c[a+216>>2]|0;return (a|0)!=5&(a|0)!=2|0}function fD(a){a=a|0;return (c[a+204>>2]&2|0)!=0|0}function gD(a,b){a=a|0;b=b|0;if((c[a+216>>2]&-2|0)==4)return;c[a+216>>2]=b;return}function hD(a,b){a=a|0;b=b|0;c[a+284>>2]=(c[a+284>>2]|0)+1;c[a+568>>2]=c[b>>2];c[a+568+4>>2]=c[b+4>>2];c[a+568+8>>2]=c[b+8>>2];c[a+568+12>>2]=c[b+12>>2];return}function iD(a,b){a=a|0;b=b|0;c[a+284>>2]=(c[a+284>>2]|0)+1;c[a+352>>2]=c[b>>2];c[a+352+4>>2]=c[b+4>>2];c[a+352+8>>2]=c[b+8>>2];c[a+352+12>>2]=c[b+12>>2];return}function jD(a,b,d){a=a|0;b=b|0;d=d|0;c[a+164>>2]=c[b>>2];c[a+164+4>>2]=c[b+4>>2];c[a+164+8>>2]=c[b+8>>2];c[a+164+12>>2]=c[b+12>>2];if(!(+g[b>>2]!=1.0)?!(+g[b+4>>2]!=1.0):0)d=+g[b+8>>2]!=1.0?d:0;c[a+180>>2]=d;return}function kD(a,b){a=a|0;b=+b;g[a+256>>2]=b;return}function lD(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function mD(a,b){a=a|0;b=b|0;Er(a,b);return}function nD(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function oD(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+8>>2]&127](a,b);return}function pD(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function qD(a,b,d){a=a|0;b=+b;d=+d;var e=0;e=i;i=i+32|0;g[e+20>>2]=b;g[e+16>>2]=d;g[e+12>>2]=0.0;g[e+8>>2]=1.0;c[a+468>>2]=c[(b<0.0?e+12|0:b>1.0?e+8|0:e+20|0)>>2];g[e+4>>2]=0.0;g[e>>2]=1.0;c[a+472>>2]=c[(d<0.0?e+4|0:d>1.0?e:e+16|0)>>2];i=e;return}function rD(a,b){a=a|0;b=+b;c[a+284>>2]=(c[a+284>>2]|0)+1;g[a+224>>2]=b;return}function sD(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0;c[a+372>>2]=c[b>>2];c[a+372+4>>2]=c[b+4>>2];c[a+372+8>>2]=c[b+8>>2];c[a+372+12>>2]=c[b+12>>2];f=+g[a+368>>2];e=f*+g[a+376>>2];d=f*+g[a+380>>2];g[a+584>>2]=+g[a+372>>2]*f;g[a+588>>2]=e;g[a+592>>2]=d;g[a+596>>2]=0.0;return}function tD(a,b){a=a|0;b=b|0;c[a+284>>2]=(c[a+284>>2]|0)+1;c[a+336>>2]=c[b>>2];c[a+336+4>>2]=c[b+4>>2];c[a+336+8>>2]=c[b+8>>2];c[a+336+12>>2]=c[b+12>>2];return}function uD(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0,h=0.0,i=0.0,j=0.0;e=c[a+204>>2]|0;if(b==0.0){c[a+204>>2]=e|1;h=0.0}else{c[a+204>>2]=e&-2;h=1.0/b}g[a+368>>2]=h;j=+g[a+408>>2]*b;i=+g[a+412>>2]*b;g[a+388>>2]=+g[a+404>>2]*b;g[a+392>>2]=j;g[a+396>>2]=i;g[a+400>>2]=0.0;b=+g[d>>2];f=b!=0.0?(g[k>>2]=1.0/b,c[k>>2]|0):0;b=+g[d+4>>2];e=b!=0.0?(g[k>>2]=1.0/b,c[k>>2]|0):0;b=+g[d+8>>2];d=b!=0.0?(g[k>>2]=1.0/b,c[k>>2]|0):0;c[a+420>>2]=f;c[a+424>>2]=e;c[a+428>>2]=d;g[a+432>>2]=0.0;i=h*+g[a+376>>2];j=h*+g[a+380>>2];g[a+584>>2]=+g[a+372>>2]*h;g[a+588>>2]=i;g[a+592>>2]=j;g[a+596>>2]=0.0;return}function vD(a,b){a=a|0;b=b|0;c[a+504>>2]=b;if(!b)return;tb[c[(c[b>>2]|0)+8>>2]&127](b,a+4|0);return}function wD(a,b){a=a|0;b=+b;c[a+284>>2]=(c[a+284>>2]|0)+1;g[a+228>>2]=b;return}function xD(a,b){a=a|0;b=+b;c[a+284>>2]=(c[a+284>>2]|0)+1;g[a+232>>2]=b;return}function yD(a,b,c){a=a|0;b=+b;c=+c;g[a+496>>2]=b;g[a+500>>2]=c;return}function zD(a,b){a=a|0;b=b|0;c[a+284>>2]=(c[a+284>>2]|0)+1;c[a+4>>2]=c[b>>2];c[a+4+4>>2]=c[b+4>>2];c[a+4+8>>2]=c[b+8>>2];c[a+4+12>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+20+4>>2]=c[b+16+4>>2];c[a+20+8>>2]=c[b+16+8>>2];c[a+20+12>>2]=c[b+16+12>>2];c[a+36>>2]=c[b+32>>2];c[a+36+4>>2]=c[b+32+4>>2];c[a+36+8>>2]=c[b+32+8>>2];c[a+36+12>>2]=c[b+32+12>>2];c[a+52>>2]=c[b+48>>2];c[a+52+4>>2]=c[b+48+4>>2];c[a+52+8>>2]=c[b+48+8>>2];c[a+52+12>>2]=c[b+48+12>>2];return}function AD(a,b){a=a|0;b=b|0;return ((c[b+236>>2]&2|0)==0?0:b)|0}function BD(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;n=+g[a+4>>2];h=+g[a+420>>2];m=+g[a+8>>2];e=+g[a+424>>2];l=+g[a+12>>2];c=+g[a+428>>2];k=+g[a+20>>2];j=+g[a+24>>2];i=+g[a+28>>2];f=+g[a+36>>2];d=+g[a+40>>2];b=+g[a+44>>2];g[a+288>>2]=n*h*n+m*e*m+l*c*l;g[a+292>>2]=n*h*k+m*e*j+l*c*i;g[a+296>>2]=n*h*f+m*e*d+l*c*b;g[a+300>>2]=0.0;g[a+304>>2]=h*k*n+e*j*m+c*i*l;g[a+308>>2]=h*k*k+e*j*j+c*i*i;g[a+312>>2]=h*k*f+e*j*d+c*i*b;g[a+316>>2]=0.0;g[a+320>>2]=h*f*n+e*d*m+c*b*l;g[a+324>>2]=h*f*k+e*d*j+c*b*i;g[a+328>>2]=h*f*f+e*d*d+c*b*b;g[a+332>>2]=0.0;return}function CD(a){a=a|0;if(!a)return;rG(a);return}function DD(a){a=a|0;return +(+g[a+80>>2])}function ED(a,b){a=a|0;b=+b;g[a+80>>2]=b;return}function FD(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function GD(){var b=0;c[5637]=(c[5637]|0)+1;b=qG(223)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}c[b>>2]=7540;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;a[b+160>>0]=1;c[b+156>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;a[b+180>>0]=1;c[b+176>>2]=0;c[b+168>>2]=0;c[b+172>>2]=0;c[b+192>>2]=13;c[b+196>>2]=14;c[b+200>>2]=0;return b|0}function HD(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function ID(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0,J=0,K=0,L=0;h=i;i=i+16|0;c[5637]=(c[5637]|0)+1;f=qG(1147)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}if(!(a[19880]|0)){a[19880]=1;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;Cr(21260,0.0,0,0,h)}c[5366]=c[5366]|1;g[5407]=0.0;z=+g[5417]*0.0;F=+g[5418]*0.0;g[5412]=+g[5416]*0.0;g[5413]=z;g[5414]=F;g[5415]=0.0;c[5420]=0;c[5421]=0;c[5422]=0;c[5423]=0;F=+g[5409]*0.0;z=+g[5410]*0.0;g[5461]=+g[5408]*0.0;g[5462]=F;g[5463]=z;g[5464]=0.0;c[f+4>>2]=7;c[f+8>>2]=-1;c[f+12>>2]=-1;g[f+16>>2]=3402823466385288598117041.0e14;a[f+20>>0]=1;a[f+21>>0]=0;c[f+24>>2]=-1;k=f+28|0;c[k>>2]=21260;j=f+32|0;c[j>>2]=b;g[f+36>>2]=0.0;g[f+40>>2]=.30000001192092896;c[f+44>>2]=0;c[f>>2]=7600;a[f+48>>0]=0;L=f+116|0;c[L>>2]=c[d>>2];c[L+4>>2]=c[d+4>>2];c[L+8>>2]=c[d+8>>2];c[L+12>>2]=c[d+12>>2];K=f+132|0;c[K>>2]=c[d+16>>2];c[K+4>>2]=c[d+16+4>>2];c[K+8>>2]=c[d+16+8>>2];c[K+12>>2]=c[d+16+12>>2];J=f+148|0;c[J>>2]=c[d+32>>2];c[J+4>>2]=c[d+32+4>>2];c[J+8>>2]=c[d+32+8>>2];c[J+12>>2]=c[d+32+12>>2];I=f+164|0;c[I>>2]=c[d+48>>2];c[I+4>>2]=c[d+48+4>>2];c[I+8>>2]=c[d+48+8>>2];c[I+12>>2]=c[d+48+12>>2];a[f+180>>0]=e&1;z=+g[L>>2];F=+g[b+4>>2];y=+g[K>>2];E=+g[b+8>>2];x=+g[J>>2];D=+g[b+12>>2];w=+g[f+120>>2];v=+g[f+136>>2];u=+g[f+152>>2];t=+g[f+124>>2];r=+g[f+140>>2];p=+g[f+156>>2];C=+g[b+20>>2];B=+g[b+24>>2];A=+g[b+28>>2];s=+g[b+36>>2];q=+g[b+40>>2];o=+g[b+44>>2];H=+g[I>>2];G=+g[f+168>>2];l=+g[f+172>>2];n=+g[b+52>>2]+(F*H+E*G+D*l);m=C*H+B*G+A*l+ +g[b+56>>2];l=s*H+q*G+o*l+ +g[b+60>>2];g[f+52>>2]=z*F+y*E+x*D;g[f+56>>2]=F*w+E*v+D*u;g[f+60>>2]=F*t+E*r+D*p;g[f+64>>2]=0.0;g[f+68>>2]=z*C+y*B+x*A;g[f+72>>2]=w*C+v*B+u*A;g[f+76>>2]=t*C+r*B+p*A;g[f+80>>2]=0.0;g[f+84>>2]=z*s+y*q+x*o;g[f+88>>2]=w*s+v*q+u*o;g[f+92>>2]=t*s+r*q+p*o;g[f+96>>2]=0.0;g[f+100>>2]=n;g[f+104>>2]=m;g[f+108>>2]=l;g[f+112>>2]=0.0;g[f+184>>2]=1.0;g[f+188>>2]=-1.0;g[f+192>>2]=0.0;g[f+196>>2]=0.0;g[f+200>>2]=1.0;g[f+204>>2]=.699999988079071;g[f+208>>2]=0.0;g[f+212>>2]=0.0;g[f+216>>2]=1.0;g[f+220>>2]=.699999988079071;g[f+224>>2]=0.0;g[f+228>>2]=0.0;g[f+264>>2]=1.0;g[f+268>>2]=.699999988079071;g[f+272>>2]=1.0;g[f+276>>2]=0.0;g[f+280>>2]=1.0;g[f+284>>2]=.699999988079071;g[f+288>>2]=1.0;g[f+292>>2]=0.0;g[f+232>>2]=1.0;g[f+236>>2]=.699999988079071;g[f+240>>2]=1.0;g[f+244>>2]=0.0;g[f+248>>2]=1.0;g[f+252>>2]=.699999988079071;g[f+256>>2]=1.0;g[f+260>>2]=0.0;a[f+1096>>0]=0;e=f+1100|0;g[f+1116>>2]=0.0;g[f+1120>>2]=0.0;g[f+1124>>2]=0.0;c[f+300>>2]=0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;a[e+12>>0]=0;a[f+49>>0]=1;rq(f,(c[k>>2]|0)+4|0,(c[j>>2]|0)+4|0);i=h;return f|0}function JD(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0;c[5637]=(c[5637]|0)+1;i=qG(1147)|0;if(!i)i=0;else{c[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}c[i+4>>2]=7;c[i+8>>2]=-1;c[i+12>>2]=-1;g[i+16>>2]=3402823466385288598117041.0e14;a[i+20>>0]=1;a[i+21>>0]=0;c[i+24>>2]=-1;j=i+28|0;c[j>>2]=b;b=i+32|0;c[b>>2]=d;g[i+36>>2]=0.0;g[i+40>>2]=.30000001192092896;c[i+44>>2]=0;c[i>>2]=7600;a[i+48>>0]=0;d=i+52|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=i+68|0;c[d>>2]=c[e+16>>2];c[d+4>>2]=c[e+16+4>>2];c[d+8>>2]=c[e+16+8>>2];c[d+12>>2]=c[e+16+12>>2];d=i+84|0;c[d>>2]=c[e+32>>2];c[d+4>>2]=c[e+32+4>>2];c[d+8>>2]=c[e+32+8>>2];c[d+12>>2]=c[e+32+12>>2];d=i+100|0;c[d>>2]=c[e+48>>2];c[d+4>>2]=c[e+48+4>>2];c[d+8>>2]=c[e+48+8>>2];c[d+12>>2]=c[e+48+12>>2];e=i+116|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=i+132|0;c[e>>2]=c[f+16>>2];c[e+4>>2]=c[f+16+4>>2];c[e+8>>2]=c[f+16+8>>2];c[e+12>>2]=c[f+16+12>>2];e=i+148|0;c[e>>2]=c[f+32>>2];c[e+4>>2]=c[f+32+4>>2];c[e+8>>2]=c[f+32+8>>2];c[e+12>>2]=c[f+32+12>>2];e=i+164|0;c[e>>2]=c[f+48>>2];c[e+4>>2]=c[f+48+4>>2];c[e+8>>2]=c[f+48+8>>2];c[e+12>>2]=c[f+48+12>>2];a[i+180>>0]=h&1;g[i+184>>2]=1.0;g[i+188>>2]=-1.0;g[i+192>>2]=0.0;g[i+196>>2]=0.0;g[i+200>>2]=1.0;g[i+204>>2]=.699999988079071;g[i+208>>2]=0.0;g[i+212>>2]=0.0;g[i+216>>2]=1.0;g[i+220>>2]=.699999988079071;g[i+224>>2]=0.0;g[i+228>>2]=0.0;g[i+264>>2]=1.0;g[i+268>>2]=.699999988079071;g[i+272>>2]=1.0;g[i+276>>2]=0.0;g[i+280>>2]=1.0;g[i+284>>2]=.699999988079071;g[i+288>>2]=1.0;g[i+292>>2]=0.0;g[i+232>>2]=1.0;g[i+236>>2]=.699999988079071;g[i+240>>2]=1.0;g[i+244>>2]=0.0;g[i+248>>2]=1.0;g[i+252>>2]=.699999988079071;g[i+256>>2]=1.0;g[i+260>>2]=0.0;a[i+1096>>0]=0;h=i+1100|0;g[i+1116>>2]=0.0;g[i+1120>>2]=0.0;g[i+1124>>2]=0.0;c[i+300>>2]=0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;a[h+12>>0]=0;a[i+49>>0]=1;rq(i,(c[j>>2]|0)+4|0,(c[b>>2]|0)+4|0);return i|0}function KD(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function LD(a){a=a|0;return +(+g[a+16>>2])}function MD(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function ND(a,b){a=a|0;b=+b;b=+oG(b);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+192>>2]=b;return}function OD(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function PD(a,b){a=a|0;b=+b;b=+oG(b);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+196>>2]=b;return}function QD(a,b){a=a|0;b=+b;g[a+188>>2]=b;return}function RD(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function SD(a){a=+a;var b=0;c[5637]=(c[5637]|0)+1;b=qG(75)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}c[b+8>>2]=0;c[b+12>>2]=-1;c[b+16>>2]=1065353216;c[b+20>>2]=1065353216;c[b+24>>2]=1065353216;g[b+28>>2]=0.0;c[b>>2]=6380;c[b+4>>2]=8;g[b+32>>2]=a;g[b+48>>2]=a;return b|0}function TD(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function UD(a){a=a|0;return +(+Hb[c[(c[a>>2]|0)+48>>2]&15](a))}function VD(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function WD(a,b){a=a|0;b=+b;qb[c[(c[a>>2]|0)+44>>2]&31](a,b);return}function XD(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function YD(a,b){a=a|0;b=+b;var d=0,e=0,f=0.0,h=0.0,i=0.0,j=0.0;c[5637]=(c[5637]|0)+1;d=qG(107)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=d+4|0;c[e>>2]=35;c[d+8>>2]=0;c[d+12>>2]=-1;g[d+16>>2]=0.0;c[d>>2]=6480;j=+g[a>>2];i=+g[a+4>>2];h=+g[a+8>>2];a=c[a+12>>2]|0;f=1.0/+O(+(j*j+i*i+h*h));g[d+52>>2]=j*f;g[d+56>>2]=i*f;g[d+60>>2]=h*f;c[d+64>>2]=a;g[d+68>>2]=b;c[d+72>>2]=1065353216;c[d+76>>2]=1065353216;c[d+80>>2]=1065353216;g[d+84>>2]=0.0;c[e>>2]=28;return d|0}function ZD(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function _D(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function $D(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function aE(a){a=a|0;if(!a)return;rG(a);return}function bE(){var a=0,b=0;while(1){a=qG(64)|0;if(a|0){b=6;break}a=c[5831]|0;c[5831]=a+0;if(!a){b=5;break}_b[a&3]()}if((b|0)==5){b=Va(4)|0;c[b>>2]=8308;hb(b|0,2416,215)}else if((b|0)==6)return a|0;return 0}function cE(a,b){a=a|0;b=b|0;var d=0,e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0;while(1){d=qG(64)|0;if(d|0){e=6;break}d=c[5831]|0;c[5831]=d+0;if(!d){e=5;break}_b[d&3]()}if((e|0)==5){b=Va(4)|0;c[b>>2]=8308;hb(b|0,2416,215)}else if((e|0)==6){j=+g[a>>2];h=+g[a+4>>2];m=+g[a+8>>2];k=+g[a+12>>2];i=j*(2.0/(j*j+h*h+m*m+k*k));f=h*(2.0/(j*j+h*h+m*m+k*k));l=m*(2.0/(j*j+h*h+m*m+k*k));g[d>>2]=1.0-(h*f+m*l);g[d+4>>2]=j*f-k*l;g[d+8>>2]=j*l+k*f;g[d+12>>2]=0.0;g[d+16>>2]=j*f+k*l;g[d+20>>2]=1.0-(j*i+m*l);g[d+24>>2]=h*l-k*i;g[d+28>>2]=0.0;g[d+32>>2]=j*l-k*f;g[d+36>>2]=h*l+k*i;g[d+40>>2]=1.0-(j*i+h*f);g[d+44>>2]=0.0;c[d+48>>2]=c[b>>2];c[d+48+4>>2]=c[b+4>>2];c[d+48+8>>2]=c[b+8>>2];c[d+48+12>>2]=c[b+12>>2];return d|0}return 0}function dE(a){a=a|0;return a|0}function eE(a){a=a|0;return a+48|0}function fE(b){b=b|0;var d=0;d=i;i=i+16|0;if(!(a[19928]|0))a[19928]=1;_f(b,d);c[5700]=c[d>>2];c[5701]=c[d+4>>2];c[5702]=c[d+8>>2];c[5703]=c[d+12>>2];i=d;return 22800}function gE(a){a=a|0;c[a>>2]=1065353216;c[a+4>>2]=0;c[a+4+4>>2]=0;c[a+4+8>>2]=0;c[a+4+12>>2]=0;c[a+20>>2]=1065353216;c[a+24>>2]=0;c[a+24+4>>2]=0;c[a+24+8>>2]=0;c[a+24+12>>2]=0;c[a+40>>2]=1065353216;c[a+44>>2]=0;c[a+44+4>>2]=0;c[a+44+8>>2]=0;c[a+44+12>>2]=0;c[a+44+16>>2]=0;return}function hE(a,b){a=a|0;b=b|0;c[a+48>>2]=c[b>>2];c[a+48+4>>2]=c[b+4>>2];c[a+48+8>>2]=c[b+8>>2];c[a+48+12>>2]=c[b+12>>2];return}function iE(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;f=+g[b>>2];d=+g[b+4>>2];j=+g[b+8>>2];h=+g[b+12>>2];e=f*(2.0/(f*f+d*d+j*j+h*h));c=d*(2.0/(f*f+d*d+j*j+h*h));i=j*(2.0/(f*f+d*d+j*j+h*h));g[a>>2]=1.0-(d*c+j*i);g[a+4>>2]=f*c-h*i;g[a+8>>2]=f*i+h*c;g[a+12>>2]=0.0;g[a+16>>2]=f*c+h*i;g[a+20>>2]=1.0-(f*e+j*i);g[a+24>>2]=d*i-h*e;g[a+28>>2]=0.0;g[a+32>>2]=f*i-h*c;g[a+36>>2]=d*i+h*e;g[a+40>>2]=1.0-(f*e+d*c);g[a+44>>2]=0.0;return}function jE(a){a=a|0;if(!a)return;rG(a);return}function kE(a){a=a|0;return a+260|0}function lE(a,b){a=a|0;b=b|0;c[a+260>>2]=c[b>>2];c[a+260+4>>2]=c[b+4>>2];c[a+260+8>>2]=c[b+8>>2];c[a+260+12>>2]=c[b+12>>2];return}function mE(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function nE(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function oE(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function pE(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function qE(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=c[a+32>>2]|0;c[f>>2]=(c[f>>2]|0)+1;an(a,bn(a,b,0)|0);an(a,bn(a,d,0)|0);an(a,bn(a,e,0)|0);return}function rE(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0;g=c[a+32>>2]|0;c[g>>2]=(c[g>>2]|0)+1;an(a,bn(a,b,f)|0);an(a,bn(a,d,f)|0);an(a,bn(a,e,f)|0);return}function sE(){var a=0;c[5637]=(c[5637]|0)+1;a=qG(191)|0;if(!a)a=0;else{c[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16}$m(a,1,1);return a|0}function tE(a){a=a|0;var b=0;c[5637]=(c[5637]|0)+1;b=qG(191)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}$m(b,a,1);return b|0}function uE(a,b){a=a|0;b=b|0;var d=0;c[5637]=(c[5637]|0)+1;d=qG(191)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}$m(d,a,b);return d|0}function vE(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function wE(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function xE(a){a=a|0;return +(+g[a+16>>2])}function yE(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function zE(a){a=a|0;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function AE(){var a=0;c[5637]=(c[5637]|0)+1;a=qG(35)|0;if(!a){a=0;return a|0}c[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16;return a|0}function BE(a,b,d){a=+a;b=+b;d=+d;var e=0;c[5637]=(c[5637]|0)+1;e=qG(35)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}g[e>>2]=a;g[e+4>>2]=b;g[e+8>>2]=d;g[e+12>>2]=0.0;return e|0}function CE(a,b){a=a|0;b=b|0;return +(+g[a>>2]*+g[b>>2]+ +g[a+4>>2]*+g[b+4>>2]+ +g[a+8>>2]*+g[b+8>>2])}function DE(a){a=a|0;var b=0.0,c=0.0,d=0.0;d=+g[a>>2];c=+g[a+4>>2];b=+g[a+8>>2];return +(+O(+(d*d+c*c+b*b)))}function EE(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0.0;e=+g[a>>2];d=+g[a+4>>2];c=+g[a+8>>2];b=1.0/+O(+(e*e+d*d+c*c));g[a>>2]=e*b;g[a+4>>2]=d*b;g[a+8>>2]=c*b;return}function FE(a,b){a=a|0;b=b|0;g[a>>2]=+g[b>>2]+ +g[a>>2];g[a+4>>2]=+g[b+4>>2]+ +g[a+4>>2];g[a+8>>2]=+g[b+8>>2]+ +g[a+8>>2];return a|0}function GE(a,b){a=a|0;b=+b;g[a>>2]=+g[a>>2]*b;g[a+4>>2]=+g[a+4>>2]*b;g[a+8>>2]=+g[a+8>>2]*b;return a|0}function HE(a,b){a=a|0;b=b|0;g[a>>2]=+g[a>>2]-+g[b>>2];g[a+4>>2]=+g[a+4>>2]-+g[b+4>>2];g[a+8>>2]=+g[a+8>>2]-+g[b+8>>2];return a|0}function IE(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=0.0;return}function JE(a,b){a=a|0;b=+b;g[a>>2]=b;return}function KE(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function LE(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function ME(a){a=a|0;return +(+g[a>>2])}function NE(a){a=a|0;return +(+g[a+4>>2])}function OE(a){a=a|0;return +(+g[a+8>>2])}function PE(a){a=a|0;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function QE(){var a=0;c[5637]=(c[5637]|0)+1;a=qG(35)|0;if(!a){a=0;return a|0}c[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16;return a|0}function RE(a,b,d,e){a=+a;b=+b;d=+d;e=+e;var f=0;c[5637]=(c[5637]|0)+1;f=qG(35)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}g[f>>2]=a;g[f+4>>2]=b;g[f+8>>2]=d;g[f+12>>2]=e;return f|0}function SE(a,b){a=a|0;b=b|0;return +(+g[a>>2]*+g[b>>2]+ +g[a+4>>2]*+g[b+4>>2]+ +g[a+8>>2]*+g[b+8>>2])}function TE(a){a=a|0;var b=0.0,c=0.0,d=0.0;d=+g[a>>2];c=+g[a+4>>2];b=+g[a+8>>2];return +(+O(+(d*d+c*c+b*b)))}function UE(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0.0;e=+g[a>>2];d=+g[a+4>>2];c=+g[a+8>>2];b=1.0/+O(+(e*e+d*d+c*c));g[a>>2]=e*b;g[a+4>>2]=d*b;g[a+8>>2]=c*b;return}function VE(a,b){a=a|0;b=b|0;g[a>>2]=+g[b>>2]+ +g[a>>2];g[a+4>>2]=+g[b+4>>2]+ +g[a+4>>2];g[a+8>>2]=+g[b+8>>2]+ +g[a+8>>2];return a|0}function WE(a,b){a=a|0;b=+b;g[a>>2]=+g[a>>2]*b;g[a+4>>2]=+g[a+4>>2]*b;g[a+8>>2]=+g[a+8>>2]*b;return a|0}function XE(a,b){a=a|0;b=b|0;g[a>>2]=+g[a>>2]-+g[b>>2];g[a+4>>2]=+g[a+4>>2]-+g[b+4>>2];g[a+8>>2]=+g[a+8>>2]-+g[b+8>>2];return a|0}function YE(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=e;return}function ZE(a,b){a=a|0;b=+b;g[a>>2]=b;return}function _E(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function $E(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function aF(a){a=a|0;return +(+g[a+12>>2])}function bF(a){a=a|0;return +(+g[a>>2])}function cF(a){a=a|0;return +(+g[a+4>>2])}function dF(a){a=a|0;return +(+g[a+8>>2])}function eF(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function fF(){var a=0,b=0;while(1){a=qG(24)|0;if(a|0){b=6;break}a=c[5831]|0;c[5831]=a+0;if(!a){b=5;break}_b[a&3]()}if((b|0)==5){b=Va(4)|0;c[b>>2]=8308;hb(b|0,2416,215)}else if((b|0)==6){g[a>>2]=5.880000114440918;g[a+4>>2]=.8299999833106995;g[a+8>>2]=.8799999952316284;g[a+12>>2]=500.0;g[a+16>>2]=10.5;g[a+20>>2]=6.0e3;return a|0}return 0}function gF(a){a=a|0;return +(+g[a+16>>2])}function hF(a){a=a|0;return +(+g[a+20>>2])}function iF(a){a=a|0;return +(+g[a+12>>2])}function jF(a){a=a|0;return +(+g[a+4>>2])}function kF(a){a=a|0;return +(+g[a+8>>2])}function lF(a){a=a|0;return +(+g[a>>2])}function mF(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function nF(a,b){a=a|0;b=+b;g[a+20>>2]=b;return}function oF(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function pF(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function qF(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function rF(a,b){a=a|0;b=+b;g[a>>2]=b;return}function sF(a){a=a|0;if(!a)return;rG(a);return}function tF(b){b=b|0;return (a[b+260>>0]|0)!=0|0}function uF(a){a=a|0;return a+156|0}function vF(a){a=a|0;return +(+g[a+252>>2])}function wF(a){a=a|0;return +(+g[a+228>>2])}function xF(a){a=a|0;return +(+g[a+248>>2])}function yF(a){a=a|0;return +(+g[a+208>>2])}function zF(a){a=a|0;return a|0}function AF(a){a=a|0;return +(+g[a+244>>2])}function BF(a){a=a|0;return +(+g[a+232>>2])}function CF(a){a=a|0;return +(+g[a+204>>2])}function DF(a){a=a|0;return +(+g[a+216>>2])}function EF(a){a=a|0;return +(+g[a+220>>2])}function FF(a){a=a|0;return +(+g[a+224>>2])}function GF(a){a=a|0;return +(+g[a+212>>2])}function HF(a){a=a|0;return +(+g[a+276>>2])}function IF(b,c){b=b|0;c=c|0;a[b+260>>0]=c&1;return}function JF(a,b){a=a|0;b=b|0;c[a+156>>2]=c[b>>2];c[a+156+4>>2]=c[b+4>>2];c[a+156+8>>2]=c[b+8>>2];c[a+156+12>>2]=c[b+12>>2];return}function KF(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function LF(a,b){a=a|0;b=+b;g[a+228>>2]=b;return}function MF(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function NF(a,b){a=a|0;b=+b;g[a+208>>2]=b;return}function OF(a,b){a=a|0;b=b|0;var d=0;d=a+92|0;do{c[a>>2]=c[b>>2];a=a+4|0;b=b+4|0}while((a|0)<(d|0));return}function PF(a,b){a=a|0;b=+b;g[a+244>>2]=b;return}function QF(a,b){a=a|0;b=+b;g[a+232>>2]=b;return}function RF(a,b){a=a|0;b=+b;g[a+204>>2]=b;return}function SF(a,b){a=a|0;b=+b;g[a+216>>2]=b;return}function TF(a,b){a=a|0;b=+b;g[a+220>>2]=b;return}function UF(a,b){a=a|0;b=+b;g[a+224>>2]=b;return}function VF(a,b){a=a|0;b=+b;g[a+212>>2]=b;return}function WF(a,b){a=a|0;b=+b;g[a+276>>2]=b;return}function XF(){return 0}function YF(){return 1}function ZF(){return 2}function _F(){return 3}function $F(){return 4}function aG(){return 5}function bG(a){a=a|0;var b=0,d=0;d=i;i=i+16|0;c[d>>2]=c[a+60>>2];a=ib(6,d|0)|0;if(a>>>0>4294963200){if(!0)b=22816;else b=c[(eH()|0)+64>>2]|0;c[b>>2]=0-a;a=-1}i=d;return a|0}function cG(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;k=i;i=i+48|0;g=c[a+28>>2]|0;c[k+32>>2]=g;g=(c[a+20>>2]|0)-g|0;c[k+32+4>>2]=g;c[k+32+8>>2]=b;c[k+32+12>>2]=d;j=k+32|0;f=2;g=g+d|0;while(1){if(!0){c[k+16>>2]=c[a+60>>2];c[k+16+4>>2]=j;c[k+16+8>>2]=f;b=nb(146,k+16|0)|0;if(b>>>0>4294963200){if(!0)e=22816;else e=c[(eH()|0)+64>>2]|0;c[e>>2]=0-b;b=-1}}else{jb(218,a|0);c[k>>2]=c[a+60>>2];c[k+4>>2]=j;c[k+8>>2]=f;b=nb(146,k|0)|0;if(b>>>0>4294963200){if(!0)e=22816;else e=c[(eH()|0)+64>>2]|0;c[e>>2]=0-b;b=-1}Sa(0)}if((g|0)==(b|0)){b=13;break}if((b|0)<0){b=15;break}g=g-b|0;e=c[j+4>>2]|0;if(b>>>0<=e>>>0)if((f|0)==2){c[a+28>>2]=(c[a+28>>2]|0)+b;h=e;e=j;f=2}else{h=e;e=j}else{h=c[a+44>>2]|0;c[a+28>>2]=h;c[a+20>>2]=h;h=c[j+12>>2]|0;b=b-e|0;e=j+8|0;f=f+-1|0}c[e>>2]=(c[e>>2]|0)+b;c[e+4>>2]=h-b;j=e}if((b|0)==13){j=c[a+44>>2]|0;c[a+16>>2]=j+(c[a+48>>2]|0);c[a+28>>2]=j;c[a+20>>2]=j}else if((b|0)==15){c[a+16>>2]=0;c[a+28>>2]=0;c[a+20>>2]=0;c[a>>2]=c[a>>2]|32;if((f|0)==2)d=0;else d=d-(c[j+4>>2]|0)|0}i=k;return d|0}function dG(a){a=a|0;return}function eG(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=i;i=i+32|0;c[f>>2]=c[a+60>>2];c[f+4>>2]=0;c[f+8>>2]=b;c[f+12>>2]=f+20;c[f+16>>2]=d;b=lb(140,f|0)|0;if(b>>>0<=4294963200)if((b|0)<0)e=7;else a=c[f+20>>2]|0;else{if(!0)a=22816;else a=c[(eH()|0)+64>>2]|0;c[a>>2]=0-b;e=7}if((e|0)==7){c[f+20>>2]=-1;a=-1}i=f;return a|0}function fG(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;a:do if((e|0)!=0&(b&3|0)!=0){f=e;while(1){if((a[b>>0]|0)==(d&255)<<24>>24)break a;b=b+1|0;e=f+-1|0;if((e|0)!=0&(b&3|0)!=0)f=e;else{f=e;e=(e|0)!=0;g=5;break}}}else{f=e;e=(e|0)!=0;g=5}while(0);b:do if((g|0)==5)if(e){if((a[b>>0]|0)!=(d&255)<<24>>24){e=_(d&255,16843009)|0;c:do if(f>>>0>3)while(1){h=c[b>>2]^e;if((h&-2139062144^-2139062144)&h+-16843009|0)break;b=b+4|0;f=f+-4|0;if(f>>>0<=3){g=11;break c}}else g=11;while(0);if((g|0)==11)if(!f){f=0;break}while(1){if((a[b>>0]|0)==(d&255)<<24>>24)break b;b=b+1|0;f=f+-1|0;if(!f){f=0;break}}}}else f=0;while(0);return (f|0?b:0)|0}function gG(e,f,g,j,l){e=e|0;f=f|0;g=g|0;j=j|0;l=l|0;var m=0,n=0,o=0,p=0.0,q=0,r=0,s=0.0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0;O=i;i=i+624|0;K=O+536+40|0;M=O+588|0;N=O+576+12|0;L=O+588+9|0;m=0;n=0;r=0;w=f;a:while(1){do if((m|0)>-1){if((n|0)<=(2147483647-m|0)){m=n+m|0;break}if(!0)m=22816;else m=c[(eH()|0)+64>>2]|0;c[m>>2]=75;m=-1}while(0);f=a[w>>0]|0;if(!(f<<24>>24)){J=254;break}else n=w;b:while(1){switch(f<<24>>24){case 37:{f=n;J=11;break b}case 0:{f=n;break b}default:{}}I=n+1|0;f=a[I>>0]|0;n=I}c:do if((J|0)==11)while(1){J=0;if((a[f+1>>0]|0)!=37)break c;n=n+1|0;f=f+2|0;if((a[f>>0]|0)==37)J=11;else break}while(0);v=n-w|0;if(e|0?(c[e>>2]&32|0)==0:0)hG(w,v,e);if((n|0)!=(w|0)){n=v;w=f;continue}o=f+1|0;n=a[o>>0]|0;if(((n<<24>>24)+-48|0)>>>0<10){I=(a[f+2>>0]|0)==36;o=I?f+3|0:o;q=a[o>>0]|0;u=I?(n<<24>>24)+-48|0:-1;r=I?1:r}else{q=n;u=-1}f=q<<24>>24;d:do if((f&-32|0)==32){n=q;q=0;do{if(!(1<<f+-32&75913))break d;q=1<<(n<<24>>24)+-32|q;o=o+1|0;n=a[o>>0]|0;f=n<<24>>24}while((f&-32|0)==32)}else{n=q;q=0}while(0);do if(n<<24>>24==42){n=o+1|0;f=(a[n>>0]|0)+-48|0;if(f>>>0<10?(a[o+2>>0]|0)==36:0){c[l+(f<<2)>>2]=10;f=1;o=o+3|0;n=c[j+((a[n>>0]|0)+-48<<3)>>2]|0}else{if(r|0){m=-1;break a}if(!e){t=q;I=0;o=n;H=0;break}f=(c[g>>2]|0)+(4-1)&~(4-1);I=c[f>>2]|0;c[g>>2]=f+4;f=0;o=n;n=I}if((n|0)<0){t=q|8192;I=f;H=0-n|0}else{t=q;I=f;H=n}}else{f=(n<<24>>24)+-48|0;if(f>>>0<10){n=0;do{n=(n*10|0)+f|0;o=o+1|0;f=(a[o>>0]|0)+-48|0}while(f>>>0<10);if((n|0)<0){m=-1;break a}else{t=q;I=r;H=n}}else{t=q;I=r;H=0}}while(0);e:do if((a[o>>0]|0)==46){f=o+1|0;q=a[f>>0]|0;if(q<<24>>24!=42){if(((q<<24>>24)+-48|0)>>>0<10){n=0;o=(q<<24>>24)+-48|0}else{r=0;break}while(1){n=(n*10|0)+o|0;f=f+1|0;o=(a[f>>0]|0)+-48|0;if(o>>>0>=10){r=n;break e}}}f=o+2|0;n=(a[f>>0]|0)+-48|0;if(n>>>0<10?(a[o+3>>0]|0)==36:0){c[l+(n<<2)>>2]=10;r=c[j+((a[f>>0]|0)+-48<<3)>>2]|0;f=o+4|0;break}if(I|0){m=-1;break a}if(e|0){G=(c[g>>2]|0)+(4-1)&~(4-1);r=c[G>>2]|0;c[g>>2]=G+4}else r=0}else{r=-1;f=o}while(0);q=0;while(1){n=(a[f>>0]|0)+-65|0;if(n>>>0>57){m=-1;break a}G=f+1|0;n=a[16811+(q*58|0)+n>>0]|0;if(((n&255)+-1|0)>>>0<8){f=G;q=n&255}else break}if(!(n<<24>>24)){m=-1;break}o=(u|0)>-1;do if(n<<24>>24==19)if(o){m=-1;break a}else J=54;else{if(o){c[l+(u<<2)>>2]=n&255;F=j+(u<<3)|0;J=c[F+4>>2]|0;c[O>>2]=c[F>>2];c[O+4>>2]=J;J=54;break}if(!e){m=0;break a}jG(O,n&255,g)}while(0);if((J|0)==54?(J=0,(e|0)==0):0){n=v;r=I;w=G;continue}E=a[f>>0]|0;E=(q|0)!=0&(E&15|0)==3?E&-33:E;o=t&-65537;F=(t&8192|0)==0?t:o;f:do switch(E|0){case 110:switch(q|0){case 0:{c[c[O>>2]>>2]=m;n=v;r=I;w=G;continue a}case 1:{c[c[O>>2]>>2]=m;n=v;r=I;w=G;continue a}case 2:{n=c[O>>2]|0;c[n>>2]=m;c[n+4>>2]=((m|0)<0)<<31>>31;n=v;r=I;w=G;continue a}case 3:{b[c[O>>2]>>1]=m;n=v;r=I;w=G;continue a}case 4:{a[c[O>>2]>>0]=m;n=v;r=I;w=G;continue a}case 6:{c[c[O>>2]>>2]=m;n=v;r=I;w=G;continue a}case 7:{n=c[O>>2]|0;c[n>>2]=m;c[n+4>>2]=((m|0)<0)<<31>>31;n=v;r=I;w=G;continue a}default:{n=v;r=I;w=G;continue a}}case 112:{t=F|8;r=r>>>0>8?r:8;u=120;J=66;break}case 88:case 120:{t=F;u=E;J=66;break}case 111:{n=c[O>>2]|0;o=c[O+4>>2]|0;if((n|0)==0&(o|0)==0)f=K;else{f=K;do{f=f+-1|0;a[f>>0]=n&7|48;n=aH(n|0,o|0,3)|0;o=C}while(!((n|0)==0&(o|0)==0))}if(!(F&8)){n=F;t=0;q=17291;J=79}else{t=K-f|0;n=F;r=(r|0)>(t|0)?r:t+1|0;t=0;q=17291;J=79}break}case 105:case 100:{f=c[O>>2]|0;n=c[O+4>>2]|0;if((n|0)<0){f=XG(0,0,f|0,n|0)|0;n=C;c[O>>2]=f;c[O+4>>2]=n;o=1;q=17291;J=78;break f}if(!(F&2048)){o=F&1;q=(F&1|0)==0?17291:17293;J=78}else{o=1;q=17292;J=78}break}case 117:{f=c[O>>2]|0;n=c[O+4>>2]|0;o=0;q=17291;J=78;break}case 99:{a[O+536+39>>0]=c[O>>2];f=O+536+39|0;u=1;w=0;v=17291;n=K;break}case 109:{if(!0)f=22816;else f=c[(eH()|0)+64>>2]|0;n=c[f>>2]|0;f=0;while(1){if((d[17301+f>>0]|0)==(n|0)){J=85;break}f=f+1|0;if((f|0)==87){n=87;f=17389;break}}if((J|0)==85)if(!f){n=17389;J=92;break f}else{n=f;f=17389}do{do{J=f;f=f+1|0}while((a[J>>0]|0)!=0);n=n+-1|0}while((n|0)!=0);n=f;J=92;break}case 115:{n=c[O>>2]|0;n=n|0?n:19193;J=92;break}case 67:{c[O+8>>2]=c[O>>2];c[O+8+4>>2]=0;c[O>>2]=O+8;f=O+8|0;r=-1;J=96;break}case 83:{f=c[O>>2]|0;if(!r){lG(e,32,H,0,F);f=0;J=107}else J=96;break}case 65:case 71:case 70:case 69:case 97:case 103:case 102:case 101:{p=+h[O>>3];c[O+16>>2]=0;h[k>>3]=p;if((c[k+4>>2]|0)>=0)if(!(F&2048)){B=F&1;D=(F&1|0)==0?19201:19206}else{B=1;D=19203}else{p=-p;B=1;D=19200}h[k>>3]=p;A=c[k+4>>2]&2146435072;do if(A>>>0<2146435072|(A|0)==2146435072&0<0){p=+nG(p,O+16|0)*2.0;if(p!=0.0)c[O+16>>2]=(c[O+16>>2]|0)+-1;if((E|32|0)==97){u=(E&32|0)==0?D:D+9|0;t=B|2;f=12-r|0;do if(!(r>>>0>11|(f|0)==0)){s=8.0;do{f=f+-1|0;s=s*16.0}while((f|0)!=0);if((a[u>>0]|0)==45){p=-(s+(-p-s));break}else{p=p+s-s;break}}while(0);n=c[O+16>>2]|0;f=(n|0)<0?0-n|0:n;f=kG(f,((f|0)<0)<<31>>31,O+576+12|0)|0;if((f|0)==(O+576+12|0)){a[O+576+11>>0]=48;f=O+576+11|0}a[f+-1>>0]=(n>>31&2)+43;q=f+-2|0;a[q>>0]=E+15;o=(r|0)<1;f=O+588|0;while(1){D=~~p;n=f+1|0;a[f>>0]=d[17275+D>>0]|E&32;p=(p-+(D|0))*16.0;do if((n-M|0)==1){if((F&8|0)==0&(o&p==0.0))break;a[n>>0]=46;n=f+2|0}while(0);if(!(p!=0.0))break;else f=n}f=(r|0)!=0&(-2-M+n|0)<(r|0)?N+2+r-q|0:N-M-q+n|0;lG(e,32,H,f+t|0,F);if(!(c[e>>2]&32))hG(u,t,e);lG(e,48,H,f+t|0,F^65536);if(!(c[e>>2]&32))hG(O+588|0,n-M|0,e);lG(e,48,f-(n-M+(N-q))|0,0,0);if(!(c[e>>2]&32))hG(q,N-q|0,e);lG(e,32,H,f+t|0,F^8192);f=(f+t|0)<(H|0)?H:f+t|0;break}f=(r|0)<0?6:r;if(p!=0.0){n=(c[O+16>>2]|0)+-28|0;c[O+16>>2]=n;p=p*268435456.0}else n=c[O+16>>2]|0;A=(n|0)<0?O+24|0:O+24+288|0;q=A;do{z=~~p>>>0;c[q>>2]=z;q=q+4|0;p=(p-+(z>>>0))*1.0e9}while(p!=0.0);n=c[O+16>>2]|0;if((n|0)>0){o=A;do{t=(n|0)>29?29:n;n=q+-4|0;do if(n>>>0>=o>>>0){r=0;do{y=_G(c[n>>2]|0,0,t|0)|0;y=YG(y|0,C|0,r|0,0)|0;z=C;x=lH(y|0,z|0,1e9,0)|0;c[n>>2]=x;r=kH(y|0,z|0,1e9,0)|0;n=n+-4|0}while(n>>>0>=o>>>0);if(!r)break;o=o+-4|0;c[o>>2]=r}while(0);while(1){if(q>>>0<=o>>>0)break;n=q+-4|0;if(!(c[n>>2]|0))q=n;else break}n=(c[O+16>>2]|0)-t|0;c[O+16>>2]=n}while((n|0)>0)}else o=A;if((n|0)<0){do{t=0-n|0;t=(t|0)>9?9:t;do if(o>>>0<q>>>0){r=0;n=o;do{z=c[n>>2]|0;c[n>>2]=(z>>>t)+r;r=_(z&(1<<t)+-1,1e9>>>t)|0;n=n+4|0}while(n>>>0<q>>>0);n=(c[o>>2]|0)==0?o+4|0:o;if(!r){o=n;n=q;break}c[q>>2]=r;o=n;n=q+4|0}else{o=(c[o>>2]|0)==0?o+4|0:o;n=q}while(0);q=(E|32|0)==102?A:o;q=(n-q>>2|0)>(((f+25|0)/9|0)+1|0)?q+(((f+25|0)/9|0)+1<<2)|0:n;n=(c[O+16>>2]|0)+t|0;c[O+16>>2]=n}while((n|0)<0);n=o}else n=o;do if(n>>>0<q>>>0){o=(A-n>>2)*9|0;t=c[n>>2]|0;if(t>>>0<10)break;else r=10;do{r=r*10|0;o=o+1|0}while(t>>>0>=r>>>0)}else o=0;while(0);r=f-((E|32|0)!=102?o:0)+(((f|0)!=0&(E|32|0)==103)<<31>>31)|0;if((r|0)<(((q-A>>2)*9|0)+-9|0)){x=A+4+(((r+9216|0)/9|0)+-1024<<2)|0;if((((r+9216|0)%9|0)+1|0)<9){t=10;u=((r+9216|0)%9|0)+1|0;while(1){r=t*10|0;u=u+1|0;if((u|0)==9)break;else t=r}}else r=10;v=c[x>>2]|0;w=(v>>>0)%(r>>>0)|0;t=(x+4|0)==(q|0);do if(t&(w|0)==0)r=x;else{s=(((v>>>0)/(r>>>0)|0)&1|0)==0?9007199254740992.0:9007199254740994.0;u=(r|0)/2|0;if(w>>>0<u>>>0)p=.5;else p=t&(w|0)==(u|0)?1.0:1.5;do if(B){if((a[D>>0]|0)!=45)break;s=-s;p=-p}while(0);c[x>>2]=v-w;if(!(s+p!=s)){r=x;break}z=v-w+r|0;c[x>>2]=z;if(z>>>0>999999999){o=x;while(1){r=o+-4|0;c[o>>2]=0;if(r>>>0<n>>>0){n=n+-4|0;c[n>>2]=0}z=(c[r>>2]|0)+1|0;c[r>>2]=z;if(z>>>0>999999999)o=r;else break}}else r=x;o=(A-n>>2)*9|0;u=c[n>>2]|0;if(u>>>0<10)break;else t=10;do{t=t*10|0;o=o+1|0}while(u>>>0>=t>>>0)}while(0);y=r+4|0;z=n;n=q>>>0>y>>>0?y:q}else{z=n;n=q}u=0-o|0;y=n;while(1){if(y>>>0<=z>>>0){w=0;break}n=y+-4|0;if(!(c[n>>2]|0))y=n;else{w=1;break}}do if((E|32|0)==103){if((((f|0)!=0^1)+f|0)>(o|0)&(o|0)>-5){t=E+-1|0;f=((f|0)!=0^1)+f+-1-o|0}else{t=E+-2|0;f=((f|0)!=0^1)+f+-1|0}if(F&8|0){r=F&8;break}do if(w){n=c[y+-4>>2]|0;if(!n){q=9;break}if(!((n>>>0)%10|0)){r=10;q=0}else{q=0;break}do{r=r*10|0;q=q+1|0}while(!((n>>>0)%(r>>>0)|0|0))}else q=9;while(0);n=((y-A>>2)*9|0)+-9|0;if((t|32|0)==102){r=n-q|0;r=(r|0)<0?0:r;f=(f|0)<(r|0)?f:r;r=0;break}else{r=n+o-q|0;r=(r|0)<0?0:r;f=(f|0)<(r|0)?f:r;r=0;break}}else{t=E;r=F&8}while(0);v=f|r;q=(t|32|0)==102;if(q){n=(o|0)>0?o:0;u=0}else{n=(o|0)<0?u:o;n=kG(n,((n|0)<0)<<31>>31,O+576+12|0)|0;if((N-n|0)<2)do{n=n+-1|0;a[n>>0]=48}while((N-n|0)<2);a[n+-1>>0]=(o>>31&2)+43;u=n+-2|0;a[u>>0]=t;n=N-u|0}x=B+1+f+((v|0)!=0&1)+n|0;lG(e,32,H,x,F);if(!(c[e>>2]&32))hG(D,B,e);lG(e,48,H,x,F^65536);do if(q){q=z>>>0>A>>>0?A:z;o=q;do{n=kG(c[o>>2]|0,0,L)|0;do if((o|0)==(q|0)){if((n|0)!=(L|0))break;a[O+588+8>>0]=48;n=O+588+8|0}else{if(n>>>0<=(O+588|0)>>>0)break;ZG(O+588|0,48,n-M|0)|0;do n=n+-1|0;while(n>>>0>(O+588|0)>>>0)}while(0);if(!(c[e>>2]&32))hG(n,L-n|0,e);o=o+4|0}while(o>>>0<=A>>>0);do if(v|0){if(c[e>>2]&32|0)break;hG(19235,1,e)}while(0);if((f|0)>0&o>>>0<y>>>0)while(1){n=kG(c[o>>2]|0,0,L)|0;if(n>>>0>(O+588|0)>>>0){ZG(O+588|0,48,n-M|0)|0;do n=n+-1|0;while(n>>>0>(O+588|0)>>>0)}if(!(c[e>>2]&32))hG(n,(f|0)>9?9:f,e);o=o+4|0;n=f+-9|0;if(!((f|0)>9&o>>>0<y>>>0)){f=n;break}else f=n}lG(e,48,f+9|0,9,0)}else{t=w?y:z+4|0;if((f|0)>-1){r=(r|0)==0;q=z;do{n=kG(c[q>>2]|0,0,L)|0;if((n|0)==(L|0)){a[O+588+8>>0]=48;n=O+588+8|0}do if((q|0)==(z|0)){o=n+1|0;if(!(c[e>>2]&32))hG(n,1,e);if(r&(f|0)<1){n=o;break}if(c[e>>2]&32|0){n=o;break}hG(19235,1,e);n=o}else{if(n>>>0<=(O+588|0)>>>0)break;ZG(O+588|0,48,n+(0-M)|0)|0;do n=n+-1|0;while(n>>>0>(O+588|0)>>>0)}while(0);o=L-n|0;if(!(c[e>>2]&32))hG(n,(f|0)>(o|0)?o:f,e);f=f-o|0;q=q+4|0}while(q>>>0<t>>>0&(f|0)>-1)}lG(e,48,f+18|0,18,0);if(c[e>>2]&32|0)break;hG(u,N-u|0,e)}while(0);lG(e,32,H,x,F^8192);f=(x|0)<(H|0)?H:x}else{q=p!=p|0.0!=0.0;n=q?0:B;lG(e,32,H,n+3|0,o);f=c[e>>2]|0;if(!(f&32)){hG(D,n,e);f=c[e>>2]|0}if(!(f&32))hG(q?(E&32|0?19227:19231):E&32|0?19219:19223,3,e);lG(e,32,H,n+3|0,F^8192);f=(n+3|0)<(H|0)?H:n+3|0}while(0);n=f;r=I;w=G;continue a}default:{f=w;o=F;u=r;w=0;v=17291;n=K}}while(0);g:do if((J|0)==66){n=c[O>>2]|0;o=c[O+4>>2]|0;q=u&32;if(!((n|0)==0&(o|0)==0)){f=K;do{f=f+-1|0;a[f>>0]=d[17275+(n&15)>>0]|q;n=aH(n|0,o|0,4)|0;o=C}while(!((n|0)==0&(o|0)==0));if((t&8|0)==0|(c[O>>2]|0)==0&(c[O+4>>2]|0)==0){n=t;t=0;q=17291;J=79}else{n=t;t=2;q=17291+(u>>4)|0;J=79}}else{f=K;n=t;t=0;q=17291;J=79}}else if((J|0)==78){f=kG(f,n,K)|0;n=F;t=o;J=79}else if((J|0)==92){J=0;F=fG(n,0,r)|0;f=n;u=(F|0)==0?r:F-n|0;w=0;v=17291;n=(F|0)==0?n+r|0:F}else if((J|0)==96){J=0;o=0;n=0;t=f;while(1){q=c[t>>2]|0;if(!q)break;n=mG(O+528|0,q)|0;if((n|0)<0|n>>>0>(r-o|0)>>>0)break;o=n+o|0;if(r>>>0>o>>>0)t=t+4|0;else break}if((n|0)<0){m=-1;break a}lG(e,32,H,o,F);if(!o){f=0;J=107}else{q=0;while(1){n=c[f>>2]|0;if(!n){f=o;J=107;break g}n=mG(O+528|0,n)|0;q=n+q|0;if((q|0)>(o|0)){f=o;J=107;break g}if(!(c[e>>2]&32))hG(O+528|0,n,e);if(q>>>0>=o>>>0){f=o;J=107;break}else f=f+4|0}}}while(0);if((J|0)==107){J=0;lG(e,32,H,f,F^8192);n=(H|0)>(f|0)?H:f;r=I;w=G;continue}if((J|0)==79){J=0;o=(r|0)>-1?n&-65537:n;n=(c[O>>2]|0)!=0|(c[O+4>>2]|0)!=0;if((r|0)!=0|n){u=(n&1^1)+(K-f)|0;u=(r|0)>(u|0)?r:u;w=t;v=q;n=K}else{f=K;u=0;w=t;v=q;n=K}}t=n-f|0;q=(u|0)<(t|0)?t:u;r=w+q|0;n=(H|0)<(r|0)?r:H;lG(e,32,n,r,o);if(!(c[e>>2]&32))hG(v,w,e);lG(e,48,n,r,o^65536);lG(e,48,q,t,0);if(!(c[e>>2]&32))hG(f,t,e);lG(e,32,n,r,o^8192);r=I;w=G}h:do if((J|0)==254)if(!e)if(!r)m=0;else{m=1;while(1){f=c[l+(m<<2)>>2]|0;if(!f){f=0;break}jG(j+(m<<3)|0,f,g);m=m+1|0;if((m|0)>=10){m=1;break h}}while(1){m=m+1|0;if(f|0){m=-1;break h}if((m|0)>=10){m=1;break h}f=c[l+(m<<2)>>2]|0}}while(0);i=O;return m|0}function hG(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=c[e+16>>2]|0;if(!f){if(!(iG(e)|0)){g=c[e+16>>2]|0;h=5}}else{g=f;h=5}a:do if((h|0)==5){f=c[e+20>>2]|0;if((g-f|0)>>>0<d>>>0){Eb[c[e+36>>2]&63](e,b,d)|0;break}b:do if((a[e+75>>0]|0)>-1){h=d;while(1){if(!h){g=d;break b}g=h+-1|0;if((a[b+g>>0]|0)==10)break;else h=g}if((Eb[c[e+36>>2]&63](e,b,h)|0)>>>0<h>>>0)break a;g=d-h|0;b=b+h|0;f=c[e+20>>2]|0}else g=d;while(0);bH(f|0,b|0,g|0)|0;c[e+20>>2]=(c[e+20>>2]|0)+g}while(0);return}function iG(b){b=b|0;var d=0;d=a[b+74>>0]|0;a[b+74>>0]=d+255|d;d=c[b>>2]|0;if(!(d&8)){c[b+8>>2]=0;c[b+4>>2]=0;d=c[b+44>>2]|0;c[b+28>>2]=d;c[b+20>>2]=d;c[b+16>>2]=d+(c[b+48>>2]|0);d=0}else{c[b>>2]=d|32;d=-1}return d|0}function jG(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0.0;a:do if(b>>>0<=20)do switch(b|0){case 9:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=b;break a}case 10:{b=(c[d>>2]|0)+(4-1)&~(4-1);e=c[b>>2]|0;c[d>>2]=b+4;c[a>>2]=e;c[a+4>>2]=((e|0)<0)<<31>>31;break a}case 11:{b=(c[d>>2]|0)+(4-1)&~(4-1);e=c[b>>2]|0;c[d>>2]=b+4;c[a>>2]=e;c[a+4>>2]=0;break a}case 12:{f=(c[d>>2]|0)+(8-1)&~(8-1);b=c[f>>2]|0;e=c[f+4>>2]|0;c[d>>2]=f+8;c[a>>2]=b;c[a+4>>2]=e;break a}case 13:{e=(c[d>>2]|0)+(4-1)&~(4-1);f=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=(f&65535)<<16>>16;c[a+4>>2]=(((f&65535)<<16>>16|0)<0)<<31>>31;break a}case 14:{e=(c[d>>2]|0)+(4-1)&~(4-1);f=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=f&65535;c[a+4>>2]=0;break a}case 15:{e=(c[d>>2]|0)+(4-1)&~(4-1);f=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=(f&255)<<24>>24;c[a+4>>2]=(((f&255)<<24>>24|0)<0)<<31>>31;break a}case 16:{e=(c[d>>2]|0)+(4-1)&~(4-1);f=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=f&255;c[a+4>>2]=0;break a}case 17:{f=(c[d>>2]|0)+(8-1)&~(8-1);g=+h[f>>3];c[d>>2]=f+8;h[a>>3]=g;break a}case 18:{f=(c[d>>2]|0)+(8-1)&~(8-1);g=+h[f>>3];c[d>>2]=f+8;h[a>>3]=g;break a}default:break a}while(0);while(0);return}function kG(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;if(c>>>0>0|(c|0)==0&b>>>0>4294967295)while(1){e=lH(b|0,c|0,10,0)|0;d=d+-1|0;a[d>>0]=e|48;e=b;b=kH(b|0,c|0,10,0)|0;if(!(c>>>0>9|(c|0)==9&e>>>0>4294967295))break;else c=C}if(b)while(1){d=d+-1|0;a[d>>0]=(b>>>0)%10|0|48;if(b>>>0<10)break;else b=(b>>>0)/10|0}return d|0}function lG(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;h=i;i=i+256|0;do if((d|0)>(e|0)&(f&73728|0)==0){ZG(h|0,b|0,((d-e|0)>>>0>256?256:d-e|0)|0)|0;f=c[a>>2]|0;if((d-e|0)>>>0>255){g=d-e|0;b=f;f=(f&32|0)==0;do{if(f){hG(h,256,a);b=c[a>>2]|0}g=g+-256|0;f=(b&32|0)==0}while(g>>>0>255);if(f)b=d-e&255;else break}else if(!(f&32))b=d-e|0;else break;hG(h,b,a)}while(0);i=h;return}function mG(b,d){b=b|0;d=d|0;do if(!b)b=0;else{if(d>>>0<128){a[b>>0]=d;b=1;break}if(d>>>0<2048){a[b>>0]=d>>>6|192;a[b+1>>0]=d&63|128;b=2;break}if(d>>>0<55296|(d&-8192|0)==57344){a[b>>0]=d>>>12|224;a[b+1>>0]=d>>>6&63|128;a[b+2>>0]=d&63|128;b=3;break}if((d+-65536|0)>>>0<1048576){a[b>>0]=d>>>18|240;a[b+1>>0]=d>>>12&63|128;a[b+2>>0]=d>>>6&63|128;a[b+3>>0]=d&63|128;b=4;break}if(!0)b=22816;else b=c[(eH()|0)+64>>2]|0;c[b>>2]=84;b=-1}while(0);return b|0}function nG(a,b){a=+a;b=b|0;var d=0,e=0,f=0;h[k>>3]=a;d=c[k>>2]|0;e=c[k+4>>2]|0;f=aH(d|0,e|0,52)|0;switch(f&2047|0){case 0:{if(a!=0.0){a=+nG(a*18446744073709551616.0,b);d=(c[b>>2]|0)+-64|0}else d=0;c[b>>2]=d;break}case 2047:break;default:{c[b>>2]=(f&2047)+-1022;c[k>>2]=d;c[k+4>>2]=e&-2146435073|1071644672;a=+h[k>>3]}}return +a}function oG(a){a=+a;var b=0,d=0,e=0,f=0,h=0,i=0;i=(g[k>>2]=a,c[k>>2]|0);a:do if((i>>>23&255|0)==255)a=a*6.2831854820251465/(a*6.2831854820251465);else{if(i<<1>>>0<=2173837238)return +((i<<1|0)==-2121130058?a*0.0:a);if(!(i>>>23&255)){if((i<<9|0)>-1){b=0;d=i<<9;do{b=b+-1|0;d=d<<1}while((d|0)>-1);d=b}else d=0;b=d;e=i<<1-d}else{b=i>>>23&255;e=i&8388607|8388608}f=e+-13176795|0;b:do if((b|0)>129){h=(f|0)>-1;d=f;while(1){if(h){if((e|0)==13176795)break}else d=e;e=d<<1;b=b+-1|0;if((b|0)>129){h=(e+-13176795|0)>-1;d=e+-13176795|0}else{d=e+-13176795|0;f=(e+-13176795|0)>-1;break b}}a=a*0.0;break a}else{d=f;f=(f|0)>-1}while(0);if(f){if((e|0)==13176795){a=a*0.0;break}}else d=e;if(d>>>0<8388608)do{d=d<<1;b=b+-1|0}while(d>>>0<8388608);if((b|0)>0)b=d+-8388608|b<<23;else b=d>>>(1-b|0);a=(c[k>>2]=b|i&-2147483648,+g[k>>2])}while(0);return +a}function pG(b,e){b=b|0;e=e|0;var f=0,g=0,h=0;h=i;i=i+16|0;a[h>>0]=e;f=c[b+16>>2]|0;if(!f)if(!(iG(b)|0)){f=c[b+16>>2]|0;g=4}else f=-1;else g=4;do if((g|0)==4){g=c[b+20>>2]|0;if(g>>>0<f>>>0?(e&255|0)!=(a[b+75>>0]|0):0){c[b+20>>2]=g+1;a[g>>0]=e;f=e&255;break}if((Eb[c[b+36>>2]&63](b,h,1)|0)==1)f=d[h>>0]|0;else f=-1}while(0);i=h;return f|0}function qG(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;F=i;i=i+16|0;do if(a>>>0<245){o=a>>>0<11?16:a+11&-8;g=c[5705]|0;if(g>>>(o>>>3)&3|0){a=22860+((g>>>(o>>>3)&1^1)+(o>>>3)<<1<<2)|0;b=c[a+8>>2]|0;d=c[b+8>>2]|0;do if((a|0)!=(d|0)){if(d>>>0<(c[5709]|0)>>>0)Ta();if((c[d+12>>2]|0)==(b|0)){c[d+12>>2]=a;c[a+8>>2]=d;break}else Ta()}else c[5705]=g&~(1<<(g>>>(o>>>3)&1^1)+(o>>>3));while(0);E=(g>>>(o>>>3)&1^1)+(o>>>3)<<3;c[b+4>>2]=E|3;c[b+E+4>>2]=c[b+E+4>>2]|1;E=b+8|0;i=F;return E|0}b=c[5707]|0;if(o>>>0>b>>>0){if(g>>>(o>>>3)|0){a=g>>>(o>>>3)<<(o>>>3)&(2<<(o>>>3)|0-(2<<(o>>>3)));f=((a&0-a)+-1|0)>>>(((a&0-a)+-1|0)>>>12&16);e=f>>>(f>>>5&8)>>>(f>>>(f>>>5&8)>>>2&4);e=(f>>>5&8|((a&0-a)+-1|0)>>>12&16|f>>>(f>>>5&8)>>>2&4|e>>>1&2|e>>>(e>>>1&2)>>>1&1)+(e>>>(e>>>1&2)>>>(e>>>(e>>>1&2)>>>1&1))|0;f=c[22860+(e<<1<<2)+8>>2]|0;a=c[f+8>>2]|0;do if((22860+(e<<1<<2)|0)!=(a|0)){if(a>>>0<(c[5709]|0)>>>0)Ta();if((c[a+12>>2]|0)==(f|0)){c[a+12>>2]=22860+(e<<1<<2);c[22860+(e<<1<<2)+8>>2]=a;h=c[5707]|0;break}else Ta()}else{c[5705]=g&~(1<<e);h=b}while(0);c[f+4>>2]=o|3;c[f+o+4>>2]=(e<<3)-o|1;c[f+o+((e<<3)-o)>>2]=(e<<3)-o;if(h|0){d=c[5710]|0;b=h>>>3;a=c[5705]|0;if(a&1<<b){a=c[22860+(b<<1<<2)+8>>2]|0;if(a>>>0<(c[5709]|0)>>>0)Ta();else{j=22860+(b<<1<<2)+8|0;k=a}}else{c[5705]=a|1<<b;j=22860+(b<<1<<2)+8|0;k=22860+(b<<1<<2)|0}c[j>>2]=d;c[k+12>>2]=d;c[d+8>>2]=k;c[d+12>>2]=22860+(b<<1<<2)}c[5707]=(e<<3)-o;c[5710]=f+o;E=f+8|0;i=F;return E|0}a=c[5706]|0;if(a){j=((a&0-a)+-1|0)>>>(((a&0-a)+-1|0)>>>12&16);k=j>>>(j>>>5&8)>>>(j>>>(j>>>5&8)>>>2&4);k=c[23124+((j>>>5&8|((a&0-a)+-1|0)>>>12&16|j>>>(j>>>5&8)>>>2&4|k>>>1&2|k>>>(k>>>1&2)>>>1&1)+(k>>>(k>>>1&2)>>>(k>>>(k>>>1&2)>>>1&1))<<2)>>2]|0;j=(c[k+4>>2]&-8)-o|0;b=k;while(1){a=c[b+16>>2]|0;if(!a){a=c[b+20>>2]|0;if(!a)break}b=(c[a+4>>2]&-8)-o|0;E=b>>>0<j>>>0;j=E?b:j;b=a;k=E?a:k}f=c[5709]|0;if(k>>>0<f>>>0)Ta();h=k+o|0;if(k>>>0>=h>>>0)Ta();g=c[k+24>>2]|0;a=c[k+12>>2]|0;do if((a|0)==(k|0)){b=k+20|0;a=c[b>>2]|0;if(!a){b=k+16|0;a=c[b>>2]|0;if(!a){l=0;break}}while(1){d=a+20|0;e=c[d>>2]|0;if(e|0){a=e;b=d;continue}d=a+16|0;e=c[d>>2]|0;if(!e)break;else{a=e;b=d}}if(b>>>0<f>>>0)Ta();else{c[b>>2]=0;l=a;break}}else{b=c[k+8>>2]|0;if(b>>>0<f>>>0)Ta();if((c[b+12>>2]|0)!=(k|0))Ta();if((c[a+8>>2]|0)==(k|0)){c[b+12>>2]=a;c[a+8>>2]=b;l=a;break}else Ta()}while(0);do if(g|0){a=c[k+28>>2]|0;if((k|0)==(c[23124+(a<<2)>>2]|0)){c[23124+(a<<2)>>2]=l;if(!l){c[5706]=c[5706]&~(1<<a);break}}else{if(g>>>0<(c[5709]|0)>>>0)Ta();if((c[g+16>>2]|0)==(k|0))c[g+16>>2]=l;else c[g+20>>2]=l;if(!l)break}b=c[5709]|0;if(l>>>0<b>>>0)Ta();c[l+24>>2]=g;a=c[k+16>>2]|0;do if(a|0)if(a>>>0<b>>>0)Ta();else{c[l+16>>2]=a;c[a+24>>2]=l;break}while(0);a=c[k+20>>2]|0;if(a|0)if(a>>>0<(c[5709]|0)>>>0)Ta();else{c[l+20>>2]=a;c[a+24>>2]=l;break}}while(0);if(j>>>0<16){E=j+o|0;c[k+4>>2]=E|3;E=k+E+4|0;c[E>>2]=c[E>>2]|1}else{c[k+4>>2]=o|3;c[h+4>>2]=j|1;c[h+j>>2]=j;b=c[5707]|0;if(b|0){d=c[5710]|0;a=c[5705]|0;if(a&1<<(b>>>3)){a=c[22860+(b>>>3<<1<<2)+8>>2]|0;if(a>>>0<(c[5709]|0)>>>0)Ta();else{m=22860+(b>>>3<<1<<2)+8|0;n=a}}else{c[5705]=a|1<<(b>>>3);m=22860+(b>>>3<<1<<2)+8|0;n=22860+(b>>>3<<1<<2)|0}c[m>>2]=d;c[n+12>>2]=d;c[d+8>>2]=n;c[d+12>>2]=22860+(b>>>3<<1<<2)}c[5707]=j;c[5710]=h}E=k+8|0;i=F;return E|0}}}else if(a>>>0<=4294967231){o=a+11&-8;j=c[5706]|0;if(j){if((a+11|0)>>>8)if(o>>>0>16777215)h=31;else{h=(a+11|0)>>>8<<((((a+11|0)>>>8)+1048320|0)>>>16&8);h=14-((h+520192|0)>>>16&4|(((a+11|0)>>>8)+1048320|0)>>>16&8|((h<<((h+520192|0)>>>16&4))+245760|0)>>>16&2)+(h<<((h+520192|0)>>>16&4)<<(((h<<((h+520192|0)>>>16&4))+245760|0)>>>16&2)>>>15)|0;h=o>>>(h+7|0)&1|h<<1}else h=0;b=c[23124+(h<<2)>>2]|0;a:do if(!b){d=0-o|0;a=0;b=0;x=86}else{d=0-o|0;a=0;f=o<<((h|0)==31?0:25-(h>>>1)|0);g=b;b=0;while(1){e=c[g+4>>2]&-8;if((e-o|0)>>>0<d>>>0)if((e|0)==(o|0)){d=e-o|0;a=g;b=g;x=90;break a}else{d=e-o|0;b=g}e=c[g+20>>2]|0;g=c[g+16+(f>>>31<<2)>>2]|0;a=(e|0)==0|(e|0)==(g|0)?a:e;e=(g|0)==0;if(e){x=86;break}else f=f<<(e&1^1)}}while(0);if((x|0)==86){if((a|0)==0&(b|0)==0){a=2<<h;if(!(j&(a|0-a)))break;m=(j&(a|0-a)&0-(j&(a|0-a)))+-1|0;n=m>>>(m>>>12&16)>>>(m>>>(m>>>12&16)>>>5&8);a=n>>>(n>>>2&4)>>>(n>>>(n>>>2&4)>>>1&2);a=c[23124+((m>>>(m>>>12&16)>>>5&8|m>>>12&16|n>>>2&4|n>>>(n>>>2&4)>>>1&2|a>>>1&1)+(a>>>(a>>>1&1))<<2)>>2]|0}if(!a){j=d;k=b}else x=90}if((x|0)==90)while(1){x=0;n=(c[a+4>>2]&-8)-o|0;e=n>>>0<d>>>0;d=e?n:d;b=e?a:b;e=c[a+16>>2]|0;if(e|0){a=e;x=90;continue}a=c[a+20>>2]|0;if(!a){j=d;k=b;break}else x=90}if((k|0)!=0?j>>>0<((c[5707]|0)-o|0)>>>0:0){f=c[5709]|0;if(k>>>0<f>>>0)Ta();h=k+o|0;if(k>>>0>=h>>>0)Ta();g=c[k+24>>2]|0;a=c[k+12>>2]|0;do if((a|0)==(k|0)){b=k+20|0;a=c[b>>2]|0;if(!a){b=k+16|0;a=c[b>>2]|0;if(!a){q=0;break}}while(1){d=a+20|0;e=c[d>>2]|0;if(e|0){a=e;b=d;continue}d=a+16|0;e=c[d>>2]|0;if(!e)break;else{a=e;b=d}}if(b>>>0<f>>>0)Ta();else{c[b>>2]=0;q=a;break}}else{b=c[k+8>>2]|0;if(b>>>0<f>>>0)Ta();if((c[b+12>>2]|0)!=(k|0))Ta();if((c[a+8>>2]|0)==(k|0)){c[b+12>>2]=a;c[a+8>>2]=b;q=a;break}else Ta()}while(0);do if(g|0){a=c[k+28>>2]|0;if((k|0)==(c[23124+(a<<2)>>2]|0)){c[23124+(a<<2)>>2]=q;if(!q){c[5706]=c[5706]&~(1<<a);break}}else{if(g>>>0<(c[5709]|0)>>>0)Ta();if((c[g+16>>2]|0)==(k|0))c[g+16>>2]=q;else c[g+20>>2]=q;if(!q)break}b=c[5709]|0;if(q>>>0<b>>>0)Ta();c[q+24>>2]=g;a=c[k+16>>2]|0;do if(a|0)if(a>>>0<b>>>0)Ta();else{c[q+16>>2]=a;c[a+24>>2]=q;break}while(0);a=c[k+20>>2]|0;if(a|0)if(a>>>0<(c[5709]|0)>>>0)Ta();else{c[q+20>>2]=a;c[a+24>>2]=q;break}}while(0);do if(j>>>0>=16){c[k+4>>2]=o|3;c[h+4>>2]=j|1;c[h+j>>2]=j;b=j>>>3;if(j>>>0<256){a=c[5705]|0;if(a&1<<b){a=c[22860+(b<<1<<2)+8>>2]|0;if(a>>>0<(c[5709]|0)>>>0)Ta();else{r=22860+(b<<1<<2)+8|0;s=a}}else{c[5705]=a|1<<b;r=22860+(b<<1<<2)+8|0;s=22860+(b<<1<<2)|0}c[r>>2]=h;c[s+12>>2]=h;c[h+8>>2]=s;c[h+12>>2]=22860+(b<<1<<2);break}a=j>>>8;if(a)if(j>>>0>16777215)d=31;else{d=a<<((a+1048320|0)>>>16&8)<<(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4);d=14-(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4|(a+1048320|0)>>>16&8|(d+245760|0)>>>16&2)+(d<<((d+245760|0)>>>16&2)>>>15)|0;d=j>>>(d+7|0)&1|d<<1}else d=0;e=23124+(d<<2)|0;c[h+28>>2]=d;c[h+16+4>>2]=0;c[h+16>>2]=0;a=c[5706]|0;b=1<<d;if(!(a&b)){c[5706]=a|b;c[e>>2]=h;c[h+24>>2]=e;c[h+12>>2]=h;c[h+8>>2]=h;break}d=j<<((d|0)==31?0:25-(d>>>1)|0);e=c[e>>2]|0;while(1){if((c[e+4>>2]&-8|0)==(j|0)){x=148;break}b=e+16+(d>>>31<<2)|0;a=c[b>>2]|0;if(!a){x=145;break}else{d=d<<1;e=a}}if((x|0)==145)if(b>>>0<(c[5709]|0)>>>0)Ta();else{c[b>>2]=h;c[h+24>>2]=e;c[h+12>>2]=h;c[h+8>>2]=h;break}else if((x|0)==148){a=e+8|0;b=c[a>>2]|0;E=c[5709]|0;if(b>>>0>=E>>>0&e>>>0>=E>>>0){c[b+12>>2]=h;c[a>>2]=h;c[h+8>>2]=b;c[h+12>>2]=e;c[h+24>>2]=0;break}else Ta()}}else{E=j+o|0;c[k+4>>2]=E|3;E=k+E+4|0;c[E>>2]=c[E>>2]|1}while(0);E=k+8|0;i=F;return E|0}}}else o=-1;while(0);d=c[5707]|0;if(d>>>0>=o>>>0){a=d-o|0;b=c[5710]|0;if(a>>>0>15){E=b+o|0;c[5710]=E;c[5707]=a;c[E+4>>2]=a|1;c[E+a>>2]=a;c[b+4>>2]=o|3}else{c[5707]=0;c[5710]=0;c[b+4>>2]=d|3;c[b+d+4>>2]=c[b+d+4>>2]|1}E=b+8|0;i=F;return E|0}a=c[5708]|0;if(a>>>0>o>>>0){C=a-o|0;c[5708]=C;E=c[5711]|0;D=E+o|0;c[5711]=D;c[D+4>>2]=C|1;c[E+4>>2]=o|3;E=E+8|0;i=F;return E|0}if(!(c[5823]|0)){c[5825]=4096;c[5824]=4096;c[5826]=-1;c[5827]=-1;c[5828]=0;c[5816]=0;c[F>>2]=F&-16^1431655768;c[5823]=F&-16^1431655768}f=o+48|0;d=c[5825]|0;g=o+47|0;h=d+g&0-d;if(h>>>0<=o>>>0){E=0;i=F;return E|0}a=c[5815]|0;if(a|0?(s=c[5813]|0,(s+h|0)>>>0<=s>>>0|(s+h|0)>>>0>a>>>0):0){E=0;i=F;return E|0}b:do if(!(c[5816]&4)){b=c[5711]|0;c:do if(b){e=23268;while(1){a=c[e>>2]|0;if(a>>>0<=b>>>0?(p=e+4|0,(a+(c[p>>2]|0)|0)>>>0>b>>>0):0)break;a=c[e+8>>2]|0;if(!a){x=171;break c}else e=a}a=d+g-(c[5708]|0)&0-d;if(a>>>0<2147483647){b=Xa(a|0)|0;if((b|0)==((c[e>>2]|0)+(c[p>>2]|0)|0)){if((b|0)!=(-1|0)){h=b;g=a;x=191;break b}}else x=181}}else x=171;while(0);do if((x|0)==171?(t=Xa(0)|0,(t|0)!=(-1|0)):0){a=c[5824]|0;if(!(a+-1&t))a=h;else a=h-t+(a+-1+t&0-a)|0;b=c[5813]|0;d=b+a|0;if(a>>>0>o>>>0&a>>>0<2147483647){s=c[5815]|0;if(s|0?d>>>0<=b>>>0|d>>>0>s>>>0:0)break;b=Xa(a|0)|0;if((b|0)==(t|0)){h=t;g=a;x=191;break b}else x=181}}while(0);d:do if((x|0)==181){d=0-a|0;do if(f>>>0>a>>>0&(a>>>0<2147483647&(b|0)!=(-1|0))?(u=c[5825]|0,u=g-a+u&0-u,u>>>0<2147483647):0)if((Xa(u|0)|0)==(-1|0)){Xa(d|0)|0;break d}else{a=u+a|0;break}while(0);if((b|0)!=(-1|0)){h=b;g=a;x=191;break b}}while(0);c[5816]=c[5816]|4;x=188}else x=188;while(0);if((((x|0)==188?h>>>0<2147483647:0)?(v=Xa(h|0)|0,w=Xa(0)|0,v>>>0<w>>>0&((v|0)!=(-1|0)&(w|0)!=(-1|0))):0)?(w-v|0)>>>0>(o+40|0)>>>0:0){h=v;g=w-v|0;x=191}if((x|0)==191){a=(c[5813]|0)+g|0;c[5813]=a;if(a>>>0>(c[5814]|0)>>>0)c[5814]=a;l=c[5711]|0;do if(l){f=23268;while(1){a=c[f>>2]|0;b=f+4|0;d=c[b>>2]|0;if((h|0)==(a+d|0)){x=201;break}e=c[f+8>>2]|0;if(!e)break;else f=e}if(((x|0)==201?(c[f+12>>2]&8|0)==0:0)?l>>>0<h>>>0&l>>>0>=a>>>0:0){c[b>>2]=d+g;D=(l+8&7|0)==0?0:0-(l+8)&7;E=g-D+(c[5708]|0)|0;c[5711]=l+D;c[5708]=E;c[l+D+4>>2]=E|1;c[l+D+E+4>>2]=40;c[5712]=c[5827];break}a=c[5709]|0;if(h>>>0<a>>>0){c[5709]=h;k=h}else k=a;b=h+g|0;a=23268;while(1){if((c[a>>2]|0)==(b|0)){x=209;break}a=c[a+8>>2]|0;if(!a){b=23268;break}}if((x|0)==209)if(!(c[a+12>>2]&8)){c[a>>2]=h;n=a+4|0;c[n>>2]=(c[n>>2]|0)+g;n=h+8|0;n=h+((n&7|0)==0?0:0-n&7)|0;a=b+((b+8&7|0)==0?0:0-(b+8)&7)|0;m=n+o|0;j=a-n-o|0;c[n+4>>2]=o|3;do if((a|0)!=(l|0)){if((a|0)==(c[5710]|0)){E=(c[5707]|0)+j|0;c[5707]=E;c[5710]=m;c[m+4>>2]=E|1;c[m+E>>2]=E;break}h=c[a+4>>2]|0;if((h&3|0)==1){e:do if(h>>>0>=256){g=c[a+24>>2]|0;b=c[a+12>>2]|0;do if((b|0)==(a|0)){b=c[a+16+4>>2]|0;if(!b){b=c[a+16>>2]|0;if(!b){C=0;break}else f=a+16|0}else f=a+16+4|0;while(1){d=b+20|0;e=c[d>>2]|0;if(e|0){b=e;f=d;continue}d=b+16|0;e=c[d>>2]|0;if(!e)break;else{b=e;f=d}}if(f>>>0<k>>>0)Ta();else{c[f>>2]=0;C=b;break}}else{d=c[a+8>>2]|0;if(d>>>0<k>>>0)Ta();if((c[d+12>>2]|0)!=(a|0))Ta();if((c[b+8>>2]|0)==(a|0)){c[d+12>>2]=b;c[b+8>>2]=d;C=b;break}else Ta()}while(0);if(!g)break;b=c[a+28>>2]|0;do if((a|0)!=(c[23124+(b<<2)>>2]|0)){if(g>>>0<(c[5709]|0)>>>0)Ta();if((c[g+16>>2]|0)==(a|0))c[g+16>>2]=C;else c[g+20>>2]=C;if(!C)break e}else{c[23124+(b<<2)>>2]=C;if(C|0)break;c[5706]=c[5706]&~(1<<b);break e}while(0);d=c[5709]|0;if(C>>>0<d>>>0)Ta();c[C+24>>2]=g;b=c[a+16>>2]|0;do if(b|0)if(b>>>0<d>>>0)Ta();else{c[C+16>>2]=b;c[b+24>>2]=C;break}while(0);b=c[a+16+4>>2]|0;if(!b)break;if(b>>>0<(c[5709]|0)>>>0)Ta();else{c[C+20>>2]=b;c[b+24>>2]=C;break}}else{b=c[a+8>>2]|0;d=c[a+12>>2]|0;do if((b|0)!=(22860+(h>>>3<<1<<2)|0)){if(b>>>0<k>>>0)Ta();if((c[b+12>>2]|0)==(a|0))break;Ta()}while(0);if((d|0)==(b|0)){c[5705]=c[5705]&~(1<<(h>>>3));break}do if((d|0)==(22860+(h>>>3<<1<<2)|0))A=d+8|0;else{if(d>>>0<k>>>0)Ta();if((c[d+8>>2]|0)==(a|0)){A=d+8|0;break}Ta()}while(0);c[b+12>>2]=d;c[A>>2]=b}while(0);a=a+(h&-8)|0;f=(h&-8)+j|0}else f=j;b=a+4|0;c[b>>2]=c[b>>2]&-2;c[m+4>>2]=f|1;c[m+f>>2]=f;b=f>>>3;if(f>>>0<256){a=c[5705]|0;do if(!(a&1<<b)){c[5705]=a|1<<b;D=22860+(b<<1<<2)+8|0;E=22860+(b<<1<<2)|0}else{a=c[22860+(b<<1<<2)+8>>2]|0;if(a>>>0>=(c[5709]|0)>>>0){D=22860+(b<<1<<2)+8|0;E=a;break}Ta()}while(0);c[D>>2]=m;c[E+12>>2]=m;c[m+8>>2]=E;c[m+12>>2]=22860+(b<<1<<2);break}a=f>>>8;do if(!a)d=0;else{if(f>>>0>16777215){d=31;break}d=a<<((a+1048320|0)>>>16&8)<<(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4);d=14-(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4|(a+1048320|0)>>>16&8|(d+245760|0)>>>16&2)+(d<<((d+245760|0)>>>16&2)>>>15)|0;d=f>>>(d+7|0)&1|d<<1}while(0);e=23124+(d<<2)|0;c[m+28>>2]=d;c[m+16+4>>2]=0;c[m+16>>2]=0;a=c[5706]|0;b=1<<d;if(!(a&b)){c[5706]=a|b;c[e>>2]=m;c[m+24>>2]=e;c[m+12>>2]=m;c[m+8>>2]=m;break}d=f<<((d|0)==31?0:25-(d>>>1)|0);e=c[e>>2]|0;while(1){if((c[e+4>>2]&-8|0)==(f|0)){x=279;break}b=e+16+(d>>>31<<2)|0;a=c[b>>2]|0;if(!a){x=276;break}else{d=d<<1;e=a}}if((x|0)==276)if(b>>>0<(c[5709]|0)>>>0)Ta();else{c[b>>2]=m;c[m+24>>2]=e;c[m+12>>2]=m;c[m+8>>2]=m;break}else if((x|0)==279){a=e+8|0;b=c[a>>2]|0;E=c[5709]|0;if(b>>>0>=E>>>0&e>>>0>=E>>>0){c[b+12>>2]=m;c[a>>2]=m;c[m+8>>2]=b;c[m+12>>2]=e;c[m+24>>2]=0;break}else Ta()}}else{E=(c[5708]|0)+j|0;c[5708]=E;c[5711]=m;c[m+4>>2]=E|1}while(0);E=n+8|0;i=F;return E|0}else b=23268;while(1){a=c[b>>2]|0;if(a>>>0<=l>>>0?(y=a+(c[b+4>>2]|0)|0,y>>>0>l>>>0):0)break;b=c[b+8>>2]|0}f=y+-47+((y+-47+8&7|0)==0?0:0-(y+-47+8)&7)|0;f=f>>>0<(l+16|0)>>>0?l:f;a=h+8|0;a=(a&7|0)==0?0:0-a&7;E=h+a|0;a=g+-40-a|0;c[5711]=E;c[5708]=a;c[E+4>>2]=a|1;c[E+a+4>>2]=40;c[5712]=c[5827];c[f+4>>2]=27;c[f+8>>2]=c[5817];c[f+8+4>>2]=c[5818];c[f+8+8>>2]=c[5819];c[f+8+12>>2]=c[5820];c[5817]=h;c[5818]=g;c[5820]=0;c[5819]=f+8;a=f+24|0;do{a=a+4|0;c[a>>2]=7}while((a+4|0)>>>0<y>>>0);if((f|0)!=(l|0)){c[f+4>>2]=c[f+4>>2]&-2;c[l+4>>2]=f-l|1;c[f>>2]=f-l;if((f-l|0)>>>0<256){b=22860+((f-l|0)>>>3<<1<<2)|0;a=c[5705]|0;if(a&1<<((f-l|0)>>>3)){a=c[b+8>>2]|0;if(a>>>0<(c[5709]|0)>>>0)Ta();else{z=b+8|0;B=a}}else{c[5705]=a|1<<((f-l|0)>>>3);z=b+8|0;B=b}c[z>>2]=l;c[B+12>>2]=l;c[l+8>>2]=B;c[l+12>>2]=b;break}if((f-l|0)>>>8)if((f-l|0)>>>0>16777215)d=31;else{d=(f-l|0)>>>8<<((((f-l|0)>>>8)+1048320|0)>>>16&8);d=14-((d+520192|0)>>>16&4|(((f-l|0)>>>8)+1048320|0)>>>16&8|((d<<((d+520192|0)>>>16&4))+245760|0)>>>16&2)+(d<<((d+520192|0)>>>16&4)<<(((d<<((d+520192|0)>>>16&4))+245760|0)>>>16&2)>>>15)|0;d=(f-l|0)>>>(d+7|0)&1|d<<1}else d=0;e=23124+(d<<2)|0;c[l+28>>2]=d;c[l+20>>2]=0;c[l+16>>2]=0;a=c[5706]|0;b=1<<d;if(!(a&b)){c[5706]=a|b;c[e>>2]=l;c[l+24>>2]=e;c[l+12>>2]=l;c[l+8>>2]=l;break}d=f-l<<((d|0)==31?0:25-(d>>>1)|0);e=c[e>>2]|0;while(1){if((c[e+4>>2]&-8|0)==(f-l|0)){x=305;break}b=e+16+(d>>>31<<2)|0;a=c[b>>2]|0;if(!a){x=302;break}else{d=d<<1;e=a}}if((x|0)==302)if(b>>>0<(c[5709]|0)>>>0)Ta();else{c[b>>2]=l;c[l+24>>2]=e;c[l+12>>2]=l;c[l+8>>2]=l;break}else if((x|0)==305){a=e+8|0;b=c[a>>2]|0;E=c[5709]|0;if(b>>>0>=E>>>0&e>>>0>=E>>>0){c[b+12>>2]=l;c[a>>2]=l;c[l+8>>2]=b;c[l+12>>2]=e;c[l+24>>2]=0;break}else Ta()}}}else{E=c[5709]|0;if((E|0)==0|h>>>0<E>>>0)c[5709]=h;c[5817]=h;c[5818]=g;c[5820]=0;c[5714]=c[5823];c[5713]=-1;a=0;do{E=22860+(a<<1<<2)|0;c[E+12>>2]=E;c[E+8>>2]=E;a=a+1|0}while((a|0)!=32);E=h+8|0;E=(E&7|0)==0?0:0-E&7;D=h+E|0;E=g+-40-E|0;c[5711]=D;c[5708]=E;c[D+4>>2]=E|1;c[D+E+4>>2]=40;c[5712]=c[5827]}while(0);a=c[5708]|0;if(a>>>0>o>>>0){C=a-o|0;c[5708]=C;E=c[5711]|0;D=E+o|0;c[5711]=D;c[D+4>>2]=C|1;c[E+4>>2]=o|3;E=E+8|0;i=F;return E|0}}if(!0)a=22816;else a=c[(eH()|0)+64>>2]|0;c[a>>2]=12;E=0;i=F;return E|0}function rG(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;if(!a)return;h=c[5709]|0;if((a+-8|0)>>>0<h>>>0)Ta();b=c[a+-4>>2]|0;if((b&3|0)==1)Ta();n=a+-8+(b&-8)|0;do if(!(b&1)){e=c[a+-8>>2]|0;if(!(b&3))return;k=a+-8+(0-e)|0;j=e+(b&-8)|0;if(k>>>0<h>>>0)Ta();if((k|0)==(c[5710]|0)){a=c[n+4>>2]|0;if((a&3|0)!=3){q=k;f=j;break}c[5707]=j;c[n+4>>2]=a&-2;c[k+4>>2]=j|1;c[k+j>>2]=j;return}if(e>>>0<256){a=c[k+8>>2]|0;b=c[k+12>>2]|0;if((a|0)!=(22860+(e>>>3<<1<<2)|0)){if(a>>>0<h>>>0)Ta();if((c[a+12>>2]|0)!=(k|0))Ta()}if((b|0)==(a|0)){c[5705]=c[5705]&~(1<<(e>>>3));q=k;f=j;break}if((b|0)!=(22860+(e>>>3<<1<<2)|0)){if(b>>>0<h>>>0)Ta();if((c[b+8>>2]|0)!=(k|0))Ta();else d=b+8|0}else d=b+8|0;c[a+12>>2]=b;c[d>>2]=a;q=k;f=j;break}g=c[k+24>>2]|0;a=c[k+12>>2]|0;do if((a|0)==(k|0)){a=c[k+16+4>>2]|0;if(!a){a=c[k+16>>2]|0;if(!a){i=0;break}else e=k+16|0}else e=k+16+4|0;while(1){b=a+20|0;d=c[b>>2]|0;if(d|0){a=d;e=b;continue}b=a+16|0;d=c[b>>2]|0;if(!d)break;else{a=d;e=b}}if(e>>>0<h>>>0)Ta();else{c[e>>2]=0;i=a;break}}else{b=c[k+8>>2]|0;if(b>>>0<h>>>0)Ta();if((c[b+12>>2]|0)!=(k|0))Ta();if((c[a+8>>2]|0)==(k|0)){c[b+12>>2]=a;c[a+8>>2]=b;i=a;break}else Ta()}while(0);if(g){a=c[k+28>>2]|0;if((k|0)==(c[23124+(a<<2)>>2]|0)){c[23124+(a<<2)>>2]=i;if(!i){c[5706]=c[5706]&~(1<<a);q=k;f=j;break}}else{if(g>>>0<(c[5709]|0)>>>0)Ta();if((c[g+16>>2]|0)==(k|0))c[g+16>>2]=i;else c[g+20>>2]=i;if(!i){q=k;f=j;break}}b=c[5709]|0;if(i>>>0<b>>>0)Ta();c[i+24>>2]=g;a=c[k+16>>2]|0;do if(a|0)if(a>>>0<b>>>0)Ta();else{c[i+16>>2]=a;c[a+24>>2]=i;break}while(0);a=c[k+16+4>>2]|0;if(a)if(a>>>0<(c[5709]|0)>>>0)Ta();else{c[i+20>>2]=a;c[a+24>>2]=i;q=k;f=j;break}else{q=k;f=j}}else{q=k;f=j}}else{q=a+-8|0;f=b&-8}while(0);if(q>>>0>=n>>>0)Ta();d=c[n+4>>2]|0;if(!(d&1))Ta();if(!(d&2)){if((n|0)==(c[5711]|0)){p=(c[5708]|0)+f|0;c[5708]=p;c[5711]=q;c[q+4>>2]=p|1;if((q|0)!=(c[5710]|0))return;c[5710]=0;c[5707]=0;return}if((n|0)==(c[5710]|0)){p=(c[5707]|0)+f|0;c[5707]=p;c[5710]=q;c[q+4>>2]=p|1;c[q+p>>2]=p;return}f=(d&-8)+f|0;do if(d>>>0>=256){g=c[n+24>>2]|0;a=c[n+12>>2]|0;do if((a|0)==(n|0)){a=c[n+16+4>>2]|0;if(!a){a=c[n+16>>2]|0;if(!a){m=0;break}else e=n+16|0}else e=n+16+4|0;while(1){b=a+20|0;d=c[b>>2]|0;if(d|0){a=d;e=b;continue}b=a+16|0;d=c[b>>2]|0;if(!d)break;else{a=d;e=b}}if(e>>>0<(c[5709]|0)>>>0)Ta();else{c[e>>2]=0;m=a;break}}else{b=c[n+8>>2]|0;if(b>>>0<(c[5709]|0)>>>0)Ta();if((c[b+12>>2]|0)!=(n|0))Ta();if((c[a+8>>2]|0)==(n|0)){c[b+12>>2]=a;c[a+8>>2]=b;m=a;break}else Ta()}while(0);if(g|0){a=c[n+28>>2]|0;if((n|0)==(c[23124+(a<<2)>>2]|0)){c[23124+(a<<2)>>2]=m;if(!m){c[5706]=c[5706]&~(1<<a);break}}else{if(g>>>0<(c[5709]|0)>>>0)Ta();if((c[g+16>>2]|0)==(n|0))c[g+16>>2]=m;else c[g+20>>2]=m;if(!m)break}b=c[5709]|0;if(m>>>0<b>>>0)Ta();c[m+24>>2]=g;a=c[n+16>>2]|0;do if(a|0)if(a>>>0<b>>>0)Ta();else{c[m+16>>2]=a;c[a+24>>2]=m;break}while(0);a=c[n+16+4>>2]|0;if(a|0)if(a>>>0<(c[5709]|0)>>>0)Ta();else{c[m+20>>2]=a;c[a+24>>2]=m;break}}}else{a=c[n+8>>2]|0;b=c[n+12>>2]|0;if((a|0)!=(22860+(d>>>3<<1<<2)|0)){if(a>>>0<(c[5709]|0)>>>0)Ta();if((c[a+12>>2]|0)!=(n|0))Ta()}if((b|0)==(a|0)){c[5705]=c[5705]&~(1<<(d>>>3));break}if((b|0)!=(22860+(d>>>3<<1<<2)|0)){if(b>>>0<(c[5709]|0)>>>0)Ta();if((c[b+8>>2]|0)!=(n|0))Ta();else l=b+8|0}else l=b+8|0;c[a+12>>2]=b;c[l>>2]=a}while(0);c[q+4>>2]=f|1;c[q+f>>2]=f;if((q|0)==(c[5710]|0)){c[5707]=f;return}}else{c[n+4>>2]=d&-2;c[q+4>>2]=f|1;c[q+f>>2]=f}b=f>>>3;if(f>>>0<256){a=c[5705]|0;if(a&1<<b){a=c[22860+(b<<1<<2)+8>>2]|0;if(a>>>0<(c[5709]|0)>>>0)Ta();else{o=22860+(b<<1<<2)+8|0;p=a}}else{c[5705]=a|1<<b;o=22860+(b<<1<<2)+8|0;p=22860+(b<<1<<2)|0}c[o>>2]=q;c[p+12>>2]=q;c[q+8>>2]=p;c[q+12>>2]=22860+(b<<1<<2);return}a=f>>>8;if(a)if(f>>>0>16777215)d=31;else{d=a<<((a+1048320|0)>>>16&8)<<(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4);d=14-(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4|(a+1048320|0)>>>16&8|(d+245760|0)>>>16&2)+(d<<((d+245760|0)>>>16&2)>>>15)|0;d=f>>>(d+7|0)&1|d<<1}else d=0;e=23124+(d<<2)|0;c[q+28>>2]=d;c[q+20>>2]=0;c[q+16>>2]=0;a=c[5706]|0;b=1<<d;do if(a&b){d=f<<((d|0)==31?0:25-(d>>>1)|0);e=c[e>>2]|0;while(1){if((c[e+4>>2]&-8|0)==(f|0)){a=130;break}b=e+16+(d>>>31<<2)|0;a=c[b>>2]|0;if(!a){a=127;break}else{d=d<<1;e=a}}if((a|0)==127)if(b>>>0<(c[5709]|0)>>>0)Ta();else{c[b>>2]=q;c[q+24>>2]=e;c[q+12>>2]=q;c[q+8>>2]=q;break}else if((a|0)==130){a=e+8|0;b=c[a>>2]|0;p=c[5709]|0;if(b>>>0>=p>>>0&e>>>0>=p>>>0){c[b+12>>2]=q;c[a>>2]=q;c[q+8>>2]=b;c[q+12>>2]=e;c[q+24>>2]=0;break}else Ta()}}else{c[5706]=a|b;c[e>>2]=q;c[q+24>>2]=e;c[q+12>>2]=q;c[q+8>>2]=q}while(0);q=(c[5713]|0)+-1|0;c[5713]=q;if(!q)a=23276;else return;while(1){a=c[a>>2]|0;if(!a)break;else a=a+8|0}c[5713]=-1;return}function sG(){var a=0,b=0,d=0,e=0;e=i;i=i+48|0;if(cb(23316,3)|0)vG(19340,e);a=bb(c[5830]|0)|0;if(a|0?(d=c[a>>2]|0,d|0):0){a=c[d+48>>2]|0;b=c[d+48+4>>2]|0;if(!((a&-256|0)==1126902528&(b|0)==1129074247)){c[e+32>>2]=19519;vG(19614,e+32|0)}if((a|0)==1126902529&(b|0)==1129074247)a=c[d+44>>2]|0;else a=d+80|0;c[e+44>>2]=a;d=c[d>>2]|0;a=c[d+4>>2]|0;if(AG(2352,d,e+44|0)|0){d=c[e+44>>2]|0;d=vb[c[(c[d>>2]|0)+8>>2]&127](d)|0;c[e+8>>2]=19519;c[e+8+4>>2]=a;c[e+8+8>>2]=d;vG(19528,e+8|0)}else{c[e+24>>2]=19519;c[e+24+4>>2]=a;vG(19573,e+24|0)}}vG(19652,e+40|0)}function tG(){var a=0;a=i;i=i+16|0;if(!(eb(23320,219)|0)){i=a;return}else vG(19290,a)}function uG(a){a=a|0;var b=0;b=i;i=i+16|0;rG(a);if(!(gb(c[5830]|0,0)|0)){i=b;return}else vG(19237,b)}function vG(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;f=i;i=i+240|0;c[f+80>>2]=d;d=f+96|0;e=d+40|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(e|0));c[f+136>>2]=c[f+80>>2];if((gG(0,b,f+136|0,f,f+96|0)|0)>=0){d=c[2026]|0;if((a[8178]|0)<1)c[2026]=d&-33;if(!(c[2038]|0)){e=c[2037]|0;c[2037]=f+152;c[2033]=f+152;c[2031]=f+152;c[2038]=80;c[2030]=f+152+80;gG(8104,b,f+136|0,f,f+96|0)|0;if(e|0){Eb[c[8140>>2]&63](8104,0,0)|0;c[2037]=e;c[2038]=0;c[2030]=0;c[2033]=0;c[2031]=0}}else gG(8104,b,f+136|0,f,f+96|0)|0;c[2026]=c[2026]|d&32}d=(a[8179]|0)==10;do if((c[2045]|0)<0){if(!d?(g=c[2031]|0,g>>>0<(c[2030]|0)>>>0):0){c[2031]=g+1;a[g>>0]=10;break}pG(8104,10)|0}else{if(!d?(h=c[2031]|0,h>>>0<(c[2030]|0)>>>0):0){c[2031]=h+1;a[h>>0]=10;break}pG(8104,10)|0}while(0);Ta()}function wG(a){a=a|0;return}function xG(a){a=a|0;rG(a);return}function yG(a){a=a|0;return}function zG(a){a=a|0;return}function AG(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;g=i;i=i+64|0;if((a|0)!=(b|0))if((b|0)!=0?(f=BG(b,2360)|0,(f|0)!=0):0){b=g;e=b+56|0;do{c[b>>2]=0;b=b+4|0}while((b|0)<(e|0));c[g>>2]=f;c[g+8>>2]=a;c[g+12>>2]=-1;c[g+48>>2]=1;bc[c[(c[f>>2]|0)+28>>2]&127](f,g,c[d>>2]|0,1);if((c[g+24>>2]|0)==1){c[d>>2]=c[g+16>>2];b=1}else b=0}else b=0;else b=1;i=g;return b|0}function BG(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0;j=i;i=i+64|0;h=c[d>>2]|0;g=d+(c[h+-8>>2]|0)|0;h=c[h+-4>>2]|0;c[j>>2]=e;c[j+4>>2]=d;c[j+8>>2]=2392;d=j+12|0;f=d+40|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(f|0));b[j+12+40>>1]=0;a[j+12+42>>0]=0;a:do if((h|0)==(e|0)){c[j+48>>2]=1;Fb[c[(c[e>>2]|0)+20>>2]&7](e,j,g,g,1,0);d=(c[j+24>>2]|0)==1?g:0}else{pb[c[(c[h>>2]|0)+24>>2]&31](h,j,g,1,0);switch(c[j+36>>2]|0){case 0:{d=((c[j+40>>2]|0)==1?(c[j+28>>2]|0)==1:0)&(c[j+32>>2]|0)==1?c[j+20>>2]|0:0;break a}case 1:break;default:{d=0;break a}}if((c[j+24>>2]|0)!=1?!(((c[j+40>>2]|0)==0?(c[j+28>>2]|0)==1:0)&(c[j+32>>2]|0)==1):0){d=0;break}d=c[j+16>>2]|0}while(0);i=j;return d|0}function CG(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;if((a|0)==(c[b+8>>2]|0))DG(b,d,e,f);else{a=c[a+8>>2]|0;Fb[c[(c[a>>2]|0)+20>>2]&7](a,b,d,e,f,g)}return}function DG(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;a[b+53>>0]=1;do if((c[b+4>>2]|0)==(e|0)){a[b+52>>0]=1;e=c[b+16>>2]|0;if(!e){c[b+16>>2]=d;c[b+24>>2]=f;c[b+36>>2]=1;if(!((f|0)==1?(c[b+48>>2]|0)==1:0))break;a[b+54>>0]=1;break}if((e|0)!=(d|0)){c[b+36>>2]=(c[b+36>>2]|0)+1;a[b+54>>0]=1;break}e=c[b+24>>2]|0;if((e|0)==2){c[b+24>>2]=f;e=f}if((e|0)==1?(c[b+48>>2]|0)==1:0)a[b+54>>0]=1}while(0);return}function EG(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;do if((b|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)==(e|0)?(c[d+28>>2]|0)!=1:0)c[d+28>>2]=f}else{if((b|0)!=(c[d>>2]|0)){b=c[b+8>>2]|0;pb[c[(c[b>>2]|0)+24>>2]&31](b,d,e,f,g);break}if((c[d+16>>2]|0)!=(e|0)?(c[d+20>>2]|0)!=(e|0):0){c[d+32>>2]=f;if((c[d+44>>2]|0)==4)break;a[d+52>>0]=0;a[d+53>>0]=0;b=c[b+8>>2]|0;Fb[c[(c[b>>2]|0)+20>>2]&7](b,d,e,e,1,g);if(a[d+53>>0]|0)if(!(a[d+52>>0]|0)){f=1;b=13}else b=17;else{f=0;b=13}do if((b|0)==13){c[d+20>>2]=e;c[d+40>>2]=(c[d+40>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0){a[d+54>>0]=1;if(f){b=17;break}else{f=4;break}}if(f)b=17;else f=4}while(0);if((b|0)==17)f=3;c[d+44>>2]=f;break}if((f|0)==1)c[d+32>>2]=1}while(0);return}function FG(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;do if((b|0)==(c[d+8>>2]|0)){b=c[d+16>>2]|0;if(!b){c[d+16>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;break}if((b|0)!=(e|0)){c[d+36>>2]=(c[d+36>>2]|0)+1;c[d+24>>2]=2;a[d+54>>0]=1;break}if((c[d+24>>2]|0)==2)c[d+24>>2]=f}else{b=c[b+8>>2]|0;bc[c[(c[b>>2]|0)+28>>2]&127](b,d,e,f)}while(0);return}function GG(a){a=a|0;rG(a);return}function HG(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;if((a|0)==(c[b+8>>2]|0))DG(b,d,e,f);return}function IG(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;do if((b|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)==(e|0)?(c[d+28>>2]|0)!=1:0)c[d+28>>2]=f}else if((b|0)==(c[d>>2]|0)){if((c[d+16>>2]|0)!=(e|0)?(c[d+20>>2]|0)!=(e|0):0){c[d+32>>2]=f;c[d+20>>2]=e;c[d+40>>2]=(c[d+40>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0)a[d+54>>0]=1;c[d+44>>2]=4;break}if((f|0)==1)c[d+32>>2]=1}while(0);return}function JG(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;do if((b|0)==(c[d+8>>2]|0)){b=c[d+16>>2]|0;if(!b){c[d+16>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;break}if((b|0)!=(e|0)){c[d+36>>2]=(c[d+36>>2]|0)+1;c[d+24>>2]=2;a[d+54>>0]=1;break}if((c[d+24>>2]|0)==2)c[d+24>>2]=f}while(0);return}function KG(a){a=a|0;return}function LG(a){a=a|0;rG(a);return}function MG(a){a=a|0;return 19717}function NG(a){a=a|0;rG(a);return}function OG(d,e,f,g,h,i){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0;if((d|0)==(c[e+8>>2]|0))DG(e,f,g,h);else{l=b[e+52>>1]|0;j=c[d+12>>2]|0;a[e+52>>0]=0;a[e+53>>0]=0;PG(d+16|0,e,f,g,h,i);a:do if((j|0)>1){m=d+24|0;do{if(a[e+54>>0]|0)break a;k=b[e+52>>1]|0;if(!((k&255)<<24>>24)){if((k&65535)>=256?(c[d+8>>2]&1|0)==0:0)break a}else{if((c[e+24>>2]|0)==1)break a;if(!(c[d+8>>2]&2))break a}a[e+52>>0]=0;a[e+53>>0]=0;PG(m,e,f,g,h,i);m=m+8|0}while(m>>>0<(d+16+(j<<3)|0)>>>0)}while(0);a[e+52>>0]=l;a[e+53>>0]=(l&65535)>>>8}return}function PG(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0;h=c[a+4>>2]|0;if(!(h&1))i=h>>8;else i=c[(c[e>>2]|0)+(h>>8)>>2]|0;a=c[a>>2]|0;Fb[c[(c[a>>2]|0)+20>>2]&7](a,b,d,e+i|0,h&2|0?f:2,g);return}function QG(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0;a:do if((b|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)==(e|0)?(c[d+28>>2]|0)!=1:0)c[d+28>>2]=f}else{if((b|0)!=(c[d>>2]|0)){i=c[b+12>>2]|0;RG(b+16|0,d,e,f,g);if((i|0)<=1)break;h=c[b+8>>2]|0;if((h&2|0)==0?(c[d+36>>2]|0)!=1:0){if(!(h&1)){h=b+24|0;while(1){if(a[d+54>>0]|0)break a;if((c[d+36>>2]|0)==1)break a;RG(h,d,e,f,g);h=h+8|0;if(h>>>0>=(b+16+(i<<3)|0)>>>0)break a}}h=b+24|0;while(1){if(a[d+54>>0]|0)break a;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==1:0)break a;RG(h,d,e,f,g);h=h+8|0;if(h>>>0>=(b+16+(i<<3)|0)>>>0)break a}}h=b+24|0;while(1){if(a[d+54>>0]|0)break a;RG(h,d,e,f,g);h=h+8|0;if(h>>>0>=(b+16+(i<<3)|0)>>>0)break a}}if((c[d+16>>2]|0)!=(e|0)?(c[d+20>>2]|0)!=(e|0):0){c[d+32>>2]=f;if((c[d+44>>2]|0)==4)break;f=b+16+(c[b+12>>2]<<3)|0;k=0;h=0;j=b+16|0;b:while(1){if(j>>>0>=f>>>0){i=20;break}a[d+52>>0]=0;a[d+53>>0]=0;PG(j,d,e,e,1,g);if(a[d+54>>0]|0){i=20;break}do if(a[d+53>>0]|0){if(!(a[d+52>>0]|0))if(!(c[b+8>>2]&1)){h=1;i=20;break b}else{i=k;h=1;break}if((c[d+24>>2]|0)==1){i=25;break b}if(!(c[b+8>>2]&2)){i=25;break b}else{i=1;h=1}}else i=k;while(0);k=i;j=j+8|0}do if((i|0)==20){if((!k?(c[d+20>>2]=e,c[d+40>>2]=(c[d+40>>2]|0)+1,(c[d+36>>2]|0)==1):0)?(c[d+24>>2]|0)==2:0){a[d+54>>0]=1;if(h){i=25;break}else{h=4;break}}if(h)i=25;else h=4}while(0);if((i|0)==25)h=3;c[d+44>>2]=h;break}if((f|0)==1)c[d+32>>2]=1}while(0);return}function RG(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=c[a+4>>2]|0;if(!(g&1))h=g>>8;else h=c[(c[d>>2]|0)+(g>>8)>>2]|0;a=c[a>>2]|0;pb[c[(c[a>>2]|0)+24>>2]&31](a,b,d+h|0,g&2|0?e:2,f);return}function SG(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;a:do if((b|0)==(c[d+8>>2]|0)){g=c[d+16>>2]|0;if(!g){c[d+16>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;break}if((g|0)!=(e|0)){c[d+36>>2]=(c[d+36>>2]|0)+1;c[d+24>>2]=2;a[d+54>>0]=1;break}if((c[d+24>>2]|0)==2)c[d+24>>2]=f}else{g=c[b+12>>2]|0;TG(b+16|0,d,e,f);if((g|0)>1){h=b+24|0;do{TG(h,d,e,f);if(a[d+54>>0]|0)break a;h=h+8|0}while(h>>>0<(b+16+(g<<3)|0)>>>0)}}while(0);return}function TG(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=c[a+4>>2]|0;if(!(f&1))g=f>>8;else g=c[(c[d>>2]|0)+(f>>8)>>2]|0;a=c[a>>2]|0;bc[c[(c[a>>2]|0)+28>>2]&127](a,b,d+g|0,f&2|0?e:2);return}function UG(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;i=i+16|0;c[e>>2]=c[d>>2];a=Eb[c[(c[a>>2]|0)+16>>2]&63](a,b,e)|0;if(a)c[d>>2]=c[e>>2];i=e;return a&1|0}function VG(a){a=a|0;if(!a)a=0;else a=(BG(a,2448)|0)!=0;return a&1|0}function WG(){}function XG(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;d=b-d-(c>>>0>a>>>0|0)>>>0;return (C=d,a-c>>>0|0)|0}function YG(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return (C=b+d+(a+c>>>0>>>0<a>>>0|0)>>>0,a+c>>>0|0)|0}function ZG(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=b+e|0;if((e|0)>=20){d=d&255;g=b&3;h=d|d<<8|d<<16|d<<24;if(g){g=b+4-g|0;while((b|0)<(g|0)){a[b>>0]=d;b=b+1|0}}while((b|0)<(f&~3|0)){c[b>>2]=h;b=b+4|0}}while((b|0)<(f|0)){a[b>>0]=d;b=b+1|0}return b-e|0}function _G(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){C=b<<c|(a&(1<<c)-1<<32-c)>>>32-c;return a<<c}C=a<<c-32;return 0}function $G(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){C=b>>c;return a>>>c|(b&(1<<c)-1)<<32-c}C=(b|0)<0?-1:0;return b>>c-32|0}function aH(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){C=b>>>c;return a>>>c|(b&(1<<c)-1)<<32-c}C=0;return b>>>c-32|0}function bH(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;if((e|0)>=4096)return _a(b|0,d|0,e|0)|0;f=b|0;if((b&3)==(d&3)){while(b&3){if(!e)return f|0;a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0;e=e-1|0}while((e|0)>=4){c[b>>2]=c[d>>2];b=b+4|0;d=d+4|0;e=e-4|0}}while((e|0)>0){a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0;e=e-1|0}return f|0}function cH(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;if((c|0)<(b|0)&(b|0)<(c+d|0)){e=b;c=c+d|0;b=b+d|0;while((d|0)>0){b=b-1|0;c=c-1|0;d=d-1|0;a[b>>0]=a[c>>0]|0}b=e}else bH(b,c,d)|0;return b|0}function dH(a){a=a|0;return (a&255)<<24|(a>>8&255)<<16|(a>>16&255)<<8|a>>>24|0}function eH(){return 0}function fH(b){b=b|0;var c=0;c=a[m+(b&255)>>0]|0;if((c|0)<8)return c|0;c=a[m+(b>>8&255)>>0]|0;if((c|0)<8)return c+8|0;c=a[m+(b>>16&255)>>0]|0;if((c|0)<8)return c+16|0;return (a[m+(b>>>24)>>0]|0)+24|0}function gH(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=_(b&65535,a&65535)|0;e=(c>>>16)+(_(b&65535,a>>>16)|0)|0;d=_(b>>>16,a&65535)|0;return (C=(e>>>16)+(_(b>>>16,a>>>16)|0)+(((e&65535)+d|0)>>>16)|0,e+d<<16|c&65535|0)|0}function hH(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0;g=b>>31|((b|0)<0?-1:0)<<1;e=((b|0)<0?-1:0)>>31|((b|0)<0?-1:0)<<1;h=d>>31|((d|0)<0?-1:0)<<1;f=((d|0)<0?-1:0)>>31|((d|0)<0?-1:0)<<1;a=XG(g^a|0,e^b|0,g|0,e|0)|0;b=C;return XG((mH(a,b,XG(h^c|0,f^d|0,h|0,f|0)|0,C,0)|0)^(h^g)|0,C^(f^e)|0,h^g|0,f^e|0)|0}function iH(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;f=i;i=i+16|0;h=b>>31|((b|0)<0?-1:0)<<1;g=((b|0)<0?-1:0)>>31|((b|0)<0?-1:0)<<1;k=e>>31|((e|0)<0?-1:0)<<1;j=((e|0)<0?-1:0)>>31|((e|0)<0?-1:0)<<1;a=XG(h^a|0,g^b|0,h|0,g|0)|0;b=C;mH(a,b,XG(k^d|0,j^e|0,k|0,j|0)|0,C,f|0)|0;e=XG(c[f>>2]^h|0,c[f+4>>2]^g|0,h|0,g|0)|0;d=C;i=f;return (C=d,e)|0}function jH(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;e=gH(a,c)|0;f=C;return (C=(_(b,c)|0)+(_(d,a)|0)+f|f&0,e|0|0)|0}function kH(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return mH(a,b,c,d,0)|0}function lH(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+16|0;mH(a,b,d,e,f|0)|0;i=f;return (C=c[f+4>>2]|0,c[f>>2]|0)|0}function mH(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;if(!b)if(!e){if(f|0){c[f>>2]=(a>>>0)%(d>>>0);c[f+4>>2]=0}e=0;f=(a>>>0)/(d>>>0)>>>0;return (C=e,f)|0}else{if(!f){e=0;f=0;return (C=e,f)|0}c[f>>2]=a|0;c[f+4>>2]=b&0;e=0;f=0;return (C=e,f)|0}do if(d){if(e|0){h=(aa(e|0)|0)-(aa(b|0)|0)|0;if(h>>>0<=31){n=h+1|0;i=a>>>((h+1|0)>>>0)&h-31>>31|b<<31-h;m=b>>>((h+1|0)>>>0)&h-31>>31;g=0;h=a<<31-h;break}if(!f){e=0;f=0;return (C=e,f)|0}c[f>>2]=a|0;c[f+4>>2]=b|b&0;e=0;f=0;return (C=e,f)|0}if(d-1&d|0){h=(aa(d|0)|0)+33-(aa(b|0)|0)|0;n=h;i=32-h-1>>31&b>>>((h-32|0)>>>0)|(b<<32-h|a>>>(h>>>0))&h-32>>31;m=h-32>>31&b>>>(h>>>0);g=a<<64-h&32-h>>31;h=(b<<64-h|a>>>((h-32|0)>>>0))&32-h>>31|a<<32-h&h-33>>31;break}if(f|0){c[f>>2]=d-1&a;c[f+4>>2]=0}if((d|0)==1){e=b|b&0;f=a|0|0;return (C=e,f)|0}else{f=fH(d|0)|0;e=b>>>(f>>>0)|0;f=b<<32-f|a>>>(f>>>0)|0;return (C=e,f)|0}}else{if(!e){if(f|0){c[f>>2]=(b>>>0)%(d>>>0);c[f+4>>2]=0}e=0;f=(b>>>0)/(d>>>0)>>>0;return (C=e,f)|0}if(!a){if(f|0){c[f>>2]=0;c[f+4>>2]=(b>>>0)%(e>>>0)}d=0;f=(b>>>0)/(e>>>0)>>>0;return (C=d,f)|0}if(!(e-1&e)){if(f|0){c[f>>2]=a|0;c[f+4>>2]=e-1&b|b&0}d=0;f=b>>>((fH(e|0)|0)>>>0);return (C=d,f)|0}h=(aa(e|0)|0)-(aa(b|0)|0)|0;if(h>>>0<=30){n=h+1|0;i=b<<31-h|a>>>((h+1|0)>>>0);m=b>>>((h+1|0)>>>0);g=0;h=a<<31-h;break}if(!f){e=0;f=0;return (C=e,f)|0}c[f>>2]=a|0;c[f+4>>2]=b|b&0;e=0;f=0;return (C=e,f)|0}while(0);if(!n){j=h;b=m;a=0;h=0}else{k=YG(d|0|0,e|e&0|0,-1,-1)|0;l=C;j=h;b=m;a=n;h=0;do{p=j;j=g>>>31|j<<1;g=h|g<<1;p=i<<1|p>>>31|0;o=i>>>31|b<<1|0;XG(k|0,l|0,p|0,o|0)|0;n=C;m=n>>31|((n|0)<0?-1:0)<<1;h=m&1;i=XG(p|0,o|0,m&(d|0)|0,(((n|0)<0?-1:0)>>31|((n|0)<0?-1:0)<<1)&(e|e&0)|0)|0;b=C;a=a-1|0}while((a|0)!=0);a=0}if(f|0){c[f>>2]=i;c[f+4>>2]=b}o=(g|0)>>>31|j<<1|(0<<1|g>>>31)&0|a;p=(g<<1|0>>>31)&-2|h;return (C=o,p)|0}function nH(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;pb[a&31](b|0,c|0,d|0,e|0,f|0)}function oH(a,b,c){a=a|0;b=b|0;c=+c;qb[a&31](b|0,+c)}function pH(a,b){a=a|0;b=b|0;rb[a&255](b|0)}function qH(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;sb[a&0](b|0,c|0,d|0,+e,f|0,g|0)}function rH(a,b,c){a=a|0;b=b|0;c=c|0;tb[a&127](b|0,c|0)}function sH(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;return ub[a&3](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0,j|0,k|0)|0}function tH(a,b){a=a|0;b=b|0;return vb[a&127](b|0)|0}function uH(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;wb[a&7](b|0,c|0,+d,e|0)}function vH(a,b,c,d,e,f,g){a=a|0;b=b|0;c=+c;d=+d;e=e|0;f=f|0;g=g|0;xb[a&0](b|0,+c,+d,e|0,f|0,g|0)}function wH(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;yb[a&0](b|0,+c,d|0,e|0)}function xH(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return zb[a&31](b|0,c|0,d|0,e|0)|0}function yH(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;Ab[a&15](b|0,+c,d|0)}function zH(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;return +Bb[a&1](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0)}function AH(a,b,c,d,e,f,g,h,i,j,k,l){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;g=+g;h=+h;i=+i;j=j|0;k=k|0;l=+l;Cb[a&0](b|0,c|0,d|0,e|0,+f,+g,+h,+i,j|0,k|0,+l)}function BH(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return +Db[a&15](b|0,c|0,d|0,e|0,f|0)}function CH(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return Eb[a&63](b|0,c|0,d|0)|0}function DH(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Fb[a&7](b|0,c|0,d|0,e|0,f|0,g|0)}function EH(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;return Gb[a&7](b|0,c|0,+d)|0}function FH(a,b){a=a|0;b=b|0;return +Hb[a&15](b|0)}function GH(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;return Ib[a&3](b|0,c|0,d|0,e|0,f|0,g|0)|0}function HH(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;return +Jb[a&3](b|0,c|0,d|0,+e,f|0,g|0)}function IH(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;f=f|0;Kb[a&0](b|0,c|0,+d,e|0,f|0)}function JH(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;Lb[a&3](b|0,c|0,d|0,e|0,f|0,g|0,h|0)}function KH(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;Mb[a&1](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0,j|0)}function LH(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;Nb[a&3](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0,j|0,k|0)}function MH(a,b,c){a=a|0;b=b|0;c=c|0;return Ob[a&31](b|0,c|0)|0}function NH(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return +Pb[a&15](b|0,c|0,d|0)}function OH(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;return +Qb[a&3](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0,j|0,k|0)}function PH(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;Rb[a&1](b|0,c|0,d|0,e|0,+f)}function QH(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;return +Sb[a&3](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0,j|0)}function RH(a,b,c){a=a|0;b=b|0;c=+c;return +Tb[a&1](b|0,+c)}function SH(a,b,c,d,e,f,g,h,i,j,k,l,m){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;g=+g;h=+h;i=+i;j=+j;k=k|0;l=+l;m=m|0;Ub[a&0](b|0,c|0,d|0,e|0,+f,+g,+h,+i,+j,k|0,+l,m|0)}function TH(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;f=f|0;return +Vb[a&3](b|0,c|0,+d,e|0,f|0)}function UH(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return +Wb[a&1](b|0,c|0,d|0,e|0)}function VH(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;return Xb[a&3](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0,j|0)|0}function WH(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;Yb[a&15](b|0,c|0,d|0,+e)}function XH(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;Zb[a&127](b|0,c|0,d|0)}function YH(a){a=a|0;_b[a&3]()}function ZH(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;$b[a&7](b|0,c|0,+d)}function _H(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=+e;return ac[a&1](b|0,+c,d|0,+e)|0}function $H(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;bc[a&127](b|0,c|0,d|0,e|0)}function aI(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;ba(0)}function bI(a,b){a=a|0;b=+b;ba(1)}function cI(a){a=a|0;ba(2)}function dI(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;f=f|0;ba(3)}function eI(a,b){a=a|0;b=b|0;ba(4)}function fI(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;ba(5);return 0}function gI(a){a=a|0;ba(6);return 0}function hI(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;ba(7)}function iI(a,b,c,d,e,f){a=a|0;b=+b;c=+c;d=d|0;e=e|0;f=f|0;ba(8)}function jI(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;ba(9)}function kI(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ba(10);return 0}function lI(a,b,c){a=a|0;b=+b;c=c|0;ba(11)}function mI(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;ba(12);return 0.0}function nI(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=+f;g=+g;h=+h;i=i|0;j=j|0;k=+k;ba(13)}function oI(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;ba(14);return 0.0}function pI(a,b,c){a=a|0;b=b|0;c=c|0;ba(15);return 0}function qI(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;ba(16)}function rI(a,b,c){a=a|0;b=b|0;c=+c;ba(17);return 0}function sI(a){a=a|0;ba(18);return 0.0}function tI(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;ba(19);return 0}function uI(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;f=f|0;ba(20);return 0.0}function vI(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;ba(21)}function wI(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;ba(22)}function xI(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;ba(23)}function yI(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;ba(24)}function zI(a,b){a=a|0;b=b|0;ba(25);return 0}function AI(a,b,c){a=a|0;b=b|0;c=c|0;ba(26);return 0.0}function BI(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;ba(27);return 0.0}function CI(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;ba(28)}function DI(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;ba(29);return 0.0}function EI(a,b){a=a|0;b=+b;ba(30);return 0.0}function FI(a,b,c,d,e,f,g,h,i,j,k,l){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=+f;g=+g;h=+h;i=+i;j=j|0;k=+k;l=l|0;ba(31)}function GI(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;ba(32);return 0.0}function HI(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ba(33);return 0.0}function II(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;ba(34);return 0}function JI(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;ba(35)}function KI(a,b,c){a=a|0;b=b|0;c=c|0;ba(36)}function LI(){ba(37)}function MI(){mb()}function NI(a,b,c){a=a|0;b=b|0;c=+c;ba(38)}function OI(a,b,c,d){a=a|0;b=+b;c=c|0;d=+d;ba(39);return 0}function PI(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ba(40)}
function Lr(b,d){b=b|0;d=+d;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0.0,F=0.0;C=i;i=i+64|0;e=c[b+128>>2]|0;if((e|0)>0){f=0;do{Mr(c[b+108>>2]|0,c[b+136>>2]|0,f,0);f=f+1|0;e=c[b+128>>2]|0}while((f|0)<(e|0))}f=c[b+108>>2]|0;t=+g[f+336>>2];u=+g[f+340>>2];h=+g[f+344>>2];h=+O(+(t*t+u*u+h*h))*3.5999999046325684;g[b+104>>2]=h;B=c[b+120>>2]|0;if(+g[f+4+(B<<2)>>2]*+g[f+336>>2]+ +g[f+20+(B<<2)>>2]*+g[f+340>>2]+ +g[f+36+(B<<2)>>2]*+g[f+344>>2]<0.0)g[b+104>>2]=-h;if((e|0)>0){B=0;do{A=c[b+136>>2]|0;p=A+(B*284|0)|0;Nr(f,p,0);o=A+(B*284|0)+204|0;e=A+(B*284|0)+212|0;h=+g[o>>2]+ +g[e>>2];q=A+(B*284|0)+52|0;v=A+(B*284|0)+56|0;w=A+(B*284|0)+60|0;D=A+(B*284|0)+36|0;x=A+(B*284|0)+16|0;t=h*+g[v>>2]+ +g[A+(B*284|0)+40>>2];u=h*+g[w>>2]+ +g[A+(B*284|0)+44>>2];g[A+(B*284|0)+16>>2]=+g[q>>2]*h+ +g[D>>2];y=A+(B*284|0)+20|0;g[y>>2]=t;z=A+(B*284|0)+24|0;g[z>>2]=u;g[A+(B*284|0)+28>>2]=0.0;g[C+32>>2]=-1.0;f=c[b+92>>2]|0;D=zb[c[(c[f>>2]|0)+8>>2]&31](f,D,x,C)|0;f=A+(B*284|0)+88|0;c[f>>2]=0;do if(D){h=h*+g[C+32>>2];c[p>>2]=c[C+16>>2];c[p+4>>2]=c[C+16+4>>2];c[p+8>>2]=c[C+16+8>>2];c[p+12>>2]=c[C+16+12>>2];a[A+(B*284|0)+84>>0]=1;if(!(a[19888]|0)){a[19888]=1;c[C+40>>2]=0;c[C+40+4>>2]=0;c[C+40+8>>2]=0;c[C+40+12>>2]=0;Cr(21908,0.0,0,0,C+40|0)}c[5528]=c[5528]|1;g[5569]=0.0;j=+g[5579]*0.0;k=+g[5580]*0.0;g[5574]=+g[5578]*0.0;g[5575]=j;g[5576]=k;g[5577]=0.0;c[5582]=0;c[5583]=0;c[5584]=0;c[5585]=0;k=+g[5571]*0.0;j=+g[5572]*0.0;g[5623]=+g[5570]*0.0;g[5624]=k;g[5625]=j;g[5626]=0.0;c[f>>2]=21908;h=h-+g[e>>2];e=A+(B*284|0)+32|0;g[e>>2]=h;j=+g[o>>2];k=+g[A+(B*284|0)+208>>2]*.009999999776482582;if(h<j-k){g[e>>2]=j-k;h=j-k}if(h>j+k)g[e>>2]=j+k;c[x>>2]=c[C>>2];c[x+4>>2]=c[C+4>>2];c[x+8>>2]=c[C+8>>2];c[x+12>>2]=c[C+12>>2];s=+g[p>>2];t=+g[A+(B*284|0)+4>>2];u=+g[A+(B*284|0)+8>>2];r=s*+g[q>>2]+t*+g[v>>2]+u*+g[w>>2];e=c[b+108>>2]|0;n=+g[x>>2]-+g[e+52>>2];m=+g[y>>2]-+g[e+56>>2];h=+g[z>>2]-+g[e+60>>2];j=+g[e+356>>2];k=+g[e+360>>2];l=+g[e+352>>2];if(!(r>=-.10000000149011612)){g[A+(B*284|0)+272>>2]=-1.0/r*(s*(j*h-m*k+ +g[e+336>>2])+t*(n*k-h*l+ +g[e+340>>2])+u*(m*l-n*j+ +g[e+344>>2]));g[A+(B*284|0)+268>>2]=-1.0/r;break}else{g[A+(B*284|0)+272>>2]=0.0;g[A+(B*284|0)+268>>2]=10.0;break}}else{c[A+(B*284|0)+32>>2]=c[o>>2];g[A+(B*284|0)+272>>2]=0.0;t=-+g[v>>2];u=-+g[w>>2];g[p>>2]=-+g[q>>2];g[A+(B*284|0)+4>>2]=t;g[A+(B*284|0)+8>>2]=u;g[A+(B*284|0)+12>>2]=0.0;g[A+(B*284|0)+268>>2]=1.0}while(0);B=B+1|0;e=c[b+128>>2]|0;f=c[b+108>>2]|0}while((B|0)<(e|0));j=1.0/+g[f+368>>2];if((e|0)>0){f=0;do{e=c[b+136>>2]|0;if(!(a[e+(f*284|0)+84>>0]|0))h=0.0;else{h=+g[e+(f*284|0)+272>>2];h=j*(+g[e+(f*284|0)+216>>2]*(+g[e+(f*284|0)+204>>2]-+g[e+(f*284|0)+32>>2])*+g[e+(f*284|0)+268>>2]-h*+g[(h<0.0?e+(f*284|0)+220|0:e+(f*284|0)+224|0)>>2]);h=h<0.0?0.0:h}g[e+(f*284|0)+276>>2]=h;f=f+1|0;e=c[b+128>>2]|0}while((f|0)<(e|0));if((e|0)>0){e=0;do{B=c[b+136>>2]|0;s=+g[B+(e*284|0)+276>>2];u=+g[B+(e*284|0)+248>>2];s=s>u?u:s;u=s*+g[B+(e*284|0)+4>>2]*d;t=s*+g[B+(e*284|0)+8>>2]*d;g[C+40>>2]=+g[B+(e*284|0)>>2]*s*d;g[C+40+4>>2]=u;g[C+40+8>>2]=t;g[C+40+12>>2]=0.0;D=c[b+108>>2]|0;t=+g[B+(e*284|0)+20>>2]-+g[D+56>>2];u=+g[B+(e*284|0)+24>>2]-+g[D+60>>2];g[C>>2]=+g[B+(e*284|0)+16>>2]-+g[D+52>>2];g[C+4>>2]=t;g[C+8>>2]=u;g[C+12>>2]=0.0;Uo(D,C+40|0,C);e=e+1|0}while((e|0)<(c[b+128>>2]|0))}}}qb[c[(c[b>>2]|0)+20>>2]&31](b,d);f=c[b+128>>2]|0;if((f|0)<=0){i=C;return}o=c[b+136>>2]|0;p=c[b+108>>2]|0;q=0;do{h=+g[o+(q*284|0)+36>>2]-+g[p+52>>2];j=+g[o+(q*284|0)+40>>2]-+g[p+56>>2];k=+g[o+(q*284|0)+44>>2]-+g[p+60>>2];l=+g[p+356>>2];m=+g[p+360>>2];n=+g[p+352>>2];if(!(a[o+(q*284|0)+84>>0]|0)){e=o+(q*284|0)+240|0;h=+g[e>>2];D=o+(q*284|0)+236|0;g[D>>2]=h+ +g[D>>2]}else{e=c[b+120>>2]|0;F=+g[p+4+(e<<2)>>2];r=+g[p+20+(e<<2)>>2];t=+g[p+36+(e<<2)>>2];E=+g[o+(q*284|0)>>2];s=+g[o+(q*284|0)+4>>2];u=+g[o+(q*284|0)+8>>2];h=((j*n-h*l+ +g[p+344>>2])*(t-u*(F*E+r*s+t*u))+((l*k-j*m+ +g[p+336>>2])*(F-E*(F*E+r*s+t*u))+(h*m-k*n+ +g[p+340>>2])*(r-s*(F*E+r*s+t*u))))*d/+g[o+(q*284|0)+212>>2];e=o+(q*284|0)+240|0;g[e>>2]=h;D=o+(q*284|0)+236|0;g[D>>2]=+g[D>>2]+h}g[e>>2]=h*.9900000095367432;q=q+1|0}while((q|0)!=(f|0));i=C;return}function Mr(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;Nr(a,b+(c*284|0)|0,d);m=+g[b+(c*284|0)+52>>2];h=+g[b+(c*284|0)+56>>2];q=+g[b+(c*284|0)+60>>2];G=+g[b+(c*284|0)+76>>2];x=+g[b+(c*284|0)+72>>2];z=+g[b+(c*284|0)+68>>2];w=1.0/+O(+((x*-m-z*-h)*(x*-m-z*-h)+((G*-h-x*-q)*(G*-h-x*-q)+(z*-q-G*-m)*(z*-q-G*-m))));v=(G*-h-x*-q)*w;u=w*(z*-q-G*-m);w=w*(x*-m-z*-h);e=+g[b+(c*284|0)+232>>2]*.5;k=+R(+e)/+O(+(m*m+h*h+q*q));e=+Q(+e);l=2.0/(e*e+(k*-q*(k*-q)+(k*-m*(k*-m)+k*-h*(k*-h))));E=1.0-(k*-h*(k*-h*l)+k*-q*(k*-q*l));D=k*-m*(k*-h*l)-e*(k*-q*l);F=k*-m*(k*-q*l)+e*(k*-h*l);B=k*-m*(k*-h*l)+e*(k*-q*l);A=1.0-(k*-m*(k*-m*l)+k*-q*(k*-q*l));C=k*-h*(k*-q*l)-e*(k*-m*l);j=k*-m*(k*-q*l)-e*(k*-h*l);e=k*-h*(k*-q*l)+e*(k*-m*l);l=1.0-(k*-m*(k*-m*l)+k*-h*(k*-h*l));k=+g[b+(c*284|0)+236>>2]*-.5;y=+R(+k)/+O(+(G*G+(x*x+z*z)));k=+Q(+k);r=2.0/(k*k+(G*y*(G*y)+(z*y*(z*y)+x*y*(x*y))));n=1.0-(x*y*(x*y*r)+G*y*(G*y*r));i=z*y*(x*y*r)-k*(G*y*r);t=z*y*(G*y*r)+k*(x*y*r);o=z*y*(x*y*r)+k*(G*y*r);f=1.0-(z*y*(z*y*r)+G*y*(G*y*r));s=x*y*(G*y*r)-k*(z*y*r);p=z*y*(G*y*r)-k*(x*y*r);k=x*y*(G*y*r)+k*(z*y*r);r=1.0-(z*y*(z*y*r)+x*y*(x*y*r));y=+g[b+(c*284|0)+68>>2];x=+g[b+(c*284|0)+72>>2];z=+g[b+(c*284|0)+76>>2];g[b+(c*284|0)+92>>2]=z*(E*t+D*s+F*r)+(y*(F*p+(D*o+E*n))+x*(F*k+(E*i+D*f)));g[b+(c*284|0)+96>>2]=w*(E*t+D*s+F*r)+(v*(F*p+(D*o+E*n))+u*(F*k+(E*i+D*f)));g[b+(c*284|0)+100>>2]=(E*t+D*s+F*r)*-q+((F*p+(D*o+E*n))*-m+(F*k+(E*i+D*f))*-h);g[b+(c*284|0)+104>>2]=0.0;g[b+(c*284|0)+108>>2]=z*(B*t+A*s+C*r)+(y*(C*p+(A*o+B*n))+x*(C*k+(B*i+A*f)));g[b+(c*284|0)+112>>2]=w*(B*t+A*s+C*r)+(v*(C*p+(A*o+B*n))+u*(C*k+(B*i+A*f)));g[b+(c*284|0)+116>>2]=(B*t+A*s+C*r)*-q+((C*p+(A*o+B*n))*-m+(C*k+(B*i+A*f))*-h);g[b+(c*284|0)+120>>2]=0.0;g[b+(c*284|0)+124>>2]=z*(j*t+e*s+l*r)+(y*(l*p+(e*o+j*n))+x*(l*k+(j*i+e*f)));g[b+(c*284|0)+128>>2]=w*(j*t+e*s+l*r)+(v*(l*p+(e*o+j*n))+u*(l*k+(j*i+e*f)));g[b+(c*284|0)+132>>2]=(j*t+e*s+l*r)*-q+((l*p+(e*o+j*n))*-m+(l*k+(j*i+e*f))*-h);g[b+(c*284|0)+136>>2]=0.0;h=+g[b+(c*284|0)+32>>2];f=h*+g[b+(c*284|0)+56>>2]+ +g[b+(c*284|0)+40>>2];e=h*+g[b+(c*284|0)+60>>2]+ +g[b+(c*284|0)+44>>2];g[b+(c*284|0)+140>>2]=+g[b+(c*284|0)+52>>2]*h+ +g[b+(c*284|0)+36>>2];g[b+(c*284|0)+144>>2]=f;g[b+(c*284|0)+148>>2]=e;g[b+(c*284|0)+152>>2]=0.0;return}function Nr(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;h=i;i=i+64|0;a[d+84>>0]=0;c[h>>2]=c[b+4>>2];c[h+4>>2]=c[b+4+4>>2];c[h+8>>2]=c[b+4+8>>2];c[h+12>>2]=c[b+4+12>>2];c[h+16>>2]=c[b+20>>2];c[h+16+4>>2]=c[b+20+4>>2];c[h+16+8>>2]=c[b+20+8>>2];c[h+16+12>>2]=c[b+20+12>>2];c[h+32>>2]=c[b+36>>2];c[h+32+4>>2]=c[b+36+4>>2];c[h+32+8>>2]=c[b+36+8>>2];c[h+32+12>>2]=c[b+36+12>>2];c[h+48>>2]=c[b+52>>2];c[h+48+4>>2]=c[b+52+4>>2];c[h+48+8>>2]=c[b+52+8>>2];c[h+48+12>>2]=c[b+52+12>>2];if(e?(f=c[b+504>>2]|0,f|0):0)tb[c[(c[f>>2]|0)+8>>2]&127](f,h);w=+g[d+156>>2];u=+g[h>>2];v=+g[d+160>>2];t=+g[h+4>>2];o=+g[d+164>>2];s=+g[h+8>>2];r=+g[h+16>>2];q=+g[h+20>>2];p=+g[h+24>>2];n=+g[h+32>>2];l=+g[h+36>>2];j=+g[h+40>>2];m=w*r+v*q+o*p+ +g[h+52>>2];k=w*n+v*l+o*j+ +g[h+56>>2];g[d+36>>2]=w*u+v*t+o*s+ +g[h+48>>2];g[d+40>>2]=m;g[d+44>>2]=k;g[d+48>>2]=0.0;k=+g[d+172>>2];m=+g[d+176>>2];o=+g[d+180>>2];g[d+52>>2]=u*k+t*m+s*o;g[d+56>>2]=k*r+m*q+o*p;g[d+60>>2]=k*n+m*l+o*j;g[d+64>>2]=0.0;o=+g[d+188>>2];m=+g[d+192>>2];k=+g[d+196>>2];g[d+68>>2]=u*o+t*m+s*k;g[d+72>>2]=o*r+m*q+k*p;g[d+76>>2]=o*n+m*l+k*j;g[d+80>>2]=0.0;i=h;return}function Or(b,d){b=b|0;d=+d;var e=0,f=0.0,h=0,j=0,k=0,l=0.0,m=0.0,n=0,o=0,p=0,q=0.0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,P=0.0,Q=0.0,R=0.0;r=i;i=i+144|0;o=c[b+128>>2]|0;if(!o){i=r;return}k=c[b+8>>2]|0;if((k|0)<(o|0)){if((c[b+12>>2]|0)<(o|0)){c[5637]=(c[5637]|0)+1;e=qG((o<<4|3)+16|0)|0;if(!e)j=0;else{c[(e+4+15&-16)+-4>>2]=e;j=e+4+15&-16}e=c[b+8>>2]|0;if((e|0)>0){h=0;do{n=j+(h<<4)|0;s=(c[b+16>>2]|0)+(h<<4)|0;c[n>>2]=c[s>>2];c[n+4>>2]=c[s+4>>2];c[n+8>>2]=c[s+8>>2];c[n+12>>2]=c[s+12>>2];h=h+1|0}while((h|0)!=(e|0))}e=c[b+16>>2]|0;if(e|0){if(a[b+20>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=j;c[b+12>>2]=o;h=b+16|0}else h=b+16|0;e=k;do{s=(c[h>>2]|0)+(e<<4)|0;c[s>>2]=c[r+80>>2];c[s+4>>2]=c[r+80+4>>2];c[s+8>>2]=c[r+80+8>>2];c[s+12>>2]=c[r+80+12>>2];e=e+1|0}while((e|0)!=(o|0))}c[b+8>>2]=o;k=c[b+28>>2]|0;if((k|0)<(o|0)){if((c[b+32>>2]|0)<(o|0)){c[5637]=(c[5637]|0)+1;e=qG((o<<4|3)+16|0)|0;if(!e)j=0;else{c[(e+4+15&-16)+-4>>2]=e;j=e+4+15&-16}e=c[b+28>>2]|0;if((e|0)>0){h=0;do{s=j+(h<<4)|0;n=(c[b+36>>2]|0)+(h<<4)|0;c[s>>2]=c[n>>2];c[s+4>>2]=c[n+4>>2];c[s+8>>2]=c[n+8>>2];c[s+12>>2]=c[n+12>>2];h=h+1|0}while((h|0)!=(e|0))}e=c[b+36>>2]|0;if(e|0){if(a[b+40>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=j;c[b+32>>2]=o;h=b+36|0}else h=b+36|0;e=k;do{s=(c[h>>2]|0)+(e<<4)|0;c[s>>2]=c[r+64>>2];c[s+4>>2]=c[r+64+4>>2];c[s+8>>2]=c[r+64+8>>2];c[s+12>>2]=c[r+64+12>>2];e=e+1|0}while((e|0)!=(o|0))}c[b+28>>2]=o;n=c[b+48>>2]|0;if((n|0)<(o|0)){do if((c[b+52>>2]|0)<(o|0)){c[5637]=(c[5637]|0)+1;e=qG((o<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=c[b+48>>2]|0;j=c[b+56>>2]|0;if((h|0)<=0){if(!j){a[b+60>>0]=1;c[b+56>>2]=e;c[b+52>>2]=o;h=o<<2;break}}else{k=0;do{c[e+(k<<2)>>2]=c[j+(k<<2)>>2];k=k+1|0}while((k|0)!=(h|0))}if(a[b+60>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0)}a[b+60>>0]=1;c[b+56>>2]=e;c[b+52>>2]=o;h=o<<2}else{h=o<<2;e=c[b+56>>2]|0}while(0);ZG(e+(n<<2)|0,0,h-(n<<2)|0)|0}c[b+48>>2]=o;n=c[b+68>>2]|0;if((n|0)<(o|0)){do if((c[b+72>>2]|0)<(o|0)){c[5637]=(c[5637]|0)+1;e=qG((o<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=c[b+68>>2]|0;j=c[b+76>>2]|0;if((h|0)<=0){if(!j){a[b+80>>0]=1;c[b+76>>2]=e;c[b+72>>2]=o;h=o<<2;break}}else{k=0;do{c[e+(k<<2)>>2]=c[j+(k<<2)>>2];k=k+1|0}while((k|0)!=(h|0))}if(a[b+80>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0)}a[b+80>>0]=1;c[b+76>>2]=e;c[b+72>>2]=o;h=o<<2}else{h=o<<2;e=c[b+76>>2]|0}while(0);ZG(e+(n<<2)|0,0,h-(n<<2)|0)|0}c[b+68>>2]=o;e=c[b+128>>2]|0;if((e|0)<=0){i=r;return}h=c[b+76>>2]|0;j=c[b+56>>2]|0;k=0;do{g[h+(k<<2)>>2]=0.0;g[j+(k<<2)>>2]=0.0;k=k+1|0}while((k|0)!=(e|0));k=0;do{h=c[b+136>>2]|0;j=c[h+(k*284|0)+88>>2]|0;if(j){e=h+(k*284|0)+92|0;c[r+96>>2]=c[e>>2];c[r+96+4>>2]=c[e+4>>2];c[r+96+8>>2]=c[e+8>>2];c[r+96+12>>2]=c[e+12>>2];e=h+(k*284|0)+108|0;c[r+96+16>>2]=c[e>>2];c[r+96+16+4>>2]=c[e+4>>2];c[r+96+16+8>>2]=c[e+8>>2];c[r+96+16+12>>2]=c[e+12>>2];e=h+(k*284|0)+124|0;c[r+96+32>>2]=c[e>>2];c[r+96+32+4>>2]=c[e+4>>2];c[r+96+32+8>>2]=c[e+8>>2];c[r+96+32+12>>2]=c[e+12>>2];e=c[b+36>>2]|0;x=c[b+112>>2]|0;o=c[r+96+16+(x<<2)>>2]|0;y=c[r+96+32+(x<<2)>>2]|0;c[e+(k<<4)>>2]=c[r+96+(x<<2)>>2];c[e+(k<<4)+4>>2]=o;c[e+(k<<4)+8>>2]=y;g[e+(k<<4)+12>>2]=0.0;e=c[b+36>>2]|0;y=e+(k<<4)|0;z=+g[y>>2];o=h+(k*284|0)|0;f=+g[o>>2];x=e+(k<<4)+4|0;w=+g[x>>2];n=h+(k*284|0)+4|0;l=+g[n>>2];e=e+(k<<4)+8|0;t=+g[e>>2];s=h+(k*284|0)+8|0;v=+g[s>>2];m=z-f*(z*f+w*l+t*v);u=w-l*(z*f+w*l+t*v);v=t-v*(z*f+w*l+t*v);t=1.0/+O(+(m*m+u*u+v*v));g[y>>2]=m*t;g[x>>2]=u*t;g[e>>2]=v*t;e=c[b+16>>2]|0;l=+g[n>>2];w=+g[s>>2];f=+g[o>>2];g[e+(k<<4)>>2]=l*(v*t)-w*(u*t);g[e+(k<<4)+4>>2]=w*(m*t)-v*t*f;g[e+(k<<4)+8>>2]=u*t*f-l*(m*t);g[e+(k<<4)+12>>2]=0.0;e=c[b+16>>2]|0;o=e+(k<<4)|0;t=+g[o>>2];s=e+(k<<4)+4|0;m=+g[s>>2];e=e+(k<<4)+8|0;l=+g[e>>2];f=1.0/+O(+(t*t+m*m+l*l));g[o>>2]=t*f;g[s>>2]=m*f;g[e>>2]=l*f;e=c[b+108>>2]|0;s=c[b+36>>2]|0;f=+g[s+(k<<4)>>2];l=+g[s+(k<<4)+4>>2];m=+g[s+(k<<4)+8>>2];if(f*f+l*l+m*m>1.100000023841858)f=0.0;else{C=+g[h+(k*284|0)+16>>2];G=C-+g[e+52>>2];E=+g[h+(k*284|0)+20>>2];I=E-+g[e+56>>2];J=+g[h+(k*284|0)+24>>2];L=J-+g[e+60>>2];C=C-+g[j+52>>2];E=E-+g[j+56>>2];J=J-+g[j+60>>2];F=+g[e+356>>2];M=+g[e+360>>2];H=+g[e+352>>2];B=+g[j+356>>2];K=+g[j+360>>2];D=+g[j+352>>2];A=(m*I-l*L)*+g[e+4>>2]+(f*L-m*G)*+g[e+20>>2]+(l*G-f*I)*+g[e+36>>2];t=(m*I-l*L)*+g[e+8>>2]+(f*L-m*G)*+g[e+24>>2]+(l*G-f*I)*+g[e+40>>2];u=(m*I-l*L)*+g[e+12>>2]+(f*L-m*G)*+g[e+28>>2]+(l*G-f*I)*+g[e+44>>2];v=(E*-m-J*-l)*+g[j+4>>2]+(J*-f-C*-m)*+g[j+20>>2]+(C*-l-E*-f)*+g[j+36>>2];w=(E*-m-J*-l)*+g[j+8>>2]+(J*-f-C*-m)*+g[j+24>>2]+(C*-l-E*-f)*+g[j+40>>2];z=(E*-m-J*-l)*+g[j+12>>2]+(J*-f-C*-m)*+g[j+28>>2]+(C*-l-E*-f)*+g[j+44>>2];f=(f*(L*F-I*M+ +g[e+336>>2]-(J*B-E*K+ +g[j+336>>2]))+l*(+g[e+340>>2]+(G*M-L*H)-(+g[j+340>>2]+(C*K-J*D)))+m*(I*H-G*F+ +g[e+344>>2]-(E*D-C*B+ +g[j+344>>2])))*-.20000000298023224*(1.0/(+g[j+368>>2]+(+g[e+368>>2]+(A*(A*+g[e+420>>2])+t*(t*+g[e+424>>2])+u*(u*+g[e+428>>2])))+(v*(v*+g[j+420>>2])+w*(w*+g[j+424>>2])+z*(z*+g[j+428>>2]))))}g[(c[b+76>>2]|0)+(k<<2)>>2]=f;e=c[b+128>>2]|0}k=k+1|0}while((k|0)<(e|0));if((e|0)<=0){i=r;return}h=c[b+136>>2]|0;j=0;o=0;while(1){e=c[h+(o*284|0)+88>>2]|0;if(e){f=+g[h+(o*284|0)+252>>2];if(f!=0.0){k=h;f=f*d}else{M=+g[h+(o*284|0)+256>>2];M=M==0.0?0.0:M;k=c[b+108>>2]|0;y=c[b+16>>2]|0;G=+g[h+(o*284|0)+16>>2];E=+g[h+(o*284|0)+20>>2];A=+g[h+(o*284|0)+24>>2];w=+g[y+(o<<4)>>2];D=+g[y+(o<<4)+4>>2];f=+g[y+(o<<4)+8>>2];P=G-+g[k+52>>2];Q=E-+g[k+56>>2];l=A-+g[k+60>>2];m=+g[k+288>>2]*(Q*f-l*D)+ +g[k+304>>2]*(l*w-P*f)+(P*D-Q*w)*+g[k+320>>2];R=(Q*f-l*D)*+g[k+292>>2]+(l*w-P*f)*+g[k+308>>2]+(P*D-Q*w)*+g[k+324>>2];N=(Q*f-l*D)*+g[k+296>>2]+(l*w-P*f)*+g[k+312>>2]+(P*D-Q*w)*+g[k+328>>2];K=G-+g[e+52>>2];I=E-+g[e+56>>2];C=A-+g[e+60>>2];v=(D*K-w*I)*+g[e+320>>2]+(+g[e+288>>2]*(f*I-D*C)+ +g[e+304>>2]*(w*C-f*K));t=(f*I-D*C)*+g[e+292>>2]+(w*C-f*K)*+g[e+308>>2]+(D*K-w*I)*+g[e+324>>2];u=(f*I-D*C)*+g[e+296>>2]+(w*C-f*K)*+g[e+312>>2]+(D*K-w*I)*+g[e+328>>2];G=G-+g[k+52>>2];E=E-+g[k+56>>2];A=A-+g[k+60>>2];H=+g[k+356>>2];z=+g[k+360>>2];F=+g[k+352>>2];L=+g[e+356>>2];B=+g[e+360>>2];J=+g[e+352>>2];f=-(1.0/(+g[k+368>>2]+(f*(Q*m-P*R)+(w*(l*R-Q*N)+D*(P*N-l*m)))+(+g[e+368>>2]+(f*(I*v-K*t)+(w*(C*t-I*u)+D*(K*u-C*v)))))*((A*H-E*z+ +g[k+336>>2]-(C*L-I*B+ +g[e+336>>2]))*w+(+g[k+340>>2]+(G*z-A*F)-(+g[e+340>>2]+(K*B-C*J)))*D+(E*F-G*H+ +g[k+344>>2]-(I*J-K*L+ +g[e+344>>2]))*f));f=M<f?M:f;k=c[b+136>>2]|0;f=f<-M?-M:f}n=c[b+56>>2]|0;y=n+(o<<2)|0;g[y>>2]=0.0;e=k+(o*284|0)+280|0;g[e>>2]=1.0;m=+g[h+(o*284|0)+276>>2]*d*+g[h+(o*284|0)+228>>2];g[y>>2]=f;f=f*.5;l=+g[(c[b+76>>2]|0)+(o<<2)>>2];if(f*f+l*l>m*m){R=m/+O(+(f*f+l*l));g[e>>2]=R*+g[e>>2];e=1}else e=j}else{n=c[b+56>>2]|0;g[n+(o<<2)>>2]=0.0;g[h+(o*284|0)+280>>2]=1.0;k=h;e=j}o=o+1|0;j=c[b+128>>2]|0;if((o|0)>=(j|0))break;else{h=k;j=e}}if(e){if((j|0)<=0){i=r;return}e=c[b+76>>2]|0;h=0;do{if(+g[e+(h<<2)>>2]!=0.0?(p=k+(h*284|0)+280|0,q=+g[p>>2],q<1.0):0){y=n+(h<<2)|0;g[y>>2]=q*+g[y>>2];y=(c[b+76>>2]|0)+(h<<2)|0;g[y>>2]=+g[p>>2]*+g[y>>2]}h=h+1|0}while((h|0)!=(j|0))}if((j|0)<=0){i=r;return}j=n;e=0;while(1){h=c[b+108>>2]|0;n=k+(e*284|0)+16|0;l=+g[n>>2]-+g[h+52>>2];o=k+(e*284|0)+20|0;m=+g[o>>2]-+g[h+56>>2];p=k+(e*284|0)+24|0;d=+g[p>>2]-+g[h+60>>2];g[r+96>>2]=l;g[r+96+4>>2]=m;g[r+96+8>>2]=d;g[r+96+12>>2]=0.0;f=+g[j+(e<<2)>>2];if(f!=0.0){y=c[b+16>>2]|0;Q=f*+g[y+(e<<4)+4>>2];R=f*+g[y+(e<<4)+8>>2];g[r+16>>2]=f*+g[y+(e<<4)>>2];g[r+16+4>>2]=Q;g[r+16+8>>2]=R;g[r+16+12>>2]=0.0;Uo(h,r+16|0,r+96|0)}f=+g[(c[b+76>>2]|0)+(e<<2)>>2];if(f!=0.0){y=c[(c[b+136>>2]|0)+(e*284|0)+88>>2]|0;Q=+g[o>>2]-+g[y+56>>2];P=+g[p>>2]-+g[y+60>>2];g[r+48>>2]=+g[n>>2]-+g[y+52>>2];g[r+48+4>>2]=Q;g[r+48+8>>2]=P;g[r+48+12>>2]=0.0;x=c[b+36>>2]|0;P=+g[x+(e<<4)>>2]*f;Q=f*+g[x+(e<<4)+4>>2];R=f*+g[x+(e<<4)+8>>2];g[r+32>>2]=P;g[r+32+4>>2]=Q;g[r+32+8>>2]=R;g[r+32+12>>2]=0.0;x=c[b+108>>2]|0;s=c[b+116>>2]|0;K=+g[x+4+(s<<2)>>2];L=+g[x+20+(s<<2)>>2];M=+g[x+36+(s<<2)>>2];N=(K*l+L*m+M*d)*(1.0-+g[k+(e*284|0)+244>>2]);g[r+96>>2]=l-K*N;g[r+96+4>>2]=m-L*N;g[r+96+8>>2]=d-M*N;Uo(x,r+32|0,r+96|0);g[r>>2]=-P;g[r+4>>2]=-Q;g[r+8>>2]=-R;g[r+12>>2]=0.0;Uo(y,r,r+48|0)}e=e+1|0;if((e|0)>=(c[b+128>>2]|0))break;k=c[b+136>>2]|0;j=c[b+56>>2]|0}i=r;return}function Pr(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+112>>2]=b;c[a+116>>2]=d;c[a+120>>2]=e;return}function Qr(a){a=a|0;return}function Rr(a){a=a|0;rG(a);return}function Sr(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0;h=i;i=i+96|0;g[h+4>>2]=1.0;c[h+8>>2]=0;b[h+12>>1]=1;b[h+14>>1]=-1;c[h+16>>2]=0;c[h>>2]=8008;c[h+20>>2]=c[d>>2];c[h+20+4>>2]=c[d+4>>2];c[h+20+8>>2]=c[d+8>>2];c[h+20+12>>2]=c[d+12>>2];c[h+36>>2]=c[e>>2];c[h+36+4>>2]=c[e+4>>2];c[h+36+8>>2]=c[e+8>>2];c[h+36+12>>2]=c[e+12>>2];a=c[a+4>>2]|0;bc[c[(c[a>>2]|0)+32>>2]&127](a,d,e,h);d=c[h+8>>2]|0;if(!d){f=0;i=h;return f|0}if(!(c[d+236>>2]&2)){f=0;i=h;return f|0}if(c[d+204>>2]&4|0){f=0;i=h;return f|0}c[f>>2]=c[h+68>>2];c[f+4>>2]=c[h+68+4>>2];c[f+8>>2]=c[h+68+8>>2];c[f+12>>2]=c[h+68+12>>2];c[f+16>>2]=c[h+52>>2];c[f+16+4>>2]=c[h+52+4>>2];c[f+16+8>>2]=c[h+52+8>>2];c[f+16+12>>2]=c[h+52+12>>2];m=+g[f+16>>2];l=+g[f+20>>2];k=+g[f+24>>2];j=1.0/+O(+(m*m+l*l+k*k));g[f+16>>2]=m*j;g[f+20>>2]=l*j;g[f+24>>2]=k*j;c[f+32>>2]=c[h+4>>2];f=d;i=h;return f|0}function Tr(a){a=a|0;rG(a);return}function Ur(a,d){a=a|0;d=d|0;d=c[d+4>>2]|0;if(!((b[a+14>>1]&(d&65535))<<16>>16)){a=0;return a|0}a=(d>>>16&65535&b[a+12>>1])<<16>>16!=0;return a|0}function Vr(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;c[a+4>>2]=c[b+24>>2];e=c[b>>2]|0;c[a+8>>2]=e;if(d){c[a+52>>2]=c[b+8>>2];c[a+52+4>>2]=c[b+8+4>>2];c[a+52+8>>2]=c[b+8+8>>2];c[a+52+12>>2]=c[b+8+12>>2]}else{k=+g[b+8>>2];j=+g[b+12>>2];i=+g[b+16>>2];h=k*+g[e+20>>2]+j*+g[e+24>>2]+i*+g[e+28>>2];f=k*+g[e+36>>2]+j*+g[e+40>>2]+i*+g[e+44>>2];g[a+52>>2]=+g[e+4>>2]*k+ +g[e+8>>2]*j+ +g[e+12>>2]*i;g[a+56>>2]=h;g[a+60>>2]=f;g[a+64>>2]=0.0}k=+g[b+24>>2];g[a+68>>2]=(1.0-k)*+g[a+20>>2]+k*+g[a+36>>2];g[a+72>>2]=(1.0-k)*+g[a+24>>2]+k*+g[a+40>>2];g[a+76>>2]=(1.0-k)*+g[a+28>>2]+k*+g[a+44>>2];return +(+g[b+24>>2])}function Wr(b,d,e,f,h,j,k,l){b=b|0;d=d|0;e=e|0;f=f|0;h=+h;j=+j;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=i;i=i+288|0;c[w+208>>2]=c[d>>2];c[w+208+4>>2]=c[d+4>>2];c[w+208+8>>2]=c[d+8>>2];c[w+208+12>>2]=c[d+12>>2];n=w+208+16|0;c[n>>2]=c[e>>2];c[n+4>>2]=c[e+4>>2];c[n+8>>2]=c[e+8>>2];c[n+12>>2]=c[e+12>>2];o=w+208+32|0;c[o>>2]=c[f>>2];c[o+4>>2]=c[f+4>>2];c[o+8>>2]=c[f+8>>2];c[o+12>>2]=c[f+12>>2];r=c[k>>2]|0;t=c[k+4>>2]|0;u=c[k+8>>2]|0;v=c[k+16>>2]|0;q=c[k+12>>2]|0;p=c[k+20>>2]|0;c[w>>2]=c[w+208>>2];c[w+4>>2]=c[w+208+4>>2];c[w+8>>2]=c[w+208+8>>2];c[w+12>>2]=c[w+208+12>>2];c[w+16>>2]=c[n>>2];c[w+16+4>>2]=c[n+4>>2];c[w+16+8>>2]=c[n+8>>2];c[w+16+12>>2]=c[n+12>>2];c[w+32>>2]=c[o>>2];c[w+32+4>>2]=c[o+4>>2];c[w+32+8>>2]=c[o+8>>2];c[w+32+12>>2]=c[o+12>>2];f=c[b+128>>2]|0;if((f|0)==(c[b+132>>2]|0)?(s=f|0?f<<1:1,(f|0)<(s|0)):0){if(!s)d=0;else{c[5637]=(c[5637]|0)+1;d=qG((s*284|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}f=c[b+128>>2]|0}if((f|0)>0){k=0;do{e=c[b+136>>2]|0;m=d+(k*284|0)|0;n=e+(k*284|0)|0;o=m+92|0;do{c[m>>2]=c[n>>2];m=m+4|0;n=n+4|0}while((m|0)<(o|0));m=d+(k*284|0)+92|0;n=e+(k*284|0)+92|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=d+(k*284|0)+108|0;n=e+(k*284|0)+108|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=d+(k*284|0)+124|0;n=e+(k*284|0)+124|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=d+(k*284|0)+140|0;n=e+(k*284|0)+140|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=d+(k*284|0)+156|0;n=e+(k*284|0)+156|0;o=m+128|0;do{c[m>>2]=c[n>>2];m=m+4|0;n=n+4|0}while((m|0)<(o|0));k=k+1|0}while((k|0)!=(f|0))}f=c[b+136>>2]|0;if(f|0){if(a[b+140>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=d;c[b+132>>2]=s;f=c[b+128>>2]|0}d=c[b+136>>2]|0;m=d+(f*284|0)|0;n=w+48|0;o=m+92|0;do{c[m>>2]=c[n>>2];m=m+4|0;n=n+4|0}while((m|0)<(o|0));m=d+(f*284|0)+92|0;c[m>>2]=c[w+192>>2];c[m+4>>2]=c[w+192+4>>2];c[m+8>>2]=c[w+192+8>>2];c[m+12>>2]=c[w+192+12>>2];m=d+(f*284|0)+108|0;c[m>>2]=c[w+176>>2];c[m+4>>2]=c[w+176+4>>2];c[m+8>>2]=c[w+176+8>>2];c[m+12>>2]=c[w+176+12>>2];m=d+(f*284|0)+124|0;c[m>>2]=c[w+160>>2];c[m+4>>2]=c[w+160+4>>2];c[m+8>>2]=c[w+160+8>>2];c[m+12>>2]=c[w+160+12>>2];m=d+(f*284|0)+140|0;c[m>>2]=c[w+144>>2];c[m+4>>2]=c[w+144+4>>2];c[m+8>>2]=c[w+144+8>>2];c[m+12>>2]=c[w+144+12>>2];d=d+(f*284|0)+156|0;m=d;n=w;o=m+48|0;do{c[m>>2]=c[n>>2];m=m+4|0;n=n+4|0}while((m|0)<(o|0));g[d+48>>2]=h;c[d+52>>2]=q;g[d+56>>2]=j;c[d+60>>2]=r;c[d+64>>2]=t;c[d+68>>2]=u;c[d+72>>2]=v;g[d+76>>2]=0.0;g[d+80>>2]=0.0;g[d+84>>2]=0.0;g[d+88>>2]=.10000000149011612;c[d+92>>2]=p;g[d+96>>2]=0.0;g[d+100>>2]=0.0;a[d+104>>0]=l&1;m=d+105|0;n=w+256|0;o=m+23|0;do{a[m>>0]=a[n>>0]|0;m=m+1|0;n=n+1|0}while((m|0)<(o|0));l=c[b+128>>2]|0;c[b+128>>2]=l+1;l=(c[b+136>>2]|0)+(l*284|0)|0;Nr(c[b+108>>2]|0,l,0);Mr(c[b+108>>2]|0,c[b+136>>2]|0,(c[b+128>>2]|0)+-1|0,0);i=w;return l|0}function Xr(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;e=c[a+56>>2]|0;if(!e){e=c[a+52>>2]|0;if(!e){c[5637]=(c[5637]|0)+1;e=qG(31)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[a+60>>2]|0;c[e+4>>2]=f;g=e+8|0;c[g>>2]=0;c[5637]=(c[5637]|0)+1;f=qG((f*24|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}c[e>>2]=f;c[g>>2]=c[a+48>>2];c[a+48>>2]=e}else c[a+52>>2]=c[e+8>>2];h=c[e+4>>2]|0;e=c[e>>2]|0;if((h|0)>0){f=0;g=e;do{f=f+1|0;i=g;g=g+24|0;c[i>>2]=(f|0)<(h|0)?g:0}while((f|0)!=(h|0));i=e}else i=e}else i=e;c[a+56>>2]=c[i>>2];c[i>>2]=0;c[i+4>>2]=0;c[i+8>>2]=0;c[i+12>>2]=0;c[i+16>>2]=0;c[i+20>>2]=0;e=c[a+56>>2]|0;if(!e){e=c[a+52>>2]|0;if(!e){c[5637]=(c[5637]|0)+1;e=qG(31)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[a+60>>2]|0;c[e+4>>2]=f;g=e+8|0;c[g>>2]=0;c[5637]=(c[5637]|0)+1;f=qG((f*24|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}c[e>>2]=f;c[g>>2]=c[a+48>>2];c[a+48>>2]=e}else c[a+52>>2]=c[e+8>>2];h=c[e+4>>2]|0;e=c[e>>2]|0;if((h|0)>0){f=0;g=e;do{f=f+1|0;j=g;g=g+24|0;c[j>>2]=(f|0)<(h|0)?g:0}while((f|0)!=(h|0))}}c[a+56>>2]=c[e>>2];c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[i+8>>2]=e;c[e+8>>2]=i;j=c[a+100>>2]|0;c[i+20>>2]=j;c[e+20>>2]=j;c[i+12>>2]=d;c[e+12>>2]=b;c[i+16>>2]=0;c[e+16>>2]=0;e=c[a+116>>2]|0;c[a+116>>2]=e+1;if((e|0)<(c[a+120>>2]|0))return i|0;c[a+120>>2]=e+1;return i|0}function Yr(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0;K=i;i=i+144|0;a:do switch(d-b|0){case 0:{c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;i=K;return}case 2:{f=c[(c[a+92>>2]|0)+(b<<2)>>2]|0;k=c[f+88>>2]|0;l=c[f+200>>2]|0;j=c[f+92>>2]|0;g=c[f+204>>2]|0;if((k|0)==(l|0)){if((j|0)==(g|0))if((c[f+96>>2]|0)==(c[f+208>>2]|0))break a;else g=j;if((j|0)==(g|0)){I=(c[f+96>>2]|0)>(c[f+208>>2]|0);g=I?f+112|0:f;c[g>>2]=g;c[g+4>>2]=g;c[e>>2]=g;c[e+4>>2]=g;c[e+8>>2]=g;c[e+12>>2]=g;f=I?f:f+112|0}else{h=g;g=0;J=9}}else{h=g;g=(j|0)==(g|0);J=9}do if((J|0)==9){c[f>>2]=f+112;c[f+4>>2]=f+112;c[f+112>>2]=f;c[f+116>>2]=f;J=(j|0)<(h|0);c[e>>2]=(k|0)<(l|0)|(k|0)==(l|0)&J?f:f+112|0;c[e+4>>2]=(k|0)<(l|0)|(k|0)==(l|0)&J?f+112|0:f;if(J|(k|0)<(l|0)&g){c[e+8>>2]=f;c[e+12>>2]=f+112;g=f;f=f+112|0;break}else{c[e+8>>2]=f+112;c[e+12>>2]=f;g=f;f=f+112|0;break}}while(0);a=Xr(a,g,f)|0;c[a>>2]=a;c[a+4>>2]=a;c[g+8>>2]=a;a=c[a+8>>2]|0;c[a>>2]=a;c[a+4>>2]=a;c[f+8>>2]=a;i=K;return}case 1:{f=c[(c[a+92>>2]|0)+(b<<2)>>2]|0;break}default:{n=((d-b|0)/2|0)+b|0;h=c[a+92>>2]|0;m=c[h+(n+-1<<2)>>2]|0;j=c[m+88>>2]|0;k=c[m+92>>2]|0;m=c[m+96>>2]|0;b:do if((n|0)<(d|0)){f=n;do{g=c[h+(f<<2)>>2]|0;if((c[g+88>>2]|0)!=(j|0))break b;if((c[g+92>>2]|0)!=(k|0))break b;if((c[g+96>>2]|0)!=(m|0))break b;f=f+1|0}while((f|0)<(d|0))}else f=n;while(0);Yr(a,b,n,e);c[K+96>>2]=0;c[K+96+4>>2]=0;c[K+96+8>>2]=0;c[K+96+12>>2]=0;Yr(a,f,d,K+96|0);m=c[K+96+4>>2]|0;c:do if(m|0){A=c[e+4>>2]|0;if(!A){c[e>>2]=c[K+96>>2];c[e+4>>2]=c[K+96+4>>2];c[e+8>>2]=c[K+96+8>>2];c[e+12>>2]=c[K+96+12>>2];break}c[a+100>>2]=(c[a+100>>2]|0)+-1;h=c[e+12>>2]|0;k=c[K+96+8>>2]|0;j=c[h+88>>2]|0;d:do if((j|0)==(c[k+88>>2]|0)?(l=c[h+92>>2]|0,(l|0)==(c[k+92>>2]|0)):0){n=c[k+4>>2]|0;if((n|0)==(k|0)){f=c[k+8>>2]|0;if(f){k=c[f+12>>2]|0;l=c[k+92>>2]|0;j=c[k+88>>2]|0}g=h;G=k;f=k;n=j+1|0;d=c[k+96>>2]|0;break}h=c[k>>2]|0;c[n>>2]=h;c[h+4>>2]=n;e:do if((k|0)==(c[K+96>>2]|0)){f=c[h+88>>2]|0;g=c[n+88>>2]|0;do if((f|0)>=(g|0)){if((f|0)==(g|0)?(c[h+92>>2]|0)<(c[n+92>>2]|0):0)break;c[K+96>>2]=n;break e}while(0);c[K+96>>2]=h}while(0);if((k|0)==(m|0)){f=c[h+88>>2]|0;g=c[n+88>>2]|0;do if((f|0)<=(g|0)){if((f|0)==(g|0)?(c[h+92>>2]|0)>(c[n+92>>2]|0):0)break;c[K+96+4>>2]=n;h=n;J=39;break d}while(0);c[K+96+4>>2]=h;J=39}else{h=m;J=39}}else{h=m;J=39}while(0);if((J|0)==39){w=c[e>>2]|0;x=c[K+96>>2]|0;y=0;z=1;b=A;g=0;f=h;j=0;while(1){k=c[f+88>>2]|0;d=c[b+88>>2]|0;l=_(k-d|0,z)|0;f:do if((l|0)<=0){if((l|0)<0){v=(y|0)!=0;n=c[b+92>>2]|0;u=c[f+92>>2]|0;m=l;l=b;while(1){r=c[(v?f+4|0:f)>>2]|0;s=(r|0)==(f|0);t=f+88|0;q=m;while(1){m=l+88|0;o=u-n|0;if(!s?(B=c[r+88>>2]|0,D=_(B-k|0,z)|0,E=c[r+92>>2]|0,F=E-u|0,(F|0)>-1):0){if(!D)break;if((D|0)<0?(_(F,q)|0)<=(_(D,o)|0):0)break}p=c[(v?l+4|0:l)>>2]|0;if((p|0)==(l|0))break f;G=c[p+88>>2]|0;d=_(G-(c[m>>2]|0)|0,z)|0;b=c[p+92>>2]|0;m=b-n|0;k=c[t>>2]|0;n=q;q=_(k-G|0,z)|0;if(!((m|0)>0&(q|0)<0))break f;if(!d){n=b;l=p;continue}if((d|0)>=0)break f;if((_(m,n)|0)>=(_(d,o)|0))break f;else{n=b;l=p}}k=B;u=E;m=_(B-(c[m>>2]|0)|0,z)|0;f=r}}k=c[b+92>>2]|0;n=(y|0)!=0;g:do if(n){m=b;while(1){l=c[m>>2]|0;if((l|0)==(b|0))break g;if((c[l+88>>2]|0)!=(d|0))break g;G=k;k=c[l+92>>2]|0;if((k|0)>(G|0))break;else m=l}}else{m=b;while(1){l=c[m+4>>2]|0;if((l|0)==(b|0))break g;if((c[l+88>>2]|0)!=(d|0))break g;G=k;k=c[l+92>>2]|0;if((k|0)>(G|0))break;else m=l}}while(0);l=c[f+92>>2]|0;if(n){n=f;while(1){k=c[n+4>>2]|0;if((k|0)==(f|0)){l=m;f=n;break f}if((c[k+88>>2]|0)!=(d|0)){l=m;f=n;break f}G=l;l=c[k+92>>2]|0;if((l|0)<(G|0)){l=m;f=n;break}else n=k}}else{n=f;while(1){k=c[n>>2]|0;if((k|0)==(f|0)){l=m;f=n;break f}if((c[k+88>>2]|0)!=(d|0)){l=m;f=n;break f}G=l;l=c[k+92>>2]|0;if((l|0)<(G|0)){l=m;f=n;break}else n=k}}}else{u=(y|0)!=0;s=d;t=c[f+92>>2]|0;r=l;while(1){q=f+88|0;m=c[b+92>>2]|0;k=t-m|0;l=c[(u?b:b+4|0)>>2]|0;h:do if((l|0)!=(b|0))if(u){p=s;o=m;d=r;while(1){m=p;p=c[l+88>>2]|0;m=_(p-m|0,z)|0;n=o;o=c[l+92>>2]|0;n=o-n|0;if((n|0)>=1){o=k;l=b;break h}if(m|0){if((m|0)>=0){o=k;l=b;break h}if((_(n,d)|0)>(_(m,k)|0)){o=k;l=b;break h}}n=_((c[q>>2]|0)-p|0,z)|0;k=t-o|0;m=c[l>>2]|0;if((m|0)==(l|0)){o=k;d=n;break}else{b=l;l=m;d=n}}}else{p=s;o=m;d=r;while(1){m=p;p=c[l+88>>2]|0;m=_(p-m|0,z)|0;n=o;o=c[l+92>>2]|0;n=o-n|0;if((n|0)>=1){o=k;l=b;break h}if(m|0){if((m|0)>=0){o=k;l=b;break h}if((_(n,d)|0)>(_(m,k)|0)){o=k;l=b;break h}}n=_((c[q>>2]|0)-p|0,z)|0;k=t-o|0;m=c[l+4>>2]|0;if((m|0)==(l|0)){o=k;d=n;break}else{b=l;l=m;d=n}}}else{o=k;d=r;l=b}while(0);n=c[(u?f:f+4|0)>>2]|0;if((n|0)==(f|0))break f;r=c[n+88>>2]|0;k=_(r-(c[q>>2]|0)|0,z)|0;m=t;t=c[n+92>>2]|0;m=t-m|0;s=c[l+88>>2]|0;r=_(r-s|0,z)|0;if(!((m|0)<0&(r|0)>0))break f;if(!k){b=l;f=n;continue}if((k|0)>=0)break f;if((_(m,d)|0)>=(_(k,o)|0))break;else{b=l;f=n}}}while(0);k=(y|0)==0;j=k?f:j;g=k?l:g;f=k?x:f;b=k?w:l;y=y+1|0;if((y|0)==2)break;else z=k?-1:z}c[b+4>>2]=f;c[f>>2]=b;c[g>>2]=j;c[j+4>>2]=g;if((c[x+88>>2]|0)<(c[w+88>>2]|0))c[e>>2]=x;if((c[h+88>>2]|0)>=(c[A+88>>2]|0))c[e+4>>2]=h;c[e+12>>2]=c[K+96+12>>2];h=g;F=j;s=c[j+88>>2]|0;d=c[g+88>>2]|0;t=c[j+92>>2]|0;u=c[g+92>>2]|0;v=c[j+96>>2]|0;b=c[g+96>>2]|0;w=((t-u|0)<0)<<31>>31;x=0-(s-d)|0;y=XG(0,0,x|0,((x|0)<0)<<31>>31|0)|0;y=jH(v-b|0,((v-b|0)<0)<<31>>31|0,y|0,C|0)|0;z=C;A=jH(v-b|0,((v-b|0)<0)<<31>>31|0,t-u|0,w|0)|0;B=C;o=jH(s-d|0,((s-d|0)<0)<<31>>31|0,x|0,((x|0)<0)<<31>>31|0)|0;E=C;D=jH(t-u|0,w|0,t-u|0,w|0)|0;D=XG(o|0,E|0,D|0,C|0)|0;E=C;o=c[g+8>>2]|0;c[K+120>>2]=0;if(!o)p=0;else{p=XG(0,0,t-u|0,w|0)|0;q=C;f=0;r=o;while(1){m=c[r+12>>2]|0;k=c[m+88>>2]|0;l=c[m+92>>2]|0;m=c[m+96>>2]|0;n=jH(l-u|0,((l-u|0)<0)<<31>>31|0,x|0,((x|0)<0)<<31>>31|0)|0;G=C;e=jH(k-d|0,((k-d|0)<0)<<31>>31|0,p|0,q|0)|0;i:do if((n|0)==(e|0)&(G|0)==(C|0)?(e=jH(k-d|0,((k-d|0)<0)<<31>>31|0,y|0,z|0)|0,n=C,G=jH(l-u|0,((l-u|0)<0)<<31>>31|0,A|0,B|0)|0,n=YG(G|0,C|0,e|0,n|0)|0,e=C,G=jH(m-b|0,((m-b|0)<0)<<31>>31|0,D|0,E|0)|0,G=YG(n|0,e|0,G|0,C|0)|0,e=C,(e|0)>0|(e|0)==0&G>>>0>0):0){do if(f|0){n=(c[f+4>>2]|0)==(r|0);if((c[f>>2]|0)!=(r|0))if(n)break;else break i;if(!n)break i;e=c[f+12>>2]|0;L=c[(c[r+8>>2]|0)+12>>2]|0;G=c[L+88>>2]|0;n=c[L+92>>2]|0;L=c[L+96>>2]|0;M=(c[e+96>>2]|0)-L|0;n=(_(m-L|0,(c[e+92>>2]|0)-n|0)|0)-(_(M,l-n|0)|0)|0;G=(_(M,k-G|0)|0)-(_(m-L|0,(c[e+88>>2]|0)-G|0)|0)|0;n=jH(n|0,((n|0)<0)<<31>>31|0,t-u|0,w|0)|0;e=C;G=jH(G|0,((G|0)<0)<<31>>31|0,x|0,((x|0)<0)<<31>>31|0)|0;G=YG(n|0,e|0,G|0,C|0)|0;e=C;if((e|0)>0|(e|0)==0&G>>>0>0)break i}while(0);c[K+120>>2]=r;f=r}while(0);r=c[r>>2]|0;if((r|0)==(o|0)){p=f;break}}}n=c[j+8>>2]|0;c[K+72>>2]=0;if(!n)f=0;else{d=XG(0,0,t-u|0,w|0)|0;b=C;f=0;o=n;do{m=c[o+12>>2]|0;k=c[m+88>>2]|0;l=c[m+92>>2]|0;m=c[m+96>>2]|0;G=jH(l-t|0,((l-t|0)<0)<<31>>31|0,x|0,((x|0)<0)<<31>>31|0)|0;M=C;L=jH(k-s|0,((k-s|0)<0)<<31>>31|0,d|0,b|0)|0;do if((G|0)==(L|0)&(M|0)==(C|0)?(L=jH(k-s|0,((k-s|0)<0)<<31>>31|0,y|0,z|0)|0,G=C,M=jH(l-t|0,((l-t|0)<0)<<31>>31|0,A|0,B|0)|0,G=YG(M|0,C|0,L|0,G|0)|0,L=C,M=jH(m-v|0,((m-v|0)<0)<<31>>31|0,D|0,E|0)|0,M=YG(G|0,L|0,M|0,C|0)|0,L=C,(L|0)>0|(L|0)==0&M>>>0>0):0){if(f|0){if((c[f>>2]|0)!=(o|0))break;if((c[f+4>>2]|0)==(o|0)?(L=c[f+12>>2]|0,e=c[(c[o+8>>2]|0)+12>>2]|0,M=c[e+88>>2]|0,G=c[e+92>>2]|0,e=c[e+96>>2]|0,r=(c[L+96>>2]|0)-e|0,G=(_(m-e|0,(c[L+92>>2]|0)-G|0)|0)-(_(r,l-G|0)|0)|0,M=(_(r,k-M|0)|0)-(_(m-e|0,(c[L+88>>2]|0)-M|0)|0)|0,G=jH(G|0,((G|0)<0)<<31>>31|0,t-u|0,w|0)|0,L=C,M=jH(M|0,((M|0)<0)<<31>>31|0,x|0,((x|0)<0)<<31>>31|0)|0,M=YG(G|0,L|0,M|0,C|0)|0,L=C,!((L|0)>0|(L|0)==0&M>>>0>0)):0)break}c[K+72>>2]=o;f=o}while(0);o=c[o>>2]|0}while((o|0)!=(n|0))}if((p|0)!=0|(f|0)!=0){Zr(a,g,j,K+120|0,K+72|0);f=c[K+120>>2]|0;if(f){h=c[f+12>>2]|0;g=h}f=c[K+72>>2]|0;if(!f)f=F;else{f=c[f+12>>2]|0;j=f}}else f=F;G=j;n=c[j+88>>2]|0;d=(c[j+96>>2]|0)+1|0;l=c[j+92>>2]|0}w=G;x=g;j=0;D=0;e=1;k=0;m=0;y=0;A=0;B=n;o=d;F=0;n=0;while(1){z=x+88|0;u=(c[w+88>>2]|0)-(c[z>>2]|0)|0;M=x+92|0;E=(c[w+92>>2]|0)-(c[M>>2]|0)|0;t=x+96|0;r=(c[w+96>>2]|0)-(c[t>>2]|0)|0;c[K+120>>2]=u;c[K+120+4>>2]=E;c[K+120+8>>2]=r;c[K+120+12>>2]=-1;z=B-(c[z>>2]|0)|0;M=l-(c[M>>2]|0)|0;t=o-(c[t>>2]|0)|0;s=(_(r,M)|0)-(_(E,t)|0)|0;t=(_(u,t)|0)-(_(r,z)|0)|0;M=(_(E,z)|0)-(_(u,M)|0)|0;c[K+72>>2]=s;c[K+72+4>>2]=((s|0)<0)<<31>>31;c[K+72+8>>2]=t;c[K+72+8+4>>2]=((t|0)<0)<<31>>31;c[K+72+16>>2]=M;c[K+72+16+4>>2]=((M|0)<0)<<31>>31;z=jH(E|0,((E|0)<0)<<31>>31|0,M|0,((M|0)<0)<<31>>31|0)|0;L=C;v=jH(r|0,((r|0)<0)<<31>>31|0,t|0,((t|0)<0)<<31>>31|0)|0;v=XG(z|0,L|0,v|0,C|0)|0;L=C;r=jH(s|0,((s|0)<0)<<31>>31|0,r|0,((r|0)<0)<<31>>31|0)|0;z=C;M=jH(u|0,((u|0)<0)<<31>>31|0,M|0,((M|0)<0)<<31>>31|0)|0;M=XG(r|0,z|0,M|0,C|0)|0;z=C;t=jH(u|0,((u|0)<0)<<31>>31|0,t|0,((t|0)<0)<<31>>31|0)|0;u=C;E=jH(s|0,((s|0)<0)<<31>>31|0,E|0,((E|0)<0)<<31>>31|0)|0;E=XG(t|0,u|0,E|0,C|0)|0;c[K+48>>2]=v;c[K+48+4>>2]=L;c[K+48+8>>2]=M;c[K+48+8+4>>2]=z;c[K+48+16>>2]=E;c[K+48+16+4>>2]=C;c[K+24>>2]=0;c[K+24+4>>2]=0;c[K+24+8>>2]=0;c[K+24+12>>2]=0;c[K+24+16>>2]=0;E=_r(a,0,x,K+120|0,K+72|0,K+48|0,K+24|0)|0;c[K>>2]=0;c[K+4>>2]=0;c[K+8>>2]=0;c[K+12>>2]=0;c[K+16>>2]=0;z=_r(a,1,w,K+120|0,K+72|0,K+48|0,K)|0;do if((E|0)!=0|(z|0)!=0){d=E|0?-1:1;do if((E|0)!=0&(z|0)!=0){v=c[K+24+16>>2]|0;d=c[K+16>>2]|0;if((v|0)!=(d|0)){u=v-d|0;break}if(!v)u=0;else{M=c[K+24>>2]|0;t=c[K+24+4>>2]|0;p=c[K+8>>2]|0;N=c[K+8+4>>2]|0;b=jH(p|0,0,M|0,0)|0;d=C;M=jH(N|0,0,M|0,0)|0;L=C;p=jH(p|0,0,t|0,0)|0;q=C;t=jH(N|0,0,t|0,0)|0;N=C;p=YG(M|0,0,p|0,0)|0;M=C;N=YG(L|0,0,t|0,N|0)|0;q=YG(N|0,C|0,q|0,0)|0;M=YG(q|0,C|0,M|0,0)|0;q=C;d=YG(0,p|0,b|0,d|0)|0;b=C;p=YG(M|0,q|0,(b>>>0<p>>>0|(b|0)==(p|0)&d>>>0<0)&1|0,0)|0;q=C;M=c[K+24+8>>2]|0;N=c[K+24+8+4>>2]|0;t=c[K>>2]|0;L=c[K+4>>2]|0;s=jH(t|0,0,M|0,0)|0;r=C;M=jH(L|0,0,M|0,0)|0;O=C;t=jH(t|0,0,N|0,0)|0;u=C;N=jH(L|0,0,N|0,0)|0;L=C;t=YG(M|0,0,t|0,0)|0;M=C;L=YG(O|0,0,N|0,L|0)|0;u=YG(L|0,C|0,u|0,0)|0;M=YG(u|0,C|0,M|0,0)|0;u=C;r=YG(0,t|0,s|0,r|0)|0;s=C;t=YG(M|0,u|0,(s>>>0<t>>>0|(s|0)==(t|0)&r>>>0<0)&1|0,0)|0;u=C;if(!(q>>>0<u>>>0|(q|0)==(u|0)&p>>>0<t>>>0))if(!(q>>>0>u>>>0|(q|0)==(u|0)&p>>>0>t>>>0))if(b>>>0<s>>>0|(b|0)==(s|0)&d>>>0<r>>>0)d=-1;else d=(b>>>0>s>>>0|(b|0)==(s|0)&d>>>0>r>>>0)&1;else d=1;else d=-1;u=_(d,v)|0}}else u=d;while(0);do if(!e)if((u|0)>-1)if((c[K+16>>2]|0)<0&((c[K+8>>2]|0)==0?(c[K+8+4>>2]|0)==0:0)){b=y;t=A;break}else{J=136;break}else if((c[K+24+16>>2]|0)<0&((c[K+24+8>>2]|0)==0?(c[K+24+8+4>>2]|0)==0:0)){b=y;t=A;break}else{J=136;break}else J=136;while(0);if((J|0)==136){J=0;b=Xr(a,x,w)|0;if(!y)k=b;else c[y+4>>2]=b;c[b>>2]=y;d=c[b+8>>2]|0;if(!A)m=d;else c[A>>2]=d;c[d+4>>2]=A;t=d}c[K+116>>2]=E;c[K+112>>2]=z;if(!u){Zr(a,h,f,K+116|0,K+112|0);s=c[K+112>>2]|0}else s=z;if((u|0)>-1&(s|0)!=0){r=(n|0)!=0;if(r?(H=c[n>>2]|0,(H|0)!=(z|0)):0){p=H;do{q=p;p=c[p>>2]|0;o=c[q+8>>2]|0;d=c[o+12>>2]|0;if((p|0)==(q|0))l=0;else{c[p+4>>2]=c[q+4>>2];c[c[q+4>>2]>>2]=p;l=p}c[d+8>>2]=l;l=c[o>>2]|0;d=c[q+12>>2]|0;if((l|0)==(o|0))l=0;else{c[l+4>>2]=c[o+4>>2];c[c[o+4>>2]>>2]=l}c[d+8>>2]=l;c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[q+12>>2]=0;c[q+16>>2]=0;c[q>>2]=c[a+56>>2];c[a+56>>2]=q;c[o>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;c[o+12>>2]=0;c[o+16>>2]=0;c[o>>2]=c[a+56>>2];c[a+56>>2]=o;c[a+116>>2]=(c[a+116>>2]|0)+-1}while((p|0)!=(z|0))}if(!t){n=s;l=r?D:z}else{if(r){c[n>>2]=m;d=z+4|0;l=D}else{n=c[z+4>>2]|0;c[n>>2]=m;d=z+4|0;l=m}c[m+4>>2]=n;c[t>>2]=z;c[d>>2]=t;n=c[K+112>>2]|0;m=0}y=f;f=c[n+12>>2]|0;D=l;t=0;d=c[y+88>>2]|0;o=c[y+96>>2]|0;l=c[y+92>>2]|0;y=c[n+8>>2]|0}else{d=B;y=n}s=c[K+116>>2]|0;if((u|0)<1&(s|0)!=0){r=(F|0)!=0;if(r?(I=c[F+4>>2]|0,(I|0)!=(E|0)):0){p=I;do{n=p+4|0;q=p;p=c[n>>2]|0;l=c[q>>2]|0;o=c[q+8>>2]|0;d=c[o+12>>2]|0;if((l|0)==(q|0))l=0;else{c[l+4>>2]=p;c[c[n>>2]>>2]=l}c[d+8>>2]=l;l=c[o>>2]|0;n=c[q+12>>2]|0;if((l|0)==(o|0))l=0;else{c[l+4>>2]=c[o+4>>2];c[c[o+4>>2]>>2]=l}c[n+8>>2]=l;c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[q+12>>2]=0;c[q+16>>2]=0;c[q>>2]=c[a+56>>2];c[a+56>>2]=q;c[o>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;c[o+12>>2]=0;c[o+16>>2]=0;c[o>>2]=c[a+56>>2];c[a+56>>2]=o;c[a+116>>2]=(c[a+116>>2]|0)+-1}while((p|0)!=(E|0))}if(!b){n=s;j=r?j:E}else{if(r){c[F+4>>2]=k;n=E;l=F}else{l=c[E>>2]|0;c[l+4>>2]=k;n=E;j=k}c[k>>2]=l;c[n>>2]=b;c[b+4>>2]=E;n=c[K+116>>2]|0;k=0}l=h;h=c[n+12>>2]|0;u=0;w=c[l+88>>2]|0;x=c[l+96>>2]|0;l=c[l+92>>2]|0;v=c[n+8>>2]|0}else{u=b;w=d;x=o;v=F}if((h|0)==(g|0)&(f|0)==(G|0)){if(v){r=v+4|0;n=c[r>>2]|0;if((n|0)!=(j|0))do{b=n+4|0;q=n;n=c[b>>2]|0;d=c[q>>2]|0;p=c[q+8>>2]|0;o=c[p+12>>2]|0;if((d|0)==(q|0))d=0;else{c[d+4>>2]=n;c[c[b>>2]>>2]=d}c[o+8>>2]=d;d=c[p>>2]|0;b=c[q+12>>2]|0;if((d|0)==(p|0))d=0;else{c[d+4>>2]=c[p+4>>2];c[c[p+4>>2]>>2]=d}c[b+8>>2]=d;c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[q+12>>2]=0;c[q+16>>2]=0;c[q>>2]=c[a+56>>2];c[a+56>>2]=q;c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;c[p+12>>2]=0;c[p+16>>2]=0;c[p>>2]=c[a+56>>2];c[a+56>>2]=p;c[a+116>>2]=(c[a+116>>2]|0)+-1}while((n|0)!=(j|0));if(u|0){c[k>>2]=v;c[r>>2]=k;c[j>>2]=u;c[u+4>>2]=j}}else{c[k>>2]=u;c[u+4>>2]=k;c[h+8>>2]=u}if(!y){c[t>>2]=m;c[m+4>>2]=t;c[G+8>>2]=t;s=0;q=D;r=e;p=u;b=w;o=x;d=v;n=0;break}n=c[y>>2]|0;if((n|0)!=(D|0))do{p=n;n=c[n>>2]|0;o=c[p+8>>2]|0;b=c[o+12>>2]|0;if((n|0)==(p|0))d=0;else{c[n+4>>2]=c[p+4>>2];c[c[p+4>>2]>>2]=n;d=n}c[b+8>>2]=d;d=c[o>>2]|0;b=c[p+12>>2]|0;if((d|0)==(o|0))d=0;else{c[d+4>>2]=c[o+4>>2];c[c[o+4>>2]>>2]=d}c[b+8>>2]=d;c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;c[p+12>>2]=0;c[p+16>>2]=0;c[p>>2]=c[a+56>>2];c[a+56>>2]=p;c[o>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;c[o+12>>2]=0;c[o+16>>2]=0;c[o>>2]=c[a+56>>2];c[a+56>>2]=o;c[a+116>>2]=(c[a+116>>2]|0)+-1}while((n|0)!=(D|0));if(!t){s=0;q=D;r=e;p=u;t=0;b=w;o=x;d=v;n=y}else{c[y>>2]=m;c[m+4>>2]=y;c[t>>2]=D;c[D+4>>2]=t;s=0;q=D;r=e;p=u;b=w;o=x;d=v;n=y}}else{s=1;q=D;r=0;p=u;b=w;o=x;d=v;n=y}}else{s=Xr(a,x,w)|0;c[s>>2]=s;c[s+4>>2]=s;c[x+8>>2]=s;s=c[s+8>>2]|0;c[s>>2]=s;c[s+4>>2]=s;c[f+8>>2]=s;s=0;q=D;r=e;p=y;t=A;b=B;d=F}while(0);if(!s)break c;w=f;x=h;D=q;e=r;y=p;A=t;B=b;F=d}}while(0);i=K;return}}while(0);c[f+8>>2]=0;c[f>>2]=f;c[f+4>>2]=f;c[e>>2]=f;c[e+4>>2]=f;c[e+8>>2]=f;c[e+12>>2]=f;i=K;return}function Zr(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0;U=c[e>>2]|0;fa=c[f>>2]|0;if(U|0)g=c[U+12>>2]|0;else g=b;i=c[g+88>>2]|0;j=c[g+92>>2]|0;h=c[g+96>>2]|0;if(!fa)g=d;else g=c[fa+12>>2]|0;s=c[g+88>>2]|0;n=c[g+92>>2]|0;p=c[g+96>>2]|0;$=c[b+88>>2]|0;da=(c[d+88>>2]|0)-$|0;u=c[b+92>>2]|0;ea=(c[d+92>>2]|0)-u|0;b=c[b+96>>2]|0;X=(c[d+96>>2]|0)-b|0;Z=c[(U|0?U:fa)+12>>2]|0;aa=(c[Z+88>>2]|0)-$|0;T=(c[Z+92>>2]|0)-u|0;Z=(c[Z+96>>2]|0)-b|0;Y=(_(T,X)|0)-(_(Z,ea)|0)|0;Z=(_(Z,da)|0)-(_(aa,X)|0)|0;T=(_(aa,ea)|0)-(_(T,da)|0)|0;$=jH(Y|0,((Y|0)<0)<<31>>31|0,$|0,(($|0)<0)<<31>>31|0)|0;aa=C;u=jH(Z|0,((Z|0)<0)<<31>>31|0,u|0,((u|0)<0)<<31>>31|0)|0;t=C;b=jH(T|0,((T|0)<0)<<31>>31|0,b|0,((b|0)<0)<<31>>31|0)|0;b=YG($|0,aa|0,b|0,C|0)|0;t=YG(b|0,C|0,u|0,t|0)|0;u=C;b=jH(T|0,((T|0)<0)<<31>>31|0,ea|0,((ea|0)<0)<<31>>31|0)|0;aa=C;$=jH(Z|0,((Z|0)<0)<<31>>31|0,X|0,((X|0)<0)<<31>>31|0)|0;$=XG(b|0,aa|0,$|0,C|0)|0;aa=C;b=jH(Y|0,((Y|0)<0)<<31>>31|0,X|0,((X|0)<0)<<31>>31|0)|0;ca=C;ba=jH(T|0,((T|0)<0)<<31>>31|0,da|0,((da|0)<0)<<31>>31|0)|0;ba=XG(b|0,ca|0,ba|0,C|0)|0;ca=C;b=jH(Z|0,((Z|0)<0)<<31>>31|0,da|0,((da|0)<0)<<31>>31|0)|0;W=C;V=jH(Y|0,((Y|0)<0)<<31>>31|0,ea|0,((ea|0)<0)<<31>>31|0)|0;V=XG(b|0,W|0,V|0,C|0)|0;W=C;b=jH($|0,aa|0,i|0,((i|0)<0)<<31>>31|0)|0;S=C;g=jH(ba|0,ca|0,j|0,((j|0)<0)<<31>>31|0)|0;S=YG(g|0,C|0,b|0,S|0)|0;b=C;g=jH(V|0,W|0,h|0,((h|0)<0)<<31>>31|0)|0;g=YG(S|0,b|0,g|0,C|0)|0;b=C;if((U|0)!=0?(c[U+12>>2]|0)!=0:0){r=U;q=i;o=j;m=h;while(1){r=c[(c[r+8>>2]|0)+4>>2]|0;j=r+12|0;i=c[j>>2]|0;d=c[i+88>>2]|0;R=jH(d|0,((d|0)<0)<<31>>31|0,Y|0,((Y|0)<0)<<31>>31|0)|0;Q=C;h=c[i+92>>2]|0;S=jH(h|0,((h|0)<0)<<31>>31|0,Z|0,((Z|0)<0)<<31>>31|0)|0;Q=YG(S|0,C|0,R|0,Q|0)|0;R=C;i=c[i+96>>2]|0;S=jH(i|0,((i|0)<0)<<31>>31|0,T|0,((T|0)<0)<<31>>31|0)|0;S=YG(Q|0,R|0,S|0,C|0)|0;R=C;if((R|0)<(u|0)|(R|0)==(u|0)&S>>>0<t>>>0){d=q;i=o;h=m;break}if((c[r+20>>2]|0)==(c[a+100>>2]|0)){d=q;i=o;h=m;break}l=jH(d|0,((d|0)<0)<<31>>31|0,$|0,aa|0)|0;S=C;k=jH(h|0,((h|0)<0)<<31>>31|0,ba|0,ca|0)|0;S=YG(k|0,C|0,l|0,S|0)|0;l=C;k=jH(i|0,((i|0)<0)<<31>>31|0,V|0,W|0)|0;k=YG(S|0,l|0,k|0,C|0)|0;l=C;if(!((l|0)>(b|0)|(l|0)==(b|0)&k>>>0>g>>>0)){d=q;i=o;h=m;break}c[e>>2]=r;S=c[j>>2]|0;d=c[S+88>>2]|0;i=c[S+92>>2]|0;h=c[S+96>>2]|0;if(!S){g=k;b=l;break}else{b=l;g=k;q=d;o=i;m=h}}o=c[f>>2]|0;S=i}else{o=fa;d=i;S=j}j=jH($|0,aa|0,s|0,((s|0)<0)<<31>>31|0)|0;R=C;i=jH(ba|0,ca|0,n|0,((n|0)<0)<<31>>31|0)|0;R=YG(i|0,C|0,j|0,R|0)|0;j=C;i=jH(V|0,W|0,p|0,((p|0)<0)<<31>>31|0)|0;i=YG(R|0,j|0,i|0,C|0)|0;j=C;a:do if(o)if(!(c[o+12>>2]|0))k=s;else{r=o;q=s;while(1){o=c[c[r+8>>2]>>2]|0;m=c[o+12>>2]|0;k=c[m+88>>2]|0;Q=jH(k|0,((k|0)<0)<<31>>31|0,Y|0,((Y|0)<0)<<31>>31|0)|0;P=C;l=c[m+92>>2]|0;R=jH(l|0,((l|0)<0)<<31>>31|0,Z|0,((Z|0)<0)<<31>>31|0)|0;P=YG(R|0,C|0,Q|0,P|0)|0;Q=C;m=c[m+96>>2]|0;R=jH(m|0,((m|0)<0)<<31>>31|0,T|0,((T|0)<0)<<31>>31|0)|0;R=YG(P|0,Q|0,R|0,C|0)|0;Q=C;if((Q|0)<(u|0)|(Q|0)==(u|0)&R>>>0<t>>>0){o=r;k=q;break a}if((c[o+20>>2]|0)==(c[a+100>>2]|0)){o=r;k=q;break a}R=jH(k|0,((k|0)<0)<<31>>31|0,$|0,aa|0)|0;Q=C;l=jH(l|0,((l|0)<0)<<31>>31|0,ba|0,ca|0)|0;Q=YG(l|0,C|0,R|0,Q|0)|0;R=C;l=jH(m|0,((m|0)<0)<<31>>31|0,V|0,W|0)|0;l=YG(Q|0,R|0,l|0,C|0)|0;m=C;if(!((m|0)>(j|0)|(m|0)==(j|0)&l>>>0>i>>>0)){o=r;k=q;break a}c[f>>2]=o;R=c[o+12>>2]|0;k=c[R+88>>2]|0;n=c[R+92>>2]|0;p=c[R+96>>2]|0;if(!R){i=l;j=m;break}else{r=o;j=m;i=l;q=k}}}else{o=0;k=s}while(0);i=XG(i|0,j|0,g|0,b|0)|0;b=C;if((b|0)>0|(b|0)==0&i>>>0>0){Q=XG(0,0,T|0,((T|0)<0)<<31>>31|0)|0;R=C;j=o;q=i;m=b;r=d;s=S;t=h;N=k;O=n;P=p;while(1){l=(_(O-s|0,ea)|0)+(_(N-r|0,da)|0)+(_(P-t|0,X)|0)|0;g=c[e>>2]|0;if(!g){E=l;D=l;B=((l|0)<0)<<31>>31;l=q;I=r;H=s;G=t}else{K=l;u=l;L=((l|0)<0)<<31>>31;l=q;H=r;I=s;J=t;b:while(1){if(!(c[g+12>>2]|0)){s=K;t=L;r=H;q=I;g=J;break}G=c[(c[g>>2]|0)+8>>2]|0;if((c[G+20>>2]|0)<=(c[a+100>>2]|0)){s=K;t=L;r=H;q=I;g=J;break}M=c[G+12>>2]|0;r=c[M+88>>2]|0;F=r-H|0;q=c[M+92>>2]|0;E=q-I|0;M=c[M+96>>2]|0;j=M-J|0;t=jH(F|0,((F|0)<0)<<31>>31|0,$|0,aa|0)|0;D=C;s=jH(E|0,((E|0)<0)<<31>>31|0,ba|0,ca|0)|0;D=YG(s|0,C|0,t|0,D|0)|0;t=C;s=jH(j|0,((j|0)<0)<<31>>31|0,V|0,W|0)|0;s=YG(D|0,t|0,s|0,C|0)|0;t=C;j=(_(E,ea)|0)+(_(F,da)|0)+(_(j,X)|0)|0;do if((s|0)==0&(t|0)==0){if((j|0)>=0){s=K;t=L;r=H;q=I;g=J;break b}}else{if((t|0)>=0){s=K;t=L;r=H;q=I;g=J;break b}if((j|0)>0){w=1;x=j;v=((j|0)<0)<<31>>31}else{x=XG(0,0,j|0,((j|0)<0)<<31>>31|0)|0;w=j>>31;x=(j|0)<0?x:0;v=(j|0)<0?C:0}F=0-w|0;A=XG(0,0,s|0,t|0)|0;B=C;if((K|0)>0){j=1;D=u;E=L}else{E=(K|0)<0;D=XG(0,0,u|0,L|0)|0;j=K>>31;D=E?D:0;E=E?C:0}if(!((m|0)>0|(m|0)==0&l>>>0>0))if((m|0)<0){s=XG(0,0,l|0,m|0)|0;j=0-j|0;t=C}else{s=0;t=0}else{s=l;t=m}if((j|0)==(F|0)){if(!w)break;j=jH(s|0,0,x|0,0)|0;w=C;ja=jH(t|0,0,x|0,0)|0;ia=C;y=jH(s|0,0,v|0,0)|0;z=C;ha=jH(t|0,0,v|0,0)|0;x=C;y=YG(ja|0,0,y|0,0)|0;s=C;x=YG(ia|0,0,ha|0,x|0)|0;z=YG(x|0,C|0,z|0,0)|0;s=YG(z|0,C|0,s|0,0)|0;z=C;w=YG(0,y|0,j|0,w|0)|0;x=C;y=YG(s|0,z|0,(x>>>0<y>>>0|(x|0)==(y|0)&w>>>0<0)&1|0,0)|0;z=C;s=jH(D|0,0,A|0,0)|0;j=C;ha=jH(E|0,0,A|0,0)|0;A=C;t=jH(D|0,0,B|0,0)|0;v=C;B=jH(E|0,0,B|0,0)|0;D=C;t=YG(ha|0,0,t|0,0)|0;E=C;D=YG(A|0,0,B|0,D|0)|0;v=YG(D|0,C|0,v|0,0)|0;E=YG(v|0,C|0,E|0,0)|0;v=C;j=YG(0,t|0,s|0,j|0)|0;s=C;t=YG(E|0,v|0,(s>>>0<t>>>0|(s|0)==(t|0)&j>>>0<0)&1|0,0)|0;v=C;do if(z>>>0<v>>>0|(z|0)==(v|0)&y>>>0<t>>>0)j=-1;else{if(z>>>0>v>>>0|(z|0)==(v|0)&y>>>0>t>>>0){j=1;break}if(x>>>0<s>>>0|(x|0)==(s|0)&w>>>0<j>>>0){j=-1;break}j=(x>>>0>s>>>0|(x|0)==(s|0)&w>>>0>j>>>0)&1}while(0);j=_(j,F)|0}else j=F-j|0;if((j|0)<=-1){s=K;t=L;r=H;q=I;g=J;break b}}while(0);ja=N-r|0;ia=O-q|0;j=P-M|0;m=jH(ja|0,((ja|0)<0)<<31>>31|0,$|0,aa|0)|0;ha=C;l=jH(ia|0,((ia|0)<0)<<31>>31|0,ba|0,ca|0)|0;ha=YG(l|0,C|0,m|0,ha|0)|0;m=C;l=jH(j|0,((j|0)<0)<<31>>31|0,V|0,W|0)|0;l=YG(ha|0,m|0,l|0,C|0)|0;m=C;g=(g|0)==(U|0)?0:G;c[e>>2]=g;j=(_(ia,ea)|0)+(_(ja,da)|0)+(_(j,X)|0)|0;if(!g){s=j;u=j;t=((j|0)<0)<<31>>31;g=M;break}else{K=j;u=j;L=((j|0)<0)<<31>>31;H=r;I=q;J=M}}E=s;j=c[f>>2]|0;D=u;B=t;I=r;H=q;G=g}if(!j){g=122;break}if(!(c[j+12>>2]|0)){g=122;break}F=c[c[j+8>>2]>>2]|0;if((c[F+20>>2]|0)<=(c[a+100>>2]|0)){g=122;break}r=c[F+12>>2]|0;t=c[r+88>>2]|0;q=t-N|0;s=c[r+92>>2]|0;j=s-O|0;r=c[r+96>>2]|0;g=r-P|0;ja=jH(q|0,((q|0)<0)<<31>>31|0,Y|0,((Y|0)<0)<<31>>31|0)|0;ha=C;ia=jH(j|0,((j|0)<0)<<31>>31|0,Z|0,((Z|0)<0)<<31>>31|0)|0;ha=YG(ia|0,C|0,ja|0,ha|0)|0;ja=C;ia=jH(g|0,((g|0)<0)<<31>>31|0,Q|0,R|0)|0;if(!((ha|0)==(ia|0)&(ja|0)==(C|0))){g=122;break}v=jH(q|0,((q|0)<0)<<31>>31|0,$|0,aa|0)|0;A=C;u=jH(j|0,((j|0)<0)<<31>>31|0,ba|0,ca|0)|0;A=YG(u|0,C|0,v|0,A|0)|0;v=C;u=jH(g|0,((g|0)<0)<<31>>31|0,V|0,W|0)|0;u=YG(A|0,v|0,u|0,C|0)|0;v=C;g=(_(j,ea)|0)+(_(q,da)|0)+(_(g,X)|0)|0;A=t-I|0;ia=s-H|0;z=r-G|0;A=jH(A|0,((A|0)<0)<<31>>31|0,$|0,aa|0)|0;ja=C;ia=jH(ia|0,((ia|0)<0)<<31>>31|0,ba|0,ca|0)|0;ja=YG(ia|0,C|0,A|0,ja|0)|0;A=C;z=jH(z|0,((z|0)<0)<<31>>31|0,V|0,W|0)|0;z=YG(ja|0,A|0,z|0,C|0)|0;A=C;if(!((A|0)>0|(A|0)==0&z>>>0>0)){g=122;break}if((u|0)==0&(v|0)==0){if((g|0)>=0){g=122;break}}else{if((v|0)>=0){g=122;break}if((g|0)>0){r=1;s=g;q=((g|0)<0)<<31>>31}else{s=XG(0,0,g|0,((g|0)<0)<<31>>31|0)|0;r=g>>31;s=(g|0)<0?s:0;q=(g|0)<0?C:0}y=0-r|0;w=XG(0,0,u|0,v|0)|0;x=C;if((E|0)>0){g=1;v=D;u=B}else{u=(E|0)<0;v=XG(0,0,D|0,B|0)|0;g=E>>31;v=u?v:0;u=u?C:0}do if((m|0)>0|(m|0)==0&l>>>0>0){j=g;g=m}else{if((m|0)>=0){j=g;l=0;g=0;break}l=XG(0,0,l|0,m|0)|0;j=0-g|0;g=C}while(0);if((j|0)==(y|0)){if(!r){g=122;break}ja=jH(l|0,0,s|0,0)|0;r=C;j=jH(g|0,0,s|0,0)|0;P=C;s=jH(l|0,0,q|0,0)|0;t=C;g=jH(g|0,0,q|0,0)|0;q=C;s=YG(j|0,0,s|0,0)|0;j=C;q=YG(P|0,0,g|0,q|0)|0;t=YG(q|0,C|0,t|0,0)|0;j=YG(t|0,C|0,j|0,0)|0;t=C;q=YG(0,s|0,ja|0,r|0)|0;r=C;s=YG(j|0,t|0,(r>>>0<s>>>0|(r|0)==(s|0)&q>>>0<0)&1|0,0)|0;t=C;j=jH(v|0,0,w|0,0)|0;g=C;ja=jH(u|0,0,w|0,0)|0;P=C;l=jH(v|0,0,x|0,0)|0;m=C;ha=jH(u|0,0,x|0,0)|0;ia=C;l=YG(ja|0,0,l|0,0)|0;ja=C;ia=YG(P|0,0,ha|0,ia|0)|0;m=YG(ia|0,C|0,m|0,0)|0;ja=YG(m|0,C|0,ja|0,0)|0;m=C;g=YG(0,l|0,j|0,g|0)|0;j=C;l=YG(ja|0,m|0,(j>>>0<l>>>0|(j|0)==(l|0)&g>>>0<0)&1|0,0)|0;m=C;do if(t>>>0<m>>>0|(t|0)==(m|0)&s>>>0<l>>>0)g=-1;else{if(t>>>0>m>>>0|(t|0)==(m|0)&s>>>0>l>>>0){g=1;break}if(r>>>0<j>>>0|(r|0)==(j|0)&q>>>0<g>>>0){g=-1;break}g=(r>>>0>j>>>0|(r|0)==(j|0)&q>>>0>g>>>0)&1}while(0);g=_(g,y)|0}else g=y-j|0;if((g|0)<=0){g=122;break}}c[f>>2]=F;P=c[F+12>>2]|0;j=F;q=z;m=A;r=I;s=H;t=G;N=c[P+88>>2]|0;O=c[P+92>>2]|0;P=c[P+96>>2]|0}if((g|0)==122)return}if((b|0)>=0)return;F=XG(0,0,T|0,((T|0)<0)<<31>>31|0)|0;G=C;g=S;E=k;c:while(1){D=b;B=i;z=g;d:while(1){A=(_(n-z|0,ea)|0)+(_(E-d|0,da)|0)+(_(p-h|0,X)|0)|0;do if((o|0?c[o+12>>2]|0:0)?(ga=c[(c[o+4>>2]|0)+8>>2]|0,(c[ga+20>>2]|0)>(c[a+100>>2]|0)):0){y=c[ga+12>>2]|0;w=c[y+88>>2]|0;ja=w-E|0;x=c[y+92>>2]|0;ia=x-n|0;y=c[y+96>>2]|0;g=y-p|0;i=jH(ja|0,((ja|0)<0)<<31>>31|0,$|0,aa|0)|0;ha=C;b=jH(ia|0,((ia|0)<0)<<31>>31|0,ba|0,ca|0)|0;ha=YG(b|0,C|0,i|0,ha|0)|0;i=C;b=jH(g|0,((g|0)<0)<<31>>31|0,V|0,W|0)|0;b=YG(ha|0,i|0,b|0,C|0)|0;i=C;g=(_(ia,ea)|0)+(_(ja,da)|0)+(_(g,X)|0)|0;if((b|0)==0&(i|0)==0)if((g|0)>0)break d;else break;if((i|0)<0){if((g|0)>0){k=1;l=g;j=((g|0)<0)<<31>>31}else{l=XG(0,0,g|0,((g|0)<0)<<31>>31|0)|0;k=g>>31;l=(g|0)<0?l:0;j=(g|0)<0?C:0}v=0-k|0;r=XG(0,0,b|0,i|0)|0;s=C;if((A|0)>0){g=1;t=A;u=((A|0)<0)<<31>>31}else{t=XG(0,0,A|0,((A|0)<0)<<31>>31|0)|0;g=A>>31;t=(A|0)<0?t:0;u=(A|0)<0?C:0}if(!((D|0)>0|(D|0)==0&B>>>0>0))if((D|0)<0){b=XG(0,0,B|0,D|0)|0;g=0-g|0;i=C}else{b=0;i=0}else{b=B;i=D}if((g|0)==(v|0)){if(!k)break d;g=jH(b|0,0,l|0,0)|0;k=C;ha=jH(i|0,0,l|0,0)|0;U=C;m=jH(b|0,0,j|0,0)|0;q=C;ja=jH(i|0,0,j|0,0)|0;l=C;m=YG(ha|0,0,m|0,0)|0;b=C;l=YG(U|0,0,ja|0,l|0)|0;q=YG(l|0,C|0,q|0,0)|0;b=YG(q|0,C|0,b|0,0)|0;q=C;k=YG(0,m|0,g|0,k|0)|0;l=C;m=YG(b|0,q|0,(l>>>0<m>>>0|(l|0)==(m|0)&k>>>0<0)&1|0,0)|0;q=C;b=jH(t|0,0,r|0,0)|0;g=C;ja=jH(u|0,0,r|0,0)|0;U=C;i=jH(t|0,0,s|0,0)|0;j=C;ha=jH(u|0,0,s|0,0)|0;ia=C;i=YG(ja|0,0,i|0,0)|0;ja=C;ia=YG(U|0,0,ha|0,ia|0)|0;j=YG(ia|0,C|0,j|0,0)|0;ja=YG(j|0,C|0,ja|0,0)|0;j=C;g=YG(0,i|0,b|0,g|0)|0;b=C;i=YG(ja|0,j|0,(b>>>0<i>>>0|(b|0)==(i|0)&g>>>0<0)&1|0,0)|0;j=C;do if(q>>>0<j>>>0|(q|0)==(j|0)&m>>>0<i>>>0)g=-1;else{if(q>>>0>j>>>0|(q|0)==(j|0)&m>>>0>i>>>0){g=1;break}if(l>>>0<b>>>0|(l|0)==(b|0)&k>>>0<g>>>0){g=-1;break}g=(l>>>0>b>>>0|(l|0)==(b|0)&k>>>0>g>>>0)&1}while(0);g=_(g,v)|0}else g=v-g|0;if((g|0)<1)break d}}while(0);g=c[e>>2]|0;if(!g){g=122;break c}if(!(c[g+12>>2]|0)){g=122;break c}u=c[(c[g+8>>2]|0)+4>>2]|0;if((c[u+20>>2]|0)<=(c[a+100>>2]|0)){g=122;break c}i=c[u+12>>2]|0;k=c[i+88>>2]|0;d=k-d|0;j=c[i+92>>2]|0;b=j-z|0;i=c[i+96>>2]|0;g=i-h|0;ja=jH(d|0,((d|0)<0)<<31>>31|0,Y|0,((Y|0)<0)<<31>>31|0)|0;ha=C;ia=jH(b|0,((b|0)<0)<<31>>31|0,Z|0,((Z|0)<0)<<31>>31|0)|0;ha=YG(ia|0,C|0,ja|0,ha|0)|0;ja=C;ia=jH(g|0,((g|0)<0)<<31>>31|0,F|0,G|0)|0;if(!((ha|0)==(ia|0)&(ja|0)==(C|0))){g=122;break c}l=jH(d|0,((d|0)<0)<<31>>31|0,$|0,aa|0)|0;t=C;h=jH(b|0,((b|0)<0)<<31>>31|0,ba|0,ca|0)|0;t=YG(h|0,C|0,l|0,t|0)|0;l=C;h=jH(g|0,((g|0)<0)<<31>>31|0,V|0,W|0)|0;h=YG(t|0,l|0,h|0,C|0)|0;l=C;g=(_(b,ea)|0)+(_(d,da)|0)+(_(g,X)|0)|0;t=E-k|0;ia=n-j|0;s=p-i|0;t=jH(t|0,((t|0)<0)<<31>>31|0,$|0,aa|0)|0;ja=C;ia=jH(ia|0,((ia|0)<0)<<31>>31|0,ba|0,ca|0)|0;ja=YG(ia|0,C|0,t|0,ja|0)|0;t=C;s=jH(s|0,((s|0)<0)<<31>>31|0,V|0,W|0)|0;s=YG(ja|0,t|0,s|0,C|0)|0;t=C;if((t|0)>=0){g=122;break c}if((h|0)==0&(l|0)==0){if((g|0)<=0){g=122;break c}}else{if((l|0)>=0){g=122;break c}if((g|0)>0){j=g;k=((g|0)<0)<<31>>31;i=1}else{j=XG(0,0,g|0,((g|0)<0)<<31>>31|0)|0;j=(g|0)<0?j:0;k=(g|0)<0?C:0;i=g>>31}r=0-i|0;o=XG(0,0,h|0,l|0)|0;q=C;if((A|0)>0){g=1;m=A;h=((A|0)<0)<<31>>31}else{m=XG(0,0,A|0,((A|0)<0)<<31>>31|0)|0;g=A>>31;m=(A|0)<0?m:0;h=(A|0)<0?C:0}do if((D|0)>0|(D|0)==0&B>>>0>0){d=g;b=B;g=D}else{if((D|0)>=0){d=g;b=0;g=0;break}b=XG(0,0,B|0,D|0)|0;d=0-g|0;g=C}while(0);if((d|0)==(r|0)){if(!i){g=122;break c}ja=jH(b|0,0,j|0,0)|0;i=C;d=jH(g|0,0,j|0,0)|0;U=C;b=jH(b|0,0,k|0,0)|0;l=C;g=jH(g|0,0,k|0,0)|0;j=C;k=YG(d|0,0,b|0,0)|0;b=C;j=YG(U|0,0,g|0,j|0)|0;l=YG(j|0,C|0,l|0,0)|0;b=YG(l|0,C|0,b|0,0)|0;l=C;i=YG(0,k|0,ja|0,i|0)|0;j=C;k=YG(b|0,l|0,(j>>>0<k>>>0|(j|0)==(k|0)&i>>>0<0)&1|0,0)|0;l=C;b=jH(m|0,0,o|0,0)|0;g=C;ja=jH(h|0,0,o|0,0)|0;U=C;d=jH(m|0,0,q|0,0)|0;ia=C;ha=jH(h|0,0,q|0,0)|0;h=C;d=YG(ja|0,0,d|0,0)|0;ja=C;h=YG(U|0,0,ha|0,h|0)|0;h=YG(h|0,C|0,ia|0,0)|0;ja=YG(h|0,C|0,ja|0,0)|0;h=C;g=YG(0,d|0,b|0,g|0)|0;b=C;d=YG(ja|0,h|0,(b>>>0<d>>>0|(b|0)==(d|0)&g>>>0<0)&1|0,0)|0;h=C;do if(l>>>0<h>>>0|(l|0)==(h|0)&k>>>0<d>>>0)g=-1;else{if(l>>>0>h>>>0|(l|0)==(h|0)&k>>>0>d>>>0){g=1;break}if(j>>>0<b>>>0|(j|0)==(b|0)&i>>>0<g>>>0){g=-1;break}g=(j>>>0>b>>>0|(j|0)==(b|0)&i>>>0>g>>>0)&1}while(0);g=_(g,r)|0}else g=r-d|0;if((g|0)>=0){g=122;break c}}c[e>>2]=u;h=c[u+12>>2]|0;o=c[f>>2]|0;D=t;B=s;d=c[h+88>>2]|0;z=c[h+92>>2]|0;h=c[h+96>>2]|0}b=w-d|0;E=x-z|0;i=y-h|0;b=jH(b|0,((b|0)<0)<<31>>31|0,$|0,aa|0)|0;g=C;E=jH(E|0,((E|0)<0)<<31>>31|0,ba|0,ca|0)|0;g=YG(E|0,C|0,b|0,g|0)|0;b=C;i=jH(i|0,((i|0)<0)<<31>>31|0,V|0,W|0)|0;i=YG(g|0,b|0,i|0,C|0)|0;o=(o|0)==(fa|0)?0:ga;c[f>>2]=o;b=C;g=z;E=w;n=x;p=y}if((g|0)==122)return}function _r(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0;i=c[d+8>>2]|0;if(!i){a=0;return a|0}j=i;D=i;i=0;do{if((c[D+20>>2]|0)>(c[a+100>>2]|0)){A=c[D+12>>2]|0;w=c[A+88>>2]|0;x=w-(c[d+88>>2]|0)|0;y=c[A+92>>2]|0;z=y-(c[d+92>>2]|0)|0;A=c[A+96>>2]|0;B=A-(c[d+96>>2]|0)|0;k=jH(c[g>>2]|0,c[g+4>>2]|0,x|0,((x|0)<0)<<31>>31|0)|0;l=C;j=jH(c[g+8>>2]|0,c[g+8+4>>2]|0,z|0,((z|0)<0)<<31>>31|0)|0;l=YG(j|0,C|0,k|0,l|0)|0;k=C;j=jH(c[g+16>>2]|0,c[g+16+4>>2]|0,B|0,((B|0)<0)<<31>>31|0)|0;j=YG(l|0,k|0,j|0,C|0)|0;k=C;l=jH(c[f>>2]|0,c[f+4>>2]|0,x|0,((x|0)<0)<<31>>31|0)|0;v=C;m=jH(c[f+8>>2]|0,c[f+8+4>>2]|0,z|0,((z|0)<0)<<31>>31|0)|0;v=YG(m|0,C|0,l|0,v|0)|0;l=C;m=jH(c[f+16>>2]|0,c[f+16+4>>2]|0,B|0,((B|0)<0)<<31>>31|0)|0;m=YG(v|0,l|0,m|0,C|0)|0;l=C;if((k|0)>0|(k|0)==0&j>>>0>0){v=k;k=1}else{t=XG(0,0,j|0,k|0)|0;v=C;u=$G(j|0,k|0,63)|0;j=(k|0)<0?t:0;v=(k|0)<0?v:0;k=u}if(!((l|0)>0|(l|0)==0&m>>>0>0)){u=XG(0,0,m|0,l|0)|0;n=(l|0)<0?0-k|0:k;k=(l|0)<0?u:0;l=(l|0)<0?C:0;if(!((n|0)==0&((k|0)==0&(l|0)==0))){m=k;o=8}}else{n=k;o=8}a:do if((o|0)==8){o=0;if(!i){c[h>>2]=j;c[h+4>>2]=v;c[h+8>>2]=m;c[h+8+4>>2]=l;c[h+16>>2]=n;i=D;break}k=c[h+16>>2]|0;if((n|0)==(k|0)){if(n|0){p=c[h+8>>2]|0;s=c[h+8+4>>2]|0;o=jH(p|0,0,j|0,0)|0;k=C;t=jH(s|0,0,j|0,0)|0;r=C;p=jH(p|0,0,v|0,0)|0;q=C;s=jH(s|0,0,v|0,0)|0;G=C;p=YG(t|0,0,p|0,0)|0;t=C;G=YG(r|0,0,s|0,G|0)|0;q=YG(G|0,C|0,q|0,0)|0;t=YG(q|0,C|0,t|0,0)|0;q=C;k=YG(0,p|0,o|0,k|0)|0;o=C;p=YG(t|0,q|0,(o>>>0<p>>>0|(o|0)==(p|0)&k>>>0<0)&1|0,0)|0;q=C;t=c[h>>2]|0;G=c[h+4>>2]|0;s=jH(t|0,0,m|0,0)|0;r=C;E=jH(G|0,0,m|0,0)|0;H=C;t=jH(t|0,0,l|0,0)|0;u=C;G=jH(G|0,0,l|0,0)|0;F=C;t=YG(E|0,0,t|0,0)|0;E=C;F=YG(H|0,0,G|0,F|0)|0;u=YG(F|0,C|0,u|0,0)|0;E=YG(u|0,C|0,E|0,0)|0;u=C;r=YG(0,t|0,s|0,r|0)|0;s=C;t=YG(E|0,u|0,(s>>>0<t>>>0|(s|0)==(t|0)&r>>>0<0)&1|0,0)|0;u=C;if(!(q>>>0<u>>>0|(q|0)==(u|0)&p>>>0<t>>>0))if(!(q>>>0>u>>>0|(q|0)==(u|0)&p>>>0>t>>>0))if(o>>>0<s>>>0|(o|0)==(s|0)&k>>>0<r>>>0)k=-1;else k=(o>>>0>s>>>0|(o|0)==(s|0)&k>>>0>r>>>0)&1;else k=1;else k=-1;k=_(k,n)|0;o=18}}else{k=n-k|0;o=18}do if((o|0)==18){o=0;if((k|0)>=0)if(!k)break;else break a;else{c[h>>2]=j;c[h+4>>2]=v;c[h+8>>2]=m;c[h+8+4>>2]=l;c[h+16>>2]=n;i=D;break a}}while(0);j=(c[i+4>>2]|0)==(D|0);if((c[i>>2]|0)==(D|0))if(j){H=c[e+8>>2]|0;E=_(H,z)|0;u=c[e+4>>2]|0;E=E-(_(u,B)|0)|0;G=c[e>>2]|0;H=(_(G,B)|0)-(_(H,x)|0)|0;G=(_(u,x)|0)-(_(G,z)|0)|0;u=c[i+12>>2]|0;j=c[(c[D+8>>2]|0)+12>>2]|0;z=c[j+88>>2]|0;x=(c[u+88>>2]|0)-z|0;v=c[j+92>>2]|0;B=(c[u+92>>2]|0)-v|0;j=c[j+96>>2]|0;u=(c[u+96>>2]|0)-j|0;F=(_(A-j|0,B)|0)-(_(y-v|0,u)|0)|0;j=(_(w-z|0,u)|0)-(_(A-j|0,x)|0)|0;B=(_(y-v|0,x)|0)-(_(w-z|0,B)|0)|0;E=jH(F|0,((F|0)<0)<<31>>31|0,E|0,((E|0)<0)<<31>>31|0)|0;F=C;H=jH(j|0,((j|0)<0)<<31>>31|0,H|0,((H|0)<0)<<31>>31|0)|0;j=C;G=jH(B|0,((B|0)<0)<<31>>31|0,G|0,((G|0)<0)<<31>>31|0)|0;G=YG(E|0,F|0,G|0,C|0)|0;j=YG(G|0,C|0,H|0,j|0)|0;H=C;j=(H|0)>0|(H|0)==0&j>>>0>0?2:1}else j=2;else j=j&1;i=(j|0)==2^b?i:D}while(0);j=c[d+8>>2]|0}D=c[D>>2]|0}while((D|0)!=(j|0));return i|0}function $r(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+16|0;h=c[a+12>>2]|0;j=c[h+(((d+b|0)/2|0)<<4)>>2]|0;k=c[h+(((d+b|0)/2|0)<<4)+4>>2]|0;l=c[h+(((d+b|0)/2|0)<<4)+8>>2]|0;e=b;f=d;while(1){g=e;while(1){e=c[h+(g<<4)+4>>2]|0;if((e|0)>=(k|0)){if((e|0)!=(k|0))break;e=c[h+(g<<4)>>2]|0;if((e|0)>=(j|0)){if((e|0)!=(j|0))break;if((c[h+(g<<4)+8>>2]|0)>=(l|0))break}}g=g+1|0}while(1){e=c[h+(f<<4)+4>>2]|0;if((k|0)>=(e|0)){if((k|0)!=(e|0))break;e=c[h+(f<<4)>>2]|0;if((j|0)>=(e|0)){if((j|0)!=(e|0))break;if((l|0)>=(c[h+(f<<4)+8>>2]|0))break}}f=f+-1|0}if((g|0)>(f|0))e=g;else{e=h+(g<<4)|0;c[m>>2]=c[e>>2];c[m+4>>2]=c[e+4>>2];c[m+8>>2]=c[e+8>>2];c[m+12>>2]=c[e+12>>2];h=h+(f<<4)|0;c[e>>2]=c[h>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2];c[e+12>>2]=c[h+12>>2];e=(c[a+12>>2]|0)+(f<<4)|0;c[e>>2]=c[m>>2];c[e+4>>2]=c[m+4>>2];c[e+8>>2]=c[m+8>>2];c[e+12>>2]=c[m+12>>2];e=g+1|0;f=f+-1|0}if((e|0)>(f|0))break;h=c[a+12>>2]|0}if((f|0)>(b|0))$r(a,b,f);if((e|0)>=(d|0)){i=m;return}$r(a,e,d);i=m;return}function as(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0,g=0;if((d|0)>-1|(d|0)==-1&c>>>0>4294967295){e=(+(c>>>0)+4294967296.0*+(d>>>0))*18446744073709551616.0+(+(a>>>0)+4294967296.0*+(b>>>0));return +e}else{g=XG(0,0,a|0,b|0)|0;f=C;d=YG((a|0)==0&(b|0)==0&1|0,0,~c|0,~d|0)|0;e=-+as(g,f,d,C);return +e}return 0.0}function bs(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0,s=0,t=0.0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0,H=0,I=0,J=0,K=0;J=i;i=i+240|0;if((e|0)<1){f=c[b+12>>2]|0;if(f|0){if(a[b+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;f=c[b+32>>2]|0;if(f|0){if(a[b+36>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;f=c[b+52>>2]|0;if(f|0){if(a[b+56>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;i=J;return}c[J+40+32>>2]=0;c[J+40+36>>2]=0;c[J+40+40>>2]=0;c[J+40+44>>2]=256;c[J+40+48>>2]=0;c[J+40+52>>2]=0;c[J+40+56>>2]=0;c[J+40+60>>2]=256;c[J+40+64>>2]=0;c[J+40+68>>2]=0;c[J+40+72>>2]=0;c[J+40+76>>2]=256;a[J+40+96>>0]=1;F=J+40+92|0;c[F>>2]=0;c[J+40+84>>2]=0;c[J+40+88>>2]=0;m=0;n=-246811958;v=-246811958;s=-246811958;r=1900671690;z=1900671690;u=1900671690;o=d;while(1){E=+g[o>>2];j=+g[o+4>>2];p=+g[o+8>>2];G=E<(c[k>>2]=r,+g[k>>2]);f=(g[k>>2]=E,c[k>>2]|0);r=G?f:r;G=j<(c[k>>2]=u,+g[k>>2]);h=(g[k>>2]=j,c[k>>2]|0);u=G?h:u;G=p<(c[k>>2]=z,+g[k>>2]);l=(g[k>>2]=p,c[k>>2]|0);z=G?l:z;n=(c[k>>2]=n,+g[k>>2])<E?f:n;s=(c[k>>2]=s,+g[k>>2])<j?h:s;v=(c[k>>2]=v,+g[k>>2])<p?l:v;m=m+1|0;if((m|0)==(e|0))break;else o=o+16|0}B=(c[k>>2]=n,+g[k>>2]);A=(c[k>>2]=r,+g[k>>2]);y=(c[k>>2]=s,+g[k>>2]);x=(c[k>>2]=u,+g[k>>2]);w=(c[k>>2]=v,+g[k>>2]);t=(c[k>>2]=z,+g[k>>2]);h=B-A<y-x?(y-x<w-t?2:1):B-A<w-t?2:0;c[J+40+112>>2]=h;f=B-A<y-x?(B-A<w-t?0:2):y-x<w-t?1:2;if((f|0)==(h|0))f=((h+1|0)>>>0)%3|0;c[J+40+104>>2]=f;G=(h^3)-f|0;c[J+40+108>>2]=G;if(((G+1|0)%3|0|0)==(h|0)){j=(B-A)*9.788566967472434e-05;p=(y-x)*9.788566967472434e-05;q=(w-t)*9.788566967472434e-05}else{j=-((B-A)*9.788566967472434e-05);p=-((y-x)*9.788566967472434e-05);q=-((w-t)*9.788566967472434e-05)}g[J+40>>2]=j;g[J+40+4>>2]=p;g[J+40+8>>2]=q;g[J+40+12>>2]=0.0;E=j!=0.0?1.0/j:j;D=p!=0.0?1.0/p:p;C=q!=0.0?1.0/q:q;g[J+40+16>>2]=(B+A)*.5;g[J+40+20>>2]=(y+x)*.5;g[J+40+24>>2]=(w+t)*.5;g[J+40+28>>2]=0.0;r=J+216+16|0;a[r>>0]=1;s=J+216+12|0;c[s>>2]=0;c[J+216+4>>2]=0;c[J+216+8>>2]=0;c[5637]=(c[5637]|0)+1;f=qG((e<<4|3)+16|0)|0;if(!f)m=0;else{c[(f+4+15&-16)+-4>>2]=f;m=f+4+15&-16}h=c[J+216+4>>2]|0;l=c[s>>2]|0;if((h|0)<=0){if(l|0)I=26}else{f=0;do{I=m+(f<<4)|0;G=l+(f<<4)|0;c[I>>2]=c[G>>2];c[I+4>>2]=c[G+4>>2];c[I+8>>2]=c[G+8>>2];c[I+12>>2]=c[G+12>>2];f=f+1|0}while((f|0)!=(h|0));I=26}if((I|0)==26){if(a[r>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[l+-4>>2]|0)}c[s>>2]=0}a[r>>0]=1;c[s>>2]=m;c[J+216+8>>2]=e;c[m>>2]=c[J+200>>2];c[m+4>>2]=c[J+200+4>>2];c[m+8>>2]=c[J+200+8>>2];c[m+12>>2]=c[J+200+12>>2];if((e|0)!=1){f=1;do{G=(c[s>>2]|0)+(f<<4)|0;c[G>>2]=c[J+200>>2];c[G+4>>2]=c[J+200+4>>2];c[G+8>>2]=c[J+200+8>>2];c[G+12>>2]=c[J+200+12>>2];f=f+1|0}while((f|0)!=(e|0))}c[J+216+4>>2]=e;h=J+184+(c[J+40+108>>2]<<2)|0;l=c[s>>2]|0;m=J+184+(c[J+40+112>>2]<<2)|0;n=J+184+(c[J+40+104>>2]<<2)|0;j=+g[J+40+16>>2];p=+g[J+40+20>>2];q=+g[J+40+24>>2];o=0;f=d;while(1){d=c[f>>2]|0;c[J+184>>2]=d;G=c[f+4>>2]|0;c[J+184+4>>2]=G;y=(c[k>>2]=d,+g[k>>2])-j;A=D*((c[k>>2]=G,+g[k>>2])-p);B=C*(+g[f+8>>2]-q);g[J+184>>2]=E*y;g[J+184+4>>2]=A;g[J+184+8>>2]=B;g[J+184+12>>2]=0.0;c[l+(o<<4)>>2]=~~+g[h>>2];c[l+(o<<4)+4>>2]=~~+g[m>>2];c[l+(o<<4)+8>>2]=~~+g[n>>2];c[l+(o<<4)+12>>2]=o;o=o+1|0;if((o|0)==(e|0))break;else f=f+16|0}if((e|0)>1)$r(J+216|0,0,e+-1|0);c[J+40+36>>2]=c[J+40+32>>2];c[J+40+40>>2]=0;c[J+40+44>>2]=e;f=c[J+40+84>>2]|0;if((f|0)<(e|0)){if((c[J+40+88>>2]|0)<(e|0)){if(!e){h=0;l=f}else{c[5637]=(c[5637]|0)+1;h=qG((e<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}l=c[J+40+84>>2]|0}if((l|0)>0){m=0;do{c[h+(m<<2)>>2]=c[(c[F>>2]|0)+(m<<2)>>2];m=m+1|0}while((m|0)!=(l|0))}l=c[F>>2]|0;if(l|0){if(a[J+40+96>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[l+-4>>2]|0)}c[F>>2]=0}a[J+40+96>>0]=1;c[F>>2]=h;c[J+40+88>>2]=e}do{c[(c[F>>2]|0)+(f<<2)>>2]=0;f=f+1|0}while((f|0)!=(e|0))}c[J+40+84>>2]=e;n=0;do{f=c[J+40+40>>2]|0;if(!f){f=c[J+40+36>>2]|0;if(!f){c[5637]=(c[5637]|0)+1;f=qG(31)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}h=c[J+40+44>>2]|0;c[f+4>>2]=h;l=f+8|0;c[l>>2]=0;c[5637]=(c[5637]|0)+1;h=qG((h*112|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}c[f>>2]=h;c[l>>2]=c[J+40+32>>2];c[J+40+32>>2]=f}else c[J+40+36>>2]=c[f+8>>2];m=c[f+4>>2]|0;f=c[f>>2]|0;if((m|0)>0){h=0;l=f;do{h=h+1|0;G=l;l=l+112|0;c[G>>2]=(h|0)<(m|0)?l:0}while((h|0)!=(m|0))}}c[J+40+40>>2]=c[f>>2];G=f+104|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[G>>2]=-1;c[f+8>>2]=0;d=f+88|0;z=(c[s>>2]|0)+(n<<4)|0;c[d>>2]=c[z>>2];c[d+4>>2]=c[z+4>>2];c[d+8>>2]=c[z+8>>2];c[d+12>>2]=c[z+12>>2];c[G>>2]=-1;c[(c[F>>2]|0)+(n<<2)>>2]=f;n=n+1|0}while((n|0)<(e|0));f=c[s>>2]|0;if(f|0){if(a[r>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[s>>2]=0}a[r>>0]=1;c[s>>2]=0;c[J+216+4>>2]=0;c[J+216+8>>2]=0;c[J+40+52>>2]=c[J+40+48>>2];c[J+40+56>>2]=0;c[J+40+60>>2]=e*6;c[J+40+116>>2]=0;c[J+40+120>>2]=0;c[J+40+100>>2]=-3;c[J+184>>2]=0;c[J+184+4>>2]=0;c[J+184+8>>2]=0;c[J+184+12>>2]=0;Yr(J+40|0,0,e,J+184|0);c[J+40+124>>2]=c[J+184>>2];f=c[s>>2]|0;if(f|0){if(a[r>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[s>>2]=0}f=c[b+4>>2]|0;if((f|0)<0){if((c[b+8>>2]|0)<0){h=c[b+12>>2]|0;if(h|0){if(a[b+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=0;c[b+8>>2]=0}do{G=(c[b+12>>2]|0)+(f<<4)|0;c[G>>2]=c[J+168>>2];c[G+4>>2]=c[J+168+4>>2];c[G+8>>2]=c[J+168+8>>2];c[G+12>>2]=c[J+168+12>>2];f=f+1|0}while((f|0)!=0)}c[b+4>>2]=0;c[J+24>>2]=0;c[J+24+4>>2]=0;c[J+24+8>>2]=0;f=c[b+24>>2]|0;if((f|0)<0){if((c[b+28>>2]|0)<0){h=c[b+32>>2]|0;if(h|0){if(a[b+36>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+28>>2]=0}do{G=(c[b+32>>2]|0)+(f*12|0)|0;c[G>>2]=c[J+24>>2];c[G+4>>2]=c[J+24+4>>2];c[G+8>>2]=c[J+24+8>>2];f=f+1|0}while((f|0)!=0)}c[b+24>>2]=0;h=c[b+44>>2]|0;if((h|0)<0){f=c[b+52>>2]|0;do if((c[b+48>>2]|0)<0){if(!f){a[b+56>>0]=1;c[b+52>>2]=0;c[b+48>>2]=0;f=0;break}if(a[b+56>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}a[b+56>>0]=1;c[b+52>>2]=0;c[b+48>>2]=0;f=0}while(0);ZG(f+(h<<2)|0,0,_(h,-4)|0)|0}c[b+44>>2]=0;f=c[J+40+124>>2]|0;if((c[f+104>>2]|0)<0){c[f+104>>2]=0;c[5637]=(c[5637]|0)+1;r=qG(23)|0;c[(r+4+15&-16)+-4>>2]=r;c[(r+4+15&-16)>>2]=f;G=0;m=1;l=1;r=r+4+15&-16;while(1){if((c[f+100>>2]|0)>-1){g[J+216+(c[J+40+108>>2]<<2)>>2]=+(c[f+88>>2]|0);g[J+216+(c[J+40+112>>2]<<2)>>2]=+(c[f+92>>2]|0);j=+(c[f+96>>2]|0)}else{e=f+24|0;d=f+32|0;j=+as(c[e>>2]|0,c[e+4>>2]|0,c[d>>2]|0,c[d+4>>2]|0);d=f+72|0;e=f+80|0;F=c[e>>2]|0;e=c[e+4>>2]|0;j=j/+as(c[d>>2]|0,c[d+4>>2]|0,F,e);g[J+216+(c[J+40+108>>2]<<2)>>2]=j;z=f+40|0;v=f+48|0;j=+as(c[z>>2]|0,c[z+4>>2]|0,c[v>>2]|0,c[v+4>>2]|0);j=j/+as(c[d>>2]|0,c[d+4>>2]|0,F,e);g[J+216+(c[J+40+112>>2]<<2)>>2]=j;v=f+56|0;z=f+64|0;j=+as(c[v>>2]|0,c[v+4>>2]|0,c[z>>2]|0,c[z+4>>2]|0);j=j/+as(c[d>>2]|0,c[d+4>>2]|0,F,e)}g[J+216+(c[J+40+104>>2]<<2)>>2]=j;j=+g[J+216>>2]*+g[J+40>>2]+ +g[J+40+16>>2];p=+g[J+216+4>>2]*+g[J+40+4>>2]+ +g[J+40+20>>2];q=+g[J+216+8>>2]*+g[J+40+8>>2]+ +g[J+40+24>>2];h=c[b+4>>2]|0;if((h|0)==(c[b+8>>2]|0)?(H=h|0?h<<1:1,(h|0)<(H|0)):0){if(!H)o=0;else{c[5637]=(c[5637]|0)+1;h=qG((H<<4|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}o=h;h=c[b+4>>2]|0}if((h|0)>0){n=0;do{e=o+(n<<4)|0;F=(c[b+12>>2]|0)+(n<<4)|0;c[e>>2]=c[F>>2];c[e+4>>2]=c[F+4>>2];c[e+8>>2]=c[F+8>>2];c[e+12>>2]=c[F+12>>2];n=n+1|0}while((n|0)!=(h|0))}h=c[b+12>>2]|0;if(h|0){if(a[b+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=o;c[b+8>>2]=H;h=c[b+4>>2]|0}F=c[b+12>>2]|0;g[F+(h<<4)>>2]=j;g[F+(h<<4)+4>>2]=p;g[F+(h<<4)+8>>2]=q;g[F+(h<<4)+12>>2]=0.0;c[b+4>>2]=(c[b+4>>2]|0)+1;F=c[f+8>>2]|0;if(!F)n=r;else{e=F;f=-1;z=r;d=-1;while(1){v=e+20|0;h=c[v>>2]|0;if((h|0)<0){u=c[b+24>>2]|0;c[J+12>>2]=0;c[J+12+4>>2]=0;c[J+12+8>>2]=0;do if((u|0)==(c[b+28>>2]|0)){r=u|0?u<<1:1;if((u|0)>=(r|0)){h=u;break}if(!r){h=0;n=u}else{c[5637]=(c[5637]|0)+1;h=qG((r*12|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}n=c[b+24>>2]|0}if((n|0)>0){o=0;do{s=h+(o*12|0)|0;K=(c[b+32>>2]|0)+(o*12|0)|0;c[s>>2]=c[K>>2];c[s+4>>2]=c[K+4>>2];c[s+8>>2]=c[K+8>>2];o=o+1|0}while((o|0)!=(n|0))}n=c[b+32>>2]|0;if(n|0){if(a[b+36>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[n+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=h;c[b+28>>2]=r;h=c[b+24>>2]|0}else h=u;while(0);h=(c[b+32>>2]|0)+(h*12|0)|0;c[h>>2]=c[J+12>>2];c[h+4>>2]=c[J+12+4>>2];c[h+8>>2]=c[J+12+8>>2];h=(c[b+24>>2]|0)+1|0;c[b+24>>2]=h;c[J>>2]=0;c[J+4>>2]=0;c[J+8>>2]=0;do if((h|0)==(c[b+28>>2]|0)){r=h|0?h<<1:1;if((h|0)>=(r|0))break;if(!r)o=0;else{c[5637]=(c[5637]|0)+1;h=qG((r*12|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}o=h;h=c[b+24>>2]|0}if((h|0)>0){n=0;do{K=o+(n*12|0)|0;s=(c[b+32>>2]|0)+(n*12|0)|0;c[K>>2]=c[s>>2];c[K+4>>2]=c[s+4>>2];c[K+8>>2]=c[s+8>>2];n=n+1|0}while((n|0)!=(h|0))}h=c[b+32>>2]|0;if(h|0){if(a[b+36>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=o;c[b+28>>2]=r;h=c[b+24>>2]|0}while(0);s=(c[b+32>>2]|0)+(h*12|0)|0;c[s>>2]=c[J>>2];c[s+4>>2]=c[J+4>>2];c[s+8>>2]=c[J+8>>2];c[b+24>>2]=(c[b+24>>2]|0)+1;s=c[b+32>>2]|0;c[v>>2]=u;c[(c[e+8>>2]|0)+20>>2]=u+1;c[s+(u*12|0)+4>>2]=1;c[s+((u+1|0)*12|0)+4>>2]=-1;r=c[e+12>>2]|0;h=c[r+104>>2]|0;if((h|0)<0){c[r+104>>2]=l;do if((l|0)==(m|0)){o=m|0?m<<1:1;if((m|0)>=(o|0)){n=z;break}do if(!o)n=0;else{c[5637]=(c[5637]|0)+1;h=qG((o<<2|3)+16|0)|0;if(!h){n=0;break}c[(h+4+15&-16)+-4>>2]=h;n=h+4+15&-16}while(0);if((m|0)<=0){if(!z){m=o;break}}else{h=0;do{c[n+(h<<2)>>2]=c[z+(h<<2)>>2];h=h+1|0}while((h|0)!=(m|0))}c[5638]=(c[5638]|0)+1;rG(c[z+-4>>2]|0);m=o}else n=z;while(0);c[n+(l<<2)>>2]=r;h=l;l=l+1|0}else n=z;c[s+(u*12|0)+8>>2]=h;c[s+((u+1|0)*12|0)+8>>2]=G;h=c[v>>2]|0}else n=z;if((d|0)>-1)c[(c[b+32>>2]|0)+(h*12|0)>>2]=d-h;else f=h;e=c[e>>2]|0;if((e|0)==(F|0))break;else{z=n;d=h}}c[(c[b+32>>2]|0)+(f*12|0)>>2]=h-f}h=G+1|0;if((h|0)>=(l|0))break;f=c[n+(h<<2)>>2]|0;G=h;r=n}if((G|0)>-1){v=0;while(1){s=c[(c[n+(v<<2)>>2]|0)+8>>2]|0;if(s|0){u=s;do{r=u+20|0;f=c[r>>2]|0;if((f|0)>-1){h=c[b+44>>2]|0;do if((h|0)==(c[b+48>>2]|0)){o=h|0?h<<1:1;if((h|0)>=(o|0))break;if(!o)f=0;else{c[5637]=(c[5637]|0)+1;f=qG((o<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}h=c[b+44>>2]|0}m=c[b+52>>2]|0;if((h|0)<=0){if(m)I=173}else{l=0;do{c[f+(l<<2)>>2]=c[m+(l<<2)>>2];l=l+1|0}while((l|0)!=(h|0));I=173}if((I|0)==173){I=0;if(a[b+56>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[m+-4>>2]|0)}c[b+52>>2]=0;h=c[b+44>>2]|0}a[b+56>>0]=1;c[b+52>>2]=f;c[b+48>>2]=o;f=c[r>>2]|0}while(0);c[(c[b+52>>2]|0)+(h<<2)>>2]=f;c[b+44>>2]=(c[b+44>>2]|0)+1;f=u;do{c[f+20>>2]=-1;f=c[(c[f+8>>2]|0)+4>>2]|0}while((f|0)!=(u|0))}u=c[u>>2]|0}while((u|0)!=(s|0))}if((v|0)==(G|0))break;else v=v+1|0}}if(n|0){c[5638]=(c[5638]|0)+1;rG(c[n+-4>>2]|0)}}cs(J+40|0);i=J;return}function cs(b){b=b|0;var d=0,e=0;d=c[b+92>>2]|0;if(d|0){if(a[b+96>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+92>>2]=0}a[b+96>>0]=1;c[b+92>>2]=0;c[b+84>>2]=0;c[b+88>>2]=0;d=c[b+64>>2]|0;if(d|0)do{c[b+64>>2]=c[d+8>>2];e=c[d>>2]|0;if(e|0){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0)}c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0);d=c[b+64>>2]|0}while((d|0)!=0);d=c[b+48>>2]|0;if(d|0)do{c[b+48>>2]=c[d+8>>2];e=c[d>>2]|0;if(e|0){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0)}c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0);d=c[b+48>>2]|0}while((d|0)!=0);d=c[b+32>>2]|0;if(!d)return;do{c[b+32>>2]=c[d+8>>2];e=c[d>>2]|0;if(e|0){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0)}c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0);d=c[b+32>>2]|0}while((d|0)!=0);return}function ds(){var a=0,b=0;while(1){a=qG(8)|0;if(a|0){b=6;break}a=c[5831]|0;c[5831]=a+0;if(!a){b=5;break}_b[a&3]()}if((b|0)==5){b=Va(4)|0;c[b>>2]=8308;hb(b|0,2416,215)}else if((b|0)==6){c[5649]=a;kb(a|0,0)|0;c[5639]=16373;c[5640]=0;c[5641]=0;c[5642]=0;c[5643]=0;c[5644]=0;c[5645]=0;c[5646]=0;c[5647]=0;es(22556);return}}function es(a){a=a|0;var b=0;do{c[a+4>>2]=0;g[a+8>>2]=0.0;b=c[a+24>>2]|0;if(b|0)es(b);a=c[a+28>>2]|0}while((a|0)!=0);return}function fs(a){a=a|0;var b=0,d=0,e=0,f=0;f=i;i=i+16|0;d=c[2006]|0;if((c[d>>2]|0)==(a|0))b=d;else{b=c[d+24>>2]|0;a:do if(!b)e=5;else while(1){if((c[b>>2]|0)==(a|0))break a;b=c[b+28>>2]|0;if(!b){e=5;break}}while(0);do if((e|0)==5){while(1){b=qG(36)|0;if(b|0){e=9;break}b=c[5831]|0;c[5831]=b+0;if(!b){e=8;break}_b[b&3]();e=5}if((e|0)==8){f=Va(4)|0;c[f>>2]=8308;hb(f|0,2416,215)}else if((e|0)==9){c[b>>2]=a;c[b+4>>2]=0;c[b+4+4>>2]=0;c[b+4+8>>2]=0;c[b+4+12>>2]=0;c[b+20>>2]=d;c[b+24>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;es(b);c[b+28>>2]=c[d+24>>2];c[d+24>>2]=b;break}}while(0);c[2006]=b}a=b+4|0;c[a>>2]=(c[a>>2]|0)+1;a=b+16|0;e=c[a>>2]|0;c[a>>2]=e+1;if(e|0){i=f;return}kb(f|0,0)|0;e=c[5649]|0;c[b+12>>2]=(c[f+4>>2]|0)-(c[e+4>>2]|0)+(((c[f>>2]|0)-(c[e>>2]|0)|0)*1e6|0);i=f;return}function gs(a,d){a=a|0;d=d|0;var e=0,f=0;while(1){e=qG(80)|0;if(e|0){f=6;break}e=c[5831]|0;c[5831]=e+0;if(!e){f=5;break}_b[e&3]()}if((f|0)==5){d=Va(4)|0;c[d>>2]=8308;hb(d|0,2416,215)}else if((f|0)==6){g[e+4>>2]=1.0;b[e+8>>1]=1;b[e+10>>1]=-1;c[e>>2]=7848;c[e+12>>2]=c[a>>2];c[e+12+4>>2]=c[a+4>>2];c[e+12+8>>2]=c[a+8>>2];c[e+12+12>>2]=c[a+12>>2];c[e+28>>2]=c[d>>2];c[e+28+4>>2]=c[d+4>>2];c[e+28+8>>2]=c[d+8>>2];c[e+28+12>>2]=c[d+12>>2];c[e+76>>2]=0;return e|0}return 0}function hs(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function is(a){a=a|0;return +(+g[a+4>>2])}function js(a){a=a|0;return b[a+8>>1]|0}function ks(a){a=a|0;return b[a+10>>1]|0}function ls(a){a=a|0;return a+12|0}function ms(a){a=a|0;return a+28|0}function ns(a){a=a|0;return a+44|0}function os(a){a=a|0;return a+60|0}function ps(a){a=a|0;return +g[a+4>>2]<1.0|0}function qs(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function rs(a,c){a=a|0;c=c|0;b[a+8>>1]=c;return}function ss(a,c){a=a|0;c=c|0;b[a+10>>1]=c;return}function ts(a,b){a=a|0;b=b|0;c[a+12>>2]=c[b>>2];c[a+12+4>>2]=c[b+4>>2];c[a+12+8>>2]=c[b+8>>2];c[a+12+12>>2]=c[b+12>>2];return}function us(a,b){a=a|0;b=b|0;c[a+28>>2]=c[b>>2];c[a+28+4>>2]=c[b+4>>2];c[a+28+8>>2]=c[b+8>>2];c[a+28+12>>2]=c[b+12>>2];return}function vs(a,b){a=a|0;b=b|0;c[a+44>>2]=c[b>>2];c[a+44+4>>2]=c[b+4>>2];c[a+44+8>>2]=c[b+8>>2];c[a+44+12>>2]=c[b+12>>2];return}function ws(a,b){a=a|0;b=b|0;c[a+60>>2]=c[b>>2];c[a+60+4>>2]=c[b+4>>2];c[a+60+8>>2]=c[b+8>>2];c[a+60+12>>2]=c[b+12>>2];return}function xs(a,d){a=a|0;d=d|0;var e=0,f=0;while(1){e=qG(84)|0;if(e|0){f=6;break}e=c[5831]|0;c[5831]=e+0;if(!e){f=5;break}_b[e&3]()}if((f|0)==5){d=Va(4)|0;c[d>>2]=8308;hb(d|0,2416,215)}else if((f|0)==6){g[e+4>>2]=1.0;c[e+8>>2]=0;b[e+12>>1]=1;b[e+14>>1]=-1;c[e+16>>2]=0;c[e>>2]=8008;c[e+20>>2]=c[a>>2];c[e+20+4>>2]=c[a+4>>2];c[e+20+8>>2]=c[a+8>>2];c[e+20+12>>2]=c[a+12>>2];c[e+36>>2]=c[d>>2];c[e+36+4>>2]=c[d+4>>2];c[e+36+8>>2]=c[d+8>>2];c[e+36+12>>2]=c[d+12>>2];return e|0}return 0}function ys(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function zs(a){a=a|0;return b[a+12>>1]|0}function As(a){a=a|0;return b[a+14>>1]|0}function Bs(a){a=a|0;return c[a+8>>2]|0}function Cs(a){a=a|0;return a+52|0}function Ds(a){a=a|0;return a+68|0}function Es(a){a=a|0;return a+20|0}function Fs(a){a=a|0;return a+36|0}function Gs(a){a=a|0;return (c[a+8>>2]|0)!=0|0}function Hs(a,c){a=a|0;c=c|0;b[a+12>>1]=c;return}function Is(a,c){a=a|0;c=c|0;b[a+14>>1]=c;return}function Js(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Ks(a,b){a=a|0;b=b|0;c[a+52>>2]=c[b>>2];c[a+52+4>>2]=c[b+4>>2];c[a+52+8>>2]=c[b+8>>2];c[a+52+12>>2]=c[b+12>>2];return}function Ls(a,b){a=a|0;b=b|0;c[a+68>>2]=c[b>>2];c[a+68+4>>2]=c[b+4>>2];c[a+68+8>>2]=c[b+8>>2];c[a+68+12>>2]=c[b+12>>2];return}function Ms(a,b){a=a|0;b=b|0;c[a+20>>2]=c[b>>2];c[a+20+4>>2]=c[b+4>>2];c[a+20+8>>2]=c[b+8>>2];c[a+20+12>>2]=c[b+12>>2];return}function Ns(a,b){a=a|0;b=b|0;c[a+36>>2]=c[b>>2];c[a+36+4>>2]=c[b+4>>2];c[a+36+8>>2]=c[b+8>>2];c[a+36+12>>2]=c[b+12>>2];return}function Os(){var a=0,d=0;while(1){a=qG(8)|0;if(a|0){d=6;break}a=c[5831]|0;c[5831]=a+0;if(!a){d=5;break}_b[a&3]()}if((d|0)==5){d=Va(4)|0;c[d>>2]=8308;hb(d|0,2416,215)}else if((d|0)==6){c[a>>2]=0;c[a+4>>2]=0;b[a+4>>1]=1;b[a+6>>1]=-1;c[a>>2]=8036;return a|0}return 0}function Ps(a){a=a|0;return}function Qs(a){a=a|0;rG(a);return}function Rs(a,d){a=a|0;d=d|0;d=c[d+4>>2]|0;if(!((b[a+6>>1]&(d&65535))<<16>>16)){a=0;return a|0}a=(d>>>16&65535&b[a+4>>1])<<16>>16!=0;return a|0}function Ss(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;return +(+fb(0,a|0,b|0,c|0,d|0,e|0,f|0,g|0,h|0))}function Ts(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Us(a,b,d,e,f,g,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;return +(+Bb[c[(c[a>>2]|0)+12>>2]&1](a,b,d,e,f,g,h,i))}function Vs(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ws(a,b,d,e,f,g,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;return +(+Bb[c[(c[a>>2]|0)+12>>2]&1](a,b,d,e,f,g,h,i))}function Xs(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ys(a){a=a|0;return +(+g[a+4>>2])}function Zs(a){a=a|0;return b[a+8>>1]|0}function _s(a){a=a|0;return b[a+10>>1]|0}function $s(a){a=a|0;return +g[a+4>>2]<1.0|0}function at(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function bt(a,c){a=a|0;c=c|0;b[a+8>>1]=c;return}function ct(a,c){a=a|0;c=c|0;b[a+10>>1]=c;return}function dt(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var h=0,i=0;while(1){h=qG(44)|0;if(h|0){i=6;break}h=c[5831]|0;c[5831]=h+0;if(!h){i=5;break}_b[h&3]()}if((i|0)==5){e=Va(4)|0;c[e>>2]=8308;hb(e|0,2416,215)}else if((i|0)==6){c[h>>2]=a;c[h+4>>2]=b;c[h+8>>2]=c[d>>2];c[h+8+4>>2]=c[d+4>>2];c[h+8+8>>2]=c[d+8>>2];c[h+8+12>>2]=c[d+12>>2];c[h+24>>2]=c[e>>2];c[h+24+4>>2]=c[e+4>>2];c[h+24+8>>2]=c[e+8>>2];c[h+24+12>>2]=c[e+12>>2];g[h+40>>2]=f;return h|0}return 0}function et(a){a=a|0;if(!a)return;rG(a);return}function ft(a){a=a|0;return c[a>>2]|0}function gt(a){a=a|0;return +(+g[a+40>>2])}function ht(a){a=a|0;return a+8|0}function it(a){a=a|0;return a+24|0}function jt(a){a=a|0;return c[a+4>>2]|0}function kt(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function lt(a,b){a=a|0;b=+b;g[a+40>>2]=b;return}function mt(a,b){a=a|0;b=b|0;c[a+8>>2]=c[b>>2];c[a+8+4>>2]=c[b+4>>2];c[a+8+8>>2]=c[b+8>>2];c[a+8+12>>2]=c[b+12>>2];return}function nt(a,b){a=a|0;b=b|0;c[a+24>>2]=c[b>>2];c[a+24+4>>2]=c[b+4>>2];c[a+24+8>>2]=c[b+8>>2];c[a+24+12>>2]=c[b+12>>2];return}function ot(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function pt(a){a=a|0;if(!a)return;rG(a);return}function qt(a){a=a|0;return c[a>>2]|0}function rt(a){a=a|0;return c[a+4>>2]|0}function st(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function tt(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function ut(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function vt(a){a=a|0;return b[a+12>>1]|0}function wt(a){a=a|0;return b[a+14>>1]|0}function xt(a){a=a|0;return c[a+8>>2]|0}function yt(a){a=a|0;return (c[a+8>>2]|0)!=0|0}function zt(a,c){a=a|0;c=c|0;b[a+12>>1]=c;return}function At(a,c){a=a|0;c=c|0;b[a+14>>1]=c;return}function Bt(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Ct(a){a=a|0;if(!a)return;rG(a);return}function Dt(a){a=a|0;return a|0}function Et(a){a=a|0;return a+16|0}function Ft(a){a=a|0;return c[a+88>>2]|0}function Gt(a){a=a|0;return a+36|0}function Ht(b){b=b|0;return (a[b+84>>0]|0)!=0|0}function It(a){a=a|0;return +(+g[a+32>>2])}function Jt(a){a=a|0;return a+68|0}function Kt(a){a=a|0;return a+52|0}function Lt(a,b){a=a|0;b=b|0;c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];return}function Mt(a,b){a=a|0;b=b|0;c[a+16>>2]=c[b>>2];c[a+16+4>>2]=c[b+4>>2];c[a+16+8>>2]=c[b+8>>2];c[a+16+12>>2]=c[b+12>>2];return}function Nt(a,b){a=a|0;b=b|0;c[a+88>>2]=b;return}function Ot(a,b){a=a|0;b=b|0;c[a+36>>2]=c[b>>2];c[a+36+4>>2]=c[b+4>>2];c[a+36+8>>2]=c[b+8>>2];c[a+36+12>>2]=c[b+12>>2];return}function Pt(b,c){b=b|0;c=c|0;a[b+84>>0]=c&1;return}function Qt(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function Rt(a,b){a=a|0;b=b|0;c[a+68>>2]=c[b>>2];c[a+68+4>>2]=c[b+4>>2];c[a+68+8>>2]=c[b+8>>2];c[a+68+12>>2]=c[b+12>>2];return}function St(a,b){a=a|0;b=b|0;c[a+52>>2]=c[b>>2];c[a+52+4>>2]=c[b+4>>2];c[a+52+8>>2]=c[b+8>>2];c[a+52+12>>2]=c[b+12>>2];return}function Tt(a){a=a|0;if(!a)return;rG(a);return}function Ut(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Vt(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Wt(a,b){a=a|0;b=b|0;var d=0;c[5637]=(c[5637]|0)+1;d=qG(135)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}lc(d,a,b,16384,0,0);return d|0}function Xt(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;c[5637]=(c[5637]|0)+1;e=qG(135)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}lc(e,a,b,d&65535,0,0);return e|0}function Yt(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;c[5637]=(c[5637]|0)+1;f=qG(135)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}lc(f,a,b,d&65535,e,0);return f|0}function Zt(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0;c[5637]=(c[5637]|0)+1;g=qG(135)|0;if(!g)g=0;else{c[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}lc(g,a,b,d&65535,e,f);return g|0}function _t(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function $t(a){a=a|0;var b=0;c[5637]=(c[5637]|0)+1;b=qG(79)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}jj(b,a);return b|0}function au(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function bu(a){a=a|0;return +(+Hb[c[(c[a>>2]|0)+48>>2]&15](a))}function cu(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function du(a,b){a=a|0;b=+b;qb[c[(c[a>>2]|0)+44>>2]&31](a,b);return}function eu(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function fu(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function gu(a,b){a=a|0;b=b|0;var d=0;c[5637]=(c[5637]|0)+1;d=qG(99)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}yj(d,a,b,1);return d|0}function hu(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;c[5637]=(c[5637]|0)+1;e=qG(99)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}yj(e,a,b,d);return e|0}function iu(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function ju(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function ku(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function lu(a,b){a=+a;b=+b;var d=0;c[5637]=(c[5637]|0)+1;d=qG(79)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}c[d+8>>2]=0;c[d+12>>2]=-1;c[d+16>>2]=1065353216;c[d+20>>2]=1065353216;c[d+24>>2]=1065353216;g[d+28>>2]=0.0;g[d+48>>2]=.03999999910593033;c[d+4>>2]=10;c[d>>2]=4976;c[d+56>>2]=0;g[d+32>>2]=b*.5;g[d+36>>2]=a;g[d+40>>2]=a;g[d+44>>2]=0.0;return d|0}function mu(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function nu(a){a=a|0;return +(+Hb[c[(c[a>>2]|0)+48>>2]&15](a))}function ou(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function pu(a,b){a=a|0;b=+b;qb[c[(c[a>>2]|0)+44>>2]&31](a,b);return}function qu(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function ru(a,b){a=+a;b=+b;var d=0;c[5637]=(c[5637]|0)+1;d=qG(79)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}c[d+8>>2]=0;c[d+12>>2]=-1;c[d+16>>2]=1065353216;c[d+20>>2]=1065353216;c[d+24>>2]=1065353216;g[d+28>>2]=0.0;g[d+48>>2]=.03999999910593033;c[d+4>>2]=10;c[d>>2]=5076;c[d+56>>2]=2;g[d+32>>2]=a;g[d+36>>2]=a;g[d+40>>2]=b*.5;g[d+44>>2]=0.0;return d|0}function su(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function tu(a){a=a|0;return +(+Hb[c[(c[a>>2]|0)+48>>2]&15](a))}function uu(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function vu(a,b){a=a|0;b=+b;qb[c[(c[a>>2]|0)+44>>2]&31](a,b);return}function wu(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function xu(a,b){a=+a;b=+b;var d=0;c[5637]=(c[5637]|0)+1;d=qG(79)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}c[d+8>>2]=0;c[d+12>>2]=-1;c[d+16>>2]=1065353216;c[d+20>>2]=1065353216;c[d+24>>2]=1065353216;g[d+28>>2]=0.0;g[d+48>>2]=.03999999910593033;c[d>>2]=4876;c[d+4>>2]=10;c[d+56>>2]=1;g[d+32>>2]=a;g[d+36>>2]=b*.5;g[d+40>>2]=a;g[d+44>>2]=0.0;return d|0}function yu(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function zu(a){a=a|0;return +(+Hb[c[(c[a>>2]|0)+48>>2]&15](a))}function Au(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Bu(a,b){a=a|0;b=+b;qb[c[(c[a>>2]|0)+44>>2]&31](a,b);return}function Cu(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Du(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Eu(a){a=a|0;var b=0,d=0;while(1){b=qG(5260)|0;if(b|0){d=6;break}b=c[5831]|0;c[5831]=b+0;if(!b){d=5;break}_b[b&3]()}if((d|0)==5){a=Va(4)|0;c[a>>2]=8308;hb(a|0,2416,215)}else if((d|0)==6){Qe(b,a);return b|0}return 0}function Fu(a,b){a=a|0;b=b|0;return Ob[c[(c[a>>2]|0)+40>>2]&31](a,b)|0}function Gu(a){a=a|0;return vb[c[(c[a>>2]|0)+36>>2]&127](a)|0}function Hu(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Iu(a){a=a|0;if(c[a+204>>2]&3|0)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function Ju(a,b){a=a|0;b=b|0;if(!b?c[a+204>>2]&3|0:0)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function Ku(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function Lu(a){a=a|0;return c[a+204>>2]|0}function Mu(a){a=a|0;return c[a+192>>2]|0}function Nu(a){a=a|0;return a+4|0}function Ou(a){a=a|0;a=c[a+216>>2]|0;return (a|0)!=5&(a|0)!=2|0}function Pu(a){a=a|0;return (c[a+204>>2]&2|0)!=0|0}function Qu(a,b){a=a|0;b=b|0;if((c[a+216>>2]&-2|0)==4)return;c[a+216>>2]=b;return}function Ru(a,b,d){a=a|0;b=b|0;d=d|0;c[a+164>>2]=c[b>>2];c[a+164+4>>2]=c[b+4>>2];c[a+164+8>>2]=c[b+8>>2];c[a+164+12>>2]=c[b+12>>2];if(!(+g[b>>2]!=1.0)?!(+g[b+4>>2]!=1.0):0)d=+g[b+8>>2]!=1.0?d:0;c[a+180>>2]=d;return}function Su(a,b){a=a|0;b=+b;g[a+256>>2]=b;return}function Tu(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function Uu(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function Vu(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+8>>2]&127](a,b);return}function Wu(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function Xu(a,b){a=a|0;b=+b;c[a+284>>2]=(c[a+284>>2]|0)+1;g[a+224>>2]=b;return}function Yu(a,b){a=a|0;b=+b;c[a+284>>2]=(c[a+284>>2]|0)+1;g[a+228>>2]=b;return}function Zu(a,b){a=a|0;b=+b;c[a+284>>2]=(c[a+284>>2]|0)+1;g[a+232>>2]=b;return}function _u(a,b){a=a|0;b=b|0;c[a+284>>2]=(c[a+284>>2]|0)+1;c[a+4>>2]=c[b>>2];c[a+4+4>>2]=c[b+4>>2];c[a+4+8>>2]=c[b+8>>2];c[a+4+12>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+20+4>>2]=c[b+16+4>>2];c[a+20+8>>2]=c[b+16+8>>2];c[a+20+12>>2]=c[b+16+12>>2];c[a+36>>2]=c[b+32>>2];c[a+36+4>>2]=c[b+32+4>>2];c[a+36+8>>2]=c[b+32+8>>2];c[a+36+12>>2]=c[b+32+12>>2];c[a+52>>2]=c[b+48>>2];c[a+52+4>>2]=c[b+48+4>>2];c[a+52+8>>2]=c[b+48+8>>2];c[a+52+12>>2]=c[b+48+12>>2];return}function $u(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function av(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function bv(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function cv(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function dv(a,b){a=a|0;b=b|0;bc[c[(c[a>>2]|0)+36>>2]&127](a,b,1,-1);return}function ev(a,b,d){a=a|0;b=b|0;d=d|0;bc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,-1);return}function fv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,e);return}function gv(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ig(a,b,c,d);return}function hv(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+48|0;f=c[b+192>>2]|0;bc[c[(c[f>>2]|0)+8>>2]&127](f,b+4|0,e+32|0,e+16|0);c[e>>2]=3544;c[e+4>>2]=b;c[e+8>>2]=a;c[e+12>>2]=d;a=c[a+68>>2]|0;bc[c[(c[a>>2]|0)+28>>2]&127](a,e+32|0,e+16|0,e);i=e;return}function iv(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;Yf(a,b,c,d,e,f);return}function jv(a){a=a|0;return c[a+68>>2]|0}function kv(a){a=a|0;return a+28|0}function lv(a){a=a|0;return c[a+24>>2]|0}function mv(a){a=a|0;a=c[a+68>>2]|0;return vb[c[(c[a>>2]|0)+36>>2]&127](a)|0}function nv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bc[c[(c[a>>2]|0)+32>>2]&127](a,b,d,e);return}function ov(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function pv(b,d,e){b=b|0;d=d|0;e=e|0;var f=0.0,h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0,q=0,r=0,s=0;p=i;i=i+128|0;c[b+72>>2]=(c[b+72>>2]|0)+1;c[p>>2]=c[d>>2];c[p+4>>2]=c[d+4>>2];c[p+8>>2]=c[d+8>>2];c[p+12>>2]=c[d+12>>2];c[p+16>>2]=c[d+16>>2];c[p+16+4>>2]=c[d+16+4>>2];c[p+16+8>>2]=c[d+16+8>>2];c[p+16+12>>2]=c[d+16+12>>2];c[p+32>>2]=c[d+32>>2];c[p+32+4>>2]=c[d+32+4>>2];c[p+32+8>>2]=c[d+32+8>>2];c[p+32+12>>2]=c[d+32+12>>2];c[p+48>>2]=c[d+48>>2];c[p+48+4>>2]=c[d+48+4>>2];c[p+48+8>>2]=c[d+48+8>>2];c[p+48+12>>2]=c[d+48+12>>2];n=c[e+4>>2]|0;o=+Hb[c[(c[e>>2]|0)+48>>2]&15](e);bc[c[(c[e>>2]|0)+8>>2]&127](e,d,p+112|0,p+96|0);f=+g[p+112>>2];if(+g[b+36>>2]>f)g[b+36>>2]=f;f=+g[p+96>>2];if(+g[b+52>>2]<f)g[b+52>>2]=f;f=+g[p+112+4>>2];if(+g[b+40>>2]>f)g[b+40>>2]=f;f=+g[p+96+4>>2];if(+g[b+56>>2]<f)g[b+56>>2]=f;f=+g[p+112+8>>2];if(+g[b+44>>2]>f)g[b+44>>2]=f;f=+g[p+96+8>>2];if(+g[b+60>>2]<f)g[b+60>>2]=f;l=c[b+68>>2]|0;if(!l){l=b+20|0;k=0}else{c[p+64>>2]=c[p+112>>2];c[p+64+4>>2]=c[p+112+4>>2];c[p+64+8>>2]=c[p+112+8>>2];c[p+64+12>>2]=c[p+112+12>>2];c[p+64+16>>2]=c[p+96>>2];c[p+64+16+4>>2]=c[p+96+4>>2];c[p+64+16+8>>2]=c[p+96+8>>2];c[p+64+16+12>>2]=c[p+96+12>>2];k=c[b+20>>2]|0;d=c[l+4>>2]|0;if(!d){c[5637]=(c[5637]|0)+1;d=qG(63)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}h=d;j=h+44|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(j|0))}else c[l+4>>2]=0;c[d+32>>2]=0;c[d+36>>2]=k;c[d+40>>2]=0;c[d>>2]=c[p+64>>2];c[d+4>>2]=c[p+64+4>>2];c[d+8>>2]=c[p+64+8>>2];c[d+12>>2]=c[p+64+12>>2];c[d+16>>2]=c[p+64+16>>2];c[d+20>>2]=c[p+64+20>>2];c[d+24>>2]=c[p+64+24>>2];c[d+28>>2]=c[p+64+28>>2];bd(l,c[l>>2]|0,d);c[l+12>>2]=(c[l+12>>2]|0)+1;l=b+20|0;k=d}d=c[l>>2]|0;if((d|0)==(c[b+24>>2]|0)?(m=d|0?d<<1:1,(d|0)<(m|0)):0){if(!m)j=0;else{c[5637]=(c[5637]|0)+1;d=qG((m*80|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}j=d;d=c[l>>2]|0}if((d|0)>0){h=0;do{q=j+(h*80|0)|0;r=c[b+28>>2]|0;s=r+(h*80|0)|0;c[q>>2]=c[s>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=j+(h*80|0)+16|0;s=r+(h*80|0)+16|0;c[q>>2]=c[s>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=j+(h*80|0)+32|0;s=r+(h*80|0)+32|0;c[q>>2]=c[s>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=j+(h*80|0)+48|0;s=r+(h*80|0)+48|0;c[q>>2]=c[s>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=j+(h*80|0)+64|0;r=r+(h*80|0)+64|0;c[q>>2]=c[r>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];c[q+12>>2]=c[r+12>>2];h=h+1|0}while((h|0)!=(d|0))}d=c[b+28>>2]|0;if(d|0){if(a[b+32>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+28>>2]=0}a[b+32>>0]=1;c[b+28>>2]=j;c[b+24>>2]=m;d=c[l>>2]|0}s=c[b+28>>2]|0;r=s+(d*80|0)|0;c[r>>2]=c[p>>2];c[r+4>>2]=c[p+4>>2];c[r+8>>2]=c[p+8>>2];c[r+12>>2]=c[p+12>>2];r=s+(d*80|0)+16|0;c[r>>2]=c[p+16>>2];c[r+4>>2]=c[p+16+4>>2];c[r+8>>2]=c[p+16+8>>2];c[r+12>>2]=c[p+16+12>>2];r=s+(d*80|0)+32|0;c[r>>2]=c[p+32>>2];c[r+4>>2]=c[p+32+4>>2];c[r+8>>2]=c[p+32+8>>2];c[r+12>>2]=c[p+32+12>>2];r=s+(d*80|0)+48|0;c[r>>2]=c[p+48>>2];c[r+4>>2]=c[p+48+4>>2];c[r+8>>2]=c[p+48+8>>2];c[r+12>>2]=c[p+48+12>>2];s=s+(d*80|0)+64|0;c[s>>2]=e;c[s+4>>2]=n;g[s+8>>2]=o;c[s+12>>2]=k;c[l>>2]=(c[l>>2]|0)+1;i=p;return}function qv(){var a=0;c[5637]=(c[5637]|0)+1;a=qG(115)|0;if(!a)a=0;else{c[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16}nk(a,1,0);return a|0}function rv(a){a=a|0;var b=0;c[5637]=(c[5637]|0)+1;b=qG(115)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}nk(b,a,0);return b|0}function sv(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function tv(a,b){a=a|0;b=b|0;return c[(c[a+28>>2]|0)+(b*80|0)+64>>2]|0}function uv(a){a=a|0;return +(+Hb[c[(c[a>>2]|0)+48>>2]&15](a))}function vv(a){a=a|0;return c[a+20>>2]|0}function wv(a,b){a=a|0;b=b|0;lk(a,b);return}function xv(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function yv(a,b){a=a|0;b=+b;qb[c[(c[a>>2]|0)+44>>2]&31](a,b);return}function zv(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Av(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Bv(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Cv(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Dv(a,b){a=+a;b=+b;var d=0;c[5637]=(c[5637]|0)+1;d=qG(99)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}c[d+8>>2]=0;c[d+12>>2]=-1;c[d+16>>2]=1065353216;c[d+20>>2]=1065353216;c[d+24>>2]=1065353216;g[d+28>>2]=0.0;g[d+48>>2]=.03999999910593033;g[d+60>>2]=a;g[d+64>>2]=b;c[d+4>>2]=11;g[d+56>>2]=a/+O(+(a*a+b*b));c[d>>2]=5456;c[d+68>>2]=1;c[d+72>>2]=0;c[d+76>>2]=2;g[d+36>>2]=a;g[d+32>>2]=b;g[d+40>>2]=a;return d|0}function Ev(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Fv(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Gv(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Hv(a,b){a=+a;b=+b;var d=0;c[5637]=(c[5637]|0)+1;d=qG(99)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}c[d+8>>2]=0;c[d+12>>2]=-1;c[d+16>>2]=1065353216;c[d+20>>2]=1065353216;c[d+24>>2]=1065353216;g[d+28>>2]=0.0;g[d+48>>2]=.03999999910593033;g[d+60>>2]=a;g[d+64>>2]=b;c[d+4>>2]=11;g[d+56>>2]=a/+O(+(a*a+b*b));c[d>>2]=5356;c[d+68>>2]=0;c[d+72>>2]=2;c[d+76>>2]=1;g[d+32>>2]=a;g[d+40>>2]=b;g[d+36>>2]=a;return d|0}function Iv(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Jv(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Kv(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Lv(a,b){a=+a;b=+b;var d=0;c[5637]=(c[5637]|0)+1;d=qG(99)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}c[d+8>>2]=0;c[d+12>>2]=-1;c[d+16>>2]=1065353216;c[d+20>>2]=1065353216;c[d+24>>2]=1065353216;g[d+28>>2]=0.0;g[d+48>>2]=.03999999910593033;c[d>>2]=5256;g[d+60>>2]=a;g[d+64>>2]=b;c[d+4>>2]=11;c[d+68>>2]=0;c[d+72>>2]=1;c[d+76>>2]=2;g[d+32>>2]=a;g[d+36>>2]=b;g[d+40>>2]=a;g[d+56>>2]=a/+O(+(a*a+b*b));return d|0}function Mv(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Nv(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Ov(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Pv(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0;c[5637]=(c[5637]|0)+1;e=qG(627)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}yq(e,5,b);c[e>>2]=7132;h=e+300|0;c[h>>2]=c[d>>2];c[h+4>>2]=c[d+4>>2];c[h+8>>2]=c[d+8>>2];c[h+12>>2]=c[d+12>>2];f=e+316|0;c[f>>2]=c[d+16>>2];c[f+4>>2]=c[d+16+4>>2];c[f+8>>2]=c[d+16+8>>2];c[f+12>>2]=c[d+16+12>>2];b=e+332|0;c[b>>2]=c[d+32>>2];c[b+4>>2]=c[d+32+4>>2];c[b+8>>2]=c[d+32+8>>2];c[b+12>>2]=c[d+32+12>>2];i=e+348|0;c[i>>2]=c[d+48>>2];c[i+4>>2]=c[d+48+4>>2];c[i+8>>2]=c[d+48+8>>2];c[i+12>>2]=c[d+48+12>>2];d=e+364|0;a[e+527>>0]=0;c[d>>2]=c[h>>2];c[d+4>>2]=c[h+4>>2];c[d+8>>2]=c[h+8>>2];c[d+12>>2]=c[h+12>>2];d=e+380|0;c[d>>2]=c[f>>2];c[d+4>>2]=c[f+4>>2];c[d+8>>2]=c[f+8>>2];c[d+12>>2]=c[f+12>>2];d=e+396|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];d=e+412|0;a[e+524>>0]=0;a[e+525>>0]=0;a[e+526>>0]=0;a[e+552>>0]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;g[e+572>>2]=-1.0;g[e+444>>2]=999999984306749440.0;g[e+448>>2]=999999984306749440.0;g[e+452>>2]=999999984306749440.0;g[e+428>>2]=1.0;g[e+432>>2]=.30000001192092896;g[e+436>>2]=1.0;g[e+440>>2]=.009999999776482582;g[e+456>>2]=.05000000074505806;c[e+592>>2]=0;g[e+596>>2]=0.0;g[e+600>>2]=.699999988079071;g[e+604>>2]=0.0;return e|0}function Qv(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0;c[5637]=(c[5637]|0)+1;h=qG(627)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}c[h+4>>2]=5;c[h+8>>2]=-1;c[h+12>>2]=-1;g[h+16>>2]=3402823466385288598117041.0e14;a[h+20>>0]=1;a[h+21>>0]=0;c[h+24>>2]=-1;c[h+28>>2]=b;c[h+32>>2]=d;g[h+36>>2]=0.0;g[h+40>>2]=.30000001192092896;c[h+44>>2]=0;c[h>>2]=7132;d=h+300|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=h+316|0;c[d>>2]=c[e+16>>2];c[d+4>>2]=c[e+16+4>>2];c[d+8>>2]=c[e+16+8>>2];c[d+12>>2]=c[e+16+12>>2];d=h+332|0;c[d>>2]=c[e+32>>2];c[d+4>>2]=c[e+32+4>>2];c[d+8>>2]=c[e+32+8>>2];c[d+12>>2]=c[e+32+12>>2];d=h+348|0;c[d>>2]=c[e+48>>2];c[d+4>>2]=c[e+48+4>>2];c[d+8>>2]=c[e+48+8>>2];c[d+12>>2]=c[e+48+12>>2];e=h+364|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=h+380|0;c[e>>2]=c[f+16>>2];c[e+4>>2]=c[f+16+4>>2];c[e+8>>2]=c[f+16+8>>2];c[e+12>>2]=c[f+16+12>>2];e=h+396|0;c[e>>2]=c[f+32>>2];c[e+4>>2]=c[f+32+4>>2];c[e+8>>2]=c[f+32+8>>2];c[e+12>>2]=c[f+32+12>>2];e=h+412|0;c[e>>2]=c[f+48>>2];c[e+4>>2]=c[f+48+4>>2];c[e+8>>2]=c[f+48+8>>2];c[e+12>>2]=c[f+48+12>>2];a[h+552>>0]=0;c[h+524>>2]=0;g[h+572>>2]=-1.0;g[h+444>>2]=999999984306749440.0;g[h+448>>2]=999999984306749440.0;g[h+452>>2]=999999984306749440.0;g[h+428>>2]=1.0;g[h+432>>2]=.30000001192092896;g[h+436>>2]=1.0;g[h+440>>2]=.009999999776482582;g[h+456>>2]=.05000000074505806;c[h+592>>2]=0;g[h+596>>2]=0.0;g[h+600>>2]=.699999988079071;g[h+604>>2]=0.0;return h|0}function Rv(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function Sv(b,c){b=b|0;c=c|0;a[b+552>>0]=c&1;return}function Tv(a){a=a|0;return +(+g[a+16>>2])}function Uv(b,c){b=b|0;c=c|0;a[b+524>>0]=c&1;return}function Vv(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function Wv(a,b){a=a|0;b=+b;g[a+440>>2]=b;return}function Xv(a,b,c){a=a|0;b=b|0;c=+c;switch(b|0){case 3:{g[a+452>>2]=c;return}case 4:{g[a+448>>2]=c;return}case 5:{g[a+444>>2]=c;return}default:return}}function Yv(b,c){b=b|0;c=+c;g[b+572>>2]=c;a[b+553>>0]=1;return}function Zv(b,c){b=b|0;c=+c;g[b+572>>2]=c;a[b+553>>0]=0;return}function _v(a,b){a=a|0;b=b|0;To(a,b);return}function $v(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0;c=i;i=i+48|0;_f(a+364|0,c+16|0);h=-+g[c+16>>2];e=-+g[c+16+4>>2];m=-+g[c+16+8>>2];l=+g[c+16+12>>2];f=+g[b>>2];n=+g[b+12>>2];k=+g[b+8>>2];j=+g[b+4>>2];_f(a+300|0,c);p=+g[c>>2];q=+g[c+12>>2];d=+g[c+8>>2];o=+g[c+4>>2];g[c+32>>2]=p*(l*n-f*h-j*e-k*m)+(l*f+n*h+k*e-j*m)*q+(f*m+(n*e+l*j)-k*h)*d-(n*m+l*k+j*h-f*e)*o;g[c+32+4>>2]=p*(n*m+l*k+j*h-f*e)+(q*(f*m+(n*e+l*j)-k*h)+(l*n-f*h-j*e-k*m)*o)-(l*f+n*h+k*e-j*m)*d;g[c+32+8>>2]=q*(n*m+l*k+j*h-f*e)+(l*n-f*h-j*e-k*m)*d+(l*f+n*h+k*e-j*m)*o-p*(f*m+(n*e+l*j)-k*h);g[c+32+12>>2]=(l*n-f*h-j*e-k*m)*q-p*(l*f+n*h+k*e-j*m)-(f*m+(n*e+l*j)-k*h)*o-(n*m+l*k+j*h-f*e)*d;To(a,c+32|0);i=c;return}function aw(a){a=a|0;if(!a)return;rG(a);return}function bw(){var a=0,b=0;while(1){a=qG(12)|0;if(a|0){b=6;break}a=c[5831]|0;c[5831]=a+0;if(!a){b=5;break}_b[a&3]()}if((b|0)==5){b=Va(4)|0;c[b>>2]=8308;hb(b|0,2416,215)}else if((b|0)==6){g[a>>2]=.30000001192092896;g[a+4>>2]=1.0;g[a+8>>2]=0.0;return a|0}return 0}function cw(a){a=a|0;return +(+g[a+4>>2])}function dw(a){a=a|0;return +(+g[a+8>>2])}function ew(a){a=a|0;return +(+g[a>>2])}function fw(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function gw(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function hw(a,b){a=a|0;b=+b;g[a>>2]=b;return}function iw(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function jw(a){a=a|0;if(!a)return;rG(a);return}function kw(a){a=a|0;return ~~+g[a+48>>2]|0}function lw(a){a=a|0;return (c[a+44>>2]|0)!=0|0}function mw(a,b){a=a|0;b=b|0;g[a+48>>2]=+(b|0);return}function nw(a,b){a=a|0;b=b|0;c[a+44>>2]=b&1;return}function ow(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function pw(a,b){a=a|0;b=b|0;Xk(a,b,1);return}function qw(a,b,c){a=a|0;b=b|0;c=c|0;Xk(a,b,c);return}function rw(){var a=0;c[5637]=(c[5637]|0)+1;a=qG(135)|0;if(!a)a=0;else{c[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16}Wk(a,0,0,16);return a|0}function sw(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function tw(a){a=a|0;return +(+Hb[c[(c[a>>2]|0)+48>>2]&15](a))}function uw(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function vw(a,b){a=a|0;b=+b;qb[c[(c[a>>2]|0)+44>>2]&31](a,b);return}function ww(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function xw(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function yw(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function zw(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Aw(a){a=a|0;var b=0;c[5637]=(c[5637]|0)+1;b=qG(119)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}xl(b,a,1);return b|0}function Bw(a,b){a=a|0;b=b|0;var d=0;c[5637]=(c[5637]|0)+1;d=qG(119)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}xl(d,a,b);return d|0}function Cw(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Dw(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Ew(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Fw(a){a=a|0;var b=0;c[5637]=(c[5637]|0)+1;b=qG(79)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}Vl(b,a);c[b>>2]=5960;c[b+56>>2]=0;return b|0}function Gw(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Hw(a){a=a|0;return +(+Hb[c[(c[a>>2]|0)+48>>2]&15](a))}function Iw(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Jw(a,b){a=a|0;b=+b;qb[c[(c[a>>2]|0)+44>>2]&31](a,b);return}function Kw(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Lw(a){a=a|0;var b=0;c[5637]=(c[5637]|0)+1;b=qG(79)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}Vl(b,a);c[b>>2]=6064;c[b+56>>2]=2;return b|0}function Mw(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Nw(a){a=a|0;return +(+Hb[c[(c[a>>2]|0)+48>>2]&15](a))}function Ow(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Pw(a,b){a=a|0;b=+b;qb[c[(c[a>>2]|0)+44>>2]&31](a,b);return}function Qw(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Rw(a){a=a|0;var b=0;c[5637]=(c[5637]|0)+1;b=qG(79)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}Vl(b,a);return b|0}function Sw(a,b,d){a=a|0;b=+b;d=d|0;Ab[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Tw(a){a=a|0;return +(+Hb[c[(c[a>>2]|0)+48>>2]&15](a))}function Uw(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Vw(a,b){a=a|0;b=+b;qb[c[(c[a>>2]|0)+44>>2]&31](a,b);return}function Ww(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Xw(){var a=0,b=0;while(1){a=qG(196)|0;if(a|0){b=6;break}a=c[5831]|0;c[5831]=a+0;if(!a){b=5;break}_b[a&3]()}if((b|0)==5){b=Va(4)|0;c[b>>2]=8308;hb(b|0,2416,215)}else if((b|0)==6){Gd(a,0);return a|0}return 0}function Yw(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Zw(){var a=0,b=0,d=0;d=i;i=i+32|0;while(1){a=qG(92)|0;if(a|0){b=6;break}a=c[5831]|0;c[5831]=a+0;if(!a){b=5;break}_b[a&3]()}if((b|0)==5){d=Va(4)|0;c[d>>2]=8308;hb(d|0,2416,215)}else if((b|0)==6){c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=4096;c[d+12>>2]=4096;c[d+16>>2]=0;c[d+20>>2]=1;Ih(a,d);i=d;return a|0}return 0}function _w(a){a=a|0;var b=0,d=0;while(1){b=qG(92)|0;if(b|0){d=6;break}b=c[5831]|0;c[5831]=b+0;if(!b){d=5;break}_b[b&3]()}if((d|0)==5){a=Va(4)|0;c[a>>2]=8308;hb(a|0,2416,215)}else if((d|0)==6){Ih(b,a);return b|0}return 0}function $w(a){a=a|0;if(!a)return;rG(a);return}function ax(){var a=0,b=0;while(1){a=qG(24)|0;if(a|0){b=6;break}a=c[5831]|0;c[5831]=a+0;if(!a){b=5;break}_b[a&3]()}if((b|0)==5){b=Va(4)|0;c[b>>2]=8308;hb(b|0,2416,215)}else if((b|0)==6){c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=4096;c[a+12>>2]=4096;c[a+16>>2]=0;c[a+20>>2]=1;return a|0}return 0}function bx(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function cx(){var b=0,d=0;c[5637]=(c[5637]|0)+1;b=qG(219)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}if(!(a[19848]|0)){a[19848]=1;if(!(a[19856]|0)){a[19856]=1;c[5017]=1065353216;c[5018]=0;c[5019]=0;c[5020]=0;c[5021]=0;c[5022]=1065353216;c[5023]=0;c[5024]=0;c[5025]=0;c[5026]=0;c[5027]=1065353216;g[5028]=0.0};c[5029]=c[5017];c[5030]=c[5018];c[5031]=c[5019];c[5032]=c[5020];c[5033]=c[5021];c[5034]=c[5022];c[5035]=c[5023];c[5036]=c[5024];c[5037]=c[5025];c[5038]=c[5026];c[5039]=c[5027];c[5040]=c[5028];c[5041]=0;c[5042]=0;c[5043]=0;c[5044]=0}if(!(a[19848]|0)){a[19848]=1;if(!(a[19856]|0)){a[19856]=1;c[5017]=1065353216;c[5018]=0;c[5019]=0;c[5020]=0;c[5021]=0;c[5022]=1065353216;c[5023]=0;c[5024]=0;c[5025]=0;c[5026]=0;c[5027]=1065353216;g[5028]=0.0};c[5029]=c[5017];c[5030]=c[5018];c[5031]=c[5019];c[5032]=c[5020];c[5033]=c[5021];c[5034]=c[5022];c[5035]=c[5023];c[5036]=c[5024];c[5037]=c[5025];c[5038]=c[5026];c[5039]=c[5027];c[5040]=c[5028];c[5041]=0;c[5042]=0;c[5043]=0;c[5044]=0}c[b>>2]=8060;d=b+4|0;c[d>>2]=c[5029];c[d+4>>2]=c[5030];c[d+8>>2]=c[5031];c[d+12>>2]=c[5032];d=b+20|0;c[d>>2]=c[5033];c[d+4>>2]=c[5034];c[d+8>>2]=c[5035];c[d+12>>2]=c[5036];d=b+36|0;c[d>>2]=c[5037];c[d+4>>2]=c[5038];c[d+8>>2]=c[5039];c[d+12>>2]=c[5040];d=b+52|0;c[d>>2]=c[5041];c[d+4>>2]=c[5042];c[d+8>>2]=c[5043];c[d+12>>2]=c[5044];d=b+68|0;c[d>>2]=c[5029];c[d+4>>2]=c[5030];c[d+8>>2]=c[5031];c[d+12>>2]=c[5032];d=b+84|0;c[d>>2]=c[5033];c[d+4>>2]=c[5034];c[d+8>>2]=c[5035];c[d+12>>2]=c[5036];d=b+100|0;c[d>>2]=c[5037];c[d+4>>2]=c[5038];c[d+8>>2]=c[5039];c[d+12>>2]=c[5040];d=b+116|0;c[d>>2]=c[5041];c[d+4>>2]=c[5042];c[d+8>>2]=c[5043];c[d+12>>2]=c[5044];d=b+132|0;c[d>>2]=c[5029];c[d+4>>2]=c[5030];c[d+8>>2]=c[5031];c[d+12>>2]=c[5032];d=b+148|0;c[d>>2]=c[5033];c[d+4>>2]=c[5034];c[d+8>>2]=c[5035];c[d+12>>2]=c[5036];d=b+164|0;c[d>>2]=c[5037];c[d+4>>2]=c[5038];c[d+8>>2]=c[5039];c[d+12>>2]=c[5040];d=b+180|0;c[d>>2]=c[5041];c[d+4>>2]=c[5042];c[d+8>>2]=c[5043];c[d+12>>2]=c[5044];c[b+196>>2]=0;return b|0}function dx(a){a=a|0;return}function ex(a){a=a|0;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function fx(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;r=+g[a+68>>2];o=+g[a+84>>2];l=+g[a+100>>2];q=+g[a+72>>2];n=+g[a+88>>2];j=+g[a+104>>2];p=+g[a+76>>2];m=+g[a+92>>2];h=+g[a+108>>2];z=-+g[a+116>>2];y=-+g[a+120>>2];c=-+g[a+124>>2];x=+g[a+4>>2];w=+g[a+8>>2];v=+g[a+12>>2];u=+g[a+20>>2];t=+g[a+24>>2];s=+g[a+28>>2];k=+g[a+36>>2];i=+g[a+40>>2];f=+g[a+44>>2];e=x*(r*z+o*y+l*c)+(q*z+n*y+j*c)*w+(p*z+m*y+h*c)*v+ +g[a+52>>2];d=(r*z+o*y+l*c)*u+(q*z+n*y+j*c)*t+(p*z+m*y+h*c)*s+ +g[a+56>>2];c=(r*z+o*y+l*c)*k+(q*z+n*y+j*c)*i+(p*z+m*y+h*c)*f+ +g[a+60>>2];g[b>>2]=r*x+q*w+p*v;g[b+4>>2]=o*x+n*w+m*v;g[b+8>>2]=l*x+j*w+h*v;g[b+12>>2]=0.0;g[b+16>>2]=r*u+q*t+p*s;g[b+20>>2]=o*u+n*t+m*s;g[b+24>>2]=l*u+j*t+h*s;g[b+28>>2]=0.0;g[b+32>>2]=r*k+q*i+p*f;g[b+36>>2]=o*k+n*i+m*f;g[b+40>>2]=l*k+j*i+h*f;g[b+44>>2]=0.0;g[b+48>>2]=e;g[b+52>>2]=d;g[b+56>>2]=c;g[b+60>>2]=0.0;return}function gx(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;r=+g[a+68>>2];x=+g[b>>2];q=+g[a+84>>2];w=+g[b+4>>2];p=+g[a+100>>2];v=+g[b+8>>2];o=+g[a+72>>2];n=+g[a+88>>2];m=+g[a+104>>2];l=+g[a+76>>2];j=+g[a+92>>2];h=+g[a+108>>2];u=+g[b+16>>2];t=+g[b+20>>2];s=+g[b+24>>2];k=+g[b+32>>2];i=+g[b+36>>2];f=+g[b+40>>2];z=+g[a+116>>2];y=+g[a+120>>2];c=+g[a+124>>2];e=+g[b+48>>2]+(x*z+w*y+v*c);d=u*z+t*y+s*c+ +g[b+52>>2];c=k*z+i*y+f*c+ +g[b+56>>2];g[a+4>>2]=r*x+q*w+p*v;g[a+8>>2]=x*o+w*n+v*m;g[a+12>>2]=x*l+w*j+v*h;g[a+16>>2]=0.0;g[a+20>>2]=r*u+q*t+p*s;g[a+24>>2]=o*u+n*t+m*s;g[a+28>>2]=l*u+j*t+h*s;g[a+32>>2]=0.0;g[a+36>>2]=r*k+q*i+p*f;g[a+40>>2]=o*k+n*i+m*f;g[a+44>>2]=l*k+j*i+h*f;g[a+48>>2]=0.0;g[a+52>>2]=e;g[a+56>>2]=d;g[a+60>>2]=c;g[a+64>>2]=0.0;return}function hx(b){b=b|0;var d=0,e=0;c[5637]=(c[5637]|0)+1;d=qG(219)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}if(!(a[19848]|0)){a[19848]=1;if(!(a[19856]|0)){a[19856]=1;c[5017]=1065353216;c[5018]=0;c[5019]=0;c[5020]=0;c[5021]=0;c[5022]=1065353216;c[5023]=0;c[5024]=0;c[5025]=0;c[5026]=0;c[5027]=1065353216;g[5028]=0.0};c[5029]=c[5017];c[5030]=c[5018];c[5031]=c[5019];c[5032]=c[5020];c[5033]=c[5021];c[5034]=c[5022];c[5035]=c[5023];c[5036]=c[5024];c[5037]=c[5025];c[5038]=c[5026];c[5039]=c[5027];c[5040]=c[5028];c[5041]=0;c[5042]=0;c[5043]=0;c[5044]=0}c[d>>2]=8060;e=d+4|0;c[e>>2]=c[b>>2];c[e+4>>2]=c[b+4>>2];c[e+8>>2]=c[b+8>>2];c[e+12>>2]=c[b+12>>2];e=d+20|0;c[e>>2]=c[b+16>>2];c[e+4>>2]=c[b+16+4>>2];c[e+8>>2]=c[b+16+8>>2];c[e+12>>2]=c[b+16+12>>2];e=d+36|0;c[e>>2]=c[b+32>>2];c[e+4>>2]=c[b+32+4>>2];c[e+8>>2]=c[b+32+8>>2];c[e+12>>2]=c[b+32+12>>2];e=d+52|0;c[e>>2]=c[b+48>>2];c[e+4>>2]=c[b+48+4>>2];c[e+8>>2]=c[b+48+8>>2];c[e+12>>2]=c[b+48+12>>2];e=d+68|0;c[e>>2]=c[5029];c[e+4>>2]=c[5030];c[e+8>>2]=c[5031];c[e+12>>2]=c[5032];e=d+84|0;c[e>>2]=c[5033];c[e+4>>2]=c[5034];c[e+8>>2]=c[5035];c[e+12>>2]=c[5036];e=d+100|0;c[e>>2]=c[5037];c[e+4>>2]=c[5038];c[e+8>>2]=c[5039];c[e+12>>2]=c[5040];e=d+116|0;c[e>>2]=c[5041];c[e+4>>2]=c[5042];c[e+8>>2]=c[5043];c[e+12>>2]=c[5044];e=d+132|0;c[e>>2]=c[b>>2];c[e+4>>2]=c[b+4>>2];c[e+8>>2]=c[b+8>>2];c[e+12>>2]=c[b+12>>2];e=d+148|0;c[e>>2]=c[b+16>>2];c[e+4>>2]=c[b+16+4>>2];c[e+8>>2]=c[b+16+8>>2];c[e+12>>2]=c[b+16+12>>2];e=d+164|0;c[e>>2]=c[b+32>>2];c[e+4>>2]=c[b+32+4>>2];c[e+8>>2]=c[b+32+8>>2];c[e+12>>2]=c[b+32+12>>2];e=d+180|0;c[e>>2]=c[b+48>>2];c[e+4>>2]=c[b+48+4>>2];c[e+8>>2]=c[b+48+8>>2];c[e+12>>2]=c[b+48+12>>2];c[d+196>>2]=0;return d|0}function ix(a,b){a=a|0;b=b|0;var d=0,e=0;c[5637]=(c[5637]|0)+1;d=qG(219)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}c[d>>2]=8060;e=d+4|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];e=d+20|0;c[e>>2]=c[a+16>>2];c[e+4>>2]=c[a+16+4>>2];c[e+8>>2]=c[a+16+8>>2];c[e+12>>2]=c[a+16+12>>2];e=d+36|0;c[e>>2]=c[a+32>>2];c[e+4>>2]=c[a+32+4>>2];c[e+8>>2]=c[a+32+8>>2];c[e+12>>2]=c[a+32+12>>2];e=d+52|0;c[e>>2]=c[a+48>>2];c[e+4>>2]=c[a+48+4>>2];c[e+8>>2]=c[a+48+8>>2];c[e+12>>2]=c[a+48+12>>2];e=d+68|0;c[e>>2]=c[b>>2];c[e+4>>2]=c[b+4>>2];c[e+8>>2]=c[b+8>>2];c[e+12>>2]=c[b+12>>2];e=d+84|0;c[e>>2]=c[b+16>>2];c[e+4>>2]=c[b+16+4>>2];c[e+8>>2]=c[b+16+8>>2];c[e+12>>2]=c[b+16+12>>2];e=d+100|0;c[e>>2]=c[b+32>>2];c[e+4>>2]=c[b+32+4>>2];c[e+8>>2]=c[b+32+8>>2];c[e+12>>2]=c[b+32+12>>2];e=d+116|0;c[e>>2]=c[b+48>>2];c[e+4>>2]=c[b+48+4>>2];c[e+8>>2]=c[b+48+8>>2];c[e+12>>2]=c[b+48+12>>2];b=d+132|0;c[b>>2]=c[a>>2];c[b+4>>2]=c[a+4>>2];c[b+8>>2]=c[a+8>>2];c[b+12>>2]=c[a+12>>2];b=d+148|0;c[b>>2]=c[a+16>>2];c[b+4>>2]=c[a+16+4>>2];c[b+8>>2]=c[a+16+8>>2];c[b+12>>2]=c[a+16+12>>2];b=d+164|0;c[b>>2]=c[a+32>>2];c[b+4>>2]=c[a+32+4>>2];c[b+8>>2]=c[a+32+8>>2];c[b+12>>2]=c[a+32+12>>2];b=d+180|0;c[b>>2]=c[a+48>>2];c[b+4>>2]=c[a+48+4>>2];c[b+8>>2]=c[a+48+8>>2];c[b+12>>2]=c[a+48+12>>2];c[d+196>>2]=0;return d|0}function jx(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+8>>2]&127](a,b);return}function kx(a){a=a|0;return a+4|0}function lx(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+12>>2]&127](a,b);return}function mx(a,b){a=a|0;b=b|0;c[a+4>>2]=c[b>>2];c[a+4+4>>2]=c[b+4>>2];c[a+4+8>>2]=c[b+8>>2];c[a+4+12>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+20+4>>2]=c[b+16+4>>2];c[a+20+8>>2]=c[b+16+8>>2];c[a+20+12>>2]=c[b+16+12>>2];c[a+36>>2]=c[b+32>>2];c[a+36+4>>2]=c[b+32+4>>2];c[a+36+8>>2]=c[b+32+8>>2];c[a+36+12>>2]=c[b+32+12>>2];c[a+52>>2]=c[b+48>>2];c[a+52+4>>2]=c[b+48+4>>2];c[a+52+8>>2]=c[b+48+8>>2];c[a+52+12>>2]=c[b+48+12>>2];return}function nx(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function ox(a){a=a|0;var b=0,d=0;while(1){b=qG(8)|0;if(b|0){d=6;break}b=c[5831]|0;c[5831]=b+0;if(!b){d=5;break}_b[b&3]()}if((d|0)==5){a=Va(4)|0;c[a>>2]=8308;hb(a|0,2416,215)}else if((d|0)==6){c[b>>2]=7988;c[b+4>>2]=a;return b|0}return 0}function px(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function qx(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+64>>2]&127](a,b);return}function rx(a,b){a=a|0;b=b|0;bc[c[(c[a>>2]|0)+36>>2]&127](a,b,2,-3);return}function sx(a,b,d){a=a|0;b=b|0;d=d|0;bc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,-3);return}function tx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,e);return}function ux(a,b){a=a|0;b=b|0;Zb[c[(c[a>>2]|0)+56>>2]&127](a,b,0);return}function vx(a,b,d){a=a|0;b=b|0;d=d|0;Zb[c[(c[a>>2]|0)+56>>2]&127](a,b,d);return}function wx(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+84>>2]&127](a,b);return}function xx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bc[c[(c[a>>2]|0)+88>>2]&127](a,b,d,e);return}function yx(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0;c[5637]=(c[5637]|0)+1;f=qG(343)|0;if(!f)i=0;else{c[(f+4+15&-16)+-4>>2]=f;i=f+4+15&-16}a[i+20>>0]=1;c[i+16>>2]=0;c[i+8>>2]=0;c[i+12>>2]=0;c[i+24>>2]=b;g[i+28>>2]=0.0;c[i+32>>2]=0;c[i+36>>2]=1;g[i+40>>2]=1.0;a[i+44>>0]=1;c[i+48>>2]=0;a[i+52>>0]=0;a[i+53>>0]=1;a[i+54>>0]=1;g[i+56>>2]=.03999999910593033;a[i+60>>0]=0;g[i+64>>2]=0.0;c[i+68>>2]=d;c[i+72>>2]=0;a[i+76>>0]=1;c[i+80>>2]=0;c[i+84>>2]=0;c[i+88>>2]=0;g[i+92>>2]=.6000000238418579;g[i+96>>2]=1.0;g[i+100>>2]=.30000001192092896;g[i+104>>2]=.01666666753590107;g[i+108>>2]=0.0;g[i+116>>2]=20.0;c[i+112>>2]=10;g[i+124>>2]=.20000000298023224;g[i+128>>2]=.800000011920929;g[i+132>>2]=0.0;g[i+120>>2]=1.0;c[i+136>>2]=1;g[i+140>>2]=-.03999999910593033;g[i+144>>2]=.10000000149011612;g[i+148>>2]=0.0;g[i+152>>2]=.8500000238418579;c[i+156>>2]=260;c[i+160>>2]=2;c[i+164>>2]=128;g[i+168>>2]=100.0;g[i+172>>2]=1000000015047466219876688.0e6;c[i>>2]=7656;a[i+192>>0]=1;c[i+188>>2]=0;c[i+180>>2]=0;c[i+184>>2]=0;d=i+196|0;c[d>>2]=0;h=i+200|0;c[h>>2]=e;a[i+224>>0]=1;c[i+220>>2]=0;c[i+212>>2]=0;c[i+216>>2]=0;a[i+244>>0]=1;c[i+240>>2]=0;c[i+232>>2]=0;c[i+236>>2]=0;c[i+248>>2]=0;c[i+252>>2]=-1054867456;f=i+256|0;a[i+274>>0]=0;a[i+275>>0]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;a[i+292>>0]=1;c[i+288>>2]=0;c[i+280>>2]=0;c[i+284>>2]=0;c[i+296>>2]=0;a[i+300>>0]=1;a[i+320>>0]=1;c[i+316>>2]=0;c[i+308>>2]=0;c[i+312>>2]=0;if(!e){c[5637]=(c[5637]|0)+1;f=qG(223)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}c[f>>2]=7540;a[f+20>>0]=1;c[f+16>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;a[f+40>>0]=1;c[f+36>>2]=0;c[f+28>>2]=0;c[f+32>>2]=0;a[f+60>>0]=1;c[f+56>>2]=0;c[f+48>>2]=0;c[f+52>>2]=0;a[f+80>>0]=1;c[f+76>>2]=0;c[f+68>>2]=0;c[f+72>>2]=0;a[f+100>>0]=1;c[f+96>>2]=0;c[f+88>>2]=0;c[f+92>>2]=0;a[f+120>>0]=1;c[f+116>>2]=0;c[f+108>>2]=0;c[f+112>>2]=0;a[f+140>>0]=1;c[f+136>>2]=0;c[f+128>>2]=0;c[f+132>>2]=0;a[f+160>>0]=1;c[f+156>>2]=0;c[f+148>>2]=0;c[f+152>>2]=0;a[f+180>>0]=1;c[f+176>>2]=0;c[f+168>>2]=0;c[f+172>>2]=0;c[f+192>>2]=13;c[f+196>>2]=14;c[f+200>>2]=0;c[h>>2]=f;a[i+273>>0]=1}else a[i+273>>0]=0;c[5637]=(c[5637]|0)+1;f=qG(87)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}c[f>>2]=4488;a[f+20>>0]=1;c[f+16>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;a[f+40>>0]=1;c[f+36>>2]=0;c[f+28>>2]=0;c[f+32>>2]=0;a[f+60>>0]=1;c[f+56>>2]=0;c[f+48>>2]=0;c[f+52>>2]=0;a[f+64>>0]=1;c[i+204>>2]=f;a[i+272>>0]=1;c[5637]=(c[5637]|0)+1;f=qG(107)|0;if(!f){e=0;f=c[h>>2]|0;c[e>>2]=7896;h=e+4|0;c[h>>2]=0;h=e+8|0;c[h>>2]=f;h=e+12|0;c[h>>2]=0;h=e+16|0;c[h>>2]=0;h=e+20|0;c[h>>2]=0;h=e+24|0;c[h>>2]=b;b=e+44|0;a[b>>0]=1;b=e+40|0;c[b>>2]=0;b=e+32|0;c[b>>2]=0;b=e+36|0;c[b>>2]=0;b=e+64|0;a[b>>0]=1;b=e+60|0;c[b>>2]=0;b=e+52|0;c[b>>2]=0;b=e+56|0;c[b>>2]=0;b=e+84|0;a[b>>0]=1;b=e+80|0;c[b>>2]=0;b=e+72|0;c[b>>2]=0;b=e+76|0;c[b>>2]=0;c[d>>2]=e;return i|0}c[(f+4+15&-16)+-4>>2]=f;e=f+4+15&-16;f=c[h>>2]|0;c[e>>2]=7896;h=e+4|0;c[h>>2]=0;h=e+8|0;c[h>>2]=f;h=e+12|0;c[h>>2]=0;h=e+16|0;c[h>>2]=0;h=e+20|0;c[h>>2]=0;h=e+24|0;c[h>>2]=b;b=e+44|0;a[b>>0]=1;b=e+40|0;c[b>>2]=0;b=e+32|0;c[b>>2]=0;b=e+36|0;c[b>>2]=0;b=e+64|0;a[b>>0]=1;b=e+60|0;c[b>>2]=0;b=e+52|0;c[b>>2]=0;b=e+56|0;c[b>>2]=0;b=e+84|0;a[b>>0]=1;b=e+80|0;c[b>>2]=0;b=e+72|0;c[b>>2]=0;b=e+76|0;c[b>>2]=0;c[d>>2]=e;return i|0}function zx(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ig(a,b,c,d);return}function Ax(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+48|0;f=c[b+192>>2]|0;bc[c[(c[f>>2]|0)+8>>2]&127](f,b+4|0,e+32|0,e+16|0);c[e>>2]=3544;c[e+4>>2]=b;c[e+8>>2]=a;c[e+12>>2]=d;a=c[a+68>>2]|0;bc[c[(c[a>>2]|0)+28>>2]&127](a,e+32|0,e+16|0,e);i=e;return}function Bx(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;Yf(a,b,c,d,e,f);return}function Cx(a){a=a|0;return c[a+68>>2]|0}function Dx(a){a=a|0;return a+28|0}function Ex(a){a=a|0;return c[a+24>>2]|0}function Fx(b){b=b|0;var d=0;d=i;i=i+16|0;if(!(a[19896]|0))a[19896]=1;tb[c[(c[b>>2]|0)+76>>2]&127](d,b);c[5650]=c[d>>2];c[5651]=c[d+4>>2];c[5652]=c[d+8>>2];c[5653]=c[d+12>>2];i=d;return 22600}function Gx(a){a=a|0;a=c[a+68>>2]|0;return vb[c[(c[a>>2]|0)+36>>2]&127](a)|0}function Hx(b){b=b|0;var d=0,e=0;if(a[19904]|0){d=b+92|0;b=22616;e=b+84|0;do{c[b>>2]=c[d>>2];b=b+4|0;d=d+4|0}while((b|0)<(e|0));return 22616}a[19904]=1;g[5654]=.6000000238418579;g[5655]=1.0;g[5656]=.30000001192092896;g[5657]=.01666666753590107;g[5658]=0.0;g[5660]=20.0;c[5659]=10;g[5662]=.20000000298023224;g[5663]=.800000011920929;g[5664]=0.0;g[5661]=1.0;c[5665]=1;g[5666]=-.03999999910593033;g[5667]=.10000000149011612;g[5668]=0.0;g[5669]=.8500000238418579;c[5670]=260;c[5671]=2;c[5672]=128;g[5673]=100.0;g[5674]=1000000015047466219876688.0e6;d=b+92|0;b=22616;e=b+84|0;do{c[b>>2]=c[d>>2];b=b+4|0;d=d+4|0}while((b|0)<(e|0));return 22616}function Ix(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bc[c[(c[a>>2]|0)+32>>2]&127](a,b,d,e);return}function Jx(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+68>>2]&127](a,b);return}function Kx(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+60>>2]&127](a,b);return}function Lx(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+92>>2]&127](a,b);return}function Mx(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+72>>2]&127](a,b);return}function Nx(a,b){a=a|0;b=+b;return ac[c[(c[a>>2]|0)+52>>2]&1](a,b,1,.01666666753590107)|0}function Ox(a,b,d){a=a|0;b=+b;d=d|0;return ac[c[(c[a>>2]|0)+52>>2]&1](a,b,d,.01666666753590107)|0}function Px(a,b,d,e){a=a|0;b=+b;d=d|0;e=+e;return ac[c[(c[a>>2]|0)+52>>2]&1](a,b,d,e)|0}function Qx(a){a=a|0;if(!a)return;rG(a);return}function Rx(a){a=a|0;return +(+g[a+28>>2])}function Sx(a){a=a|0;return +(+g[a+36>>2])}function Tx(a){a=a|0;return c[a+8>>2]|0}function Ux(b){b=b|0;return (a[b+25>>0]|0)!=0|0}function Vx(b){b=b|0;return (a[b+24>>0]|0)!=0|0}function Wx(a){a=a|0;return c[a+4>>2]|0}function Xx(a){a=a|0;return +(+g[a+12>>2])}function Yx(a){a=a|0;return +(+g[a>>2])}function Zx(b){b=b|0;return (a[b+16>>0]|0)!=0|0}function _x(b){b=b|0;return (a[b+32>>0]|0)!=0|0}function $x(b){b=b|0;return (a[b+26>>0]|0)!=0|0}function ay(a,b){a=a|0;b=+b;g[a+28>>2]=b;return}function by(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function cy(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function dy(b,c){b=b|0;c=c|0;a[b+25>>0]=c&1;return}function ey(b,c){b=b|0;c=c|0;a[b+24>>0]=c&1;return}function fy(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function gy(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function hy(a,b){a=a|0;b=+b;g[a>>2]=b;return}function iy(b,c){b=b|0;c=c|0;a[b+16>>0]=c&1;return}function jy(b,c){b=b|0;c=c|0;a[b+32>>0]=c&1;return}function ky(b,c){b=b|0;c=c|0;a[b+26>>0]=c&1;return}function ly(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function my(a,b){a=a|0;b=b|0;return Ob[c[(c[a>>2]|0)+40>>2]&31](a,b)|0}function ny(a){a=a|0;return vb[c[(c[a>>2]|0)+36>>2]&127](a)|0}function oy(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function py(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+64>>2]&127](a,b);return}function qy(a,b){a=a|0;b=b|0;bc[c[(c[a>>2]|0)+36>>2]&127](a,b,1,-1);return}function ry(a,b,d){a=a|0;b=b|0;d=d|0;bc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,-1);return}function sy(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,e);return}function ty(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ig(a,b,c,d);return}function uy(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+48|0;f=c[b+192>>2]|0;bc[c[(c[f>>2]|0)+8>>2]&127](f,b+4|0,e+32|0,e+16|0);c[e>>2]=3544;c[e+4>>2]=b;c[e+8>>2]=a;c[e+12>>2]=d;a=c[a+68>>2]|0;bc[c[(c[a>>2]|0)+28>>2]&127](a,e+32|0,e+16|0,e);i=e;return}function vy(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;Yf(a,b,c,d,e,f);return}function wy(a){a=a|0;return c[a+68>>2]|0}function xy(a){a=a|0;return a+28|0}function yy(a){a=a|0;return c[a+24>>2]|0}function zy(a){a=a|0;a=c[a+68>>2]|0;return vb[c[(c[a>>2]|0)+36>>2]&127](a)|0}function Ay(b){b=b|0;var d=0,e=0;if(a[19912]|0){d=b+92|0;b=22700;e=b+84|0;do{c[b>>2]=c[d>>2];b=b+4|0;d=d+4|0}while((b|0)<(e|0));return 22700}a[19912]=1;g[5675]=.6000000238418579;g[5676]=1.0;g[5677]=.30000001192092896;g[5678]=.01666666753590107;g[5679]=0.0;g[5681]=20.0;c[5680]=10;g[5683]=.20000000298023224;g[5684]=.800000011920929;g[5685]=0.0;g[5682]=1.0;c[5686]=1;g[5687]=-.03999999910593033;g[5688]=.10000000149011612;g[5689]=0.0;g[5690]=.8500000238418579;c[5691]=260;c[5692]=2;c[5693]=128;g[5694]=100.0;g[5695]=1000000015047466219876688.0e6;d=b+92|0;b=22700;e=b+84|0;do{c[b>>2]=c[d>>2];b=b+4|0;d=d+4|0}while((b|0)<(e|0));return 22700}function By(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bc[c[(c[a>>2]|0)+32>>2]&127](a,b,d,e);return}function Cy(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+68>>2]&127](a,b);return}function Dy(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ey(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;c[5637]=(c[5637]|0)+1;e=qG(1331)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}mp(e,a,b,d);return e|0}function Fy(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0;c[5637]=(c[5637]|0)+1;g=qG(1331)|0;if(!g)g=0;else{c[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}lp(g,a,b,d,e,f);return g|0}function Gy(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function Hy(a){a=a|0;return +(+g[a+16>>2])}function Iy(a,b){a=a|0;b=b|0;var c=0.0;c=+oG(+g[b>>2]);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+868>>2]=c;c=+oG(+g[b+4>>2]);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+932>>2]=c;c=+oG(+g[b+8>>2]);if(c<-3.1415927410125732){c=c+6.2831854820251465;a=a+996|0;g[a>>2]=c;return}if(!(c>3.1415927410125732)){a=a+996|0;g[a>>2]=c;return}c=c+-6.2831854820251465;a=a+996|0;g[a>>2]=c;return}function Jy(a,b){a=a|0;b=b|0;var c=0.0;c=+oG(+g[b>>2]);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+872>>2]=c;c=+oG(+g[b+4>>2]);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+936>>2]=c;c=+oG(+g[b+8>>2]);if(c<-3.1415927410125732){c=c+6.2831854820251465;a=a+1e3|0;g[a>>2]=c;return}if(!(c>3.1415927410125732)){a=a+1e3|0;g[a>>2]=c;return}c=c+-6.2831854820251465;a=a+1e3|0;g[a>>2]=c;return}function Ky(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function Ly(a,b){a=a|0;b=b|0;c[a+680>>2]=c[b>>2];c[a+680+4>>2]=c[b+4>>2];c[a+680+8>>2]=c[b+8>>2];c[a+680+12>>2]=c[b+12>>2];return}function My(a,b){a=a|0;b=b|0;c[a+696>>2]=c[b>>2];c[a+696+4>>2]=c[b+4>>2];c[a+696+8>>2]=c[b+8>>2];c[a+696+12>>2]=c[b+12>>2];return}function Ny(a){a=a|0;if(!a)return;rb[c[(c[a>>2]|0)+4>>2]&255](a);return}
function nq(b,d,e,f,h,j,l,m,n){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0.0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0;Y=i;i=i+304|0;c[b+188>>2]=-1;fs(15532);c[b+184>>2]=0;if((e|0)>0){n=0;do{c[(c[d+(n<<2)>>2]|0)+212>>2]=-1;n=n+1|0}while((n|0)!=(e|0))}o=c[b+12>>2]|0;if((o|0)>(e|0))p=b+8|0;else{if((e+1|0)!=0?(c[5637]=(c[5637]|0)+1,p=qG(((e+1|0)*244|3)+16|0)|0,(p|0)!=0):0){c[(p+4+15&-16)+-4>>2]=p;p=p+4+15&-16}else p=0;n=c[b+8>>2]|0;if((n|0)>0){o=0;do{V=p+(o*244|0)|0;W=c[b+16>>2]|0;U=W+(o*244|0)|0;c[V>>2]=c[U>>2];c[V+4>>2]=c[U+4>>2];c[V+8>>2]=c[U+8>>2];c[V+12>>2]=c[U+12>>2];V=p+(o*244|0)+16|0;U=W+(o*244|0)+16|0;c[V>>2]=c[U>>2];c[V+4>>2]=c[U+4>>2];c[V+8>>2]=c[U+8>>2];c[V+12>>2]=c[U+12>>2];V=p+(o*244|0)+32|0;U=W+(o*244|0)+32|0;c[V>>2]=c[U>>2];c[V+4>>2]=c[U+4>>2];c[V+8>>2]=c[U+8>>2];c[V+12>>2]=c[U+12>>2];V=p+(o*244|0)+48|0;U=W+(o*244|0)+48|0;c[V>>2]=c[U>>2];c[V+4>>2]=c[U+4>>2];c[V+8>>2]=c[U+8>>2];c[V+12>>2]=c[U+12>>2];bH(p+(o*244|0)+64|0,W+(o*244|0)+64|0,180)|0;o=o+1|0}while((o|0)!=(n|0))}n=c[b+16>>2]|0;if(n|0){if(a[b+20>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[n+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=p;c[b+12>>2]=e+1;p=b+8|0;o=e+1|0}ZG(Y|0,0,244)|0;n=c[p>>2]|0;if((n|0)<0){if((o|0)<0){o=c[b+16>>2]|0;if(o|0){if(a[b+20>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[o+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+12>>2]=0}do{W=c[b+16>>2]|0;V=W+(n*244|0)|0;c[V>>2]=c[Y>>2];c[V+4>>2]=c[Y+4>>2];c[V+8>>2]=c[Y+8>>2];c[V+12>>2]=c[Y+12>>2];V=W+(n*244|0)+16|0;c[V>>2]=c[Y+16>>2];c[V+4>>2]=c[Y+16+4>>2];c[V+8>>2]=c[Y+16+8>>2];c[V+12>>2]=c[Y+16+12>>2];V=W+(n*244|0)+32|0;c[V>>2]=c[Y+32>>2];c[V+4>>2]=c[Y+32+4>>2];c[V+8>>2]=c[Y+32+8>>2];c[V+12>>2]=c[Y+32+12>>2];V=W+(n*244|0)+48|0;c[V>>2]=c[Y+48>>2];c[V+4>>2]=c[Y+48+4>>2];c[V+8>>2]=c[Y+48+8>>2];c[V+12>>2]=c[Y+48+12>>2];bH(W+(n*244|0)+64|0,Y+64|0,180)|0;n=n+1|0}while((n|0)!=0)}c[p>>2]=0;if((e|0)>0){s=0;do{p=d+(s<<2)|0;o=cq(b,c[p>>2]|0,+g[m+12>>2])|0;p=c[p>>2]|0;if(!((p|0)==0?1:(c[p+236>>2]&2|0)==0)?+g[p+368>>2]!=0.0:0){q=c[b+16>>2]|0;n=c[p+528>>2]|0;if(n&2){r=+g[m+76>>2];_=+g[p+420>>2];u=+g[p+424>>2];t=+g[p+428>>2];ea=+g[p+4>>2];_=_!=0.0?1.0/_:0.0;da=+g[p+8>>2];u=u!=0.0?1.0/u:0.0;ca=+g[p+12>>2];t=t!=0.0?1.0/t:0.0;ba=+g[p+20>>2];aa=+g[p+24>>2];$=+g[p+28>>2];Z=+g[p+36>>2];B=+g[p+40>>2];w=+g[p+44>>2];x=+g[p+352>>2];y=+g[p+356>>2];v=+g[p+360>>2];z=(_*ea*ea+u*da*da+t*ca*ca)*x+(_*ea*ba+u*da*aa+t*ca*$)*y+(_*ea*Z+u*da*B+t*ca*w)*v;A=(_*ba*ea+u*aa*da+t*$*ca)*x+(_*ba*ba+u*aa*aa+t*$*$)*y+(_*ba*Z+u*aa*B+t*$*w)*v;w=(_*Z*ea+u*B*da+t*w*ca)*x+(_*Z*ba+u*B*aa+t*w*$)*y+(_*Z*Z+u*B*B+t*w*w)*v;t=(y*w-v*A)*(y*w-v*A)+(v*z-x*w)*(v*z-x*w)+(x*A-y*z)*(x*A-y*z);if(t>r*r){r=1.0/+O(+t)*r;u=(y*w-v*A)*r;t=r*(v*z-x*w);r=r*(x*A-y*z)}else{u=y*w-v*A;t=v*z-x*w;r=x*A-y*z}ca=+g[m+12>>2];da=(u*+g[p+292>>2]+t*+g[p+308>>2]+r*+g[p+324>>2])*ca;ea=ca*(u*+g[p+296>>2]+t*+g[p+312>>2]+r*+g[p+328>>2]);g[q+(o*244|0)+224>>2]=+g[q+(o*244|0)+224>>2]-(u*+g[p+288>>2]+t*+g[p+304>>2]+r*+g[p+320>>2])*ca;g[q+(o*244|0)+228>>2]=+g[q+(o*244|0)+228>>2]-da;g[q+(o*244|0)+232>>2]=+g[q+(o*244|0)+232>>2]-ea;n=c[p+528>>2]|0}if(n&4){B=+g[m+12>>2];ia=+g[p+420>>2];ca=+g[p+424>>2];aa=+g[p+428>>2];y=+g[p+352>>2];t=+g[p+356>>2];ea=+g[p+360>>2];$=+g[p+4>>2];ia=ia!=0.0?1.0/ia:0.0;r=+g[p+8>>2];ca=ca!=0.0?1.0/ca:0.0;u=+g[p+12>>2];aa=aa!=0.0?1.0/aa:0.0;ja=+g[p+20>>2];_=+g[p+24>>2];x=+g[p+28>>2];ba=+g[p+36>>2];Z=+g[p+40>>2];ha=+g[p+44>>2];v=ia*$*$+ca*r*r+aa*u*u;A=ia*$*ja+ca*r*_+aa*u*x;ga=ia*$*ba+ca*r*Z+aa*u*ha;w=ia*ja*$+ca*_*r+aa*x*u;z=ia*ja*ja+ca*_*_+aa*x*x;fa=ia*ja*ba+ca*_*Z+aa*x*ha;u=ia*ba*$+ca*Z*r+aa*ha*u;x=ia*ba*ja+ca*Z*_+aa*ha*x;ha=ia*ba*ba+ca*Z*Z+aa*ha*ha;aa=y*v+t*A+ea*ga+(t*(y*u+t*x+ea*ha)-ea*(y*w+t*z+ea*fa))*B-(B*0.0+(y*v+t*A+ea*ga));Z=y*w+t*z+ea*fa+(ea*(y*v+t*A+ea*ga)-y*(y*u+t*x+ea*ha))*B-(B*0.0+(y*w+t*z+ea*fa));ca=y*u+t*x+ea*ha+(y*(y*w+t*z+ea*fa)-t*(y*v+t*A+ea*ga))*B-(B*0.0+(y*u+t*x+ea*ha));ba=A+(y*u+t*x+ea*ha+(t*x+(A*0.0+z*-ea)))*B;ia=ga+(t*ha+(ga*0.0+fa*-ea)-(y*w+t*z+ea*fa))*B;_=w+(u*-y+(w*0.0+ea*v)-(y*u+t*x+ea*ha))*B;ja=fa+(y*v+t*A+ea*ga+(ha*-y+(fa*0.0+ea*ga)))*B;r=u+(u*0.0+(v*-t+y*w)+(y*w+t*z+ea*fa))*B;$=x+(x*0.0+(A*-t+y*z)-(y*v+t*A+ea*ga))*B;la=(z+(x*-y+(z*0.0+ea*A))*B)*(ha+(ha*0.0+(ga*-t+y*fa))*B)-$*ja;ka=$*ia-ba*(ha+(ha*0.0+(ga*-t+y*fa))*B);ma=ba*ja-(z+(x*-y+(z*0.0+ea*A))*B)*ia;da=r*ma+((v+(t*u+(v*0.0+w*-ea))*B)*la+_*ka);n=+N(+da)>1.1920928955078125e-07;da=n?1.0/da:da;g[q+(o*244|0)+224>>2]=y-(ca*ma+(aa*la+Z*ka))*da-y+ +g[q+(o*244|0)+224>>2];g[q+(o*244|0)+228>>2]=t-(r*(ja*aa-ia*Z)+((v+(t*u+(v*0.0+w*-ea))*B)*((ha+(ha*0.0+(ga*-t+y*fa))*B)*Z-ja*ca)+_*(ia*ca-(ha+(ha*0.0+(ga*-t+y*fa))*B)*aa)))*da-t+ +g[q+(o*244|0)+228>>2];g[q+(o*244|0)+232>>2]=ea-(r*(ba*Z-(z+(x*-y+(z*0.0+ea*A))*B)*aa)+((v+(t*u+(v*0.0+w*-ea))*B)*((z+(x*-y+(z*0.0+ea*A))*B)*ca-$*Z)+_*($*aa-ba*ca)))*da-ea+ +g[q+(o*244|0)+232>>2];n=c[p+528>>2]|0}if(n&8|0){ia=+g[m+12>>2];A=+g[p+420>>2];B=+g[p+424>>2];x=+g[p+428>>2];da=+g[p+352>>2];ea=+g[p+356>>2];ma=+g[p+360>>2];_f(p+4|0,Y+248|0);la=+g[Y+248>>2];fa=+g[Y+248+4>>2];ga=+g[Y+248+8>>2];Z=+g[Y+248+12>>2];$=ga*(da*-ga+ea*Z-ma*-la)+(la*(-(da*-la)-ea*-fa-ma*-ga)+Z*(ma*-fa+da*Z-ea*-ga))-fa*(ea*-la+ma*Z-da*-fa);ba=la*(ea*-la+ma*Z-da*-fa)+(fa*(-(da*-la)-ea*-fa-ma*-ga)+Z*(da*-ga+ea*Z-ma*-la))-ga*(ma*-fa+da*Z-ea*-ga);Z=fa*(ma*-fa+da*Z-ea*-ga)+(ga*(-(da*-la)-ea*-fa-ma*-ga)+Z*(ea*-la+ma*Z-da*-fa))-la*(da*-ga+ea*Z-ma*-la);A=A!=0.0?1.0/A:0.0;ca=Z*0.0+(A*$+ba*0.0);B=B!=0.0?1.0/B:0.0;aa=Z*0.0+($*0.0+B*ba);x=x!=0.0?1.0/x:0.0;_=x*Z+($*0.0+ba*0.0);y=A+(ba*0.0+(A*0.0+Z*-0.0))*ia;z=B+($*-0.0+(B*0.0+Z*0.0))*ia;ja=x+(x*0.0+(ba*-0.0+$*0.0))*ia;w=z*ja-((ba*-0.0+B*$+0.0-ca)*ia+0.0)*((Z*0.0+0.0-x*$+ca)*ia+0.0);ha=((ba*-0.0+B*$+0.0-ca)*ia+0.0)*((x*ba+(Z*-0.0+0.0)-aa)*ia+0.0)-ja*((ba*0.0+(0.0-B*Z)+_)*ia+0.0);v=((ba*0.0+(0.0-B*Z)+_)*ia+0.0)*((Z*0.0+0.0-x*$+ca)*ia+0.0)-z*((x*ba+(Z*-0.0+0.0)-aa)*ia+0.0);ka=(($*0.0-A*ba+0.0+aa)*ia+0.0)*v+(y*w+(($*-0.0+(A*Z+0.0)-_)*ia+0.0)*ha);W=+N(+ka)>1.1920928955078125e-07;ka=W?1.0/ka:ka;ha=$-(($*aa-ba*ca)*ia*v+((ba*_-Z*aa)*ia*w+(Z*ca-$*_)*ia*ha))*ka;ja=ba-((($*0.0-A*ba+0.0+aa)*ia+0.0)*(((Z*0.0+0.0-x*$+ca)*ia+0.0)*((ba*_-Z*aa)*ia)-((x*ba+(Z*-0.0+0.0)-aa)*ia+0.0)*((Z*ca-$*_)*ia))+(y*(ja*((Z*ca-$*_)*ia)-((Z*0.0+0.0-x*$+ca)*ia+0.0)*(($*aa-ba*ca)*ia))+(($*-0.0+(A*Z+0.0)-_)*ia+0.0)*(((x*ba+(Z*-0.0+0.0)-aa)*ia+0.0)*(($*aa-ba*ca)*ia)-ja*((ba*_-Z*aa)*ia))))*ka;ka=Z-((($*0.0-A*ba+0.0+aa)*ia+0.0)*(((ba*0.0+(0.0-B*Z)+_)*ia+0.0)*((Z*ca-$*_)*ia)-z*((ba*_-Z*aa)*ia))+(y*(z*(($*aa-ba*ca)*ia)-((ba*-0.0+B*$+0.0-ca)*ia+0.0)*((Z*ca-$*_)*ia))+(($*-0.0+(A*Z+0.0)-_)*ia+0.0)*(((ba*-0.0+B*$+0.0-ca)*ia+0.0)*((ba*_-Z*aa)*ia)-((ba*0.0+(0.0-B*Z)+_)*ia+0.0)*(($*aa-ba*ca)*ia))))*ka;ia=+g[Y+248+12>>2];g[q+(o*244|0)+224>>2]=(ga*ha+ia*ja-la*ka)*-ga+(ia*(ia*ha+fa*ka-ga*ja)+(-(la*ha)-fa*ja-ga*ka)*-la)-(ia*ka+la*ja-fa*ha)*-fa-da+ +g[q+(o*244|0)+224>>2];g[q+(o*244|0)+228>>2]=(ia*ka+la*ja-fa*ha)*-la+(ia*(ga*ha+ia*ja-la*ka)+(-(la*ha)-fa*ja-ga*ka)*-fa)-(ia*ha+fa*ka-ga*ja)*-ga-ea+ +g[q+(o*244|0)+228>>2];g[q+(o*244|0)+232>>2]=(ia*ha+fa*ka-ga*ja)*-fa+((-(la*ha)-fa*ja-ga*ka)*-ga+ia*(ia*ka+la*ja-fa*ha))-(ga*ha+ia*ja-la*ka)*-la-ma+ +g[q+(o*244|0)+232>>2]}}s=s+1|0}while((s|0)!=(e|0))}if((l|0)>0){n=0;do{W=c[j+(n<<2)>>2]|0;rb[c[(c[W>>2]|0)+8>>2]&255](W);g[W+36>>2]=0.0;n=n+1|0}while((n|0)<(l|0))}o=c[b+168>>2]|0;if((o|0)<(l|0)?(c[b+172>>2]|0)<(l|0):0){if(!l)n=0;else{c[5637]=(c[5637]|0)+1;n=qG((l<<3|3)+16|0)|0;if(!n)n=0;else{c[(n+4+15&-16)+-4>>2]=n;n=n+4+15&-16}o=c[b+168>>2]|0}if((o|0)>0){p=0;do{U=(c[b+176>>2]|0)+(p<<3)|0;V=c[U+4>>2]|0;W=n+(p<<3)|0;c[W>>2]=c[U>>2];c[W+4>>2]=V;p=p+1|0}while((p|0)!=(o|0))}o=c[b+176>>2]|0;if(o|0){if(a[b+180>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[o+-4>>2]|0)}c[b+176>>2]=0}a[b+180>>0]=1;c[b+176>>2]=n;c[b+172>>2]=l}c[b+168>>2]=l;if((l|0)>0){e=0;n=0;do{s=c[b+176>>2]|0;d=s+(e<<3)|0;q=j+(e<<2)|0;o=c[q>>2]|0;p=c[o+44>>2]|0;if(p){o=p+64|0;do{c[p>>2]=0;p=p+4|0}while((p|0)<(o|0));o=c[q>>2]|0}if(!(a[o+20>>0]|0)){c[d>>2]=0;c[s+(e<<3)+4>>2]=0;o=0}else{tb[c[(c[o>>2]|0)+16>>2]&127](o,d);o=c[d>>2]|0}n=o+n|0;e=e+1|0}while((e|0)<(l|0))}else n=0;p=c[b+48>>2]|0;if((p|0)<(n|0)?(c[b+52>>2]|0)<(n|0):0){if(!n)o=0;else{c[5637]=(c[5637]|0)+1;o=qG((n*152|3)+16|0)|0;if(!o)o=0;else{c[(o+4+15&-16)+-4>>2]=o;o=o+4+15&-16}p=c[b+48>>2]|0}if((p|0)>0){q=0;do{bH(o+(q*152|0)|0,(c[b+56>>2]|0)+(q*152|0)|0,152)|0;q=q+1|0}while((q|0)!=(p|0))}p=c[b+56>>2]|0;if(p|0){if(a[b+60>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[p+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=o;c[b+52>>2]=n}c[b+48>>2]=n;if((l|0)>0){n=c[b+176>>2]|0;V=0;W=0;while(1){U=n+(W<<3)|0;if(!(c[U>>2]|0))o=0;else{n=c[b+56>>2]|0;K=n+(V*152|0)|0;L=j+(W<<2)|0;M=c[L>>2]|0;P=c[M+28>>2]|0;Q=c[M+32>>2]|0;R=cq(b,P,+g[m+12>>2])|0;S=cq(b,Q,+g[m+12>>2])|0;T=c[b+16>>2]|0;o=c[M+24>>2]|0;o=(o|0)>0?o:c[m+20>>2]|0;if((o|0)>(c[b+184>>2]|0))c[b+184>>2]=o;if((c[U>>2]|0)>0){p=0;do{ZG(K+(p*152|0)|0,0,152)|0;g[K+(p*152|0)+120>>2]=-3402823466385288598117041.0e14;g[K+(p*152|0)+124>>2]=3402823466385288598117041.0e14;g[K+(p*152|0)+100>>2]=0.0;g[K+(p*152|0)+96>>2]=0.0;c[K+(p*152|0)+144>>2]=R;c[K+(p*152|0)+148>>2]=S;c[K+(p*152|0)+136>>2]=o;p=p+1|0}while((p|0)<(c[U>>2]|0))}c[T+(R*244|0)+64>>2]=0;c[T+(R*244|0)+64+4>>2]=0;c[T+(R*244|0)+64+8>>2]=0;c[T+(R*244|0)+64+12>>2]=0;c[T+(R*244|0)+64+16>>2]=0;c[T+(R*244|0)+64+20>>2]=0;c[T+(R*244|0)+64+24>>2]=0;c[T+(R*244|0)+64+28>>2]=0;c[T+(R*244|0)+144>>2]=0;c[T+(R*244|0)+144+4>>2]=0;c[T+(R*244|0)+144+8>>2]=0;c[T+(R*244|0)+144+12>>2]=0;c[T+(R*244|0)+144+16>>2]=0;c[T+(R*244|0)+144+20>>2]=0;c[T+(R*244|0)+144+24>>2]=0;c[T+(R*244|0)+144+28>>2]=0;c[T+(S*244|0)+64>>2]=0;c[T+(S*244|0)+64+4>>2]=0;c[T+(S*244|0)+64+8>>2]=0;c[T+(S*244|0)+64+12>>2]=0;c[T+(S*244|0)+64+16>>2]=0;c[T+(S*244|0)+64+20>>2]=0;c[T+(S*244|0)+64+24>>2]=0;c[T+(S*244|0)+64+28>>2]=0;c[T+(S*244|0)+144>>2]=0;c[T+(S*244|0)+144+4>>2]=0;c[T+(S*244|0)+144+8>>2]=0;c[T+(S*244|0)+144+12>>2]=0;c[T+(S*244|0)+144+16>>2]=0;c[T+(S*244|0)+144+20>>2]=0;c[T+(S*244|0)+144+24>>2]=0;c[T+(S*244|0)+144+28>>2]=0;g[Y+248>>2]=1.0/+g[m+12>>2];c[Y+248+4>>2]=c[m+32>>2];c[Y+248+8>>2]=n+(V*152|0)+16;c[Y+248+12>>2]=K;c[Y+248+16>>2]=n+(V*152|0)+48;c[Y+248+20>>2]=n+(V*152|0)+32;c[Y+248+24>>2]=38;c[Y+248+28>>2]=n+(V*152|0)+112;J=n+(V*152|0)+116|0;c[J>>2]=c[m+40>>2];c[Y+248+52>>2]=c[m+4>>2];c[Y+248+32>>2]=J;c[Y+248+36>>2]=n+(V*152|0)+120;c[Y+248+40>>2]=n+(V*152|0)+124;c[Y+248+48>>2]=c[m+20>>2];J=c[L>>2]|0;tb[c[(c[J>>2]|0)+20>>2]&127](J,Y+248|0);if((c[U>>2]|0)>0){J=0;do{n=K+(J*152|0)+124|0;r=+g[(c[L>>2]|0)+16>>2];if(+g[n>>2]>=r)g[n>>2]=r;n=K+(J*152|0)+120|0;if(+g[n>>2]<=-r)g[n>>2]=-r;c[K+(J*152|0)+132>>2]=M;I=K+(J*152|0)|0;n=K+(J*152|0)+64|0;o=c[M+28>>2]|0;la=+g[I>>2];ja=+g[I+4>>2];B=+g[I+8>>2];ka=(la*+g[o+304>>2]+ja*+g[o+308>>2]+B*+g[o+312>>2])*+g[o+572>>2];r=(la*+g[o+320>>2]+ja*+g[o+324>>2]+B*+g[o+328>>2])*+g[o+576>>2];g[n>>2]=(+g[o+288>>2]*la+ +g[o+292>>2]*ja+ +g[o+296>>2]*B)*+g[o+568>>2];g[n+4>>2]=ka;g[n+8>>2]=r;g[n+12>>2]=0.0;n=K+(J*152|0)+32|0;o=K+(J*152|0)+80|0;H=c[M+32>>2]|0;r=+g[n>>2];ka=+g[n+4>>2];B=+g[n+8>>2];ja=(r*+g[H+304>>2]+ka*+g[H+308>>2]+B*+g[H+312>>2])*+g[H+572>>2];la=(r*+g[H+320>>2]+ka*+g[H+324>>2]+B*+g[H+328>>2])*+g[H+576>>2];g[o>>2]=(+g[H+288>>2]*r+ +g[H+292>>2]*ka+ +g[H+296>>2]*B)*+g[H+568>>2];g[o+4>>2]=ja;g[o+8>>2]=la;g[o+12>>2]=0.0;o=K+(J*152|0)+16|0;la=+g[P+368>>2];ja=+g[o>>2];ka=+g[o+4>>2];r=+g[o+8>>2];t=+g[I>>2];u=+g[I+4>>2];v=+g[I+8>>2];I=K+(J*152|0)+48|0;ma=+g[Q+368>>2];w=+g[I>>2];x=+g[I+4>>2];y=+g[I+8>>2];z=+g[n>>2];A=+g[n+4>>2];B=ja*(la*ja)+ka*(la*ka)+r*(la*r)+(t*(+g[P+288>>2]*t+ +g[P+292>>2]*u+ +g[P+296>>2]*v)+u*(t*+g[P+304>>2]+u*+g[P+308>>2]+v*+g[P+312>>2])+v*(t*+g[P+320>>2]+u*+g[P+324>>2]+v*+g[P+328>>2]))+(w*(ma*w)+x*(ma*x)+y*(ma*y))+(z*(+g[Q+288>>2]*z+ +g[Q+292>>2]*A+ +g[Q+296>>2]*B)+A*(z*+g[Q+304>>2]+A*+g[Q+308>>2]+B*+g[Q+312>>2])+B*(z*+g[Q+320>>2]+A*+g[Q+324>>2]+B*+g[Q+328>>2]));I=+N(+B)>1.1920928955078125e-07;B=I?1.0/B:0.0;g[K+(J*152|0)+108>>2]=B;if(!(c[T+(R*244|0)+240>>2]|0)){p=0;q=0;s=0;D=0;E=0;F=0}else{p=c[T+(R*244|0)+208>>2]|0;q=c[T+(R*244|0)+212>>2]|0;s=c[T+(R*244|0)+216>>2]|0;D=c[T+(R*244|0)+224>>2]|0;E=c[T+(R*244|0)+228>>2]|0;F=c[T+(R*244|0)+232>>2]|0}if(!(c[T+(S*244|0)+240>>2]|0)){d=0;e=0;C=0;G=0;H=0;I=0}else{d=c[T+(S*244|0)+208>>2]|0;e=c[T+(S*244|0)+212>>2]|0;C=c[T+(S*244|0)+216>>2]|0;G=c[T+(S*244|0)+224>>2]|0;H=c[T+(S*244|0)+228>>2]|0;I=c[T+(S*244|0)+232>>2]|0}la=(c[k>>2]=p,+g[k>>2])+ +g[P+336>>2];ka=(c[k>>2]=q,+g[k>>2])+ +g[P+340>>2];ka=la*+g[o>>2]+ka*+g[o+4>>2]+((c[k>>2]=s,+g[k>>2])+ +g[P+344>>2])*r;la=(c[k>>2]=D,+g[k>>2])+ +g[P+352>>2];ja=(c[k>>2]=E,+g[k>>2])+ +g[P+356>>2];ja=ka+(la*t+ja*u+((c[k>>2]=F,+g[k>>2])+ +g[P+360>>2])*v);la=(c[k>>2]=d,+g[k>>2])+ +g[Q+336>>2];ka=(c[k>>2]=e,+g[k>>2])+ +g[Q+340>>2];ka=la*w+ka*x+((c[k>>2]=C,+g[k>>2])+ +g[Q+344>>2])*y;la=(c[k>>2]=G,+g[k>>2])+ +g[Q+352>>2];ma=(c[k>>2]=H,+g[k>>2])+ +g[Q+356>>2];H=K+(J*152|0)+112|0;g[H>>2]=+g[H>>2]*B+B*(0.0-+g[Y+248+52>>2]*(ja+(ka+(la*z+ma*A+((c[k>>2]=I,+g[k>>2])+ +g[Q+360>>2])*+g[n+8>>2]))));g[K+(J*152|0)+100>>2]=0.0;J=J+1|0}while((J|0)<(c[U>>2]|0))}n=c[b+176>>2]|0;o=c[n+(W<<3)>>2]|0}W=W+1|0;if((W|0)>=(l|0))break;else V=o+V|0}}bc[c[(c[b>>2]|0)+28>>2]&127](b,f,h,m);s=c[b+48>>2]|0;d=c[b+28>>2]|0;e=c[b+68>>2]|0;o=c[b+128>>2]|0;if((o|0)<(s|0)?(c[b+132>>2]|0)<(s|0):0){if(!s)n=0;else{c[5637]=(c[5637]|0)+1;n=qG((s<<2|3)+16|0)|0;if(!n)n=0;else{c[(n+4+15&-16)+-4>>2]=n;n=n+4+15&-16}o=c[b+128>>2]|0}q=c[b+136>>2]|0;if((o|0)<=0)if(!q)o=b+140|0;else X=103;else{p=0;do{c[n+(p<<2)>>2]=c[q+(p<<2)>>2];p=p+1|0}while((p|0)!=(o|0));X=103}if((X|0)==103){if(a[b+140>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[q+-4>>2]|0)}c[b+136>>2]=0;o=b+140|0}a[o>>0]=1;c[b+136>>2]=n;c[b+132>>2]=s}c[b+128>>2]=s;if(!(c[m+64>>2]&16)){o=c[b+108>>2]|0;if((o|0)<(d|0)?(c[b+112>>2]|0)<(d|0):0){if(!d)n=0;else{c[5637]=(c[5637]|0)+1;n=qG((d<<2|3)+16|0)|0;if(!n)n=0;else{c[(n+4+15&-16)+-4>>2]=n;n=n+4+15&-16}o=c[b+108>>2]|0}q=c[b+116>>2]|0;if((o|0)<=0)if(!q)o=b+120|0;else X=133;else{p=0;do{c[n+(p<<2)>>2]=c[q+(p<<2)>>2];p=p+1|0}while((p|0)!=(o|0));X=133}if((X|0)==133){if(a[b+120>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[q+-4>>2]|0)}c[b+116>>2]=0;o=b+120|0}a[o>>0]=1;c[b+116>>2]=n;c[b+112>>2]=d}c[b+108>>2]=d}else{o=c[b+108>>2]|0;if((o|0)<(d<<1|0)?(c[b+112>>2]|0)<(d<<1|0):0){if(!d)n=0;else{c[5637]=(c[5637]|0)+1;n=qG((d<<3|3)+16|0)|0;if(!n)n=0;else{c[(n+4+15&-16)+-4>>2]=n;n=n+4+15&-16}o=c[b+108>>2]|0}q=c[b+116>>2]|0;if((o|0)<=0)if(!q)o=b+120|0;else X=118;else{p=0;do{c[n+(p<<2)>>2]=c[q+(p<<2)>>2];p=p+1|0}while((p|0)!=(o|0));X=118}if((X|0)==118){if(a[b+120>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[q+-4>>2]|0)}c[b+116>>2]=0;o=b+120|0}a[o>>0]=1;c[b+116>>2]=n;c[b+112>>2]=d<<1}c[b+108>>2]=d<<1}o=c[b+148>>2]|0;if((o|0)<(e|0)?(c[b+152>>2]|0)<(e|0):0){if(!e)n=0;else{c[5637]=(c[5637]|0)+1;n=qG((e<<2|3)+16|0)|0;if(!n)n=0;else{c[(n+4+15&-16)+-4>>2]=n;n=n+4+15&-16}o=c[b+148>>2]|0}q=c[b+156>>2]|0;if((o|0)<=0)if(!q)o=b+160|0;else X=148;else{p=0;do{c[n+(p<<2)>>2]=c[q+(p<<2)>>2];p=p+1|0}while((p|0)!=(o|0));X=148}if((X|0)==148){if(a[b+160>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[q+-4>>2]|0)}c[b+156>>2]=0;o=b+160|0}a[o>>0]=1;c[b+156>>2]=n;c[b+152>>2]=e}c[b+148>>2]=e;if((s|0)>0){n=c[b+136>>2]|0;o=0;do{c[n+(o<<2)>>2]=o;o=o+1|0}while((o|0)!=(s|0))}if((d|0)>0){n=c[b+116>>2]|0;o=0;do{c[n+(o<<2)>>2]=o;o=o+1|0}while((o|0)!=(d|0))}if((e|0)>0){n=c[b+156>>2]|0;o=0;do{c[n+(o<<2)>>2]=o;o=o+1|0}while((o|0)!=(e|0))}n=c[2006]|0;b=(c[n+16>>2]|0)+-1|0;c[n+16>>2]=b;if(b|0){i=Y;return 0.0}do if(c[n+4>>2]|0){kb(Y+248|0,0)|0;b=c[5649]|0;g[n+8>>2]=+g[n+8>>2]+ +(((c[Y+248+4>>2]|0)-(c[b+4>>2]|0)+(((c[Y+248>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[n+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[n+16>>2]|0)){n=c[2006]|0;break}else{i=Y;return 0.0}}while(0);c[2006]=c[n+20>>2];i=Y;return 0.0}function oq(a,b,d,e,f,h,j,k,l){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0;o=i;i=i+16|0;fs(15561);Mb[c[(c[a>>2]|0)+32>>2]&1](a,b,d,e,f,h,j,k,l);n=c[a+184>>2]|0;m=c[k+20>>2]|0;m=(n|0)>(m|0)?n:m;if((m|0)>0){n=0;do{+Qb[c[(c[a>>2]|0)+40>>2]&3](a,n,b,d,e,f,h,j,k,l);n=n+1|0}while((n|0)<(m|0))}m=c[2006]|0;a=(c[m+16>>2]|0)+-1|0;c[m+16>>2]=a;if(a|0){i=o;return 0.0}do if(c[m+4>>2]|0){kb(o|0,0)|0;a=c[5649]|0;g[m+8>>2]=+g[m+8>>2]+ +(((c[o+4>>2]|0)-(c[a+4>>2]|0)+(((c[o>>2]|0)-(c[a>>2]|0)|0)*1e6|0)-(c[m+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[m+16>>2]|0)){m=c[2006]|0;break}else{i=o;return 0.0}}while(0);c[2006]=c[m+20>>2];i=o;return 0.0}function pq(a){a=a|0;c[a>>2]=7188;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function qq(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0,l=0.0,m=0.0;if(a[b+48>>0]|0){c[d>>2]=0;c[d+4>>2]=0;return}c[d>>2]=4;c[d+4>>2]=2;rq(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);g[b+1088>>2]=0.0;a[b+297>>0]=0;f=+g[b+192>>2];h=+g[b+196>>2];do if(f<=h){m=+g[b+892>>2];l=+g[b+908>>2];i=+g[b+924>>2];i=+ap(+W(+(+g[b+832>>2]*m+ +g[b+848>>2]*l+ +g[b+864>>2]*i),+(+g[b+828>>2]*m+ +g[b+844>>2]*l+ +g[b+860>>2]*i)),f,h);g[b+1084>>2]=i;if(i<f){g[b+1088>>2]=i-f;a[b+297>>0]=1;j=1;break}if(i>h){g[b+1088>>2]=i-h;a[b+297>>0]=1;j=1}else j=0}else j=0;while(0);a[b+296>>0]=0;e=c[b+1032>>2]|0;c[b+1080>>2]=e;f=+g[b+184>>2];h=+g[b+188>>2];i=(c[k>>2]=e,+g[k>>2]);do if(f<=h){if(i>h){g[b+1032>>2]=i-h;a[b+296>>0]=1;e=14;break}if(i<f){g[b+1032>>2]=i-f;a[b+296>>0]=1;e=14}else e=13}else e=13;while(0);if((e|0)==13?(g[b+1032>>2]=0.0,a[b+1096>>0]|0):0)e=14;if((e|0)==14){c[d>>2]=(c[d>>2]|0)+1;c[d+4>>2]=(c[d+4>>2]|0)+-1}if(j<<24>>24==0?(a[b+1112>>0]|0)==0:0)return;c[d>>2]=(c[d>>2]|0)+1;c[d+4>>2]=(c[d+4>>2]|0)+-1;return}function rq(b,d,e){b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0;if((a[b+180>>0]|0)==0?(a[b+48>>0]|0)!=0:0){w=+g[b+116>>2];i=+g[e>>2];x=+g[b+132>>2];C=+g[e+4>>2];y=+g[b+148>>2];D=+g[e+8>>2];l=+g[b+120>>2];n=+g[b+136>>2];p=+g[b+152>>2];q=+g[b+124>>2];s=+g[b+140>>2];t=+g[b+156>>2];j=+g[e+16>>2];m=+g[e+20>>2];o=+g[e+24>>2];r=+g[e+32>>2];z=+g[e+36>>2];A=+g[e+40>>2];h=+g[b+164>>2];f=+g[b+168>>2];v=+g[b+172>>2];u=+g[e+48>>2]+(i*h+C*f+D*v);B=j*h+m*f+o*v+ +g[e+52>>2];v=r*h+z*f+A*v+ +g[e+56>>2];g[b+824>>2]=w*i+x*C+y*D;g[b+828>>2]=i*l+C*n+D*p;g[b+832>>2]=i*q+C*s+D*t;g[b+836>>2]=0.0;g[b+840>>2]=w*j+x*m+y*o;g[b+844>>2]=l*j+n*m+p*o;g[b+848>>2]=q*j+s*m+t*o;g[b+852>>2]=0.0;g[b+856>>2]=w*r+x*z+y*A;g[b+860>>2]=l*r+n*z+p*A;g[b+864>>2]=q*r+s*z+t*A;g[b+868>>2]=0.0;g[b+872>>2]=u;g[b+876>>2]=B;g[b+880>>2]=v;g[b+884>>2]=0.0;v=+g[b+52>>2];B=+g[d>>2];u=+g[b+68>>2];A=+g[d+4>>2];t=+g[b+84>>2];z=+g[d+8>>2];s=+g[b+56>>2];r=+g[b+72>>2];q=+g[b+88>>2];p=+g[b+60>>2];n=+g[b+76>>2];l=+g[b+92>>2];y=+g[d+16>>2];x=+g[d+20>>2];w=+g[d+24>>2];o=+g[d+32>>2];m=+g[d+36>>2];j=+g[d+40>>2];D=+g[b+100>>2];C=+g[b+104>>2];i=+g[b+108>>2];f=+g[d+48>>2]+(B*D+A*C+z*i);h=y*D+x*C+w*i+ +g[d+52>>2];i=o*D+m*C+j*i+ +g[d+56>>2];g[b+888>>2]=v*B+u*A+t*z;g[b+892>>2]=B*s+A*r+z*q;g[b+896>>2]=B*p+A*n+z*l;g[b+900>>2]=0.0;g[b+904>>2]=v*y+u*x+t*w;g[b+908>>2]=s*y+r*x+q*w;g[b+912>>2]=p*y+n*x+l*w;g[b+916>>2]=0.0;g[b+920>>2]=v*o+u*m+t*j;g[b+924>>2]=s*o+r*m+q*j;g[b+928>>2]=p*o+n*m+l*j;g[b+932>>2]=0.0;g[b+936>>2]=f;g[b+940>>2]=h;g[b+944>>2]=i;g[b+948>>2]=0.0;d=b+856|0;e=b+840|0}else{o=+g[b+52>>2];D=+g[d>>2];n=+g[b+68>>2];h=+g[d+4>>2];m=+g[b+84>>2];f=+g[d+8>>2];z=+g[b+56>>2];x=+g[b+72>>2];v=+g[b+88>>2];u=+g[b+60>>2];s=+g[b+76>>2];r=+g[b+92>>2];A=+g[d+16>>2];y=+g[d+20>>2];w=+g[d+24>>2];t=+g[d+32>>2];l=+g[d+36>>2];j=+g[d+40>>2];C=+g[b+100>>2];B=+g[b+104>>2];p=+g[b+108>>2];q=+g[d+48>>2]+(D*C+h*B+f*p);i=A*C+y*B+w*p+ +g[d+52>>2];p=t*C+l*B+j*p+ +g[d+56>>2];g[b+824>>2]=o*D+n*h+m*f;g[b+828>>2]=D*z+h*x+f*v;g[b+832>>2]=D*u+h*s+f*r;g[b+836>>2]=0.0;g[b+840>>2]=o*A+n*y+m*w;g[b+844>>2]=z*A+x*y+v*w;g[b+848>>2]=u*A+s*y+r*w;g[b+852>>2]=0.0;g[b+856>>2]=o*t+n*l+m*j;g[b+860>>2]=z*t+x*l+v*j;g[b+864>>2]=u*t+s*l+r*j;g[b+868>>2]=0.0;g[b+872>>2]=q;g[b+876>>2]=i;g[b+880>>2]=p;g[b+884>>2]=0.0;p=+g[b+116>>2];i=+g[e>>2];q=+g[b+132>>2];j=+g[e+4>>2];r=+g[b+148>>2];l=+g[e+8>>2];s=+g[b+120>>2];t=+g[b+136>>2];u=+g[b+152>>2];v=+g[b+124>>2];x=+g[b+140>>2];z=+g[b+156>>2];m=+g[e+16>>2];n=+g[e+20>>2];o=+g[e+24>>2];w=+g[e+32>>2];y=+g[e+36>>2];A=+g[e+40>>2];f=+g[b+164>>2];h=+g[b+168>>2];D=+g[b+172>>2];B=+g[e+48>>2]+(i*f+j*h+l*D);C=m*f+n*h+o*D+ +g[e+52>>2];D=w*f+y*h+A*D+ +g[e+56>>2];g[b+888>>2]=p*i+q*j+r*l;g[b+892>>2]=i*s+j*t+l*u;g[b+896>>2]=i*v+j*x+l*z;g[b+900>>2]=0.0;g[b+904>>2]=p*m+q*n+r*o;g[b+908>>2]=s*m+t*n+u*o;g[b+912>>2]=v*m+x*n+z*o;g[b+916>>2]=0.0;g[b+920>>2]=p*w+q*y+r*A;g[b+924>>2]=s*w+t*y+u*A;g[b+928>>2]=v*w+x*y+z*A;g[b+932>>2]=0.0;g[b+936>>2]=B;g[b+940>>2]=C;g[b+944>>2]=D;g[b+948>>2]=0.0;d=b+856|0;e=b+840|0}c[b+968>>2]=c[b+872>>2];c[b+968+4>>2]=c[b+872+4>>2];c[b+968+8>>2]=c[b+872+8>>2];c[b+968+12>>2]=c[b+872+12>>2];c[b+984>>2]=c[b+936>>2];c[b+984+4>>2]=c[b+936+4>>2];c[b+984+8>>2]=c[b+936+8>>2];c[b+984+12>>2]=c[b+936+12>>2];F=c[b+824>>2]|0;E=c[e>>2]|0;e=c[d>>2]|0;c[b+952>>2]=F;c[b+956>>2]=E;c[b+960>>2]=e;g[b+964>>2]=0.0;f=(c[k>>2]=F,+g[k>>2]);h=(c[k>>2]=E,+g[k>>2]);i=(c[k>>2]=e,+g[k>>2]);if((a[b+180>>0]|0)==0?(a[b+48>>0]|0)==0:0){u=+g[b+968>>2];A=u-+g[b+984>>2];v=+g[b+972>>2];C=v-+g[b+988>>2];w=+g[b+976>>2];D=w-+g[b+992>>2];g[b+1016>>2]=A;g[b+1020>>2]=C;g[b+1024>>2]=D;g[b+1028>>2]=0.0;B=f*A;x=h*C;x=B+x;B=i*D;B=x+B;x=f*B;y=h*B;z=i*B;x=u+x;y=v+y;z=w+z;F=b+1e3|0;g[F>>2]=x;F=b+1004|0;g[F>>2]=y;F=b+1008|0;g[F>>2]=z;F=b+1012|0;g[F>>2]=0.0;F=b+1032|0;g[F>>2]=B;F=b+828|0;E=b+844|0;e=b+860|0;B=+g[F>>2];z=+g[E>>2];y=+g[e>>2];B=B*A;z=z*C;z=B+z;y=y*D;y=z+y;e=b+1036|0;g[e>>2]=y;e=b+832|0;E=b+848|0;F=b+864|0;y=+g[e>>2];z=+g[E>>2];B=+g[F>>2];A=y*A;C=z*C;C=A+C;D=B*D;D=C+D;F=b+1040|0;g[F>>2]=D;return}u=+g[b+968>>2];A=+g[b+984>>2]-u;v=+g[b+972>>2];C=+g[b+988>>2]-v;w=+g[b+976>>2];D=+g[b+992>>2]-w;g[b+1016>>2]=A;g[b+1020>>2]=C;g[b+1024>>2]=D;g[b+1028>>2]=0.0;B=f*A;x=h*C;x=B+x;B=i*D;B=x+B;x=f*B;y=h*B;z=i*B;x=u+x;y=v+y;z=w+z;F=b+1e3|0;g[F>>2]=x;F=b+1004|0;g[F>>2]=y;F=b+1008|0;g[F>>2]=z;F=b+1012|0;g[F>>2]=0.0;F=b+1032|0;g[F>>2]=B;F=b+828|0;E=b+844|0;e=b+860|0;B=+g[F>>2];z=+g[E>>2];y=+g[e>>2];B=B*A;z=z*C;z=B+z;y=y*D;y=z+y;e=b+1036|0;g[e>>2]=y;e=b+832|0;E=b+848|0;F=b+864|0;y=+g[e>>2];z=+g[E>>2];B=+g[F>>2];A=y*A;C=z*C;C=A+C;D=B*D;D=C+D;F=b+1040|0;g[F>>2]=D;return}function sq(d,e){d=d|0;e=e|0;var f=0.0,h=0,j=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0,A=0,B=0.0,C=0.0,D=0,E=0,F=0.0,G=0.0,H=0,I=0.0,J=0,K=0,L=0,M=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0.0,X=0.0,Y=0.0,Z=0,$=0.0,aa=0.0,ba=0.0,ca=0,da=0,ea=0.0,fa=0,ga=0,ha=0.0,ia=0.0;ga=i;i=i+16|0;da=c[d+28>>2]|0;fa=c[d+32>>2]|0;$=+g[da+368>>2];aa=+g[fa+368>>2];Z=c[e+24>>2]|0;ea=a[d+180>>0]|0?1.0:-1.0;W=+g[d+936>>2]-+g[d+872>>2];X=+g[d+940>>2]-+g[d+876>>2];Y=+g[d+944>>2]-+g[d+880>>2];ba=$+aa>0.0?aa/($+aa):.5;H=c[d+824>>2]|0;J=c[d+840>>2]|0;K=c[d+856>>2]|0;L=c[d+888>>2]|0;M=c[d+904>>2]|0;P=c[d+920>>2]|0;Q=(a[d+49>>0]|0)==0;if(Q){y=c[d+828>>2]|0;l=c[d+844>>2]|0;t=c[d+860>>2]|0;c[ga+4>>2]=l;x=c[d+832>>2]|0;D=c[d+848>>2]|0;ca=c[d+864>>2]|0;c[ga>>2]=x;w=(c[k>>2]=t,+g[k>>2]);v=(c[k>>2]=x,+g[k>>2]);q=(c[k>>2]=D,+g[k>>2]);E=ca;u=(c[k>>2]=ca,+g[k>>2]);ca=H;z=J;A=K}else{f=ba*(c[k>>2]=H,+g[k>>2]);n=ba*(c[k>>2]=J,+g[k>>2]);m=ba*(c[k>>2]=K,+g[k>>2]);j=(1.0-ba)*(c[k>>2]=L,+g[k>>2]);o=(1.0-ba)*(c[k>>2]=M,+g[k>>2]);m=m+(1.0-ba)*(c[k>>2]=P,+g[k>>2]);p=1.0/+O(+((f+j)*(f+j)+(n+o)*(n+o)+m*m));y=(g[k>>2]=(f+j)*p,c[k>>2]|0);z=(g[k>>2]=(n+o)*p,c[k>>2]|0);A=(g[k>>2]=m*p,c[k>>2]|0);if(+N(+(m*p))>.7071067690849304){I=1.0/+O(+(m*p*(m*p)+(n+o)*p*((n+o)*p)));g[ga+4>>2]=-(m*p*I);q=-((f+j)*p*((n+o)*p*I));r=(f+j)*p*-(m*p*I);j=(m*p*(m*p)+(n+o)*p*((n+o)*p))*I;f=(n+o)*p*I;h=0}else{r=(f+j)*p*((f+j)*p)+(n+o)*p*((n+o)*p);I=1.0/+O(+r);h=(g[k>>2]=-((n+o)*p*I),c[k>>2]|0);g[ga+4>>2]=(f+j)*p*I;q=m*p*-((n+o)*p*I);r=r*I;j=-(m*p*((f+j)*p*I));f=0.0}t=(g[k>>2]=f,c[k>>2]|0);x=(g[k>>2]=j,c[k>>2]|0);g[ga>>2]=j;D=(g[k>>2]=q,c[k>>2]|0);l=c[ga+4>>2]|0;E=(g[k>>2]=r,c[k>>2]|0);w=f;v=j;u=r;ca=y;y=h}h=c[e+12>>2]|0;c[h>>2]=y;c[h+4>>2]=l;c[h+8>>2]=t;c[h+(Z<<2)>>2]=x;c[h+(Z+1<<2)>>2]=D;c[h+(Z+2<<2)>>2]=E;r=(c[k>>2]=y,+g[k>>2]);h=c[e+20>>2]|0;g[h>>2]=-r;s=+g[ga+4>>2];g[h+4>>2]=-s;g[h+8>>2]=-w;g[h+(Z<<2)>>2]=-v;g[h+(Z+1<<2)>>2]=-q;g[h+(Z+2<<2)>>2]=-u;h=c[d+300>>2]|0;f=+g[d+280>>2];if(!(h&128))f=f*+g[e+4>>2];o=f*+g[e>>2];G=(c[k>>2]=J,+g[k>>2]);B=(c[k>>2]=P,+g[k>>2]);p=(c[k>>2]=K,+g[k>>2]);F=(c[k>>2]=M,+g[k>>2]);I=(c[k>>2]=L,+g[k>>2]);C=(c[k>>2]=H,+g[k>>2]);V=c[e+28>>2]|0;g[V>>2]=o*((G*B-p*F)*r+(p*I-C*B)*s+(C*F-G*I)*w);g[V+(Z<<2)>>2]=o*((G*B-p*F)*v+(p*I-C*B)*q+(C*F-G*I)*u);if(h&64|0){V=c[e+32>>2]|0;c[V>>2]=c[d+292>>2];c[V+(Z<<2)>>2]=c[d+292>>2]}n=+g[da+52>>2];o=+g[da+56>>2];p=+g[da+60>>2];f=+g[fa+52>>2];j=+g[fa+56>>2];m=+g[fa+60>>2];if(Q){S=(g[k>>2]=j-o,c[k>>2]|0);G=(j-o)*w-(m-p)*s;I=(m-p)*r-(f-n)*w;Q=c[e+12>>2]|0;g[Q+(Z<<1<<2)>>2]=ba*G;g[Q+((Z<<1|1)<<2)>>2]=ba*I;g[Q+((Z<<1)+2<<2)>>2]=ba*((f-n)*s-(j-o)*r);Q=(g[k>>2]=f-n,c[k>>2]|0);R=(g[k>>2]=m-p,c[k>>2]|0);T=c[e+20>>2]|0;g[T+(Z<<1<<2)>>2]=(1.0-ba)*G;g[T+((Z<<1|1)<<2)>>2]=(1.0-ba)*I;g[T+((Z<<1)+2<<2)>>2]=(1.0-ba)*((f-n)*s-(j-o)*r);I=(j-o)*u-(m-p)*q;m=(m-p)*v-(f-n)*u;p=(f-n)*q-(j-o)*v;T=c[e+12>>2]|0;g[T+(Z*3<<2)>>2]=ba*I;g[T+((Z*3|0)+1<<2)>>2]=ba*m;g[T+((Z*3|0)+2<<2)>>2]=ba*p;T=c[e+20>>2]|0;g[T+(Z*3<<2)>>2]=(1.0-ba)*I;g[T+((Z*3|0)+1<<2)>>2]=(1.0-ba)*m;g[T+((Z*3|0)+2<<2)>>2]=(1.0-ba)*p;J=c[e+8>>2]|0;c[J+(Z<<1<<2)>>2]=y;g[J+((Z<<1|1)<<2)>>2]=s;g[J+((Z<<1)+2<<2)>>2]=w;J=c[e+8>>2]|0;M=c[ga>>2]|0;c[J+(Z*3<<2)>>2]=M;c[J+((Z*3|0)+1<<2)>>2]=D;c[J+((Z*3|0)+2<<2)>>2]=E;P=c[e+16>>2]|0;g[P+(Z<<1<<2)>>2]=-r;p=+g[ga+4>>2];g[P+((Z<<1|1)<<2)>>2]=-p;g[P+((Z<<1)+2<<2)>>2]=-w;P=c[e+16>>2]|0;n=(c[k>>2]=M,+g[k>>2]);g[P+(Z*3<<2)>>2]=-n;m=(c[k>>2]=D,+g[k>>2]);g[P+((Z*3|0)+1<<2)>>2]=-m;j=(c[k>>2]=E,+g[k>>2]);g[P+((Z*3|0)+2<<2)>>2]=-j;o=w;M=0;L=0;K=0;t=0;l=0;h=0}else{ia=+g[d+936>>2]-f;ha=+g[d+940>>2]-j;F=+g[d+944>>2]-m;r=(c[k>>2]=ca,+g[k>>2]);s=(c[k>>2]=z,+g[k>>2]);q=(c[k>>2]=A,+g[k>>2]);G=+g[d+872>>2]-n;I=+g[d+876>>2]-o;m=+g[d+880>>2]-p;o=+g[d+1080>>2]-+g[d+1032>>2];u=r*(r*G+s*I+q*m)+r*o-r*(r*ia+s*ha+q*F);v=s*(r*G+s*I+q*m)+s*o-s*(r*ia+s*ha+q*F);o=q*(r*G+s*I+q*m)+q*o-q*(r*ia+s*ha+q*F);B=G-r*(r*G+s*I+q*m)+ba*u;w=I-s*(r*G+s*I+q*m)+ba*v;C=m-q*(r*G+s*I+q*m)+ba*o;M=(g[k>>2]=B,c[k>>2]|0);L=(g[k>>2]=w,c[k>>2]|0);K=(g[k>>2]=C,c[k>>2]|0);u=ia-r*(r*ia+s*ha+q*F)-(1.0-ba)*u;v=ha-s*(r*ia+s*ha+q*F)-(1.0-ba)*v;o=F-q*(r*ia+s*ha+q*F)-(1.0-ba)*o;t=(g[k>>2]=u,c[k>>2]|0);x=(g[k>>2]=v,c[k>>2]|0);y=(g[k>>2]=o,c[k>>2]|0);j=ba*(ia-r*(r*ia+s*ha+q*F))+(1.0-ba)*(G-r*(r*G+s*I+q*m));f=ba*(ha-s*(r*ia+s*ha+q*F))+(1.0-ba)*(I-s*(r*G+s*I+q*m));m=ba*(F-q*(r*ia+s*ha+q*F))+(1.0-ba)*(m-q*(r*G+s*I+q*m));g[ga+4>>2]=f;if(m*m+(j*j+f*f)>1.1920928955078125e-07){ia=1.0/+O(+(m*m+(j*j+f*f)));l=(g[k>>2]=j*ia,c[k>>2]|0);g[ga+4>>2]=ia*f;I=ia*m;n=ia*f;f=j*ia;h=(g[k>>2]=ia*m,c[k>>2]|0)}else{l=c[d+828>>2]|0;V=c[d+844>>2]|0;h=c[d+860>>2]|0;c[ga+4>>2]=V;I=(c[k>>2]=h,+g[k>>2]);n=(c[k>>2]=V,+g[k>>2]);f=(c[k>>2]=l,+g[k>>2])}F=s*I-q*n;G=q*f-r*I;q=r*n-s*f;g[ga>>2]=F;V=(c[e+12>>2]|0)+(Z<<1<<2)|0;g[V>>2]=w*I-C*n;g[V+4>>2]=C*f-B*I;g[V+8>>2]=B*n-w*f;V=c[e+20>>2]|0;g[V+(Z<<1<<2)>>2]=-(v*I-o*n);g[V+((Z<<1|1)<<2)>>2]=-(o*f-u*I);g[V+((Z<<1)+2<<2)>>2]=-(u*n-v*f);if($<1.1920928955078125e-07|aa<1.1920928955078125e-07?(a[d+297>>0]|0)!=0:0){p=(1.0-ba)*(v*q-o*G);o=(1.0-ba)*(o*F-u*q);m=(1.0-ba)*(u*G-v*F);n=ba*(w*q-C*G);j=ba*(B*G-w*F);f=ba*(C*F-B*q)}else{p=v*q-o*G;o=o*F-u*q;m=u*G-v*F;n=w*q-C*G;j=B*G-w*F;f=C*F-B*q}T=(c[e+12>>2]|0)+(Z*3<<2)|0;g[T>>2]=n;g[T+4>>2]=f;g[T+8>>2]=j;T=c[e+20>>2]|0;g[T+(Z*3<<2)>>2]=-p;g[T+((Z*3|0)+1<<2)>>2]=-o;g[T+((Z*3|0)+2<<2)>>2]=-m;J=c[e+8>>2]|0;c[J+(Z<<1<<2)>>2]=l;c[J+((Z<<1|1)<<2)>>2]=c[ga+4>>2];c[J+((Z<<1)+2<<2)>>2]=h;J=c[e+8>>2]|0;g[J+(Z*3<<2)>>2]=F;g[J+((Z*3|0)+1<<2)>>2]=G;g[J+((Z*3|0)+2<<2)>>2]=q;P=c[e+16>>2]|0;r=(c[k>>2]=l,+g[k>>2]);g[P+(Z<<1<<2)>>2]=-r;p=+g[ga+4>>2];g[P+((Z<<1|1)<<2)>>2]=-p;g[P+((Z<<1)+2<<2)>>2]=-I;P=c[e+16>>2]|0;g[P+(Z*3<<2)>>2]=-F;g[P+((Z*3|0)+1<<2)>>2]=-G;g[P+((Z*3|0)+2<<2)>>2]=-q;o=I;n=F;m=G;j=q;Q=0;R=0;S=0;l=x;h=y}U=c[d+300>>2]|0;f=+g[d+264>>2];if(!(U&32))f=f*+g[e+4>>2];ia=f*+g[e>>2];V=c[e+28>>2]|0;g[V+(Z<<1<<2)>>2]=ia*(W*r+X*p+Y*o);g[V+(Z*3<<2)>>2]=ia*(W*n+X*m+Y*j);if(U&16|0){H=c[e+32>>2]|0;c[H+(Z<<1<<2)>>2]=c[d+276>>2];c[H+(Z*3<<2)>>2]=c[d+276>>2]}H=b[d+296>>1]|0;if(!((H&255)<<24>>24)){E=0;u=0.0}else{u=ea*+g[d+1032>>2];E=u>0.0?2:1}x=a[d+1096>>0]|0;y=(E|0)!=0;if(x&255|E){D=c[e+24>>2]<<2;c[J+(D<<2)>>2]=ca;c[J+((D|1)<<2)>>2]=z;c[J+((D|2)<<2)>>2]=A;q=(c[k>>2]=ca,+g[k>>2]);g[P+(D<<2)>>2]=-q;r=(c[k>>2]=z,+g[k>>2]);g[P+((D|1)<<2)>>2]=-r;s=(c[k>>2]=A,+g[k>>2]);g[P+((D|2)<<2)>>2]=-s;if(a[d+49>>0]|0){if(!($<1.1920928955078125e-07|aa<1.1920928955078125e-07)){aa=(c[k>>2]=L,+g[k>>2]);Y=(c[k>>2]=K,+g[k>>2]);$=(c[k>>2]=M,+g[k>>2]);ia=(c[k>>2]=l,+g[k>>2]);ba=(c[k>>2]=h,+g[k>>2]);ha=(c[k>>2]=t,+g[k>>2]);Z=c[e+12>>2]|0;g[Z+(D<<2)>>2]=s*aa-r*Y;g[Z+((D|1)<<2)>>2]=q*Y-s*$;g[Z+((D|2)<<2)>>2]=r*$-q*aa;g[T+(D<<2)>>2]=-(s*ia-r*ba);g[T+((D|1)<<2)>>2]=-(q*ba-s*ha);g[T+((D|2)<<2)>>2]=-(r*ha-q*ia)}}else{ia=(c[k>>2]=S,+g[k>>2]);aa=(c[k>>2]=R,+g[k>>2]);ha=(c[k>>2]=Q,+g[k>>2]);Z=c[e+12>>2]|0;g[Z+(D<<2)>>2]=ba*(s*ia-r*aa);g[Z+((D|1)<<2)>>2]=ba*(q*aa-s*ha);g[Z+((D|2)<<2)>>2]=ba*(r*ha-q*ia);g[T+(D<<2)>>2]=(1.0-ba)*(s*ia-r*aa);g[T+((D|1)<<2)>>2]=(1.0-ba)*(q*aa-s*ha);g[T+((D|2)<<2)>>2]=(1.0-ba)*(r*ha-q*ia)}h=+g[d+184>>2]==+g[d+188>>2];g[V+(D<<2)>>2]=0.0;l=(c[e+36>>2]|0)+(D<<2)|0;g[l>>2]=0.0;t=(c[e+40>>2]|0)+(D<<2)|0;g[t>>2]=0.0;p=+g[((U&512|0)==0?e+4|0:d+232|0)>>2];if(!(x<<24>>24==0|y&h)){if(U&1|0)c[(c[e+32>>2]|0)+(D<<2)>>2]=c[d+212>>2];o=+g[d+1100>>2];f=+g[d+1080>>2];j=+g[d+184>>2];m=+g[d+188>>2];n=p*+g[e>>2];do if(!(j>m))if(!(j==m)){if(o/n<0.0)if(f>=j?j-o/n>f:0){f=(j-f)/(o/n);break}else{f=f<j?0.0:1.0;break}if(o/n>0.0)if(f<=m?m-o/n<f:0){f=(m-f)/(o/n);break}else{f=f>m?0.0:1.0;break}else f=0.0}else f=0.0;else f=1.0;while(0);g[V+(D<<2)>>2]=+g[V+(D<<2)>>2]-ea*f*o;g[l>>2]=-+g[d+1104>>2]/+g[e>>2]+ +g[l>>2];g[t>>2]=+g[d+1104>>2]/+g[e>>2]+ +g[t>>2]}if(y){g[V+(D<<2)>>2]=+g[V+(D<<2)>>2]+u*(p*+g[e>>2]);if(U&256|0)c[(c[e+32>>2]|0)+(D<<2)>>2]=c[d+244>>2];do if(!h)if((E|0)==1){g[l>>2]=-3402823466385288598117041.0e14;g[t>>2]=0.0;break}else{g[l>>2]=0.0;g[t>>2]=3402823466385288598117041.0e14;break}else{g[l>>2]=-3402823466385288598117041.0e14;g[t>>2]=3402823466385288598117041.0e14}while(0);ia=1.0-+g[d+240>>2];j=+N(+ia);do if(!(ia!=ia|0.0!=0.0|ia==0.0)){f=ea*(q*+g[da+336>>2]+r*+g[da+340>>2]+s*+g[da+344>>2]-(q*+g[fa+336>>2]+r*+g[fa+340>>2]+s*+g[fa+344>>2]));if((E|0)==1){if(!(f<0.0))break;if(!(+g[V+(D<<2)>>2]<-(j*f)))break;g[V+(D<<2)>>2]=-(j*f);break}else{if(!(f>0.0))break;if(!(+g[V+(D<<2)>>2]>-(j*f)))break;g[V+(D<<2)>>2]=-(j*f);break}}while(0);g[V+(D<<2)>>2]=+g[d+232>>2]*+g[V+(D<<2)>>2];h=5}else h=5}else h=4;if((H&65535)<256){y=0;v=0.0}else{v=+g[d+1088>>2];y=v>0.0?1:2}l=a[d+1112>>0]|0;t=(y|0)!=0;if(!(l&255|y)){i=ga;return}x=_(c[e+24>>2]|0,h)|0;fa=c[e+12>>2]|0;c[fa+(x<<2)>>2]=ca;c[fa+(x+1<<2)>>2]=z;c[fa+(x+2<<2)>>2]=A;w=(c[k>>2]=ca,+g[k>>2]);g[T+(x<<2)>>2]=-w;u=(c[k>>2]=z,+g[k>>2]);g[T+(x+1<<2)>>2]=-u;s=(c[k>>2]=A,+g[k>>2]);g[T+(x+2<<2)>>2]=-s;p=+g[d+192>>2];q=+g[d+196>>2];r=+g[((U&2048|0)==0?e+4|0:d+248|0)>>2];if(!(l<<24>>24==0|t&p==q)){if(!(U&4)){m=p;n=q}else{c[(c[e+32>>2]|0)+(x<<2)>>2]=c[d+228>>2];m=+g[d+192>>2];n=+g[d+196>>2]}f=+g[d+1084>>2];o=+g[d+1116>>2];j=r*+g[e>>2];do if(!(m>n))if(!(m==n)){if(o/j<0.0)if(f>=m?m-o/j>f:0){f=(m-f)/(o/j);break}else{f=f<m?0.0:1.0;break}if(o/j>0.0)if(f<=n?n-o/j<f:0){f=(n-f)/(o/j);break}else{f=f>n?0.0:1.0;break}else f=0.0}else f=0.0;else f=1.0;while(0);g[V+(x<<2)>>2]=f*o;g[(c[e+36>>2]|0)+(x<<2)>>2]=-+g[d+1120>>2]/+g[e>>2];g[(c[e+40>>2]|0)+(x<<2)>>2]=+g[d+1120>>2]/+g[e>>2]}if(!t){i=ga;return}g[V+(x<<2)>>2]=+g[V+(x<<2)>>2]+v*(r*+g[e>>2]);if(U&1024|0)c[(c[e+32>>2]|0)+(x<<2)>>2]=c[d+260>>2];do if(!(p==q)){l=(c[e+36>>2]|0)+(x<<2)|0;h=c[e+40>>2]|0;if((y|0)==1){g[l>>2]=0.0;g[h+(x<<2)>>2]=3402823466385288598117041.0e14;break}else{g[l>>2]=-3402823466385288598117041.0e14;g[h+(x<<2)>>2]=0.0;break}}else{g[(c[e+36>>2]|0)+(x<<2)>>2]=-3402823466385288598117041.0e14;g[(c[e+40>>2]|0)+(x<<2)>>2]=3402823466385288598117041.0e14}while(0);ia=1.0-+g[d+256>>2];j=+N(+ia);do if(!(ia!=ia|0.0!=0.0|ia==0.0)){fa=c[d+28>>2]|0;e=c[d+32>>2]|0;f=w*+g[fa+352>>2]+u*+g[fa+356>>2]+s*+g[fa+360>>2]-(w*+g[e+352>>2]+u*+g[e+356>>2]+s*+g[e+360>>2]);if((y|0)==1){if(!(f<0.0))break;if(!(+g[V+(x<<2)>>2]<-(j*f)))break;g[V+(x<<2)>>2]=-(j*f);break}else{if(!(f>0.0))break;if(!(+g[V+(x<<2)>>2]>-(j*f)))break;g[V+(x<<2)>>2]=-(j*f);break}}while(0);g[V+(x<<2)>>2]=+g[d+248>>2]*+g[V+(x<<2)>>2];i=ga;return}function tq(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;switch(b|0){case 2:{if((e|0)<1){g[a+232>>2]=d;c[a+300>>2]=c[a+300>>2]|512;return}if((e|0)<3){g[a+264>>2]=d;c[a+300>>2]=c[a+300>>2]|32;return}if((e|0)==3){g[a+248>>2]=d;c[a+300>>2]=c[a+300>>2]|2048;return}if((e|0)>=6)return;g[a+280>>2]=d;c[a+300>>2]=c[a+300>>2]|128;return}case 3:{if((e|0)<1){g[a+212>>2]=d;c[a+300>>2]=c[a+300>>2]|1;return}if((e|0)!=3)return;g[a+228>>2]=d;c[a+300>>2]=c[a+300>>2]|4;return}case 4:{if((e|0)<1){g[a+244>>2]=d;c[a+300>>2]=c[a+300>>2]|256;return}if((e|0)<3){g[a+276>>2]=d;c[a+300>>2]=c[a+300>>2]|16;return}if((e|0)==3){g[a+260>>2]=d;c[a+300>>2]=c[a+300>>2]|1024;return}if((e|0)>=6)return;g[a+292>>2]=d;c[a+300>>2]=c[a+300>>2]|64;return}default:return}}function uq(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0;a:do switch(b|0){case 2:{if((c|0)<1){d=+g[a+232>>2];break a}if((c|0)<3){d=+g[a+264>>2];break a}if((c|0)==3){d=+g[a+248>>2];break a}if((c|0)<6)d=+g[a+280>>2];else d=3402823466385288598117041.0e14;break}case 3:{if((c|0)<1){d=+g[a+212>>2];break a}if((c|0)==3)d=+g[a+228>>2];else d=3402823466385288598117041.0e14;break}case 4:{if((c|0)<1){d=+g[a+244>>2];break a}if((c|0)<3){d=+g[a+276>>2];break a}if((c|0)==3){d=+g[a+260>>2];break a}if((c|0)<6)d=+g[a+292>>2];else d=3402823466385288598117041.0e14;break}default:d=3402823466385288598117041.0e14}while(0);return +d}function vq(a){a=a|0;return 204}function wq(a,b,e){a=a|0;b=b|0;e=e|0;Aq(a,b,e)|0;c[b+52>>2]=c[a+52>>2];c[b+56>>2]=c[a+56>>2];c[b+60>>2]=c[a+60>>2];c[b+64>>2]=c[a+64>>2];c[b+68>>2]=c[a+68>>2];c[b+72>>2]=c[a+72>>2];c[b+76>>2]=c[a+76>>2];c[b+80>>2]=c[a+80>>2];c[b+84>>2]=c[a+84>>2];c[b+88>>2]=c[a+88>>2];c[b+92>>2]=c[a+92>>2];c[b+96>>2]=c[a+96>>2];c[b+100>>2]=c[a+100>>2];c[b+104>>2]=c[a+104>>2];c[b+108>>2]=c[a+108>>2];c[b+112>>2]=c[a+112>>2];c[b+116>>2]=c[a+116>>2];c[b+120>>2]=c[a+120>>2];c[b+124>>2]=c[a+124>>2];c[b+128>>2]=c[a+128>>2];c[b+132>>2]=c[a+132>>2];c[b+136>>2]=c[a+136>>2];c[b+140>>2]=c[a+140>>2];c[b+144>>2]=c[a+144>>2];c[b+148>>2]=c[a+148>>2];c[b+152>>2]=c[a+152>>2];c[b+156>>2]=c[a+156>>2];c[b+160>>2]=c[a+160>>2];c[b+164>>2]=c[a+164>>2];c[b+168>>2]=c[a+168>>2];c[b+172>>2]=c[a+172>>2];c[b+176>>2]=c[a+176>>2];c[b+180>>2]=c[a+188>>2];c[b+184>>2]=c[a+184>>2];c[b+188>>2]=c[a+196>>2];c[b+192>>2]=c[a+192>>2];c[b+196>>2]=d[a+180>>0];c[b+200>>2]=d[a+49>>0];return 15616}function xq(a){a=a|0;return c[a+300>>2]|0}function yq(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0;f=i;i=i+16|0;c[b+4>>2]=d;c[b>>2]=7188;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3402823466385288598117041.0e14;a[b+20>>0]=1;a[b+21>>0]=0;c[b+24>>2]=-1;c[b+28>>2]=e;if(!(a[19880]|0)){a[19880]=1;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;Cr(21260,0.0,0,0,f)}c[5366]=c[5366]|1;g[5407]=0.0;h=+g[5417]*0.0;j=+g[5418]*0.0;g[5412]=+g[5416]*0.0;g[5413]=h;g[5414]=j;g[5415]=0.0;c[5420]=0;c[5421]=0;c[5422]=0;c[5423]=0;j=+g[5409]*0.0;h=+g[5410]*0.0;g[5461]=+g[5408]*0.0;g[5462]=j;g[5463]=h;g[5464]=0.0;c[b+32>>2]=21260;g[b+36>>2]=0.0;g[b+40>>2]=.30000001192092896;c[b+44>>2]=0;i=f;return}function zq(b){b=b|0;var d=0;c[b>>2]=7916;d=c[b+520>>2]|0;if(d|0){if(a[b+524>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+520>>2]=0}a[b+524>>0]=1;c[b+520>>2]=0;c[b+512>>2]=0;c[b+516>>2]=0;c[b>>2]=3156;d=c[b+276>>2]|0;if(!d){a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;b=b+272|0;c[b>>2]=0;return}if(a[b+280>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+276>>2]=0;a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;b=b+272|0;c[b>>2]=0;return}function Aq(a,b,e){a=a|0;b=b|0;e=e|0;var f=0,g=0;c[b>>2]=Ob[c[(c[e>>2]|0)+28>>2]&31](e,c[a+28>>2]|0)|0;c[b+4>>2]=Ob[c[(c[e>>2]|0)+28>>2]&31](e,c[a+32>>2]|0)|0;f=Ob[c[(c[e>>2]|0)+40>>2]&31](e,a)|0;g=Ob[c[(c[e>>2]|0)+28>>2]&31](e,f)|0;c[b+8>>2]=g;if(g|0)tb[c[(c[e>>2]|0)+48>>2]&127](e,f);c[b+12>>2]=c[a+4>>2];c[b+24>>2]=d[a+21>>0];c[b+40>>2]=c[a+24>>2];c[b+44>>2]=c[a+16>>2];c[b+48>>2]=d[a+20>>0];c[b+20>>2]=c[a+12>>2];c[b+16>>2]=c[a+8>>2];c[b+28>>2]=c[a+36>>2];c[b+32>>2]=c[a+40>>2];c[b+36>>2]=0;f=c[a+28>>2]|0;if((c[f+512>>2]|0)>0){e=0;do{if((c[(c[f+520>>2]|0)+(e<<2)>>2]|0)==(a|0)){c[b+36>>2]=1;f=c[a+28>>2]|0}e=e+1|0}while((e|0)<(c[f+512>>2]|0))}f=c[a+32>>2]|0;if((c[f+512>>2]|0)>0)e=0;else return 15639;do{if((c[(c[f+520>>2]|0)+(e<<2)>>2]|0)==(a|0)){c[b+36>>2]=1;f=c[a+32>>2]|0}e=e+1|0}while((e|0)<(c[f+512>>2]|0));return 15639}function Bq(b){b=b|0;var d=0,e=0,f=0;c[b>>2]=7656;if(a[b+272>>0]|0?(d=c[b+204>>2]|0,rb[c[c[d>>2]>>2]&255](d),d=c[b+204>>2]|0,d|0):0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+196>>2]|0;if(d|0?(rb[c[c[d>>2]>>2]&255](d),e=c[b+196>>2]|0,e|0):0){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0)}if(a[b+273>>0]|0?(f=c[b+200>>2]|0,rb[c[c[f>>2]>>2]&255](f),f=c[b+200>>2]|0,f|0):0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}d=c[b+316>>2]|0;if(d|0){if(a[b+320>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+316>>2]=0}a[b+320>>0]=1;c[b+316>>2]=0;c[b+308>>2]=0;c[b+312>>2]=0;d=c[b+288>>2]|0;if(d|0){if(a[b+292>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+288>>2]=0}a[b+292>>0]=1;c[b+288>>2]=0;c[b+280>>2]=0;c[b+284>>2]=0;d=c[b+240>>2]|0;if(d|0){if(a[b+244>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+240>>2]=0}a[b+244>>0]=1;c[b+240>>2]=0;c[b+232>>2]=0;c[b+236>>2]=0;d=c[b+220>>2]|0;if(d|0){if(a[b+224>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+220>>2]=0}a[b+224>>0]=1;c[b+220>>2]=0;c[b+212>>2]=0;c[b+216>>2]=0;d=c[b+188>>2]|0;if(!d){a[b+192>>0]=1;c[b+188>>2]=0;c[b+180>>2]=0;f=b+184|0;c[f>>2]=0;Ze(b);return}if(a[b+192>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+188>>2]=0;a[b+192>>0]=1;c[b+188>>2]=0;c[b+180>>2]=0;f=b+184|0;c[f>>2]=0;Ze(b);return}function Cq(a){a=a|0;Bq(a);if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function Dq(a){a=a|0;var b=0,d=0,e=0;e=i;i=i+16|0;fs(15710);df(a);a:do if(vb[c[(c[a>>2]|0)+20>>2]&127](a)|0?(d=vb[c[(c[a>>2]|0)+20>>2]&127](a)|0,(vb[c[(c[d>>2]|0)+56>>2]&127](d)|0)&6144|0):0){d=vb[c[(c[a>>2]|0)+104>>2]&127](a)|0;while(1){b=d+-1|0;if((d|0)<=0)break a;d=Ob[c[(c[a>>2]|0)+108>>2]&31](a,b)|0;tb[c[(c[a>>2]|0)+168>>2]&127](a,d);d=b}}while(0);if((((vb[c[(c[a>>2]|0)+20>>2]&127](a)|0?(d=vb[c[(c[a>>2]|0)+20>>2]&127](a)|0,(vb[c[(c[d>>2]|0)+56>>2]&127](d)|0)&16387|0):0)?vb[c[(c[a>>2]|0)+20>>2]&127](a)|0:0)?(d=vb[c[(c[a>>2]|0)+20>>2]&127](a)|0,vb[c[(c[d>>2]|0)+56>>2]&127](d)|0):0)?(c[a+280>>2]|0)>0:0){b=0;do{d=c[(c[a+288>>2]|0)+(b<<2)>>2]|0;tb[c[(c[d>>2]|0)+12>>2]&127](d,c[a+72>>2]|0);b=b+1|0}while((b|0)<(c[a+280>>2]|0))}if(vb[c[(c[a>>2]|0)+20>>2]&127](a)|0){a=vb[c[(c[a>>2]|0)+20>>2]&127](a)|0;rb[c[(c[a>>2]|0)+100>>2]&255](a)}b=c[2006]|0;a=(c[b+16>>2]|0)+-1|0;c[b+16>>2]=a;if(a|0){i=e;return}do if(c[b+4>>2]|0){kb(e|0,0)|0;a=c[5649]|0;g[b+8>>2]=+g[b+8>>2]+ +(((c[e+4>>2]|0)-(c[a+4>>2]|0)+(((c[e>>2]|0)-(c[a>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[b+16>>2]|0)){b=c[2006]|0;break}else{i=e;return}}while(0);c[2006]=c[b+20>>2];i=e;return}function Eq(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;Jf(a,b,c,d);return}function Fq(a,b){a=a|0;b=b|0;if((b|0)==0?1:(c[b+236>>2]&2|0)==0){Kf(a,b);return}else{tb[c[(c[a>>2]|0)+92>>2]&127](a,b);return}}function Gq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;rb[c[(c[b>>2]|0)+32>>2]&255](b);d=Eb[c[(c[b>>2]|0)+16>>2]&63](b,104,1)|0;e=c[d+8>>2]|0;f=e;g=f+104|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(g|0));c[e+88>>2]=c[a+248>>2];c[e+92>>2]=c[a+252>>2];c[e+96>>2]=c[a+256>>2];c[e+100>>2]=c[a+260>>2];c[e>>2]=c[a+92>>2];c[e+4>>2]=c[a+96>>2];c[e+8>>2]=c[a+100>>2];c[e+12>>2]=c[a+104>>2];c[e+16>>2]=c[a+108>>2];c[e+20>>2]=c[a+116>>2];c[e+24>>2]=c[a+120>>2];c[e+28>>2]=c[a+124>>2];c[e+32>>2]=c[a+128>>2];c[e+36>>2]=c[a+132>>2];c[e+40>>2]=c[a+140>>2];c[e+44>>2]=c[a+144>>2];c[e+48>>2]=c[a+148>>2];c[e+52>>2]=c[a+152>>2];c[e+56>>2]=c[a+168>>2];c[e+60>>2]=c[a+172>>2];c[e+64>>2]=c[a+112>>2];c[e+68>>2]=c[a+156>>2];c[e+72>>2]=c[a+160>>2];c[e+76>>2]=c[a+164>>2];c[e+80>>2]=c[a+136>>2];pb[c[(c[b>>2]|0)+20>>2]&31](b,d,15725,1145853764,e);Nf(a,b);Hq(a,b);rb[c[(c[b>>2]|0)+36>>2]&255](b);return}function Hq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=c[a+8>>2]|0;if((d|0)>0){f=0;do{e=c[(c[a+16>>2]|0)+(f<<2)>>2]|0;if(c[e+236>>2]&2){g=vb[c[(c[e>>2]|0)+16>>2]&127](e)|0;g=Eb[c[(c[b>>2]|0)+16>>2]&63](b,g,1)|0;d=Eb[c[(c[e>>2]|0)+20>>2]&63](e,c[g+8>>2]|0,b)|0;pb[c[(c[b>>2]|0)+20>>2]&31](b,g,d,1497645650,e);d=c[a+8>>2]|0}f=f+1|0}while((f|0)<(d|0))}if((c[a+212>>2]|0)<=0)return;d=0;do{g=c[(c[a+220>>2]|0)+(d<<2)>>2]|0;e=vb[c[(c[g>>2]|0)+36>>2]&127](g)|0;e=Eb[c[(c[b>>2]|0)+16>>2]&63](b,e,1)|0;f=Eb[c[(c[g>>2]|0)+40>>2]&63](g,c[e+8>>2]|0,b)|0;pb[c[(c[b>>2]|0)+20>>2]&31](b,e,f,1397641027,g);d=d+1|0}while((d|0)<(c[a+212>>2]|0));return}function Iq(b,d,e,f){b=b|0;d=+d;e=e|0;f=+f;var h=0,j=0.0,k=0,l=0;l=i;i=i+16|0;kb(c[5649]|0,0)|0;es(22556);c[5640]=(c[5640]|0)+1;k=c[5643]|0;c[5643]=k+1;if(!k){kb(l|0,0)|0;k=c[5649]|0;c[5642]=(c[l+4>>2]|0)-(c[k+4>>2]|0)+(((c[l>>2]|0)-(c[k>>2]|0)|0)*1e6|0)}c[5648]=0;kb(l|0,0)|0;fs(15750);if(e){g[b+268>>2]=f;j=+g[b+264>>2]+d;g[b+264>>2]=j;if(!(j>=f)){d=f;k=0}else{g[b+264>>2]=j-+(~~(j/f)|0)*f;d=f;k=~~(j/f)}}else{g[b+264>>2]=a[b+300>>0]|0?0.0:d;g[b+268>>2]=0.0;k=!(+N(+d)<1.1920928955078125e-07)&1;e=k}if(vb[c[(c[b>>2]|0)+20>>2]&127](b)|0){h=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;a[23328]=(vb[c[(c[h>>2]|0)+56>>2]&127](h)|0)>>>4&1}if(k){e=(k|0)>(e|0)?e:k;qb[c[(c[b>>2]|0)+164>>2]&31](b,d*+(e|0));rb[c[(c[b>>2]|0)+172>>2]&255](b);if((e|0)>0){h=0;do{qb[c[(c[b>>2]|0)+160>>2]&31](b,d);rb[c[(c[b>>2]|0)+80>>2]&255](b);h=h+1|0}while((h|0)<(e|0));e=b}else e=b}else{rb[c[(c[b>>2]|0)+80>>2]&255](b);e=b}rb[c[(c[e>>2]|0)+120>>2]&255](b);c[5648]=(c[5648]|0)+1;e=c[2006]|0;b=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=b;if(b|0){i=l;return k|0}do if(c[e+4>>2]|0){kb(l|0,0)|0;b=c[5649]|0;g[e+8>>2]=+g[e+8>>2]+ +(((c[l+4>>2]|0)-(c[b+4>>2]|0)+(((c[l>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[e+16>>2]|0)){e=c[2006]|0;break}else{i=l;return k|0}}while(0);c[2006]=c[e+20>>2];i=l;return k|0}function Jq(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;f=c[b+212>>2]|0;if((f|0)==(c[b+216>>2]|0)?(i=f|0?f<<1:1,(f|0)<(i|0)):0){if(!i)h=0;else{c[5637]=(c[5637]|0)+1;f=qG((i<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}h=f;f=c[b+212>>2]|0}if((f|0)>0){g=0;do{c[h+(g<<2)>>2]=c[(c[b+220>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}g=c[b+220>>2]|0;if(g){if(a[b+224>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[g+-4>>2]|0);f=c[b+212>>2]|0}c[b+220>>2]=0}a[b+224>>0]=1;c[b+220>>2]=h;c[b+216>>2]=i}c[(c[b+220>>2]|0)+(f<<2)>>2]=d;c[b+212>>2]=f+1;if(!e)return;Fr(c[d+28>>2]|0,d);Fr(c[d+32>>2]|0,d);return}function Kq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;f=c[a+212>>2]|0;a:do if((f|0)>0){g=c[a+220>>2]|0;d=0;while(1){e=g+(d<<2)|0;if((c[e>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(f|0))break a}if((d|0)<(f|0)){c[e>>2]=c[g+(f+-1<<2)>>2];c[(c[a+220>>2]|0)+(f+-1<<2)>>2]=b;c[a+212>>2]=f+-1}}while(0);Gr(c[b+28>>2]|0,b);Gr(c[b+32>>2]|0,b);return}function Lq(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[b+280>>2]|0;if((e|0)==(c[b+284>>2]|0)?(h=e|0?e<<1:1,(e|0)<(h|0)):0){if(!h)g=0;else{c[5637]=(c[5637]|0)+1;e=qG((h<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}g=e;e=c[b+280>>2]|0}if((e|0)>0){f=0;do{c[g+(f<<2)>>2]=c[(c[b+288>>2]|0)+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}f=c[b+288>>2]|0;if(f){if(a[b+292>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0);e=c[b+280>>2]|0}c[b+288>>2]=0}a[b+292>>0]=1;c[b+288>>2]=g;c[b+284>>2]=h}c[(c[b+288>>2]|0)+(e<<2)>>2]=d;c[b+280>>2]=e+1;return}function Mq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;f=c[a+280>>2]|0;if((f|0)<=0)return;g=c[a+288>>2]|0;d=0;while(1){e=g+(d<<2)|0;if((c[e>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(f|0)){h=7;break}}if((h|0)==7)return;if((d|0)>=(f|0))return;c[e>>2]=c[g+(f+-1<<2)>>2];c[(c[a+288>>2]|0)+(f+-1<<2)>>2]=b;c[a+280>>2]=f+-1;return}function Nq(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0,h=0,i=0.0,j=0.0;c[a+248>>2]=c[b>>2];c[a+248+4>>2]=c[b+4>>2];c[a+248+8>>2]=c[b+8>>2];c[a+248+12>>2]=c[b+12>>2];d=c[a+232>>2]|0;if((d|0)<=0)return;h=0;do{f=c[(c[a+240>>2]|0)+(h<<2)>>2]|0;switch(c[f+216>>2]|0){case 2:case 5:break;default:if(!(c[f+528>>2]&1)){e=+g[f+368>>2];if(e!=0.0){j=1.0/e*+g[b+4>>2];i=1.0/e*+g[b+8>>2];g[f+388>>2]=1.0/e*+g[b>>2];g[f+392>>2]=j;g[f+396>>2]=i;g[f+400>>2]=0.0}c[f+404>>2]=c[b>>2];c[f+404+4>>2]=c[b+4>>2];c[f+404+8>>2]=c[b+8>>2];c[f+404+12>>2]=c[b+12>>2];d=c[a+232>>2]|0}}h=h+1|0}while((h|0)<(d|0));return}function Oq(a,b){a=a|0;b=b|0;c[a>>2]=c[b+248>>2];c[a+4>>2]=c[b+248+4>>2];c[a+8>>2]=c[b+248+8>>2];c[a+12>>2]=c[b+248+12>>2];return}function Pq(b){b=b|0;var d=0,e=0.0,f=0,h=0,j=0.0,k=0.0,l=0;l=i;i=i+64|0;fs(15765);a:do if(!(a[b+274>>0]|0)){d=c[b+232>>2]|0;if((d|0)>0){h=0;while(1){f=c[(c[b+240>>2]|0)+(h<<2)>>2]|0;switch(c[f+216>>2]|0){case 2:case 5:break;default:if((c[f+504>>2]|0)!=0?(c[f+204>>2]&3|0)==0:0){if((a[b+300>>0]|0)!=0?(k=+g[b+268>>2],k!=0.0):0)e=+g[b+264>>2]-k;else e=+g[b+264>>2]*+g[f+248>>2];xn(f+68|0,+g[f+132>>2],+g[f+136>>2],+g[f+140>>2],f+148|0,e,l);d=c[f+504>>2]|0;tb[c[(c[d>>2]|0)+12>>2]&127](d,l);d=c[b+232>>2]|0}}h=h+1|0;if((h|0)>=(d|0))break a}}}else{d=c[b+8>>2]|0;if((d|0)>0){h=0;do{f=c[(c[b+16>>2]|0)+(h<<2)>>2]|0;if((!((f|0)==0?1:(c[f+236>>2]&2|0)==0)?(c[f+504>>2]|0)!=0:0)?(c[f+204>>2]&3|0)==0:0){if((a[b+300>>0]|0)!=0?(j=+g[b+268>>2],j!=0.0):0)e=+g[b+264>>2]-j;else e=+g[b+264>>2]*+g[f+248>>2];xn(f+68|0,+g[f+132>>2],+g[f+136>>2],+g[f+140>>2],f+148|0,e,l);d=c[f+504>>2]|0;tb[c[(c[d>>2]|0)+12>>2]&127](d,l);d=c[b+8>>2]|0}h=h+1|0}while((h|0)<(d|0))}}while(0);d=c[2006]|0;b=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=b;if(b|0){i=l;return}do if(c[d+4>>2]|0){kb(l|0,0)|0;b=c[5649]|0;g[d+8>>2]=+g[d+8>>2]+ +(((c[l+4>>2]|0)-(c[b+4>>2]|0)+(((c[l>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[d+16>>2]|0)){d=c[2006]|0;break}else{i=l;return}}while(0);c[2006]=c[d+20>>2];i=l;return}function Qq(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,i=0,j=0,k=0.0,l=0.0;e=c[d+204>>2]|0;if((e&3|0)==0?(c[d+528>>2]&1|0)==0:0){h=+g[d+368>>2];if(h!=0.0){l=1.0/h*+g[b+252>>2];k=1.0/h*+g[b+256>>2];g[d+388>>2]=1.0/h*+g[b+248>>2];g[d+392>>2]=l;g[d+396>>2]=k;g[d+400>>2]=0.0}c[d+404>>2]=c[b+248>>2];c[d+404+4>>2]=c[b+248+4>>2];c[d+404+8>>2]=c[b+248+8>>2];c[d+404+12>>2]=c[b+248+12>>2]}if(!(c[d+192>>2]|0))return;if(e&1){if((c[d+216>>2]&-2|0)!=4)c[d+216>>2]=2}else{f=c[b+232>>2]|0;if((f|0)==(c[b+236>>2]|0)?(j=f|0?f<<1:1,(f|0)<(j|0)):0){if(!j)e=0;else{c[5637]=(c[5637]|0)+1;e=qG((j<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[b+232>>2]|0}if((f|0)>0){i=0;do{c[e+(i<<2)>>2]=c[(c[b+240>>2]|0)+(i<<2)>>2];i=i+1|0}while((i|0)!=(f|0))}i=c[b+240>>2]|0;if(i){if(a[b+244>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[i+-4>>2]|0);f=c[b+232>>2]|0}c[b+240>>2]=0}a[b+244>>0]=1;c[b+240>>2]=e;c[b+236>>2]=j;e=c[d+204>>2]|0}c[(c[b+240>>2]|0)+(f<<2)>>2]=d;c[b+232>>2]=f+1}j=(e&3|0)==0;bc[c[(c[b>>2]|0)+36>>2]&127](b,d,j?1:2,j?-1:-3);return}function Rq(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0.0,j=0,k=0,l=0,m=0.0,n=0.0;h=c[d+204>>2]|0;if((h&3|0)==0?(c[d+528>>2]&1|0)==0:0){i=+g[d+368>>2];if(i!=0.0){n=1.0/i*+g[b+252>>2];m=1.0/i*+g[b+256>>2];g[d+388>>2]=1.0/i*+g[b+248>>2];g[d+392>>2]=n;g[d+396>>2]=m;g[d+400>>2]=0.0}c[d+404>>2]=c[b+248>>2];c[d+404+4>>2]=c[b+248+4>>2];c[d+404+8>>2]=c[b+248+8>>2];c[d+404+12>>2]=c[b+248+12>>2]}if(!(c[d+192>>2]|0))return;if(h&1){if((c[d+216>>2]&-2|0)!=4)c[d+216>>2]=2}else{h=c[b+232>>2]|0;if((h|0)==(c[b+236>>2]|0)?(l=h|0?h<<1:1,(h|0)<(l|0)):0){if(!l)k=0;else{c[5637]=(c[5637]|0)+1;h=qG((l<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}k=h;h=c[b+232>>2]|0}if((h|0)>0){j=0;do{c[k+(j<<2)>>2]=c[(c[b+240>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[b+240>>2]|0;if(j){if(a[b+244>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0);h=c[b+232>>2]|0}c[b+240>>2]=0}a[b+244>>0]=1;c[b+240>>2]=k;c[b+236>>2]=l}c[(c[b+240>>2]|0)+(h<<2)>>2]=d;c[b+232>>2]=h+1}bc[c[(c[b>>2]|0)+36>>2]&127](b,d,e,f);return}function Sq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;f=c[a+232>>2]|0;a:do if((f|0)>0){g=c[a+240>>2]|0;d=0;while(1){e=g+(d<<2)|0;if((c[e>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(f|0))break a}if((d|0)<(f|0)){c[e>>2]=c[g+(f+-1<<2)>>2];c[(c[a+240>>2]|0)+(f+-1<<2)>>2]=b;c[a+232>>2]=f+-1}}while(0);d=c[b+188>>2]|0;if(d|0){g=c[a+68>>2]|0;g=vb[c[(c[g>>2]|0)+36>>2]&127](g)|0;Zb[c[(c[g>>2]|0)+40>>2]&127](g,d,c[a+24>>2]|0);g=c[a+68>>2]|0;Zb[c[(c[g>>2]|0)+12>>2]&127](g,d,c[a+24>>2]|0);c[b+188>>2]=0}f=c[a+8>>2]|0;if((f|0)<=0)return;g=c[a+16>>2]|0;d=0;while(1){e=g+(d<<2)|0;if((c[e>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(f|0)){h=15;break}}if((h|0)==15)return;if((d|0)>=(f|0))return;c[e>>2]=c[g+(f+-1<<2)>>2];c[(c[a+16>>2]|0)+(f+-1<<2)>>2]=b;c[a+8>>2]=f+-1;return}function Tq(b,d){b=b|0;d=d|0;var e=0;if(a[b+273>>0]|0?(e=c[b+200>>2]|0,e|0):0){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0)}a[b+273>>0]=0;c[b+200>>2]=d;c[(c[b+196>>2]|0)+8>>2]=d;return}function Uq(a){a=a|0;return c[a+200>>2]|0}function Vq(a){a=a|0;return c[a+212>>2]|0}function Wq(a,b){a=a|0;b=b|0;return c[(c[a+220>>2]|0)+(b<<2)>>2]|0}function Xq(a,b){a=a|0;b=b|0;return c[(c[a+220>>2]|0)+(b<<2)>>2]|0}function Yq(a){a=a|0;return 2}function Zq(a){a=a|0;var b=0,d=0;if((c[a+232>>2]|0)<=0)return;b=0;do{d=(c[(c[a+240>>2]|0)+(b<<2)>>2]|0)+436|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;b=b+1|0}while((b|0)<(c[a+232>>2]|0));return}function _q(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+64>>2]&127](a,b);return}function $q(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+68>>2]&127](a,b);return}function ar(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+64>>2]&127](a,b);return}function br(a,b){a=a|0;b=b|0;tb[c[(c[a>>2]|0)+68>>2]&127](a,b);return}function cr(a,b){a=a|0;b=+b;var d=0,e=0,f=0,h=0;h=i;i=i+16|0;fs(15789);d=c[a+232>>2]|0;if((d|0)>0){f=0;do{e=c[(c[a+240>>2]|0)+(f<<2)>>2]|0;if(!(c[e+204>>2]&3)){Dr(e,b);xn(e+4|0,+g[e+336>>2],+g[e+340>>2],+g[e+344>>2],e+352|0,b,e+68|0);d=c[a+232>>2]|0}f=f+1|0}while((f|0)<(d|0))}d=c[2006]|0;a=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=a;if(a|0){i=h;return}do if(c[d+4>>2]|0){kb(h|0,0)|0;a=c[5649]|0;g[d+8>>2]=+g[d+8>>2]+ +(((c[h+4>>2]|0)-(c[a+4>>2]|0)+(((c[h>>2]|0)-(c[a>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[d+16>>2]|0)){d=c[2006]|0;break}else{i=h;return}}while(0);c[2006]=c[d+20>>2];i=h;return}function dr(d,e){d=d|0;e=+e;var f=0,h=0.0,j=0,k=0.0,l=0.0,m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0,t=0.0,u=0;s=i;i=i+304|0;fs(15815);a:do if((c[d+232>>2]|0)>0){n=s+136+48|0;o=0;while(1){m=c[(c[d+240>>2]|0)+(o<<2)>>2]|0;g[m+248>>2]=1.0;b:do switch(c[m+216>>2]|0){case 2:case 5:break;default:if(!(c[m+204>>2]&3)){xn(m+4|0,+g[m+336>>2],+g[m+340>>2],+g[m+344>>2],m+352|0,e,s+136|0);h=+g[n>>2]-+g[m+52>>2];k=+g[s+136+52>>2]-+g[m+56>>2];l=+g[s+136+56>>2]-+g[m+60>>2];if(a[d+44>>0]|0?(t=+g[m+256>>2],t*t!=0.0?t*t<h*h+k*k+l*l:0):0){fs(15835);if((c[(c[m+192>>2]|0)+4>>2]|0)<20){c[5475]=(c[5475]|0)+1;f=c[d+68>>2]|0;f=vb[c[(c[f>>2]|0)+36>>2]&127](f)|0;j=c[d+24>>2]|0;g[s+200+4>>2]=1.0;b[s+200+8>>1]=1;b[s+200+10>>1]=-1;c[s+200>>2]=7848;c[s+200+12>>2]=c[m+52>>2];c[s+200+12+4>>2]=c[m+52+4>>2];c[s+200+12+8>>2]=c[m+52+8>>2];c[s+200+12+12>>2]=c[m+52+12>>2];c[s+200+28>>2]=c[n>>2];c[s+200+28+4>>2]=c[n+4>>2];c[s+200+28+8>>2]=c[n+8>>2];c[s+200+28+12>>2]=c[n+12>>2];c[s+200+76>>2]=0;c[s+200>>2]=7872;c[s+200+80>>2]=m;c[s+200+88>>2]=f;c[s+200+92>>2]=j;j=c[m+252>>2]|0;c[s+64+8>>2]=0;c[s+64+12>>2]=-1;c[s+64+16>>2]=1065353216;c[s+64+20>>2]=1065353216;c[s+64+24>>2]=1065353216;g[s+64+28>>2]=0.0;c[s+64>>2]=6380;c[s+64+4>>2]=8;c[s+64+32>>2]=j;c[s+64+48>>2]=j;c[s+200+84>>2]=c[d+56>>2];j=c[(c[m+188>>2]|0)+4>>2]|0;b[s+200+8>>1]=j;b[s+200+10>>1]=j>>>16;c[s+48>>2]=c[n>>2];c[s+48+4>>2]=c[n+4>>2];c[s+48+8>>2]=c[n+8>>2];c[s+48+12>>2]=c[n+12>>2];c[s>>2]=c[m+4>>2];c[s+4>>2]=c[m+4+4>>2];c[s+8>>2]=c[m+4+8>>2];c[s+12>>2]=c[m+4+12>>2];c[s+16>>2]=c[m+20>>2];c[s+16+4>>2]=c[m+20+4>>2];c[s+16+8>>2]=c[m+20+8>>2];c[s+16+12>>2]=c[m+20+12>>2];c[s+32>>2]=c[m+36>>2];c[s+32+4>>2]=c[m+36+4>>2];c[s+32+8>>2]=c[m+36+8>>2];c[s+32+12>>2]=c[m+36+12>>2];Yf(d,s+64|0,m+4|0,s,s+200|0,0.0);h=+g[s+200+4>>2];if(h<1.0){g[m+248>>2]=h;xn(m+4|0,+g[m+336>>2],+g[m+340>>2],+g[m+344>>2],m+352|0,h*e,s+136|0);g[m+248>>2]=0.0;Er(m,s+136|0);f=4}else f=0;if(!f)p=12}else p=12;if((p|0)==12){p=0;f=0}j=c[2006]|0;u=(c[j+16>>2]|0)+-1|0;c[j+16>>2]=u;do if(!u){if(c[j+4>>2]|0){kb(s+200|0,0)|0;u=c[5649]|0;g[j+8>>2]=+g[j+8>>2]+ +(((c[s+200+4>>2]|0)-(c[u+4>>2]|0)+(((c[s+200>>2]|0)-(c[u>>2]|0)|0)*1e6|0)-(c[j+12>>2]|0)|0)>>>0)/1.0e3;if(c[j+16>>2]|0)break;j=c[2006]|0}c[2006]=c[j+20>>2]}while(0);if(f|0)break b}Er(m,s+136|0)}}while(0);o=o+1|0;if((o|0)>=(c[d+232>>2]|0))break a}}while(0);do if(a[d+275>>0]|0){fs(15892);if((c[d+308>>2]|0)>0){p=0;do{o=c[(c[d+316>>2]|0)+(p<<2)>>2]|0;m=c[o+740>>2]|0;m=(c[m+236>>2]&2|0)==0?0:m;n=c[o+744>>2]|0;n=(c[n+236>>2]&2|0)==0?0:n;f=c[o+748>>2]|0;if((f|0)>0)if(!m){j=0;do{h=+g[57]*+g[n+228>>2];if(h>0.0?(q=+g[o+4+(j*184|0)+120>>2],q!=0.0):0){l=h*(+g[o+4+(j*184|0)+64>>2]*q);e=h*(+g[o+4+(j*184|0)+68>>2]*q);t=h*(+g[o+4+(j*184|0)+72>>2]*q);h=+g[o+4+(j*184|0)+36>>2]-+g[n+56>>2];k=+g[o+4+(j*184|0)+40>>2]-+g[n+60>>2];g[s>>2]=+g[o+4+(j*184|0)+32>>2]-+g[n+52>>2];g[s+4>>2]=h;g[s+8>>2]=k;g[s+12>>2]=0.0;g[s+120>>2]=l;g[s+120+4>>2]=e;g[s+120+8>>2]=t;g[s+120+12>>2]=0.0;Uo(n,s+120|0,s);f=c[o+748>>2]|0}j=j+1|0}while((j|0)<(f|0))}else{j=0;do{h=+g[m+228>>2]*+g[n+228>>2];if(h>0.0?(r=+g[o+4+(j*184|0)+120>>2],r!=0.0):0){l=h*(+g[o+4+(j*184|0)+64>>2]*r);e=h*(+g[o+4+(j*184|0)+68>>2]*r);t=h*(+g[o+4+(j*184|0)+72>>2]*r);g[s+200>>2]=-l;g[s+200+4>>2]=-e;g[s+200+8>>2]=-t;g[s+200+12>>2]=0.0;k=+g[o+4+(j*184|0)+52>>2]-+g[m+56>>2];h=+g[o+4+(j*184|0)+56>>2]-+g[m+60>>2];g[s+64>>2]=+g[o+4+(j*184|0)+48>>2]-+g[m+52>>2];g[s+64+4>>2]=k;g[s+64+8>>2]=h;g[s+64+12>>2]=0.0;h=+g[o+4+(j*184|0)+36>>2]-+g[n+56>>2];k=+g[o+4+(j*184|0)+40>>2]-+g[n+60>>2];g[s>>2]=+g[o+4+(j*184|0)+32>>2]-+g[n+52>>2];g[s+4>>2]=h;g[s+8>>2]=k;g[s+12>>2]=0.0;Uo(m,s+200|0,s+64|0);g[s+120>>2]=l;g[s+120+4>>2]=e;g[s+120+8>>2]=t;g[s+120+12>>2]=0.0;Uo(n,s+120|0,s);f=c[o+748>>2]|0}j=j+1|0}while((j|0)<(f|0))}p=p+1|0}while((p|0)<(c[d+308>>2]|0))}f=c[2006]|0;u=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=u;if(!u){if(c[f+4>>2]|0){kb(s+200|0,0)|0;u=c[5649]|0;g[f+8>>2]=+g[f+8>>2]+ +(((c[s+200+4>>2]|0)-(c[u+4>>2]|0)+(((c[s+200>>2]|0)-(c[u>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3;if(c[f+16>>2]|0)break;f=c[2006]|0}c[2006]=c[f+20>>2]}}while(0);f=c[2006]|0;u=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=u;if(u|0){i=s;return}do if(c[f+4>>2]|0){kb(s+200|0,0)|0;u=c[5649]|0;g[f+8>>2]=+g[f+8>>2]+ +(((c[s+200+4>>2]|0)-(c[u+4>>2]|0)+(((c[s+200>>2]|0)-(c[u>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[f+16>>2]|0)){f=c[2006]|0;break}else{i=s;return}}while(0);c[2006]=c[f+20>>2];i=s;return}function er(a){a=a|0;rG(a);return}function fr(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;c[a+4>>2]=c[b+40>>2];e=c[b>>2]|0;c[a+76>>2]=e;if(d){c[a+44>>2]=c[b+8>>2];c[a+44+4>>2]=c[b+8+4>>2];c[a+44+8>>2]=c[b+8+8>>2];c[a+44+12>>2]=c[b+8+12>>2];a=a+60|0;d=b+24|0;c[a>>2]=c[d>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];f=+g[b+40>>2];return +f}else{k=+g[b+8>>2];j=+g[b+12>>2];i=+g[b+16>>2];h=k*+g[e+20>>2]+j*+g[e+24>>2]+i*+g[e+28>>2];f=k*+g[e+36>>2]+j*+g[e+40>>2]+i*+g[e+44>>2];g[a+44>>2]=+g[e+4>>2]*k+ +g[e+8>>2]*j+ +g[e+12>>2]*i;g[a+48>>2]=h;g[a+52>>2]=f;g[a+56>>2]=0.0;a=a+60|0;d=b+24|0;c[a>>2]=c[d>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];f=+g[b+40>>2];return +f}return 0.0}function gr(a){a=a|0;rG(a);return}function hr(a,d){a=a|0;d=d|0;var e=0,f=0;e=c[d>>2]|0;f=c[a+80>>2]|0;if((e|0)==(f|0)){a=0;return a|0}d=c[d+4>>2]|0;if(!((b[a+10>>1]&(d&65535))<<16>>16)){a=0;return a|0}if(!((b[a+8>>1]&(d>>>16&65535))<<16>>16)){a=0;return a|0}a=c[a+92>>2]|0;a=Eb[c[(c[a>>2]|0)+28>>2]&63](a,f,e)|0;return a|0}function ir(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;e=c[b>>2]|0;if((e|0)==(c[a+80>>2]|0)){f=1.0;return +f}if(c[e+204>>2]&4|0){f=1.0;return +f}if((+g[a+28>>2]-+g[a+12>>2])*+g[b+8>>2]+(+g[a+32>>2]-+g[a+16>>2])*+g[b+12>>2]+(+g[a+36>>2]-+g[a+20>>2])*+g[b+16>>2]>=-+g[a+84>>2]){f=1.0;return +f}c[a+4>>2]=c[b+40>>2];c[a+76>>2]=e;if(d){c[a+44>>2]=c[b+8>>2];c[a+44+4>>2]=c[b+8+4>>2];c[a+44+8>>2]=c[b+8+8>>2];c[a+44+12>>2]=c[b+8+12>>2]}else{k=+g[b+8>>2];j=+g[b+12>>2];i=+g[b+16>>2];h=k*+g[e+20>>2]+j*+g[e+24>>2]+i*+g[e+28>>2];f=k*+g[e+36>>2]+j*+g[e+40>>2]+i*+g[e+44>>2];g[a+44>>2]=+g[e+4>>2]*k+ +g[e+8>>2]*j+ +g[e+12>>2]*i;g[a+48>>2]=h;g[a+52>>2]=f;g[a+56>>2]=0.0}c[a+60>>2]=c[b+24>>2];c[a+60+4>>2]=c[b+24+4>>2];c[a+60+8>>2]=c[b+24+8>>2];c[a+60+12>>2]=c[b+24+12>>2];k=+g[b+40>>2];return +k}function jr(b){b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+16|0;fs(16195);l=c[b+204>>2]|0;Zb[c[(c[l>>2]|0)+8>>2]&127](l,b,c[b+24>>2]|0);l=c[b+308>>2]|0;if((l|0)>0){k=c[b+316>>2]|0;m=0;do{e=c[k+(m<<2)>>2]|0;d=c[e+740>>2]|0;e=c[e+744>>2]|0;if((d|0?(e|0?(c[d+204>>2]&3|0)==0:0):0)?(c[e+204>>2]&3|0)==0:0){h=c[d+208>>2]|0;d=c[e+208>>2]|0;j=c[(c[b+204>>2]|0)+16>>2]|0;e=c[j+(h<<3)>>2]|0;if((e|0)!=(h|0)){f=j+(h<<3)|0;do{h=j+(e<<3)|0;c[f>>2]=c[h>>2];h=c[h>>2]|0;f=j+(h<<3)|0;e=c[f>>2]|0}while((h|0)!=(e|0))}e=c[j+(d<<3)>>2]|0;if((e|0)!=(d|0)){f=j+(d<<3)|0;do{d=j+(e<<3)|0;c[f>>2]=c[d>>2];d=c[d>>2]|0;f=j+(d<<3)|0;e=c[f>>2]|0}while((d|0)!=(e|0))}if((h|0)!=(d|0)){c[j+(h<<3)>>2]=d;f=j+(d<<3)+4|0;c[f>>2]=(c[f>>2]|0)+(c[j+(h<<3)+4>>2]|0)}}m=m+1|0}while((m|0)!=(l|0))}l=c[b+212>>2]|0;if((l|0)>0){k=c[b+220>>2]|0;m=0;do{d=c[k+(m<<2)>>2]|0;if((a[d+20>>0]|0?(n=c[d+28>>2]|0,(c[n+204>>2]&3|0)==0):0)?(o=c[d+32>>2]|0,(c[o+204>>2]&3|0)==0):0){f=c[n+208>>2]|0;d=c[o+208>>2]|0;j=c[(c[b+204>>2]|0)+16>>2]|0;e=c[j+(f<<3)>>2]|0;if((e|0)==(f|0))h=f;else{f=j+(f<<3)|0;do{h=j+(e<<3)|0;c[f>>2]=c[h>>2];h=c[h>>2]|0;f=j+(h<<3)|0;e=c[f>>2]|0}while((h|0)!=(e|0))}e=c[j+(d<<3)>>2]|0;if((e|0)!=(d|0)){f=j+(d<<3)|0;do{d=j+(e<<3)|0;c[f>>2]=c[d>>2];d=c[d>>2]|0;f=j+(d<<3)|0;e=c[f>>2]|0}while((d|0)!=(e|0))}if((h|0)!=(d|0)){c[j+(h<<3)>>2]=d;f=j+(d<<3)+4|0;c[f>>2]=(c[f>>2]|0)+(c[j+(h<<3)+4>>2]|0)}}m=m+1|0}while((m|0)!=(l|0))}d=c[b+204>>2]|0;tb[c[(c[d>>2]|0)+12>>2]&127](d,b);d=c[2006]|0;b=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=b;if(b|0){i=p;return}do if(c[d+4>>2]|0){kb(p|0,0)|0;b=c[5649]|0;g[d+8>>2]=+g[d+8>>2]+ +(((c[p+4>>2]|0)-(c[b+4>>2]|0)+(((c[p>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[d+16>>2]|0)){d=c[2006]|0;break}else{i=p;return}}while(0);c[2006]=c[d+20>>2];i=p;return}function kr(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0;l=i;i=i+16|0;fs(16222);k=c[b+212>>2]|0;j=c[b+180>>2]|0;if((j|0)<(k|0)){if((c[b+184>>2]|0)<(k|0)){if(!k){e=0;f=j}else{c[5637]=(c[5637]|0)+1;e=qG((k<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[b+180>>2]|0}if((f|0)>0){h=0;do{c[e+(h<<2)>>2]=c[(c[b+188>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(f|0))}f=c[b+188>>2]|0;if(f|0){if(a[b+192>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[b+188>>2]=0}a[b+192>>0]=1;c[b+188>>2]=e;c[b+184>>2]=k;f=b+188|0}else f=b+188|0;e=j;do{c[(c[f>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=(k|0))}else f=b+188|0;c[b+180>>2]=k;e=0;while(1){if((e|0)>=(vb[c[(c[b>>2]|0)+104>>2]&127](b)|0))break;c[(c[f>>2]|0)+(e<<2)>>2]=c[(c[b+220>>2]|0)+(e<<2)>>2];e=e+1|0}e=c[b+180>>2]|0;if((e|0)>1)lr(b+176|0,0,e+-1|0);if(!(vb[c[(c[b>>2]|0)+104>>2]&127](b)|0))e=0;else e=c[f>>2]|0;h=c[b+196>>2]|0;j=c[b+180>>2]|0;k=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;c[h+4>>2]=d;c[h+12>>2]=e;c[h+16>>2]=j;c[h+20>>2]=k;e=c[h+32>>2]|0;if((e|0)<0){if((c[h+36>>2]|0)<0){f=c[h+40>>2]|0;if(f|0){if(a[h+44>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[h+40>>2]=0}a[h+44>>0]=1;c[h+40>>2]=0;c[h+36>>2]=0}do{c[(c[h+40>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=0)}c[h+32>>2]=0;e=c[h+52>>2]|0;if((e|0)<0){if((c[h+56>>2]|0)<0){f=c[h+60>>2]|0;if(f|0){if(a[h+64>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[h+60>>2]=0}a[h+64>>0]=1;c[h+60>>2]=0;c[h+56>>2]=0}do{c[(c[h+60>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=0)}c[h+52>>2]=0;e=c[h+72>>2]|0;if((e|0)<0){if((c[h+76>>2]|0)<0){f=c[h+80>>2]|0;if(f|0){if(a[h+84>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[h+80>>2]=0}a[h+84>>0]=1;c[h+80>>2]=0;c[h+76>>2]=0}do{c[(c[h+80>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=0)}c[h+72>>2]=0;j=c[b+200>>2]|0;h=c[(c[j>>2]|0)+8>>2]|0;k=c[b+8>>2]|0;e=c[b+24>>2]|0;e=vb[c[(c[e>>2]|0)+36>>2]&127](e)|0;Zb[h&127](j,k,e);Di(c[b+204>>2]|0,c[b+24>>2]|0,b,c[b+196>>2]|0);mr(c[b+196>>2]|0);e=c[b+200>>2]|0;Zb[c[(c[e>>2]|0)+16>>2]&127](e,d,c[b+72>>2]|0);e=c[2006]|0;b=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=b;if(b|0){i=l;return}do if(c[e+4>>2]|0){kb(l|0,0)|0;b=c[5649]|0;g[e+8>>2]=+g[e+8>>2]+ +(((c[l+4>>2]|0)-(c[b+4>>2]|0)+(((c[l>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[e+16>>2]|0)){e=c[2006]|0;break}else{i=l;return}}while(0);c[2006]=c[e+20>>2];i=l;return}function lr(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;while(1){k=c[a+12>>2]|0;l=c[k+(((b+d|0)/2|0)<<2)>>2]|0;e=b;f=d;while(1){j=c[(c[l+28>>2]|0)+208>>2]|0;if((j|0)>-1)while(1){h=c[k+(e<<2)>>2]|0;g=c[(c[h+28>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+32>>2]|0)+208>>2]|0;if((g|0)<(j|0))e=e+1|0;else break}else{i=c[(c[l+32>>2]|0)+208>>2]|0;while(1){h=c[k+(e<<2)>>2]|0;g=c[(c[h+28>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+32>>2]|0)+208>>2]|0;if((g|0)<(i|0))e=e+1|0;else break}}if((j|0)>-1)while(1){h=c[k+(f<<2)>>2]|0;g=c[(c[h+28>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+32>>2]|0)+208>>2]|0;if((j|0)<(g|0))f=f+-1|0;else break}else{i=c[(c[l+32>>2]|0)+208>>2]|0;while(1){h=c[k+(f<<2)>>2]|0;g=c[(c[h+28>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+32>>2]|0)+208>>2]|0;if((i|0)<(g|0))f=f+-1|0;else break}}if((e|0)<=(f|0)){i=k+(e<<2)|0;j=c[i>>2]|0;c[i>>2]=c[k+(f<<2)>>2];c[(c[a+12>>2]|0)+(f<<2)>>2]=j;e=e+1|0;f=f+-1|0}if((e|0)>(f|0))break;k=c[a+12>>2]|0}if((f|0)>(b|0))lr(a,b,f);if((e|0)<(d|0))b=e;else break}return}function mr(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;d=c[b+32>>2]|0;if(!d)f=0;else f=c[b+40>>2]|0;i=c[b+52>>2]|0;if(!i)g=0;else g=c[b+60>>2]|0;e=c[b+72>>2]|0;if(!e)h=0;else h=c[b+80>>2]|0;j=c[b+8>>2]|0;+Qb[c[(c[j>>2]|0)+12>>2]&3](j,f,d,g,i,h,e,c[b+4>>2]|0,c[b+20>>2]|0,c[b+24>>2]|0);d=c[b+32>>2]|0;if((d|0)<0){if((c[b+36>>2]|0)<0){e=c[b+40>>2]|0;if(e|0){if(a[b+44>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0)}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=0;c[b+36>>2]=0}do{c[(c[b+40>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=0)}c[b+32>>2]=0;d=c[b+52>>2]|0;if((d|0)<0){if((c[b+56>>2]|0)<0){e=c[b+60>>2]|0;if(e|0){if(a[b+64>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+56>>2]=0}do{c[(c[b+60>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=0)}c[b+52>>2]=0;d=c[b+72>>2]|0;if((d|0)>=0){c[b+72>>2]=0;return}if((c[b+76>>2]|0)<0){e=c[b+80>>2]|0;if(e|0){if(a[b+84>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0)}c[b+80>>2]=0}a[b+84>>0]=1;c[b+80>>2]=0;c[b+76>>2]=0}do{c[(c[b+80>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=0);c[b+72>>2]=0;return}function nr(b,d){b=b|0;d=+d;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0;m=i;i=i+16|0;fs(15930);e=c[b+232>>2]|0;if((e|0)>0){l=(a[23328]|0)==0;k=0;do{j=c[(c[b+240>>2]|0)+(k<<2)>>2]|0;a:do if(j){f=c[j+216>>2]|0;b:do switch(f|0){case 4:case 2:{if((f|0)==4)break a;break}default:{q=+g[j+336>>2];p=+g[j+340>>2];o=+g[j+344>>2];n=+g[j+496>>2];if(q*q+p*p+o*o<n*n?(n=+g[j+352>>2],o=+g[j+356>>2],p=+g[j+360>>2],q=+g[j+500>>2],n*n+o*o+p*p<q*q):0){g[j+220>>2]=+g[j+220>>2]+d;break b}g[j+220>>2]=0.0;if((f&-2|0)!=4){c[j+216>>2]=0;f=0}}}while(0);h=f&-2;do if(l){if((h|0)!=2?!(+g[j+220>>2]>2.0):0)break;if(c[j+204>>2]&3|0){if((h|0)==4)break a;c[j+216>>2]=2;break a}if((f|0)==1){if((h|0)==4)break a;c[j+216>>2]=3;break a}else{if((f|0)!=2)break a;e=(c[j+284>>2]|0)+2|0;c[j+352>>2]=0;c[j+352+4>>2]=0;c[j+352+8>>2]=0;c[j+352+12>>2]=0;c[j+284>>2]=e;c[j+336>>2]=0;c[j+336+4>>2]=0;c[j+336+8>>2]=0;c[j+336+12>>2]=0;e=c[b+232>>2]|0;break a}}while(0);if((h|0)!=4)c[j+216>>2]=1}while(0);k=k+1|0}while((k|0)<(e|0))}e=c[2006]|0;b=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=b;if(b|0){i=m;return}do if(c[e+4>>2]|0){kb(m|0,0)|0;b=c[5649]|0;g[e+8>>2]=+g[e+8>>2]+ +(((c[m+4>>2]|0)-(c[b+4>>2]|0)+(((c[m>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[e+16>>2]|0)){e=c[2006]|0;break}else{i=m;return}}while(0);c[2006]=c[e+20>>2];i=m;return}function or(d,e){d=d|0;e=+e;var f=0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0;B=i;i=i+464|0;fs(15952);f=c[d+84>>2]|0;if(f|0)qb[f&31](d,e);qb[c[(c[d>>2]|0)+140>>2]&31](d,e);g[d+28>>2]=e;c[d+32>>2]=0;c[d+48>>2]=vb[c[(c[d>>2]|0)+20>>2]&127](d)|0;fs(15981);fs(16006);f=c[d+316>>2]|0;if((c[d+308>>2]|0)>0){h=0;do{s=c[d+24>>2]|0;tb[c[(c[s>>2]|0)+16>>2]&127](s,c[f+(h<<2)>>2]|0);h=h+1|0;f=c[d+316>>2]|0}while((h|0)<(c[d+308>>2]|0))}if(f|0){if(a[d+320>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[d+316>>2]=0}a[d+320>>0]=1;c[d+316>>2]=0;c[d+308>>2]=0;c[d+312>>2]=0;f=c[2006]|0;s=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=s;do if(!s){if(c[f+4>>2]|0){kb(B+368|0,0)|0;s=c[5649]|0;g[f+8>>2]=+g[f+8>>2]+ +(((c[B+368+4>>2]|0)-(c[s+4>>2]|0)+(((c[B+368>>2]|0)-(c[s>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3;if(c[f+16>>2]|0)break;f=c[2006]|0}c[2006]=c[f+20>>2]}while(0);a:do if((c[d+232>>2]|0)>0){q=B+304+48|0;r=B+368+44|0;s=0;while(1){k=c[(c[d+240>>2]|0)+(s<<2)>>2]|0;g[k+248>>2]=1.0;b:do switch(c[k+216>>2]|0){case 2:case 5:break;default:if(((c[k+204>>2]&3|0)==0?(xn(k+4|0,+g[k+336>>2],+g[k+340>>2],+g[k+344>>2],k+352|0,e,B+304|0),t=+g[q>>2],u=t-+g[k+52>>2],v=+g[B+304+52>>2],w=v-+g[k+56>>2],x=+g[B+304+56>>2],y=x-+g[k+60>>2],a[d+44>>0]|0):0)?(o=+g[k+256>>2],o*o!=0.0?o*o<u*u+w*w+y*y:0):0){fs(16043);if((c[(c[k+192>>2]|0)+4>>2]|0)<20?(c[5475]=(c[5475]|0)+1,j=c[d+68>>2]|0,j=vb[c[(c[j>>2]|0)+36>>2]&127](j)|0,p=c[d+24>>2]|0,g[B+368+4>>2]=1.0,b[B+368+8>>1]=1,b[B+368+10>>1]=-1,c[B+368>>2]=7848,c[B+368+12>>2]=c[k+52>>2],c[B+368+12+4>>2]=c[k+52+4>>2],c[B+368+12+8>>2]=c[k+52+8>>2],c[B+368+12+12>>2]=c[k+52+12>>2],c[B+368+28>>2]=c[q>>2],c[B+368+28+4>>2]=c[q+4>>2],c[B+368+28+8>>2]=c[q+8>>2],c[B+368+28+12>>2]=c[q+12>>2],c[B+368+76>>2]=0,c[B+368>>2]=7872,c[B+368+80>>2]=k,c[B+368+88>>2]=j,c[B+368+92>>2]=p,p=c[k+252>>2]|0,c[B+248+8>>2]=0,c[B+248+12>>2]=-1,c[B+248+16>>2]=1065353216,c[B+248+20>>2]=1065353216,c[B+248+24>>2]=1065353216,g[B+248+28>>2]=0.0,c[B+248>>2]=6380,c[B+248+4>>2]=8,c[B+248+32>>2]=p,c[B+248+48>>2]=p,c[B+368+84>>2]=c[d+56>>2],p=c[(c[k+188>>2]|0)+4>>2]|0,b[B+368+8>>1]=p,b[B+368+10>>1]=p>>>16,c[B+184+48>>2]=c[q>>2],c[B+184+48+4>>2]=c[q+4>>2],c[B+184+48+8>>2]=c[q+8>>2],c[B+184+48+12>>2]=c[q+12>>2],c[B+184>>2]=c[k+4>>2],c[B+184+4>>2]=c[k+4+4>>2],c[B+184+8>>2]=c[k+4+8>>2],c[B+184+12>>2]=c[k+4+12>>2],c[B+184+16>>2]=c[k+20>>2],c[B+184+16+4>>2]=c[k+20+4>>2],c[B+184+16+8>>2]=c[k+20+8>>2],c[B+184+16+12>>2]=c[k+20+12>>2],c[B+184+32>>2]=c[k+36>>2],c[B+184+32+4>>2]=c[k+36+4>>2],c[B+184+32+8>>2]=c[k+36+8>>2],c[B+184+32+12>>2]=c[k+36+12>>2],Yf(d,B+248|0,k+4|0,B+184|0,B+368|0,0.0),z=+g[B+368+4>>2],z<1.0):0){l=z*(t-+g[k+52>>2]);m=z*(v-+g[k+56>>2]);n=z*(x-+g[k+60>>2]);o=-(m*+g[B+368+48>>2])-l*+g[r>>2]-n*+g[B+368+52>>2];p=c[d+24>>2]|0;p=Eb[c[(c[p>>2]|0)+12>>2]&63](p,k,c[B+368+76>>2]|0)|0;f=c[d+308>>2]|0;if((f|0)==(c[d+312>>2]|0)?(A=f|0?f<<1:1,(f|0)<(A|0)):0){if(!A)j=0;else{c[5637]=(c[5637]|0)+1;f=qG((A<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}j=f;f=c[d+308>>2]|0}if((f|0)>0){h=0;do{c[j+(h<<2)>>2]=c[(c[d+316>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(f|0))}h=c[d+316>>2]|0;if(h){if(a[d+320>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0);f=c[d+308>>2]|0}c[d+316>>2]=0}a[d+320>>0]=1;c[d+316>>2]=j;c[d+312>>2]=A}c[(c[d+316>>2]|0)+(f<<2)>>2]=p;c[d+308>>2]=f+1;l=l+ +g[k+52>>2];m=m+ +g[k+56>>2];n=n+ +g[k+60>>2];j=c[B+368+76>>2]|0;N=+g[j+4>>2];M=+g[j+20>>2];L=+g[j+36>>2];K=+g[j+8>>2];J=+g[j+24>>2];I=+g[j+40>>2];H=+g[j+12>>2];F=+g[j+28>>2];D=+g[j+44>>2];G=-+g[j+52>>2];E=-+g[j+56>>2];C=-+g[j+60>>2];c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;c[B+12>>2]=0;g[B+16>>2]=l*N+m*M+n*L+(N*G+M*E+L*C);g[B+20>>2]=l*K+m*J+n*I+(K*G+J*E+I*C);g[B+24>>2]=l*H+m*F+n*D+(H*G+F*E+D*C);g[B+28>>2]=0.0;c[B+64>>2]=c[r>>2];c[B+64+4>>2]=c[r+4>>2];c[B+64+8>>2]=c[r+8>>2];c[B+64+12>>2]=c[r+12>>2];g[B+80>>2]=o;g[B+84>>2]=0.0;g[B+88>>2]=0.0;g[B+92>>2]=0.0;c[B+112>>2]=0;a[B+116>>0]=0;c[B+120>>2]=0;c[B+120+4>>2]=0;c[B+120+8>>2]=0;c[B+120+12>>2]=0;c[B+120+16>>2]=0;c[B+120+20>>2]=0;c[B+120+24>>2]=0;c[B+120+28>>2]=0;j=Wn(p,B)|0;g[p+4+(j*184|0)+92>>2]=0.0;o=+g[k+224>>2]*+g[(c[B+368+76>>2]|0)+224>>2];o=o<-10.0?-10.0:o;g[p+4+(j*184|0)+84>>2]=o>10.0?10.0:o;c[p+4+(j*184|0)+48>>2]=c[k+52>>2];c[p+4+(j*184|0)+48+4>>2]=c[k+52+4>>2];c[p+4+(j*184|0)+48+8>>2]=c[k+52+8>>2];c[p+4+(j*184|0)+48+12>>2]=c[k+52+12>>2];g[p+4+(j*184|0)+32>>2]=l;g[p+4+(j*184|0)+36>>2]=m;g[p+4+(j*184|0)+40>>2]=n;g[p+4+(j*184|0)+44>>2]=0.0}f=c[2006]|0;p=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=p;if(!p){if(c[f+4>>2]|0){kb(B+368|0,0)|0;p=c[5649]|0;g[f+8>>2]=+g[f+8>>2]+ +(((c[B+368+4>>2]|0)-(c[p+4>>2]|0)+(((c[B+368>>2]|0)-(c[p>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3;if(c[f+16>>2]|0)break b;f=c[2006]|0}c[2006]=c[f+20>>2]}}}while(0);s=s+1|0;if((s|0)>=(c[d+232>>2]|0))break a}}while(0);f=c[2006]|0;A=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=A;do if(!A){if(c[f+4>>2]|0){kb(B+368|0,0)|0;A=c[5649]|0;g[f+8>>2]=+g[f+8>>2]+ +(((c[B+368+4>>2]|0)-(c[A+4>>2]|0)+(((c[B+368>>2]|0)-(c[A>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3;if(c[f+16>>2]|0)break;f=c[2006]|0}c[2006]=c[f+20>>2]}while(0);rb[c[(c[d>>2]|0)+44>>2]&255](d);rb[c[(c[d>>2]|0)+148>>2]&255](d);g[d+104>>2]=e;tb[c[(c[d>>2]|0)+152>>2]&127](d,d+92|0);qb[c[(c[d>>2]|0)+144>>2]&31](d,e);fs(16070);if((c[d+280>>2]|0)>0){f=0;do{A=c[(c[d+288>>2]|0)+(f<<2)>>2]|0;$b[c[(c[A>>2]|0)+8>>2]&7](A,d,e);f=f+1|0}while((f|0)<(c[d+280>>2]|0))}f=c[2006]|0;A=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=A;do if(!A){if(c[f+4>>2]|0){kb(B+368|0,0)|0;A=c[5649]|0;g[f+8>>2]=+g[f+8>>2]+ +(((c[B+368+4>>2]|0)-(c[A+4>>2]|0)+(((c[B+368>>2]|0)-(c[A>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3;if(c[f+16>>2]|0)break;f=c[2006]|0}c[2006]=c[f+20>>2]}while(0);qb[c[(c[d>>2]|0)+156>>2]&31](d,e);f=c[d+80>>2]|0;if(f|0)qb[f&31](d,e);f=c[2006]|0;d=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=d;if(d|0){i=B;return}do if(c[f+4>>2]|0){kb(B+368|0,0)|0;d=c[5649]|0;g[f+8>>2]=+g[f+8>>2]+ +(((c[B+368+4>>2]|0)-(c[d+4>>2]|0)+(((c[B+368>>2]|0)-(c[d>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[f+16>>2]|0)){f=c[2006]|0;break}else{i=B;return}}while(0);c[2006]=c[f+20>>2];i=B;return}function pr(a,b){a=a|0;b=+b;var d=0,e=0,f=0,h=0,j=0.0,k=0.0,l=0.0;h=i;i=i+32|0;d=c[a+8>>2]|0;if((d|0)<=0){i=h;return}f=0;do{e=c[(c[a+16>>2]|0)+(f<<2)>>2]|0;if((!((e|0)==0?1:(c[e+236>>2]&2|0)==0)?(c[e+216>>2]|0)!=2:0)?!(b==0.0?1:(c[e+204>>2]&2|0)==0):0){d=c[e+504>>2]|0;if(!d)d=e+4|0;else{tb[c[(c[d>>2]|0)+8>>2]&127](d,e+4|0);d=e+4|0}k=1.0/b*(+g[e+56>>2]-+g[e+120>>2]);l=1.0/b*(+g[e+60>>2]-+g[e+124>>2]);g[e+336>>2]=1.0/b*(+g[e+52>>2]-+g[e+116>>2]);g[e+340>>2]=k;g[e+344>>2]=l;g[e+348>>2]=0.0;Zf(e+68|0,d,h+8|0,h);l=+g[h>>2];k=1.0/b*(l*+g[h+8+4>>2]);j=1.0/b*(l*+g[h+8+8>>2]);g[e+352>>2]=1.0/b*(+g[h+8>>2]*l);g[e+356>>2]=k;g[e+360>>2]=j;g[e+364>>2]=0.0;c[e+132>>2]=c[e+336>>2];c[e+132+4>>2]=c[e+336+4>>2];c[e+132+8>>2]=c[e+336+8>>2];c[e+132+12>>2]=c[e+336+12>>2];c[e+148>>2]=c[e+352>>2];c[e+148+4>>2]=c[e+352+4>>2];c[e+148+8>>2]=c[e+352+8>>2];c[e+148+12>>2]=c[e+352+12>>2];c[e+68>>2]=c[d>>2];c[e+68+4>>2]=c[d+4>>2];c[e+68+8>>2]=c[d+8>>2];c[e+68+12>>2]=c[d+12>>2];c[e+84>>2]=c[e+20>>2];c[e+84+4>>2]=c[e+20+4>>2];c[e+84+8>>2]=c[e+20+8>>2];c[e+84+12>>2]=c[e+20+12>>2];c[e+100>>2]=c[e+36>>2];c[e+100+4>>2]=c[e+36+4>>2];c[e+100+8>>2]=c[e+36+8>>2];c[e+100+12>>2]=c[e+36+12>>2];c[e+116>>2]=c[e+52>>2];c[e+116+4>>2]=c[e+52+4>>2];c[e+116+8>>2]=c[e+52+8>>2];c[e+116+12>>2]=c[e+52+12>>2];d=c[a+8>>2]|0}f=f+1|0}while((f|0)<(d|0));i=h;return}function qr(b,d){b=b|0;d=d|0;var e=0.0,f=0.0,h=0,j=0,l=0,m=0.0,n=0.0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0.0,L=0,M=0.0,N=0.0,O=0.0,P=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0;L=i;i=i+384|0;C=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;C=(vb[c[(c[C>>2]|0)+56>>2]&127](C)|0)>>>11;J=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;J=(vb[c[(c[J>>2]|0)+56>>2]&127](J)|0)>>>12;K=+g[d+40>>2];if(K<=0.0){i=L;return}switch(c[d+4>>2]|0){case 3:{c[L+320>>2]=1065353216;c[L+320+4>>2]=0;c[L+320+4+4>>2]=0;c[L+320+4+8>>2]=0;c[L+320+4+12>>2]=0;c[L+320+20>>2]=1065353216;c[L+320+24>>2]=0;c[L+320+24+4>>2]=0;c[L+320+24+8>>2]=0;c[L+320+24+12>>2]=0;c[L+320+40>>2]=1065353216;J=L+320+44|0;c[J>>2]=0;c[J+4>>2]=0;c[J+8>>2]=0;c[J+12>>2]=0;c[J+16>>2]=0;B=+g[d+300>>2];A=+g[d+304>>2];z=+g[d+308>>2];J=c[d+28>>2]|0;y=B*+g[J+20>>2]+A*+g[J+24>>2]+z*+g[J+28>>2]+ +g[J+56>>2];x=B*+g[J+36>>2]+A*+g[J+40>>2]+z*+g[J+44>>2]+ +g[J+60>>2];g[L+320+48>>2]=B*+g[J+4>>2]+A*+g[J+8>>2]+z*+g[J+12>>2]+ +g[J+52>>2];g[L+320+52>>2]=y;g[L+320+56>>2]=x;g[L+320+60>>2]=0.0;J=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;$b[c[(c[J>>2]|0)+64>>2]&7](J,L+320|0,K);x=+g[d+316>>2];y=+g[d+320>>2];z=+g[d+324>>2];d=c[d+32>>2]|0;A=x*+g[d+20>>2]+y*+g[d+24>>2]+z*+g[d+28>>2]+ +g[d+56>>2];B=x*+g[d+36>>2]+y*+g[d+40>>2]+z*+g[d+44>>2]+ +g[d+60>>2];g[L+320+48>>2]=x*+g[d+4>>2]+y*+g[d+8>>2]+z*+g[d+12>>2]+ +g[d+52>>2];g[L+320+52>>2]=A;g[L+320+56>>2]=B;g[L+320+60>>2]=0.0;if(C&1|0){b=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;$b[c[(c[b>>2]|0)+64>>2]&7](b,L+320|0,K)}i=L;return}case 4:{I=c[d+28>>2]|0;M=+g[d+552>>2];U=+g[I+4>>2];e=+g[d+552+16>>2];T=+g[I+8>>2];f=+g[d+552+32>>2];S=+g[I+12>>2];m=+g[d+552+4>>2];n=+g[d+552+20>>2];s=+g[d+552+36>>2];t=+g[d+552+8>>2];v=+g[d+552+24>>2];x=+g[d+552+40>>2];P=+g[I+20>>2];O=+g[I+24>>2];N=+g[I+28>>2];u=+g[I+36>>2];w=+g[I+40>>2];y=+g[I+44>>2];W=+g[d+552+48>>2];V=+g[d+552+52>>2];B=+g[d+552+56>>2];z=+g[I+52>>2]+(U*W+T*V+S*B);A=P*W+O*V+N*B+ +g[I+56>>2];B=u*W+w*V+y*B+ +g[I+60>>2];g[L+320>>2]=M*U+e*T+f*S;g[L+320+4>>2]=U*m+T*n+S*s;g[L+320+8>>2]=U*t+T*v+S*x;g[L+320+12>>2]=0.0;g[L+320+16>>2]=M*P+e*O+f*N;g[L+320+20>>2]=m*P+n*O+s*N;g[L+320+24>>2]=t*P+v*O+x*N;g[L+320+28>>2]=0.0;g[L+320+32>>2]=M*u+e*w+f*y;g[L+320+36>>2]=m*u+n*w+s*y;g[L+320+40>>2]=t*u+v*w+x*y;g[L+320+44>>2]=0.0;g[L+320+48>>2]=z;g[L+320+52>>2]=A;g[L+320+56>>2]=B;g[L+320+60>>2]=0.0;if(!(C&1)){I=c[d+32>>2]|0;w=+g[d+616>>2];m=+g[I+4>>2];x=+g[d+616+16>>2];n=+g[I+8>>2];y=+g[d+616+32>>2];s=+g[I+12>>2];z=+g[d+616+4>>2];A=+g[d+616+20>>2];B=+g[d+616+36>>2];M=+g[d+616+8>>2];O=+g[d+616+24>>2];S=+g[d+616+40>>2];t=+g[I+20>>2];u=+g[I+24>>2];v=+g[I+28>>2];N=+g[I+36>>2];P=+g[I+40>>2];T=+g[I+44>>2];e=+g[d+616+48>>2];f=+g[d+616+52>>2];W=+g[d+616+56>>2];U=+g[I+52>>2]+(m*e+n*f+s*W);V=t*e+u*f+v*W+ +g[I+56>>2];W=N*e+P*f+T*W+ +g[I+60>>2];g[L+320>>2]=w*m+x*n+y*s;g[L+320+4>>2]=m*z+n*A+s*B;g[L+320+8>>2]=m*M+n*O+s*S;g[L+320+12>>2]=0.0;g[L+320+16>>2]=w*t+x*u+y*v;g[L+320+20>>2]=z*t+A*u+B*v;g[L+320+24>>2]=M*t+O*u+S*v;g[L+320+28>>2]=0.0;g[L+320+32>>2]=w*N+x*P+y*T;g[L+320+36>>2]=z*N+A*P+B*T;g[L+320+40>>2]=M*N+O*P+S*T;g[L+320+44>>2]=0.0;g[L+320+48>>2]=U;g[L+320+52>>2]=V;g[L+320+56>>2]=W;g[L+320+60>>2]=0.0}else{I=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;$b[c[(c[I>>2]|0)+64>>2]&7](I,L+320|0,K);I=c[d+32>>2]|0;w=+g[d+616>>2];m=+g[I+4>>2];x=+g[d+616+16>>2];n=+g[I+8>>2];y=+g[d+616+32>>2];s=+g[I+12>>2];z=+g[d+616+4>>2];A=+g[d+616+20>>2];B=+g[d+616+36>>2];M=+g[d+616+8>>2];O=+g[d+616+24>>2];S=+g[d+616+40>>2];t=+g[I+20>>2];u=+g[I+24>>2];v=+g[I+28>>2];N=+g[I+36>>2];P=+g[I+40>>2];T=+g[I+44>>2];e=+g[d+616+48>>2];f=+g[d+616+52>>2];W=+g[d+616+56>>2];U=+g[I+52>>2]+(m*e+n*f+s*W);V=t*e+u*f+v*W+ +g[I+56>>2];W=N*e+P*f+T*W+ +g[I+60>>2];g[L+320>>2]=w*m+x*n+y*s;g[L+320+4>>2]=m*z+n*A+s*B;g[L+320+8>>2]=m*M+n*O+s*S;g[L+320+12>>2]=0.0;g[L+320+16>>2]=w*t+x*u+y*v;g[L+320+20>>2]=z*t+A*u+B*v;g[L+320+24>>2]=M*t+O*u+S*v;g[L+320+28>>2]=0.0;g[L+320+32>>2]=w*N+x*P+y*T;g[L+320+36>>2]=z*N+A*P+B*T;g[L+320+40>>2]=M*N+O*P+S*T;g[L+320+44>>2]=0.0;g[L+320+48>>2]=U;g[L+320+52>>2]=V;g[L+320+56>>2]=W;g[L+320+60>>2]=0.0;I=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;$b[c[(c[I>>2]|0)+64>>2]&7](I,L+320|0,K)}m=+g[d+688>>2];n=+g[d+688+4>>2];e=+oG(m-n);if(!(e<-3.1415927410125732))if(e>3.1415927410125732)f=e+-6.2831854820251465;else f=e;else f=e+6.2831854820251465;e=+oG(m+n);if(!(e<-3.1415927410125732)){if(e>3.1415927410125732)e=e+-6.2831854820251465}else e=e+6.2831854820251465;if(!(f==e)?J&1|0:0){c[L+304>>2]=c[L+320+8>>2];c[L+304+4>>2]=c[L+320+24>>2];c[L+304+8>>2]=c[L+320+40>>2];g[L+304+12>>2]=0.0;c[L+272>>2]=c[L+320>>2];c[L+272+4>>2]=c[L+320+16>>2];c[L+272+8>>2]=c[L+320+32>>2];g[L+272+12>>2]=0.0;b=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;d=c[(c[b>>2]|0)+68>>2]|0;c[L+288>>2]=0;c[L+288+4>>2]=0;c[L+288+8>>2]=0;c[L+288+12>>2]=0;Cb[d&0](b,L+320+48|0,L+304|0,L+272|0,K,K,n>0.0?f:0.0,n>0.0?e:6.2831854820251465,L+288|0,n>0.0,10.0)}i=L;return}case 5:{l=c[d+28>>2]|0;w=+g[d+300>>2];m=+g[l+4>>2];x=+g[d+300+16>>2];n=+g[l+8>>2];y=+g[d+300+32>>2];s=+g[l+12>>2];z=+g[d+300+4>>2];A=+g[d+300+20>>2];B=+g[d+300+36>>2];M=+g[d+300+8>>2];O=+g[d+300+24>>2];S=+g[d+300+40>>2];t=+g[l+20>>2];u=+g[l+24>>2];v=+g[l+28>>2];N=+g[l+36>>2];P=+g[l+40>>2];T=+g[l+44>>2];e=+g[d+300+48>>2];f=+g[d+300+52>>2];W=+g[d+300+56>>2];U=+g[l+52>>2]+(m*e+n*f+s*W);V=t*e+u*f+v*W+ +g[l+56>>2];W=N*e+P*f+T*W+ +g[l+60>>2];g[L+320>>2]=w*m+x*n+y*s;l=L+320+4|0;g[l>>2]=m*z+n*A+s*B;o=L+320+8|0;g[o>>2]=m*M+n*O+s*S;g[L+320+12>>2]=0.0;p=L+320+16|0;g[p>>2]=w*t+x*u+y*v;q=L+320+20|0;g[q>>2]=z*t+A*u+B*v;r=L+320+24|0;g[r>>2]=M*t+O*u+S*v;g[L+320+28>>2]=0.0;D=L+320+32|0;g[D>>2]=w*N+x*P+y*T;E=L+320+36|0;g[E>>2]=z*N+A*P+B*T;F=L+320+40|0;g[F>>2]=M*N+O*P+S*T;g[L+320+44>>2]=0.0;G=L+320+48|0;g[G>>2]=U;H=L+320+52|0;g[H>>2]=V;I=L+320+56|0;g[I>>2]=W;g[L+320+60>>2]=0.0;if(!(C&1)){C=c[d+32>>2]|0;w=+g[d+364>>2];m=+g[C+4>>2];x=+g[d+364+16>>2];n=+g[C+8>>2];y=+g[d+364+32>>2];s=+g[C+12>>2];z=+g[d+364+4>>2];A=+g[d+364+20>>2];B=+g[d+364+36>>2];M=+g[d+364+8>>2];O=+g[d+364+24>>2];S=+g[d+364+40>>2];t=+g[C+20>>2];u=+g[C+24>>2];v=+g[C+28>>2];N=+g[C+36>>2];P=+g[C+40>>2];T=+g[C+44>>2];e=+g[d+364+48>>2];f=+g[d+364+52>>2];W=+g[d+364+56>>2];U=+g[C+52>>2]+(m*e+n*f+s*W);V=t*e+u*f+v*W+ +g[C+56>>2];W=N*e+P*f+T*W+ +g[C+60>>2];g[L+320>>2]=w*m+x*n+y*s;g[l>>2]=m*z+n*A+s*B;g[o>>2]=m*M+n*O+s*S;g[L+320+12>>2]=0.0;g[p>>2]=w*t+x*u+y*v;g[q>>2]=z*t+A*u+B*v;g[r>>2]=M*t+O*u+S*v;g[L+320+28>>2]=0.0;g[D>>2]=w*N+x*P+y*T;g[E>>2]=z*N+A*P+B*T;g[F>>2]=M*N+O*P+S*T;g[L+320+44>>2]=0.0;g[G>>2]=U;g[H>>2]=V;g[I>>2]=W;g[L+320+60>>2]=0.0}else{C=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;$b[c[(c[C>>2]|0)+64>>2]&7](C,L+320|0,K);C=c[d+32>>2]|0;w=+g[d+364>>2];m=+g[C+4>>2];x=+g[d+364+16>>2];n=+g[C+8>>2];y=+g[d+364+32>>2];s=+g[C+12>>2];z=+g[d+364+4>>2];A=+g[d+364+20>>2];B=+g[d+364+36>>2];M=+g[d+364+8>>2];O=+g[d+364+24>>2];S=+g[d+364+40>>2];t=+g[C+20>>2];u=+g[C+24>>2];v=+g[C+28>>2];N=+g[C+36>>2];P=+g[C+40>>2];T=+g[C+44>>2];e=+g[d+364+48>>2];f=+g[d+364+52>>2];W=+g[d+364+56>>2];U=+g[C+52>>2]+(m*e+n*f+s*W);V=t*e+u*f+v*W+ +g[C+56>>2];W=N*e+P*f+T*W+ +g[C+60>>2];g[L+320>>2]=w*m+x*n+y*s;g[l>>2]=m*z+n*A+s*B;g[o>>2]=m*M+n*O+s*S;g[L+320+12>>2]=0.0;g[p>>2]=w*t+x*u+y*v;g[q>>2]=z*t+A*u+B*v;g[r>>2]=M*t+O*u+S*v;g[L+320+28>>2]=0.0;g[D>>2]=w*N+x*P+y*T;g[E>>2]=z*N+A*P+B*T;g[F>>2]=M*N+O*P+S*T;g[L+320+44>>2]=0.0;g[G>>2]=U;g[H>>2]=V;g[I>>2]=W;g[L+320+60>>2]=0.0;C=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;$b[c[(c[C>>2]|0)+64>>2]&7](C,L+320|0,K)}if(J&1|0){So(L+304|0,d,6.0868353843688965,K);S=+g[L+304>>2];T=+g[L+304+4>>2];U=+g[L+304+8>>2];V=S*+g[p>>2]+T*+g[q>>2]+U*+g[r>>2]+ +g[H>>2];W=S*+g[D>>2]+T*+g[E>>2]+U*+g[F>>2]+ +g[I>>2];g[L+304>>2]=S*+g[L+320>>2]+T*+g[l>>2]+U*+g[o>>2]+ +g[G>>2];g[L+304+4>>2]=V;g[L+304+8>>2]=W;g[L+304+12>>2]=0.0;j=L+320+48|0;h=0;do{So(L+272|0,d,+(h|0)*6.283185005187988*.03125,K);S=+g[L+272>>2];T=+g[L+272+4>>2];U=+g[L+272+8>>2];V=S*+g[p>>2]+T*+g[q>>2]+U*+g[r>>2]+ +g[H>>2];W=S*+g[D>>2]+T*+g[E>>2]+U*+g[F>>2]+ +g[I>>2];g[L+272>>2]=S*+g[L+320>>2]+T*+g[l>>2]+U*+g[o>>2]+ +g[G>>2];g[L+272+4>>2]=V;g[L+272+8>>2]=W;g[L+272+12>>2]=0.0;J=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;C=c[(c[J>>2]|0)+16>>2]|0;c[L+256>>2]=0;c[L+256+4>>2]=0;c[L+256+8>>2]=0;c[L+256+12>>2]=0;bc[C&127](J,L+304|0,L+272|0,L+256|0);if(!(h&3)){J=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;C=c[(c[J>>2]|0)+16>>2]|0;c[L+240>>2]=0;c[L+240+4>>2]=0;c[L+240+8>>2]=0;c[L+240+12>>2]=0;bc[C&127](J,j,L+272|0,L+240|0)};c[L+304>>2]=c[L+272>>2];c[L+304+4>>2]=c[L+272+4>>2];c[L+304+8>>2]=c[L+272+8>>2];c[L+304+12>>2]=c[L+272+12>>2];h=h+1|0}while((h|0)!=32);A=+g[d+452>>2];B=+g[d+512>>2];h=c[d+32>>2]|0;if(+g[h+368>>2]>0.0){S=+g[d+364>>2];T=+g[h+4>>2];U=+g[d+364+16>>2];V=+g[h+8>>2];W=+g[d+364+32>>2];x=+g[h+12>>2];O=+g[d+364+4>>2];P=+g[d+364+20>>2];w=+g[d+364+36>>2];M=+g[d+364+8>>2];N=+g[d+364+24>>2];v=+g[d+364+40>>2];Y=+g[h+20>>2];X=+g[h+24>>2];u=+g[h+28>>2];t=+g[h+36>>2];s=+g[h+40>>2];n=+g[h+44>>2];m=+g[d+364+48>>2];f=+g[d+364+52>>2];e=+g[d+364+56>>2];y=t*m+s*f+n*e+ +g[h+60>>2];z=Y*m+X*f+u*e+ +g[h+56>>2];e=+g[h+52>>2]+(T*m+V*f+x*e);f=M*t+N*s+v*n;m=O*t+P*s+w*n;n=S*t+U*s+W*n;s=M*Y+N*X+v*u;t=O*Y+P*X+w*u;u=S*Y+U*X+W*u;v=T*M+V*N+x*v;w=T*O+V*P+x*w;x=S*T+U*V+W*x}else{J=c[d+28>>2]|0;U=+g[d+300>>2];V=+g[J+4>>2];W=+g[d+300+16>>2];X=+g[J+8>>2];Y=+g[d+300+32>>2];x=+g[J+12>>2];S=+g[d+300+4>>2];T=+g[d+300+20>>2];w=+g[d+300+36>>2];O=+g[d+300+8>>2];P=+g[d+300+24>>2];v=+g[d+300+40>>2];M=+g[J+20>>2];N=+g[J+24>>2];u=+g[J+28>>2];t=+g[J+36>>2];s=+g[J+40>>2];n=+g[J+44>>2];m=+g[d+300+48>>2];f=+g[d+300+52>>2];e=+g[d+300+56>>2];y=t*m+s*f+n*e+ +g[J+60>>2];z=M*m+N*f+u*e+ +g[J+56>>2];e=+g[J+52>>2]+(V*m+X*f+x*e);f=O*t+P*s+v*n;m=S*t+T*s+w*n;n=U*t+W*s+Y*n;s=O*M+P*N+v*u;t=S*M+T*N+w*u;u=U*M+W*N+Y*u;v=V*O+X*P+x*v;w=V*S+X*T+x*w;x=U*V+W*X+Y*x}g[L+320>>2]=x;g[l>>2]=w;g[o>>2]=v;g[L+320+12>>2]=0.0;g[p>>2]=u;g[q>>2]=t;g[r>>2]=s;g[L+320+28>>2]=0.0;g[D>>2]=n;g[E>>2]=m;g[F>>2]=f;g[L+320+44>>2]=0.0;g[G>>2]=e;g[H>>2]=z;g[I>>2]=y;g[L+320+60>>2]=0.0;c[L+272>>2]=c[j>>2];c[L+272+4>>2]=c[j+4>>2];c[L+272+8>>2]=c[j+8>>2];c[L+272+12>>2]=c[j+12>>2];g[L+208>>2]=x;g[L+208+4>>2]=u;g[L+208+8>>2]=n;g[L+208+12>>2]=0.0;g[L+176>>2]=w;g[L+176+4>>2]=t;g[L+176+8>>2]=m;g[L+176+12>>2]=0.0;b=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;d=c[(c[b>>2]|0)+68>>2]|0;c[L+224>>2]=0;c[L+224+4>>2]=0;c[L+224+8>>2]=0;c[L+224+12>>2]=0;Cb[d&0](b,L+272|0,L+208|0,L+176|0,K,K,-B-A,A-B,L+224|0,1,10.0)}i=L;return}case 6:case 9:{c[L+320>>2]=c[d+1064>>2];c[L+320+4>>2]=c[d+1064+4>>2];c[L+320+8>>2]=c[d+1064+8>>2];c[L+320+12>>2]=c[d+1064+12>>2];j=L+320+16|0;l=d+1064+16|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];o=L+320+32|0;p=d+1064+32|0;c[o>>2]=c[p>>2];c[o+4>>2]=c[p+4>>2];c[o+8>>2]=c[p+8>>2];c[o+12>>2]=c[p+12>>2];q=L+320+48|0;r=d+1064+48|0;c[q>>2]=c[r>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];c[q+12>>2]=c[r+12>>2];if(!(C&1)){c[L+320>>2]=c[d+1128>>2];c[L+320+4>>2]=c[d+1128+4>>2];c[L+320+8>>2]=c[d+1128+8>>2];c[L+320+12>>2]=c[d+1128+12>>2];c[j>>2]=c[d+1128+16>>2];c[j+4>>2]=c[d+1128+16+4>>2];c[j+8>>2]=c[d+1128+16+8>>2];c[j+12>>2]=c[d+1128+16+12>>2];c[o>>2]=c[d+1128+32>>2];c[o+4>>2]=c[d+1128+32+4>>2];c[o+8>>2]=c[d+1128+32+8>>2];c[o+12>>2]=c[d+1128+32+12>>2];c[q>>2]=c[d+1128+48>>2];c[q+4>>2]=c[d+1128+48+4>>2];c[q+8>>2]=c[d+1128+48+8>>2];c[q+12>>2]=c[d+1128+48+12>>2]}else{I=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;$b[c[(c[I>>2]|0)+64>>2]&7](I,L+320|0,K);c[L+320>>2]=c[d+1128>>2];c[L+320+4>>2]=c[d+1128+4>>2];c[L+320+8>>2]=c[d+1128+8>>2];c[L+320+12>>2]=c[d+1128+12>>2];c[j>>2]=c[d+1128+16>>2];c[j+4>>2]=c[d+1128+16+4>>2];c[j+8>>2]=c[d+1128+16+8>>2];c[j+12>>2]=c[d+1128+16+12>>2];c[o>>2]=c[d+1128+32>>2];c[o+4>>2]=c[d+1128+32+4>>2];c[o+8>>2]=c[d+1128+32+8>>2];c[o+12>>2]=c[d+1128+32+12>>2];c[q>>2]=c[d+1128+48>>2];c[q+4>>2]=c[d+1128+48+4>>2];c[q+8>>2]=c[d+1128+48+8>>2];c[q+12>>2]=c[d+1128+48+12>>2];I=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;$b[c[(c[I>>2]|0)+64>>2]&7](I,L+320|0,K)}if(J&1|0){c[L+320>>2]=c[d+1064>>2];c[L+320+4>>2]=c[d+1064+4>>2];c[L+320+8>>2]=c[d+1064+8>>2];c[L+320+12>>2]=c[d+1064+12>>2];c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];c[o>>2]=c[p>>2];c[o+4>>2]=c[p+4>>2];c[o+8>>2]=c[p+8>>2];c[o+12>>2]=c[p+12>>2];c[q>>2]=c[r>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];c[q+12>>2]=c[r+12>>2];h=d+1128+48|0;c[L+304>>2]=c[L+320+8>>2];c[L+304+4>>2]=c[L+320+24>>2];c[L+304+8>>2]=c[L+320+40>>2];g[L+304+12>>2]=0.0;c[L+272>>2]=c[L+320>>2];c[L+272+4>>2]=c[L+320+16>>2];c[L+272+8>>2]=c[L+320+32>>2];g[L+272+12>>2]=0.0;U=+g[d+932>>2];e=+g[d+932+4>>2];X=+g[d+996>>2];W=+g[d+996+4>>2];H=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;I=c[(c[H>>2]|0)+72>>2]|0;c[L+192>>2]=0;c[L+192+4>>2]=0;c[L+192+8>>2]=0;c[L+192+12>>2]=0;Ub[I&0](H,h,L+304|0,L+272|0,K*.8999999761581421,U,e,X,W,L+192|0,10.0,1);H=c[L+320+4>>2]|0;I=c[L+320+20>>2]|0;J=c[L+320+36>>2]|0;c[L+272>>2]=H;c[L+272+4>>2]=I;c[L+272+8>>2]=J;g[L+272+12>>2]=0.0;W=+g[d+1196>>2];X=+g[d+1200>>2];e=+Q(+W);W=+R(+W);U=+Q(+X);X=+R(+X);V=(c[k>>2]=H,+g[k>>2]);Y=(c[k>>2]=I,+g[k>>2]);f=(c[k>>2]=J,+g[k>>2]);g[L+208>>2]=e*U*V+e*X*Y-W*f;g[L+208+4>>2]=U*Y-X*V;g[L+208+8>>2]=W*U*V+W*X*Y+e*f;c[L+320>>2]=c[d+1128>>2];c[L+320+4>>2]=c[d+1128+4>>2];c[L+320+8>>2]=c[d+1128+8>>2];c[L+320+12>>2]=c[d+1128+12>>2];c[j>>2]=c[d+1128+16>>2];c[j+4>>2]=c[d+1128+16+4>>2];c[j+8>>2]=c[d+1128+16+8>>2];c[j+12>>2]=c[d+1128+16+12>>2];c[o>>2]=c[d+1128+32>>2];c[o+4>>2]=c[d+1128+32+4>>2];c[o+8>>2]=c[d+1128+32+8>>2];c[o+12>>2]=c[d+1128+32+12>>2];c[q>>2]=c[h>>2];c[q+4>>2]=c[h+4>>2];c[q+8>>2]=c[h+8>>2];c[q+12>>2]=c[h+12>>2];f=-+g[L+320+16>>2];e=-+g[L+320+32>>2];g[L+176>>2]=-+g[L+320>>2];g[L+176+4>>2]=f;g[L+176+8>>2]=e;g[L+176+12>>2]=0.0;e=+g[d+868>>2];f=+g[d+868+4>>2];if(!(e>f)){if(e<f){J=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;I=c[(c[J>>2]|0)+68>>2]|0;c[L+144>>2]=0;c[L+144+4>>2]=0;c[L+144+8>>2]=0;c[L+144+12>>2]=0;Cb[I&0](J,h,L+176|0,L+208|0,K,K,e,f,L+144|0,1,10.0)}}else{J=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;I=c[(c[J>>2]|0)+68>>2]|0;c[L+160>>2]=0;c[L+160+4>>2]=0;c[L+160+8>>2]=0;c[L+160+12>>2]=0;Cb[I&0](J,h,L+176|0,L+208|0,K,K,-3.1415927410125732,3.1415927410125732,L+160|0,0,10.0)};c[L+320>>2]=c[d+1064>>2];c[L+320+4>>2]=c[d+1064+4>>2];c[L+320+8>>2]=c[d+1064+8>>2];c[L+320+12>>2]=c[d+1064+12>>2];c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];c[o>>2]=c[p>>2];c[o+4>>2]=c[p+4>>2];c[o+8>>2]=c[p+8>>2];c[o+12>>2]=c[p+12>>2];c[q>>2]=c[r>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];c[q+12>>2]=c[r+12>>2];c[L+96>>2]=c[d+680>>2];c[L+96+4>>2]=c[d+680+4>>2];c[L+96+8>>2]=c[d+680+8>>2];c[L+96+12>>2]=c[d+680+12>>2];c[L+64>>2]=c[d+680+16>>2];c[L+64+4>>2]=c[d+680+16+4>>2];c[L+64+8>>2]=c[d+680+16+8>>2];c[L+64+12>>2]=c[d+680+16+12>>2];b=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;d=c[(c[b>>2]|0)+80>>2]|0;c[L+128>>2]=0;c[L+128+4>>2]=0;c[L+128+8>>2]=0;c[L+128+12>>2]=0;pb[d&31](b,L+96|0,L+64|0,L+320|0,L+128|0)}i=L;return}case 12:{c[L+320>>2]=c[d+1236>>2];c[L+320+4>>2]=c[d+1236+4>>2];c[L+320+8>>2]=c[d+1236+8>>2];c[L+320+12>>2]=c[d+1236+12>>2];j=L+320+16|0;l=d+1236+16|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];o=L+320+32|0;p=d+1236+32|0;c[o>>2]=c[p>>2];c[o+4>>2]=c[p+4>>2];c[o+8>>2]=c[p+8>>2];c[o+12>>2]=c[p+12>>2];q=L+320+48|0;r=d+1236+48|0;c[q>>2]=c[r>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];c[q+12>>2]=c[r+12>>2];if(!(C&1)){c[L+320>>2]=c[d+1300>>2];c[L+320+4>>2]=c[d+1300+4>>2];c[L+320+8>>2]=c[d+1300+8>>2];c[L+320+12>>2]=c[d+1300+12>>2];c[j>>2]=c[d+1300+16>>2];c[j+4>>2]=c[d+1300+16+4>>2];c[j+8>>2]=c[d+1300+16+8>>2];c[j+12>>2]=c[d+1300+16+12>>2];c[o>>2]=c[d+1300+32>>2];c[o+4>>2]=c[d+1300+32+4>>2];c[o+8>>2]=c[d+1300+32+8>>2];c[o+12>>2]=c[d+1300+32+12>>2];c[q>>2]=c[d+1300+48>>2];c[q+4>>2]=c[d+1300+48+4>>2];c[q+8>>2]=c[d+1300+48+8>>2];c[q+12>>2]=c[d+1300+48+12>>2]}else{I=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;$b[c[(c[I>>2]|0)+64>>2]&7](I,L+320|0,K);c[L+320>>2]=c[d+1300>>2];c[L+320+4>>2]=c[d+1300+4>>2];c[L+320+8>>2]=c[d+1300+8>>2];c[L+320+12>>2]=c[d+1300+12>>2];c[j>>2]=c[d+1300+16>>2];c[j+4>>2]=c[d+1300+16+4>>2];c[j+8>>2]=c[d+1300+16+8>>2];c[j+12>>2]=c[d+1300+16+12>>2];c[o>>2]=c[d+1300+32>>2];c[o+4>>2]=c[d+1300+32+4>>2];c[o+8>>2]=c[d+1300+32+8>>2];c[o+12>>2]=c[d+1300+32+12>>2];c[q>>2]=c[d+1300+48>>2];c[q+4>>2]=c[d+1300+48+4>>2];c[q+8>>2]=c[d+1300+48+8>>2];c[q+12>>2]=c[d+1300+48+12>>2];I=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;$b[c[(c[I>>2]|0)+64>>2]&7](I,L+320|0,K)}if(J&1|0){c[L+320>>2]=c[d+1236>>2];c[L+320+4>>2]=c[d+1236+4>>2];c[L+320+8>>2]=c[d+1236+8>>2];c[L+320+12>>2]=c[d+1236+12>>2];c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];c[o>>2]=c[p>>2];c[o+4>>2]=c[p+4>>2];c[o+8>>2]=c[p+8>>2];c[o+12>>2]=c[p+12>>2];c[q>>2]=c[r>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];c[q+12>>2]=c[r+12>>2];h=d+1300+48|0;c[L+304>>2]=c[L+320+8>>2];c[L+304+4>>2]=c[L+320+24>>2];c[L+304+8>>2]=c[L+320+40>>2];g[L+304+12>>2]=0.0;c[L+272>>2]=c[L+320>>2];c[L+272+4>>2]=c[L+320+16>>2];c[L+272+8>>2]=c[L+320+32>>2];g[L+272+12>>2]=0.0;U=+g[d+1056>>2];e=+g[d+1060>>2];X=+g[d+1144>>2];W=+g[d+1144+4>>2];H=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;I=c[(c[H>>2]|0)+72>>2]|0;c[L+112>>2]=0;c[L+112+4>>2]=0;c[L+112+8>>2]=0;c[L+112+12>>2]=0;Ub[I&0](H,h,L+304|0,L+272|0,K*.8999999761581421,U,e,X,W,L+112|0,10.0,1);H=c[L+320+4>>2]|0;I=c[L+320+20>>2]|0;J=c[L+320+36>>2]|0;c[L+272>>2]=H;c[L+272+4>>2]=I;c[L+272+8>>2]=J;g[L+272+12>>2]=0.0;W=+g[d+1368>>2];X=+g[d+1372>>2];e=+Q(+W);W=+R(+W);U=+Q(+X);X=+R(+X);V=(c[k>>2]=H,+g[k>>2]);Y=(c[k>>2]=I,+g[k>>2]);f=(c[k>>2]=J,+g[k>>2]);g[L+208>>2]=e*U*V+e*X*Y-W*f;g[L+208+4>>2]=U*Y-X*V;g[L+208+8>>2]=W*U*V+W*X*Y+e*f;c[L+320>>2]=c[d+1300>>2];c[L+320+4>>2]=c[d+1300+4>>2];c[L+320+8>>2]=c[d+1300+8>>2];c[L+320+12>>2]=c[d+1300+12>>2];c[j>>2]=c[d+1300+16>>2];c[j+4>>2]=c[d+1300+16+4>>2];c[j+8>>2]=c[d+1300+16+8>>2];c[j+12>>2]=c[d+1300+16+12>>2];c[o>>2]=c[d+1300+32>>2];c[o+4>>2]=c[d+1300+32+4>>2];c[o+8>>2]=c[d+1300+32+8>>2];c[o+12>>2]=c[d+1300+32+12>>2];c[q>>2]=c[h>>2];c[q+4>>2]=c[h+4>>2];c[q+8>>2]=c[h+8>>2];c[q+12>>2]=c[h+12>>2];f=-+g[L+320+16>>2];e=-+g[L+320+32>>2];g[L+176>>2]=-+g[L+320>>2];g[L+176+4>>2]=f;g[L+176+8>>2]=e;g[L+176+12>>2]=0.0;e=+g[d+968>>2];f=+g[d+968+4>>2];if(!(e>f)){if(e<f){J=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;I=c[(c[J>>2]|0)+68>>2]|0;c[L+48>>2]=0;c[L+48+4>>2]=0;c[L+48+8>>2]=0;c[L+48+12>>2]=0;Cb[I&0](J,h,L+176|0,L+208|0,K,K,e,f,L+48|0,1,10.0)}}else{J=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;I=c[(c[J>>2]|0)+68>>2]|0;c[L+80>>2]=0;c[L+80+4>>2]=0;c[L+80+8>>2]=0;c[L+80+12>>2]=0;Cb[I&0](J,h,L+176|0,L+208|0,K,K,-3.1415927410125732,3.1415927410125732,L+80|0,0,10.0)};c[L+320>>2]=c[d+1236>>2];c[L+320+4>>2]=c[d+1236+4>>2];c[L+320+8>>2]=c[d+1236+8>>2];c[L+320+12>>2]=c[d+1236+12>>2];c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];c[o>>2]=c[p>>2];c[o+4>>2]=c[p+4>>2];c[o+8>>2]=c[p+8>>2];c[o+12>>2]=c[p+12>>2];c[q>>2]=c[r>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];c[q+12>>2]=c[r+12>>2];c[L+96>>2]=c[d+680>>2];c[L+96+4>>2]=c[d+680+4>>2];c[L+96+8>>2]=c[d+680+8>>2];c[L+96+12>>2]=c[d+680+12>>2];c[L+64>>2]=c[d+680+16>>2];c[L+64+4>>2]=c[d+680+16+4>>2];c[L+64+8>>2]=c[d+680+16+8>>2];c[L+64+12>>2]=c[d+680+16+12>>2];b=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;d=c[(c[b>>2]|0)+80>>2]|0;c[L+32>>2]=0;c[L+32+4>>2]=0;c[L+32+8>>2]=0;c[L+32+12>>2]=0;pb[d&31](b,L+96|0,L+64|0,L+320|0,L+32|0)}i=L;return}case 7:{c[L+320>>2]=c[d+824>>2];c[L+320+4>>2]=c[d+824+4>>2];c[L+320+8>>2]=c[d+824+8>>2];c[L+320+12>>2]=c[d+824+12>>2];h=L+320+16|0;c[h>>2]=c[d+824+16>>2];c[h+4>>2]=c[d+824+16+4>>2];c[h+8>>2]=c[d+824+16+8>>2];c[h+12>>2]=c[d+824+16+12>>2];j=L+320+32|0;c[j>>2]=c[d+824+32>>2];c[j+4>>2]=c[d+824+32+4>>2];c[j+8>>2]=c[d+824+32+8>>2];c[j+12>>2]=c[d+824+32+12>>2];l=L+320+48|0;c[l>>2]=c[d+824+48>>2];c[l+4>>2]=c[d+824+48+4>>2];c[l+8>>2]=c[d+824+48+8>>2];c[l+12>>2]=c[d+824+48+12>>2];if(!(C&1)){c[L+320>>2]=c[d+888>>2];c[L+320+4>>2]=c[d+888+4>>2];c[L+320+8>>2]=c[d+888+8>>2];c[L+320+12>>2]=c[d+888+12>>2];c[h>>2]=c[d+888+16>>2];c[h+4>>2]=c[d+888+16+4>>2];c[h+8>>2]=c[d+888+16+8>>2];c[h+12>>2]=c[d+888+16+12>>2];c[j>>2]=c[d+888+32>>2];c[j+4>>2]=c[d+888+32+4>>2];c[j+8>>2]=c[d+888+32+8>>2];c[j+12>>2]=c[d+888+32+12>>2];c[l>>2]=c[d+888+48>>2];c[l+4>>2]=c[d+888+48+4>>2];c[l+8>>2]=c[d+888+48+8>>2];c[l+12>>2]=c[d+888+48+12>>2]}else{I=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;$b[c[(c[I>>2]|0)+64>>2]&7](I,L+320|0,K);c[L+320>>2]=c[d+888>>2];c[L+320+4>>2]=c[d+888+4>>2];c[L+320+8>>2]=c[d+888+8>>2];c[L+320+12>>2]=c[d+888+12>>2];c[h>>2]=c[d+888+16>>2];c[h+4>>2]=c[d+888+16+4>>2];c[h+8>>2]=c[d+888+16+8>>2];c[h+12>>2]=c[d+888+16+12>>2];c[j>>2]=c[d+888+32>>2];c[j+4>>2]=c[d+888+32+4>>2];c[j+8>>2]=c[d+888+32+8>>2];c[j+12>>2]=c[d+888+32+12>>2];c[l>>2]=c[d+888+48>>2];c[l+4>>2]=c[d+888+48+4>>2];c[l+8>>2]=c[d+888+48+8>>2];c[l+12>>2]=c[d+888+48+12>>2];I=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;$b[c[(c[I>>2]|0)+64>>2]&7](I,L+320|0,K)}if(J&1|0){D=a[d+180>>0]|0?d+824|0:d+888|0;E=c[D>>2]|0;H=c[D+4>>2]|0;F=c[D+16>>2]|0;I=c[D+20>>2]|0;G=c[D+32>>2]|0;J=c[D+36>>2]|0;A=+g[D+48>>2];O=+g[D+52>>2];U=+g[D+56>>2];X=+g[d+184>>2];N=(c[k>>2]=E,+g[k>>2]);M=(c[k>>2]=H,+g[k>>2])*0.0;B=+g[D+8>>2]*0.0;T=(c[k>>2]=F,+g[k>>2]);S=(c[k>>2]=I,+g[k>>2])*0.0;P=+g[D+24>>2]*0.0;Y=(c[k>>2]=G,+g[k>>2]);W=(c[k>>2]=J,+g[k>>2])*0.0;V=+g[D+40>>2]*0.0;g[L+304>>2]=A+(B+(M+N*X));g[L+304+4>>2]=O+(P+(S+T*X));g[L+304+8>>2]=U+(V+(W+Y*X));g[L+304+12>>2]=0.0;X=+g[d+188>>2];g[L+272>>2]=A+(B+(M+N*X));g[L+272+4>>2]=O+(P+(S+T*X));g[L+272+8>>2]=U+(V+(W+Y*X));g[L+272+12>>2]=0.0;D=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;C=c[(c[D>>2]|0)+16>>2]|0;c[L+16>>2]=0;c[L+16+4>>2]=0;c[L+16+8>>2]=0;c[L+16+12>>2]=0;bc[C&127](D,L+304|0,L+272|0,L+16|0);c[L+208>>2]=E;c[L+208+4>>2]=F;c[L+208+8>>2]=G;g[L+208+12>>2]=0.0;c[L+176>>2]=H;c[L+176+4>>2]=I;c[L+176+8>>2]=J;g[L+176+12>>2]=0.0;X=+g[d+192>>2];Y=+g[d+196>>2];b=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;J=c[(c[b>>2]|0)+68>>2]|0;c[L>>2]=0;c[L+4>>2]=0;c[L+8>>2]=0;c[L+12>>2]=0;Cb[J&0](b,d+888+48|0,L+208|0,L+176|0,K,K,X,Y,L,1,10.0)}i=L;return}default:{i=L;return}}}function rr(a){a=a|0;var b=0,d=0,e=0,f=0.0,h=0.0;e=c[a+232>>2]|0;if((e|0)<=0)return;a=c[a+240>>2]|0;d=0;do{b=c[a+(d<<2)>>2]|0;switch(c[b+216>>2]|0){case 2:case 5:break;default:if(!(c[b+204>>2]&3)){h=+g[b+392>>2]*+g[b+376>>2];f=+g[b+396>>2]*+g[b+380>>2];g[b+436>>2]=+g[b+388>>2]*+g[b+372>>2]+ +g[b+436>>2];g[b+440>>2]=h+ +g[b+440>>2];g[b+444>>2]=f+ +g[b+444>>2]}}d=d+1|0}while((d|0)!=(e|0));return}function sr(a,b){a=a|0;b=b|0;return}function tr(a,b){a=a|0;b=+b;var d=0,e=0,f=0;e=i;i=i+16|0;fs(16070);if((c[a+280>>2]|0)>0){d=0;do{f=c[(c[a+288>>2]|0)+(d<<2)>>2]|0;$b[c[(c[f>>2]|0)+8>>2]&7](f,a,b);d=d+1|0}while((d|0)<(c[a+280>>2]|0))}d=c[2006]|0;f=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=f;if(f|0){i=e;return}do if(c[d+4>>2]|0){kb(e|0,0)|0;f=c[5649]|0;g[d+8>>2]=+g[d+8>>2]+ +(((c[e+4>>2]|0)-(c[f+4>>2]|0)+(((c[e>>2]|0)-(c[f>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[d+16>>2]|0)){d=c[2006]|0;break}else{i=e;return}}while(0);c[2006]=c[d+20>>2];i=e;return}function ur(b){b=b|0;var d=0;c[b>>2]=7896;d=c[b+80>>2]|0;if(d|0){if(a[b+84>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+80>>2]=0}a[b+84>>0]=1;c[b+80>>2]=0;c[b+72>>2]=0;c[b+76>>2]=0;d=c[b+60>>2]|0;if(d|0){if(a[b+64>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+52>>2]=0;c[b+56>>2]=0;d=c[b+40>>2]|0;if(!d){a[b+44>>0]=1;c[b+40>>2]=0;c[b+32>>2]=0;b=b+36|0;c[b>>2]=0;return}if(a[b+44>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+40>>2]=0;a[b+44>>0]=1;c[b+40>>2]=0;c[b+32>>2]=0;b=b+36|0;c[b>>2]=0;return}function vr(a){a=a|0;ur(a);rG(a);return}function wr(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0;if((h|0)<0){o=c[b+8>>2]|0;+Qb[c[(c[o>>2]|0)+12>>2]&3](o,d,e,f,g,c[b+12>>2]|0,c[b+16>>2]|0,c[b+4>>2]|0,c[b+20>>2]|0,c[b+24>>2]|0);return}n=c[b+16>>2]|0;a:do if((n|0)>0){m=c[b+12>>2]|0;i=0;while(1){l=m+(i<<2)|0;k=c[l>>2]|0;j=c[(c[k+28>>2]|0)+208>>2]|0;if((j|0)<=-1)j=c[(c[k+32>>2]|0)+208>>2]|0;if((j|0)==(h|0)){o=l;break a}i=i+1|0;if((i|0)>=(n|0)){o=0;break}}}else{i=0;o=0}while(0);if((i|0)<(n|0)){m=c[b+12>>2]|0;j=0;do{l=c[m+(i<<2)>>2]|0;k=c[(c[l+28>>2]|0)+208>>2]|0;if((k|0)<=-1)k=c[(c[l+32>>2]|0)+208>>2]|0;j=((k|0)==(h|0)&1)+j|0;i=i+1|0}while((i|0)!=(n|0));h=j}else h=0;i=c[b+4>>2]|0;if((c[i+72>>2]|0)<2){n=c[b+8>>2]|0;+Qb[c[(c[n>>2]|0)+12>>2]&3](n,d,e,f,g,o,h,i,c[b+20>>2]|0,c[b+24>>2]|0);return}if((e|0)>0){i=c[b+32>>2]|0;j=c[b+36>>2]|0;n=0;do{m=d+(n<<2)|0;if((i|0)==(j|0)){l=j|0?j<<1:1;if((j|0)<(l|0)){if(!l)i=0;else{c[5637]=(c[5637]|0)+1;i=qG((l<<2|3)+16|0)|0;if(!i)i=0;else{c[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}j=c[b+32>>2]|0}if((j|0)>0){k=0;do{c[i+(k<<2)>>2]=c[(c[b+40>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(j|0))}k=c[b+40>>2]|0;if(k){if(a[b+44>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[k+-4>>2]|0);j=c[b+32>>2]|0}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=i;c[b+36>>2]=l;i=j;j=l}else i=j}c[(c[b+40>>2]|0)+(i<<2)>>2]=c[m>>2];i=i+1|0;c[b+32>>2]=i;n=n+1|0}while((n|0)!=(e|0))}if((g|0)>0){i=c[b+52>>2]|0;j=c[b+56>>2]|0;n=0;do{m=f+(n<<2)|0;if((i|0)==(j|0)){l=j|0?j<<1:1;if((j|0)<(l|0)){if(!l)i=0;else{c[5637]=(c[5637]|0)+1;i=qG((l<<2|3)+16|0)|0;if(!i)i=0;else{c[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}j=c[b+52>>2]|0}if((j|0)>0){k=0;do{c[i+(k<<2)>>2]=c[(c[b+60>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(j|0))}k=c[b+60>>2]|0;if(k){if(a[b+64>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[k+-4>>2]|0);j=c[b+52>>2]|0}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=i;c[b+56>>2]=l;i=j;j=l}else i=j}c[(c[b+60>>2]|0)+(i<<2)>>2]=c[m>>2];i=i+1|0;c[b+52>>2]=i;n=n+1|0}while((n|0)!=(g|0))}if((h|0)>0){i=c[b+72>>2]|0;j=c[b+76>>2]|0;n=0;do{m=o+(n<<2)|0;if((i|0)==(j|0)){l=j|0?j<<1:1;if((j|0)<(l|0)){if(!l){k=0;i=j}else{c[5637]=(c[5637]|0)+1;i=qG((l<<2|3)+16|0)|0;if(!i)i=0;else{c[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}k=i;i=c[b+72>>2]|0}if((i|0)>0){j=0;do{c[k+(j<<2)>>2]=c[(c[b+80>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(i|0))}j=c[b+80>>2]|0;if(j){if(a[b+84>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0);i=c[b+72>>2]|0}c[b+80>>2]=0}a[b+84>>0]=1;c[b+80>>2]=k;c[b+76>>2]=l;j=l}else i=j}c[(c[b+80>>2]|0)+(i<<2)>>2]=c[m>>2];i=i+1|0;c[b+72>>2]=i;n=n+1|0}while((n|0)!=(h|0))}else i=c[b+72>>2]|0;if(((c[b+52>>2]|0)+i|0)<=(c[(c[b+4>>2]|0)+72>>2]|0))return;mr(b);return}function xr(b){b=b|0;var d=0;c[b>>2]=7916;d=c[b+520>>2]|0;if(d|0){if(a[b+524>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+520>>2]=0}a[b+524>>0]=1;c[b+520>>2]=0;c[b+512>>2]=0;c[b+516>>2]=0;c[b>>2]=3156;d=c[b+276>>2]|0;if(d|0){if(a[b+280>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0;c[5638]=(c[5638]|0)+1;rG(c[b+-4>>2]|0);return}function yr(a){a=a|0;return 488}function zr(a,b,e){a=a|0;b=b|0;e=e|0;Xe(a,b,e)|0;c[b+256>>2]=c[a+288>>2];c[b+260>>2]=c[a+292>>2];c[b+264>>2]=c[a+296>>2];c[b+268>>2]=c[a+300>>2];c[b+272>>2]=c[a+304>>2];c[b+276>>2]=c[a+308>>2];c[b+280>>2]=c[a+312>>2];c[b+284>>2]=c[a+316>>2];c[b+288>>2]=c[a+320>>2];c[b+292>>2]=c[a+324>>2];c[b+296>>2]=c[a+328>>2];c[b+300>>2]=c[a+332>>2];c[b+304>>2]=c[a+336>>2];c[b+308>>2]=c[a+340>>2];c[b+312>>2]=c[a+344>>2];c[b+316>>2]=c[a+348>>2];c[b+320>>2]=c[a+352>>2];c[b+324>>2]=c[a+356>>2];c[b+328>>2]=c[a+360>>2];c[b+332>>2]=c[a+364>>2];c[b+448>>2]=c[a+368>>2];c[b+336>>2]=c[a+568>>2];c[b+340>>2]=c[a+572>>2];c[b+344>>2]=c[a+576>>2];c[b+348>>2]=c[a+580>>2];c[b+352>>2]=c[a+372>>2];c[b+356>>2]=c[a+376>>2];c[b+360>>2]=c[a+380>>2];c[b+364>>2]=c[a+384>>2];c[b+368>>2]=c[a+388>>2];c[b+372>>2]=c[a+392>>2];c[b+376>>2]=c[a+396>>2];c[b+380>>2]=c[a+400>>2];c[b+384>>2]=c[a+404>>2];c[b+388>>2]=c[a+408>>2];c[b+392>>2]=c[a+412>>2];c[b+396>>2]=c[a+416>>2];c[b+400>>2]=c[a+420>>2];c[b+404>>2]=c[a+424>>2];c[b+408>>2]=c[a+428>>2];c[b+412>>2]=c[a+432>>2];c[b+416>>2]=c[a+436>>2];c[b+420>>2]=c[a+440>>2];c[b+424>>2]=c[a+444>>2];c[b+428>>2]=c[a+448>>2];c[b+432>>2]=c[a+452>>2];c[b+436>>2]=c[a+456>>2];c[b+440>>2]=c[a+460>>2];c[b+444>>2]=c[a+464>>2];c[b+452>>2]=c[a+468>>2];c[b+456>>2]=c[a+472>>2];c[b+484>>2]=d[a+476>>0];c[b+460>>2]=c[a+480>>2];c[b+464>>2]=c[a+484>>2];c[b+468>>2]=c[a+488>>2];c[b+472>>2]=c[a+492>>2];c[b+476>>2]=c[a+496>>2];c[b+480>>2]=c[a+500>>2];return 16174}function Ar(a,b){a=a|0;b=b|0;var d=0,e=0;d=c[(c[b>>2]|0)+16>>2]|0;e=vb[c[(c[a>>2]|0)+16>>2]&127](a)|0;e=Eb[d&63](b,e,1)|0;d=Eb[c[(c[a>>2]|0)+20>>2]&63](a,c[e+8>>2]|0,b)|0;pb[c[(c[b>>2]|0)+20>>2]&31](b,e,d,1497645650,a);return}function Br(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0,j=0,l=0,m=0.0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;n=i;i=i+32|0;c[b+236>>2]=2;c[b+336>>2]=0;c[b+336+4>>2]=0;c[b+336+8>>2]=0;c[b+336+12>>2]=0;c[b+336+16>>2]=0;c[b+336+20>>2]=0;c[b+336+24>>2]=0;c[b+336+28>>2]=0;c[b+568>>2]=1065353216;c[b+572>>2]=1065353216;c[b+576>>2]=1065353216;g[b+580>>2]=0.0;c[b+372>>2]=1065353216;c[b+376>>2]=1065353216;c[b+380>>2]=1065353216;e=b+384|0;h=e+36|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(h|0));c[b+436>>2]=0;c[b+436+4>>2]=0;c[b+436+8>>2]=0;c[b+436+12>>2]=0;c[b+436+16>>2]=0;c[b+436+20>>2]=0;c[b+436+24>>2]=0;c[b+436+28>>2]=0;f=+g[d+92>>2];m=+g[d+96>>2];g[n+20>>2]=f;g[n+16>>2]=m;g[n+12>>2]=0.0;g[n+8>>2]=1.0;c[b+468>>2]=c[(f<0.0?n+12|0:f>1.0?n+8|0:n+20|0)>>2];g[n+4>>2]=0.0;g[n>>2]=1.0;c[b+472>>2]=c[(m<0.0?n+4|0:m>1.0?n:n+16|0)>>2];c[b+496>>2]=c[d+112>>2];c[b+500>>2]=c[d+116>>2];e=c[d+4>>2]|0;c[b+504>>2]=e;c[b+632>>2]=0;c[b+636>>2]=0;a[b+476>>0]=a[d+120>>0]|0;c[b+480>>2]=c[d+124>>2];c[b+484>>2]=c[d+128>>2];c[b+488>>2]=c[d+132>>2];c[b+492>>2]=c[d+136>>2];if(!e){c[b+4>>2]=c[d+8>>2];c[b+4+4>>2]=c[d+8+4>>2];c[b+4+8>>2]=c[d+8+8>>2];c[b+4+12>>2]=c[d+8+12>>2];c[b+20>>2]=c[d+24>>2];c[b+20+4>>2]=c[d+24+4>>2];c[b+20+8>>2]=c[d+24+8>>2];c[b+20+12>>2]=c[d+24+12>>2];c[b+36>>2]=c[d+40>>2];c[b+36+4>>2]=c[d+40+4>>2];c[b+36+8>>2]=c[d+40+8>>2];c[b+36+12>>2]=c[d+40+12>>2];c[b+52>>2]=c[d+56>>2];c[b+52+4>>2]=c[d+56+4>>2];c[b+52+8>>2]=c[d+56+8>>2];c[b+52+12>>2]=c[d+56+12>>2];e=b+4|0;h=b+20|0;j=b+36|0;l=b+52|0}else{tb[c[(c[e>>2]|0)+8>>2]&127](e,b+4|0);e=b+4|0;h=b+20|0;j=b+36|0;l=b+52|0}c[b+68>>2]=c[e>>2];c[b+68+4>>2]=c[e+4>>2];c[b+68+8>>2]=c[e+8>>2];c[b+68+12>>2]=c[e+12>>2];c[b+84>>2]=c[h>>2];c[b+84+4>>2]=c[h+4>>2];c[b+84+8>>2]=c[h+8>>2];c[b+84+12>>2]=c[h+12>>2];c[b+100>>2]=c[j>>2];c[b+100+4>>2]=c[j+4>>2];c[b+100+8>>2]=c[j+8>>2];c[b+100+12>>2]=c[j+12>>2];c[b+116>>2]=c[l>>2];c[b+116+4>>2]=c[l+4>>2];c[b+116+8>>2]=c[l+8>>2];c[b+116+12>>2]=c[l+12>>2];c[b+132>>2]=0;c[b+132+4>>2]=0;c[b+132+8>>2]=0;c[b+132+12>>2]=0;c[b+132+16>>2]=0;c[b+132+20>>2]=0;c[b+132+24>>2]=0;c[b+132+28>>2]=0;c[b+224>>2]=c[d+100>>2];c[b+232>>2]=c[d+104>>2];c[b+228>>2]=c[d+108>>2];tb[c[(c[b>>2]|0)+8>>2]&127](b,c[d+72>>2]|0);e=c[5476]|0;c[5476]=e+1;c[b+532>>2]=e;f=+g[d>>2];e=c[b+204>>2]|0;if(f==0.0){c[b+204>>2]=e|1;m=0.0}else{c[b+204>>2]=e&-2;m=1.0/f}g[b+368>>2]=m;p=f*+g[b+408>>2];o=f*+g[b+412>>2];g[b+388>>2]=f*+g[b+404>>2];g[b+392>>2]=p;g[b+396>>2]=o;g[b+400>>2]=0.0;f=+g[d+76>>2];h=f!=0.0?(g[k>>2]=1.0/f,c[k>>2]|0):0;f=+g[d+80>>2];e=f!=0.0?(g[k>>2]=1.0/f,c[k>>2]|0):0;f=+g[d+84>>2];d=f!=0.0?(g[k>>2]=1.0/f,c[k>>2]|0):0;c[b+420>>2]=h;c[b+424>>2]=e;c[b+428>>2]=d;g[b+432>>2]=0.0;r=m*+g[b+376>>2];x=m*+g[b+380>>2];g[b+584>>2]=m*+g[b+372>>2];g[b+588>>2]=r;g[b+592>>2]=x;g[b+596>>2]=0.0;x=+g[b+4>>2];r=(c[k>>2]=h,+g[k>>2]);w=+g[b+8>>2];f=(c[k>>2]=e,+g[k>>2]);v=+g[b+12>>2];o=(c[k>>2]=d,+g[k>>2]);u=+g[b+20>>2];t=+g[b+24>>2];s=+g[b+28>>2];q=+g[b+36>>2];p=+g[b+40>>2];m=+g[b+44>>2];g[b+288>>2]=x*(x*r)+w*(w*f)+v*(v*o);g[b+292>>2]=x*r*u+w*f*t+v*o*s;g[b+296>>2]=x*r*q+w*f*p+v*o*m;g[b+300>>2]=0.0;g[b+304>>2]=x*(r*u)+w*(f*t)+v*(o*s);g[b+308>>2]=u*(r*u)+t*(f*t)+s*(o*s);g[b+312>>2]=r*u*q+f*t*p+o*s*m;g[b+316>>2]=0.0;g[b+320>>2]=x*(r*q)+w*(f*p)+v*(o*m);g[b+324>>2]=u*(r*q)+t*(f*p)+s*(o*m);g[b+328>>2]=q*(r*q)+p*(f*p)+m*(o*m);g[b+332>>2]=0.0;c[b+528>>2]=8;c[b+536>>2]=0;c[b+536+4>>2]=0;c[b+536+8>>2]=0;c[b+536+12>>2]=0;c[b+536+16>>2]=0;c[b+536+20>>2]=0;c[b+536+24>>2]=0;c[b+536+28>>2]=0;m=+g[b+368>>2];o=m*+g[b+376>>2];p=m*+g[b+380>>2];g[b+584>>2]=+g[b+372>>2]*m;g[b+588>>2]=o;g[b+592>>2]=p;e=b+596|0;h=e+36|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(h|0));i=n;return}function Cr(b,d,e,f,h){b=b|0;d=+d;e=e|0;f=f|0;h=h|0;var j=0;j=i;i=i+144|0;c[b+164>>2]=1065353216;c[b+168>>2]=1065353216;c[b+172>>2]=1065353216;g[b+176>>2]=0.0;c[b+180>>2]=0;g[b+184>>2]=999999984306749440.0;c[b+188>>2]=0;c[b+188+4>>2]=0;c[b+188+8>>2]=0;c[b+188+12>>2]=0;c[b+204>>2]=1;c[b+208>>2]=-1;c[b+212>>2]=-1;c[b+216>>2]=1;g[b+220>>2]=0.0;g[b+224>>2]=.5;g[b+228>>2]=0.0;g[b+232>>2]=0.0;c[b+236>>2]=1;c[b+240>>2]=0;c[b+244>>2]=-1;g[b+248>>2]=1.0;g[b+252>>2]=0.0;g[b+256>>2]=0.0;c[b+260>>2]=0;a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0;c[b+284>>2]=0;c[b+4>>2]=1065353216;c[b+8>>2]=0;c[b+8+4>>2]=0;c[b+8+8>>2]=0;c[b+8+12>>2]=0;c[b+24>>2]=1065353216;c[b+28>>2]=0;c[b+28+4>>2]=0;c[b+28+8>>2]=0;c[b+28+12>>2]=0;c[b+44>>2]=1065353216;c[b+48>>2]=0;c[b+48+4>>2]=0;c[b+48+8>>2]=0;c[b+48+12>>2]=0;c[b+48+16>>2]=0;c[b>>2]=7916;a[b+524>>0]=1;c[b+520>>2]=0;c[b+512>>2]=0;c[b+516>>2]=0;g[j>>2]=d;c[j+4>>2]=e;c[j+72>>2]=f;c[j+76>>2]=c[h>>2];c[j+76+4>>2]=c[h+4>>2];c[j+76+8>>2]=c[h+8>>2];c[j+76+12>>2]=c[h+12>>2];g[j+92>>2]=0.0;g[j+96>>2]=0.0;g[j+100>>2]=.5;g[j+104>>2]=0.0;g[j+108>>2]=0.0;g[j+112>>2]=.800000011920929;g[j+116>>2]=1.0;a[j+120>>0]=0;g[j+124>>2]=.004999999888241291;g[j+128>>2]=.009999999776482582;g[j+132>>2]=.009999999776482582;g[j+136>>2]=.009999999776482582;c[j+8>>2]=1065353216;c[j+12>>2]=0;c[j+12+4>>2]=0;c[j+12+8>>2]=0;c[j+12+12>>2]=0;c[j+28>>2]=1065353216;c[j+32>>2]=0;c[j+32+4>>2]=0;c[j+32+8>>2]=0;c[j+32+12>>2]=0;c[j+48>>2]=1065353216;c[j+52>>2]=0;c[j+52+4>>2]=0;c[j+52+8>>2]=0;c[j+52+12>>2]=0;c[j+52+16>>2]=0;Br(b,j);i=j;return}function Dr(b,d){b=b|0;d=+d;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;l=+g[b+468>>2];i=+P(+(1.0-l),+d);e=i*+g[b+336>>2];g[b+336>>2]=e;h=i*+g[b+340>>2];g[b+340>>2]=h;i=i*+g[b+344>>2];g[b+344>>2]=i;m=+g[b+472>>2];f=+P(+(1.0-m),+d);d=f*+g[b+352>>2];g[b+352>>2]=d;j=f*+g[b+356>>2];g[b+356>>2]=j;f=f*+g[b+360>>2];g[b+360>>2]=f;if(!(a[b+476>>0]|0))return;if(f*f+(d*d+j*j)<+g[b+488>>2]?e*e+h*h+i*i<+g[b+484>>2]:0){n=+g[b+480>>2];g[b+352>>2]=d*n;g[b+356>>2]=n*j;g[b+360>>2]=n*f;g[b+336>>2]=n*e;g[b+340>>2]=n*h;g[b+344>>2]=n*i;e=n*e;h=n*h;i=n*i;k=d*n;j=n*j;f=n*f}else k=d;d=+O(+(e*e+h*h+i*i));do if(d<l)if(d>.004999999888241291){g[b+336>>2]=e-e*(1.0/d)*.004999999888241291;g[b+340>>2]=h-h*(1.0/d)*.004999999888241291;g[b+344>>2]=i-i*(1.0/d)*.004999999888241291;break}else{c[b+336>>2]=0;c[b+336+4>>2]=0;c[b+336+8>>2]=0;c[b+336+12>>2]=0;break}while(0);d=+O(+(k*k+j*j+f*f));if(!(d<m))return;if(d>.004999999888241291){g[b+352>>2]=k-k*(1.0/d)*.004999999888241291;g[b+356>>2]=j-j*(1.0/d)*.004999999888241291;g[b+360>>2]=f-f*(1.0/d)*.004999999888241291;return}else{c[b+352>>2]=0;c[b+352+4>>2]=0;c[b+352+8>>2]=0;c[b+352+12>>2]=0;return}}function Er(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;if(!(c[a+204>>2]&2)){c[a+68>>2]=c[b>>2];c[a+68+4>>2]=c[b+4>>2];c[a+68+8>>2]=c[b+8>>2];c[a+68+12>>2]=c[b+12>>2];c[a+84>>2]=c[b+16>>2];c[a+84+4>>2]=c[b+16+4>>2];c[a+84+8>>2]=c[b+16+8>>2];c[a+84+12>>2]=c[b+16+12>>2];c[a+100>>2]=c[b+32>>2];c[a+100+4>>2]=c[b+32+4>>2];c[a+100+8>>2]=c[b+32+8>>2];c[a+100+12>>2]=c[b+32+12>>2];c[a+116>>2]=c[b+48>>2];c[a+116+4>>2]=c[b+48+4>>2];c[a+116+8>>2]=c[b+48+8>>2];c[a+116+12>>2]=c[b+48+12>>2];d=a+20|0;e=b+16|0;f=a+36|0;h=b+32|0;i=a+52|0;j=b+48|0;k=a+4|0}else{c[a+68>>2]=c[a+4>>2];c[a+68+4>>2]=c[a+4+4>>2];c[a+68+8>>2]=c[a+4+8>>2];c[a+68+12>>2]=c[a+4+12>>2];c[a+84>>2]=c[a+20>>2];c[a+84+4>>2]=c[a+20+4>>2];c[a+84+8>>2]=c[a+20+8>>2];c[a+84+12>>2]=c[a+20+12>>2];c[a+100>>2]=c[a+36>>2];c[a+100+4>>2]=c[a+36+4>>2];c[a+100+8>>2]=c[a+36+8>>2];c[a+100+12>>2]=c[a+36+12>>2];c[a+116>>2]=c[a+52>>2];c[a+116+4>>2]=c[a+52+4>>2];c[a+116+8>>2]=c[a+52+8>>2];c[a+116+12>>2]=c[a+52+12>>2];d=a+20|0;e=b+16|0;f=a+36|0;h=b+32|0;i=a+52|0;j=b+48|0;k=a+4|0}c[a+132>>2]=c[a+336>>2];c[a+132+4>>2]=c[a+336+4>>2];c[a+132+8>>2]=c[a+336+8>>2];c[a+132+12>>2]=c[a+336+12>>2];c[a+148>>2]=c[a+352>>2];c[a+148+4>>2]=c[a+352+4>>2];c[a+148+8>>2]=c[a+352+8>>2];c[a+148+12>>2]=c[a+352+12>>2];c[k>>2]=c[b>>2];c[k+4>>2]=c[b+4>>2];c[k+8>>2]=c[b+8>>2];c[k+12>>2]=c[b+12>>2];c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];c[f>>2]=c[h>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2];c[i>>2]=c[j>>2];c[i+4>>2]=c[j+4>>2];c[i+8>>2]=c[j+8>>2];c[i+12>>2]=c[j+12>>2];w=+g[a+4>>2];q=+g[a+420>>2];v=+g[a+8>>2];o=+g[a+424>>2];u=+g[a+12>>2];m=+g[a+428>>2];t=+g[a+20>>2];s=+g[a+24>>2];r=+g[a+28>>2];p=+g[a+36>>2];n=+g[a+40>>2];l=+g[a+44>>2];g[a+288>>2]=w*(w*q)+v*(v*o)+u*(u*m);g[a+292>>2]=w*q*t+v*o*s+u*m*r;g[a+296>>2]=w*q*p+v*o*n+u*m*l;g[a+300>>2]=0.0;g[a+304>>2]=w*(q*t)+v*(o*s)+u*(m*r);g[a+308>>2]=t*(q*t)+s*(o*s)+r*(m*r);g[a+312>>2]=q*t*p+o*s*n+m*r*l;g[a+316>>2]=0.0;g[a+320>>2]=w*(q*p)+v*(o*n)+u*(m*l);g[a+324>>2]=t*(q*p)+s*(o*n)+r*(m*l);g[a+328>>2]=p*(q*p)+n*(o*n)+l*(m*l);g[a+332>>2]=0.0;return}function Fr(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;e=c[b+512>>2]|0;a:do if((e|0)>0){g=c[b+520>>2]|0;f=0;while(1){if((c[g+(f<<2)>>2]|0)==(d|0))break;f=f+1|0;if((f|0)>=(e|0))break a}if((f|0)!=(e|0))return}while(0);if((e|0)==(c[b+516>>2]|0)?(h=e|0?e<<1:1,(e|0)<(h|0)):0){if(!h)g=0;else{c[5637]=(c[5637]|0)+1;e=qG((h<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}g=e;e=c[b+512>>2]|0}if((e|0)>0){f=0;do{c[g+(f<<2)>>2]=c[(c[b+520>>2]|0)+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}f=c[b+520>>2]|0;if(f){if(a[b+524>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0);e=c[b+512>>2]|0}c[b+520>>2]=0}a[b+524>>0]=1;c[b+520>>2]=g;c[b+516>>2]=h}c[(c[b+520>>2]|0)+(e<<2)>>2]=d;c[b+512>>2]=e+1;h=c[d+28>>2]|0;d=c[d+32>>2]|0;if((h|0)==(b|0)){e=c[b+268>>2]|0;if((e|0)==(c[b+272>>2]|0)?(j=e|0?e<<1:1,(e|0)<(j|0)):0){if(!j)g=0;else{c[5637]=(c[5637]|0)+1;e=qG((j<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}g=e;e=c[b+268>>2]|0}if((e|0)>0){f=0;do{c[g+(f<<2)>>2]=c[(c[b+276>>2]|0)+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}f=c[b+276>>2]|0;if(f){if(a[b+280>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0);e=c[b+268>>2]|0}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=g;c[b+272>>2]=j}c[(c[b+276>>2]|0)+(e<<2)>>2]=d;c[b+268>>2]=e+1;c[b+260>>2]=e>>>31^1;return}else{e=c[d+268>>2]|0;if((e|0)==(c[d+272>>2]|0)?(i=e|0?e<<1:1,(e|0)<(i|0)):0){if(!i)g=0;else{c[5637]=(c[5637]|0)+1;e=qG((i<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}g=e;e=c[d+268>>2]|0}if((e|0)>0){f=0;do{c[g+(f<<2)>>2]=c[(c[d+276>>2]|0)+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}f=c[d+276>>2]|0;if(f){if(a[d+280>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0);e=c[d+268>>2]|0}c[d+276>>2]=0}a[d+280>>0]=1;c[d+276>>2]=g;c[d+272>>2]=i}c[(c[d+276>>2]|0)+(e<<2)>>2]=h;c[d+268>>2]=e+1;c[d+260>>2]=e>>>31^1;return}}function Gr(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;g=c[a+512>>2]|0;if((g|0)<=0)return;h=c[a+520>>2]|0;d=0;while(1){if((c[h+(d<<2)>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(g|0)){i=25;break}}if((i|0)==25)return;if((d|0)<(g|0))f=0;else return;while(1){d=h+(f<<2)|0;if((c[d>>2]|0)==(b|0)){i=8;break}e=f+1|0;if((e|0)<(g|0))f=e;else break}if((i|0)==8?(f|0)<(g|0):0){c[d>>2]=c[h+(g+-1<<2)>>2];c[(c[a+520>>2]|0)+(g+-1<<2)>>2]=b;c[a+512>>2]=g+-1}h=c[b+28>>2]|0;i=c[b+32>>2]|0;if((h|0)==(a|0)){d=c[a+268>>2]|0;a:do if((d|0)>0){g=c[a+276>>2]|0;e=0;while(1){f=g+(e<<2)|0;if((c[f>>2]|0)==(i|0))break;e=e+1|0;if((e|0)>=(d|0))break a}if((e|0)<(d|0)){c[f>>2]=c[g+(d+-1<<2)>>2];c[(c[a+276>>2]|0)+(d+-1<<2)>>2]=i;c[a+268>>2]=d+-1;d=d+-1|0}}while(0);c[a+260>>2]=(d|0)>0&1;return}else{d=c[i+268>>2]|0;b:do if((d|0)>0){g=c[i+276>>2]|0;e=0;while(1){f=g+(e<<2)|0;if((c[f>>2]|0)==(h|0))break;e=e+1|0;if((e|0)>=(d|0))break b}if((e|0)<(d|0)){c[f>>2]=c[g+(d+-1<<2)>>2];c[(c[i+276>>2]|0)+(d+-1<<2)>>2]=h;c[i+268>>2]=d+-1;d=d+-1|0}}while(0);c[i+260>>2]=(d|0)>0&1;return}}function Hr(b){b=b|0;var d=0;c[b>>2]=7952;d=c[b+136>>2]|0;if(d|0){if(a[b+140>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;d=c[b+76>>2]|0;if(d|0){if(a[b+80>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;d=c[b+56>>2]|0;if(d|0){if(a[b+60>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;d=c[b+36>>2]|0;if(d|0){if(a[b+40>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}if(a[b+20>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}function Ir(a){a=a|0;Hr(a);rG(a);return}function Jr(a,b,d){a=a|0;b=b|0;d=+d;qb[c[(c[a>>2]|0)+16>>2]&31](a,d);return}function Kr(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0,m=0;f=i;i=i+48|0;if((c[b+128>>2]|0)<=0){i=f;return}e=0;do{m=c[b+136>>2]|0;c[f+32>>2]=(a[m+(e*284|0)+84>>0]|0)==0?1065353216:0;c[f+32+4>>2]=0;c[f+32+8>>2]=1065353216;g[f+32+12>>2]=0.0;l=m+(e*284|0)+140|0;c[f+16>>2]=c[l>>2];c[f+16+4>>2]=c[l+4>>2];c[f+16+8>>2]=c[l+8>>2];c[f+16+12>>2]=c[l+12>>2];l=c[b+112>>2]|0;h=c[(c[d>>2]|0)+16>>2]|0;k=+g[m+(e*284|0)+108+(l<<2)>>2]+ +g[f+16+4>>2];j=+g[m+(e*284|0)+124+(l<<2)>>2]+ +g[f+16+8>>2];g[f>>2]=+g[m+(e*284|0)+92+(l<<2)>>2]+ +g[f+16>>2];g[f+4>>2]=k;g[f+8>>2]=j;g[f+12>>2]=0.0;bc[h&127](d,f+16|0,f,f+32|0);bc[c[(c[d>>2]|0)+16>>2]&127](d,f+16|0,(c[b+136>>2]|0)+(e*284|0)+16|0,f+32|0);e=e+1|0}while((e|0)<(c[b+128>>2]|0));i=f;return}
function Gm(a,b,f,j){a=a|0;b=b|0;f=f|0;j=j|0;var k=0.0,l=0.0,m=0.0,n=0,o=0,p=0.0,q=0.0,r=0,s=0,t=0,u=0;o=i;i=i+80|0;f=vb[c[(c[a>>2]|0)+28>>2]&127](a)|0;k=+g[a+4>>2];l=+g[a+8>>2];m=+g[a+12>>2];if((f|0)<=0){i=o;return}n=0;do{Nb[c[(c[a>>2]|0)+16>>2]&3](a,o+76|0,o+52|0,o+64|0,o+56|0,o+72|0,o+68|0,o+48|0,o+60|0,n);a:do switch(c[o+64>>2]|0){case 0:{switch(c[o+60>>2]|0){case 2:{if((c[o+48>>2]|0)>0)j=0;else break a;do{r=(c[o+72>>2]|0)+(_(c[o+68>>2]|0,j)|0)|0;t=c[o+76>>2]|0;s=c[o+56>>2]|0;u=t+(_(s,c[r>>2]|0)|0)|0;q=l*+g[u+4>>2];p=m*+g[u+8>>2];g[o>>2]=k*+g[u>>2];g[o+4>>2]=q;g[o+8>>2]=p;g[o+12>>2]=0.0;u=t+(_(s,c[r+4>>2]|0)|0)|0;p=l*+g[u+4>>2];q=m*+g[u+8>>2];g[o+16>>2]=k*+g[u>>2];g[o+20>>2]=p;g[o+24>>2]=q;g[o+28>>2]=0.0;r=t+(_(s,c[r+8>>2]|0)|0)|0;q=l*+g[r+4>>2];p=m*+g[r+8>>2];g[o+32>>2]=k*+g[r>>2];g[o+36>>2]=q;g[o+40>>2]=p;g[o+44>>2]=0.0;bc[c[(c[b>>2]|0)+8>>2]&127](b,o,n,j);j=j+1|0}while((j|0)<(c[o+48>>2]|0));break}case 3:{if((c[o+48>>2]|0)>0)j=0;else break a;do{t=(c[o+72>>2]|0)+(_(c[o+68>>2]|0,j)|0)|0;s=c[o+76>>2]|0;u=c[o+56>>2]|0;r=s+(_(e[t>>1]|0,u)|0)|0;p=l*+g[r+4>>2];q=m*+g[r+8>>2];g[o>>2]=k*+g[r>>2];g[o+4>>2]=p;g[o+8>>2]=q;g[o+12>>2]=0.0;r=s+(_(e[t+2>>1]|0,u)|0)|0;q=l*+g[r+4>>2];p=m*+g[r+8>>2];g[o+16>>2]=k*+g[r>>2];g[o+20>>2]=q;g[o+24>>2]=p;g[o+28>>2]=0.0;u=s+(_(e[t+4>>1]|0,u)|0)|0;p=l*+g[u+4>>2];q=m*+g[u+8>>2];g[o+32>>2]=k*+g[u>>2];g[o+36>>2]=p;g[o+40>>2]=q;g[o+44>>2]=0.0;bc[c[(c[b>>2]|0)+8>>2]&127](b,o,n,j);j=j+1|0}while((j|0)<(c[o+48>>2]|0));break}case 5:{if((c[o+48>>2]|0)>0)j=0;else break a;do{t=(c[o+72>>2]|0)+(_(c[o+68>>2]|0,j)|0)|0;s=c[o+76>>2]|0;u=c[o+56>>2]|0;r=s+(_(d[t>>0]|0,u)|0)|0;p=l*+g[r+4>>2];q=m*+g[r+8>>2];g[o>>2]=k*+g[r>>2];g[o+4>>2]=p;g[o+8>>2]=q;g[o+12>>2]=0.0;r=s+(_(d[t+1>>0]|0,u)|0)|0;q=l*+g[r+4>>2];p=m*+g[r+8>>2];g[o+16>>2]=k*+g[r>>2];g[o+20>>2]=q;g[o+24>>2]=p;g[o+28>>2]=0.0;u=s+(_(d[t+2>>0]|0,u)|0)|0;p=l*+g[u+4>>2];q=m*+g[u+8>>2];g[o+32>>2]=k*+g[u>>2];g[o+36>>2]=p;g[o+40>>2]=q;g[o+44>>2]=0.0;bc[c[(c[b>>2]|0)+8>>2]&127](b,o,n,j);j=j+1|0}while((j|0)<(c[o+48>>2]|0));break}default:break a}break}case 1:{switch(c[o+60>>2]|0){case 2:{if((c[o+48>>2]|0)>0)j=0;else break a;do{u=(c[o+72>>2]|0)+(_(c[o+68>>2]|0,j)|0)|0;s=c[o+76>>2]|0;t=c[o+56>>2]|0;r=s+(_(t,c[u>>2]|0)|0)|0;p=l*+h[r+8>>3];q=m*+h[r+16>>3];g[o>>2]=k*+h[r>>3];g[o+4>>2]=p;g[o+8>>2]=q;g[o+12>>2]=0.0;r=s+(_(t,c[u+4>>2]|0)|0)|0;q=l*+h[r+8>>3];p=m*+h[r+16>>3];g[o+16>>2]=k*+h[r>>3];g[o+20>>2]=q;g[o+24>>2]=p;g[o+28>>2]=0.0;u=s+(_(t,c[u+8>>2]|0)|0)|0;p=l*+h[u+8>>3];q=m*+h[u+16>>3];g[o+32>>2]=k*+h[u>>3];g[o+36>>2]=p;g[o+40>>2]=q;g[o+44>>2]=0.0;bc[c[(c[b>>2]|0)+8>>2]&127](b,o,n,j);j=j+1|0}while((j|0)<(c[o+48>>2]|0));break}case 3:{if((c[o+48>>2]|0)>0)j=0;else break a;do{t=(c[o+72>>2]|0)+(_(c[o+68>>2]|0,j)|0)|0;s=c[o+76>>2]|0;u=c[o+56>>2]|0;r=s+(_(e[t>>1]|0,u)|0)|0;p=l*+h[r+8>>3];q=m*+h[r+16>>3];g[o>>2]=k*+h[r>>3];g[o+4>>2]=p;g[o+8>>2]=q;g[o+12>>2]=0.0;r=s+(_(e[t+2>>1]|0,u)|0)|0;q=l*+h[r+8>>3];p=m*+h[r+16>>3];g[o+16>>2]=k*+h[r>>3];g[o+20>>2]=q;g[o+24>>2]=p;g[o+28>>2]=0.0;u=s+(_(e[t+4>>1]|0,u)|0)|0;p=l*+h[u+8>>3];q=m*+h[u+16>>3];g[o+32>>2]=k*+h[u>>3];g[o+36>>2]=p;g[o+40>>2]=q;g[o+44>>2]=0.0;bc[c[(c[b>>2]|0)+8>>2]&127](b,o,n,j);j=j+1|0}while((j|0)<(c[o+48>>2]|0));break}case 5:{if((c[o+48>>2]|0)>0)j=0;else break a;do{t=(c[o+72>>2]|0)+(_(c[o+68>>2]|0,j)|0)|0;s=c[o+76>>2]|0;u=c[o+56>>2]|0;r=s+(_(d[t>>0]|0,u)|0)|0;p=l*+h[r+8>>3];q=m*+h[r+16>>3];g[o>>2]=k*+h[r>>3];g[o+4>>2]=p;g[o+8>>2]=q;g[o+12>>2]=0.0;r=s+(_(d[t+1>>0]|0,u)|0)|0;q=l*+h[r+8>>3];p=m*+h[r+16>>3];g[o+16>>2]=k*+h[r>>3];g[o+20>>2]=q;g[o+24>>2]=p;g[o+28>>2]=0.0;u=s+(_(d[t+2>>0]|0,u)|0)|0;p=l*+h[u+8>>3];q=m*+h[u+16>>3];g[o+32>>2]=k*+h[u>>3];g[o+36>>2]=p;g[o+40>>2]=q;g[o+44>>2]=0.0;bc[c[(c[b>>2]|0)+8>>2]&127](b,o,n,j);j=j+1|0}while((j|0)<(c[o+48>>2]|0));break}default:break a}break}default:{}}while(0);tb[c[(c[a>>2]|0)+24>>2]&127](a,n);n=n+1|0}while((n|0)!=(f|0));i=o;return}function Hm(a){a=a|0;return 28}function Im(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;t=i;i=i+32|0;g=vb[c[(c[d>>2]|0)+28>>2]&127](d)|0;c[e+20>>2]=g;c[e>>2]=0;if(!g){s=d+4|0;f=e+4|0;s=c[s>>2]|0;c[f>>2]=s;f=d+8|0;f=c[f>>2]|0;s=e+8|0;c[s>>2]=f;s=d+12|0;s=c[s>>2]|0;f=e+12|0;c[f>>2]=s;f=d+16|0;f=c[f>>2]|0;d=e+16|0;c[d>>2]=f;i=t;return 14151}s=Eb[c[(c[f>>2]|0)+16>>2]&63](f,32,g)|0;g=c[s+8>>2]|0;c[e>>2]=Ob[c[(c[f>>2]|0)+28>>2]&31](f,g)|0;r=vb[c[(c[d>>2]|0)+28>>2]&127](d)|0;a:do if((r|0)>0){q=0;while(1){Nb[c[(c[d>>2]|0)+16>>2]&3](d,t+28|0,t+4|0,t+16|0,t+8|0,t+24|0,t+20|0,t,t+12|0,q);c[g+24>>2]=c[t>>2];c[g+28>>2]=c[t+4>>2];k=g+12|0;m=g+16|0;p=g+4|0;c[g>>2]=0;c[g+4>>2]=0;c[g+8>>2]=0;c[g+12>>2]=0;c[g+16>>2]=0;c[g+20>>2]=0;switch(c[t+12>>2]|0){case 2:{j=c[t>>2]|0;if(j|0){j=Eb[c[(c[f>>2]|0)+16>>2]&63](f,4,j*3|0)|0;k=c[j+8>>2]|0;c[g+8>>2]=Ob[c[(c[f>>2]|0)+28>>2]&31](f,k)|0;if((c[t>>2]|0)>0){l=c[t+24>>2]|0;m=0;do{n=l+(_(c[t+20>>2]|0,m)|0)|0;o=m*3|0;c[k+(o<<2)>>2]=c[n>>2];c[k+(o+1<<2)>>2]=c[n+4>>2];c[k+(o+2<<2)>>2]=c[n+8>>2];m=m+1|0}while((m|0)<(c[t>>2]|0))}pb[c[(c[f>>2]|0)+20>>2]&31](f,j,14051,1497453121,c[j+8>>2]|0)}break}case 3:{j=c[t>>2]|0;if(j|0){n=Eb[c[(c[f>>2]|0)+16>>2]&63](f,8,j)|0;o=c[n+8>>2]|0;c[k>>2]=Ob[c[(c[f>>2]|0)+28>>2]&31](f,o)|0;j=c[t>>2]|0;if((j|0)>0){k=c[t+24>>2]|0;l=c[t+20>>2]|0;m=0;do{u=k+(_(l,m)|0)|0;b[o+(m<<3)>>1]=b[u>>1]|0;b[o+(m<<3)+2>>1]=b[u+2>>1]|0;b[o+(m<<3)+4>>1]=b[u+4>>1]|0;m=m+1|0}while((m|0)!=(j|0))}pb[c[(c[f>>2]|0)+20>>2]&31](f,n,14066,1497453121,c[n+8>>2]|0)}break}case 5:{j=c[t>>2]|0;if(j|0){k=Eb[c[(c[f>>2]|0)+16>>2]&63](f,4,j)|0;l=c[k+8>>2]|0;c[m>>2]=Ob[c[(c[f>>2]|0)+28>>2]&31](f,l)|0;if((c[t>>2]|0)>0){j=0;do{u=(c[t+24>>2]|0)+(_(c[t+20>>2]|0,j)|0)|0;a[l+(j<<2)>>0]=a[u>>0]|0;a[l+(j<<2)+1>>0]=a[u+1>>0]|0;a[l+(j<<2)+2>>0]=a[u+2>>0]|0;j=j+1|0}while((j|0)<(c[t>>2]|0))}pb[c[(c[f>>2]|0)+20>>2]&31](f,k,14093,1497453121,c[k+8>>2]|0)}break}default:{}}switch(c[t+16>>2]|0){case 0:{j=c[t+4>>2]|0;if(j|0){j=Eb[c[(c[f>>2]|0)+16>>2]&63](f,16,j)|0;k=c[j+8>>2]|0;c[g>>2]=Ob[c[(c[f>>2]|0)+28>>2]&31](f,k)|0;l=c[t+4>>2]|0;if((l|0)>0){m=c[t+28>>2]|0;n=c[t+8>>2]|0;o=0;do{u=m+(_(n,o)|0)|0;c[k+(o<<4)>>2]=c[u>>2];c[k+(o<<4)+4>>2]=c[u+4>>2];c[k+(o<<4)+8>>2]=c[u+8>>2];o=o+1|0}while((o|0)!=(l|0))}pb[c[(c[f>>2]|0)+20>>2]&31](f,j,16354,1497453121,c[j+8>>2]|0)}break}case 1:{j=c[t+4>>2]|0;if(j|0){n=Eb[c[(c[f>>2]|0)+16>>2]&63](f,32,j)|0;o=c[n+8>>2]|0;c[p>>2]=Ob[c[(c[f>>2]|0)+28>>2]&31](f,o)|0;j=c[t+4>>2]|0;if((j|0)>0){k=c[t+28>>2]|0;l=c[t+8>>2]|0;m=0;do{u=k+(_(l,m)|0)|0;h[o+(m<<5)>>3]=+h[u>>3];h[o+(m<<5)+8>>3]=+h[u+8>>3];h[o+(m<<5)+16>>3]=+h[u+16>>3];m=m+1|0}while((m|0)!=(j|0))}pb[c[(c[f>>2]|0)+20>>2]&31](f,n,14116,1497453121,c[n+8>>2]|0)}break}default:{}}tb[c[(c[d>>2]|0)+24>>2]&127](d,q);q=q+1|0;if((q|0)==(r|0)){g=f;break a}else g=g+32|0}}else g=f;while(0);pb[c[(c[g>>2]|0)+20>>2]&31](f,s,14136,1497453121,c[s+8>>2]|0);f=d+4|0;u=e+4|0;f=c[f>>2]|0;c[u>>2]=f;u=d+8|0;u=c[u>>2]|0;f=e+8|0;c[f>>2]=u;f=d+12|0;f=c[f>>2]|0;u=e+12|0;c[u>>2]=f;d=d+16|0;d=c[d>>2]|0;u=e+16|0;c[u>>2]=d;i=t;return 14151}function Jm(a){a=a|0;return}function Km(a){a=a|0;return}function Lm(b){b=b|0;var d=0;c[b>>2]=6556;d=c[b+32>>2]|0;if(d|0){if(a[b+36>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;return}function Mm(b){b=b|0;var d=0;c[b>>2]=6556;d=c[b+32>>2]|0;if(d|0){if(a[b+36>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;c[5638]=(c[5638]|0)+1;rG(c[b+-4>>2]|0);return}function Nm(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;a=c[a+32>>2]|0;c[d>>2]=c[a+(k<<5)+12>>2];c[b>>2]=c[a+(k<<5)+16>>2];c[e>>2]=c[a+(k<<5)+28>>2];c[f>>2]=c[a+(k<<5)+20>>2];c[i>>2]=c[a+(k<<5)>>2];c[g>>2]=c[a+(k<<5)+4>>2];c[h>>2]=c[a+(k<<5)+8>>2];c[j>>2]=c[a+(k<<5)+24>>2];return}function Om(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;a=c[a+32>>2]|0;c[d>>2]=c[a+(k<<5)+12>>2];c[b>>2]=c[a+(k<<5)+16>>2];c[e>>2]=c[a+(k<<5)+28>>2];c[f>>2]=c[a+(k<<5)+20>>2];c[i>>2]=c[a+(k<<5)>>2];c[g>>2]=c[a+(k<<5)+4>>2];c[h>>2]=c[a+(k<<5)+8>>2];c[j>>2]=c[a+(k<<5)+24>>2];return}function Pm(a,b){a=a|0;b=b|0;return}function Qm(a,b){a=a|0;b=b|0;return}function Rm(a){a=a|0;return c[a+24>>2]|0}function Sm(a,b){a=a|0;b=b|0;return}function Tm(a,b){a=a|0;b=b|0;return}function Um(a){a=a|0;return (c[a+48>>2]|0)==1|0}function Vm(a,b,d){a=a|0;b=b|0;d=d|0;c[a+52>>2]=c[b>>2];c[a+52+4>>2]=c[b+4>>2];c[a+52+8>>2]=c[b+8>>2];c[a+52+12>>2]=c[b+12>>2];c[a+68>>2]=c[d>>2];c[a+68+4>>2]=c[d+4>>2];c[a+68+8>>2]=c[d+8>>2];c[a+68+12>>2]=c[d+12>>2];c[a+48>>2]=1;return}function Wm(a,b,d){a=a|0;b=b|0;d=d|0;c[b>>2]=c[a+52>>2];c[b+4>>2]=c[a+52+4>>2];c[b+8>>2]=c[a+52+8>>2];c[b+12>>2]=c[a+52+12>>2];c[d>>2]=c[a+68>>2];c[d+4>>2]=c[a+68+4>>2];c[d+8>>2]=c[a+68+8>>2];c[d+12>>2]=c[a+68+12>>2];return}function Xm(b){b=b|0;var d=0;c[b>>2]=6624;d=c[b+156>>2]|0;if(d|0){if(a[b+160>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+156>>2]=0}a[b+160>>0]=1;c[b+156>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;d=c[b+136>>2]|0;if(d|0){if(a[b+140>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;d=c[b+116>>2]|0;if(d|0){if(a[b+120>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;d=c[b+96>>2]|0;if(d|0){if(a[b+100>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;c[b>>2]=6556;d=c[b+32>>2]|0;if(!d){a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;b=b+28|0;c[b>>2]=0;return}if(a[b+36>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+32>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;b=b+28|0;c[b>>2]=0;return}function Ym(a){a=a|0;Xm(a);if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function Zm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;if(a[b+165>>0]|0){if((c[b+92>>2]|0)>=(d|0))return;if((d|0)!=0?(c[5637]=(c[5637]|0)+1,e=qG((d<<4|3)+16|0)|0,(e|0)!=0):0){c[(e+4+15&-16)+-4>>2]=e;g=e+4+15&-16}else g=0;e=c[b+88>>2]|0;if((e|0)>0){f=0;do{i=g+(f<<4)|0;h=(c[b+96>>2]|0)+(f<<4)|0;c[i>>2]=c[h>>2];c[i+4>>2]=c[h+4>>2];c[i+8>>2]=c[h+8>>2];c[i+12>>2]=c[h+12>>2];f=f+1|0}while((f|0)!=(e|0))}e=c[b+96>>2]|0;if(e|0){if(a[b+100>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=g;c[b+92>>2]=d;return}if((c[b+112>>2]|0)>=(d|0))return;if((d|0)!=0?(c[5637]=(c[5637]|0)+1,f=qG((d<<2|3)+16|0)|0,(f|0)!=0):0){c[(f+4+15&-16)+-4>>2]=f;h=f+4+15&-16}else h=0;f=c[b+108>>2]|0;g=c[b+116>>2]|0;if((f|0)<=0)if(!g)e=b+120|0;else i=21;else{e=0;do{c[h+(e<<2)>>2]=c[g+(e<<2)>>2];e=e+1|0}while((e|0)!=(f|0));i=21}if((i|0)==21){if(a[b+120>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[g+-4>>2]|0)}c[b+116>>2]=0;e=b+120|0}a[e>>0]=1;c[b+116>>2]=h;c[b+112>>2]=d;return}function _m(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;if(!(a[d+164>>0]|0)){if((c[d+152>>2]|0)>=(e|0))return;if((e|0)!=0?(c[5637]=(c[5637]|0)+1,g=qG((e<<1)+19|0)|0,(g|0)!=0):0){c[(g+4+15&-16)+-4>>2]=g;i=g+4+15&-16}else i=0;g=c[d+148>>2]|0;h=c[d+156>>2]|0;if((g|0)<=0)if(!h)f=d+160|0;else j=22;else{f=0;do{b[i+(f<<1)>>1]=b[h+(f<<1)>>1]|0;f=f+1|0}while((f|0)!=(g|0));j=22}if((j|0)==22){if(a[d+160>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0)}c[d+156>>2]=0;f=d+160|0}a[f>>0]=1;c[d+156>>2]=i;c[d+152>>2]=e;return}else{if((c[d+132>>2]|0)>=(e|0))return;if((e|0)!=0?(c[5637]=(c[5637]|0)+1,f=qG((e<<2|3)+16|0)|0,(f|0)!=0):0){c[(f+4+15&-16)+-4>>2]=f;i=f+4+15&-16}else i=0;g=c[d+128>>2]|0;h=c[d+136>>2]|0;if((g|0)<=0)if(!h)f=d+140|0;else j=10;else{f=0;do{c[i+(f<<2)>>2]=c[h+(f<<2)>>2];f=f+1|0}while((f|0)!=(g|0));j=10}if((j|0)==10){if(a[d+140>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0)}c[d+136>>2]=0;f=d+140|0}a[f>>0]=1;c[d+136>>2]=i;c[d+132>>2]=e;return}}function $m(d,e,f){d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0;c[d+4>>2]=1065353216;c[d+8>>2]=1065353216;c[d+12>>2]=1065353216;g[d+16>>2]=0.0;a[d+36>>0]=1;c[d+32>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[d+48>>2]=0;c[d>>2]=6624;a[d+100>>0]=1;c[d+96>>2]=0;c[d+88>>2]=0;c[d+92>>2]=0;a[d+120>>0]=1;c[d+116>>2]=0;c[d+108>>2]=0;c[d+112>>2]=0;a[d+140>>0]=1;c[d+136>>2]=0;c[d+128>>2]=0;c[d+132>>2]=0;a[d+160>>0]=1;c[d+156>>2]=0;c[d+148>>2]=0;c[d+152>>2]=0;a[d+164>>0]=e&1;a[d+165>>0]=f&1;g[d+168>>2]=0.0;c[5637]=(c[5637]|0)+1;e=qG(51)|0;if(!e)h=0;else{c[(e+4+15&-16)+-4>>2]=e;h=e+4+15&-16}e=c[d+24>>2]|0;if((e|0)>0){f=0;do{i=h+(f<<5)|0;j=(c[d+32>>2]|0)+(f<<5)|0;c[i>>2]=c[j>>2];c[i+4>>2]=c[j+4>>2];c[i+8>>2]=c[j+8>>2];c[i+12>>2]=c[j+12>>2];c[i+16>>2]=c[j+16>>2];c[i+20>>2]=c[j+20>>2];c[i+24>>2]=c[j+24>>2];c[i+28>>2]=c[j+28>>2];f=f+1|0}while((f|0)!=(e|0))}e=c[d+32>>2]|0;if(e|0){if(a[d+36>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0)}c[d+32>>2]=0}a[d+36>>0]=1;c[d+32>>2]=h;c[d+28>>2]=1;e=c[d+24>>2]|0;c[h+(e<<5)>>2]=0;c[h+(e<<5)+4>>2]=0;c[h+(e<<5)+8>>2]=12;c[h+(e<<5)+12>>2]=0;c[h+(e<<5)+16>>2]=0;c[h+(e<<5)+20>>2]=16;c[h+(e<<5)+24>>2]=2;c[h+(e<<5)+28>>2]=0;c[d+24>>2]=(c[d+24>>2]|0)+1;e=b[d+164>>1]|0;if(!((e&255)<<24>>24)){f=c[d+32>>2]|0;c[f>>2]=(c[d+148>>2]|0)/3|0;c[f+4>>2]=0;c[f+24>>2]=3;c[f+8>>2]=6}else{f=c[d+32>>2]|0;c[f>>2]=(c[d+128>>2]|0)/3|0;c[f+4>>2]=0;c[f+24>>2]=2;c[f+8>>2]=12}if((e&65535)<256){i=12;d=(c[d+108>>2]|0)/3|0;j=f+12|0;c[j>>2]=d;j=f+16|0;c[j>>2]=0;j=f+20|0;c[j>>2]=i;return}else{i=16;d=c[d+88>>2]|0;j=f+12|0;c[j>>2]=d;j=f+16|0;c[j>>2]=0;j=f+20|0;c[j>>2]=i;return}}function an(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;if(!(a[d+164>>0]|0)){f=c[d+148>>2]|0;if((f|0)==(c[d+152>>2]|0)?(k=f|0?f<<1:1,(f|0)<(k|0)):0){if(!k)i=0;else{c[5637]=(c[5637]|0)+1;f=qG((k<<1)+19|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}i=f;f=c[d+148>>2]|0}h=c[d+156>>2]|0;if((f|0)<=0)if(!h)f=d+160|0;else g=27;else{g=0;do{b[i+(g<<1)>>1]=b[h+(g<<1)>>1]|0;g=g+1|0}while((g|0)!=(f|0));g=27}if((g|0)==27){if(a[d+160>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0)}c[d+156>>2]=0;f=d+160|0}a[f>>0]=1;c[d+156>>2]=i;c[d+152>>2]=k;f=c[d+148>>2]|0}k=c[d+156>>2]|0;b[k+(f<<1)>>1]=e;c[d+148>>2]=f+1;c[(c[d+32>>2]|0)+4>>2]=k;return}else{f=c[d+128>>2]|0;if((f|0)==(c[d+132>>2]|0)?(j=f|0?f<<1:1,(f|0)<(j|0)):0){if(!j)i=0;else{c[5637]=(c[5637]|0)+1;f=qG((j<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}i=f;f=c[d+128>>2]|0}h=c[d+136>>2]|0;if((f|0)<=0)if(!h)f=d+140|0;else g=12;else{g=0;do{c[i+(g<<2)>>2]=c[h+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0));g=12}if((g|0)==12){if(a[d+140>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0)}c[d+136>>2]=0;f=d+140|0}a[f>>0]=1;c[d+136>>2]=i;c[d+132>>2]=j;f=c[d+128>>2]|0}k=c[d+136>>2]|0;c[k+(f<<2)>>2]=e;c[d+128>>2]=(c[d+128>>2]|0)+1;c[(c[d+32>>2]|0)+4>>2]=k;return}}function bn(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0.0,q=0.0,r=0.0;if(a[b+165>>0]|0){f=c[b+88>>2]|0;a:do if((f|0)>0&e){h=c[b+96>>2]|0;m=+g[d>>2];j=+g[d+4>>2];k=+g[d+8>>2];l=+g[b+168>>2];e=0;while(1){r=+g[h+(e<<4)>>2]-m;q=+g[h+(e<<4)+4>>2]-j;p=+g[h+(e<<4)+8>>2]-k;if(r*r+q*q+p*p<=l)break;e=e+1|0;if((e|0)>=(f|0))break a}return e|0}while(0);o=(c[b+32>>2]|0)+12|0;c[o>>2]=(c[o>>2]|0)+1;if((f|0)==(c[b+92>>2]|0)?(i=f|0?f<<1:1,(f|0)<(i|0)):0){if(!i)e=0;else{c[5637]=(c[5637]|0)+1;e=qG((i<<4|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[b+88>>2]|0}if((f|0)>0){h=0;do{o=e+(h<<4)|0;n=(c[b+96>>2]|0)+(h<<4)|0;c[o>>2]=c[n>>2];c[o+4>>2]=c[n+4>>2];c[o+8>>2]=c[n+8>>2];c[o+12>>2]=c[n+12>>2];h=h+1|0}while((h|0)!=(f|0))}f=c[b+96>>2]|0;if(f|0){if(a[b+100>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=e;c[b+92>>2]=i;e=c[b+88>>2]|0}else e=f;o=(c[b+96>>2]|0)+(e<<4)|0;c[o>>2]=c[d>>2];c[o+4>>2]=c[d+4>>2];c[o+8>>2]=c[d+8>>2];c[o+12>>2]=c[d+12>>2];d=c[b+88>>2]|0;c[b+88>>2]=d+1;c[(c[b+32>>2]|0)+16>>2]=c[b+96>>2];return d|0}h=c[b+108>>2]|0;b:do if((h|0)>0&e){e=c[b+116>>2]|0;j=+g[d>>2];k=+g[d+4>>2];l=+g[d+8>>2];m=+g[b+168>>2];i=0;while(1){p=+g[e+(i<<2)>>2]-j;q=+g[e+(i+1<<2)>>2]-k;r=+g[e+(i+2<<2)>>2]-l;f=i+3|0;if(p*p+q*q+r*r<=m)break;if((f|0)<(h|0))i=f;else break b}d=(i|0)/3|0;return d|0}while(0);e=c[b+112>>2]|0;if((h|0)==(e|0)){n=h|0?h<<1:1;if((h|0)<(n|0)){if(!n)e=0;else{c[5637]=(c[5637]|0)+1;e=qG((n<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=c[b+108>>2]|0}i=c[b+116>>2]|0;if((h|0)<=0)if(!i)f=b+120|0;else o=34;else{f=0;do{c[e+(f<<2)>>2]=c[i+(f<<2)>>2];f=f+1|0}while((f|0)!=(h|0));o=34}if((o|0)==34){if(a[b+120>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[i+-4>>2]|0)}c[b+116>>2]=0;f=b+120|0}a[f>>0]=1;c[b+116>>2]=e;c[b+112>>2]=n;f=c[b+108>>2]|0;h=n}else f=h}else{f=h;h=e}c[(c[b+116>>2]|0)+(f<<2)>>2]=c[d>>2];e=f+1|0;c[b+108>>2]=e;if((e|0)==(h|0)){n=h|0?h<<1:1;if((h|0)<(n|0)){if(!n)e=0;else{c[5637]=(c[5637]|0)+1;e=qG((n<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=c[b+108>>2]|0}i=c[b+116>>2]|0;if((h|0)<=0)if(!i)f=b+120|0;else o=48;else{f=0;do{c[e+(f<<2)>>2]=c[i+(f<<2)>>2];f=f+1|0}while((f|0)!=(h|0));o=48}if((o|0)==48){if(a[b+120>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[i+-4>>2]|0)}c[b+116>>2]=0;f=b+120|0}a[f>>0]=1;c[b+116>>2]=e;c[b+112>>2]=n;e=c[b+108>>2]|0;h=n}else e=h}c[(c[b+116>>2]|0)+(e<<2)>>2]=c[d+4>>2];e=e+1|0;c[b+108>>2]=e;if((e|0)==(h|0)){n=h|0?h<<1:1;if((h|0)<(n|0)){if(!n)e=0;else{c[5637]=(c[5637]|0)+1;e=qG((n<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=c[b+108>>2]|0}i=c[b+116>>2]|0;if((h|0)<=0)if(!i)f=b+120|0;else o=62;else{f=0;do{c[e+(f<<2)>>2]=c[i+(f<<2)>>2];f=f+1|0}while((f|0)!=(h|0));o=62}if((o|0)==62){if(a[b+120>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[i+-4>>2]|0)}c[b+116>>2]=0;f=b+120|0}a[f>>0]=1;c[b+116>>2]=e;c[b+112>>2]=n;e=c[b+108>>2]|0}else e=h}o=c[b+116>>2]|0;c[o+(e<<2)>>2]=c[d+8>>2];d=e+1|0;c[b+108>>2]=d;b=c[b+32>>2]|0;c[b+12>>2]=(c[b+12>>2]|0)+1;c[b+16>>2]=o;d=((d|0)/3|0)+-1|0;return d|0}function cn(a){a=a|0;return}function dn(a){a=a|0;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function en(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0;o=(+g[a+36>>2]-+g[a+20>>2])*.5;l=(+g[a+40>>2]-+g[a+24>>2])*.5;i=(+g[a+44>>2]-+g[a+28>>2])*.5;n=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);k=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);i=i+ +Hb[c[(c[a>>2]|0)+48>>2]&15](a);B=(+g[a+36>>2]+ +g[a+20>>2])*.5;z=(+g[a+40>>2]+ +g[a+24>>2])*.5;x=(+g[a+44>>2]+ +g[a+28>>2])*.5;F=+g[b>>2];w=+N(+F);E=+g[b+4>>2];v=+N(+E);t=+g[b+8>>2];u=+N(+t);D=+g[b+16>>2];s=+N(+D);C=+g[b+20>>2];r=+N(+C);p=+g[b+24>>2];q=+N(+p);A=+g[b+32>>2];m=+N(+A);y=+g[b+36>>2];j=+N(+y);f=+g[b+40>>2];h=+N(+f);t=B*F+z*E+x*t+ +g[b+48>>2];p=B*D+z*C+x*p+ +g[b+52>>2];f=B*A+z*y+x*f+ +g[b+56>>2];g[d>>2]=t-((o+n)*w+(l+k)*v+i*u);g[d+4>>2]=p-((o+n)*s+(l+k)*r+i*q);g[d+8>>2]=f-((o+n)*m+(l+k)*j+i*h);g[d+12>>2]=0.0;g[e>>2]=(o+n)*w+(l+k)*v+i*u+t;g[e+4>>2]=(o+n)*s+(l+k)*r+i*q+p;g[e+8>>2]=(o+n)*m+(l+k)*j+i*h+f;g[e+12>>2]=0.0;return}function fn(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;i=i+48|0;e=(c[a+52>>2]|0)+4|0;c[e>>2]=c[b>>2];c[e+4>>2]=c[b+4>>2];c[e+8>>2]=c[b+8>>2];c[e+12>>2]=c[b+12>>2];c[d+32>>2]=0;c[d+32+4>>2]=0;c[d+32+8>>2]=0;c[d+32+12>>2]=0;g[d+32>>2]=1.0;Zb[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+36>>2]=+g[d+16>>2]+ +g[a+16>>2];g[d+32>>2]=-1.0;Zb[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d>>2];c[d+16+4>>2]=c[d+4>>2];c[d+16+8>>2]=c[d+8>>2];c[d+16+12>>2]=c[d+12>>2];g[a+20>>2]=+g[d+16>>2]-+g[a+16>>2];c[d+32>>2]=0;c[d+32+4>>2]=0;c[d+32+8>>2]=0;c[d+32+12>>2]=0;g[d+32+4>>2]=1.0;Zb[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+40>>2]=+g[d+16+4>>2]+ +g[a+16>>2];g[d+32+4>>2]=-1.0;Zb[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d>>2];c[d+16+4>>2]=c[d+4>>2];c[d+16+8>>2]=c[d+8>>2];c[d+16+12>>2]=c[d+12>>2];g[a+24>>2]=+g[d+16+4>>2]-+g[a+16>>2];c[d+32>>2]=0;c[d+32+4>>2]=0;c[d+32+8>>2]=0;c[d+32+12>>2]=0;g[d+32+8>>2]=1.0;Zb[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+44>>2]=+g[d+16+8>>2]+ +g[a+16>>2];g[d+32+8>>2]=-1.0;Zb[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d>>2];c[d+16+4>>2]=c[d+4>>2];c[d+16+8>>2]=c[d+8>>2];c[d+16+12>>2]=c[d+12>>2];g[a+28>>2]=+g[d+16+8>>2]-+g[a+16>>2];i=d;return}function gn(a){a=a|0;return (c[a+52>>2]|0)+4|0}function hn(a,b,d){a=a|0;b=+b;d=d|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;return}function jn(a){a=a|0;return 14302}function kn(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+48|0;c[f>>2]=6776;c[f+4>>2]=b;c[f+8>>2]=c[d>>2];c[f+8+4>>2]=c[d+4>>2];c[f+8+8>>2]=c[d+8>>2];c[f+8+12>>2]=c[d+12>>2];c[f+24>>2]=c[e>>2];c[f+24+4>>2]=c[e+4>>2];c[f+24+8>>2]=c[e+8>>2];c[f+24+12>>2]=c[e+12>>2];a=c[a+52>>2]|0;bc[c[(c[a>>2]|0)+8>>2]&127](a,f,d,e);i=f;return}function ln(a){a=a|0;rG(a);return}function mn(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0;f=+g[b>>2];h=+g[b+16>>2];j=f<h?f:h;i=+g[b+32>>2];if((j<i?j:i)>+g[a+24>>2])return;k=f>h?b:b+16|0;if(+g[(+g[k>>2]>i?k:b+32|0)>>2]<+g[a+8>>2])return;f=+g[b+8>>2];h=+g[b+24>>2];j=f<h?f:h;i=+g[b+40>>2];if((j<i?j:i)>+g[a+32>>2])return;k=f>h?b+8|0:b+24|0;if(+g[(+g[k>>2]>i?k:b+40|0)>>2]<+g[a+16>>2])return;f=+g[b+4>>2];h=+g[b+20>>2];j=f<h?f:h;i=+g[b+36>>2];if((j<i?j:i)>+g[a+28>>2])return;k=f>h?b+4|0:b+20|0;if(+g[(+g[k>>2]>i?k:b+36|0)>>2]<+g[a+12>>2])return;k=c[a+4>>2]|0;bc[c[(c[k>>2]|0)+8>>2]&127](k,b,d,e);return}function nn(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0;e=i;i=i+160|0;c[e+136>>2]=0;c[e+136+4>>2]=0;c[e+136+8>>2]=0;c[e+136+12>>2]=0;c[e+136+16>>2]=0;c[e+32>>2]=6796;f=e+32+4|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[e+32+20>>2]=1065353216;c[e+32+24>>2]=0;c[e+32+24+4>>2]=0;c[e+32+24+8>>2]=0;c[e+32+24+12>>2]=0;c[e+32+40>>2]=1065353216;c[e+32+44>>2]=0;c[e+32+44+4>>2]=0;c[e+32+44+8>>2]=0;c[e+32+44+12>>2]=0;c[e+32+60>>2]=1065353216;c[e+32+64>>2]=0;c[e+32+68>>2]=c[e+136+4>>2];c[e+32+68+4>>2]=c[e+136+4+4>>2];c[e+32+68+8>>2]=c[e+136+4+8>>2];c[e+32+68+12>>2]=c[e+136+4+12>>2];g[e+32+84>>2]=-999999984306749440.0;k=+g[d>>2];j=+g[d+4>>2];h=+g[d+8>>2];g[e+32+88>>2]=k+j*0.0+h*0.0;g[e+32+92>>2]=k*0.0+j+h*0.0;g[e+32+96>>2]=k*0.0+j*0.0+h;g[e+32+100>>2]=0.0;c[e+16>>2]=1566444395;c[e+16+4>>2]=1566444395;c[e+16+8>>2]=1566444395;g[e+16+12>>2]=0.0;d=c[(c[b>>2]|0)+64>>2]|0;g[e>>2]=-999999984306749440.0;g[e+4>>2]=-999999984306749440.0;g[e+8>>2]=-999999984306749440.0;g[e+12>>2]=0.0;bc[d&127](b,e+32|0,e,e+16|0);c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];i=e;return}function on(a){a=a|0;rG(a);return}function pn(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;j=+g[a+88>>2];k=+g[a+92>>2];i=+g[a+96>>2];f=j*+g[b>>2]+k*+g[b+4>>2]+i*+g[b+8>>2];h=+g[a+84>>2];if(f>h){g[a+84>>2]=f;c[a+4>>2]=c[b>>2];c[a+4+4>>2]=c[b+4>>2];c[a+4+8>>2]=c[b+8>>2];c[a+4+12>>2]=c[b+12>>2]}else f=h;h=j*+g[b+16>>2]+k*+g[b+20>>2]+i*+g[b+24>>2];if(h>f){g[a+84>>2]=h;c[a+4>>2]=c[b+16>>2];c[a+4+4>>2]=c[b+16+4>>2];c[a+4+8>>2]=c[b+16+8>>2];c[a+4+12>>2]=c[b+16+12>>2]}else h=f;f=j*+g[b+32>>2]+k*+g[b+36>>2]+i*+g[b+40>>2];if(!(f>h))return;g[a+84>>2]=f;c[a+4>>2]=c[b+32>>2];c[a+4+4>>2]=c[b+32+4>>2];c[a+4+8>>2]=c[b+32+8>>2];c[a+4+12>>2]=c[b+32+12>>2];return}function qn(a){a=a|0;rG(a);return}function rn(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var l=0,m=0.0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0;C=i;i=i+304|0;B=+g[e+48>>2]-+g[d+48>>2];z=+g[e+52>>2]-+g[d+52>>2];A=+g[e+56>>2]-+g[d+56>>2];Zf(d,e,C+288|0,C+240|0);v=+g[C+240>>2];t=+g[C+288>>2]*v;u=v*+g[C+288+4>>2];v=v*+g[C+288+8>>2];g[C+224>>2]=t;g[C+224+4>>2]=u;g[C+224+8>>2]=v;g[C+224+12>>2]=0.0;w=+g[h+48>>2]-+g[f+48>>2];x=+g[h+52>>2]-+g[f+52>>2];y=+g[h+56>>2]-+g[f+56>>2];Zf(f,h,C+288|0,C+240|0);r=+g[C+240>>2];p=+g[C+288>>2]*r;q=r*+g[C+288+4>>2];r=r*+g[C+288+8>>2];g[C+192>>2]=p;g[C+192+4>>2]=q;g[C+192+8>>2]=r;g[C+192+12>>2]=0.0;e=c[b+12>>2]|0;s=+Hb[c[(c[e>>2]|0)+16>>2]&15](e);e=c[b+16>>2]|0;if(!e)m=0.0;else m=+Hb[c[(c[e>>2]|0)+16>>2]&15](e);s=s*+O(+(t*t+u*u+v*v))+m*+O(+(p*p+q*q+r*r));if(s+ +O(+((w-B)*(w-B)+(x-z)*(x-z)+(y-A)*(y-A)))==0.0){j=0;i=C;return j|0}c[C+240>>2]=6836;g[C+240+36>>2]=999999984306749440.0;a[C+240+40>>0]=0;wn(b,d,f,C+240|0);h=(a[C+240+40>>0]|0)==0;c[C+288>>2]=c[C+240+20>>2];c[C+288+4>>2]=c[C+240+20+4>>2];c[C+288+8>>2]=c[C+240+20+8>>2];c[C+288+12>>2]=c[C+240+20+12>>2];a:do if(!h?(o=c[C+240+4>>2]|0,l=c[C+240+8>>2]|0,n=c[C+240+12>>2]|0,v=(w-B)*(c[k>>2]=o,+g[k>>2]),v=v+(x-z)*(c[k>>2]=l,+g[k>>2]),!(s+(v+(y-A)*(c[k>>2]=n,+g[k>>2]))<=1.1920928955078125e-07)):0){m=+g[C+240+16>>2];p=+g[C+240+36>>2]+ +g[j+172>>2];b:do if(p>1.0000000474974513e-03){q=p;r=0.0;h=0;while(1){e=c[j+168>>2]|0;if(e|0){D=c[(c[e>>2]|0)+28>>2]|0;c[C+208>>2]=1065353216;c[C+208+4>>2]=1065353216;c[C+208+8>>2]=1065353216;g[C+208+12>>2]=0.0;wb[D&7](e,C+288|0,.20000000298023224,C+208|0)}m=(w-B)*(c[k>>2]=o,+g[k>>2]);m=m+(x-z)*(c[k>>2]=l,+g[k>>2]);m=s+(m+(y-A)*(c[k>>2]=n,+g[k>>2]));if(m<=1.1920928955078125e-07){l=0;break a}p=r+q/m;if(!(!(p<=r)&(!(p<0.0)&!(p>1.0)))){l=0;break a}xn(d,B,z,A,C+224|0,p,C+112|0);xn(f,w,x,y,C+192|0,p,C+48|0);l=c[j+168>>2]|0;if(l|0){D=c[(c[l>>2]|0)+28>>2]|0;c[C+176>>2]=1065353216;c[C+176+4>>2]=0;c[C+176+8>>2]=0;g[C+176+12>>2]=0.0;wb[D&7](l,C+112+48|0,.20000000298023224,C+176|0)}qb[c[c[j>>2]>>2]&31](j,p);c[C>>2]=6836;g[C+36>>2]=999999984306749440.0;a[C+40>>0]=0;wn(b,C+112|0,C+48|0,C);if(!(a[C+40>>0]|0)){l=15;break}m=+g[C+36>>2];q=+g[j+172>>2];c[C+288>>2]=c[C+20>>2];c[C+288+4>>2]=c[C+20+4>>2];c[C+288+8>>2]=c[C+20+8>>2];c[C+288+12>>2]=c[C+20+12>>2];e=h+1|0;if((h|0)>63){l=16;break}n=c[C+12>>2]|0;l=c[C+8>>2]|0;o=c[C+4>>2]|0;q=m+q;if(!(q>1.0000000474974513e-03)){m=+g[C+16>>2];break b}else{r=p;h=e}}if((l|0)==15)Zb[c[(c[j>>2]|0)+8>>2]&127](j,-1,h);else if((l|0)==16)Zb[c[(c[j>>2]|0)+8>>2]&127](j,-2,e);l=0;break a}else p=0.0;while(0);g[j+164>>2]=p;c[j+132>>2]=o;c[j+136>>2]=l;c[j+140>>2]=n;g[j+144>>2]=m;c[j+148>>2]=c[C+288>>2];c[j+148+4>>2]=c[C+288+4>>2];c[j+148+8>>2]=c[C+288+8>>2];c[j+148+12>>2]=c[C+288+12>>2];l=1}else l=0;while(0);D=l;i=C;return D|0}function sn(a){a=a|0;rG(a);return}function tn(a,b,c){a=a|0;b=b|0;c=c|0;return}function un(a,b,c){a=a|0;b=b|0;c=c|0;return}function vn(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;if(!(+g[b+36>>2]>f))return;a[b+40>>0]=1;c[b+4>>2]=c[d>>2];c[b+4+4>>2]=c[d+4>>2];c[b+4+8>>2]=c[d+8>>2];c[b+4+12>>2]=c[d+12>>2];c[b+20>>2]=c[e>>2];c[b+20+4>>2]=c[e+4>>2];c[b+20+8>>2]=c[e+8>>2];c[b+20+12>>2]=c[e+12>>2];g[b+36>>2]=f;return}function wn(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0,L=0,M=0,N=0,O=0;h=i;i=i+256|0;if(!(c[b+16>>2]|0)){K=c[b+12>>2]|0;b=c[b+20>>2]|0;n=+g[d>>2];q=+g[d+4>>2];u=+g[d+8>>2];k=+g[d+16>>2];r=+g[d+20>>2];j=+g[d+24>>2];m=+g[d+32>>2];s=+g[d+36>>2];l=+g[d+40>>2];F=+g[d+48>>2];E=+g[d+52>>2];D=+g[d+56>>2];J=+g[e>>2];I=+g[e+16>>2];y=+g[e+32>>2];H=+g[e+4>>2];G=+g[e+20>>2];w=+g[e+36>>2];v=+g[e+8>>2];z=+g[e+24>>2];x=+g[e+40>>2];C=-+g[e+48>>2];B=-+g[e+52>>2];p=-+g[e+56>>2];d=c[(c[K>>2]|0)+64>>2]|0;A=-+g[b+52>>2];t=-+g[b+56>>2];o=-+g[b+60>>2];g[h+16>>2]=(n*J+k*I+m*y)*A+(n*H+k*G+m*w)*t+(n*v+k*z+m*x)*o;g[h+16+4>>2]=(q*J+r*I+s*y)*A+(q*H+r*G+s*w)*t+(q*v+r*z+s*x)*o;g[h+16+8>>2]=(u*J+j*I+l*y)*A+(u*H+j*G+l*w)*t+(u*v+j*z+l*x)*o;g[h+16+12>>2]=0.0;Zb[d&127](h+168|0,K,h+16|0);o=+g[h+168>>2];t=+g[h+168+4>>2];A=+g[h+168+8>>2];y=F*J+E*I+D*y+(J*C+I*B+y*p)+((n*J+k*I+m*y)*o+(q*J+r*I+s*y)*t+(u*J+j*I+l*y)*A);w=F*H+E*G+D*w+(H*C+G*B+w*p)+((n*H+k*G+m*w)*o+(q*H+r*G+s*w)*t+(u*H+j*G+l*w)*A);A=F*v+E*z+D*x+(v*C+z*B+x*p)+((n*v+k*z+m*x)*o+(q*v+r*z+s*x)*t+(u*v+j*z+l*x)*A);x=+g[b+52>>2];l=+g[b+56>>2];z=+g[b+60>>2];j=z*A+(x*y+l*w)-+g[b+68>>2];v=+g[e>>2];u=+g[e+4>>2];t=+g[e+8>>2];s=+g[e+16>>2];r=+g[e+20>>2];q=+g[e+24>>2];o=+g[e+32>>2];m=+g[e+36>>2];k=+g[e+40>>2];n=(y-x*j)*s+(w-l*j)*r+(A-z*j)*q+ +g[e+52>>2];p=(y-x*j)*o+(w-l*j)*m+(A-z*j)*k+ +g[e+56>>2];g[h+32>>2]=t*(A-z*j)+(v*(y-x*j)+u*(w-l*j))+ +g[e+48>>2];g[h+32+4>>2]=n;g[h+32+8>>2]=p;g[h+32+12>>2]=0.0;p=+g[b+52>>2];n=+g[b+56>>2];l=+g[b+60>>2];g[h>>2]=v*p+u*n+t*l;g[h+4>>2]=p*s+n*r+l*q;g[h+8>>2]=p*o+n*m+l*k;g[h+12>>2]=0.0;Yb[c[(c[f>>2]|0)+16>>2]&15](f,h,h+32|0,j);i=h;return}else{N=c[b+4>>2]|0;a[N+312>>0]=0;c[N>>2]=0;a[N+356>>0]=1;c[N+292>>2]=1566444395;c[N+296>>2]=1566444395;c[N+300>>2]=1566444395;g[N+304>>2]=0.0;c[N+336>>2]=0;c[N+336+4>>2]=0;c[N+336+8>>2]=0;c[N+336+12>>2]=0;a[N+336+16>>0]=0;a[N+332>>0]=a[N+332>>0]&-16;N=c[b+12>>2]|0;M=c[b+16>>2]|0;L=c[N+4>>2]|0;K=c[M+4>>2]|0;I=+Hb[c[(c[N>>2]|0)+48>>2]&15](N);O=c[b+16>>2]|0;J=+Hb[c[(c[O>>2]|0)+48>>2]&15](O);O=c[b+4>>2]|0;b=c[b+8>>2]|0;c[h+168>>2]=6928;c[h+168+4>>2]=0;c[h+168+8>>2]=1065353216;c[h+168+12>>2]=0;g[h+168+16>>2]=0.0;c[h+168+20>>2]=b;c[h+168+24>>2]=O;c[h+168+28>>2]=N;c[h+168+32>>2]=M;c[h+168+36>>2]=L;c[h+168+40>>2]=K;g[h+168+44>>2]=I;g[h+168+48>>2]=J;a[h+168+52>>0]=0;c[h+168+60>>2]=-1;c[h+168+72>>2]=1;c[h+168+76>>2]=1;g[h+32+128>>2]=999999984306749440.0;c[h+32>>2]=c[d>>2];c[h+32+4>>2]=c[d+4>>2];c[h+32+8>>2]=c[d+8>>2];c[h+32+12>>2]=c[d+12>>2];c[h+32+16>>2]=c[d+16>>2];c[h+32+16+4>>2]=c[d+16+4>>2];c[h+32+16+8>>2]=c[d+16+8>>2];c[h+32+16+12>>2]=c[d+16+12>>2];c[h+32+32>>2]=c[d+32>>2];c[h+32+32+4>>2]=c[d+32+4>>2];c[h+32+32+8>>2]=c[d+32+8>>2];c[h+32+32+12>>2]=c[d+32+12>>2];c[h+32+48>>2]=c[d+48>>2];c[h+32+48+4>>2]=c[d+48+4>>2];c[h+32+48+8>>2]=c[d+48+8>>2];c[h+32+48+12>>2]=c[d+48+12>>2];c[h+32+64>>2]=c[e>>2];c[h+32+64+4>>2]=c[e+4>>2];c[h+32+64+8>>2]=c[e+8>>2];c[h+32+64+12>>2]=c[e+12>>2];c[h+32+80>>2]=c[e+16>>2];c[h+32+80+4>>2]=c[e+16+4>>2];c[h+32+80+8>>2]=c[e+16+8>>2];c[h+32+80+12>>2]=c[e+16+12>>2];c[h+32+96>>2]=c[e+32>>2];c[h+32+96+4>>2]=c[e+32+4>>2];c[h+32+96+8>>2]=c[e+32+8>>2];c[h+32+96+12>>2]=c[e+32+12>>2];c[h+32+112>>2]=c[e+48>>2];c[h+32+112+4>>2]=c[e+48+4>>2];c[h+32+112+8>>2]=c[e+48+8>>2];c[h+32+112+12>>2]=c[e+48+12>>2];On(h+168|0,h+32|0,f,0,0);i=h;return}}function xn(a,b,c,d,e,f,h){a=a|0;b=+b;c=+c;d=+d;e=e|0;f=+f;h=h|0;var j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0;l=i;i=i+16|0;k=c*f+ +g[a+52>>2];j=d*f+ +g[a+56>>2];g[h+48>>2]=b*f+ +g[a+48>>2];g[h+52>>2]=k;g[h+56>>2]=j;g[h+60>>2]=0.0;j=+g[e>>2];k=+g[e+4>>2];c=+g[e+8>>2];d=+O(+(j*j+k*k+c*c));d=d*f>.7853981852531433?.7853981852531433/f:d;if(d<1.0000000474974513e-03)b=f*.5-d*(f*f*f*.02083333395421505*d);else b=+R(+(d*.5*f))/d;o=j*b;n=k*b;j=c*b;q=+Q(+(d*f*.5));_f(a,l);b=+g[l>>2];p=+g[l+12>>2];c=+g[l+8>>2];f=+g[l+4>>2];r=1.0/+O(+((q*p-o*b-n*f-j*c)*(q*p-o*b-n*f-j*c)+((j*p+q*c+o*f-n*b)*(j*p+q*c+o*f-n*b)+((q*b+o*p+n*c-j*f)*(q*b+o*p+n*c-j*f)+(j*b+(n*p+q*f)-o*c)*(j*b+(n*p+q*f)-o*c)))));d=(q*b+o*p+n*c-j*f)*r;k=r*(j*b+(n*p+q*f)-o*c);m=r*(j*p+q*c+o*f-n*b);c=r*(q*p-o*b-n*f-j*c);j=d*(2.0/(c*c+(m*m+(d*d+k*k))));f=k*(2.0/(c*c+(m*m+(d*d+k*k))));b=m*(2.0/(c*c+(m*m+(d*d+k*k))));g[h>>2]=1.0-(k*f+m*b);g[h+4>>2]=d*f-c*b;g[h+8>>2]=d*b+c*f;g[h+12>>2]=0.0;g[h+16>>2]=d*f+c*b;g[h+20>>2]=1.0-(d*j+m*b);g[h+24>>2]=k*b-c*j;g[h+28>>2]=0.0;g[h+32>>2]=d*b-c*f;g[h+36>>2]=k*b+c*j;g[h+40>>2]=1.0-(d*j+k*f);g[h+44>>2]=0.0;i=l;return}function yn(a){a=a|0;return}function zn(a){a=a|0;rG(a);return}function An(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var l=0.0,m=0,n=0.0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0;u=i;i=i+288|0;q=c[b+4>>2]|0;a[q+312>>0]=0;c[q>>2]=0;a[q+356>>0]=1;c[q+292>>2]=1566444395;c[q+296>>2]=1566444395;c[q+300>>2]=1566444395;g[q+304>>2]=0.0;c[q+336>>2]=0;c[q+336+4>>2]=0;c[q+336+8>>2]=0;c[q+336+12>>2]=0;a[q+336+16>>0]=0;a[q+332>>0]=a[q+332>>0]&-16;r=+g[e+48>>2]-+g[d+48>>2]-(+g[h+48>>2]-+g[f+48>>2]);s=+g[e+52>>2]-+g[d+52>>2]-(+g[h+52>>2]-+g[f+52>>2]);t=+g[e+56>>2]-+g[d+56>>2]-(+g[h+56>>2]-+g[f+56>>2]);c[u+216>>2]=6836;g[u+216+36>>2]=999999984306749440.0;a[u+216+40>>0]=0;q=c[b+8>>2]|0;p=c[b+12>>2]|0;o=c[b+4>>2]|0;c[u+136>>2]=6928;c[u+136+4>>2]=0;c[u+136+8>>2]=1065353216;c[u+136+12>>2]=0;g[u+136+16>>2]=0.0;c[u+136+20>>2]=0;c[u+136+24>>2]=o;c[u+136+28>>2]=q;c[u+136+32>>2]=p;c[u+136+36>>2]=c[q+4>>2];c[u+136+40>>2]=c[p+4>>2];g[u+136+44>>2]=+Hb[c[(c[q>>2]|0)+48>>2]&15](q);g[u+136+48>>2]=+Hb[c[(c[p>>2]|0)+48>>2]&15](p);a[u+136+52>>0]=0;c[u+136+60>>2]=-1;c[u+136+72>>2]=1;c[u+136+76>>2]=1;g[u+128>>2]=999999984306749440.0;c[u>>2]=c[d>>2];c[u+4>>2]=c[d+4>>2];c[u+8>>2]=c[d+8>>2];c[u+12>>2]=c[d+12>>2];c[u+16>>2]=c[d+16>>2];c[u+16+4>>2]=c[d+16+4>>2];c[u+16+8>>2]=c[d+16+8>>2];c[u+16+12>>2]=c[d+16+12>>2];c[u+32>>2]=c[d+32>>2];c[u+32+4>>2]=c[d+32+4>>2];c[u+32+8>>2]=c[d+32+8>>2];c[u+32+12>>2]=c[d+32+12>>2];c[u+48>>2]=c[d+48>>2];c[u+48+4>>2]=c[d+48+4>>2];c[u+48+8>>2]=c[d+48+8>>2];c[u+48+12>>2]=c[d+48+12>>2];c[u+64>>2]=c[f>>2];c[u+64+4>>2]=c[f+4>>2];c[u+64+8>>2]=c[f+8>>2];c[u+64+12>>2]=c[f+12>>2];c[u+80>>2]=c[f+16>>2];c[u+80+4>>2]=c[f+16+4>>2];c[u+80+8>>2]=c[f+16+8>>2];c[u+80+12>>2]=c[f+16+12>>2];c[u+96>>2]=c[f+32>>2];c[u+96+4>>2]=c[f+32+4>>2];c[u+96+8>>2]=c[f+32+8>>2];c[u+96+12>>2]=c[f+32+12>>2];c[u+112>>2]=c[f+48>>2];c[u+112+4>>2]=c[f+48+4>>2];c[u+112+8>>2]=c[f+48+8>>2];c[u+112+12>>2]=c[f+48+12>>2];On(u+136|0,u,u+216|0,0,0);p=(a[u+216+40>>0]|0)==0;q=u+216+20|0;c[u+264>>2]=c[q>>2];c[u+264+4>>2]=c[q+4>>2];c[u+264+8>>2]=c[q+8>>2];c[u+264+12>>2]=c[q+12>>2];if(p){j=0;i=u;return j|0}n=+g[u+216+36>>2];l=+g[u+216+16>>2];b=c[u+216+12>>2]|0;m=c[u+216+8>>2]|0;o=c[u+216+4>>2]|0;do if(n>1.0000000474974513e-03){l=0.0;p=0;while(1){if((p|0)>31){b=0;p=13;break}w=r*(c[k>>2]=o,+g[k>>2]);w=s*(c[k>>2]=m,+g[k>>2])+w;v=l;l=l-n/(t*(c[k>>2]=b,+g[k>>2])+w);if(!(!(l<=v)&(!(l<0.0)&!(l>1.0)))){b=0;p=13;break}qb[c[c[j>>2]>>2]&31](j,l);w=1.0-l;g[u+48>>2]=w*+g[d+48>>2]+l*+g[e+48>>2];g[u+52>>2]=w*+g[d+52>>2]+l*+g[e+52>>2];g[u+56>>2]=w*+g[d+56>>2]+l*+g[e+56>>2];g[u+112>>2]=w*+g[f+48>>2]+l*+g[h+48>>2];g[u+116>>2]=w*+g[f+52>>2]+l*+g[h+52>>2];g[u+120>>2]=w*+g[f+56>>2]+l*+g[h+56>>2];On(u+136|0,u,u+216|0,0,0);if(!(a[u+216+40>>0]|0)){b=0;p=13;break}n=+g[u+216+36>>2];if(n<0.0){p=8;break};c[u+264>>2]=c[q>>2];c[u+264+4>>2]=c[q+4>>2];c[u+264+8>>2]=c[q+8>>2];c[u+264+12>>2]=c[q+12>>2];b=c[u+216+12>>2]|0;m=c[u+216+8>>2]|0;o=c[u+216+4>>2]|0;if(!(n>1.0000000474974513e-03)){p=10;break}else p=p+1|0}if((p|0)==8){g[j+164>>2]=l;f=c[u+216+8>>2]|0;e=c[u+216+12>>2]|0;h=c[u+216+16>>2]|0;c[j+132>>2]=c[u+216+4>>2];c[j+136>>2]=f;c[j+140>>2]=e;c[j+144>>2]=h;c[j+148>>2]=c[q>>2];c[j+148+4>>2]=c[q+4>>2];c[j+148+8>>2]=c[q+8>>2];c[j+148+12>>2]=c[q+12>>2];j=1;i=u;return j|0}else if((p|0)==10){n=l;l=+g[u+216+16>>2];break}else if((p|0)==13){i=u;return b|0}}else n=0.0;while(0);w=r*(c[k>>2]=o,+g[k>>2]);w=s*(c[k>>2]=m,+g[k>>2])+w;if(t*(c[k>>2]=b,+g[k>>2])+w>=-+g[j+172>>2]){j=0;i=u;return j|0}g[j+164>>2]=n;c[j+132>>2]=o;c[j+136>>2]=m;c[j+140>>2]=b;g[j+144>>2]=l;c[j+148>>2]=c[u+264>>2];c[j+148+4>>2]=c[u+264+4>>2];c[j+148+8>>2]=c[u+264+8>>2];c[j+148+12>>2]=c[u+264+12>>2];j=1;i=u;return j|0}function Bn(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;v=i;i=i+560|0;k=h;l=k+36|0;do{c[k>>2]=0;k=k+4|0}while((k|0)<(l|0));c[v+400>>2]=a;c[v+400+4>>2]=d;o=+g[e>>2];E=+g[b>>2];n=+g[e+16>>2];j=+g[b+16>>2];m=+g[e+32>>2];F=+g[b+32>>2];w=+g[b+4>>2];G=+g[b+20>>2];x=+g[b+36>>2];t=+g[b+8>>2];r=+g[b+24>>2];p=+g[b+40>>2];D=+g[e+4>>2];C=+g[e+20>>2];B=+g[e+36>>2];A=+g[e+8>>2];z=+g[e+24>>2];y=+g[e+40>>2];g[v+400+8>>2]=o*E+n*j+m*F;g[v+400+12>>2]=o*w+n*G+m*x;g[v+400+16>>2]=o*t+n*r+m*p;g[v+400+20>>2]=0.0;g[v+400+24>>2]=E*D+j*C+F*B;g[v+400+28>>2]=w*D+G*C+x*B;g[v+400+32>>2]=t*D+r*C+p*B;g[v+400+36>>2]=0.0;g[v+400+40>>2]=E*A+j*z+F*y;g[v+400+44>>2]=w*A+G*z+x*y;g[v+400+48>>2]=t*A+r*z+p*y;g[v+400+52>>2]=0.0;p=+g[e+48>>2]-+g[b+48>>2];r=+g[e+52>>2]-+g[b+52>>2];t=+g[e+56>>2]-+g[b+56>>2];x=+g[b>>2];G=+g[e>>2];w=+g[b+16>>2];F=+g[e+16>>2];j=+g[b+32>>2];E=+g[e+32>>2];m=+g[b+4>>2];n=+g[b+20>>2];o=+g[b+36>>2];q=+g[b+8>>2];s=+g[b+24>>2];u=+g[b+40>>2];g[v+400+56>>2]=x*G+w*F+j*E;g[v+400+60>>2]=x*D+w*C+j*B;g[v+400+64>>2]=x*A+w*z+j*y;g[v+400+68>>2]=0.0;g[v+400+72>>2]=G*m+F*n+E*o;g[v+400+76>>2]=D*m+C*n+B*o;g[v+400+80>>2]=A*m+z*n+y*o;g[v+400+84>>2]=0.0;g[v+400+88>>2]=G*q+F*s+E*u;g[v+400+92>>2]=D*q+C*s+B*u;g[v+400+96>>2]=A*q+z*s+y*u;g[v+400+100>>2]=0.0;g[v+400+104>>2]=p*x+r*w+t*j;g[v+400+108>>2]=p*m+r*n+t*o;g[v+400+112>>2]=p*q+r*s+t*u;g[v+400+116>>2]=0.0;c[v+400+120>>2]=71;c[v+400+124>>2]=0;c[v+16+364>>2]=0;c[v+16+128>>2]=0;c[v+16+128+4>>2]=0;c[v+16+128+8>>2]=0;c[v+16+128+12>>2]=0;c[v+16+376>>2]=2;c[v+16+368>>2]=0;g[v+16+144>>2]=0.0;f=Cn(v+16|0,v+400|0,f)|0;if(f|0){c[h>>2]=(f|0)==1?1:2;b=0;i=v;return b|0}f=c[v+16+372>>2]|0;if(!(c[f+32>>2]|0)){q=0.0;p=0.0;o=0.0;n=0.0;m=0.0;j=0.0}else{e=0;q=0.0;p=0.0;o=0.0;n=0.0;m=0.0;j=0.0;do{u=+g[f+16+(e<<2)>>2];a=c[v+400+120>>2]|0;l=c[v+400+124>>2]|0;d=(c[v+400>>2]|0)+(l>>1)|0;if(l&1)a=c[(c[d>>2]|0)+a>>2]|0;Zb[a&127](v,d,c[f+(e<<2)>>2]|0);q=q+u*+g[v>>2];o=o+u*+g[v+4>>2];p=p+u*+g[v+8>>2];f=c[(c[v+16+372>>2]|0)+(e<<2)>>2]|0;r=-+g[f>>2];s=-+g[f+4>>2];t=-+g[f+8>>2];f=c[v+400+120>>2]|0;l=c[v+400+124>>2]|0;a=(c[v+400+4>>2]|0)+(l>>1)|0;if(l&1)f=c[(c[a>>2]|0)+f>>2]|0;F=+g[v+400+24>>2]*r+ +g[v+400+28>>2]*s+ +g[v+400+32>>2]*t;E=+g[v+400+40>>2]*r+ +g[v+400+44>>2]*s+ +g[v+400+48>>2]*t;g[v+528>>2]=+g[v+400+8>>2]*r+ +g[v+400+12>>2]*s+ +g[v+400+16>>2]*t;g[v+528+4>>2]=F;g[v+528+8>>2]=E;g[v+528+12>>2]=0.0;Zb[f&127](v+544|0,a,v+528|0);E=+g[v+544>>2];F=+g[v+544+4>>2];G=+g[v+544+8>>2];n=n+u*(E*+g[v+400+56>>2]+F*+g[v+400+60>>2]+G*+g[v+400+64>>2]+ +g[v+400+104>>2]);j=j+u*(E*+g[v+400+72>>2]+F*+g[v+400+76>>2]+G*+g[v+400+80>>2]+ +g[v+400+108>>2]);m=m+u*(E*+g[v+400+88>>2]+F*+g[v+400+92>>2]+G*+g[v+400+96>>2]+ +g[v+400+112>>2]);e=e+1|0;f=c[v+16+372>>2]|0}while(e>>>0<(c[f+32>>2]|0)>>>0)}D=q*+g[b+16>>2]+o*+g[b+20>>2]+p*+g[b+24>>2]+ +g[b+52>>2];E=q*+g[b+32>>2]+o*+g[b+36>>2]+p*+g[b+40>>2]+ +g[b+56>>2];g[h+4>>2]=q*+g[b>>2]+o*+g[b+4>>2]+p*+g[b+8>>2]+ +g[b+48>>2];g[h+8>>2]=D;g[h+12>>2]=E;g[h+16>>2]=0.0;E=n*+g[b+16>>2]+j*+g[b+20>>2]+m*+g[b+24>>2]+ +g[b+52>>2];D=n*+g[b+32>>2]+j*+g[b+36>>2]+m*+g[b+40>>2]+ +g[b+56>>2];g[h+20>>2]=n*+g[b>>2]+j*+g[b+4>>2]+m*+g[b+8>>2]+ +g[b+48>>2];g[h+24>>2]=E;g[h+28>>2]=D;g[h+32>>2]=0.0;D=q-n;E=o-j;G=p-m;g[h+48>>2]=0.0;F=+O(+(D*D+E*E+G*G));g[h+52>>2]=F;F=F>9.999999747378752e-05?1.0/F:1.0;g[h+36>>2]=F*D;g[h+40>>2]=F*E;g[h+44>>2]=F*G;b=1;i=v;return b|0}function Cn(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0.0,j=0.0,l=0.0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0.0,u=0,v=0.0,w=0,x=0,y=0.0,z=0,A=0,B=0.0,C=0.0,D=0.0,E=0.0,F=0;A=i;i=i+176|0;c[a+348>>2]=a+220;c[a+352>>2]=a+252;c[a+356>>2]=a+284;c[a+360>>2]=a+316;c[a+364>>2]=4;c[a+368>>2]=0;c[a+376>>2]=0;x=c[b+4>>2]|0;c[a>>2]=c[b>>2];c[a+4>>2]=x;c[a+8>>2]=c[b+8>>2];c[a+8+4>>2]=c[b+8+4>>2];c[a+8+8>>2]=c[b+8+8>>2];c[a+8+12>>2]=c[b+8+12>>2];c[a+24>>2]=c[b+24>>2];c[a+24+4>>2]=c[b+24+4>>2];c[a+24+8>>2]=c[b+24+8>>2];c[a+24+12>>2]=c[b+24+12>>2];c[a+40>>2]=c[b+40>>2];c[a+40+4>>2]=c[b+40+4>>2];c[a+40+8>>2]=c[b+40+8>>2];c[a+40+12>>2]=c[b+40+12>>2];c[a+56>>2]=c[b+56>>2];c[a+56+4>>2]=c[b+56+4>>2];c[a+56+8>>2]=c[b+56+8>>2];c[a+56+12>>2]=c[b+56+12>>2];c[a+72>>2]=c[b+72>>2];c[a+72+4>>2]=c[b+72+4>>2];c[a+72+8>>2]=c[b+72+8>>2];c[a+72+12>>2]=c[b+72+12>>2];c[a+88>>2]=c[b+88>>2];c[a+88+4>>2]=c[b+88+4>>2];c[a+88+8>>2]=c[b+88+8>>2];c[a+88+12>>2]=c[b+88+12>>2];c[a+104>>2]=c[b+104>>2];c[a+104+4>>2]=c[b+104+4>>2];c[a+104+8>>2]=c[b+104+8>>2];c[a+104+12>>2]=c[b+104+12>>2];x=c[b+124>>2]|0;c[a+120>>2]=c[b+120>>2];c[a+124>>2]=x;g[a+144>>2]=0.0;c[a+180>>2]=0;c[a+128>>2]=c[d>>2];c[a+128+4>>2]=c[d+4>>2];c[a+128+8>>2]=c[d+8>>2];c[a+128+12>>2]=c[d+12>>2];e=+g[a+128>>2];h=+g[a+132>>2];j=+g[a+136>>2];if(e*e+h*h+j*j>0.0){d=(g[k>>2]=-e,c[k>>2]|0);b=(g[k>>2]=-h,c[k>>2]|0);f=(g[k>>2]=-j,c[k>>2]|0)}else{d=1065353216;b=0;f=0}g[a+164>>2]=0.0;c[a+364>>2]=3;c[a+148>>2]=a+316;c[a+180>>2]=1;t=(c[k>>2]=d,+g[k>>2]);v=(c[k>>2]=b,+g[k>>2]);Dn(a,t,v,(c[k>>2]=f,+g[k>>2]),a+316|0);g[a+164>>2]=1.0;w=(c[a+148>>2]|0)+16|0;c[a+128>>2]=c[w>>2];c[a+128+4>>2]=c[w+4>>2];c[a+128+8>>2]=c[w+8>>2];c[a+128+12>>2]=c[w+12>>2];c[A+24+48>>2]=c[w>>2];c[A+24+48+4>>2]=c[w+4>>2];c[A+24+48+8>>2]=c[w+8>>2];c[A+24+48+12>>2]=c[w+12>>2];c[A+24+32>>2]=c[w>>2];c[A+24+32+4>>2]=c[w+4>>2];c[A+24+32+8>>2]=c[w+8>>2];c[A+24+32+12>>2]=c[w+12>>2];c[A+24+16>>2]=c[w>>2];c[A+24+16+4>>2]=c[w+4>>2];c[A+24+16+8>>2]=c[w+8>>2];c[A+24+16+12>>2]=c[w+12>>2];c[A+24>>2]=c[w>>2];c[A+24+4>>2]=c[w+4>>2];c[A+24+8>>2]=c[w+8>>2];c[A+24+12>>2]=c[w+12>>2];v=0.0;w=0;x=0;e=e*e+h*h+j*j;a:do{u=c[a+368>>2]|0;l=+g[a+128>>2];h=+g[a+132>>2];j=+g[a+136>>2];o=+O(+(l*l+h*h+j*j));if(o<9.999999747378752e-05){z=5;break}g[a+148+(u*36|0)+16+(c[a+148+(u*36|0)+32>>2]<<2)>>2]=0.0;d=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=d;c[a+148+(u*36|0)+(c[a+148+(u*36|0)+32>>2]<<2)>>2]=c[a+348+(d<<2)>>2];d=c[a+148+(u*36|0)+32>>2]|0;c[a+148+(u*36|0)+32>>2]=d+1;Dn(a,-l,-h,-j,c[a+148+(u*36|0)+(d<<2)>>2]|0);d=c[a+148+(u*36|0)+32>>2]|0;b=c[a+148+(u*36|0)+(d+-1<<2)>>2]|0;h=+g[b+16>>2];j=+g[b+20>>2];l=+g[b+24>>2];q=h-+g[A+24>>2];r=j-+g[A+24+4>>2];t=l-+g[A+24+8>>2];if(q*q+r*r+t*t<9.999999747378752e-05){z=8;break}q=h-+g[A+24+16>>2];r=j-+g[A+24+20>>2];t=l-+g[A+24+24>>2];if(q*q+r*r+t*t<9.999999747378752e-05){z=8;break}q=h-+g[A+24+32>>2];r=j-+g[A+24+36>>2];t=l-+g[A+24+40>>2];if(q*q+r*r+t*t<9.999999747378752e-05){z=8;break}q=h-+g[A+24+48>>2];r=j-+g[A+24+52>>2];t=l-+g[A+24+56>>2];if(q*q+r*r+t*t<9.999999747378752e-05){z=8;break}w=w+1&3;s=A+24+(w<<4)|0;c[s>>2]=c[b+16>>2];c[s+4>>2]=c[b+16+4>>2];c[s+8>>2]=c[b+16+8>>2];c[s+12>>2]=c[b+16+12>>2];t=(+g[a+128>>2]*h+ +g[a+132>>2]*j+ +g[a+136>>2]*l)/o;v=t>v?t:v;if(o-v-o*9.999999747378752e-05<=0.0){z=9;break}c[A>>2]=0;b:do switch(d|0){case 2:{s=c[a+148+(u*36|0)>>2]|0;n=c[a+148+(u*36|0)+4>>2]|0;e=+g[n+16>>2];h=+g[s+16>>2];j=+g[n+20>>2];l=+g[s+20>>2];o=+g[n+24>>2];p=+g[s+24>>2];if(!((e-h)*(e-h)+(j-l)*(j-l)+(o-p)*(o-p)>0.0)){z=39;break a}q=-(h*(e-h)+l*(j-l)+p*(o-p))/((e-h)*(e-h)+(j-l)*(j-l)+(o-p)*(o-p));if(q>=1.0){g[A+8>>2]=0.0;g[A+8+4>>2]=1.0;c[A>>2]=2;e=e*e+j*j+o*o;break b}if(!(q<=0.0)){g[A+8+4>>2]=q;g[A+8>>2]=1.0-q;c[A>>2]=3;e=((e-h)*q+h)*((e-h)*q+h)+((j-l)*q+l)*((j-l)*q+l)+((o-p)*q+p)*((o-p)*q+p);break b}else{g[A+8>>2]=1.0;g[A+8+4>>2]=0.0;c[A>>2]=1;e=h*h+l*l+p*p;break b}}case 3:{e=+En((c[a+148+(u*36|0)>>2]|0)+16|0,(c[a+148+(u*36|0)+4>>2]|0)+16|0,(c[a+148+(u*36|0)+8>>2]|0)+16|0,A+8|0,A);break}case 4:{f=c[a+148+(u*36|0)>>2]|0;m=c[a+148+(u*36|0)+4>>2]|0;n=c[a+148+(u*36|0)+8>>2]|0;s=c[a+148+(u*36|0)+12>>2]|0;c[A+152>>2]=f+16;c[A+152+4>>2]=m+16;c[A+152+8>>2]=n+16;c[A+152+12>>2]=s+16;j=+g[f+16>>2];l=+g[s+16>>2];e=+g[f+20>>2];o=+g[s+20>>2];h=+g[f+24>>2];p=+g[s+24>>2];g[A+104>>2]=j-l;g[A+104+4>>2]=e-o;g[A+104+8>>2]=h-p;g[A+104+12>>2]=0.0;B=+g[m+16>>2];D=+g[m+20>>2];r=+g[m+24>>2];g[A+104+16>>2]=B-l;g[A+104+20>>2]=D-o;g[A+104+24>>2]=r-p;g[A+104+28>>2]=0.0;q=+g[n+16>>2];E=+g[n+20>>2];C=+g[n+24>>2];g[A+104+32>>2]=q-l;g[A+104+36>>2]=E-o;g[A+104+40>>2]=C-p;g[A+104+44>>2]=0.0;t=(e-o)*(r-p)*(q-l)+(h-p)*(B-l)*(E-o)-(E-o)*((r-p)*(j-l))-(e-o)*(B-l)*(C-p)+(C-p)*((j-l)*(D-o))-(q-l)*((h-p)*(D-o));if(t!=t|0.0!=0.0|t==0.0|!(t*(h*((B-q)*(e-D)-(D-E)*(j-B))+(j*((D-E)*(h-r)-(r-C)*(e-D))+e*((r-C)*(j-B)-(B-q)*(h-r))))<=0.0))e=-1.0;else{c[A+92>>2]=0;c[A+92+4>>2]=0;c[A+92+8>>2]=0;c[A+88>>2]=0;r=e-o;q=h-p;h=j-l;d=0;e=-1.0;while(1){b=c[6876+(d<<2)>>2]|0;C=+g[A+104+(b<<4)+8>>2];D=+g[A+104+(b<<4)+4>>2];E=+g[A+104+(b<<4)>>2];if(t*((r*C-q*D)*l+o*(q*E-C*h)+(D*h-r*E)*p)>0.0?(y=+En(c[A+152+(d<<2)>>2]|0,c[A+152+(b<<2)>>2]|0,s+16|0,A+92|0,A+88|0),e<0.0|y<e):0){F=c[A+88>>2]|0;c[A>>2]=(F&2|0?1<<b:0)+(F<<1&8)+(F&1|0?1<<d:0);c[A+8+(d<<2)>>2]=c[A+92>>2];c[A+8+(b<<2)>>2]=c[A+92+4>>2];g[A+8+(c[6876+(b<<2)>>2]<<2)>>2]=0.0;c[A+8+12>>2]=c[A+92+8>>2];e=y}d=d+1|0;if((d|0)==3)break;r=+g[A+104+(d<<4)+4>>2];q=+g[A+104+(d<<4)+8>>2];h=+g[A+104+(d<<4)>>2];l=+g[s+16>>2];o=+g[s+20>>2];p=+g[s+24>>2]}if(e<0.0){c[A>>2]=15;l=+g[n+20>>2];E=+g[m+24>>2];D=+g[s+16>>2];h=+g[n+24>>2];C=+g[m+16>>2];o=+g[s+20>>2];j=+g[n+16>>2];B=+g[s+24>>2];q=+g[m+20>>2];g[A+8>>2]=(l*E*D+h*C*o-o*(E*j)-l*C*B+B*(j*q)-D*(h*q))/t;e=+g[f+20>>2];p=+g[f+24>>2];r=+g[f+16>>2];g[A+8+4>>2]=(e*h*D+p*j*o-o*(h*r)-e*j*B+B*(r*l)-D*(p*l))/t;g[A+8+8>>2]=(q*p*D+E*r*o-o*(p*C)-q*r*B+B*(C*e)-D*(E*e))/t;g[A+8+12>>2]=1.0-((l*E*D+h*C*o-o*(E*j)-l*C*B+B*(j*q)-D*(h*q))/t+(e*h*D+p*j*o-o*(h*r)-e*j*B+B*(r*l)-D*(p*l))/t+(q*p*D+E*r*o-o*(p*C)-q*r*B+B*(C*e)-D*(E*e))/t);e=0.0}}break}default:{}}while(0);if(!(e>=0.0)){z=39;break}c[a+148+((1-u|0)*36|0)+32>>2]=0;c[a+128>>2]=0;c[a+128+4>>2]=0;c[a+128+8>>2]=0;c[a+128+12>>2]=0;c[a+368>>2]=1-u;d=c[a+148+(u*36|0)+32>>2]|0;b=c[A>>2]|0;if(d|0){n=0;do{f=a+148+(u*36|0)+(n<<2)|0;m=c[f>>2]|0;if(!(b&1<<n)){F=c[a+364>>2]|0;c[a+364>>2]=F+1;c[a+348+(F<<2)>>2]=m}else{c[a+148+((1-u|0)*36|0)+(c[a+148+((1-u|0)*36|0)+32>>2]<<2)>>2]=m;s=c[A+8+(n<<2)>>2]|0;F=c[a+148+((1-u|0)*36|0)+32>>2]|0;c[a+148+((1-u|0)*36|0)+32>>2]=F+1;c[a+148+((1-u|0)*36|0)+16+(F<<2)>>2]=s;F=c[f>>2]|0;C=(c[k>>2]=s,+g[k>>2]);D=C*+g[F+20>>2];E=C*+g[F+24>>2];g[a+128>>2]=+g[F+16>>2]*C+ +g[a+128>>2];g[a+132>>2]=D+ +g[a+132>>2];g[a+136>>2]=E+ +g[a+136>>2]}n=n+1|0}while((n|0)!=(d|0))}if((b|0)==15)c[a+376>>2]=1;x=x+1|0;if(x>>>0>=128){z=38;break}}while(!(c[a+376>>2]|0));if((z|0)==5)c[a+376>>2]=1;else if((z|0)==8){F=c[a+368>>2]|0;z=(c[a+148+(F*36|0)+32>>2]|0)+-1|0;c[a+148+(F*36|0)+32>>2]=z;z=c[a+148+(F*36|0)+(z<<2)>>2]|0;F=c[a+364>>2]|0;c[a+364>>2]=F+1;c[a+348+(F<<2)>>2]=z}else if((z|0)==9){F=c[a+368>>2]|0;z=(c[a+148+(F*36|0)+32>>2]|0)+-1|0;c[a+148+(F*36|0)+32>>2]=z;z=c[a+148+(F*36|0)+(z<<2)>>2]|0;F=c[a+364>>2]|0;c[a+364>>2]=F+1;c[a+348+(F<<2)>>2]=z}else if((z|0)==38)c[a+376>>2]=2;else if((z|0)==39){F=c[a+368>>2]|0;z=(c[a+148+(F*36|0)+32>>2]|0)+-1|0;c[a+148+(F*36|0)+32>>2]=z;z=c[a+148+(F*36|0)+(z<<2)>>2]|0;F=c[a+364>>2]|0;c[a+364>>2]=F+1;c[a+348+(F<<2)>>2]=z}c[a+372>>2]=a+148+((c[a+368>>2]|0)*36|0);d=c[a+376>>2]|0;switch(d|0){case 0:{C=+g[a+128>>2];D=+g[a+132>>2];E=+g[a+136>>2];g[a+144>>2]=+O(+(C*C+D*D+E*E));i=A;return d|0}case 1:{g[a+144>>2]=0.0;i=A;return d|0}default:{i=A;return d|0}}return 0}function Dn(a,b,d,e,f){a=a|0;b=+b;d=+d;e=+e;f=f|0;var h=0,j=0,k=0,l=0,m=0.0,n=0.0;k=i;i=i+48|0;m=1.0/+O(+(b*b+d*d+e*e));g[f>>2]=m*b;g[f+4>>2]=m*d;g[f+8>>2]=m*e;g[f+12>>2]=0.0;h=c[a+120>>2]|0;l=c[a+124>>2]|0;j=(c[a>>2]|0)+(l>>1)|0;if(l&1)h=c[(c[j>>2]|0)+h>>2]|0;Zb[h&127](k,j,f);b=-+g[f>>2];d=-+g[f+4>>2];e=-+g[f+8>>2];h=c[a+120>>2]|0;l=c[a+124>>2]|0;j=(c[a+4>>2]|0)+(l>>1)|0;if(l&1)h=c[(c[j>>2]|0)+h>>2]|0;m=+g[a+24>>2]*b+ +g[a+28>>2]*d+ +g[a+32>>2]*e;n=+g[a+40>>2]*b+ +g[a+44>>2]*d+ +g[a+48>>2]*e;g[k+16>>2]=+g[a+8>>2]*b+ +g[a+12>>2]*d+ +g[a+16>>2]*e;g[k+16+4>>2]=m;g[k+16+8>>2]=n;g[k+16+12>>2]=0.0;Zb[h&127](k+32|0,j,k+16|0);n=+g[k+32>>2];b=+g[k+32+4>>2];d=+g[k+32+8>>2];e=+g[k+4>>2]-(n*+g[a+72>>2]+b*+g[a+76>>2]+d*+g[a+80>>2]+ +g[a+108>>2]);m=+g[k+8>>2]-(n*+g[a+88>>2]+b*+g[a+92>>2]+d*+g[a+96>>2]+ +g[a+112>>2]);g[f+16>>2]=+g[k>>2]-(n*+g[a+56>>2]+b*+g[a+60>>2]+d*+g[a+64>>2]+ +g[a+104>>2]);g[f+20>>2]=e;g[f+24>>2]=m;g[f+28>>2]=0.0;i=k;return}function En(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,l=0.0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0,M=0;L=i;i=i+64|0;c[L+48>>2]=a;c[L+48+4>>2]=b;c[L+48+8>>2]=d;C=+g[a>>2];F=+g[b>>2];J=+g[a+4>>2];K=+g[b+4>>2];z=+g[a+8>>2];A=+g[b+8>>2];g[L>>2]=C-F;g[L+4>>2]=J-K;g[L+8>>2]=z-A;g[L+12>>2]=0.0;B=+g[d>>2];D=+g[d+4>>2];E=+g[d+8>>2];g[L+16>>2]=F-B;g[L+20>>2]=K-D;g[L+24>>2]=A-E;g[L+28>>2]=0.0;g[L+32>>2]=B-C;g[L+36>>2]=D-J;g[L+40>>2]=E-z;g[L+44>>2]=0.0;G=(J-K)*(A-E)-(z-A)*(K-D);H=(z-A)*(F-B)-(A-E)*(C-F);I=(K-D)*(C-F)-(J-K)*(F-B);if(I*I+(G*G+H*H)>0.0){o=J-K;p=z-A;q=C-F;v=C;w=J;x=z;m=0;y=-1.0;n=0;h=0;j=0}else{K=-1.0;i=L;return +K}while(1){if(v*(I*o-H*p)+w*(G*p-I*q)+(H*q-G*o)*x>0.0){u=c[6876+(m<<2)>>2]|0;M=c[L+48+(u<<2)>>2]|0;l=+g[M>>2];p=l-v;q=+g[M+4>>2];r=q-w;s=+g[M+8>>2];t=s-x;do if(p*p+r*r+t*t>0.0){o=-(v*p+w*r+x*t)/(p*p+r*r+t*t);if(o>=1.0){l=l*l+q*q+s*s;n=2;h=0;j=1065353216;break}if(!(o<=0.0)){j=(g[k>>2]=o,c[k>>2]|0);v=v+p*o;l=w+r*o;x=x+t*o;l=x*x+(v*v+l*l);n=3;h=(g[k>>2]=1.0-o,c[k>>2]|0);break}else{l=v*v+w*w+x*x;n=1;h=1065353216;j=0;break}}else l=-1.0;while(0);if(y<0.0|l<y){c[f>>2]=(n&1|0?1<<m:0)+(n&2|0?1<<u:0);c[e+(m<<2)>>2]=h;c[e+(u<<2)>>2]=j;g[e+(c[6876+(u<<2)>>2]<<2)>>2]=0.0}else l=y}else l=y;m=m+1|0;if((m|0)==3)break;M=c[L+48+(m<<2)>>2]|0;o=+g[L+(m<<4)+4>>2];p=+g[L+(m<<4)+8>>2];q=+g[L+(m<<4)>>2];v=+g[M>>2];w=+g[M+4>>2];x=+g[M+8>>2];y=l}if(!(l<0.0)){K=l;i=L;return +K}x=+O(+(I*I+(G*G+H*H)));y=(G*+g[a>>2]+H*+g[a+4>>2]+I*+g[a+8>>2])/(I*I+(G*G+H*H));c[f>>2]=7;v=+g[b>>2]-G*y;t=+g[b+4>>2]-H*y;w=+g[b+8>>2]-I*y;K=+O(+((t*(F-B)-v*(K-D))*(t*(F-B)-v*(K-D))+(((K-D)*w-t*(A-E))*((K-D)*w-t*(A-E))+(v*(A-E)-w*(F-B))*(v*(A-E)-w*(F-B)))))/x;g[e>>2]=K;A=+g[d>>2]-G*y;w=+g[d+4>>2]-H*y;F=+g[d+8>>2]-I*y;J=+O(+((w*(B-C)-A*(D-J))*(w*(B-C)-A*(D-J))+(((D-J)*F-w*(E-z))*((D-J)*F-w*(E-z))+(A*(E-z)-F*(B-C))*(A*(E-z)-F*(B-C)))))/x;g[e+4>>2]=J;g[e+8>>2]=1.0-(J+K);K=I*y*(I*y)+(G*y*(G*y)+H*y*(H*y));i=L;return +K}function Fn(b,e,f,h,j,l,m){b=b|0;e=e|0;f=f|0;h=h|0;j=j|0;l=l|0;m=m|0;var n=0.0,o=0.0,p=0.0,q=0,r=0,s=0.0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0;B=i;i=i+9856|0;q=l;r=q+36|0;do{c[q>>2]=0;q=q+4|0}while((q|0)<(r|0));c[B+9712>>2]=b;c[B+9712+4>>2]=f;E=+g[h>>2];R=+g[e>>2];F=+g[h+16>>2];H=+g[e+16>>2];G=+g[h+32>>2];S=+g[e+32>>2];I=+g[e+4>>2];T=+g[e+20>>2];J=+g[e+36>>2];s=+g[e+8>>2];n=+g[e+24>>2];D=+g[e+40>>2];Q=+g[h+4>>2];P=+g[h+20>>2];N=+g[h+36>>2];M=+g[h+8>>2];L=+g[h+24>>2];K=+g[h+40>>2];g[B+9712+8>>2]=E*R+F*H+G*S;g[B+9712+12>>2]=E*I+F*T+G*J;g[B+9712+16>>2]=E*s+F*n+G*D;g[B+9712+20>>2]=0.0;g[B+9712+24>>2]=R*Q+H*P+S*N;g[B+9712+28>>2]=I*Q+T*P+J*N;g[B+9712+32>>2]=s*Q+n*P+D*N;g[B+9712+36>>2]=0.0;g[B+9712+40>>2]=R*M+H*L+S*K;g[B+9712+44>>2]=I*M+T*L+J*K;g[B+9712+48>>2]=s*M+n*L+D*K;g[B+9712+52>>2]=0.0;D=+g[h+48>>2]-+g[e+48>>2];n=+g[h+52>>2]-+g[e+52>>2];s=+g[h+56>>2]-+g[e+56>>2];J=+g[e>>2];T=+g[h>>2];I=+g[e+16>>2];S=+g[h+16>>2];H=+g[e+32>>2];R=+g[h+32>>2];G=+g[e+4>>2];F=+g[e+20>>2];E=+g[e+36>>2];C=+g[e+8>>2];o=+g[e+24>>2];p=+g[e+40>>2];g[B+9712+56>>2]=J*T+I*S+H*R;g[B+9712+60>>2]=J*Q+I*P+H*N;g[B+9712+64>>2]=J*M+I*L+H*K;g[B+9712+68>>2]=0.0;g[B+9712+72>>2]=T*G+S*F+R*E;g[B+9712+76>>2]=Q*G+P*F+N*E;g[B+9712+80>>2]=M*G+L*F+K*E;g[B+9712+84>>2]=0.0;g[B+9712+88>>2]=T*C+S*o+R*p;g[B+9712+92>>2]=Q*C+P*o+N*p;g[B+9712+96>>2]=M*C+L*o+K*p;g[B+9712+100>>2]=0.0;g[B+9712+104>>2]=D*J+n*I+s*H;g[B+9712+108>>2]=D*G+n*F+s*E;g[B+9712+112>>2]=D*C+n*o+s*p;g[B+9712+116>>2]=0.0;c[B+9712+120>>2]=m?72:71;c[B+9712+124>>2]=0;c[B+9328+364>>2]=0;c[B+9328+128>>2]=0;c[B+9328+128+4>>2]=0;c[B+9328+128+8>>2]=0;c[B+9328+128+12>>2]=0;c[B+9328+376>>2]=2;c[B+9328+368>>2]=0;g[B+9328+144>>2]=0.0;p=-+g[j+4>>2];s=-+g[j+8>>2];g[B+16>>2]=-+g[j>>2];g[B+16+4>>2]=p;g[B+16+8>>2]=s;g[B+16+12>>2]=0.0;switch(Cn(B+9328|0,B+9712|0,B+16|0)|0){case 1:{w=B+32+9280|0;x=B+32+9288|0;y=B+32+9292|0;c[w>>2]=0;c[w+4>>2]=0;c[w+8>>2]=0;c[w+12>>2]=0;c[B+32>>2]=9;A=B+32+40|0;c[B+32+9276>>2]=0;c[A>>2]=0;c[A+4>>2]=0;c[A+8>>2]=0;c[A+12>>2]=0;c[A+16>>2]=0;m=0;do{b=128-m+-1|0;c[B+32+2108+(b*56|0)+44>>2]=0;f=c[x>>2]|0;c[B+32+2108+(b*56|0)+48>>2]=f;if(f|0)c[f+44>>2]=B+32+2108+(b*56|0);c[x>>2]=B+32+2108+(b*56|0);c[y>>2]=(c[y>>2]|0)+1;m=m+1|0}while((m|0)!=128);p=+g[j>>2];s=+g[j+4>>2];o=+g[j+8>>2];t=c[B+9328+372>>2]|0;do if((c[t+32>>2]|0)>>>0>1?Gn(B+9328|0)|0:0){v=B+32+9280|0;b=c[v>>2]|0;if(b|0){q=c[B+32+9284>>2]|0;r=c[y>>2]|0;do{f=b+44|0;h=b+48|0;m=c[h>>2]|0;if(m|0)c[m+44>>2]=c[f>>2];f=c[f>>2]|0;if(f|0)c[f+48>>2]=c[h>>2];if((c[v>>2]|0)==(b|0))c[v>>2]=c[h>>2];q=q+-1|0;c[b+44>>2]=0;c[h>>2]=c[x>>2];f=c[x>>2]|0;if(f|0)c[f+44>>2]=b;c[x>>2]=b;r=r+1|0;b=c[v>>2]|0}while((b|0)!=0);c[B+32+9284>>2]=q;c[y>>2]=r}c[B+32>>2]=0;c[B+32+9276>>2]=0;b=c[t>>2]|0;f=c[t+12>>2]|0;T=+g[f+16>>2];K=+g[b+16>>2]-T;M=+g[f+20>>2];N=+g[b+20>>2]-M;Q=+g[f+24>>2];R=+g[b+24>>2]-Q;f=c[t+4>>2]|0;P=+g[f+16>>2]-T;S=+g[f+20>>2]-M;L=+g[f+24>>2]-Q;m=c[t+8>>2]|0;T=+g[m+16>>2]-T;M=+g[m+20>>2]-M;Q=+g[m+24>>2]-Q;if(K*S*Q+(N*L*T+R*P*M-K*L*M-N*P*Q)-R*S*T<0.0){c[t>>2]=f;c[t+4>>2]=b;h=c[t+16>>2]|0;c[t+16>>2]=c[t+20>>2];c[t+20>>2]=h;h=f}else{h=b;b=f}h=Hn(B+32|0,h,b,m,1)|0;q=Hn(B+32|0,c[t+4>>2]|0,c[t>>2]|0,c[t+12>>2]|0,1)|0;r=Hn(B+32|0,c[t+8>>2]|0,c[t+4>>2]|0,c[t+12>>2]|0,1)|0;j=Hn(B+32|0,c[t>>2]|0,c[t+8>>2]|0,c[t+12>>2]|0,1)|0;if((c[B+32+9284>>2]|0)==4){b=c[w>>2]|0;n=+g[b+16>>2];f=c[b+48>>2]|0;if(f){o=n*n;while(1){n=+g[f+16>>2];m=n*n<o;b=m?f:b;f=c[f+48>>2]|0;if(!f)break;else o=m?n*n:o}}s=+g[b>>2];p=+g[b+4>>2];o=+g[b+8>>2];n=+g[b+12>>2];u=c[b+16>>2]|0;U=c[b+20>>2]|0;f=c[b+24>>2]|0;m=c[b+28>>2]|0;a[h+52>>0]=0;c[h+32>>2]=q;a[q+52>>0]=0;c[q+32>>2]=h;a[h+53>>0]=0;c[h+36>>2]=r;a[r+52>>0]=1;c[r+32>>2]=h;a[h+54>>0]=0;c[h+40>>2]=j;a[j+52>>0]=2;c[j+32>>2]=h;a[q+53>>0]=2;c[q+36>>2]=j;a[j+54>>0]=1;c[j+40>>2]=q;a[q+54>>0]=1;c[q+40>>2]=r;a[r+53>>0]=2;c[r+36>>2]=q;a[r+54>>0]=1;c[r+40>>2]=j;a[j+53>>0]=2;c[j+36>>2]=r;c[B+32>>2]=0;t=b;r=U;j=f;q=m;b=u;u=0;while(1){f=c[B+32+9276>>2]|0;if(f>>>0>=64){z=43;break}c[B+9840>>2]=0;c[B+9840+4>>2]=0;c[B+9840+8>>2]=0;c[B+32+9276>>2]=f+1;u=u+1|0;a[t+55>>0]=u;h=t+4|0;U=t+8|0;Dn(B+9328|0,+g[t>>2],+g[h>>2],+g[U>>2],B+32+60+(f<<5)|0);if(+g[t>>2]*+g[B+32+60+(f<<5)+16>>2]+ +g[h>>2]*+g[B+32+60+(f<<5)+20>>2]+ +g[U>>2]*+g[B+32+60+(f<<5)+24>>2]-+g[t+16>>2]>9.999999747378752e-05)h=0;else{f=7;z=42;break}do{m=Jn(B+32|0,u,B+32+60+(f<<5)|0,c[t+32+(h<<2)>>2]|0,d[t+52+h>>0]|0,B+9840|0)|0;h=h+1|0}while(m&h>>>0<3);if(!(m&(c[B+9840+8>>2]|0)>>>0>2)){f=4;z=42;break}m=c[B+9840>>2]|0;b=c[B+9840+4>>2]|0;a[m+53>>0]=2;c[m+36>>2]=b;a[b+54>>0]=1;c[b+40>>2]=m;b=t+44|0;m=t+48|0;f=c[m>>2]|0;if(f|0)c[f+44>>2]=c[b>>2];b=c[b>>2]|0;if(b|0)c[b+48>>2]=c[m>>2];if((c[v>>2]|0)==(t|0))c[v>>2]=c[m>>2];c[B+32+9284>>2]=(c[B+32+9284>>2]|0)+-1;c[t+44>>2]=0;c[m>>2]=c[x>>2];b=c[x>>2]|0;if(b|0)c[b+44>>2]=t;c[x>>2]=t;c[y>>2]=(c[y>>2]|0)+1;f=c[w>>2]|0;n=+g[f+16>>2];b=c[f+48>>2]|0;if(b){o=n*n;while(1){n=+g[b+16>>2];m=n*n<o;f=m?b:f;b=c[b+48>>2]|0;if(!b)break;else o=m?n*n:o}}s=+g[f>>2];p=+g[f+4>>2];o=+g[f+8>>2];n=+g[f+12>>2];b=c[f+16>>2]|0;m=c[f+20>>2]|0;h=c[f+24>>2]|0;q=c[f+28>>2]|0;if(u>>>0>=255){f=q;break}else{t=f;r=m;j=h}}if((z|0)==42){c[B+32>>2]=f;m=r;h=j;f=q}else if((z|0)==43){c[B+32>>2]=6;m=r;h=j;f=q}R=(c[k>>2]=b,+g[k>>2]);P=s*R;M=p*R;R=o*R;g[B+32+40>>2]=s;g[B+32+44>>2]=p;g[B+32+48>>2]=o;g[B+32+52>>2]=n;c[B+32+56>>2]=b;c[B+32+36>>2]=3;c[B+32+4>>2]=m;c[B+32+8>>2]=h;c[B+32+12>>2]=f;U=h;Q=+g[U+16>>2]-P;K=+g[U+20>>2]-M;N=+g[U+24>>2]-R;y=f;J=+g[y+16>>2]-P;L=+g[y+20>>2]-M;S=+g[y+24>>2]-R;S=+O(+((Q*L-K*J)*(Q*L-K*J)+((K*S-N*L)*(K*S-N*L)+(N*J-Q*S)*(N*J-Q*S))));g[B+32+20>>2]=S;Q=+g[y+16>>2]-P;J=+g[y+20>>2]-M;N=+g[y+24>>2]-R;y=m;L=+g[y+16>>2]-P;K=+g[y+20>>2]-M;T=+g[y+24>>2]-R;T=+O(+((Q*K-J*L)*(Q*K-J*L)+((J*T-N*K)*(J*T-N*K)+(N*L-Q*T)*(N*L-Q*T))));g[B+32+24>>2]=T;Q=+g[y+16>>2]-P;L=+g[y+20>>2]-M;N=+g[y+24>>2]-R;P=+g[U+16>>2]-P;M=+g[U+20>>2]-M;R=+g[U+24>>2]-R;R=+O(+((Q*M-L*P)*(Q*M-L*P)+((L*R-N*M)*(L*R-N*M)+(N*P-Q*R)*(N*P-Q*R))));g[B+32+20>>2]=S/(R+(S+T));g[B+32+24>>2]=T/(R+(S+T));g[B+32+28>>2]=R/(R+(S+T));if((c[B+32>>2]|0)!=9)if(!(c[B+32+36>>2]|0)){p=0.0;o=0.0;n=0.0;break}else{h=B+32+36|0;z=51;break}c[l>>2]=3;U=0;i=B;return U|0}else z=45}else z=45;while(0);if((z|0)==45){c[B+32>>2]=8;g[B+32+40>>2]=p;g[B+32+44>>2]=s;g[B+32+48>>2]=o;g[B+32+52>>2]=0.0;n=+O(+(p*p+s*s+o*o));if(n>0.0){g[B+32+40>>2]=1.0/n*p;g[B+32+44>>2]=1.0/n*s;g[B+32+48>>2]=1.0/n*o}else{c[A>>2]=1065353216;c[B+32+44>>2]=0;c[B+32+48>>2]=0}g[B+32+52>>2]=0.0;g[B+32+56>>2]=0.0;c[B+32+36>>2]=1;c[B+32+4>>2]=c[t>>2];g[B+32+20>>2]=1.0;h=B+32+36|0;z=51}if((z|0)==51){m=0;p=0.0;o=0.0;n=0.0;do{b=c[B+9712+120>>2]|0;U=c[B+9712+124>>2]|0;f=(c[B+9712>>2]|0)+(U>>1)|0;if(U&1)b=c[(c[f>>2]|0)+b>>2]|0;Zb[b&127](B,f,c[B+32+4+(m<<2)>>2]|0);T=+g[B+32+20+(m<<2)>>2];p=p+ +g[B>>2]*T;n=n+T*+g[B+4>>2];o=o+T*+g[B+8>>2];m=m+1|0}while(m>>>0<(c[h>>2]|0)>>>0)}c[l>>2]=1;T=p*+g[e+16>>2]+n*+g[e+20>>2]+o*+g[e+24>>2]+ +g[e+52>>2];Q=p*+g[e+32>>2]+n*+g[e+36>>2]+o*+g[e+40>>2]+ +g[e+56>>2];g[l+4>>2]=p*+g[e>>2]+n*+g[e+4>>2]+o*+g[e+8>>2]+ +g[e+48>>2];g[l+8>>2]=T;g[l+12>>2]=Q;g[l+16>>2]=0.0;Q=+g[A>>2];T=+g[B+32+56>>2];R=+g[B+32+44>>2];S=+g[B+32+48>>2];K=p-Q*T;L=n-T*R;M=o-T*S;N=K*+g[e+16>>2]+L*+g[e+20>>2]+M*+g[e+24>>2]+ +g[e+52>>2];P=K*+g[e+32>>2]+L*+g[e+36>>2]+M*+g[e+40>>2]+ +g[e+56>>2];g[l+20>>2]=K*+g[e>>2]+L*+g[e+4>>2]+M*+g[e+8>>2]+ +g[e+48>>2];g[l+24>>2]=N;g[l+28>>2]=P;g[l+32>>2]=0.0;g[l+36>>2]=-Q;g[l+40>>2]=-R;g[l+44>>2]=-S;g[l+48>>2]=0.0;g[l+52>>2]=-T;U=1;i=B;return U|0}case 2:{c[l>>2]=2;U=0;i=B;return U|0}default:{U=0;i=B;return U|0}}return 0}function Gn(a){a=a|0;var b=0,d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0;n=i;i=i+16|0;m=c[a+372>>2]|0;a:do switch(c[m+32>>2]|0){case 1:{d=1;b=0;while(1){c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;g[n+(b<<2)>>2]=1.0;o=m+32|0;g[m+16+(d<<2)>>2]=0.0;d=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=d;c[m+(c[o>>2]<<2)>>2]=c[a+348+(d<<2)>>2];d=c[o>>2]|0;c[o>>2]=d+1;e=+g[n>>2];f=+g[n+4>>2];h=+g[n+8>>2];Dn(a,e,f,h,c[m+(d<<2)>>2]|0);if(Gn(a)|0)break;m=c[a+372>>2]|0;o=(c[m+32>>2]|0)+-1|0;c[m+32>>2]=o;o=c[m+(o<<2)>>2]|0;m=c[a+364>>2]|0;c[a+364>>2]=m+1;c[a+348+(m<<2)>>2]=o;m=c[a+372>>2]|0;g[m+16+(c[m+32>>2]<<2)>>2]=0.0;o=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=o;c[m+(c[m+32>>2]<<2)>>2]=c[a+348+(o<<2)>>2];o=c[m+32>>2]|0;c[m+32>>2]=o+1;Dn(a,-e,-f,-h,c[m+(o<<2)>>2]|0);if(Gn(a)|0)break;o=c[a+372>>2]|0;m=(c[o+32>>2]|0)+-1|0;c[o+32>>2]=m;m=c[o+(m<<2)>>2]|0;o=c[a+364>>2]|0;c[a+364>>2]=o+1;c[a+348+(o<<2)>>2]=m;b=b+1|0;if(b>>>0>=3)break a;m=c[a+372>>2]|0;d=c[m+32>>2]|0}o=1;i=n;return o|0}case 2:{o=c[m+4>>2]|0;b=c[m>>2]|0;e=+g[o+16>>2]-+g[b+16>>2];f=+g[o+20>>2]-+g[b+20>>2];h=+g[o+24>>2]-+g[b+24>>2];b=0;while(1){c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;g[n+(b<<2)>>2]=1.0;j=+g[n+8>>2];k=+g[n+4>>2];l=+g[n>>2];if((f*j-h*k)*(f*j-h*k)+(h*l-e*j)*(h*l-e*j)+(e*k-f*l)*(e*k-f*l)>0.0){m=c[a+372>>2]|0;g[m+16+(c[m+32>>2]<<2)>>2]=0.0;o=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=o;c[m+(c[m+32>>2]<<2)>>2]=c[a+348+(o<<2)>>2];o=c[m+32>>2]|0;c[m+32>>2]=o+1;Dn(a,f*j-h*k,h*l-e*j,e*k-f*l,c[m+(o<<2)>>2]|0);if(Gn(a)|0)break;m=c[a+372>>2]|0;o=(c[m+32>>2]|0)+-1|0;c[m+32>>2]=o;o=c[m+(o<<2)>>2]|0;m=c[a+364>>2]|0;c[a+364>>2]=m+1;c[a+348+(m<<2)>>2]=o;m=c[a+372>>2]|0;g[m+16+(c[m+32>>2]<<2)>>2]=0.0;o=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=o;c[m+(c[m+32>>2]<<2)>>2]=c[a+348+(o<<2)>>2];o=c[m+32>>2]|0;c[m+32>>2]=o+1;Dn(a,-(f*j-h*k),-(h*l-e*j),-(e*k-f*l),c[m+(o<<2)>>2]|0);if(Gn(a)|0)break;o=c[a+372>>2]|0;m=(c[o+32>>2]|0)+-1|0;c[o+32>>2]=m;m=c[o+(m<<2)>>2]|0;o=c[a+364>>2]|0;c[a+364>>2]=o+1;c[a+348+(o<<2)>>2]=m}b=b+1|0;if(b>>>0>=3)break a}o=1;i=n;return o|0}case 3:{o=c[m+4>>2]|0;d=c[m>>2]|0;j=+g[d+16>>2];e=+g[o+16>>2]-j;k=+g[d+20>>2];f=+g[o+20>>2]-k;l=+g[d+24>>2];h=+g[o+24>>2]-l;o=c[m+8>>2]|0;j=+g[o+16>>2]-j;k=+g[o+20>>2]-k;l=+g[o+24>>2]-l;if((f*l-h*k)*(f*l-h*k)+(h*j-e*l)*(h*j-e*l)+(e*k-f*j)*(e*k-f*j)>0.0){g[m+28>>2]=0.0;o=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=o;c[m+12>>2]=c[a+348+(o<<2)>>2];o=c[m+32>>2]|0;c[m+32>>2]=o+1;Dn(a,f*l-h*k,h*j-e*l,e*k-f*j,c[m+(o<<2)>>2]|0);if(Gn(a)|0){o=1;i=n;return o|0}m=c[a+372>>2]|0;o=(c[m+32>>2]|0)+-1|0;c[m+32>>2]=o;o=c[m+(o<<2)>>2]|0;m=c[a+364>>2]|0;c[a+364>>2]=m+1;c[a+348+(m<<2)>>2]=o;m=c[a+372>>2]|0;g[m+16+(c[m+32>>2]<<2)>>2]=0.0;o=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=o;c[m+(c[m+32>>2]<<2)>>2]=c[a+348+(o<<2)>>2];o=c[m+32>>2]|0;c[m+32>>2]=o+1;Dn(a,-(f*l-h*k),-(h*j-e*l),-(e*k-f*j),c[m+(o<<2)>>2]|0);if(Gn(a)|0){o=1;i=n;return o|0}else{o=c[a+372>>2]|0;m=(c[o+32>>2]|0)+-1|0;c[o+32>>2]=m;m=c[o+(m<<2)>>2]|0;o=c[a+364>>2]|0;c[a+364>>2]=o+1;c[a+348+(o<<2)>>2]=m;break a}}break}case 4:{o=c[m>>2]|0;a=c[m+12>>2]|0;l=+g[a+16>>2];r=+g[o+16>>2]-l;p=+g[a+20>>2];e=+g[o+20>>2]-p;h=+g[a+24>>2];j=+g[o+24>>2]-h;o=c[m+4>>2]|0;f=+g[o+16>>2]-l;k=+g[o+20>>2]-p;q=+g[o+24>>2]-h;o=c[m+8>>2]|0;l=+g[o+16>>2]-l;p=+g[o+20>>2]-p;h=+g[o+24>>2]-h;if(!((0.0!=0.0?1:r*k*h+(e*q*l+j*f*p-r*q*p-e*f*h)-j*k*l!=r*k*h+(e*q*l+j*f*p-r*q*p-e*f*h)-j*k*l)|r*k*h+(e*q*l+j*f*p-r*q*p-e*f*h)-j*k*l==0.0)){o=1;i=n;return o|0}break}default:{}}while(0);o=0;i=n;return o|0}function Hn(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0;q=c[b+9288>>2]|0;if(!q){c[b>>2]=5;b=0;return b|0}i=c[q+48>>2]|0;if(i|0)c[i+44>>2]=c[q+44>>2];i=c[q+44>>2]|0;if(i|0)c[i+48>>2]=c[q+48>>2];if((c[b+9288>>2]|0)==(q|0))c[b+9288>>2]=c[q+48>>2];c[b+9292>>2]=(c[b+9292>>2]|0)+-1;c[q+44>>2]=0;c[q+48>>2]=c[b+9280>>2];i=c[b+9280>>2]|0;if(i|0)c[i+44>>2]=q;c[b+9280>>2]=q;c[b+9284>>2]=(c[b+9284>>2]|0)+1;a[q+55>>0]=0;c[q+20>>2]=d;c[q+24>>2]=e;c[q+28>>2]=f;m=+g[d+16>>2];j=+g[e+16>>2]-m;n=+g[d+20>>2];k=+g[e+20>>2]-n;o=+g[d+24>>2];l=+g[e+24>>2]-o;m=+g[f+16>>2]-m;n=+g[f+20>>2]-n;o=+g[f+24>>2]-o;g[q>>2]=k*o-l*n;g[q+4>>2]=l*m-j*o;g[q+8>>2]=j*n-k*m;g[q+12>>2]=0.0;p=+O(+((k*o-l*n)*(k*o-l*n)+(l*m-j*o)*(l*m-j*o)+(j*n-k*m)*(j*n-k*m)));do if(p>9.999999747378752e-05){if((!(In(k*o-l*n,l*m-j*o,j*n-k*m,+g[d+16>>2],+g[d+20>>2],+g[d+24>>2],+g[e+16>>2],+g[e+20>>2],+g[e+24>>2],q+16|0)|0)?!(In(+g[q>>2],+g[q+4>>2],+g[q+8>>2],+g[e+16>>2],+g[e+20>>2],+g[e+24>>2],+g[f+16>>2],+g[f+20>>2],+g[f+24>>2],q+16|0)|0):0)?!(In(+g[q>>2],+g[q+4>>2],+g[q+8>>2],+g[f+16>>2],+g[f+20>>2],+g[f+24>>2],+g[d+16>>2],+g[d+20>>2],+g[d+24>>2],q+16|0)|0):0)g[q+16>>2]=(+g[d+16>>2]*+g[q>>2]+ +g[d+20>>2]*+g[q+4>>2]+ +g[d+24>>2]*+g[q+8>>2])/p;g[q>>2]=1.0/p*+g[q>>2];g[q+4>>2]=1.0/p*+g[q+4>>2];g[q+8>>2]=1.0/p*+g[q+8>>2];if(h){b=q;return b|0}if(!(+g[q+16>>2]>=-9.999999747378752e-06)){c[b>>2]=3;break}else{b=q;return b|0}}else c[b>>2]=2;while(0);i=c[q+48>>2]|0;if(i|0)c[i+44>>2]=c[q+44>>2];i=c[q+44>>2]|0;if(i|0)c[i+48>>2]=c[q+48>>2];if((c[b+9280>>2]|0)==(q|0))c[b+9280>>2]=c[q+48>>2];c[b+9284>>2]=(c[b+9284>>2]|0)+-1;c[q+44>>2]=0;c[q+48>>2]=c[b+9288>>2];i=c[b+9288>>2]|0;if(i|0)c[i+44>>2]=q;c[b+9288>>2]=q;c[b+9292>>2]=(c[b+9292>>2]|0)+1;b=0;return b|0}function In(a,b,c,d,e,f,h,i,j,k){a=+a;b=+b;c=+c;d=+d;e=+e;f=+f;h=+h;i=+i;j=+j;k=k|0;if(!(((h-d)*b-(i-e)*a)*f+(((i-e)*c-(j-f)*b)*d+((j-f)*a-(h-d)*c)*e)<0.0)){k=0;return k|0}if((h-d)*d+(i-e)*e+(j-f)*f>0.0){g[k>>2]=+O(+(d*d+e*e+f*f));k=1;return k|0}if((h-d)*h+(i-e)*i+(j-f)*j<0.0){g[k>>2]=+O(+(h*h+i*i+j*j));k=1;return k|0}else{c=((h*h+i*i+j*j)*(d*d+e*e+f*f)-(h*d+i*e+j*f)*(h*d+i*e+j*f))/((h-d)*(h-d)+(i-e)*(i-e)+(j-f)*(j-f));g[k>>2]=+O(+(c>0.0?c:0.0));k=1;return k|0}return 0}function Jn(b,e,f,h,i,j){b=b|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;var k=0;if((d[h+55>>0]|0|0)==(e|0)){h=0;return h|0}k=c[6876+(i<<2)>>2]|0;if(+g[h>>2]*+g[f+16>>2]+ +g[h+4>>2]*+g[f+20>>2]+ +g[h+8>>2]*+g[f+24>>2]-+g[h+16>>2]<-9.999999747378752e-06){k=Hn(b,c[h+20+(k<<2)>>2]|0,c[h+20+(i<<2)>>2]|0,f,0)|0;if(!k){h=0;return h|0}a[k+52>>0]=i;c[k+32>>2]=h;a[h+52+i>>0]=0;c[h+32+(i<<2)>>2]=k;i=c[j>>2]|0;if(!i)c[j+4>>2]=k;else{a[i+53>>0]=2;c[i+36>>2]=k;a[k+54>>0]=1;c[k+40>>2]=i}c[j>>2]=k;c[j+8>>2]=(c[j+8>>2]|0)+1;h=1;return h|0}i=c[6888+(i<<2)>>2]|0;a[h+55>>0]=e;if(!(Jn(b,e,f,c[h+32+(k<<2)>>2]|0,d[h+52+k>>0]|0,j)|0)){h=0;return h|0}if(!(Jn(b,e,f,c[h+32+(i<<2)>>2]|0,d[h+52+i>>0]|0,j)|0)){h=0;return h|0}i=c[h+48>>2]|0;if(i|0)c[i+44>>2]=c[h+44>>2];i=c[h+44>>2]|0;if(i|0)c[i+48>>2]=c[h+48>>2];if((c[b+9280>>2]|0)==(h|0))c[b+9280>>2]=c[h+48>>2];c[b+9284>>2]=(c[b+9284>>2]|0)+-1;c[h+44>>2]=0;c[h+48>>2]=c[b+9288>>2];i=c[b+9288>>2]|0;if(i|0)c[i+44>>2]=h;c[b+9288>>2]=h;c[b+9292>>2]=(c[b+9292>>2]|0)+1;h=1;return h|0}function Kn(a){a=a|0;return}function Ln(a){a=a|0;rG(a);return}function Mn(a,b,d,e,f,h,j,k,l,m){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0.0,o=0.0;m=i;i=i+80|0;o=+g[h+52>>2]-+g[f+52>>2];n=+g[h+56>>2]-+g[f+56>>2];g[m+56>>2]=+g[h+48>>2]-+g[f+48>>2];g[m+56+4>>2]=o;g[m+56+8>>2]=n;g[m+56+12>>2]=0.0;if(Fn(d,f,e,h,m+56|0,m,1)|0){c[k>>2]=c[m+4>>2];c[k+4>>2]=c[m+4+4>>2];c[k+8>>2]=c[m+4+8>>2];c[k+12>>2]=c[m+4+12>>2];c[l>>2]=c[m+20>>2];c[l+4>>2]=c[m+20+4>>2];c[l+8>>2]=c[m+20+8>>2];c[l+12>>2]=c[m+20+12>>2];c[j>>2]=c[m+36>>2];c[j+4>>2]=c[m+36+4>>2];c[j+8>>2]=c[m+36+8>>2];c[j+12>>2]=c[m+36+12>>2];l=1;i=m;return l|0}if(!(Bn(d,f,e,h,m+56|0,m)|0)){l=0;i=m;return l|0}c[k>>2]=c[m+4>>2];c[k+4>>2]=c[m+4+4>>2];c[k+8>>2]=c[m+4+8>>2];c[k+12>>2]=c[m+4+12>>2];c[l>>2]=c[m+20>>2];c[l+4>>2]=c[m+20+4>>2];c[l+8>>2]=c[m+20+8>>2];c[l+12>>2]=c[m+20+12>>2];c[j>>2]=c[m+36>>2];c[j+4>>2]=c[m+36+4>>2];c[j+8>>2]=c[m+36+8>>2];c[j+12>>2]=c[m+36+12>>2];l=0;i=m;return l|0}function Nn(a){a=a|0;rG(a);return}function On(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0.0,z=0,A=0,B=0.0,C=0.0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0.0,L=0.0,M=0.0,N=0.0,P=0.0,Q=0.0,R=0,S=0;R=i;i=i+256|0;g[b+56>>2]=0.0;I=R+240+4|0;J=R+240+8|0;c[R+240>>2]=0;c[R+240+4>>2]=0;c[R+240+8>>2]=0;c[R+240+12>>2]=0;c[R+176>>2]=c[d>>2];c[R+176+4>>2]=c[d+4>>2];c[R+176+8>>2]=c[d+8>>2];c[R+176+12>>2]=c[d+12>>2];c[R+176+16>>2]=c[d+16>>2];c[R+176+16+4>>2]=c[d+16+4>>2];c[R+176+16+8>>2]=c[d+16+8>>2];c[R+176+16+12>>2]=c[d+16+12>>2];c[R+176+32>>2]=c[d+32>>2];c[R+176+32+4>>2]=c[d+32+4>>2];c[R+176+32+8>>2]=c[d+32+8>>2];c[R+176+32+12>>2]=c[d+32+12>>2];z=R+176+48|0;c[z>>2]=c[d+48>>2];c[z+4>>2]=c[d+48+4>>2];c[z+8>>2]=c[d+48+8>>2];c[z+12>>2]=c[d+48+12>>2];c[R+112>>2]=c[d+64>>2];c[R+112+4>>2]=c[d+64+4>>2];c[R+112+8>>2]=c[d+64+8>>2];c[R+112+12>>2]=c[d+64+12>>2];c[R+112+16>>2]=c[d+80>>2];c[R+112+16+4>>2]=c[d+80+4>>2];c[R+112+16+8>>2]=c[d+80+8>>2];c[R+112+16+12>>2]=c[d+80+12>>2];c[R+112+32>>2]=c[d+96>>2];c[R+112+32+4>>2]=c[d+96+4>>2];c[R+112+32+8>>2]=c[d+96+8>>2];c[R+112+32+12>>2]=c[d+96+12>>2];A=R+112+48|0;c[A>>2]=c[d+112>>2];c[A+4>>2]=c[d+112+4>>2];c[A+8>>2]=c[d+112+8>>2];c[A+12>>2]=c[d+112+12>>2];K=+g[z>>2];L=+g[A>>2];E=R+176+52|0;M=+g[E>>2];F=R+112+52|0;N=+g[F>>2];G=R+176+56|0;P=+g[G>>2];H=R+112+56|0;Q=+g[H>>2];g[z>>2]=K-(K+L)*.5;g[E>>2]=M-(M+N)*.5;g[G>>2]=P-(P+Q)*.5;g[A>>2]=L-(K+L)*.5;g[F>>2]=N-(M+N)*.5;g[H>>2]=Q-(P+Q)*.5;if(((c[(c[b+28>>2]|0)+4>>2]|0)+-17|0)>>>0<2)z=((c[(c[b+32>>2]|0)+4>>2]|0)+-17|0)>>>0<2;else z=0;v=+g[b+44>>2];u=+g[b+48>>2];c[5046]=(c[5046]|0)+1;A=a[b+52>>0]|0;c[b+64>>2]=0;c[b+4>>2]=0;c[b+8>>2]=1065353216;c[b+12>>2]=0;g[b+16>>2]=0.0;c[b+68>>2]=0;c[b+60>>2]=-1;s=c[b+24>>2]|0;a[s+312>>0]=0;c[s>>2]=0;a[s+356>>0]=1;c[s+292>>2]=1566444395;c[s+296>>2]=1566444395;c[s+300>>2]=1566444395;g[s+304>>2]=0.0;c[s+336>>2]=0;c[s+336+4>>2]=0;c[s+336+8>>2]=0;c[s+336+12>>2]=0;a[s+336+16>>0]=0;a[s+332>>0]=a[s+332>>0]&-16;s=0;m=999999984306749440.0;do{p=+g[b+4>>2];o=+g[b+8>>2];k=+g[b+12>>2];l=+g[d+4>>2]*-p+ +g[d+20>>2]*-o+ +g[d+36>>2]*-k;n=+g[d+8>>2]*-p+ +g[d+24>>2]*-o+ +g[d+40>>2]*-k;g[R+96>>2]=+g[d>>2]*-p+ +g[d+16>>2]*-o+ +g[d+32>>2]*-k;g[R+96+4>>2]=l;g[R+96+8>>2]=n;g[R+96+12>>2]=0.0;n=p*+g[d+68>>2]+o*+g[d+84>>2]+k*+g[d+100>>2];l=p*+g[d+72>>2]+o*+g[d+88>>2]+k*+g[d+104>>2];g[R+80>>2]=+g[d+64>>2]*p+ +g[d+80>>2]*o+ +g[d+96>>2]*k;g[R+80+4>>2]=n;g[R+80+8>>2]=l;g[R+80+12>>2]=0.0;fl(R+64|0,c[b+28>>2]|0,R+96|0);fl(R+48|0,c[b+32>>2]|0,R+80|0);l=+g[R+64>>2];n=+g[R+64+4>>2];k=+g[R+64+8>>2];o=l*+g[R+176>>2]+n*+g[R+176+4>>2]+k*+g[R+176+8>>2]+ +g[R+176+48>>2];p=l*+g[R+176+16>>2]+n*+g[R+176+20>>2]+k*+g[R+176+24>>2]+ +g[E>>2];k=l*+g[R+176+32>>2]+n*+g[R+176+36>>2]+k*+g[R+176+40>>2]+ +g[G>>2];n=+g[R+48>>2];l=+g[R+48+4>>2];t=+g[R+48+8>>2];q=n*+g[R+112>>2]+l*+g[R+112+4>>2]+t*+g[R+112+8>>2]+ +g[R+112+48>>2];r=n*+g[R+112+16>>2]+l*+g[R+112+20>>2]+t*+g[R+112+24>>2]+ +g[F>>2];t=n*+g[R+112+32>>2]+l*+g[R+112+36>>2]+t*+g[R+112+40>>2]+ +g[H>>2];l=z?0.0:t;n=z?0.0:k;t=(z?0.0:k)-(z?0.0:t);k=+g[b+4>>2]*(o-q)+ +g[b+8>>2]*(p-r)+ +g[b+12>>2]*t;if(k>0.0?k*k>m*+g[d+128>>2]:0){c[b+68>>2]=10;h=0;s=1}else S=7;do if((S|0)==7){S=0;w=c[b+24>>2]|0;x=c[w>>2]|0;a:do if((x|0)>0){j=+g[w+308>>2];h=0;while(1){y=o-q-+g[w+4+(h<<4)>>2];B=p-r-+g[w+4+(h<<4)+4>>2];C=t-+g[w+4+(h<<4)+8>>2];h=h+1|0;if(y*y+B*B+C*C<=j){h=1;break a}if((h|0)>=(x|0)){h=0;break}}}else h=0;while(0);if((+g[w+304>>2]==0.0?t==+g[w+300>>2]:0)?p-r==+g[w+296>>2]:0){if(o-q==+g[w+292>>2]|h)S=16}else S=15;if((S|0)==15?(S=0,h):0)S=16;if((S|0)==16){S=0;c[b+68>>2]=1;h=0;s=1;break}j=m-k;if(j<=m*9.999999974752427e-07){c[b+68>>2]=!(j<=0.0)?11:2;h=0;s=1;break}g[w+292>>2]=o-q;g[w+296>>2]=p-r;g[w+300>>2]=t;g[w+304>>2]=0.0;a[w+356>>0]=1;g[w+4+(x<<4)>>2]=o-q;g[w+4+(x<<4)+4>>2]=p-r;g[w+4+(x<<4)+8>>2]=t;g[w+4+(x<<4)+12>>2]=0.0;h=c[w>>2]|0;g[w+84+(h<<4)>>2]=o;g[w+84+(h<<4)+4>>2]=p;g[w+84+(h<<4)+8>>2]=n;g[w+84+(h<<4)+12>>2]=0.0;h=c[w>>2]|0;g[w+164+(h<<4)>>2]=q;g[w+164+(h<<4)+4>>2]=r;g[w+164+(h<<4)+8>>2]=l;g[w+164+(h<<4)+12>>2]=0.0;c[w>>2]=(c[w>>2]|0)+1;h=c[b+24>>2]|0;x=eo(h)|0;j=+g[h+276>>2];k=+g[h+280>>2];l=+g[h+284>>2];h=c[h+288>>2]|0;if(!x){c[b+68>>2]=3;h=0;s=1;break}if(j*j+k*k+l*l<9.999999974752427e-07){g[b+4>>2]=j;g[b+8>>2]=k;g[b+12>>2]=l;c[b+16>>2]=h;c[b+68>>2]=6;h=0;s=1;break}if(m-(j*j+k*k+l*l)<=m*1.1920928955078125e-07){c[b+68>>2]=12;h=0;s=1;m=j*j+k*k+l*l;break}g[b+4>>2]=j;g[b+8>>2]=k;g[b+12>>2]=l;c[b+16>>2]=h;x=c[b+64>>2]|0;c[b+64>>2]=x+1;if((x|0)<=1e3)if((c[c[b+24>>2]>>2]|0)==4){c[b+68>>2]=13;h=0;m=j*j+k*k+l*l}else{h=1;m=j*j+k*k+l*l}else{h=0;m=j*j+k*k+l*l}}while(0)}while(h);u=A<<24>>24==0?u:0.0;t=(A<<24>>24==0?v:0.0)+u;do if(s){A=c[b+24>>2]|0;eo(A)|0;l=+g[A+260>>2];k=+g[A+264>>2];o=+g[A+268>>2];c[R+240>>2]=c[b+4>>2];c[R+240+4>>2]=c[b+4+4>>2];c[R+240+8>>2]=c[b+4+8>>2];c[R+240+12>>2]=c[b+4+12>>2];j=+g[b+4>>2];n=+g[b+8>>2];p=+g[b+12>>2];if(j*j+n*n+p*p<.0001)c[b+68>>2]=5;if(j*j+n*n+p*p>1.4210854715202004e-14){C=1.0/+O(+(j*j+n*n+p*p));g[R+240>>2]=C*+g[R+240>>2];g[I>>2]=C*+g[I>>2];g[J>>2]=C*+g[J>>2];B=u/+O(+m);c[b+60>>2]=1;m=1.0/C-t;w=1;l=B*j+l;C=B*n+k;B=B*p+o;break}else{c[b+60>>2]=2;m=0.0;w=0;C=k;B=o;break}}else{m=0.0;w=0;l=0.0;C=0.0;B=0.0}while(0);if(((c[b+72>>2]|0)!=0?(c[b+20>>2]|0)!=0:0)?(c[b+68>>2]|0)!=0:0)h=t+m<.01;else h=0;s=w^1;do if(h|s?(D=c[b+20>>2]|0,(D|0)!=0):0){c[5045]=(c[5045]|0)+1;c[b+4>>2]=0;c[b+4+4>>2]=0;c[b+4+8>>2]=0;c[b+4+12>>2]=0;if(!(ub[c[(c[D>>2]|0)+8>>2]&3](D,c[b+24>>2]|0,c[b+28>>2]|0,c[b+32>>2]|0,R+176|0,R+112|0,b+4|0,R+96|0,R+80|0,f)|0)){k=+g[b+4>>2];o=+g[b+8>>2];q=+g[b+12>>2];if(!(k*k+o*o+q*q>0.0)){if(w){k=C;j=B;break}i=R;return}n=+g[R+80>>2];v=+g[R+96>>2]-n;p=+g[R+80+4>>2];y=+g[R+96+4>>2]-p;r=+g[R+80+8>>2];j=+g[R+96+8>>2]-r;j=+O(+(v*v+y*y+j*j))-t;if(j<m|s){c[R+240>>2]=c[b+4>>2];c[R+240+4>>2]=c[b+4+4>>2];c[R+240+8>>2]=c[b+4+8>>2];c[R+240+12>>2]=c[b+4+12>>2];B=+g[R+240>>2];C=+g[I>>2];l=+g[J>>2];m=1.0/+O(+(B*B+C*C+l*l));g[R+240>>2]=B*m;g[I>>2]=C*m;g[J>>2]=l*m;c[b+60>>2]=6;m=j;l=u*k+n;k=u*o+p;j=u*q+r;break}c[b+60>>2]=5;if(w){k=C;j=B;break}i=R;return}y=+g[R+80>>2];o=+g[R+96>>2];k=+g[R+80+4>>2];p=+g[R+96+4>>2];j=+g[R+80+8>>2];q=+g[R+96+8>>2];if(!((y-o)*(y-o)+(k-p)*(k-p)+(j-q)*(j-q)<=1.4210854715202004e-14)){n=(y-o)*(y-o)+(k-p)*(k-p)+(j-q)*(j-q);r=y-o;t=j-q;u=0.0;v=k-p}else{r=+g[b+4>>2];v=+g[b+8>>2];t=+g[b+12>>2];n=r*r+v*v+t*t;u=+g[b+16>>2]}if(!(n>1.4210854715202004e-14)){c[b+60>>2]=9;if(w){k=C;j=B;break}i=R;return}n=1.0/+O(+n);o=-+O(+((o-y)*(o-y)+(p-k)*(p-k)+(q-j)*(q-j)));c[b+60>>2]=3;if(!(m>o|s)){c[b+60>>2]=8;if(w){k=C;j=B;break}i=R;return}C=t*n;t=v*n;r=r*n;g[R+240>>2]=r;g[I>>2]=t;g[J>>2]=C;g[R+240+12>>2]=u;m=r*+g[d+4>>2]+t*+g[d+20>>2]+C*+g[d+36>>2];l=r*+g[d+8>>2]+t*+g[d+24>>2]+C*+g[d+40>>2];g[R+64>>2]=+g[d>>2]*r+ +g[d+16>>2]*t+ +g[d+32>>2]*C;g[R+64+4>>2]=m;g[R+64+8>>2]=l;g[R+64+12>>2]=0.0;l=+g[d+68>>2]*-r+ +g[d+84>>2]*-t+ +g[d+100>>2]*-C;m=+g[d+72>>2]*-r+ +g[d+88>>2]*-t+ +g[d+104>>2]*-C;g[R+48>>2]=+g[d+64>>2]*-r+ +g[d+80>>2]*-t+ +g[d+96>>2]*-C;g[R+48+4>>2]=l;g[R+48+8>>2]=m;g[R+48+12>>2]=0.0;fl(R+32|0,c[b+28>>2]|0,R+64|0);fl(R+16|0,c[b+32>>2]|0,R+48|0);m=+g[R+32>>2];l=+g[R+32+4>>2];C=+g[R+32+8>>2];t=+g[R+16>>2];r=+g[R+16+4>>2];q=+g[R+16+8>>2];B=+g[R+240>>2];v=+g[I>>2];u=+g[J>>2];q=-((m*+g[R+176+16>>2]+l*+g[R+176+20>>2]+C*+g[R+176+24>>2]+ +g[E>>2]-(t*+g[R+112+16>>2]+r*+g[R+112+20>>2]+q*+g[R+112+24>>2]+ +g[F>>2]))*v)-(m*+g[R+176>>2]+l*+g[R+176+4>>2]+C*+g[R+176+8>>2]+ +g[R+176+48>>2]-(t*+g[R+112>>2]+r*+g[R+112+4>>2]+q*+g[R+112+8>>2]+ +g[R+112+48>>2]))*B-(m*+g[R+176+32>>2]+l*+g[R+176+36>>2]+C*+g[R+176+40>>2]+ +g[G>>2]-(t*+g[R+112+32>>2]+r*+g[R+112+36>>2]+q*+g[R+112+40>>2]+ +g[H>>2]))*u;r=+g[d+4>>2]*-B+ +g[d+20>>2]*-v+ +g[d+36>>2]*-u;t=+g[d+8>>2]*-B+ +g[d+24>>2]*-v+ +g[d+40>>2]*-u;g[R+64>>2]=+g[d>>2]*-B+ +g[d+16>>2]*-v+ +g[d+32>>2]*-u;g[R+64+4>>2]=r;g[R+64+8>>2]=t;g[R+64+12>>2]=0.0;t=B*+g[d+68>>2]+v*+g[d+84>>2]+u*+g[d+100>>2];r=B*+g[d+72>>2]+v*+g[d+88>>2]+u*+g[d+104>>2];g[R+48>>2]=+g[d+64>>2]*B+ +g[d+80>>2]*v+ +g[d+96>>2]*u;g[R+48+4>>2]=t;g[R+48+8>>2]=r;g[R+48+12>>2]=0.0;fl(R+32|0,c[b+28>>2]|0,R+64|0);fl(R+16|0,c[b+32>>2]|0,R+48|0);r=+g[R+32>>2];t=+g[R+32+4>>2];u=+g[R+32+8>>2];v=+g[R+16>>2];B=+g[R+16+4>>2];C=+g[R+16+8>>2];l=+g[R+240>>2];m=+g[I>>2];n=+g[J>>2];if(q>(r*+g[R+176>>2]+t*+g[R+176+4>>2]+u*+g[R+176+8>>2]+ +g[R+176+48>>2]-(v*+g[R+112>>2]+B*+g[R+112+4>>2]+C*+g[R+112+8>>2]+ +g[R+112+48>>2]))*l+(r*+g[R+176+16>>2]+t*+g[R+176+20>>2]+u*+g[R+176+24>>2]+ +g[E>>2]-(v*+g[R+112+16>>2]+B*+g[R+112+20>>2]+C*+g[R+112+24>>2]+ +g[F>>2]))*m+(r*+g[R+176+32>>2]+t*+g[R+176+36>>2]+u*+g[R+176+40>>2]+ +g[G>>2]-(v*+g[R+112+32>>2]+B*+g[R+112+36>>2]+C*+g[R+112+40>>2]+ +g[H>>2]))*n){c[b+60>>2]=10;g[R+240>>2]=-l;g[I>>2]=-m;g[J>>2]=-n}m=o;l=y}else S=56;while(0);if((S|0)==56)if(w){k=C;j=B}else{i=R;return}if(!(m<0.0)?!(m*m<+g[d+128>>2]):0){i=R;return};c[b+4>>2]=c[R+240>>2];c[b+4+4>>2]=c[R+240+4>>2];c[b+4+8>>2]=c[R+240+8>>2];c[b+4+12>>2]=c[R+240+12>>2];g[b+56>>2]=m;S=c[(c[e>>2]|0)+16>>2]|0;g[R>>2]=(K+L)*.5+l;g[R+4>>2]=(M+N)*.5+k;g[R+8>>2]=(P+Q)*.5+j;g[R+12>>2]=0.0;Yb[S&15](e,R+240|0,R,m);i=R;return}function Pn(a){a=a|0;rG(a);return}function Qn(b,d,e,f,h,j,l,m,n,o){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0.0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;B=i;i=i+4224|0;if(((c[e+4>>2]|0)+-17|0)>>>0<2)A=((c[f+4>>2]|0)+-17|0)>>>0<2;else A=0;b=0;do{Rn();t=+g[20188+(b<<4)>>2];u=+g[20188+(b<<4)+4>>2];v=+g[20188+(b<<4)+8>>2];y=+g[h+4>>2]*-t+ +g[h+20>>2]*-u+ +g[h+36>>2]*-v;w=+g[h+8>>2]*-t+ +g[h+24>>2]*-u+ +g[h+40>>2]*-v;g[B+1248+(b<<4)>>2]=+g[h>>2]*-t+ +g[h+16>>2]*-u+ +g[h+32>>2]*-v;g[B+1248+(b<<4)+4>>2]=y;g[B+1248+(b<<4)+8>>2]=w;g[B+1248+(b<<4)+12>>2]=0.0;w=t*+g[j+4>>2]+u*+g[j+20>>2]+v*+g[j+36>>2];y=t*+g[j+8>>2]+u*+g[j+24>>2]+v*+g[j+40>>2];g[B+256+(b<<4)>>2]=t*+g[j>>2]+u*+g[j+16>>2]+v*+g[j+32>>2];g[B+256+(b<<4)+4>>2]=w;g[B+256+(b<<4)+8>>2]=y;g[B+256+(b<<4)+12>>2]=0.0;b=b+1|0}while((b|0)!=42);b=vb[c[(c[e>>2]|0)+84>>2]&127](e)|0;if((b|0)>0){q=0;r=42;while(1){Zb[c[(c[e>>2]|0)+88>>2]&127](e,q,B+176|0);w=+g[B+176>>2];y=+g[B+176+4>>2];v=+g[B+176+8>>2];u=w*+g[h+16>>2]+y*+g[h+20>>2]+v*+g[h+24>>2];t=w*+g[h+32>>2]+y*+g[h+36>>2]+v*+g[h+40>>2];g[B+176>>2]=+g[h>>2]*w+ +g[h+4>>2]*y+ +g[h+8>>2]*v;g[B+176+4>>2]=u;g[B+176+8>>2]=t;g[B+176+12>>2]=0.0;Rn();z=20188+(r<<4)|0;c[z>>2]=c[B+176>>2];c[z+4>>2]=c[B+176+4>>2];c[z+8>>2]=c[B+176+8>>2];c[z+12>>2]=c[B+176+12>>2];t=+g[B+176>>2];u=+g[B+176+4>>2];v=+g[B+176+8>>2];y=+g[h+4>>2]*-t+ +g[h+20>>2]*-u+ +g[h+36>>2]*-v;w=+g[h+8>>2]*-t+ +g[h+24>>2]*-u+ +g[h+40>>2]*-v;g[B+1248+(r<<4)>>2]=+g[h>>2]*-t+ +g[h+16>>2]*-u+ +g[h+32>>2]*-v;g[B+1248+(r<<4)+4>>2]=y;g[B+1248+(r<<4)+8>>2]=w;g[B+1248+(r<<4)+12>>2]=0.0;w=t*+g[j+4>>2]+u*+g[j+20>>2]+v*+g[j+36>>2];y=t*+g[j+8>>2]+u*+g[j+24>>2]+v*+g[j+40>>2];g[B+256+(r<<4)>>2]=+g[j>>2]*t+ +g[j+16>>2]*u+ +g[j+32>>2]*v;g[B+256+(r<<4)+4>>2]=w;g[B+256+(r<<4)+8>>2]=y;g[B+256+(r<<4)+12>>2]=0.0;q=q+1|0;if((q|0)==(b|0))break;else r=r+1|0}r=b+42|0}else r=42;b=vb[c[(c[f>>2]|0)+84>>2]&127](f)|0;if((b|0)>0){q=0;s=r;while(1){Zb[c[(c[f>>2]|0)+88>>2]&127](f,q,B+176|0);w=+g[B+176>>2];y=+g[B+176+4>>2];v=+g[B+176+8>>2];u=w*+g[j+16>>2]+y*+g[j+20>>2]+v*+g[j+24>>2];t=w*+g[j+32>>2]+y*+g[j+36>>2]+v*+g[j+40>>2];g[B+176>>2]=+g[j>>2]*w+ +g[j+4>>2]*y+ +g[j+8>>2]*v;g[B+176+4>>2]=u;g[B+176+8>>2]=t;g[B+176+12>>2]=0.0;Rn();z=20188+(s<<4)|0;c[z>>2]=c[B+176>>2];c[z+4>>2]=c[B+176+4>>2];c[z+8>>2]=c[B+176+8>>2];c[z+12>>2]=c[B+176+12>>2];t=+g[B+176>>2];u=+g[B+176+4>>2];v=+g[B+176+8>>2];y=+g[h+4>>2]*-t+ +g[h+20>>2]*-u+ +g[h+36>>2]*-v;w=+g[h+8>>2]*-t+ +g[h+24>>2]*-u+ +g[h+40>>2]*-v;g[B+1248+(s<<4)>>2]=+g[h>>2]*-t+ +g[h+16>>2]*-u+ +g[h+32>>2]*-v;g[B+1248+(s<<4)+4>>2]=y;g[B+1248+(s<<4)+8>>2]=w;g[B+1248+(s<<4)+12>>2]=0.0;w=t*+g[j+4>>2]+u*+g[j+20>>2]+v*+g[j+36>>2];y=t*+g[j+8>>2]+u*+g[j+24>>2]+v*+g[j+40>>2];g[B+256+(s<<4)>>2]=+g[j>>2]*t+ +g[j+16>>2]*u+ +g[j+32>>2]*v;g[B+256+(s<<4)+4>>2]=w;g[B+256+(s<<4)+8>>2]=y;g[B+256+(s<<4)+12>>2]=0.0;q=q+1|0;if((q|0)==(b|0))break;else s=s+1|0}r=b+r|0}bc[c[(c[e>>2]|0)+76>>2]&127](e,B+1248|0,B+3232|0,r);bc[c[(c[f>>2]|0)+76>>2]&127](f,B+256|0,B+2240|0,r);if((r|0)>0){z=0;b=0;q=0;s=0;w=0.0;u=999999984306749440.0;while(1){Rn();p=+g[20188+(z<<4)>>2];t=+g[20188+(z<<4)+4>>2];y=+g[20188+(z<<4)+12>>2];v=A?0.0:+g[20188+(z<<4)+8>>2];if(p*p+t*t+v*v>.01?(D=+g[B+3232+(z<<4)>>2],C=+g[B+3232+(z<<4)+4>>2],x=+g[B+3232+(z<<4)+8>>2],G=+g[B+2240+(z<<4)>>2],F=+g[B+2240+(z<<4)+4>>2],E=+g[B+2240+(z<<4)+8>>2],x=p*(G*+g[j>>2]+F*+g[j+4>>2]+E*+g[j+8>>2]+ +g[j+48>>2]-(D*+g[h>>2]+C*+g[h+4>>2]+x*+g[h+8>>2]+ +g[h+48>>2]))+t*(G*+g[j+16>>2]+F*+g[j+20>>2]+E*+g[j+24>>2]+ +g[j+52>>2]-(D*+g[h+16>>2]+C*+g[h+20>>2]+x*+g[h+24>>2]+ +g[h+52>>2]))+v*((A?0.0:G*+g[j+32>>2]+F*+g[j+36>>2]+E*+g[j+40>>2]+ +g[j+56>>2])-(A?0.0:D*+g[h+32>>2]+C*+g[h+36>>2]+x*+g[h+40>>2]+ +g[h+56>>2])),x<u):0){b=(g[k>>2]=p,c[k>>2]|0);q=(g[k>>2]=t,c[k>>2]|0);s=(g[k>>2]=v,c[k>>2]|0);u=x}else y=w;z=z+1|0;if((z|0)==(r|0)){z=b;r=s;break}else w=y}}else{z=0;q=0;r=0;y=0.0;u=999999984306749440.0}switch(c[e+4>>2]|0){case 4:case 5:case 10:case 11:case 13:case 1:case 0:case 8:break;default:+Hb[c[(c[e>>2]|0)+48>>2]&15](e)}v=(c[k>>2]=z,+g[k>>2]);w=(c[k>>2]=q,+g[k>>2]);x=(c[k>>2]=r,+g[k>>2]);switch(c[f+4>>2]|0){case 4:case 5:case 10:case 11:case 13:case 1:case 0:case 8:break;default:+Hb[c[(c[f>>2]|0)+48>>2]&15](f)}if(u<0.0){l=0;i=B;return l|0}switch(c[e+4>>2]|0){case 8:{p=+g[e+32>>2]*+g[e+16>>2];break}case 0:{p=+g[e+48>>2];break}case 1:{p=+g[e+48>>2];break}case 13:{p=+g[e+48>>2];break}case 11:{p=+g[e+48>>2];break}case 10:{p=+g[e+48>>2];break}case 4:case 5:{p=+g[e+48>>2];break}default:p=+Hb[c[(c[e>>2]|0)+48>>2]&15](e)}b=c[f+4>>2]|0;switch(b|0){case 8:{t=+g[f+32>>2]*+g[f+16>>2];b=8;break}case 0:{t=+g[f+48>>2];b=0;break}case 1:{t=+g[f+48>>2];b=1;break}case 13:{t=+g[f+48>>2];b=13;break}case 11:{t=+g[f+48>>2];b=11;break}case 10:{t=+g[f+48>>2];b=10;break}case 4:case 5:{t=+g[f+48>>2];break}default:{t=+Hb[c[(c[f>>2]|0)+48>>2]&15](f);b=c[f+4>>2]|0}}p=u+(p+t+.5);c[B+176>>2]=6928;c[B+176+4>>2]=0;c[B+176+8>>2]=1065353216;c[B+176+12>>2]=0;g[B+176+16>>2]=0.0;c[B+176+20>>2]=0;c[B+176+24>>2]=d;c[B+176+28>>2]=e;c[B+176+32>>2]=f;c[B+176+36>>2]=c[e+4>>2];c[B+176+40>>2]=b;g[B+176+44>>2]=+Hb[c[(c[e>>2]|0)+48>>2]&15](e);g[B+176+48>>2]=+Hb[c[(c[f>>2]|0)+48>>2]&15](f);a[B+176+52>>0]=0;c[B+176+60>>2]=-1;c[B+176+72>>2]=1;c[B+176+76>>2]=1;E=v*p+ +g[h+48>>2];F=w*p+ +g[h+52>>2];G=x*p+ +g[h+56>>2];c[B+44>>2]=c[h>>2];c[B+44+4>>2]=c[h+4>>2];c[B+44+8>>2]=c[h+8>>2];c[B+44+12>>2]=c[h+12>>2];c[B+44+16>>2]=c[h+16>>2];c[B+44+16+4>>2]=c[h+16+4>>2];c[B+44+16+8>>2]=c[h+16+8>>2];c[B+44+16+12>>2]=c[h+16+12>>2];c[B+44+32>>2]=c[h+32>>2];c[B+44+32+4>>2]=c[h+32+4>>2];c[B+44+32+8>>2]=c[h+32+8>>2];c[B+44+32+12>>2]=c[h+32+12>>2];g[B+44+48>>2]=E;g[B+44+52>>2]=F;g[B+44+56>>2]=G;g[B+44+60>>2]=0.0;c[B+44+64>>2]=c[j>>2];c[B+44+64+4>>2]=c[j+4>>2];c[B+44+64+8>>2]=c[j+8>>2];c[B+44+64+12>>2]=c[j+12>>2];c[B+44+80>>2]=c[j+16>>2];c[B+44+80+4>>2]=c[j+16+4>>2];c[B+44+80+8>>2]=c[j+16+8>>2];c[B+44+80+12>>2]=c[j+16+12>>2];c[B+44+96>>2]=c[j+32>>2];c[B+44+96+4>>2]=c[j+32+4>>2];c[B+44+96+8>>2]=c[j+32+8>>2];c[B+44+96+12>>2]=c[j+32+12>>2];c[B+44+112>>2]=c[j+48>>2];c[B+44+112+4>>2]=c[j+48+4>>2];c[B+44+112+8>>2]=c[j+48+8>>2];c[B+44+112+12>>2]=c[j+48+12>>2];g[B+44+128>>2]=999999984306749440.0;c[B>>2]=6968;a[B+40>>0]=0;g[B+176+4>>2]=-v;g[B+176+8>>2]=-w;g[B+176+12>>2]=-x;g[B+176+16>>2]=0.0;On(B+176|0,B+44|0,B,o,0);p=p-+g[B+36>>2];b=a[B+40>>0]|0;if(b<<24>>24){F=+g[B+24>>2]-w*p;G=+g[B+28>>2]-x*p;g[m>>2]=+g[B+20>>2]-v*p;g[m+4>>2]=F;g[m+8>>2]=G;g[m+12>>2]=0.0;c[n>>2]=c[B+20>>2];c[n+4>>2]=c[B+20+4>>2];c[n+8>>2]=c[B+20+8>>2];c[n+12>>2]=c[B+20+12>>2];c[l>>2]=z;c[l+4>>2]=q;c[l+8>>2]=r;g[l+12>>2]=y}l=b<<24>>24!=0;i=B;return l|0}function Rn(){if(a[19864]|0)return;a[19864]=1;c[5047]=0;c[5048]=-2147483648;c[5049]=-1082130432;g[5050]=0.0;c[5051]=1060716128;c[5052]=-1090087446;c[5053]=-1092290076;g[5054]=0.0;c[5055]=-1098022214;c[5056]=-1084636126;c[5057]=-1092290076;g[5058]=0.0;c[5059]=-1083901670;c[5060]=-2147483648;c[5061]=-1092290177;g[5062]=0.0;c[5063]=-1098022214;c[5064]=1062847522;c[5065]=-1092290043;g[5066]=0.0;c[5067]=1060716128;c[5068]=1057396202;c[5069]=-1092290076;g[5070]=0.0;c[5071]=1049461434;c[5072]=-1084636126;c[5073]=1055193605;g[5074]=0.0;c[5075]=-1086767520;c[5076]=-1090087446;c[5077]=1055193572;g[5078]=0.0;c[5079]=-1086767520;c[5080]=1057396202;c[5081]=1055193572;g[5082]=0.0;c[5083]=1049461434;c[5084]=1062847522;c[5085]=1055193572;g[5086]=0.0;c[5087]=1063581978;c[5088]=0;c[5089]=1055193471;g[5090]=0.0;c[5091]=-2147483648;c[5092]=0;c[5093]=1065353216;g[5094]=0.0;c[5095]=1054458864;c[5096]=-1096927567;c[5097]=-1084636042;g[5098]=0.0;c[5099]=-1104782626;c[5100]=-1090519208;c[5101]=-1084636042;g[5102]=0.0;c[5103]=1049007812;c[5104]=-1085334679;c[5105]=-1090087228;g[5106]=0.0;c[5107]=1054458864;c[5108]=1050556081;c[5109]=-1084636042;g[5110]=0.0;c[5111]=1062847505;c[5112]=-2147483648;c[5113]=-1090087262;g[5114]=0.0;c[5115]=-1090087362;c[5116]=-2147483648;c[5117]=-1084636076;g[5118]=0.0;c[5119]=-1087361736;c[5120]=-1090519141;c[5121]=-1090087262;g[5122]=0.0;c[5123]=-1104782626;c[5124]=1056964440;c[5125]=-1084636042;g[5126]=0.0;c[5127]=-1087361736;c[5128]=1056964507;c[5129]=-1090087262;g[5130]=0.0;c[5131]=1049007812;c[5132]=1062148969;c[5133]=-1090087228;g[5134]=0.0;c[5135]=1064532105;c[5136]=1050556148;c[5137]=0;g[5138]=0.0;c[5139]=1064532105;c[5140]=-1096927500;c[5141]=0;g[5142]=0.0;c[5143]=1058437413;c[5144]=-1085334595;c[5145]=0;g[5146]=0.0;c[5147]=0;c[5148]=-1082130432;c[5149]=0;g[5150]=0.0;c[5151]=-1089046235;c[5152]=-1085334595;c[5153]=0;g[5154]=0.0;c[5155]=-1082951543;c[5156]=-1096927500;c[5157]=-2147483648;g[5158]=0.0;c[5159]=-1082951543;c[5160]=1050556148;c[5161]=-2147483648;g[5162]=0.0;c[5163]=-1089046235;c[5164]=1062149053;c[5165]=-2147483648;g[5166]=0.0;c[5167]=-2147483648;c[5168]=1065353216;c[5169]=-2147483648;g[5170]=0.0;c[5171]=1058437413;c[5172]=1062149053;c[5173]=-2147483648;g[5174]=0.0;c[5175]=1060121912;c[5176]=-1090519141;c[5177]=1057396386;g[5178]=0.0;c[5179]=-1098475836;c[5180]=-1085334679;c[5181]=1057396420;g[5182]=0.0;c[5183]=-1084636143;c[5184]=0;c[5185]=1057396386;g[5186]=0.0;c[5187]=-1098475836;c[5188]=1062148969;c[5189]=1057396420;g[5190]=0.0;c[5191]=1060121912;c[5192]=1056964507;c[5193]=1057396386;g[5194]=0.0;c[5195]=1057396286;c[5196]=0;c[5197]=1062847572;g[5198]=0.0;c[5199]=1042701022;c[5200]=-1090519208;c[5201]=1062847606;g[5202]=0.0;c[5203]=-1093024784;c[5204]=-1096927567;c[5205]=1062847606;g[5206]=0.0;c[5207]=-1093024784;c[5208]=1050556081;c[5209]=1062847606;g[5210]=0.0;c[5211]=1042701022;c[5212]=1056964440;c[5213]=1062847606;g[5214]=0.0;return}function Sn(a){a=a|0;rG(a);return}function Tn(a,b,c){a=a|0;b=b|0;c=c|0;return}function Un(a,b,c){a=a|0;b=b|0;c=c|0;return}function Vn(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;c[b+4>>2]=c[d>>2];c[b+4+4>>2]=c[d+4>>2];c[b+4+8>>2]=c[d+8>>2];c[b+4+12>>2]=c[d+12>>2];c[b+20>>2]=c[e>>2];c[b+20+4>>2]=c[e+4>>2];c[b+20+8>>2]=c[e+8>>2];c[b+20+12>>2]=c[e+12>>2];g[b+36>>2]=f;a[b+40>>0]=1;return}function Wn(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0,h=0,i=0.0,j=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0;d=c[a+748>>2]|0;if((d|0)!=4){c[a+748>>2]=d+1;x=d;w=(x|0)<0;x=w?0:x;a=a+4+(x*184|0)|0;bH(a|0,b|0,184)|0;return x|0}y=+g[b+80>>2];v=+g[a+84>>2];u=v<y?v:y;t=+g[a+268>>2];s=t<u?t:u;r=+g[a+452>>2];w=+g[a+636>>2]<(r<s?r:s);d=w?3:r<s?2:t<u?1:(v<y^1)<<31>>31;y=+g[b>>2];if(d){e=+g[a+188>>2];p=+g[b+4>>2];m=+g[a+192>>2];i=+g[b+8>>2];j=+g[a+196>>2];o=+g[a+556>>2];u=+g[a+372>>2];r=+g[a+560>>2];v=+g[a+376>>2];t=+g[a+564>>2];n=+g[a+380>>2];h=(g[k>>2]=((y-e)*(r-v)-(p-m)*(o-u))*((y-e)*(r-v)-(p-m)*(o-u))+(((p-m)*(t-n)-(i-j)*(r-v))*((p-m)*(t-n)-(i-j)*(r-v))+((i-j)*(o-u)-(y-e)*(t-n))*((i-j)*(o-u)-(y-e)*(t-n))),c[k>>2]|0);if((d|0)==1){l=+g[a+8>>2];q=+g[a+12>>2];s=r;r=+g[a+4>>2];f=0;x=7}else{s=r;x=6}}else{e=+g[a+188>>2];m=+g[a+192>>2];j=+g[a+196>>2];p=+g[b+4>>2];i=+g[b+8>>2];o=+g[a+556>>2];u=+g[a+372>>2];s=+g[a+560>>2];v=+g[a+376>>2];t=+g[a+564>>2];n=+g[a+380>>2];h=0;x=6}if((x|0)==6){r=+g[a+4>>2];l=+g[a+8>>2];D=p-l;q=+g[a+12>>2];B=i-q;A=o-u;C=s-v;z=t-n;f=(g[k>>2]=((y-r)*C-D*A)*((y-r)*C-D*A)+((D*z-B*C)*(D*z-B*C)+(B*A-(y-r)*z)*(B*A-(y-r)*z)),c[k>>2]|0);if((d|0)==2){s=u;o=v;d=0;x=8}else x=7}if((x|0)==7){C=y-r;E=p-l;A=i-q;B=o-e;z=s-m;D=t-j;d=(g[k>>2]=(C*z-E*B)*(C*z-E*B)+((E*D-A*z)*(E*D-A*z)+(A*B-C*D)*(A*B-C*D)),c[k>>2]|0);if(w)e=0.0;else{s=u;o=v;x=8}}if((x|0)==8){E=y-r;A=p-l;C=i-q;D=s-e;B=o-m;e=n-j;e=(E*B-A*D)*(E*B-A*D)+((A*e-C*B)*(A*e-C*B)+(C*D-E*e)*(C*D-E*e))}E=+N(+(c[k>>2]=h,+g[k>>2]));C=+N(+(c[k>>2]=f,+g[k>>2]));A=+N(+(c[k>>2]=d,+g[k>>2]));z=+N(+e);D=E>-999999984306749440.0?E:-999999984306749440.0;B=C>D?C:D;x=z>(A>B?A:B)?3:A>B?2:C>D?1:(E>-999999984306749440.0^1)<<31>>31;w=(x|0)<0;x=w?0:x;a=a+4+(x*184|0)|0;bH(a|0,b|0,184)|0;return x|0}function Xn(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0.0,i=0.0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0;f=c[b+748>>2]|0;if((f|0)<=0)return;do{k=f;f=f+-1|0;p=+g[b+4+(f*184|0)>>2];q=+g[b+4+(f*184|0)+4>>2];h=+g[b+4+(f*184|0)+8>>2];o=p*+g[d>>2]+q*+g[d+4>>2]+h*+g[d+8>>2]+ +g[d+48>>2];m=p*+g[d+16>>2]+q*+g[d+20>>2]+h*+g[d+24>>2]+ +g[d+52>>2];h=p*+g[d+32>>2]+q*+g[d+36>>2]+h*+g[d+40>>2]+ +g[d+56>>2];g[b+4+(f*184|0)+48>>2]=o;g[b+4+(f*184|0)+52>>2]=m;g[b+4+(f*184|0)+56>>2]=h;g[b+4+(f*184|0)+60>>2]=0.0;q=+g[b+4+(f*184|0)+16>>2];p=+g[b+4+(f*184|0)+20>>2];i=+g[b+4+(f*184|0)+24>>2];n=q*+g[e>>2]+p*+g[e+4>>2]+i*+g[e+8>>2]+ +g[e+48>>2];l=q*+g[e+16>>2]+p*+g[e+20>>2]+i*+g[e+24>>2]+ +g[e+52>>2];i=q*+g[e+32>>2]+p*+g[e+36>>2]+i*+g[e+40>>2]+ +g[e+56>>2];g[b+4+(f*184|0)+32>>2]=n;g[b+4+(f*184|0)+36>>2]=l;g[b+4+(f*184|0)+40>>2]=i;g[b+4+(f*184|0)+44>>2]=0.0;g[b+4+(f*184|0)+80>>2]=(o-n)*+g[b+4+(f*184|0)+64>>2]+(m-l)*+g[b+4+(f*184|0)+68>>2]+(h-i)*+g[b+4+(f*184|0)+72>>2];j=b+4+(f*184|0)+148|0;c[j>>2]=(c[j>>2]|0)+1}while((k|0)>1);f=c[b+748>>2]|0;if((f|0)<=0)return;e=f;j=f;while(1){k=j;j=j+-1|0;d=b+4+(j*184|0)|0;h=+g[b+4+(j*184|0)+80>>2];i=+g[b+752>>2];if(h<=i){o=+g[b+4+(j*184|0)+32>>2]-(+g[b+4+(j*184|0)+48>>2]-+g[b+4+(j*184|0)+64>>2]*h);p=+g[b+4+(j*184|0)+36>>2]-(+g[b+4+(j*184|0)+52>>2]-h*+g[b+4+(j*184|0)+68>>2]);q=+g[b+4+(j*184|0)+40>>2]-(+g[b+4+(j*184|0)+56>>2]-h*+g[b+4+(j*184|0)+72>>2]);if(o*o+p*p+q*q>i*i){f=e+-1|0;if((f|0)==(j|0))f=e;else{bH(d|0,b+4+(f*184|0)|0,184)|0;c[b+4+(f*184|0)+112>>2]=0;g[b+4+(f*184|0)+120>>2]=0.0;a[b+4+(f*184|0)+116>>0]=0;g[b+4+(f*184|0)+124>>2]=0.0;g[b+4+(f*184|0)+128>>2]=0.0;c[b+4+(f*184|0)+148>>2]=0;f=c[b+748>>2]|0}f=f+-1|0;c[b+748>>2]=f}else f=e}else{f=e+-1|0;if((f|0)==(j|0))f=e;else{bH(d|0,b+4+(f*184|0)|0,184)|0;c[b+4+(f*184|0)+112>>2]=0;g[b+4+(f*184|0)+120>>2]=0.0;a[b+4+(f*184|0)+116>>0]=0;g[b+4+(f*184|0)+124>>2]=0.0;g[b+4+(f*184|0)+128>>2]=0.0;c[b+4+(f*184|0)+148>>2]=0;f=c[b+748>>2]|0}f=f+-1|0;c[b+748>>2]=f}if((k|0)<=1)break;else e=f}return}function Yn(a,b,c,d,e,f,h,i,j,k,l){a=a|0;b=b|0;c=+c;d=+d;e=+e;f=+f;h=+h;i=+i;j=j|0;k=k|0;l=+l;var m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;x=+g[a>>2]*f+ +g[a+16>>2]*h+ +g[a+32>>2]*i;v=+g[a+4>>2]*f+ +g[a+20>>2]*h+ +g[a+36>>2]*i;t=+g[a+8>>2]*f+ +g[a+24>>2]*h+ +g[a+40>>2]*i;s=+g[b>>2]*f+ +g[b+16>>2]*h+ +g[b+32>>2]*i;q=+g[b+4>>2]*f+ +g[b+20>>2]*h+ +g[b+36>>2]*i;o=+g[b+8>>2]*f+ +g[b+24>>2]*h+ +g[b+40>>2]*i;w=+g[j+80>>2];u=+g[j+84>>2];p=+g[j+88>>2];r=+g[k+80>>2];m=+g[k+84>>2];n=+g[k+88>>2];p=x*(x<0.0?-w:w)+v*(v<0.0?-u:u)+t*(t<0.0?-p:p);n=s*(s<0.0?-r:r)+q*(q<0.0?-m:m)+o*(o<0.0?-n:n);o=+g[j+96>>2];m=+g[k+96>>2];m=(p>o?p:o)+(n>m?n:m);return !((c*f+d*h+e*i+m<m-(c*f+d*h+e*i)?c*f+d*h+e*i+m:m-(c*f+d*h+e*i))>l)|0}function Zn(b,d,e,f,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;h=+h;j=+j;k=k|0;var l=0,m=0,n=0.0,o=0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0,E=0.0,F=0.0,G=0.0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0,ba=0;X=i;i=i+64|0;a[X+32+16>>0]=1;W=X+32+12|0;c[W>>2]=0;c[X+32+4>>2]=0;c[X+32+8>>2]=0;q=c[f+4>>2]|0;if((q|0)>0){c[5637]=(c[5637]|0)+1;l=qG((q<<4|3)+16|0)|0;if(!l)o=0;else{c[(l+4+15&-16)+-4>>2]=l;o=l+4+15&-16}l=c[X+32+4>>2]|0;if((l|0)>0){m=0;do{V=o+(m<<4)|0;U=(c[W>>2]|0)+(m<<4)|0;c[V>>2]=c[U>>2];c[V+4>>2]=c[U+4>>2];c[V+8>>2]=c[U+8>>2];c[V+12>>2]=c[U+12>>2];m=m+1|0}while((m|0)!=(l|0))}l=c[W>>2]|0;if(l|0){if(a[X+32+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[l+-4>>2]|0)}c[W>>2]=0}a[X+32+16>>0]=1;c[W>>2]=o;c[X+32+8>>2]=q}l=c[d+28>>2]|0;if((l|0)>0){U=c[d+36>>2]|0;A=+g[e>>2];B=+g[e+4>>2];E=+g[e+8>>2];F=+g[e+16>>2];G=+g[e+20>>2];s=+g[e+24>>2];r=+g[e+32>>2];p=+g[e+36>>2];n=+g[e+40>>2];t=+g[b>>2];u=+g[b+4>>2];v=+g[b+8>>2];V=-1;z=3402823466385288598117041.0e14;o=0;while(1){w=+g[U+(o*36|0)+20>>2];x=+g[U+(o*36|0)+24>>2];y=+g[U+(o*36|0)+28>>2];m=(w*A+x*B+y*E)*t+(w*F+x*G+y*s)*u+(w*r+x*p+y*n)*v<z;V=m?o:V;o=o+1|0;if((o|0)==(l|0))break;else z=m?(w*A+x*B+y*E)*t+(w*F+x*G+y*s)*u+(w*r+x*p+y*n)*v:z}if((V|0)>=0){L=c[U+(V*36|0)+4>>2]|0;if((L|0)>0){M=U+(V*36|0)+12|0;N=U+(V*36|0)+20|0;O=U+(V*36|0)+24|0;P=U+(V*36|0)+28|0;t=A;x=B;w=E;v=F;u=G;K=0;J=f;f=X+32|0;while(1){I=c[M>>2]|0;l=c[I+(K<<2)>>2]|0;H=c[d+16>>2]|0;K=K+1|0;I=c[I+(((K|0)==(L|0)?0:K)<<2)>>2]|0;Z=+g[H+(l<<4)>>2];_=Z-+g[H+(I<<4)>>2];Y=+g[H+(l<<4)+4>>2];$=Y-+g[H+(I<<4)+4>>2];y=+g[H+(l<<4)+8>>2];B=y-+g[H+(I<<4)+8>>2];z=_*t+$*x+B*w;A=_*v+$*u+B*s;B=_*r+$*p+B*n;$=+g[N>>2];_=+g[O>>2];G=+g[P>>2];E=t*$+x*_+w*G;F=v*$+u*_+s*G;G=r*$+p*_+n*G;u=(Z*t+Y*x+y*w+ +g[e+48>>2])*-(A*G-B*F)+(Z*v+Y*u+y*s+ +g[e+52>>2])*-(B*E-z*G)+(Z*r+Y*p+y*n+ +g[e+56>>2])*-(z*F-A*E);I=J;H=f;l=c[I+4>>2]|0;if((l|0)>=2){o=c[I+12>>2]|0;p=+g[o+(l+-1<<4)>>2];r=+g[o+(l+-1<<4)+4>>2];s=+g[o+(l+-1<<4)+8>>2];n=p*-(A*G-B*F)+r*-(B*E-z*G)+s*-(z*F-A*E)-u;D=0;while(1){v=+g[o+(D<<4)>>2];w=+g[o+(D<<4)+4>>2];x=+g[o+(D<<4)+8>>2];C=c[o+(D<<4)+12>>2]|0;y=v*-(A*G-B*F)+w*-(B*E-z*G)+x*-(z*F-A*E)-u;do if(n<0.0)if(y<0.0){m=c[H+4>>2]|0;if((m|0)==(c[H+8>>2]|0)?(Q=m|0?m<<1:1,(m|0)<(Q|0)):0){if(!Q)q=0;else{c[5637]=(c[5637]|0)+1;m=qG((Q<<4|3)+16|0)|0;if(!m)m=0;else{c[(m+4+15&-16)+-4>>2]=m;m=m+4+15&-16}q=m;m=c[H+4>>2]|0}if((m|0)>0){o=0;do{aa=q+(o<<4)|0;ba=(c[H+12>>2]|0)+(o<<4)|0;c[aa>>2]=c[ba>>2];c[aa+4>>2]=c[ba+4>>2];c[aa+8>>2]=c[ba+8>>2];c[aa+12>>2]=c[ba+12>>2];o=o+1|0}while((o|0)!=(m|0))}m=c[H+12>>2]|0;if(m|0){if(a[H+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[m+-4>>2]|0)}c[H+12>>2]=0}a[H+16>>0]=1;c[H+12>>2]=q;c[H+8>>2]=Q;m=c[H+4>>2]|0}ba=c[H+12>>2]|0;g[ba+(m<<4)>>2]=v;g[ba+(m<<4)+4>>2]=w;g[ba+(m<<4)+8>>2]=x;c[ba+(m<<4)+12>>2]=C;c[H+4>>2]=(c[H+4>>2]|0)+1;break}else{n=n/(n-y);t=p+(v-p)*n;p=r+(w-r)*n;n=s+(x-s)*n;m=c[H+4>>2]|0;if((m|0)==(c[H+8>>2]|0)?(R=m|0?m<<1:1,(m|0)<(R|0)):0){if(!R)q=0;else{c[5637]=(c[5637]|0)+1;m=qG((R<<4|3)+16|0)|0;if(!m)m=0;else{c[(m+4+15&-16)+-4>>2]=m;m=m+4+15&-16}q=m;m=c[H+4>>2]|0}if((m|0)>0){o=0;do{ba=q+(o<<4)|0;aa=(c[H+12>>2]|0)+(o<<4)|0;c[ba>>2]=c[aa>>2];c[ba+4>>2]=c[aa+4>>2];c[ba+8>>2]=c[aa+8>>2];c[ba+12>>2]=c[aa+12>>2];o=o+1|0}while((o|0)!=(m|0))}m=c[H+12>>2]|0;if(m|0){if(a[H+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[m+-4>>2]|0)}c[H+12>>2]=0}a[H+16>>0]=1;c[H+12>>2]=q;c[H+8>>2]=R;m=c[H+4>>2]|0}ba=c[H+12>>2]|0;g[ba+(m<<4)>>2]=t;g[ba+(m<<4)+4>>2]=p;g[ba+(m<<4)+8>>2]=n;g[ba+(m<<4)+12>>2]=0.0;c[H+4>>2]=(c[H+4>>2]|0)+1;break}else if(y<0.0){n=n/(n-y);t=p+(v-p)*n;p=r+(w-r)*n;n=s+(x-s)*n;m=c[H+4>>2]|0;if((m|0)==(c[H+8>>2]|0)?(S=m|0?m<<1:1,(m|0)<(S|0)):0){if(!S)q=0;else{c[5637]=(c[5637]|0)+1;m=qG((S<<4|3)+16|0)|0;if(!m)m=0;else{c[(m+4+15&-16)+-4>>2]=m;m=m+4+15&-16}q=m;m=c[H+4>>2]|0}if((m|0)>0){o=0;do{ba=q+(o<<4)|0;aa=(c[H+12>>2]|0)+(o<<4)|0;c[ba>>2]=c[aa>>2];c[ba+4>>2]=c[aa+4>>2];c[ba+8>>2]=c[aa+8>>2];c[ba+12>>2]=c[aa+12>>2];o=o+1|0}while((o|0)!=(m|0))}m=c[H+12>>2]|0;if(m|0){if(a[H+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[m+-4>>2]|0)}c[H+12>>2]=0}a[H+16>>0]=1;c[H+12>>2]=q;c[H+8>>2]=S;m=c[H+4>>2]|0}ba=c[H+12>>2]|0;g[ba+(m<<4)>>2]=t;g[ba+(m<<4)+4>>2]=p;g[ba+(m<<4)+8>>2]=n;g[ba+(m<<4)+12>>2]=0.0;m=(c[H+4>>2]|0)+1|0;c[H+4>>2]=m;if((m|0)==(c[H+8>>2]|0)?(T=m|0?m<<1:1,(m|0)<(T|0)):0){if(!T)q=0;else{c[5637]=(c[5637]|0)+1;m=qG((T<<4|3)+16|0)|0;if(!m)m=0;else{c[(m+4+15&-16)+-4>>2]=m;m=m+4+15&-16}q=m;m=c[H+4>>2]|0}if((m|0)>0){o=0;do{ba=q+(o<<4)|0;aa=(c[H+12>>2]|0)+(o<<4)|0;c[ba>>2]=c[aa>>2];c[ba+4>>2]=c[aa+4>>2];c[ba+8>>2]=c[aa+8>>2];c[ba+12>>2]=c[aa+12>>2];o=o+1|0}while((o|0)!=(m|0))}m=c[H+12>>2]|0;if(m|0){if(a[H+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[m+-4>>2]|0)}c[H+12>>2]=0}a[H+16>>0]=1;c[H+12>>2]=q;c[H+8>>2]=T;m=c[H+4>>2]|0}ba=c[H+12>>2]|0;g[ba+(m<<4)>>2]=v;g[ba+(m<<4)+4>>2]=w;g[ba+(m<<4)+8>>2]=x;c[ba+(m<<4)+12>>2]=C;c[H+4>>2]=(c[H+4>>2]|0)+1}while(0);m=D+1|0;if((m|0)==(l|0))break;o=c[I+12>>2]|0;n=y;p=v;s=x;r=w;D=m}l=c[I+4>>2]|0}if((l|0)<0){if((c[I+8>>2]|0)<0){m=c[I+12>>2]|0;if(m|0){if(a[I+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[m+-4>>2]|0)}c[I+12>>2]=0}a[I+16>>0]=1;c[I+12>>2]=0;c[I+8>>2]=0}do{ba=(c[I+12>>2]|0)+(l<<4)|0;c[ba>>2]=c[X>>2];c[ba+4>>2]=c[X+4>>2];c[ba+8>>2]=c[X+8>>2];c[ba+12>>2]=c[X+12>>2];l=l+1|0}while((l|0)!=0)}c[I+4>>2]=0;t=+g[e>>2];x=+g[e+4>>2];w=+g[e+8>>2];v=+g[e+16>>2];u=+g[e+20>>2];s=+g[e+24>>2];r=+g[e+32>>2];p=+g[e+36>>2];n=+g[e+40>>2];if((K|0)>=(L|0)){o=N;m=O;l=P;C=e+48|0;D=e+52|0;q=e+56|0;break}else{ba=f;f=J;J=ba}}}else{o=U+(V*36|0)+20|0;m=U+(V*36|0)+24|0;l=U+(V*36|0)+28|0;C=e+48|0;D=e+52|0;q=e+56|0;t=A;x=B;w=E;v=F;u=G}Z=+g[o>>2];_=+g[m>>2];$=+g[l>>2];t=Z*t+_*x+$*w;s=Z*v+_*u+$*s;r=Z*r+_*p+$*n;p=+g[U+(V*36|0)+32>>2]-(t*+g[C>>2]+s*+g[D>>2]+r*+g[q>>2]);l=c[f+4>>2]|0;if((l|0)>0){o=0;do{m=c[f+12>>2]|0;n=p+(t*+g[m+(o<<4)>>2]+s*+g[m+(o<<4)+4>>2]+r*+g[m+(o<<4)+8>>2]);n=n<=h?h:n;if(n<=j){l=m+(o<<4)|0;c[X+16>>2]=c[l>>2];c[X+16+4>>2]=c[l+4>>2];c[X+16+8>>2]=c[l+8>>2];c[X+16+12>>2]=c[l+12>>2];Yb[c[(c[k>>2]|0)+16>>2]&15](k,b,X+16|0,n);l=c[f+4>>2]|0}o=o+1|0}while((o|0)<(l|0))}}}l=c[W>>2]|0;if(!l){i=X;return}if(a[X+32+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[l+-4>>2]|0)}c[W>>2]=0;i=X;return}function _n(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0.0,H=0;H=i;i=i+32|0;k=+g[b+16>>2];f=+g[b>>2];l=+g[b+20>>2];h=+g[b+4>>2];n=+g[b+24>>2];j=+g[b+8>>2];r=+g[b+32>>2];v=+g[b+36>>2];w=+g[b+40>>2];B=(l-h)*(w-j)-(n-j)*(v-h);C=(n-j)*(r-f)-(k-f)*(w-j);D=(k-f)*(v-h)-(l-h)*(r-f);g[H+16>>2]=B;g[H+16+4>>2]=C;g[H+16+8>>2]=D;g[H+16+12>>2]=0.0;o=+g[a+4>>2];s=+g[a+8>>2];x=+g[a+12>>2];E=B*o+C*s+D*x-(f*B+h*C+j*D);p=+g[a+20>>2];t=+g[a+24>>2];y=+g[a+28>>2];if(E*(B*p+C*t+D*y-(f*B+h*C+j*D))>=0.0){i=H;return}F=c[a+36>>2]|0;if(E<=0.0&(F&1|0)!=0){i=H;return}G=E/(E-(B*p+C*t+D*y-(f*B+h*C+j*D)));if(!(G<+g[a+40>>2])){i=H;return}A=(B*B+C*C+D*D)*-9.999999747378752e-05;z=f-(p*G+o*(1.0-G));u=h-(t*G+s*(1.0-G));q=j-(y*G+x*(1.0-G));m=k-(p*G+o*(1.0-G));l=l-(t*G+s*(1.0-G));k=n-(y*G+x*(1.0-G));if(!(D*(z*l-u*m)+(B*(u*k-q*l)+C*(q*m-z*k))>=A)){i=H;return}j=r-(p*G+o*(1.0-G));h=v-(t*G+s*(1.0-G));f=w-(y*G+x*(1.0-G));if(!(D*(m*h-l*j)+(B*(l*f-k*h)+C*(k*j-m*f))>=A)){i=H;return}if(!(D*(u*j-z*h)+(B*(q*h-u*f)+C*(z*f-q*j))>=A)){i=H;return}f=1.0/+O(+(B*B+C*C+D*D));g[H+16>>2]=B*f;g[H+16+4>>2]=C*f;g[H+16+8>>2]=D*f;b=c[(c[a>>2]|0)+12>>2]|0;if(E<=0.0&(F&2|0)==0){g[H>>2]=-(B*f);g[H+4>>2]=-(C*f);g[H+8>>2]=-(D*f);g[H+12>>2]=0.0;g[a+40>>2]=+Vb[b&3](a,H,G,d,e);i=H;return}else{g[a+40>>2]=+Vb[b&3](a,H+16|0,G,d,e);i=H;return}}function $n(a){a=a|0;rG(a);return}function ao(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0.0;m=i;i=i+688|0;c[m+568+8>>2]=0;c[m+568+12>>2]=-1;c[m+568+16>>2]=1065353216;c[m+568+20>>2]=1065353216;c[m+568+24>>2]=1065353216;g[m+568+28>>2]=0.0;c[m+568+56>>2]=0;c[m+568>>2]=3768;c[m+568+4>>2]=1;c[m+568+60>>2]=c[d>>2];c[m+568+60+4>>2]=c[d+4>>2];c[m+568+60+8>>2]=c[d+8>>2];c[m+568+60+12>>2]=c[d+12>>2];c[m+568+76>>2]=c[d+16>>2];c[m+568+76+4>>2]=c[d+16+4>>2];c[m+568+76+8>>2]=c[d+16+8>>2];c[m+568+76+12>>2]=c[d+16+12>>2];c[m+568+92>>2]=c[d+32>>2];c[m+568+92+4>>2]=c[d+32+4>>2];c[m+568+92+8>>2]=c[d+32+8>>2];c[m+568+92+12>>2]=c[d+32+12>>2];c[m+568+48>>2]=c[b+204>>2];g[m+208+308>>2]=9.999999747378752e-05;a[m+208+332>>0]=0;c[m+200>>2]=6908;d=c[b+4>>2]|0;c[m+176>>2]=6816;c[m+176+4>>2]=m+208;c[m+176+8>>2]=m+200;c[m+176+12>>2]=d;c[m+176+16>>2]=m+568;c[m+176+20>>2]=0;c[m>>2]=3316;c[m+168>>2]=0;g[m+164>>2]=1.0;c[m+172>>2]=c[b+208>>2];if((rn(m+176|0,b+8|0,b+72|0,b+136|0,b+136|0,m)|0?(h=+g[m+132>>2],j=+g[m+136>>2],k=+g[m+140>>2],h*h+j*j+k*k>9.999999747378752e-05):0)?(l=+g[m+164>>2],l<+g[b+200>>2]):0){n=1.0/+O(+(h*h+j*j+k*k));g[m+132>>2]=h*n;g[m+136>>2]=j*n;g[m+140>>2]=k*n;+Jb[c[(c[b>>2]|0)+12>>2]&3](b,m+132|0,m+148|0,l,e,f)}c[m+568>>2]=6248;e=c[m+568+56>>2]|0;if(!e){i=m;return}rb[c[c[e>>2]>>2]&255](e);e=c[m+568+56>>2]|0;if(!e){i=m;return}c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0);i=m;return}function bo(a){a=a|0;rG(a);return}function co(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0,x=0.0,y=0,z=0,A=0.0,B=0.0,C=0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0,L=0.0,M=0.0,N=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0,da=0.0,ea=0.0,fa=0.0,ga=0,ha=0.0;ga=i;i=i+128|0;K=c[b+4>>2]|0;a[K+312>>0]=0;c[K>>2]=0;a[K+356>>0]=1;c[K+292>>2]=1566444395;c[K+296>>2]=1566444395;c[K+300>>2]=1566444395;g[K+304>>2]=0.0;c[K+336>>2]=0;c[K+336+4>>2]=0;c[K+336+8>>2]=0;c[K+336+12>>2]=0;a[K+336+16>>0]=0;a[K+332>>0]=a[K+332>>0]&-16;m=+g[d+48>>2];n=+g[d+52>>2];o=+g[d+56>>2];p=+g[f+48>>2];t=+g[f+52>>2];u=+g[f+56>>2];L=+g[d>>2];M=+g[d+4>>2];N=+g[d+8>>2];P=+g[d+16>>2];Q=+g[d+20>>2];R=+g[d+24>>2];S=+g[d+32>>2];T=+g[d+36>>2];U=+g[d+40>>2];V=+g[f>>2];W=+g[f+4>>2];X=+g[f+8>>2];Y=+g[f+16>>2];Z=+g[f+20>>2];_=+g[f+24>>2];$=+g[f+32>>2];aa=+g[f+36>>2];ba=+g[f+40>>2];da=+g[e+48>>2]-m-(+g[h+48>>2]-p);ea=+g[e+52>>2]-n-(+g[h+52>>2]-t);fa=+g[e+56>>2]-o-(+g[h+56>>2]-u);K=c[b+8>>2]|0;C=c[(c[K>>2]|0)+64>>2]|0;g[ga+96>>2]=L*-da+P*-ea+S*-fa;g[ga+96+4>>2]=M*-da+Q*-ea+T*-fa;g[ga+96+8>>2]=N*-da+R*-ea+U*-fa;g[ga+96+12>>2]=0.0;Zb[C&127](ga+112|0,K,ga+96|0);I=+g[ga+112>>2];J=+g[ga+112+4>>2];H=+g[ga+112+8>>2];v=I*+g[d>>2]+J*+g[d+4>>2]+H*+g[d+8>>2]+ +g[d+48>>2];A=I*+g[d+16>>2]+J*+g[d+20>>2]+H*+g[d+24>>2]+ +g[d+52>>2];H=I*+g[d+32>>2]+J*+g[d+36>>2]+H*+g[d+40>>2]+ +g[d+56>>2];K=c[b+12>>2]|0;C=c[(c[K>>2]|0)+64>>2]|0;J=da*+g[f+4>>2]+ea*+g[f+20>>2]+fa*+g[f+36>>2];I=da*+g[f+8>>2]+ea*+g[f+24>>2]+fa*+g[f+40>>2];g[ga+64>>2]=da*+g[f>>2]+ea*+g[f+16>>2]+fa*+g[f+32>>2];g[ga+64+4>>2]=J;g[ga+64+8>>2]=I;g[ga+64+12>>2]=0.0;Zb[C&127](ga+80|0,K,ga+64|0);I=+g[ga+80>>2];J=+g[ga+80+4>>2];x=+g[ga+80+8>>2];v=v-(I*+g[f>>2]+J*+g[f+4>>2]+x*+g[f+8>>2]+ +g[f+48>>2]);A=A-(I*+g[f+16>>2]+J*+g[f+20>>2]+x*+g[f+24>>2]+ +g[f+52>>2]);x=H-(I*+g[f+32>>2]+J*+g[f+36>>2]+x*+g[f+40>>2]+ +g[f+56>>2]);a:do if(v*v+A*A+x*x>9.999999747378752e-05){J=m;m=0.0;K=32;r=0;s=0;q=0;l=0;z=0;while(1){if(!K)break a;K=K+-1|0;w=c[b+8>>2]|0;y=c[(c[w>>2]|0)+64>>2]|0;F=-v;ha=-A;B=-x;g[ga+32>>2]=L*F+P*ha+S*B;g[ga+32+4>>2]=M*F+Q*ha+T*B;g[ga+32+8>>2]=N*F+R*ha+U*B;g[ga+32+12>>2]=0.0;Zb[y&127](ga+48|0,w,ga+32|0);B=+g[ga+48>>2];ha=+g[ga+48+4>>2];F=+g[ga+48+8>>2];D=J+(L*B+M*ha+N*F);E=n+(P*B+Q*ha+R*F);F=o+(S*B+T*ha+U*F);w=c[b+12>>2]|0;y=c[(c[w>>2]|0)+64>>2]|0;g[ga>>2]=V*v+Y*A+$*x;g[ga+4>>2]=W*v+Z*A+aa*x;g[ga+8>>2]=X*v+_*A+ba*x;g[ga+12>>2]=0.0;Zb[y&127](ga+16|0,w,ga);ha=+g[ga+16>>2];B=+g[ga+16+4>>2];I=+g[ga+16+8>>2];G=p+(V*ha+W*B+X*I);H=t+(Y*ha+Z*B+_*I);I=u+($*ha+aa*B+ba*I);B=v*(D-G)+A*(E-H)+x*(F-I);w=(g[k>>2]=v,c[k>>2]|0);y=(g[k>>2]=A,c[k>>2]|0);C=(g[k>>2]=x,c[k>>2]|0);if(m>1.0){l=0;ca=25;break}if(B>0.0){n=da*v+ea*A+fa*x;if(n>=-1.4210854715202004e-14){l=0;ca=25;break}m=m-B/n;B=(1.0-m)*+g[d+48>>2]+m*+g[e+48>>2];n=(1.0-m)*+g[d+52>>2]+m*+g[e+52>>2];o=(1.0-m)*+g[d+56>>2]+m*+g[e+56>>2];p=(1.0-m)*+g[f+48>>2]+m*+g[h+48>>2];t=(1.0-m)*+g[f+52>>2]+m*+g[h+52>>2];u=(1.0-m)*+g[f+56>>2]+m*+g[h+56>>2];r=w;s=z;q=y;l=C}else B=J;y=c[b+4>>2]|0;z=c[y>>2]|0;b:do if((z|0)>0){v=+g[y+308>>2];w=0;while(1){A=D-G-+g[y+4+(w<<4)>>2];J=E-H-+g[y+4+(w<<4)+4>>2];ha=F-I-+g[y+4+(w<<4)+8>>2];w=w+1|0;if(A*A+J*J+ha*ha<=v){w=1;break b}if((w|0)>=(z|0)){w=0;break}}}else w=0;while(0);if((+g[y+304>>2]==0.0?F-I==+g[y+300>>2]:0)?E-H==+g[y+296>>2]:0){if(!(D-G==+g[y+292>>2]|w))ca=17}else if(!w)ca=17;if((ca|0)==17){ca=0;g[y+292>>2]=D-G;g[y+296>>2]=E-H;g[y+300>>2]=F-I;g[y+304>>2]=0.0;a[y+356>>0]=1;g[y+4+(z<<4)>>2]=D-G;g[y+4+(z<<4)+4>>2]=E-H;g[y+4+(z<<4)+8>>2]=F-I;g[y+4+(z<<4)+12>>2]=0.0;C=c[y>>2]|0;g[y+84+(C<<4)>>2]=D;g[y+84+(C<<4)+4>>2]=E;g[y+84+(C<<4)+8>>2]=F;g[y+84+(C<<4)+12>>2]=0.0;C=c[y>>2]|0;g[y+164+(C<<4)>>2]=G;g[y+164+(C<<4)+4>>2]=H;g[y+164+(C<<4)+8>>2]=I;g[y+164+(C<<4)+12>>2]=0.0;c[y>>2]=(c[y>>2]|0)+1;y=c[b+4>>2]|0}C=eo(y)|0;v=+g[y+276>>2];A=+g[y+280>>2];x=+g[y+284>>2];if(!C)break a;if(!(v*v+A*A+x*x>9.999999747378752e-05))break a;else{J=B;z=c[y+288>>2]|0}}if((ca|0)==25){i=ga;return l|0}}else{m=0.0;r=0;s=0;q=0;l=0}while(0);g[j+164>>2]=m;m=(c[k>>2]=r,+g[k>>2]);n=(c[k>>2]=q,+g[k>>2]);p=(c[k>>2]=l,+g[k>>2]);if(!(m*m+n*n+p*p>=1.4210854715202004e-14)){c[j+132>>2]=0;c[j+132+4>>2]=0;c[j+132+8>>2]=0;c[j+132+12>>2]=0;o=0.0;n=0.0;m=0.0}else{ha=1.0/+O(+(m*m+n*n+p*p));g[j+132>>2]=m*ha;g[j+136>>2]=n*ha;g[j+140>>2]=p*ha;c[j+144>>2]=s;o=m*ha;n=n*ha;m=p*ha}if(da*o+ea*n+fa*m>=-+g[j+172>>2]){b=0;i=ga;return b|0}b=c[b+4>>2]|0;eo(b)|0;cH(j+148|0,b+260|0,16)|0;b=1;i=ga;return b|0}function eo(b){b=b|0;var d=0,e=0.0,f=0.0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0,H=0,I=0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0;I=i;i=i+64|0;if(!(a[b+356>>0]|0)){b=a[b+312>>0]|0;b=b<<24>>24!=0;i=I;return b|0}c[b+336>>2]=0;c[b+336+4>>2]=0;c[b+336+8>>2]=0;c[b+336+12>>2]=0;a[b+336+16>>0]=0;h=a[b+332>>0]|0;a[b+332>>0]=h&-16;a[b+356>>0]=0;switch(c[b>>2]|0){case 0:{a[b+312>>0]=0;b=0;b=b<<24>>24!=0;i=I;return b|0}case 1:{c[b+244>>2]=c[b+84>>2];c[b+244+4>>2]=c[b+84+4>>2];c[b+244+8>>2]=c[b+84+8>>2];c[b+244+12>>2]=c[b+84+12>>2];c[b+260>>2]=c[b+164>>2];c[b+260+4>>2]=c[b+164+4>>2];c[b+260+8>>2]=c[b+164+8>>2];c[b+260+12>>2]=c[b+164+12>>2];E=+g[b+248>>2]-+g[b+264>>2];F=+g[b+252>>2]-+g[b+268>>2];g[b+276>>2]=+g[b+244>>2]-+g[b+260>>2];g[b+280>>2]=E;g[b+284>>2]=F;g[b+288>>2]=0.0;c[b+336>>2]=0;c[b+336+4>>2]=0;c[b+336+8>>2]=0;c[b+336+12>>2]=0;a[b+336+16>>0]=0;a[b+332>>0]=h&-16;g[b+336>>2]=1.0;g[b+340>>2]=0.0;g[b+344>>2]=0.0;g[b+348>>2]=0.0;a[b+312>>0]=1;b=1;b=b<<24>>24!=0;i=I;return b|0}case 2:{e=+g[b+4>>2];f=+g[b+8>>2];j=+g[b+12>>2];k=+g[b+20>>2]-e;l=+g[b+24>>2]-f;m=+g[b+28>>2]-j;do if((0.0-e)*k+(0.0-f)*l+(0.0-j)*m>0.0)if((0.0-e)*k+(0.0-f)*l+(0.0-j)*m<k*k+l*l+m*m){a[b+332>>0]=h&-16|3;h=h&-16|3;f=((0.0-e)*k+(0.0-f)*l+(0.0-j)*m)/(k*k+l*l+m*m);break}else{a[b+332>>0]=h&-16|2;h=h&-16|2;f=1.0;break}else{a[b+332>>0]=h&-16|1;h=h&-16|1;f=0.0}while(0);e=1.0-f;g[b+336>>2]=e;g[b+340>>2]=f;g[b+344>>2]=0.0;g[b+348>>2]=0.0;A=+g[b+84>>2];C=+g[b+88>>2];E=+g[b+92>>2];A=A+f*(+g[b+100>>2]-A);C=C+f*(+g[b+104>>2]-C);E=E+f*(+g[b+108>>2]-E);g[b+244>>2]=A;g[b+248>>2]=C;g[b+252>>2]=E;g[b+256>>2]=0.0;B=+g[b+164>>2];D=+g[b+168>>2];F=+g[b+172>>2];B=B+f*(+g[b+180>>2]-B);D=D+f*(+g[b+184>>2]-D);F=F+f*(+g[b+188>>2]-F);g[b+260>>2]=B;g[b+264>>2]=D;g[b+268>>2]=F;g[b+272>>2]=0.0;g[b+276>>2]=A-B;g[b+280>>2]=C-D;g[b+284>>2]=E-F;g[b+288>>2]=0.0;if(!(h&2)){c[b>>2]=1;d=0}else d=1;if(!(h&1)){c[b>>2]=d;H=b+4+(d<<4)|0;c[b+4>>2]=c[H>>2];c[b+4+4>>2]=c[H+4>>2];c[b+4+8>>2]=c[H+8>>2];c[b+4+12>>2]=c[H+12>>2];H=b+84+(d<<4)|0;c[b+84>>2]=c[H>>2];c[b+84+4>>2]=c[H+4>>2];c[b+84+8>>2]=c[H+8>>2];c[b+84+12>>2]=c[H+12>>2];H=b+164+(d<<4)|0;c[b+164>>2]=c[H>>2];c[b+164+4>>2]=c[H+4>>2];c[b+164+8>>2]=c[H+8>>2];c[b+164+12>>2]=c[H+12>>2]}H=(!(e>=0.0)|!(f>=0.0))&1^1;a[b+312>>0]=H;b=H;b=b<<24>>24!=0;i=I;return b|0}case 3:{c[I+16>>2]=0;c[I+16+4>>2]=0;c[I+16+8>>2]=0;c[I+16+12>>2]=0;fo(I+16|0,b+4|0,b+20|0,b+36|0,b+316|0);F=+g[b+336>>2];e=+g[b+340>>2];f=+g[b+344>>2];A=+g[b+84>>2]*F+ +g[b+100>>2]*e+ +g[b+116>>2]*f;C=F*+g[b+88>>2]+e*+g[b+104>>2]+f*+g[b+120>>2];E=F*+g[b+92>>2]+e*+g[b+108>>2]+f*+g[b+124>>2];g[b+244>>2]=A;g[b+248>>2]=C;g[b+252>>2]=E;g[b+256>>2]=0.0;B=+g[b+164>>2]*F+ +g[b+180>>2]*e+ +g[b+196>>2]*f;D=F*+g[b+168>>2]+e*+g[b+184>>2]+f*+g[b+200>>2];F=F*+g[b+172>>2]+e*+g[b+188>>2]+f*+g[b+204>>2];g[b+260>>2]=B;g[b+264>>2]=D;g[b+268>>2]=F;g[b+272>>2]=0.0;g[b+276>>2]=A-B;g[b+280>>2]=C-D;g[b+284>>2]=E-F;g[b+288>>2]=0.0;h=c[b>>2]|0;do if((h|0)>3){d=a[b+332>>0]|0;if(!(d&8)){c[b>>2]=h+-1;H=b+4+(h+-1<<4)|0;c[b+52>>2]=c[H>>2];c[b+52+4>>2]=c[H+4>>2];c[b+52+8>>2]=c[H+8>>2];c[b+52+12>>2]=c[H+12>>2];H=b+84+(h+-1<<4)|0;c[b+132>>2]=c[H>>2];c[b+132+4>>2]=c[H+4>>2];c[b+132+8>>2]=c[H+8>>2];c[b+132+12>>2]=c[H+12>>2];H=b+164+(h+-1<<4)|0;c[b+212>>2]=c[H>>2];c[b+212+4>>2]=c[H+4>>2];c[b+212+8>>2]=c[H+8>>2];c[b+212+12>>2]=c[H+12>>2];h=h+-1|0;H=21}else H=21}else{if((h|0)>2){d=a[b+332>>0]|0;h=3;H=21;break}if((h|0)>1){d=a[b+332>>0]|0;h=2;H=25;break}if((h|0)>0){o=a[b+332>>0]|0;n=1;H=29}}while(0);if((H|0)==21)if(!(d&4)){h=h+-1|0;c[b>>2]=h;c[b+36>>2]=c[b+4+(h<<4)>>2];c[b+36+4>>2]=c[b+4+(h<<4)+4>>2];c[b+36+8>>2]=c[b+4+(h<<4)+8>>2];c[b+36+12>>2]=c[b+4+(h<<4)+12>>2];c[b+116>>2]=c[b+84+(h<<4)>>2];c[b+116+4>>2]=c[b+84+(h<<4)+4>>2];c[b+116+8>>2]=c[b+84+(h<<4)+8>>2];c[b+116+12>>2]=c[b+84+(h<<4)+12>>2];c[b+196>>2]=c[b+164+(h<<4)>>2];c[b+196+4>>2]=c[b+164+(h<<4)+4>>2];c[b+196+8>>2]=c[b+164+(h<<4)+8>>2];c[b+196+12>>2]=c[b+164+(h<<4)+12>>2];H=25}else H=25;if((H|0)==25)if(!(d&2)){n=h+-1|0;c[b>>2]=n;c[b+20>>2]=c[b+4+(n<<4)>>2];c[b+20+4>>2]=c[b+4+(n<<4)+4>>2];c[b+20+8>>2]=c[b+4+(n<<4)+8>>2];c[b+20+12>>2]=c[b+4+(n<<4)+12>>2];c[b+100>>2]=c[b+84+(n<<4)>>2];c[b+100+4>>2]=c[b+84+(n<<4)+4>>2];c[b+100+8>>2]=c[b+84+(n<<4)+8>>2];c[b+100+12>>2]=c[b+84+(n<<4)+12>>2];c[b+180>>2]=c[b+164+(n<<4)>>2];c[b+180+4>>2]=c[b+164+(n<<4)+4>>2];c[b+180+8>>2]=c[b+164+(n<<4)+8>>2];c[b+180+12>>2]=c[b+164+(n<<4)+12>>2];o=d;H=29}else{o=d;n=h;H=29}if((H|0)==29?(o&1)==0:0){H=n+-1|0;c[b>>2]=H;c[b+4>>2]=c[b+4+(H<<4)>>2];c[b+4+4>>2]=c[b+4+(H<<4)+4>>2];c[b+4+8>>2]=c[b+4+(H<<4)+8>>2];c[b+4+12>>2]=c[b+4+(H<<4)+12>>2];c[b+84>>2]=c[b+84+(H<<4)>>2];c[b+84+4>>2]=c[b+84+(H<<4)+4>>2];c[b+84+8>>2]=c[b+84+(H<<4)+8>>2];c[b+84+12>>2]=c[b+84+(H<<4)+12>>2];c[b+164>>2]=c[b+164+(H<<4)>>2];c[b+164+4>>2]=c[b+164+(H<<4)+4>>2];c[b+164+8>>2]=c[b+164+(H<<4)+8>>2];c[b+164+12>>2]=c[b+164+(H<<4)+12>>2]}if((e>=0.0?!(+g[b+336>>2]>=0.0):1)|!(f>=0.0))d=0;else d=+g[b+348>>2]>=0.0&1;a[b+312>>0]=d;b=d;b=b<<24>>24!=0;i=I;return b|0}case 4:{c[I>>2]=0;c[I+4>>2]=0;c[I+8>>2]=0;c[I+12>>2]=0;q=I+16+16|0;a[q>>0]=0;c[b+316>>2]=0;c[b+316+4>>2]=0;c[b+316+8>>2]=0;c[b+316+12>>2]=0;a[b+332>>0]=h|15;K=+g[b+20>>2];T=+g[b+4>>2];Q=+g[b+24>>2];J=+g[b+8>>2];M=+g[b+28>>2];U=+g[b+12>>2];P=+g[b+36>>2];R=+g[b+40>>2];N=+g[b+44>>2];L=+g[b+52>>2];S=+g[b+56>>2];O=+g[b+60>>2];V=((Q-J)*(N-U)-(M-U)*(R-J))*(L-T)+((M-U)*(P-T)-(K-T)*(N-U))*(S-J)+((K-T)*(R-J)-(Q-J)*(P-T))*(O-U);h=V*V<9.99999905104687e-09?-1:((0.0-T)*((Q-J)*(N-U)-(M-U)*(R-J))+(0.0-J)*((M-U)*(P-T)-(K-T)*(N-U))+((K-T)*(R-J)-(Q-J)*(P-T))*(0.0-U))*V<0.0&1;V=(M-U)*((P-T)*(S-J)-(R-J)*(L-T))+((K-T)*((R-J)*(O-U)-(N-U)*(S-J))+(Q-J)*((N-U)*(L-T)-(P-T)*(O-U)));n=V*V<9.99999905104687e-09?-1:((0.0-U)*((P-T)*(S-J)-(R-J)*(L-T))+((0.0-T)*((R-J)*(O-U)-(N-U)*(S-J))+(0.0-J)*((N-U)*(L-T)-(P-T)*(O-U))))*V<0.0&1;V=(N-U)*((Q-J)*(L-T)-(K-T)*(S-J))+((P-T)*((M-U)*(S-J)-(Q-J)*(O-U))+(R-J)*((K-T)*(O-U)-(M-U)*(L-T)));o=V*V<9.99999905104687e-09?-1:((0.0-U)*((Q-J)*(L-T)-(K-T)*(S-J))+((0.0-T)*((M-U)*(S-J)-(Q-J)*(O-U))+(0.0-J)*((K-T)*(O-U)-(M-U)*(L-T))))*V<0.0&1;J=(U-M)*((R-Q)*(L-K)-(P-K)*(S-Q))+((T-K)*((N-M)*(S-Q)-(R-Q)*(O-M))+(J-Q)*((P-K)*(O-M)-(N-M)*(L-K)));p=J*J<9.99999905104687e-09?-1:((0.0-M)*((R-Q)*(L-K)-(P-K)*(S-Q))+((0.0-K)*((N-M)*(S-Q)-(R-Q)*(O-M))+(0.0-Q)*((P-K)*(O-M)-(N-M)*(L-K))))*J<0.0&1;do if((n|h|o|p|0)<0){a[b+352>>0]=1;d=b+312|0;H=70}else{if(!(n|h|o|p)){if(a[b+352>>0]|0){d=b+312|0;H=70;break}a[b+312>>0]=1;c[b+276>>2]=0;c[b+276+4>>2]=0;c[b+276+8>>2]=0;c[b+276+12>>2]=0;d=1;break}if((h|0)!=0?(fo(I,b+4|0,b+20|0,b+36|0,I+16|0),e=+g[I+16>>2],f=+g[I+16+4>>2],j=+g[I+16+8>>2],k=e-+g[I>>2],l=f-+g[I+4>>2],m=j-+g[I+8>>2],k*k+l*l+m*m<3402823466385288598117041.0e14):0){W=c[I+16+12>>2]|0;g[b+316>>2]=e;g[b+320>>2]=f;g[b+324>>2]=j;c[b+328>>2]=W;W=a[q>>0]|0;a[b+332>>0]=W&1|a[b+332>>0]&-16|W&2|W&4;W=c[I+16+24>>2]|0;h=c[I+16+28>>2]|0;c[b+336>>2]=c[I+16+20>>2];c[b+340>>2]=W;c[b+344>>2]=h;g[b+348>>2]=0.0;e=k*k+l*l+m*m}else e=3402823466385288598117041.0e14;if((n|0)!=0?(fo(I,b+4|0,b+36|0,b+52|0,I+16|0),r=+g[I+16>>2],s=+g[I+16+4>>2],t=+g[I+16+8>>2],u=r-+g[I>>2],v=s-+g[I+4>>2],w=t-+g[I+8>>2],u*u+v*v+w*w<e):0){n=c[I+16+12>>2]|0;g[b+316>>2]=r;g[b+320>>2]=s;g[b+324>>2]=t;c[b+328>>2]=n;n=a[q>>0]|0;a[b+332>>0]=n<<1&8|(n&1|a[b+332>>0]&-16|n<<1&4);n=c[I+16+24>>2]|0;W=c[I+16+28>>2]|0;c[b+336>>2]=c[I+16+20>>2];g[b+340>>2]=0.0;c[b+344>>2]=n;c[b+348>>2]=W;e=u*u+v*v+w*w}if((o|0)!=0?(fo(I,b+4|0,b+52|0,b+20|0,I+16|0),x=+g[I+16>>2],y=+g[I+16+4>>2],z=+g[I+16+8>>2],A=x-+g[I>>2],B=y-+g[I+4>>2],C=z-+g[I+8>>2],A*A+B*B+C*C<e):0){o=c[I+16+12>>2]|0;g[b+316>>2]=x;g[b+320>>2]=y;g[b+324>>2]=z;c[b+328>>2]=o;o=a[q>>0]|0;a[b+332>>0]=o<<2&8|(o&1|a[b+332>>0]&-16|(o&255)>>>1&2);o=c[I+16+28>>2]|0;W=c[I+16+24>>2]|0;c[b+336>>2]=c[I+16+20>>2];c[b+340>>2]=o;g[b+344>>2]=0.0;c[b+348>>2]=W;e=A*A+B*B+C*C}if(p|0?(fo(I,b+20|0,b+52|0,b+36|0,I+16|0),D=+g[I+16>>2],E=+g[I+16+4>>2],F=+g[I+16+8>>2],T=D-+g[I>>2],U=E-+g[I+4>>2],V=F-+g[I+8>>2],T*T+U*U+V*V<e):0){p=c[I+16+12>>2]|0;g[b+316>>2]=D;g[b+320>>2]=E;g[b+324>>2]=F;c[b+328>>2]=p;p=a[q>>0]|0;a[b+332>>0]=p&4|a[b+332>>0]&-16|p<<1&2|p<<2&8;p=c[I+16+20>>2]|0;q=c[I+16+28>>2]|0;W=c[I+16+24>>2]|0;g[b+336>>2]=0.0;c[b+340>>2]=p;c[b+344>>2]=q;c[b+348>>2]=W}O=+g[b+336>>2];P=+g[b+340>>2];V=+g[b+344>>2];e=+g[b+348>>2];Q=+g[b+84>>2]*O+ +g[b+100>>2]*P+ +g[b+116>>2]*V+ +g[b+132>>2]*e;S=O*+g[b+88>>2]+P*+g[b+104>>2]+V*+g[b+120>>2]+e*+g[b+136>>2];U=O*+g[b+92>>2]+P*+g[b+108>>2]+V*+g[b+124>>2]+e*+g[b+140>>2];g[b+244>>2]=Q;g[b+248>>2]=S;g[b+252>>2]=U;g[b+256>>2]=0.0;R=+g[b+164>>2]*O+ +g[b+180>>2]*P+ +g[b+196>>2]*V+ +g[b+212>>2]*e;T=O*+g[b+168>>2]+P*+g[b+184>>2]+V*+g[b+200>>2]+e*+g[b+216>>2];V=O*+g[b+172>>2]+P*+g[b+188>>2]+V*+g[b+204>>2]+e*+g[b+220>>2];g[b+260>>2]=R;g[b+264>>2]=T;g[b+268>>2]=V;g[b+272>>2]=0.0;g[b+276>>2]=Q-R;g[b+280>>2]=S-T;g[b+284>>2]=U-V;g[b+288>>2]=0.0;h=c[b>>2]|0;do if((h|0)>3){d=a[b+332>>0]|0;if(!(d&8)){c[b>>2]=h+-1;H=b+4+(h+-1<<4)|0;c[b+52>>2]=c[H>>2];c[b+52+4>>2]=c[H+4>>2];c[b+52+8>>2]=c[H+8>>2];c[b+52+12>>2]=c[H+12>>2];H=b+84+(h+-1<<4)|0;c[b+132>>2]=c[H>>2];c[b+132+4>>2]=c[H+4>>2];c[b+132+8>>2]=c[H+8>>2];c[b+132+12>>2]=c[H+12>>2];H=b+164+(h+-1<<4)|0;c[b+212>>2]=c[H>>2];c[b+212+4>>2]=c[H+4>>2];c[b+212+8>>2]=c[H+8>>2];c[b+212+12>>2]=c[H+12>>2];h=h+-1|0;H=54}else H=54}else{if((h|0)>2){d=a[b+332>>0]|0;h=3;H=54;break}if((h|0)>1){d=a[b+332>>0]|0;h=2;H=58;break}if((h|0)>0){d=a[b+332>>0]|0;G=1;H=62}}while(0);if((H|0)==54)if(!(d&4)){h=h+-1|0;c[b>>2]=h;c[b+36>>2]=c[b+4+(h<<4)>>2];c[b+36+4>>2]=c[b+4+(h<<4)+4>>2];c[b+36+8>>2]=c[b+4+(h<<4)+8>>2];c[b+36+12>>2]=c[b+4+(h<<4)+12>>2];c[b+116>>2]=c[b+84+(h<<4)>>2];c[b+116+4>>2]=c[b+84+(h<<4)+4>>2];c[b+116+8>>2]=c[b+84+(h<<4)+8>>2];c[b+116+12>>2]=c[b+84+(h<<4)+12>>2];c[b+196>>2]=c[b+164+(h<<4)>>2];c[b+196+4>>2]=c[b+164+(h<<4)+4>>2];c[b+196+8>>2]=c[b+164+(h<<4)+8>>2];c[b+196+12>>2]=c[b+164+(h<<4)+12>>2];H=58}else H=58;if((H|0)==58)if(!(d&2)){G=h+-1|0;c[b>>2]=G;c[b+20>>2]=c[b+4+(G<<4)>>2];c[b+20+4>>2]=c[b+4+(G<<4)+4>>2];c[b+20+8>>2]=c[b+4+(G<<4)+8>>2];c[b+20+12>>2]=c[b+4+(G<<4)+12>>2];c[b+100>>2]=c[b+84+(G<<4)>>2];c[b+100+4>>2]=c[b+84+(G<<4)+4>>2];c[b+100+8>>2]=c[b+84+(G<<4)+8>>2];c[b+100+12>>2]=c[b+84+(G<<4)+12>>2];c[b+180>>2]=c[b+164+(G<<4)>>2];c[b+180+4>>2]=c[b+164+(G<<4)+4>>2];c[b+180+8>>2]=c[b+164+(G<<4)+8>>2];c[b+180+12>>2]=c[b+164+(G<<4)+12>>2];H=62}else{G=h;H=62}if((H|0)==62?(d&1)==0:0){W=G+-1|0;c[b>>2]=W;c[b+4>>2]=c[b+4+(W<<4)>>2];c[b+4+4>>2]=c[b+4+(W<<4)+4>>2];c[b+4+8>>2]=c[b+4+(W<<4)+8>>2];c[b+4+12>>2]=c[b+4+(W<<4)+12>>2];c[b+84>>2]=c[b+84+(W<<4)>>2];c[b+84+4>>2]=c[b+84+(W<<4)+4>>2];c[b+84+8>>2]=c[b+84+(W<<4)+8>>2];c[b+84+12>>2]=c[b+84+(W<<4)+12>>2];c[b+164>>2]=c[b+164+(W<<4)>>2];c[b+164+4>>2]=c[b+164+(W<<4)+4>>2];c[b+164+8>>2]=c[b+164+(W<<4)+8>>2];c[b+164+12>>2]=c[b+164+(W<<4)+12>>2]}if((+g[b+336>>2]>=0.0?+g[b+340>>2]>=0.0:0)?+g[b+344>>2]>=0.0:0)d=e>=0.0&1;else d=0;a[b+312>>0]=d}while(0);if((H|0)==70){a[d>>0]=0;d=0}W=d;W=W<<24>>24!=0;i=I;return W|0}default:{a[b+312>>0]=0;W=0;W=W<<24>>24!=0;i=I;return W|0}}return 0}
function xe(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,l=0,m=0.0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0.0,P=0.0,Q=0,R=0.0,S=0.0,T=0.0,U=0.0,V=0,X=0.0,Y=0,Z=0.0,_=0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0,ea=0,fa=0.0,ga=0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0,na=0.0,oa=0.0,pa=0.0,qa=0.0,ra=0.0,sa=0.0,ta=0.0,ua=0.0,va=0.0,wa=0.0,xa=0.0,ya=0.0,za=0.0,Aa=0,Ba=0,Ca=0,Da=0.0,Ea=0.0,Fa=0;Fa=i;i=i+592|0;c[Fa+48>>2]=c[b>>2];c[Fa>>2]=c[b+64>>2];E=Fa+48+4|0;c[E>>2]=c[b+4>>2];c[Fa+4>>2]=c[b+68>>2];c[Fa+48+8>>2]=c[b+8>>2];c[Fa+8>>2]=c[b+72>>2];c[Fa+48+16>>2]=c[b+16>>2];c[Fa+16>>2]=c[b+80>>2];c[Fa+48+20>>2]=c[b+20>>2];c[Fa+20>>2]=c[b+84>>2];c[Fa+48+24>>2]=c[b+24>>2];c[Fa+24>>2]=c[b+88>>2];c[Fa+48+32>>2]=c[b+32>>2];c[Fa+32>>2]=c[b+96>>2];c[Fa+48+36>>2]=c[b+36>>2];c[Fa+36>>2]=c[b+100>>2];c[Fa+48+40>>2]=c[b+40>>2];c[Fa+40>>2]=c[b+104>>2];Ca=c[a+4>>2]|0;ia=+g[Ca+32>>2];ja=+g[Ca+36>>2];ma=+g[Ca+40>>2];ka=+Hb[c[(c[Ca>>2]|0)+48>>2]&15](Ca);la=+Hb[c[(c[Ca>>2]|0)+48>>2]&15](Ca);ma=(ma+ +Hb[c[(c[Ca>>2]|0)+48>>2]&15](Ca))*2.0;Ca=c[a+8>>2]|0;qa=+g[Ca+32>>2];ra=+g[Ca+36>>2];wa=+g[Ca+40>>2];sa=+Hb[c[(c[Ca>>2]|0)+48>>2]&15](Ca);pa=+Hb[c[(c[Ca>>2]|0)+48>>2]&15](Ca);wa=(wa+ +Hb[c[(c[Ca>>2]|0)+48>>2]&15](Ca))*2.0;D=+g[b+112>>2]-+g[b+48>>2];M=+g[b+116>>2]-+g[b+52>>2];P=+g[b+120>>2]-+g[b+56>>2];ca=+g[Fa+48>>2];aa=+g[Fa+48+16>>2];ba=+g[Fa+48+32>>2];$=+g[E>>2];X=+g[Fa+48+20>>2];Z=+g[Fa+48+36>>2];fa=+g[Fa+48+8>>2];ha=+g[Fa+48+24>>2];na=+g[Fa+48+40>>2];g[Fa+484>>2]=(ia+ka)*2.0*.5;g[Fa+484+4>>2]=(ja+la)*2.0*.5;g[Fa+484+8>>2]=ma*.5;g[Fa+472>>2]=(qa+sa)*2.0*.5;g[Fa+472+4>>2]=(ra+pa)*2.0*.5;g[Fa+472+8>>2]=wa*.5;za=+g[Fa>>2];ta=+g[Fa+16>>2];va=+g[Fa+32>>2];ya=+g[Fa+4>>2];oa=+g[Fa+20>>2];ua=+g[Fa+36>>2];xa=+g[Fa+8>>2];Da=+g[Fa+24>>2];Ea=+g[Fa+40>>2];y=+N(+(ca*za+aa*ta+ba*va));A=+N(+(ca*ya+aa*oa+ba*ua));R=+N(+(ca*xa+aa*Da+ba*Ea));z=+N(+(za*$+ta*X+va*Z));B=+N(+(ya*$+oa*X+ua*Z));S=+N(+(xa*$+Da*X+Ea*Z));T=+N(+(za*fa+ta*ha+va*na));U=+N(+(ya*fa+oa*ha+ua*na));C=+N(+(xa*fa+Da*ha+Ea*na));h=+N(+(D*ca+M*aa+P*ba))-(wa*.5*R+((ia+ka)*2.0*.5+y*((qa+sa)*2.0*.5)+A*((ra+pa)*2.0*.5)));if(h>0.0){i=Fa;return}if(h>-3402823466385288598117041.0e14){n=1;l=D*ca+M*aa+P*ba<0.0&1;e=Fa+48|0}else{n=0;l=0;e=0;h=-3402823466385288598117041.0e14}j=+N(+(D*$+M*X+P*Z))-((ja+la)*2.0*.5+z*((qa+sa)*2.0*.5)+B*((ra+pa)*2.0*.5)+S*(wa*.5));if(j>0.0){i=Fa;return}if(j>h){n=2;l=D*$+M*X+P*Z<0.0&1;e=E;h=j}j=+N(+(D*fa+M*ha+P*na))-(ma*.5+T*((qa+sa)*2.0*.5)+U*((ra+pa)*2.0*.5)+C*(wa*.5));if(j>0.0){i=Fa;return}if(j>h){n=3;l=D*fa+M*ha+P*na<0.0&1;e=Fa+48+8|0;h=j}j=+N(+(D*za+M*ta+P*va))-((qa+sa)*2.0*.5+(y*((ia+ka)*2.0*.5)+z*((ja+la)*2.0*.5)+T*(ma*.5)));if(j>0.0){i=Fa;return}if(j>h){n=4;l=D*za+M*ta+P*va<0.0&1;e=Fa;h=j}j=+N(+(D*ya+M*oa+P*ua))-((ra+pa)*2.0*.5+(A*((ia+ka)*2.0*.5)+B*((ja+la)*2.0*.5)+U*(ma*.5)));if(j>0.0){i=Fa;return}if(j>h){n=5;l=D*ya+M*oa+P*ua<0.0&1;e=Fa+4|0}else j=h;h=+N(+(D*xa+M*Da+P*Ea))-(wa*.5+(R*((ia+ka)*2.0*.5)+S*((ja+la)*2.0*.5)+C*(ma*.5)));if(h>0.0){i=Fa;return}if(h>j){n=6;l=D*xa+M*Da+P*Ea<0.0&1;u=Fa+8|0}else{u=e;h=j}j=(D*fa+M*ha+P*na)*(za*$+ta*X+va*Z)-(D*$+M*X+P*Z)*(za*fa+ta*ha+va*na);m=+N(+j)-((T+9.999999747378752e-06)*((ja+la)*2.0*.5)+(z+9.999999747378752e-06)*(ma*.5)+(R+9.999999747378752e-06)*((ra+pa)*2.0*.5)+(A+9.999999747378752e-06)*(wa*.5));if(m>1.1920928955078125e-07){i=Fa;return}p=(za*fa+ta*ha+va*na)*(za*fa+ta*ha+va*na)+0.0;v=(za*$+ta*X+va*Z)*(za*$+ta*X+va*Z);o=+O(+(v+p));if(o>1.1920928955078125e-07?m/o*1.0499999523162842>h:0){a=(g[k>>2]=0.0/o,c[k>>2]|0);f=(g[k>>2]=-(za*fa+ta*ha+va*na)/o,c[k>>2]|0);n=7;l=j<0.0&1;e=(g[k>>2]=(za*$+ta*X+va*Z)/o,c[k>>2]|0);u=0;h=m/o}else{a=0;f=0;e=0}j=(D*fa+M*ha+P*na)*(ya*$+oa*X+ua*Z)-(D*$+M*X+P*Z)*(ya*fa+oa*ha+ua*na);m=+N(+j)-((U+9.999999747378752e-06)*((ja+la)*2.0*.5)+(B+9.999999747378752e-06)*(ma*.5)+(R+9.999999747378752e-06)*((qa+sa)*2.0*.5)+(y+9.999999747378752e-06)*(wa*.5));if(m>1.1920928955078125e-07){i=Fa;return}q=(ya*fa+oa*ha+ua*na)*(ya*fa+oa*ha+ua*na)+0.0;w=(ya*$+oa*X+ua*Z)*(ya*$+oa*X+ua*Z);o=+O(+(w+q));if(o>1.1920928955078125e-07?m/o*1.0499999523162842>h:0){a=(g[k>>2]=0.0/o,c[k>>2]|0);f=(g[k>>2]=-(ya*fa+oa*ha+ua*na)/o,c[k>>2]|0);n=8;l=j<0.0&1;e=(g[k>>2]=(ya*$+oa*X+ua*Z)/o,c[k>>2]|0);u=0;h=m/o}j=(D*fa+M*ha+P*na)*(xa*$+Da*X+Ea*Z)-(D*$+M*X+P*Z)*(xa*fa+Da*ha+Ea*na);m=+N(+j)-((C+9.999999747378752e-06)*((ja+la)*2.0*.5)+(S+9.999999747378752e-06)*(ma*.5)+(A+9.999999747378752e-06)*((qa+sa)*2.0*.5)+(y+9.999999747378752e-06)*((ra+pa)*2.0*.5));if(m>1.1920928955078125e-07){i=Fa;return}s=(xa*fa+Da*ha+Ea*na)*(xa*fa+Da*ha+Ea*na)+0.0;x=(xa*$+Da*X+Ea*Z)*(xa*$+Da*X+Ea*Z);o=+O(+(x+s));if(o>1.1920928955078125e-07?m/o*1.0499999523162842>h:0){a=(g[k>>2]=0.0/o,c[k>>2]|0);f=(g[k>>2]=-(xa*fa+Da*ha+Ea*na)/o,c[k>>2]|0);n=9;l=j<0.0&1;e=(g[k>>2]=(xa*$+Da*X+Ea*Z)/o,c[k>>2]|0);u=0;h=m/o}j=(D*ca+M*aa+P*ba)*(za*fa+ta*ha+va*na)-(D*fa+M*ha+P*na)*(ca*za+aa*ta+ba*va);o=+N(+j)-((T+9.999999747378752e-06)*((ia+ka)*2.0*.5)+(y+9.999999747378752e-06)*(ma*.5)+(S+9.999999747378752e-06)*((ra+pa)*2.0*.5)+(B+9.999999747378752e-06)*(wa*.5));if(o>1.1920928955078125e-07){i=Fa;return}t=(ca*za+aa*ta+ba*va)*(ca*za+aa*ta+ba*va);m=+O(+(t+p));do if(m>1.1920928955078125e-07){if(!(o/m*1.0499999523162842>h))break;a=(g[k>>2]=(za*fa+ta*ha+va*na)/m,c[k>>2]|0);f=(g[k>>2]=0.0/m,c[k>>2]|0);n=10;l=j<0.0&1;e=(g[k>>2]=-(ca*za+aa*ta+ba*va)/m,c[k>>2]|0);u=0;h=o/m}while(0);j=(D*ca+M*aa+P*ba)*(ya*fa+oa*ha+ua*na)-(D*fa+M*ha+P*na)*(ca*ya+aa*oa+ba*ua);o=+N(+j)-((U+9.999999747378752e-06)*((ia+ka)*2.0*.5)+(A+9.999999747378752e-06)*(ma*.5)+(S+9.999999747378752e-06)*((qa+sa)*2.0*.5)+(z+9.999999747378752e-06)*(wa*.5));if(o>1.1920928955078125e-07){i=Fa;return}r=(ca*ya+aa*oa+ba*ua)*(ca*ya+aa*oa+ba*ua);m=+O(+(r+q));do if(m>1.1920928955078125e-07){if(!(o/m*1.0499999523162842>h))break;a=(g[k>>2]=(ya*fa+oa*ha+ua*na)/m,c[k>>2]|0);f=(g[k>>2]=0.0/m,c[k>>2]|0);n=11;l=j<0.0&1;e=(g[k>>2]=-(ca*ya+aa*oa+ba*ua)/m,c[k>>2]|0);u=0;h=o/m}while(0);j=(D*ca+M*aa+P*ba)*(xa*fa+Da*ha+Ea*na)-(D*fa+M*ha+P*na)*(ca*xa+aa*Da+ba*Ea);o=+N(+j)-((C+9.999999747378752e-06)*((ia+ka)*2.0*.5)+(R+9.999999747378752e-06)*(ma*.5)+(B+9.999999747378752e-06)*((qa+sa)*2.0*.5)+(z+9.999999747378752e-06)*((ra+pa)*2.0*.5));if(o>1.1920928955078125e-07){i=Fa;return}p=(ca*xa+aa*Da+ba*Ea)*(ca*xa+aa*Da+ba*Ea);m=+O(+(p+s));do if(m>1.1920928955078125e-07){if(!(o/m*1.0499999523162842>h))break;a=(g[k>>2]=(xa*fa+Da*ha+Ea*na)/m,c[k>>2]|0);f=(g[k>>2]=0.0/m,c[k>>2]|0);n=12;l=j<0.0&1;e=(g[k>>2]=-(ca*xa+aa*Da+ba*Ea)/m,c[k>>2]|0);u=0;h=o/m}while(0);j=(D*$+M*X+P*Z)*(ca*za+aa*ta+ba*va)-(D*ca+M*aa+P*ba)*(za*$+ta*X+va*Z);o=+N(+j)-((z+9.999999747378752e-06)*((ia+ka)*2.0*.5)+(y+9.999999747378752e-06)*((ja+la)*2.0*.5)+(C+9.999999747378752e-06)*((ra+pa)*2.0*.5)+(U+9.999999747378752e-06)*(wa*.5));if(o>1.1920928955078125e-07){i=Fa;return}m=+O(+(t+v+0.0));do if(m>1.1920928955078125e-07){if(!(o/m*1.0499999523162842>h))break;a=(g[k>>2]=-(za*$+ta*X+va*Z)/m,c[k>>2]|0);f=(g[k>>2]=(ca*za+aa*ta+ba*va)/m,c[k>>2]|0);n=13;l=j<0.0&1;e=(g[k>>2]=0.0/m,c[k>>2]|0);u=0;h=o/m}while(0);j=(D*$+M*X+P*Z)*(ca*ya+aa*oa+ba*ua)-(D*ca+M*aa+P*ba)*(ya*$+oa*X+ua*Z);o=+N(+j)-((B+9.999999747378752e-06)*((ia+ka)*2.0*.5)+(A+9.999999747378752e-06)*((ja+la)*2.0*.5)+(C+9.999999747378752e-06)*((qa+sa)*2.0*.5)+(T+9.999999747378752e-06)*(wa*.5));if(o>1.1920928955078125e-07){i=Fa;return}m=+O(+(r+w+0.0));do if(m>1.1920928955078125e-07){if(!(o/m*1.0499999523162842>h))break;a=(g[k>>2]=-(ya*$+oa*X+ua*Z)/m,c[k>>2]|0);f=(g[k>>2]=(ca*ya+aa*oa+ba*ua)/m,c[k>>2]|0);n=14;l=j<0.0&1;e=(g[k>>2]=0.0/m,c[k>>2]|0);u=0;h=o/m}while(0);m=(D*$+M*X+P*Z)*(ca*xa+aa*Da+ba*Ea)-(D*ca+M*aa+P*ba)*(xa*$+Da*X+Ea*Z);o=+N(+m)-((S+9.999999747378752e-06)*((ia+ka)*2.0*.5)+(R+9.999999747378752e-06)*((ja+la)*2.0*.5)+(U+9.999999747378752e-06)*((qa+sa)*2.0*.5)+(T+9.999999747378752e-06)*((ra+pa)*2.0*.5));if(o>1.1920928955078125e-07){i=Fa;return}j=+O(+(p+x+0.0));do if(j>1.1920928955078125e-07){if(!(o/j*1.0499999523162842>h)){Aa=55;break}a=(g[k>>2]=-(xa*$+Da*X+Ea*Z)/j,c[k>>2]|0);f=(g[k>>2]=(ca*xa+aa*Da+ba*Ea)/j,c[k>>2]|0);n=15;l=m<0.0&1;e=(g[k>>2]=0.0/j,c[k>>2]|0);h=o/j;Aa=58}else Aa=55;while(0);do if((Aa|0)==55){if(!n){i=Fa;return}if(!u){Aa=58;break}e=c[u>>2]|0;a=c[u+16>>2]|0;Ca=c[u+32>>2]|0;j=(c[k>>2]=e,+g[k>>2]);m=(c[k>>2]=a,+g[k>>2]);o=(c[k>>2]=Ca,+g[k>>2]);f=l;l=Ca;D=h}while(0);if((Aa|0)==58){ca=(c[k>>2]=a,+g[k>>2]);o=(c[k>>2]=f,+g[k>>2]);D=(c[k>>2]=e,+g[k>>2]);j=ca*+g[Fa+48>>2]+o*+g[E>>2]+D*fa;e=(g[k>>2]=j,c[k>>2]|0);m=ca*+g[Fa+48+16>>2]+o*+g[Fa+48+20>>2]+D*ha;a=(g[k>>2]=m,c[k>>2]|0);D=ca*+g[Fa+48+32>>2]+o*+g[Fa+48+36>>2]+D*na;o=D;f=l;l=(g[k>>2]=D,c[k>>2]|0);D=h}if(!f){Ba=a;Ca=l}else{e=(g[k>>2]=-j,c[k>>2]|0);Ba=(g[k>>2]=-m,c[k>>2]|0);Ca=(g[k>>2]=-o,c[k>>2]|0)}if((n|0)>6){C=(c[k>>2]=e,+g[k>>2]);B=(c[k>>2]=Ba,+g[k>>2]);A=(c[k>>2]=Ca,+g[k>>2]);j=+g[Fa+48>>2];t=+g[Fa+48+16>>2];w=+g[Fa+48+32>>2];v=(C*j+B*t+A*w>0.0?1.0:-1.0)*((ia+ka)*2.0*.5);z=+g[E>>2];y=+g[Fa+48+20>>2];h=+g[Fa+48+36>>2];s=(C*z+B*y+A*h>0.0?1.0:-1.0)*((ja+la)*2.0*.5);x=(C*fa+B*ha+A*na>0.0?1.0:-1.0)*(ma*.5);z=+g[b+48>>2]+v*j+s*z+x*fa;y=+g[b+52>>2]+v*t+s*y+x*ha;x=+g[b+56>>2]+v*w+s*h+x*na;c[Fa+528>>2]=c[b+112>>2];c[Fa+528+4>>2]=c[b+112+4>>2];c[Fa+528+8>>2]=c[b+112+8>>2];h=(C*za+B*ta+A*va>0.0?-1.0:1.0)*((qa+sa)*2.0*.5);s=(C*ya+B*oa+A*ua>0.0?-1.0:1.0)*((ra+pa)*2.0*.5);w=+g[Fa+528+4>>2]+h*ta+s*oa;v=+g[Fa+528+8>>2]+h*va+s*ua;t=(C*xa+B*Da+A*Ea>0.0?-1.0:1.0)*(wa*.5);s=+g[Fa+528>>2]+h*za+s*ya+t*xa;g[Fa+528>>2]=s;g[Fa+528+4>>2]=w+t*Da;g[Fa+528+8>>2]=v+t*Ea;Ca=n+-7|0;h=+g[Fa+48+(((Ca|0)/3|0)<<2)>>2];j=+g[Fa+48+(((Ca|0)/3|0)+4<<2)>>2];m=+g[Fa+48+(((Ca|0)/3|0)+8<<2)>>2];p=+g[Fa+(((Ca|0)%3|0)<<2)>>2];q=+g[Fa+(((Ca|0)%3|0)+4<<2)>>2];r=+g[Fa+(((Ca|0)%3|0)+8<<2)>>2];o=1.0-(h*p+j*q+m*r)*(h*p+j*q+m*r);if(!(o<=9.999999747378752e-05))h=(((s-z)*h+(w+t*Da-y)*j+(v+t*Ea-x)*m)*(h*p+j*q+m*r)-((s-z)*p+(w+t*Da-y)*q+(v+t*Ea-x)*r))*(1.0/o);else h=0.0;g[Fa+528>>2]=s+h*p;g[Fa+528+4>>2]=w+t*Da+h*q;g[Fa+528+8>>2]=v+t*Ea+h*r;Ca=c[(c[d>>2]|0)+16>>2]|0;g[Fa+456>>2]=-C;g[Fa+456+4>>2]=-B;g[Fa+456+8>>2]=-A;g[Fa+456+12>>2]=0.0;Yb[Ca&15](d,Fa+456|0,Fa+528|0,D);i=Fa;return}da=(n|0)<4;fa=(c[k>>2]=e,+g[k>>2]);if(da){l=Fa+48|0;_=Fa;Q=Fa+484|0;u=Fa+472|0;ca=fa;f=Ca;e=Ba;ga=b+48|0;a=b+112|0}else{e=(g[k>>2]=-(c[k>>2]=Ba,+g[k>>2]),c[k>>2]|0);l=Fa;_=Fa+48|0;Q=Fa+472|0;u=Fa+484|0;ca=-fa;f=(g[k>>2]=-(c[k>>2]=Ca,+g[k>>2]),c[k>>2]|0);ga=b+112|0;a=b+48|0}ba=(c[k>>2]=e,+g[k>>2]);aa=(c[k>>2]=f,+g[k>>2]);h=ca*+g[_>>2]+ba*+g[_+16>>2]+aa*+g[_+32>>2];g[Fa+440>>2]=h;j=ca*+g[_+4>>2]+ba*+g[_+20>>2]+aa*+g[_+36>>2];g[Fa+440+4>>2]=j;p=ca*+g[_+8>>2]+ba*+g[_+24>>2]+aa*+g[_+40>>2];g[Fa+440+8>>2]=p;h=+N(+h);j=+N(+j);p=+N(+p);e=j>h?(j>p?1:2):h>p?0:2;V=j>h?0:h>p&1;Y=(j>h?j>p:h>p)?2:1;p=+g[u+(e<<2)>>2];h=+g[a>>2]-+g[ga>>2];j=p*+g[_+(e<<2)>>2];m=+g[a+4>>2];ea=ga+4|0;o=+g[ea>>2];if(+g[Fa+440+(e<<2)>>2]<0.0){$=h+j;Z=m-o+p*+g[_+((e|4)<<2)>>2];X=+g[a+8>>2]-+g[ga+8>>2]+p*+g[_+((e|8)<<2)>>2]}else{$=h-j;Z=m-o-p*+g[_+((e|4)<<2)>>2];X=+g[a+8>>2]-+g[ga+8>>2]-p*+g[_+((e|8)<<2)>>2]}K=(da?-1:-4)+n|0;switch(K|0){case 0:{e=1;f=2;break}case 1:{e=0;f=2;break}default:{e=0;f=1}}J=l+(e<<2)|0;T=+g[J>>2];R=+g[J+16>>2];S=+g[J+32>>2];U=$*T+Z*R+X*S;J=l+(f<<2)|0;M=+g[J>>2];A=+g[J+16>>2];B=+g[J+32>>2];P=$*M+Z*A+X*B;J=_+(V<<2)|0;D=+g[J>>2];y=+g[J+16>>2];z=+g[J+32>>2];L=_+(Y<<2)|0;C=+g[L>>2];w=+g[L+16>>2];x=+g[L+32>>2];Da=+g[u+(V<<2)>>2];Ea=+g[u+(Y<<2)>>2];za=(T*C+R*w+S*x)*Ea;Ea=(M*C+A*w+B*x)*Ea;g[Fa+408>>2]=U-(T*D+R*y+S*z)*Da-za;g[Fa+408+4>>2]=P-(M*D+A*y+B*z)*Da-Ea;g[Fa+408+8>>2]=U-(T*D+R*y+S*z)*Da+za;g[Fa+408+12>>2]=P-(M*D+A*y+B*z)*Da+Ea;g[Fa+408+16>>2]=U+(T*D+R*y+S*z)*Da+za;g[Fa+408+20>>2]=P+(M*D+A*y+B*z)*Da+Ea;g[Fa+408+24>>2]=U+(T*D+R*y+S*z)*Da-za;g[Fa+408+28>>2]=P+(M*D+A*y+B*z)*Da-Ea;c[Fa+400>>2]=c[Q+(e<<2)>>2];c[Fa+400+4>>2]=c[Q+(f<<2)>>2];I=0;f=4;b=Fa+408|0;H=Fa+336|0;a:while(1){F=Fa+400+(I<<2)|0;G=1-I|0;do if((f|0)>0){a=0;E=b;e=H;while(1){l=E+(I<<2)|0;h=+g[l>>2];j=+g[F>>2];if(j>-h){c[e>>2]=c[E>>2];c[e+4>>2]=c[E+4>>2];a=a+1|0;if(a&8|0){f=a;e=H;break a}h=+g[l>>2];j=+g[F>>2];n=e+8|0}else n=e;u=(f|0)>1;l=E;E=E+8|0;e=u?E:b;m=+g[e+(I<<2)>>2];if(j>-h^j>-m){Ea=+g[l+(G<<2)>>2];g[n+(G<<2)>>2]=Ea+(-j-h)*((+g[e+(G<<2)>>2]-Ea)/(m-h));g[n+(I<<2)>>2]=-+g[F>>2];e=a+1|0;if(!(e&8)){a=e;e=n+8|0}else{f=e;e=H;break a}}else e=n;if(!u)break;else f=f+-1|0}e=(H|0)==(Fa+336|0)?Fa+528|0:Fa+336|0;if((a|0)<=0){f=0;break}E=a;f=0;b=H;a=e;while(1){l=b+(I<<2)|0;h=+g[l>>2];j=+g[F>>2];if(h<j){c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];f=f+1|0;if(f&8|0)break a;h=+g[l>>2];j=+g[F>>2];a=a+8|0}u=(E|0)>1;n=b;b=b+8|0;l=u?b:H;m=+g[l+(I<<2)>>2];if(h<j^m<j){Ea=+g[n+(G<<2)>>2];g[a+(G<<2)>>2]=Ea+(j-h)*((+g[l+(G<<2)>>2]-Ea)/(m-h));c[a+(I<<2)>>2]=c[F>>2];f=f+1|0;if(!(f&8))a=a+8|0;else break a}if(!u)break;else E=E+-1|0}}else{e=(H|0)==(Fa+336|0)?Fa+528|0:Fa+336|0;f=0}while(0);I=I+1|0;if((I|0)>=2)break;else{b=e;H=(e|0)==(Fa+336|0)?Fa+528|0:Fa+336|0}}if((e|0)!=(Fa+336|0))bH(Fa+336|0,e|0,f<<3|0)|0;if((f|0)>=1){v=1.0/((T*D+R*y+S*z)*(M*C+A*w+B*x)-(M*D+A*y+B*z)*(T*C+R*w+S*x));t=+g[Q+(K<<2)>>2];s=+g[J>>2];p=+g[L>>2];q=+g[_+((V|4)<<2)>>2];r=+g[_+((Y|4)<<2)>>2];o=+g[_+((V|8)<<2)>>2];m=+g[_+((Y|8)<<2)>>2];a=0;e=0;do{_=e<<1;h=+g[Fa+336+(_<<2)>>2];j=+g[Fa+336+((_|1)<<2)>>2];ya=(M*C+A*w+B*x)*v*(h-U)-(T*C+R*w+S*x)*v*(j-P);Ea=(T*D+R*y+S*z)*v*(j-P)-(M*D+A*y+B*z)*v*(h-U);_=a*3|0;za=$+ya*s+Ea*p;g[Fa+240+(_<<2)>>2]=za;Da=Z+ya*q+Ea*r;g[Fa+240+(_+1<<2)>>2]=Da;Ea=X+ya*o+Ea*m;g[Fa+240+(_+2<<2)>>2]=Ea;Ea=t-(ca*za+ba*Da+aa*Ea);g[Fa+208+(a<<2)>>2]=Ea;if(Ea>=0.0){_=a<<1;g[Fa+336+(_<<2)>>2]=h;g[Fa+336+((_|1)<<2)>>2]=j;a=a+1|0}e=e+1|0}while((e|0)!=(f|0));b:do if((a|0)>=1){E=(a|0)<4?a:4;E=(E|0)<1?1:E;if((a|0)<=(E|0))if(da){f=ga+8|0;j=-(c[k>>2]=Ba,+g[k>>2]);h=-(c[k>>2]=Ca,+g[k>>2]);e=0;while(1){Ca=e*3|0;g[Fa+528>>2]=+g[Fa+240+(Ca<<2)>>2]+ +g[ga>>2];g[Fa+528+4>>2]=+g[Fa+240+(Ca+1<<2)>>2]+ +g[ea>>2];g[Fa+528+8>>2]=+g[Fa+240+(Ca+2<<2)>>2]+ +g[f>>2];Ca=c[(c[d>>2]|0)+16>>2]|0;g[Fa+192>>2]=-fa;g[Fa+192+4>>2]=j;g[Fa+192+8>>2]=h;g[Fa+192+12>>2]=0.0;Yb[Ca&15](d,Fa+192|0,Fa+528|0,-+g[Fa+208+(e<<2)>>2]);e=e+1|0;if((e|0)==(a|0))break b}}else{f=ga+8|0;j=(c[k>>2]=Ba,+g[k>>2]);h=(c[k>>2]=Ca,+g[k>>2]);e=0;while(1){Ca=e*3|0;Ea=+g[Fa+208+(e<<2)>>2];g[Fa+528>>2]=+g[Fa+240+(Ca<<2)>>2]+ +g[ga>>2]-fa*Ea;g[Fa+528+4>>2]=+g[Fa+240+(Ca+1<<2)>>2]+ +g[ea>>2]-j*Ea;g[Fa+528+8>>2]=+g[Fa+240+(Ca+2<<2)>>2]+ +g[f>>2]-h*Ea;Ca=c[(c[d>>2]|0)+16>>2]|0;g[Fa+176>>2]=-fa;g[Fa+176+4>>2]=-j;g[Fa+176+8>>2]=-h;g[Fa+176+12>>2]=0.0;Yb[Ca&15](d,Fa+176|0,Fa+528|0,-Ea);e=e+1|0;if((e|0)==(a|0))break b}}c:do if((a|0)>1){f=1;l=0;j=+g[Fa+208>>2];while(1){h=+g[Fa+208+(f<<2)>>2];e=h>j;l=e?f:l;f=f+1|0;if((f|0)==(a|0))break;else j=e?h:j}switch(a|0){case 1:{e=Fa+144|0;f=Fa+144|0;a=1;Aa=111;break c}case 2:{e=Fa+144|0;f=Fa+144|0;a=2;j=(+g[Fa+336>>2]+ +g[Fa+336+8>>2])*.5;h=(+g[Fa+336+4>>2]+ +g[Fa+336+12>>2])*.5;Aa=116;break c}default:{}}e=a+-1|0;h=0.0;j=0.0;r=0.0;f=0;do{_=f<<1;ya=+g[Fa+336+(_<<2)>>2];za=+g[Fa+336+(_+3<<2)>>2];Da=+g[Fa+336+(_+2<<2)>>2];Ea=+g[Fa+336+((_|1)<<2)>>2];h=h+(ya*za-Da*Ea);j=j+(ya+Da)*(ya*za-Da*Ea);r=r+(za+Ea)*(ya*za-Da*Ea);f=f+1|0}while((f|0)!=(e|0));_=a<<1;m=+g[Fa+336+(_+-2<<2)>>2];o=+g[Fa+336+4>>2];p=+g[Fa+336>>2];q=+g[Fa+336+(_+-1<<2)>>2];h=h+(m*o-p*q);if(+N(+h)>1.1920928955078125e-07)h=1.0/(h*3.0);else h=999999984306749440.0;if((a|0)>0){u=Fa+144|0;f=Fa+144|0;n=Fa+528|0;j=h*(j+(m*o-p*q)*(m+p));h=h*(r+(m*o-p*q)*(q+o));Aa=119;break}e=Fa+144|0;f=0;u=a}else{e=Fa+144|0;f=Fa+144|0;l=0;Aa=111}while(0);if((Aa|0)==111){j=+g[Fa+336>>2];h=+g[Fa+336+4>>2];Aa=116}if((Aa|0)==116){u=e;n=Fa+528|0;Aa=119}if((Aa|0)==119){e=0;do{Aa=e<<1;g[Fa+528+(e<<2)>>2]=+W(+(+g[Fa+336+((Aa|1)<<2)>>2]-h),+(+g[Fa+336+(Aa<<2)>>2]-j));e=e+1|0}while((e|0)!=(a|0));e=0;do{c[Fa+496+(e<<2)>>2]=1;e=e+1|0}while((e|0)!=(a|0));e=u;f=1;u=a}a=Fa+496+(l<<2)|0;c[a>>2]=0;c[e>>2]=l;d:do if((E|0)>1){o=+g[Fa+528+(l<<2)>>2];if(f){f=Fa+144+4|0;n=1}else{e=Fa+144+4|0;f=1;while(1){c[e>>2]=l;c[a>>2]=0;f=f+1|0;if((f|0)==(E|0))break d;else e=e+4|0}}while(1){m=6.2831854820251465/+(E|0)*+(n|0)+o;m=m>3.1415927410125732?m+-6.2831854820251465:m;c[f>>2]=l;e=l;a=0;j=1.0e9;while(1){do if(!(c[Fa+496+(a<<2)>>2]|0))h=j;else{h=+N(+(+g[Fa+528+(a<<2)>>2]-m));h=h>3.1415927410125732?6.2831854820251465-h:h;if(!(h<j)){h=j;break}c[f>>2]=a;e=a}while(0);a=a+1|0;if((a|0)==(u|0))break;else j=h}c[Fa+496+(e<<2)>>2]=0;n=n+1|0;if((n|0)==(E|0))break;else f=f+4|0}}while(0);if((E|0)>0){f=ga+8|0;j=(c[k>>2]=Ba,+g[k>>2]);h=(c[k>>2]=Ca,+g[k>>2]);if(da){e=0;do{Ca=c[Fa+144+(e<<2)>>2]|0;g[Fa+528>>2]=+g[Fa+240+(Ca*3<<2)>>2]+ +g[ga>>2];g[Fa+528+4>>2]=+g[Fa+240+((Ca*3|0)+1<<2)>>2]+ +g[ea>>2];g[Fa+528+8>>2]=+g[Fa+240+((Ca*3|0)+2<<2)>>2]+ +g[f>>2];Ba=c[(c[d>>2]|0)+16>>2]|0;g[Fa+128>>2]=-fa;g[Fa+128+4>>2]=-j;g[Fa+128+8>>2]=-h;g[Fa+128+12>>2]=0.0;Yb[Ba&15](d,Fa+128|0,Fa+528|0,-+g[Fa+208+(Ca<<2)>>2]);e=e+1|0}while((e|0)<(E|0))}else{e=0;do{Ba=c[Fa+144+(e<<2)>>2]|0;ya=+g[Fa+240+(Ba*3<<2)>>2]+ +g[ga>>2];g[Fa+528>>2]=ya;za=+g[Fa+240+((Ba*3|0)+1<<2)>>2]+ +g[ea>>2];g[Fa+528+4>>2]=za;Da=+g[Fa+240+((Ba*3|0)+2<<2)>>2]+ +g[f>>2];g[Fa+528+8>>2]=Da;Ca=c[(c[d>>2]|0)+16>>2]|0;g[Fa+112>>2]=-fa;g[Fa+112+4>>2]=-j;g[Fa+112+8>>2]=-h;g[Fa+112+12>>2]=0.0;Ea=+g[Fa+208+(Ba<<2)>>2];g[Fa+96>>2]=ya-fa*Ea;g[Fa+96+4>>2]=za-Ea*j;g[Fa+96+8>>2]=Da-Ea*h;g[Fa+96+12>>2]=0.0;Yb[Ca&15](d,Fa+112|0,Fa+96|0,-Ea);e=e+1|0}while((e|0)<(E|0))}}}while(0)}i=Fa;return}function ye(b){b=b|0;var d=0;c[b>>2]=3064;d=c[b+20>>2]|0;if(d|0){if(a[b+24>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;return}function ze(b){b=b|0;var d=0;c[b>>2]=3064;d=c[b+20>>2]|0;if(!d){rG(b);return}if(!(a[b+24>>0]|0)){rG(b);return}c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0);rG(b);return}function Ae(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+16|0;c[f>>2]=a;c[f+4>>2]=e;a=c[a+72+((c[(c[b+4>>2]|0)+4>>2]|0)*144|0)+(c[(c[d+4>>2]|0)+4>>2]<<2)>>2]|0;a=zb[c[(c[a>>2]|0)+8>>2]&31](a,f,b,d)|0;i=f;return a|0}function Be(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0.0,l=0,m=0,n=0,o=0.0;n=i;i=i+16|0;c[4989]=(c[4989]|0)+1;if(!(c[b+4>>2]&2))f=6988;else{f=c[d+192>>2]|0;o=+Tb[c[(c[f>>2]|0)+20>>2]&1](f,.019999999552965164);g[n+4>>2]=o;f=c[e+192>>2]|0;k=+Tb[c[(c[f>>2]|0)+20>>2]&1](f,.019999999552965164);g[n>>2]=k;f=o<k?n+4|0:n}j=c[f>>2]|0;o=+g[d+184>>2];k=+g[e+184>>2];k=o<k?o:k;f=c[b+68>>2]|0;h=c[f+8>>2]|0;if(!h){if(c[b+4>>2]&4|0){b=0;i=n;return b|0}c[5637]=(c[5637]|0)+1;f=qG(791)|0;if(!f)l=0;else{c[(f+4+15&-16)+-4>>2]=f;l=f+4+15&-16}}else{l=c[f+12>>2]|0;c[f+12>>2]=c[l>>2];c[f+8>>2]=h+-1}c[l>>2]=1025;c[l+116>>2]=0;a[l+120>>0]=0;f=l+124|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;c[l+300>>2]=0;a[l+304>>0]=0;f=l+308|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;c[l+484>>2]=0;a[l+488>>0]=0;f=l+492|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;c[l+668>>2]=0;a[l+672>>0]=0;f=l+676|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;c[l+740>>2]=d;c[l+744>>2]=e;c[l+748>>2]=0;c[l+752>>2]=j;g[l+756>>2]=k;d=l;f=c[b+12>>2]|0;c[l+768>>2]=f;if((f|0)==(c[b+16>>2]|0)?(m=f|0?f<<1:1,(f|0)<(m|0)):0){if(!m)j=0;else{c[5637]=(c[5637]|0)+1;f=qG((m<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}j=f;f=c[b+12>>2]|0}if((f|0)>0){h=0;do{c[j+(h<<2)>>2]=c[(c[b+20>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(f|0))}h=c[b+20>>2]|0;if(h){if(a[b+24>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0);f=c[b+12>>2]|0}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=j;c[b+16>>2]=m}c[(c[b+20>>2]|0)+(f<<2)>>2]=d;c[b+12>>2]=f+1;b=l;i=n;return b|0}function Ce(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;c[4989]=(c[4989]|0)+-1;tb[c[(c[a>>2]|0)+20>>2]&127](a,b);e=c[b+768>>2]|0;d=(c[a+12>>2]|0)+-1|0;g=c[a+20>>2]|0;f=c[g+(e<<2)>>2]|0;c[g+(e<<2)>>2]=c[g+(d<<2)>>2];c[(c[a+20>>2]|0)+(d<<2)>>2]=f;c[(c[(c[a+20>>2]|0)+(e<<2)>>2]|0)+768>>2]=e;c[a+12>>2]=d;a=c[a+68>>2]|0;if(!b)return;g=c[a+16>>2]|0;if(g>>>0<=b>>>0?(g+(_(c[a>>2]|0,c[a+4>>2]|0)|0)|0)>>>0>b>>>0:0){c[b>>2]=c[a+12>>2];c[a+12>>2]=b;c[a+8>>2]=(c[a+8>>2]|0)+1;return}c[5638]=(c[5638]|0)+1;rG(c[b+-4>>2]|0);return}function De(a,b){a=a|0;b=b|0;c[b+748>>2]=0;return}function Ee(a,b,d){a=a|0;b=b|0;d=d|0;a:do switch(c[b+216>>2]|0){case 2:case 5:{switch(c[d+216>>2]|0){case 2:case 5:{b=0;break}default:break a}return b|0}default:{}}while(0);if(!((c[b+260>>2]|0)!=0?!(Ob[c[(c[b>>2]|0)+12>>2]&31](b,d)|0):0)){if(!(c[d+260>>2]|0)){a=1;return a|0}if(Ob[c[(c[d>>2]|0)+12>>2]&31](d,b)|0){a=1;return a|0}}a=0;return a|0}function Fe(a,b,d){a=a|0;b=b|0;d=d|0;a=c[b+204>>2]|0;if(a&4|0){d=0;return d|0}b=c[d+204>>2]|0;if(b&4|0){d=0;return d|0}if(!(a&3)){d=1;return d|0}d=(b&3|0)==0;return d|0}function Ge(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+16|0;c[f>>2]=3136;c[f+4>>2]=d;c[f+8>>2]=a;Zb[c[(c[b>>2]|0)+48>>2]&127](b,f,e);i=f;return}function He(a){a=a|0;rG(a);return}function Ie(a,b){a=a|0;b=b|0;var d=0;d=c[a+8>>2]|0;Zb[c[d+60>>2]&127](b,d,c[a+4>>2]|0);return 0}function Je(a){a=a|0;return c[a+12>>2]|0}function Ke(a,b){a=a|0;b=b|0;return c[(c[a+20>>2]|0)+(b<<2)>>2]|0}function Le(a){a=a|0;if(!(c[a+12>>2]|0)){a=0;return a|0}a=c[a+20>>2]|0;return a|0}function Me(a){a=a|0;return c[a+68>>2]|0}function Ne(a){a=a|0;return c[a+68>>2]|0}function Oe(a,b){a=a|0;b=b|0;var d=0;a=c[a+64>>2]|0;d=c[a+8>>2]|0;if(d|0){b=c[a+12>>2]|0;c[a+12>>2]=c[b>>2];c[a+8>>2]=d+-1;return b|0}c[5637]=(c[5637]|0)+1;a=qG(b+19|0)|0;if(!a){b=0;return b|0}c[(a+4+15&-16)+-4>>2]=a;b=a+4+15&-16;return b|0}function Pe(a,b){a=a|0;b=b|0;var d=0;a=c[a+64>>2]|0;if(!b)return;d=c[a+16>>2]|0;if(d>>>0<=b>>>0?(d+(_(c[a>>2]|0,c[a+4>>2]|0)|0)|0)>>>0>b>>>0:0){c[b>>2]=c[a+12>>2];c[a+12>>2]=b;c[a+8>>2]=(c[a+8>>2]|0)+1;return}c[5638]=(c[5638]|0)+1;rG(c[b+-4>>2]|0);return}function Qe(b,d){b=b|0;d=d|0;var e=0,f=0;c[b>>2]=3064;c[b+4>>2]=2;a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;c[b+28>>2]=4460;c[b+5256>>2]=d;c[b+60>>2]=70;c[b+64>>2]=vb[c[(c[d>>2]|0)+12>>2]&127](d)|0;c[b+68>>2]=vb[c[(c[d>>2]|0)+8>>2]&127](d)|0;d=0;do{e=0;do{f=c[b+5256>>2]|0;c[b+72+(d*144|0)+(e<<2)>>2]=Eb[c[(c[f>>2]|0)+16>>2]&63](f,d,e)|0;e=e+1|0}while((e|0)<36);d=d+1|0}while((d|0)<36);return}function Re(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0,j=0,k=0,l=0;l=i;i=i+80|0;h=c[c[a>>2]>>2]|0;j=c[c[a+4>>2]>>2]|0;if(!(Eb[c[(c[b>>2]|0)+24>>2]&63](b,h,j)|0)){i=l;return}f=c[h+192>>2]|0;c[l+56>>2]=0;c[l+56+4>>2]=f;c[l+56+8>>2]=h;c[l+56+12>>2]=h+4;c[l+56+16>>2]=-1;c[l+56+20>>2]=-1;f=c[j+192>>2]|0;c[l+32>>2]=0;c[l+32+4>>2]=f;c[l+32+8>>2]=j;c[l+32+12>>2]=j+4;c[l+32+16>>2]=-1;c[l+32+20>>2]=-1;f=c[a+8>>2]|0;if(!f){f=zb[c[(c[b>>2]|0)+8>>2]&31](b,l+56|0,l+32|0,0)|0;c[a+8>>2]=f;if(f|0)k=4}else k=4;if((k|0)==4){c[l>>2]=4460;c[l+4>>2]=0;c[l+8>>2]=l+56;c[l+12>>2]=l+32;if((c[d+8>>2]|0)!=1){e=+Db[c[(c[f>>2]|0)+12>>2]&15](f,h,j,d,l);if(+g[d+12>>2]>e)g[d+12>>2]=e}else pb[c[(c[f>>2]|0)+8>>2]&31](f,l+56|0,l+32|0,d,l)}i=l;return}function Se(b){b=b|0;var d=0;c[b>>2]=3156;d=c[b+276>>2]|0;if(d|0){if(a[b+280>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0;return}function Te(b){b=b|0;var d=0;c[b>>2]=3156;d=c[b+276>>2]|0;if(d|0){if(a[b+280>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0;c[5638]=(c[5638]|0)+1;rG(c[b+-4>>2]|0);return}function Ue(a,b){a=a|0;b=b|0;c[a+284>>2]=(c[a+284>>2]|0)+1;c[a+192>>2]=b;c[a+200>>2]=b;return}function Ve(a,b){a=a|0;b=b|0;var d=0,e=0;e=c[a+268>>2]|0;a:do if((e|0)>0){d=c[a+276>>2]|0;a=0;while(1){if((c[d+(a<<2)>>2]|0)==(b|0))break a;a=a+1|0;if((a|0)>=(e|0)){a=e;break}}}else a=e;while(0);return (a|0)>=(e|0)|0}function We(a){a=a|0;return 256}function Xe(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;c[b+16>>2]=c[a+4>>2];c[b+20>>2]=c[a+8>>2];c[b+24>>2]=c[a+12>>2];c[b+28>>2]=c[a+16>>2];c[b+32>>2]=c[a+20>>2];c[b+36>>2]=c[a+24>>2];c[b+40>>2]=c[a+28>>2];c[b+44>>2]=c[a+32>>2];c[b+48>>2]=c[a+36>>2];c[b+52>>2]=c[a+40>>2];c[b+56>>2]=c[a+44>>2];c[b+60>>2]=c[a+48>>2];c[b+64>>2]=c[a+52>>2];c[b+68>>2]=c[a+56>>2];c[b+72>>2]=c[a+60>>2];c[b+76>>2]=c[a+64>>2];c[b+80>>2]=c[a+68>>2];c[b+84>>2]=c[a+72>>2];c[b+88>>2]=c[a+76>>2];c[b+92>>2]=c[a+80>>2];c[b+96>>2]=c[a+84>>2];c[b+100>>2]=c[a+88>>2];c[b+104>>2]=c[a+92>>2];c[b+108>>2]=c[a+96>>2];c[b+112>>2]=c[a+100>>2];c[b+116>>2]=c[a+104>>2];c[b+120>>2]=c[a+108>>2];c[b+124>>2]=c[a+112>>2];c[b+128>>2]=c[a+116>>2];c[b+132>>2]=c[a+120>>2];c[b+136>>2]=c[a+124>>2];c[b+140>>2]=c[a+128>>2];c[b+144>>2]=c[a+132>>2];c[b+148>>2]=c[a+136>>2];c[b+152>>2]=c[a+140>>2];c[b+156>>2]=c[a+144>>2];c[b+160>>2]=c[a+148>>2];c[b+164>>2]=c[a+152>>2];c[b+168>>2]=c[a+156>>2];c[b+172>>2]=c[a+160>>2];c[b+176>>2]=c[a+164>>2];c[b+180>>2]=c[a+168>>2];c[b+184>>2]=c[a+172>>2];c[b+188>>2]=c[a+176>>2];c[b+224>>2]=c[a+180>>2];c[b+192>>2]=c[a+184>>2];c[b>>2]=0;c[b+4>>2]=Ob[c[(c[d>>2]|0)+28>>2]&31](d,c[a+192>>2]|0)|0;c[b+8>>2]=0;c[b+228>>2]=c[a+204>>2];c[b+232>>2]=c[a+208>>2];c[b+236>>2]=c[a+212>>2];c[b+240>>2]=c[a+216>>2];c[b+196>>2]=c[a+220>>2];c[b+200>>2]=c[a+224>>2];c[b+204>>2]=c[a+232>>2];c[b+208>>2]=c[a+228>>2];c[b+244>>2]=c[a+236>>2];e=Ob[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=Ob[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b+12>>2]=f;if(!f){d=a+248|0;d=c[d>>2]|0;f=b+212|0;c[f>>2]=d;f=a+252|0;f=c[f>>2]|0;d=b+216|0;c[d>>2]=f;d=a+256|0;d=c[d>>2]|0;f=b+220|0;c[f>>2]=d;a=a+260|0;a=c[a>>2]|0;f=b+248|0;c[f>>2]=a;return 9250}tb[c[(c[d>>2]|0)+48>>2]&127](d,e);d=a+248|0;d=c[d>>2]|0;f=b+212|0;c[f>>2]=d;f=a+252|0;f=c[f>>2]|0;d=b+216|0;c[d>>2]=f;d=a+256|0;d=c[d>>2]|0;f=b+220|0;c[f>>2]=d;a=a+260|0;a=c[a>>2]|0;f=b+248|0;c[f>>2]=a;return 9250}function Ye(a,b){a=a|0;b=b|0;var d=0,e=0;e=vb[c[(c[a>>2]|0)+16>>2]&127](a)|0;e=Eb[c[(c[b>>2]|0)+16>>2]&63](b,e,1)|0;d=Eb[c[(c[a>>2]|0)+20>>2]&63](a,c[e+8>>2]|0,b)|0;pb[c[(c[b>>2]|0)+20>>2]&31](b,e,d,1245859651,a);return}function Ze(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;c[b>>2]=3192;e=c[b+8>>2]|0;d=c[b+16>>2]|0;if((e|0)>0){h=0;do{f=(c[d+(h<<2)>>2]|0)+188|0;g=c[f>>2]|0;if(g){e=c[b+68>>2]|0;e=vb[c[(c[e>>2]|0)+36>>2]&127](e)|0;Zb[c[(c[e>>2]|0)+40>>2]&127](e,g,c[b+24>>2]|0);e=c[b+68>>2]|0;Zb[c[(c[e>>2]|0)+12>>2]&127](e,g,c[b+24>>2]|0);c[f>>2]=0;e=c[b+8>>2]|0;d=c[b+16>>2]|0}h=h+1|0}while((h|0)<(e|0))}if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}if(a[b+20>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}function _e(a){a=a|0;Ze(a);rG(a);return}function $e(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0,r=0,s=0;s=i;i=i+64|0;fs(9296);d=c[b+8>>2]|0;if((d|0)>0){p=0;do{o=c[(c[b+16>>2]|0)+(p<<2)>>2]|0;if(!(a[b+76>>0]|0))switch(c[o+216>>2]|0){case 2:case 5:break;default:r=11}else r=11;if((r|0)==11){r=0;d=c[o+192>>2]|0;bc[c[(c[d>>2]|0)+8>>2]&127](d,o+4|0,s+48|0,s+32|0);k=+g[s+48>>2]+-.019999999552965164;g[s+48>>2]=k;l=+g[s+48+4>>2]+-.019999999552965164;g[s+48+4>>2]=l;j=+g[s+48+8>>2]+-.019999999552965164;g[s+48+8>>2]=j;e=+g[s+32>>2]+.019999999552965164;g[s+32>>2]=e;f=+g[s+32+4>>2]+.019999999552965164;g[s+32+4>>2]=f;h=+g[s+32+8>>2]+.019999999552965164;g[s+32+8>>2]=h;if(((a[b+44>>0]|0)!=0?(c[o+236>>2]|0)==2:0)?(c[o+204>>2]&3|0)==0:0){d=c[o+192>>2]|0;bc[c[(c[d>>2]|0)+8>>2]&127](d,o+68|0,s+16|0,s);k=+g[s+16>>2]+-.019999999552965164;g[s+16>>2]=k;l=+g[s+16+4>>2]+-.019999999552965164;g[s+16+4>>2]=l;f=+g[s+16+8>>2]+-.019999999552965164;g[s+16+8>>2]=f;h=+g[s>>2]+.019999999552965164;g[s>>2]=h;j=+g[s+4>>2]+.019999999552965164;g[s+4>>2]=j;m=+g[s+8>>2]+.019999999552965164;g[s+8>>2]=m;e=+g[s+48>>2];if(k<e)g[s+48>>2]=k;else k=e;e=+g[s+48+4>>2];if(l<e)g[s+48+4>>2]=l;else l=e;e=+g[s+48+8>>2];if(f<e){g[s+48+8>>2]=f;n=f}else n=e;e=+g[s+16+12>>2];if(e<+g[s+48+12>>2])g[s+48+12>>2]=e;e=+g[s+32>>2];if(e<h){g[s+32>>2]=h;e=h}f=+g[s+32+4>>2];if(f<j){g[s+32+4>>2]=j;f=j}h=+g[s+32+8>>2];if(h<m){g[s+32+8>>2]=m;h=m}j=+g[s+12>>2];if(+g[s+32+12>>2]<j)g[s+32+12>>2]=j;j=n}d=c[b+68>>2]|0;if((c[o+204>>2]&1|0)==0?(k=e-k,m=f-l,n=h-j,!(k*k+m*m+n*n<999999995904.0)):0){if((c[o+216>>2]&-2|0)!=4)c[o+216>>2]=5;if(a[9308]|0?(q=c[b+72>>2]|0,q|0):0){a[9308]=0;tb[c[(c[q>>2]|0)+44>>2]&127](q,9309);o=c[b+72>>2]|0;tb[c[(c[o>>2]|0)+44>>2]&127](o,9358);o=c[b+72>>2]|0;tb[c[(c[o>>2]|0)+44>>2]&127](o,9426);o=c[b+72>>2]|0;tb[c[(c[o>>2]|0)+44>>2]&127](o,9491)}}else pb[c[(c[d>>2]|0)+16>>2]&31](d,c[o+188>>2]|0,s+48|0,s+32|0,c[b+24>>2]|0);d=c[b+8>>2]|0}p=p+1|0}while((p|0)<(d|0))}d=c[2006]|0;r=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=r;if(r|0){i=s;return}do if(c[d+4>>2]|0){kb(s+48|0,0)|0;r=c[5649]|0;g[d+8>>2]=+g[d+8>>2]+ +(((c[s+48+4>>2]|0)-(c[r+4>>2]|0)+(((c[s+48>>2]|0)-(c[r>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[d+16>>2]|0)){d=c[2006]|0;break}else{i=s;return}}while(0);c[2006]=c[d+20>>2];i=s;return}function af(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;fs(9500);d=c[a+68>>2]|0;tb[c[(c[d>>2]|0)+32>>2]&127](d,c[a+24>>2]|0);a=c[2006]|0;d=(c[a+16>>2]|0)+-1|0;c[a+16>>2]=d;if(d|0){i=b;return}do if(c[a+4>>2]|0){kb(b|0,0)|0;d=c[5649]|0;g[a+8>>2]=+g[a+8>>2]+ +(((c[b+4>>2]|0)-(c[d+4>>2]|0)+(((c[b>>2]|0)-(c[d>>2]|0)|0)*1e6|0)-(c[a+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[a+16>>2]|0)){a=c[2006]|0;break}else{i=b;return}}while(0);c[2006]=c[a+20>>2];i=b;return}function bf(a,b){a=a|0;b=b|0;c[a+72>>2]=b;return}function cf(a){a=a|0;return c[a+72>>2]|0}function df(b){b=b|0;var d=0.0,e=0,f=0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0;q=i;i=i+192|0;if(!(vb[c[(c[b>>2]|0)+20>>2]&127](b)|0)){i=q;return}j=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;tb[c[(c[j>>2]|0)+8>>2]&127](q+80|0,j);j=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;if(((vb[c[(c[j>>2]|0)+56>>2]&127](j)|0)&8|0?(e=c[b+24>>2]|0,e|0):0)?(k=vb[c[(c[e>>2]|0)+36>>2]&127](e)|0,(k|0)>0):0){h=0;do{e=c[b+24>>2]|0;e=Ob[c[(c[e>>2]|0)+40>>2]&31](e,h)|0;f=c[e+748>>2]|0;if((f|0)>0){j=0;do{r=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;sb[c[(c[r>>2]|0)+40>>2]&0](r,e+4+(j*184|0)+32|0,e+4+(j*184|0)+64|0,+g[e+4+(j*184|0)+80>>2],c[e+4+(j*184|0)+148>>2]|0,q+80+96|0);j=j+1|0}while((j|0)!=(f|0))}h=h+1|0}while((h|0)!=(k|0))}r=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0;if((vb[c[(c[r>>2]|0)+56>>2]&127](r)|0)&3|0?(c[b+8>>2]|0)>0:0){h=0;do{f=c[(c[b+16>>2]|0)+(h<<2)>>2]|0;if(!(c[f+204>>2]&32)){if(vb[c[(c[b>>2]|0)+20>>2]&127](b)|0?(r=vb[c[(c[b>>2]|0)+20>>2]&127](b)|0,(vb[c[(c[r>>2]|0)+56>>2]&127](r)|0)&1|0):0){c[q+64>>2]=1053609165;c[q+64+4>>2]=1053609165;c[q+64+8>>2]=1053609165;g[q+64+12>>2]=0.0;switch(c[f+216>>2]|0){case 1:{c[q+64>>2]=c[q+80>>2];c[q+64+4>>2]=c[q+80+4>>2];c[q+64+8>>2]=c[q+80+8>>2];c[q+64+12>>2]=c[q+80+12>>2];break}case 2:{c[q+64>>2]=c[q+80+16>>2];c[q+64+4>>2]=c[q+80+16+4>>2];c[q+64+8>>2]=c[q+80+16+8>>2];c[q+64+12>>2]=c[q+80+16+12>>2];break}case 3:{c[q+64>>2]=c[q+80+32>>2];c[q+64+4>>2]=c[q+80+32+4>>2];c[q+64+8>>2]=c[q+80+32+8>>2];c[q+64+12>>2]=c[q+80+32+12>>2];break}case 4:{c[q+64>>2]=c[q+80+48>>2];c[q+64+4>>2]=c[q+80+48+4>>2];c[q+64+8>>2]=c[q+80+48+8>>2];c[q+64+12>>2]=c[q+80+48+12>>2];break}case 5:{c[q+64>>2]=c[q+80+64>>2];c[q+64+4>>2]=c[q+80+64+4>>2];c[q+64+8>>2]=c[q+80+64+8>>2];c[q+64+12>>2]=c[q+80+64+12>>2];break}default:{c[q+64>>2]=1050253722;c[q+64+4>>2]=1050253722;c[q+64+8>>2]=1050253722;g[q+64+12>>2]=0.0}}bc[c[(c[b>>2]|0)+28>>2]&127](b,f+4|0,c[f+192>>2]|0,q+64|0)}e=c[b+72>>2]|0;if(e|0?(vb[c[(c[e>>2]|0)+56>>2]&127](e)|0)&2|0:0){c[q+32>>2]=c[q+80+80>>2];c[q+32+4>>2]=c[q+80+80+4>>2];c[q+32+8>>2]=c[q+80+80+8>>2];c[q+32+12>>2]=c[q+80+80+12>>2];r=c[f+192>>2]|0;bc[c[(c[r>>2]|0)+8>>2]&127](r,f+4|0,q+64|0,q+48|0);g[q+64>>2]=+g[q+64>>2]+-.019999999552965164;g[q+64+4>>2]=+g[q+64+4>>2]+-.019999999552965164;g[q+64+8>>2]=+g[q+64+8>>2]+-.019999999552965164;g[q+48>>2]=+g[q+48>>2]+.019999999552965164;g[q+48+4>>2]=+g[q+48+4>>2]+.019999999552965164;g[q+48+8>>2]=+g[q+48+8>>2]+.019999999552965164;do if((a[b+44>>0]|0?(c[f+236>>2]|0)==2:0)?(c[f+204>>2]&3|0)==0:0){r=c[f+192>>2]|0;bc[c[(c[r>>2]|0)+8>>2]&127](r,f+68|0,q+16|0,q);d=+g[q+16>>2]+-.019999999552965164;g[q+16>>2]=d;l=+g[q+16+4>>2]+-.019999999552965164;g[q+16+4>>2]=l;m=+g[q+16+8>>2]+-.019999999552965164;g[q+16+8>>2]=m;n=+g[q>>2]+.019999999552965164;g[q>>2]=n;o=+g[q+4>>2]+.019999999552965164;g[q+4>>2]=o;p=+g[q+8>>2]+.019999999552965164;g[q+8>>2]=p;if(d<+g[q+64>>2])g[q+64>>2]=d;if(l<+g[q+64+4>>2])g[q+64+4>>2]=l;if(m<+g[q+64+8>>2])g[q+64+8>>2]=m;d=+g[q+16+12>>2];if(d<+g[q+64+12>>2])g[q+64+12>>2]=d;if(+g[q+48>>2]<n)g[q+48>>2]=n;if(+g[q+48+4>>2]<o)g[q+48+4>>2]=o;if(+g[q+48+8>>2]<p)g[q+48+8>>2]=p;d=+g[q+12>>2];if(!(+g[q+48+12>>2]<d))break;g[q+48+12>>2]=d}while(0);r=c[b+72>>2]|0;bc[c[(c[r>>2]|0)+60>>2]&127](r,q+64|0,q+48|0,q+32|0)}}h=h+1|0}while((h|0)<(c[b+8>>2]|0))}i=q;return}function ef(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0;u=i;i=i+368|0;if(vb[c[(c[a>>2]|0)+20>>2]&127](a)|0?(s=vb[c[(c[a>>2]|0)+20>>2]&127](a)|0,(vb[c[(c[s>>2]|0)+56>>2]&127](s)|0)&32768|0):0){s=vb[c[(c[a>>2]|0)+20>>2]&127](a)|0;$b[c[(c[s>>2]|0)+64>>2]&7](s,b,1.0)}f=c[d+4>>2]|0;switch(f|0){case 31:{f=c[d+20>>2]|0;if((f|0)<=0){i=u;return}do{t=f;f=f+-1|0;s=c[d+28>>2]|0;J=+g[s+(f*80|0)>>2];G=+g[s+(f*80|0)+4>>2];D=+g[s+(f*80|0)+8>>2];I=+g[s+(f*80|0)+16>>2];F=+g[s+(f*80|0)+20>>2];B=+g[s+(f*80|0)+24>>2];H=+g[s+(f*80|0)+32>>2];E=+g[s+(f*80|0)+36>>2];z=+g[s+(f*80|0)+40>>2];R=+g[s+(f*80|0)+48>>2];Q=+g[s+(f*80|0)+52>>2];v=+g[s+(f*80|0)+56>>2];s=c[s+(f*80|0)+64>>2]|0;r=c[(c[a>>2]|0)+28>>2]|0;P=+g[b>>2];O=+g[b+4>>2];N=+g[b+8>>2];M=+g[b+16>>2];L=+g[b+20>>2];K=+g[b+24>>2];C=+g[b+32>>2];A=+g[b+36>>2];y=+g[b+40>>2];x=R*P+Q*O+v*N+ +g[b+48>>2];w=R*M+Q*L+v*K+ +g[b+52>>2];v=R*C+Q*A+v*y+ +g[b+56>>2];g[u+304>>2]=J*P+I*O+H*N;g[u+304+4>>2]=G*P+F*O+E*N;g[u+304+8>>2]=D*P+B*O+z*N;g[u+304+12>>2]=0.0;g[u+304+16>>2]=J*M+I*L+H*K;g[u+304+20>>2]=G*M+F*L+E*K;g[u+304+24>>2]=D*M+B*L+z*K;g[u+304+28>>2]=0.0;g[u+304+32>>2]=J*C+I*A+H*y;g[u+304+36>>2]=G*C+F*A+E*y;g[u+304+40>>2]=D*C+B*A+z*y;g[u+304+44>>2]=0.0;g[u+304+48>>2]=x;g[u+304+52>>2]=w;g[u+304+56>>2]=v;g[u+304+60>>2]=0.0;bc[r&127](a,u+304|0,s,e)}while((t|0)>1);i=u;return}case 0:{c[u+288>>2]=c[d+32>>2];c[u+288+4>>2]=c[d+32+4>>2];c[u+288+8>>2]=c[d+32+8>>2];c[u+288+12>>2]=c[d+32+12>>2];P=+Hb[c[(c[d>>2]|0)+48>>2]&15](d);Q=+Hb[c[(c[d>>2]|0)+48>>2]&15](d);R=+Hb[c[(c[d>>2]|0)+48>>2]&15](d);P=P+ +g[u+288>>2];g[u+288>>2]=P;Q=Q+ +g[u+288+4>>2];g[u+288+4>>2]=Q;R=R+ +g[u+288+8>>2];g[u+288+8>>2]=R;a=vb[c[(c[a>>2]|0)+20>>2]&127](a)|0;d=c[(c[a>>2]|0)+80>>2]|0;g[u+272>>2]=-P;g[u+272+4>>2]=-Q;g[u+272+8>>2]=-R;g[u+272+12>>2]=0.0;pb[d&31](a,u+272|0,u+288|0,b,e);i=u;return}case 8:{R=+Hb[c[(c[d>>2]|0)+48>>2]&15](d);a=vb[c[(c[a>>2]|0)+20>>2]&127](a)|0;yb[c[(c[a>>2]|0)+24>>2]&0](a,R,b,e);i=u;return}case 9:{f=c[d+96>>2]|0;if((f|0)<=0){i=u;return}do{t=f;f=f+-1|0;s=c[d+104>>2]|0;D=+g[s+(f<<4)>>2];E=+g[s+(f<<4)+4>>2];Q=+g[s+(f<<4)+8>>2];s=vb[c[(c[a>>2]|0)+20>>2]&127](a)|0;r=c[(c[s>>2]|0)+24>>2]|0;R=+g[(c[d+124>>2]|0)+(f<<2)>>2];G=+g[b>>2];H=+g[b+4>>2];F=+g[b+8>>2];J=+g[b+16>>2];K=+g[b+20>>2];I=+g[b+24>>2];M=+g[b+32>>2];N=+g[b+36>>2];L=+g[b+40>>2];O=D*G+E*H+Q*F+ +g[b+48>>2];P=D*J+E*K+Q*I+ +g[b+52>>2];Q=D*M+E*N+Q*L+ +g[b+56>>2];g[u+192>>2]=G+H*0.0+F*0.0;g[u+192+4>>2]=G*0.0+H+F*0.0;g[u+192+8>>2]=F+(G*0.0+H*0.0);g[u+192+12>>2]=0.0;g[u+192+16>>2]=J+K*0.0+I*0.0;g[u+192+20>>2]=J*0.0+K+I*0.0;g[u+192+24>>2]=I+(J*0.0+K*0.0);g[u+192+28>>2]=0.0;g[u+192+32>>2]=M+N*0.0+L*0.0;g[u+192+36>>2]=M*0.0+N+L*0.0;g[u+192+40>>2]=L+(M*0.0+N*0.0);g[u+192+44>>2]=0.0;g[u+192+48>>2]=O;g[u+192+52>>2]=P;g[u+192+56>>2]=Q;g[u+192+60>>2]=0.0;yb[r&0](s,R,u+192|0,e)}while((t|0)>1);i=u;return}case 10:{t=c[d+56>>2]|0;Q=+g[d+32+(((t+2|0)%3|0)<<2)>>2];R=+g[d+32+(t<<2)>>2];a=vb[c[(c[a>>2]|0)+20>>2]&127](a)|0;xb[c[(c[a>>2]|0)+84>>2]&0](a,Q,R,t,b,e);i=u;return}case 11:{Q=+g[d+60>>2];R=+g[d+64>>2];d=c[d+72>>2]|0;a=vb[c[(c[a>>2]|0)+20>>2]&127](a)|0;xb[c[(c[a>>2]|0)+92>>2]&0](a,Q,R,d,b,e);i=u;return}case 13:{t=c[d+56>>2]|0;Q=+Hb[c[(c[d>>2]|0)+92>>2]&15](d);c[u+176>>2]=c[d+32>>2];c[u+176+4>>2]=c[d+32+4>>2];c[u+176+8>>2]=c[d+32+8>>2];c[u+176+12>>2]=c[d+32+12>>2];O=+Hb[c[(c[d>>2]|0)+48>>2]&15](d);P=+Hb[c[(c[d>>2]|0)+48>>2]&15](d);R=+Hb[c[(c[d>>2]|0)+48>>2]&15](d);g[u+176>>2]=O+ +g[u+176>>2];g[u+176+4>>2]=P+ +g[u+176+4>>2];g[u+176+8>>2]=R+ +g[u+176+8>>2];R=+g[u+176+(t<<2)>>2];a=vb[c[(c[a>>2]|0)+20>>2]&127](a)|0;xb[c[(c[a>>2]|0)+88>>2]&0](a,Q,R,t,b,e);i=u;return}case 28:{R=+g[d+68>>2];a=vb[c[(c[a>>2]|0)+20>>2]&127](a)|0;Kb[c[(c[a>>2]|0)+96>>2]&0](a,d+52|0,R,b,e);i=u;return}default:{a:do if((f|0)<7){q=c[d+56>>2]|0;if(!q){if((vb[c[(c[d>>2]|0)+100>>2]&127](d)|0)<=0)break;f=0;while(1){bc[c[(c[d>>2]|0)+104>>2]&127](d,f,u+288|0,u+256|0);P=+g[u+288>>2];D=+g[b>>2];N=+g[u+288+4>>2];E=+g[b+4>>2];L=+g[u+288+8>>2];F=+g[b+8>>2];H=+g[b+16>>2];I=+g[b+20>>2];J=+g[b+24>>2];M=+g[b+32>>2];O=+g[b+36>>2];Q=+g[b+40>>2];G=+g[b+48>>2];K=+g[b+52>>2];R=+g[b+56>>2];g[u+80>>2]=P*D+N*E+L*F+G;g[u+80+4>>2]=P*H+N*I+L*J+K;g[u+80+8>>2]=P*M+N*O+L*Q+R;g[u+80+12>>2]=0.0;L=+g[u+256>>2];N=+g[u+256+4>>2];P=+g[u+256+8>>2];g[u+48>>2]=L*D+N*E+P*F+G;g[u+48+4>>2]=L*H+N*I+P*J+K;g[u+48+8>>2]=L*M+N*O+P*Q+R;g[u+48+12>>2]=0.0;t=vb[c[(c[a>>2]|0)+20>>2]&127](a)|0;bc[c[(c[t>>2]|0)+16>>2]&127](t,u+80|0,u+48|0,e);f=f+1|0;if((f|0)>=(vb[c[(c[d>>2]|0)+100>>2]&127](d)|0))break a}}if((c[q+28>>2]|0)>0){s=0;do{f=c[q+36>>2]|0;r=c[f+(s*36|0)+4>>2]|0;b:do if((r|0)!=0?(t=c[f+(s*36|0)+12>>2]|0,(r|0)>0):0){m=t;j=0;h=0;f=0;o=c[t+(r+-1<<2)>>2]|0;l=0;while(1){p=c[m+(l<<2)>>2]|0;n=c[q+16>>2]|0;j=(g[k>>2]=(c[k>>2]=j,+g[k>>2])+ +g[n+(p<<4)>>2],c[k>>2]|0);f=(g[k>>2]=(c[k>>2]=f,+g[k>>2])+ +g[n+(p<<4)+4>>2],c[k>>2]|0);h=(g[k>>2]=(c[k>>2]=h,+g[k>>2])+ +g[n+(p<<4)+8>>2],c[k>>2]|0);n=vb[c[(c[a>>2]|0)+20>>2]&127](a)|0;m=c[(c[n>>2]|0)+16>>2]|0;S=c[q+16>>2]|0;P=+g[S+(o<<4)>>2];D=+g[b>>2];N=+g[S+(o<<4)+4>>2];E=+g[b+4>>2];L=+g[S+(o<<4)+8>>2];F=+g[b+8>>2];H=+g[b+16>>2];I=+g[b+20>>2];J=+g[b+24>>2];M=+g[b+32>>2];O=+g[b+36>>2];Q=+g[b+40>>2];G=+g[b+48>>2];K=+g[b+52>>2];R=+g[b+56>>2];g[u+64>>2]=P*D+N*E+L*F+G;g[u+64+4>>2]=P*H+N*I+L*J+K;g[u+64+8>>2]=P*M+N*O+L*Q+R;g[u+64+12>>2]=0.0;L=+g[S+(p<<4)>>2];N=+g[S+(p<<4)+4>>2];P=+g[S+(p<<4)+8>>2];g[u+32>>2]=L*D+N*E+P*F+G;g[u+32+4>>2]=L*H+N*I+P*J+K;g[u+32+8>>2]=L*M+N*O+P*Q+R;g[u+32+12>>2]=0.0;bc[m&127](n,u+64|0,u+32|0,e);n=l+1|0;l=c[q+36>>2]|0;if((n|0)>=(c[l+(s*36|0)+4>>2]|0))break b;m=c[l+(s*36|0)+12>>2]|0;o=p;l=n}}else{j=0;h=0;f=0}while(0);S=vb[c[(c[a>>2]|0)+20>>2]&127](a)|0;if((vb[c[(c[S>>2]|0)+56>>2]&127](S)|0)&16384|0){O=1.0/+(r|0)*(c[k>>2]=h,+g[k>>2]);L=1.0/+(r|0)*(c[k>>2]=f,+g[k>>2]);I=1.0/+(r|0)*(c[k>>2]=j,+g[k>>2]);c[u+288>>2]=1065353216;c[u+288+4>>2]=1065353216;c[u+288+8>>2]=0;g[u+288+12>>2]=0.0;S=c[q+36>>2]|0;J=+g[S+(s*36|0)+20>>2];M=+g[S+(s*36|0)+24>>2];P=+g[S+(s*36|0)+28>>2];S=vb[c[(c[a>>2]|0)+20>>2]&127](a)|0;r=c[(c[S>>2]|0)+16>>2]|0;A=+g[b>>2];B=+g[b+4>>2];C=+g[b+8>>2];E=+g[b+16>>2];F=+g[b+20>>2];G=+g[b+24>>2];K=+g[b+32>>2];N=+g[b+36>>2];Q=+g[b+40>>2];D=+g[b+48>>2];H=+g[b+52>>2];R=+g[b+56>>2];g[u+16>>2]=I*A+L*B+O*C+D;g[u+16+4>>2]=I*E+L*F+O*G+H;g[u+16+8>>2]=I*K+L*N+O*Q+R;g[u+16+12>>2]=0.0;g[u>>2]=(I+J)*A+(L+M)*B+(O+P)*C+D;g[u+4>>2]=(I+J)*E+(L+M)*F+(O+P)*G+H;g[u+8>>2]=(I+J)*K+(L+M)*N+(O+P)*Q+R;g[u+12>>2]=0.0;bc[r&127](S,u+16|0,u,u+288|0)}s=s+1|0}while((s|0)<(c[q+28>>2]|0))}}while(0);f=c[d+4>>2]|0;if((f+-21|0)>>>0<9){c[u+288>>2]=1566444395;c[u+288+4>>2]=1566444395;c[u+288+8>>2]=1566444395;g[u+288+12>>2]=0.0;c[u+256>>2]=-581039253;c[u+256+4>>2]=-581039253;c[u+256+8>>2]=-581039253;g[u+256+12>>2]=0.0;f=vb[c[(c[a>>2]|0)+20>>2]&127](a)|0;c[u+80>>2]=3252;c[u+80+4>>2]=3276;c[u+80+8>>2]=f;c[u+80+12>>2]=c[e>>2];c[u+80+12+4>>2]=c[e+4>>2];c[u+80+12+8>>2]=c[e+8>>2];c[u+80+12+12>>2]=c[e+12>>2];c[u+80+28>>2]=c[b>>2];c[u+80+28+4>>2]=c[b+4>>2];c[u+80+28+8>>2]=c[b+8>>2];c[u+80+28+12>>2]=c[b+12>>2];c[u+80+44>>2]=c[b+16>>2];c[u+80+44+4>>2]=c[b+16+4>>2];c[u+80+44+8>>2]=c[b+16+8>>2];c[u+80+44+12>>2]=c[b+16+12>>2];c[u+80+60>>2]=c[b+32>>2];c[u+80+60+4>>2]=c[b+32+4>>2];c[u+80+60+8>>2]=c[b+32+8>>2];c[u+80+60+12>>2]=c[b+32+12>>2];c[u+80+76>>2]=c[b+48>>2];c[u+80+76+4>>2]=c[b+48+4>>2];c[u+80+76+8>>2]=c[b+48+8>>2];c[u+80+76+12>>2]=c[b+48+12>>2];bc[c[(c[d>>2]|0)+64>>2]&127](d,u+80|0,u+256|0,u+288|0);f=c[d+4>>2]|0}if((f|0)!=3){i=u;return}c[u+288>>2]=1566444395;c[u+288+4>>2]=1566444395;c[u+288+8>>2]=1566444395;g[u+288+12>>2]=0.0;c[u+256>>2]=-581039253;c[u+256+4>>2]=-581039253;c[u+256+8>>2]=-581039253;g[u+256+12>>2]=0.0;S=vb[c[(c[a>>2]|0)+20>>2]&127](a)|0;c[u+80>>2]=3252;c[u+80+4>>2]=3276;c[u+80+8>>2]=S;c[u+80+12>>2]=c[e>>2];c[u+80+12+4>>2]=c[e+4>>2];c[u+80+12+8>>2]=c[e+8>>2];c[u+80+12+12>>2]=c[e+12>>2];c[u+80+28>>2]=c[b>>2];c[u+80+28+4>>2]=c[b+4>>2];c[u+80+28+8>>2]=c[b+8>>2];c[u+80+28+12>>2]=c[b+12>>2];c[u+80+44>>2]=c[b+16>>2];c[u+80+44+4>>2]=c[b+16+4>>2];c[u+80+44+8>>2]=c[b+16+8>>2];c[u+80+44+12>>2]=c[b+16+12>>2];c[u+80+60>>2]=c[b+32>>2];c[u+80+60+4>>2]=c[b+32+4>>2];c[u+80+60+8>>2]=c[b+32+8>>2];c[u+80+60+12>>2]=c[b+32+12>>2];c[u+80+76>>2]=c[b+48>>2];c[u+80+76+4>>2]=c[b+48+4>>2];c[u+80+76+8>>2]=c[b+48+8>>2];c[u+80+76+12>>2]=c[b+48+12>>2];S=c[d+96>>2]|0;bc[c[(c[S>>2]|0)+8>>2]&127](S,u+80+4|0,u+256|0,u+288|0);i=u;return}}}function ff(a){a=a|0;return}function gf(a){a=a|0;rG(a);return}function hf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0.0,H=0.0,I=0.0;d=i;i=i+96|0;l=+g[b>>2];s=+g[a+28>>2];B=+g[b+4>>2];D=+g[a+32>>2];m=+g[b+8>>2];n=+g[a+36>>2];o=+g[a+44>>2];p=+g[a+48>>2];q=+g[a+52>>2];r=+g[a+60>>2];t=+g[a+64>>2];u=+g[a+68>>2];v=+g[a+76>>2];w=+g[a+80>>2];x=+g[a+84>>2];g[d+80>>2]=l*s+B*D+m*n+v;g[d+80+4>>2]=l*o+B*p+m*q+w;g[d+80+8>>2]=l*r+B*t+m*u+x;g[d+80+12>>2]=0.0;y=+g[b+16>>2];z=+g[b+20>>2];A=+g[b+24>>2];g[d+64>>2]=y*s+z*D+A*n+v;g[d+64+4>>2]=y*o+z*p+A*q+w;g[d+64+8>>2]=y*r+z*t+A*u+x;g[d+64+12>>2]=0.0;C=+g[b+32>>2];E=+g[b+36>>2];k=+g[b+40>>2];g[d+48>>2]=C*s+E*D+k*n+v;g[d+48+4>>2]=C*o+E*p+k*q+w;g[d+48+8>>2]=C*r+E*t+k*u+x;g[d+48+12>>2]=0.0;f=(l*s+B*D+m*n+v+(y*s+z*D+A*n+v)+(C*s+E*D+k*n+v))*.3333333432674408;h=(l*o+B*p+m*q+w+(y*o+z*p+A*q+w)+(C*o+E*p+k*q+w))*.3333333432674408;j=(l*r+B*t+m*u+x+(y*r+z*t+A*u+x)+(C*r+E*t+k*u+x))*.3333333432674408;g[d+32>>2]=f;g[d+32+4>>2]=h;g[d+32+8>>2]=j;g[d+32+12>>2]=0.0;b=c[a+8>>2]|0;if(!((vb[c[(c[b>>2]|0)+56>>2]&127](b)|0)&16384)){e=c[a+8>>2]|0;F=c[e>>2]|0;F=F+16|0;F=c[F>>2]|0;b=a+12|0;bc[F&127](e,d+80|0,d+64|0,b);e=c[a+8>>2]|0;F=c[e>>2]|0;F=F+16|0;F=c[F>>2]|0;bc[F&127](e,d+64|0,d+48|0,b);a=c[a+8>>2]|0;e=c[a>>2]|0;e=e+16|0;e=c[e>>2]|0;bc[e&127](a,d+48|0,d+80|0,b);i=d;return}I=+g[d+80>>2];H=y*o+z*p+A*q+w-(l*o+B*p+m*q+w);G=y*r+z*t+A*u+x-(l*r+B*t+m*u+x);w=C*o+E*p+k*q+w-(l*o+B*p+m*q+w);x=C*r+E*t+k*u+x-(l*r+B*t+m*u+x);B=G*(C*s+E*D+k*n+v-I)-(y*s+z*D+A*n+v-I)*x;E=(y*s+z*D+A*n+v-I)*w-H*(C*s+E*D+k*n+v-I);D=1.0/+O(+(E*E+((H*x-G*w)*(H*x-G*w)+B*B)));c[d+16>>2]=1065353216;c[d+16+4>>2]=1065353216;c[d+16+8>>2]=0;g[d+16+12>>2]=0.0;b=c[a+8>>2]|0;e=c[(c[b>>2]|0)+16>>2]|0;g[d>>2]=D*(H*x-G*w)+f;g[d+4>>2]=D*B+h;g[d+8>>2]=D*E+j;g[d+12>>2]=0.0;bc[e&127](b,d+32|0,d,d+16|0);b=c[a+8>>2]|0;e=c[b>>2]|0;e=e+16|0;e=c[e>>2]|0;F=a+12|0;bc[e&127](b,d+80|0,d+64|0,F);b=c[a+8>>2]|0;e=c[b>>2]|0;e=e+16|0;e=c[e>>2]|0;bc[e&127](b,d+64|0,d+48|0,F);a=c[a+8>>2]|0;b=c[a>>2]|0;b=b+16|0;b=c[b>>2]|0;bc[b&127](a,d+48|0,d+80|0,F);i=d;return}function jf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bc[c[(c[a>>2]|0)+8>>2]&127](a,b,d,e);return}function kf(a){a=a|0;return}function lf(a){a=a|0;rG(a+-4|0);return}function mf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bc[c[(c[a+-4>>2]|0)+8>>2]&127](a+-4|0,b,d,e);return}function nf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0;f=i;i=i+256|0;c[f+32>>2]=3296;l=f+32+36|0;c[l>>2]=c[b>>2];c[l+4>>2]=c[b+4>>2];c[l+8>>2]=c[b+8>>2];c[l+12>>2]=c[b+12>>2];m=f+32+52|0;c[m>>2]=c[d>>2];c[m+4>>2]=c[d+4>>2];c[m+8>>2]=c[d+8>>2];c[m+12>>2]=c[d+12>>2];c[f+32+212>>2]=a;c[f+32+216>>2]=e;c[f+32+68>>2]=1065353216;c[f+32+72>>2]=0;c[f+32+72+4>>2]=0;c[f+32+72+8>>2]=0;c[f+32+72+12>>2]=0;c[f+32+88>>2]=1065353216;c[f+32+92>>2]=0;c[f+32+92+4>>2]=0;c[f+32+92+8>>2]=0;c[f+32+92+12>>2]=0;c[f+32+108>>2]=1065353216;c[f+32+112>>2]=0;c[f+32+116>>2]=c[l>>2];c[f+32+116+4>>2]=c[l+4>>2];c[f+32+116+8>>2]=c[l+8>>2];c[f+32+116+12>>2]=c[l+12>>2];c[f+32+132>>2]=1065353216;c[f+32+136>>2]=0;c[f+32+136+4>>2]=0;c[f+32+136+8>>2]=0;c[f+32+136+12>>2]=0;c[f+32+152>>2]=1065353216;c[f+32+156>>2]=0;c[f+32+156+4>>2]=0;c[f+32+156+8>>2]=0;c[f+32+156+12>>2]=0;c[f+32+172>>2]=1065353216;c[f+32+176>>2]=0;c[f+32+180>>2]=c[d>>2];c[f+32+180+4>>2]=c[d+4>>2];c[f+32+180+8>>2]=c[d+8>>2];c[f+32+180+12>>2]=c[d+12>>2];n=+g[d>>2]-+g[b>>2];k=+g[d+4>>2]-+g[b+4>>2];j=+g[d+8>>2]-+g[b+8>>2];h=1.0/+O(+(n*n+k*k+j*j));q=n*h==0.0?999999984306749440.0:1.0/(n*h);g[f+32+4>>2]=q;p=k*h==0.0?999999984306749440.0:1.0/(k*h);g[f+32+8>>2]=p;o=j*h==0.0?999999984306749440.0:1.0/(j*h);g[f+32+12>>2]=o;c[f+32+20>>2]=q<0.0&1;c[f+32+24>>2]=p<0.0&1;c[f+32+28>>2]=o<0.0&1;g[f+32+32>>2]=n*h*(+g[m>>2]-+g[l>>2])+k*h*(+g[f+32+56>>2]-+g[f+32+40>>2])+j*h*(+g[f+32+60>>2]-+g[f+32+44>>2]);a=c[a+68>>2]|0;e=c[(c[a>>2]|0)+24>>2]|0;c[f+16>>2]=0;c[f+16+4>>2]=0;c[f+16+8>>2]=0;c[f+16+12>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;Fb[e&7](a,b,d,f+32|0,f+16|0,f);i=f;return}function of(a){a=a|0;return}function pf(a){a=a|0;rG(a);return}function qf(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e=i;i=i+32|0;d=c[a+216>>2]|0;if(+g[d+4>>2]==0.0){a=0;i=e;return a|0}b=c[b>>2]|0;if(!(Ob[c[(c[d>>2]|0)+8>>2]&31](d,c[b+188>>2]|0)|0)){a=1;i=e;return a|0}f=c[b+192>>2]|0;d=c[a+216>>2]|0;c[e>>2]=0;c[e+4>>2]=f;c[e+8>>2]=b;c[e+12>>2]=b+4;c[e+16>>2]=-1;c[e+20>>2]=-1;rf(a+68|0,a+132|0,e,d);a=1;i=e;return a|0}function rf(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0;s=i;i=i+752|0;c[s+136+8>>2]=0;c[s+136+12>>2]=-1;c[s+136+16>>2]=1065353216;c[s+136+20>>2]=1065353216;c[s+136+24>>2]=1065353216;g[s+136+28>>2]=0.0;c[s+136>>2]=6380;c[s+136+4>>2]=8;g[s+136+32>>2]=0.0;g[s+136+48>>2]=0.0;q=c[e+4>>2]|0;r=c[e+12>>2]|0;h=c[q+4>>2]|0;if((h|0)<20){c[s+568>>2]=3316;c[s+568+168>>2]=0;g[s+568+172>>2]=0.0;c[s+568+164>>2]=c[f+4>>2];g[s+208+308>>2]=9.999999747378752e-05;a[s+208+332>>0]=0;c[s+192>>2]=7024;c[s+192+4>>2]=s+208;c[s+192+8>>2]=s+136;c[s+192+12>>2]=q;c[s+120>>2]=6864;c[s+120+4>>2]=s+208;c[s+120+8>>2]=s+136;c[s+120+12>>2]=q;q=(c[f+16>>2]&8|0)==0?s+192|0:s+120|0;if((Ib[c[(c[q>>2]|0)+8>>2]&3](q,b,d,r,r,s+568|0)|0?(j=s+568+132|0,k=+g[j>>2],l=+g[s+568+136>>2],m=+g[s+568+140>>2],k*k+l*l+m*m>9.999999747378752e-05):0)?(n=+g[s+568+164>>2],n<+g[f+4>>2]):0){p=1.0/+O(+(k*k+l*l+m*m));g[j>>2]=k*p;g[s+568+136>>2]=l*p;g[s+568+140>>2]=m*p;c[s>>2]=c[e+8>>2];c[s+4>>2]=0;c[s+8>>2]=c[j>>2];c[s+8+4>>2]=c[j+4>>2];c[s+8+8>>2]=c[j+8>>2];c[s+8+12>>2]=c[j+12>>2];g[s+24>>2]=n;+Pb[c[(c[f>>2]|0)+12>>2]&15](f,s,1)}i=s;return}if((h+-21|0)>>>0>=9){if((h|0)!=31){i=s;return}h=c[q+68>>2]|0;e=c[e+8>>2]|0;c[s+568>>2]=3392;c[s+568+4>>2]=e;c[s+568+8>>2]=q;c[s+568+12>>2]=r;c[s+568+16>>2]=b;c[s+568+20>>2]=d;c[s+568+24>>2]=f;if(!h){h=c[q+20>>2]|0;if((h|0)>0){j=0;do{Df(s+568|0,j);j=j+1|0}while((j|0)<(h|0))}}else{k=+g[r+48>>2];B=+g[b+48>>2]-k;m=+g[r+52>>2];A=+g[b+52>>2]-m;o=+g[r+56>>2];z=+g[b+56>>2]-o;y=+g[r>>2];x=+g[r+16>>2];w=+g[r+32>>2];v=+g[r+4>>2];u=+g[r+20>>2];t=+g[r+36>>2];l=+g[r+8>>2];n=+g[r+24>>2];p=+g[r+40>>2];g[s+208>>2]=B*y+A*x+z*w;g[s+208+4>>2]=B*v+A*u+z*t;g[s+208+8>>2]=B*l+A*n+z*p;g[s+208+12>>2]=0.0;k=+g[d+48>>2]-k;m=+g[d+52>>2]-m;o=+g[d+56>>2]-o;If(c[h>>2]|0,s+208|0,k*y+m*x+o*w,k*v+m*u+o*t,k*l+m*n+o*p,s+568|0)}i=s;return}E=+g[r>>2];D=+g[r+16>>2];n=+g[r+32>>2];C=+g[r+4>>2];t=+g[r+20>>2];o=+g[r+36>>2];x=+g[r+8>>2];z=+g[r+24>>2];B=+g[r+40>>2];u=-+g[r+48>>2];v=-+g[r+52>>2];w=-+g[r+56>>2];A=+g[b+48>>2];y=+g[b+52>>2];m=+g[b+56>>2];k=E*u+D*v+n*w+(E*A+D*y+n*m);l=C*u+t*v+o*w+(C*A+t*y+o*m);m=x*u+z*v+B*w+(x*A+z*y+B*m);g[s+120>>2]=k;g[s+120+4>>2]=l;g[s+120+8>>2]=m;g[s+120+12>>2]=0.0;y=+g[d+48>>2];A=+g[d+52>>2];p=+g[d+56>>2];n=E*u+D*v+n*w+(E*y+D*A+n*p);o=C*u+t*v+o*w+(C*y+t*A+o*p);p=x*u+z*v+B*w+(x*y+z*A+B*p);if((c[q+4>>2]|0)==21){h=c[e+8>>2]|0;e=c[f+16>>2]|0;c[s+4>>2]=c[s+120>>2];c[s+4+4>>2]=c[s+120+4>>2];c[s+4+8>>2]=c[s+120+8>>2];c[s+4+12>>2]=c[s+120+12>>2];g[s+20>>2]=n;g[s+24>>2]=o;g[s+28>>2]=p;g[s+32>>2]=0.0;c[s+36>>2]=e;g[s+40>>2]=1.0;c[s>>2]=3344;c[s+44>>2]=f;c[s+48>>2]=h;c[s+52>>2]=q;c[s+56>>2]=c[r>>2];c[s+56+4>>2]=c[r+4>>2];c[s+56+8>>2]=c[r+8>>2];c[s+56+12>>2]=c[r+12>>2];c[s+72>>2]=c[r+16>>2];c[s+72+4>>2]=c[r+16+4>>2];c[s+72+8>>2]=c[r+16+8>>2];c[s+72+12>>2]=c[r+16+12>>2];c[s+88>>2]=c[r+32>>2];c[s+88+4>>2]=c[r+32+4>>2];c[s+88+8>>2]=c[r+32+8>>2];c[s+88+12>>2]=c[r+32+12>>2];c[s+104>>2]=c[r+48>>2];c[s+104+4>>2]=c[r+48+4>>2];c[s+104+8>>2]=c[r+48+8>>2];c[s+104+12>>2]=c[r+48+12>>2];c[s+40>>2]=c[f+4>>2];h=c[q+52>>2]|0;c[s+192>>2]=4836;c[s+192+4>>2]=h;c[s+192+8>>2]=s;h=c[q+56>>2]|0;c[s+568>>2]=0;c[s+568+4>>2]=0;c[s+568+8>>2]=0;c[s+568+12>>2]=0;c[s+208>>2]=0;c[s+208+4>>2]=0;c[s+208+8>>2]=0;c[s+208+12>>2]=0;if(!(a[h+60>>0]|0))oe(h,s+192|0,s+120|0,n,o,p,s+568|0,s+208|0);else pe(h,s+192|0,s+120|0,n,o,p,s+568|0,s+208|0,c[h+56>>2]|0)}else{e=c[e+8>>2]|0;d=c[f+16>>2]|0;g[s+568+4>>2]=k;g[s+568+8>>2]=l;g[s+568+12>>2]=m;g[s+568+16>>2]=0.0;g[s+568+20>>2]=n;g[s+568+24>>2]=o;g[s+568+28>>2]=p;g[s+568+32>>2]=0.0;c[s+568+36>>2]=d;g[s+568+40>>2]=1.0;c[s+568>>2]=3368;c[s+568+44>>2]=f;c[s+568+48>>2]=e;c[s+568+52>>2]=q;c[s+568+56>>2]=c[r>>2];c[s+568+56+4>>2]=c[r+4>>2];c[s+568+56+8>>2]=c[r+8>>2];c[s+568+56+12>>2]=c[r+12>>2];c[s+568+72>>2]=c[r+16>>2];c[s+568+72+4>>2]=c[r+16+4>>2];c[s+568+72+8>>2]=c[r+16+8>>2];c[s+568+72+12>>2]=c[r+16+12>>2];c[s+568+88>>2]=c[r+32>>2];c[s+568+88+4>>2]=c[r+32+4>>2];c[s+568+88+8>>2]=c[r+32+8>>2];c[s+568+88+12>>2]=c[r+32+12>>2];c[s+568+104>>2]=c[r+48>>2];c[s+568+104+4>>2]=c[r+48+4>>2];c[s+568+104+8>>2]=c[r+48+8>>2];c[s+568+104+12>>2]=c[r+48+12>>2];c[s+568+40>>2]=c[f+4>>2];g[s+208>>2]=k;g[s+208+4>>2]=l;g[s+208+8>>2]=m;g[s+208+12>>2]=0.0;if(n<k)g[s+208>>2]=n;if(o<l)g[s+208+4>>2]=o;if(p<m)g[s+208+8>>2]=p;g[s+192>>2]=k;g[s+192+4>>2]=l;g[s+192+8>>2]=m;g[s+192+12>>2]=0.0;if(k<n)g[s+192>>2]=n;if(l<o)g[s+192+4>>2]=o;if(m<p)g[s+192+8>>2]=p;bc[c[(c[q>>2]|0)+64>>2]&127](q,s+568|0,s+208|0,s+192|0)}i=s;return}function sf(a,b){a=a|0;b=+b;return}function tf(a,b){a=a|0;b=b|0;return}function uf(a,b,c){a=a|0;b=b|0;c=c|0;return}function vf(a){a=a|0;return}function wf(a){a=a|0;rG(a);return}function xf(a){a=a|0;rG(a);return}function yf(a,b,d,e,f){a=a|0;b=b|0;d=+d;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;h=i;i=i+48|0;c[h+32>>2]=e;c[h+32+4>>2]=f;n=+g[b>>2];m=+g[b+4>>2];j=+g[b+8>>2];l=+g[a+56>>2]*n+ +g[a+60>>2]*m+ +g[a+64>>2]*j;k=n*+g[a+72>>2]+m*+g[a+76>>2]+j*+g[a+80>>2];j=n*+g[a+88>>2]+m*+g[a+92>>2]+j*+g[a+96>>2];c[h>>2]=c[a+48>>2];c[h+4>>2]=h+32;g[h+8>>2]=l;g[h+12>>2]=k;g[h+16>>2]=j;g[h+20>>2]=0.0;g[h+24>>2]=d;f=c[a+44>>2]|0;d=+Pb[c[(c[f>>2]|0)+12>>2]&15](f,h,1);i=h;return +d}function zf(a){a=a|0;rG(a);return}function Af(a,b,d,e,f){a=a|0;b=b|0;d=+d;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;h=i;i=i+48|0;c[h+32>>2]=e;c[h+32+4>>2]=f;n=+g[b>>2];m=+g[b+4>>2];j=+g[b+8>>2];l=+g[a+56>>2]*n+ +g[a+60>>2]*m+ +g[a+64>>2]*j;k=n*+g[a+72>>2]+m*+g[a+76>>2]+j*+g[a+80>>2];j=n*+g[a+88>>2]+m*+g[a+92>>2]+j*+g[a+96>>2];c[h>>2]=c[a+48>>2];c[h+4>>2]=h+32;g[h+8>>2]=l;g[h+12>>2]=k;g[h+16>>2]=j;g[h+20>>2]=0.0;g[h+24>>2]=d;f=c[a+44>>2]|0;d=+Pb[c[(c[f>>2]|0)+12>>2]&15](f,h,1);i=h;return +d}function Bf(a){a=a|0;rG(a);return}function Cf(a,b){a=a|0;b=b|0;Df(a,c[b+36>>2]|0);return}function Df(a,d){a=a|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0;e=i;i=i+128|0;G=c[(c[a+8>>2]|0)+28>>2]|0;h=c[G+(d*80|0)+64>>2]|0;f=c[a+12>>2]|0;x=+g[G+(d*80|0)>>2];D=+g[f>>2];w=+g[G+(d*80|0)+16>>2];C=+g[f+4>>2];v=+g[G+(d*80|0)+32>>2];B=+g[f+8>>2];u=+g[G+(d*80|0)+4>>2];t=+g[G+(d*80|0)+20>>2];s=+g[G+(d*80|0)+36>>2];r=+g[G+(d*80|0)+8>>2];p=+g[G+(d*80|0)+24>>2];n=+g[G+(d*80|0)+40>>2];A=+g[f+16>>2];z=+g[f+20>>2];y=+g[f+24>>2];q=+g[f+32>>2];o=+g[f+36>>2];m=+g[f+40>>2];F=+g[G+(d*80|0)+48>>2];E=+g[G+(d*80|0)+52>>2];j=+g[G+(d*80|0)+56>>2];l=+g[f+48>>2]+(D*F+C*E+B*j);k=A*F+z*E+y*j+ +g[f+52>>2];j=q*F+o*E+m*j+ +g[f+56>>2];g[e+56>>2]=x*D+w*C+v*B;g[e+56+4>>2]=D*u+C*t+B*s;g[e+56+8>>2]=D*r+C*p+B*n;g[e+56+12>>2]=0.0;g[e+56+16>>2]=x*A+w*z+v*y;g[e+56+20>>2]=u*A+t*z+s*y;g[e+56+24>>2]=r*A+p*z+n*y;g[e+56+28>>2]=0.0;g[e+56+32>>2]=x*q+w*o+v*m;g[e+56+36>>2]=u*q+t*o+s*m;g[e+56+40>>2]=r*q+p*o+n*m;g[e+56+44>>2]=0.0;g[e+56+48>>2]=l;g[e+56+52>>2]=k;g[e+56+56>>2]=j;g[e+56+60>>2]=0.0;f=c[a+4>>2]|0;c[e+32>>2]=0;c[e+32+4>>2]=h;c[e+32+8>>2]=f;c[e+32+12>>2]=e+56;c[e+32+16>>2]=-1;c[e+32+20>>2]=d;f=c[a+24>>2]|0;g[e+4>>2]=1.0;c[e+8>>2]=0;b[e+12>>1]=1;b[e+14>>1]=-1;c[e+16>>2]=0;c[e>>2]=3428;c[e+20>>2]=f;c[e+24>>2]=d;c[e+4>>2]=c[f+4>>2];c[e+16>>2]=c[f+16>>2];rf(c[a+16>>2]|0,c[a+20>>2]|0,e+32|0,e);i=e;return}function Ef(a){a=a|0;return}function Ff(a){a=a|0;rG(a);return}function Gf(a,b){a=a|0;b=b|0;a=c[a+20>>2]|0;return Ob[c[(c[a>>2]|0)+8>>2]&31](a,b)|0}function Hf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,g=0;e=i;i=i+16|0;c[e>>2]=-1;c[e+4>>2]=c[a+24>>2];if(!(c[b+4>>2]|0))c[b+4>>2]=e;g=c[a+20>>2]|0;f=+Pb[c[(c[g>>2]|0)+12>>2]&15](g,b,d);c[a+4>>2]=c[(c[a+20>>2]|0)+4>>2];i=e;return +f}function If(a,b,d,e,f,h){a=a|0;b=b|0;d=+d;e=+e;f=+f;h=h|0;var j=0,k=0,l=0.0,m=0,n=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0;D=i;i=i+32|0;if(!a){i=D;return}x=d-+g[b>>2];w=e-+g[b+4>>2];v=f-+g[b+8>>2];r=1.0/+O(+(x*x+w*w+v*v));s=x*r==0.0?999999984306749440.0:1.0/(x*r);t=w*r==0.0?999999984306749440.0:1.0/(w*r);u=v*r==0.0?999999984306749440.0:1.0/(v*r);c[5637]=(c[5637]|0)+1;j=qG(531)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}ZG(j|0,0,512)|0;c[j>>2]=a;q=1;a=128;m=128;k=126;while(1){n=q+-1|0;p=c[j+(n<<2)>>2]|0;c[D>>2]=c[p>>2];c[D+4>>2]=c[p+4>>2];c[D+8>>2]=c[p+8>>2];c[D+12>>2]=c[p+12>>2];c[D+16>>2]=c[p+16>>2];c[D+16+4>>2]=c[p+16+4>>2];c[D+16+8>>2]=c[p+16+8>>2];c[D+16+12>>2]=c[p+16+12>>2];e=+g[b>>2];d=s*(+g[D+((s<0.0&1)<<4)>>2]-e);e=s*(+g[D+((s<0.0^1)<<4)>>2]-e);l=+g[b+4>>2];f=t*(+g[D+((t<0.0&1)<<4)+4>>2]-l);l=t*(+g[D+((t<0.0^1)<<4)+4>>2]-l);do if((!(f>e|d>l)?(y=f>d?f:d,B=l<e?l:e,A=+g[b+8>>2],z=u*(+g[D+((u<0.0&1)<<4)+8>>2]-A),A=u*(+g[D+((u<0.0^1)<<4)+8>>2]-A),!(z>B|y>A)):0)?((A<B?A:B)>0.0?(z>y?z:y)<x*r*x+w*r*w+v*r*v:0):0){if(!(c[p+40>>2]|0)){tb[c[(c[h>>2]|0)+12>>2]&127](h,p);break}if((n|0)>(k|0)){o=m<<1;if((m|0)<(o|0)){do if((a|0)<(o|0)){if(m){c[5637]=(c[5637]|0)+1;a=qG((m<<3|3)+16|0)|0;if(!a)a=0;else{c[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16}if((m|0)>0){k=0;do{c[a+(k<<2)>>2]=c[j+(k<<2)>>2];k=k+1|0}while((k|0)!=(m|0))}else C=17}else{a=0;C=17}if((C|0)==17){C=0;if(!j){k=o;j=a;break}}c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0);k=o;j=a}else k=a;while(0);ZG(j+(m<<2)|0,0,m<<2|0)|0;a=k}m=o;k=o+-2|0}c[j+(n<<2)>>2]=c[p+36>>2];c[j+(q<<2)>>2]=c[p+40>>2];n=q+1|0}while(0);if(!n)break;else q=n}if(!j){i=D;return}c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0);i=D;return}function Jf(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0;l=i;i=i+96|0;g=c[b+8>>2]|0;if((g|0)==(c[b+12>>2]|0)?(k=g|0?g<<1:1,(g|0)<(k|0)):0){if(!k)j=0;else{c[5637]=(c[5637]|0)+1;g=qG((k<<2|3)+16|0)|0;if(!g)g=0;else{c[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}j=g;g=c[b+8>>2]|0}if((g|0)>0){h=0;do{c[j+(h<<2)>>2]=c[(c[b+16>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(g|0))}h=c[b+16>>2]|0;if(h){if(a[b+20>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0);g=c[b+8>>2]|0}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=j;c[b+12>>2]=k}c[(c[b+16>>2]|0)+(g<<2)>>2]=d;c[b+8>>2]=g+1;c[l+32>>2]=c[d+4>>2];c[l+32+4>>2]=c[d+4+4>>2];c[l+32+8>>2]=c[d+4+8>>2];c[l+32+12>>2]=c[d+4+12>>2];c[l+32+16>>2]=c[d+20>>2];c[l+32+16+4>>2]=c[d+20+4>>2];c[l+32+16+8>>2]=c[d+20+8>>2];c[l+32+16+12>>2]=c[d+20+12>>2];c[l+32+32>>2]=c[d+36>>2];c[l+32+32+4>>2]=c[d+36+4>>2];c[l+32+32+8>>2]=c[d+36+8>>2];c[l+32+32+12>>2]=c[d+36+12>>2];c[l+32+48>>2]=c[d+52>>2];c[l+32+48+4>>2]=c[d+52+4>>2];c[l+32+48+8>>2]=c[d+52+8>>2];c[l+32+48+12>>2]=c[d+52+12>>2];k=c[d+192>>2]|0;bc[c[(c[k>>2]|0)+8>>2]&127](k,l+32|0,l+16|0,l);k=c[b+68>>2]|0;c[d+188>>2]=Xb[c[(c[k>>2]|0)+8>>2]&3](k,l+16|0,l,c[(c[d+192>>2]|0)+4>>2]|0,d,e,f,c[b+24>>2]|0,0)|0;i=l;return}function Kf(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=c[b+188>>2]|0;if(d|0){g=c[a+68>>2]|0;g=vb[c[(c[g>>2]|0)+36>>2]&127](g)|0;Zb[c[(c[g>>2]|0)+40>>2]&127](g,d,c[a+24>>2]|0);g=c[a+68>>2]|0;Zb[c[(c[g>>2]|0)+12>>2]&127](g,d,c[a+24>>2]|0);c[b+188>>2]=0}f=c[a+8>>2]|0;if((f|0)<=0)return;g=c[a+16>>2]|0;d=0;while(1){e=g+(d<<2)|0;if((c[e>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(f|0)){h=9;break}}if((h|0)==9)return;if((d|0)>=(f|0))return;c[e>>2]=c[g+(f+-1<<2)>>2];c[(c[a+16>>2]|0)+(f+-1<<2)>>2]=b;c[a+8>>2]=f+-1;return}function Lf(a){a=a|0;var b=0,d=0,e=0,f=0;d=i;i=i+16|0;fs(10245);rb[c[(c[a>>2]|0)+8>>2]&255](a);rb[c[(c[a>>2]|0)+12>>2]&255](a);b=c[a+24>>2]|0;fs(10279);if(b|0){f=c[(c[b>>2]|0)+32>>2]|0;e=c[a+68>>2]|0;e=vb[c[(c[e>>2]|0)+36>>2]&127](e)|0;bc[f&127](b,e,a+28|0,c[a+24>>2]|0)}a=c[2006]|0;f=(c[a+16>>2]|0)+-1|0;c[a+16>>2]=f;do if(!f){if(c[a+4>>2]|0){kb(d|0,0)|0;b=c[5649]|0;g[a+8>>2]=+g[a+8>>2]+ +(((c[d+4>>2]|0)-(c[b+4>>2]|0)+(((c[d>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[a+12>>2]|0)|0)>>>0)/1.0e3;b=c[2006]|0;if(c[a+16>>2]|0)break}else b=a;b=c[b+20>>2]|0;c[2006]=b}else b=a;while(0);a=b+16|0;f=(c[a>>2]|0)+-1|0;c[a>>2]=f;if(f|0){i=d;return}do if(c[b+4>>2]|0){kb(d|0,0)|0;e=c[5649]|0;f=b+8|0;g[f>>2]=+g[f>>2]+ +(((c[d+4>>2]|0)-(c[e+4>>2]|0)+(((c[d>>2]|0)-(c[e>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[a>>2]|0)){b=c[2006]|0;break}else{i=d;return}}while(0);c[2006]=c[b+20>>2];i=d;return}function Mf(a,b){a=a|0;b=b|0;rb[c[(c[b>>2]|0)+32>>2]&255](b);Nf(a,b);rb[c[(c[b>>2]|0)+36>>2]&255](b);return}function Nf(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;x=i;i=i+80|0;a[x+16>>0]=1;c[x+12>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;a[x+36>>0]=1;c[x+32>>2]=0;c[x+24>>2]=0;c[x+28>>2]=0;a[x+56>>0]=1;c[x+52>>2]=0;c[x+44>>2]=0;c[x+48>>2]=0;a[x+76>>0]=1;c[x+72>>2]=0;c[x+64>>2]=0;c[x+68>>2]=0;e=c[b+8>>2]|0;if((e|0)<=0){Of(x);i=x;return}j=0;k=0;g=0;f=0;r=0;while(1){q=c[(c[(c[b+16>>2]|0)+(r<<2)>>2]|0)+192>>2]|0;p=(q+~(q<<15)>>10^q+~(q<<15))*9|0;p=(p>>6^p)+~((p>>6^p)<<11)>>16^(p>>6^p)+~((p>>6^p)<<11);o=p&j+-1;l=o>>>0<k>>>0;a:do if(l){h=c[g+(o<<2)>>2]|0;if((h|0)!=-1){m=c[x+72>>2]|0;while(1){if((q|0)==(c[m+(h<<3)>>2]|0)){n=9;break}k=c[f+(h<<2)>>2]|0;if((k|0)==-1)break;else h=k}if((n|0)==9?(n=0,(c[x+52>>2]|0)+(h<<2)|0):0)break;if(!l){n=16;break}}e=c[g+(o<<2)>>2]|0;if((e|0)!=-1){h=c[x+72>>2]|0;while(1){if((q|0)==(c[h+(e<<3)>>2]|0))break;e=c[f+(e<<2)>>2]|0;if((e|0)==-1){n=16;break a}}c[(c[x+52>>2]|0)+(e<<2)>>2]=q;e=j;n=78}else n=16}else n=16;while(0);if((n|0)==16){l=c[x+44>>2]|0;if((l|0)==(j|0)){e=j|0?j<<1:1;if((j|0)<(e|0)){if((e|0)!=0?(c[5637]=(c[5637]|0)+1,w=qG((e<<2|3)+16|0)|0,(w|0)!=0):0){c[(w+4+15&-16)+-4>>2]=w;g=w+4+15&-16}else g=0;if((j|0)>0){f=0;do{c[g+(f<<2)>>2]=c[(c[x+52>>2]|0)+(f<<2)>>2];f=f+1|0}while((f|0)!=(j|0))}f=c[x+52>>2]|0;if(f|0){if(a[x+56>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[x+52>>2]=0}a[x+56>>0]=1;c[x+52>>2]=g;c[x+48>>2]=e;f=j}else{f=j;e=j}}else{f=l;e=j}c[(c[x+52>>2]|0)+(f<<2)>>2]=q;c[x+44>>2]=f+1;f=c[x+64>>2]|0;if((f|0)==(c[x+68>>2]|0)?(s=f|0?f<<1:1,(f|0)<(s|0)):0){if((s|0)!=0?(c[5637]=(c[5637]|0)+1,t=qG((s<<3|3)+16|0)|0,(t|0)!=0):0){c[(t+4+15&-16)+-4>>2]=t;g=t+4+15&-16}else g=0;if((f|0)>0){e=0;do{k=(c[x+72>>2]|0)+(e<<3)|0;m=c[k+4>>2]|0;n=g+(e<<3)|0;c[n>>2]=c[k>>2];c[n+4>>2]=m;e=e+1|0}while((e|0)!=(f|0))}e=c[x+72>>2]|0;if(e|0){if(a[x+76>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0)}c[x+72>>2]=0}a[x+76>>0]=1;c[x+72>>2]=g;c[x+68>>2]=s;f=c[x+64>>2]|0;e=c[x+48>>2]|0}n=(c[x+72>>2]|0)+(f<<3)|0;c[n>>2]=q;c[n+4>>2]=0;c[x+64>>2]=f+1;if((j|0)<(e|0)){k=c[x+4>>2]|0;do if((e|0)>(k|0)){if((e|0)>=(k|0)){do if((c[x+8>>2]|0)<(e|0)){if((e|0)!=0?(c[5637]=(c[5637]|0)+1,u=qG((e<<2|3)+16|0)|0,(u|0)!=0):0){c[(u+4+15&-16)+-4>>2]=u;f=u+4+15&-16}else f=0;g=c[x+12>>2]|0;if((k|0)<=0){if(!g){a[x+16>>0]=1;c[x+12>>2]=f;c[x+8>>2]=e;break}}else{h=0;do{c[f+(h<<2)>>2]=c[g+(h<<2)>>2];h=h+1|0}while((h|0)!=(k|0))}if(a[x+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[g+-4>>2]|0)}a[x+16>>0]=1;c[x+12>>2]=f;c[x+8>>2]=e}else f=c[x+12>>2]|0;while(0);ZG(f+(k<<2)|0,0,e-k<<2|0)|0}c[x+4>>2]=e;j=c[x+24>>2]|0;if((e|0)>(j|0)){do if((c[x+28>>2]|0)<(e|0)){if((e|0)!=0?(c[5637]=(c[5637]|0)+1,v=qG((e<<2|3)+16|0)|0,(v|0)!=0):0){c[(v+4+15&-16)+-4>>2]=v;f=v+4+15&-16}else f=0;g=c[x+32>>2]|0;if((j|0)<=0){if(!g){a[x+36>>0]=1;c[x+32>>2]=f;c[x+28>>2]=e;break}}else{h=0;do{c[f+(h<<2)>>2]=c[g+(h<<2)>>2];h=h+1|0}while((h|0)!=(j|0))}if(a[x+36>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[g+-4>>2]|0)}a[x+36>>0]=1;c[x+32>>2]=f;c[x+28>>2]=e}else f=c[x+32>>2]|0;while(0);ZG(f+(j<<2)|0,0,e-j<<2|0)|0}c[x+24>>2]=e;if((e|0)>0){o=e<<2;ZG(c[x+12>>2]|0,-1,o|0)|0;ZG(c[x+32>>2]|0,-1,o|0)|0}if((k|0)<=0){e=c[x+48>>2]|0;break}f=c[x+72>>2]|0;g=c[x+12>>2]|0;h=c[x+32>>2]|0;e=c[x+48>>2]|0;j=0;do{o=c[f+(j<<3)>>2]|0;o=(o+~(o<<15)>>10^o+~(o<<15))*9|0;o=g+((((o>>6^o)+~((o>>6^o)<<11)>>16^(o>>6^o)+~((o>>6^o)<<11))&e+-1)<<2)|0;c[h+(j<<2)>>2]=c[o>>2];c[o>>2]=j;j=j+1|0}while((j|0)!=(k|0))}while(0);f=e;e=p&e+-1}else{f=e;e=o}g=c[x+12>>2]|0;e=g+(e<<2)|0;n=c[x+32>>2]|0;c[n+(l<<2)>>2]=c[e>>2];c[e>>2]=l;e=f;f=n;n=78}if((n|0)==78){n=0;tb[c[(c[q>>2]|0)+60>>2]&127](q,d);j=e;e=c[b+8>>2]|0}h=r+1|0;if((h|0)>=(e|0))break;k=c[x+4>>2]|0;r=h}if((e|0)>0)g=0;else{Of(x);i=x;return}do{f=c[(c[b+16>>2]|0)+(g<<2)>>2]|0;switch(c[f+236>>2]|0){case 64:case 1:{tb[c[(c[f>>2]|0)+24>>2]&127](f,d);e=c[b+8>>2]|0;break}default:{}}g=g+1|0}while((g|0)<(e|0));Of(x);i=x;return}function Of(b){b=b|0;var d=0;d=c[b+72>>2]|0;if(d|0){if(a[b+76>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+72>>2]=0}a[b+76>>0]=1;c[b+72>>2]=0;c[b+64>>2]=0;c[b+68>>2]=0;d=c[b+52>>2]|0;if(d|0){if(a[b+56>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;d=c[b+32>>2]|0;if(d|0){if(a[b+36>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;d=c[b+12>>2]|0;if(!d){a[b+16>>0]=1;c[b+12>>2]=0;c[b+4>>2]=0;b=b+8|0;c[b>>2]=0;return}if(a[b+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+12>>2]=0;a[b+16>>0]=1;c[b+12>>2]=0;c[b+4>>2]=0;b=b+8|0;c[b>>2]=0;return}function Pf(d,e,f,h,j,k){d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=+k;var l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0,F=0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,P=0.0;F=i;i=i+896|0;E=c[h+4>>2]|0;D=c[h+12>>2]|0;w=c[E+4>>2]|0;if((w|0)<20){c[F+712>>2]=3316;c[F+712+168>>2]=0;g[F+712+172>>2]=k;c[F+712+164>>2]=c[j+4>>2];g[F+352+308>>2]=9.999999747378752e-05;a[F+352+332>>0]=0;c[F+288>>2]=6908;c[F+64>>2]=6816;c[F+64+4>>2]=F+352;c[F+64+8>>2]=F+288;c[F+64+12>>2]=d;c[F+64+16>>2]=E;c[F+64+20>>2]=0;if((rn(F+64|0,e,f,D,D,F+712|0)|0?(l=F+712+132|0,m=+g[l>>2],n=+g[F+712+136>>2],p=+g[F+712+140>>2],m*m+n*n+p*p>9.999999747378752e-05):0)?(t=+g[F+712+164>>2],t<+g[j+4>>2]):0){k=1.0/+O(+(m*m+n*n+p*p));g[l>>2]=m*k;g[F+712+136>>2]=n*k;g[F+712+140>>2]=p*k;c[F+16>>2]=c[h+8>>2];c[F+16+4>>2]=0;c[F+16+8>>2]=c[l>>2];c[F+16+8+4>>2]=c[l+4>>2];c[F+16+8+8>>2]=c[l+8>>2];c[F+16+8+12>>2]=c[l+12>>2];c[F+16+24>>2]=c[F+712+148>>2];c[F+16+24+4>>2]=c[F+712+148+4>>2];c[F+16+24+8>>2]=c[F+712+148+8>>2];c[F+16+24+12>>2]=c[F+712+148+12>>2];g[F+16+40>>2]=t;+Pb[c[(c[j>>2]|0)+12>>2]&15](j,F+16|0,1)}i=F;return}if((w+-21|0)>>>0>=9){if((w|0)!=31){i=F;return}fs(10657);if((c[E+20>>2]|0)>0){l=0;do{u=c[E+28>>2]|0;m=+g[u+(l*80|0)>>2];p=+g[u+(l*80|0)+4>>2];s=+g[u+(l*80|0)+8>>2];n=+g[u+(l*80|0)+16>>2];q=+g[u+(l*80|0)+20>>2];v=+g[u+(l*80|0)+24>>2];o=+g[u+(l*80|0)+32>>2];r=+g[u+(l*80|0)+36>>2];y=+g[u+(l*80|0)+40>>2];N=+g[u+(l*80|0)+48>>2];M=+g[u+(l*80|0)+52>>2];C=+g[u+(l*80|0)+56>>2];u=c[u+(l*80|0)+64>>2]|0;L=+g[D>>2];K=+g[D+4>>2];J=+g[D+8>>2];I=+g[D+16>>2];H=+g[D+20>>2];G=+g[D+24>>2];t=+g[D+32>>2];x=+g[D+36>>2];z=+g[D+40>>2];A=N*L+M*K+C*J+ +g[D+48>>2];B=N*I+M*H+C*G+ +g[D+52>>2];C=N*t+M*x+C*z+ +g[D+56>>2];g[F+712>>2]=m*L+n*K+o*J;g[F+712+4>>2]=p*L+q*K+r*J;g[F+712+8>>2]=s*L+v*K+y*J;g[F+712+12>>2]=0.0;g[F+712+16>>2]=m*I+n*H+o*G;g[F+712+20>>2]=p*I+q*H+r*G;g[F+712+24>>2]=s*I+v*H+y*G;g[F+712+28>>2]=0.0;g[F+712+32>>2]=m*t+n*x+o*z;g[F+712+36>>2]=p*t+q*x+r*z;g[F+712+40>>2]=s*t+v*x+y*z;g[F+712+44>>2]=0.0;g[F+712+48>>2]=A;g[F+712+52>>2]=B;g[F+712+56>>2]=C;g[F+712+60>>2]=0.0;b[F+352+8>>1]=1;b[F+352+10>>1]=-1;c[F+352>>2]=3500;c[F+352+12>>2]=j;c[F+352+16>>2]=l;c[F+352+4>>2]=c[j+4>>2];w=c[h+8>>2]|0;c[F+288>>2]=h;c[F+288+4>>2]=u;c[F+288+8>>2]=w;c[F+288+12>>2]=F+712;c[F+288+16>>2]=-1;c[F+288+20>>2]=l;Pf(d,e,f,F+288|0,F+352|0,k);l=l+1|0}while((l|0)<(c[E+20>>2]|0))}l=c[2006]|0;E=(c[l+16>>2]|0)+-1|0;c[l+16>>2]=E;if(E|0){i=F;return}do if(c[l+4>>2]|0){kb(F+712|0,0)|0;E=c[5649]|0;g[l+8>>2]=+g[l+8>>2]+ +(((c[F+712+4>>2]|0)-(c[E+4>>2]|0)+(((c[F+712>>2]|0)-(c[E>>2]|0)|0)*1e6|0)-(c[l+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[l+16>>2]|0)){l=c[2006]|0;break}else{i=F;return}}while(0);c[2006]=c[l+20>>2];i=F;return}switch(w|0){case 21:{p=+g[D>>2];q=+g[D+16>>2];r=+g[D+32>>2];s=+g[D+4>>2];t=+g[D+20>>2];v=+g[D+36>>2];x=+g[D+8>>2];y=+g[D+24>>2];z=+g[D+40>>2];A=-+g[D+48>>2];B=-+g[D+52>>2];C=-+g[D+56>>2];o=+g[e+48>>2];n=+g[e+52>>2];m=+g[e+56>>2];g[F+352>>2]=p*A+q*B+r*C+(p*o+q*n+r*m);g[F+352+4>>2]=s*A+t*B+v*C+(s*o+t*n+v*m);g[F+352+8>>2]=x*A+y*B+z*C+(x*o+y*n+z*m);g[F+352+12>>2]=0.0;m=+g[f+48>>2];n=+g[f+52>>2];o=+g[f+56>>2];P=+g[f>>2];G=+g[f+16>>2];H=+g[f+32>>2];I=+g[f+4>>2];J=+g[f+20>>2];K=+g[f+36>>2];L=+g[f+8>>2];M=+g[f+24>>2];N=+g[f+40>>2];g[F+288>>2]=p*P+q*G+r*H;g[F+288+4>>2]=p*I+q*J+r*K;g[F+288+8>>2]=p*L+q*M+r*N;g[F+288+12>>2]=0.0;g[F+288+16>>2]=s*P+t*G+v*H;g[F+288+20>>2]=s*I+t*J+v*K;g[F+288+24>>2]=s*L+t*M+v*N;g[F+288+28>>2]=0.0;g[F+288+32>>2]=x*P+y*G+z*H;g[F+288+36>>2]=x*I+y*J+z*K;g[F+288+40>>2]=x*L+y*M+z*N;l=F+288+44|0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;l=c[h+8>>2]|0;N=+Hb[c[(c[E>>2]|0)+48>>2]&15](E);c[F+64>>2]=7e3;c[F+64+4>>2]=d;c[F+64+8>>2]=c[e>>2];c[F+64+8+4>>2]=c[e+4>>2];c[F+64+8+8>>2]=c[e+8>>2];c[F+64+8+12>>2]=c[e+12>>2];c[F+64+24>>2]=c[e+16>>2];c[F+64+24+4>>2]=c[e+16+4>>2];c[F+64+24+8>>2]=c[e+16+8>>2];c[F+64+24+12>>2]=c[e+16+12>>2];c[F+64+40>>2]=c[e+32>>2];c[F+64+40+4>>2]=c[e+32+4>>2];c[F+64+40+8>>2]=c[e+32+8>>2];c[F+64+40+12>>2]=c[e+32+12>>2];c[F+64+56>>2]=c[e+48>>2];c[F+64+56+4>>2]=c[e+48+4>>2];c[F+64+56+8>>2]=c[e+48+8>>2];c[F+64+56+12>>2]=c[e+48+12>>2];c[F+64+72>>2]=c[f>>2];c[F+64+72+4>>2]=c[f+4>>2];c[F+64+72+8>>2]=c[f+8>>2];c[F+64+72+12>>2]=c[f+12>>2];c[F+64+88>>2]=c[f+16>>2];c[F+64+88+4>>2]=c[f+16+4>>2];c[F+64+88+8>>2]=c[f+16+8>>2];c[F+64+88+12>>2]=c[f+16+12>>2];c[F+64+104>>2]=c[f+32>>2];c[F+64+104+4>>2]=c[f+32+4>>2];c[F+64+104+8>>2]=c[f+32+8>>2];c[F+64+104+12>>2]=c[f+32+12>>2];c[F+64+120>>2]=c[f+48>>2];c[F+64+120+4>>2]=c[f+48+4>>2];c[F+64+120+8>>2]=c[f+48+8>>2];c[F+64+120+12>>2]=c[f+48+12>>2];c[F+64+136>>2]=c[D>>2];c[F+64+136+4>>2]=c[D+4>>2];c[F+64+136+8>>2]=c[D+8>>2];c[F+64+136+12>>2]=c[D+12>>2];c[F+64+152>>2]=c[D+16>>2];c[F+64+152+4>>2]=c[D+16+4>>2];c[F+64+152+8>>2]=c[D+16+8>>2];c[F+64+152+12>>2]=c[D+16+12>>2];c[F+64+168>>2]=c[D+32>>2];c[F+64+168+4>>2]=c[D+32+4>>2];c[F+64+168+8>>2]=c[D+32+8>>2];c[F+64+168+12>>2]=c[D+32+12>>2];c[F+64+184>>2]=c[D+48>>2];c[F+64+184+4>>2]=c[D+48+4>>2];c[F+64+184+8>>2]=c[D+48+8>>2];c[F+64+184+12>>2]=c[D+48+12>>2];g[F+64+204>>2]=N;c[F+64>>2]=3452;c[F+64+212>>2]=j;c[F+64+216>>2]=l;c[F+64+220>>2]=E;c[F+64+200>>2]=c[j+4>>2];g[F+64+208>>2]=k;bc[c[(c[d>>2]|0)+8>>2]&127](d,F+288|0,F+16|0,F);l=c[E+52>>2]|0;c[F+712>>2]=4856;c[F+712+4>>2]=l;c[F+712+8>>2]=F+64;l=c[E+56>>2]|0;if(!(a[l+60>>0]|0))oe(l,F+712|0,F+352|0,p*A+q*B+r*C+(p*m+q*n+r*o),s*A+t*B+v*C+(s*m+t*n+v*o),x*A+y*B+z*C+(x*m+y*n+z*o),F+16|0,F);else pe(l,F+712|0,F+352|0,p*A+q*B+r*C+(p*m+q*n+r*o),s*A+t*B+v*C+(s*m+t*n+v*o),x*A+y*B+z*C+(x*m+y*n+z*o),F+16|0,F,c[l+56>>2]|0);i=F;return}case 28:{c[F+712>>2]=3316;c[F+712+168>>2]=0;g[F+712+172>>2]=k;c[F+712+164>>2]=c[j+4>>2];c[F+352>>2]=6816;c[F+352+4>>2]=0;c[F+352+8>>2]=0;c[F+352+12>>2]=d;c[F+352+16>>2]=0;c[F+352+20>>2]=E;if((rn(F+352|0,e,f,D,D,F+712|0)|0?(u=F+712+132|0,o=+g[u>>2],q=+g[F+712+136>>2],r=+g[F+712+140>>2],o*o+q*q+r*r>9.999999747378752e-05):0)?(s=+g[F+712+164>>2],s<+g[j+4>>2]):0){P=1.0/+O(+(o*o+q*q+r*r));g[u>>2]=o*P;g[F+712+136>>2]=q*P;g[F+712+140>>2]=r*P;c[F+288>>2]=c[h+8>>2];c[F+288+4>>2]=0;c[F+288+8>>2]=c[u>>2];c[F+288+8+4>>2]=c[u+4>>2];c[F+288+8+8>>2]=c[u+8>>2];c[F+288+8+12>>2]=c[u+12>>2];c[F+288+24>>2]=c[F+712+148>>2];c[F+288+24+4>>2]=c[F+712+148+4>>2];c[F+288+24+8>>2]=c[F+712+148+8>>2];c[F+288+24+12>>2]=c[F+712+148+12>>2];g[F+288+40>>2]=s;+Pb[c[(c[j>>2]|0)+12>>2]&15](j,F+288|0,1)}i=F;return}default:{p=+g[D>>2];q=+g[D+16>>2];r=+g[D+32>>2];x=+g[D+4>>2];y=+g[D+20>>2];z=+g[D+36>>2];J=+g[D+8>>2];L=+g[D+24>>2];N=+g[D+40>>2];H=-+g[D+48>>2];G=-+g[D+52>>2];C=-+g[D+56>>2];A=+g[e+48>>2];B=+g[e+52>>2];m=+g[e+56>>2];o=p*H+q*G+r*C+(p*A+q*B+r*m);n=x*H+y*G+z*C+(x*A+y*B+z*m);m=J*H+L*G+N*C+(J*A+L*B+N*m);B=+g[f+48>>2];A=+g[f+52>>2];v=+g[f+56>>2];s=p*H+q*G+r*C+(p*B+q*A+r*v);t=x*H+y*G+z*C+(x*B+y*A+z*v);v=J*H+L*G+N*C+(J*B+L*A+N*v);A=+g[f>>2];B=+g[f+16>>2];C=+g[f+32>>2];G=+g[f+4>>2];H=+g[f+20>>2];I=+g[f+36>>2];K=+g[f+8>>2];M=+g[f+24>>2];P=+g[f+40>>2];g[F+712>>2]=p*A+q*B+r*C;g[F+712+4>>2]=p*G+q*H+r*I;g[F+712+8>>2]=p*K+q*M+r*P;g[F+712+12>>2]=0.0;g[F+712+16>>2]=x*A+y*B+z*C;g[F+712+20>>2]=x*G+y*H+z*I;g[F+712+24>>2]=x*K+y*M+z*P;g[F+712+28>>2]=0.0;g[F+712+32>>2]=J*A+L*B+N*C;g[F+712+36>>2]=J*G+L*H+N*I;g[F+712+40>>2]=J*K+L*M+N*P;w=F+712+44|0;c[w>>2]=0;c[w+4>>2]=0;c[w+8>>2]=0;c[w+12>>2]=0;c[w+16>>2]=0;h=c[h+8>>2]|0;P=+Hb[c[(c[E>>2]|0)+48>>2]&15](E);c[F+352>>2]=7e3;c[F+352+4>>2]=d;c[F+352+8>>2]=c[e>>2];c[F+352+8+4>>2]=c[e+4>>2];c[F+352+8+8>>2]=c[e+8>>2];c[F+352+8+12>>2]=c[e+12>>2];c[F+352+24>>2]=c[e+16>>2];c[F+352+24+4>>2]=c[e+16+4>>2];c[F+352+24+8>>2]=c[e+16+8>>2];c[F+352+24+12>>2]=c[e+16+12>>2];c[F+352+40>>2]=c[e+32>>2];c[F+352+40+4>>2]=c[e+32+4>>2];c[F+352+40+8>>2]=c[e+32+8>>2];c[F+352+40+12>>2]=c[e+32+12>>2];c[F+352+56>>2]=c[e+48>>2];c[F+352+56+4>>2]=c[e+48+4>>2];c[F+352+56+8>>2]=c[e+48+8>>2];c[F+352+56+12>>2]=c[e+48+12>>2];c[F+352+72>>2]=c[f>>2];c[F+352+72+4>>2]=c[f+4>>2];c[F+352+72+8>>2]=c[f+8>>2];c[F+352+72+12>>2]=c[f+12>>2];c[F+352+88>>2]=c[f+16>>2];c[F+352+88+4>>2]=c[f+16+4>>2];c[F+352+88+8>>2]=c[f+16+8>>2];c[F+352+88+12>>2]=c[f+16+12>>2];c[F+352+104>>2]=c[f+32>>2];c[F+352+104+4>>2]=c[f+32+4>>2];c[F+352+104+8>>2]=c[f+32+8>>2];c[F+352+104+12>>2]=c[f+32+12>>2];c[F+352+120>>2]=c[f+48>>2];c[F+352+120+4>>2]=c[f+48+4>>2];c[F+352+120+8>>2]=c[f+48+8>>2];c[F+352+120+12>>2]=c[f+48+12>>2];c[F+352+136>>2]=c[D>>2];c[F+352+136+4>>2]=c[D+4>>2];c[F+352+136+8>>2]=c[D+8>>2];c[F+352+136+12>>2]=c[D+12>>2];c[F+352+152>>2]=c[D+16>>2];c[F+352+152+4>>2]=c[D+16+4>>2];c[F+352+152+8>>2]=c[D+16+8>>2];c[F+352+152+12>>2]=c[D+16+12>>2];c[F+352+168>>2]=c[D+32>>2];c[F+352+168+4>>2]=c[D+32+4>>2];c[F+352+168+8>>2]=c[D+32+8>>2];c[F+352+168+12>>2]=c[D+32+12>>2];c[F+352+184>>2]=c[D+48>>2];c[F+352+184+4>>2]=c[D+48+4>>2];c[F+352+184+8>>2]=c[D+48+8>>2];c[F+352+184+12>>2]=c[D+48+12>>2];g[F+352+204>>2]=P;c[F+352>>2]=3476;c[F+352+212>>2]=j;c[F+352+216>>2]=h;c[F+352+220>>2]=E;c[F+352+200>>2]=c[j+4>>2];g[F+352+208>>2]=k;bc[c[(c[d>>2]|0)+8>>2]&127](d,F+712|0,F+288|0,F+64|0);g[F+16>>2]=o;g[F+16+4>>2]=n;g[F+16+8>>2]=m;g[F+16+12>>2]=0.0;if(s<o){g[F+16>>2]=s;p=s}else p=o;if(t<n){g[F+16+4>>2]=t;q=t}else q=n;if(v<m){g[F+16+8>>2]=v;r=v}else r=m;g[F>>2]=o;g[F+4>>2]=n;g[F+8>>2]=m;g[F+12>>2]=0.0;if(o<s){g[F>>2]=s;o=s}if(n<t){g[F+4>>2]=t;n=t}if(m<v){g[F+8>>2]=v;m=v}g[F+16>>2]=+g[F+288>>2]+p;g[F+16+4>>2]=+g[F+288+4>>2]+q;g[F+16+8>>2]=+g[F+288+8>>2]+r;g[F>>2]=+g[F+64>>2]+o;g[F+4>>2]=+g[F+64+4>>2]+n;g[F+8>>2]=+g[F+64+8>>2]+m;bc[c[(c[E>>2]|0)+64>>2]&127](E,F+352|0,F+16|0,F);i=F;return}}}function Qf(a){a=a|0;rG(a);return}function Rf(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=+e;f=f|0;h=h|0;var j=0;j=i;i=i+64|0;c[j+48>>2]=f;c[j+48+4>>2]=h;f=c[a+212>>2]|0;if(!(+g[f+4>>2]>=e)){i=j;return +e}c[j>>2]=c[a+216>>2];c[j+4>>2]=j+48;c[j+8>>2]=c[b>>2];c[j+8+4>>2]=c[b+4>>2];c[j+8+8>>2]=c[b+8>>2];c[j+8+12>>2]=c[b+12>>2];c[j+24>>2]=c[d>>2];c[j+24+4>>2]=c[d+4>>2];c[j+24+8>>2]=c[d+8>>2];c[j+24+12>>2]=c[d+12>>2];g[j+40>>2]=e;e=+Pb[c[(c[f>>2]|0)+12>>2]&15](f,j,1);i=j;return +e}function Sf(a){a=a|0;rG(a);return}function Tf(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=+e;f=f|0;h=h|0;var j=0;j=i;i=i+64|0;c[j+48>>2]=f;c[j+48+4>>2]=h;f=c[a+212>>2]|0;if(!(+g[f+4>>2]>=e)){i=j;return +e}c[j>>2]=c[a+216>>2];c[j+4>>2]=j+48;c[j+8>>2]=c[b>>2];c[j+8+4>>2]=c[b+4>>2];c[j+8+8>>2]=c[b+8>>2];c[j+8+12>>2]=c[b+12>>2];c[j+24>>2]=c[d>>2];c[j+24+4>>2]=c[d+4>>2];c[j+24+8>>2]=c[d+8>>2];c[j+24+12>>2]=c[d+12>>2];g[j+40>>2]=e;e=+Pb[c[(c[f>>2]|0)+12>>2]&15](f,j,1);i=j;return +e}function Uf(a){a=a|0;return}function Vf(a){a=a|0;rG(a);return}function Wf(a,b){a=a|0;b=b|0;a=c[a+12>>2]|0;return Ob[c[(c[a>>2]|0)+8>>2]&31](a,b)|0}function Xf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,g=0;e=i;i=i+16|0;c[e>>2]=-1;c[e+4>>2]=c[a+16>>2];if(!(c[b+4>>2]|0))c[b+4>>2]=e;g=c[a+12>>2]|0;f=+Pb[c[(c[g>>2]|0)+12>>2]&15](g,b,d);c[a+4>>2]=c[(c[a+12>>2]|0)+4>>2];i=e;return +f}function Yf(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=+h;var j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0.0;j=i;i=i+464|0;fs(10877);c[j+128>>2]=c[d>>2];c[j+128+4>>2]=c[d+4>>2];c[j+128+8>>2]=c[d+8>>2];c[j+128+12>>2]=c[d+12>>2];c[j+128+16>>2]=c[d+16>>2];c[j+128+16+4>>2]=c[d+16+4>>2];c[j+128+16+8>>2]=c[d+16+8>>2];c[j+128+16+12>>2]=c[d+16+12>>2];c[j+128+32>>2]=c[d+32>>2];c[j+128+32+4>>2]=c[d+32+4>>2];c[j+128+32+8>>2]=c[d+32+8>>2];c[j+128+32+12>>2]=c[d+32+12>>2];l=j+128+48|0;c[l>>2]=c[d+48>>2];c[l+4>>2]=c[d+48+4>>2];c[l+8>>2]=c[d+48+8>>2];c[l+12>>2]=c[d+48+12>>2];c[j+64>>2]=c[e>>2];c[j+64+4>>2]=c[e+4>>2];c[j+64+8>>2]=c[e+8>>2];c[j+64+12>>2]=c[e+12>>2];c[j+64+16>>2]=c[e+16>>2];c[j+64+16+4>>2]=c[e+16+4>>2];c[j+64+16+8>>2]=c[e+16+8>>2];c[j+64+16+12>>2]=c[e+16+12>>2];c[j+64+32>>2]=c[e+32>>2];c[j+64+32+4>>2]=c[e+32+4>>2];c[j+64+32+8>>2]=c[e+32+8>>2];c[j+64+32+12>>2]=c[e+32+12>>2];k=j+64+48|0;c[k>>2]=c[e+48>>2];c[k+4>>2]=c[e+48+4>>2];c[k+8>>2]=c[e+48+8>>2];c[k+12>>2]=c[e+48+12>>2];Zf(j+128|0,j+64|0,j+256|0,j+192|0);t=+g[j+192>>2];m=t*+g[j+256+4>>2];r=t*+g[j+256+8>>2];g[j+16>>2]=+g[j+256>>2]*t;g[j+16+4>>2]=m;g[j+16+8>>2]=r;g[j+16+12>>2]=0.0;c[j+256>>2]=0;c[j+256+4>>2]=0;c[j+256+8>>2]=0;c[j+256+12>>2]=0;c[j+192+4>>2]=0;c[j+192+4+4>>2]=0;c[j+192+24>>2]=0;c[j+192+24+4>>2]=0;s=j+192+44|0;c[s>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;c[s+12>>2]=0;c[s+16>>2]=0;_f(j+128|0,j);r=+g[j>>2];m=+g[j+4>>2];t=+g[j+8>>2];q=+g[j+12>>2];o=r*(2.0/(r*r+m*m+t*t+q*q));n=m*(2.0/(r*r+m*m+t*t+q*q));p=t*(2.0/(r*r+m*m+t*t+q*q));g[j+192>>2]=1.0-(m*n+t*p);g[j+192+4>>2]=r*n-q*p;g[j+192+8>>2]=r*p+q*n;g[j+192+12>>2]=0.0;g[j+192+16>>2]=r*n+q*p;g[j+192+20>>2]=1.0-(r*o+t*p);g[j+192+24>>2]=m*p-q*o;g[j+192+28>>2]=0.0;g[j+192+32>>2]=r*p-q*n;g[j+192+36>>2]=m*p+q*o;g[j+192+40>>2]=1.0-(r*o+m*n);g[s>>2]=0.0;_j(b,j+192|0,j+256|0,j+16|0,j+48|0,j+32|0);c[j+256>>2]=3524;c[j+256+36>>2]=c[d>>2];c[j+256+36+4>>2]=c[d+4>>2];c[j+256+36+8>>2]=c[d+8>>2];c[j+256+36+12>>2]=c[d+12>>2];c[j+256+52>>2]=c[d+16>>2];c[j+256+52+4>>2]=c[d+16+4>>2];c[j+256+52+8>>2]=c[d+16+8>>2];c[j+256+52+12>>2]=c[d+16+12>>2];c[j+256+68>>2]=c[d+32>>2];c[j+256+68+4>>2]=c[d+32+4>>2];c[j+256+68+8>>2]=c[d+32+8>>2];c[j+256+68+12>>2]=c[d+32+12>>2];s=j+256+84|0;c[s>>2]=c[d+48>>2];c[s+4>>2]=c[d+48+4>>2];c[s+8>>2]=c[d+48+8>>2];c[s+12>>2]=c[d+48+12>>2];c[j+256+100>>2]=c[e>>2];c[j+256+100+4>>2]=c[e+4>>2];c[j+256+100+8>>2]=c[e+8>>2];c[j+256+100+12>>2]=c[e+12>>2];c[j+256+116>>2]=c[e+16>>2];c[j+256+116+4>>2]=c[e+16+4>>2];c[j+256+116+8>>2]=c[e+16+8>>2];c[j+256+116+12>>2]=c[e+16+12>>2];c[j+256+132>>2]=c[e+32>>2];c[j+256+132+4>>2]=c[e+32+4>>2];c[j+256+132+8>>2]=c[e+32+8>>2];c[j+256+132+12>>2]=c[e+32+12>>2];d=j+256+148|0;c[d>>2]=c[e+48>>2];c[d+4>>2]=c[e+48+4>>2];c[d+8>>2]=c[e+48+8>>2];c[d+12>>2]=c[e+48+12>>2];c[j+256+180>>2]=a;c[j+256+184>>2]=f;g[j+256+188>>2]=h;c[j+256+192>>2]=b;n=+g[d>>2]-+g[s>>2];m=+g[j+256+152>>2]-+g[j+256+88>>2];o=+g[j+256+156>>2]-+g[j+256+92>>2];h=1.0/+O(+(n*n+m*m+o*o));r=n*h==0.0?999999984306749440.0:1.0/(n*h);g[j+256+4>>2]=r;q=m*h==0.0?999999984306749440.0:1.0/(m*h);g[j+256+8>>2]=q;p=o*h==0.0?999999984306749440.0:1.0/(o*h);g[j+256+12>>2]=p;c[j+256+20>>2]=r<0.0&1;c[j+256+24>>2]=q<0.0&1;c[j+256+28>>2]=p<0.0&1;g[j+256+32>>2]=o*(o*h)+(n*(n*h)+m*(m*h));b=c[a+68>>2]|0;Fb[c[(c[b>>2]|0)+24>>2]&7](b,l,k,j+256|0,j+48|0,j+32|0);b=c[2006]|0;a=(c[b+16>>2]|0)+-1|0;c[b+16>>2]=a;if(a|0){i=j;return}do if(c[b+4>>2]|0){kb(j+256|0,0)|0;s=c[5649]|0;g[b+8>>2]=+g[b+8>>2]+ +(((c[j+256+4>>2]|0)-(c[s+4>>2]|0)+(((c[j+256>>2]|0)-(c[s>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[b+16>>2]|0)){b=c[2006]|0;break}else{i=j;return}}while(0);c[2006]=c[b+20>>2];i=j;return}function Zf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0;l=i;i=i+64|0;n=+g[a+20>>2];u=+g[a+40>>2];p=+g[a+24>>2];s=+g[a+36>>2];t=+g[a+32>>2];m=+g[a+16>>2];k=+g[a>>2];j=+g[a+4>>2];q=+g[a+8>>2];h=1.0/((n*u-p*s)*k+j*(p*t-u*m)+(s*m-n*t)*q);z=+g[b>>2];y=+g[b+4>>2];A=+g[b+8>>2];x=+g[b+16>>2];w=+g[b+20>>2];v=+g[b+24>>2];r=+g[b+32>>2];o=+g[b+36>>2];f=+g[b+40>>2];g[l+16>>2]=A*((s*m-n*t)*h)+(z*((n*u-p*s)*h)+y*((p*t-u*m)*h));g[l+16+4>>2]=A*((t*j-s*k)*h)+(z*((s*q-u*j)*h)+y*((u*k-t*q)*h));g[l+16+8>>2]=A*((n*k-m*j)*h)+(z*((p*j-n*q)*h)+y*((m*q-p*k)*h));g[l+16+12>>2]=0.0;g[l+16+16>>2]=(n*u-p*s)*h*x+(p*t-u*m)*h*w+(s*m-n*t)*h*v;g[l+16+20>>2]=(s*q-u*j)*h*x+(u*k-t*q)*h*w+(t*j-s*k)*h*v;g[l+16+24>>2]=(p*j-n*q)*h*x+(m*q-p*k)*h*w+(n*k-m*j)*h*v;g[l+16+28>>2]=0.0;g[l+16+32>>2]=(n*u-p*s)*h*r+(p*t-u*m)*h*o+(s*m-n*t)*h*f;g[l+16+36>>2]=(s*q-u*j)*h*r+(u*k-t*q)*h*o+(t*j-s*k)*h*f;g[l+16+40>>2]=(p*j-n*q)*h*r+(m*q-p*k)*h*o+(n*k-m*j)*h*f;g[l+16+44>>2]=0.0;_f(l+16|0,l);f=+g[l>>2];h=+g[l+4>>2];j=+g[l+8>>2];m=+g[l+12>>2];k=1.0/+O(+(f*f+h*h+j*j+m*m));g[l>>2]=f*k;g[l+4>>2]=h*k;g[l+8>>2]=j*k;g[l+12>>2]=m*k;m=m*k<-1.0?-1.0:m*k;g[e>>2]=+T(+(m>1.0?1.0:m))*2.0;g[d>>2]=f*k;g[d+4>>2]=h*k;g[d+8>>2]=j*k;g[d+12>>2]=0.0;if(f*k*(f*k)+h*k*(h*k)+j*k*(j*k)<1.4210854715202004e-14){c[d>>2]=1065353216;c[d+4>>2]=0;c[d+8>>2]=0;g[d+12>>2]=0.0;i=l;return}else{A=1.0/+O(+(f*k*(f*k)+h*k*(h*k)+j*k*(j*k)));g[d>>2]=f*k*A;g[d+4>>2]=A*(h*k);g[d+8>>2]=A*(j*k);i=l;return}}function _f(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0,j=0,l=0,m=0,n=0.0;h=i;i=i+16|0;d=+g[a>>2];e=+g[a+20>>2];f=+g[a+40>>2];if(d+e+f>0.0){f=+O(+(d+e+f+1.0));g[h+12>>2]=f*.5;n=.5/f*(+g[a+36>>2]-+g[a+24>>2]);g[h>>2]=n;d=.5/f*(+g[a+8>>2]-+g[a+32>>2]);g[h+4>>2]=d;e=.5/f*(+g[a+16>>2]-+g[a+4>>2]);g[h+8>>2]=e;a=(g[k>>2]=n,c[k>>2]|0);m=(g[k>>2]=d,c[k>>2]|0);l=(g[k>>2]=e,c[k>>2]|0);j=(g[k>>2]=f*.5,c[k>>2]|0);c[b>>2]=a;a=b+4|0;c[a>>2]=m;a=b+8|0;c[a>>2]=l;a=b+12|0;c[a>>2]=j;i=h;return}else{m=d<e?(e<f?2:1):d<f?2:0;n=+O(+(+g[a+(m<<4)+(m<<2)>>2]-+g[a+((((m+1|0)>>>0)%3|0)<<4)+((((m+1|0)>>>0)%3|0)<<2)>>2]-+g[a+((((m+2|0)>>>0)%3|0)<<4)+((((m+2|0)>>>0)%3|0)<<2)>>2]+1.0));g[h+(m<<2)>>2]=n*.5;g[h+12>>2]=.5/n*(+g[a+((((m+2|0)>>>0)%3|0)<<4)+((((m+1|0)>>>0)%3|0)<<2)>>2]-+g[a+((((m+1|0)>>>0)%3|0)<<4)+((((m+2|0)>>>0)%3|0)<<2)>>2]);g[h+((((m+1|0)>>>0)%3|0)<<2)>>2]=.5/n*(+g[a+((((m+1|0)>>>0)%3|0)<<4)+(m<<2)>>2]+ +g[a+(m<<4)+((((m+1|0)>>>0)%3|0)<<2)>>2]);g[h+((((m+2|0)>>>0)%3|0)<<2)>>2]=.5/n*(+g[a+((((m+2|0)>>>0)%3|0)<<4)+(m<<2)>>2]+ +g[a+(m<<4)+((((m+2|0)>>>0)%3|0)<<2)>>2]);m=c[h>>2]|0;a=c[h+4>>2]|0;j=c[h+8>>2]|0;l=c[h+12>>2]|0;c[b>>2]=m;m=b+4|0;c[m>>2]=a;m=b+8|0;c[m>>2]=j;m=b+12|0;c[m>>2]=l;i=h;return}}function $f(a){a=a|0;rG(a);return}function ag(a,b){a=a|0;b=b|0;var d=0,e=0,f=0.0,h=0,j=0;e=i;i=i+32|0;d=c[a+184>>2]|0;if(+g[d+4>>2]==0.0){a=0;i=e;return a|0}b=c[b>>2]|0;if(!(Ob[c[(c[d>>2]|0)+8>>2]&31](d,c[b+188>>2]|0)|0)){a=1;i=e;return a|0}h=c[a+192>>2]|0;j=c[b+192>>2]|0;d=c[a+184>>2]|0;f=+g[a+188>>2];c[e>>2]=0;c[e+4>>2]=j;c[e+8>>2]=b;c[e+12>>2]=b+4;c[e+16>>2]=-1;c[e+20>>2]=-1;Pf(h,a+36|0,a+100|0,e,d,f);a=1;i=e;return a|0}function bg(a){a=a|0;rG(a);return}function cg(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+96|0;b=c[b>>2]|0;if((b|0)==(c[a+4>>2]|0)){i=d;return 1}e=c[a+12>>2]|0;if(!(Ob[c[(c[e>>2]|0)+8>>2]&31](e,c[b+188>>2]|0)|0)){i=d;return 1}e=c[a+4>>2]|0;f=c[e+192>>2]|0;c[d+64>>2]=0;c[d+64+4>>2]=f;c[d+64+8>>2]=e;c[d+64+12>>2]=e+4;c[d+64+16>>2]=-1;c[d+64+20>>2]=-1;e=c[b+192>>2]|0;c[d+40>>2]=0;c[d+40+4>>2]=e;c[d+40+8>>2]=b;c[d+40+12>>2]=b+4;c[d+40+16>>2]=-1;c[d+40+20>>2]=-1;b=c[(c[a+8>>2]|0)+24>>2]|0;b=zb[c[(c[b>>2]|0)+8>>2]&31](b,d+64|0,d+40|0,0)|0;if(b|0){f=c[a+12>>2]|0;c[d+4>>2]=0;c[d+8>>2]=d+64;c[d+12>>2]=d+40;c[d>>2]=3564;c[d+32>>2]=f;pb[c[(c[b>>2]|0)+8>>2]&31](b,d+64|0,d+40|0,(c[a+8>>2]|0)+28|0,d);rb[c[c[b>>2]>>2]&255](b);f=c[(c[a+8>>2]|0)+24>>2]|0;tb[c[(c[f>>2]|0)+60>>2]&127](f,b)}i=d;return 1}function dg(a){a=a|0;return}function eg(a){a=a|0;rG(a);return}function fg(a,b,d){a=a|0;b=b|0;d=d|0;c[a+16>>2]=b;c[a+24>>2]=d;return}function gg(a,b,d){a=a|0;b=b|0;d=d|0;c[a+20>>2]=b;c[a+28>>2]=d;return}function hg(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0.0,j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0,z=0,A=0;y=i;i=i+192|0;w=c[(c[b+4>>2]|0)+740>>2]|0;x=c[(c[b+8>>2]|0)+8>>2]|0;j=+g[e>>2];t=+g[d>>2]*f+j;k=+g[e+4>>2];u=+g[d+4>>2]*f+k;h=+g[e+8>>2];v=+g[d+8>>2]*f+h;l=c[(c[b+12>>2]|0)+8>>2]|0;m=+g[l+52>>2];n=+g[l+56>>2];if((w|0)!=(x|0)){q=v-+g[l+60>>2];j=j-+g[x+52>>2];k=k-+g[x+56>>2];h=h-+g[x+60>>2];o=(t-m)*+g[l+4>>2]+(u-n)*+g[l+20>>2]+q*+g[l+36>>2];p=(t-m)*+g[l+8>>2]+(u-n)*+g[l+24>>2]+q*+g[l+40>>2];q=(t-m)*+g[l+12>>2]+(u-n)*+g[l+28>>2]+q*+g[l+44>>2];r=j*+g[x+4>>2]+k*+g[x+20>>2]+h*+g[x+36>>2];s=j*+g[x+8>>2]+k*+g[x+24>>2]+h*+g[x+40>>2];h=j*+g[x+12>>2]+k*+g[x+28>>2]+h*+g[x+44>>2]}else{s=t-+g[w+52>>2];r=u-+g[w+56>>2];q=v-+g[w+60>>2];h=h-+g[l+60>>2];o=s*+g[w+4>>2]+r*+g[w+20>>2]+q*+g[w+36>>2];p=s*+g[w+8>>2]+r*+g[w+24>>2]+q*+g[w+40>>2];q=s*+g[w+12>>2]+r*+g[w+28>>2]+q*+g[w+44>>2];r=(j-m)*+g[l+4>>2]+(k-n)*+g[l+20>>2]+h*+g[l+36>>2];s=(j-m)*+g[l+8>>2]+(k-n)*+g[l+24>>2]+h*+g[l+40>>2];h=(j-m)*+g[l+12>>2]+(k-n)*+g[l+28>>2]+h*+g[l+44>>2]}g[y>>2]=o;g[y+4>>2]=p;g[y+8>>2]=q;g[y+12>>2]=0.0;g[y+16>>2]=r;g[y+20>>2]=s;g[y+24>>2]=h;g[y+28>>2]=0.0;c[y+64>>2]=c[d>>2];c[y+64+4>>2]=c[d+4>>2];c[y+64+8>>2]=c[d+8>>2];c[y+64+12>>2]=c[d+12>>2];g[y+80>>2]=f;g[y+84>>2]=0.0;g[y+88>>2]=0.0;g[y+92>>2]=0.0;c[y+112>>2]=0;a[y+116>>0]=0;c[y+120>>2]=0;c[y+120+4>>2]=0;c[y+120+8>>2]=0;c[y+120+12>>2]=0;c[y+120+16>>2]=0;c[y+120+20>>2]=0;c[y+120+24>>2]=0;c[y+120+28>>2]=0;g[y+48>>2]=t;g[y+52>>2]=u;g[y+56>>2]=v;g[y+60>>2]=0.0;c[y+32>>2]=c[e>>2];c[y+32+4>>2]=c[e+4>>2];c[y+32+8>>2]=c[e+8>>2];c[y+32+12>>2]=c[e+12>>2];d=c[b+20>>2]|0;l=c[b+16>>2]|0;e=c[b+28>>2]|0;A=c[b+24>>2]|0;z=(w|0)!=(x|0)?d:l;d=(w|0)!=(x|0)?l:d;l=(w|0)!=(x|0)?e:A;e=(w|0)!=(x|0)?A:e;c[y+96>>2]=z;c[y+100>>2]=d;c[y+104>>2]=l;c[y+108>>2]=e;A=c[b+32>>2]|0;+Bb[c[(c[A>>2]|0)+12>>2]&1](A,y,c[((w|0)!=(x|0)?b+12|0:b+8|0)>>2]|0,z,l,c[((w|0)!=(x|0)?b+8|0:b+12|0)>>2]|0,d,e);i=y;return}function ig(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+96|0;g=c[b+192>>2]|0;c[f+64>>2]=0;c[f+64+4>>2]=g;c[f+64+8>>2]=b;c[f+64+12>>2]=b+4;c[f+64+16>>2]=-1;c[f+64+20>>2]=-1;b=c[d+192>>2]|0;c[f+40>>2]=0;c[f+40+4>>2]=b;c[f+40+8>>2]=d;c[f+40+12>>2]=d+4;c[f+40+16>>2]=-1;c[f+40+20>>2]=-1;b=c[a+24>>2]|0;b=zb[c[(c[b>>2]|0)+8>>2]&31](b,f+64|0,f+40|0,0)|0;if(!b){i=f;return}c[f+4>>2]=0;c[f+8>>2]=f+64;c[f+12>>2]=f+40;c[f>>2]=3564;c[f+32>>2]=e;pb[c[(c[b>>2]|0)+8>>2]&31](b,f+64|0,f+40|0,a+28|0,f);rb[c[c[b>>2]>>2]&255](b);g=c[a+24>>2]|0;tb[c[(c[g>>2]|0)+60>>2]&127](g,b);i=f;return}function jg(b){b=b|0;var d=0,e=0,f=0;c[b>>2]=3592;d=c[b+12>>2]|0;if((d|0)>0){f=0;do{e=c[(c[b+20>>2]|0)+(f<<2)>>2]|0;if(e|0){rb[c[c[e>>2]>>2]&255](e);e=c[b+4>>2]|0;tb[c[(c[e>>2]|0)+60>>2]&127](e,c[(c[b+20>>2]|0)+(f<<2)>>2]|0)}f=f+1|0}while((f|0)!=(d|0))}d=c[b+20>>2]|0;if(!d){a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;b=b+16|0;c[b>>2]=0;return}if(a[b+24>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+20>>2]=0;a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;b=b+16|0;c[b>>2]=0;return}function kg(a){a=a|0;jg(a);rG(a);return}function lg(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0;s=i;i=i+224|0;q=(a[b+28>>0]|0)!=0;p=q?e:d;q=q?d:e;r=c[p+4>>2]|0;if((c[r+72>>2]|0)!=(c[b+40>>2]|0)){j=c[b+12>>2]|0;if((j|0)>0){l=0;do{k=c[(c[b+20>>2]|0)+(l<<2)>>2]|0;if(k|0){rb[c[c[k>>2]>>2]&255](k);n=c[b+4>>2]|0;tb[c[(c[n>>2]|0)+60>>2]&127](n,c[(c[b+20>>2]|0)+(l<<2)>>2]|0)}l=l+1|0}while((l|0)!=(j|0))}mg(b,d,e);c[b+40>>2]=c[r+72>>2]}j=c[b+12>>2]|0;if(!j){i=s;return}n=c[r+68>>2]|0;l=c[b+4>>2]|0;k=c[b+20>>2]|0;m=c[b+32>>2]|0;c[s+192>>2]=3620;c[s+192+4>>2]=p;c[s+192+8>>2]=q;c[s+192+12>>2]=l;c[s+192+16>>2]=f;c[s+192+20>>2]=h;c[s+192+24>>2]=k;c[s+192+28>>2]=m;a[s+128+16>>0]=1;m=s+128+12|0;c[m>>2]=0;c[s+128+4>>2]=0;c[s+128+8>>2]=0;if((j|0)>0){d=k;f=0;while(1){k=c[d+(f<<2)>>2]|0;if(k){tb[c[(c[k>>2]|0)+16>>2]&127](k,s+128|0);j=c[s+128+4>>2]|0;if((j|0)>0){l=0;do{e=c[(c[m>>2]|0)+(l<<2)>>2]|0;if(c[e+748>>2]|0){c[h+4>>2]=e;j=c[e+740>>2]|0;k=c[(c[h+8>>2]|0)+8>>2]|0;d=c[(c[h+12>>2]|0)+8>>2]|0;if((j|0)==(k|0))Xn(e,j+4|0,d+4|0);else Xn(e,d+4|0,k+4|0);c[h+4>>2]=0;j=c[s+128+4>>2]|0}l=l+1|0}while((l|0)<(j|0))}if((j|0)<0){if((c[s+128+8>>2]|0)<0){k=c[m>>2]|0;if(k|0){if(a[s+128+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[k+-4>>2]|0)}c[m>>2]=0}a[s+128+16>>0]=1;c[m>>2]=0;c[s+128+8>>2]=0}do{c[(c[m>>2]|0)+(j<<2)>>2]=0;j=j+1|0}while((j|0)!=0)}c[s+128+4>>2]=0;j=c[b+12>>2]|0}k=f+1|0;if((k|0)>=(j|0))break;d=c[b+20>>2]|0;f=k}j=c[m>>2]|0;if(j|0){if(a[s+128+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0)}c[m>>2]=0}}if(!n){k=c[b+12>>2]|0;if((k|0)>0){j=0;do{pg(s+192|0,c[(c[r+28>>2]|0)+(j*80|0)+64>>2]|0,j);j=j+1|0}while((j|0)<(k|0));o=39}}else{o=c[p+12>>2]|0;H=+g[o>>2];G=+g[o+16>>2];F=+g[o+32>>2];E=+g[o+4>>2];D=+g[o+20>>2];C=+g[o+36>>2];y=+g[o+8>>2];w=+g[o+24>>2];u=+g[o+40>>2];B=-+g[o+48>>2];A=-+g[o+52>>2];z=-+g[o+56>>2];o=c[q+12>>2]|0;Q=+g[o>>2];P=+g[o+16>>2];O=+g[o+32>>2];N=+g[o+4>>2];M=+g[o+20>>2];L=+g[o+36>>2];K=+g[o+8>>2];J=+g[o+24>>2];I=+g[o+40>>2];x=+g[o+48>>2];v=+g[o+52>>2];t=+g[o+56>>2];g[s+48>>2]=H*Q+G*P+F*O;g[s+48+4>>2]=H*N+G*M+F*L;g[s+48+8>>2]=H*K+G*J+F*I;g[s+48+12>>2]=0.0;g[s+48+16>>2]=E*Q+D*P+C*O;g[s+48+20>>2]=E*N+D*M+C*L;g[s+48+24>>2]=E*K+D*J+C*I;g[s+48+28>>2]=0.0;g[s+48+32>>2]=y*Q+w*P+u*O;g[s+48+36>>2]=y*N+w*M+u*L;g[s+48+40>>2]=y*K+w*J+u*I;g[s+48+44>>2]=0.0;g[s+48+48>>2]=H*B+G*A+F*z+(H*x+G*v+F*t);g[s+48+52>>2]=E*B+D*A+C*z+(E*x+D*v+C*t);g[s+48+56>>2]=y*B+w*A+u*z+(y*x+w*v+u*t);g[s+48+60>>2]=0.0;o=c[q+4>>2]|0;bc[c[(c[o>>2]|0)+8>>2]&127](o,s+48|0,s+128|0,s+112|0);c[s+16>>2]=c[s+128>>2];c[s+16+4>>2]=c[s+128+4>>2];c[s+16+8>>2]=c[s+128+8>>2];c[s+16+12>>2]=c[s+128+12>>2];c[s+16+16>>2]=c[s+112>>2];c[s+16+16+4>>2]=c[s+112+4>>2];c[s+16+16+8>>2]=c[s+112+8>>2];c[s+16+16+12>>2]=c[s+112+12>>2];od(c[n>>2]|0,s+16|0,s+192|0);o=39}if((o|0)==39)k=c[b+12>>2]|0;if((k|0)>0){d=0;do{do if(c[(c[b+20>>2]|0)+(d<<2)>>2]|0){n=c[r+28>>2]|0;o=c[n+(d*80|0)+64>>2]|0;h=c[p+12>>2]|0;w=+g[h>>2];x=+g[h+4>>2];y=+g[h+8>>2];z=+g[h+16>>2];A=+g[h+20>>2];B=+g[h+24>>2];I=+g[h+32>>2];K=+g[h+36>>2];M=+g[h+40>>2];C=+g[n+(d*80|0)>>2];D=+g[n+(d*80|0)+16>>2];E=+g[n+(d*80|0)+32>>2];F=+g[n+(d*80|0)+4>>2];G=+g[n+(d*80|0)+20>>2];H=+g[n+(d*80|0)+36>>2];J=+g[n+(d*80|0)+8>>2];L=+g[n+(d*80|0)+24>>2];N=+g[n+(d*80|0)+40>>2];u=+g[n+(d*80|0)+48>>2];v=+g[n+(d*80|0)+52>>2];Q=+g[n+(d*80|0)+56>>2];O=+g[h+48>>2]+(w*u+x*v+y*Q);P=+g[h+52>>2]+(z*u+A*v+B*Q);Q=+g[h+56>>2]+(I*u+K*v+M*Q);g[s+128>>2]=w*C+x*D+y*E;g[s+128+4>>2]=w*F+x*G+y*H;g[s+128+8>>2]=w*J+x*L+y*N;g[s+128+12>>2]=0.0;g[s+128+16>>2]=z*C+A*D+B*E;g[s+128+20>>2]=z*F+A*G+B*H;g[s+128+24>>2]=z*J+A*L+B*N;g[s+128+28>>2]=0.0;g[s+128+32>>2]=I*C+K*D+M*E;g[s+128+36>>2]=I*F+K*G+M*H;g[s+128+40>>2]=I*J+K*L+M*N;g[s+128+44>>2]=0.0;g[s+128+48>>2]=O;g[s+128+52>>2]=P;g[s+128+56>>2]=Q;g[s+128+60>>2]=0.0;bc[c[(c[o>>2]|0)+8>>2]&127](o,s+128|0,s+112|0,s+48|0);o=c[q+4>>2]|0;bc[c[(c[o>>2]|0)+8>>2]&127](o,c[q+12>>2]|0,s+16|0,s);if(!(+g[s+112>>2]>+g[s>>2])?!(+g[s+48>>2]<+g[s+16>>2]):0)j=1;else j=0;if(!(!(+g[s+112+8>>2]>+g[s+8>>2])?!(+g[s+48+8>>2]<+g[s+16+8>>2]):0))j=0;if(!(+g[s+112+4>>2]>+g[s+4>>2])?!(+g[s+48+4>>2]<+g[s+16+4>>2]|j^1):0)break;o=c[(c[b+20>>2]|0)+(d<<2)>>2]|0;rb[c[c[o>>2]>>2]&255](o);o=c[b+4>>2]|0;tb[c[(c[o>>2]|0)+60>>2]&127](o,c[(c[b+20>>2]|0)+(d<<2)>>2]|0);c[(c[b+20>>2]|0)+(d<<2)>>2]=0}while(0);d=d+1|0}while((d|0)<(k|0))}i=s;return}function mg(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+32|0;h=(a[b+28>>0]|0)!=0;l=h?e:d;h=h?d:e;j=c[l+4>>2]|0;k=c[j+20>>2]|0;g=c[b+12>>2]|0;if((g|0)<(k|0)){if((c[b+16>>2]|0)<(k|0)){if(!k){d=0;e=g}else{c[5637]=(c[5637]|0)+1;d=qG((k<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=c[b+12>>2]|0}if((e|0)>0){f=0;do{c[d+(f<<2)>>2]=c[(c[b+20>>2]|0)+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}e=c[b+20>>2]|0;if(e|0){if(a[b+24>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0)}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=d;c[b+16>>2]=k;e=b+20|0}else e=b+20|0;d=g;do{c[(c[e>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=(k|0))}c[b+12>>2]=k;if((k|0)<=0){i=m;return}d=0;do{if(!(c[j+68>>2]|0)){e=c[(c[j+28>>2]|0)+(d*80|0)+64>>2]|0;f=c[l+8>>2]|0;g=c[l+12>>2]|0;c[m>>2]=l;c[m+4>>2]=e;c[m+8>>2]=f;c[m+12>>2]=g;c[m+16>>2]=-1;c[m+20>>2]=d;g=c[b+4>>2]|0;g=zb[c[(c[g>>2]|0)+8>>2]&31](g,m,h,c[b+32>>2]|0)|0;c[(c[b+20>>2]|0)+(d<<2)>>2]=g}else c[(c[b+20>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=(k|0));i=m;return}function ng(a){a=a|0;rG(a);return}function og(a,b){a=a|0;b=b|0;b=c[b+36>>2]|0;pg(a,c[(c[(c[(c[a+4>>2]|0)+4>>2]|0)+28>>2]|0)+(b*80|0)+64>>2]|0,b);return}function pg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0;h=i;i=i+160|0;e=c[a+4>>2]|0;f=c[e+12>>2]|0;D=+g[f>>2];C=+g[f+4>>2];B=+g[f+8>>2];A=+g[f+16>>2];z=+g[f+20>>2];y=+g[f+24>>2];r=+g[f+32>>2];p=+g[f+36>>2];n=+g[f+40>>2];e=c[(c[e+4>>2]|0)+28>>2]|0;x=+g[e+(d*80|0)>>2];w=+g[e+(d*80|0)+16>>2];v=+g[e+(d*80|0)+32>>2];u=+g[e+(d*80|0)+4>>2];t=+g[e+(d*80|0)+20>>2];s=+g[e+(d*80|0)+36>>2];q=+g[e+(d*80|0)+8>>2];o=+g[e+(d*80|0)+24>>2];m=+g[e+(d*80|0)+40>>2];F=+g[e+(d*80|0)+48>>2];E=+g[e+(d*80|0)+52>>2];j=+g[e+(d*80|0)+56>>2];l=+g[f+48>>2]+(D*F+C*E+B*j);k=+g[f+52>>2]+(A*F+z*E+y*j);j=+g[f+56>>2]+(r*F+p*E+n*j);g[h+88>>2]=D*x+C*w+B*v;g[h+88+4>>2]=D*u+C*t+B*s;g[h+88+8>>2]=D*q+C*o+B*m;g[h+88+12>>2]=0.0;g[h+88+16>>2]=A*x+z*w+y*v;g[h+88+20>>2]=A*u+z*t+y*s;g[h+88+24>>2]=A*q+z*o+y*m;g[h+88+28>>2]=0.0;g[h+88+32>>2]=r*x+p*w+n*v;g[h+88+36>>2]=r*u+p*t+n*s;g[h+88+40>>2]=r*q+p*o+n*m;g[h+88+44>>2]=0.0;g[h+88+48>>2]=l;g[h+88+52>>2]=k;g[h+88+56>>2]=j;g[h+88+60>>2]=0.0;bc[c[(c[b>>2]|0)+8>>2]&127](b,h+88|0,h+72|0,h+56|0);f=c[a+8>>2]|0;e=c[f+4>>2]|0;bc[c[(c[e>>2]|0)+8>>2]&127](e,c[f+12>>2]|0,h+40|0,h+24|0);if(!(+g[h+72>>2]>+g[h+24>>2])?!(+g[h+56>>2]<+g[h+40>>2]):0)e=1;else e=0;if(!(!(+g[h+72+8>>2]>+g[h+24+8>>2])?!(+g[h+56+8>>2]<+g[h+40+8>>2]):0))e=0;if(+g[h+72+4>>2]>+g[h+24+4>>2]){i=h;return}if(+g[h+56+4>>2]<+g[h+40+4>>2]|e^1){i=h;return}e=c[a+4>>2]|0;f=c[e+8>>2]|0;c[h>>2]=e;c[h+4>>2]=b;c[h+8>>2]=f;c[h+12>>2]=h+88;c[h+16>>2]=-1;c[h+20>>2]=d;if(!(c[(c[a+24>>2]|0)+(d<<2)>>2]|0)){e=c[a+12>>2]|0;e=zb[c[(c[e>>2]|0)+8>>2]&31](e,h,c[a+8>>2]|0,c[a+28>>2]|0)|0;c[(c[a+24>>2]|0)+(d<<2)>>2]=e;e=c[a+4>>2]|0}f=c[a+20>>2]|0;b=c[f+8>>2]|0;if((c[b+8>>2]|0)==(c[e+8>>2]|0)){c[f+8>>2]=h;Zb[c[(c[f>>2]|0)+8>>2]&127](f,-1,d)}else{b=c[f+12>>2]|0;c[f+12>>2]=h;Zb[c[(c[f>>2]|0)+12>>2]&127](f,-1,d)}e=c[(c[a+24>>2]|0)+(d<<2)>>2]|0;pb[c[(c[e>>2]|0)+8>>2]&31](e,h,c[a+8>>2]|0,c[a+16>>2]|0,c[a+20>>2]|0);e=c[a+20>>2]|0;if((c[(c[e+8>>2]|0)+8>>2]|0)==(c[(c[a+4>>2]|0)+8>>2]|0))c[e+8>>2]=b;else c[e+12>>2]=b;i=h;return}function qg(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0.0,u=0.0,v=0,w=0.0,x=0,y=0,z=0,A=0,B=0,C=0,D=0.0,E=0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0;z=(a[b+28>>0]|0)!=0;C=z?e:d;z=z?d:e;A=c[b+12>>2]|0;if((A|0)<=0){w=1.0;return +w}y=(c[C+192>>2]|0)+28|0;j=+g[C+4>>2];t=+g[C+8>>2];u=+g[C+12>>2];v=c[C+16>>2]|0;w=+g[C+20>>2];k=+g[C+24>>2];l=+g[C+28>>2];d=c[C+32>>2]|0;m=+g[C+36>>2];n=+g[C+40>>2];o=+g[C+44>>2];e=c[C+48>>2]|0;p=+g[C+52>>2];q=+g[C+56>>2];r=+g[C+60>>2];s=c[C+64>>2]|0;x=c[C+284>>2]|0;i=1.0;B=0;do{E=c[y>>2]|0;P=+g[E+(B*80|0)>>2];O=+g[E+(B*80|0)+16>>2];N=+g[E+(B*80|0)+32>>2];M=+g[E+(B*80|0)+4>>2];L=+g[E+(B*80|0)+20>>2];K=+g[E+(B*80|0)+36>>2];J=+g[E+(B*80|0)+8>>2];I=+g[E+(B*80|0)+24>>2];H=+g[E+(B*80|0)+40>>2];G=+g[E+(B*80|0)+48>>2];F=+g[E+(B*80|0)+52>>2];D=+g[E+(B*80|0)+56>>2];c[C+284>>2]=x+1;g[C+4>>2]=j*P+t*O+u*N;g[C+8>>2]=j*M+t*L+u*K;g[C+12>>2]=j*J+t*I+u*H;g[C+16>>2]=0.0;g[C+20>>2]=w*P+k*O+l*N;g[C+24>>2]=w*M+k*L+l*K;g[C+28>>2]=w*J+k*I+l*H;g[C+32>>2]=0.0;g[C+36>>2]=m*P+n*O+o*N;g[C+40>>2]=m*M+n*L+o*K;g[C+44>>2]=m*J+n*I+o*H;g[C+48>>2]=0.0;g[C+52>>2]=p+(j*G+t*F+u*D);g[C+56>>2]=q+(w*G+k*F+l*D);g[C+60>>2]=r+(m*G+n*F+o*D);g[C+64>>2]=0.0;E=c[(c[b+20>>2]|0)+(B<<2)>>2]|0;D=+Db[c[(c[E>>2]|0)+12>>2]&15](E,C,z,f,h);i=D<i?D:i;x=(c[C+284>>2]|0)+1|0;c[C+284>>2]=x;g[C+4>>2]=j;g[C+8>>2]=t;g[C+12>>2]=u;c[C+16>>2]=v;g[C+20>>2]=w;g[C+24>>2]=k;g[C+28>>2]=l;c[C+32>>2]=d;g[C+36>>2]=m;g[C+40>>2]=n;g[C+44>>2]=o;c[C+48>>2]=e;g[C+52>>2]=p;g[C+56>>2]=q;g[C+60>>2]=r;c[C+64>>2]=s;B=B+1|0}while((B|0)!=(A|0));return +i}function rg(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=c[a+12>>2]|0;if((d|0)<=0)return;f=0;do{e=c[(c[a+20>>2]|0)+(f<<2)>>2]|0;if(e){tb[c[(c[e>>2]|0)+16>>2]&127](e,b);d=c[a+12>>2]|0}f=f+1|0}while((f|0)<(d|0));return}function sg(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;c[b+4>>2]=c[d>>2];c[b>>2]=3592;a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;a[b+28>>0]=g&1;c[b+32>>2]=c[d+4>>2];a[b+36>>0]=0;c[b+40>>2]=c[(c[(g?f:e)+4>>2]|0)+72>>2];mg(b,e,f);return}function tg(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;c[b>>2]=3656;d=c[b+44>>2]|0;e=c[d+8>>2]|0;if((e|0)>0){g=0;do{f=c[(c[d+16>>2]|0)+(g*12|0)+8>>2]|0;if(f|0){rb[c[c[f>>2]>>2]&255](f);h=c[b+4>>2]|0;tb[c[(c[h>>2]|0)+60>>2]&127](h,f)}g=g+1|0}while((g|0)!=(e|0));d=c[b+44>>2]|0}wi(d);d=c[b+44>>2]|0;rb[c[c[d>>2]>>2]&255](d);d=c[b+44>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+60>>2]|0;if(!d){a[b+64>>0]=1;c[b+60>>2]=0;c[b+52>>2]=0;h=b+56|0;c[h>>2]=0;jg(b);return}if(a[b+64>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+60>>2]=0;a[b+64>>0]=1;c[b+60>>2]=0;c[b+52>>2]=0;h=b+56|0;c[h>>2]=0;jg(b);return}function ug(a){a=a|0;tg(a);rG(a);return}function vg(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0,na=0.0,oa=0.0,pa=0.0;ea=i;i=i+176|0;ba=c[d+4>>2]|0;ca=c[e+4>>2]|0;r=c[ba+68>>2]|0;s=c[ca+68>>2]|0;if(!((r|0)!=0&(s|0)!=0)){lg(b,d,e,f,h);i=ea;return}if((c[ba+72>>2]|0)==(c[b+68>>2]|0)?(c[ca+72>>2]|0)==(c[b+72>>2]|0):0)aa=b+44|0;else{j=c[b+44>>2]|0;k=c[j+8>>2]|0;if((k|0)>0){m=0;do{l=c[(c[j+16>>2]|0)+(m*12|0)+8>>2]|0;if(l|0){rb[c[c[l>>2]>>2]&255](l);aa=c[b+4>>2]|0;tb[c[(c[aa>>2]|0)+60>>2]&127](aa,l)}m=m+1|0}while((m|0)!=(k|0));j=c[b+44>>2]|0}wi(j);c[b+68>>2]=c[ba+72>>2];c[b+72>>2]=c[ca+72>>2];aa=b+44|0}a[ea+128+16>>0]=1;q=ea+128+12|0;c[q>>2]=0;c[ea+128+4>>2]=0;c[ea+128+8>>2]=0;p=c[aa>>2]|0;j=c[p+8>>2]|0;if((j|0)>0){o=0;do{k=c[(c[p+16>>2]|0)+(o*12|0)+8>>2]|0;if(k){tb[c[(c[k>>2]|0)+16>>2]&127](k,ea+128|0);j=c[ea+128+4>>2]|0;if((j|0)>0){n=0;do{m=c[(c[q>>2]|0)+(n<<2)>>2]|0;if(c[m+748>>2]|0){c[h+4>>2]=m;j=c[m+740>>2]|0;k=c[(c[h+8>>2]|0)+8>>2]|0;l=c[(c[h+12>>2]|0)+8>>2]|0;if((j|0)==(k|0))Xn(m,j+4|0,l+4|0);else Xn(m,l+4|0,k+4|0);c[h+4>>2]=0;j=c[ea+128+4>>2]|0}n=n+1|0}while((n|0)<(j|0))}if((j|0)<0){if((c[ea+128+8>>2]|0)<0){k=c[q>>2]|0;if(k|0){if(a[ea+128+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[k+-4>>2]|0)}c[q>>2]=0}a[ea+128+16>>0]=1;c[q>>2]=0;c[ea+128+8>>2]=0}do{c[(c[q>>2]|0)+(j<<2)>>2]=0;j=j+1|0}while((j|0)!=0)}c[ea+128+4>>2]=0;j=c[p+8>>2]|0}o=o+1|0}while((o|0)<(j|0));j=c[q>>2]|0;if(j|0){if(a[ea+128+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0)}c[q>>2]=0}}q=c[b+4>>2]|0;k=c[aa>>2]|0;l=c[b+32>>2]|0;c[ea+128>>2]=3684;c[ea+128+4>>2]=0;c[ea+128+8>>2]=d;c[ea+128+12>>2]=e;c[ea+128+16>>2]=q;c[ea+128+20>>2]=f;c[ea+128+24>>2]=h;c[ea+128+28>>2]=k;c[ea+128+32>>2]=l;l=c[d+12>>2]|0;C=+g[l>>2];D=+g[l+16>>2];E=+g[l+32>>2];F=+g[l+4>>2];G=+g[l+20>>2];H=+g[l+36>>2];I=+g[l+8>>2];J=+g[l+24>>2];K=+g[l+40>>2];L=-+g[l+48>>2];M=-+g[l+52>>2];O=-+g[l+56>>2];l=c[e+12>>2]|0;P=+g[l>>2];Q=+g[l+16>>2];R=+g[l+32>>2];S=+g[l+4>>2];T=+g[l+20>>2];U=+g[l+36>>2];V=+g[l+8>>2];W=+g[l+24>>2];X=+g[l+40>>2];Y=+g[l+48>>2];Z=+g[l+52>>2];_=+g[l+56>>2];l=c[r>>2]|0;k=c[s>>2]|0;if((l|0)!=0&(k|0)!=0){c[5637]=(c[5637]|0)+1;j=qG(1043)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}c[j>>2]=l;c[j+4>>2]=k;t=+N(+(C*P+D*Q+E*R));u=+N(+(C*S+D*T+E*U));v=+N(+(C*V+D*W+E*X));w=+N(+(F*P+G*Q+H*R));x=+N(+(F*S+G*T+H*U));y=+N(+(F*V+G*W+H*X));z=+N(+(I*P+J*Q+K*R));A=+N(+(I*S+J*T+K*U));B=+N(+(I*V+J*W+K*X));r=1;l=128;m=128;k=124;while(1){q=r+-1|0;f=c[j+(q<<3)>>2]|0;h=c[j+(q<<3)+4>>2]|0;pa=+g[h+16>>2];oa=+g[h>>2];na=+g[h+20>>2];ma=+g[h+4>>2];la=+g[h+24>>2];fa=+g[h+8>>2];ka=C*L+D*M+E*O+(C*Y+D*Z+E*_)+((C*P+D*Q+E*R)*((pa+oa)*.5)+(C*S+D*T+E*U)*((na+ma)*.5)+(C*V+D*W+E*X)*((la+fa)*.5));ia=F*L+G*M+H*O+(F*Y+G*Z+H*_)+((F*P+G*Q+H*R)*((pa+oa)*.5)+(F*S+G*T+H*U)*((na+ma)*.5)+(F*V+G*W+H*X)*((la+fa)*.5));ga=I*L+J*M+K*O+(I*Y+J*Z+K*_)+((I*P+J*Q+K*R)*((pa+oa)*.5)+(I*S+J*T+K*U)*((na+ma)*.5)+(I*V+J*W+K*X)*((la+fa)*.5));ja=((pa-oa)*.5+0.0)*t+((na-ma)*.5+0.0)*u+((la-fa)*.5+0.0)*v;ha=((pa-oa)*.5+0.0)*w+((na-ma)*.5+0.0)*x+((la-fa)*.5+0.0)*y;fa=((pa-oa)*.5+0.0)*z+((na-ma)*.5+0.0)*A+((la-fa)*.5+0.0)*B;do if(((((+g[f>>2]<=ja+ka?+g[f+16>>2]>=ka-ja:0)?+g[f+4>>2]<=ia+ha:0)?+g[f+20>>2]>=ia-ha:0)?+g[f+8>>2]<=ga+fa:0)?+g[f+24>>2]>=ga-fa:0){if((q|0)>(k|0)){n=m<<1;do if((m|0)<(n|0)&(l|0)<(n|0)){do if(!m){k=0;$=54}else{c[5637]=(c[5637]|0)+1;k=qG((m<<4|3)+16|0)|0;if(!k)k=0;else{c[(k+4+15&-16)+-4>>2]=k;k=k+4+15&-16}if((m|0)>0)l=0;else{$=54;break}do{o=j+(l<<3)|0;p=c[o+4>>2]|0;s=k+(l<<3)|0;c[s>>2]=c[o>>2];c[s+4>>2]=p;l=l+1|0}while((l|0)!=(m|0))}while(0);if(($|0)==54){$=0;if(!j){l=n;j=k;break}}c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0);l=n;j=k}while(0);p=n;k=n+-4|0}else p=m;m=(c[h+40>>2]|0)!=0;if(!(c[f+40>>2]|0))if(m){n=c[h+36>>2]|0;c[j+(q<<3)>>2]=f;c[j+(q<<3)+4>>2]=n;n=c[h+40>>2]|0;c[j+(r<<3)>>2]=f;c[j+(r<<3)+4>>2]=n;n=r+1|0;m=p;break}else{Zb[c[(c[ea+128>>2]|0)+8>>2]&127](ea+128|0,f,h);n=q;m=p;break}else{n=j+(q<<3)|0;o=c[f+36>>2]|0;if(m){m=c[h+36>>2]|0;c[n>>2]=o;c[j+(q<<3)+4>>2]=m;m=r+1|0;n=c[h+36>>2]|0;c[j+(r<<3)>>2]=c[f+40>>2];c[j+(r<<3)+4>>2]=n;n=r+2|0;s=c[h+40>>2]|0;c[j+(m<<3)>>2]=c[f+36>>2];c[j+(m<<3)+4>>2]=s;m=c[h+40>>2]|0;c[j+(n<<3)>>2]=c[f+40>>2];c[j+(n<<3)+4>>2]=m;n=r+3|0;m=p;break}else{c[n>>2]=o;c[j+(q<<3)+4>>2]=h;c[j+(r<<3)>>2]=c[f+40>>2];c[j+(r<<3)+4>>2]=h;n=r+1|0;m=p;break}}}else n=q;while(0);if(!n)break;else r=n}if(j|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0)}}o=c[aa>>2]|0;if((c[o+8>>2]|0)>0){p=0;do{j=c[o+16>>2]|0;k=c[j+(p*12|0)+8>>2]|0;do if(k|0){$=c[j+(p*12|0)>>2]|0;s=c[ba+28>>2]|0;r=c[s+($*80|0)+64>>2]|0;h=c[d+12>>2]|0;pa=+g[h>>2];Q=+g[h+4>>2];P=+g[h+8>>2];ma=+g[h+16>>2];ka=+g[h+20>>2];ia=+g[h+24>>2];la=+g[h+32>>2];ha=+g[h+36>>2];V=+g[h+40>>2];ga=+g[s+($*80|0)>>2];fa=+g[s+($*80|0)+16>>2];_=+g[s+($*80|0)+32>>2];Z=+g[s+($*80|0)+4>>2];Y=+g[s+($*80|0)+20>>2];X=+g[s+($*80|0)+36>>2];ja=+g[s+($*80|0)+8>>2];W=+g[s+($*80|0)+24>>2];U=+g[s+($*80|0)+40>>2];oa=+g[s+($*80|0)+48>>2];na=+g[s+($*80|0)+52>>2];R=+g[s+($*80|0)+56>>2];T=+g[h+48>>2]+(pa*oa+Q*na+P*R);S=+g[h+52>>2]+(ma*oa+ka*na+ia*R);R=+g[h+56>>2]+(la*oa+ha*na+V*R);g[ea>>2]=pa*ga+Q*fa+P*_;g[ea+4>>2]=pa*Z+Q*Y+P*X;g[ea+8>>2]=pa*ja+Q*W+P*U;g[ea+12>>2]=0.0;g[ea+16>>2]=ma*ga+ka*fa+ia*_;g[ea+20>>2]=ma*Z+ka*Y+ia*X;g[ea+24>>2]=ma*ja+ka*W+ia*U;g[ea+28>>2]=0.0;g[ea+32>>2]=la*ga+ha*fa+V*_;g[ea+36>>2]=la*Z+ha*Y+V*X;g[ea+40>>2]=la*ja+ha*W+V*U;g[ea+44>>2]=0.0;g[ea+48>>2]=T;g[ea+52>>2]=S;g[ea+56>>2]=R;g[ea+60>>2]=0.0;bc[c[(c[r>>2]|0)+8>>2]&127](r,ea,ea+112|0,ea+96|0);r=c[(c[o+16>>2]|0)+(p*12|0)+4>>2]|0;h=c[ca+28>>2]|0;$=c[h+(r*80|0)+64>>2]|0;s=c[e+12>>2]|0;R=+g[s>>2];S=+g[s+4>>2];T=+g[s+8>>2];U=+g[s+16>>2];V=+g[s+20>>2];W=+g[s+24>>2];ha=+g[s+32>>2];ja=+g[s+36>>2];la=+g[s+40>>2];X=+g[h+(r*80|0)>>2];Y=+g[h+(r*80|0)+16>>2];Z=+g[h+(r*80|0)+32>>2];_=+g[h+(r*80|0)+4>>2];fa=+g[h+(r*80|0)+20>>2];ga=+g[h+(r*80|0)+36>>2];ia=+g[h+(r*80|0)+8>>2];ka=+g[h+(r*80|0)+24>>2];ma=+g[h+(r*80|0)+40>>2];P=+g[h+(r*80|0)+48>>2];Q=+g[h+(r*80|0)+52>>2];pa=+g[h+(r*80|0)+56>>2];na=+g[s+48>>2]+(R*P+S*Q+T*pa);oa=+g[s+52>>2]+(U*P+V*Q+W*pa);pa=+g[s+56>>2]+(ha*P+ja*Q+la*pa);g[ea>>2]=R*X+S*Y+T*Z;g[ea+4>>2]=R*_+S*fa+T*ga;g[ea+8>>2]=R*ia+S*ka+T*ma;g[ea+12>>2]=0.0;g[ea+16>>2]=U*X+V*Y+W*Z;g[ea+20>>2]=U*_+V*fa+W*ga;g[ea+24>>2]=U*ia+V*ka+W*ma;g[ea+28>>2]=0.0;g[ea+32>>2]=ha*X+ja*Y+la*Z;g[ea+36>>2]=ha*_+ja*fa+la*ga;g[ea+40>>2]=ha*ia+ja*ka+la*ma;g[ea+44>>2]=0.0;g[ea+48>>2]=na;g[ea+52>>2]=oa;g[ea+56>>2]=pa;g[ea+60>>2]=0.0;bc[c[(c[$>>2]|0)+8>>2]&127]($,ea,ea+80|0,ea+64|0);if(!(+g[ea+112>>2]>+g[ea+64>>2])?!(+g[ea+96>>2]<+g[ea+80>>2]):0)j=1;else j=0;if(!(!(+g[ea+112+8>>2]>+g[ea+64+8>>2])?!(+g[ea+96+8>>2]<+g[ea+80+8>>2]):0))j=0;if(!(+g[ea+112+4>>2]>+g[ea+64+4>>2])?!(+g[ea+96+4>>2]<+g[ea+80+4>>2]|j^1):0)break;rb[c[c[k>>2]>>2]&255](k);n=c[b+4>>2]|0;tb[c[(c[n>>2]|0)+60>>2]&127](n,k);n=c[o+16>>2]|0;m=c[n+(p*12|0)>>2]|0;n=c[n+(p*12|0)+4>>2]|0;j=c[b+52>>2]|0;if((j|0)==(c[b+56>>2]|0)?(da=j|0?j<<1:1,(j|0)<(da|0)):0){if(!da)l=0;else{c[5637]=(c[5637]|0)+1;j=qG((da*12|3)+16|0)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}l=j;j=c[b+52>>2]|0}if((j|0)>0){k=0;do{$=l+(k*12|0)|0;s=(c[b+60>>2]|0)+(k*12|0)|0;c[$>>2]=c[s>>2];c[$+4>>2]=c[s+4>>2];c[$+8>>2]=c[s+8>>2];k=k+1|0}while((k|0)!=(j|0))}j=c[b+60>>2]|0;if(j|0){if(a[b+64>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=l;c[b+56>>2]=da;j=c[b+52>>2]|0}$=c[b+60>>2]|0;c[$+(j*12|0)>>2]=m;c[$+(j*12|0)+4>>2]=n;c[$+(j*12|0)+8>>2]=0;c[b+52>>2]=(c[b+52>>2]|0)+1}while(0);p=p+1|0}while((p|0)<(c[o+8>>2]|0));k=b+60|0;l=b+52|0}else{k=b+60|0;l=b+52|0}if((c[l>>2]|0)>0){j=0;do{d=c[aa>>2]|0;e=c[k>>2]|0;Eb[c[(c[d>>2]|0)+8>>2]&63](d,c[e+(j*12|0)>>2]|0,c[e+(j*12|0)+4>>2]|0)|0;j=j+1|0}while((j|0)<(c[l>>2]|0))}j=c[k>>2]|0;if(j|0){if(a[b+64>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0)}c[k>>2]=0}a[b+64>>0]=1;c[k>>2]=0;c[l>>2]=0;c[b+56>>2]=0;i=ea;return}function wg(a){a=a|0;rG(a);return}function xg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0;m=i;i=i+240|0;c[a+4>>2]=(c[a+4>>2]|0)+1;k=c[b+36>>2]|0;j=c[d+36>>2]|0;f=c[a+8>>2]|0;K=c[(c[f+4>>2]|0)+28>>2]|0;d=c[K+(k*80|0)+64>>2]|0;b=(c[(c[a+12>>2]|0)+4>>2]|0)+28|0;e=c[(c[b>>2]|0)+(j*80|0)+64>>2]|0;f=c[f+12>>2]|0;n=+g[f>>2];I=+g[f+4>>2];J=+g[f+8>>2];q=+g[f+16>>2];s=+g[f+20>>2];u=+g[f+24>>2];r=+g[f+32>>2];v=+g[f+36>>2];D=+g[f+40>>2];w=+g[K+(k*80|0)>>2];x=+g[K+(k*80|0)+16>>2];y=+g[K+(k*80|0)+32>>2];z=+g[K+(k*80|0)+4>>2];A=+g[K+(k*80|0)+20>>2];B=+g[K+(k*80|0)+36>>2];t=+g[K+(k*80|0)+8>>2];C=+g[K+(k*80|0)+24>>2];E=+g[K+(k*80|0)+40>>2];o=+g[K+(k*80|0)+48>>2];p=+g[K+(k*80|0)+52>>2];H=+g[K+(k*80|0)+56>>2];F=+g[f+48>>2]+(n*o+I*p+J*H);G=+g[f+52>>2]+(q*o+s*p+u*H);H=+g[f+56>>2]+(r*o+v*p+D*H);g[m+176>>2]=n*w+I*x+J*y;g[m+176+4>>2]=n*z+I*A+J*B;g[m+176+8>>2]=n*t+I*C+J*E;g[m+176+12>>2]=0.0;g[m+176+16>>2]=q*w+s*x+u*y;g[m+176+20>>2]=q*z+s*A+u*B;g[m+176+24>>2]=q*t+s*C+u*E;g[m+176+28>>2]=0.0;g[m+176+32>>2]=r*w+v*x+D*y;g[m+176+36>>2]=r*z+v*A+D*B;g[m+176+40>>2]=r*t+v*C+D*E;g[m+176+44>>2]=0.0;g[m+176+48>>2]=F;g[m+176+52>>2]=G;g[m+176+56>>2]=H;g[m+176+60>>2]=0.0;f=c[(c[a+12>>2]|0)+12>>2]|0;H=+g[f>>2];G=+g[f+4>>2];F=+g[f+8>>2];E=+g[f+16>>2];D=+g[f+20>>2];C=+g[f+24>>2];v=+g[f+32>>2];t=+g[f+36>>2];r=+g[f+40>>2];b=c[b>>2]|0;B=+g[b+(j*80|0)>>2];A=+g[b+(j*80|0)+16>>2];z=+g[b+(j*80|0)+32>>2];y=+g[b+(j*80|0)+4>>2];x=+g[b+(j*80|0)+20>>2];w=+g[b+(j*80|0)+36>>2];u=+g[b+(j*80|0)+8>>2];s=+g[b+(j*80|0)+24>>2];q=+g[b+(j*80|0)+40>>2];J=+g[b+(j*80|0)+48>>2];I=+g[b+(j*80|0)+52>>2];n=+g[b+(j*80|0)+56>>2];p=+g[f+48>>2]+(H*J+G*I+F*n);o=+g[f+52>>2]+(E*J+D*I+C*n);n=+g[f+56>>2]+(v*J+t*I+r*n);g[m+112>>2]=H*B+G*A+F*z;g[m+112+4>>2]=H*y+G*x+F*w;g[m+112+8>>2]=H*u+G*s+F*q;g[m+112+12>>2]=0.0;g[m+112+16>>2]=E*B+D*A+C*z;g[m+112+20>>2]=E*y+D*x+C*w;g[m+112+24>>2]=E*u+D*s+C*q;g[m+112+28>>2]=0.0;g[m+112+32>>2]=v*B+t*A+r*z;g[m+112+36>>2]=v*y+t*x+r*w;g[m+112+40>>2]=v*u+t*s+r*q;g[m+112+44>>2]=0.0;g[m+112+48>>2]=p;g[m+112+52>>2]=o;g[m+112+56>>2]=n;g[m+112+60>>2]=0.0;bc[c[(c[d>>2]|0)+8>>2]&127](d,m+176|0,m+96|0,m+80|0);bc[c[(c[e>>2]|0)+8>>2]&127](e,m+112|0,m+64|0,m+48|0);if(!(+g[m+96>>2]>+g[m+48>>2])?!(+g[m+80>>2]<+g[m+64>>2]):0)b=1;else b=0;if(!(!(+g[m+96+8>>2]>+g[m+48+8>>2])?!(+g[m+80+8>>2]<+g[m+64+8>>2]):0))b=0;if(+g[m+96+4>>2]>+g[m+48+4>>2]){i=m;return}if(+g[m+80+4>>2]<+g[m+64+4>>2]|b^1){i=m;return}f=c[a+8>>2]|0;b=c[f+8>>2]|0;c[m+24>>2]=f;c[m+24+4>>2]=d;c[m+24+8>>2]=b;c[m+24+12>>2]=m+176;c[m+24+16>>2]=-1;c[m+24+20>>2]=k;b=c[a+12>>2]|0;f=c[b+8>>2]|0;c[m>>2]=b;c[m+4>>2]=e;c[m+8>>2]=f;c[m+12>>2]=m+112;c[m+16>>2]=-1;c[m+20>>2]=j;f=c[a+28>>2]|0;c[4992]=(c[4992]|0)+1;b=((j<<16|k)+~((j<<16|k)<<15)>>10^(j<<16|k)+~((j<<16|k)<<15))*9|0;b=(c[f+12>>2]|0)+-1&((b>>6^b)+~((b>>6^b)<<11)>>16^(b>>6^b)+~((b>>6^b)<<11));a:do if((b|0)<(c[f+28>>2]|0)?(h=c[(c[f+36>>2]|0)+(b<<2)>>2]|0,(h|0)!=-1):0){e=c[f+16>>2]|0;b=h;while(1){d=e+(b*12|0)|0;if((c[d>>2]|0)==(k|0)?(c[e+(b*12|0)+4>>2]|0)==(j|0):0)break;b=c[(c[f+56>>2]|0)+(b<<2)>>2]|0;if((b|0)==-1){l=16;break a}}if(d)b=c[e+(b*12|0)+8>>2]|0;else l=16}else l=16;while(0);if((l|0)==16){b=c[a+16>>2]|0;b=zb[c[(c[b>>2]|0)+8>>2]&31](b,m+24|0,m,c[a+32>>2]|0)|0;K=c[a+28>>2]|0;c[(Eb[c[(c[K>>2]|0)+12>>2]&63](K,k,j)|0)+8>>2]=b}K=c[a+24>>2]|0;h=c[K+8>>2]|0;l=c[K+12>>2]|0;c[K+8>>2]=m+24;c[K+12>>2]=m;Zb[c[(c[K>>2]|0)+8>>2]&127](K,-1,k);K=c[a+24>>2]|0;Zb[c[(c[K>>2]|0)+12>>2]&127](K,-1,j);pb[c[(c[b>>2]|0)+8>>2]&31](b,m+24|0,m,c[a+20>>2]|0,c[a+24>>2]|0);K=c[a+24>>2]|0;c[K+8>>2]=h;c[K+12>>2]=l;i=m;return}function yg(a,b){a=a|0;b=b|0;return}function zg(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 0.0}function Ag(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;f=c[a+44>>2]|0;a=c[f+8>>2]|0;if((a|0)<=0)return;e=0;do{d=c[(c[f+16>>2]|0)+(e*12|0)+8>>2]|0;if(d){tb[c[(c[d>>2]|0)+16>>2]&127](d,b);a=c[f+8>>2]|0}e=e+1|0}while((e|0)<(a|0));return}function Bg(a){a=a|0;var b=0;c[a>>2]=3720;c[a+12>>2]=3748;b=c[a+60>>2]|0;tb[c[(c[b>>2]|0)+20>>2]&127](b,c[a+76>>2]|0);b=c[a+60>>2]|0;tb[c[(c[b>>2]|0)+16>>2]&127](b,c[a+76>>2]|0);return}function Cg(a){a=a|0;var b=0;c[a>>2]=3748;b=c[a+48>>2]|0;tb[c[(c[b>>2]|0)+20>>2]&127](b,c[a+64>>2]|0);b=c[a+48>>2]|0;tb[c[(c[b>>2]|0)+16>>2]&127](b,c[a+64>>2]|0);return}function Dg(a){a=a|0;var b=0;c[a>>2]=3748;b=c[a+48>>2]|0;tb[c[(c[b>>2]|0)+20>>2]&127](b,c[a+64>>2]|0);b=c[a+48>>2]|0;tb[c[(c[b>>2]|0)+16>>2]&127](b,c[a+64>>2]|0);rG(a);return}function Eg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0,m=0,n=0,o=0,p=0.0,q=0;o=i;i=i+144|0;h=+g[b>>2];j=+g[b+16>>2];p=h<j?h:j;k=+g[b+32>>2];if((p<k?p:k)>+g[a+28>>2]){i=o;return}m=h>j?b:b+16|0;if(+g[(+g[m>>2]>k?m:b+32|0)>>2]<+g[a+12>>2]){i=o;return}h=+g[b+8>>2];j=+g[b+24>>2];p=h<j?h:j;k=+g[b+40>>2];if((p<k?p:k)>+g[a+36>>2]){i=o;return}m=h>j?b+8|0:b+24|0;if(+g[(+g[m>>2]>k?m:b+40|0)>>2]<+g[a+20>>2]){i=o;return}h=+g[b+4>>2];j=+g[b+20>>2];p=h<j?h:j;k=+g[b+36>>2];if((p<k?p:k)>+g[a+32>>2]){i=o;return}m=h>j?b+4|0:b+20|0;if(+g[(+g[m>>2]>k?m:b+36|0)>>2]<+g[a+16>>2]){i=o;return}m=c[a+48>>2]|0;f=c[a+4>>2]|0;if((c[(c[f+4>>2]|0)+4>>2]|0)>=20){i=o;return}c[o+24+8>>2]=0;c[o+24+12>>2]=-1;c[o+24+16>>2]=1065353216;c[o+24+20>>2]=1065353216;c[o+24+24>>2]=1065353216;g[o+24+28>>2]=0.0;c[o+24+56>>2]=0;c[o+24>>2]=3768;c[o+24+4>>2]=1;c[o+24+60>>2]=c[b>>2];c[o+24+60+4>>2]=c[b+4>>2];c[o+24+60+8>>2]=c[b+8>>2];c[o+24+60+12>>2]=c[b+12>>2];c[o+24+76>>2]=c[b+16>>2];c[o+24+76+4>>2]=c[b+16+4>>2];c[o+24+76+8>>2]=c[b+16+8>>2];c[o+24+76+12>>2]=c[b+16+12>>2];c[o+24+92>>2]=c[b+32>>2];c[o+24+92+4>>2]=c[b+32+4>>2];c[o+24+92+8>>2]=c[b+32+8>>2];c[o+24+92+12>>2]=c[b+32+12>>2];c[o+24+48>>2]=c[a+56>>2];q=c[a+8>>2]|0;b=c[q+8>>2]|0;l=c[q+12>>2]|0;c[o>>2]=q;c[o+4>>2]=o+24;c[o+8>>2]=b;c[o+12>>2]=l;c[o+16>>2]=d;c[o+20>>2]=e;l=zb[c[(c[m>>2]|0)+8>>2]&31](m,f,o,c[a+64>>2]|0)|0;f=c[a+44>>2]|0;b=c[f+8>>2]|0;if((c[b+8>>2]|0)==(c[(c[a+8>>2]|0)+8>>2]|0)){c[f+8>>2]=o;Zb[c[(c[f>>2]|0)+8>>2]&127](f,d,e)}else{b=c[f+12>>2]|0;c[f+12>>2]=o;Zb[c[(c[f>>2]|0)+12>>2]&127](f,d,e)}pb[c[(c[l>>2]|0)+8>>2]&31](l,c[a+4>>2]|0,o,c[a+52>>2]|0,c[a+44>>2]|0);f=c[a+44>>2]|0;if((c[(c[f+8>>2]|0)+8>>2]|0)==(c[(c[a+8>>2]|0)+8>>2]|0))c[f+8>>2]=b;else c[f+12>>2]=b;rb[c[c[l>>2]>>2]&255](l);tb[c[(c[m>>2]|0)+60>>2]&127](m,l);c[o+24>>2]=6248;f=c[o+24+56>>2]|0;if(f|0?(rb[c[c[f>>2]>>2]&255](f),n=c[o+24+56>>2]|0,n|0):0){c[5638]=(c[5638]|0)+1;rG(c[n+-4>>2]|0)}i=o;return}function Fg(a){a=a|0;var b=0,d=0;c[a>>2]=6248;b=c[a+56>>2]|0;if(b|0?(rb[c[c[b>>2]>>2]&255](b),d=c[a+56>>2]|0,d|0):0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function Gg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bc[c[(c[a>>2]|0)+80>>2]&127](a,b,d,e);return}function Hg(a){a=a|0;return a+16|0}function Ig(a,b,d){a=a|0;b=+b;d=d|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;return}function Jg(a){a=a|0;return 11211}function Kg(a,b){a=a|0;b=b|0;c[a>>2]=1065353216;c[a+4>>2]=1065353216;c[a+8>>2]=1065353216;g[a+12>>2]=0.0;return}function Lg(a,b){a=a|0;b=+b;g[a+48>>2]=b;return}function Mg(a){a=a|0;return +(+g[a+48>>2])}function Ng(a){a=a|0;return 52}function Og(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=Ob[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=Ob[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=f;if(f|0)tb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];c[b+28>>2]=c[a+32>>2];c[b+32>>2]=c[a+36>>2];c[b+36>>2]=c[a+40>>2];c[b+40>>2]=c[a+44>>2];c[b+12>>2]=c[a+16>>2];c[b+16>>2]=c[a+20>>2];c[b+20>>2]=c[a+24>>2];c[b+24>>2]=c[a+28>>2];c[b+44>>2]=c[a+48>>2];return 11220}function Pg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;j=+g[d>>2];i=+g[d+4>>2];e=+g[d+8>>2];f=j*+g[b+60>>2]+i*+g[b+64>>2]+e*+g[b+68>>2];h=j*+g[b+76>>2]+i*+g[b+80>>2]+e*+g[b+84>>2];e=j*+g[b+92>>2]+i*+g[b+96>>2]+e*+g[b+100>>2];b=b+60+((f<h?(h<e?2:1):f<e?2:0)<<4)|0;c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];return}function Qg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;if((e|0)<=0)return;f=0;do{n=+g[b+(f<<4)>>2];m=+g[b+(f<<4)+4>>2];j=+g[b+(f<<4)+8>>2];k=n*+g[a+60>>2]+m*+g[a+64>>2]+j*+g[a+68>>2];l=n*+g[a+76>>2]+m*+g[a+80>>2]+j*+g[a+84>>2];j=n*+g[a+92>>2]+m*+g[a+96>>2]+j*+g[a+100>>2];h=d+(f<<4)|0;i=a+60+((k<l?(l<j?2:1):k<j?2:0)<<4)|0;c[h>>2]=c[i>>2];c[h+4>>2]=c[i+4>>2];c[h+8>>2]=c[i+8>>2];c[h+12>>2]=c[i+12>>2];f=f+1|0}while((f|0)!=(e|0));return}function Rg(a){a=a|0;return 2}function Sg(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;h=+g[a+60>>2];j=+g[a+76>>2]-h;i=+g[a+64>>2];k=+g[a+80>>2]-i;d=+g[a+68>>2];f=+g[a+84>>2]-d;h=+g[a+92>>2]-h;i=+g[a+96>>2]-i;d=+g[a+100>>2]-d;g[c+12>>2]=0.0;e=1.0/+O(+((j*i-k*h)*(j*i-k*h)+((k*d-f*i)*(k*d-f*i)+(f*h-j*d)*(f*h-j*d))));g[c>>2]=(k*d-f*i)*e;g[c+4>>2]=(f*h-j*d)*e;g[c+8>>2]=(j*i-k*h)*e;if(!b)return;g[c>>2]=-((k*d-f*i)*e);g[c+4>>2]=-((f*h-j*d)*e);g[c+8>>2]=-((j*i-k*h)*e);return}function Tg(a){a=a|0;return 3}function Ug(a){a=a|0;return 3}function Vg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;Zb[c[(c[a>>2]|0)+108>>2]&127](a,b,d);Zb[c[(c[a>>2]|0)+108>>2]&127](a,(b+1|0)%3|0,e);return}function Wg(a,b,d){a=a|0;b=b|0;d=d|0;c[d>>2]=c[a+60+(b<<4)>>2];c[d+4>>2]=c[a+60+(b<<4)+4>>2];c[d+8>>2]=c[a+60+(b<<4)+8>>2];c[d+12>>2]=c[a+60+(b<<4)+12>>2];return}function Xg(a){a=a|0;return 1}function Yg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bc[c[(c[a>>2]|0)+124>>2]&127](a,e,b,d);return}
function Aj(a,b,d){a=a|0;b=b|0;d=d|0;var f=0.0,j=0.0,k=0.0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+80|0;o=c[a+4>>2]|0;Nb[c[(c[o>>2]|0)+16>>2]&3](o,r+28|0,r+24|0,r+20|0,r+16|0,r+12|0,r+8|0,r+4|0,r,b);o=(c[r+12>>2]|0)+(_(c[r+8>>2]|0,d)|0)|0;q=c[a+4>>2]|0;p=(c[r+20>>2]|0)==0;n=c[r+28>>2]|0;if((c[r>>2]|0)==3){m=c[r+16>>2]|0;l=n+(_(m,e[o+4>>1]|0)|0)|0;if(p){j=+g[l+8>>2]*+g[q+12>>2];k=+g[l+4>>2]*+g[q+8>>2];f=+g[l>>2]*+g[q+4>>2]}else{j=+h[l+16>>3]*+g[q+12>>2];k=+h[l+8>>3]*+g[q+8>>2];f=+h[l>>3]*+g[q+4>>2]}g[r+32+32>>2]=f;g[r+32+36>>2]=k;g[r+32+40>>2]=j;g[r+32+44>>2]=0.0;l=n+(_(m,e[o+2>>1]|0)|0)|0;if(p){j=+g[l+8>>2]*+g[q+12>>2];k=+g[l+4>>2]*+g[q+8>>2];f=+g[l>>2]*+g[q+4>>2]}else{j=+h[l+16>>3]*+g[q+12>>2];k=+h[l+8>>3]*+g[q+8>>2];f=+h[l>>3]*+g[q+4>>2]}g[r+32+16>>2]=f;g[r+32+20>>2]=k;g[r+32+24>>2]=j;g[r+32+28>>2]=0.0;l=n+(_(m,e[o>>1]|0)|0)|0;if(p){j=+g[l+8>>2]*+g[q+12>>2];k=+g[l+4>>2]*+g[q+8>>2];f=+g[l>>2]*+g[q+4>>2]}else{j=+h[l+16>>3]*+g[q+12>>2];k=+h[l+8>>3]*+g[q+8>>2];f=+h[l>>3]*+g[q+4>>2]}g[r+32>>2]=f;g[r+32+4>>2]=k;g[r+32+8>>2]=j;g[r+32+12>>2]=0.0;q=a+8|0;q=c[q>>2]|0;p=c[q>>2]|0;p=p+8|0;p=c[p>>2]|0;bc[p&127](q,r+32|0,b,d);a=c[a+4>>2]|0;d=c[a>>2]|0;d=d+24|0;d=c[d>>2]|0;tb[d&127](a,b);i=r;return}else{m=c[r+16>>2]|0;l=n+(_(m,c[o+8>>2]|0)|0)|0;if(p){j=+g[l+8>>2]*+g[q+12>>2];k=+g[l+4>>2]*+g[q+8>>2];f=+g[l>>2]*+g[q+4>>2]}else{j=+h[l+16>>3]*+g[q+12>>2];k=+h[l+8>>3]*+g[q+8>>2];f=+h[l>>3]*+g[q+4>>2]}g[r+32+32>>2]=f;g[r+32+36>>2]=k;g[r+32+40>>2]=j;g[r+32+44>>2]=0.0;l=n+(_(m,c[o+4>>2]|0)|0)|0;if(p){j=+g[l+8>>2]*+g[q+12>>2];k=+g[l+4>>2]*+g[q+8>>2];f=+g[l>>2]*+g[q+4>>2]}else{j=+h[l+16>>3]*+g[q+12>>2];k=+h[l+8>>3]*+g[q+8>>2];f=+h[l>>3]*+g[q+4>>2]}g[r+32+16>>2]=f;g[r+32+20>>2]=k;g[r+32+24>>2]=j;g[r+32+28>>2]=0.0;l=n+(_(m,c[o>>2]|0)|0)|0;if(p){j=+g[l+8>>2]*+g[q+12>>2];k=+g[l+4>>2]*+g[q+8>>2];f=+g[l>>2]*+g[q+4>>2]}else{j=+h[l+16>>3]*+g[q+12>>2];k=+h[l+8>>3]*+g[q+8>>2];f=+h[l>>3]*+g[q+4>>2]}g[r+32>>2]=f;g[r+32+4>>2]=k;g[r+32+8>>2]=j;g[r+32+12>>2]=0.0;q=a+8|0;q=c[q>>2]|0;p=c[q>>2]|0;p=p+8|0;p=c[p>>2]|0;bc[p&127](q,r+32|0,b,d);a=c[a+4>>2]|0;d=c[a>>2]|0;d=d+24|0;d=c[d>>2]|0;tb[d&127](a,b);i=r;return}}function Bj(a){a=a|0;rG(a);return}function Cj(a,b,d){a=a|0;b=b|0;d=d|0;var f=0.0,j=0.0,k=0.0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+80|0;o=c[a+4>>2]|0;Nb[c[(c[o>>2]|0)+16>>2]&3](o,r+28|0,r+24|0,r+20|0,r+16|0,r+12|0,r+8|0,r+4|0,r,b);o=(c[r+12>>2]|0)+(_(c[r+8>>2]|0,d)|0)|0;q=c[a+4>>2]|0;p=(c[r+20>>2]|0)==0;n=c[r+28>>2]|0;if((c[r>>2]|0)==3){m=c[r+16>>2]|0;l=n+(_(m,e[o+4>>1]|0)|0)|0;if(p){j=+g[l+8>>2]*+g[q+12>>2];k=+g[l+4>>2]*+g[q+8>>2];f=+g[l>>2]*+g[q+4>>2]}else{j=+h[l+16>>3]*+g[q+12>>2];k=+h[l+8>>3]*+g[q+8>>2];f=+h[l>>3]*+g[q+4>>2]}g[r+32+32>>2]=f;g[r+32+36>>2]=k;g[r+32+40>>2]=j;g[r+32+44>>2]=0.0;l=n+(_(m,e[o+2>>1]|0)|0)|0;if(p){j=+g[l+8>>2]*+g[q+12>>2];k=+g[l+4>>2]*+g[q+8>>2];f=+g[l>>2]*+g[q+4>>2]}else{j=+h[l+16>>3]*+g[q+12>>2];k=+h[l+8>>3]*+g[q+8>>2];f=+h[l>>3]*+g[q+4>>2]}g[r+32+16>>2]=f;g[r+32+20>>2]=k;g[r+32+24>>2]=j;g[r+32+28>>2]=0.0;l=n+(_(m,e[o>>1]|0)|0)|0;if(p){j=+g[l+8>>2]*+g[q+12>>2];k=+g[l+4>>2]*+g[q+8>>2];f=+g[l>>2]*+g[q+4>>2]}else{j=+h[l+16>>3]*+g[q+12>>2];k=+h[l+8>>3]*+g[q+8>>2];f=+h[l>>3]*+g[q+4>>2]}g[r+32>>2]=f;g[r+32+4>>2]=k;g[r+32+8>>2]=j;g[r+32+12>>2]=0.0;q=a+8|0;q=c[q>>2]|0;p=c[q>>2]|0;p=p+8|0;p=c[p>>2]|0;bc[p&127](q,r+32|0,b,d);a=c[a+4>>2]|0;d=c[a>>2]|0;d=d+24|0;d=c[d>>2]|0;tb[d&127](a,b);i=r;return}else{m=c[r+16>>2]|0;l=n+(_(m,c[o+8>>2]|0)|0)|0;if(p){j=+g[l+8>>2]*+g[q+12>>2];k=+g[l+4>>2]*+g[q+8>>2];f=+g[l>>2]*+g[q+4>>2]}else{j=+h[l+16>>3]*+g[q+12>>2];k=+h[l+8>>3]*+g[q+8>>2];f=+h[l>>3]*+g[q+4>>2]}g[r+32+32>>2]=f;g[r+32+36>>2]=k;g[r+32+40>>2]=j;g[r+32+44>>2]=0.0;l=n+(_(m,c[o+4>>2]|0)|0)|0;if(p){j=+g[l+8>>2]*+g[q+12>>2];k=+g[l+4>>2]*+g[q+8>>2];f=+g[l>>2]*+g[q+4>>2]}else{j=+h[l+16>>3]*+g[q+12>>2];k=+h[l+8>>3]*+g[q+8>>2];f=+h[l>>3]*+g[q+4>>2]}g[r+32+16>>2]=f;g[r+32+20>>2]=k;g[r+32+24>>2]=j;g[r+32+28>>2]=0.0;l=n+(_(m,c[o>>2]|0)|0)|0;if(p){j=+g[l+8>>2]*+g[q+12>>2];k=+g[l+4>>2]*+g[q+8>>2];f=+g[l>>2]*+g[q+4>>2]}else{j=+h[l+16>>3]*+g[q+12>>2];k=+h[l+8>>3]*+g[q+8>>2];f=+h[l>>3]*+g[q+4>>2]}g[r+32>>2]=f;g[r+32+4>>2]=k;g[r+32+8>>2]=j;g[r+32+12>>2]=0.0;q=a+8|0;q=c[q>>2]|0;p=c[q>>2]|0;p=p+8|0;p=c[p>>2]|0;bc[p&127](q,r+32|0,b,d);a=c[a+4>>2]|0;d=c[a>>2]|0;d=d+24|0;d=c[d>>2]|0;tb[d&127](a,b);i=r;return}}function Dj(a){a=a|0;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function Ej(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0;f=i;i=i+16|0;y=c[a+56>>2]|0;z=c[a+32+(((y+2|0)%3|0)<<2)>>2]|0;c[f>>2]=z;c[f+4>>2]=z;c[f+8>>2]=z;g[f+12>>2]=0.0;g[f+(y<<2)>>2]=(c[k>>2]=z,+g[k>>2])+ +g[a+32+(y<<2)>>2];l=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);o=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);l=l+ +g[f>>2];g[f>>2]=l;h=h+ +g[f+4>>2];g[f+4>>2]=h;o=o+ +g[f+8>>2];v=+N(+(+g[b>>2]));u=+N(+(+g[b+4>>2]));w=+N(+(+g[b+8>>2]));r=+N(+(+g[b+16>>2]));q=+N(+(+g[b+20>>2]));s=+N(+(+g[b+24>>2]));m=+N(+(+g[b+32>>2]));j=+N(+(+g[b+36>>2]));n=+N(+(+g[b+40>>2]));x=+g[b+48>>2];t=+g[b+52>>2];p=+g[b+56>>2];g[d>>2]=x-(o*w+(v*l+u*h));g[d+4>>2]=t-(o*s+(r*l+q*h));g[d+8>>2]=p-(o*n+(m*l+j*h));g[d+12>>2]=0.0;g[e>>2]=x+(o*w+(v*l+u*h));g[e+4>>2]=t+(o*s+(r*l+q*h));g[e+8>>2]=p+(o*n+(m*l+j*h));g[e+12>>2]=0.0;i=f;return}function Fj(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0;k=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);d=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);m=(k+ +g[a+32>>2])/+g[a+16>>2];j=(h+ +g[a+36>>2])/+g[a+20>>2];f=(d+ +g[a+40>>2])/+g[a+24>>2];l=+N(+(+g[b>>2]));i=+N(+(+g[b+4>>2]));e=+N(+(+g[b+8>>2]));g[a+16>>2]=l;g[a+20>>2]=i;g[a+24>>2]=e;g[a+28>>2]=0.0;g[a+32>>2]=m*l-k;g[a+36>>2]=j*i-h;g[a+40>>2]=f*e-d;g[a+44>>2]=0.0;return}function Gj(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0,l=0;e=i;i=i+16|0;k=c[a+56>>2]|0;l=c[a+32+(((k+2|0)%3|0)<<2)>>2]|0;c[e>>2]=l;c[e+4>>2]=l;c[e+8>>2]=l;g[e+12>>2]=0.0;g[e+(k<<2)>>2]=+g[a+32+(k<<2)>>2]+ +g[e+(k<<2)>>2];h=(+g[e>>2]+.03999999910593033)*2.0;f=(+g[e+4>>2]+.03999999910593033)*2.0;j=(+g[e+8>>2]+.03999999910593033)*2.0;g[d>>2]=b*.0833333283662796*(f*f+j*j);g[d+4>>2]=b*.0833333283662796*(h*h+j*j);g[d+8>>2]=b*.0833333283662796*(h*h+f*f);i=e;return}function Hj(a){a=a|0;return 13096}function Ij(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;g[a+(c[b+56>>2]<<2)>>2]=1.0;return}function Jj(a,b){a=a|0;b=+b;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0;h=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);i=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);h=h+ +g[a+32>>2];e=e+ +g[a+36>>2];i=i+ +g[a+40>>2];g[a+48>>2]=b;f=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);d=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);b=i-+Hb[c[(c[a>>2]|0)+48>>2]&15](a);g[a+32>>2]=h-f;g[a+36>>2]=e-d;g[a+40>>2]=b;g[a+44>>2]=0.0;return}function Kj(a){a=a|0;return 60}function Lj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=Ob[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=Ob[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=f;if(f|0)tb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];c[b+28>>2]=c[a+32>>2];c[b+32>>2]=c[a+36>>2];c[b+36>>2]=c[a+40>>2];c[b+40>>2]=c[a+44>>2];c[b+12>>2]=c[a+16>>2];c[b+16>>2]=c[a+20>>2];c[b+20>>2]=c[a+24>>2];c[b+24>>2]=c[a+28>>2];c[b+44>>2]=c[a+48>>2];c[b+52>>2]=c[a+56>>2];return 13109}function Mj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0;q=i;i=i+16|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;e=+g[d>>2];f=+g[d+4>>2];h=+g[d+8>>2];if(e*e+f*f+h*h<9.999999747378752e-05){p=1.0;o=0.0;n=0.0}else{n=1.0/+O(+(e*e+f*f+h*h));p=e*n;o=f*n;n=h*n}d=c[b+56>>2]|0;m=+g[b+32+(((d+2|0)%3|0)<<2)>>2];c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[q+12>>2]=0;c[q+(d<<2)>>2]=c[b+32+(d<<2)>>2];k=p*m;l=o*m;m=n*m;e=k+ +g[q>>2];f=l+ +g[q+4>>2];j=m+ +g[q+8>>2];h=+Hb[c[(c[b>>2]|0)+48>>2]&15](b);e=e-p*h;f=f-o*h;h=j-n*h;j=n*h+(p*e+o*f);if(j>-999999984306749440.0){g[a>>2]=e;g[a+4>>2]=f;g[a+8>>2]=h;g[a+12>>2]=0.0}else j=-999999984306749440.0;c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[q+12>>2]=0;d=c[b+56>>2]|0;g[q+(d<<2)>>2]=-+g[b+32+(d<<2)>>2];e=k+ +g[q>>2];f=l+ +g[q+4>>2];m=m+ +g[q+8>>2];h=+Hb[c[(c[b>>2]|0)+48>>2]&15](b);e=e-p*h;f=f-o*h;h=m-n*h;if(!(n*h+(p*e+o*f)>j)){i=q;return}g[a>>2]=e;g[a+4>>2]=f;g[a+8>>2]=h;g[a+12>>2]=0.0;i=q;return}function Nj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0.0,x=0,y=0;x=i;i=i+16|0;f=c[a+56>>2]|0;w=+g[a+32+(((f+2|0)%3|0)<<2)>>2];if((e|0)<=0){i=x;return}h=0;while(1){c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;c[x+12>>2]=0;c[x+(f<<2)>>2]=c[a+32+(f<<2)>>2];f=b+(h<<4)|0;u=b+(h<<4)+4|0;v=b+(h<<4)+8|0;j=w*+g[f>>2]+ +g[x>>2];k=w*+g[u>>2]+ +g[x+4>>2];l=w*+g[v>>2]+ +g[x+8>>2];m=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);n=+g[f>>2];o=+g[u>>2];p=+g[v>>2];if(n*(j-m*n)+o*(k-m*o)+p*(l-m*p)>-999999984306749440.0){g[d+(h<<4)>>2]=j-m*n;g[d+(h<<4)+4>>2]=k-m*o;g[d+(h<<4)+8>>2]=l-m*p;g[d+(h<<4)+12>>2]=0.0;q=+g[f>>2];s=+g[u>>2];t=+g[v>>2];r=n*(j-m*n)+o*(k-m*o)+p*(l-m*p)}else{q=n;s=o;t=p;r=-999999984306749440.0};c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;c[x+12>>2]=0;y=c[a+56>>2]|0;g[x+(y<<2)>>2]=-+g[a+32+(y<<2)>>2];p=w*q+ +g[x>>2];o=w*s+ +g[x+4>>2];m=w*t+ +g[x+8>>2];n=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);l=+g[f>>2];k=+g[u>>2];j=+g[v>>2];if(l*(p-n*l)+k*(o-n*k)+j*(m-n*j)>r){g[d+(h<<4)>>2]=p-n*l;g[d+(h<<4)+4>>2]=o-n*k;g[d+(h<<4)+8>>2]=m-n*j;g[d+(h<<4)+12>>2]=0.0}h=h+1|0;if((h|0)==(e|0))break;f=c[a+56>>2]|0}i=x;return}function Oj(a){a=a|0;return 0}function Pj(a,b,c){a=a|0;b=b|0;c=c|0;return}function Qj(a){a=a|0;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function Rj(a){a=a|0;return 13146}function Sj(a){a=a|0;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function Tj(a){a=a|0;return 13173}function Uj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0;e=i;i=i+96|0;c[e+32>>2]=1065353216;c[e+32+4>>2]=0;c[e+32+4+4>>2]=0;c[e+32+4+8>>2]=0;c[e+32+4+12>>2]=0;c[e+32+20>>2]=1065353216;c[e+32+24>>2]=0;c[e+32+24+4>>2]=0;c[e+32+24+8>>2]=0;c[e+32+24+12>>2]=0;c[e+32+40>>2]=1065353216;n=e+32+44|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;bc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);l=+g[e>>2];m=+g[e+16>>2];j=+g[e+4>>2];k=+g[e+16+4>>2];f=+g[e+8>>2];h=+g[e+16+8>>2];g[d>>2]=+O(+((l-m)*(l-m)+(j-k)*(j-k)+(f-h)*(f-h)))*.5;g[b>>2]=(m+l)*.5;g[b+4>>2]=(k+j)*.5;g[b+8>>2]=(h+f)*.5;g[b+12>>2]=0.0;i=e;return}function Vj(a){a=a|0;var b=0,d=0.0,e=0.0,f=0.0;b=i;i=i+32|0;Zb[c[(c[a>>2]|0)+12>>2]&127](a,b+8|0,b);f=+g[b+8>>2];e=+g[b+8+4>>2];d=+g[b+8+8>>2];d=+O(+(f*f+e*e+d*d));i=b;return +(d+ +g[b>>2])}function Wj(a,b){a=a|0;b=+b;return +(+Hb[c[(c[a>>2]|0)+16>>2]&15](a)*b)}function Xj(a){a=a|0;return 12}function Yj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=Ob[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=Ob[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=f;if(f|0)tb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];return 13201}function Zj(a,b){a=a|0;b=b|0;var d=0,e=0;e=vb[c[(c[a>>2]|0)+52>>2]&127](a)|0;e=Eb[c[(c[b>>2]|0)+16>>2]&63](b,e,1)|0;d=Eb[c[(c[a>>2]|0)+56>>2]&63](a,c[e+8>>2]|0,b)|0;pb[c[(c[b>>2]|0)+20>>2]&31](b,e,d,1346455635,a);return}function _j(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0,l=0,m=0.0,n=0,o=0,p=0.0,q=0.0;bc[c[(c[a>>2]|0)+8>>2]&127](a,b,f,h);l=c[h>>2]|0;o=c[h+4>>2]|0;i=c[h+8>>2]|0;n=c[f>>2]|0;j=c[f+4>>2]|0;b=c[f+8>>2]|0;m=+g[d>>2];p=+g[d+4>>2];q=+g[d+8>>2];if(m>0.0)l=(g[k>>2]=(c[k>>2]=l,+g[k>>2])+m,c[k>>2]|0);else n=(g[k>>2]=(c[k>>2]=n,+g[k>>2])+m,c[k>>2]|0);if(p>0.0)d=(g[k>>2]=(c[k>>2]=o,+g[k>>2])+p,c[k>>2]|0);else{d=o;j=(g[k>>2]=(c[k>>2]=j,+g[k>>2])+p,c[k>>2]|0)}if(q>0.0)i=(g[k>>2]=(c[k>>2]=i,+g[k>>2])+q,c[k>>2]|0);else b=(g[k>>2]=(c[k>>2]=b,+g[k>>2])+q,c[k>>2]|0);m=+g[e>>2];p=+g[e+4>>2];q=+g[e+8>>2];q=+O(+(m*m+p*p+q*q));q=q*+Hb[c[(c[a>>2]|0)+16>>2]&15](a);c[f>>2]=n;c[f+4>>2]=j;c[f+8>>2]=b;g[f+12>>2]=0.0;c[h>>2]=l;c[h+4>>2]=d;c[h+8>>2]=i;g[h+12>>2]=0.0;g[f>>2]=+g[f>>2]-q;g[f+4>>2]=+g[f+4>>2]-q;g[f+8>>2]=+g[f+8>>2]-q;g[h>>2]=q+ +g[h>>2];g[h+4>>2]=q+ +g[h+4>>2];g[h+8>>2]=q+ +g[h+8>>2];return}function $j(b){b=b|0;var d=0,e=0;c[b>>2]=5176;d=c[b+68>>2]|0;if(d|0?(Zc(d),e=c[b+68>>2]|0,e|0):0){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0)}d=c[b+28>>2]|0;if(!d){a[b+32>>0]=1;c[b+28>>2]=0;c[b+20>>2]=0;b=b+24|0;c[b>>2]=0;return}if(a[b+32>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+28>>2]=0;a[b+32>>0]=1;c[b+28>>2]=0;c[b+20>>2]=0;b=b+24|0;c[b>>2]=0;return}function ak(a){a=a|0;$j(a);if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function bk(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0.0,H=0.0;H=+g[a+52>>2];z=+g[a+36>>2];G=+g[a+56>>2];x=+g[a+40>>2];E=+g[a+60>>2];v=+g[a+44>>2];F=(c[a+20>>2]|0)==0;m=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);k=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);i=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);m=(F?0.0:(H-z)*.5)+m;k=(F?0.0:(G-x)*.5)+k;i=(F?0.0:(E-v)*.5)+i;D=+g[b>>2];u=+N(+D);C=+g[b+4>>2];t=+N(+C);r=+g[b+8>>2];s=+N(+r);B=+g[b+16>>2];q=+N(+B);A=+g[b+20>>2];p=+N(+A);n=+g[b+24>>2];o=+N(+n);y=+g[b+32>>2];l=+N(+y);w=+g[b+36>>2];j=+N(+w);f=+g[b+40>>2];h=+N(+f);z=F?0.0:(H+z)*.5;x=F?0.0:(G+x)*.5;v=F?0.0:(E+v)*.5;r=z*D+x*C+v*r+ +g[b+48>>2];n=z*B+x*A+v*n+ +g[b+52>>2];f=z*y+x*w+v*f+ +g[b+56>>2];g[d>>2]=r-(m*u+k*t+i*s);g[d+4>>2]=n-(m*q+k*p+i*o);g[d+8>>2]=f-(m*l+k*j+i*h);g[d+12>>2]=0.0;g[e>>2]=m*u+k*t+i*s+r;g[e+4>>2]=m*q+k*p+i*o+n;g[e+8>>2]=m*l+k*j+i*h+f;g[e+12>>2]=0.0;return}function ck(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=0.0;p=i;i=i+144|0;if((c[a+20>>2]|0)<=0){o=a+80|0;c[o>>2]=c[b>>2];c[o+4>>2]=c[b+4>>2];c[o+8>>2]=c[b+8>>2];c[o+12>>2]=c[b+12>>2];b=c[a>>2]|0;b=b+68|0;b=c[b>>2]|0;rb[b&255](a);i=p;return}j=p+16+16|0;k=p+16+32|0;l=p+16+48|0;o=0;do{n=c[a+28>>2]|0;m=n+(o*80|0)|0;c[p+16>>2]=c[m>>2];c[p+16+4>>2]=c[m+4>>2];c[p+16+8>>2]=c[m+8>>2];c[p+16+12>>2]=c[m+12>>2];m=n+(o*80|0)+16|0;c[j>>2]=c[m>>2];c[j+4>>2]=c[m+4>>2];c[j+8>>2]=c[m+8>>2];c[j+12>>2]=c[m+12>>2];m=n+(o*80|0)+32|0;c[k>>2]=c[m>>2];c[k+4>>2]=c[m+4>>2];c[k+8>>2]=c[m+8>>2];c[k+12>>2]=c[m+12>>2];m=n+(o*80|0)+48|0;c[l>>2]=c[m>>2];c[l+4>>2]=c[m+4>>2];c[l+8>>2]=c[m+8>>2];c[l+12>>2]=c[m+12>>2];n=c[n+(o*80|0)+64>>2]|0;n=vb[c[(c[n>>2]|0)+28>>2]&127](n)|0;c[p>>2]=c[n>>2];c[p+4>>2]=c[n+4>>2];c[p+8>>2]=c[n+8>>2];q=+g[p+4>>2]*+g[b+4>>2]/+g[a+84>>2];r=+g[p+8>>2]*+g[b+8>>2]/+g[a+88>>2];g[p>>2]=+g[p>>2]*+g[b>>2]/+g[a+80>>2];g[p+4>>2]=q;g[p+8>>2]=r;g[p+12>>2]=0.0;n=c[(c[a+28>>2]|0)+(o*80|0)+64>>2]|0;tb[c[(c[n>>2]|0)+24>>2]&127](n,p);r=+g[p+16+52>>2]*+g[b+4>>2]/+g[a+84>>2];q=+g[p+16+56>>2]*+g[b+8>>2]/+g[a+88>>2];g[p+16+48>>2]=+g[l>>2]*+g[b>>2]/+g[a+80>>2];g[p+16+52>>2]=r;g[p+16+56>>2]=q;g[p+16+60>>2]=0.0;n=c[a+28>>2]|0;m=n+(o*80|0)|0;c[m>>2]=c[p+16>>2];c[m+4>>2]=c[p+16+4>>2];c[m+8>>2]=c[p+16+8>>2];c[m+12>>2]=c[p+16+12>>2];m=n+(o*80|0)+16|0;c[m>>2]=c[j>>2];c[m+4>>2]=c[j+4>>2];c[m+8>>2]=c[j+8>>2];c[m+12>>2]=c[j+12>>2];m=n+(o*80|0)+32|0;c[m>>2]=c[k>>2];c[m+4>>2]=c[k+4>>2];c[m+8>>2]=c[k+8>>2];c[m+12>>2]=c[k+12>>2];n=n+(o*80|0)+48|0;c[n>>2]=c[l>>2];c[n+4>>2]=c[l+4>>2];c[n+8>>2]=c[l+8>>2];c[n+12>>2]=c[l+12>>2];if(c[a+68>>2]|0){m=c[(c[a+28>>2]|0)+(o*80|0)+64>>2]|0;bc[c[(c[m>>2]|0)+8>>2]&127](m,p+16|0,p+128|0,p+112|0);c[p+80>>2]=c[p+128>>2];c[p+80+4>>2]=c[p+128+4>>2];c[p+80+8>>2]=c[p+128+8>>2];c[p+80+12>>2]=c[p+128+12>>2];c[p+80+16>>2]=c[p+112>>2];c[p+80+16+4>>2]=c[p+112+4>>2];c[p+80+16+8>>2]=c[p+112+8>>2];c[p+80+16+12>>2]=c[p+112+12>>2];m=c[a+68>>2]|0;n=c[(c[a+28>>2]|0)+(o*80|0)+76>>2]|0;d=ad(m,n)|0;a:do if(d){f=c[m+8>>2]|0;if((f|0)<=-1){d=c[m>>2]|0;break}if((f|0)>0){h=0;while(1){e=c[d+32>>2]|0;h=h+1|0;if(!e)break a;if((h|0)>=(f|0)){d=e;break}else d=e}}}else d=0;while(0);c[n>>2]=c[p+80>>2];c[n+4>>2]=c[p+80+4>>2];c[n+8>>2]=c[p+80+8>>2];c[n+12>>2]=c[p+80+12>>2];c[n+16>>2]=c[p+80+16>>2];c[n+20>>2]=c[p+80+20>>2];c[n+24>>2]=c[p+80+24>>2];c[n+28>>2]=c[p+80+28>>2];bd(m,d,n)}o=o+1|0}while((o|0)<(c[a+20>>2]|0));o=a+80|0;c[o>>2]=c[b>>2];c[o+4>>2]=c[b+4>>2];c[o+8>>2]=c[b+8>>2];c[o+12>>2]=c[b+12>>2];b=c[a>>2]|0;b=b+68|0;b=c[b>>2]|0;rb[b&255](a);i=p;return}function dk(a){a=a|0;return a+80|0}function ek(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0;e=i;i=i+96|0;c[e+32>>2]=1065353216;c[e+32+4>>2]=0;c[e+32+4+4>>2]=0;c[e+32+4+8>>2]=0;c[e+32+4+12>>2]=0;c[e+32+20>>2]=1065353216;c[e+32+24>>2]=0;c[e+32+24+4>>2]=0;c[e+32+24+8>>2]=0;c[e+32+24+12>>2]=0;c[e+32+40>>2]=1065353216;k=e+32+44|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;bc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);h=(+g[e>>2]-+g[e+16>>2])*.5*2.0;f=(+g[e+4>>2]-+g[e+16+4>>2])*.5*2.0;j=(+g[e+8>>2]-+g[e+16+8>>2])*.5*2.0;g[d>>2]=b/12.0*(f*f+j*j);g[d+4>>2]=b/12.0*(h*h+j*j);g[d+8>>2]=b/12.0*(h*h+f*f);i=e;return}function fk(a){a=a|0;return 13240}function gk(a,b){a=a|0;b=+b;g[a+76>>2]=b;return}function hk(a){a=a|0;return +(+g[a+76>>2])}function ik(a){a=a|0;return 24}function jk(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;e=Ob[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;g=Ob[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=g;if(g|0)tb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];c[b+20>>2]=c[a+76>>2];e=c[a+20>>2]|0;c[b+16>>2]=e;c[b+12>>2]=0;if(!e)return 13274;g=Eb[c[(c[d>>2]|0)+16>>2]&63](d,76,e)|0;e=c[g+8>>2]|0;c[b+12>>2]=Ob[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;if((c[b+16>>2]|0)>0){f=0;while(1){h=c[a+28>>2]|0;c[e+72>>2]=c[h+(f*80|0)+72>>2];c[e+64>>2]=Ob[c[(c[d>>2]|0)+28>>2]&31](d,c[h+(f*80|0)+64>>2]|0)|0;if(!(Ob[c[(c[d>>2]|0)+24>>2]&31](d,c[(c[a+28>>2]|0)+(f*80|0)+64>>2]|0)|0)){h=c[(c[d>>2]|0)+16>>2]|0;i=c[(c[a+28>>2]|0)+(f*80|0)+64>>2]|0;i=vb[c[(c[i>>2]|0)+52>>2]&127](i)|0;i=Eb[h&63](d,i,1)|0;h=c[(c[a+28>>2]|0)+(f*80|0)+64>>2]|0;h=Eb[c[(c[h>>2]|0)+56>>2]&63](h,c[i+8>>2]|0,d)|0;pb[c[(c[d>>2]|0)+20>>2]&31](d,i,h,1346455635,c[(c[a+28>>2]|0)+(f*80|0)+64>>2]|0)}i=c[a+28>>2]|0;c[e+68>>2]=c[i+(f*80|0)+68>>2];c[e>>2]=c[i+(f*80|0)>>2];c[e+4>>2]=c[i+(f*80|0)+4>>2];c[e+8>>2]=c[i+(f*80|0)+8>>2];c[e+12>>2]=c[i+(f*80|0)+12>>2];c[e+16>>2]=c[i+(f*80|0)+16>>2];c[e+20>>2]=c[i+(f*80|0)+20>>2];c[e+24>>2]=c[i+(f*80|0)+24>>2];c[e+28>>2]=c[i+(f*80|0)+28>>2];c[e+32>>2]=c[i+(f*80|0)+32>>2];c[e+36>>2]=c[i+(f*80|0)+36>>2];c[e+40>>2]=c[i+(f*80|0)+40>>2];c[e+44>>2]=c[i+(f*80|0)+44>>2];c[e+48>>2]=c[i+(f*80|0)+48>>2];c[e+52>>2]=c[i+(f*80|0)+52>>2];c[e+56>>2]=c[i+(f*80|0)+56>>2];c[e+60>>2]=c[i+(f*80|0)+60>>2];f=f+1|0;if((f|0)>=(c[b+16>>2]|0)){e=d;break}else e=e+76|0}}else e=d;pb[c[(c[e>>2]|0)+20>>2]&31](d,g,13249,1497453121,c[g+8>>2]|0);return 13274}function kk(a,b){a=a|0;b=b|0;var d=0,e=0;c[a+72>>2]=(c[a+72>>2]|0)+1;d=c[a+20>>2]|0;if((d|0)>0)do{e=d;d=d+-1|0;if((c[(c[a+28>>2]|0)+(d*80|0)+64>>2]|0)==(b|0))lk(a,d)}while((e|0)>1);rb[c[(c[a>>2]|0)+68>>2]&255](a);return}function lk(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;g=i;i=i+80|0;c[a+72>>2]=(c[a+72>>2]|0)+1;e=c[a+68>>2]|0;if(e|0){f=c[(c[a+28>>2]|0)+(b*80|0)+76>>2]|0;ad(e,f)|0;d=c[e+4>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[e+4>>2]=f;c[e+12>>2]=(c[e+12>>2]|0)+-1}f=(c[a+20>>2]|0)+-1|0;e=c[a+28>>2]|0;c[g>>2]=c[e+(b*80|0)>>2];c[g+4>>2]=c[e+(b*80|0)+4>>2];c[g+8>>2]=c[e+(b*80|0)+8>>2];c[g+12>>2]=c[e+(b*80|0)+12>>2];c[g+16>>2]=c[e+(b*80|0)+16>>2];c[g+16+4>>2]=c[e+(b*80|0)+16+4>>2];c[g+16+8>>2]=c[e+(b*80|0)+16+8>>2];c[g+16+12>>2]=c[e+(b*80|0)+16+12>>2];c[g+32>>2]=c[e+(b*80|0)+32>>2];c[g+32+4>>2]=c[e+(b*80|0)+32+4>>2];c[g+32+8>>2]=c[e+(b*80|0)+32+8>>2];c[g+32+12>>2]=c[e+(b*80|0)+32+12>>2];c[g+48>>2]=c[e+(b*80|0)+48>>2];c[g+48+4>>2]=c[e+(b*80|0)+48+4>>2];c[g+48+8>>2]=c[e+(b*80|0)+48+8>>2];c[g+48+12>>2]=c[e+(b*80|0)+48+12>>2];c[g+64>>2]=c[e+(b*80|0)+64>>2];c[g+64+4>>2]=c[e+(b*80|0)+64+4>>2];c[g+64+8>>2]=c[e+(b*80|0)+64+8>>2];c[g+64+12>>2]=c[e+(b*80|0)+64+12>>2];c[e+(b*80|0)>>2]=c[e+(f*80|0)>>2];c[e+(b*80|0)+4>>2]=c[e+(f*80|0)+4>>2];c[e+(b*80|0)+8>>2]=c[e+(f*80|0)+8>>2];c[e+(b*80|0)+12>>2]=c[e+(f*80|0)+12>>2];c[e+(b*80|0)+16>>2]=c[e+(f*80|0)+16>>2];c[e+(b*80|0)+16+4>>2]=c[e+(f*80|0)+16+4>>2];c[e+(b*80|0)+16+8>>2]=c[e+(f*80|0)+16+8>>2];c[e+(b*80|0)+16+12>>2]=c[e+(f*80|0)+16+12>>2];c[e+(b*80|0)+32>>2]=c[e+(f*80|0)+32>>2];c[e+(b*80|0)+32+4>>2]=c[e+(f*80|0)+32+4>>2];c[e+(b*80|0)+32+8>>2]=c[e+(f*80|0)+32+8>>2];c[e+(b*80|0)+32+12>>2]=c[e+(f*80|0)+32+12>>2];c[e+(b*80|0)+48>>2]=c[e+(f*80|0)+48>>2];c[e+(b*80|0)+48+4>>2]=c[e+(f*80|0)+48+4>>2];c[e+(b*80|0)+48+8>>2]=c[e+(f*80|0)+48+8>>2];c[e+(b*80|0)+48+12>>2]=c[e+(f*80|0)+48+12>>2];c[e+(b*80|0)+64>>2]=c[e+(f*80|0)+64>>2];c[e+(b*80|0)+64+4>>2]=c[e+(f*80|0)+64+4>>2];c[e+(b*80|0)+64+8>>2]=c[e+(f*80|0)+64+8>>2];c[e+(b*80|0)+64+12>>2]=c[e+(f*80|0)+64+12>>2];e=c[a+28>>2]|0;c[e+(f*80|0)>>2]=c[g>>2];c[e+(f*80|0)+4>>2]=c[g+4>>2];c[e+(f*80|0)+8>>2]=c[g+8>>2];c[e+(f*80|0)+12>>2]=c[g+12>>2];c[e+(f*80|0)+16>>2]=c[g+16>>2];c[e+(f*80|0)+16+4>>2]=c[g+16+4>>2];c[e+(f*80|0)+16+8>>2]=c[g+16+8>>2];c[e+(f*80|0)+16+12>>2]=c[g+16+12>>2];c[e+(f*80|0)+32>>2]=c[g+32>>2];c[e+(f*80|0)+32+4>>2]=c[g+32+4>>2];c[e+(f*80|0)+32+8>>2]=c[g+32+8>>2];c[e+(f*80|0)+32+12>>2]=c[g+32+12>>2];c[e+(f*80|0)+48>>2]=c[g+48>>2];c[e+(f*80|0)+48+4>>2]=c[g+48+4>>2];c[e+(f*80|0)+48+8>>2]=c[g+48+8>>2];c[e+(f*80|0)+48+12>>2]=c[g+48+12>>2];c[e+(f*80|0)+64>>2]=c[g+64>>2];c[e+(f*80|0)+64+4>>2]=c[g+64+4>>2];c[e+(f*80|0)+64+8>>2]=c[g+64+8>>2];c[e+(f*80|0)+64+12>>2]=c[g+64+12>>2];if(!(c[a+68>>2]|0)){b=c[a+20>>2]|0;b=b+-1|0;c[a+20>>2]=b;i=g;return}c[(c[(c[a+28>>2]|0)+(b*80|0)+76>>2]|0)+36>>2]=b;b=c[a+20>>2]|0;b=b+-1|0;c[a+20>>2]=b;i=g;return}function mk(a){a=a|0;var b=0.0,d=0,e=0,f=0,h=0;e=i;i=i+32|0;c[a+36>>2]=1566444395;c[a+40>>2]=1566444395;c[a+44>>2]=1566444395;g[a+48>>2]=0.0;c[a+52>>2]=-581039253;c[a+56>>2]=-581039253;c[a+60>>2]=-581039253;g[a+64>>2]=0.0;if((c[a+20>>2]|0)<=0){i=e;return}d=0;do{f=c[a+28>>2]|0;h=c[f+(d*80|0)+64>>2]|0;bc[c[(c[h>>2]|0)+8>>2]&127](h,f+(d*80|0)|0,e+16|0,e);b=+g[e+16>>2];if(+g[a+36>>2]>b)g[a+36>>2]=b;b=+g[e>>2];if(+g[a+52>>2]<b)g[a+52>>2]=b;b=+g[e+16+4>>2];if(+g[a+40>>2]>b)g[a+40>>2]=b;b=+g[e+4>>2];if(+g[a+56>>2]<b)g[a+56>>2]=b;b=+g[e+16+8>>2];if(+g[a+44>>2]>b)g[a+44>>2]=b;b=+g[e+8>>2];if(+g[a+60>>2]<b)g[a+60>>2]=b;d=d+1|0}while((d|0)<(c[a+20>>2]|0));i=e;return}function nk(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0,k=0;c[b+8>>2]=0;c[b+12>>2]=-1;c[b>>2]=5176;a[b+32>>0]=1;c[b+28>>2]=0;c[b+20>>2]=0;c[b+24>>2]=0;c[b+36>>2]=1566444395;c[b+40>>2]=1566444395;c[b+44>>2]=1566444395;g[b+48>>2]=0.0;c[b+52>>2]=-581039253;c[b+56>>2]=-581039253;c[b+60>>2]=-581039253;g[b+64>>2]=0.0;c[b+68>>2]=0;c[b+72>>2]=1;g[b+76>>2]=0.0;c[b+80>>2]=1065353216;c[b+84>>2]=1065353216;c[b+88>>2]=1065353216;g[b+92>>2]=0.0;c[b+4>>2]=31;if(d){c[5637]=(c[5637]|0)+1;d=qG(79)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}a[d+36>>0]=1;c[d+32>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;a[d+56>>0]=1;c[d+52>>2]=0;c[d+44>>2]=0;c[d+48>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=-1;c[d+12>>2]=0;c[d+16>>2]=0;c[b+68>>2]=d;d=c[b+24>>2]|0}else d=0;if((d|0)>=(e|0))return;if((e|0)!=0?(c[5637]=(c[5637]|0)+1,f=qG((e*80|3)+16|0)|0,(f|0)!=0):0){c[(f+4+15&-16)+-4>>2]=f;h=f+4+15&-16}else h=0;d=c[b+20>>2]|0;if((d|0)>0){f=0;do{i=h+(f*80|0)|0;j=c[b+28>>2]|0;k=j+(f*80|0)|0;c[i>>2]=c[k>>2];c[i+4>>2]=c[k+4>>2];c[i+8>>2]=c[k+8>>2];c[i+12>>2]=c[k+12>>2];i=h+(f*80|0)+16|0;k=j+(f*80|0)+16|0;c[i>>2]=c[k>>2];c[i+4>>2]=c[k+4>>2];c[i+8>>2]=c[k+8>>2];c[i+12>>2]=c[k+12>>2];i=h+(f*80|0)+32|0;k=j+(f*80|0)+32|0;c[i>>2]=c[k>>2];c[i+4>>2]=c[k+4>>2];c[i+8>>2]=c[k+8>>2];c[i+12>>2]=c[k+12>>2];i=h+(f*80|0)+48|0;k=j+(f*80|0)+48|0;c[i>>2]=c[k>>2];c[i+4>>2]=c[k+4>>2];c[i+8>>2]=c[k+8>>2];c[i+12>>2]=c[k+12>>2];i=h+(f*80|0)+64|0;j=j+(f*80|0)+64|0;c[i>>2]=c[j>>2];c[i+4>>2]=c[j+4>>2];c[i+8>>2]=c[j+8>>2];c[i+12>>2]=c[j+12>>2];f=f+1|0}while((f|0)!=(d|0))}d=c[b+28>>2]|0;if(d|0){if(a[b+32>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+28>>2]=0}a[b+32>>0]=1;c[b+28>>2]=h;c[b+24>>2]=e;return}function ok(a){a=a|0;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function pk(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;bc[c[(c[a>>2]|0)+80>>2]&127](a,b,d,e);return}function qk(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0,i=0,j=0;j=c[a+72>>2]|0;i=c[a+68>>2]|0;h=c[a+76>>2]|0;e=+g[a+64>>2]*(+g[b+(j<<2)>>2]/+g[a+16+(j<<2)>>2]);g[a+64>>2]=e;f=+g[a+60>>2]*((+g[b+(i<<2)>>2]/+g[a+16+(i<<2)>>2]+ +g[b+(h<<2)>>2]/+g[a+16+(h<<2)>>2])*.5);g[a+60>>2]=f;g[a+56>>2]=f/+O(+(e*e+f*f));f=+N(+(+g[b>>2]));e=+N(+(+g[b+4>>2]));d=+N(+(+g[b+8>>2]));g[a+16>>2]=f;g[a+20>>2]=e;g[a+24>>2]=d;g[a+28>>2]=0.0;return}function rk(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0;e=i;i=i+96|0;c[e+32>>2]=1065353216;c[e+32+4>>2]=0;c[e+32+4+4>>2]=0;c[e+32+4+8>>2]=0;c[e+32+4+12>>2]=0;c[e+32+20>>2]=1065353216;c[e+32+24>>2]=0;c[e+32+24+4>>2]=0;c[e+32+24+8>>2]=0;c[e+32+24+12>>2]=0;c[e+32+40>>2]=1065353216;l=e+32+44|0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;bc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);j=(+g[e>>2]-+g[e+16>>2])*.5;h=(+g[e+4>>2]-+g[e+16+4>>2])*.5;k=(+g[e+8>>2]-+g[e+16+8>>2])*.5;f=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);g[d>>2]=b*.0833333283662796*((h+f)*2.0*((h+f)*2.0)+(k+f)*2.0*((k+f)*2.0));g[d+4>>2]=b*.0833333283662796*((j+f)*2.0*((j+f)*2.0)+(k+f)*2.0*((k+f)*2.0));g[d+8>>2]=b*.0833333283662796*((j+f)*2.0*((j+f)*2.0)+(h+f)*2.0*((h+f)*2.0));g[d+12>>2]=0.0;i=e;return}function sk(a){a=a|0;return 13325}function tk(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=1065353216;c[a+8>>2]=0;g[a+12>>2]=0.0;return}function uk(a){a=a|0;return 60}function vk(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=Ob[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=Ob[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=f;if(f|0)tb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];c[b+28>>2]=c[a+32>>2];c[b+32>>2]=c[a+36>>2];c[b+36>>2]=c[a+40>>2];c[b+40>>2]=c[a+44>>2];c[b+12>>2]=c[a+16>>2];c[b+16>>2]=c[a+20>>2];c[b+20>>2]=c[a+24>>2];c[b+24>>2]=c[a+28>>2];c[b+44>>2]=c[a+48>>2];c[b+52>>2]=c[a+72>>2];return 13330}function wk(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0.0,i=0,j=0.0,k=0.0,l=0,m=0.0;e=+g[b+64>>2]*.5;l=c[b+72>>2]|0;h=+g[d>>2];j=+g[d+4>>2];k=+g[d+8>>2];k=+O(+(h*h+j*j+k*k));f=c[b+68>>2]|0;do if(!(+g[d+(l<<2)>>2]>k*+g[b+56>>2])){h=+g[d+(f<<2)>>2];i=c[b+76>>2]|0;j=+g[d+(i<<2)>>2];k=+O(+(h*h+j*j));if(k>1.1920928955078125e-07){k=+g[b+60>>2]/k;g[a+(f<<2)>>2]=h*k;g[a+(l<<2)>>2]=-e;g[a+(i<<2)>>2]=j*k;break}else{g[a+(f<<2)>>2]=0.0;g[a+(l<<2)>>2]=-e;g[a+(i<<2)>>2]=0.0;break}}else{g[a+(f<<2)>>2]=0.0;g[a+(l<<2)>>2]=e;g[a+(c[b+76>>2]<<2)>>2]=0.0}while(0);if(!(+Hb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0))return;h=+g[d>>2];j=+g[d+4>>2];k=+g[d+8>>2];m=h*h+j*j+k*k<1.4210854715202004e-14?-1.0:h;e=h*h+j*j+k*k<1.4210854715202004e-14?-1.0:j;k=h*h+j*j+k*k<1.4210854715202004e-14?-1.0:k;j=1.0/+O(+(k*k+(m*m+e*e)));h=+Hb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=+g[a>>2]+h*(j*m);g[a+4>>2]=h*(j*e)+ +g[a+4>>2];g[a+8>>2]=h*(j*k)+ +g[a+8>>2];return}function xk(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0,j=0.0,k=0,l=0;h=+g[b+64>>2]*.5;l=c[b+72>>2]|0;e=+g[d>>2];f=+g[d+4>>2];j=+g[d+8>>2];j=+O(+(e*e+f*f+j*j));i=c[b+68>>2]|0;if(+g[d+(l<<2)>>2]>j*+g[b+56>>2]){g[a+(i<<2)>>2]=0.0;g[a+(l<<2)>>2]=h;g[a+(c[b+76>>2]<<2)>>2]=0.0;return}j=+g[d+(i<<2)>>2];k=c[b+76>>2]|0;e=+g[d+(k<<2)>>2];f=+O(+(j*j+e*e));if(f>1.1920928955078125e-07){f=+g[b+60>>2]/f;g[a+(i<<2)>>2]=j*f;g[a+(l<<2)>>2]=-h;g[a+(k<<2)>>2]=e*f;return}else{g[a+(i<<2)>>2]=0.0;g[a+(l<<2)>>2]=-h;g[a+(k<<2)>>2]=0.0;return}}function yk(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0,j=0,k=0.0,l=0,m=0.0,n=0.0,o=0,p=0,q=0;q=i;i=i+16|0;if((e|0)<=0){i=q;return}p=0;do{o=d+(p<<4)|0;f=+g[a+64>>2]*.5;h=c[a+72>>2]|0;k=+g[b+(p<<4)>>2];m=+g[b+(p<<4)+4>>2];n=+g[b+(p<<4)+8>>2];n=+O(+(k*k+m*m+n*n));j=c[a+68>>2]|0;do if(!(+g[b+(p<<4)+(h<<2)>>2]>n*+g[a+56>>2])){k=+g[b+(p<<4)+(j<<2)>>2];l=c[a+76>>2]|0;m=+g[b+(p<<4)+(l<<2)>>2];n=+O(+(k*k+m*m));if(n>1.1920928955078125e-07){n=+g[a+60>>2]/n;g[q+(j<<2)>>2]=k*n;g[q+(h<<2)>>2]=-f;g[q+(l<<2)>>2]=m*n;break}else{g[q+(j<<2)>>2]=0.0;g[q+(h<<2)>>2]=-f;g[q+(l<<2)>>2]=0.0;break}}else{g[q+(j<<2)>>2]=0.0;g[q+(h<<2)>>2]=f;g[q+(c[a+76>>2]<<2)>>2]=0.0}while(0);c[o>>2]=c[q>>2];c[o+4>>2]=c[q+4>>2];c[o+8>>2]=c[q+8>>2];c[o+12>>2]=c[q+12>>2];p=p+1|0}while((p|0)!=(e|0));i=q;return}function zk(a){a=a|0;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function Ak(a){a=a|0;return 13361}function Bk(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=1065353216;g[a+12>>2]=0.0;return}function Ck(a){a=a|0;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function Dk(a){a=a|0;return 13382}function Ek(a,b){a=a|0;b=b|0;c[a>>2]=1065353216;c[a+4>>2]=0;c[a+8>>2]=0;g[a+12>>2]=0.0;return}function Fk(b){b=b|0;var d=0;c[b>>2]=5556;d=c[b+108>>2]|0;if(d|0){if(a[b+112>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+108>>2]=0}a[b+112>>0]=1;c[b+108>>2]=0;c[b+100>>2]=0;c[b+104>>2]=0;c[b>>2]=6248;d=c[b+56>>2]|0;if(!d)return;rb[c[c[d>>2]>>2]&255](d);d=c[b+56>>2]|0;if(!d)return;c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0);return}function Gk(b){b=b|0;var d=0,e=0;c[b>>2]=5556;d=c[b+108>>2]|0;if(d|0){if(a[b+112>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+108>>2]=0}a[b+112>>0]=1;c[b+108>>2]=0;c[b+100>>2]=0;c[b+104>>2]=0;c[b>>2]=6248;d=c[b+56>>2]|0;if(d|0?(rb[c[c[d>>2]>>2]&255](d),e=c[b+56>>2]|0,e|0):0){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0)}c[5638]=(c[5638]|0)+1;rG(c[b+-4>>2]|0);return}function Hk(a,b){a=a|0;b=b|0;c[a+16>>2]=c[b>>2];c[a+16+4>>2]=c[b+4>>2];c[a+16+8>>2]=c[b+8>>2];c[a+16+12>>2]=c[b+12>>2];mm(a);return}function Ik(a){a=a|0;return 13408}function Jk(a){a=a|0;return 68}function Kk(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=Ob[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;g=Ob[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=g;if(g|0)tb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];c[b+28>>2]=c[a+32>>2];c[b+32>>2]=c[a+36>>2];c[b+36>>2]=c[a+40>>2];c[b+40>>2]=c[a+44>>2];c[b+12>>2]=c[a+16>>2];c[b+16>>2]=c[a+20>>2];c[b+20>>2]=c[a+24>>2];c[b+24>>2]=c[a+28>>2];c[b+44>>2]=c[a+48>>2];f=c[a+100>>2]|0;c[b+60>>2]=f;if(!f){c[b+52>>2]=0;c[b+56>>2]=0;return 13415}c[b+52>>2]=Ob[c[(c[d>>2]|0)+28>>2]&31](d,c[a+108>>2]|0)|0;c[b+56>>2]=0;g=Eb[c[(c[d>>2]|0)+16>>2]&63](d,16,f)|0;if((f|0)>0){e=c[a+108>>2]|0;b=0;a=c[g+8>>2]|0;while(1){c[a>>2]=c[e+(b<<4)>>2];c[a+4>>2]=c[e+(b<<4)+4>>2];c[a+8>>2]=c[e+(b<<4)+8>>2];c[a+12>>2]=c[e+(b<<4)+12>>2];b=b+1|0;if((b|0)==(f|0))break;else a=a+16|0}}else e=c[a+108>>2]|0;pb[c[(c[d>>2]|0)+20>>2]&31](d,g,16354,1497453121,e);return 13415}function Lk(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;Zb[c[(c[b>>2]|0)+68>>2]&127](a,b,d);if(!(+Hb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0))return;h=+g[d>>2];f=+g[d+4>>2];e=+g[d+8>>2];j=h*h+f*f+e*e<1.4210854715202004e-14?-1.0:h;i=h*h+f*f+e*e<1.4210854715202004e-14?-1.0:f;e=h*h+f*f+e*e<1.4210854715202004e-14?-1.0:e;f=1.0/+O(+(e*e+(j*j+i*i)));h=+Hb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=+g[a>>2]+h*(f*j);g[a+4>>2]=h*(f*i)+ +g[a+4>>2];g[a+8>>2]=h*(f*e)+ +g[a+8>>2];return}function Mk(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0.0,i=0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0;k=c[b+100>>2]|0;if((k|0)<=0){c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;return}o=+g[b+16>>2];p=+g[d>>2]*o;l=+g[b+20>>2];m=+g[d+4>>2]*l;n=+g[b+24>>2];j=+g[d+8>>2]*n;d=c[b+108>>2]|0;f=0;h=-3402823466385288598117041.0e14;i=-1;while(1){e=p*+g[d+(f<<4)>>2]+m*+g[d+(f<<4)+4>>2]+j*+g[d+(f<<4)+8>>2];b=e>h;i=b?f:i;f=f+1|0;if((f|0)==(k|0))break;else h=b?e:h}m=+g[d+(i<<4)+4>>2]*l;p=+g[d+(i<<4)+8>>2]*n;g[a>>2]=+g[d+(i<<4)>>2]*o;g[a+4>>2]=m;g[a+8>>2]=p;g[a+12>>2]=0.0;return}function Nk(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var l=0.0,m=0.0,n=0,o=0.0,p=0.0,q=0,r=0,s=0.0,t=0;r=i;i=i+16|0;g[e>>2]=3402823466385288598117041.0e14;g[f>>2]=-3402823466385288598117041.0e14;n=c[a+100>>2]|0;if((n|0)>0){q=0;do{t=c[a+108>>2]|0;s=+g[t+(q<<4)>>2]*+g[a+16>>2];p=+g[t+(q<<4)+4>>2]*+g[a+20>>2];o=+g[t+(q<<4)+8>>2]*+g[a+24>>2];l=s*+g[b>>2]+p*+g[b+4>>2]+o*+g[b+8>>2]+ +g[b+48>>2];m=s*+g[b+16>>2]+p*+g[b+20>>2]+o*+g[b+24>>2]+ +g[b+52>>2];o=s*+g[b+32>>2]+p*+g[b+36>>2]+o*+g[b+40>>2]+ +g[b+56>>2];p=l*+g[d>>2]+m*+g[d+4>>2]+o*+g[d+8>>2];if(p<+g[e>>2]){g[e>>2]=p;g[h>>2]=l;g[h+4>>2]=m;g[h+8>>2]=o;g[h+12>>2]=0.0}if(p>+g[f>>2]){g[f>>2]=p;g[j>>2]=l;g[j+4>>2]=m;g[j+8>>2]=o;g[j+12>>2]=0.0}q=q+1|0}while((q|0)!=(n|0));s=+g[f>>2];m=s;n=(g[k>>2]=s,c[k>>2]|0)}else{m=-3402823466385288598117041.0e14;n=-8388609}l=+g[e>>2];if(!(l>m)){i=r;return}c[e>>2]=n;g[f>>2]=l;c[r>>2]=c[h>>2];c[r+4>>2]=c[h+4>>2];c[r+8>>2]=c[h+8>>2];c[r+12>>2]=c[h+12>>2];c[h>>2]=c[j>>2];c[h+4>>2]=c[j+4>>2];c[h+8>>2]=c[j+8>>2];c[h+12>>2]=c[j+12>>2];c[j>>2]=c[r>>2];c[j+4>>2]=c[r+4>>2];c[j+8>>2]=c[r+8>>2];c[j+12>>2]=c[r+12>>2];i=r;return}function Ok(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0.0,r=0,s=0.0,t=0;if((e|0)>0)f=0;else return;do{g[d+(f<<4)+12>>2]=-999999984306749440.0;f=f+1|0}while((f|0)!=(e|0));p=0;do{h=+g[a+16>>2];i=+g[b+(p<<4)>>2]*h;j=+g[a+20>>2];k=+g[b+(p<<4)+4>>2]*j;l=+g[a+24>>2];m=+g[b+(p<<4)+8>>2]*l;f=c[a+100>>2]|0;if((f|0)>0){n=c[a+108>>2]|0;o=0;q=-3402823466385288598117041.0e14;r=-1;do{s=i*+g[n+(o<<4)>>2]+k*+g[n+(o<<4)+4>>2]+m*+g[n+(o<<4)+8>>2];t=s>q;r=t?o:r;q=t?s:q;o=o+1|0}while((o|0)!=(f|0));m=+g[n+(r<<4)+4>>2]*j;s=+g[n+(r<<4)+8>>2]*l;g[d+(p<<4)>>2]=+g[n+(r<<4)>>2]*h;g[d+(p<<4)+4>>2]=m;g[d+(p<<4)+8>>2]=s;g[d+(p<<4)+12>>2]=q}else g[d+(p<<4)+12>>2]=-999999984306749440.0;p=p+1|0}while((p|0)!=(e|0));return}function Pk(a){a=a|0;return c[a+100>>2]|0}function Qk(a){a=a|0;return c[a+100>>2]|0}function Rk(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0,j=0;i=c[a+100>>2]|0;j=c[a+108>>2]|0;f=+g[j+(((b|0)%(i|0)|0)<<4)+4>>2]*+g[a+20>>2];h=+g[j+(((b|0)%(i|0)|0)<<4)+8>>2]*+g[a+24>>2];g[d>>2]=+g[j+(((b|0)%(i|0)|0)<<4)>>2]*+g[a+16>>2];g[d+4>>2]=f;g[d+8>>2]=h;g[d+12>>2]=0.0;d=c[a+108>>2]|0;h=+g[d+(((b+1|0)%(i|0)|0)<<4)+4>>2]*+g[a+20>>2];f=+g[d+(((b+1|0)%(i|0)|0)<<4)+8>>2]*+g[a+24>>2];g[e>>2]=+g[d+(((b+1|0)%(i|0)|0)<<4)>>2]*+g[a+16>>2];g[e+4>>2]=h;g[e+8>>2]=f;g[e+12>>2]=0.0;return}function Sk(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0;h=c[a+108>>2]|0;f=+g[h+(b<<4)+4>>2]*+g[a+20>>2];e=+g[h+(b<<4)+8>>2]*+g[a+24>>2];g[d>>2]=+g[h+(b<<4)>>2]*+g[a+16>>2];g[d+4>>2]=f;g[d+8>>2]=e;g[d+12>>2]=0.0;return}function Tk(a){a=a|0;return 0}function Uk(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function Vk(a,b,c){a=a|0;b=b|0;c=+c;return 0}function Wk(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0;l=i;i=i+16|0;c[b+8>>2]=0;c[b+12>>2]=-1;c[b+16>>2]=1065353216;c[b+20>>2]=1065353216;c[b+24>>2]=1065353216;g[b+28>>2]=0.0;g[b+48>>2]=.03999999910593033;c[b+56>>2]=0;c[b+60>>2]=1065353216;c[b+64>>2]=1065353216;c[b+68>>2]=1065353216;g[b+72>>2]=0.0;c[b+76>>2]=-1082130432;c[b+80>>2]=-1082130432;c[b+84>>2]=-1082130432;g[b+88>>2]=0.0;a[b+92>>0]=0;c[b>>2]=5556;a[b+112>>0]=1;c[b+108>>2]=0;c[b+100>>2]=0;c[b+104>>2]=0;c[b+4>>2]=4;if((e|0)<=0){c[b+100>>2]=e;mm(b);i=l;return}c[5637]=(c[5637]|0)+1;h=qG((e<<4|3)+16|0)|0;if(!h)k=0;else{c[(h+4+15&-16)+-4>>2]=h;k=h+4+15&-16}h=c[b+100>>2]|0;if((h|0)>0){j=0;do{m=k+(j<<4)|0;n=(c[b+108>>2]|0)+(j<<4)|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];j=j+1|0}while((j|0)!=(h|0))}h=c[b+108>>2]|0;if(h|0){if(a[b+112>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0)}c[b+108>>2]=0}a[b+112>>0]=1;c[b+108>>2]=k;c[b+104>>2]=e;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];if((e|0)!=1){h=1;do{n=(c[b+108>>2]|0)+(h<<4)|0;c[n>>2]=c[l>>2];c[n+4>>2]=c[l+4>>2];c[n+8>>2]=c[l+8>>2];c[n+12>>2]=c[l+12>>2];h=h+1|0}while((h|0)!=(e|0))}c[b+100>>2]=e;j=0;h=d;while(1){n=c[b+108>>2]|0;d=c[h+4>>2]|0;m=c[h+8>>2]|0;c[n+(j<<4)>>2]=c[h>>2];c[n+(j<<4)+4>>2]=d;c[n+(j<<4)+8>>2]=m;g[n+(j<<4)+12>>2]=0.0;j=j+1|0;if((j|0)==(e|0))break;else h=h+f|0}mm(b);i=l;return}function Xk(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;f=c[b+100>>2]|0;if((f|0)==(c[b+104>>2]|0)?(i=f|0?f<<1:1,(f|0)<(i|0)):0){if(!i)h=0;else{c[5637]=(c[5637]|0)+1;f=qG((i<<4|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}h=f;f=c[b+100>>2]|0}if((f|0)>0){g=0;do{j=h+(g<<4)|0;k=(c[b+108>>2]|0)+(g<<4)|0;c[j>>2]=c[k>>2];c[j+4>>2]=c[k+4>>2];c[j+8>>2]=c[k+8>>2];c[j+12>>2]=c[k+12>>2];g=g+1|0}while((g|0)!=(f|0))}f=c[b+108>>2]|0;if(f|0){if(a[b+112>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[b+108>>2]=0}a[b+112>>0]=1;c[b+108>>2]=h;c[b+104>>2]=i;f=c[b+100>>2]|0}k=(c[b+108>>2]|0)+(f<<4)|0;c[k>>2]=c[d>>2];c[k+4>>2]=c[d+4>>2];c[k+8>>2]=c[d+8>>2];c[k+12>>2]=c[d+12>>2];c[b+100>>2]=(c[b+100>>2]|0)+1;if(!e)return;mm(b);return}function Yk(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0;e=+N(+(+g[b>>2]));d=+N(+(+g[b+4>>2]));c=+N(+(+g[b+8>>2]));g[a+16>>2]=e;g[a+20>>2]=d;g[a+24>>2]=c;g[a+28>>2]=0.0;return}function Zk(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;Zb[c[(c[b>>2]|0)+68>>2]&127](a,b,d);if(!(+Hb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0))return;h=+g[d>>2];f=+g[d+4>>2];e=+g[d+8>>2];j=h*h+f*f+e*e<1.4210854715202004e-14?-1.0:h;i=h*h+f*f+e*e<1.4210854715202004e-14?-1.0:f;e=h*h+f*f+e*e<1.4210854715202004e-14?-1.0:e;f=1.0/+O(+(e*e+(j*j+i*i)));h=+Hb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=+g[a>>2]+h*(f*j);g[a+4>>2]=h*(f*i)+ +g[a+4>>2];g[a+8>>2]=h*(f*e)+ +g[a+8>>2];return}function _k(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0;j=i;i=i+96|0;f=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);h=0;do{q=j+80+(h<<2)|0;c[j+80>>2]=0;c[j+80+4>>2]=0;c[j+80+8>>2]=0;c[j+80+12>>2]=0;g[q>>2]=1.0;k=c[(c[a>>2]|0)+64>>2]|0;l=+g[j+80>>2];m=+g[j+80+4>>2];n=+g[j+80+8>>2];o=l*+g[b+4>>2]+m*+g[b+20>>2]+n*+g[b+36>>2];p=l*+g[b+8>>2]+m*+g[b+24>>2]+n*+g[b+40>>2];g[j+32>>2]=+g[b>>2]*l+ +g[b+16>>2]*m+ +g[b+32>>2]*n;g[j+32+4>>2]=o;g[j+32+8>>2]=p;g[j+32+12>>2]=0.0;Zb[k&127](j+64|0,a,j+32|0);p=+g[j+64>>2];o=+g[j+64+4>>2];n=+g[j+64+8>>2];m=p*+g[b+16>>2]+o*+g[b+20>>2]+n*+g[b+24>>2]+ +g[b+52>>2];l=p*+g[b+32>>2]+o*+g[b+36>>2]+n*+g[b+40>>2]+ +g[b+56>>2];g[j+48>>2]=p*+g[b>>2]+o*+g[b+4>>2]+n*+g[b+8>>2]+ +g[b+48>>2];g[j+48+4>>2]=m;g[j+48+8>>2]=l;g[j+48+12>>2]=0.0;k=j+48+(h<<2)|0;g[e+(h<<2)>>2]=f+ +g[k>>2];g[q>>2]=-1.0;q=c[(c[a>>2]|0)+64>>2]|0;l=+g[j+80>>2];m=+g[j+80+4>>2];n=+g[j+80+8>>2];o=l*+g[b+4>>2]+m*+g[b+20>>2]+n*+g[b+36>>2];p=l*+g[b+8>>2]+m*+g[b+24>>2]+n*+g[b+40>>2];g[j>>2]=+g[b>>2]*l+ +g[b+16>>2]*m+ +g[b+32>>2]*n;g[j+4>>2]=o;g[j+8>>2]=p;g[j+12>>2]=0.0;Zb[q&127](j+16|0,a,j);p=+g[j+16>>2];o=+g[j+16+4>>2];n=+g[j+16+8>>2];m=p*+g[b+16>>2]+o*+g[b+20>>2]+n*+g[b+24>>2]+ +g[b+52>>2];l=p*+g[b+32>>2]+o*+g[b+36>>2]+n*+g[b+40>>2]+ +g[b+56>>2];g[j+48>>2]=p*+g[b>>2]+o*+g[b+4>>2]+n*+g[b+8>>2]+ +g[b+48>>2];g[j+48+4>>2]=m;g[j+48+8>>2]=l;g[j+48+12>>2]=0.0;g[d+(h<<2)>>2]=+g[k>>2]-f;h=h+1|0}while((h|0)!=3);i=j;return}function $k(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;c[b>>2]=5688;d=c[b+56>>2]|0;if(d|0){if(a[b+60>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;e=c[b+28>>2]|0;if((e|0)>0){j=0;do{f=c[b+36>>2]|0;g=f+(j*36|0)+4|0;h=f+(j*36|0)+12|0;i=c[h>>2]|0;d=f+(j*36|0)+16|0;if(i|0){if(a[d>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[i+-4>>2]|0)}c[h>>2]=0}a[d>>0]=1;c[h>>2]=0;c[g>>2]=0;c[f+(j*36|0)+8>>2]=0;j=j+1|0}while((j|0)!=(e|0))}d=c[b+36>>2]|0;if(d|0){if(a[b+40>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}if(a[b+20>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}function al(a){a=a|0;$k(a);if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function bl(a){a=a|0;var b=0,d=0,e=0.0,f=0.0,h=0.0,i=0,j=0;i=c[a+28>>2]|0;e=0.0;f=0.0;h=0.0;j=0;a:while(1){switch(j|0){case 0:{e=+g[a+80>>2]+ +g[a+64>>2];f=+g[a+84>>2]+ +g[a+68>>2];h=+g[a+88>>2]+ +g[a+72>>2];break}case 1:{e=+g[a+80>>2]+ +g[a+64>>2];f=+g[a+84>>2]+ +g[a+68>>2];h=+g[a+72>>2]-+g[a+88>>2];break}case 2:{e=+g[a+80>>2]+ +g[a+64>>2];f=+g[a+68>>2]-+g[a+84>>2];h=+g[a+88>>2]+ +g[a+72>>2];break}case 3:{e=+g[a+80>>2]+ +g[a+64>>2];f=+g[a+68>>2]-+g[a+84>>2];h=+g[a+72>>2]-+g[a+88>>2];break}case 4:{e=+g[a+64>>2]-+g[a+80>>2];f=+g[a+84>>2]+ +g[a+68>>2];h=+g[a+88>>2]+ +g[a+72>>2];break}case 5:{e=+g[a+64>>2]-+g[a+80>>2];f=+g[a+84>>2]+ +g[a+68>>2];h=+g[a+72>>2]-+g[a+88>>2];break}case 6:{e=+g[a+64>>2]-+g[a+80>>2];f=+g[a+68>>2]-+g[a+84>>2];h=+g[a+88>>2]+ +g[a+72>>2];break}case 7:{e=+g[a+64>>2]-+g[a+80>>2];f=+g[a+68>>2]-+g[a+84>>2];h=+g[a+72>>2]-+g[a+88>>2];break}default:{}}if((i|0)>0){b=c[a+36>>2]|0;d=0;do{if(+g[b+(d*36|0)+32>>2]+(e*+g[b+(d*36|0)+20>>2]+f*+g[b+(d*36|0)+24>>2]+h*+g[b+(d*36|0)+28>>2])>0.0){b=0;d=16;break a}d=d+1|0}while((d|0)<(i|0))}j=j+1|0;if((j|0)>=8){b=1;d=16;break}}if((d|0)==16)return b|0;return 0}function cl(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var l=0.0,m=0.0,n=0,o=0.0,p=0.0,q=0,r=0,s=0.0,t=0;r=i;i=i+16|0;g[e>>2]=3402823466385288598117041.0e14;g[f>>2]=-3402823466385288598117041.0e14;n=c[a+8>>2]|0;if((n|0)>0){q=0;do{t=c[a+16>>2]|0;s=+g[t+(q<<4)>>2];p=+g[t+(q<<4)+4>>2];o=+g[t+(q<<4)+8>>2];l=s*+g[b>>2]+p*+g[b+4>>2]+o*+g[b+8>>2]+ +g[b+48>>2];m=s*+g[b+16>>2]+p*+g[b+20>>2]+o*+g[b+24>>2]+ +g[b+52>>2];o=s*+g[b+32>>2]+p*+g[b+36>>2]+o*+g[b+40>>2]+ +g[b+56>>2];p=l*+g[d>>2]+m*+g[d+4>>2]+o*+g[d+8>>2];if(p<+g[e>>2]){g[e>>2]=p;g[h>>2]=l;g[h+4>>2]=m;g[h+8>>2]=o;g[h+12>>2]=0.0}if(p>+g[f>>2]){g[f>>2]=p;g[j>>2]=l;g[j+4>>2]=m;g[j+8>>2]=o;g[j+12>>2]=0.0}q=q+1|0}while((q|0)!=(n|0));s=+g[f>>2];m=s;n=(g[k>>2]=s,c[k>>2]|0)}else{m=-3402823466385288598117041.0e14;n=-8388609}l=+g[e>>2];if(!(l>m)){i=r;return}c[e>>2]=n;g[f>>2]=l;c[r>>2]=c[h>>2];c[r+4>>2]=c[h+4>>2];c[r+8>>2]=c[h+8>>2];c[r+12>>2]=c[h+12>>2];c[h>>2]=c[j>>2];c[h+4>>2]=c[j+4>>2];c[h+8>>2]=c[j+8>>2];c[h+12>>2]=c[j+12>>2];c[j>>2]=c[r>>2];c[j+4>>2]=c[r+4>>2];c[j+8>>2]=c[r+8>>2];c[j+12>>2]=c[r+12>>2];i=r;return}function dl(a){a=a|0;return}function el(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0;s=i;i=i+64|0;q=+g[d>>2];p=+g[d+4>>2];r=+g[d+8>>2];k=q*+g[b+4>>2]+p*+g[b+20>>2]+r*+g[b+36>>2];l=q*+g[b+8>>2]+p*+g[b+24>>2]+r*+g[b+40>>2];g[s+48>>2]=+g[b>>2]*q+ +g[b+16>>2]*p+ +g[b+32>>2]*r;g[s+48+4>>2]=k;g[s+48+8>>2]=l;g[s+48+12>>2]=0.0;Zb[c[(c[a>>2]|0)+64>>2]&127](s+32|0,a,s+48|0);l=+g[s+32>>2];k=+g[s+32+4>>2];r=+g[s+32+8>>2];p=l*+g[b>>2]+k*+g[b+4>>2]+r*+g[b+8>>2]+ +g[b+48>>2];q=l*+g[b+16>>2]+k*+g[b+20>>2]+r*+g[b+24>>2]+ +g[b+52>>2];r=l*+g[b+32>>2]+k*+g[b+36>>2]+r*+g[b+40>>2]+ +g[b+56>>2];t=c[(c[a>>2]|0)+64>>2]|0;k=-+g[s+48+4>>2];l=-+g[s+48+8>>2];g[s>>2]=-+g[s+48>>2];g[s+4>>2]=k;g[s+8>>2]=l;g[s+12>>2]=0.0;Zb[t&127](s+16|0,a,s);l=+g[s+16>>2];k=+g[s+16+4>>2];m=+g[s+16+8>>2];n=l*+g[b>>2]+k*+g[b+4>>2]+m*+g[b+8>>2]+ +g[b+48>>2];o=l*+g[b+16>>2]+k*+g[b+20>>2]+m*+g[b+24>>2]+ +g[b+52>>2];m=l*+g[b+32>>2]+k*+g[b+36>>2]+m*+g[b+40>>2]+ +g[b+56>>2];g[e>>2]=p*+g[d>>2]+q*+g[d+4>>2]+r*+g[d+8>>2];g[f>>2]=n*+g[d>>2]+o*+g[d+4>>2]+m*+g[d+8>>2];g[j>>2]=n;g[j+4>>2]=o;g[j+8>>2]=m;g[j+12>>2]=0.0;g[h>>2]=p;g[h+4>>2]=q;g[h+8>>2]=r;g[h+12>>2]=0.0;k=+g[e>>2];l=+g[f>>2];if(!(k>l)){i=s;return}g[e>>2]=l;g[f>>2]=k;g[j>>2]=p;g[j+4>>2]=q;g[j+8>>2]=r;g[j+12>>2]=0.0;g[h>>2]=n;g[h+4>>2]=o;g[h+8>>2]=m;g[h+12>>2]=0.0;i=s;return}function fl(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0.0,j=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0;z=i;i=i+48|0;switch(c[b+4>>2]|0){case 8:{c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;i=z;return}case 0:{w=+g[b+32>>2];x=+g[b+36>>2];x=+g[d+4>>2]>=0.0?x:-x;y=+g[b+40>>2];y=+g[d+8>>2]>=0.0?y:-y;g[a>>2]=+g[d>>2]>=0.0?w:-w;g[a+4>>2]=x;g[a+8>>2]=y;g[a+12>>2]=0.0;i=z;return}case 1:{u=+g[d>>2];v=+g[d+4>>2];y=+g[d+8>>2];x=u*+g[b+60>>2]+v*+g[b+60+4>>2]+y*+g[b+60+8>>2];w=u*+g[b+60+16>>2]+v*+g[b+60+20>>2]+y*+g[b+60+24>>2];y=u*+g[b+60+32>>2]+v*+g[b+60+36>>2]+y*+g[b+60+40>>2];d=x<w?(w<y?2:1):x<y?2:0;o=c[b+60+(d<<4)+4>>2]|0;r=c[b+60+(d<<4)+8>>2]|0;c[a>>2]=c[b+60+(d<<4)>>2];c[a+4>>2]=o;c[a+8>>2]=r;g[a+12>>2]=0.0;i=z;return}case 13:{c[z+32>>2]=c[b+32>>2];c[z+32+4>>2]=c[b+32+4>>2];c[z+32+8>>2]=c[b+32+8>>2];c[z+32+12>>2]=c[b+32+12>>2];c[z+16>>2]=c[d>>2];f=c[d+4>>2]|0;c[z+16+4>>2]=f;r=c[d+8>>2]|0;c[z+16+8>>2]=r;g[z+16+12>>2]=0.0;d=c[b+56>>2]|0;e=(c[k>>2]=r,+g[k>>2]);switch(d|0){case 2:{e=(c[k>>2]=f,+g[k>>2]);f=0;b=2;o=1;break}case 1:{f=0;b=1;o=2;break}default:{f=1;b=0;o=2}}n=+g[z+32+(f<<2)>>2];l=+g[z+32+(d<<2)>>2];m=+g[z+16+(f<<2)>>2];h=+O(+(m*m+e*e));j=+g[z+16+(b<<2)>>2];if(h!=0.0){g[z+(f<<2)>>2]=m*(n/h);g[z+(b<<2)>>2]=j<0.0?-l:l;g[z+(o<<2)>>2]=n/h*e;c[a>>2]=c[z>>2];c[a+4>>2]=c[z+4>>2];c[a+8>>2]=c[z+8>>2]}else{g[z+(f<<2)>>2]=n;g[z+(b<<2)>>2]=j<0.0?-l:l;g[z+(o<<2)>>2]=0.0;c[a>>2]=c[z>>2];c[a+4>>2]=c[z+4>>2];c[a+8>>2]=c[z+8>>2]}g[a+12>>2]=0.0;i=z;return}case 10:{e=+g[d>>2];h=+g[d+4>>2];j=+g[d+8>>2];o=c[b+56>>2]|0;v=+g[b+32+(o<<2)>>2];l=+g[b+32+(((o+2|0)%3|0)<<2)>>2];if(e*e+h*h+j*j<9.999999747378752e-05){y=1.0;x=0.0;w=0.0}else{w=1.0/+O(+(e*e+h*h+j*j));y=e*w;x=h*w;w=j*w}c[z+32>>2]=0;c[z+32+4>>2]=0;c[z+32+8>>2]=0;c[z+32+12>>2]=0;g[z+32+(o<<2)>>2]=v;q=l*y;t=l*x;u=l*w;s=+g[b+48>>2];m=y*s;p=x*s;s=w*s;e=q+ +g[z+32>>2]-m;h=t+ +g[z+32+4>>2]-p;l=u+ +g[z+32+8>>2]-s;j=w*l+(y*e+x*h);if(j>-999999984306749440.0){b=(g[k>>2]=e,c[k>>2]|0);f=(g[k>>2]=h,c[k>>2]|0);n=j;d=(g[k>>2]=l,c[k>>2]|0)}else{n=-999999984306749440.0;b=0;d=0;f=0}c[z+32>>2]=0;c[z+32+4>>2]=0;c[z+32+8>>2]=0;c[z+32+12>>2]=0;g[z+32+(o<<2)>>2]=-v;j=q+ +g[z+32>>2]-m;h=t+ +g[z+32+4>>2]-p;e=u+ +g[z+32+8>>2]-s;if(w*e+(y*j+x*h)>n){b=(g[k>>2]=j,c[k>>2]|0);f=(g[k>>2]=h,c[k>>2]|0);d=(g[k>>2]=e,c[k>>2]|0)}c[a>>2]=b;c[a+4>>2]=f;c[a+8>>2]=d;g[a+12>>2]=0.0;i=z;return}case 5:{r=c[b+96>>2]|0;o=c[b+100>>2]|0;p=+g[b+16>>2];q=+g[b+20>>2];n=+g[b+24>>2];l=+g[d>>2]*p;m=+g[d+4>>2]*q;e=+g[d+8>>2]*n;if((o|0)>0){b=0;j=-3402823466385288598117041.0e14;f=-1;while(1){h=l*+g[r+(b<<4)>>2]+m*+g[r+(b<<4)+4>>2]+e*+g[r+(b<<4)+8>>2];d=h>j;f=d?b:f;b=b+1|0;if((b|0)==(o|0))break;else j=d?h:j}}else f=-1;x=q*+g[r+(f<<4)+4>>2];y=n*+g[r+(f<<4)+8>>2];g[a>>2]=p*+g[r+(f<<4)>>2];g[a+4>>2]=x;g[a+8>>2]=y;g[a+12>>2]=0.0;i=z;return}case 4:{r=c[b+108>>2]|0;o=c[b+100>>2]|0;p=+g[b+16>>2];q=+g[b+20>>2];n=+g[b+24>>2];l=+g[d>>2]*p;m=+g[d+4>>2]*q;e=+g[d+8>>2]*n;if((o|0)>0){b=0;j=-3402823466385288598117041.0e14;f=-1;while(1){h=l*+g[r+(b<<4)>>2]+m*+g[r+(b<<4)+4>>2]+e*+g[r+(b<<4)+8>>2];d=h>j;f=d?b:f;b=b+1|0;if((b|0)==(o|0))break;else j=d?h:j}}else f=-1;x=q*+g[r+(f<<4)+4>>2];y=n*+g[r+(f<<4)+8>>2];g[a>>2]=p*+g[r+(f<<4)>>2];g[a+4>>2]=x;g[a+8>>2]=y;g[a+12>>2]=0.0;i=z;return}default:{Zb[c[(c[b>>2]|0)+68>>2]&127](a,b,d);i=z;return}}}function gl(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0,k=0.0;j=i;i=i+32|0;c[j+16>>2]=c[d>>2];c[j+16+4>>2]=c[d+4>>2];c[j+16+8>>2]=c[d+8>>2];c[j+16+12>>2]=c[d+12>>2];e=+g[j+16>>2];h=+g[j+16+4>>2];f=+g[j+16+8>>2];if(e*e+h*h+f*f<1.4210854715202004e-14){c[j+16>>2]=-1082130432;c[j+16+4>>2]=-1082130432;c[j+16+8>>2]=-1082130432;g[j+16+12>>2]=0.0;e=-1.0;h=-1.0;f=-1.0}k=1.0/+O(+(e*e+h*h+f*f));g[j+16>>2]=e*k;g[j+16+4>>2]=h*k;g[j+16+8>>2]=f*k;fl(j,b,j+16|0);switch(c[b+4>>2]|0){case 8:{e=+g[b+32>>2]*+g[b+16>>2];break}case 0:{e=+g[b+48>>2];break}case 1:{e=+g[b+48>>2];break}case 13:{e=+g[b+48>>2];break}case 11:{e=+g[b+48>>2];break}case 10:{e=+g[b+48>>2];break}case 4:case 5:{e=+g[b+48>>2];break}default:e=+Hb[c[(c[b>>2]|0)+48>>2]&15](b)}h=e*+g[j+16+4>>2]+ +g[j+4>>2];k=e*+g[j+16+8>>2]+ +g[j+8>>2];g[a>>2]=e*+g[j+16>>2]+ +g[j>>2];g[a+4>>2]=h;g[a+8>>2]=k;g[a+12>>2]=0.0;i=j;return}function hl(a){a=a|0;var b=0,d=0;c[a>>2]=6248;b=c[a+56>>2]|0;if(b|0?(rb[c[c[b>>2]>>2]&255](b),d=c[a+56>>2]|0,d|0):0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function il(a,b){a=a|0;b=b|0;var d=0;d=(c[a+96>>2]|0)+4|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];mm(a);return}function jl(a){a=a|0;return (c[a+96>>2]|0)+4|0}function kl(a){a=a|0;return 13526}function ll(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;Zb[c[(c[b>>2]|0)+68>>2]&127](a,b,d);if(!(+Hb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0))return;h=+g[d>>2];f=+g[d+4>>2];e=+g[d+8>>2];j=h*h+f*f+e*e<1.4210854715202004e-14?-1.0:h;i=h*h+f*f+e*e<1.4210854715202004e-14?-1.0:f;e=h*h+f*f+e*e<1.4210854715202004e-14?-1.0:e;f=1.0/+O(+(e*e+(j*j+i*i)));h=+Hb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=+g[a>>2]+h*(f*j);g[a+4>>2]=h*(f*i)+ +g[a+4>>2];g[a+8>>2]=h*(f*e)+ +g[a+8>>2];return}function ml(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0,l=0,m=0,n=0,o=0.0;m=i;i=i+80|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;e=+g[d>>2];f=+g[d+4>>2];h=+g[d+8>>2];if(e*e+f*f+h*h<9.999999747378752e-05){l=1065353216;j=0;e=0.0;d=0}else{o=1.0/+O(+(e*e+f*f+h*h));l=(g[k>>2]=e*o,c[k>>2]|0);n=(g[k>>2]=f*o,c[k>>2]|0);j=(g[k>>2]=h*o,c[k>>2]|0);e=+g[d+12>>2];d=n}c[m+32>>2]=5836;n=m+32+4|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;g[m+32+20>>2]=-999999984306749440.0;c[m+32+24>>2]=l;c[m+32+28>>2]=d;c[m+32+32>>2]=j;g[m+32+36>>2]=e;c[m+16>>2]=1566444395;c[m+16+4>>2]=1566444395;c[m+16+8>>2]=1566444395;g[m+16+12>>2]=0.0;b=c[b+96>>2]|0;l=c[(c[b>>2]|0)+8>>2]|0;g[m>>2]=-999999984306749440.0;g[m+4>>2]=-999999984306749440.0;g[m+8>>2]=-999999984306749440.0;g[m+12>>2]=0.0;bc[l&127](b,m+32|0,m,m+16|0);c[a>>2]=c[n>>2];c[a+4>>2]=c[n+4>>2];c[a+8>>2]=c[n+8>>2];c[a+12>>2]=c[n+12>>2];i=m;return}function nl(a){a=a|0;rG(a);return}function ol(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;j=+g[a+24>>2];k=+g[a+28>>2];i=+g[a+32>>2];f=j*+g[b>>2]+k*+g[b+4>>2]+i*+g[b+8>>2];h=+g[a+20>>2];if(f>h){g[a+20>>2]=f;c[a+4>>2]=c[b>>2];c[a+4+4>>2]=c[b+4>>2];c[a+4+8>>2]=c[b+8>>2];c[a+4+12>>2]=c[b+12>>2]}else f=h;h=j*+g[b+16>>2]+k*+g[b+20>>2]+i*+g[b+24>>2];if(h>f){g[a+20>>2]=h;c[a+4>>2]=c[b+16>>2];c[a+4+4>>2]=c[b+16+4>>2];c[a+4+8>>2]=c[b+16+8>>2];c[a+4+12>>2]=c[b+16+12>>2]}else h=f;f=j*+g[b+32>>2]+k*+g[b+36>>2]+i*+g[b+40>>2];if(!(f>h))return;g[a+20>>2]=f;c[a+4>>2]=c[b+32>>2];c[a+4+4>>2]=c[b+32+4>>2];c[a+4+8>>2]=c[b+32+8>>2];c[a+4+12>>2]=c[b+32+12>>2];return}function pl(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0;j=i;i=i+80|0;if((e|0)>0)f=0;else{i=j;return}do{g[d+(f<<4)+12>>2]=-999999984306749440.0;f=f+1|0}while((f|0)!=(e|0));f=j+32+4|0;h=0;do{k=b+(h<<4)|0;c[j+32>>2]=5836;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;g[j+32+20>>2]=-999999984306749440.0;c[j+32+24>>2]=c[k>>2];c[j+32+24+4>>2]=c[k+4>>2];c[j+32+24+8>>2]=c[k+8>>2];c[j+32+24+12>>2]=c[k+12>>2];c[j+16>>2]=1566444395;c[j+16+4>>2]=1566444395;c[j+16+8>>2]=1566444395;g[j+16+12>>2]=0.0;k=c[a+96>>2]|0;l=c[(c[k>>2]|0)+8>>2]|0;g[j>>2]=-999999984306749440.0;g[j+4>>2]=-999999984306749440.0;g[j+8>>2]=-999999984306749440.0;g[j+12>>2]=0.0;bc[l&127](k,j+32|0,j,j+16|0);k=d+(h<<4)|0;c[k>>2]=c[f>>2];c[k+4>>2]=c[f+4>>2];c[k+8>>2]=c[f+8>>2];c[k+12>>2]=c[f+12>>2];h=h+1|0}while((h|0)<(e|0));i=j;return}function ql(a){a=a|0;return 0}function rl(a){a=a|0;return 0}function sl(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function tl(a,b,c){a=a|0;b=b|0;c=c|0;return}function ul(a){a=a|0;return 0}function vl(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function wl(a,b,c){a=a|0;b=b|0;c=+c;return 0}function xl(b,d,e){b=b|0;d=d|0;e=e|0;c[b+8>>2]=0;c[b+12>>2]=-1;c[b+16>>2]=1065353216;c[b+20>>2]=1065353216;c[b+24>>2]=1065353216;g[b+28>>2]=0.0;g[b+48>>2]=.03999999910593033;c[b+56>>2]=0;c[b+60>>2]=1065353216;c[b+64>>2]=1065353216;c[b+68>>2]=1065353216;g[b+72>>2]=0.0;c[b+76>>2]=-1082130432;c[b+80>>2]=-1082130432;c[b+84>>2]=-1082130432;g[b+88>>2]=0.0;a[b+92>>0]=0;c[b>>2]=5704;c[b+96>>2]=d;c[b+4>>2]=3;if(!e)return;mm(b);return}function yl(a){a=a|0;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function zl(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0;i=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);m=i+ +g[a+32>>2];k=i+ +g[a+36>>2];i=i+ +g[a+40>>2];u=+N(+(+g[b>>2]));t=+N(+(+g[b+4>>2]));s=+N(+(+g[b+8>>2]));q=+N(+(+g[b+16>>2]));p=+N(+(+g[b+20>>2]));o=+N(+(+g[b+24>>2]));l=+N(+(+g[b+32>>2]));j=+N(+(+g[b+36>>2]));h=+N(+(+g[b+40>>2]));r=+g[b+48>>2];n=+g[b+52>>2];f=+g[b+56>>2];g[d>>2]=r-(m*u+k*t+i*s);g[d+4>>2]=n-(m*q+k*p+i*o);g[d+8>>2]=f-(m*l+k*j+i*h);g[d+12>>2]=0.0;g[e>>2]=m*u+k*t+i*s+r;g[e+4>>2]=m*q+k*p+i*o+n;g[e+8>>2]=m*l+k*j+i*h+f;g[e+12>>2]=0.0;return}function Al(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0;k=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);d=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);m=(k+ +g[a+32>>2])/+g[a+16>>2];j=(h+ +g[a+36>>2])/+g[a+20>>2];f=(d+ +g[a+40>>2])/+g[a+24>>2];l=+N(+(+g[b>>2]));i=+N(+(+g[b+4>>2]));e=+N(+(+g[b+8>>2]));g[a+16>>2]=l;g[a+20>>2]=i;g[a+24>>2]=e;g[a+28>>2]=0.0;g[a+32>>2]=m*l-k;g[a+36>>2]=j*i-h;g[a+40>>2]=f*e-d;g[a+44>>2]=0.0;return}function Bl(a,b,d){a=a|0;b=+b;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;e=+g[a+32>>2];i=+g[a+36>>2];h=+g[a+40>>2];j=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Hb[c[(c[a>>2]|0)+48>>2]&15](a)+h;switch(c[a+56>>2]|0){case 0:{j=b*.25*((f+i)*(f+i))+b/12.0*((j+e)*((j+e)*4.0));g[d>>2]=b*.5*((f+i)*(f+i));g[d+4>>2]=j;g[d+8>>2]=j;g[d+12>>2]=0.0;return}case 2:{g[d>>2]=b*.25*((j+e)*(j+e))+b/12.0*(h*(h*4.0));g[d+4>>2]=b*.25*((j+e)*(j+e))+b/12.0*(h*(h*4.0));g[d+8>>2]=b*.5*((j+e)*(j+e));g[d+12>>2]=0.0;return}default:{i=b*.25*((j+e)*(j+e))+b/12.0*((f+i)*((f+i)*4.0));g[d>>2]=i;g[d+4>>2]=b*.5*((j+e)*(j+e));g[d+8>>2]=i;g[d+12>>2]=0.0;return}}}function Cl(a){a=a|0;return 13587}function Dl(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;g[a+(c[b+56>>2]<<2)>>2]=1.0;return}function El(a,b){a=a|0;b=+b;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0;h=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);i=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);h=h+ +g[a+32>>2];e=e+ +g[a+36>>2];i=i+ +g[a+40>>2];g[a+48>>2]=b;f=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);d=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);b=i-+Hb[c[(c[a>>2]|0)+48>>2]&15](a);g[a+32>>2]=h-f;g[a+36>>2]=e-d;g[a+40>>2]=b;g[a+44>>2]=0.0;return}function Fl(a){a=a|0;return 60}function Gl(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=Ob[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=Ob[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=f;if(f|0)tb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];c[b+28>>2]=c[a+32>>2];c[b+32>>2]=c[a+36>>2];c[b+36>>2]=c[a+40>>2];c[b+40>>2]=c[a+44>>2];c[b+12>>2]=c[a+16>>2];c[b+16>>2]=c[a+20>>2];c[b+20>>2]=c[a+24>>2];c[b+24>>2]=c[a+28>>2];c[b+44>>2]=c[a+48>>2];c[b+52>>2]=c[a+56>>2];return 13597}function Hl(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;i=i+16|0;Zb[c[(c[b>>2]|0)+68>>2]&127](e,b,d);c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];if(!(+Hb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0)){i=e;return}j=+g[d>>2];h=+g[d+4>>2];f=+g[d+8>>2];l=j*j+h*h+f*f<1.4210854715202004e-14?-1.0:j;k=j*j+h*h+f*f<1.4210854715202004e-14?-1.0:h;f=j*j+h*h+f*f<1.4210854715202004e-14?-1.0:f;h=1.0/+O(+(f*f+(l*l+k*k)));j=+Hb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=+g[a>>2]+j*(h*l);g[a+4>>2]=j*(h*k)+ +g[a+4>>2];g[a+8>>2]=j*(h*f)+ +g[a+8>>2];i=e;return}function Il(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=+g[b+32>>2];h=+g[b+36>>2];j=+g[c>>2];f=+g[c+8>>2];i=+O(+(j*j+f*f));e=+g[c+4>>2];if(i!=0.0){f=f*(d/i);e=e<0.0?-h:h;d=j*(d/i)}else{f=0.0;e=e<0.0?-h:h}g[a>>2]=d;g[a+4>>2]=e;g[a+8>>2]=f;return}function Jl(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0;if((d|0)<=0)return;m=0;do{e=+g[a+32>>2];i=+g[a+36>>2];l=+g[b+(m<<4)>>2];f=+g[b+(m<<4)+8>>2];k=+O(+(l*l+f*f));h=+g[b+(m<<4)+4>>2];if(k!=0.0){j=f*(e/k);f=h<0.0?-i:i;e=l*(e/k)}else{j=0.0;f=h<0.0?-i:i}g[c+(m<<4)>>2]=e;g[c+(m<<4)+4>>2]=f;g[c+(m<<4)+8>>2]=j;m=m+1|0}while((m|0)!=(d|0));return}function Kl(a){a=a|0;var b=0.0,d=0.0;d=+g[a+32>>2];b=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);+Hb[c[(c[a>>2]|0)+48>>2]&15](a);+Hb[c[(c[a>>2]|0)+48>>2]&15](a);return +(d+b)}function Ll(a){a=a|0;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function Ml(a){a=a|0;return 13636}function Nl(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=+g[b+36>>2];f=+g[b+32>>2];j=+g[c+4>>2];e=+g[c+8>>2];i=+O(+(j*j+e*e));if(i!=0.0){h=e*(d/i);e=+g[c>>2]<0.0?-f:f;d=j*(d/i)}else{h=0.0;e=+g[c>>2]<0.0?-f:f}g[a+4>>2]=d;g[a>>2]=e;g[a+8>>2]=h;return}function Ol(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0,j=0.0,k=0.0,l=0.0,m=0;if((d|0)<=0)return;m=0;do{e=+g[a+36>>2];h=+g[a+32>>2];i=b+(m<<4)|0;l=+g[b+(m<<4)+4>>2];f=+g[b+(m<<4)+8>>2];k=+O(+(l*l+f*f));if(k!=0.0){j=f*(e/k);f=+g[i>>2]<0.0?-h:h;e=l*(e/k)}else{j=0.0;f=+g[i>>2]<0.0?-h:h}g[c+(m<<4)>>2]=f;g[c+(m<<4)+4>>2]=e;g[c+(m<<4)+8>>2]=j;m=m+1|0}while((m|0)!=(d|0));return}function Pl(a){a=a|0;var b=0.0,d=0.0;d=+g[a+36>>2];+Hb[c[(c[a>>2]|0)+48>>2]&15](a);b=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);+Hb[c[(c[a>>2]|0)+48>>2]&15](a);return +(d+b)}function Ql(a){a=a|0;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function Rl(a){a=a|0;return 13665}function Sl(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=+g[b+32>>2];h=+g[b+40>>2];j=+g[c>>2];f=+g[c+4>>2];i=+O(+(j*j+f*f));e=+g[c+8>>2];if(i!=0.0){f=f*(d/i);e=e<0.0?-h:h;d=j*(d/i)}else{f=0.0;e=e<0.0?-h:h}g[a>>2]=d;g[a+8>>2]=e;g[a+4>>2]=f;return}function Tl(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0;if((d|0)<=0)return;m=0;do{e=+g[a+32>>2];i=+g[a+40>>2];l=+g[b+(m<<4)>>2];f=+g[b+(m<<4)+4>>2];k=+O(+(l*l+f*f));h=+g[b+(m<<4)+8>>2];if(k!=0.0){j=f*(e/k);f=h<0.0?-i:i;e=l*(e/k)}else{j=0.0;f=h<0.0?-i:i}g[c+(m<<4)>>2]=e;g[c+(m<<4)+4>>2]=j;g[c+(m<<4)+8>>2]=f;m=m+1|0}while((m|0)!=(d|0));return}function Ul(a){a=a|0;var b=0.0,d=0.0;d=+g[a+32>>2];b=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);+Hb[c[(c[a>>2]|0)+48>>2]&15](a);+Hb[c[(c[a>>2]|0)+48>>2]&15](a);return +(d+b)}function Vl(a,b){a=a|0;b=b|0;var d=0.0,e=0,f=0.0,h=0.0,i=0.0,j=0.0;c[a+4>>2]=35;c[a+8>>2]=0;c[a+12>>2]=-1;c[a+16>>2]=1065353216;c[a+20>>2]=1065353216;c[a+24>>2]=1065353216;g[a+28>>2]=0.0;g[a+48>>2]=.03999999910593033;c[a>>2]=5856;c[a+56>>2]=1;h=+g[b>>2];f=+g[b+4>>2];d=+g[b+8>>2];d=+g[b+((h<f?(h<d?0:2):f<d?1:2)<<2)>>2]*.10000000149011612;if(d<.03999999910593033){j=+Mg(a);i=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);j=j+ +g[a+32>>2];i=i+ +g[a+36>>2];h=h+ +g[a+40>>2];g[a+48>>2]=d;d=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);h=h-+Hb[c[(c[a>>2]|0)+48>>2]&15](a);g[a+32>>2]=j-d;g[a+36>>2]=i-f;g[a+40>>2]=h;g[a+44>>2]=0.0;e=c[a>>2]|0}else e=5856;h=+Hb[c[e+48>>2]&15](a);i=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);j=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);i=+g[b+4>>2]*+g[a+20>>2]-i;j=+g[b+8>>2]*+g[a+24>>2]-j;g[a+32>>2]=+g[b>>2]*+g[a+16>>2]-h;g[a+36>>2]=i;g[a+40>>2]=j;g[a+44>>2]=0.0;c[a+4>>2]=13;return}function Wl(a){a=a|0;ee(a);return}function Xl(a){a=a|0;ee(a);if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function Yl(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ge(a,b,c,d)|0;return 1}function Zl(d,e,f,h,j){d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0.0,l=0.0,m=0,n=0,o=0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0;A=i;i=i+160|0;a[d+60>>0]=f&1;if(f){r=+g[h>>2]+-1.0;u=+g[h+4>>2]+-1.0;s=+g[h+8>>2]+-1.0;g[d+4>>2]=r;g[d+8>>2]=u;g[d+12>>2]=s;g[d+16>>2]=0.0;v=+g[j>>2]+1.0;x=+g[j+4>>2]+1.0;y=+g[j+8>>2]+1.0;g[d+20>>2]=v;g[d+24>>2]=x;g[d+28>>2]=y;g[d+32>>2]=0.0;g[d+36>>2]=65533.0/(v-r);g[d+40>>2]=65533.0/(x-u);g[d+44>>2]=65533.0/(y-s);g[d+48>>2]=0.0;a[d+60>>0]=1;k=r+ +(~~((r-r)*(65533.0/(v-r)))&65534)/(65533.0/(v-r))+-1.0;l=u+ +(~~((u-u)*(65533.0/(x-u)))&65534)/(65533.0/(x-u))+-1.0;p=s+ +(~~((s-s)*(65533.0/(y-s)))&65534)/(65533.0/(y-s))+-1.0;if(k<r){g[d+4>>2]=k;z=k}else z=r;if(l<u){g[d+8>>2]=l;w=l}else w=u;if(p<s){g[d+12>>2]=p;t=p}else t=s;p=z+ +((~~((v-z)*(65533.0/(v-r))+1.0)&65535|1)&65535)/(65533.0/(v-r))+1.0;l=w+ +((~~((x-w)*(65533.0/(x-u))+1.0)&65535|1)&65535)/(65533.0/(x-u))+1.0;k=t+ +((~~((y-t)*(65533.0/(y-s))+1.0)&65535|1)&65535)/(65533.0/(y-s))+1.0;if(v<p)g[d+20>>2]=p;else p=v;if(x<l)g[d+24>>2]=l;else l=x;if(y<k)g[d+28>>2]=k;else k=y;g[d+36>>2]=65533.0/(p-z);g[d+40>>2]=65533.0/(l-w);g[d+44>>2]=65533.0/(k-t);g[d+48>>2]=0.0;c[A+144>>2]=6208;c[A+144+4>>2]=d+104;c[A+144+8>>2]=d;bc[c[(c[e>>2]|0)+8>>2]&127](e,A+144|0,d+4|0,d+20|0);f=c[d+108>>2]|0;c[A+128>>2]=0;c[A+128+4>>2]=0;c[A+128+8>>2]=0;c[A+128+12>>2]=0;m=c[d+128>>2]|0;if((m|0)<(f<<1|0)){if((c[d+132>>2]|0)<(f<<1|0)){if(!f){h=0;j=m}else{c[5637]=(c[5637]|0)+1;h=qG(f<<5|19)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}j=c[d+128>>2]|0}if((j|0)>0){e=0;do{q=h+(e<<4)|0;o=(c[d+136>>2]|0)+(e<<4)|0;c[q>>2]=c[o>>2];c[q+4>>2]=c[o+4>>2];c[q+8>>2]=c[o+8>>2];c[q+12>>2]=c[o+12>>2];e=e+1|0}while((e|0)!=(j|0))}j=c[d+136>>2]|0;if(j|0){if(a[d+140>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=h;c[d+132>>2]=f<<1;j=d+136|0}else j=d+136|0;h=m;do{q=(c[j>>2]|0)+(h<<4)|0;c[q>>2]=c[A+128>>2];c[q+4>>2]=c[A+128+4>>2];c[q+8>>2]=c[A+128+8>>2];c[q+12>>2]=c[A+128+12>>2];h=h+1|0}while((h|0)!=(f<<1|0))}c[d+128>>2]=f<<1}else{c[A+144>>2]=6228;c[A+144+4>>2]=d+64;c[A+112>>2]=-581039253;c[A+112+4>>2]=-581039253;c[A+112+8>>2]=-581039253;g[A+112+12>>2]=0.0;c[A+96>>2]=1566444395;c[A+96+4>>2]=1566444395;c[A+96+8>>2]=1566444395;g[A+96+12>>2]=0.0;bc[c[(c[e>>2]|0)+8>>2]&127](e,A+144|0,A+112|0,A+96|0);f=c[d+68>>2]|0;m=A+32|0;o=m+64|0;do{c[m>>2]=0;m=m+4|0}while((m|0)<(o|0));q=c[d+88>>2]|0;if((q|0)<(f<<1|0)){if((c[d+92>>2]|0)<(f<<1|0)){if(!f){h=0;j=q}else{c[5637]=(c[5637]|0)+1;h=qG(f<<7|19)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}j=c[d+88>>2]|0}if((j|0)>0){e=0;do{m=h+(e<<6)|0;n=(c[d+96>>2]|0)+(e<<6)|0;o=m+64|0;do{c[m>>2]=c[n>>2];m=m+4|0;n=n+4|0}while((m|0)<(o|0));e=e+1|0}while((e|0)!=(j|0))}j=c[d+96>>2]|0;if(j|0){if(a[d+100>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0)}c[d+96>>2]=0}a[d+100>>0]=1;c[d+96>>2]=h;c[d+92>>2]=f<<1;j=d+96|0}else j=d+96|0;h=q;do{m=(c[j>>2]|0)+(h<<6)|0;n=A+32|0;o=m+64|0;do{c[m>>2]=c[n>>2];m=m+4|0;n=n+4|0}while((m|0)<(o|0));h=h+1|0}while((h|0)!=(f<<1|0))}c[d+88>>2]=f<<1}c[d+56>>2]=0;le(d,0,f);if(a[d+60>>0]|0?(c[d+152>>2]|0)==0:0){if(!(c[d+156>>2]|0)){c[5637]=(c[5637]|0)+1;f=qG(51)|0;if(!f)e=0;else{c[(f+4+15&-16)+-4>>2]=f;e=f+4+15&-16}f=c[d+152>>2]|0;if((f|0)>0){h=0;do{q=e+(h<<5)|0;o=(c[d+160>>2]|0)+(h<<5)|0;c[q>>2]=c[o>>2];c[q+4>>2]=c[o+4>>2];c[q+8>>2]=c[o+8>>2];c[q+12>>2]=c[o+12>>2];c[q+16>>2]=c[o+16>>2];c[q+20>>2]=c[o+20>>2];c[q+24>>2]=c[o+24>>2];c[q+28>>2]=c[o+28>>2];h=h+1|0}while((h|0)!=(f|0))}f=c[d+160>>2]|0;if(f|0){if(a[d+164>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=e;c[d+156>>2]=1;h=d+160|0;j=(c[d+152>>2]|0)+1|0;f=e}else{h=d+160|0;j=1;f=c[d+160>>2]|0}c[d+152>>2]=j;c[f>>2]=c[A>>2];c[f+4>>2]=c[A+4>>2];c[f+8>>2]=c[A+8>>2];c[f+12>>2]=c[A+12>>2];c[f+16>>2]=c[A+16>>2];c[f+20>>2]=c[A+20>>2];c[f+24>>2]=c[A+24>>2];c[f+28>>2]=c[A+28>>2];q=c[h>>2]|0;o=c[d+136>>2]|0;b[q>>1]=b[o>>1]|0;b[q+2>>1]=b[o+2>>1]|0;b[q+4>>1]=b[o+4>>1]|0;b[q+6>>1]=b[o+6>>1]|0;b[q+8>>1]=b[o+8>>1]|0;b[q+10>>1]=b[o+10>>1]|0;c[q+12>>2]=0;o=c[o+12>>2]|0;c[q+16>>2]=(o|0)>-1?1:0-o|0}c[d+168>>2]=c[d+152>>2];f=c[d+116>>2]|0;if(f|0){if(a[d+120>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[d+116>>2]=0}a[d+120>>0]=1;c[d+116>>2]=0;c[d+108>>2]=0;c[d+112>>2]=0;f=c[d+76>>2]|0;if(!f){a[d+80>>0]=1;c[d+76>>2]=0;c[d+68>>2]=0;d=d+72|0;c[d>>2]=0;i=A;return}if(a[d+80>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[d+76>>2]=0;a[d+80>>0]=1;c[d+76>>2]=0;c[d+68>>2]=0;d=d+72|0;c[d>>2]=0;i=A;return}function _l(a){a=a|0;rG(a);return}function $l(d,e,f,h){d=d|0;e=e|0;f=f|0;h=h|0;var i=0.0,j=0.0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0,y=0.0,z=0,A=0.0,B=0.0;j=+g[e>>2];m=(g[k>>2]=j,c[k>>2]|0);r=j<999999984306749440.0?m:1566444395;i=+g[e+4>>2];o=(g[k>>2]=i,c[k>>2]|0);t=i<999999984306749440.0?o:1566444395;y=+g[e+8>>2];q=(g[k>>2]=y,c[k>>2]|0);z=y<999999984306749440.0?q:1566444395;m=j>-999999984306749440.0?m:-581039253;o=i>-999999984306749440.0?o:-581039253;q=y>-999999984306749440.0?q:-581039253;y=+g[e+16>>2];x=y<(c[k>>2]=r,+g[k>>2]);l=(g[k>>2]=y,c[k>>2]|0);r=x?l:r;i=+g[e+20>>2];x=i<(c[k>>2]=t,+g[k>>2]);n=(g[k>>2]=i,c[k>>2]|0);t=x?n:t;j=+g[e+24>>2];x=j<(c[k>>2]=z,+g[k>>2]);p=(g[k>>2]=j,c[k>>2]|0);z=x?p:z;x=(c[k>>2]=m,+g[k>>2])<y?l:m;s=(c[k>>2]=o,+g[k>>2])<i?n:o;q=(c[k>>2]=q,+g[k>>2])<j?p:q;y=+g[e+32>>2];m=y<(c[k>>2]=r,+g[k>>2]);o=(g[k>>2]=y,c[k>>2]|0);r=m?o:r;j=+g[e+36>>2];m=j<(c[k>>2]=t,+g[k>>2]);p=(g[k>>2]=j,c[k>>2]|0);m=m?p:t;i=+g[e+40>>2];l=i<(c[k>>2]=z,+g[k>>2]);n=(g[k>>2]=i,c[k>>2]|0);l=l?n:z;o=(c[k>>2]=x,+g[k>>2])<y?o:x;p=(c[k>>2]=s,+g[k>>2])<j?p:s;q=(c[k>>2]=q,+g[k>>2])<i?n:q;i=(c[k>>2]=o,+g[k>>2]);j=(c[k>>2]=r,+g[k>>2]);if(i-j<2.0000000949949026e-03){o=(g[k>>2]=i+1.0000000474974513e-03,c[k>>2]|0);n=(g[k>>2]=j+-1.0000000474974513e-03,c[k>>2]|0)}else n=r;i=(c[k>>2]=p,+g[k>>2]);j=(c[k>>2]=m,+g[k>>2]);if(i-j<2.0000000949949026e-03){p=(g[k>>2]=i+1.0000000474974513e-03,c[k>>2]|0);m=(g[k>>2]=j+-1.0000000474974513e-03,c[k>>2]|0)}i=(c[k>>2]=q,+g[k>>2]);j=(c[k>>2]=l,+g[k>>2]);if(i-j<2.0000000949949026e-03){q=(g[k>>2]=i+1.0000000474974513e-03,c[k>>2]|0);l=(g[k>>2]=j+-1.0000000474974513e-03,c[k>>2]|0)}r=c[d+8>>2]|0;j=+g[r+4>>2];y=(c[k>>2]=n,+g[k>>2])-j;i=+g[r+8>>2];u=(c[k>>2]=m,+g[k>>2])-i;B=+g[r+12>>2];v=+g[r+36>>2];w=+g[r+40>>2];A=+g[r+44>>2];r=~~(((c[k>>2]=l,+g[k>>2])-B)*A)&65534;j=(c[k>>2]=o,+g[k>>2])-j;i=(c[k>>2]=p,+g[k>>2])-i;q=(~~(((c[k>>2]=q,+g[k>>2])-B)*A+1.0)&65535|1)&65535;o=c[d+4>>2]|0;m=c[o+4>>2]|0;if((m|0)!=(c[o+8>>2]|0)){d=m;z=o+12|0;z=c[z>>2]|0;x=z+(d<<4)|0;b[x>>1]=~~(y*v)&65534;x=z+(d<<4)+2|0;b[x>>1]=~~(u*w)&65534;x=z+(d<<4)+4|0;b[x>>1]=r;x=z+(d<<4)+6|0;b[x>>1]=~~(j*v+1.0)&65535|1;x=z+(d<<4)+8|0;b[x>>1]=~~(i*w+1.0)&65535|1;x=z+(d<<4)+10|0;b[x>>1]=q;d=z+(d<<4)+12|0;c[d>>2]=f<<21|h;h=c[o+4>>2]|0;h=h+1|0;c[o+4>>2]=h;return}p=m|0?m<<1:1;if((m|0)>=(p|0)){d=m;z=o+12|0;z=c[z>>2]|0;x=z+(d<<4)|0;b[x>>1]=~~(y*v)&65534;x=z+(d<<4)+2|0;b[x>>1]=~~(u*w)&65534;x=z+(d<<4)+4|0;b[x>>1]=r;x=z+(d<<4)+6|0;b[x>>1]=~~(j*v+1.0)&65535|1;x=z+(d<<4)+8|0;b[x>>1]=~~(i*w+1.0)&65535|1;x=z+(d<<4)+10|0;b[x>>1]=q;d=z+(d<<4)+12|0;c[d>>2]=f<<21|h;h=c[o+4>>2]|0;h=h+1|0;c[o+4>>2]=h;return}if(!p)l=0;else{c[5637]=(c[5637]|0)+1;l=qG((p<<4|3)+16|0)|0;if(!l)l=0;else{c[(l+4+15&-16)+-4>>2]=l;l=l+4+15&-16}m=c[o+4>>2]|0}if((m|0)>0){n=0;do{d=l+(n<<4)|0;z=(c[o+12>>2]|0)+(n<<4)|0;c[d>>2]=c[z>>2];c[d+4>>2]=c[z+4>>2];c[d+8>>2]=c[z+8>>2];c[d+12>>2]=c[z+12>>2];n=n+1|0}while((n|0)!=(m|0))}m=c[o+12>>2]|0;if(m|0){if(a[o+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[m+-4>>2]|0)}c[o+12>>2]=0}a[o+16>>0]=1;c[o+12>>2]=l;c[o+8>>2]=p;d=c[o+4>>2]|0;z=o+12|0;z=c[z>>2]|0;x=z+(d<<4)|0;b[x>>1]=~~(y*v)&65534;x=z+(d<<4)+2|0;b[x>>1]=~~(u*w)&65534;x=z+(d<<4)+4|0;b[x>>1]=r;x=z+(d<<4)+6|0;b[x>>1]=~~(j*v+1.0)&65535|1;x=z+(d<<4)+8|0;b[x>>1]=~~(i*w+1.0)&65535|1;x=z+(d<<4)+10|0;b[x>>1]=q;d=z+(d<<4)+12|0;c[d>>2]=f<<21|h;h=c[o+4>>2]|0;h=h+1|0;c[o+4>>2]=h;return}function am(a){a=a|0;rG(a);return}function bm(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0,A=0,B=0,C=0,D=0,E=0.0;D=i;i=i+32|0;q=+g[d>>2];j=(g[k>>2]=q,c[k>>2]|0);t=q<999999984306749440.0?j:1566444395;p=+g[d+4>>2];m=(g[k>>2]=p,c[k>>2]|0);u=p<999999984306749440.0?m:1566444395;E=+g[d+8>>2];o=(g[k>>2]=E,c[k>>2]|0);w=E<999999984306749440.0?o:1566444395;s=+g[d+12>>2];y=s<0.0?s:0.0;j=q>-999999984306749440.0?j:-581039253;m=p>-999999984306749440.0?m:-581039253;o=E>-999999984306749440.0?o:-581039253;s=s>0.0?s:0.0;E=+g[d+16>>2];B=E<(c[k>>2]=t,+g[k>>2]);h=(g[k>>2]=E,c[k>>2]|0);t=B?h:t;p=+g[d+20>>2];B=p<(c[k>>2]=u,+g[k>>2]);l=(g[k>>2]=p,c[k>>2]|0);u=B?l:u;q=+g[d+24>>2];B=q<(c[k>>2]=w,+g[k>>2]);n=(g[k>>2]=q,c[k>>2]|0);w=B?n:w;r=+g[d+28>>2];y=r<y?r:y;x=(c[k>>2]=j,+g[k>>2])<E?h:j;v=(c[k>>2]=m,+g[k>>2])<p?l:m;m=(c[k>>2]=o,+g[k>>2])<q?n:o;s=s<r?r:s;E=+g[d+32>>2];B=E<(c[k>>2]=t,+g[k>>2]);h=(g[k>>2]=E,c[k>>2]|0);B=B?h:t;q=+g[d+36>>2];A=q<(c[k>>2]=u,+g[k>>2]);j=(g[k>>2]=q,c[k>>2]|0);A=A?j:u;r=+g[d+40>>2];z=r<(c[k>>2]=w,+g[k>>2]);l=(g[k>>2]=r,c[k>>2]|0);z=z?l:w;p=+g[d+44>>2];y=p<y?p:y;w=(c[k>>2]=x,+g[k>>2])<E?h:x;v=(c[k>>2]=v,+g[k>>2])<q?j:v;u=(c[k>>2]=m,+g[k>>2])<r?l:m;p=s<p?p:s;t=c[b+4>>2]|0;h=c[t+4>>2]|0;if((h|0)==(c[t+8>>2]|0)?(C=h|0?h<<1:1,(h|0)<(C|0)):0){if(!C)o=0;else{c[5637]=(c[5637]|0)+1;h=qG(C<<6|19)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}o=h;h=c[t+4>>2]|0}if((h|0)>0){j=0;do{l=o+(j<<6)|0;m=(c[t+12>>2]|0)+(j<<6)|0;n=l+64|0;do{c[l>>2]=c[m>>2];l=l+4|0;m=m+4|0}while((l|0)<(n|0));j=j+1|0}while((j|0)!=(h|0))}h=c[t+12>>2]|0;if(h|0){if(a[t+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0)}c[t+12>>2]=0}a[t+16>>0]=1;c[t+12>>2]=o;c[t+8>>2]=C;h=c[t+4>>2]|0}C=c[t+12>>2]|0;c[C+(h<<6)>>2]=B;c[C+(h<<6)+4>>2]=A;c[C+(h<<6)+8>>2]=z;g[C+(h<<6)+12>>2]=y;c[C+(h<<6)+16>>2]=w;c[C+(h<<6)+20>>2]=v;c[C+(h<<6)+24>>2]=u;g[C+(h<<6)+28>>2]=p;c[C+(h<<6)+32>>2]=-1;c[C+(h<<6)+36>>2]=e;c[C+(h<<6)+40>>2]=f;f=C+(h<<6)+44|0;c[f>>2]=c[D>>2];c[f+4>>2]=c[D+4>>2];c[f+8>>2]=c[D+8>>2];c[f+12>>2]=c[D+12>>2];c[f+16>>2]=c[D+16>>2];c[t+4>>2]=(c[t+4>>2]|0)+1;i=D;return}function cm(a){a=a|0;var b=0;c[a>>2]=6248;b=c[a+56>>2]|0;if(!b)return;rb[c[c[b>>2]>>2]&255](b);b=c[a+56>>2]|0;if(!b)return;c[5638]=(c[5638]|0)+1;rG(c[b+-4>>2]|0);return}function dm(a){a=a|0;var b=0,d=0;c[a>>2]=6248;b=c[a+56>>2]|0;if(b|0?(rb[c[c[b>>2]>>2]&255](b),d=c[a+56>>2]|0,d|0):0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function em(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0;e=i;i=i+96|0;j=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);c[e+32>>2]=1065353216;c[e+32+4>>2]=0;c[e+32+4+4>>2]=0;c[e+32+4+8>>2]=0;c[e+32+4+12>>2]=0;c[e+32+20>>2]=1065353216;c[e+32+24>>2]=0;c[e+32+24+4>>2]=0;c[e+32+24+8>>2]=0;c[e+32+24+12>>2]=0;c[e+32+40>>2]=1065353216;k=e+32+44|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;bc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);h=(j+(+g[e>>2]-+g[e+16>>2])*.5)*2.0;f=(j+(+g[e+4>>2]-+g[e+16+4>>2])*.5)*2.0;j=(j+(+g[e+8>>2]-+g[e+16+8>>2])*.5)*2.0;g[d>>2]=b*.0833333283662796*(f*f+j*j);g[d+4>>2]=b*.0833333283662796*(h*h+j*j);g[d+8>>2]=b*.0833333283662796*(h*h+f*f);g[d+12>>2]=0.0;i=e;return}function fm(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0,k=0,l=0,m=0.0,n=0.0,o=0,p=0,q=0.0,r=0;p=i;i=i+2048|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;e=+g[d>>2];h=+g[d+4>>2];f=+g[d+8>>2];if(e*e+h*h+f*f<9.999999747378752e-05){n=1.0;m=0.0;h=0.0}else{q=1.0/+O(+(e*e+h*h+f*f));n=e*q;m=f*q;h=h*q}if((vb[c[(c[b>>2]|0)+96>>2]&127](b)|0)<=0){i=p;return}l=0;e=-999999984306749440.0;do{if(((vb[c[(c[b>>2]|0)+96>>2]&127](b)|0)-l|0)<128){d=(vb[c[(c[b>>2]|0)+96>>2]&127](b)|0)-l|0;if((d|0)>0)o=8;else{f=-3402823466385288598117041.0e14;d=-1}}else{d=128;o=8}if((o|0)==8){o=0;j=0;do{Zb[c[(c[b>>2]|0)+108>>2]&127](b,j,p+(j<<4)|0);j=j+1|0}while((j|0)!=(d|0));k=0;f=-3402823466385288598117041.0e14;j=-1;do{q=n*+g[p+(k<<4)>>2]+h*+g[p+(k<<4)+4>>2]+m*+g[p+(k<<4)+8>>2];r=q>f;j=r?k:j;f=r?q:f;k=k+1|0}while((k|0)!=(d|0));d=j}if(f>e){r=p+(d<<4)|0;c[a>>2]=c[r>>2];c[a+4>>2]=c[r+4>>2];c[a+8>>2]=c[r+8>>2];c[a+12>>2]=c[r+12>>2];e=f}l=l+128|0}while((l|0)<(vb[c[(c[b>>2]|0)+96>>2]&127](b)|0));i=p;return}function gm(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0;w=i;i=i+2048|0;if((e|0)>0)f=0;else{i=w;return}do{g[d+(f<<4)+12>>2]=-999999984306749440.0;f=f+1|0}while((f|0)!=(e|0));t=0;do{if((vb[c[(c[a>>2]|0)+96>>2]&127](a)|0)>0){r=b+(t<<4)|0;s=b+(t<<4)+4|0;o=b+(t<<4)+8|0;p=d+(t<<4)+12|0;q=d+(t<<4)|0;u=0;do{if(((vb[c[(c[a>>2]|0)+96>>2]&127](a)|0)-u|0)<128){f=(vb[c[(c[a>>2]|0)+96>>2]&127](a)|0)-u|0;if((f|0)>0)v=10;else{j=-3402823466385288598117041.0e14;f=-1}}else{f=128;v=10}if((v|0)==10){v=0;h=0;do{Zb[c[(c[a>>2]|0)+108>>2]&127](a,h,w+(h<<4)|0);h=h+1|0}while((h|0)!=(f|0));k=+g[r>>2];l=+g[s>>2];m=+g[o>>2];n=0;j=-3402823466385288598117041.0e14;h=-1;do{x=k*+g[w+(n<<4)>>2]+l*+g[w+(n<<4)+4>>2]+m*+g[w+(n<<4)+8>>2];y=x>j;h=y?n:h;j=y?x:j;n=n+1|0}while((n|0)!=(f|0));f=h}if(j>+g[p>>2]){y=w+(f<<4)|0;c[q>>2]=c[y>>2];c[q+4>>2]=c[y+4>>2];c[q+8>>2]=c[y+8>>2];c[q+12>>2]=c[y+12>>2];g[p>>2]=j}u=u+128|0}while((u|0)<(vb[c[(c[a>>2]|0)+96>>2]&127](a)|0))}t=t+1|0}while((t|0)!=(e|0));i=w;return}function hm(d,f){d=d|0;f=f|0;var h=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0.0,y=0,z=0,A=0,B=0,C=0,D=0,E=0.0,F=0.0,G=0,H=0.0,I=0.0,J=0,K=0,L=0.0,M=0.0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0.0,ga=0,ha=0;ea=i;i=i+288|0;h=c[d+56>>2]|0;if(h|0?(rb[c[c[h>>2]>>2]&255](h),j=c[d+56>>2]|0,j|0):0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0)}c[5637]=(c[5637]|0)+1;h=qG(151)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}c[h>>2]=5688;a[h+20>>0]=1;c[h+16>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;a[h+40>>0]=1;c[h+36>>2]=0;c[h+28>>2]=0;c[h+32>>2]=0;a[h+60>>0]=1;c[h+56>>2]=0;c[h+48>>2]=0;c[h+52>>2]=0;c[d+56>>2]=h;o=0;n=0;da=0;J=0;while(1){if((o|0)>=(vb[c[(c[d>>2]|0)+96>>2]&127](d)|0))break;do if((J|0)==(n|0)){l=n|0?n<<1:1;if((n|0)<(l|0)){if((l|0)!=0?(c[5637]=(c[5637]|0)+1,p=qG((l<<4|3)+16|0)|0,(p|0)!=0):0){c[(p+4+15&-16)+-4>>2]=p;h=p+4+15&-16}else h=0;if((n|0)<=0){if(!da){m=n;j=l;break}}else{j=0;do{ca=h+(j<<4)|0;ba=da+(j<<4)|0;c[ca>>2]=c[ba>>2];c[ca+4>>2]=c[ba+4>>2];c[ca+8>>2]=c[ba+8>>2];c[ca+12>>2]=c[ba+12>>2];j=j+1|0}while((j|0)!=(n|0))}c[5638]=(c[5638]|0)+1;rG(c[da+-4>>2]|0);m=n;j=l}else{m=n;j=n;h=da}}else{m=J;j=n;h=da}while(0);n=h+(J<<4)|0;c[n>>2]=c[ea+200>>2];c[n+4>>2]=c[ea+200+4>>2];c[n+8>>2]=c[ea+200+8>>2];c[n+12>>2]=c[ea+200+12>>2];Zb[c[(c[d>>2]|0)+108>>2]&127](d,o,n);o=o+1|0;n=j;da=h;J=m+1|0}a[ea+136+16>>0]=1;ca=ea+136+12|0;c[ca>>2]=0;c[ea+136+4>>2]=0;c[ea+136+8>>2]=0;a[ea+136+36>>0]=1;ba=ea+136+32|0;c[ba>>2]=0;c[ea+136+24>>2]=0;c[ea+136+28>>2]=0;a[ea+136+56>>0]=1;aa=ea+136+52|0;c[aa>>2]=0;c[ea+136+44>>2]=0;c[ea+136+48>>2]=0;if(f){if((J|0)>0){G=0;j=0;m=0;l=0;while(1){h=G;G=G+1|0;if((G|0)<(J|0)){C=da+(h<<4)|0;D=da+(h<<4)+4|0;A=da+(h<<4)+8|0;B=G;h=l;do{l=B;B=B+1|0;if((B|0)<(J|0)){y=da+(l<<4)|0;z=da+(l<<4)+4|0;f=da+(l<<4)+8|0;w=B;do{E=+g[C>>2];I=+g[y>>2]-E;F=+g[D>>2];v=+g[z>>2]-F;H=+g[A>>2];x=+g[f>>2]-H;E=+g[da+(w<<4)>>2]-E;F=+g[da+(w<<4)+4>>2]-F;H=+g[da+(w<<4)+8>>2]-H;q=1.0;p=0;while(1){t=(v*H-x*F)*q;u=(x*E-I*H)*q;r=(I*F-v*E)*q;a:do if(r*r+(t*t+u*u)>9.999999747378752e-05){s=1.0/+O(+(r*r+(t*t+u*u)));if((h|0)>0){l=0;do{if(t*s*+g[m+(l<<4)>>2]+u*s*+g[m+(l<<4)+4>>2]+r*s*+g[m+(l<<4)+8>>2]>.9990000128746033)break a;l=l+1|0}while((l|0)<(h|0))}q=t*s*+g[C>>2]+u*s*+g[D>>2]+r*s*+g[A>>2];l=0;do{if(t*s*+g[da+(l<<4)>>2]+u*s*+g[da+(l<<4)+4>>2]+r*s*+g[da+(l<<4)+8>>2]-q+-.009999999776482582>0.0)break a;l=l+1|0}while((l|0)<(J|0));do if((h|0)==(j|0)){o=j|0?j<<1:1;if((j|0)<(o|0)){do if(!o)n=0;else{c[5637]=(c[5637]|0)+1;l=qG((o<<4|3)+16|0)|0;if(!l){n=0;break}c[(l+4+15&-16)+-4>>2]=l;n=l+4+15&-16}while(0);if((j|0)<=0){if(!m){l=j;j=o;m=n;break}}else{l=0;do{Z=n+(l<<4)|0;Y=m+(l<<4)|0;c[Z>>2]=c[Y>>2];c[Z+4>>2]=c[Y+4>>2];c[Z+8>>2]=c[Y+8>>2];c[Z+12>>2]=c[Y+12>>2];l=l+1|0}while((l|0)!=(j|0))}c[5638]=(c[5638]|0)+1;rG(c[m+-4>>2]|0);l=j;j=o;m=n}else l=j}else l=h;while(0);g[m+(l<<4)>>2]=t*s;g[m+(l<<4)+4>>2]=u*s;g[m+(l<<4)+8>>2]=r*s;g[m+(l<<4)+12>>2]=-q;h=h+1|0}while(0);p=p+1|0;if((p|0)==2)break;else q=-1.0}w=w+1|0}while((w|0)!=(J|0))}}while((B|0)!=(J|0))}else h=l;if((G|0)==(J|0))break;else l=h}if((h|0)>0){o=0;p=0;f=0;while(1){Z=m+(f<<4)|0;c[ea+216>>2]=c[Z>>2];c[ea+216+4>>2]=c[Z+4>>2];c[ea+216+8>>2]=c[Z+8>>2];q=+g[m+(f<<4)+12>>2];q=q-+Hb[c[(c[d>>2]|0)+48>>2]&15](d);do if((f|0)==(o|0)){n=o|0?o<<1:1;if((o|0)<(n|0)){if((n|0)!=0?(c[5637]=(c[5637]|0)+1,K=qG((n<<4|3)+16|0)|0,(K|0)!=0):0){c[(K+4+15&-16)+-4>>2]=K;l=K+4+15&-16}else l=0;if((o|0)<=0){if(!p){j=o;break}}else{j=0;do{Z=l+(j<<4)|0;Y=p+(j<<4)|0;c[Z>>2]=c[Y>>2];c[Z+4>>2]=c[Y+4>>2];c[Z+8>>2]=c[Y+8>>2];c[Z+12>>2]=c[Y+12>>2];j=j+1|0}while((j|0)!=(o|0))}c[5638]=(c[5638]|0)+1;rG(c[p+-4>>2]|0);j=o}else{j=o;n=o;l=p}}else{j=f;n=o;l=p}while(0);Z=l+(j<<4)|0;c[Z>>2]=c[ea+216>>2];c[Z+4>>2]=c[ea+216+4>>2];c[Z+8>>2]=c[ea+216+8>>2];g[l+(j<<4)+12>>2]=q;f=f+1|0;if((f|0)<(h|0)){o=n;p=l}else break}if((f|0)>0){C=0;n=0;j=0;h=0;do{A=C;C=C+1|0;if((C|0)<(f|0)){B=C;do{y=B;B=B+1|0;if((B|0)<(f|0)){z=B;do{t=+g[l+(y<<4)+4>>2];q=+g[l+(z<<4)+8>>2];r=+g[l+(y<<4)+8>>2];u=+g[l+(z<<4)+4>>2];v=+g[l+(z<<4)>>2];x=+g[l+(y<<4)>>2];s=+g[l+(A<<4)+8>>2];E=+g[l+(A<<4)+4>>2];F=+g[l+(A<<4)>>2];b:do if((((u*x-t*v)*(u*x-t*v)+((t*q-r*u)*(t*q-r*u)+(r*v-q*x)*(r*v-q*x))>9.999999747378752e-05?(v*E-u*F)*(v*E-u*F)+((u*s-q*E)*(u*s-q*E)+(q*F-v*s)*(q*F-v*s))>9.999999747378752e-05:0)?(t*F-x*E)*(t*F-x*E)+((r*E-t*s)*(r*E-t*s)+(x*s-r*F)*(x*s-r*F))>9.999999747378752e-05:0)?(L=s*(u*x-t*v)+(E*(r*v-q*x)+(t*q-r*u)*F),+N(+L)>9.999999974752427e-07):0){I=+g[l+(A<<4)+12>>2];M=+g[l+(y<<4)+12>>2];fa=+g[l+(z<<4)+12>>2];H=-1.0/L*((r*E-t*s)*fa+((t*q-r*u)*I+(u*s-q*E)*M));r=-1.0/L*((x*s-r*F)*fa+((r*v-q*x)*I+(q*F-v*s)*M));q=-1.0/L*((t*F-x*E)*fa+((u*x-t*v)*I+(v*E-u*F)*M));o=0;do{if(+g[l+(o<<4)+12>>2]+(H*+g[l+(o<<4)>>2]+r*+g[l+(o<<4)+4>>2]+q*+g[l+(o<<4)+8>>2])+-.009999999776482582>0.0)break b;o=o+1|0}while((o|0)<(f|0));do if((h|0)==(n|0)){w=n|0?n<<1:1;if((n|0)>=(w|0)){o=n;break}do if(!w)p=0;else{c[5637]=(c[5637]|0)+1;o=qG((w<<4|3)+16|0)|0;if(!o){p=0;break}c[(o+4+15&-16)+-4>>2]=o;p=o+4+15&-16}while(0);if((n|0)<=0){if(!j){o=n;n=w;j=p;break}}else{o=0;do{Z=p+(o<<4)|0;Y=j+(o<<4)|0;c[Z>>2]=c[Y>>2];c[Z+4>>2]=c[Y+4>>2];c[Z+8>>2]=c[Y+8>>2];c[Z+12>>2]=c[Y+12>>2];o=o+1|0}while((o|0)!=(n|0))}c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0);o=n;n=w;j=p}else o=h;while(0);g[j+(o<<4)>>2]=H;g[j+(o<<4)+4>>2]=r;g[j+(o<<4)+8>>2]=q;g[j+(o<<4)+12>>2]=0.0;h=h+1|0}while(0);z=z+1|0}while((z|0)!=(f|0))}}while((B|0)!=(f|0))}}while((C|0)!=(f|0))}else{j=0;h=0}}else{l=0;j=0;h=0}}else{m=0;l=0;j=0;h=0}bs(ea+136|0,j,h);if(j|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0)}if(l|0){c[5638]=(c[5638]|0)+1;rG(c[l+-4>>2]|0)}if(m|0){c[5638]=(c[5638]|0)+1;rG(c[m+-4>>2]|0)}}else bs(ea+136|0,da,J);G=c[ea+136+44>>2]|0;if((G|0)>0){c[5637]=(c[5637]|0)+1;h=qG((G<<4|3)+16|0)|0;if(!h)j=0;else{c[(h+4+15&-16)+-4>>2]=h;j=h+4+15&-16}h=0;do{Z=j+(h<<4)|0;c[Z>>2]=c[ea+120>>2];c[Z+4>>2]=c[ea+120+4>>2];c[Z+8>>2]=c[ea+120+8>>2];c[Z+12>>2]=c[ea+120+12>>2];h=h+1|0}while((h|0)!=(G|0))}else j=0;a[ea+96+16>>0]=1;Z=ea+96+12|0;c[Z>>2]=0;Y=ea+96+4|0;c[Y>>2]=0;c[ea+96+8>>2]=0;m=ea+264|0;o=m+19|0;do{a[m>>0]=0;m=m+1|0}while((m|0)<(o|0));if((G|0)<0)db();if((G|0)>0){im(ea+96|0,G);h=c[Z>>2]|0;l=0;do{m=h+(l*36|0)|0;a[m+16>>0]=1;c[m+4>>2]=0;c[m+4+4>>2]=0;c[m+4+8>>2]=0;m=m+20|0;n=ea+264+3|0;o=m+16|0;do{a[m>>0]=a[n>>0]|0;m=m+1|0;n=n+1|0}while((m|0)<(o|0));l=l+1|0}while((l|0)!=(G|0))}c[Y>>2]=G;p=c[ea+136+4>>2]|0;o=c[d+56>>2]|0;n=c[o+8>>2]|0;if((n|0)<(p|0)){if((c[o+12>>2]|0)<(p|0)){if(!p){h=0;l=n}else{c[5637]=(c[5637]|0)+1;h=qG((p<<4|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}l=c[o+8>>2]|0}if((l|0)>0){m=0;do{X=h+(m<<4)|0;W=(c[o+16>>2]|0)+(m<<4)|0;c[X>>2]=c[W>>2];c[X+4>>2]=c[W+4>>2];c[X+8>>2]=c[W+8>>2];c[X+12>>2]=c[W+12>>2];m=m+1|0}while((m|0)!=(l|0))}l=c[o+16>>2]|0;if(l|0){if(a[o+20>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[l+-4>>2]|0)}c[o+16>>2]=0}a[o+20>>0]=1;c[o+16>>2]=h;c[o+12>>2]=p;l=o+16|0}else l=o+16|0;h=n;do{X=(c[l>>2]|0)+(h<<4)|0;c[X>>2]=c[ea+80>>2];c[X+4>>2]=c[ea+80+4>>2];c[X+8>>2]=c[ea+80+8>>2];c[X+12>>2]=c[ea+80+12>>2];h=h+1|0}while((h|0)!=(p|0))}c[o+8>>2]=p;if((p|0)>0){h=0;do{X=(c[(c[d+56>>2]|0)+16>>2]|0)+(h<<4)|0;W=(c[ca>>2]|0)+(h<<4)|0;c[X>>2]=c[W>>2];c[X+4>>2]=c[W+4>>2];c[X+8>>2]=c[W+8>>2];c[X+12>>2]=c[W+12>>2];h=h+1|0}while((h|0)!=(p|0))}if((G|0)>0){D=0;do{A=(c[ba>>2]|0)+((c[(c[aa>>2]|0)+(D<<2)>>2]|0)*12|0)|0;C=A;l=0;do{B=C+4|0;z=c[C+((c[B>>2]|0)*12|0)+8>>2]|0;w=c[Z>>2]|0;y=w+(D*36|0)+4|0;h=c[y>>2]|0;f=w+(D*36|0)+8|0;if((h|0)==(c[f>>2]|0)?(P=h|0?h<<1:1,(h|0)<(P|0)):0){if(!P)p=0;else{c[5637]=(c[5637]|0)+1;h=qG((P<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}p=h;h=c[y>>2]|0}o=w+(D*36|0)+12|0;n=c[o>>2]|0;if((h|0)<=0)if(!n)m=w+(D*36|0)+16|0;else $=132;else{m=0;do{c[p+(m<<2)>>2]=c[n+(m<<2)>>2];m=m+1|0}while((m|0)!=(h|0));$=132}if(($|0)==132){$=0;h=w+(D*36|0)+16|0;if(a[h>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[n+-4>>2]|0)}c[o>>2]=0;m=h;h=c[y>>2]|0}a[m>>0]=1;c[o>>2]=p;c[f>>2]=P}c[(c[w+(D*36|0)+12>>2]|0)+(h<<2)>>2]=z;c[y>>2]=(c[y>>2]|0)+1;W=c[C+8>>2]|0;X=c[ca>>2]|0;s=+g[X+(W<<4)>>2]-+g[X+(z<<4)>>2];t=+g[X+(W<<4)+4>>2]-+g[X+(z<<4)+4>>2];q=+g[X+(W<<4)+8>>2]-+g[X+(z<<4)+8>>2];r=1.0/+O(+(s*s+t*t+q*q));if((l|0)<2){g[ea+216+(l<<4)>>2]=s*r;g[ea+216+(l<<4)+4>>2]=t*r;g[ea+216+(l<<4)+8>>2]=q*r;g[ea+216+(l<<4)+12>>2]=0.0;l=l+1|0}X=C+((c[B>>2]|0)*12|0)|0;C=X+((c[X>>2]|0)*12|0)|0}while((C|0)!=(A|0));h=j+(D<<4)|0;if((l|0)==2){H=+g[ea+216+4>>2];I=+g[ea+216+24>>2];L=+g[ea+216+8>>2];M=+g[ea+216+20>>2];F=+g[ea+216+16>>2];E=+g[ea+216>>2];W=j+(D<<4)+4|0;X=j+(D<<4)+8|0;g[j+(D<<4)+12>>2]=0.0;fa=1.0/+O(+((H*I-L*M)*(H*I-L*M)+(L*F-I*E)*(L*F-I*E)+(M*E-H*F)*(M*E-H*F)));g[h>>2]=(H*I-L*M)*fa;g[W>>2]=(L*F-I*E)*fa;g[X>>2]=(M*E-H*F)*fa;o=c[Z>>2]|0;g[o+(D*36|0)+20>>2]=(H*I-L*M)*fa;c[o+(D*36|0)+24>>2]=c[W>>2];c[o+(D*36|0)+28>>2]=c[X>>2];g[o+(D*36|0)+32>>2]=1000000015047466219876688.0e6}else{c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;o=c[Z>>2]|0}m=c[o+(D*36|0)+4>>2]|0;if((m|0)>0){n=c[(c[d+56>>2]|0)+16>>2]|0;r=+g[h>>2];s=+g[j+(D<<4)+4>>2];t=+g[j+(D<<4)+8>>2];h=c[o+(D*36|0)+12>>2]|0;q=1000000015047466219876688.0e6;l=0;do{X=c[h+(l<<2)>>2]|0;fa=+g[n+(X<<4)>>2]*r+ +g[n+(X<<4)+4>>2]*s+ +g[n+(X<<4)+8>>2]*t;q=q>fa?fa:q;l=l+1|0}while((l|0)!=(m|0))}else q=1000000015047466219876688.0e6;g[o+(D*36|0)+32>>2]=-q;D=D+1|0}while((D|0)!=(G|0))}if((c[Y>>2]|0)>0){o=0;h=0;n=0;while(1){do if((o|0)==(h|0)){h=o|0?o<<1:1;if((o|0)<(h|0)){if((h|0)!=0?(c[5637]=(c[5637]|0)+1,Q=qG((h<<2|3)+16|0)|0,(Q|0)!=0):0){c[(Q+4+15&-16)+-4>>2]=Q;m=Q+4+15&-16}else m=0;if((o|0)<=0){if(!n)break}else{l=0;do{c[m+(l<<2)>>2]=c[n+(l<<2)>>2];l=l+1|0}while((l|0)!=(o|0))}c[5638]=(c[5638]|0)+1;rG(c[n+-4>>2]|0)}else{h=o;m=n}}else m=n;while(0);c[m+(o<<2)>>2]=o;o=o+1|0;if((o|0)>=(c[Y>>2]|0))break;else n=m}P=ea+56+12|0;Q=ea+56+4|0;while(1){f=o+-1|0;l=c[m+(f<<2)>>2]|0;c[5637]=(c[5637]|0)+1;h=qG(23)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}c[h>>2]=l;X=c[Z>>2]|0;r=+g[X+(l*36|0)+20>>2];s=+g[X+(l*36|0)+24>>2];q=+g[X+(l*36|0)+28>>2];c:do if((o|0)>1){n=1;p=1;l=h;h=f;z=f;while(1){y=p;f=l;d:while(1){l=c[Z>>2]|0;do{X=h;h=h+-1|0;if((X|0)<=0){h=l;K=y;J=f;o=z;break c}w=c[m+(h<<2)>>2]|0}while(!(r*+g[l+(w*36|0)+20>>2]+s*+g[l+(w*36|0)+24>>2]+q*+g[l+(w*36|0)+28>>2]>.9990000128746033));do if((y|0)==(n|0)){n=y|0?y<<1:1;if((y|0)<(n|0)){do if(!n)o=0;else{c[5637]=(c[5637]|0)+1;l=qG((n<<2|3)+16|0)|0;if(!l){o=0;break}c[(l+4+15&-16)+-4>>2]=l;o=l+4+15&-16}while(0);if((y|0)<=0){if(!f){f=o;break}}else{l=0;do{c[o+(l<<2)>>2]=c[f+(l<<2)>>2];l=l+1|0}while((l|0)!=(y|0))}c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0);f=o}else n=y}while(0);c[f+(y<<2)>>2]=w;y=y+1|0;l=0;while(1){p=m+(l<<2)|0;if((c[p>>2]|0)==(w|0))break;l=l+1|0;if((l|0)>=(z|0))continue d}if((l|0)<(z|0))break}o=z+-1|0;X=m+(o<<2)|0;c[p>>2]=c[X>>2];c[X>>2]=w;if((z|0)>1){p=y;l=f;z=o}else{p=y;l=f;$=161;break}}}else{n=1;p=1;l=h;h=f;o=f;$=161}while(0);e:do if(($|0)==161){$=0;y=p;w=l;while(1){l=c[Z>>2]|0;do{X=h;h=h+-1|0;if((X|0)<=0){h=l;K=y;J=w;break e}f=c[m+(h<<2)>>2]|0}while(!(r*+g[l+(f*36|0)+20>>2]+s*+g[l+(f*36|0)+24>>2]+q*+g[l+(f*36|0)+28>>2]>.9990000128746033));do if((y|0)==(n|0)){n=y|0?y<<1:1;if((y|0)<(n|0)){do if(!n)l=0;else{c[5637]=(c[5637]|0)+1;l=qG((n<<2|3)+16|0)|0;if(!l){l=0;break}c[(l+4+15&-16)+-4>>2]=l;l=l+4+15&-16}while(0);if((y|0)<=0){if(!w)break}else{p=0;do{c[l+(p<<2)>>2]=c[w+(p<<2)>>2];p=p+1|0}while((p|0)!=(y|0))}c[5638]=(c[5638]|0)+1;rG(c[w+-4>>2]|0)}else{n=y;l=w}}else l=w;while(0);c[l+(y<<2)>>2]=f;y=y+1|0;w=l}}while(0);if((K|0)>1){a[ea+56+16>>0]=1;c[P>>2]=0;c[Q>>2]=0;c[ea+56+8>>2]=0;q=0.0;r=0.0;s=0.0;n=0;B=0;do{l=c[J+(B<<2)>>2]|0;q=+g[h+(l*36|0)+20>>2]+q;r=+g[h+(l*36|0)+24>>2]+r;s=+g[h+(l*36|0)+28>>2]+s;A=h+(l*36|0)+4|0;if((c[A>>2]|0)>0){z=h+(l*36|0)+12|0;h=n;y=0;while(1){w=c[(c[z>>2]|0)+(y<<2)>>2]|0;X=(c[(c[d+56>>2]|0)+16>>2]|0)+(w<<4)|0;c[ea+216>>2]=c[X>>2];c[ea+216+4>>2]=c[X+4>>2];c[ea+216+8>>2]=c[X+8>>2];c[ea+216+12>>2]=c[X+12>>2];f:do if((h|0)>0){l=c[P>>2]|0;n=0;while(1){if((c[l+(n*24|0)+20>>2]|0)==(w|0))break f;n=n+1|0;if((n|0)>=(h|0)){$=263;break}}}else $=263;while(0);if(($|0)==263){$=0;c[ea>>2]=c[ea+216>>2];c[ea+4>>2]=c[ea+216+4>>2];c[ea+8>>2]=c[ea+216+8>>2];c[ea+12>>2]=c[ea+216+12>>2];do if((h|0)==(c[ea+56+8>>2]|0)){f=h|0?h<<1:1;if((h|0)>=(f|0))break;if(!f)p=0;else{c[5637]=(c[5637]|0)+1;h=qG((f*24|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}p=h;h=c[Q>>2]|0}n=c[P>>2]|0;if((h|0)<=0){if(n)$=272}else{l=0;do{$=p+(l*24|0)|0;X=n+(l*24|0)|0;c[$>>2]=c[X>>2];c[$+4>>2]=c[X+4>>2];c[$+8>>2]=c[X+8>>2];c[$+12>>2]=c[X+12>>2];c[$+16>>2]=c[X+16>>2];c[$+20>>2]=c[X+20>>2];l=l+1|0}while((l|0)!=(h|0));$=272}if(($|0)==272){$=0;if(a[ea+56+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[n+-4>>2]|0);h=c[Q>>2]|0}c[P>>2]=0}a[ea+56+16>>0]=1;c[P>>2]=p;c[ea+56+8>>2]=f}while(0);X=c[P>>2]|0;W=X+(h*24|0)|0;c[W>>2]=c[ea>>2];c[W+4>>2]=c[ea+4>>2];c[W+8>>2]=c[ea+8>>2];c[W+12>>2]=c[ea+12>>2];c[W+16>>2]=c[ea+16>>2];c[X+(h*24|0)+20>>2]=w;h=(c[Q>>2]|0)+1|0;c[Q>>2]=h}y=y+1|0;if((y|0)>=(c[A>>2]|0)){n=h;break}}}B=B+1|0;h=c[Z>>2]|0}while((B|0)<(K|0));a[ea+20+16>>0]=1;c[ea+20+12>>2]=0;c[ea+20+4>>2]=0;c[ea+20+8>>2]=0;X=h+20+((c[J>>2]|0)*9<<2)|0;c[ea+20+20>>2]=c[X>>2];c[ea+20+20+4>>2]=c[X+4>>2];c[ea+20+20+8>>2]=c[X+8>>2];c[ea+20+20+12>>2]=c[X+12>>2];I=1.0/+O(+(q*q+r*r+s*s));M=q*I;L=r*I;I=s*I;if(+N(+I)>.7071067690849304){H=1.0/+O(+(I*I+L*L));u=M*-(I*H);v=0.0;x=L*H;E=-(I*H);F=(I*I+L*L)*H;H=-(M*(L*H))}else{H=1.0/+O(+(M*M+L*L));u=(M*M+L*L)*H;v=-(L*H);x=0.0;E=M*H;F=-(I*(M*H));H=I*-(L*H)}if((n|0)<2)if((n|0)>0){h=n;n=0;p=0;y=0;while(1){z=c[P>>2]|0;do if((n|0)==(p|0)){w=p|0?p<<1:1;if((p|0)>=(w|0)){f=p;l=y;break}do if(!w)l=0;else{c[5637]=(c[5637]|0)+1;h=qG((w*24|3)+16|0)|0;if(!h){l=0;p=n;break}c[(h+4+15&-16)+-4>>2]=h;l=h+4+15&-16;p=n}while(0);if((p|0)<=0){if(y|0)$=209}else{h=0;do{$=l+(h*24|0)|0;X=y+(h*24|0)|0;c[$>>2]=c[X>>2];c[$+4>>2]=c[X+4>>2];c[$+8>>2]=c[X+8>>2];c[$+12>>2]=c[X+12>>2];c[$+16>>2]=c[X+16>>2];c[$+20>>2]=c[X+20>>2];h=h+1|0}while((h|0)!=(p|0));$=209}if(($|0)==209){$=0;c[5638]=(c[5638]|0)+1;rG(c[y+-4>>2]|0)}f=n;h=c[Q>>2]|0;p=w}else{f=n;l=y}while(0);X=l+(f*24|0)|0;c[X>>2]=c[z>>2];c[X+4>>2]=c[z+4>>2];c[X+8>>2]=c[z+8>>2];c[X+12>>2]=c[z+12>>2];c[X+16>>2]=c[z+16>>2];c[X+20>>2]=c[z+20>>2];n=n+1|0;if((n|0)<(h|0))y=l;else{$=278;break}}}else{h=0;l=0;$=307}else{h=c[P>>2]|0;l=n;p=0;do{if(v*+g[h+(p*24|0)>>2]+E*+g[h+(p*24|0)+4>>2]+x*+g[h+(p*24|0)+8>>2]<v*+g[h>>2]+E*+g[h+4>>2]+x*+g[h+8>>2]){c[ea+216>>2]=c[h>>2];c[ea+216+4>>2]=c[h+4>>2];c[ea+216+8>>2]=c[h+8>>2];c[ea+216+12>>2]=c[h+12>>2];c[ea+216+16>>2]=c[h+16>>2];c[ea+216+20>>2]=c[h+20>>2];l=h+(p*24|0)|0;c[h>>2]=c[l>>2];c[h+4>>2]=c[l+4>>2];c[h+8>>2]=c[l+8>>2];c[h+12>>2]=c[l+12>>2];c[h+16>>2]=c[l+16>>2];c[h+20>>2]=c[l+20>>2];l=h+(p*24|0)|0;c[l>>2]=c[ea+216>>2];c[l+4>>2]=c[ea+216+4>>2];c[l+8>>2]=c[ea+216+8>>2];c[l+12>>2]=c[ea+216+12>>2];c[l+16>>2]=c[ea+216+16>>2];c[l+20>>2]=c[ea+216+20>>2];l=n}p=p+1|0}while((p|0)<(l|0));g[h+16>>2]=-1000000015047466219876688.0e6;if((l|0)>1){h=c[P>>2]|0;l=c[Q>>2]|0;s=+g[h+4>>2];n=1;do{r=+g[h+(n*24|0)>>2]-+g[h>>2];fa=+g[h+(n*24|0)+4>>2]-s;q=+g[h+(n*24|0)+8>>2]-+g[h+8>>2];t=F*r+H*fa+u*q;q=v*r+E*fa+x*q;if(t*t+q*q<1.1920928955078125e-07)g[h+(n*24|0)+16>>2]=0.0;else{r=+N(+t);if(!(q>=0.0))q=2.356194496154785-(q+r)/(r-q)*.7853981852531433;else q=.7853981852531433-(q-r)/(q+r)*.7853981852531433;g[h+(n*24|0)+16>>2]=t<0.0?-q:q}n=n+1|0}while((n|0)<(l|0))};c[ea+216>>2]=c[h>>2];c[ea+216+4>>2]=c[h+4>>2];c[ea+216+8>>2]=c[h+8>>2];c[ea+216+12>>2]=c[h+12>>2];jm(ea+56|0,ea+216|0,1,(c[Q>>2]|0)+-1|0);l=c[P>>2]|0;c[5637]=(c[5637]|0)+1;h=qG(43)|0;if(!h)p=0;else{c[(h+4+15&-16)+-4>>2]=h;p=h+4+15&-16}n=c[P>>2]|0;c[p>>2]=c[l>>2];c[p+4>>2]=c[l+4>>2];c[p+8>>2]=c[l+8>>2];c[p+12>>2]=c[l+12>>2];c[p+16>>2]=c[l+16>>2];c[p+20>>2]=c[l+20>>2];c[5637]=(c[5637]|0)+1;h=qG(67)|0;if(!h)l=0;else{c[(h+4+15&-16)+-4>>2]=h;l=h+4+15&-16};c[l>>2]=c[p>>2];c[l+4>>2]=c[p+4>>2];c[l+8>>2]=c[p+8>>2];c[l+12>>2]=c[p+12>>2];c[l+16>>2]=c[p+16>>2];c[l+20>>2]=c[p+20>>2];if(p|0){c[5638]=(c[5638]|0)+1;rG(c[p+-4>>2]|0)}X=l+24|0;c[X>>2]=c[n+24>>2];c[X+4>>2]=c[n+24+4>>2];c[X+8>>2]=c[n+24+8>>2];c[X+12>>2]=c[n+24+12>>2];c[X+16>>2]=c[n+24+16>>2];c[X+20>>2]=c[n+24+20>>2];if((c[Q>>2]|0)==2){h=2;n=2}else{f=2;n=2;w=2;h=2;do{g:do if((f|0)>1){X=c[P>>2]|0;A=X+(h*24|0)|0;q=+g[A>>2];r=+g[X+(h*24|0)+4>>2];s=+g[X+(h*24|0)+8>>2];while(1){X=f+-2|0;p=f+-1|0;F=+g[l+(X*24|0)>>2];H=F-+g[l+(p*24|0)>>2];x=+g[l+(X*24|0)+4>>2];v=x-+g[l+(p*24|0)+4>>2];fa=+g[l+(X*24|0)+8>>2];E=fa-+g[l+(p*24|0)+8>>2];if((H*(x-r)-v*(F-q))*I+(M*(v*(fa-s)-E*(x-r))+L*(E*(F-q)-H*(fa-s)))>0.0)break;if((p|0)>1){f=p;n=p}else{f=p;n=p;break g}}do if((f|0)==(w|0)){z=w<<1;if((w|0)>=(z|0)){f=w;break}if(w){c[5637]=(c[5637]|0)+1;p=qG((w*48|3)+16|0)|0;if(!p)p=0;else{c[(p+4+15&-16)+-4>>2]=p;p=p+4+15&-16}if((n|0)>0){y=p;f=n;$=236}}else{y=0;p=0;f=0;$=236}if(($|0)==236){$=0;w=0;do{X=p+(w*24|0)|0;W=l+(w*24|0)|0;c[X>>2]=c[W>>2];c[X+4>>2]=c[W+4>>2];c[X+8>>2]=c[W+8>>2];c[X+12>>2]=c[W+12>>2];c[X+16>>2]=c[W+16>>2];c[X+20>>2]=c[W+20>>2];w=w+1|0}while((w|0)!=(f|0));p=y}c[5638]=(c[5638]|0)+1;rG(c[l+-4>>2]|0);f=n;w=z;l=p}while(0);f=l+(f*24|0)|0;c[f>>2]=c[A>>2];c[f+4>>2]=c[A+4>>2];c[f+8>>2]=c[A+8>>2];c[f+12>>2]=c[A+12>>2];c[f+16>>2]=c[A+16>>2];c[f+20>>2]=c[A+20>>2];n=n+1|0;f=n}while(0);if((f|0)==1){y=(c[P>>2]|0)+(h*24|0)|0;do if((w|0)==1){c[5637]=(c[5637]|0)+1;p=qG(67)|0;if(!p)f=0;else{c[(p+4+15&-16)+-4>>2]=p;f=p+4+15&-16}if((n|0)<=0){if(!l){p=n;w=2;l=f;break}}else{p=0;do{X=f+(p*24|0)|0;W=l+(p*24|0)|0;c[X>>2]=c[W>>2];c[X+4>>2]=c[W+4>>2];c[X+8>>2]=c[W+8>>2];c[X+12>>2]=c[W+12>>2];c[X+16>>2]=c[W+16>>2];c[X+20>>2]=c[W+20>>2];p=p+1|0}while((p|0)!=(n|0))}c[5638]=(c[5638]|0)+1;rG(c[l+-4>>2]|0);p=n;w=2;l=f}else p=1;while(0);f=l+(p*24|0)|0;c[f>>2]=c[y>>2];c[f+4>>2]=c[y+4>>2];c[f+8>>2]=c[y+8>>2];c[f+12>>2]=c[y+12>>2];c[f+16>>2]=c[y+16>>2];c[f+20>>2]=c[y+20>>2];n=n+1|0;f=n}h=h+1|0}while((h|0)!=(c[Q>>2]|0))}$=278}h:do if(($|0)==278){$=0;if((n|0)>0){D=0;A=0;f=0;h=0;G=0;while(1){B=l+(G*24|0)+20|0;do if((D|0)==(A|0)){w=A|0?A<<1:1;if((A|0)>=(w|0)){C=f;break}do if(!w)p=0;else{c[5637]=(c[5637]|0)+1;h=qG((w<<2|3)+16|0)|0;if(!h){p=0;break}c[(h+4+15&-16)+-4>>2]=h;p=h+4+15&-16}while(0);if((A|0)<=0){if(f|0)$=299}else{h=0;do{c[p+(h<<2)>>2]=c[f+(h<<2)>>2];h=h+1|0}while((h|0)!=(A|0));$=299}if(($|0)==299){$=0;c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0);c[ea+20+12>>2]=0}a[ea+20+16>>0]=1;c[ea+20+12>>2]=p;c[ea+20+8>>2]=w;C=p;h=p;A=w}else C=f;while(0);c[C+(D<<2)>>2]=c[B>>2];D=(c[ea+20+4>>2]|0)+1|0;c[ea+20+4>>2]=D;y=c[Q>>2]|0;i:do if((y|0)>0){z=c[P>>2]|0;p=c[B>>2]|0;w=0;while(1){f=z+(w*24|0)+20|0;w=w+1|0;if((c[f>>2]|0)==(p|0))break;if((w|0)>=(y|0))break i}c[f>>2]=-1}while(0);G=G+1|0;if((G|0)>=(n|0)){D=y;break}else f=C}}else{D=h;h=0}if((D|0)<=0){$=307;break}w=c[P>>2]|0;y=c[Y>>2]|0;z=c[Z>>2]|0;if((y|0)>0)B=0;else{$=307;break}while(1){A=c[w+(B*24|0)+20>>2]|0;if((A|0)!=-1){C=0;do{n=0;while(1){if((c[J+(n<<2)>>2]|0)==(C|0))break;n=n+1|0;if((n|0)>=(K|0)){$=285;break}}do if(($|0)==285){$=0;n=c[z+(C*36|0)+4>>2]|0;if((n|0)<=0)break;p=c[z+(C*36|0)+12>>2]|0;f=0;do{if((c[p+(f<<2)>>2]|0)==(A|0)){n=1;break h}f=f+1|0}while((f|0)<(n|0))}while(0);C=C+1|0}while((C|0)<(y|0))}B=B+1|0;if((B|0)>=(D|0)){$=307;break}}}while(0);if(($|0)==307){$=0;km((c[d+56>>2]|0)+24|0,ea+20|0);n=0}if(l|0){c[5638]=(c[5638]|0)+1;rG(c[l+-4>>2]|0)}if(h|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0);c[ea+20+12>>2]=0}h=c[P>>2]|0;if(h|0){if(a[ea+56+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0)}c[P>>2]=0}if(n&(K|0)>0){y=0;$=317}}else if((K|0)>0){y=0;$=317}if(($|0)==317)while(1){$=0;f=c[J+(y<<2)>>2]|0;w=c[Z>>2]|0;a[ea+216+16>>0]=1;c[ea+216+12>>2]=0;c[ea+216+4>>2]=0;c[ea+216+8>>2]=0;p=c[w+(f*36|0)+4>>2]|0;if((p|0)>0){c[5637]=(c[5637]|0)+1;h=qG((p<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}a[ea+216+16>>0]=1;c[ea+216+12>>2]=h;c[ea+216+8>>2]=p;ZG(h|0,0,p<<2|0)|0;l=c[w+(f*36|0)+12>>2]|0;c[ea+216+4>>2]=p;n=0;do{c[h+(n<<2)>>2]=c[l+(n<<2)>>2];n=n+1|0}while((n|0)!=(p|0))}else{c[ea+216+4>>2]=p;h=0}c[ea+216+20>>2]=c[w+(f*36|0)+20>>2];c[ea+216+20+4>>2]=c[w+(f*36|0)+20+4>>2];c[ea+216+20+8>>2]=c[w+(f*36|0)+20+8>>2];c[ea+216+20+12>>2]=c[w+(f*36|0)+20+12>>2];km((c[d+56>>2]|0)+24|0,ea+216|0);if(h|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0);c[ea+216+12>>2]=0}y=y+1|0;if((y|0)>=(K|0))break;else $=317}if(J|0){c[5638]=(c[5638]|0)+1;rG(c[J+-4>>2]|0)}if(!o)break}}else m=0;X=c[d+56>>2]|0;c[X+64>>2]=0;c[X+64+4>>2]=0;c[X+64+8>>2]=0;c[X+64+12>>2]=0;h=c[X+28>>2]|0;if((h|0)>0){z=0;l=0;n=0;D=0;B=0;w=0;o=0;C=0;y=0;p=0;A=0;G=0;W=0;while(1){f=c[X+36>>2]|0;V=c[f+(W*36|0)+4>>2]|0;if((V|0)>0){T=W&65535;U=W|-65536;R=w;P=y;K=G;h=0;while(1){S=h+1|0;J=c[f+(W*36|0)+12>>2]|0;w=c[J+(h<<2)>>2]&65535;J=c[J+(((S|0)==(V|0)?0:S)<<2)>>2]&65535;Q=J<<16>>16>w<<16>>16?w:J;d=J<<16>>16>w<<16>>16?J:w;f=J<<16>>16>w<<16>>16?w:J;w=J<<16>>16>w<<16>>16?J:w;J=P+-1|0;j:do if((((f&65535)<<16)+(w<<16>>16)&J)>>>0<D>>>0?(_=c[n+((((f&65535)<<16)+(w<<16>>16)&J)<<2)>>2]|0,(_|0)!=-1):0){h=_;while(1){if(w<<16>>16==(b[l+(h<<2)>>1]|0)?f<<16>>16==(b[l+(h<<2)+2>>1]|0):0)break;h=c[o+(h<<2)>>2]|0;if((h|0)==-1){G=0;break j}}G=p+(h<<2)|0}else G=0;while(0);h=c[X+16>>2]|0;u=+g[h+(f<<16>>16<<4)>>2]-+g[h+(w<<16>>16<<4)>>2];v=+g[h+(f<<16>>16<<4)+4>>2]-+g[h+(w<<16>>16<<4)+4>>2];s=+g[h+(f<<16>>16<<4)+8>>2]-+g[h+(w<<16>>16<<4)+8>>2];t=1.0/+O(+(u*u+v*v+s*s));h=c[X+48>>2]|0;k:do if((h|0)>0){f=c[X+56>>2]|0;w=0;while(1){q=+g[f+(w<<4)>>2];r=+g[f+(w<<4)+8>>2];do if(!(+N(+(q-u*t))>1.0e-06)){if(+N(+(+g[f+(w<<4)+4>>2]-v*t))>1.0e-06)break;if(!(+N(+(r-s*t))>1.0e-06))break k}while(0);do if(!(+N(+(u*t+q))>1.0e-06)){if(+N(+(v*t+ +g[f+(w<<4)+4>>2]))>1.0e-06)break;if(!(+N(+(s*t+r))>1.0e-06))break k}while(0);w=w+1|0;if((w|0)>=(h|0)){$=353;break}}}else $=353;while(0);if(($|0)==353){$=0;do if((h|0)==(c[X+52>>2]|0)){y=h|0?h<<1:1;if((h|0)>=(y|0))break;if(!y)w=0;else{c[5637]=(c[5637]|0)+1;h=qG((y<<4|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}w=h;h=c[X+48>>2]|0}if((h|0)>0){f=0;do{ga=w+(f<<4)|0;ha=(c[X+56>>2]|0)+(f<<4)|0;c[ga>>2]=c[ha>>2];c[ga+4>>2]=c[ha+4>>2];c[ga+8>>2]=c[ha+8>>2];c[ga+12>>2]=c[ha+12>>2];f=f+1|0}while((f|0)!=(h|0))}h=c[X+56>>2]|0;if(h|0){if(a[X+60>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0)}c[X+56>>2]=0}a[X+60>>0]=1;c[X+56>>2]=w;c[X+52>>2]=y;h=c[X+48>>2]|0}while(0);ha=c[X+56>>2]|0;g[ha+(h<<4)>>2]=u*t;g[ha+(h<<4)+4>>2]=v*t;g[ha+(h<<4)+8>>2]=s*t;g[ha+(h<<4)+12>>2]=0.0;c[X+48>>2]=(c[X+48>>2]|0)+1}l:do if(!G){h=((Q&65535)<<16)+(d<<16>>16)&J;m:do if(h>>>0<D>>>0){f=c[n+(h<<2)>>2]|0;if((f|0)==-1)break;while(1){if(d<<16>>16==(b[l+(f<<2)>>1]|0)?Q<<16>>16==(b[l+(f<<2)+2>>1]|0):0)break;f=c[o+(f<<2)>>2]|0;if((f|0)==-1)break m}w=p+(f<<2)|0;b[w>>1]=U;b[w+2>>1]=U>>>16;w=R;y=P;G=K;break l}while(0);do if((C|0)==(P|0)){y=C|0?C<<1:1;if((C|0)>=(y|0)){y=C;break}do if(!y)w=0;else{c[5637]=(c[5637]|0)+1;f=qG((y<<2|3)+16|0)|0;if(!f){w=0;break}c[(f+4+15&-16)+-4>>2]=f;w=f+4+15&-16}while(0);if((C|0)<=0){if(!p){p=w;break}}else{f=0;do{ha=w+(f<<2)|0;ga=p+(f<<2)|0;ga=e[ga>>1]|e[ga+2>>1]<<16;b[ha>>1]=ga;b[ha+2>>1]=ga>>>16;f=f+1|0}while((f|0)!=(C|0))}c[5638]=(c[5638]|0)+1;rG(c[p+-4>>2]|0);p=w}else y=P;while(0);J=p+(C<<2)|0;b[J>>1]=U;b[J+2>>1]=U>>>16;J=C+1|0;do if((K|0)==(z|0)){z=K|0?K<<1:1;if((K|0)>=(z|0)){z=K;break}do if(!z)w=0;else{c[5637]=(c[5637]|0)+1;f=qG((z<<2|3)+16|0)|0;if(!f){w=0;break}c[(f+4+15&-16)+-4>>2]=f;w=f+4+15&-16}while(0);if((K|0)<=0){if(!l){l=w;break}}else{f=0;do{ha=w+(f<<2)|0;ga=l+(f<<2)|0;ga=e[ga>>1]|e[ga+2>>1]<<16;b[ha>>1]=ga;b[ha+2>>1]=ga>>>16;f=f+1|0}while((f|0)!=(K|0))}c[5638]=(c[5638]|0)+1;rG(c[l+-4>>2]|0);l=w}while(0);G=l+(K<<2)|0;b[G>>1]=(Q&65535)<<16|d&65535;b[G+2>>1]=((Q&65535)<<16|d&65535)>>>16;G=K+1|0;if((P|0)<(y|0)){do if((y|0)>(D|0)){if((y|0)>=(D|0)){do if((A|0)<(y|0)){do if(!y)h=0;else{c[5637]=(c[5637]|0)+1;h=qG((y<<2|3)+16|0)|0;if(!h){h=0;break}c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}while(0);if((D|0)<=0){if(!n){n=h;h=y;break}}else{f=0;do{c[h+(f<<2)>>2]=c[n+(f<<2)>>2];f=f+1|0}while((f|0)!=(D|0))}c[5638]=(c[5638]|0)+1;rG(c[n+-4>>2]|0);n=h;h=y}else h=A;while(0);ZG(n+(D<<2)|0,0,y-D<<2|0)|0;A=h}if((y|0)>(B|0)){do if((R|0)<(y|0)){do if(!y)f=0;else{c[5637]=(c[5637]|0)+1;h=qG((y<<2|3)+16|0)|0;if(!h){f=0;break}c[(h+4+15&-16)+-4>>2]=h;f=h+4+15&-16}while(0);if((B|0)<=0){if(!o){h=y;o=f;break}}else{h=0;do{c[f+(h<<2)>>2]=c[o+(h<<2)>>2];h=h+1|0}while((h|0)!=(B|0))}c[5638]=(c[5638]|0)+1;rG(c[o+-4>>2]|0);h=y;o=f}else h=R;while(0);ZG(o+(B<<2)|0,0,y-B<<2|0)|0;w=h}else w=R;if((y|0)>0){ha=y<<2;ZG(n|0,-1,ha|0)|0;ZG(o|0,-1,ha|0)|0}if((D|0)<=0){f=y;B=y;h=A;break}h=y+-1|0;f=0;do{ha=n+(((e[l+(f<<2)+2>>1]<<16)+(b[l+(f<<2)>>1]|0)&h)<<2)|0;c[o+(f<<2)>>2]=c[ha>>2];c[ha>>2]=f;f=f+1|0}while((f|0)!=(D|0));f=y;B=y;h=A}else{f=D;w=R;h=A}while(0);A=h;h=((Q&65535)<<16)+(d<<16>>16)&y+-1}else{f=D;w=R}D=n+(h<<2)|0;c[o+(C<<2)>>2]=c[D>>2];c[D>>2]=C;D=f;C=J}else{b[G+2>>1]=T;w=R;y=P;G=K}while(0);if((S|0)>=(V|0))break;f=c[X+36>>2]|0;R=w;P=y;K=G;h=S}h=c[X+28>>2]|0;f=G}else f=G;W=W+1|0;if((W|0)>=(h|0))break;else G=f}if((h|0)>0){A=c[X+36>>2]|0;B=c[X+16>>2]|0;q=0.0;C=0;do{w=c[A+(C*36|0)+4>>2]|0;y=c[A+(C*36|0)+12>>2]|0;z=c[y>>2]|0;if((w+-2|0)>=1){r=+g[X+64>>2];s=+g[X+68>>2];t=+g[X+72>>2];f=1;do{ga=c[y+(f<<2)>>2]|0;f=f+1|0;ha=c[y+(((f|0)%(w|0)|0)<<2)>>2]|0;u=+g[B+(z<<4)>>2];v=+g[B+(ga<<4)>>2];E=+g[B+(z<<4)+4>>2];F=+g[B+(ga<<4)+4>>2];I=+g[B+(z<<4)+8>>2];L=+g[B+(ga<<4)+8>>2];x=+g[B+(ha<<4)>>2];H=+g[B+(ha<<4)+4>>2];M=+g[B+(ha<<4)+8>>2];fa=+O(+(((u-v)*(E-H)-(E-F)*(u-x))*((u-v)*(E-H)-(E-F)*(u-x))+(((E-F)*(I-M)-(I-L)*(E-H))*((E-F)*(I-M)-(I-L)*(E-H))+((I-L)*(u-x)-(u-v)*(I-M))*((I-L)*(u-x)-(u-v)*(I-M)))))*.5;r=r+(u+v+x)*.3333333432674408*fa;g[X+64>>2]=r;s=(E+F+H)*.3333333432674408*fa+s;g[X+68>>2]=s;t=fa*((I+L+M)*.3333333432674408)+t;g[X+72>>2]=t;q=q+fa}while((f|0)!=(w+-1|0))}C=C+1|0}while((C|0)!=(h|0));f=X+64|0;w=1;z=l;y=n}else $=332}else{l=0;n=0;o=0;p=0;$=332}if(($|0)==332){f=X+64|0;w=0;q=0.0;z=l;y=n}t=1.0/q;u=t*+g[f>>2];g[f>>2]=u;s=t*+g[X+68>>2];g[X+68>>2]=s;t=t*+g[X+72>>2];g[X+72>>2]=t;g[X+96>>2]=3402823466385288598117041.0e14;if(w){l=c[X+36>>2]|0;r=3402823466385288598117041.0e14;n=0;while(1){q=+N(+(+g[l+(n*36|0)+32>>2]+(+g[l+(n*36|0)+20>>2]*u+ +g[l+(n*36|0)+24>>2]*s+ +g[l+(n*36|0)+28>>2]*t)));if(q<r)g[X+96>>2]=q;else q=r;n=n+1|0;if((n|0)>=(h|0))break;else r=q}}else q=3402823466385288598117041.0e14;h=c[X+8>>2]|0;if((h|0)>0){l=c[X+16>>2]|0;x=-3402823466385288598117041.0e14;v=-3402823466385288598117041.0e14;u=-3402823466385288598117041.0e14;t=3402823466385288598117041.0e14;s=3402823466385288598117041.0e14;r=3402823466385288598117041.0e14;n=0;do{fa=+g[l+(n<<4)>>2];t=fa<t?fa:t;x=fa>x?fa:x;fa=+g[l+(n<<4)+4>>2];s=fa<s?fa:s;v=fa>v?fa:v;fa=+g[l+(n<<4)+8>>2];r=fa<r?fa:r;u=fa>u?fa:u;n=n+1|0}while((n|0)!=(h|0))}else{x=-3402823466385288598117041.0e14;v=-3402823466385288598117041.0e14;u=-3402823466385288598117041.0e14;t=3402823466385288598117041.0e14;s=3402823466385288598117041.0e14;r=3402823466385288598117041.0e14}g[X+100>>2]=x+t;g[X+104>>2]=s+v;g[X+108>>2]=r+u;g[X+112>>2]=0.0;fa=x-t;M=v-s;r=u-r;g[X+116>>2]=fa;g[X+120>>2]=M;g[X+124>>2]=r;g[X+128>>2]=0.0;s=q/1.7320507764816284;f=fa<M?(M<r?2:1):fa<r?2:0;q=(+g[X+116+(f<<2)>>2]*.5-s)*.0009765625;g[X+88>>2]=s;g[X+84>>2]=s;g[X+80>>2]=s;r=+g[X+116+(f<<2)>>2]*.5;g[X+80+(f<<2)>>2]=r;h=0;while(1){if(bl(X)|0){$=440;break}r=r-q;g[X+80+(f<<2)>>2]=r;h=h+1|0;if((h|0)>=1024){$=439;break}}n:do if(($|0)==439){g[X+88>>2]=s;g[X+84>>2]=s;g[X+80>>2]=s}else if(($|0)==440){q=(+g[X+96>>2]-s)*.0009765625;l=c[X+80+((1<<(1<<f&3)&3)<<2)>>2]|0;n=0;while(1){h=c[X+80+((1<<f&3)<<2)>>2]|0;g[X+80+((1<<f&3)<<2)>>2]=q+(c[k>>2]=h,+g[k>>2]);r=q+ +g[X+80+((1<<(1<<f&3)&3)<<2)>>2];g[X+80+((1<<(1<<f&3)&3)<<2)>>2]=r;n=n+1|0;if(!(bl(X)|0))break;if((n|0)>=1024)break n;else l=(g[k>>2]=r,c[k>>2]|0)}c[X+80+((1<<f&3)<<2)>>2]=h;c[X+80+((1<<(1<<f&3)&3)<<2)>>2]=l}while(0);if(z|0){c[5638]=(c[5638]|0)+1;rG(c[z+-4>>2]|0)}if(p|0){c[5638]=(c[5638]|0)+1;rG(c[p+-4>>2]|0)}if(o|0){c[5638]=(c[5638]|0)+1;rG(c[o+-4>>2]|0)}if(y|0){c[5638]=(c[5638]|0)+1;rG(c[y+-4>>2]|0)}if(m|0){c[5638]=(c[5638]|0)+1;rG(c[m+-4>>2]|0)}p=c[Y>>2]|0;f=c[Z>>2]|0;if((p|0)<=0){if(f|0)$=461}else{o=0;do{l=f+(o*36|0)+4|0;m=f+(o*36|0)+12|0;n=c[m>>2]|0;h=f+(o*36|0)+16|0;if(n|0){if(a[h>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[n+-4>>2]|0)}c[m>>2]=0}a[h>>0]=1;c[m>>2]=0;c[l>>2]=0;c[f+(o*36|0)+8>>2]=0;o=o+1|0}while((o|0)!=(p|0));$=461}if(($|0)==461){if(a[ea+96+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[Z>>2]=0}if(j|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0)}h=c[aa>>2]|0;if(h|0){if(a[ea+136+56>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0)}c[aa>>2]=0}a[ea+136+56>>0]=1;c[aa>>2]=0;c[ea+136+44>>2]=0;c[ea+136+48>>2]=0;h=c[ba>>2]|0;if(h|0){if(a[ea+136+36>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0)}c[ba>>2]=0}a[ea+136+36>>0]=1;c[ba>>2]=0;c[ea+136+24>>2]=0;c[ea+136+28>>2]=0;h=c[ca>>2]|0;if(h|0){if(a[ea+136+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[h+-4>>2]|0)}c[ca>>2]=0}if(!da){i=ea;return 1}c[5638]=(c[5638]|0)+1;rG(c[da+-4>>2]|0);i=ea;return 1}function im(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;if((c[b+8>>2]|0)>=(d|0))return;if((d|0)!=0?(c[5637]=(c[5637]|0)+1,e=qG((d*36|3)+16|0)|0,(e|0)!=0):0){c[(e+4+15&-16)+-4>>2]=e;o=e+4+15&-16}else o=0;i=c[b+4>>2]|0;if((i|0)>0){m=0;do{j=o+(m*36|0)|0;k=c[b+12>>2]|0;a[j+16>>0]=1;c[j+12>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;l=c[k+(m*36|0)+4>>2]|0;if((l|0)>0){c[5637]=(c[5637]|0)+1;e=qG((l<<2|3)+16|0)|0;if(!e)h=0;else{c[(e+4+15&-16)+-4>>2]=e;h=e+4+15&-16}g=c[j+4>>2]|0;f=c[j+12>>2]|0;if((g|0)<=0)if(!f){a[j+16>>0]=1;c[j+12>>2]=h;c[j+8>>2]=l;ZG(h|0,0,l<<2|0)|0}else n=14;else{e=0;do{c[h+(e<<2)>>2]=c[f+(e<<2)>>2];e=e+1|0}while((e|0)!=(g|0));n=14}if((n|0)==14){n=0;if(a[j+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}a[j+16>>0]=1;c[j+12>>2]=h;c[j+8>>2]=l;ZG(h|0,0,l<<2|0)|0}e=c[j+12>>2]|0;c[j+4>>2]=l;f=c[k+(m*36|0)+12>>2]|0;g=0;do{c[e+(g<<2)>>2]=c[f+(g<<2)>>2];g=g+1|0}while((g|0)!=(l|0))}else c[j+4>>2]=l;l=k+(m*36|0)+20|0;c[j+20>>2]=c[l>>2];c[j+20+4>>2]=c[l+4>>2];c[j+20+8>>2]=c[l+8>>2];c[j+20+12>>2]=c[l+12>>2];m=m+1|0}while((m|0)!=(i|0));e=c[b+4>>2]|0;if((e|0)>0){k=0;do{g=c[b+12>>2]|0;h=g+(k*36|0)+4|0;i=g+(k*36|0)+12|0;j=c[i>>2]|0;f=g+(k*36|0)+16|0;if(j|0){if(a[f>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0)}c[i>>2]=0}a[f>>0]=1;c[i>>2]=0;c[h>>2]=0;c[g+(k*36|0)+8>>2]=0;k=k+1|0}while((k|0)!=(e|0))}}e=c[b+12>>2]|0;if(e|0){if(a[b+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=o;c[b+8>>2]=d;return}function jm(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0,x=0;w=i;i=i+32|0;s=c[a+12>>2]|0;t=+g[s+(((e+d|0)/2|0)*24|0)>>2];u=+g[s+(((e+d|0)/2|0)*24|0)+4>>2];v=+g[s+(((e+d|0)/2|0)*24|0)+8>>2];q=+g[s+(((e+d|0)/2|0)*24|0)+16>>2];r=c[s+(((e+d|0)/2|0)*24|0)+20>>2]|0;f=d;h=e;while(1){m=+g[b>>2];n=+g[b+4>>2];o=+g[b+8>>2];p=(t-m)*(t-m)+(u-n)*(u-n)+(v-o)*(v-o);a:while(1){j=+g[s+(f*24|0)+16>>2];do if(j!=q){if(!(j<q))break a}else{j=+g[s+(f*24|0)>>2]-m;k=+g[s+(f*24|0)+4>>2]-n;l=+g[s+(f*24|0)+8>>2]-o;if(j*j+k*k+l*l!=p)if(j*j+k*k+l*l<p)break;else break a;else if((c[s+(f*24|0)+20>>2]|0)<(r|0))break;else break a}while(0);f=f+1|0}b:while(1){j=+g[s+(h*24|0)+16>>2];do if(q!=j){if(!(q<j))break b}else{j=+g[s+(h*24|0)>>2]-m;k=+g[s+(h*24|0)+4>>2]-n;l=+g[s+(h*24|0)+8>>2]-o;if(p!=j*j+k*k+l*l)if(p<j*j+k*k+l*l)break;else break b;else if((r|0)<(c[s+(h*24|0)+20>>2]|0))break;else break b}while(0);h=h+-1|0}if((f|0)<=(h|0)){x=s+(f*24|0)|0;c[w>>2]=c[x>>2];c[w+4>>2]=c[x+4>>2];c[w+8>>2]=c[x+8>>2];c[w+12>>2]=c[x+12>>2];c[w+16>>2]=c[x+16>>2];c[w+20>>2]=c[x+20>>2];s=s+(h*24|0)|0;c[x>>2]=c[s>>2];c[x+4>>2]=c[s+4>>2];c[x+8>>2]=c[s+8>>2];c[x+12>>2]=c[s+12>>2];c[x+16>>2]=c[s+16>>2];c[x+20>>2]=c[s+20>>2];s=(c[a+12>>2]|0)+(h*24|0)|0;c[s>>2]=c[w>>2];c[s+4>>2]=c[w+4>>2];c[s+8>>2]=c[w+8>>2];c[s+12>>2]=c[w+12>>2];c[s+16>>2]=c[w+16>>2];c[s+20>>2]=c[w+20>>2];f=f+1|0;h=h+-1|0}if((f|0)>(h|0))break;s=c[a+12>>2]|0}if((h|0)>(d|0))jm(a,b,d,h);if((f|0)>=(e|0)){i=w;return}jm(a,b,f,e);i=w;return}function km(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=c[b+4>>2]|0;if((e|0)==(c[b+8>>2]|0)){im(b,e|0?e<<1:1);e=c[b+4>>2]|0}j=(c[b+12>>2]|0)+(e*36|0)|0;a[j+16>>0]=1;c[j+12>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;k=c[d+4>>2]|0;if((k|0)<=0){c[j+4>>2]=k;k=j+20|0;d=d+20|0;c[k>>2]=c[d>>2];c[k+4>>2]=c[d+4>>2];c[k+8>>2]=c[d+8>>2];c[k+12>>2]=c[d+12>>2];d=c[b+4>>2]|0;d=d+1|0;c[b+4>>2]=d;return}c[5637]=(c[5637]|0)+1;e=qG((k<<2|3)+16|0)|0;if(!e)h=0;else{c[(e+4+15&-16)+-4>>2]=e;h=e+4+15&-16}g=c[j+4>>2]|0;f=c[j+12>>2]|0;if((g|0)<=0)if(!f){a[j+16>>0]=1;c[j+12>>2]=h;c[j+8>>2]=k;ZG(h|0,0,k<<2|0)|0}else i=11;else{e=0;do{c[h+(e<<2)>>2]=c[f+(e<<2)>>2];e=e+1|0}while((e|0)!=(g|0));i=11}if((i|0)==11){if(a[j+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}a[j+16>>0]=1;c[j+12>>2]=h;c[j+8>>2]=k;ZG(h|0,0,k<<2|0)|0}e=c[j+12>>2]|0;c[j+4>>2]=k;f=c[d+12>>2]|0;g=0;do{c[e+(g<<2)>>2]=c[f+(g<<2)>>2];g=g+1|0}while((g|0)!=(k|0));k=j+20|0;d=d+20|0;c[k>>2]=c[d>>2];c[k+4>>2]=c[d+4>>2];c[k+8>>2]=c[d+8>>2];c[k+12>>2]=c[d+12>>2];d=c[b+4>>2]|0;d=d+1|0;c[b+4>>2]=d;return}function lm(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0;o=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);u=+g[a+76>>2];t=+g[a+60>>2];r=+g[a+80>>2];q=+g[a+64>>2];n=+g[a+84>>2];m=+g[a+68>>2];E=+g[b>>2];y=+N(+E);D=+g[b+4>>2];x=+N(+D);k=+g[b+8>>2];l=+N(+k);C=+g[b+16>>2];w=+N(+C);B=+g[b+20>>2];v=+N(+B);i=+g[b+24>>2];j=+N(+i);A=+g[b+32>>2];s=+N(+A);z=+g[b+36>>2];p=+N(+z);f=+g[b+40>>2];h=+N(+f);k=(u+t)*.5*E+(r+q)*.5*D+(n+m)*.5*k+ +g[b+48>>2];i=(u+t)*.5*C+(r+q)*.5*B+(n+m)*.5*i+ +g[b+52>>2];f=(u+t)*.5*A+(r+q)*.5*z+(n+m)*.5*f+ +g[b+56>>2];l=(o+(u-t)*.5)*y+(o+(r-q)*.5)*x+(o+(n-m)*.5)*l;j=(o+(u-t)*.5)*w+(o+(r-q)*.5)*v+(o+(n-m)*.5)*j;h=(o+(u-t)*.5)*s+(o+(r-q)*.5)*p+(o+(n-m)*.5)*h;g[d>>2]=k-l;g[d+4>>2]=i-j;g[d+8>>2]=f-h;g[d+12>>2]=0.0;g[e>>2]=l+k;g[e+4>>2]=j+i;g[e+8>>2]=h+f;g[e+12>>2]=0.0;return}function mm(b){b=b|0;var d=0,e=0,f=0,h=0.0;e=i;i=i+96|0;a[b+92>>0]=1;if(!(a[19840]|0)){a[19840]=1;c[4993]=1065353216;c[4994]=0;c[4995]=0;c[4996]=0;c[4997]=0;c[4998]=1065353216;c[4999]=0;c[5e3]=0;c[5001]=0;c[5002]=0;c[5003]=1065353216;g[5004]=0.0;c[5005]=-1082130432;c[5006]=0;c[5007]=0;c[5008]=0;c[5009]=0;c[5010]=-1082130432;c[5011]=0;c[5012]=0;c[5013]=0;c[5014]=0;c[5015]=-1082130432;g[5016]=0.0}d=e;f=d+96|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(f|0));bc[c[(c[b>>2]|0)+76>>2]&127](b,19972,e,6);h=+g[b+48>>2];g[b+76>>2]=+g[e>>2]+h;g[b+60>>2]=+g[e+48>>2]-h;g[b+80>>2]=+g[e+20>>2]+h;g[b+64>>2]=+g[e+68>>2]-h;g[b+84>>2]=+g[e+40>>2]+h;g[b+68>>2]=+g[e+88>>2]-h;i=e;return}function nm(a){a=a|0;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function om(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;i=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);k=+g[b+52>>2]-h;j=+g[b+56>>2]-f;g[d>>2]=+g[b+48>>2]-i;g[d+4>>2]=k;g[d+8>>2]=j;g[d+12>>2]=0.0;h=h+ +g[b+52>>2];f=f+ +g[b+56>>2];g[e>>2]=i+ +g[b+48>>2];g[e+4>>2]=h;g[e+8>>2]=f;g[e+12>>2]=0.0;return}function pm(a,b,d){a=a|0;b=+b;d=d|0;b=b*.4000000059604645*+Hb[c[(c[a>>2]|0)+48>>2]&15](a);b=b*+Hb[c[(c[a>>2]|0)+48>>2]&15](a);g[d>>2]=b;g[d+4>>2]=b;g[d+8>>2]=b;g[d+12>>2]=0.0;return}function qm(a){a=a|0;return 13962}function rm(a,b){a=a|0;b=+b;g[a+48>>2]=b;return}function sm(a){a=a|0;return +(+g[a+32>>2]*+g[a+16>>2])}function tm(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;i=i+16|0;Zb[c[(c[b>>2]|0)+68>>2]&127](e,b,d);c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];j=+g[d>>2];h=+g[d+4>>2];f=+g[d+8>>2];l=j*j+h*h+f*f<1.4210854715202004e-14?-1.0:j;k=j*j+h*h+f*f<1.4210854715202004e-14?-1.0:h;f=j*j+h*h+f*f<1.4210854715202004e-14?-1.0:f;h=1.0/+O(+(f*f+(l*l+k*k)));j=+Hb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=+g[a>>2]+j*(h*l);g[a+4>>2]=j*(h*k)+ +g[a+4>>2];g[a+8>>2]=j*(h*f)+ +g[a+8>>2];i=e;return}function um(a,b,d){a=a|0;b=b|0;d=d|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;return}function vm(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;if((e|0)>0)a=0;else return;do{b=d+(a<<4)|0;a=a+1|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0}while((a|0)!=(e|0));return}function wm(a){a=a|0;return}function xm(a){a=a|0;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function ym(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[d>>2]=-581039253;c[d+4>>2]=-581039253;c[d+8>>2]=-581039253;g[d+12>>2]=0.0;c[e>>2]=1566444395;c[e+4>>2]=1566444395;c[e+8>>2]=1566444395;g[e+12>>2]=0.0;return}function zm(a,b){a=a|0;b=b|0;c[a+72>>2]=c[b>>2];c[a+72+4>>2]=c[b+4>>2];c[a+72+8>>2]=c[b+8>>2];c[a+72+12>>2]=c[b+12>>2];return}function Am(a){a=a|0;return a+72|0}function Bm(a,b,d){a=a|0;b=+b;d=d|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;return}function Cm(a){a=a|0;return 13990}function Dm(a){a=a|0;return 52}function Em(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=Ob[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=Ob[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=f;if(f|0)tb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];c[b+12>>2]=c[a+72>>2];c[b+16>>2]=c[a+76>>2];c[b+20>>2]=c[a+80>>2];c[b+24>>2]=c[a+84>>2];c[b+28>>2]=c[a+52>>2];c[b+32>>2]=c[a+56>>2];c[b+36>>2]=c[a+60>>2];c[b+40>>2]=c[a+64>>2];c[b+44>>2]=c[a+68>>2];return 14002}function Fm(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0.0;x=i;i=i+48|0;t=+g[e>>2];u=+g[d>>2];v=+g[e+4>>2];w=+g[d+4>>2];s=+g[e+8>>2];h=+g[d+8>>2];j=+O(+((t-u)*.5*((t-u)*.5)+(v-w)*.5*((v-w)*.5)+(s-h)*.5*((s-h)*.5)));k=+g[a+60>>2];d=+N(+k)>.7071067690849304;l=+g[a+56>>2];if(d){r=1.0/+O(+(k*k+l*l));y=+g[a+52>>2];f=y*-(k*r);m=y;n=0.0;o=-(k*r);p=l*r;q=(k*k+l*l)*r;r=-(y*(l*r))}else{q=+g[a+52>>2];r=1.0/+O(+(q*q+l*l));f=(q*q+l*l)*r;m=q;n=-(l*r);o=q*r;p=0.0;q=-(k*(q*r));r=k*-(l*r)}y=(t+u)*.5*m+(v+w)*.5*l+(s+h)*.5*k-+g[a+68>>2];m=(t+u)*.5-m*y;n=j*n;o=j*o;u=j*p;q=j*q;r=j*r;t=j*f;g[x>>2]=q+(n+m);g[x+4>>2]=r+(o+((v+w)*.5-l*y));g[x+8>>2]=t+(u+((s+h)*.5-k*y));g[x+12>>2]=0.0;g[x+16>>2]=n+m-q;g[x+20>>2]=o+((v+w)*.5-l*y)-r;g[x+24>>2]=u+((s+h)*.5-k*y)-t;g[x+28>>2]=0.0;g[x+32>>2]=m-n-q;g[x+36>>2]=(v+w)*.5-l*y-o-r;g[x+40>>2]=(s+h)*.5-k*y-u-t;g[x+44>>2]=0.0;bc[c[(c[b>>2]|0)+8>>2]&127](b,x,0,0);g[x>>2]=m-n-q;g[x+4>>2]=(v+w)*.5-l*y-o-r;g[x+8>>2]=(s+h)*.5-k*y-u-t;g[x+12>>2]=0.0;g[x+16>>2]=q+(m-n);g[x+20>>2]=r+((v+w)*.5-l*y-o);g[x+24>>2]=t+((s+h)*.5-k*y-u);g[x+28>>2]=0.0;g[x+32>>2]=q+(n+m);g[x+36>>2]=r+(o+((v+w)*.5-l*y));g[x+40>>2]=t+(u+((s+h)*.5-k*y));g[x+44>>2]=0.0;bc[c[(c[b>>2]|0)+8>>2]&127](b,x,0,1);i=x;return}
function fo(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;u=a[h+16>>0]&-16;a[h+16>>0]=u;w=+g[e>>2];x=+g[d>>2];y=+g[e+4>>2];z=+g[d+4>>2];q=+g[e+8>>2];r=+g[d+8>>2];s=+g[f>>2];t=+g[f+4>>2];v=+g[f+8>>2];m=+g[b>>2];n=+g[b+4>>2];i=+g[b+8>>2];o=(w-x)*(m-x)+(y-z)*(n-z)+(q-r)*(i-r);p=(s-x)*(m-x)+(t-z)*(n-z)+(v-r)*(i-r);if(o<=0.0&p<=0.0){c[h>>2]=c[d>>2];c[h+4>>2]=c[d+4>>2];c[h+8>>2]=c[d+8>>2];c[h+12>>2]=c[d+12>>2];a[h+16>>0]=u|1;g[h+20>>2]=1.0;g[h+24>>2]=0.0;g[h+28>>2]=0.0;g[h+32>>2]=0.0;return}k=(w-x)*(m-w)+(y-z)*(n-y)+(q-r)*(i-q);l=(s-x)*(m-w)+(t-z)*(n-y)+(v-r)*(i-q);if(!(!(k>=0.0)|!(l<=k))){c[h>>2]=c[e>>2];c[h+4>>2]=c[e+4>>2];c[h+8>>2]=c[e+8>>2];c[h+12>>2]=c[e+12>>2];a[h+16>>0]=u|2;g[h+20>>2]=0.0;g[h+24>>2]=1.0;g[h+28>>2]=0.0;g[h+32>>2]=0.0;return}if(k<=0.0&(o>=0.0?o*l-k*p<=0.0:0)){g[h>>2]=x+(w-x)*(o/(o-k));g[h+4>>2]=z+(y-z)*(o/(o-k));g[h+8>>2]=r+(q-r)*(o/(o-k));g[h+12>>2]=0.0;a[h+16>>0]=u|3;g[h+20>>2]=1.0-o/(o-k);g[h+24>>2]=o/(o-k);g[h+28>>2]=0.0;g[h+32>>2]=0.0;return}j=(w-x)*(m-s)+(y-z)*(n-t)+(q-r)*(i-v);i=(s-x)*(m-s)+(t-z)*(n-t)+(v-r)*(i-v);if(!(!(i>=0.0)|!(j<=i))){c[h>>2]=c[f>>2];c[h+4>>2]=c[f+4>>2];c[h+8>>2]=c[f+8>>2];c[h+12>>2]=c[f+12>>2];a[h+16>>0]=u|4;g[h+20>>2]=0.0;g[h+24>>2]=0.0;g[h+28>>2]=1.0;g[h+32>>2]=0.0;return}if(i<=0.0&(p>=0.0?j*p-o*i<=0.0:0)){g[h>>2]=x+(s-x)*(p/(p-i));g[h+4>>2]=z+(t-z)*(p/(p-i));g[h+8>>2]=r+(v-r)*(p/(p-i));g[h+12>>2]=0.0;a[h+16>>0]=u|5;g[h+20>>2]=1.0-p/(p-i);g[h+24>>2]=0.0;g[h+28>>2]=p/(p-i);g[h+32>>2]=0.0;return}if((k*i-j*l<=0.0?l-k>=0.0:0)?j-i>=0.0:0){z=(l-k)/(l-k+(j-i));g[h>>2]=w+(s-w)*z;g[h+4>>2]=y+(t-y)*z;g[h+8>>2]=q+(v-q)*z;g[h+12>>2]=0.0;a[h+16>>0]=u|6;g[h+20>>2]=0.0;g[h+24>>2]=1.0-z;g[h+28>>2]=z;g[h+32>>2]=0.0;return}m=1.0/(o*l-k*p+(k*i-j*l+(j*p-o*i)));n=(j*p-o*i)*m;p=(o*l-k*p)*m;g[h>>2]=(s-x)*p+((w-x)*n+x);g[h+4>>2]=(t-z)*p+((y-z)*n+z);g[h+8>>2]=(v-r)*p+((q-r)*n+r);g[h+12>>2]=0.0;a[h+16>>0]=u|7;g[h+20>>2]=1.0-n-p;g[h+24>>2]=n;g[h+28>>2]=p;g[h+32>>2]=0.0;return}function go(b){b=b|0;var d=0;c[b>>2]=7044;d=c[b+140>>2]|0;if(d|0){if(a[b+144>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+140>>2]=0}a[b+144>>0]=1;c[b+140>>2]=0;c[b+132>>2]=0;c[b+136>>2]=0;return}function ho(b){b=b|0;var d=0;c[b>>2]=7044;d=c[b+140>>2]|0;if(d|0){if(a[b+144>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+140>>2]=0}a[b+144>>0]=1;c[b+140>>2]=0;c[b+132>>2]=0;c[b+136>>2]=0;c[5638]=(c[5638]|0)+1;rG(c[b+-4>>2]|0);return}function io(a,b,d){a=a|0;b=b|0;d=+d;tb[c[(c[a>>2]|0)+32>>2]&127](a,b);$b[c[(c[a>>2]|0)+36>>2]&7](a,b,d);return}function jo(a,b){a=a|0;b=b|0;return}function ko(b,d){b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;a[b+171>>0]=1;c[b+60>>2]=c[d>>2];c[b+60+4>>2]=c[d+4>>2];c[b+60+8>>2]=c[d+8>>2];c[b+60+12>>2]=c[d+12>>2];e=+g[b+60>>2];f=+g[b+64>>2];i=+g[b+68>>2];h=+O(+(e*e+f*f+i*i));if(h>1.1920928955078125e-07){j=e*(1.0/h);f=f*(1.0/h);e=i*(1.0/h);d=c[b+72>>2]|0}else{j=0.0;f=0.0;e=0.0;d=0}g[b+76>>2]=j;g[b+80>>2]=f;g[b+84>>2]=e;c[b+88>>2]=d;return}function lo(b,d,e){b=b|0;d=d|0;e=+e;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;a[b+171>>0]=0;c[b+60>>2]=c[d>>2];c[b+60+4>>2]=c[d+4>>2];c[b+60+8>>2]=c[d+8>>2];c[b+60+12>>2]=c[d+12>>2];f=+g[b+60>>2];h=+g[b+64>>2];j=+g[b+68>>2];i=+O(+(f*f+h*h+j*j));if(i>1.1920928955078125e-07){k=f*(1.0/i);h=h*(1.0/i);f=j*(1.0/i);d=c[b+72>>2]|0}else{k=0.0;h=0.0;f=0.0;d=0}g[b+76>>2]=k;g[b+80>>2]=h;g[b+84>>2]=f;c[b+88>>2]=d;g[b+172>>2]=+g[b+172>>2]+e;return}function mo(b,d){b=b|0;d=d|0;var e=0,f=0,h=0;g[b+16>>2]=0.0;g[b+20>>2]=0.0;a[b+168>>0]=0;a[b+169>>0]=0;g[b+172>>2]=0.0;c[b+60>>2]=0;c[b+60+4>>2]=0;c[b+60+8>>2]=0;c[b+60+12>>2]=0;b=c[(c[b+8>>2]|0)+308>>2]|0;if((c[(vb[c[(c[b>>2]|0)+28>>2]&127](b)|0)+4>>2]|0)<=0)return;do{f=c[b>>2]|0;h=c[f+12>>2]|0;f=c[c[(vb[c[f+28>>2]&127](b)|0)+12>>2]>>2]|0;e=c[(c[(vb[c[(c[b>>2]|0)+28>>2]&127](b)|0)+12>>2]|0)+4>>2]|0;zb[h&31](b,f,e,c[d+24>>2]|0)|0}while((c[(vb[c[(c[b>>2]|0)+28>>2]&127](b)|0)+4>>2]|0)>0);return}function no(a,b){a=a|0;b=b|0;var d=0;d=i;i=i+16|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];a=c[a+8>>2]|0;c[a+284>>2]=(c[a+284>>2]|0)+1;c[a+4>>2]=1065353216;c[a+8>>2]=0;c[a+8+4>>2]=0;c[a+8+8>>2]=0;c[a+8+12>>2]=0;c[a+24>>2]=1065353216;c[a+28>>2]=0;c[a+28+4>>2]=0;c[a+28+8>>2]=0;c[a+28+12>>2]=0;c[a+44>>2]=1065353216;c[a+48>>2]=0;c[a+52>>2]=c[d>>2];c[a+52+4>>2]=c[d+4>>2];c[a+52+8>>2]=c[d+8>>2];c[a+52+12>>2]=c[d+12>>2];i=d;return}function oo(b,d){b=b|0;d=d|0;a[b+148>>0]=0;if((((po(b,d)|0?(a[b+148>>0]=1,po(b,d)|0):0)?(a[b+148>>0]=1,po(b,d)|0):0)?(a[b+148>>0]=1,po(b,d)|0):0)?(a[b+148>>0]=1,po(b,d)|0):0)a[b+148>>0]=1;d=(c[b+8>>2]|0)+52|0;c[b+92>>2]=c[d>>2];c[b+92+4>>2]=c[d+4>>2];c[b+92+8>>2]=c[d+8>>2];c[b+92+12>>2]=c[d+12>>2];cH(b+112|0,d|0,16)|0;return}function po(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0,k=0.0,l=0,m=0,n=0.0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0.0,w=0.0;u=i;i=i+96|0;s=c[b+12>>2]|0;bc[c[(c[s>>2]|0)+8>>2]&127](s,(c[b+8>>2]|0)+4|0,u+80|0,u+64|0);s=c[d+68>>2]|0;pb[c[(c[s>>2]|0)+16>>2]&31](s,c[(c[b+8>>2]|0)+188>>2]|0,u+80|0,u+64|0,c[d+24>>2]|0);s=c[d+24>>2]|0;bc[c[(c[s>>2]|0)+32>>2]&127](s,c[(c[b+8>>2]|0)+308>>2]|0,d+28|0,s);s=c[b+8>>2]|0;c[b+92>>2]=c[s+52>>2];c[b+92+4>>2]=c[s+52+4>>2];c[b+92+8>>2]=c[s+52+8>>2];c[b+92+12>>2]=c[s+52+12>>2];s=c[s+308>>2]|0;if((vb[c[(c[s>>2]|0)+36>>2]&127](s)|0)>0){s=0;h=0.0;d=0;do{e=c[b+132>>2]|0;if((e|0)<0){if((c[b+136>>2]|0)<0){f=c[b+140>>2]|0;if(f|0){if(a[b+144>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[b+140>>2]=0}a[b+144>>0]=1;c[b+140>>2]=0;c[b+136>>2]=0}do{c[(c[b+140>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=0)}c[b+132>>2]=0;e=c[(c[b+8>>2]|0)+308>>2]|0;e=c[(vb[c[(c[e>>2]|0)+28>>2]&127](e)|0)+12>>2]|0;r=c[c[e+(s<<4)>>2]>>2]|0;f=c[c[e+(s<<4)+4>>2]>>2]|0;if(!((r|0)!=0?(c[r+204>>2]&4|0)!=0:0))t=14;do if((t|0)==14){t=0;if(f|0?c[f+204>>2]&4|0:0)break;e=c[e+(s<<4)+8>>2]|0;if(e|0)tb[c[(c[e>>2]|0)+16>>2]&127](e,b+128|0);q=c[b+132>>2]|0;if((q|0)>0){o=c[b+140>>2]|0;p=c[b+8>>2]|0;r=0;do{m=c[o+(r<<2)>>2]|0;n=(c[m+740>>2]|0)==(p|0)?-1.0:1.0;e=c[m+748>>2]|0;if((e|0)>0){l=0;do{k=+g[m+4+(l*184|0)+80>>2];if(k<0.0){j=m+4+(l*184|0)+64|0;if(k<h){d=m+4+(l*184|0)+68|0;v=n*+g[d>>2];f=m+4+(l*184|0)+72|0;h=n*+g[f>>2];g[b+152>>2]=n*+g[j>>2];g[b+156>>2]=v;g[b+160>>2]=h;g[b+164>>2]=0.0;e=c[m+748>>2]|0;h=k}else{d=m+4+(l*184|0)+68|0;f=m+4+(l*184|0)+72|0}w=k*(n*+g[d>>2])*.20000000298023224;v=k*(n*+g[f>>2])*.20000000298023224;g[b+92>>2]=k*(n*+g[j>>2])*.20000000298023224+ +g[b+92>>2];g[b+96>>2]=w+ +g[b+96>>2];g[b+100>>2]=v+ +g[b+100>>2];d=1}l=l+1|0}while((l|0)<(e|0))}r=r+1|0}while((r|0)!=(q|0))}}while(0);s=s+1|0;r=c[(c[b+8>>2]|0)+308>>2]|0}while((s|0)<(vb[c[(c[r>>2]|0)+36>>2]&127](r)|0))}else d=0;t=c[b+8>>2]|0;c[u>>2]=c[t+4>>2];c[u+4>>2]=c[t+4+4>>2];c[u+8>>2]=c[t+4+8>>2];c[u+12>>2]=c[t+4+12>>2];c[u+16>>2]=c[t+20>>2];c[u+16+4>>2]=c[t+20+4>>2];c[u+16+8>>2]=c[t+20+8>>2];c[u+16+12>>2]=c[t+20+12>>2];c[u+32>>2]=c[t+36>>2];c[u+32+4>>2]=c[t+36+4>>2];c[u+32+8>>2]=c[t+36+8>>2];c[u+32+12>>2]=c[t+36+12>>2];c[u+48>>2]=c[b+92>>2];c[u+48+4>>2]=c[b+92+4>>2];c[u+48+8>>2]=c[b+92+8>>2];c[u+48+12>>2]=c[b+92+12>>2];c[t+284>>2]=(c[t+284>>2]|0)+1;c[t+4>>2]=c[u>>2];c[t+4+4>>2]=c[u+4>>2];c[t+4+8>>2]=c[u+8>>2];c[t+4+12>>2]=c[u+12>>2];c[t+20>>2]=c[u+16>>2];c[t+20+4>>2]=c[u+16+4>>2];c[t+20+8>>2]=c[u+16+8>>2];c[t+20+12>>2]=c[u+16+12>>2];c[t+36>>2]=c[u+32>>2];c[t+36+4>>2]=c[u+32+4>>2];c[t+36+8>>2]=c[u+32+8>>2];c[t+36+12>>2]=c[u+32+12>>2];c[t+52>>2]=c[u+48>>2];c[t+52+4>>2]=c[u+48+4>>2];c[t+52+8>>2]=c[u+48+8>>2];c[t+52+12>>2]=c[u+48+12>>2];i=u;return d|0}function qo(d,e,f){d=d|0;e=e|0;f=+f;var h=0,j=0.0,k=0.0,l=0,m=0.0,n=0,o=0.0,p=0,q=0.0,r=0.0,s=0.0,t=0,u=0;t=i;i=i+528|0;if(!(a[d+171>>0]|0)){if(+g[d+172>>2]<=0.0){i=t;return}j=+g[d+60>>2];q=+g[d+64>>2];r=+g[d+68>>2];if(j*j+q*q+r*r<1.4210854715202004e-14){i=t;return}}a[d+168>>0]=(vb[c[(c[d>>2]|0)+48>>2]&127](d)|0)&1;j=+g[d+16>>2]-+g[d+44>>2]*f;g[d+16>>2]=j;if(j>0.0?(k=+g[d+28>>2],j>k):0){g[d+16>>2]=k;j=k}if(j<0.0?(r=+N(+j),m=+N(+(+g[d+24>>2])),r>m):0){g[d+16>>2]=-m;j=-m}g[d+20>>2]=j*f;h=c[d+8>>2]|0;c[t>>2]=c[h+4>>2];c[t+4>>2]=c[h+4+4>>2];c[t+8>>2]=c[h+4+8>>2];c[t+12>>2]=c[h+4+12>>2];c[t+16>>2]=c[h+20>>2];c[t+16+4>>2]=c[h+20+4>>2];c[t+16+8>>2]=c[h+20+8>>2];c[t+16+12>>2]=c[h+20+12>>2];c[t+32>>2]=c[h+36>>2];c[t+32+4>>2]=c[h+36+4>>2];c[t+32+8>>2]=c[h+36+8>>2];c[t+32+12>>2]=c[h+36+12>>2];c[t+48>>2]=c[h+52>>2];c[t+48+4>>2]=c[h+52+4>>2];c[t+48+8>>2]=c[h+52+8>>2];c[t+48+12>>2]=c[h+52+12>>2];h=c[d+176>>2]|0;if(!(a[19872]|0)){a[19872]=1;c[5298]=1065353216;c[5299]=0;c[5300]=0;c[5301]=0;c[5302]=0;c[5303]=1065353216;c[5304]=0;c[5305]=0;c[5306]=0;c[5307]=0;c[5308]=1065353216;g[5309]=0.0}m=+g[d+20>>2];m=+g[d+52>>2]+(m>0.0?m:0.0);q=+g[21192+(h<<4)+4>>2]*m+ +g[d+96>>2];r=m*+g[21192+(h<<4)+8>>2]+ +g[d+100>>2];g[d+112>>2]=+g[d+92>>2]+ +g[21192+(h<<4)>>2]*m;g[d+116>>2]=q;g[d+120>>2]=r;g[d+124>>2]=0.0;c[t+456>>2]=1065353216;c[t+456+4>>2]=0;c[t+456+4+4>>2]=0;c[t+456+4+8>>2]=0;c[t+456+4+12>>2]=0;c[t+456+20>>2]=1065353216;c[t+456+24>>2]=0;c[t+456+24+4>>2]=0;c[t+456+24+8>>2]=0;c[t+456+24+12>>2]=0;c[t+456+40>>2]=1065353216;h=t+456+44|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;c[t+392>>2]=1065353216;c[t+392+4>>2]=0;c[t+392+4+4>>2]=0;c[t+392+4+8>>2]=0;c[t+392+4+12>>2]=0;c[t+392+20>>2]=1065353216;c[t+392+24>>2]=0;c[t+392+24+4>>2]=0;c[t+392+24+8>>2]=0;c[t+392+24+12>>2]=0;c[t+392+40>>2]=1065353216;h=t+392+44|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;h=c[d+176>>2]|0;if(!(a[19872]|0)){a[19872]=1;c[5298]=1065353216;c[5299]=0;c[5300]=0;c[5301]=0;c[5302]=0;c[5303]=1065353216;c[5304]=0;c[5305]=0;c[5306]=0;c[5307]=0;c[5308]=1065353216;g[5309]=0.0}l=c[d+12>>2]|0;m=+Hb[c[(c[l>>2]|0)+48>>2]&15](l);m=m+ +g[d+56>>2];q=m*+g[21192+(h<<4)+4>>2]+ +g[d+96>>2];r=m*+g[21192+(h<<4)+8>>2]+ +g[d+100>>2];g[t+456+48>>2]=+g[21192+(h<<4)>>2]*m+ +g[d+92>>2];g[t+456+52>>2]=q;g[t+456+56>>2]=r;g[t+456+60>>2]=0.0;c[t+392+48>>2]=c[d+112>>2];c[t+392+48+4>>2]=c[d+112+4>>2];c[t+392+48+8>>2]=c[d+112+8>>2];c[t+392+48+12>>2]=c[d+112+12>>2];h=c[d+8>>2]|0;l=c[d+176>>2]|0;if(!(a[19872]|0)){a[19872]=1;c[5298]=1065353216;c[5299]=0;c[5300]=0;c[5301]=0;c[5302]=0;c[5303]=1065353216;c[5304]=0;c[5305]=0;c[5306]=0;c[5307]=0;c[5308]=1065353216;g[5309]=0.0}m=-+g[21192+(l<<4)>>2];q=-+g[21192+(l<<4)+4>>2];r=-+g[21192+(l<<4)+8>>2];g[t+288+4>>2]=1.0;b[t+288+8>>1]=1;b[t+288+10>>1]=-1;p=t+288+12|0;c[t+288+76>>2]=0;c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;c[p+12>>2]=0;c[p+16>>2]=0;c[p+20>>2]=0;c[p+24>>2]=0;c[p+28>>2]=0;c[t+288>>2]=7108;c[t+288+80>>2]=h;g[t+288+84>>2]=m;g[t+288+88>>2]=q;g[t+288+92>>2]=r;g[t+288+96>>2]=0.0;g[t+288+100>>2]=.707099974155426;h=c[d+8>>2]|0;p=c[(c[h+188>>2]|0)+4>>2]|0;b[t+288+8>>1]=p;b[t+288+10>>1]=p>>>16;if(!(a[d+170>>0]|0))Yf(e,c[d+12>>2]|0,t+456|0,t+392|0,t+288|0,0.0);else pi(h,c[d+12>>2]|0,t+456|0,t+392|0,t+288|0,+g[e+56>>2]);if(+g[t+288+4>>2]<1.0){h=c[d+176>>2]|0;if(!(a[19872]|0)){a[19872]=1;c[5298]=1065353216;c[5299]=0;c[5300]=0;c[5301]=0;c[5302]=0;c[5303]=1065353216;c[5304]=0;c[5305]=0;c[5306]=0;c[5307]=0;c[5308]=1065353216;g[5309]=0.0}do if(+g[t+288+44>>2]*+g[21192+(h<<4)>>2]+ +g[t+288+48>>2]*+g[21192+(h<<4)+4>>2]+ +g[t+288+52>>2]*+g[21192+(h<<4)+8>>2]>0.0){j=+g[t+288+4>>2];g[d+108>>2]=+g[d+52>>2]*j;if(!(a[d+180>>0]|0)){c[d+92>>2]=c[d+112>>2];c[d+92+4>>2]=c[d+112+4>>2];c[d+92+8>>2]=c[d+112+8>>2];c[d+92+12>>2]=c[d+112+12>>2];break}else{g[d+92>>2]=(1.0-j)*+g[d+92>>2]+j*+g[d+112>>2];g[d+96>>2]=(1.0-j)*+g[d+96>>2]+j*+g[d+116>>2];g[d+100>>2]=(1.0-j)*+g[d+100>>2]+j*+g[d+120>>2];break}}while(0);g[d+16>>2]=0.0;g[d+20>>2]=0.0}else{c[d+108>>2]=c[d+52>>2];c[d+92>>2]=c[d+112>>2];c[d+92+4>>2]=c[d+112+4>>2];c[d+92+8>>2]=c[d+112+8>>2];c[d+92+12>>2]=c[d+112+12>>2]}if(!(a[d+171>>0]|0)){q=+g[d+172>>2];r=q>f?f:q;g[d+172>>2]=q-f;uo(d,e,r*+g[d+60>>2],r*+g[d+64>>2],r*+g[d+68>>2])}else uo(d,e,+g[d+60>>2],+g[d+64>>2],+g[d+68>>2]);c[t+272>>2]=c[d+112>>2];c[t+272+4>>2]=c[d+112+4>>2];c[t+272+8>>2]=c[d+112+8>>2];c[t+272+12>>2]=c[d+112+12>>2];j=+g[d+16>>2];j=(j<0.0?-j:0.0)*f;if(j>0.0?(o=+g[d+24>>2],j>o):0){p=b[d+168>>1]|0;j=(p&255)<<24>>24!=0|(p&65535)<256?o:j}h=c[d+176>>2]|0;if(!(a[19872]|0)){a[19872]=1;c[5298]=1065353216;c[5299]=0;c[5300]=0;c[5301]=0;c[5302]=0;c[5303]=1065353216;c[5304]=0;c[5305]=0;c[5306]=0;c[5307]=0;c[5308]=1065353216;g[5309]=0.0}o=j+ +g[d+108>>2];q=+g[21192+(h<<4)>>2]*o;r=o*+g[21192+(h<<4)+4>>2];o=o*+g[21192+(h<<4)+8>>2];g[d+112>>2]=+g[d+112>>2]-q;g[d+116>>2]=+g[d+116>>2]-r;g[d+120>>2]=+g[d+120>>2]-o;h=c[d+8>>2]|0;l=c[d+176>>2]|0;if(!(a[19872]|0)){a[19872]=1;c[5298]=1065353216;c[5299]=0;c[5300]=0;c[5301]=0;c[5302]=0;c[5303]=1065353216;c[5304]=0;c[5305]=0;c[5306]=0;c[5307]=0;c[5308]=1065353216;g[5309]=0.0}n=c[d+40>>2]|0;p=t+168+4|0;g[p>>2]=1.0;b[t+168+8>>1]=1;b[t+168+10>>1]=-1;u=t+168+12|0;c[t+168+76>>2]=0;c[u>>2]=0;c[u+4>>2]=0;c[u+8>>2]=0;c[u+12>>2]=0;c[u+16>>2]=0;c[u+20>>2]=0;c[u+24>>2]=0;c[u+28>>2]=0;c[t+168>>2]=7108;c[t+168+80>>2]=h;c[t+168+84>>2]=c[21192+(l<<4)>>2];c[t+168+84+4>>2]=c[21192+(l<<4)+4>>2];c[t+168+84+8>>2]=c[21192+(l<<4)+8>>2];c[t+168+84+12>>2]=c[21192+(l<<4)+12>>2];c[t+168+100>>2]=n;h=c[d+8>>2]|0;l=c[(c[h+188>>2]|0)+4>>2]|0;b[t+168+8>>1]=l;b[t+168+10>>1]=l>>>16;l=c[d+176>>2]|0;if(!(a[19872]|0)){a[19872]=1;c[5298]=1065353216;c[5299]=0;c[5300]=0;c[5301]=0;c[5302]=0;c[5303]=1065353216;c[5304]=0;c[5305]=0;c[5306]=0;c[5307]=0;c[5308]=1065353216;g[5309]=0.0}u=c[d+40>>2]|0;g[t+64+4>>2]=1.0;b[t+64+8>>1]=1;b[t+64+10>>1]=-1;n=t+64+12|0;c[t+64+76>>2]=0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;c[n+20>>2]=0;c[n+24>>2]=0;c[n+28>>2]=0;c[t+64>>2]=7108;c[t+64+80>>2]=h;c[t+64+84>>2]=c[21192+(l<<4)>>2];c[t+64+84+4>>2]=c[21192+(l<<4)+4>>2];c[t+64+84+8>>2]=c[21192+(l<<4)+8>>2];c[t+64+84+12>>2]=c[21192+(l<<4)+12>>2];c[t+64+100>>2]=u;h=c[(c[(c[d+8>>2]|0)+188>>2]|0)+4>>2]|0;b[t+64+8>>1]=h;b[t+64+10>>1]=h>>>16;j=+g[d+112>>2];k=+g[d+116>>2];m=+g[d+120>>2];h=0;while(1){c[t+456>>2]=1065353216;c[t+456+4>>2]=0;c[t+456+4+4>>2]=0;c[t+456+4+8>>2]=0;c[t+456+4+12>>2]=0;c[t+456+20>>2]=1065353216;c[t+456+24>>2]=0;c[t+456+24+4>>2]=0;c[t+456+24+8>>2]=0;c[t+456+24+12>>2]=0;c[t+456+40>>2]=1065353216;c[t+456+44>>2]=0;c[t+392>>2]=1065353216;c[t+392+4>>2]=0;c[t+392+4+4>>2]=0;c[t+392+4+8>>2]=0;c[t+392+4+12>>2]=0;c[t+392+20>>2]=1065353216;c[t+392+24>>2]=0;c[t+392+24+4>>2]=0;c[t+392+24+8>>2]=0;c[t+392+24+12>>2]=0;c[t+392+40>>2]=1065353216;c[t+392+44>>2]=0;c[t+288>>2]=1065353216;c[t+288+4>>2]=0;c[t+288+4+4>>2]=0;c[t+288+4+8>>2]=0;c[t+288+4+12>>2]=0;c[t+288+20>>2]=1065353216;c[t+288+24>>2]=0;c[t+288+24+4>>2]=0;c[t+288+24+8>>2]=0;c[t+288+24+12>>2]=0;c[t+288+40>>2]=1065353216;c[t+288+44>>2]=0;c[t+288+44+4>>2]=0;c[t+288+44+8>>2]=0;c[t+456+48>>2]=c[d+92>>2];c[t+456+48+4>>2]=c[d+92+4>>2];c[t+456+48+8>>2]=c[d+92+8>>2];c[t+456+48+12>>2]=c[d+92+12>>2];c[t+392+48>>2]=c[d+112>>2];c[t+392+48+4>>2]=c[d+112+4>>2];c[t+392+48+8>>2]=c[d+112+8>>2];c[t+392+48+12>>2]=c[d+112+12>>2];g[t+288+48>>2]=j-q;g[t+288+52>>2]=k-r;g[t+288+56>>2]=m-o;g[t+288+60>>2]=0.0;if(!(a[d+170>>0]|0)){Yf(e,c[d+12>>2]|0,t+456|0,t+392|0,t+168|0,+g[e+56>>2]);if(!(+g[p>>2]<1.0))Yf(e,c[d+12>>2]|0,t+456|0,t+288|0,t+64|0,+g[e+56>>2])}else{pi(c[d+8>>2]|0,c[d+12>>2]|0,t+456|0,t+392|0,t+168|0,+g[e+56>>2]);if(!(+g[p>>2]<1.0))pi(c[d+8>>2]|0,c[d+12>>2]|0,t+456|0,t+288|0,t+64|0,+g[e+56>>2])}k=+g[d+16>>2];k=(k<0.0?-k:0.0)*f;n=(a[d+182>>0]|0)==0;if(!n?+g[p>>2]<1.0:0)l=1;else l=+g[t+64+4>>2]<1.0;if(!(k>0.0))break;j=+g[d+52>>2];if(h|(!(k<j)|l^1))break;u=b[d+168>>1]|0;if(!((u&255)<<24>>24!=0|(u&65535)<256)){h=0;break};c[d+112>>2]=c[t+272>>2];c[d+112+4>>2]=c[t+272+4>>2];c[d+112+8>>2]=c[t+272+8>>2];c[d+112+12>>2]=c[t+272+12>>2];h=c[d+176>>2]|0;if(!(a[19872]|0)){a[19872]=1;c[5298]=1065353216;c[5299]=0;c[5300]=0;c[5301]=0;c[5302]=0;c[5303]=1065353216;c[5304]=0;c[5305]=0;c[5306]=0;c[5307]=0;c[5308]=1065353216;g[5309]=0.0}j=j+ +g[d+108>>2];k=j*+g[21192+(h<<4)+4>>2];m=j*+g[21192+(h<<4)+8>>2];j=+g[d+112>>2]-+g[21192+(h<<4)>>2]*j;g[d+112>>2]=j;k=+g[d+116>>2]-k;g[d+116>>2]=k;m=+g[d+120>>2]-m;g[d+120>>2]=m;h=1}m=+g[p>>2];if(h|m<1.0){j=+g[d+96>>2];k=(j-+g[t+168+64>>2])*.5;do if(!n)if(!(a[d+181>>0]|0)){g[d+92>>2]=(1.0-k)*+g[d+92>>2]+k*+g[d+112>>2];g[d+96>>2]=(1.0-k)*j+k*+g[d+116>>2];g[d+100>>2]=(1.0-k)*+g[d+100>>2]+k*+g[d+120>>2];h=d+181|0;break}else{g[d+92>>2]=(1.0-m)*+g[d+92>>2]+m*+g[d+112>>2];g[d+96>>2]=(1.0-m)*j+m*+g[d+116>>2];g[d+100>>2]=(1.0-m)*+g[d+100>>2]+m*+g[d+120>>2];h=d+181|0;break}else{g[d+92>>2]=(1.0-m)*+g[d+92>>2]+m*+g[d+112>>2];g[d+96>>2]=(1.0-m)*j+m*+g[d+116>>2];g[d+100>>2]=(1.0-m)*+g[d+100>>2]+m*+g[d+120>>2];h=d+181|0}while(0);a[h>>0]=0;g[d+16>>2]=0.0;g[d+20>>2]=0.0;a[d+169>>0]=0}else{a[d+181>>0]=1;if((!n?(s=+g[d+24>>2],k>s):0)?(u=b[d+168>>1]|0,(u&255)<<24>>24!=0|(u&65535)<256):0){g[d+112>>2]=q+ +g[d+112>>2];g[d+116>>2]=r+ +g[d+116>>2];g[d+120>>2]=o+ +g[d+120>>2];h=c[d+176>>2]|0;if(!(a[19872]|0)){a[19872]=1;c[5298]=1065353216;c[5299]=0;c[5300]=0;c[5301]=0;c[5302]=0;c[5303]=1065353216;c[5304]=0;c[5305]=0;c[5306]=0;c[5307]=0;c[5308]=1065353216;g[5309]=0.0}r=s+ +g[d+108>>2];f=r*+g[21192+(h<<4)+4>>2];s=r*+g[21192+(h<<4)+8>>2];g[d+112>>2]=+g[d+112>>2]-+g[21192+(h<<4)>>2]*r;g[d+116>>2]=+g[d+116>>2]-f;g[d+120>>2]=+g[d+120>>2]-s};c[d+92>>2]=c[d+112>>2];c[d+92+4>>2]=c[d+112+4>>2];c[d+92+8>>2]=c[d+112+8>>2];c[d+92+12>>2]=c[d+112+12>>2]};c[t+48>>2]=c[d+92>>2];c[t+48+4>>2]=c[d+92+4>>2];c[t+48+8>>2]=c[d+92+8>>2];c[t+48+12>>2]=c[d+92+12>>2];u=c[d+8>>2]|0;c[u+284>>2]=(c[u+284>>2]|0)+1;c[u+4>>2]=c[t>>2];c[u+4+4>>2]=c[t+4>>2];c[u+4+8>>2]=c[t+8>>2];c[u+4+12>>2]=c[t+12>>2];c[u+20>>2]=c[t+16>>2];c[u+20+4>>2]=c[t+16+4>>2];c[u+20+8>>2]=c[t+16+8>>2];c[u+20+12>>2]=c[t+16+12>>2];c[u+36>>2]=c[t+32>>2];c[u+36+4>>2]=c[t+32+4>>2];c[u+36+8>>2]=c[t+32+8>>2];c[u+36+12>>2]=c[t+32+12>>2];c[u+52>>2]=c[t+48>>2];c[u+52+4>>2]=c[t+48+4>>2];c[u+52+8>>2]=c[t+48+8>>2];c[u+52+12>>2]=c[t+48+12>>2];i=t;return}function ro(a){a=a|0;rG(a);return}function so(a,d){a=a|0;d=d|0;d=c[d+4>>2]|0;if(!((b[a+10>>1]&(d&65535))<<16>>16)){a=0;return a|0}a=(d>>>16&65535&b[a+8>>1])<<16>>16!=0;return a|0}function to(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0,j=0.0,k=0.0;i=c[b>>2]|0;if((i|0)==(c[a+80>>2]|0)){k=1.0;return +k}if(c[i+204>>2]&4|0){k=1.0;return +k}h=+g[b+8>>2];f=+g[b+12>>2];e=+g[b+16>>2];if(d){j=h;k=f}else{j=+g[i+4>>2]*h+ +g[i+8>>2]*f+ +g[i+12>>2]*e;k=h*+g[i+20>>2]+f*+g[i+24>>2]+e*+g[i+28>>2];e=h*+g[i+36>>2]+f*+g[i+40>>2]+e*+g[i+44>>2]}if(j*+g[a+84>>2]+k*+g[a+88>>2]+e*+g[a+92>>2]<+g[a+100>>2]){k=1.0;return +k}c[a+4>>2]=c[b+40>>2];c[a+76>>2]=i;if(d){c[a+44>>2]=c[b+8>>2];c[a+44+4>>2]=c[b+8+4>>2];c[a+44+8>>2]=c[b+8+8>>2];c[a+44+12>>2]=c[b+8+12>>2]}else{e=+g[b+8>>2];f=+g[b+12>>2];h=+g[b+16>>2];j=e*+g[i+20>>2]+f*+g[i+24>>2]+h*+g[i+28>>2];k=e*+g[i+36>>2]+f*+g[i+40>>2]+h*+g[i+44>>2];g[a+44>>2]=+g[i+4>>2]*e+ +g[i+8>>2]*f+ +g[i+12>>2]*h;g[a+48>>2]=j;g[a+52>>2]=k;g[a+56>>2]=0.0}c[a+60>>2]=c[b+24>>2];c[a+60+4>>2]=c[b+24+4>>2];c[a+60+8>>2]=c[b+24+8>>2];c[a+60+12>>2]=c[b+24+12>>2];k=+g[b+40>>2];return +k}function uo(d,e,f,h,j){d=d|0;e=e|0;f=+f;h=+h;j=+j;var k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;q=i;i=i+240|0;o=+g[d+96>>2]+h;p=+g[d+100>>2]+j;g[d+112>>2]=+g[d+92>>2]+f;g[d+116>>2]=o;g[d+120>>2]=p;g[d+124>>2]=0.0;c[q+168>>2]=1065353216;c[q+168+4>>2]=0;c[q+168+4+4>>2]=0;c[q+168+4+8>>2]=0;c[q+168+4+12>>2]=0;c[q+168+20>>2]=1065353216;c[q+168+24>>2]=0;c[q+168+24+4>>2]=0;c[q+168+24+8>>2]=0;c[q+168+24+12>>2]=0;c[q+168+40>>2]=1065353216;k=q+168+44|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[q+104>>2]=1065353216;c[q+104+4>>2]=0;c[q+104+4+4>>2]=0;c[q+104+4+8>>2]=0;c[q+104+4+12>>2]=0;c[q+104+20>>2]=1065353216;c[q+104+24>>2]=0;c[q+104+24+4>>2]=0;c[q+104+24+8>>2]=0;c[q+104+24+12>>2]=0;c[q+104+40>>2]=1065353216;k=q+104+44|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;p=1.0;k=10;while(1){if((k|0)<=0){k=14;break};k=k+-1|0;c[q+168+48>>2]=c[d+92>>2];c[q+168+48+4>>2]=c[d+92+4>>2];c[q+168+48+8>>2]=c[d+92+8>>2];c[q+168+48+12>>2]=c[d+92+12>>2];c[q+104+48>>2]=c[d+112>>2];c[q+104+48+4>>2]=c[d+112+4>>2];c[q+104+48+8>>2]=c[d+112+8>>2];c[q+104+48+12>>2]=c[d+112+12>>2];n=+g[d+92>>2]-+g[d+112>>2];o=+g[d+96>>2]-+g[d+116>>2];f=+g[d+100>>2]-+g[d+120>>2];r=c[d+8>>2]|0;g[q+4>>2]=1.0;b[q+8>>1]=1;b[q+10>>1]=-1;c[q+76>>2]=0;c[q+12>>2]=0;c[q+12+4>>2]=0;c[q+12+8>>2]=0;c[q+12+12>>2]=0;c[q+12+16>>2]=0;c[q+12+20>>2]=0;c[q+12+24>>2]=0;c[q+12+28>>2]=0;c[q>>2]=7108;c[q+80>>2]=r;g[q+84>>2]=n;g[q+88>>2]=o;g[q+92>>2]=f;g[q+96>>2]=0.0;g[q+100>>2]=0.0;r=c[(c[r+188>>2]|0)+4>>2]|0;b[q+8>>1]=r;b[q+10>>1]=r>>>16;r=c[d+12>>2]|0;f=+Hb[c[(c[r>>2]|0)+48>>2]&15](r);r=c[d+12>>2]|0;qb[c[(c[r>>2]|0)+44>>2]&31](r,f+ +g[d+56>>2]);if(!(a[d+170>>0]|0))Yf(e,c[d+12>>2]|0,q+168|0,q+104|0,q,+g[e+56>>2]);else pi(c[d+8>>2]|0,c[d+12>>2]|0,q+168|0,q+104|0,q,+g[e+56>>2]);r=c[d+12>>2]|0;qb[c[(c[r>>2]|0)+44>>2]&31](r,f);o=+g[q+4>>2];p=p-o;if(o<1.0){h=+g[d+112>>2];m=+g[d+92>>2];j=+g[d+116>>2];n=+g[d+96>>2];l=+g[d+120>>2];o=+g[d+100>>2];f=+O(+((h-m)*(h-m)+(j-n)*(j-n)+(l-o)*(l-o)));if(f>1.1920928955078125e-07){v=+g[q+44>>2];t=+g[q+48>>2];x=+g[q+52>>2];w=((h-m)*(1.0/f)*v+(j-n)*(1.0/f)*t+(l-o)*(1.0/f)*x)*2.0;u=(h-m)*(1.0/f)-v*w;s=(j-n)*(1.0/f)-t*w;w=(l-o)*(1.0/f)-x*w;l=1.0/+O(+(w*w+(u*u+s*s)));c[d+112>>2]=c[d+92>>2];c[d+112+4>>2]=c[d+92+4>>2];c[d+112+8>>2]=c[d+92+8>>2];c[d+112+12>>2]=c[d+92+12>>2];h=f*(l*u-v*(x*(l*w)+(v*(l*u)+t*(l*s))))+ +g[d+112>>2];g[d+112>>2]=h;j=f*(l*s-t*(x*(l*w)+(v*(l*u)+t*(l*s))))+ +g[d+116>>2];g[d+116>>2]=j;l=f*(l*w-x*(x*(l*w)+(v*(l*u)+t*(l*s))))+ +g[d+120>>2];g[d+120>>2]=l;f=j}else f=j;j=h-m;h=f-n;f=l-o;if(!(j*j+h*h+f*f>1.1920928955078125e-07)){k=11;break}x=1.0/+O(+(j*j+h*h+f*f));if(+g[d+76>>2]*(j*x)+h*x*+g[d+80>>2]+f*x*+g[d+84>>2]<=0.0){k=11;break}}else{c[d+92>>2]=c[d+112>>2];c[d+92+4>>2]=c[d+112+4>>2];c[d+92+8>>2]=c[d+112+8>>2];c[d+92+12>>2]=c[d+112+12>>2]}if(!(p>.009999999776482582)){k=14;break}}if((k|0)==11){i=q;return}else if((k|0)==14){i=q;return}}function vo(a){a=a|0;return vb[c[(c[a>>2]|0)+48>>2]&127](a)|0}function wo(b){b=b|0;if(!(vb[c[(c[b>>2]|0)+40>>2]&127](b)|0))return;c[b+16>>2]=c[b+28>>2];a[b+169>>0]=1;return}function xo(a){a=a|0;if(!(+g[a+16>>2]==0.0)){a=0;return a|0}a=+g[a+20>>2]==0.0;return a|0}function yo(b,c){b=b|0;c=c|0;a[b+180>>0]=c&1;return}function zo(a){a=a|0;c[a>>2]=7188;return}function Ao(a){a=a|0;c[a>>2]=7188;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function Bo(a){a=a|0;return}function Co(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return}function Do(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;return}function Eo(a){a=a|0;return 52}function Fo(a){a=a|0;c[a>>2]=7188;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function Go(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0.0,x=0.0,y=0;v=i;i=i+176|0;if(!(a[b+527>>0]|0)){i=v;return}g[b+36>>2]=0.0;g[b+520>>2]=0.0;g[b+516>>2]=0.0;c[b+576>>2]=0;c[b+576+4>>2]=0;c[b+576+8>>2]=0;c[b+576+12>>2]=0;if(!(a[b+524>>0]|0)){d=c[b+28>>2]|0;k=+g[b+348>>2];l=+g[b+352>>2];r=+g[b+356>>2];t=k*+g[d+20>>2]+l*+g[d+24>>2]+r*+g[d+28>>2]+ +g[d+56>>2];j=c[b+32>>2]|0;m=+g[b+412>>2];n=+g[b+416>>2];s=+g[b+420>>2];o=+g[j+52>>2];e=+g[j+56>>2];u=m*+g[j+20>>2]+n*+g[j+24>>2]+s*+g[j+28>>2]+e;p=m*+g[j+36>>2]+n*+g[j+40>>2]+s*+g[j+44>>2]+ +g[j+60>>2];q=k*+g[d+4>>2]+l*+g[d+8>>2]+r*+g[d+12>>2]+ +g[d+52>>2];r=k*+g[d+36>>2]+l*+g[d+40>>2]+r*+g[d+44>>2]+ +g[d+60>>2];s=m*+g[j+4>>2]+n*+g[j+8>>2]+s*+g[j+12>>2]+o;if((s-q)*(s-q)+(u-t)*(u-t)+(p-r)*(p-r)>1.1920928955078125e-07){h=1.0/+O(+((s-q)*(s-q)+(u-t)*(u-t)+(p-r)*(p-r)));g[v+128>>2]=(s-q)*h;g[v+128+4>>2]=(u-t)*h;g[v+128+8>>2]=(p-r)*h;c[v+128+12>>2]=0;k=(p-r)*h;f=(u-t)*h;h=(s-q)*h}else{c[v+128>>2]=1065353216;c[v+128+4>>2]=0;c[v+128+8>>2]=0;g[v+128+12>>2]=0.0;k=0.0;f=0.0;h=1.0}if(+N(+k)>.7071067690849304){x=k*k+f*f;w=1.0/+O(+x);m=-(w*k);k=w*f;n=-(k*h);l=h*m;f=x*w;h=k;k=0.0}else{m=h*h+f*f;l=1.0/+O(+m);x=-(f*l);f=l*h;n=k*x;l=m*l;m=f;f=-(f*k);h=0.0;k=x}g[v+128+16>>2]=k;g[v+128+20>>2]=m;g[v+128+24>>2]=h;g[v+128+32>>2]=f;g[v+128+36>>2]=n;g[v+128+40>>2]=l;f=o;d=0;while(1){y=c[b+28>>2]|0;c[v+80>>2]=c[y+4>>2];c[v+80+4>>2]=c[y+20>>2];c[v+80+8>>2]=c[y+36>>2];g[v+80+12>>2]=0.0;c[v+80+16>>2]=c[y+8>>2];c[v+80+20>>2]=c[y+24>>2];c[v+80+24>>2]=c[y+40>>2];g[v+80+28>>2]=0.0;c[v+80+32>>2]=c[y+12>>2];c[v+80+36>>2]=c[y+28>>2];c[v+80+40>>2]=c[y+44>>2];g[v+80+44>>2]=0.0;c[v+32>>2]=c[j+4>>2];c[v+32+4>>2]=c[j+20>>2];c[v+32+8>>2]=c[j+36>>2];g[v+32+12>>2]=0.0;c[v+32+16>>2]=c[j+8>>2];c[v+32+20>>2]=c[j+24>>2];c[v+32+24>>2]=c[j+40>>2];g[v+32+28>>2]=0.0;c[v+32+32>>2]=c[j+12>>2];c[v+32+36>>2]=c[j+28>>2];c[v+32+40>>2]=c[j+44>>2];g[v+32+44>>2]=0.0;w=t-+g[y+56>>2];x=r-+g[y+60>>2];g[v+16>>2]=q-+g[y+52>>2];g[v+16+4>>2]=w;g[v+16+8>>2]=x;g[v+16+12>>2]=0.0;x=p-+g[j+60>>2];g[v>>2]=s-f;g[v+4>>2]=u-e;g[v+8>>2]=x;g[v+12>>2]=0.0;y=c[b+28>>2]|0;j=c[b+32>>2]|0;Ho(b+48+(d*84|0)|0,v+80|0,v+32|0,v+16|0,v,v+128+(d<<4)|0,y+420|0,+g[y+368>>2],j+420|0,+g[j+368>>2]);d=d+1|0;if((d|0)==3)break;y=c[b+32>>2]|0;j=y;f=+g[y+52>>2];e=+g[y+56>>2]}d=b+32|0}else d=b+32|0;j=c[b+28>>2]|0;y=c[d>>2]|0;Io(b,j+4|0,y+4|0,j+288|0,y+288|0);i=v;return}function Ho(a,b,d,e,f,h,i,j,k,l){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=+j;k=k|0;l=+l;var m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;c[a>>2]=c[h>>2];c[a+4>>2]=c[h+4>>2];c[a+8>>2]=c[h+8>>2];c[a+12>>2]=c[h+12>>2];s=+g[e+4>>2];v=+g[a+8>>2];w=+g[e+8>>2];p=+g[a+4>>2];m=+g[a>>2];r=+g[e>>2];u=(s*v-w*p)*+g[b>>2]+ +g[b+4>>2]*(w*m-v*r)+(p*r-s*m)*+g[b+8>>2];t=(s*v-w*p)*+g[b+16>>2]+(w*m-v*r)*+g[b+20>>2]+(p*r-s*m)*+g[b+24>>2];s=(s*v-w*p)*+g[b+32>>2]+(w*m-v*r)*+g[b+36>>2]+(p*r-s*m)*+g[b+40>>2];g[a+16>>2]=u;g[a+20>>2]=t;g[a+24>>2]=s;g[a+28>>2]=0.0;r=+g[f+4>>2];w=+g[f+8>>2];n=+g[f>>2];q=+g[d>>2]*(r*-v-w*-p)+ +g[d+4>>2]*(w*-m-n*-v)+(n*-p-r*-m)*+g[d+8>>2];o=(r*-v-w*-p)*+g[d+16>>2]+(w*-m-n*-v)*+g[d+20>>2]+(n*-p-r*-m)*+g[d+24>>2];m=(r*-v-w*-p)*+g[d+32>>2]+(w*-m-n*-v)*+g[d+36>>2]+(n*-p-r*-m)*+g[d+40>>2];g[a+32>>2]=q;g[a+36>>2]=o;g[a+40>>2]=m;g[a+44>>2]=0.0;u=+g[i>>2]*u;t=+g[i+4>>2]*t;s=+g[i+8>>2]*s;g[a+48>>2]=u;g[a+52>>2]=t;g[a+56>>2]=s;g[a+60>>2]=0.0;r=+g[k>>2]*q;p=+g[k+4>>2]*o;n=+g[k+8>>2]*m;g[a+64>>2]=r;g[a+68>>2]=p;g[a+72>>2]=n;g[a+76>>2]=0.0;g[a+80>>2]=u*+g[a+16>>2]+t*+g[a+20>>2]+s*+g[a+24>>2]+j+l+(r*q+p*o+n*m);return}function Io(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0.0,r=0.0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,P=0.0,S=0,U=0.0,V=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0,na=0.0,oa=0.0,pa=0.0,qa=0.0,ra=0,sa=0.0,ta=0.0,ua=0.0,va=0.0,wa=0.0;ra=i;i=i+144|0;g[b+504>>2]=0.0;g[b+500>>2]=0.0;a[b+525>>0]=0;a[b+526>>0]=0;if(a[b+552>>0]|0?(a[b+527>>0]|0)==0:0){wa=+g[b+556>>2];ua=+g[b+560>>2];qa=+g[b+564>>2];ta=+g[b+568>>2];fa=wa*(2.0/(wa*wa+ua*ua+qa*qa+ta*ta));va=ua*(2.0/(wa*wa+ua*ua+qa*qa+ta*ta));sa=qa*(2.0/(wa*wa+ua*ua+qa*qa+ta*ta));ga=+g[b+300>>2];Y=+g[d>>2];ha=+g[b+316>>2];Z=+g[d+4>>2];ia=+g[b+332>>2];_=+g[d+8>>2];ka=+g[b+304>>2];ma=+g[b+320>>2];oa=+g[b+336>>2];ca=+g[b+308>>2];da=+g[b+324>>2];ea=+g[b+340>>2];$=+g[d+16>>2];aa=+g[d+20>>2];ba=+g[d+24>>2];la=+g[d+32>>2];na=+g[d+36>>2];pa=+g[d+40>>2];w=+g[b+348>>2];v=+g[b+352>>2];u=+g[b+356>>2];A=+g[b+364>>2];n=+g[e>>2];B=+g[b+380>>2];o=+g[e+4>>2];C=+g[b+396>>2];m=+g[e+8>>2];D=+g[b+368>>2];E=+g[b+384>>2];F=+g[b+400>>2];x=+g[b+372>>2];y=+g[b+388>>2];z=+g[b+404>>2];q=+g[e+16>>2];r=+g[e+20>>2];l=+g[e+24>>2];G=+g[e+32>>2];I=+g[e+36>>2];K=+g[e+40>>2];H=+g[b+412>>2];J=+g[b+416>>2];j=+g[b+420>>2];M=(1.0-(ua*va+qa*sa))*(A*n+B*o+C*m)+(wa*va+ta*sa)*(n*D+o*E+m*F)+(wa*sa-ta*va)*(n*x+o*y+m*z);P=(wa*va-ta*sa)*(A*n+B*o+C*m)+(1.0-(wa*fa+qa*sa))*(n*D+o*E+m*F)+(ua*sa+ta*fa)*(n*x+o*y+m*z);L=(wa*sa+ta*va)*(A*n+B*o+C*m)+(ua*sa-ta*fa)*(n*D+o*E+m*F)+(1.0-(wa*fa+ua*va))*(n*x+o*y+m*z);V=(wa*sa-ta*va)*(x*q+y*r+z*l)+((1.0-(ua*va+qa*sa))*(A*q+B*r+C*l)+(wa*va+ta*sa)*(D*q+E*r+F*l));X=(ua*sa+ta*fa)*(x*q+y*r+z*l)+((wa*va-ta*sa)*(A*q+B*r+C*l)+(1.0-(wa*fa+qa*sa))*(D*q+E*r+F*l));U=(1.0-(wa*fa+ua*va))*(x*q+y*r+z*l)+((wa*sa+ta*va)*(A*q+B*r+C*l)+(ua*sa-ta*fa)*(D*q+E*r+F*l));ja=(wa*sa-ta*va)*(x*G+y*I+z*K)+((1.0-(ua*va+qa*sa))*(A*G+B*I+C*K)+(wa*va+ta*sa)*(D*G+E*I+F*K));qa=(ua*sa+ta*fa)*(x*G+y*I+z*K)+((wa*va-ta*sa)*(A*G+B*I+C*K)+(1.0-(wa*fa+qa*sa))*(D*G+E*I+F*K));fa=(1.0-(wa*fa+ua*va))*(x*G+y*I+z*K)+((wa*sa+ta*va)*(A*G+B*I+C*K)+(ua*sa-ta*fa)*(D*G+E*I+F*K));ta=-(+g[d+48>>2]+(Y*w+Z*v+_*u));sa=-($*w+aa*v+ba*u+ +g[d+52>>2]);u=-(la*w+na*v+pa*u+ +g[d+56>>2]);v=(ga*Y+ha*Z+ia*_)*ta+(ga*$+ha*aa+ia*ba)*sa+(ga*la+ha*na+ia*pa)*u;w=(Y*ka+Z*ma+_*oa)*ta+(ka*$+ma*aa+oa*ba)*sa+(ka*la+ma*na+oa*pa)*u;u=(Y*ca+Z*da+_*ea)*ta+(ca*$+da*aa+ea*ba)*sa+(ca*la+da*na+ea*pa)*u;m=u*L+(v*M+w*P)+((A*n+B*o+C*m)*0.0+(n*D+o*E+m*F)*0.0+(n*x+o*y+m*z)*0.0+(+g[e+48>>2]+(n*H+o*J+m*j)));l=u*U+(v*V+w*X)+((x*q+y*r+z*l)*0.0+((A*q+B*r+C*l)*0.0+(D*q+E*r+F*l)*0.0)+(q*H+r*J+l*j+ +g[e+52>>2]));j=u*fa+(v*ja+w*qa)+((x*G+y*I+z*K)*0.0+((A*G+B*I+C*K)*0.0+(D*G+E*I+F*K)*0.0)+(G*H+I*J+K*j+ +g[e+56>>2]));g[ra+80>>2]=(Y*ca+Z*da+_*ea)*L+((ga*Y+ha*Z+ia*_)*M+(Y*ka+Z*ma+_*oa)*P);g[ra+80+4>>2]=(ca*$+da*aa+ea*ba)*L+((ga*$+ha*aa+ia*ba)*M+(ka*$+ma*aa+oa*ba)*P);g[ra+80+8>>2]=(ca*la+da*na+ea*pa)*L+((ga*la+ha*na+ia*pa)*M+(ka*la+ma*na+oa*pa)*P);g[ra+80+12>>2]=0.0;g[ra+80+16>>2]=(Y*ca+Z*da+_*ea)*U+((ga*Y+ha*Z+ia*_)*V+(Y*ka+Z*ma+_*oa)*X);g[ra+80+20>>2]=(ca*$+da*aa+ea*ba)*U+((ga*$+ha*aa+ia*ba)*V+(ka*$+ma*aa+oa*ba)*X);g[ra+80+24>>2]=(ca*la+da*na+ea*pa)*U+((ga*la+ha*na+ia*pa)*V+(ka*la+ma*na+oa*pa)*X);g[ra+80+28>>2]=0.0;g[ra+80+32>>2]=(Y*ca+Z*da+_*ea)*fa+((ga*Y+ha*Z+ia*_)*ja+(Y*ka+Z*ma+_*oa)*qa);g[ra+80+36>>2]=(ca*$+da*aa+ea*ba)*fa+((ga*$+ha*aa+ia*ba)*ja+(ka*$+ma*aa+oa*ba)*qa);g[ra+80+40>>2]=(ca*la+da*na+ea*pa)*fa+((ga*la+ha*na+ia*pa)*ja+(ka*la+ma*na+oa*pa)*qa);g[ra+80+44>>2]=0.0;g[ra+80+48>>2]=m;g[ra+80+52>>2]=l;g[ra+80+56>>2]=j;g[ra+80+60>>2]=0.0;_f(ra+80|0,ra+64|0);j=+g[ra+64>>2];l=+g[ra+64+4>>2];m=+g[ra+64+8>>2];if(!(+N(+(j*j+l*l+m*m))<1.1920928955078125e-07)?(g[b+472>>2]=0.0,wa=1.0/+O(+(j*j+l*l+m*m)),g[b+460>>2]=j*wa,g[b+464>>2]=l*wa,g[b+468>>2]=m*wa,wa=+g[ra+64+12>>2],wa=wa<-1.0?-1.0:wa,wa=+T(+(wa>1.0?1.0:wa))*2.0,g[b+504>>2]=wa,!(+N(+wa)<1.1920928955078125e-07)):0)a[b+526>>0]=1;i=ra;return}_f(d,ra+48|0);_f(b+300|0,ra+32|0);_=+g[ra+48+12>>2];$=+g[ra+32>>2];aa=+g[ra+48>>2];ba=+g[ra+32+12>>2];ca=+g[ra+48+4>>2];da=+g[ra+32+8>>2];ea=+g[ra+48+8>>2];fa=+g[ra+32+4>>2];_f(e,ra+16|0);_f(b+364|0,ra);ga=+g[ra+16+12>>2];ha=+g[ra>>2];ia=+g[ra+16>>2];ja=+g[ra+12>>2];ka=+g[ra+16+4>>2];la=+g[ra+8>>2];ma=+g[ra+16+8>>2];na=+g[ra+4>>2];oa=-(ga*ha+ia*ja+ka*la-ma*na);pa=-(ha*ma+(ja*ka+ga*na)-ia*la);qa=-(ga*la+ja*ma+ia*na-ha*ka);u=(_*ba-$*aa-ca*fa-da*ea)*oa+(_*$+aa*ba+ca*da-ea*fa)*(ga*ja-ha*ia-ka*na-la*ma)+(_*da+ba*ea+aa*fa-$*ca)*pa-($*ea+(ba*ca+_*fa)-aa*da)*qa;v=(_*$+aa*ba+ca*da-ea*fa)*qa+(($*ea+(ba*ca+_*fa)-aa*da)*(ga*ja-ha*ia-ka*na-la*ma)+(_*ba-$*aa-ca*fa-da*ea)*pa)-(_*da+ba*ea+aa*fa-$*ca)*oa;w=($*ea+(ba*ca+_*fa)-aa*da)*oa+((_*da+ba*ea+aa*fa-$*ca)*(ga*ja-ha*ia-ka*na-la*ma)+(_*ba-$*aa-ca*fa-da*ea)*qa)-(_*$+aa*ba+ca*da-ea*fa)*pa;x=(_*ba-$*aa-ca*fa-da*ea)*(ga*ja-ha*ia-ka*na-la*ma)-(_*$+aa*ba+ca*da-ea*fa)*oa-($*ea+(ba*ca+_*fa)-aa*da)*pa-(_*da+ba*ea+aa*fa-$*ca)*qa;m=+g[5310];n=+g[5312];l=+g[5311];o=(m*w+l*x-n*u)*-w+(x*(m*x+n*v-l*w)+(-(m*u)-l*v-n*w)*-u)-(n*x+l*u-m*v)*-v;j=(n*x+l*u-m*v)*-u+(x*(m*w+l*x-n*u)+(-(m*u)-l*v-n*w)*-v)-(m*x+n*v-l*w)*-w;q=(m*x+n*v-l*w)*-v+(x*(n*x+l*u-m*v)+(-(m*u)-l*v-n*w)*-w)-(m*w+l*x-n*u)*-u;r=1.0/+O(+(q*q+(o*o+j*j)));do if(n*(r*q)+(l*(r*j)+m*(r*o))<-.9999998807907104)if(+N(+n)>.7071067690849304){j=1.0/+O(+(n*n+l*l));p=0;s=(g[k>>2]=l*j,c[k>>2]|0);t=0;j=-(n*j);break}else{j=1.0/+O(+(m*m+l*l));p=(g[k>>2]=-(l*j),c[k>>2]|0);s=0;t=0;j=m*j;break}else{wa=+O(+((n*(r*q)+(l*(r*j)+m*(r*o))+1.0)*2.0));p=(g[k>>2]=(l*(r*q)-n*(r*j))*(1.0/wa),c[k>>2]|0);s=(g[k>>2]=(m*(r*j)-l*(r*o))*(1.0/wa),c[k>>2]|0);t=(g[k>>2]=wa*.5,c[k>>2]|0);j=(n*(r*o)-m*(r*q))*(1.0/wa)}while(0);m=(c[k>>2]=p,+g[k>>2]);q=(c[k>>2]=s,+g[k>>2]);l=(c[k>>2]=t,+g[k>>2]);n=1.0/+O(+(m*m+j*j+q*q+l*l));o=j*n;X=w*-o+(u*(l*n)+x*-(m*n))-v*-(q*n);Y=u*-(q*n)+(x*-o+v*(l*n))-w*-(m*n);Z=v*-(m*n)+(w*(l*n)+x*-(q*n))-u*-o;U=x*(l*n)-u*-(m*n)-v*-o-w*-(q*n);V=1.0/+O(+(U*U+(Z*Z+(X*X+Y*Y))));u=+g[b+444>>2];j=+g[b+456>>2];p=(g[k>>2]=u,c[k>>2]|0);if(u>=j?(y=+g[b+448>>2],y>=j):0){r=l*n<-1.0?-1.0:l*n;r=+T(+(r>1.0?1.0:r))*2.0;if(r>1.1920928955078125e-07){j=1.0/+O(+(q*n*(q*n)+(m*n*(m*n)+o*o)));if(+N(+(o*j))>1.1920928955078125e-07){wa=+O(+((q*n*j*(q*n*j)/(o*j*(o*j))+1.0)/(1.0/(y*y)+q*n*j*(q*n*j)/(o*j*(o*j))/(u*u))));m=m*n*j;l=q*n*j;j=o*j;p=(g[k>>2]=wa,c[k>>2]|0)}else{m=m*n*j;l=q*n*j;j=o*j}}else{m=0.0;l=0.0;j=0.0;p=0}n=(c[k>>2]=p,+g[k>>2]);o=+g[b+428>>2];if(r>n*o){a[b+526>>0]=1;if(r<n&o<.9999998807907104)q=(r-n*o)/(n-n*o);else q=1.0;g[b+528>>2]=q;g[b+504>>2]=r-n*o;if(+N(+j)>1.1920928955078125e-07){wa=+N(+(j*(-l/j*(y/u))));l=l<-0.0?wa:-wa;wa=1.0/+O(+(m*m+j*j+l*l));m=m*wa;l=-(l*wa);j=j*wa}va=-m;ua=-j;sa=-l;P=(ga*ja-ha*ia-ka*na-la*ma)*va+(ha*ma+(ja*ka+ga*na)-ia*la)*sa-(ga*la+ja*ma+ia*na-ha*ka)*ua;wa=(ga*la+ja*ma+ia*na-ha*ka)*va+(ga*ja-ha*ia-ka*na-la*ma)*ua-(ga*ha+ia*ja+ka*la-ma*na)*sa;ta=(ga*ha+ia*ja+ka*la-ma*na)*ua+(ga*ja-ha*ia-ka*na-la*ma)*sa-(ha*ma+(ja*ka+ga*na)-ia*la)*va;sa=-((ga*ha+ia*ja+ka*la-ma*na)*va)-(ha*ma+(ja*ka+ga*na)-ia*la)*ua-(ga*la+ja*ma+ia*na-ha*ka)*sa;ua=wa*qa+(sa*oa+(ga*ja-ha*ia-ka*na-la*ma)*P)-ta*pa;va=ta*oa+((ga*ja-ha*ia-ka*na-la*ma)*wa+sa*pa)-P*qa;wa=P*pa+(sa*qa+(ga*ja-ha*ia-ka*na-la*ma)*ta)-wa*oa;g[b+460>>2]=ua;g[b+464>>2]=va;g[b+468>>2]=wa;g[b+472>>2]=0.0;c[b+536>>2]=0;c[b+536+4>>2]=0;c[b+536+8>>2]=0;c[b+536+12>>2]=0;g[b+492>>2]=1.0/(ua*(+g[f>>2]*ua+ +g[f+16>>2]*va+ +g[f+32>>2]*wa)+va*(ua*+g[f+4>>2]+va*+g[f+20>>2]+wa*+g[f+36>>2])+wa*(ua*+g[f+8>>2]+va*+g[f+24>>2]+wa*+g[f+40>>2])+(ua*(ua*+g[h>>2]+va*+g[h+16>>2]+wa*+g[h+32>>2])+va*(ua*+g[h+4>>2]+va*+g[h+20>>2]+wa*+g[h+36>>2])+wa*(ua*+g[h+8>>2]+va*+g[h+24>>2]+wa*+g[h+40>>2])))}}else S=23;a:do if((S|0)==23){G=+g[b+300>>2];H=+g[b+316>>2];I=+g[b+332>>2];r=+g[d>>2];u=+g[d+4>>2];v=+g[d+8>>2];w=+g[d+16>>2];x=+g[d+20>>2];y=+g[d+24>>2];J=+g[d+32>>2];K=+g[d+36>>2];z=+g[d+40>>2];A=+g[b+304>>2];B=+g[b+320>>2];C=+g[b+336>>2];D=+g[b+308>>2];E=+g[b+324>>2];F=+g[b+340>>2];n=+g[b+364>>2];m=+g[b+380>>2];L=+g[b+396>>2];M=n*+g[e>>2]+m*+g[e+4>>2]+L*+g[e+8>>2];P=n*+g[e+16>>2]+m*+g[e+20>>2]+L*+g[e+24>>2];L=n*+g[e+32>>2]+m*+g[e+36>>2]+L*+g[e+40>>2];m=(G*r+H*u+I*v)*M+(G*w+H*x+I*y)*P+(G*J+H*K+I*z)*L;n=(r*A+u*B+v*C)*M+(w*A+x*B+y*C)*P+(J*A+K*B+z*C)*L;q=(r*D+u*E+v*F)*M+(w*D+x*E+y*F)*P+(J*D+K*E+z*F)*L;l=+g[b+444>>2];j=+g[b+456>>2];do if(l<j){o=+g[b+448>>2];if(o<j){if(+N(+n)<1.1920928955078125e-07?+N(+q)<1.1920928955078125e-07:0)break a;a[b+526>>0]=1;g[b+460>>2]=-((G*J+H*K+I*z)*P-(G*w+H*x+I*y)*L);g[b+464>>2]=-((G*r+H*u+I*v)*L-(G*J+H*K+I*z)*M);g[b+468>>2]=-((G*w+H*x+I*y)*M-(G*r+H*u+I*v)*P);g[b+472>>2]=0.0;break a}if(+N(+m)<1.1920928955078125e-07?+N(+q)<1.1920928955078125e-07:0){l=n;j=q;break}a[b+526>>0]=1;if(o>=j){j=+W(+q,+m);if(j>o){m=+Q(+o);l=0.0;j=+R(+o);break}if(j<-o){m=+Q(+o);l=0.0;j=-+R(+o)}else{l=0.0;j=q}}else{l=n;j=q}}else{if(+N(+m)<1.1920928955078125e-07?+N(+n)<1.1920928955078125e-07:0){l=n;j=q;break}a[b+526>>0]=1;if(l>=j){j=+W(+n,+m);if(j>l){m=+Q(+l);l=+R(+l);j=0.0;break}if(j<-l){m=+Q(+l);l=-+R(+l);j=0.0}else{l=n;j=0.0}}else{l=n;j=q}}while(0);o=(r*D+u*E+v*F)*j+((r*A+u*B+v*C)*l+(G*r+H*u+I*v)*m);n=(w*D+x*E+y*F)*j+((w*A+x*B+y*C)*l+(G*w+H*x+I*y)*m);j=(J*D+K*E+z*F)*j+((J*A+K*B+z*C)*l+(G*J+H*K+I*z)*m);l=1.0/+O(+(j*j+(o*o+n*n)));g[b+460>>2]=-(P*(l*j)-L*(l*n));g[b+464>>2]=-(L*(l*o)-M*(l*j));g[b+468>>2]=-(M*(l*n)-P*(l*o));g[b+472>>2]=0.0;m=+O(+((P*(l*j)-L*(l*n))*(P*(l*j)-L*(l*n))+(L*(l*o)-M*(l*j))*(L*(l*o)-M*(l*j))+(M*(l*n)-P*(l*o))*(M*(l*n)-P*(l*o))));g[b+504>>2]=m;if(!(+N(+m)<1.1920928955078125e-07)){g[b+460>>2]=1.0/m*-(P*(l*j)-L*(l*n));g[b+464>>2]=1.0/m*-(L*(l*o)-M*(l*j));g[b+468>>2]=1.0/m*-(M*(l*n)-P*(l*o))}}while(0);r=+g[b+452>>2];if(!(r>=0.0)){g[b+512>>2]=0.0;i=ra;return}j=V*U<-1.0?-1.0:V*U;j=+T(+(j>1.0?1.0:j))*2.0;if(j>3.1415927410125732){q=-(V*U)<-1.0?-1.0:-(V*U);q=+T(+(q>1.0?1.0:q))*2.0;l=-(V*X);m=-(V*Y);j=-(V*Z)}else{q=j;l=V*X;m=V*Y;j=V*Z}g[b+512>>2]=q;if(q>1.1920928955078125e-07){wa=1.0/+O(+(l*l+m*m+j*j));o=l*wa;n=j*wa;m=m*wa}else{o=l;n=j}j=+g[b+428>>2];if(q>r*j){a[b+525>>0]=1;l=q-r*j;if(q<r&j<.9999998807907104)j=l/(r-r*j);else j=1.0;g[b+532>>2]=j;g[b+508>>2]=l;va=-o;ua=-m;sa=-n;Z=(ga*ja-ha*ia-ka*na-la*ma)*va+(ha*ma+(ja*ka+ga*na)-ia*la)*sa-(ga*la+ja*ma+ia*na-ha*ka)*ua;wa=(ga*la+ja*ma+ia*na-ha*ka)*va+(ga*ja-ha*ia-ka*na-la*ma)*ua-(ga*ha+ia*ja+ka*la-ma*na)*sa;ta=(ga*ha+ia*ja+ka*la-ma*na)*ua+(ga*ja-ha*ia-ka*na-la*ma)*sa-(ha*ma+(ja*ka+ga*na)-ia*la)*va;sa=-((ga*ha+ia*ja+ka*la-ma*na)*va)-(ha*ma+(ja*ka+ga*na)-ia*la)*ua-(ga*la+ja*ma+ia*na-ha*ka)*sa;ua=wa*qa+(sa*oa+(ga*ja-ha*ia-ka*na-la*ma)*Z)-ta*pa;va=ta*oa+((ga*ja-ha*ia-ka*na-la*ma)*wa+sa*pa)-Z*qa;wa=Z*pa+(sa*qa+(ga*ja-ha*ia-ka*na-la*ma)*ta)-wa*oa;g[b+476>>2]=ua;g[b+480>>2]=va;g[b+484>>2]=wa;g[b+488>>2]=0.0;g[b+496>>2]=1.0/(ua*(+g[f>>2]*ua+ +g[f+16>>2]*va+ +g[f+32>>2]*wa)+va*(ua*+g[f+4>>2]+va*+g[f+20>>2]+wa*+g[f+36>>2])+wa*(ua*+g[f+8>>2]+va*+g[f+24>>2]+wa*+g[f+40>>2])+(ua*(ua*+g[h>>2]+va*+g[h+16>>2]+wa*+g[h+32>>2])+va*(ua*+g[h+4>>2]+va*+g[h+20>>2]+wa*+g[h+36>>2])+wa*(ua*+g[h+8>>2]+va*+g[h+24>>2]+wa*+g[h+40>>2])))}if(!(a[b+526>>0]|0)){i=ra;return}qa=-o;wa=-m;sa=-n;pa=(_*ba-$*aa-ca*fa-da*ea)*qa+($*ea+(ba*ca+_*fa)-aa*da)*sa-(_*da+ba*ea+aa*fa-$*ca)*wa;va=(_*da+ba*ea+aa*fa-$*ca)*qa+(_*ba-$*aa-ca*fa-da*ea)*wa-(_*$+aa*ba+ca*da-ea*fa)*sa;ua=(_*$+aa*ba+ca*da-ea*fa)*wa+(_*ba-$*aa-ca*fa-da*ea)*sa-($*ea+(ba*ca+_*fa)-aa*da)*qa;sa=-((_*$+aa*ba+ca*da-ea*fa)*qa)-($*ea+(ba*ca+_*fa)-aa*da)*wa-(_*da+ba*ea+aa*fa-$*ca)*sa;wa=-(_*$+aa*ba+ca*da-ea*fa);qa=-($*ea+(ba*ca+_*fa)-aa*da);ta=-(_*da+ba*ea+aa*fa-$*ca);g[b+536>>2]=va*ta+(sa*wa+(_*ba-$*aa-ca*fa-da*ea)*pa)-ua*qa;g[b+540>>2]=ua*wa+((_*ba-$*aa-ca*fa-da*ea)*va+sa*qa)-pa*ta;g[b+544>>2]=pa*qa+(sa*ta+(_*ba-$*aa-ca*fa-da*ea)*ua)-va*wa;g[b+548>>2]=0.0;i=ra;return}function Jo(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,i=0,j=0;if(a[b+527>>0]|0){c[d>>2]=0;c[d+4>>2]=0;return}c[d>>2]=3;c[d+4>>2]=3;j=c[b+28>>2]|0;i=c[b+32>>2]|0;Io(b,j+4|0,i+4|0,j+288|0,i+288|0);if((a[b+526>>0]|0?(e=c[d>>2]|0,c[d>>2]=e+1,f=c[d+4>>2]|0,c[d+4>>2]=f+-1,h=+g[b+456>>2],+g[b+444>>2]<h):0)?+g[b+448>>2]<h:0){c[d>>2]=e+2;c[d+4>>2]=f+-2}if(!(a[b+525>>0]|0))return;c[d>>2]=(c[d>>2]|0)+1;c[d+4>>2]=(c[d+4>>2]|0)+-1;return}function Ko(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,i=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0;p=c[b+28>>2]|0;i=c[b+32>>2]|0;Io(b,p+4|0,i+4|0,p+288|0,i+288|0);r=c[d+8>>2]|0;g[r>>2]=1.0;q=c[d+24>>2]|0;g[r+(q+1<<2)>>2]=1.0;g[r+((q<<1)+2<<2)>>2]=1.0;m=+g[b+348>>2];v=+g[b+352>>2];o=+g[b+356>>2];t=+g[p+4>>2]*m+ +g[p+8>>2]*v+ +g[p+12>>2]*o;n=m*+g[p+20>>2]+v*+g[p+24>>2]+o*+g[p+28>>2];o=m*+g[p+36>>2]+v*+g[p+40>>2]+o*+g[p+44>>2];r=c[d+12>>2]|0;c[r>>2]=0;g[r+4>>2]=o;g[r+8>>2]=-n;g[r+12>>2]=0.0;g[r+(q<<2)>>2]=-o;c[r+(q<<2)+4>>2]=0;g[r+(q<<2)+8>>2]=t;g[r+(q<<2)+12>>2]=0.0;g[r+(q<<1<<2)>>2]=n;g[r+(q<<1<<2)+4>>2]=-t;c[r+(q<<1<<2)+8>>2]=0;g[r+(q<<1<<2)+12>>2]=0.0;r=c[d+16>>2]|0;g[r>>2]=-1.0;g[r+(q+1<<2)>>2]=-1.0;g[r+((q<<1)+2<<2)>>2]=-1.0;v=+g[b+412>>2];m=+g[b+416>>2];l=+g[b+420>>2];u=+g[i+4>>2]*v+ +g[i+8>>2]*m+ +g[i+12>>2]*l;k=v*+g[i+20>>2]+m*+g[i+24>>2]+l*+g[i+28>>2];l=v*+g[i+36>>2]+m*+g[i+40>>2]+l*+g[i+44>>2];q=c[d+20>>2]|0;r=c[d+24>>2]|0;c[q>>2]=0;g[q+4>>2]=-l;g[q+8>>2]=k;g[q+12>>2]=0.0;g[q+(r<<2)>>2]=l;c[q+(r<<2)+4>>2]=0;g[q+(r<<2)+8>>2]=-u;g[q+(r<<2)+12>>2]=0.0;g[q+(r<<1<<2)>>2]=-k;g[q+(r<<1<<2)+4>>2]=u;c[q+(r<<1<<2)+8>>2]=0;g[q+(r<<1<<2)+12>>2]=0.0;r=c[b+592>>2]|0;m=+g[((r&2|0)==0?d+4|0:b+600|0)>>2]*+g[d>>2];s=c[d+24>>2]|0;j=c[d+28>>2]|0;f=c[d+36>>2]|0;e=c[d+40>>2]|0;g[j>>2]=m*(u+ +g[i+52>>2]-t-+g[p+52>>2]);g[f>>2]=-3402823466385288598117041.0e14;g[e>>2]=3402823466385288598117041.0e14;if(!(r&1)){g[j+(s<<2)>>2]=m*(k+ +g[i+56>>2]-n-+g[p+56>>2]);g[f+(s<<2)>>2]=-3402823466385288598117041.0e14;g[e+(s<<2)>>2]=3402823466385288598117041.0e14;g[j+(s<<1<<2)>>2]=m*(l+ +g[i+60>>2]-o-+g[p+60>>2]);g[f+(s<<1<<2)>>2]=-3402823466385288598117041.0e14;g[e+(s<<1<<2)>>2]=3402823466385288598117041.0e14}else{w=c[d+32>>2]|0;c[w>>2]=c[b+596>>2];g[j+(s<<2)>>2]=m*(k+ +g[i+56>>2]-n-+g[p+56>>2]);g[f+(s<<2)>>2]=-3402823466385288598117041.0e14;g[e+(s<<2)>>2]=3402823466385288598117041.0e14;c[w+(s<<2)>>2]=c[b+596>>2];g[j+(s<<1<<2)>>2]=m*(l+ +g[i+60>>2]-o-+g[p+60>>2]);g[f+(s<<1<<2)>>2]=-3402823466385288598117041.0e14;g[e+(s<<1<<2)>>2]=3402823466385288598117041.0e14;c[w+(s<<1<<2)>>2]=c[b+596>>2]}do if(!(a[b+526>>0]|0))i=s*3|0;else{i=c[d+12>>2]|0;v=+g[b+456>>2];if(+g[b+444>>2]<v?+g[b+448>>2]<v:0){z=+g[p+4>>2];y=+g[p+8>>2];x=+g[p+12>>2];D=+g[b+304>>2];C=+g[b+320>>2];B=+g[b+336>>2];m=+g[b+308>>2];o=+g[b+324>>2];u=+g[b+340>>2];h=+g[p+20>>2];k=+g[p+24>>2];l=+g[p+28>>2];n=+g[p+36>>2];t=+g[p+40>>2];v=+g[p+44>>2];g[i+(s*3<<2)>>2]=z*D+y*C+x*B;g[i+((s*3|0)+1<<2)>>2]=D*h+C*k+B*l;g[i+((s*3|0)+2<<2)>>2]=D*n+C*t+B*v;g[i+(s<<2<<2)>>2]=z*m+y*o+x*u;g[i+((s<<2|1)<<2)>>2]=m*h+o*k+u*l;g[i+((s<<2|2)<<2)>>2]=m*n+o*t+u*v;g[q+(s*3<<2)>>2]=-(z*D+y*C+x*B);g[q+((s*3|0)+1<<2)>>2]=-(D*h+C*k+B*l);g[q+((s*3|0)+2<<2)>>2]=-(D*n+C*t+B*v);g[q+(s<<2<<2)>>2]=-(z*m+y*o+x*u);g[q+((s<<2|1)<<2)>>2]=-(m*h+o*k+u*l);g[q+((s<<2|2)<<2)>>2]=-(m*n+o*t+u*v);A=+g[d>>2]*+g[b+436>>2];j=c[d+28>>2]|0;g[j+(s*3<<2)>>2]=A*((z*D+y*C+x*B)*+g[b+460>>2]+(D*h+C*k+B*l)*+g[b+464>>2]+(D*n+C*t+B*v)*+g[b+468>>2]);g[j+(s<<2<<2)>>2]=A*((z*m+y*o+x*u)*+g[b+460>>2]+(m*h+o*k+u*l)*+g[b+464>>2]+(m*n+o*t+u*v)*+g[b+468>>2]);f=c[d+36>>2]|0;g[f+(s*3<<2)>>2]=-3402823466385288598117041.0e14;e=c[d+40>>2]|0;g[e+(s*3<<2)>>2]=3402823466385288598117041.0e14;g[f+(s<<2<<2)>>2]=-3402823466385288598117041.0e14;g[e+(s<<2<<2)>>2]=3402823466385288598117041.0e14;i=(c[d+24>>2]|0)+(s<<2)|0;break}D=+g[b+436>>2];B=D*(+g[b+460>>2]*D);C=D*(D*+g[b+464>>2]);D=D*(D*+g[b+468>>2]);g[i+(s*3<<2)>>2]=B;g[i+((s*3|0)+1<<2)>>2]=C;g[i+((s*3|0)+2<<2)>>2]=D;g[q+(s*3<<2)>>2]=-B;g[q+((s*3|0)+1<<2)>>2]=-C;g[q+((s*3|0)+2<<2)>>2]=-D;g[j+(s*3<<2)>>2]=+g[d>>2]*+g[b+432>>2]*+g[b+504>>2];if(r&4|0)c[(c[d+32>>2]|0)+(s*3<<2)>>2]=c[b+604>>2];g[f+(s*3<<2)>>2]=0.0;if(!((a[b+552>>0]|0)!=0?(h=+g[b+572>>2],h>=0.0):0))h=3402823466385288598117041.0e14;g[e+(s*3<<2)>>2]=h;i=s<<2}while(0);if(!(a[b+525>>0]|0))return;D=+g[b+436>>2];B=D*(+g[b+476>>2]*D);C=D*(D*+g[b+480>>2]);D=D*(D*+g[b+484>>2]);q=c[d+12>>2]|0;s=c[d+20>>2]|0;g[q+(i<<2)>>2]=B;r=i+1|0;g[q+(r<<2)>>2]=C;w=i+2|0;g[q+(w<<2)>>2]=D;g[s+(i<<2)>>2]=-B;g[s+(r<<2)>>2]=-C;g[s+(w<<2)>>2]=-D;g[j+(i<<2)>>2]=+g[d>>2]*+g[b+432>>2]*+g[b+508>>2];if(c[b+592>>2]&4|0)c[(c[d+32>>2]|0)+(i<<2)>>2]=c[b+604>>2];if(!(+g[b+452>>2]>0.0)){g[f+(i<<2)>>2]=-3402823466385288598117041.0e14;g[e+(i<<2)>>2]=3402823466385288598117041.0e14;return}f=f+(i<<2)|0;e=c[d+40>>2]|0;if(+g[b+508>>2]>0.0){g[f>>2]=0.0;g[e+(i<<2)>>2]=3402823466385288598117041.0e14;return}else{g[f>>2]=-3402823466385288598117041.0e14;g[e+(i<<2)>>2]=0.0;return}}function Lo(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0,s=0,t=0,u=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0,J=0,K=0,L=0,M=0,N=0,P=0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0;P=i;i=i+448|0;if(!(a[b+527>>0]|0)){i=P;return}N=c[b+28>>2]|0;x=+g[b+348>>2];w=+g[b+352>>2];D=+g[b+356>>2];y=+g[N+52>>2];z=x*+g[N+4>>2]+w*+g[N+8>>2]+D*+g[N+12>>2]+y;A=+g[N+56>>2];B=x*+g[N+20>>2]+w*+g[N+24>>2]+D*+g[N+28>>2]+A;C=+g[N+60>>2];D=x*+g[N+36>>2]+w*+g[N+40>>2]+D*+g[N+44>>2]+C;N=c[b+32>>2]|0;w=+g[b+412>>2];x=+g[b+416>>2];l=+g[b+420>>2];E=+g[N+52>>2];F=w*+g[N+4>>2]+x*+g[N+8>>2]+l*+g[N+12>>2]+E;G=+g[N+56>>2];H=w*+g[N+20>>2]+x*+g[N+24>>2]+l*+g[N+28>>2]+G;k=+g[N+60>>2];l=w*+g[N+36>>2]+x*+g[N+40>>2]+l*+g[N+44>>2]+k;if(!(a[b+524>>0]|0)){u=+g[d+192>>2]+ +g[d+80>>2];w=+g[d+196>>2]+ +g[d+84>>2];q=+g[d+200>>2]+ +g[d+88>>2];x=+g[e+192>>2]+ +g[e+80>>2];p=+g[e+196>>2]+ +g[e+84>>2];n=+g[e+200>>2]+ +g[e+88>>2];m=+g[d+176>>2]+ +g[d+64>>2]+((D-C)*w-(B-A)*q)-(+g[e+176>>2]+ +g[e+64>>2]+((l-k)*p-(H-G)*n));n=+g[d+180>>2]+ +g[d+68>>2]+((z-y)*q-(D-C)*u)-(+g[e+180>>2]+ +g[e+68>>2]+((F-E)*n-(l-k)*x));p=+g[d+184>>2]+ +g[d+72>>2]+((B-A)*u-(z-y)*w)-(+g[e+184>>2]+ +g[e+72>>2]+((H-G)*x-(F-E)*p));o=(c[d+240>>2]|0)==0;v=0;do{x=1.0/+g[b+48+(v*84|0)+80>>2];r=b+48+(v*84|0)|0;w=+g[r>>2];s=b+48+(v*84|0)+4|0;u=+g[s>>2];t=b+48+(v*84|0)+8|0;q=+g[t>>2];q=x*(((z-F)*w+(B-H)*u+(D-l)*q)*-.30000001192092896/f)-x*(m*w+n*u+p*q);g[b+36>>2]=+g[b+36>>2]+q;u=+g[t>>2];w=+g[s>>2];x=+g[r>>2];h=c[b+28>>2]|0;j=+g[h+368>>2];if(!o){S=((B-A)*u-(D-C)*w)*+g[h+320>>2]+((D-C)*x-(z-y)*u)*+g[h+324>>2]+((z-y)*w-(B-A)*x)*+g[h+328>>2];Q=((B-A)*u-(D-C)*w)*+g[h+304>>2]+((D-C)*x-(z-y)*u)*+g[h+308>>2]+((z-y)*w-(B-A)*x)*+g[h+312>>2];R=((B-A)*u-(D-C)*w)*+g[h+288>>2]+((D-C)*x-(z-y)*u)*+g[h+292>>2]+((z-y)*w-(B-A)*x)*+g[h+296>>2];U=q*(w*j)*+g[d+116>>2];T=q*(u*j)*+g[d+120>>2];g[d+64>>2]=q*(x*j)*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=U+ +g[d+68>>2];g[d+72>>2]=T+ +g[d+72>>2];Q=Q*(q*+g[d+100>>2]);j=S*(q*+g[d+104>>2]);g[d+80>>2]=R*(q*+g[d+96>>2])+ +g[d+80>>2];g[d+84>>2]=Q+ +g[d+84>>2];g[d+88>>2]=j+ +g[d+88>>2]}h=c[b+32>>2]|0;j=+g[h+368>>2];if(c[e+240>>2]|0){U=((H-G)*u-(l-k)*w)*+g[h+320>>2]+((l-k)*x-(F-E)*u)*+g[h+324>>2]+((F-E)*w-(H-G)*x)*+g[h+328>>2];T=((H-G)*u-(l-k)*w)*+g[h+304>>2]+((l-k)*x-(F-E)*u)*+g[h+308>>2]+((F-E)*w-(H-G)*x)*+g[h+312>>2];S=((H-G)*u-(l-k)*w)*+g[h+288>>2]+((l-k)*x-(F-E)*u)*+g[h+292>>2]+((F-E)*w-(H-G)*x)*+g[h+296>>2];Q=j*+g[s>>2]*-q*+g[e+116>>2];R=j*+g[t>>2]*-q*+g[e+120>>2];g[e+64>>2]=+g[e+112>>2]*(j*+g[r>>2]*-q)+ +g[e+64>>2];g[e+68>>2]=Q+ +g[e+68>>2];g[e+72>>2]=R+ +g[e+72>>2];T=T*(+g[e+100>>2]*-q);U=U*(+g[e+104>>2]*-q);g[e+80>>2]=S*(+g[e+96>>2]*-q)+ +g[e+80>>2];g[e+84>>2]=T+ +g[e+84>>2];g[e+88>>2]=U+ +g[e+88>>2]}v=v+1|0}while((v|0)!=3)}do if(!(a[b+552>>0]|0)){j=+g[b+440>>2];if(!(j>1.1920928955078125e-07)){I=d+80|0;o=d+196|0;J=d+84|0;r=d+200|0;K=d+88|0;s=e+192|0;L=e+80|0;t=e+196|0;M=e+84|0;v=e+200|0;N=e+88|0;h=d+192|0;break}k=+g[e+192>>2]+ +g[e+80>>2]-(+g[d+192>>2]+ +g[d+80>>2]);l=+g[e+196>>2]+ +g[e+84>>2]-(+g[d+196>>2]+ +g[d+84>>2]);m=+g[e+200>>2]+ +g[e+88>>2]-(+g[d+200>>2]+ +g[d+88>>2]);if(k*k+l*l+m*m>1.1920928955078125e-07){C=1.0/+O(+(k*k+l*l+m*m));h=c[b+28>>2]|0;p=+g[h+288>>2];q=+g[h+304>>2];u=+g[h+320>>2];w=+g[h+292>>2];x=+g[h+308>>2];y=+g[h+324>>2];z=+g[h+296>>2];A=+g[h+312>>2];B=+g[h+328>>2];h=c[b+32>>2]|0;j=j*(1.0/(k*C*(p*(k*C)+l*C*q+m*C*u)+l*C*(k*C*w+l*C*x+m*C*y)+m*C*(k*C*z+l*C*A+m*C*B)+(k*C*(k*C*+g[h+288>>2]+l*C*+g[h+304>>2]+m*C*+g[h+320>>2])+l*C*(k*C*+g[h+292>>2]+l*C*+g[h+308>>2]+m*C*+g[h+324>>2])+m*C*(k*C*+g[h+296>>2]+l*C*+g[h+312>>2]+m*C*+g[h+328>>2]))));C=+O(+(m*j*(m*j)+(k*j*(k*j)+l*j*(l*j))));n=1.0/C*(k*j);k=1.0/C*(l*j);j=1.0/C*(m*j);if(c[d+240>>2]|0){U=C*0.0*+g[d+116>>2];T=C*0.0*+g[d+120>>2];g[d+64>>2]=C*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=U+ +g[d+68>>2];g[d+72>>2]=T+ +g[d+72>>2];T=(n*q+k*x+j*A)*(C*+g[d+100>>2]);U=(n*u+k*y+j*B)*(C*+g[d+104>>2]);g[d+80>>2]=(n*p+k*w+j*z)*(C*+g[d+96>>2])+ +g[d+80>>2];g[d+84>>2]=T+ +g[d+84>>2];g[d+88>>2]=U+ +g[d+88>>2];h=c[b+32>>2]|0}if(c[e+240>>2]|0){U=n*+g[h+320>>2]+k*+g[h+324>>2]+j*+g[h+328>>2];T=n*+g[h+304>>2]+k*+g[h+308>>2]+j*+g[h+312>>2];S=n*+g[h+288>>2]+k*+g[h+292>>2]+j*+g[h+296>>2];Q=C*-0.0*+g[e+116>>2];R=C*-0.0*+g[e+120>>2];g[e+64>>2]=C*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=Q+ +g[e+68>>2];g[e+72>>2]=R+ +g[e+72>>2];T=T*(+g[e+100>>2]*-C);U=U*(+g[e+104>>2]*-C);g[e+80>>2]=S*(+g[e+96>>2]*-C)+ +g[e+80>>2];g[e+84>>2]=T+ +g[e+84>>2];g[e+88>>2]=U+ +g[e+88>>2];I=d+80|0;o=d+196|0;J=d+84|0;r=d+200|0;K=d+88|0;s=e+192|0;L=e+80|0;t=e+196|0;M=e+84|0;v=e+200|0;N=e+88|0;h=d+192|0}else{I=d+80|0;o=d+196|0;J=d+84|0;r=d+200|0;K=d+88|0;s=e+192|0;L=e+80|0;t=e+196|0;M=e+84|0;v=e+200|0;N=e+88|0;h=d+192|0}}else{I=d+80|0;o=d+196|0;J=d+84|0;r=d+200|0;K=d+88|0;s=e+192|0;L=e+80|0;t=e+196|0;M=e+84|0;v=e+200|0;N=e+88|0;h=d+192|0}}else{M=c[b+28>>2]|0;c[P+352>>2]=c[M+4>>2];c[P+352+4>>2]=c[M+4+4>>2];c[P+352+8>>2]=c[M+4+8>>2];c[P+352+12>>2]=c[M+4+12>>2];c[P+352+16>>2]=c[M+20>>2];c[P+352+16+4>>2]=c[M+20+4>>2];c[P+352+16+8>>2]=c[M+20+8>>2];c[P+352+16+12>>2]=c[M+20+12>>2];c[P+352+32>>2]=c[M+36>>2];c[P+352+32+4>>2]=c[M+36+4>>2];c[P+352+32+8>>2]=c[M+36+8>>2];c[P+352+32+12>>2]=c[M+36+12>>2];c[P+352+48>>2]=c[M+52>>2];c[P+352+48+4>>2]=c[M+52+4>>2];c[P+352+48+8>>2]=c[M+52+8>>2];c[P+352+48+12>>2]=c[M+52+12>>2];M=c[b+32>>2]|0;c[P+288>>2]=c[M+4>>2];c[P+288+4>>2]=c[M+4+4>>2];c[P+288+8>>2]=c[M+4+8>>2];c[P+288+12>>2]=c[M+4+12>>2];c[P+288+16>>2]=c[M+20>>2];c[P+288+16+4>>2]=c[M+20+4>>2];c[P+288+16+8>>2]=c[M+20+8>>2];c[P+288+16+12>>2]=c[M+20+12>>2];c[P+288+32>>2]=c[M+36>>2];c[P+288+32+4>>2]=c[M+36+4>>2];c[P+288+32+8>>2]=c[M+36+8>>2];c[P+288+32+12>>2]=c[M+36+12>>2];c[P+288+48>>2]=c[M+52>>2];c[P+288+48+4>>2]=c[M+52+4>>2];c[P+288+48+8>>2]=c[M+52+8>>2];c[P+288+48+12>>2]=c[M+52+12>>2];S=+g[d+196>>2]+ +g[d+84>>2];u=+g[d+200>>2]+ +g[d+88>>2];g[P+272>>2]=+g[d+192>>2]+ +g[d+80>>2];g[P+272+4>>2]=S;g[P+272+8>>2]=u;g[P+272+12>>2]=0.0;u=+g[e+196>>2]+ +g[e+84>>2];S=+g[e+200>>2]+ +g[e+88>>2];g[P+256>>2]=+g[e+192>>2]+ +g[e+80>>2];g[P+256+4>>2]=u;g[P+256+8>>2]=S;g[P+256+12>>2]=0.0;c[P+192>>2]=1065353216;M=P+192+4|0;c[M>>2]=0;c[M+4>>2]=0;c[M+8>>2]=0;c[M+12>>2]=0;c[P+192+20>>2]=1065353216;N=P+192+24|0;c[N>>2]=0;c[N+4>>2]=0;c[N+8>>2]=0;c[N+12>>2]=0;c[P+192+40>>2]=1065353216;K=P+192+44|0;c[K>>2]=0;c[K+4>>2]=0;c[K+8>>2]=0;c[K+12>>2]=0;c[K+16>>2]=0;xn(P+352|0,0.0,0.0,0.0,P+272|0,f,P+192|0);c[P+128>>2]=1065353216;K=P+128+4|0;c[K>>2]=0;c[K+4>>2]=0;c[K+8>>2]=0;c[K+12>>2]=0;c[P+128+20>>2]=1065353216;L=P+128+24|0;c[L>>2]=0;c[L+4>>2]=0;c[L+8>>2]=0;c[L+12>>2]=0;c[P+128+40>>2]=1065353216;J=P+128+44|0;c[J>>2]=0;c[J+4>>2]=0;c[J+8>>2]=0;c[J+12>>2]=0;c[J+16>>2]=0;xn(P+288|0,0.0,0.0,0.0,P+256|0,f,P+128|0);S=+g[b+556>>2];u=+g[b+560>>2];T=+g[b+564>>2];w=+g[b+568>>2];F=S*(2.0/(S*S+u*u+T*T+w*w));A=u*(2.0/(S*S+u*u+T*T+w*w));G=T*(2.0/(S*S+u*u+T*T+w*w));W=+g[b+364>>2];V=+g[b+368>>2];Z=+g[b+372>>2];k=Z*(S*G-w*A)+(V*(S*A+w*G)+W*(1.0-(u*A+T*G)));l=Z*(u*G+w*F)+(W*(S*A-w*G)+V*(1.0-(S*F+T*G)));m=W*(S*G+w*A)+V*(u*G-w*F)+Z*(1.0-(S*F+u*A));j=+g[b+380>>2];E=+g[b+384>>2];B=+g[b+388>>2];n=(S*G-w*A)*B+(E*(S*A+w*G)+j*(1.0-(u*A+T*G)));p=(u*G+w*F)*B+(j*(S*A-w*G)+E*(1.0-(S*F+T*G)));q=j*(S*G+w*A)+E*(u*G-w*F)+B*(1.0-(S*F+u*A));Q=+g[b+396>>2];C=+g[b+400>>2];z=+g[b+404>>2];R=(1.0-(u*A+T*G))*Q+(S*A+w*G)*C+(S*G-w*A)*z;T=(S*A-w*G)*Q+(1.0-(S*F+T*G))*C+(u*G+w*F)*z;A=(S*G+w*A)*Q+(u*G-w*F)*C+(1.0-(S*F+u*A))*z;u=+g[b+300>>2];F=+g[b+316>>2];S=+g[b+332>>2];w=+g[b+304>>2];G=+g[b+320>>2];U=+g[b+336>>2];D=+g[b+308>>2];H=+g[b+324>>2];y=+g[b+340>>2];x=-+g[b+348>>2];aa=-+g[b+352>>2];Y=-+g[b+356>>2];Z=W*0.0+V*0.0+Z*0.0+ +g[b+412>>2]+(m*(D*x+H*aa+y*Y)+(k*(u*x+F*aa+S*Y)+l*(w*x+G*aa+U*Y)));B=j*0.0+E*0.0+B*0.0+ +g[b+416>>2]+(q*(D*x+H*aa+y*Y)+(n*(u*x+F*aa+S*Y)+p*(w*x+G*aa+U*Y)));Y=Q*0.0+C*0.0+z*0.0+ +g[b+420>>2]+(A*(D*x+H*aa+y*Y)+(R*(u*x+F*aa+S*Y)+T*(w*x+G*aa+U*Y)));aa=+g[P+128>>2];x=+g[K>>2];z=+g[P+128+8>>2];C=+g[P+128+16>>2];Q=+g[P+128+20>>2];E=+g[L>>2];j=+g[P+128+32>>2];V=+g[P+128+36>>2];W=+g[P+128+40>>2];X=z*Y+(aa*Z+x*B)+ +g[P+128+48>>2];_=C*Z+B*Q+Y*E+ +g[P+128+52>>2];$=Z*j+B*V+Y*W+ +g[P+128+56>>2];g[P+64>>2]=(k*u+l*w+m*D)*aa+(n*u+p*w+q*D)*x+(R*u+T*w+A*D)*z;g[P+64+4>>2]=(k*F+l*G+m*H)*aa+(n*F+p*G+q*H)*x+(R*F+T*G+A*H)*z;g[P+64+8>>2]=(k*S+l*U+m*y)*aa+(n*S+p*U+q*y)*x+(R*S+T*U+A*y)*z;g[P+64+12>>2]=0.0;g[P+64+16>>2]=(k*u+l*w+m*D)*C+(n*u+p*w+q*D)*Q+(R*u+T*w+A*D)*E;g[P+64+20>>2]=(k*F+l*G+m*H)*C+(n*F+p*G+q*H)*Q+(R*F+T*G+A*H)*E;g[P+64+24>>2]=(k*S+l*U+m*y)*C+(n*S+p*U+q*y)*Q+(R*S+T*U+A*y)*E;g[P+64+28>>2]=0.0;g[P+64+32>>2]=(k*u+l*w+m*D)*j+(n*u+p*w+q*D)*V+(R*u+T*w+A*D)*W;g[P+64+36>>2]=(k*F+l*G+m*H)*j+(n*F+p*G+q*H)*V+(R*F+T*G+A*H)*W;g[P+64+40>>2]=(k*S+l*U+m*y)*j+(n*S+p*U+q*y)*V+(R*S+T*U+A*y)*W;g[P+64+44>>2]=0.0;g[P+64+48>>2]=X;g[P+64+52>>2]=_;g[P+64+56>>2]=$;g[P+64+60>>2]=0.0;$=(R*u+T*w+A*D)*-Y+((k*u+l*w+m*D)*-Z+(n*u+p*w+q*D)*-B);_=(R*F+T*G+A*H)*-Y+((k*F+l*G+m*H)*-Z+(n*F+p*G+q*H)*-B);B=(R*S+T*U+A*y)*-Y+((k*S+l*U+m*y)*-Z+(n*S+p*U+q*y)*-B);Z=+g[P+192>>2];Y=+g[M>>2];X=+g[P+192+8>>2];W=+g[P+192+16>>2];V=+g[P+192+20>>2];j=+g[N>>2];E=+g[P+192+32>>2];Q=+g[P+192+36>>2];C=+g[P+192+40>>2];z=$*Z+_*Y+B*X+ +g[P+192+48>>2];x=$*W+_*V+B*j+ +g[P+192+52>>2];B=$*E+_*Q+B*C+ +g[P+192+56>>2];g[P>>2]=(k*u+l*w+m*D)*Z+(k*F+l*G+m*H)*Y+(k*S+l*U+m*y)*X;g[P+4>>2]=(n*u+p*w+q*D)*Z+(n*F+p*G+q*H)*Y+(n*S+p*U+q*y)*X;g[P+8>>2]=(R*u+T*w+A*D)*Z+(R*F+T*G+A*H)*Y+(R*S+T*U+A*y)*X;g[P+12>>2]=0.0;g[P+16>>2]=(k*u+l*w+m*D)*W+(k*F+l*G+m*H)*V+(k*S+l*U+m*y)*j;g[P+20>>2]=(n*u+p*w+q*D)*W+(n*F+p*G+q*H)*V+(n*S+p*U+q*y)*j;g[P+24>>2]=(R*u+T*w+A*D)*W+(R*F+T*G+A*H)*V+(R*S+T*U+A*y)*j;g[P+28>>2]=0.0;g[P+32>>2]=(k*u+l*w+m*D)*E+(k*F+l*G+m*H)*Q+(k*S+l*U+m*y)*C;g[P+36>>2]=(n*u+p*w+q*D)*E+(n*F+p*G+q*H)*Q+(n*S+p*U+q*y)*C;g[P+40>>2]=(R*u+T*w+A*D)*E+(R*F+T*G+A*H)*Q+(R*S+T*U+A*y)*C;g[P+44>>2]=0.0;g[P+48>>2]=z;g[P+52>>2]=x;g[P+56>>2]=B;g[P+60>>2]=0.0;Zf(P+352|0,P+64|0,P+424|0,P+416|0);B=+g[P+416>>2];x=1.0/f*(+g[P+424>>2]*B);z=1.0/f*(B*+g[P+424+4>>2]);B=1.0/f*(B*+g[P+424+8>>2]);Zf(P+288|0,P,P+424|0,P+416|0);C=+g[P+416>>2];x=x-+g[P+272>>2];z=z-+g[P+272+4>>2];B=B-+g[P+272+8>>2];y=1.0/f*(+g[P+424>>2]*C)-+g[P+256>>2];A=1.0/f*(C*+g[P+424+4>>2])-+g[P+256+4>>2];C=1.0/f*(C*+g[P+424+8>>2])-+g[P+256+8>>2];if(x*x+z*z+B*B>1.1920928955078125e-07){q=1.0/+O(+(x*x+z*z+B*B));N=c[b+28>>2]|0;j=x*q;l=z*q;n=B*q;q=x*q*(+g[N+288>>2]*(x*q)+z*q*+g[N+304>>2]+B*q*+g[N+320>>2])+z*q*(x*q*+g[N+292>>2]+z*q*+g[N+308>>2]+B*q*+g[N+324>>2])+B*q*(x*q*+g[N+296>>2]+z*q*+g[N+312>>2]+B*q*+g[N+328>>2])}else{j=0.0;l=0.0;n=0.0;q=0.0}if(y*y+A*A+C*C>1.1920928955078125e-07){u=1.0/+O(+(y*y+A*A+C*C));N=c[b+32>>2]|0;k=y*u;m=A*u;p=C*u;u=y*u*(+g[N+288>>2]*(y*u)+A*u*+g[N+304>>2]+C*u*+g[N+320>>2])+A*u*(y*u*+g[N+292>>2]+A*u*+g[N+308>>2]+C*u*+g[N+324>>2])+C*u*(y*u*+g[N+296>>2]+A*u*+g[N+312>>2]+C*u*+g[N+328>>2])}else{k=0.0;m=0.0;p=0.0;u=0.0}w=q*j+u*k;k=q*l+u*m;j=q*n+u*p;if(w*w+k*k+j*j>1.1920928955078125e-07){n=1.0/+O(+(w*w+k*k+j*j));o=c[b+28>>2]|0;l=w*n*(+g[o+288>>2]*(w*n)+k*n*+g[o+304>>2]+j*n*+g[o+320>>2])+k*n*(w*n*+g[o+292>>2]+k*n*+g[o+308>>2]+j*n*+g[o+324>>2])+j*n*(w*n*+g[o+296>>2]+k*n*+g[o+312>>2]+j*n*+g[o+328>>2]);h=c[b+32>>2]|0;n=w*n*(w*n*+g[h+288>>2]+k*n*+g[h+304>>2]+j*n*+g[h+320>>2])+k*n*(w*n*+g[h+292>>2]+k*n*+g[h+308>>2]+j*n*+g[h+324>>2])+j*n*(w*n*+g[h+296>>2]+k*n*+g[h+312>>2]+j*n*+g[h+328>>2]);k=(x*l-y*n)*(1.0/((l+n)*(l+n)));u=(z*l-A*n)*(1.0/((l+n)*(l+n)));n=(B*l-C*n)*(1.0/((l+n)*(l+n)));j=+g[b+572>>2];if(!(j>=0.0))j=u;else{l=(a[b+553>>0]|0)==0?j:j/l;m=+g[b+576>>2];p=+g[b+580>>2];q=+g[b+584>>2];j=+O(+((k+m)*(k+m)+(u+p)*(u+p)+(n+q)*(n+q)));if(j>l){k=l*((k+m)*(1.0/j))-m;n=l*((n+q)*(1.0/j))-q;j=l*((u+p)*(1.0/j))-p}else j=u;g[b+576>>2]=k+m;g[b+580>>2]=j+p;g[b+584>>2]=n+q}m=+O(+(k*k+j*j+n*n));l=k*(1.0/m);k=j*(1.0/m);j=n*(1.0/m);if(c[d+240>>2]|0){aa=l*+g[o+320>>2]+k*+g[o+324>>2]+j*+g[o+328>>2];$=l*+g[o+304>>2]+k*+g[o+308>>2]+j*+g[o+312>>2];_=l*+g[o+288>>2]+k*+g[o+292>>2]+j*+g[o+296>>2];Y=m*0.0*+g[d+116>>2];Z=m*0.0*+g[d+120>>2];g[d+64>>2]=m*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=Y+ +g[d+68>>2];g[d+72>>2]=Z+ +g[d+72>>2];$=$*(m*+g[d+100>>2]);aa=aa*(m*+g[d+104>>2]);g[d+80>>2]=_*(m*+g[d+96>>2])+ +g[d+80>>2];g[d+84>>2]=$+ +g[d+84>>2];g[d+88>>2]=aa+ +g[d+88>>2];h=c[b+32>>2]|0}if(c[e+240>>2]|0){aa=l*+g[h+320>>2]+k*+g[h+324>>2]+j*+g[h+328>>2];$=l*+g[h+304>>2]+k*+g[h+308>>2]+j*+g[h+312>>2];_=l*+g[h+288>>2]+k*+g[h+292>>2]+j*+g[h+296>>2];Y=m*-0.0*+g[e+116>>2];Z=m*-0.0*+g[e+120>>2];g[e+64>>2]=m*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=Y+ +g[e+68>>2];g[e+72>>2]=Z+ +g[e+72>>2];$=$*(+g[e+100>>2]*-m);aa=aa*(+g[e+104>>2]*-m);g[e+80>>2]=_*(+g[e+96>>2]*-m)+ +g[e+80>>2];g[e+84>>2]=$+ +g[e+84>>2];g[e+88>>2]=aa+ +g[e+88>>2]}}I=d+80|0;o=d+196|0;J=d+84|0;r=d+200|0;K=d+88|0;s=e+192|0;L=e+80|0;t=e+196|0;M=e+84|0;v=e+200|0;N=e+88|0;h=d+192|0}while(0);z=+g[h>>2]+ +g[I>>2];y=+g[o>>2]+ +g[J>>2];x=+g[r>>2]+ +g[K>>2];w=+g[s>>2]+ +g[L>>2];u=+g[t>>2]+ +g[M>>2];q=+g[v>>2]+ +g[N>>2];if(a[b+526>>0]|0){k=+g[b+528>>2];j=k*+g[b+504>>2]*+g[b+432>>2]/f;l=+g[b+460>>2];m=+g[b+464>>2];n=+g[b+468>>2];if((w-z)*l+(u-y)*m+(q-x)*n>0.0)j=j+k*((w-z)*l+(u-y)*m+(q-x)*n)*+g[b+436>>2];$=+g[b+516>>2];_=$+j*+g[b+492>>2];_=_>0.0?_:0.0;g[b+516>>2]=_;Z=+g[b+536>>2];k=+g[b+540>>2];aa=+g[b+544>>2];j=l*(_-$)*Z+m*(_-$)*k+(_-$)*n*aa;p=+O(+(((_-$)*n-aa*j)*((_-$)*n-aa*j)+((l*(_-$)-Z*j)*(l*(_-$)-Z*j)+(m*(_-$)-k*j)*(m*(_-$)-k*j))));l=1.0/p*(l*(_-$)-Z*j);k=1.0/p*(m*(_-$)-k*j);j=1.0/p*((_-$)*n-aa*j);h=c[b+28>>2]|0;if(c[d+240>>2]|0){aa=l*+g[h+320>>2]+k*+g[h+324>>2]+j*+g[h+328>>2];$=l*+g[h+304>>2]+k*+g[h+308>>2]+j*+g[h+312>>2];_=l*+g[h+288>>2]+k*+g[h+292>>2]+j*+g[h+296>>2];Y=p*0.0*+g[d+116>>2];Z=p*0.0*+g[d+120>>2];g[d+64>>2]=p*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=Y+ +g[d+68>>2];g[d+72>>2]=Z+ +g[d+72>>2];$=$*(p*+g[d+100>>2]);aa=aa*(p*+g[d+104>>2]);g[I>>2]=_*(p*+g[d+96>>2])+ +g[I>>2];g[J>>2]=$+ +g[J>>2];g[K>>2]=aa+ +g[K>>2]}h=c[b+32>>2]|0;if(c[e+240>>2]|0){aa=l*+g[h+320>>2]+k*+g[h+324>>2]+j*+g[h+328>>2];$=l*+g[h+304>>2]+k*+g[h+308>>2]+j*+g[h+312>>2];_=l*+g[h+288>>2]+k*+g[h+292>>2]+j*+g[h+296>>2];Y=p*-0.0*+g[e+116>>2];Z=p*-0.0*+g[e+120>>2];g[e+64>>2]=p*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=Y+ +g[e+68>>2];g[e+72>>2]=Z+ +g[e+72>>2];$=$*(+g[e+100>>2]*-p);aa=aa*(+g[e+104>>2]*-p);g[L>>2]=_*(+g[e+96>>2]*-p)+ +g[L>>2];g[M>>2]=$+ +g[M>>2];g[N>>2]=aa+ +g[N>>2]}}if(!(a[b+525>>0]|0)){i=P;return}n=+g[b+532>>2];m=n*+g[b+508>>2]*+g[b+432>>2]/f;l=+g[b+476>>2];k=+g[b+480>>2];j=+g[b+484>>2];if((w-z)*l+(u-y)*k+(q-x)*j>0.0)m=m+n*((w-z)*l+(u-y)*k+(q-x)*j)*+g[b+436>>2];n=+g[b+520>>2];m=n+m*+g[b+496>>2];m=m>0.0?m:0.0;g[b+520>>2]=m;h=c[b+28>>2]|0;if(c[d+240>>2]|0){aa=l*+g[h+320>>2]+k*+g[h+324>>2]+j*+g[h+328>>2];$=l*+g[h+304>>2]+k*+g[h+308>>2]+j*+g[h+312>>2];j=l*+g[h+288>>2]+k*+g[h+292>>2]+j*+g[h+296>>2];l=(m-n)*0.0*+g[d+116>>2];k=(m-n)*0.0*+g[d+120>>2];g[d+64>>2]=(m-n)*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=l+ +g[d+68>>2];g[d+72>>2]=k+ +g[d+72>>2];k=$*((m-n)*+g[d+100>>2]);l=aa*((m-n)*+g[d+104>>2]);g[I>>2]=j*((m-n)*+g[d+96>>2])+ +g[I>>2];g[J>>2]=k+ +g[J>>2];g[K>>2]=l+ +g[K>>2];l=+g[b+476>>2];k=+g[b+480>>2];j=+g[b+484>>2]}h=c[b+32>>2]|0;if(!(c[e+240>>2]|0)){i=P;return}aa=l*+g[h+320>>2]+k*+g[h+324>>2]+j*+g[h+328>>2];$=l*+g[h+304>>2]+k*+g[h+308>>2]+j*+g[h+312>>2];_=l*+g[h+288>>2]+k*+g[h+292>>2]+j*+g[h+296>>2];Y=(m-n)*-0.0*+g[e+116>>2];Z=(m-n)*-0.0*+g[e+120>>2];g[e+64>>2]=(m-n)*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=Y+ +g[e+68>>2];g[e+72>>2]=Z+ +g[e+72>>2];$=$*(+g[e+100>>2]*-(m-n));aa=aa*(+g[e+104>>2]*-(m-n));g[L>>2]=_*(+g[e+96>>2]*-(m-n))+ +g[L>>2];g[M>>2]=$+ +g[M>>2];g[N>>2]=aa+ +g[N>>2];i=P;return}function Mo(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;switch(b|0){case 2:case 1:if(e>>>0<3){g[a+600>>2]=d;c[a+592>>2]=c[a+592>>2]|2;return}else{g[a+432>>2]=d;return}case 4:case 3:if(e>>>0<3){g[a+596>>2]=d;c[a+592>>2]=c[a+592>>2]|1;return}else{g[a+604>>2]=d;c[a+592>>2]=c[a+592>>2]|4;return}default:return}}function No(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0;a:do switch(b|0){case 2:case 1:{if(c>>>0<3){d=+g[a+600>>2];break a}if((c+-3|0)>>>0<3)d=+g[a+432>>2];else d=0.0;break}case 4:case 3:{if(c>>>0<3){d=+g[a+596>>2];break a}if((c+-3|0)>>>0<3)d=+g[a+604>>2];else d=0.0;break}default:d=0.0}while(0);return +d}function Oo(a){a=a|0;return 212}function Po(a,b,d){a=a|0;b=b|0;d=d|0;Aq(a,b,d)|0;c[b+52>>2]=c[a+300>>2];c[b+56>>2]=c[a+304>>2];c[b+60>>2]=c[a+308>>2];c[b+64>>2]=c[a+312>>2];c[b+68>>2]=c[a+316>>2];c[b+72>>2]=c[a+320>>2];c[b+76>>2]=c[a+324>>2];c[b+80>>2]=c[a+328>>2];c[b+84>>2]=c[a+332>>2];c[b+88>>2]=c[a+336>>2];c[b+92>>2]=c[a+340>>2];c[b+96>>2]=c[a+344>>2];c[b+100>>2]=c[a+348>>2];c[b+104>>2]=c[a+352>>2];c[b+108>>2]=c[a+356>>2];c[b+112>>2]=c[a+360>>2];c[b+116>>2]=c[a+364>>2];c[b+120>>2]=c[a+368>>2];c[b+124>>2]=c[a+372>>2];c[b+128>>2]=c[a+376>>2];c[b+132>>2]=c[a+380>>2];c[b+136>>2]=c[a+384>>2];c[b+140>>2]=c[a+388>>2];c[b+144>>2]=c[a+392>>2];c[b+148>>2]=c[a+396>>2];c[b+152>>2]=c[a+400>>2];c[b+156>>2]=c[a+404>>2];c[b+160>>2]=c[a+408>>2];c[b+164>>2]=c[a+412>>2];c[b+168>>2]=c[a+416>>2];c[b+172>>2]=c[a+420>>2];c[b+176>>2]=c[a+424>>2];c[b+180>>2]=c[a+444>>2];c[b+184>>2]=c[a+448>>2];c[b+188>>2]=c[a+452>>2];c[b+192>>2]=c[a+428>>2];c[b+196>>2]=c[a+432>>2];c[b+200>>2]=c[a+436>>2];c[b+204>>2]=c[a+440>>2];return 15142}function Qo(a,b,d){a=a|0;b=b|0;d=d|0;c[a+300>>2]=c[b>>2];c[a+300+4>>2]=c[b+4>>2];c[a+300+8>>2]=c[b+8>>2];c[a+300+12>>2]=c[b+12>>2];c[a+316>>2]=c[b+16>>2];c[a+316+4>>2]=c[b+16+4>>2];c[a+316+8>>2]=c[b+16+8>>2];c[a+316+12>>2]=c[b+16+12>>2];c[a+332>>2]=c[b+32>>2];c[a+332+4>>2]=c[b+32+4>>2];c[a+332+8>>2]=c[b+32+8>>2];c[a+332+12>>2]=c[b+32+12>>2];c[a+348>>2]=c[b+48>>2];c[a+348+4>>2]=c[b+48+4>>2];c[a+348+8>>2]=c[b+48+8>>2];c[a+348+12>>2]=c[b+48+12>>2];c[a+364>>2]=c[d>>2];c[a+364+4>>2]=c[d+4>>2];c[a+364+8>>2]=c[d+8>>2];c[a+364+12>>2]=c[d+12>>2];c[a+380>>2]=c[d+16>>2];c[a+380+4>>2]=c[d+16+4>>2];c[a+380+8>>2]=c[d+16+8>>2];c[a+380+12>>2]=c[d+16+12>>2];c[a+396>>2]=c[d+32>>2];c[a+396+4>>2]=c[d+32+4>>2];c[a+396+8>>2]=c[d+32+8>>2];c[a+396+12>>2]=c[d+32+12>>2];c[a+412>>2]=c[d+48>>2];c[a+412+4>>2]=c[d+48+4>>2];c[a+412+8>>2]=c[d+48+8>>2];c[a+412+12>>2]=c[d+48+12>>2];rb[c[(c[a>>2]|0)+8>>2]&255](a);return}function Ro(){c[5310]=1065353216;c[5311]=0;c[5312]=0;g[5313]=0.0;return}function So(a,b,d,e){a=a|0;b=b|0;d=+d;e=+e;var f=0,h=0.0,i=0.0,j=0.0,l=0,m=0.0,n=0.0,o=0.0;j=+Q(+d);i=+R(+d);f=c[b+444>>2]|0;l=+N(+j)>1.1920928955078125e-07;d=(c[k>>2]=f,+g[k>>2]);if(l){m=+g[b+448>>2];m=+O(+((i*i/(j*j)+1.0)/(1.0/(m*m)+i*i/(j*j)/(d*d))));d=i*i;h=j*j;f=(g[k>>2]=m,c[k>>2]|0)}else{d=i*i;h=j*j}m=+O(+(h+0.0+d));n=(c[k>>2]=f,+g[k>>2])*.5;m=+R(+n)/m;n=+Q(+n);o=n*e+j*m*0.0-i*m*-0.0;h=n*0.0-i*m*e-m*0.0*0.0;d=n*0.0+m*0.0*0.0-j*m*e;e=-(m*0.0*e)-j*m*0.0-i*m*-0.0;g[a>>2]=i*m*h+(n*o+e*-(m*0.0))-d*-(j*m);g[a+4>>2]=d*-(m*0.0)+(n*h+e*-(j*m))-i*m*o;g[a+8>>2]=o*-(j*m)+(i*m*e+n*d)-h*-(m*0.0);g[a+12>>2]=0.0;return}function To(a,b){a=a|0;b=b|0;var d=0.0,e=0,f=0.0,h=0,i=0.0,j=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0.0,y=0,z=0.0,A=0.0,B=0.0,C=0.0;c[a+556>>2]=c[b>>2];c[a+556+4>>2]=c[b+4>>2];c[a+556+8>>2]=c[b+8>>2];c[a+556+12>>2]=c[b+12>>2];s=+g[a+568>>2];j=+g[5310];t=+g[a+560>>2];f=+g[5312];q=+g[a+564>>2];i=+g[5311];r=+g[a+556>>2];l=(j*q+s*i-f*r)*-q+(s*(s*j+t*f-q*i)+(-(j*r)-t*i-f*q)*-r)-(s*f+i*r-j*t)*-t;m=(s*f+i*r-j*t)*-r+(s*(j*q+s*i-f*r)+(-(j*r)-t*i-f*q)*-t)-(s*j+t*f-q*i)*-q;d=(s*j+t*f-q*i)*-t+((-(j*r)-t*i-f*q)*-q+s*(s*f+i*r-j*t))-(j*q+s*i-f*r)*-r;do if(f*d+(i*m+j*l)<-.9999998807907104)if(+N(+f)>.7071067690849304){d=1.0/+O(+(f*f+i*i));e=0;f=-(f*d);b=(g[k>>2]=i*d,c[k>>2]|0);d=0.0;break}else{f=1.0/+O(+(j*j+i*i));e=(g[k>>2]=-(i*f),c[k>>2]|0);f=j*f;b=0;d=0.0;break}else{C=+O(+((f*d+(i*m+j*l)+1.0)*2.0));e=(g[k>>2]=(i*d-f*m)*(1.0/C),c[k>>2]|0);f=(f*l-j*d)*(1.0/C);b=(g[k>>2]=(j*m-i*l)*(1.0/C),c[k>>2]|0);d=C*.5}while(0);j=(c[k>>2]=e,+g[k>>2]);m=(c[k>>2]=b,+g[k>>2]);u=1.0/+O(+(d*d+(j*j+f*f+m*m)));o=(g[k>>2]=j*u,c[k>>2]|0);x=f*u;w=(g[k>>2]=m*u,c[k>>2]|0);d=d*u;v=(g[k>>2]=d,c[k>>2]|0);A=r*d+s*-(j*u)+q*-x-t*-(m*u);B=r*-(m*u)+(s*-x+d*t)-q*-(j*u);C=s*-(m*u)+d*q+t*-(j*u)-r*-x;q=d*s-r*-(j*u)-t*-x-q*-(m*u);r=1.0/+O(+(q*q+(C*C+(A*A+B*B))));h=(g[k>>2]=A*r,c[k>>2]|0);b=(g[k>>2]=r*B,c[k>>2]|0);e=(g[k>>2]=r*C,c[k>>2]|0);f=+g[a+444>>2];n=(g[k>>2]=f,c[k>>2]|0);if(f>=.05000000074505806?(z=+g[a+448>>2],z>=.05000000074505806):0){d=d<-1.0?-1.0:d;d=+T(+(d>1.0?1.0:d))*2.0;if(d>1.1920928955078125e-07){i=1.0/+O(+(m*u*(m*u)+(j*u*(j*u)+x*x)));if(+N(+(x*i))>1.1920928955078125e-07){z=+O(+((m*u*i*(m*u*i)/(x*i*(x*i))+1.0)/(1.0/(z*z)+m*u*i*(m*u*i)/(x*i*(x*i))/(f*f))));j=j*u*i;l=x*i;i=m*u*i;n=(g[k>>2]=z,c[k>>2]|0)}else{j=j*u*i;l=x*i;i=m*u*i}}else{j=0.0;l=0.0;i=0.0;n=0}if(+N(+d)>1.1920928955078125e-07){f=(c[k>>2]=n,+g[k>>2]);if(!(d>f)){if(d<-f)d=-f}else d=f;z=d*.5;x=+R(+z)/+O(+(j*j+l*l+i*i));z=+Q(+z);y=(g[k>>2]=j*x,c[k>>2]|0);w=(g[k>>2]=i*x,c[k>>2]|0);x=l*x;v=(g[k>>2]=z,c[k>>2]|0)}else y=o}else y=o;d=+g[a+452>>2];if(d>=.05000000074505806){f=r*q<-1.0?-1.0:r*q;f=+T(+(f>1.0?1.0:f))*2.0;if(f>3.1415927410125732){p=(g[k>>2]=-(A*r),c[k>>2]|0);o=(g[k>>2]=-(r*B),c[k>>2]|0);f=-(r*q)<-1.0?-1.0:-(r*q);n=(g[k>>2]=-(r*C),c[k>>2]|0);f=+T(+(f>1.0?1.0:f))*2.0}else{p=h;o=b;n=e}i=(c[k>>2]=p,+g[k>>2]);j=(c[k>>2]=o,+g[k>>2]);l=(c[k>>2]=n,+g[k>>2]);if(f>1.1920928955078125e-07){C=1.0/+O(+(i*i+j*j+l*l));p=(g[k>>2]=i*C,c[k>>2]|0);o=(g[k>>2]=j*C,c[k>>2]|0);n=(g[k>>2]=l*C,c[k>>2]|0)}if(+N(+f)>1.1920928955078125e-07){if(!(f>d))if(f<-d)d=-d;else d=f;z=(c[k>>2]=p,+g[k>>2]);A=(c[k>>2]=o,+g[k>>2]);B=(c[k>>2]=n,+g[k>>2]);d=d*.5;C=+R(+d)/+O(+(B*B+(A*A+z*z)));d=+Q(+d);h=(g[k>>2]=z*C,c[k>>2]|0);b=(g[k>>2]=A*C,c[k>>2]|0);e=(g[k>>2]=B*C,c[k>>2]|0)}else d=r*q}else d=r*q;t=(c[k>>2]=v,+g[k>>2]);z=(c[k>>2]=h,+g[k>>2]);u=(c[k>>2]=y,+g[k>>2]);C=(c[k>>2]=e,+g[k>>2]);B=(c[k>>2]=w,+g[k>>2]);A=(c[k>>2]=b,+g[k>>2]);g[a+556>>2]=x*C+(t*z+u*d)-B*A;g[a+560>>2]=B*z+(t*A+x*d)-u*C;g[a+564>>2]=u*A+(t*C+B*d)-x*z;g[a+568>>2]=t*d-u*z-x*A-B*C;return}function Uo(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;d=+g[a+368>>2];if(!(d!=0.0))return;h=+g[a+372>>2];j=+g[a+376>>2];k=+g[a+380>>2];l=d*(+g[b+4>>2]*j);f=d*(+g[b+8>>2]*k);g[a+336>>2]=d*(+g[b>>2]*h)+ +g[a+336>>2];g[a+340>>2]=l+ +g[a+340>>2];g[a+344>>2]=f+ +g[a+344>>2];h=+g[b>>2]*h;j=+g[b+4>>2]*j;k=+g[b+8>>2]*k;f=+g[c+4>>2];l=+g[c+8>>2];i=+g[c>>2];e=((f*k-j*l)*+g[a+304>>2]+(h*l-k*i)*+g[a+308>>2]+(j*i-h*f)*+g[a+312>>2])*+g[a+572>>2];d=((f*k-j*l)*+g[a+320>>2]+(h*l-k*i)*+g[a+324>>2]+(j*i-h*f)*+g[a+328>>2])*+g[a+576>>2];g[a+352>>2]=(+g[a+288>>2]*(f*k-j*l)+ +g[a+292>>2]*(h*l-k*i)+(j*i-h*f)*+g[a+296>>2])*+g[a+568>>2]+ +g[a+352>>2];g[a+356>>2]=e+ +g[a+356>>2];g[a+360>>2]=d+ +g[a+360>>2];return}function Vo(a){a=a|0;return}function Wo(a){a=a|0;return 644}function Xo(b,d,e){b=b|0;d=d|0;e=e|0;Aq(b,d,e)|0;c[d+52>>2]=c[b+48>>2];c[d+56>>2]=c[b+52>>2];c[d+60>>2]=c[b+56>>2];c[d+64>>2]=c[b+60>>2];c[d+68>>2]=c[b+64>>2];c[d+72>>2]=c[b+68>>2];c[d+76>>2]=c[b+72>>2];c[d+80>>2]=c[b+76>>2];c[d+84>>2]=c[b+80>>2];c[d+88>>2]=c[b+84>>2];c[d+92>>2]=c[b+88>>2];c[d+96>>2]=c[b+92>>2];c[d+100>>2]=c[b+96>>2];c[d+104>>2]=c[b+100>>2];c[d+108>>2]=c[b+104>>2];c[d+112>>2]=c[b+108>>2];c[d+116>>2]=c[b+112>>2];c[d+120>>2]=c[b+116>>2];c[d+124>>2]=c[b+120>>2];c[d+128>>2]=c[b+124>>2];c[d+132>>2]=c[b+128>>2];c[d+136>>2]=c[b+132>>2];c[d+140>>2]=c[b+136>>2];c[d+144>>2]=c[b+140>>2];c[d+148>>2]=c[b+144>>2];c[d+152>>2]=c[b+148>>2];c[d+156>>2]=c[b+152>>2];c[d+160>>2]=c[b+156>>2];c[d+164>>2]=c[b+160>>2];c[d+168>>2]=c[b+164>>2];c[d+172>>2]=c[b+168>>2];c[d+176>>2]=c[b+172>>2];e=0;do{c[d+428+(e<<2)>>2]=c[b+968+(e*88|0)>>2];c[d+412+(e<<2)>>2]=c[b+968+(e*88|0)+4>>2];c[d+444+(e<<2)>>2]=c[b+968+(e*88|0)+8>>2];c[d+460+(e<<2)>>2]=c[b+968+(e*88|0)+12>>2];c[d+476+(e<<2)>>2]=c[b+968+(e*88|0)+16>>2];c[d+492+(e<<2)>>2]=c[b+968+(e*88|0)+20>>2];c[d+508+(e<<2)>>2]=c[b+968+(e*88|0)+24>>2];c[d+524+(e<<2)>>2]=c[b+968+(e*88|0)+32>>2];c[d+540+(e<<2)>>2]=c[b+968+(e*88|0)+36>>2];c[d+556+(e<<2)>>2]=c[b+968+(e*88|0)+44>>2];c[d+572+(e<<2)>>2]=c[b+968+(e*88|0)+52>>2];c[d+588+(e<<2)>>2]=c[b+968+(e*88|0)+60>>2];c[d+604+(e<<2)>>2]=c[b+968+(e*88|0)+68>>2];e=e+1|0}while((e|0)!=3);g[d+440>>2]=0.0;g[d+424>>2]=0.0;g[d+456>>2]=0.0;g[d+472>>2]=0.0;g[d+488>>2]=0.0;g[d+504>>2]=0.0;g[d+520>>2]=0.0;g[d+536>>2]=0.0;g[d+552>>2]=0.0;g[d+568>>2]=0.0;g[d+584>>2]=0.0;g[d+600>>2]=0.0;g[d+616>>2]=0.0;a[d+620>>0]=a[b+996>>0]|0;a[d+624>>0]=a[b+1008>>0]|0;a[d+628>>0]=a[b+1016>>0]|0;a[d+632>>0]=a[b+1024>>0]|0;a[d+636>>0]=a[b+1032>>0]|0;a[d+621>>0]=a[b+1084>>0]|0;a[d+625>>0]=a[b+1096>>0]|0;a[d+629>>0]=a[b+1104>>0]|0;a[d+633>>0]=a[b+1112>>0]|0;a[d+637>>0]=a[b+1120>>0]|0;a[d+622>>0]=a[b+1172>>0]|0;a[d+626>>0]=a[b+1184>>0]|0;a[d+630>>0]=a[b+1192>>0]|0;a[d+634>>0]=a[b+1200>>0]|0;a[d+638>>0]=a[b+1208>>0]|0;a[d+623>>0]=0;a[d+627>>0]=0;a[d+631>>0]=0;a[d+635>>0]=0;a[d+639>>0]=0;c[d+196>>2]=c[b+680>>2];c[d+200>>2]=c[b+684>>2];c[d+204>>2]=c[b+688>>2];c[d+208>>2]=c[b+692>>2];c[d+180>>2]=c[b+696>>2];c[d+184>>2]=c[b+700>>2];c[d+188>>2]=c[b+704>>2];c[d+192>>2]=c[b+708>>2];c[d+212>>2]=c[b+712>>2];c[d+216>>2]=c[b+716>>2];c[d+220>>2]=c[b+720>>2];c[d+224>>2]=c[b+724>>2];c[d+228>>2]=c[b+728>>2];c[d+232>>2]=c[b+732>>2];c[d+236>>2]=c[b+736>>2];c[d+240>>2]=c[b+740>>2];c[d+244>>2]=c[b+744>>2];c[d+248>>2]=c[b+748>>2];c[d+252>>2]=c[b+752>>2];c[d+256>>2]=c[b+756>>2];c[d+260>>2]=c[b+760>>2];c[d+264>>2]=c[b+764>>2];c[d+268>>2]=c[b+768>>2];c[d+272>>2]=c[b+772>>2];c[d+276>>2]=c[b+776>>2];c[d+280>>2]=c[b+780>>2];c[d+284>>2]=c[b+784>>2];c[d+288>>2]=c[b+788>>2];c[d+292>>2]=c[b+876>>2];c[d+296>>2]=c[b+880>>2];c[d+300>>2]=c[b+884>>2];c[d+304>>2]=c[b+888>>2];c[d+308>>2]=c[b+892>>2];c[d+312>>2]=c[b+896>>2];c[d+316>>2]=c[b+900>>2];c[d+320>>2]=c[b+904>>2];c[d+324>>2]=c[b+804>>2];c[d+328>>2]=c[b+808>>2];c[d+332>>2]=c[b+812>>2];c[d+336>>2]=c[b+816>>2];c[d+340>>2]=c[b+820>>2];c[d+344>>2]=c[b+824>>2];c[d+348>>2]=c[b+828>>2];c[d+352>>2]=c[b+832>>2];c[d+356>>2]=c[b+840>>2];c[d+360>>2]=c[b+844>>2];c[d+364>>2]=c[b+848>>2];c[d+368>>2]=c[b+852>>2];c[d+372>>2]=c[b+860>>2];c[d+376>>2]=c[b+864>>2];c[d+380>>2]=c[b+868>>2];c[d+384>>2]=c[b+872>>2];a[d+388>>0]=a[b+792>>0]|0;a[d+392>>0]=a[b+795>>0]|0;a[d+396>>0]=a[b+798>>0]|0;a[d+400>>0]=a[b+836>>0]|0;a[d+404>>0]=a[b+856>>0]|0;a[d+389>>0]=a[b+793>>0]|0;a[d+393>>0]=a[b+796>>0]|0;a[d+397>>0]=a[b+799>>0]|0;a[d+401>>0]=a[b+837>>0]|0;a[d+405>>0]=a[b+857>>0]|0;a[d+390>>0]=a[b+794>>0]|0;a[d+394>>0]=a[b+797>>0]|0;a[d+398>>0]=a[b+800>>0]|0;a[d+402>>0]=a[b+838>>0]|0;a[d+406>>0]=a[b+858>>0]|0;a[d+391>>0]=0;a[d+395>>0]=0;a[d+399>>0]=0;a[d+403>>0]=0;a[d+407>>0]=0;c[d+640>>2]=c[b+1232>>2];return 15168}function Yo(a){a=a|0;c[a>>2]=7188;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function Zo(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0;k=i;i=i+16|0;if(!(a[b+1308>>0]|0)){i=k;return}g[b+928>>2]=0.0;g[b+992>>2]=0.0;g[b+1056>>2]=0.0;c[b+712>>2]=0;c[b+712+4>>2]=0;c[b+712+8>>2]=0;c[b+712+12>>2]=0;_o(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);rb[c[(c[b>>2]|0)+44>>2]&255](b);e=+g[b+1284>>2];f=+g[b+1288>>2];h=+g[b+1292>>2];if(+g[b+696>>2]>=+g[b+680>>2]){l=(a[b+1300>>0]|0)==0;j=c[(l?b+1160|0:b+1096|0)>>2]|0;d=c[(l?b+1144|0:b+1080|0)>>2]|0;c[k>>2]=c[(l?b+1128|0:b+1064|0)>>2];c[k+4>>2]=d;c[k+8>>2]=j;g[k+12>>2]=0.0;$o(c[b+28>>2]|0,c[b+32>>2]|0,b+176|0,k,e,f,h,e,f,h)}if(+g[b+700>>2]>=+g[b+684>>2]){d=(a[b+1300>>0]|0)==0;l=c[(d?b+1164|0:b+1100|0)>>2]|0;j=c[(d?b+1148|0:b+1084|0)>>2]|0;c[k>>2]=c[(d?b+1132|0:b+1068|0)>>2];c[k+4>>2]=j;c[k+8>>2]=l;g[k+12>>2]=0.0;$o(c[b+28>>2]|0,c[b+32>>2]|0,b+260|0,k,e,f,h,e,f,h)}if(+g[b+704>>2]>=+g[b+688>>2]){d=(a[b+1300>>0]|0)==0;l=c[(d?b+1168|0:b+1104|0)>>2]|0;j=c[(d?b+1152|0:b+1088|0)>>2]|0;c[k>>2]=c[(d?b+1136|0:b+1072|0)>>2];c[k+4>>2]=j;c[k+8>>2]=l;g[k+12>>2]=0.0;$o(c[b+28>>2]|0,c[b+32>>2]|0,b+344|0,k,e,f,h,e,f,h)}j=0;do{e=+g[b+868+(j<<6)>>2];f=+g[b+868+(j<<6)+4>>2];h=+ap(+g[b+1192+(j<<2)>>2],e,f);g[b+868+(j<<6)+52>>2]=h;do if(!(e>f)){if(e>h){c[b+868+(j<<6)+56>>2]=1;d=b+868+(j<<6)+48|0;g[d>>2]=h-e;if(h-e>3.1415927410125732){g[d>>2]=h-e+-6.2831854820251465;d=19;break}if(!(h-e<-3.1415927410125732)){d=19;break}g[d>>2]=h-e+6.2831854820251465;d=19;break}d=b+868+(j<<6)+56|0;if(!(f<h)){c[d>>2]=0;d=18;break}c[d>>2]=2;d=b+868+(j<<6)+48|0;g[d>>2]=h-f;if(h-f>3.1415927410125732){g[d>>2]=h-f+-6.2831854820251465;d=19;break}if(h-f<-3.1415927410125732){g[d>>2]=h-f+6.2831854820251465;d=19}else d=19}else{c[b+868+(j<<6)+56>>2]=0;d=18}while(0);if((d|0)==18?(d=0,a[b+868+(j<<6)+44>>0]|0):0)d=19;if((d|0)==19){K=b+1208+(j<<4)|0;c[k>>2]=c[K>>2];c[k+4>>2]=c[K+4>>2];c[k+8>>2]=c[K+8>>2];c[k+12>>2]=c[K+12>>2];K=b+428+(j*84|0)|0;d=c[b+28>>2]|0;J=+g[d+4>>2];I=+g[d+20>>2];H=+g[d+36>>2];F=+g[d+8>>2];E=+g[d+24>>2];D=+g[d+40>>2];B=+g[d+12>>2];A=+g[d+28>>2];z=+g[d+44>>2];l=c[b+32>>2]|0;x=+g[l+4>>2];w=+g[l+20>>2];v=+g[l+36>>2];t=+g[l+8>>2];s=+g[l+24>>2];r=+g[l+40>>2];p=+g[l+12>>2];n=+g[l+28>>2];e=+g[l+44>>2];c[K>>2]=0;c[K+4>>2]=0;c[K+8>>2]=0;c[K+12>>2]=0;o=+g[k>>2];m=+g[k+4>>2];f=+g[k+8>>2];g[b+428+(j*84|0)+16>>2]=J*o+I*m+H*f;g[b+428+(j*84|0)+20>>2]=F*o+E*m+D*f;g[b+428+(j*84|0)+24>>2]=B*o+A*m+z*f;g[b+428+(j*84|0)+28>>2]=0.0;g[b+428+(j*84|0)+32>>2]=x*-o+w*-m+v*-f;g[b+428+(j*84|0)+36>>2]=t*-o+s*-m+r*-f;g[b+428+(j*84|0)+40>>2]=p*-o+n*-m+e*-f;g[b+428+(j*84|0)+44>>2]=0.0;G=(J*o+I*m+H*f)*+g[d+420>>2];C=(F*o+E*m+D*f)*+g[d+424>>2];y=(B*o+A*m+z*f)*+g[d+428>>2];g[b+428+(j*84|0)+48>>2]=G;g[b+428+(j*84|0)+52>>2]=C;g[b+428+(j*84|0)+56>>2]=y;g[b+428+(j*84|0)+60>>2]=0.0;u=(x*-o+w*-m+v*-f)*+g[l+420>>2];q=(t*-o+s*-m+r*-f)*+g[l+424>>2];h=(p*-o+n*-m+e*-f)*+g[l+428>>2];g[b+428+(j*84|0)+64>>2]=u;g[b+428+(j*84|0)+68>>2]=q;g[b+428+(j*84|0)+72>>2]=h;g[b+428+(j*84|0)+76>>2]=0.0;g[b+428+(j*84|0)+80>>2]=(J*o+I*m+H*f)*G+(F*o+E*m+D*f)*C+(B*o+A*m+z*f)*y+((x*-o+w*-m+v*-f)*u+(t*-o+s*-m+r*-f)*q+(p*-o+n*-m+e*-f)*h)}j=j+1|0}while((j|0)!=3);i=k;return}function _o(b,d,e){b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;C=+g[b+48>>2];i=+g[d>>2];D=+g[b+64>>2];j=+g[d+4>>2];E=+g[b+80>>2];p=+g[d+8>>2];s=+g[b+52>>2];r=+g[b+68>>2];q=+g[b+84>>2];w=+g[b+56>>2];y=+g[b+72>>2];z=+g[b+88>>2];v=+g[d+16>>2];u=+g[d+20>>2];t=+g[d+24>>2];x=+g[d+32>>2];F=+g[d+36>>2];G=+g[d+40>>2];k=+g[b+96>>2];h=+g[b+100>>2];B=+g[b+104>>2];A=+g[d+48>>2]+(i*k+j*h+p*B);f=v*k+u*h+t*B+ +g[d+52>>2];B=x*k+F*h+G*B+ +g[d+56>>2];g[b+1064>>2]=C*i+D*j+E*p;g[b+1068>>2]=i*s+j*r+p*q;g[b+1072>>2]=i*w+j*y+p*z;g[b+1076>>2]=0.0;g[b+1080>>2]=C*v+D*u+E*t;g[b+1084>>2]=s*v+r*u+q*t;g[b+1088>>2]=w*v+y*u+z*t;g[b+1092>>2]=0.0;g[b+1096>>2]=C*x+D*F+E*G;g[b+1100>>2]=s*x+r*F+q*G;g[b+1104>>2]=w*x+y*F+z*G;g[b+1108>>2]=0.0;g[b+1112>>2]=A;g[b+1116>>2]=f;g[b+1120>>2]=B;g[b+1124>>2]=0.0;B=+g[b+112>>2];f=+g[e>>2];A=+g[b+128>>2];G=+g[e+4>>2];z=+g[b+144>>2];F=+g[e+8>>2];y=+g[b+116>>2];x=+g[b+132>>2];w=+g[b+148>>2];q=+g[b+120>>2];r=+g[b+136>>2];s=+g[b+152>>2];E=+g[e+16>>2];D=+g[e+20>>2];C=+g[e+24>>2];t=+g[e+32>>2];u=+g[e+36>>2];v=+g[e+40>>2];p=+g[b+160>>2];j=+g[b+164>>2];i=+g[b+168>>2];h=+g[e+48>>2]+(f*p+G*j+F*i);k=E*p+D*j+C*i+ +g[e+52>>2];i=t*p+u*j+v*i+ +g[e+56>>2];g[b+1128>>2]=B*f+A*G+z*F;g[b+1132>>2]=f*y+G*x+F*w;g[b+1136>>2]=f*q+G*r+F*s;g[b+1140>>2]=0.0;g[b+1144>>2]=B*E+A*D+z*C;g[b+1148>>2]=y*E+x*D+w*C;g[b+1152>>2]=q*E+r*D+s*C;g[b+1156>>2]=0.0;g[b+1160>>2]=B*t+A*u+z*v;g[b+1164>>2]=y*t+x*u+w*v;g[b+1168>>2]=q*t+r*u+s*v;g[b+1172>>2]=0.0;g[b+1176>>2]=h;g[b+1180>>2]=k;g[b+1184>>2]=i;g[b+1188>>2]=0.0;h=h-+g[b+1112>>2];k=k-+g[b+1116>>2];i=i-+g[b+1120>>2];w=+g[b+1084>>2];x=+g[b+1104>>2];y=+g[b+1088>>2];z=+g[b+1100>>2];A=+g[b+1096>>2];B=+g[b+1080>>2];C=+g[b+1064>>2];D=+g[b+1068>>2];E=+g[b+1072>>2];F=1.0/((w*x-y*z)*C+D*(y*A-x*B)+(z*B-w*A)*E);G=(z*B-w*A)*F;f=i*((y*D-w*E)*F)+(h*((w*x-y*z)*F)+k*((z*E-x*D)*F));j=i*((B*E-y*C)*F)+(h*((y*A-x*B)*F)+k*((x*C-A*E)*F));k=i*((w*C-B*D)*F)+(h*G+k*((A*D-z*C)*F));g[b+1256>>2]=f;g[b+1260>>2]=j;g[b+1264>>2]=k;g[b+1268>>2]=0.0;g[b+840>>2]=f;h=+g[b+680>>2];i=+g[b+696>>2];do if(!(h>i)){if(h>f){c[b+856>>2]=2;g[b+824>>2]=f-h;break}if(i<f){c[b+856>>2]=1;g[b+824>>2]=f-i;break}else{c[b+856>>2]=0;g[b+824>>2]=0.0;break}}else{c[b+856>>2]=0;g[b+824>>2]=0.0}while(0);g[b+844>>2]=j;f=+g[b+684>>2];h=+g[b+700>>2];do if(!(f>h)){if(f>j){c[b+860>>2]=2;g[b+828>>2]=j-f;break}if(h<j){c[b+860>>2]=1;g[b+828>>2]=j-h;break}else{c[b+860>>2]=0;g[b+828>>2]=0.0;break}}else{c[b+860>>2]=0;g[b+828>>2]=0.0}while(0);g[b+848>>2]=k;f=+g[b+688>>2];h=+g[b+704>>2];do if(!(f>h)){if(f>k){c[b+864>>2]=2;g[b+832>>2]=k-f;break}if(h<k){c[b+864>>2]=1;g[b+832>>2]=k-h;break}else{c[b+864>>2]=0;g[b+832>>2]=0.0;break}}else{c[b+864>>2]=0;g[b+832>>2]=0.0}while(0);h=+g[b+1128>>2];i=+g[b+1144>>2];j=+g[b+1160>>2];k=+g[b+1132>>2];l=+g[b+1148>>2];m=+g[b+1164>>2];n=(w*x-y*z)*F*k+(z*E-x*D)*F*l+(y*D-w*E)*F*m;o=k*((y*A-x*B)*F)+(x*C-A*E)*F*l+(B*E-y*C)*F*m;p=j*((w*C-B*D)*F)+(h*G+i*((A*D-z*C)*F));f=G*+g[b+1136>>2]+(A*D-z*C)*F*+g[b+1152>>2]+(w*C-B*D)*F*(q*t+r*u+s*v);do if(p<1.0)if(p>-1.0){g[b+1192>>2]=+W(+-(k*G+(A*D-z*C)*F*l+(w*C-B*D)*F*m),+f);G=p<-1.0?-1.0:p;g[b+1196>>2]=+U(+(G>1.0?1.0:G));g[b+1200>>2]=+W(+-(j*((B*E-y*C)*F)+(h*((y*A-x*B)*F)+i*((x*C-A*E)*F))),+(j*((y*D-w*E)*F)+(h*((w*x-y*z)*F)+i*((z*E-x*D)*F))));break}else{g[b+1192>>2]=-+W(+n,+o);g[b+1196>>2]=-1.5707963705062866;g[b+1200>>2]=0.0;break}else{g[b+1192>>2]=+W(+n,+o);g[b+1196>>2]=1.5707963705062866;g[b+1200>>2]=0.0}while(0);g[b+1236>>2]=0.0;z=x*(h*x-j*E)-y*(i*E-h*y);A=E*(i*E-h*y)-x*(j*y-i*x);B=y*(j*y-i*x)-E*(h*x-j*E);g[b+1220>>2]=0.0;C=i*(i*E-h*y)-j*(h*x-j*E);D=j*(j*y-i*x)-h*(i*E-h*y);F=h*(h*x-j*E)-i*(j*y-i*x);g[b+1252>>2]=0.0;G=1.0/+O(+(z*z+A*A+B*B));g[b+1208>>2]=z*G;g[b+1212>>2]=A*G;g[b+1216>>2]=B*G;G=1.0/+O(+((j*y-i*x)*(j*y-i*x)+(h*x-j*E)*(h*x-j*E)+(i*E-h*y)*(i*E-h*y)));g[b+1224>>2]=(j*y-i*x)*G;g[b+1228>>2]=(h*x-j*E)*G;g[b+1232>>2]=(i*E-h*y)*G;G=1.0/+O(+(C*C+D*D+F*F));g[b+1240>>2]=C*G;g[b+1244>>2]=D*G;g[b+1248>>2]=F*G;if(!(a[b+1301>>0]|0))return;F=+g[(c[b+28>>2]|0)+368>>2];G=+g[(c[b+32>>2]|0)+368>>2];a[b+1280>>0]=(F<1.1920928955078125e-07|G<1.1920928955078125e-07)&1;G=F+G>0.0?G/(F+G):.5;g[b+1272>>2]=G;g[b+1276>>2]=1.0-G;return}function $o(a,b,d,e,f,h,j,k,l,m){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;h=+h;j=+j;k=+k;l=+l;m=+m;var n=0;n=i;i=i+128|0;c[n+80>>2]=c[a+4>>2];c[n+80+4>>2]=c[a+20>>2];c[n+80+8>>2]=c[a+36>>2];g[n+80+12>>2]=0.0;c[n+80+16>>2]=c[a+8>>2];c[n+80+20>>2]=c[a+24>>2];c[n+80+24>>2]=c[a+40>>2];g[n+80+28>>2]=0.0;c[n+80+32>>2]=c[a+12>>2];c[n+80+36>>2]=c[a+28>>2];c[n+80+40>>2]=c[a+44>>2];g[n+80+44>>2]=0.0;c[n+32>>2]=c[b+4>>2];c[n+32+4>>2]=c[b+20>>2];c[n+32+8>>2]=c[b+36>>2];g[n+32+12>>2]=0.0;c[n+32+16>>2]=c[b+8>>2];c[n+32+20>>2]=c[b+24>>2];c[n+32+24>>2]=c[b+40>>2];g[n+32+28>>2]=0.0;c[n+32+32>>2]=c[b+12>>2];c[n+32+36>>2]=c[b+28>>2];c[n+32+40>>2]=c[b+44>>2];g[n+32+44>>2]=0.0;h=h-+g[a+56>>2];j=j-+g[a+60>>2];g[n+16>>2]=f-+g[a+52>>2];g[n+16+4>>2]=h;g[n+16+8>>2]=j;g[n+16+12>>2]=0.0;l=l-+g[b+56>>2];m=m-+g[b+60>>2];g[n>>2]=k-+g[b+52>>2];g[n+4>>2]=l;g[n+8>>2]=m;g[n+12>>2]=0.0;Ho(d,n+80|0,n+32|0,n+16|0,n,e,a+420|0,+g[a+368>>2],b+420|0,+g[b+368>>2]);i=n;return}function ap(a,b,c){a=+a;b=+b;c=+c;var d=0.0,e=0.0,f=0;if(b>=c)return +a;if(a<b){d=+oG(b-a);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;e=+N(+d);d=+oG(c-a);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;f=e<+N(+d);a=f?a:a+6.2831854820251465;return +a}if(!(a>c))return +a;d=+oG(a-c);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;e=+N(+d);d=+oG(a-b);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;f=+N(+d)<e;a=f?a+-6.2831854820251465:a;return +a}function bp(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0;if(a[b+1308>>0]|0){c[d>>2]=0;c[d+4>>2]=0;return}_o(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);c[d>>2]=0;c[d+4>>2]=6;if((c[b+856>>2]|0)==0?(a[b+788>>0]|0)==0:0){e=0;f=6}else{c[d>>2]=1;c[d+4>>2]=5;e=1;f=5}if(!((c[b+860>>2]|0)==0?(a[b+789>>0]|0)==0:0)){e=e+1|0;c[d>>2]=e;f=f+-1|0;c[d+4>>2]=f}if((c[b+864>>2]|0)==0?(a[b+790>>0]|0)==0:0)l=0;else{e=e+1|0;c[d>>2]=e;f=f+-1|0;c[d+4>>2]=f;l=0}do{i=+g[b+868+(l<<6)>>2];j=+g[b+868+(l<<6)+4>>2];k=+ap(+g[b+1192+(l<<2)>>2],i,j);g[b+868+(l<<6)+52>>2]=k;do if(!(i>j)){if(i>k){c[b+868+(l<<6)+56>>2]=1;h=b+868+(l<<6)+48|0;g[h>>2]=k-i;if(k-i>3.1415927410125732){g[h>>2]=k-i+-6.2831854820251465;h=21;break}if(!(k-i<-3.1415927410125732)){h=21;break}g[h>>2]=k-i+6.2831854820251465;h=21;break}h=b+868+(l<<6)+56|0;if(!(j<k)){c[h>>2]=0;h=20;break}c[h>>2]=2;h=b+868+(l<<6)+48|0;g[h>>2]=k-j;if(k-j>3.1415927410125732){g[h>>2]=k-j+-6.2831854820251465;h=21;break}if(k-j<-3.1415927410125732){g[h>>2]=k-j+6.2831854820251465;h=21}else h=21}else{c[b+868+(l<<6)+56>>2]=0;h=20}while(0);if((h|0)==20){h=0;if(a[b+868+(l<<6)+44>>0]|0)h=21}if((h|0)==21){e=e+1|0;c[d>>2]=e;f=f+-1|0;c[d+4>>2]=f}l=l+1|0}while((l|0)!=3);return}function cp(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;l=i;i=i+16|0;j=c[b+28>>2]|0;k=c[b+32>>2]|0;if(!(a[b+1301>>0]|0)){h=0;e=ep(b,d,0,j+4|0,k+4|0,j+336|0,k+336|0,j+352|0,k+352|0)|0;do{f=b+868+(h<<6)|0;if(!((c[b+868+(h<<6)+56>>2]|0)==0?(a[b+868+(h<<6)+44>>0]|0)==0:0)){g=b+1208+(h<<4)|0;c[l>>2]=c[g>>2];c[l+4>>2]=c[g+4>>2];c[l+8>>2]=c[g+8>>2];c[l+12>>2]=c[g+12>>2];g=c[b+1304>>2]>>(h*3|0)+9;if(!(g&1))c[b+868+(h<<6)+28>>2]=c[c[d+32>>2]>>2];if(!(g&2))c[b+868+(h<<6)+36>>2]=c[c[d+32>>2]>>2];if(!(g&4))c[b+868+(h<<6)+32>>2]=c[d+4>>2];e=(dp(b,f,j+4|0,k+4|0,j+336|0,k+336|0,j+352|0,k+352|0,d,e,l,1,0)|0)+e|0}h=h+1|0}while((h|0)!=3);i=l;return}h=0;e=0;do{f=b+868+(h<<6)|0;if(!((c[b+868+(h<<6)+56>>2]|0)==0?(a[b+868+(h<<6)+44>>0]|0)==0:0)){g=b+1208+(h<<4)|0;c[l>>2]=c[g>>2];c[l+4>>2]=c[g+4>>2];c[l+8>>2]=c[g+8>>2];c[l+12>>2]=c[g+12>>2];g=c[b+1304>>2]>>(h*3|0)+9;if(!(g&1))c[b+868+(h<<6)+28>>2]=c[c[d+32>>2]>>2];if(!(g&2))c[b+868+(h<<6)+36>>2]=c[c[d+32>>2]>>2];if(!(g&4))c[b+868+(h<<6)+32>>2]=c[d+4>>2];e=(dp(b,f,j+4|0,k+4|0,j+336|0,k+336|0,j+352|0,k+352|0,d,e,l,1,0)|0)+e|0}h=h+1|0}while((h|0)!=3);ep(b,d,e,j+4|0,k+4|0,j+336|0,k+336|0,j+352|0,k+352|0)|0;i=l;return}function dp(b,d,e,f,h,i,j,k,l,m,n,o,p){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;var q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0,A=0,B=0,C=0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;A=_(c[l+24>>2]|0,m)|0;m=a[d+44>>0]|0;z=c[d+56>>2]|0;if(!(m<<24>>24!=0|(z|0)!=0)){A=0;return A|0}C=c[(o|0?l+12|0:l+8|0)>>2]|0;B=c[(o|0?l+20|0:l+16|0)>>2]|0;c[C+(A<<2)>>2]=c[n>>2];c[C+(A+1<<2)>>2]=c[n+4>>2];c[C+(A+2<<2)>>2]=c[n+8>>2];g[B+(A<<2)>>2]=-+g[n>>2];g[B+(A+1<<2)>>2]=-+g[n+4>>2];g[B+(A+2<<2)>>2]=-+g[n+8>>2];do if(!o){q=+g[b+1176>>2];if(!(a[b+1301>>0]|0)){t=q-+g[e+48>>2];w=+g[b+1180>>2]-+g[e+52>>2];x=+g[b+1184>>2]-+g[e+56>>2];v=+g[n+8>>2];s=+g[n+4>>2];u=+g[n>>2];C=c[l+12>>2]|0;g[C+(A<<2)>>2]=w*v-x*s;g[C+(A+1<<2)>>2]=x*u-t*v;g[C+(A+2<<2)>>2]=t*s-w*u;u=+g[b+1176>>2]-+g[f+48>>2];w=+g[b+1180>>2]-+g[f+52>>2];s=+g[b+1184>>2]-+g[f+56>>2];t=+g[n+8>>2];v=+g[n+4>>2];x=+g[n>>2];C=c[l+20>>2]|0;g[C+(A<<2)>>2]=-(w*t-s*v);g[C+(A+1<<2)>>2]=-(s*x-u*t);g[C+(A+2<<2)>>2]=-(u*v-w*x);break}I=q-+g[f+48>>2];H=+g[b+1180>>2]-+g[f+52>>2];F=+g[b+1184>>2]-+g[f+56>>2];u=+g[n>>2];G=+g[n+4>>2];E=+g[n+8>>2];K=+g[b+1112>>2]-+g[e+48>>2];t=+g[b+1116>>2]-+g[e+52>>2];q=+g[b+1120>>2]-+g[e+56>>2];v=+g[d+52>>2]-+g[d+48>>2];J=u*(u*K+G*t+E*q)+u*v-u*(I*u+H*G+F*E);D=G*(u*K+G*t+E*q)+G*v-G*(I*u+H*G+F*E);v=E*(u*K+G*t+E*q)+E*v-E*(I*u+H*G+F*E);x=+g[b+1272>>2];w=+g[b+1276>>2];s=E*(t-G*(u*K+G*t+E*q)+x*D)-G*(q-E*(u*K+G*t+E*q)+x*v);r=u*(q-E*(u*K+G*t+E*q)+x*v)-E*(K-u*(u*K+G*t+E*q)+x*J);q=G*(K-u*(u*K+G*t+E*q)+x*J)-u*(t-G*(u*K+G*t+E*q)+x*D);t=(H-G*(I*u+H*G+F*E)-w*D)*E-(F-E*(I*u+H*G+F*E)-w*v)*G;v=(F-E*(I*u+H*G+F*E)-w*v)*u-(I-u*(I*u+H*G+F*E)-w*J)*E;u=(I-u*(I*u+H*G+F*E)-w*J)*G-(H-G*(I*u+H*G+F*E)-w*D)*u;if(!((p|0)!=0|(a[b+1280>>0]|0)==0)){t=w*t;v=w*v;u=w*u;s=x*s;r=x*r;q=x*q}C=(c[l+12>>2]|0)+(A<<2)|0;g[C>>2]=s;g[C+4>>2]=r;g[C+8>>2]=q;C=c[l+20>>2]|0;g[C+(A<<2)>>2]=-t;g[C+(A+1<<2)>>2]=-v;g[C+(A+2<<2)>>2]=-u}while(0);if(z|0?+g[d>>2]==+g[d+4>>2]:0){m=c[l+28>>2]|0;g[m+(A<<2)>>2]=0.0;q=0.0;e=l+28|0}else y=11;do if((y|0)==11){e=c[l+28>>2]|0;g[e+(A<<2)>>2]=0.0;if(!(m<<24>>24)){if(z|0){m=e;q=0.0;e=l+28|0;break}else m=1;return m|0}c[(c[l+32>>2]|0)+(A<<2)>>2]=c[d+28>>2];if(z|0){m=e;q=+g[e+(A<<2)>>2];e=l+28|0;break}v=+g[d+8>>2];q=o|0?v:-v;r=+g[d+52>>2];s=+g[d>>2];t=+g[d+4>>2];u=+g[l>>2]*+g[d+32>>2];do if(!(s>t))if(!(s==t)){if(q/u<0.0)if(r>=s?s-q/u>r:0){q=(s-r)/(q/u);break}else{q=r<s?0.0:1.0;break}if(q/u>0.0)if(r<=t?t-q/u<r:0){q=(t-r)/(q/u);break}else{q=r>t?0.0:1.0;break}else q=0.0}else q=0.0;else q=1.0;while(0);g[e+(A<<2)>>2]=q*v+ +g[e+(A<<2)>>2];g[(c[l+36>>2]|0)+(A<<2)>>2]=-+g[d+12>>2];c[(c[l+40>>2]|0)+(A<<2)>>2]=c[d+12>>2];C=1;return C|0}while(0);K=+g[l>>2]*+g[d+32>>2]*+g[d+48>>2];g[m+(A<<2)>>2]=q+(o|0?-K:K);c[(c[l+32>>2]|0)+(A<<2)>>2]=c[d+36>>2];if(+g[d>>2]==+g[d+4>>2]){g[(c[l+36>>2]|0)+(A<<2)>>2]=-3402823466385288598117041.0e14;g[(c[l+40>>2]|0)+(A<<2)>>2]=3402823466385288598117041.0e14;C=1;return C|0}C=c[l+40>>2]|0;g[(c[l+36>>2]|0)+(A<<2)>>2]=(z|0)==1?0.0:-3402823466385288598117041.0e14;g[C+(A<<2)>>2]=(z|0)==1?3402823466385288598117041.0e14:0.0;r=+g[d+40>>2];if(!(r>0.0)){C=1;return C|0}if(o|0){J=+g[n>>2];K=+g[n+4>>2];q=+g[n+8>>2];q=+g[j>>2]*J+ +g[j+4>>2]*K+ +g[j+8>>2]*q-(J*+g[k>>2]+K*+g[k+4>>2]+q*+g[k+8>>2])}else{J=+g[n>>2];K=+g[n+4>>2];q=+g[n+8>>2];q=+g[h>>2]*J+ +g[h+4>>2]*K+ +g[h+8>>2]*q-(J*+g[i>>2]+K*+g[i+4>>2]+q*+g[i+8>>2])}if((z|0)==1){if(!(q<0.0)){C=1;return C|0}q=-(q*r);m=(c[e>>2]|0)+(A<<2)|0;if(!(+g[m>>2]<q)){C=1;return C|0}g[m>>2]=q;C=1;return C|0}else{if(!(q>0.0)){C=1;return C|0}q=-(q*r);m=(c[e>>2]|0)+(A<<2)|0;if(!(+g[m>>2]>q)){C=1;return C|0}g[m>>2]=q;C=1;return C|0}return 0}function ep(b,d,e,f,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0;q=i;i=i+80|0;g[q+16+60>>2]=0.0;g[q+16+8>>2]=0.0;g[q+16+12>>2]=.10000000149011612;g[q+16+16>>2]=300.0;g[q+16>>2]=1.0;g[q+16+4>>2]=-1.0;g[q+16+28>>2]=0.0;g[q+16+32>>2]=.20000000298023224;g[q+16+36>>2]=0.0;g[q+16+40>>2]=0.0;g[q+16+20>>2]=1.0;g[q+16+24>>2]=.5;c[q+16+56>>2]=0;g[q+16+48>>2]=0.0;a[q+16+44>>0]=0;p=0;do{n=c[b+856+(p<<2)>>2]|0;o=a[b+788+p>>0]|0;if(!((n|0)==0&o<<24>>24==0)){g[q+16+40>>2]=0.0;c[q+16+56>>2]=n;c[q+16+52>>2]=c[b+840+(p<<2)>>2];c[q+16+48>>2]=c[b+824+(p<<2)>>2];c[q+16+20>>2]=c[b+732>>2];a[q+16+44>>0]=o;c[q+16+4>>2]=c[b+696+(p<<2)>>2];c[q+16+24>>2]=c[b+728>>2];c[q+16>>2]=c[b+680+(p<<2)>>2];g[q+16+16>>2]=0.0;c[q+16+12>>2]=c[b+808+(p<<2)>>2];c[q+16+8>>2]=c[b+792+(p<<2)>>2];c[q>>2]=c[b+1064+(p<<2)>>2];c[q+4>>2]=c[b+1080+(p<<2)>>2];c[q+8>>2]=c[b+1096+(p<<2)>>2];g[q+12>>2]=0.0;o=c[b+1304>>2]>>p*3;if(!(o&1))n=c[d+32>>2]|0;else n=b+740+(p<<2)|0;c[q+16+28>>2]=c[n>>2];if(!(o&2))n=c[d+32>>2]|0;else n=b+772+(p<<2)|0;c[q+16+36>>2]=c[n>>2];c[q+16+32>>2]=c[((o&4|0)==0?d+4|0:b+756+(p<<2)|0)>>2];if(!(a[b+1301>>0]|0))n=dp(b,q+16|0,f,h,j,k,l,m,d,e,q,0,0)|0;else{o=p+1|0;if(!(c[b+868+(((o|0)==3?0:o)<<6)+56>>2]|0))n=1;else n=(c[b+868+(((p+2|0)%3|0)<<6)+56>>2]|0)==0&1;n=dp(b,q+16|0,f,h,j,k,l,m,d,e,q,0,n)|0}e=n+e|0}p=p+1|0}while((p|0)!=3);i=q;return e|0}function fp(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;if(e>>>0<3)switch(b|0){case 2:{g[a+756+(e<<2)>>2]=d;c[a+1304>>2]=c[a+1304>>2]|4<<e*3;return}case 4:{g[a+772+(e<<2)>>2]=d;c[a+1304>>2]=c[a+1304>>2]|2<<e*3;return}case 3:{g[a+740+(e<<2)>>2]=d;c[a+1304>>2]=c[a+1304>>2]|1<<e*3;return}default:return}if((e+-3|0)>>>0>=3)return;switch(b|0){case 2:{g[a+868+(e+-3<<6)+32>>2]=d;c[a+1304>>2]=c[a+1304>>2]|4<<e*3;return}case 4:{g[a+868+(e+-3<<6)+36>>2]=d;c[a+1304>>2]=c[a+1304>>2]|2<<e*3;return}case 3:{g[a+868+(e+-3<<6)+28>>2]=d;c[a+1304>>2]=c[a+1304>>2]|1<<e*3;return}default:return}}function gp(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0;a:do if(c>>>0>=3)if((c+-3|0)>>>0<3)switch(b|0){case 2:{d=+g[a+868+(c+-3<<6)+32>>2];break a}case 4:{d=+g[a+868+(c+-3<<6)+36>>2];break a}case 3:{d=+g[a+868+(c+-3<<6)+28>>2];break a}default:{d=0.0;break a}}else d=0.0;else switch(b|0){case 2:{d=+g[a+756+(c<<2)>>2];break a}case 4:{d=+g[a+772+(c<<2)>>2];break a}case 3:{d=+g[a+740+(c<<2)>>2];break a}default:{d=0.0;break a}}while(0);return +d}function hp(a){a=a|0;return 252}function ip(a,d,e){a=a|0;d=d|0;e=e|0;Aq(a,d,e)|0;c[d+52>>2]=c[a+48>>2];c[d+56>>2]=c[a+52>>2];c[d+60>>2]=c[a+56>>2];c[d+64>>2]=c[a+60>>2];c[d+68>>2]=c[a+64>>2];c[d+72>>2]=c[a+68>>2];c[d+76>>2]=c[a+72>>2];c[d+80>>2]=c[a+76>>2];c[d+84>>2]=c[a+80>>2];c[d+88>>2]=c[a+84>>2];c[d+92>>2]=c[a+88>>2];c[d+96>>2]=c[a+92>>2];c[d+100>>2]=c[a+96>>2];c[d+104>>2]=c[a+100>>2];c[d+108>>2]=c[a+104>>2];c[d+112>>2]=c[a+108>>2];c[d+116>>2]=c[a+112>>2];c[d+120>>2]=c[a+116>>2];c[d+124>>2]=c[a+120>>2];c[d+128>>2]=c[a+124>>2];c[d+132>>2]=c[a+128>>2];c[d+136>>2]=c[a+132>>2];c[d+140>>2]=c[a+136>>2];c[d+144>>2]=c[a+140>>2];c[d+148>>2]=c[a+144>>2];c[d+152>>2]=c[a+148>>2];c[d+156>>2]=c[a+152>>2];c[d+160>>2]=c[a+156>>2];c[d+164>>2]=c[a+160>>2];c[d+168>>2]=c[a+164>>2];c[d+172>>2]=c[a+168>>2];c[d+176>>2]=c[a+172>>2];c[d+228>>2]=c[a+868>>2];c[d+212>>2]=c[a+872>>2];c[d+196>>2]=c[a+680>>2];c[d+180>>2]=c[a+696>>2];c[d+232>>2]=c[a+932>>2];c[d+216>>2]=c[a+936>>2];c[d+200>>2]=c[a+684>>2];c[d+184>>2]=c[a+700>>2];c[d+236>>2]=c[a+996>>2];c[d+220>>2]=c[a+1e3>>2];c[d+204>>2]=c[a+688>>2];c[d+188>>2]=c[a+704>>2];a=b[a+1300>>1]|0;c[d+244>>2]=a&255;c[d+248>>2]=(a&65535)>>>8&65535;return 15229}function jp(a){a=a|0;var b=0.0,d=0.0,e=0.0,f=0.0;b=+g[(c[a+28>>2]|0)+368>>2];d=+g[(c[a+32>>2]|0)+368>>2];if(d==0.0)b=1.0;else b=b/(b+d);f=1.0-b;e=b*+g[a+1116>>2]+f*+g[a+1180>>2];d=b*+g[a+1120>>2]+f*+g[a+1184>>2];g[a+1284>>2]=b*+g[a+1112>>2]+f*+g[a+1176>>2];g[a+1288>>2]=e;g[a+1292>>2]=d;g[a+1296>>2]=0.0;return}function kp(a){a=a|0;return c[a+1304>>2]|0}function lp(b,d,e,f,h,i){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;c[b+4>>2]=6;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3402823466385288598117041.0e14;a[b+20>>0]=1;a[b+21>>0]=0;c[b+24>>2]=-1;c[b+28>>2]=d;c[b+32>>2]=e;g[b+36>>2]=0.0;g[b+40>>2]=.30000001192092896;c[b+44>>2]=0;c[b>>2]=7240;c[b+48>>2]=c[f>>2];c[b+48+4>>2]=c[f+4>>2];c[b+48+8>>2]=c[f+8>>2];c[b+48+12>>2]=c[f+12>>2];c[b+64>>2]=c[f+16>>2];c[b+64+4>>2]=c[f+16+4>>2];c[b+64+8>>2]=c[f+16+8>>2];c[b+64+12>>2]=c[f+16+12>>2];c[b+80>>2]=c[f+32>>2];c[b+80+4>>2]=c[f+32+4>>2];c[b+80+8>>2]=c[f+32+8>>2];c[b+80+12>>2]=c[f+32+12>>2];c[b+96>>2]=c[f+48>>2];c[b+96+4>>2]=c[f+48+4>>2];c[b+96+8>>2]=c[f+48+8>>2];c[b+96+12>>2]=c[f+48+12>>2];c[b+112>>2]=c[h>>2];c[b+112+4>>2]=c[h+4>>2];c[b+112+8>>2]=c[h+8>>2];c[b+112+12>>2]=c[h+12>>2];c[b+128>>2]=c[h+16>>2];c[b+128+4>>2]=c[h+16+4>>2];c[b+128+8>>2]=c[h+16+8>>2];c[b+128+12>>2]=c[h+16+12>>2];c[b+144>>2]=c[h+32>>2];c[b+144+4>>2]=c[h+32+4>>2];c[b+144+8>>2]=c[h+32+8>>2];c[b+144+12>>2]=c[h+32+12>>2];c[b+160>>2]=c[h+48>>2];c[b+160+4>>2]=c[h+48+4>>2];c[b+160+8>>2]=c[h+48+8>>2];c[b+160+12>>2]=c[h+48+12>>2];f=b+680|0;h=f+48|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(h|0));c[b+740>>2]=0;c[b+740+4>>2]=0;c[b+740+8>>2]=0;c[b+740+12>>2]=0;c[b+756>>2]=1045220557;c[b+760>>2]=1045220557;c[b+764>>2]=1045220557;c[b+768>>2]=0;c[b+768+4>>2]=0;c[b+768+8>>2]=0;c[b+768+12>>2]=0;c[b+768+16>>2]=0;g[b+728>>2]=.699999988079071;g[b+732>>2]=1.0;g[b+736>>2]=.5;a[b+788>>0]=0;g[b+792>>2]=0.0;g[b+808>>2]=0.0;a[b+789>>0]=0;g[b+796>>2]=0.0;g[b+812>>2]=0.0;a[b+790>>0]=0;g[b+800>>2]=0.0;g[b+816>>2]=0.0;g[b+928>>2]=0.0;g[b+876>>2]=0.0;g[b+880>>2]=.10000000149011612;g[b+884>>2]=300.0;g[b+868>>2]=1.0;g[b+872>>2]=-1.0;g[b+896>>2]=0.0;g[b+900>>2]=.20000000298023224;g[b+904>>2]=0.0;g[b+908>>2]=0.0;g[b+888>>2]=1.0;g[b+892>>2]=.5;c[b+924>>2]=0;g[b+916>>2]=0.0;a[b+912>>0]=0;g[b+992>>2]=0.0;g[b+940>>2]=0.0;g[b+944>>2]=.10000000149011612;g[b+948>>2]=300.0;g[b+932>>2]=1.0;g[b+936>>2]=-1.0;g[b+960>>2]=0.0;g[b+964>>2]=.20000000298023224;g[b+968>>2]=0.0;g[b+972>>2]=0.0;g[b+952>>2]=1.0;g[b+956>>2]=.5;c[b+988>>2]=0;g[b+980>>2]=0.0;a[b+976>>0]=0;g[b+1056>>2]=0.0;g[b+1004>>2]=0.0;g[b+1008>>2]=.10000000149011612;g[b+1012>>2]=300.0;g[b+996>>2]=1.0;g[b+1e3>>2]=-1.0;g[b+1024>>2]=0.0;g[b+1028>>2]=.20000000298023224;g[b+1032>>2]=0.0;g[b+1036>>2]=0.0;g[b+1016>>2]=1.0;g[b+1020>>2]=.5;c[b+1052>>2]=0;g[b+1044>>2]=0.0;a[b+1040>>0]=0;a[b+1300>>0]=i&1;a[b+1301>>0]=1;c[b+1304>>2]=0;a[b+1308>>0]=0;_o(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);return}function mp(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;j=i;i=i+16|0;if(!(a[19880]|0)){a[19880]=1;c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;Cr(21260,0.0,0,0,j)}c[5366]=c[5366]|1;g[5407]=0.0;k=+g[5417]*0.0;l=+g[5418]*0.0;g[5412]=+g[5416]*0.0;g[5413]=k;g[5414]=l;g[5415]=0.0;c[5420]=0;c[5421]=0;c[5422]=0;c[5423]=0;l=+g[5409]*0.0;k=+g[5410]*0.0;g[5461]=+g[5408]*0.0;g[5462]=l;g[5463]=k;g[5464]=0.0;c[b+4>>2]=6;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3402823466385288598117041.0e14;a[b+20>>0]=1;a[b+21>>0]=0;c[b+24>>2]=-1;c[b+28>>2]=21260;c[b+32>>2]=d;g[b+36>>2]=0.0;g[b+40>>2]=.30000001192092896;c[b+44>>2]=0;c[b>>2]=7240;c[b+112>>2]=c[e>>2];c[b+112+4>>2]=c[e+4>>2];c[b+112+8>>2]=c[e+8>>2];c[b+112+12>>2]=c[e+12>>2];c[b+128>>2]=c[e+16>>2];c[b+128+4>>2]=c[e+16+4>>2];c[b+128+8>>2]=c[e+16+8>>2];c[b+128+12>>2]=c[e+16+12>>2];c[b+144>>2]=c[e+32>>2];c[b+144+4>>2]=c[e+32+4>>2];c[b+144+8>>2]=c[e+32+8>>2];c[b+144+12>>2]=c[e+32+12>>2];c[b+160>>2]=c[e+48>>2];c[b+160+4>>2]=c[e+48+4>>2];c[b+160+8>>2]=c[e+48+8>>2];c[b+160+12>>2]=c[e+48+12>>2];e=b+680|0;h=e+48|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(h|0));c[b+740>>2]=0;c[b+740+4>>2]=0;c[b+740+8>>2]=0;c[b+740+12>>2]=0;c[b+756>>2]=1045220557;c[b+760>>2]=1045220557;c[b+764>>2]=1045220557;c[b+768>>2]=0;c[b+768+4>>2]=0;c[b+768+8>>2]=0;c[b+768+12>>2]=0;c[b+768+16>>2]=0;g[b+728>>2]=.699999988079071;g[b+732>>2]=1.0;g[b+736>>2]=.5;a[b+788>>0]=0;g[b+792>>2]=0.0;g[b+808>>2]=0.0;a[b+789>>0]=0;g[b+796>>2]=0.0;g[b+812>>2]=0.0;a[b+790>>0]=0;g[b+800>>2]=0.0;g[b+816>>2]=0.0;g[b+928>>2]=0.0;g[b+876>>2]=0.0;g[b+880>>2]=.10000000149011612;g[b+884>>2]=300.0;g[b+868>>2]=1.0;g[b+872>>2]=-1.0;g[b+896>>2]=0.0;g[b+900>>2]=.20000000298023224;g[b+904>>2]=0.0;g[b+908>>2]=0.0;g[b+888>>2]=1.0;g[b+892>>2]=.5;c[b+924>>2]=0;g[b+916>>2]=0.0;a[b+912>>0]=0;g[b+992>>2]=0.0;g[b+940>>2]=0.0;g[b+944>>2]=.10000000149011612;g[b+948>>2]=300.0;g[b+932>>2]=1.0;g[b+936>>2]=-1.0;g[b+960>>2]=0.0;g[b+964>>2]=.20000000298023224;g[b+968>>2]=0.0;g[b+972>>2]=0.0;g[b+952>>2]=1.0;g[b+956>>2]=.5;c[b+988>>2]=0;g[b+980>>2]=0.0;a[b+976>>0]=0;g[b+1056>>2]=0.0;g[b+1004>>2]=0.0;g[b+1008>>2]=.10000000149011612;g[b+1012>>2]=300.0;g[b+996>>2]=1.0;g[b+1e3>>2]=-1.0;g[b+1024>>2]=0.0;g[b+1028>>2]=.20000000298023224;g[b+1032>>2]=0.0;g[b+1036>>2]=0.0;g[b+1016>>2]=1.0;g[b+1020>>2]=.5;c[b+1052>>2]=0;g[b+1044>>2]=0.0;a[b+1040>>0]=0;a[b+1300>>0]=f&1;a[b+1301>>0]=1;c[b+1304>>2]=0;a[b+1308>>0]=0;y=+g[b+112>>2];E=+g[d+4>>2];x=+g[b+128>>2];D=+g[d+8>>2];w=+g[b+144>>2];C=+g[d+12>>2];v=+g[b+116>>2];u=+g[b+132>>2];t=+g[b+148>>2];s=+g[b+120>>2];q=+g[b+136>>2];o=+g[b+152>>2];B=+g[d+20>>2];A=+g[d+24>>2];z=+g[d+28>>2];r=+g[d+36>>2];p=+g[d+40>>2];n=+g[d+44>>2];G=+g[b+160>>2];F=+g[b+164>>2];l=+g[b+168>>2];m=+g[d+52>>2]+(E*G+D*F+C*l);k=B*G+A*F+z*l+ +g[d+56>>2];l=r*G+p*F+n*l+ +g[d+60>>2];g[b+48>>2]=y*E+x*D+w*C;g[b+52>>2]=E*v+D*u+C*t;g[b+56>>2]=E*s+D*q+C*o;g[b+60>>2]=0.0;g[b+64>>2]=y*B+x*A+w*z;g[b+68>>2]=v*B+u*A+t*z;g[b+72>>2]=s*B+q*A+o*z;g[b+76>>2]=0.0;g[b+80>>2]=y*r+x*p+w*n;g[b+84>>2]=v*r+u*p+t*n;g[b+88>>2]=s*r+q*p+o*n;g[b+92>>2]=0.0;g[b+96>>2]=m;g[b+100>>2]=k;g[b+104>>2]=l;g[b+108>>2]=0.0;_o(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);i=j;return}function np(a){a=a|0;c[a>>2]=7188;if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function op(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0;pp(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);c[d>>2]=0;c[d+4>>2]=0;switch(c[b+956>>2]|0){case 4:{c[d>>2]=2;e=2;break}case 0:{e=0;break}default:{c[d>>2]=1;e=1}}if(a[b+792>>0]|0){e=e+1|0;c[d>>2]=e}if(a[b+798>>0]|0){e=e+1|0;c[d>>2]=e}switch(c[b+960>>2]|0){case 4:{e=e+2|0;c[d>>2]=e;break}case 0:break;default:{e=e+1|0;c[d>>2]=e}}if(a[b+793>>0]|0){e=e+1|0;c[d>>2]=e}if(a[b+799>>0]|0){e=e+1|0;c[d>>2]=e}switch(c[b+964>>2]|0){case 4:{e=e+2|0;c[d>>2]=e;break}case 0:break;default:{e=e+1|0;c[d>>2]=e}}if(a[b+794>>0]|0){e=e+1|0;c[d>>2]=e}if(!(a[b+800>>0]|0))j=0;else{e=e+1|0;c[d>>2]=e;j=0}do{f=+g[b+968+(j*88|0)>>2];h=+g[b+968+(j*88|0)+4>>2];i=+ap(+g[b+1364+(j<<2)>>2],f,h);g[b+968+(j*88|0)+80>>2]=i;do if(!(f>h)){g[b+968+(j*88|0)+72>>2]=i-f;if(f==h){c[b+968+(j*88|0)+84>>2]=3;e=e+1|0;c[d>>2]=e;break}else{g[b+968+(j*88|0)+76>>2]=i-h;c[b+968+(j*88|0)+84>>2]=4;e=e+2|0;c[d>>2]=e;break}}else{c[b+968+(j*88|0)+84>>2]=0;g[b+968+(j*88|0)+72>>2]=0.0}while(0);if(a[b+968+(j*88|0)+28>>0]|0){e=e+1|0;c[d>>2]=e}if(a[b+968+(j*88|0)+48>>0]|0){e=e+1|0;c[d>>2]=e}j=j+1|0}while((j|0)!=3);return}function pp(b,d,e){b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,V=0.0,X=0.0,Y=0.0;V=+g[b+48>>2];i=+g[d>>2];X=+g[b+64>>2];y=+g[d+4>>2];Y=+g[b+80>>2];f=+g[d+8>>2];B=+g[b+52>>2];A=+g[b+68>>2];z=+g[b+84>>2];Q=+g[b+56>>2];S=+g[b+72>>2];N=+g[b+88>>2];E=+g[d+16>>2];D=+g[d+20>>2];C=+g[d+24>>2];R=+g[d+32>>2];x=+g[d+36>>2];s=+g[d+40>>2];k=+g[b+96>>2];h=+g[b+100>>2];T=+g[b+104>>2];P=+g[d+48>>2]+(i*k+y*h+f*T);w=E*k+D*h+C*T+ +g[d+52>>2];T=R*k+x*h+s*T+ +g[d+56>>2];g[b+1236>>2]=V*i+X*y+Y*f;g[b+1240>>2]=i*B+y*A+f*z;g[b+1244>>2]=i*Q+y*S+f*N;g[b+1248>>2]=0.0;g[b+1252>>2]=V*E+X*D+Y*C;g[b+1256>>2]=B*E+A*D+z*C;g[b+1260>>2]=Q*E+S*D+N*C;g[b+1264>>2]=0.0;g[b+1268>>2]=V*R+X*x+Y*s;g[b+1272>>2]=B*R+A*x+z*s;g[b+1276>>2]=Q*R+S*x+N*s;g[b+1280>>2]=0.0;g[b+1284>>2]=P;g[b+1288>>2]=w;g[b+1292>>2]=T;g[b+1296>>2]=0.0;T=+g[b+112>>2];w=+g[e>>2];P=+g[b+128>>2];s=+g[e+4>>2];N=+g[b+144>>2];x=+g[e+8>>2];S=+g[b+116>>2];R=+g[b+132>>2];Q=+g[b+148>>2];z=+g[b+120>>2];A=+g[b+136>>2];B=+g[b+152>>2];Y=+g[e+16>>2];X=+g[e+20>>2];V=+g[e+24>>2];C=+g[e+32>>2];D=+g[e+36>>2];E=+g[e+40>>2];f=+g[b+160>>2];y=+g[b+164>>2];i=+g[b+168>>2];h=+g[e+48>>2]+(w*f+s*y+x*i);k=Y*f+X*y+V*i+ +g[e+52>>2];i=C*f+D*y+E*i+ +g[e+56>>2];g[b+1300>>2]=T*w+P*s+N*x;g[b+1304>>2]=w*S+s*R+x*Q;g[b+1308>>2]=w*z+s*A+x*B;g[b+1312>>2]=0.0;g[b+1316>>2]=T*Y+P*X+N*V;g[b+1320>>2]=S*Y+R*X+Q*V;g[b+1324>>2]=z*Y+A*X+B*V;g[b+1328>>2]=0.0;g[b+1332>>2]=T*C+P*D+N*E;g[b+1336>>2]=S*C+R*D+Q*E;g[b+1340>>2]=z*C+A*D+B*E;g[b+1344>>2]=0.0;g[b+1348>>2]=h;g[b+1352>>2]=k;g[b+1356>>2]=i;g[b+1360>>2]=0.0;h=h-+g[b+1284>>2];k=k-+g[b+1288>>2];i=i-+g[b+1292>>2];Q=+g[b+1256>>2];R=+g[b+1276>>2];S=+g[b+1260>>2];N=+g[b+1272>>2];P=+g[b+1268>>2];T=+g[b+1252>>2];V=+g[b+1236>>2];X=+g[b+1240>>2];Y=+g[b+1244>>2];x=1.0/((Q*R-S*N)*V+X*(S*P-R*T)+(N*T-Q*P)*Y);s=(Q*R-S*N)*x;w=(S*P-R*T)*x;y=(N*T-Q*P)*x;f=i*((S*X-Q*Y)*x)+(h*s+k*((N*Y-R*X)*x));j=i*((T*Y-S*V)*x)+(h*w+k*((R*V-P*Y)*x));k=i*((Q*V-T*X)*x)+(h*y+k*((P*X-N*V)*x));g[b+1428>>2]=f;g[b+1432>>2]=j;g[b+1436>>2]=k;g[b+1440>>2]=0.0;g[b+940>>2]=f;h=+g[b+680>>2];i=+g[b+696>>2];do if(!(h>i)){g[b+908>>2]=f-h;if(h==i){c[b+956>>2]=3;break}else{g[b+924>>2]=f-i;c[b+956>>2]=4;break}}else{g[b+908>>2]=0.0;c[b+956>>2]=0}while(0);g[b+944>>2]=j;f=+g[b+684>>2];h=+g[b+700>>2];do if(!(f>h)){g[b+912>>2]=j-f;if(f==h){c[b+960>>2]=3;break}else{g[b+928>>2]=j-h;c[b+960>>2]=4;break}}else{g[b+912>>2]=0.0;c[b+960>>2]=0}while(0);g[b+948>>2]=k;f=+g[b+688>>2];h=+g[b+704>>2];do if(!(f>h)){g[b+916>>2]=k-f;if(f==h){c[b+964>>2]=3;break}else{g[b+932>>2]=k-h;c[b+964>>2]=4;break}}else{g[b+916>>2]=0.0;c[b+964>>2]=0}while(0);H=+g[b+1300>>2];I=+g[b+1316>>2];J=+g[b+1332>>2];u=J*((S*X-Q*Y)*x)+(H*s+I*((N*Y-R*X)*x));K=+g[b+1304>>2];L=+g[b+1320>>2];M=+g[b+1336>>2];v=s*K+(N*Y-R*X)*x*L+(S*X-Q*Y)*x*M;F=+g[b+1308>>2];G=+g[b+1324>>2];k=s*F+(N*Y-R*X)*x*G+(S*X-Q*Y)*x*(z*C+A*D+B*E);s=J*((T*Y-S*V)*x)+(H*w+I*((R*V-P*Y)*x));t=K*w+(R*V-P*Y)*x*L+(T*Y-S*V)*x*M;h=w*F+(R*V-P*Y)*x*G+(T*Y-S*V)*x*(z*C+A*D+B*E);i=J*((Q*V-T*X)*x)+(H*y+I*((P*X-N*V)*x));j=K*y+(P*X-N*V)*x*L+(Q*V-T*X)*x*M;f=y*F+(P*X-N*V)*x*G+(Q*V-T*X)*x*(z*C+A*D+B*E);switch(c[b+1232>>2]|0){case 0:{do if(i<1.0)if(i>-1.0){g[b+1364>>2]=+W(+-j,+f);X=i<-1.0?-1.0:i;g[b+1368>>2]=+U(+(X>1.0?1.0:X));g[b+1372>>2]=+W(+-s,+u);break}else{g[b+1364>>2]=-+W(+v,+t);g[b+1368>>2]=-1.5707963705062866;g[b+1372>>2]=0.0;break}else{g[b+1364>>2]=+W(+v,+t);g[b+1368>>2]=1.5707963705062866;g[b+1372>>2]=0.0}while(0);g[b+1396>>2]=J*S-I*R;g[b+1400>>2]=H*R-J*Y;g[b+1404>>2]=I*Y-H*S;g[b+1408>>2]=0.0;g[b+1380>>2]=R*(H*R-J*Y)-S*(I*Y-H*S);g[b+1384>>2]=Y*(I*Y-H*S)-R*(J*S-I*R);g[b+1388>>2]=S*(J*S-I*R)-Y*(H*R-J*Y);g[b+1392>>2]=0.0;g[b+1412>>2]=I*(I*Y-H*S)-J*(H*R-J*Y);g[b+1416>>2]=J*(J*S-I*R)-H*(I*Y-H*S);g[b+1420>>2]=H*(H*R-J*Y)-I*(J*S-I*R);g[b+1424>>2]=0.0;d=b+1380|0;e=b+1384|0;l=b+1388|0;m=b+1396|0;n=b+1400|0;o=b+1404|0;p=b+1412|0;q=b+1416|0;r=b+1420|0;i=R*(H*R-J*Y)-S*(I*Y-H*S);j=Y*(I*Y-H*S)-R*(J*S-I*R);k=S*(J*S-I*R)-Y*(H*R-J*Y);s=J*S-I*R;t=H*R-J*Y;u=I*Y-H*S;v=I*(I*Y-H*S)-J*(H*R-J*Y);h=J*(J*S-I*R)-H*(I*Y-H*S);f=H*(H*R-J*Y)-I*(J*S-I*R);break}case 1:{do if(s<1.0)if(s>-1.0){g[b+1364>>2]=+W(+h,+t);g[b+1368>>2]=+W(+i,+u);Y=-s<-1.0?-1.0:-s;g[b+1372>>2]=+U(+(Y>1.0?1.0:Y));break}else{g[b+1364>>2]=-+W(+-k,+f);g[b+1368>>2]=0.0;g[b+1372>>2]=1.5707963705062866;break}else{g[b+1364>>2]=+W(+-k,+f);g[b+1368>>2]=0.0;g[b+1372>>2]=-1.5707963705062866}while(0);g[b+1412>>2]=I*N-J*Q;g[b+1416>>2]=J*X-H*N;g[b+1420>>2]=H*Q-I*X;g[b+1424>>2]=0.0;g[b+1380>>2]=Q*(H*Q-I*X)-N*(J*X-H*N);g[b+1384>>2]=N*(I*N-J*Q)-X*(H*Q-I*X);g[b+1388>>2]=X*(J*X-H*N)-Q*(I*N-J*Q);g[b+1392>>2]=0.0;g[b+1396>>2]=J*(J*X-H*N)-I*(H*Q-I*X);g[b+1400>>2]=H*(H*Q-I*X)-J*(I*N-J*Q);g[b+1404>>2]=I*(I*N-J*Q)-H*(J*X-H*N);g[b+1408>>2]=0.0;d=b+1380|0;e=b+1384|0;l=b+1388|0;m=b+1396|0;n=b+1400|0;o=b+1404|0;p=b+1412|0;q=b+1416|0;r=b+1420|0;i=Q*(H*Q-I*X)-N*(J*X-H*N);j=N*(I*N-J*Q)-X*(H*Q-I*X);k=X*(J*X-H*N)-Q*(I*N-J*Q);s=J*(J*X-H*N)-I*(H*Q-I*X);t=H*(H*Q-I*X)-J*(I*N-J*Q);u=I*(I*N-J*Q)-H*(J*X-H*N);v=I*N-J*Q;h=J*X-H*N;f=H*Q-I*X;break}case 2:{do if(j<1.0)if(j>-1.0){X=-j<-1.0?-1.0:-j;g[b+1364>>2]=+U(+(X>1.0?1.0:X));g[b+1368>>2]=+W(+i,+f);g[b+1372>>2]=+W(+v,+t);break}else{g[b+1364>>2]=1.5707963705062866;g[b+1368>>2]=-+W(+-s,+u);g[b+1372>>2]=0.0;break}else{g[b+1364>>2]=-1.5707963705062866;g[b+1368>>2]=+W(+-s,+u);g[b+1372>>2]=0.0}while(0);g[b+1380>>2]=L*R-M*S;g[b+1384>>2]=M*Y-K*R;g[b+1388>>2]=K*S-L*Y;g[b+1392>>2]=0.0;g[b+1396>>2]=S*(K*S-L*Y)-R*(M*Y-K*R);g[b+1400>>2]=R*(L*R-M*S)-Y*(K*S-L*Y);g[b+1404>>2]=Y*(M*Y-K*R)-S*(L*R-M*S);g[b+1408>>2]=0.0;g[b+1412>>2]=M*(M*Y-K*R)-L*(K*S-L*Y);g[b+1416>>2]=K*(K*S-L*Y)-M*(L*R-M*S);g[b+1420>>2]=L*(L*R-M*S)-K*(M*Y-K*R);g[b+1424>>2]=0.0;d=b+1380|0;e=b+1384|0;l=b+1388|0;m=b+1396|0;n=b+1400|0;o=b+1404|0;p=b+1412|0;q=b+1416|0;r=b+1420|0;i=L*R-M*S;j=M*Y-K*R;k=K*S-L*Y;s=S*(K*S-L*Y)-R*(M*Y-K*R);t=R*(L*R-M*S)-Y*(K*S-L*Y);u=Y*(M*Y-K*R)-S*(L*R-M*S);v=M*(M*Y-K*R)-L*(K*S-L*Y);h=K*(K*S-L*Y)-M*(L*R-M*S);f=L*(L*R-M*S)-K*(M*Y-K*R);break}case 3:{do if(v<1.0)if(v>-1.0){g[b+1364>>2]=+W(+-j,+t);g[b+1368>>2]=+W(+-k,+u);Y=v<-1.0?-1.0:v;g[b+1372>>2]=+U(+(Y>1.0?1.0:Y));break}else{g[b+1364>>2]=0.0;g[b+1368>>2]=-+W(+h,+f);g[b+1372>>2]=-1.5707963705062866;break}else{g[b+1364>>2]=0.0;g[b+1368>>2]=+W(+h,+f);g[b+1372>>2]=1.5707963705062866}while(0);g[b+1412>>2]=T*M-P*L;g[b+1416>>2]=P*K-V*M;g[b+1420>>2]=V*L-T*K;g[b+1424>>2]=0.0;g[b+1380>>2]=L*(V*L-T*K)-M*(P*K-V*M);g[b+1384>>2]=M*(T*M-P*L)-K*(V*L-T*K);g[b+1388>>2]=K*(P*K-V*M)-L*(T*M-P*L);g[b+1392>>2]=0.0;g[b+1396>>2]=P*(P*K-V*M)-T*(V*L-T*K);g[b+1400>>2]=V*(V*L-T*K)-P*(T*M-P*L);g[b+1404>>2]=T*(T*M-P*L)-V*(P*K-V*M);g[b+1408>>2]=0.0;d=b+1380|0;e=b+1384|0;l=b+1388|0;m=b+1396|0;n=b+1400|0;o=b+1404|0;p=b+1412|0;q=b+1416|0;r=b+1420|0;i=L*(V*L-T*K)-M*(P*K-V*M);j=M*(T*M-P*L)-K*(V*L-T*K);k=K*(P*K-V*M)-L*(T*M-P*L);s=P*(P*K-V*M)-T*(V*L-T*K);t=V*(V*L-T*K)-P*(T*M-P*L);u=T*(T*M-P*L)-V*(P*K-V*M);v=T*M-P*L;h=P*K-V*M;f=V*L-T*K;break}case 4:{do if(h<1.0)if(h>-1.0){Y=h<-1.0?-1.0:h;g[b+1364>>2]=+U(+(Y>1.0?1.0:Y));g[b+1368>>2]=+W(+-k,+f);g[b+1372>>2]=+W(+-s,+t);break}else{g[b+1364>>2]=-1.5707963705062866;g[b+1368>>2]=0.0;g[b+1372>>2]=-+W(+i,+u);break}else{g[b+1364>>2]=1.5707963705062866;g[b+1368>>2]=0.0;g[b+1372>>2]=+W(+i,+u)}while(0);Y=Q*(z*C+A*D+B*E)-N*G;f=N*F-X*(z*C+A*D+B*E);g[b+1380>>2]=Y;g[b+1384>>2]=f;g[b+1388>>2]=X*G-Q*F;g[b+1392>>2]=0.0;s=G*(X*G-Q*F)-(z*C+A*D+B*E)*f;t=(z*C+A*D+B*E)*Y-F*(X*G-Q*F);g[b+1396>>2]=s;g[b+1400>>2]=t;g[b+1404>>2]=F*f-G*Y;g[b+1408>>2]=0.0;g[b+1412>>2]=N*f-Q*(X*G-Q*F);g[b+1416>>2]=X*(X*G-Q*F)-N*Y;g[b+1420>>2]=Q*Y-X*f;g[b+1424>>2]=0.0;d=b+1380|0;e=b+1384|0;l=b+1388|0;m=b+1396|0;n=b+1400|0;o=b+1404|0;p=b+1412|0;q=b+1416|0;r=b+1420|0;i=Y;j=f;k=X*G-Q*F;u=F*f-G*Y;v=N*f-Q*(X*G-Q*F);h=X*(X*G-Q*F)-N*Y;f=Q*Y-X*f;break}case 5:{do if(k<1.0)if(k>-1.0){g[b+1364>>2]=+W(+h,+f);Y=-k<-1.0?-1.0:-k;g[b+1368>>2]=+U(+(Y>1.0?1.0:Y));g[b+1372>>2]=+W(+v,+u);break}else{g[b+1364>>2]=0.0;g[b+1368>>2]=1.5707963705062866;g[b+1372>>2]=-+W(+s,+i);break}else{g[b+1364>>2]=0.0;g[b+1368>>2]=-1.5707963705062866;g[b+1372>>2]=+W(+-s,+-i)}while(0);f=P*G-T*(z*C+A*D+B*E);Y=V*(z*C+A*D+B*E)-P*F;g[b+1396>>2]=f;g[b+1400>>2]=Y;g[b+1404>>2]=T*F-V*G;g[b+1408>>2]=0.0;i=(z*C+A*D+B*E)*Y-G*(T*F-V*G);j=F*(T*F-V*G)-(z*C+A*D+B*E)*f;g[b+1380>>2]=i;g[b+1384>>2]=j;g[b+1388>>2]=G*f-F*Y;g[b+1392>>2]=0.0;g[b+1412>>2]=T*(T*F-V*G)-P*Y;g[b+1416>>2]=P*f-V*(T*F-V*G);g[b+1420>>2]=V*Y-T*f;g[b+1424>>2]=0.0;d=b+1380|0;e=b+1384|0;l=b+1388|0;m=b+1396|0;n=b+1400|0;o=b+1404|0;p=b+1412|0;q=b+1416|0;r=b+1420|0;k=G*f-F*Y;s=f;t=Y;u=T*F-V*G;v=T*(T*F-V*G)-P*Y;h=P*f-V*(T*F-V*G);f=V*Y-T*f;break}default:{d=b+1380|0;e=b+1384|0;l=b+1388|0;m=b+1396|0;n=b+1400|0;o=b+1404|0;p=b+1412|0;q=b+1416|0;r=b+1420|0;i=+g[b+1380>>2];j=+g[b+1384>>2];k=+g[b+1388>>2];s=+g[b+1396>>2];t=+g[b+1400>>2];u=+g[b+1404>>2];v=+g[b+1412>>2];h=+g[b+1416>>2];f=+g[b+1420>>2]}}X=1.0/+O(+(i*i+j*j+k*k));g[d>>2]=i*X;g[e>>2]=j*X;g[l>>2]=k*X;X=1.0/+O(+(s*s+t*t+u*u));g[m>>2]=s*X;g[n>>2]=t*X;g[o>>2]=u*X;X=1.0/+O(+(v*v+h*h+f*f));g[p>>2]=v*X;g[q>>2]=h*X;g[r>>2]=f*X;X=+g[(c[b+28>>2]|0)+368>>2];Y=+g[(c[b+32>>2]|0)+368>>2];a[b+1452>>0]=(X<1.1920928955078125e-07|Y<1.1920928955078125e-07)&1;Y=X+Y>0.0?Y/(X+Y):.5;g[b+1444>>2]=Y;g[b+1448>>2]=1.0-Y;return}function qp(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0;p=i;i=i+112|0;m=c[b+28>>2]|0;n=c[b+32>>2]|0;c[p+16>>2]=c[1836];c[p+16+4>>2]=c[1837];c[p+16+8>>2]=c[1838];switch(c[b+1232>>2]|0){case 0:{c[p+16>>2]=0;c[p+16+4>>2]=1;c[p+16+8>>2]=2;e=0;break}case 1:{c[p+16>>2]=0;c[p+16+4>>2]=2;c[p+16+8>>2]=1;e=0;break}case 2:{c[p+16>>2]=1;c[p+16+4>>2]=0;c[p+16+8>>2]=2;e=1;break}case 3:{c[p+16>>2]=1;c[p+16+4>>2]=2;c[p+16+8>>2]=0;e=1;break}case 4:{c[p+16>>2]=2;c[p+16+4>>2]=0;c[p+16+8>>2]=1;e=2;break}case 5:{c[p+16>>2]=2;c[p+16+4>>2]=1;c[p+16+8>>2]=0;e=2;break}default:e=0}f=0;k=0;while(1){h=b+968+(e*88|0)|0;if(!(((c[b+968+(e*88|0)+84>>2]|0)==0?(a[b+968+(e*88|0)+28>>0]|0)==0:0)?(a[b+968+(e*88|0)+48>>0]|0)==0:0)){j=b+1380+(e<<4)|0;c[p>>2]=c[j>>2];c[p+4>>2]=c[j+4>>2];c[p+8>>2]=c[j+8>>2];c[p+12>>2]=c[j+12>>2];j=c[b+1456>>2]>>(e<<2)+12;if(!(j&1))c[b+968+(e*88|0)+16>>2]=c[c[d+32>>2]>>2];if(!(j&2))c[b+968+(e*88|0)+12>>2]=c[d+4>>2];if(!(j&4))c[b+968+(e*88|0)+24>>2]=c[c[d+32>>2]>>2];if(!(j&8))c[b+968+(e*88|0)+20>>2]=c[d+4>>2];k=(rp(b,h,m+4|0,n+4|0,m+336|0,n+336|0,m+352|0,n+352|0,d,k,p,1,0)|0)+k|0}f=f+1|0;if((f|0)==3)break;e=c[p+16+(f<<2)>>2]|0}g[p+16>>2]=1.0;g[p+16+4>>2]=-1.0;g[p+16+8>>2]=0.0;g[p+16+12>>2]=.20000000298023224;g[p+16+16>>2]=0.0;g[p+16+20>>2]=.8999999761581421;g[p+16+24>>2]=0.0;a[p+16+28>>0]=0;g[p+16+32>>2]=0.0;g[p+16+36>>2]=.10000000149011612;a[p+16+40>>0]=0;g[p+16+44>>2]=0.0;a[p+16+48>>0]=0;g[p+16+52>>2]=0.0;a[p+16+56>>0]=0;g[p+16+60>>2]=0.0;a[p+16+64>>0]=0;l=p+16+68|0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;f=k;k=0;while(1){h=c[b+956+(k<<2)>>2]|0;e=a[b+792+k>>0]|0;j=a[b+798+k>>0]|0;if((h|0)==0&e<<24>>24==0)if(!(j<<24>>24))e=k+1|0;else{e=0;o=27}else o=27;if((o|0)==27){o=0;c[p+16+8>>2]=c[b+712+(k<<2)>>2];c[p+16+84>>2]=h;c[p+16+80>>2]=c[b+940+(k<<2)>>2];c[p+16+72>>2]=c[b+908+(k<<2)>>2];c[p+16+76>>2]=c[b+924+(k<<2)>>2];a[p+16+28>>0]=e;a[p+16+40>>0]=a[b+795+k>>0]|0;c[p+16+44>>2]=c[b+804+(k<<2)>>2];a[p+16+48>>0]=j;c[p+16+52>>2]=c[b+820+(k<<2)>>2];a[p+16+56>>0]=a[b+836+k>>0]|0;c[p+16+60>>2]=c[b+840+(k<<2)>>2];a[p+16+64>>0]=a[b+856+k>>0]|0;c[l>>2]=c[b+860+(k<<2)>>2];c[p+16+4>>2]=c[b+696+(k<<2)>>2];c[p+16>>2]=c[b+680+(k<<2)>>2];c[p+16+36>>2]=c[b+892+(k<<2)>>2];c[p+16+32>>2]=c[b+876+(k<<2)>>2];c[p>>2]=c[b+1236+(k<<2)>>2];c[p+4>>2]=c[b+1252+(k<<2)>>2];c[p+8>>2]=c[b+1268+(k<<2)>>2];g[p+12>>2]=0.0;h=c[b+1456>>2]>>(k<<2);if(!(h&1))e=c[d+32>>2]|0;else e=b+744+(k<<2)|0;c[p+16+16>>2]=c[e>>2];c[p+16+12>>2]=c[((h&2|0)==0?d+4|0:b+728+(k<<2)|0)>>2];if(!(h&4))e=c[d+32>>2]|0;else e=b+776+(k<<2)|0;c[p+16+24>>2]=c[e>>2];c[p+16+20>>2]=c[((h&8|0)==0?d+4|0:b+760+(k<<2)|0)>>2];e=k+1|0;j=(e|0)==3?0:e;k=(k+2|0)%3|0;h=c[b+968+(j*88|0)+84>>2]|0;switch(h|0){case 2:case 1:{j=1;break}case 3:{q=+g[b+968+(j*88|0)+72>>2];j=q<-.001|q>.001;break}default:if((h|0)==4)if(+g[b+968+(j*88|0)+72>>2]<-.001)j=1;else j=+g[b+968+(j*88|0)+76>>2]>.001;else j=0}switch(c[b+968+(k*88|0)+84>>2]|0){case 2:case 1:{o=42;break}case 3:{q=+g[b+968+(k*88|0)+72>>2];if(q<-.001|q>.001)o=42;else h=1;break}case 4:{if(!(+g[b+968+(k*88|0)+72>>2]<-.001)?!(+g[b+968+(k*88|0)+76>>2]>.001):0)h=1;else o=42;break}default:h=1}if((o|0)==42){o=0;h=0}f=(rp(b,p+16|0,m+4|0,n+4|0,m+336|0,n+336|0,m+352|0,n+352|0,d,f,p,0,j?h:1)|0)+f|0}if((e|0)==3)break;else k=e}i=p;return}
function Zg(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0.0,h=0.0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0;k=i;i=i+32|0;n=+g[a+60>>2];r=+g[a+76>>2]-n;m=+g[a+64>>2];p=+g[a+80>>2]-m;l=+g[a+68>>2];s=+g[a+84>>2]-l;o=+g[a+92>>2]-n;q=+g[a+96>>2]-m;h=+g[a+100>>2]-l;j=1.0/+O(+((r*q-p*o)*(r*q-p*o)+((p*h-s*q)*(p*h-s*q)+(s*o-r*h)*(s*o-r*h))));f=j*(p*h-s*q);h=j*(s*o-r*h);j=(r*q-p*o)*j;l=j*+g[b+8>>2]+(+g[b>>2]*f+ +g[b+4>>2]*h)-(f*n+h*m+j*l);if(!(l>=-d)|!(l<=d)){a=0;i=k;return a|0}e=0;while(1){bc[c[(c[a>>2]|0)+104>>2]&127](a,e,k+16|0,k);n=+g[k+16>>2];s=+g[k>>2]-n;p=+g[k+16+4>>2];o=+g[k+4>>2]-p;m=+g[k+16+8>>2];r=+g[k+8>>2]-m;q=1.0/+O(+((h*s-f*o)*(h*s-f*o)+((j*o-h*r)*(j*o-h*r)+(f*r-j*s)*(f*r-j*s))));e=e+1|0;if((h*s-f*o)*q*+g[b+8>>2]+(+g[b>>2]*(q*(j*o-h*r))+ +g[b+4>>2]*(q*(f*r-j*s)))-(m*((h*s-f*o)*q)+(n*(q*(j*o-h*r))+p*(q*(f*r-j*s))))<-d){e=0;b=5;break}if((e|0)>=3){e=1;b=5;break}}if((b|0)==5){i=k;return e|0}return 0}function _g(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0;h=+g[a+60>>2];k=+g[a+76>>2]-h;j=+g[a+64>>2];i=+g[a+80>>2]-j;l=+g[a+68>>2];m=+g[a+84>>2]-l;h=+g[a+92>>2]-h;j=+g[a+96>>2]-j;l=+g[a+100>>2]-l;g[d+12>>2]=0.0;f=1.0/+O(+((k*j-i*h)*(k*j-i*h)+((i*l-m*j)*(i*l-m*j)+(m*h-k*l)*(m*h-k*l))));g[d>>2]=(i*l-m*j)*f;g[d+4>>2]=(m*h-k*l)*f;g[d+8>>2]=(k*j-i*h)*f;c[e>>2]=c[a+60>>2];c[e+4>>2]=c[a+60+4>>2];c[e+8>>2]=c[a+60+8>>2];c[e+12>>2]=c[a+60+12>>2];return}function $g(a){a=a|0;var b=0;c[a>>2]=3720;c[a+12>>2]=3748;b=c[a+60>>2]|0;tb[c[(c[b>>2]|0)+20>>2]&127](b,c[a+76>>2]|0);b=c[a+60>>2]|0;tb[c[(c[b>>2]|0)+16>>2]&127](b,c[a+76>>2]|0);rG(a);return}function ah(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;k=i;i=i+64|0;l=(a[b+8>>0]|0)!=0;j=l?e:d;d=l?d:e;e=c[d+4>>2]|0;if(((c[e+4>>2]|0)+-21|0)>>>0>=9){i=k;return}if((c[(c[j+4>>2]|0)+4>>2]|0)>=20){i=k;return}m=+Hb[c[(c[e>>2]|0)+48>>2]&15](e);c[h+4>>2]=c[b+76>>2];c[b+16>>2]=j;c[b+20>>2]=d;c[b+64>>2]=f;g[b+68>>2]=m;c[b+56>>2]=h;l=c[d+12>>2]|0;B=+g[l>>2];A=+g[l+16>>2];z=+g[l+32>>2];y=+g[l+4>>2];x=+g[l+20>>2];w=+g[l+36>>2];s=+g[l+8>>2];q=+g[l+24>>2];o=+g[l+40>>2];v=-+g[l+48>>2];u=-+g[l+52>>2];t=-+g[l+56>>2];l=c[j+12>>2]|0;K=+g[l>>2];J=+g[l+16>>2];I=+g[l+32>>2];H=+g[l+4>>2];G=+g[l+20>>2];F=+g[l+36>>2];E=+g[l+8>>2];D=+g[l+24>>2];C=+g[l+40>>2];r=+g[l+48>>2];p=+g[l+52>>2];n=+g[l+56>>2];g[k>>2]=B*K+A*J+z*I;g[k+4>>2]=B*H+A*G+z*F;g[k+8>>2]=B*E+A*D+z*C;g[k+12>>2]=0.0;g[k+16>>2]=y*K+x*J+w*I;g[k+20>>2]=y*H+x*G+w*F;g[k+24>>2]=y*E+x*D+w*C;g[k+28>>2]=0.0;g[k+32>>2]=s*K+q*J+o*I;g[k+36>>2]=s*H+q*G+o*F;g[k+40>>2]=s*E+q*D+o*C;g[k+44>>2]=0.0;g[k+48>>2]=B*v+A*u+z*t+(B*r+A*p+z*n);g[k+52>>2]=y*v+x*u+w*t+(y*r+x*p+w*n);g[k+56>>2]=s*v+q*u+o*t+(s*r+q*p+o*n);g[k+60>>2]=0.0;l=c[(c[b+16>>2]|0)+4>>2]|0;bc[c[(c[l>>2]|0)+8>>2]&127](l,k,b+24|0,b+40|0);g[b+40>>2]=+g[b+40>>2]+m;g[b+44>>2]=+g[b+44>>2]+m;g[b+48>>2]=+g[b+48>>2]+m;g[b+24>>2]=+g[b+24>>2]-m;g[b+28>>2]=+g[b+28>>2]-m;g[b+32>>2]=+g[b+32>>2]-m;l=c[b+76>>2]|0;f=c[d+8>>2]|0;c[l+740>>2]=c[j+8>>2];c[l+744>>2]=f;bc[c[(c[e>>2]|0)+64>>2]&127](e,b+12|0,b+24|0,b+40|0);e=c[h+4>>2]|0;do if(c[e+748>>2]|0){j=c[e+740>>2]|0;f=c[(c[h+8>>2]|0)+8>>2]|0;d=c[(c[h+12>>2]|0)+8>>2]|0;if((j|0)==(f|0)){Xn(e,j+4|0,d+4|0);break}else{Xn(e,d+4|0,f+4|0);break}}while(0);c[b+16>>2]=0;c[b+20>>2]=0;i=k;return}function bh(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0,X=0.0,Y=0.0;W=i;i=i+240|0;f=(a[b+8>>0]|0)!=0;h=f?e:d;f=f?d:e;S=+g[h+116>>2]-+g[h+52>>2];T=+g[h+120>>2]-+g[h+56>>2];U=+g[h+124>>2]-+g[h+60>>2];V=+g[h+256>>2];if(S*S+T*T+U*U<V*V){X=1.0;i=W;return +X}F=+g[f+4>>2];G=+g[f+20>>2];H=+g[f+36>>2];I=+g[f+8>>2];J=+g[f+24>>2];K=+g[f+40>>2];L=+g[f+12>>2];M=+g[f+28>>2];N=+g[f+44>>2];k=-+g[f+52>>2];l=-+g[f+56>>2];m=-+g[f+60>>2];O=+g[h+4>>2];P=+g[h+20>>2];Q=+g[h+36>>2];R=+g[h+8>>2];S=+g[h+24>>2];T=+g[h+40>>2];U=+g[h+12>>2];V=+g[h+28>>2];p=+g[h+44>>2];u=+g[h+52>>2];t=+g[h+56>>2];s=+g[h+60>>2];q=F*k+G*l+H*m+(F*u+G*t+H*s);r=I*k+J*l+K*m+(I*u+J*t+K*s);s=L*k+M*l+N*m+(L*u+M*t+N*s);t=+g[h+68>>2];u=+g[h+84>>2];v=+g[h+100>>2];w=+g[h+72>>2];x=+g[h+88>>2];y=+g[h+104>>2];z=+g[h+76>>2];A=+g[h+92>>2];B=+g[h+108>>2];n=+g[h+116>>2];o=+g[h+120>>2];E=+g[h+124>>2];C=F*k+G*l+H*m+(F*n+G*o+H*E);D=I*k+J*l+K*m+(I*n+J*o+K*E);E=L*k+M*l+N*m+(L*n+M*o+N*E);f=c[f+192>>2]|0;if(((c[f+4>>2]|0)+-21|0)>>>0>=9){X=1.0;i=W;return +X}g[W+224>>2]=q;g[W+224+4>>2]=r;g[W+224+8>>2]=s;g[W+224+12>>2]=0.0;if(C<q){g[W+224>>2]=C;j=C}else j=q;if(D<r){g[W+224+4>>2]=D;k=D}else k=r;if(E<s){g[W+224+8>>2]=E;l=E}else l=s;g[W+208>>2]=q;g[W+208+4>>2]=r;g[W+208+8>>2]=s;g[W+208+12>>2]=0.0;if(q<C){g[W+208>>2]=C;m=C}else m=q;if(r<D){g[W+208+4>>2]=D;n=D}else n=r;if(s<E){g[W+208+8>>2]=E;o=E}else o=s;Y=+g[h+252>>2];g[W+224>>2]=j-Y;g[W+224+4>>2]=k-Y;g[W+224+8>>2]=l-Y;g[W+208>>2]=Y+m;g[W+208+4>>2]=Y+n;g[W+208+8>>2]=Y+o;c[W>>2]=3904;g[W+4>>2]=F*O+G*P+H*Q;g[W+8>>2]=F*R+G*S+H*T;g[W+12>>2]=F*U+G*V+H*p;g[W+16>>2]=0.0;g[W+20>>2]=I*O+J*P+K*Q;g[W+24>>2]=I*R+J*S+K*T;g[W+28>>2]=I*U+J*V+K*p;g[W+32>>2]=0.0;g[W+36>>2]=L*O+M*P+N*Q;g[W+40>>2]=L*R+M*S+N*T;g[W+44>>2]=L*U+M*V+N*p;g[W+48>>2]=0.0;g[W+52>>2]=q;g[W+56>>2]=r;g[W+60>>2]=s;g[W+64>>2]=0.0;g[W+68>>2]=F*t+G*u+H*v;g[W+72>>2]=F*w+G*x+H*y;g[W+76>>2]=F*z+G*A+H*B;g[W+80>>2]=0.0;g[W+84>>2]=I*t+J*u+K*v;g[W+88>>2]=I*w+J*x+K*y;g[W+92>>2]=I*z+J*A+K*B;g[W+96>>2]=0.0;g[W+100>>2]=L*t+M*u+N*v;g[W+104>>2]=L*w+M*x+N*y;g[W+108>>2]=L*z+M*A+N*B;g[W+112>>2]=0.0;g[W+116>>2]=C;g[W+120>>2]=D;g[W+124>>2]=E;g[W+128>>2]=0.0;g[W+196>>2]=Y;c[W+200>>2]=c[h+248>>2];if(f|0?(bc[c[(c[f>>2]|0)+64>>2]&127](f,W,W+224|0,W+208|0),X=+g[W+200>>2],X<+g[h+248>>2]):0){g[h+248>>2]=X;Y=X;i=W;return +Y}Y=1.0;i=W;return +Y}function ch(a){a=a|0;rG(a);return}function dh(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0;f=i;i=i+784|0;c[f+720>>2]=1065353216;c[f+720+4>>2]=0;c[f+720+4+4>>2]=0;c[f+720+4+8>>2]=0;c[f+720+4+12>>2]=0;c[f+720+20>>2]=1065353216;c[f+720+24>>2]=0;c[f+720+24+4>>2]=0;c[f+720+24+8>>2]=0;c[f+720+24+12>>2]=0;c[f+720+40>>2]=1065353216;e=f+720+44|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[f+544>>2]=3316;c[f+544+168>>2]=0;g[f+544+172>>2]=0.0;c[f+544+164>>2]=c[b+200>>2];e=c[b+196>>2]|0;c[f+488+8>>2]=0;c[f+488+12>>2]=-1;c[f+488+16>>2]=1065353216;c[f+488+20>>2]=1065353216;c[f+488+24>>2]=1065353216;g[f+488+28>>2]=0.0;c[f+488>>2]=6380;c[f+488+4>>2]=8;c[f+488+32>>2]=e;c[f+488+48>>2]=e;c[f+376+8>>2]=0;c[f+376+12>>2]=-1;c[f+376+16>>2]=1065353216;c[f+376+20>>2]=1065353216;c[f+376+24>>2]=1065353216;g[f+376+28>>2]=0.0;g[f+376+48>>2]=.03999999910593033;c[f+376+56>>2]=0;c[f+376>>2]=3768;c[f+376+4>>2]=1;c[f+376+60>>2]=c[d>>2];c[f+376+60+4>>2]=c[d+4>>2];c[f+376+60+8>>2]=c[d+8>>2];c[f+376+60+12>>2]=c[d+12>>2];c[f+376+76>>2]=c[d+16>>2];c[f+376+76+4>>2]=c[d+16+4>>2];c[f+376+76+8>>2]=c[d+16+8>>2];c[f+376+76+12>>2]=c[d+16+12>>2];c[f+376+92>>2]=c[d+32>>2];c[f+376+92+4>>2]=c[d+32+4>>2];c[f+376+92+8>>2]=c[d+32+8>>2];c[f+376+92+12>>2]=c[d+32+12>>2];g[f+16+308>>2]=9.999999747378752e-05;a[f+16+332>>0]=0;c[f>>2]=7024;c[f+4>>2]=f+16;c[f+8>>2]=f+488;c[f+12>>2]=f+376;if(co(f,b+4|0,b+68|0,f+720|0,f+720|0,f+544|0)|0?(h=+g[f+544+164>>2],+g[b+200>>2]>h):0)g[b+200>>2]=h;c[f+376>>2]=6248;e=c[f+376+56>>2]|0;if(!e){i=f;return}rb[c[c[e>>2]>>2]&255](e);e=c[f+376+56>>2]|0;if(!e){i=f;return}c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0);i=f;return}function eh(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[b+76>>2]|0;if(!e)return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(h=f|0?f<<1:1,(f|0)<(h|0)):0){if(!h)e=0;else{c[5637]=(c[5637]|0)+1;e=qG((h<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[d+4>>2]|0}if((f|0)>0){g=0;do{c[e+(g<<2)>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}g=c[d+12>>2]|0;if(g){if(a[d+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[g+-4>>2]|0);f=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=e;c[d+8>>2]=h;e=c[b+76>>2]|0}c[(c[d+12>>2]|0)+(f<<2)>>2]=e;c[d+4>>2]=f+1;return}function fh(a){a=a|0;return}function gh(a){a=a|0;rG(a);return}function hh(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;f=c[d>>2]|0;f=Ob[c[(c[f>>2]|0)+56>>2]&31](f,36)|0;g=c[d+4>>2]|0;i=c[b+12>>2]|0;h=c[b+8>>2]|0;e=c[b+16>>2]|0;b=c[b+20>>2]|0;c[f+4>>2]=c[d>>2];c[f>>2]=3944;c[f+8>>2]=i;c[f+12>>2]=h;a[f+16>>0]=0;c[f+20>>2]=g;a[f+24>>0]=0;c[f+28>>2]=e;c[f+32>>2]=b;return f|0}function ih(b){b=b|0;var d=0;c[b>>2]=3944;if(!(a[b+16>>0]|0))return;d=c[b+20>>2]|0;if(!d)return;b=c[b+4>>2]|0;tb[c[(c[b>>2]|0)+16>>2]&127](b,d);return}function jh(b){b=b|0;var d=0,e=0;c[b>>2]=3944;if(!(a[b+16>>0]|0)){rG(b);return}d=c[b+20>>2]|0;if(!d){rG(b);return}e=c[b+4>>2]|0;tb[c[(c[e>>2]|0)+16>>2]&127](e,d);rG(b);return}function kh(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0.0,y=0.0,z=0.0,A=0,B=0.0,C=0.0,D=0.0,E=0,F=0.0,G=0,H=0,I=0,J=0.0,K=0,L=0.0,M=0.0,P=0.0,S=0.0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0.0,la=0.0,ma=0.0,na=0,oa=0.0,pa=0,qa=0,ra=0,sa=0,ta=0.0,ua=0.0;sa=i;i=i+688|0;l=c[b+20>>2]|0;if(!l){l=c[b+4>>2]|0;l=Eb[c[(c[l>>2]|0)+12>>2]&63](l,c[d+8>>2]|0,c[e+8>>2]|0)|0;c[b+20>>2]=l;a[b+16>>0]=1}c[h+4>>2]=l;pa=c[d+4>>2]|0;qa=c[e+4>>2]|0;j=c[pa+4>>2]|0;m=c[qa+4>>2]|0;if((j|0)==10&(m|0)==10){M=+g[l+752>>2];na=c[pa+56>>2]|0;s=+g[pa+32+(na<<2)>>2];L=+g[pa+32+(((na+2|0)%3|0)<<2)>>2];ra=c[qa+56>>2]|0;t=+g[qa+32+(ra<<2)>>2];J=+g[qa+32+(((ra+2|0)%3|0)<<2)>>2];b=c[d+12>>2]|0;j=c[e+12>>2]|0;C=+g[b+(na<<2)>>2];F=+g[b+16+(na<<2)>>2];D=+g[b+32+(na<<2)>>2];q=+g[j+(ra<<2)>>2];r=+g[j+16+(ra<<2)>>2];x=+g[j+32+(ra<<2)>>2];y=+g[j+48>>2]-+g[b+48>>2];z=+g[j+52>>2]-+g[b+52>>2];B=+g[j+56>>2]-+g[b+56>>2];o=1.0-(C*q+F*r+D*x)*(C*q+F*r+D*x);if(!(o==0.0)){o=(C*y+F*z+D*B-(C*q+F*r+D*x)*(q*y+r*z+x*B))/o;if(!(o<-s)){if(o>s)o=s}else o=-s}else o=0.0;p=(C*q+F*r+D*x)*o-(q*y+r*z+x*B);if(p<-t){o=(C*q+F*r+D*x)*-t+(C*y+F*z+D*B);if(!(o<-s))if(o>s){o=s;p=-t}else p=-t;else{o=-s;p=-t}}else if(p>t){o=t*(C*q+F*r+D*x)+(C*y+F*z+D*B);if(!(o<-s))if(o>s){o=s;p=t}else p=t;else{o=-s;p=t}}v=q*p;u=r*p;t=x*p;p=v+(y-C*o);r=u+(z-F*o);o=t+(B-D*o);s=+O(+(o*o+(p*p+r*r)));if(!(s-L-J>M)){do if(o*o+(p*p+r*r)<=1.4210854715202004e-14)if(+N(+D)>.7071067690849304){o=1.0/+O(+(F*F+D*D));g[sa+280>>2]=0.0;g[sa+280+4>>2]=-(D*o);g[sa+280+8>>2]=F*o;q=0.0;p=-(D*o);o=F*o;break}else{p=1.0/+O(+(C*C+F*F));g[sa+280>>2]=-(F*p);g[sa+280+4>>2]=C*p;g[sa+280+8>>2]=0.0;q=-(F*p);p=C*p;o=0.0;break}else{g[sa+280>>2]=p*-(1.0/s);g[sa+280+4>>2]=r*-(1.0/s);g[sa+280+8>>2]=o*-(1.0/s);g[sa+280+12>>2]=0.0;q=p*-(1.0/s);p=r*-(1.0/s);o=o*-(1.0/s)}while(0);ma=J*p+(u+ +g[j+52>>2]);oa=J*o+(t+ +g[j+56>>2]);g[sa+264>>2]=J*q+(v+ +g[j+48>>2]);g[sa+264+4>>2]=ma;g[sa+264+8>>2]=oa;g[sa+264+12>>2]=0.0}if(s-L-J<M){Yb[c[(c[h>>2]|0)+16>>2]&15](h,sa+280|0,sa+264|0,s-L-J);l=c[h+4>>2]|0}if(!(c[l+748>>2]|0)){i=sa;return}m=c[l+740>>2]|0;n=c[(c[h+8>>2]|0)+8>>2]|0;j=c[(c[h+12>>2]|0)+8>>2]|0;if((m|0)==(n|0)){Xn(l,m+4|0,j+4|0);i=sa;return}else{Xn(l,j+4|0,n+4|0);i=sa;return}}g[sa+128+128>>2]=999999984306749440.0;E=c[b+8>>2]|0;w=c[b+12>>2]|0;c[sa+48>>2]=6928;c[sa+48+4>>2]=0;c[sa+48+8>>2]=1065353216;c[sa+48+12>>2]=0;g[sa+48+16>>2]=0.0;c[sa+48+20>>2]=w;c[sa+48+24>>2]=E;c[sa+48+28>>2]=pa;c[sa+48+32>>2]=qa;c[sa+48+36>>2]=j;c[sa+48+40>>2]=m;g[sa+48+44>>2]=+Hb[c[(c[pa>>2]|0)+48>>2]&15](pa);g[sa+48+48>>2]=+Hb[c[(c[qa>>2]|0)+48>>2]&15](qa);a[sa+48+52>>0]=0;c[sa+48+60>>2]=-1;c[sa+48+72>>2]=1;c[sa+48+76>>2]=1;c[sa+48+28>>2]=pa;c[sa+48+32>>2]=qa;ma=+Hb[c[(c[pa>>2]|0)+48>>2]&15](pa);oa=+Hb[c[(c[qa>>2]|0)+48>>2]&15](qa);oa=ma+oa+ +g[(c[b+20>>2]|0)+752>>2];g[sa+128+128>>2]=oa*oa;E=c[d+12>>2]|0;c[sa+128>>2]=c[E>>2];c[sa+128+4>>2]=c[E+4>>2];c[sa+128+8>>2]=c[E+8>>2];c[sa+128+12>>2]=c[E+12>>2];m=sa+128+16|0;c[m>>2]=c[E+16>>2];c[m+4>>2]=c[E+16+4>>2];c[m+8>>2]=c[E+16+8>>2];c[m+12>>2]=c[E+16+12>>2];w=sa+128+32|0;c[w>>2]=c[E+32>>2];c[w+4>>2]=c[E+32+4>>2];c[w+8>>2]=c[E+32+8>>2];c[w+12>>2]=c[E+32+12>>2];A=sa+128+48|0;c[A>>2]=c[E+48>>2];c[A+4>>2]=c[E+48+4>>2];c[A+8>>2]=c[E+48+8>>2];c[A+12>>2]=c[E+48+12>>2];E=sa+128+64|0;j=c[e+12>>2]|0;c[E>>2]=c[j>>2];c[E+4>>2]=c[j+4>>2];c[E+8>>2]=c[j+8>>2];c[E+12>>2]=c[j+12>>2];G=sa+128+80|0;c[G>>2]=c[j+16>>2];c[G+4>>2]=c[j+16+4>>2];c[G+8>>2]=c[j+16+8>>2];c[G+12>>2]=c[j+16+12>>2];H=sa+128+96|0;c[H>>2]=c[j+32>>2];c[H+4>>2]=c[j+32+4>>2];c[H+8>>2]=c[j+32+8>>2];c[H+12>>2]=c[j+32+12>>2];I=sa+128+112|0;c[I>>2]=c[j+48>>2];c[I+4>>2]=c[j+48+4>>2];c[I+8>>2]=c[j+48+8>>2];c[I+12>>2]=c[j+48+12>>2];j=c[pa+4>>2]|0;if((j|0)<7?(n=c[qa+4>>2]|0,(n|0)<7):0){c[sa+40>>2]=3972;if(!j){j=n;p=0.0}else{p=+Hb[c[(c[pa>>2]|0)+48>>2]&15](pa);j=c[qa+4>>2]|0}if(!j)o=0.0;else o=+Hb[c[(c[qa>>2]|0)+48>>2]&15](qa);c[sa>>2]=4e3;c[sa+4>>2]=h;g[sa+24>>2]=p;g[sa+28>>2]=o;a[sa+36>>0]=0;ia=c[pa+56>>2]|0;a:do if(ia|0){ja=c[qa+56>>2]|0;do if(!ja){if((c[qa+4>>2]|0)!=1)break a;A=sa+624+16|0;a[A>>0]=1;E=sa+624+12|0;c[E>>2]=0;w=sa+624+4|0;c[w>>2]=0;n=sa+624+8|0;c[n>>2]=0;j=c[e+12>>2]|0;ma=+g[qa+60>>2];oa=+g[qa+60+4>>2];q=+g[qa+60+8>>2];o=ma*+g[j>>2]+oa*+g[j+4>>2]+q*+g[j+8>>2]+ +g[j+48>>2];p=ma*+g[j+16>>2]+oa*+g[j+20>>2]+q*+g[j+24>>2]+ +g[j+52>>2];q=ma*+g[j+32>>2]+oa*+g[j+36>>2]+q*+g[j+40>>2]+ +g[j+56>>2];c[5637]=(c[5637]|0)+1;j=qG(35)|0;if(!j)l=0;else{c[(j+4+15&-16)+-4>>2]=j;l=j+4+15&-16}j=c[E>>2]|0;if(!j)j=0;else{c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0);j=c[w>>2]|0;c[E>>2]=0}a[A>>0]=1;c[E>>2]=l;c[n>>2]=1;g[l+(j<<4)>>2]=o;g[l+(j<<4)+4>>2]=p;g[l+(j<<4)+8>>2]=q;g[l+(j<<4)+12>>2]=0.0;j=(c[w>>2]|0)+1|0;c[w>>2]=j;ra=c[e+12>>2]|0;ma=+g[qa+60+16>>2];oa=+g[qa+60+20>>2];q=+g[qa+60+24>>2];o=ma*+g[ra>>2]+oa*+g[ra+4>>2]+q*+g[ra+8>>2]+ +g[ra+48>>2];p=ma*+g[ra+16>>2]+oa*+g[ra+20>>2]+q*+g[ra+24>>2]+ +g[ra+52>>2];q=ma*+g[ra+32>>2]+oa*+g[ra+36>>2]+q*+g[ra+40>>2]+ +g[ra+56>>2];if((j|0)==(c[n>>2]|0)?(K=j|0?j<<1:1,(j|0)<(K|0)):0){if(!K)m=0;else{c[5637]=(c[5637]|0)+1;j=qG((K<<4|3)+16|0)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}m=j;j=c[w>>2]|0}if((j|0)>0){l=0;do{ra=m+(l<<4)|0;na=(c[E>>2]|0)+(l<<4)|0;c[ra>>2]=c[na>>2];c[ra+4>>2]=c[na+4>>2];c[ra+8>>2]=c[na+8>>2];c[ra+12>>2]=c[na+12>>2];l=l+1|0}while((l|0)!=(j|0))}j=c[E>>2]|0;if(j|0){if(a[A>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0)}c[E>>2]=0}a[A>>0]=1;c[E>>2]=m;c[n>>2]=K;j=c[w>>2]|0}ra=c[E>>2]|0;g[ra+(j<<4)>>2]=o;g[ra+(j<<4)+4>>2]=p;g[ra+(j<<4)+8>>2]=q;g[ra+(j<<4)+12>>2]=0.0;j=(c[w>>2]|0)+1|0;c[w>>2]=j;ra=c[e+12>>2]|0;ma=+g[qa+60+32>>2];oa=+g[qa+60+36>>2];q=+g[qa+60+40>>2];o=ma*+g[ra>>2]+oa*+g[ra+4>>2]+q*+g[ra+8>>2]+ +g[ra+48>>2];p=ma*+g[ra+16>>2]+oa*+g[ra+20>>2]+q*+g[ra+24>>2]+ +g[ra+52>>2];q=ma*+g[ra+32>>2]+oa*+g[ra+36>>2]+q*+g[ra+40>>2]+ +g[ra+56>>2];if((j|0)==(c[n>>2]|0)?(T=j|0?j<<1:1,(j|0)<(T|0)):0){if(!T)m=0;else{c[5637]=(c[5637]|0)+1;j=qG((T<<4|3)+16|0)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}m=j;j=c[w>>2]|0}if((j|0)>0){l=0;do{ra=m+(l<<4)|0;e=(c[E>>2]|0)+(l<<4)|0;c[ra>>2]=c[e>>2];c[ra+4>>2]=c[e+4>>2];c[ra+8>>2]=c[e+8>>2];c[ra+12>>2]=c[e+12>>2];l=l+1|0}while((l|0)!=(j|0))}j=c[E>>2]|0;if(j|0){if(a[A>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0)}c[E>>2]=0}a[A>>0]=1;c[E>>2]=m;c[n>>2]=T;j=c[w>>2]|0}ra=c[E>>2]|0;g[ra+(j<<4)>>2]=o;g[ra+(j<<4)+4>>2]=p;g[ra+(j<<4)+8>>2]=q;g[ra+(j<<4)+12>>2]=0.0;c[w>>2]=(c[w>>2]|0)+1;r=+g[(c[b+20>>2]|0)+752>>2];On(sa+48|0,sa+128|0,sa+40|0,c[f+20>>2]|0,0);o=+g[sa+48+4>>2];p=+g[sa+48+8>>2];q=+g[sa+48+12>>2];if(o*o+p*p+q*q>1.1920928955078125e-07){ma=1.0/(o*o+p*p+q*q);g[sa+384>>2]=o*ma;g[sa+384+4>>2]=p*ma;g[sa+384+8>>2]=q*ma;g[sa+384+12>>2]=0.0;ma=+g[sa+48+56>>2];oa=+Hb[c[(c[pa>>2]|0)+48>>2]&15](pa);oa=ma-oa-+Hb[c[(c[qa>>2]|0)+48>>2]&15](qa);Zn(sa+384|0,c[pa+56>>2]|0,c[d+12>>2]|0,sa+624|0,oa-r,r,h)}do if(a[b+16>>0]|0?(U=c[h+4>>2]|0,c[U+748>>2]|0):0){l=c[U+740>>2]|0;m=c[(c[h+8>>2]|0)+8>>2]|0;j=c[(c[h+12>>2]|0)+8>>2]|0;if((l|0)==(m|0)){Xn(U,l+4|0,j+4|0);break}else{Xn(U,j+4|0,m+4|0);break}}while(0);j=c[E>>2]|0;if(j|0){if(a[A>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0)}c[E>>2]=0}}else{oa=+g[(c[b+20>>2]|0)+752>>2];b:do if(!(a[f+24>>0]|0)){On(sa+48|0,sa+128|0,sa,c[f+20>>2]|0,0);o=+g[sa+32>>2];if(o<0.0&(a[sa+36>>0]|0)!=0){q=+g[sa+8>>2];r=+g[sa+16>>2];j=c[sa+20>>2]|0;p=+g[sa+12>>2];na=111}}else{ga=c[d+12>>2]|0;ha=c[e+12>>2]|0;c[5297]=(c[5297]|0)+1;S=+g[ia+64>>2];ba=+g[ia+68>>2];o=+g[ga+4>>2];ca=+g[ia+72>>2];p=+g[ga+8>>2];q=+g[ga+16>>2];r=+g[ga+20>>2];s=+g[ga+24>>2];t=+g[ga+32>>2];u=+g[ga+36>>2];v=+g[ga+40>>2];da=+g[ja+64>>2];ea=+g[ja+68>>2];ma=+g[ja+72>>2];ka=S*+g[ga>>2]+ba*o+ca*p+ +g[ga+48>>2]-(da*+g[ha>>2]+ea*+g[ha+4>>2]+ma*+g[ha+8>>2]+ +g[ha+48>>2]);la=S*q+ba*r+ca*s+ +g[ga+52>>2]-(da*+g[ha+16>>2]+ea*+g[ha+20>>2]+ma*+g[ha+24>>2]+ +g[ha+52>>2]);ma=S*t+ba*u+ca*v+ +g[ga+56>>2]-(da*+g[ha+32>>2]+ea*+g[ha+36>>2]+ma*+g[ha+40>>2]+ +g[ha+56>>2]);m=c[ia+28>>2]|0;c:do if((m|0)>0){B=p;C=q;z=r;D=0.0;F=3402823466385288598117041.0e14;l=0;q=0.0;r=0.0;p=0.0;while(1){fa=c[ia+36>>2]|0;ca=+g[fa+(l*36|0)+20>>2];da=+g[fa+(l*36|0)+24>>2];ea=+g[fa+(l*36|0)+28>>2];x=ca*+g[ga>>2]+da*o+ea*B;s=ca*C+da*z+ea*s;o=ca*t+da*u+ea*v;g[sa+296>>2]=x;g[sa+296+4>>2]=s;g[sa+296+8>>2]=o;g[sa+296+12>>2]=0.0;if(ka*x+la*s+ma*o<0.0){g[sa+296>>2]=-x;g[sa+296+4>>2]=-s;g[sa+296+8>>2]=-o;y=-x;s=-s;o=-o}else y=x;c[5295]=(c[5295]|0)+1;if(Yn(ga,ha,ka,la,ma,y,s,o,ia,ja,F)|0){c[5296]=(c[5296]|0)+1;cl(ia,ga,sa+296|0,sa+624|0,sa+384|0,sa+360|0,sa+344|0);cl(ja,ha,sa+296|0,sa+380|0,sa+376|0,sa+328|0,sa+312|0);t=+g[sa+384>>2];u=+g[sa+380>>2];do if(t<u){j=0;u=D}else{v=+g[sa+376>>2];x=+g[sa+624>>2];if(v<x){j=0;u=D;break}j=1;u=t-u<v-x?t-u:v-x}while(0);if(!j)break;if(u<F){t=u;q=y;r=o;p=s}else t=F;y=u;x=t}else{y=D;x=F}j=l+1|0;if((j|0)>=(m|0)){o=x;break c}o=+g[ga+4>>2];B=+g[ga+8>>2];C=+g[ga+16>>2];z=+g[ga+20>>2];s=+g[ga+24>>2];t=+g[ga+32>>2];u=+g[ga+36>>2];v=+g[ga+40>>2];D=y;F=x;l=j}break b}else{o=3402823466385288598117041.0e14;q=0.0;r=0.0;p=0.0}while(0);m=c[ja+28>>2]|0;d:do if((m|0)>0){B=0.0;l=0;while(1){fa=c[ja+36>>2]|0;da=+g[fa+(l*36|0)+20>>2];ea=+g[fa+(l*36|0)+24>>2];u=+g[fa+(l*36|0)+28>>2];s=da*+g[ha>>2]+ea*+g[ha+4>>2]+u*+g[ha+8>>2];t=da*+g[ha+16>>2]+ea*+g[ha+20>>2]+u*+g[ha+24>>2];u=da*+g[ha+32>>2]+ea*+g[ha+36>>2]+u*+g[ha+40>>2];g[sa+296>>2]=s;g[sa+296+4>>2]=t;g[sa+296+8>>2]=u;g[sa+296+12>>2]=0.0;if(ka*s+la*t+ma*u<0.0){g[sa+296>>2]=-s;g[sa+296+4>>2]=-t;g[sa+296+8>>2]=-u;s=-s;t=-t;u=-u}c[5295]=(c[5295]|0)+1;if(Yn(ga,ha,ka,la,ma,s,t,u,ia,ja,o)|0){c[5296]=(c[5296]|0)+1;cl(ia,ga,sa+296|0,sa+624|0,sa+384|0,sa+360|0,sa+344|0);cl(ja,ha,sa+296|0,sa+380|0,sa+376|0,sa+328|0,sa+312|0);v=+g[sa+384>>2];x=+g[sa+380>>2];do if(v<x){j=0;v=B}else{y=+g[sa+376>>2];z=+g[sa+624>>2];if(y<z){j=0;v=B;break}j=1;v=v-x<y-z?v-x:y-z}while(0);if(!j)break;if(v<o){o=v;q=s;r=u;p=t}}else v=B;l=l+1|0;if((l|0)>=(m|0))break d;else B=v}break b}while(0);j=c[ia+48>>2]|0;e:do if((j|0)>0){V=c[ja+48>>2]|0;s=0.0;fa=0;G=-1;E=-1;H=0;I=0;K=0;T=0;U=0;f=0;n=0;w=0;A=0;W=0;l=0;m=0;M=0.0;P=0.0;S=0.0;v=0.0;x=0.0;J=0.0;f:while(1){aa=c[ia+56>>2]|0;L=+g[aa+(fa<<4)>>2];ba=+g[aa+(fa<<4)+4>>2];ea=+g[aa+(fa<<4)+8>>2];ca=L*+g[ga>>2]+ba*+g[ga+4>>2]+ea*+g[ga+8>>2];da=L*+g[ga+16>>2]+ba*+g[ga+20>>2]+ea*+g[ga+24>>2];ea=L*+g[ga+32>>2]+ba*+g[ga+36>>2]+ea*+g[ga+40>>2];if((V|0)>0){D=s;V=0;ba=q;L=r;F=p;while(1){aa=c[ja+56>>2]|0;u=+g[aa+(V<<4)>>2];y=+g[aa+(V<<4)+4>>2];C=+g[aa+(V<<4)+8>>2];z=u*+g[ha>>2]+y*+g[ha+4>>2]+C*+g[ha+8>>2];B=u*+g[ha+16>>2]+y*+g[ha+20>>2]+C*+g[ha+24>>2];C=u*+g[ha+32>>2]+y*+g[ha+36>>2]+C*+g[ha+40>>2];g[sa+296>>2]=da*C-ea*B;g[sa+296+4>>2]=ea*z-ca*C;g[sa+296+8>>2]=ca*B-da*z;g[sa+296+12>>2]=0.0;do if(!(+N(+(da*C-ea*B))>1.0e-06)){if(+N(+(ea*z-ca*C))>1.0e-06){na=75;break}if(!(+N(+(ca*B-da*z))>1.0e-06)){t=D;q=ba;r=L;p=F;X=H;Y=I;Z=K;_=T;$=U;aa=f}else na=75}else na=75;while(0);do if((na|0)==75){na=0;r=1.0/+O(+((da*C-ea*B)*(da*C-ea*B)+(ea*z-ca*C)*(ea*z-ca*C)+(ca*B-da*z)*(ca*B-da*z)));q=(da*C-ea*B)*r;g[sa+296>>2]=q;p=(ea*z-ca*C)*r;g[sa+296+4>>2]=p;r=(ca*B-da*z)*r;g[sa+296+8>>2]=r;if(q*ka+p*la+ma*r<0.0){g[sa+296>>2]=-q;g[sa+296+4>>2]=-p;g[sa+296+8>>2]=-r;q=-q;p=-p;r=-r}c[5295]=(c[5295]|0)+1;if(!(Yn(ga,ha,ka,la,ma,q,p,r,ia,ja,o)|0)){t=D;q=ba;r=L;p=F;X=H;Y=I;Z=K;_=T;$=U;aa=f;break}c[5296]=(c[5296]|0)+1;cl(ia,ga,sa+296|0,sa+624|0,sa+384|0,sa+360|0,sa+344|0);cl(ja,ha,sa+296|0,sa+380|0,sa+376|0,sa+328|0,sa+312|0);s=+g[sa+384>>2];t=+g[sa+380>>2];do if(!(s<t)){u=+g[sa+376>>2];y=+g[sa+624>>2];if(u<y){j=0;s=D;break}if(s-t<u-y){j=1;s=s-t;H=c[sa+344>>2]|0;I=c[sa+344+4>>2]|0;K=c[sa+344+8>>2]|0;T=c[sa+328>>2]|0;U=c[sa+328+4>>2]|0;f=c[sa+328+8>>2]|0;break}else{j=1;s=u-y;H=c[sa+360>>2]|0;I=c[sa+360+4>>2]|0;K=c[sa+360+8>>2]|0;T=c[sa+312>>2]|0;U=c[sa+312+4>>2]|0;f=c[sa+312+8>>2]|0;break}}else{j=0;s=D}while(0);if(!j)break f;if(!(s<o)){t=s;q=ba;r=L;p=F;X=H;Y=I;Z=K;_=T;$=U;aa=f;break}t=s;o=s;G=fa;E=V;X=H;Y=I;Z=K;_=T;$=U;aa=f;n=H;w=I;A=K;W=T;l=U;m=f;M=ca;P=da;S=ea;v=z;x=B;J=C}while(0);V=V+1|0;j=c[ja+48>>2]|0;if((V|0)>=(j|0))break;else{D=t;ba=q;L=r;F=p;H=X;I=Y;K=Z;T=_;U=$;f=aa}}V=j;j=c[ia+48>>2]|0;s=t;H=X;I=Y;K=Z;T=_;U=$;f=aa}fa=fa+1|0;if((fa|0)>=(j|0)){j=W;break e}}break b}else{G=-1;E=-1;n=0;w=0;A=0;j=0;l=0;m=0;M=0.0;P=0.0;S=0.0;v=0.0;x=0.0;J=0.0}while(0);if((E|G|0)>-1){L=(c[k>>2]=j,+g[k>>2]);C=L-(c[k>>2]=n,+g[k>>2]);F=(c[k>>2]=l,+g[k>>2]);B=F-(c[k>>2]=w,+g[k>>2]);D=(c[k>>2]=m,+g[k>>2]);z=D-(c[k>>2]=A,+g[k>>2]);s=v*M+x*P+J*S;t=C*M+B*P+z*S;o=C*v+B*x+z*J;do if(1.0-s*s==0.0)u=0.0;else{if((t-o*s)/(1.0-s*s)<-1000000015047466219876688.0e6){u=-1000000015047466219876688.0e6;break}if(!((t-o*s)/(1.0-s*s)>1000000015047466219876688.0e6)){u=(t-o*s)/(1.0-s*s);break}u=1000000015047466219876688.0e6}while(0);o=s*u-o;do if(o<-1000000015047466219876688.0e6){if(t-s*1000000015047466219876688.0e6<-1000000015047466219876688.0e6){s=-1000000015047466219876688.0e6;o=-1000000015047466219876688.0e6;break}if(!(t-s*1000000015047466219876688.0e6>1000000015047466219876688.0e6)){s=t-s*1000000015047466219876688.0e6;o=-1000000015047466219876688.0e6;break}s=1000000015047466219876688.0e6;o=-1000000015047466219876688.0e6}else{if(!(o>1000000015047466219876688.0e6)){s=u;break}if(t+s*1000000015047466219876688.0e6<-1000000015047466219876688.0e6){s=-1000000015047466219876688.0e6;o=1000000015047466219876688.0e6;break}if(!(t+s*1000000015047466219876688.0e6>1000000015047466219876688.0e6)){s=t+s*1000000015047466219876688.0e6;o=1000000015047466219876688.0e6;break}s=1000000015047466219876688.0e6;o=1000000015047466219876688.0e6}while(0);y=v*o;x=x*o;v=J*o;u=y+(C-M*s);t=x+(B-P*s);o=v+(z-S*s);g[sa+624>>2]=u;g[sa+624+4>>2]=t;g[sa+624+8>>2]=o;g[sa+624+12>>2]=0.0;if(u*u+t*t+o*o>1.1920928955078125e-07){s=+O(+(u*u+t*t+o*o));g[sa+624>>2]=u*(1.0/s);g[sa+624+4>>2]=1.0/s*t;g[sa+624+8>>2]=1.0/s*o;if(u*(1.0/s)*ka+1.0/s*t*la+1.0/s*o*ma<0.0){g[sa+624>>2]=-(u*(1.0/s));g[sa+624+4>>2]=-(1.0/s*t);g[sa+624+8>>2]=-(1.0/s*o)}g[sa+384>>2]=L+y;g[sa+384+4>>2]=F+x;g[sa+384+8>>2]=D+v;g[sa+384+12>>2]=0.0;Yb[c[(c[h>>2]|0)+16>>2]&15](h,sa+624|0,sa+384|0,-s)}}if(ka*q+la*p+ma*r<0.0){o=-1000000015047466219876688.0e6;q=-q;r=-r;j=0;p=-p;na=111}else{o=-1000000015047466219876688.0e6;j=0;na=111}}while(0);if((na|0)==111){V=c[pa+56>>2]|0;f=c[qa+56>>2]|0;U=c[d+12>>2]|0;T=c[e+12>>2]|0;L=o-oa;D=1.0/+O(+(q*q+p*p+r*r));J=q*D;F=p*D;D=r*D;g[sa+624>>2]=J;g[sa+624+4>>2]=F;g[sa+624+8>>2]=D;c[sa+624+12>>2]=j;l=c[f+28>>2]|0;w=c[f+36>>2]|0;if((l|0)>0){o=+g[T>>2];p=+g[T+4>>2];q=+g[T+8>>2];r=+g[T+16>>2];s=+g[T+20>>2];t=+g[T+24>>2];u=+g[T+32>>2];v=+g[T+36>>2];x=+g[T+40>>2];j=-1;C=-3402823466385288598117041.0e14;n=0;while(1){y=+g[w+(n*36|0)+20>>2];z=+g[w+(n*36|0)+24>>2];B=+g[w+(n*36|0)+28>>2];m=(y*o+z*p+B*q)*J+(y*r+z*s+B*t)*F+(y*u+z*v+B*x)*D>C;j=m?n:j;n=n+1|0;if((n|0)==(l|0)){I=j;break}else C=m?(y*o+z*p+B*q)*J+(y*r+z*s+B*t)*F+(y*u+z*v+B*x)*D:C}}else I=-1;a[sa+384+16>>0]=1;K=sa+384+12|0;c[K>>2]=0;G=sa+384+4|0;c[G>>2]=0;c[sa+384+8>>2]=0;H=c[w+(I*36|0)+4>>2]|0;g:do if((H|0)>0){E=w+(I*36|0)+12|0;j=0;m=0;l=0;while(1){d=c[(c[E>>2]|0)+(l<<2)>>2]|0;e=c[f+16>>2]|0;la=+g[e+(d<<4)>>2];ma=+g[e+(d<<4)+4>>2];q=+g[e+(d<<4)+8>>2];o=la*+g[T>>2]+ma*+g[T+4>>2]+q*+g[T+8>>2]+ +g[T+48>>2];p=la*+g[T+16>>2]+ma*+g[T+20>>2]+q*+g[T+24>>2]+ +g[T+52>>2];q=la*+g[T+32>>2]+ma*+g[T+36>>2]+q*+g[T+40>>2]+ +g[T+56>>2];if((j|0)==(m|0)){A=m|0?m<<1:1;if((m|0)<(A|0)){if(!A){w=0;j=m}else{c[5637]=(c[5637]|0)+1;j=qG((A<<4|3)+16|0)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}w=j;j=c[G>>2]|0}n=c[K>>2]|0;if((j|0)<=0){if(n)na=126}else{m=0;do{d=w+(m<<4)|0;e=n+(m<<4)|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];m=m+1|0}while((m|0)!=(j|0));na=126}if((na|0)==126){na=0;if(a[sa+384+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[n+-4>>2]|0);j=c[G>>2]|0}c[K>>2]=0}a[sa+384+16>>0]=1;c[K>>2]=w;c[sa+384+8>>2]=A}else j=m}d=c[K>>2]|0;g[d+(j<<4)>>2]=o;g[d+(j<<4)+4>>2]=p;g[d+(j<<4)+8>>2]=q;g[d+(j<<4)+12>>2]=0.0;j=(c[G>>2]|0)+1|0;c[G>>2]=j;l=l+1|0;if((l|0)>=(H|0))break g;m=c[sa+384+8>>2]|0}}while(0);if((I|0)>-1)Zn(sa+624|0,V,U,sa+384|0,L,oa,h);j=c[K>>2]|0;if(j|0){if(a[sa+384+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0)}c[K>>2]=0}}if(a[b+16>>0]|0?(ra=c[h+4>>2]|0,c[ra+748>>2]|0):0){m=c[ra+740>>2]|0;l=c[(c[h+8>>2]|0)+8>>2]|0;j=c[(c[h+12>>2]|0)+8>>2]|0;if((m|0)==(l|0)){Xn(ra,m+4|0,j+4|0);break}else{Xn(ra,j+4|0,l+4|0);break}}}while(0);i=sa;return}while(0)}On(sa+48|0,sa+128|0,h,c[f+20>>2]|0,0);if((c[b+28>>2]|0?(c[(c[h+4>>2]|0)+748>>2]|0)<(c[b+32>>2]|0):0)?(L=+g[sa+48+4>>2],M=+g[sa+48+8>>2],P=+g[sa+48+12>>2],L*L+M*M+P*P>1.1920928955078125e-07):0){C=1.0/(L*L+M*M+P*P);if(+N(+(P*C))>.7071067690849304){J=1.0/+O(+(P*C*(P*C)+M*C*(M*C)));D=0.0;F=M*C*J;J=-(P*C*J)}else{J=1.0/+O(+(L*C*(L*C)+M*C*(M*C)));D=-(M*C*J);F=0.0;J=L*C*J}B=+Hb[c[(c[pa>>2]|0)+16>>2]&15](pa);y=+Hb[c[(c[qa>>2]|0)+16>>2]&15](qa);o=.019999999552965164/(B<y?B:y);if(B<y){c[sa+624>>2]=c[sa+128>>2];c[sa+624+4>>2]=c[sa+128+4>>2];c[sa+624+8>>2]=c[sa+128+8>>2];c[sa+624+12>>2]=c[sa+128+12>>2];c[sa+624+16>>2]=c[m>>2];c[sa+624+16+4>>2]=c[m+4>>2];c[sa+624+16+8>>2]=c[m+8>>2];c[sa+624+16+12>>2]=c[m+12>>2];c[sa+624+32>>2]=c[w>>2];c[sa+624+32+4>>2]=c[w+4>>2];c[sa+624+32+8>>2]=c[w+8>>2];c[sa+624+32+12>>2]=c[w+12>>2];c[sa+624+48>>2]=c[A>>2];c[sa+624+48+4>>2]=c[A+4>>2];c[sa+624+48+8>>2]=c[A+8>>2];c[sa+624+48+12>>2]=c[A+12>>2]}else{c[sa+624>>2]=c[E>>2];c[sa+624+4>>2]=c[E+4>>2];c[sa+624+8>>2]=c[E+8>>2];c[sa+624+12>>2]=c[E+12>>2];c[sa+624+16>>2]=c[G>>2];c[sa+624+16+4>>2]=c[G+4>>2];c[sa+624+16+8>>2]=c[G+8>>2];c[sa+624+16+12>>2]=c[G+12>>2];c[sa+624+32>>2]=c[H>>2];c[sa+624+32+4>>2]=c[H+4>>2];c[sa+624+32+8>>2]=c[H+8>>2];c[sa+624+32+12>>2]=c[H+12>>2];c[sa+624+48>>2]=c[I>>2];c[sa+624+48+4>>2]=c[I+4>>2];c[sa+624+48+8>>2]=c[I+8>>2];c[sa+624+48+12>>2]=c[I+12>>2]}j=c[b+28>>2]|0;if((j|0)>0){z=D*D+J*J+F*F;x=(o>.39269909262657166?.39269909262657166:o)*.5;l=0;do{if(z>1.1920928955078125e-07){u=+R(+x)/+O(+z);s=D*u;t=J*u;u=F*u;v=+Q(+x);r=+(l|0)*(6.2831854820251465/+(j|0))*.5;q=+R(+r)/+O(+(P*C*(P*C)+(L*C*(L*C)+M*C*(M*C))));o=L*C*q;p=M*C*q;q=P*C*q;r=+Q(+r);if(B<y){ea=q*(s*-q+(t*r+v*-p)-u*-o)+(o*(v*r-s*-o-t*-p-u*-q)+r*(u*-p+(s*r+v*-o)-t*-q))-p*(t*-o+(u*r+v*-q)-s*-p);la=o*(t*-o+(u*r+v*-q)-s*-p)+(r*(s*-q+(t*r+v*-p)-u*-o)+p*(v*r-s*-o-t*-p-u*-q))-q*(u*-p+(s*r+v*-o)-t*-q);ta=p*(u*-p+(s*r+v*-o)-t*-q)+(q*(v*r-s*-o-t*-p-u*-q)+r*(t*-o+(u*r+v*-q)-s*-p))-o*(s*-q+(t*r+v*-p)-u*-o);ca=r*(v*r-s*-o-t*-p-u*-q)-o*(u*-p+(s*r+v*-o)-t*-q)-p*(s*-q+(t*r+v*-p)-u*-o)-q*(t*-o+(u*r+v*-q)-s*-p);ka=ea*(2.0/(ca*ca+(ta*ta+(ea*ea+la*la))));ma=la*(2.0/(ca*ca+(ta*ta+(ea*ea+la*la))));ba=ta*(2.0/(ca*ca+(ta*ta+(ea*ea+la*la))));ra=c[d+12>>2]|0;q=+g[ra>>2];r=+g[ra+16>>2];s=+g[ra+32>>2];t=+g[ra+4>>2];u=+g[ra+20>>2];v=+g[ra+36>>2];S=+g[ra+8>>2];da=+g[ra+24>>2];oa=+g[ra+40>>2];g[sa+128>>2]=(1.0-(la*ma+ta*ba))*q+(ea*ma-ca*ba)*r+(ea*ba+ca*ma)*s;g[sa+128+4>>2]=(1.0-(la*ma+ta*ba))*t+(ea*ma-ca*ba)*u+(ea*ba+ca*ma)*v;g[sa+128+8>>2]=(1.0-(la*ma+ta*ba))*S+(ea*ma-ca*ba)*da+(ea*ba+ca*ma)*oa;g[sa+128+12>>2]=0.0;g[sa+128+16>>2]=(ea*ma+ca*ba)*q+(1.0-(ea*ka+ta*ba))*r+(la*ba-ca*ka)*s;g[sa+128+20>>2]=(ea*ma+ca*ba)*t+(1.0-(ea*ka+ta*ba))*u+(la*ba-ca*ka)*v;g[sa+128+24>>2]=(ea*ma+ca*ba)*S+(1.0-(ea*ka+ta*ba))*da+(la*ba-ca*ka)*oa;g[sa+128+28>>2]=0.0;g[sa+128+32>>2]=(ea*ba-ca*ma)*q+(la*ba+ca*ka)*r+(1.0-(ea*ka+la*ma))*s;g[sa+128+36>>2]=(ea*ba-ca*ma)*t+(la*ba+ca*ka)*u+(1.0-(ea*ka+la*ma))*v;g[sa+128+40>>2]=(ea*ba-ca*ma)*S+(la*ba+ca*ka)*da+(1.0-(ea*ka+la*ma))*oa;g[sa+128+44>>2]=0.0;ra=c[e+12>>2]|0;c[E>>2]=c[ra>>2];c[E+4>>2]=c[ra+4>>2];c[E+8>>2]=c[ra+8>>2];c[E+12>>2]=c[ra+12>>2];c[G>>2]=c[ra+16>>2];c[G+4>>2]=c[ra+16+4>>2];c[G+8>>2]=c[ra+16+8>>2];c[G+12>>2]=c[ra+16+12>>2];c[H>>2]=c[ra+32>>2];c[H+4>>2]=c[ra+32+4>>2];c[H+8>>2]=c[ra+32+8>>2];c[H+12>>2]=c[ra+32+12>>2];c[I>>2]=c[ra+48>>2];c[I+4>>2]=c[ra+48+4>>2];c[I+8>>2]=c[ra+48+8>>2];c[I+12>>2]=c[ra+48+12>>2]}else{ra=c[d+12>>2]|0;c[sa+128>>2]=c[ra>>2];c[sa+128+4>>2]=c[ra+4>>2];c[sa+128+8>>2]=c[ra+8>>2];c[sa+128+12>>2]=c[ra+12>>2];c[m>>2]=c[ra+16>>2];c[m+4>>2]=c[ra+16+4>>2];c[m+8>>2]=c[ra+16+8>>2];c[m+12>>2]=c[ra+16+12>>2];c[w>>2]=c[ra+32>>2];c[w+4>>2]=c[ra+32+4>>2];c[w+8>>2]=c[ra+32+8>>2];c[w+12>>2]=c[ra+32+12>>2];c[A>>2]=c[ra+48>>2];c[A+4>>2]=c[ra+48+4>>2];c[A+8>>2]=c[ra+48+8>>2];c[A+12>>2]=c[ra+48+12>>2];ka=q*(s*-q+(t*r+v*-p)-u*-o)+(o*(v*r-s*-o-t*-p-u*-q)+r*(u*-p+(s*r+v*-o)-t*-q))-p*(t*-o+(u*r+v*-q)-s*-p);ma=o*(t*-o+(u*r+v*-q)-s*-p)+(r*(s*-q+(t*r+v*-p)-u*-o)+p*(v*r-s*-o-t*-p-u*-q))-q*(u*-p+(s*r+v*-o)-t*-q);ua=p*(u*-p+(s*r+v*-o)-t*-q)+(q*(v*r-s*-o-t*-p-u*-q)+r*(t*-o+(u*r+v*-q)-s*-p))-o*(s*-q+(t*r+v*-p)-u*-o);da=r*(v*r-s*-o-t*-p-u*-q)-o*(u*-p+(s*r+v*-o)-t*-q)-p*(s*-q+(t*r+v*-p)-u*-o)-q*(t*-o+(u*r+v*-q)-s*-p);la=ka*(2.0/(da*da+(ua*ua+(ka*ka+ma*ma))));oa=ma*(2.0/(da*da+(ua*ua+(ka*ka+ma*ma))));ca=ua*(2.0/(da*da+(ua*ua+(ka*ka+ma*ma))));ra=c[e+12>>2]|0;r=+g[ra>>2];s=+g[ra+16>>2];t=+g[ra+32>>2];u=+g[ra+4>>2];v=+g[ra+20>>2];S=+g[ra+36>>2];ba=+g[ra+8>>2];ea=+g[ra+24>>2];ta=+g[ra+40>>2];g[sa+128+64>>2]=(1.0-(ma*oa+ua*ca))*r+(ka*oa-da*ca)*s+(ka*ca+da*oa)*t;g[sa+128+68>>2]=(1.0-(ma*oa+ua*ca))*u+(ka*oa-da*ca)*v+(ka*ca+da*oa)*S;g[sa+128+72>>2]=(1.0-(ma*oa+ua*ca))*ba+(ka*oa-da*ca)*ea+(ka*ca+da*oa)*ta;g[sa+128+76>>2]=0.0;g[sa+128+80>>2]=(ka*oa+da*ca)*r+(1.0-(ka*la+ua*ca))*s+(ma*ca-da*la)*t;g[sa+128+84>>2]=(ka*oa+da*ca)*u+(1.0-(ka*la+ua*ca))*v+(ma*ca-da*la)*S;g[sa+128+88>>2]=(ka*oa+da*ca)*ba+(1.0-(ka*la+ua*ca))*ea+(ma*ca-da*la)*ta;g[sa+128+92>>2]=0.0;g[sa+128+96>>2]=(ka*ca-da*oa)*r+(ma*ca+da*la)*s+(1.0-(ka*la+ma*oa))*t;g[sa+128+100>>2]=(ka*ca-da*oa)*u+(ma*ca+da*la)*v+(1.0-(ka*la+ma*oa))*S;g[sa+128+104>>2]=(ka*ca-da*oa)*ba+(ma*ca+da*la)*ea+(1.0-(ka*la+ma*oa))*ta;g[sa+128+108>>2]=0.0}j=c[f+20>>2]|0;c[sa+384>>2]=4028;c[sa+384+32>>2]=h;c[sa+384+36>>2]=c[sa+128>>2];c[sa+384+36+4>>2]=c[sa+128+4>>2];c[sa+384+36+8>>2]=c[sa+128+8>>2];c[sa+384+36+12>>2]=c[sa+128+12>>2];c[sa+384+52>>2]=c[m>>2];c[sa+384+52+4>>2]=c[m+4>>2];c[sa+384+52+8>>2]=c[m+8>>2];c[sa+384+52+12>>2]=c[m+12>>2];c[sa+384+68>>2]=c[w>>2];c[sa+384+68+4>>2]=c[w+4>>2];c[sa+384+68+8>>2]=c[w+8>>2];c[sa+384+68+12>>2]=c[w+12>>2];c[sa+384+84>>2]=c[A>>2];c[sa+384+84+4>>2]=c[A+4>>2];c[sa+384+84+8>>2]=c[A+8>>2];c[sa+384+84+12>>2]=c[A+12>>2];c[sa+384+100>>2]=c[E>>2];c[sa+384+100+4>>2]=c[E+4>>2];c[sa+384+100+8>>2]=c[E+8>>2];c[sa+384+100+12>>2]=c[E+12>>2];c[sa+384+116>>2]=c[G>>2];c[sa+384+116+4>>2]=c[G+4>>2];c[sa+384+116+8>>2]=c[G+8>>2];c[sa+384+116+12>>2]=c[G+12>>2];c[sa+384+132>>2]=c[H>>2];c[sa+384+132+4>>2]=c[H+4>>2];c[sa+384+132+8>>2]=c[H+8>>2];c[sa+384+132+12>>2]=c[H+12>>2];c[sa+384+148>>2]=c[I>>2];c[sa+384+148+4>>2]=c[I+4>>2];c[sa+384+148+8>>2]=c[I+8>>2];c[sa+384+148+12>>2]=c[I+12>>2];c[sa+384+164>>2]=c[sa+624>>2];c[sa+384+164+4>>2]=c[sa+624+4>>2];c[sa+384+164+8>>2]=c[sa+624+8>>2];c[sa+384+164+12>>2]=c[sa+624+12>>2];c[sa+384+180>>2]=c[sa+624+16>>2];c[sa+384+180+4>>2]=c[sa+624+16+4>>2];c[sa+384+180+8>>2]=c[sa+624+16+8>>2];c[sa+384+180+12>>2]=c[sa+624+16+12>>2];c[sa+384+196>>2]=c[sa+624+32>>2];c[sa+384+196+4>>2]=c[sa+624+32+4>>2];c[sa+384+196+8>>2]=c[sa+624+32+8>>2];c[sa+384+196+12>>2]=c[sa+624+32+12>>2];c[sa+384+212>>2]=c[sa+624+48>>2];c[sa+384+212+4>>2]=c[sa+624+48+4>>2];c[sa+384+212+8>>2]=c[sa+624+48+8>>2];c[sa+384+212+12>>2]=c[sa+624+48+12>>2];a[sa+384+228>>0]=B<y&1;c[sa+384+232>>2]=j;On(sa+48|0,sa+128|0,sa+384|0,j,0);j=c[b+28>>2]|0}l=l+1|0}while((l|0)<(j|0))}}if(!(a[b+16>>0]|0)){i=sa;return}l=c[h+4>>2]|0;if(!(c[l+748>>2]|0)){i=sa;return}m=c[l+740>>2]|0;n=c[(c[h+8>>2]|0)+8>>2]|0;j=c[(c[h+12>>2]|0)+8>>2]|0;if((m|0)==(n|0)){Xn(l,m+4|0,j+4|0);i=sa;return}else{Xn(l,j+4|0,n+4|0);i=sa;return}}function lh(a){a=a|0;rG(a);return}function mh(a,b,c){a=a|0;b=b|0;c=c|0;return}function nh(a,b,c){a=a|0;b=b|0;c=c|0;return}function oh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;return}function ph(a){a=a|0;rG(a);return}function qh(a,b,c){a=a|0;b=b|0;c=c|0;return}function rh(a,b,c){a=a|0;b=b|0;c=c|0;return}function sh(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0.0,k=0.0,l=0.0;h=i;i=i+16|0;g[b+32>>2]=f;c[b+8>>2]=c[d>>2];c[b+8+4>>2]=c[d+4>>2];c[b+8+8>>2]=c[d+8>>2];c[b+8+12>>2]=c[d+12>>2];j=+g[b+28>>2];l=+g[e+4>>2]-j*+g[d+4>>2];k=+g[e+8>>2]-j*+g[d+8>>2];g[h>>2]=+g[e>>2]-+g[d>>2]*j;g[h+4>>2]=l;g[h+8>>2]=k;g[h+12>>2]=0.0;f=+g[b+24>>2]+j+f;g[b+32>>2]=f;if(!(f<0.0)){b=b+4|0;b=c[b>>2]|0;e=c[b>>2]|0;e=e+16|0;e=c[e>>2]|0;Yb[e&15](b,d,h,f);i=h;return}a[b+36>>0]=1;b=b+4|0;b=c[b>>2]|0;e=c[b>>2]|0;e=e+16|0;e=c[e>>2]|0;Yb[e&15](b,d,h,f);i=h;return}function th(a){a=a|0;rG(a);return}function uh(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0;o=i;i=i+16|0;l=+g[d>>2];m=+g[d+4>>2];n=+g[d+8>>2];j=+g[e>>2];k=+g[e+4>>2];h=+g[e+8>>2];if(!(a[b+228>>0]|0)){z=+g[b+100>>2];w=+g[b+116>>2];C=+g[b+132>>2];y=+g[b+104>>2];u=+g[b+120>>2];B=+g[b+136>>2];x=+g[b+108>>2];p=+g[b+124>>2];A=+g[b+140>>2];F=-+g[b+148>>2];E=-+g[b+152>>2];D=-+g[b+156>>2];J=+g[b+164>>2];I=+g[b+168>>2];s=+g[b+172>>2];H=+g[b+180>>2];G=+g[b+184>>2];r=+g[b+188>>2];v=+g[b+196>>2];t=+g[b+200>>2];q=+g[b+204>>2];s=h*(C*J+B*I+A*s)+(j*(z*J+y*I+x*s)+k*(w*J+u*I+p*s))+(J*(z*F+w*E+C*D)+(y*F+u*E+B*D)*I+(x*F+p*E+A*D)*s+ +g[b+212>>2]);r=h*(C*H+B*G+A*r)+(j*(z*H+y*G+x*r)+k*(w*H+u*G+p*r))+((z*F+w*E+C*D)*H+(y*F+u*E+B*D)*G+(x*F+p*E+A*D)*r+ +g[b+216>>2]);q=(z*F+w*E+C*D)*v+(y*F+u*E+B*D)*t+(x*F+p*E+A*D)*q+ +g[b+220>>2]+(h*(C*v+B*t+A*q)+(j*(z*v+y*t+x*q)+k*(w*v+u*t+p*q)));g[o>>2]=s;g[o+4>>2]=r;p=q;f=(l*f+j-s)*+g[d>>2]+(m*f+k-r)*+g[d+4>>2]+(n*f+h-q)*+g[d+8>>2];e=o+8|0;g[e>>2]=p;e=o+12|0;g[e>>2]=0.0;b=b+32|0;b=c[b>>2]|0;e=c[b>>2]|0;e=e+16|0;e=c[e>>2]|0;Yb[e&15](b,d,o,f);i=o;return}else{z=+g[b+36>>2];C=+g[b+52>>2];w=+g[b+68>>2];A=+g[b+40>>2];E=+g[b+56>>2];x=+g[b+72>>2];B=+g[b+44>>2];I=+g[b+60>>2];y=+g[b+76>>2];t=-+g[b+84>>2];u=-+g[b+88>>2];v=-+g[b+92>>2];p=+g[b+164>>2];q=+g[b+168>>2];G=+g[b+172>>2];r=+g[b+180>>2];s=+g[b+184>>2];H=+g[b+188>>2];D=+g[b+196>>2];F=+g[b+200>>2];J=+g[b+204>>2];G=(n*f+h)*(w*p+x*q+y*G)+((l*f+j)*(z*p+A*q+B*G)+(m*f+k)*(C*p+E*q+I*G))+(p*(z*t+C*u+w*v)+(A*t+E*u+x*v)*q+(B*t+I*u+y*v)*G+ +g[b+212>>2]);H=(n*f+h)*(w*r+x*s+y*H)+((l*f+j)*(z*r+A*s+B*H)+(m*f+k)*(C*r+E*s+I*H))+((z*t+C*u+w*v)*r+(A*t+E*u+x*v)*s+(B*t+I*u+y*v)*H+ +g[b+216>>2]);J=(z*t+C*u+w*v)*D+(A*t+E*u+x*v)*F+(B*t+I*u+y*v)*J+ +g[b+220>>2]+((n*f+h)*(w*D+x*F+y*J)+((l*f+j)*(z*D+A*F+B*J)+(m*f+k)*(C*D+E*F+I*J)));g[o>>2]=G+l*(l*(G-j)+m*(H-k)+n*(J-h));g[o+4>>2]=H+m*(l*(G-j)+m*(H-k)+n*(J-h));I=J+n*(l*(G-j)+m*(H-k)+n*(J-h));J=l*(G-j)+m*(H-k)+n*(J-h);e=o+8|0;g[e>>2]=I;e=o+12|0;g[e>>2]=0.0;b=b+32|0;b=c[b>>2]|0;e=c[b>>2]|0;e=e+16|0;e=c[e>>2]|0;Yb[e&15](b,d,o,J);i=o;return}}function vh(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0;f=i;i=i+608|0;p=+g[d+116>>2]-+g[d+52>>2];o=+g[d+120>>2]-+g[d+56>>2];n=+g[d+124>>2]-+g[d+60>>2];j=+g[e+116>>2]-+g[e+52>>2];k=+g[e+120>>2]-+g[e+56>>2];l=+g[e+124>>2]-+g[e+60>>2];m=+g[d+256>>2];if(p*p+o*o+n*n<m*m?(p=+g[e+256>>2],j*j+k*k+l*l<p*p):0){p=1.0;i=f;return +p}b=c[d+192>>2]|0;h=c[e+252>>2]|0;c[f+552+8>>2]=0;c[f+552+12>>2]=-1;c[f+552+16>>2]=1065353216;c[f+552+20>>2]=1065353216;c[f+552+24>>2]=1065353216;g[f+552+28>>2]=0.0;c[f+552>>2]=6380;c[f+552+4>>2]=8;c[f+552+32>>2]=h;c[f+552+48>>2]=h;c[f+376>>2]=3316;g[f+376+164>>2]=999999984306749440.0;c[f+376+168>>2]=0;g[f+376+172>>2]=0.0;g[f+16+308>>2]=9.999999747378752e-05;a[f+16+332>>0]=0;c[f>>2]=6864;c[f+4>>2]=f+16;c[f+8>>2]=b;c[f+12>>2]=f+552;if(An(f,d+4|0,d+68|0,e+4|0,e+68|0,f+376|0)|0){j=+g[f+376+164>>2];if(+g[d+248>>2]>j)g[d+248>>2]=j;if(+g[e+248>>2]>j)g[e+248>>2]=j;if(j<1.0)k=j;else k=1.0}else k=1.0;b=c[e+192>>2]|0;h=c[d+252>>2]|0;c[f+552+8>>2]=0;c[f+552+12>>2]=-1;c[f+552+16>>2]=1065353216;c[f+552+20>>2]=1065353216;c[f+552+24>>2]=1065353216;g[f+552+28>>2]=0.0;c[f+552>>2]=6380;c[f+552+4>>2]=8;c[f+552+32>>2]=h;c[f+552+48>>2]=h;c[f+376>>2]=3316;g[f+376+164>>2]=999999984306749440.0;c[f+376+168>>2]=0;g[f+376+172>>2]=0.0;g[f+16+308>>2]=9.999999747378752e-05;a[f+16+332>>0]=0;c[f>>2]=6864;c[f+4>>2]=f+16;c[f+8>>2]=f+552;c[f+12>>2]=b;if(An(f,d+4|0,d+68|0,e+4|0,e+68|0,f+376|0)|0){j=+g[f+376+164>>2];if(+g[d+248>>2]>j)g[d+248>>2]=j;if(+g[e+248>>2]>j)g[e+248>>2]=j;if(!(k>j))j=k}else j=k;p=j;i=f;return +p}function wh(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[b+20>>2]|0;if(!e)return;if(!(a[b+16>>0]|0))return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(h=f|0?f<<1:1,(f|0)<(h|0)):0){if(!h)e=0;else{c[5637]=(c[5637]|0)+1;e=qG((h<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[d+4>>2]|0}if((f|0)>0){g=0;do{c[e+(g<<2)>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}g=c[d+12>>2]|0;if(g){if(a[d+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[g+-4>>2]|0);f=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=e;c[d+8>>2]=h;e=c[b+20>>2]|0}c[(c[d+12>>2]|0)+(f<<2)>>2]=e;c[d+4>>2]=f+1;return}function xh(b){b=b|0;var d=0;c[b>>2]=4056;if(!(a[b+8>>0]|0))return;d=c[b+12>>2]|0;if(!d)return;b=c[b+4>>2]|0;tb[c[(c[b>>2]|0)+16>>2]&127](b,d);return}function yh(b){b=b|0;var d=0,e=0;c[b>>2]=4056;if(!(a[b+8>>0]|0)){rG(b);return}d=c[b+12>>2]|0;if(!d){rG(b);return}e=c[b+4>>2]|0;tb[c[(c[e>>2]|0)+16>>2]&127](e,d);rG(b);return}function zh(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0,J=0,K=0,L=0,M=0.0,P=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0,na=0.0,oa=0.0;I=i;i=i+96|0;if(!(c[b+12>>2]|0)){i=I;return}f=(a[b+16>>0]|0)!=0;L=f?e:d;f=f?d:e;j=c[L+4>>2]|0;k=c[f+4>>2]|0;L=c[L+12>>2]|0;aa=+g[L>>2];$=+g[L+16>>2];_=+g[L+32>>2];Z=+g[L+4>>2];Y=+g[L+20>>2];o=+g[L+36>>2];l=+g[L+8>>2];r=+g[L+24>>2];y=+g[L+40>>2];T=+g[L+48>>2];S=+g[L+52>>2];P=+g[L+56>>2];K=c[f+12>>2]|0;X=+g[K>>2];W=+g[K+16>>2];p=+g[K+32>>2];V=+g[K+4>>2];U=+g[K+20>>2];q=+g[K+36>>2];x=+g[K+8>>2];v=+g[K+24>>2];t=+g[K+40>>2];M=-+g[K+48>>2];E=-+g[K+52>>2];F=-+g[K+56>>2];G=+g[L>>2];H=+g[L+16>>2];D=+g[L+32>>2];B=+g[L+4>>2];A=+g[L+20>>2];z=+g[L+36>>2];w=+g[L+8>>2];u=+g[L+24>>2];s=+g[L+40>>2];L=c[(c[j>>2]|0)+64>>2]|0;n=-+g[k+52>>2];m=-+g[k+56>>2];C=-+g[k+60>>2];g[I>>2]=(aa*X+$*W+_*p)*n+(aa*V+$*U+_*q)*m+(aa*x+$*v+_*t)*C;g[I+4>>2]=(Z*X+Y*W+o*p)*n+(Z*V+Y*U+o*q)*m+(Z*x+Y*v+o*t)*C;g[I+8>>2]=(l*X+r*W+y*p)*n+(l*V+r*U+y*q)*m+(l*x+r*v+y*t)*C;g[I+12>>2]=0.0;Zb[L&127](I+16|0,j,I);C=+g[I+16>>2];y=+g[I+16+4>>2];r=+g[I+16+8>>2];l=+g[k+52>>2];m=+g[k+56>>2];n=+g[k+60>>2];o=n*(T*x+S*v+P*t+(x*M+v*E+t*F)+((x*G+v*H+t*D)*C+(x*B+v*A+t*z)*y+(x*w+v*u+t*s)*r))+(l*(T*X+S*W+P*p+(X*M+W*E+p*F)+((X*G+W*H+p*D)*C+(X*B+W*A+p*z)*y+(X*w+W*u+p*s)*r))+m*(T*V+S*U+P*q+(V*M+U*E+q*F)+((V*G+U*H+q*D)*C+(V*B+U*A+q*z)*y+(V*w+U*u+q*s)*r)))-+g[k+68>>2];p=T*X+S*W+P*p+(X*M+W*E+p*F)+((X*G+W*H+p*D)*C+(X*B+W*A+p*z)*y+(X*w+W*u+p*s)*r)-l*o;q=T*V+S*U+P*q+(V*M+U*E+q*F)+((V*G+U*H+q*D)*C+(V*B+U*A+q*z)*y+(V*w+U*u+q*s)*r)-m*o;r=T*x+S*v+P*t+(x*M+v*E+t*F)+((x*G+v*H+t*D)*C+(x*B+v*A+t*z)*y+(x*w+v*u+t*s)*r)-n*o;L=c[f+12>>2]|0;s=+g[L>>2];t=+g[L+4>>2];u=+g[L+8>>2];v=+g[L+16>>2];w=+g[L+20>>2];x=+g[L+24>>2];y=+g[L+32>>2];z=+g[L+36>>2];A=+g[L+40>>2];B=+g[L+48>>2];C=+g[L+52>>2];D=+g[L+56>>2];L=c[b+12>>2]|0;K=o<+g[L+752>>2];c[h+4>>2]=L;if(K){L=c[f+12>>2]|0;$=l*+g[L+16>>2]+m*+g[L+20>>2]+n*+g[L+24>>2];aa=l*+g[L+32>>2]+m*+g[L+36>>2]+n*+g[L+40>>2];g[I+80>>2]=+g[L>>2]*l+ +g[L+4>>2]*m+ +g[L+8>>2]*n;g[I+80+4>>2]=$;g[I+80+8>>2]=aa;g[I+80+12>>2]=0.0;g[I+64>>2]=u*r+(s*p+t*q)+B;g[I+64+4>>2]=p*v+q*w+r*x+C;g[I+64+8>>2]=p*y+q*z+r*A+D;g[I+64+12>>2]=0.0;Yb[c[(c[h>>2]|0)+16>>2]&15](h,I+80|0,I+64|0,o)}if((c[j+4>>2]|0)<7?(c[(c[h+4>>2]|0)+748>>2]|0)<(c[b+24>>2]|0):0){l=+g[k+60>>2];if(+N(+l)>.7071067690849304){n=+g[k+56>>2];aa=1.0/+O(+(l*l+n*n));m=0.0;n=n*aa;l=-(l*aa)}else{aa=+g[k+52>>2];m=+g[k+56>>2];l=1.0/+O(+(aa*aa+m*m));m=-(m*l);n=0.0;l=aa*l}F=.019999999552965164/+Hb[c[(c[j>>2]|0)+16>>2]&15](j);F=(F>.39269909262657166?.39269909262657166:F)*.5;E=+R(+F)/+O(+(m*m+l*l+n*n));H=m*E;G=l*E;E=n*E;F=+Q(+F);f=c[b+20>>2]|0;if((f|0)>0){j=0;do{v=+g[k+52>>2];aa=+g[k+56>>2];B=+g[k+60>>2];z=+(j|0)*(6.2831854820251465/+(f|0))*.5;$=+R(+z)/+O(+(v*v+aa*aa+B*B));z=+Q(+z);A=E*-(aa*$)+(H*z+F*-(v*$))-G*-(B*$);x=H*-(B*$)+(G*z+F*-(aa*$))-E*-(v*$);da=G*-(v*$)+(E*z+F*-(B*$))-H*-(aa*$);D=F*z-H*-(v*$)-G*-(aa*$)-E*-(B*$);ia=B*$*x+(v*$*D+z*A)-aa*$*da;ha=v*$*da+(z*x+aa*$*D)-B*$*A;la=aa*$*A+(B*$*D+z*da)-v*$*x;da=z*D-v*$*A-aa*$*x-B*$*da;f=(a[b+16>>0]|0)!=0;ba=f?e:d;f=f?d:e;L=c[ba+4>>2]|0;K=c[f+4>>2]|0;ba=c[ba+12>>2]|0;$=+g[ba>>2];B=+g[ba+4>>2];x=+g[ba+8>>2];aa=+g[ba+16>>2];A=+g[ba+20>>2];v=+g[ba+24>>2];D=+g[ba+32>>2];z=+g[ba+36>>2];t=+g[ba+40>>2];V=+g[ba+48>>2];W=+g[ba+52>>2];X=+g[ba+56>>2];ba=c[f+12>>2]|0;P=+g[ba>>2];S=+g[ba+16>>2];p=+g[ba+32>>2];T=+g[ba+4>>2];U=+g[ba+20>>2];q=+g[ba+36>>2];w=+g[ba+8>>2];u=+g[ba+24>>2];s=+g[ba+40>>2];Y=-+g[ba+48>>2];Z=-+g[ba+52>>2];_=-+g[ba+56>>2];ga=ia*(2.0/(ia*ia+ha*ha+la*la+da*da));n=ha*(2.0/(ia*ia+ha*ha+la*la+da*da));ca=la*(2.0/(ia*ia+ha*ha+la*la+da*da));na=x*(ia*ca-da*n)+(B*(ia*n+da*ca)+$*(1.0-(ha*n+la*ca)));ka=x*(ha*ca+da*ga)+($*(ia*n-da*ca)+B*(1.0-(ia*ga+la*ca)));l=$*(ia*ca+da*n)+B*(ha*ca-da*ga)+x*(1.0-(ia*ga+ha*n));ma=v*(ia*ca-da*n)+(A*(ia*n+da*ca)+aa*(1.0-(ha*n+la*ca)));ja=v*(ha*ca+da*ga)+(aa*(ia*n-da*ca)+A*(1.0-(ia*ga+la*ca)));y=aa*(ia*ca+da*n)+A*(ha*ca-da*ga)+v*(1.0-(ia*ga+ha*n));oa=t*(ia*ca-da*n)+(z*(ia*n+da*ca)+D*(1.0-(ha*n+la*ca)));la=t*(ha*ca+da*ga)+(D*(ia*n-da*ca)+z*(1.0-(ia*ga+la*ca)));n=D*(ia*ca+da*n)+z*(ha*ca-da*ga)+t*(1.0-(ia*ga+ha*n));ha=+g[ba>>2];ga=+g[ba+16>>2];ia=+g[ba+32>>2];da=+g[ba+4>>2];ca=+g[ba+20>>2];ea=+g[ba+36>>2];m=+g[ba+8>>2];r=+g[ba+24>>2];o=+g[ba+40>>2];ba=c[(c[L>>2]|0)+64>>2]|0;fa=-+g[K+52>>2];M=-+g[K+56>>2];C=-+g[K+60>>2];g[I+64>>2]=(ia*oa+(ha*na+ga*ma))*fa+(ea*oa+(da*na+ca*ma))*M+(o*oa+(m*na+r*ma))*C;g[I+64+4>>2]=(ia*la+(ha*ka+ga*ja))*fa+(ea*la+(da*ka+ca*ja))*M+(o*la+(m*ka+r*ja))*C;g[I+64+8>>2]=(ia*n+(ha*l+ga*y))*fa+(ea*n+(da*l+ca*y))*M+(o*n+(m*l+r*y))*C;g[I+64+12>>2]=0.0;Zb[ba&127](I+80|0,L,I+64|0);C=+g[I+80>>2];y=+g[I+80+4>>2];r=+g[I+80+8>>2];l=+g[K+52>>2];m=+g[K+56>>2];n=+g[K+60>>2];o=n*(V*w+W*u+X*s+(w*Y+u*Z+s*_)+(($*w+aa*u+D*s)*C+(B*w+A*u+z*s)*y+(x*w+v*u+t*s)*r))+(l*(V*P+W*S+X*p+(P*Y+S*Z+p*_)+(($*P+aa*S+D*p)*C+(B*P+A*S+z*p)*y+(x*P+v*S+t*p)*r))+m*(V*T+W*U+X*q+(T*Y+U*Z+q*_)+(($*T+aa*U+D*q)*C+(B*T+A*U+z*q)*y+(x*T+v*U+t*q)*r)))-+g[K+68>>2];p=V*P+W*S+X*p+(P*Y+S*Z+p*_)+(($*P+aa*S+D*p)*C+(B*P+A*S+z*p)*y+(x*P+v*S+t*p)*r)-l*o;q=V*T+W*U+X*q+(T*Y+U*Z+q*_)+(($*T+aa*U+D*q)*C+(B*T+A*U+z*q)*y+(x*T+v*U+t*q)*r)-m*o;r=V*w+W*u+X*s+(w*Y+u*Z+s*_)+(($*w+aa*u+D*s)*C+(B*w+A*u+z*s)*y+(x*w+v*u+t*s)*r)-n*o;K=c[f+12>>2]|0;s=+g[K>>2];t=+g[K+4>>2];u=+g[K+8>>2];v=+g[K+16>>2];w=+g[K+20>>2];x=+g[K+24>>2];y=+g[K+32>>2];z=+g[K+36>>2];A=+g[K+40>>2];B=+g[K+48>>2];C=+g[K+52>>2];D=+g[K+56>>2];K=c[b+12>>2]|0;L=o<+g[K+752>>2];c[h+4>>2]=K;if(L){ba=c[f+12>>2]|0;na=l*+g[ba+16>>2]+m*+g[ba+20>>2]+n*+g[ba+24>>2];oa=l*+g[ba+32>>2]+m*+g[ba+36>>2]+n*+g[ba+40>>2];g[I+48>>2]=+g[ba>>2]*l+ +g[ba+4>>2]*m+ +g[ba+8>>2]*n;g[I+48+4>>2]=na;g[I+48+8>>2]=oa;g[I+48+12>>2]=0.0;g[I+32>>2]=u*r+(s*p+t*q)+B;g[I+32+4>>2]=p*v+q*w+r*x+C;g[I+32+8>>2]=p*y+q*z+r*A+D;g[I+32+12>>2]=0.0;Yb[c[(c[h>>2]|0)+16>>2]&15](h,I+48|0,I+32|0,o)}j=j+1|0;f=c[b+20>>2]|0}while((j|0)<(f|0))}}do if((a[b+8>>0]|0?c[(c[b+12>>2]|0)+748>>2]|0:0)?(J=c[h+4>>2]|0,c[J+748>>2]|0):0){j=c[J+740>>2]|0;k=c[(c[h+8>>2]|0)+8>>2]|0;f=c[(c[h+12>>2]|0)+8>>2]|0;if((j|0)==(k|0)){Xn(J,j+4|0,f+4|0);break}else{Xn(J,f+4|0,k+4|0);break}}while(0);i=I;return}function Ah(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function Bh(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[b+12>>2]|0;if(!e)return;if(!(a[b+8>>0]|0))return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(h=f|0?f<<1:1,(f|0)<(h|0)):0){if(!h)e=0;else{c[5637]=(c[5637]|0)+1;e=qG((h<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[d+4>>2]|0}if((f|0)>0){g=0;do{c[e+(g<<2)>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}g=c[d+12>>2]|0;if(g){if(a[d+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[g+-4>>2]|0);f=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=e;c[d+8>>2]=h;e=c[b+12>>2]|0}c[(c[d+12>>2]|0)+(f<<2)>>2]=e;c[d+4>>2]=f+1;return}function Ch(b){b=b|0;var d=0,e=0;c[b>>2]=4084;if(a[b+20>>0]|0){d=c[b+16>>2]|0;e=c[d+16>>2]|0;if(e){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0);d=c[b+16>>2]|0}if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}}if(a[b+12>>0]|0){d=c[b+8>>2]|0;e=c[d+16>>2]|0;if(e){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0);d=c[b+8>>2]|0}if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}}d=c[b+32>>2]|0;rb[c[c[d>>2]>>2]&255](d);d=c[b+32>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+36>>2]|0;rb[c[c[d>>2]>>2]&255](d);d=c[b+36>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+40>>2]|0;rb[c[c[d>>2]>>2]&255](d);d=c[b+40>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+44>>2]|0;rb[c[c[d>>2]>>2]&255](d);d=c[b+44>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+48>>2]|0;rb[c[c[d>>2]>>2]&255](d);d=c[b+48>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+52>>2]|0;rb[c[c[d>>2]>>2]&255](d);d=c[b+52>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+56>>2]|0;rb[c[c[d>>2]>>2]&255](d);d=c[b+56>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+60>>2]|0;rb[c[c[d>>2]>>2]&255](d);d=c[b+60>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+76>>2]|0;rb[c[c[d>>2]>>2]&255](d);d=c[b+76>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+80>>2]|0;rb[c[c[d>>2]>>2]&255](d);d=c[b+80>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+72>>2]|0;rb[c[c[d>>2]>>2]&255](d);d=c[b+72>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+88>>2]|0;rb[c[c[d>>2]>>2]&255](d);d=c[b+88>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+84>>2]|0;rb[c[c[d>>2]>>2]&255](d);d=c[b+84>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+24>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+28>>2]|0;rb[c[c[d>>2]>>2]&255](d);d=c[b+28>>2]|0;if(!d)return;c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0);return}function Dh(a){a=a|0;Ch(a);rG(a);return}function Eh(a){a=a|0;return c[a+8>>2]|0}function Fh(a){a=a|0;return c[a+16>>2]|0}function Gh(a,b,d){a=a|0;b=b|0;d=d|0;do if(!((b|0)==8&(d|0)==8)){if((b|0)==8&(d|0)==1){b=a+76|0;break}if((b|0)==1&(d|0)==8){b=a+80|0;break}if(!(d|b)){b=a+72|0;break}if((b|0)<20&(d|0)==28){b=a+88|0;break}if((b|0)==28&(d|0)<20){b=a+84|0;break}if((b|0)<20){if((d|0)<20){b=a+32|0;break}if((d+-21|0)>>>0<9){b=a+36|0;break}}else{if((d|0)<20&(b+-21|0)>>>0<9){b=a+40|0;break}if((b|0)==31)if((d|0)==31){b=a+48|0;break}else{b=a+44|0;break}}if((d|0)==31){b=a+52|0;break}else{b=a+56|0;break}}else b=a+60|0;while(0);return c[b>>2]|0}function Hh(a){a=a|0;return c[a+24>>2]|0}function Ih(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0;c[b>>2]=4084;c[5637]=(c[5637]|0)+1;e=qG(379)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}g[e+308>>2]=9.999999747378752e-05;f=e+332|0;a[f>>0]=a[f>>0]&-16;c[b+24>>2]=e;f=(c[d+20>>2]|0)==0;c[5637]=(c[5637]|0)+1;e=qG(23)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}if(f){c[e>>2]=6948;c[b+28>>2]=e;f=b+28|0}else{c[e>>2]=6908;c[b+28>>2]=e;f=b+28|0}c[5637]=(c[5637]|0)+1;e=qG(43)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}k=c[b+24>>2]|0;l=c[f>>2]|0;a[e+4>>0]=0;c[e>>2]=3924;c[e+16>>2]=0;c[e+20>>2]=3;c[e+12>>2]=k;c[e+8>>2]=l;c[b+32>>2]=e;c[5637]=(c[5637]|0)+1;e=qG(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=4116;c[b+36>>2]=e;c[5637]=(c[5637]|0)+1;e=qG(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=4136;c[b+40>>2]=e;c[5637]=(c[5637]|0)+1;e=qG(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=4156;c[b+44>>2]=e;c[5637]=(c[5637]|0)+1;e=qG(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=4176;c[b+48>>2]=e;c[5637]=(c[5637]|0)+1;e=qG(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=4196;c[b+52>>2]=e;c[5637]=(c[5637]|0)+1;e=qG(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=4216;c[b+56>>2]=e;c[5637]=(c[5637]|0)+1;e=qG(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=4236;c[b+60>>2]=e;c[5637]=(c[5637]|0)+1;e=qG(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=4256;c[b+76>>2]=e;c[5637]=(c[5637]|0)+1;e=qG(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[e>>2]=4256;c[b+80>>2]=e;a[e+4>>0]=1;c[5637]=(c[5637]|0)+1;e=qG(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=4276;c[b+72>>2]=e;c[5637]=(c[5637]|0)+1;e=qG(35)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=4296;c[e+8>>2]=1;c[e+12>>2]=0;c[b+88>>2]=e;c[5637]=(c[5637]|0)+1;e=qG(35)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[e>>2]=4296;c[e+8>>2]=1;c[e+12>>2]=0;c[b+84>>2]=e;a[e+4>>0]=1;l=c[d+16>>2]|0;l=(l|0)>80?l:80;e=c[d>>2]|0;if(!e){a[b+12>>0]=1;c[5637]=(c[5637]|0)+1;e=qG(39)|0;if(!e)k=0;else{c[(e+4+15&-16)+-4>>2]=e;k=e+4+15&-16}e=c[d+8>>2]|0;c[k>>2]=772;f=k+4|0;c[f>>2]=e;c[5637]=(c[5637]|0)+1;e=qG((e*772|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[k+16>>2]=e;c[k+12>>2]=e;f=c[f>>2]|0;c[k+8>>2]=f;if(f+-1|0){h=c[k>>2]|0;i=f+-1|0;j=e;do{m=j;j=j+h|0;c[m>>2]=j;i=i+-1|0}while((i|0)!=0);e=e+(_(h,f+-1|0)|0)|0}c[e>>2]=0;c[b+8>>2]=k}else{a[b+12>>0]=0;c[b+8>>2]=e}e=c[d+4>>2]|0;if(e|0){a[b+20>>0]=0;c[b+16>>2]=e;return}a[b+20>>0]=1;c[5637]=(c[5637]|0)+1;e=qG(39)|0;if(!e)k=0;else{c[(e+4+15&-16)+-4>>2]=e;k=e+4+15&-16}e=c[d+12>>2]|0;c[k>>2]=l;f=k+4|0;c[f>>2]=e;e=_(e,l)|0;c[5637]=(c[5637]|0)+1;e=qG(e+19|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[k+16>>2]=e;c[k+12>>2]=e;f=c[f>>2]|0;c[k+8>>2]=f;if(f+-1|0){h=c[k>>2]|0;i=f+-1|0;j=e;do{m=j;j=j+h|0;c[m>>2]=j;i=i+-1|0}while((i|0)!=0);e=e+(_(h,f+-1|0)|0)|0}c[e>>2]=0;c[b+16>>2]=k;return}function Jh(a){a=a|0;return}function Kh(a){a=a|0;rG(a);return}function Lh(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;b=c[d>>2]|0;b=Ob[c[(c[b>>2]|0)+56>>2]&31](b,80)|0;d=c[d>>2]|0;c[b+4>>2]=d;c[b>>2]=3720;a[b+8>>0]=0;c[b+12>>2]=3748;c[b+60>>2]=d;c[b+64>>2]=0;c[b+16>>2]=e;c[b+20>>2]=f;d=Eb[c[(c[d>>2]|0)+12>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;c[b+76>>2]=d;f=c[b+60>>2]|0;tb[c[(c[f>>2]|0)+20>>2]&127](f,d);return b|0}function Mh(a){a=a|0;rG(a);return}function Nh(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;b=c[d>>2]|0;b=Ob[c[(c[b>>2]|0)+56>>2]&31](b,80)|0;d=c[d>>2]|0;c[b+4>>2]=d;c[b>>2]=3720;a[b+8>>0]=1;c[b+12>>2]=3748;c[b+60>>2]=d;c[b+64>>2]=0;c[b+16>>2]=f;c[b+20>>2]=e;d=Eb[c[(c[d>>2]|0)+12>>2]&63](d,c[f+8>>2]|0,c[e+8>>2]|0)|0;c[b+76>>2]=d;f=c[b+60>>2]|0;tb[c[(c[f>>2]|0)+20>>2]&127](f,d);return b|0}function Oh(a){a=a|0;rG(a);return}function Ph(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;a=c[b>>2]|0;a=Ob[c[(c[a>>2]|0)+56>>2]&31](a,44)|0;sg(a,b,d,e,0);return a|0}function Qh(a){a=a|0;rG(a);return}function Rh(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;l=c[d>>2]|0;l=Ob[c[(c[l>>2]|0)+56>>2]&31](l,76)|0;sg(l,d,e,f,0);c[l>>2]=3656;a[l+64>>0]=1;c[l+60>>2]=0;c[l+52>>2]=0;c[l+56>>2]=0;c[5637]=(c[5637]|0)+1;b=qG(83)|0;if(!b)k=0;else{c[(b+4+15&-16)+-4>>2]=b;k=b+4+15&-16}c[k>>2]=4432;h=k+20|0;a[h>>0]=1;i=k+16|0;c[i>>2]=0;d=k+8|0;c[d>>2]=0;j=k+12|0;c[j>>2]=0;a[k+40>>0]=1;c[k+36>>2]=0;c[k+28>>2]=0;c[k+32>>2]=0;a[k+60>>0]=1;c[k+56>>2]=0;c[k+48>>2]=0;c[k+52>>2]=0;c[5637]=(c[5637]|0)+1;b=qG(43)|0;if(!b)g=0;else{c[(b+4+15&-16)+-4>>2]=b;g=b+4+15&-16}b=c[d>>2]|0;if((b|0)>0){d=0;do{m=g+(d*12|0)|0;n=(c[i>>2]|0)+(d*12|0)|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];d=d+1|0}while((d|0)!=(b|0))}b=c[i>>2]|0;if(!b){a[h>>0]=1;c[i>>2]=g;c[j>>2]=2;ui(k);n=l+44|0;c[n>>2]=k;n=e+4|0;n=c[n>>2]|0;n=n+72|0;n=c[n>>2]|0;m=l+68|0;c[m>>2]=n;m=f+4|0;m=c[m>>2]|0;m=m+72|0;m=c[m>>2]|0;n=l+72|0;c[n>>2]=m;return l|0}if(a[h>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[b+-4>>2]|0)}c[i>>2]=0;a[h>>0]=1;c[i>>2]=g;c[j>>2]=2;ui(k);n=l+44|0;c[n>>2]=k;n=e+4|0;n=c[n>>2]|0;n=n+72|0;n=c[n>>2]|0;m=l+68|0;c[m>>2]=n;m=f+4|0;m=c[m>>2]|0;m=m+72|0;m=c[m>>2]|0;n=l+72|0;c[n>>2]=m;return l|0}function Sh(a){a=a|0;rG(a);return}function Th(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;a=c[b>>2]|0;a=Ob[c[(c[a>>2]|0)+56>>2]&31](a,44)|0;sg(a,b,d,e,1);return a|0}function Uh(a){a=a|0;rG(a);return}function Vh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;a=c[b>>2]|0;a=Ob[c[(c[a>>2]|0)+56>>2]&31](a,8)|0;c[a+4>>2]=c[b>>2];c[a>>2]=4316;return a|0}function Wh(a){a=a|0;rG(a);return}function Xh(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;b=c[d>>2]|0;b=Ob[c[(c[b>>2]|0)+56>>2]&31](b,16)|0;d=c[d>>2]|0;c[b+4>>2]=d;c[b>>2]=4512;a[b+8>>0]=0;c[b+12>>2]=0;c[b+12>>2]=Eb[c[(c[d>>2]|0)+12>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[b+8>>0]=1;return b|0}function Yh(a){a=a|0;rG(a);return}function Zh(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=c[d>>2]|0;g=Ob[c[(c[g>>2]|0)+56>>2]&31](g,20)|0;h=c[d+4>>2]|0;b=a[b+4>>0]|0;d=c[d>>2]|0;c[g+4>>2]=d;c[g>>2]=4540;a[g+8>>0]=0;c[g+12>>2]=h;a[g+16>>0]=b;if(h|0)return g|0;c[g+12>>2]=Eb[c[(c[d>>2]|0)+12>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[g+8>>0]=1;return g|0}function _h(a){a=a|0;rG(a);return}function $h(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;b=c[d>>2]|0;b=Ob[c[(c[b>>2]|0)+56>>2]&31](b,16)|0;d=c[d>>2]|0;c[b+4>>2]=d;c[b>>2]=3016;a[b+8>>0]=0;c[b+12>>2]=0;if(!(Eb[c[(c[d>>2]|0)+24>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0))return b|0;d=c[b+4>>2]|0;c[b+12>>2]=Eb[c[(c[d>>2]|0)+12>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[b+8>>0]=1;return b|0}function ai(a){a=a|0;rG(a);return}function bi(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0;h=c[d>>2]|0;h=Ob[c[(c[h>>2]|0)+56>>2]&31](h,28)|0;j=(a[b+4>>0]|0)==0;i=c[b+8>>2]|0;g=c[b+12>>2]|0;b=c[d>>2]|0;c[h+4>>2]=b;c[h>>2]=4056;a[h+8>>0]=0;c[h+12>>2]=0;if(j){a[h+16>>0]=0;c[h+20>>2]=i;c[h+24>>2]=g;if(!(Eb[c[(c[b>>2]|0)+24>>2]&63](b,c[e+8>>2]|0,c[f+8>>2]|0)|0))return h|0;j=c[h+4>>2]|0;c[h+12>>2]=Eb[c[(c[j>>2]|0)+12>>2]&63](j,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[h+8>>0]=1;return h|0}else{a[h+16>>0]=1;c[h+20>>2]=i;c[h+24>>2]=g;if(!(Eb[c[(c[b>>2]|0)+24>>2]&63](b,c[f+8>>2]|0,c[e+8>>2]|0)|0))return h|0;j=c[h+4>>2]|0;c[h+12>>2]=Eb[c[(c[j>>2]|0)+12>>2]&63](j,c[f+8>>2]|0,c[e+8>>2]|0)|0;a[h+8>>0]=1;return h|0}return 0}function ci(a){a=a|0;rG(a);return}function di(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return}function ei(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function fi(a,b){a=a|0;b=b|0;return}function gi(b){b=b|0;var d=0;c[b>>2]=4344;d=c[b+300>>2]|0;if(d|0){if(a[b+304>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+300>>2]=0}a[b+304>>0]=1;c[b+300>>2]=0;c[b+292>>2]=0;c[b+296>>2]=0;c[b>>2]=3156;d=c[b+276>>2]|0;if(!d){a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;b=b+272|0;c[b>>2]=0;return}if(a[b+280>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+276>>2]=0;a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;b=b+272|0;c[b>>2]=0;return}function hi(b){b=b|0;var d=0;c[b>>2]=4344;d=c[b+300>>2]|0;if(d|0){if(a[b+304>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+300>>2]=0}a[b+304>>0]=1;c[b+300>>2]=0;c[b+292>>2]=0;c[b+296>>2]=0;c[b>>2]=3156;d=c[b+276>>2]|0;if(d|0){if(a[b+280>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0;c[5638]=(c[5638]|0)+1;rG(c[b+-4>>2]|0);return}function ii(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;g=c[d>>2]|0;d=c[b+292>>2]|0;a:do if((d|0)>0){f=c[b+300>>2]|0;e=0;while(1){if((c[f+(e<<2)>>2]|0)==(g|0))break;e=e+1|0;if((e|0)>=(d|0))break a}if((e|0)!=(d|0))return}while(0);if((d|0)==(c[b+296>>2]|0)?(h=d|0?d<<1:1,(d|0)<(h|0)):0){if(!h)f=0;else{c[5637]=(c[5637]|0)+1;d=qG((h<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}f=d;d=c[b+292>>2]|0}if((d|0)>0){e=0;do{c[f+(e<<2)>>2]=c[(c[b+300>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(d|0))}e=c[b+300>>2]|0;if(e){if(a[b+304>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0);d=c[b+292>>2]|0}c[b+300>>2]=0}a[b+304>>0]=1;c[b+300>>2]=f;c[b+296>>2]=h}c[(c[b+300>>2]|0)+(d<<2)>>2]=g;c[b+292>>2]=d+1;return}function ji(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;g=c[a+292>>2]|0;if((g|0)<=0)return;b=c[b>>2]|0;f=c[a+300>>2]|0;d=0;while(1){e=f+(d<<2)|0;if((c[e>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(g|0)){h=7;break}}if((h|0)==7)return;if((d|0)>=(g|0))return;c[e>>2]=c[f+(g+-1<<2)>>2];c[a+292>>2]=g+-1;return}function ki(b){b=b|0;var d=0;c[b>>2]=4388;d=c[b+308>>2]|0;rb[c[c[d>>2]>>2]&255](d);d=c[b+308>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b>>2]=4344;d=c[b+300>>2]|0;if(d|0){if(a[b+304>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+300>>2]=0}a[b+304>>0]=1;c[b+300>>2]=0;c[b+292>>2]=0;c[b+296>>2]=0;c[b>>2]=3156;d=c[b+276>>2]|0;if(!d){a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;b=b+272|0;c[b>>2]=0;return}if(a[b+280>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+276>>2]=0;a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;b=b+272|0;c[b>>2]=0;return}function li(a){a=a|0;ki(a);if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function mi(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;if(!e)e=c[b+188>>2]|0;j=c[d>>2]|0;f=c[b+292>>2]|0;a:do if((f|0)>0){h=c[b+300>>2]|0;g=0;while(1){if((c[h+(g<<2)>>2]|0)==(j|0))break;g=g+1|0;if((g|0)>=(f|0))break a}if((g|0)!=(f|0))return}while(0);if((f|0)==(c[b+296>>2]|0)?(i=f|0?f<<1:1,(f|0)<(i|0)):0){if(!i)h=0;else{c[5637]=(c[5637]|0)+1;f=qG((i<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}h=f;f=c[b+292>>2]|0}if((f|0)>0){g=0;do{c[h+(g<<2)>>2]=c[(c[b+300>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}g=c[b+300>>2]|0;if(g){if(a[b+304>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[g+-4>>2]|0);f=c[b+292>>2]|0}c[b+300>>2]=0}a[b+304>>0]=1;c[b+300>>2]=h;c[b+296>>2]=i}c[(c[b+300>>2]|0)+(f<<2)>>2]=j;c[b+292>>2]=f+1;b=c[b+308>>2]|0;Eb[c[(c[b>>2]|0)+8>>2]&63](b,e,d)|0;return}function ni(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;j=c[b>>2]|0;if(!e)e=c[a+188>>2]|0;h=c[a+292>>2]|0;if((h|0)<=0)return;i=c[a+300>>2]|0;f=0;while(1){g=i+(f<<2)|0;if((c[g>>2]|0)==(j|0))break;f=f+1|0;if((f|0)>=(h|0)){k=9;break}}if((k|0)==9)return;if((f|0)>=(h|0))return;c[g>>2]=c[i+(h+-1<<2)>>2];c[a+292>>2]=h+-1;k=c[a+308>>2]|0;zb[c[(c[k>>2]|0)+12>>2]&31](k,e,b,d)|0;return}function oi(b){b=b|0;var d=0;c[b+164>>2]=1065353216;c[b+168>>2]=1065353216;c[b+172>>2]=1065353216;g[b+176>>2]=0.0;c[b+180>>2]=0;g[b+184>>2]=999999984306749440.0;c[b+188>>2]=0;c[b+188+4>>2]=0;c[b+188+8>>2]=0;c[b+188+12>>2]=0;c[b+204>>2]=1;c[b+208>>2]=-1;c[b+212>>2]=-1;c[b+216>>2]=1;g[b+220>>2]=0.0;g[b+224>>2]=.5;g[b+228>>2]=0.0;g[b+232>>2]=0.0;c[b+240>>2]=0;c[b+244>>2]=-1;g[b+248>>2]=1.0;g[b+252>>2]=0.0;g[b+256>>2]=0.0;c[b+260>>2]=0;a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0;c[b+284>>2]=0;c[b+4>>2]=1065353216;c[b+8>>2]=0;c[b+8+4>>2]=0;c[b+8+8>>2]=0;c[b+8+12>>2]=0;c[b+24>>2]=1065353216;c[b+28>>2]=0;c[b+28+4>>2]=0;c[b+28+8>>2]=0;c[b+28+12>>2]=0;c[b+44>>2]=1065353216;c[b+48>>2]=0;c[b+48+4>>2]=0;c[b+48+8>>2]=0;c[b+48+12>>2]=0;c[b+48+16>>2]=0;a[b+304>>0]=1;c[b+300>>2]=0;c[b+292>>2]=0;c[b+296>>2]=0;c[b+236>>2]=4;c[b>>2]=4388;c[5637]=(c[5637]|0)+1;d=qG(91)|0;if(!d){d=0;de(d);b=b+308|0;c[b>>2]=d;return}c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16;de(d);b=b+308|0;c[b>>2]=d;return}function pi(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=+h;var j=0.0,l=0,m=0.0,n=0,o=0.0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0,E=0.0,F=0.0,G=0.0,H=0,I=0,J=0,K=0,L=0.0,M=0.0,N=0.0,O=0.0;K=i;i=i+288|0;c[K+144>>2]=c[d>>2];c[K+144+4>>2]=c[d+4>>2];c[K+144+8>>2]=c[d+8>>2];c[K+144+12>>2]=c[d+12>>2];c[K+144+16>>2]=c[d+16>>2];c[K+144+16+4>>2]=c[d+16+4>>2];c[K+144+16+8>>2]=c[d+16+8>>2];c[K+144+16+12>>2]=c[d+16+12>>2];c[K+144+32>>2]=c[d+32>>2];c[K+144+32+4>>2]=c[d+32+4>>2];c[K+144+32+8>>2]=c[d+32+8>>2];c[K+144+32+12>>2]=c[d+32+12>>2];c[K+144+48>>2]=c[d+48>>2];c[K+144+48+4>>2]=c[d+48+4>>2];c[K+144+48+8>>2]=c[d+48+8>>2];c[K+144+48+12>>2]=c[d+48+12>>2];c[K+80>>2]=c[e>>2];c[K+80+4>>2]=c[e+4>>2];c[K+80+8>>2]=c[e+8>>2];c[K+80+12>>2]=c[e+12>>2];c[K+80+16>>2]=c[e+16>>2];c[K+80+16+4>>2]=c[e+16+4>>2];c[K+80+16+8>>2]=c[e+16+8>>2];c[K+80+16+12>>2]=c[e+16+12>>2];c[K+80+32>>2]=c[e+32>>2];c[K+80+32+4>>2]=c[e+32+4>>2];c[K+80+32+8>>2]=c[e+32+8>>2];c[K+80+32+12>>2]=c[e+32+12>>2];c[K+80+48>>2]=c[e+48>>2];c[K+80+48+4>>2]=c[e+48+4>>2];c[K+80+48+8>>2]=c[e+48+8>>2];c[K+80+48+12>>2]=c[e+48+12>>2];m=+g[K+80+52>>2]-+g[K+144+52>>2];O=+g[K+80+56>>2]-+g[K+144+56>>2];g[K+32>>2]=+g[K+80+48>>2]-+g[K+144+48>>2];g[K+32+4>>2]=m;g[K+32+8>>2]=O;g[K+32+12>>2]=0.0;Zf(K+144|0,K+80|0,K+224|0,K+208|0);O=+g[K+208>>2];m=O*+g[K+224+4>>2];L=O*+g[K+224+8>>2];g[K+16>>2]=+g[K+224>>2]*O;g[K+16+4>>2]=m;g[K+16+8>>2]=L;g[K+16+12>>2]=0.0;c[K+224+4>>2]=0;c[K+224+4+4>>2]=0;c[K+224+24>>2]=0;c[K+224+24+4>>2]=0;J=K+224+44|0;c[J>>2]=0;c[J+4>>2]=0;c[J+8>>2]=0;c[J+12>>2]=0;c[J+16>>2]=0;_f(K+144|0,K);L=+g[K>>2];m=+g[K+4>>2];O=+g[K+8>>2];M=+g[K+12>>2];j=L*(2.0/(L*L+m*m+O*O+M*M));o=m*(2.0/(L*L+m*m+O*O+M*M));N=O*(2.0/(L*L+m*m+O*O+M*M));g[K+224>>2]=1.0-(m*o+O*N);g[K+224+4>>2]=L*o-M*N;g[K+224+8>>2]=L*N+M*o;g[K+224+12>>2]=0.0;g[K+224+16>>2]=L*o+M*N;g[K+224+20>>2]=1.0-(L*j+O*N);g[K+224+24>>2]=m*N-M*j;g[K+224+28>>2]=0.0;g[K+224+32>>2]=L*N-M*o;g[K+224+36>>2]=m*N+M*j;g[K+224+40>>2]=1.0-(L*j+m*o);g[J>>2]=0.0;_j(b,K+224|0,K+32|0,K+16|0,K+64|0,K+48|0);if((c[a+292>>2]|0)<=0){i=K;return}I=0;do{p=c[(c[a+300>>2]|0)+(I<<2)>>2]|0;if(Ob[c[(c[f>>2]|0)+8>>2]&31](f,c[p+188>>2]|0)|0?(C=c[p+192>>2]|0,bc[c[(c[C>>2]|0)+8>>2]&127](C,p+4|0,K+208|0,K+32|0),q=+g[K+208>>2]+ +g[K+64>>2],r=+g[K+208+4>>2]+ +g[K+64+4>>2],s=+g[K+208+8>>2]+ +g[K+64+8>>2],g[K+208>>2]=q,g[K+208+4>>2]=r,g[K+208+8>>2]=s,g[K+208+12>>2]=0.0,t=+g[K+32>>2]+ +g[K+48>>2],u=+g[K+32+4>>2]+ +g[K+48+4>>2],v=+g[K+32+8>>2]+ +g[K+48+8>>2],g[K+32>>2]=t,g[K+32+4>>2]=u,g[K+32+8>>2]=v,g[K+32+12>>2]=0.0,w=+g[d+48>>2]-(t+q)*.5,x=+g[d+52>>2]-(u+r)*.5,y=+g[d+56>>2]-(v+s)*.5,z=+g[e+48>>2]-(t+q)*.5,A=+g[e+52>>2]-(u+r)*.5,B=+g[e+56>>2]-(v+s)*.5,C=w<-((t-q)*.5)|(w>(t-q)*.5?8:0)|(x<-((u-r)*.5)?2:0)|(x>(u-r)*.5?16:0)|(y<-((v-s)*.5)?4:0)|(y>(v-s)*.5?32:0),D=z<-((t-q)*.5)|(z>(t-q)*.5?8:0)|(A<-((u-r)*.5)?2:0)|(A>(u-r)*.5?16:0)|(B<-((v-s)*.5)?4:0)|(B>(v-s)*.5?32:0),(C&D|0)==0):0){H=1;J=0;j=0.0;l=1065353216;o=1.0;while(1){if(!(H&C)){if((H&D|0)!=0?(E=(-w-o*((t-q)*.5))/(z-w),E<(c[k>>2]=l,+g[k>>2])):0)l=(g[k>>2]=E,c[k>>2]|0)}else{m=(-w-o*((t-q)*.5))/(z-w);if(j<=m)j=m}n=H<<1;if(!(n&C))if((n&D|0)!=0?(F=(-x-o*((u-r)*.5))/(A-x),F<(c[k>>2]=l,+g[k>>2])):0){m=j;l=(g[k>>2]=F,c[k>>2]|0)}else m=j;else{m=(-x-o*((u-r)*.5))/(A-x);if(!(j<=m))m=j}n=H<<2;if(!(n&C))if((n&D|0)!=0?(G=(-y-o*((v-s)*.5))/(B-y),G<(c[k>>2]=l,+g[k>>2])):0){j=m;l=(g[k>>2]=G,c[k>>2]|0)}else j=m;else{j=(-y-o*((v-s)*.5))/(B-y);if(!(m<=j))j=m}J=J+1|0;if((J|0)==2)break;else{H=H<<3;o=-1.0}}if(j<=(c[k>>2]=l,+g[k>>2])){J=c[p+192>>2]|0;c[K+224>>2]=0;c[K+224+4>>2]=J;c[K+224+8>>2]=p;c[K+224+12>>2]=p+4;c[K+224+16>>2]=-1;c[K+224+20>>2]=-1;Pf(b,K+144|0,K+80|0,K+224|0,f,h)}}I=I+1|0}while((I|0)<(c[a+292>>2]|0));i=K;return}function qi(b){b=b|0;var d=0;c[b>>2]=4432;d=c[b+56>>2]|0;if(d|0){if(a[b+60>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;d=c[b+36>>2]|0;if(d|0){if(a[b+40>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}if(a[b+20>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}function ri(a){a=a|0;qi(a);rG(a);return}function si(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;c[4990]=(c[4990]|0)+1;g=((d<<16|b)+~((d<<16|b)<<15)>>10^(d<<16|b)+~((d<<16|b)<<15))*9|0;l=c[a+36>>2]|0;g=l+(((c[a+12>>2]|0)+-1&((g>>6^g)+~((g>>6^g)<<11)>>16^(g>>6^g)+~((g>>6^g)<<11)))<<2)|0;f=c[g>>2]|0;if((f|0)==-1){n=0;return n|0}m=c[a+16>>2]|0;e=f;while(1){k=m+(e*12|0)|0;if((c[k>>2]|0)==(b|0)?(c[m+(e*12|0)+4>>2]|0)==(d|0):0)break;e=c[(c[a+56>>2]|0)+(e<<2)>>2]|0;if((e|0)==-1){e=0;n=21;break}}if((n|0)==21)return e|0;if(!k){n=0;return n|0}j=c[m+(e*12|0)+8>>2]|0;i=(e*12|0)/12|0;b=c[a+56>>2]|0;if((f|0)!=(i|0)){while(1){d=b+(f<<2)|0;e=c[d>>2]|0;if((e|0)==(i|0))break;else f=e}e=c[b+(i<<2)>>2]|0;if((f|0)==-1)n=11;else c[d>>2]=e}else{e=c[b+(f<<2)>>2]|0;n=11}if((n|0)==11)c[g>>2]=e;g=(c[a+8>>2]|0)+-1|0;if((g|0)==(i|0)){c[a+8>>2]=i;n=j;return n|0}h=c[m+(g*12|0)+4>>2]<<16|c[m+(g*12|0)>>2];h=(h+~(h<<15)>>10^h+~(h<<15))*9|0;h=((h>>6^h)+~((h>>6^h)<<11)>>16^(h>>6^h)+~((h>>6^h)<<11))&(c[a+12>>2]|0)+-1;e=c[l+(h<<2)>>2]|0;b=c[a+56>>2]|0;if((e|0)!=(g|0)){f=e;while(1){d=b+(f<<2)|0;e=c[d>>2]|0;if((e|0)==(g|0))break;else f=e}e=c[b+(g<<2)>>2]|0;if((f|0)==-1)n=19;else c[d>>2]=e}else{e=c[b+(g<<2)>>2]|0;n=19}if((n|0)==19)c[l+(h<<2)>>2]=e;c[k>>2]=c[m+(g*12|0)>>2];c[k+4>>2]=c[m+(g*12|0)+4>>2];c[k+8>>2]=c[m+(g*12|0)+8>>2];n=(c[a+36>>2]|0)+(h<<2)|0;c[(c[a+56>>2]|0)+(i<<2)>>2]=c[n>>2];c[n>>2]=i;c[a+8>>2]=(c[a+8>>2]|0)+-1;n=j;return n|0}function ti(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;c[4991]=(c[4991]|0)+1;k=((e<<16|d)+~((e<<16|d)<<15)>>10^(e<<16|d)+~((e<<16|d)<<15))*9|0;k=(k>>6^k)+~((k>>6^k)<<11)>>16^(k>>6^k)+~((k>>6^k)<<11);l=c[b+12>>2]|0;f=c[(c[b+36>>2]|0)+((l+-1&k)<<2)>>2]|0;a:do if((f|0)!=-1){h=c[b+16>>2]|0;while(1){g=h+(f*12|0)|0;if((c[g>>2]|0)==(d|0)?(c[h+(f*12|0)+4>>2]|0)==(e|0):0)break;f=c[(c[b+56>>2]|0)+(f<<2)>>2]|0;if((f|0)==-1)break a}if(g|0){b=g;return b|0}}while(0);j=c[b+8>>2]|0;if((j|0)==(l|0)){h=l|0?l<<1:1;if((l|0)<(h|0)){if(!h){f=0;g=l}else{c[5637]=(c[5637]|0)+1;f=qG((h*12|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}g=c[b+8>>2]|0}if((g|0)>0){i=0;do{m=f+(i*12|0)|0;n=(c[b+16>>2]|0)+(i*12|0)|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];i=i+1|0}while((i|0)!=(g|0))}g=c[b+16>>2]|0;if(g|0){if(a[b+20>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[g+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=f;c[b+12>>2]=h;f=c[b+8>>2]|0}else{f=l;h=l}}else{f=j;h=l}c[b+8>>2]=f+1;g=c[b+16>>2]|0;if((l|0)<(h|0)){ui(b);f=(c[b+12>>2]|0)+-1&k}else f=l+-1&k;c[g+(j*12|0)>>2]=d;c[g+(j*12|0)+4>>2]=e;c[g+(j*12|0)+8>>2]=0;n=(c[b+36>>2]|0)+(f<<2)|0;c[(c[b+56>>2]|0)+(j<<2)>>2]=c[n>>2];c[n>>2]=j;n=g+(j*12|0)|0;return n|0}function ui(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;i=c[b+12>>2]|0;j=c[b+28>>2]|0;if((i|0)<=(j|0))return;if((i|0)>=(j|0)){do if((c[b+32>>2]|0)<(i|0)){if(!i){d=0;e=j}else{c[5637]=(c[5637]|0)+1;d=qG((i<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=c[b+28>>2]|0}f=c[b+36>>2]|0;if((e|0)<=0){if(!f){a[b+40>>0]=1;c[b+36>>2]=d;c[b+32>>2]=i;break}}else{g=0;do{c[d+(g<<2)>>2]=c[f+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}if(a[b+40>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}a[b+40>>0]=1;c[b+36>>2]=d;c[b+32>>2]=i}else d=c[b+36>>2]|0;while(0);ZG(d+(j<<2)|0,0,i-j<<2|0)|0}c[b+28>>2]=i;h=c[b+48>>2]|0;if((i|0)>(h|0)){do if((c[b+52>>2]|0)<(i|0)){if(!i){d=0;e=h}else{c[5637]=(c[5637]|0)+1;d=qG((i<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=c[b+48>>2]|0}f=c[b+56>>2]|0;if((e|0)<=0){if(!f){a[b+60>>0]=1;c[b+56>>2]=d;c[b+52>>2]=i;break}}else{g=0;do{c[d+(g<<2)>>2]=c[f+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}if(a[b+60>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}a[b+60>>0]=1;c[b+56>>2]=d;c[b+52>>2]=i}else d=c[b+56>>2]|0;while(0);ZG(d+(h<<2)|0,0,i-h<<2|0)|0}c[b+48>>2]=i;if((i|0)>0){ZG(c[b+36>>2]|0,-1,i<<2|0)|0;ZG(c[b+56>>2]|0,-1,i<<2|0)|0}if((j|0)<=0)return;d=c[b+16>>2]|0;e=c[b+36>>2]|0;f=c[b+56>>2]|0;g=0;do{i=c[d+(g*12|0)+4>>2]<<16|c[d+(g*12|0)>>2];i=(i+~(i<<15)>>10^i+~(i<<15))*9|0;i=e+((((i>>6^i)+~((i>>6^i)<<11)>>16^(i>>6^i)+~((i>>6^i)<<11))&(c[b+12>>2]|0)+-1)<<2)|0;c[f+(g<<2)>>2]=c[i>>2];c[i>>2]=g;g=g+1|0}while((g|0)!=(j|0));return}function vi(a){a=a|0;return c[a+16>>2]|0}function wi(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;d=c[b+16>>2]|0;if(d|0){if(a[b+20>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;d=c[b+36>>2]|0;if(d|0){if(a[b+40>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;d=c[b+56>>2]|0;if(d|0){if(a[b+60>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;if((c[b+12>>2]|0)>=2){ui(b);return}c[5637]=(c[5637]|0)+1;d=qG(43)|0;if(!d)f=0;else{c[(d+4+15&-16)+-4>>2]=d;f=d+4+15&-16}d=c[b+8>>2]|0;if((d|0)>0){e=0;do{g=f+(e*12|0)|0;h=(c[b+16>>2]|0)+(e*12|0)|0;c[g>>2]=c[h>>2];c[g+4>>2]=c[h+4>>2];c[g+8>>2]=c[h+8>>2];e=e+1|0}while((e|0)!=(d|0))}d=c[b+16>>2]|0;if(d|0){if(a[b+20>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=f;c[b+12>>2]=2;ui(b);return}function xi(a){a=a|0;rG(a);return}function yi(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;C=i;i=i+192|0;z=c[b+4>>2]|0;if(+g[z+752>>2]<f){i=C;return}B=c[z+740>>2]|0;y=(c[b+8>>2]|0)+8|0;A=c[y>>2]|0;j=+g[e>>2];r=+g[d>>2]*f+j;k=+g[e+4>>2];s=+g[d+4>>2]*f+k;h=+g[e+8>>2];t=+g[d+8>>2]*f+h;x=(c[b+12>>2]|0)+8|0;p=c[x>>2]|0;l=+g[p+52>>2];m=+g[p+56>>2];if((B|0)!=(A|0)){w=t-+g[p+60>>2];j=j-+g[A+52>>2];k=k-+g[A+56>>2];h=h-+g[A+60>>2];u=(r-l)*+g[p+4>>2]+(s-m)*+g[p+20>>2]+w*+g[p+36>>2];v=(r-l)*+g[p+8>>2]+(s-m)*+g[p+24>>2]+w*+g[p+40>>2];w=(r-l)*+g[p+12>>2]+(s-m)*+g[p+28>>2]+w*+g[p+44>>2];n=j*+g[A+4>>2]+k*+g[A+20>>2]+h*+g[A+36>>2];o=j*+g[A+8>>2]+k*+g[A+24>>2]+h*+g[A+40>>2];h=j*+g[A+12>>2]+k*+g[A+28>>2]+h*+g[A+44>>2]}else{o=r-+g[B+52>>2];n=s-+g[B+56>>2];w=t-+g[B+60>>2];h=h-+g[p+60>>2];u=o*+g[B+4>>2]+n*+g[B+20>>2]+w*+g[B+36>>2];v=o*+g[B+8>>2]+n*+g[B+24>>2]+w*+g[B+40>>2];w=o*+g[B+12>>2]+n*+g[B+28>>2]+w*+g[B+44>>2];n=(j-l)*+g[p+4>>2]+(k-m)*+g[p+20>>2]+h*+g[p+36>>2];o=(j-l)*+g[p+8>>2]+(k-m)*+g[p+24>>2]+h*+g[p+40>>2];h=(j-l)*+g[p+12>>2]+(k-m)*+g[p+28>>2]+h*+g[p+44>>2]}g[C>>2]=u;g[C+4>>2]=v;g[C+8>>2]=w;g[C+12>>2]=0.0;g[C+16>>2]=n;g[C+20>>2]=o;g[C+24>>2]=h;g[C+28>>2]=0.0;c[C+64>>2]=c[d>>2];c[C+64+4>>2]=c[d+4>>2];c[C+64+8>>2]=c[d+8>>2];c[C+64+12>>2]=c[d+12>>2];g[C+80>>2]=f;g[C+84>>2]=0.0;g[C+88>>2]=0.0;g[C+92>>2]=0.0;c[C+112>>2]=0;a[C+116>>0]=0;c[C+120>>2]=0;c[C+120+4>>2]=0;c[C+120+8>>2]=0;c[C+120+12>>2]=0;c[C+120+16>>2]=0;c[C+120+20>>2]=0;c[C+120+24>>2]=0;c[C+120+28>>2]=0;g[C+48>>2]=r;g[C+52>>2]=s;g[C+56>>2]=t;g[C+60>>2]=0.0;c[C+32>>2]=c[e>>2];c[C+32+4>>2]=c[e+4>>2];c[C+32+8>>2]=c[e+8>>2];c[C+32+12>>2]=c[e+12>>2];h=+g[z+752>>2];e=c[z+748>>2]|0;if((e|0)>0){q=0;p=-1;l=h*h;while(1){h=+g[z+4+(q*184|0)>>2]-u;j=+g[z+4+(q*184|0)+4>>2]-v;k=+g[z+4+(q*184|0)+8>>2]-w;d=h*h+j*j+k*k<l;p=d?q:p;q=q+1|0;if((q|0)==(e|0))break;else l=d?h*h+j*j+k*k:l}}else p=-1;q=c[y>>2]|0;y=c[x>>2]|0;h=+g[q+224>>2]*+g[y+224>>2];h=h<-10.0?-10.0:h;g[C+84>>2]=h>10.0?10.0:h;g[C+92>>2]=+g[q+228>>2]*+g[y+228>>2];h=+g[q+232>>2]*+g[y+232>>2];h=h<-10.0?-10.0:h;g[C+88>>2]=h>10.0?10.0:h;h=+g[C+72>>2];y=+N(+h)>.7071067690849304;l=+g[C+68>>2];if(y){w=1.0/+O(+(h*h+l*l));n=+g[C+64>>2];m=-(w*l*n);n=n*-(w*h);o=-(w*h);j=(h*h+l*l)*w;k=0.0;h=w*l}else{j=+g[C+64>>2];k=1.0/+O(+(j*j+l*l));m=h*-(l*k);n=(j*j+l*l)*k;o=k*j;j=-(k*j*h);k=-(l*k);h=0.0}g[C+152>>2]=k;g[C+156>>2]=o;g[C+160>>2]=h;g[C+168>>2]=j;g[C+172>>2]=m;g[C+176>>2]=n;x=c[b+20>>2]|0;q=c[b+16>>2]|0;y=c[b+28>>2]|0;b=c[b+24>>2]|0;c[C+96>>2]=(B|0)!=(A|0)?x:q;c[C+100>>2]=(B|0)!=(A|0)?q:x;c[C+104>>2]=(B|0)!=(A|0)?y:b;c[C+108>>2]=(B|0)!=(A|0)?b:y;if((p|0)>-1){b=z+4+(p*184|0)+148|0;B=c[b>>2]|0;e=z+4+(p*184|0)+120|0;d=c[e>>2]|0;x=z+4+(p*184|0)+124|0;q=c[x>>2]|0;A=z+4+(p*184|0)+128|0;y=c[A>>2]|0;D=z+4+(p*184|0)+112|0;E=c[D>>2]|0;bH(z+4+(p*184|0)|0,C|0,184)|0;c[D>>2]=E;c[e>>2]=d;c[x>>2]=q;c[A>>2]=y;c[b>>2]=B}else Wn(z,C)|0;i=C;return}function zi(b){b=b|0;var d=0;c[b>>2]=4488;d=c[b+56>>2]|0;if(d|0){if(a[b+60>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;d=c[b+36>>2]|0;if(d|0){if(a[b+40>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;d=c[b+16>>2]|0;if(!d){d=b+12|0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[d>>2]=0;return}if(a[b+20>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[b+16>>2]=0;d=b+12|0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[d>>2]=0;return}function Ai(a){a=a|0;zi(a);rG(a);return}function Bi(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0,k=0,l=0,m=0;f=c[d+8>>2]|0;if((f|0)>0){h=c[d+16>>2]|0;j=0;e=0;do{i=c[h+(j<<2)>>2]|0;if(!(c[i+204>>2]&3)){c[i+208>>2]=e;e=e+1|0}c[i+212>>2]=-1;g[i+248>>2]=1.0;j=j+1|0}while((j|0)!=(f|0));j=e}else j=0;i=c[b+8>>2]|0;if((i|0)<(j|0)){if((c[b+12>>2]|0)<(j|0)){if(!j){e=0;f=i}else{c[5637]=(c[5637]|0)+1;e=qG((j<<3|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[b+8>>2]|0}if((f|0)>0){h=0;do{m=(c[b+16>>2]|0)+(h<<3)|0;k=c[m+4>>2]|0;l=e+(h<<3)|0;c[l>>2]=c[m>>2];c[l+4>>2]=k;h=h+1|0}while((h|0)!=(f|0))}f=c[b+16>>2]|0;if(f|0){if(a[b+20>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[f+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=e;c[b+12>>2]=j;f=b+16|0}else f=b+16|0;e=i;do{m=(c[f>>2]|0)+(e<<3)|0;c[m>>2]=0;c[m+4>>2]=0;e=e+1|0}while((e|0)!=(j|0))}c[b+8>>2]=j;if((j|0)>0){e=c[b+16>>2]|0;f=0;do{c[e+(f<<3)>>2]=f;c[e+(f<<3)+4>>2]=1;f=f+1|0}while((f|0)!=(j|0))}e=c[d+68>>2]|0;e=vb[c[(c[e>>2]|0)+36>>2]&127](e)|0;l=vb[c[(c[e>>2]|0)+36>>2]&127](e)|0;if(!l)return;d=vb[c[(c[e>>2]|0)+20>>2]&127](e)|0;if((l|0)<=0)return;k=0;do{e=c[c[d+(k<<4)>>2]>>2]|0;f=c[c[d+(k<<4)+4>>2]>>2]|0;if((e|0?(f|0?(c[e+204>>2]&7|0)==0:0):0)?(c[f+204>>2]&7|0)==0:0){i=c[e+208>>2]|0;e=c[f+208>>2]|0;j=c[b+16>>2]|0;f=c[j+(i<<3)>>2]|0;if((f|0)!=(i|0)){h=j+(i<<3)|0;do{i=j+(f<<3)|0;c[h>>2]=c[i>>2];i=c[i>>2]|0;h=j+(i<<3)|0;f=c[h>>2]|0}while((i|0)!=(f|0))}f=c[j+(e<<3)>>2]|0;if((f|0)!=(e|0)){h=j+(e<<3)|0;do{e=j+(f<<3)|0;c[h>>2]=c[e>>2];e=c[e>>2]|0;h=j+(e<<3)|0;f=c[h>>2]|0}while((e|0)!=(f|0))}if((i|0)!=(e|0)){c[j+(i<<3)>>2]=e;m=j+(e<<3)+4|0;c[m>>2]=(c[m>>2]|0)+(c[j+(i<<3)+4>>2]|0)}}k=k+1|0}while((k|0)!=(l|0));return}function Ci(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;k=c[b+8>>2]|0;if((k|0)<=0)return;i=c[b+16>>2]|0;j=0;b=0;do{h=c[i+(j<<2)>>2]|0;if(!(c[h+204>>2]&3)){g=c[a+16>>2]|0;e=g+(b<<3)|0;d=c[e>>2]|0;if((d|0)==(b|0))d=b;else{f=d;do{d=g+(f<<3)|0;c[e>>2]=c[d>>2];d=c[d>>2]|0;e=g+(d<<3)|0;f=c[e>>2]|0}while((d|0)!=(f|0))}c[h+208>>2]=d;c[g+(b<<3)+4>>2]=j;c[h+212>>2]=-1;b=b+1|0}else{c[h+208>>2]=-1;c[h+212>>2]=-2}j=j+1|0}while((j|0)!=(k|0));return}function Di(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;u=i;i=i+16|0;fs(12530);h=c[b+28>>2]|0;if((h|0)<0){if((c[b+32>>2]|0)<0){j=c[b+36>>2]|0;if(j|0){if(a[b+40>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+32>>2]=0}do{c[(c[b+36>>2]|0)+(h<<2)>>2]=0;h=h+1|0}while((h|0)!=0)}c[b+28>>2]=0;l=c[b+8>>2]|0;if((l|0)>0){m=c[b+16>>2]|0;o=0;do{n=m+(o<<3)|0;h=c[n>>2]|0;if((h|0)==(o|0))h=o;else{j=h;k=n;do{h=m+(j<<3)|0;c[k>>2]=c[h>>2];h=c[h>>2]|0;k=m+(h<<3)|0;j=c[k>>2]|0}while((h|0)!=(j|0))}c[n>>2]=h;o=o+1|0}while((o|0)!=(l|0));if((l|0)>1){Pi(b+4|0,0,l+-1|0);l=c[b+8>>2]|0}if((l|0)>0){o=c[b+16>>2]|0;j=0;while(1){p=c[o+(j<<3)>>2]|0;s=j;while(1){r=s+1|0;if((r|0)>=(l|0)){n=0;break}if((c[o+(r<<3)>>2]|0)==(p|0))s=r;else{n=1;break}}a:do if((j|0)<=(s|0)){q=c[e+16>>2]|0;h=1;m=j;while(1){k=c[q+(c[o+(m<<3)+4>>2]<<2)>>2]|0;if((c[k+208>>2]|0)==(p|0)){k=c[k+216>>2]|0;h=(k|0)!=4&(h&(k|0)!=1)}if((m|0)<(s|0))m=m+1|0;else break}if(h){h=o;while(1){h=c[q+(c[h+(j<<3)+4>>2]<<2)>>2]|0;if((c[h+208>>2]|0)==(p|0)?(c[h+216>>2]&-2|0)!=4:0)c[h+216>>2]=2;if((j|0)>=(s|0))break a;h=c[b+16>>2]|0;j=j+1|0}}else{h=o;while(1){h=c[q+(c[h+(j<<3)+4>>2]<<2)>>2]|0;if((c[h+208>>2]|0)==(p|0)?(c[h+216>>2]|0)==2:0){c[h+216>>2]=3;g[h+220>>2]=0.0}if((j|0)>=(s|0))break a;h=c[b+16>>2]|0;j=j+1|0}}}while(0);if(n)j=r;else break}}}m=vb[c[(c[d>>2]|0)+36>>2]&127](d)|0;if((m|0)>0){n=0;do{l=Ob[c[(c[d>>2]|0)+40>>2]&31](d,n)|0;j=c[l+740>>2]|0;k=c[l+744>>2]|0;if((j|0)!=0?(c[j+216>>2]|0)!=2:0)h=44;else h=42;if(((h|0)==42?(h=0,k|0):0)?(c[k+216>>2]|0)!=2:0)h=44;if((h|0)==44){h=c[j+204>>2]|0;if((h&2|0?((h&4|0)==0?(c[j+216>>2]|0)!=2:0):0)?(c[k+204>>2]&3|0)==0:0){if((c[k+216>>2]&-2|0)!=4)c[k+216>>2]=1;g[k+220>>2]=0.0}s=c[k+204>>2]|0;if(s&2|0?((s&4|h&3|0)==0?(c[k+216>>2]|0)!=2:0):0){if((c[j+216>>2]&-2|0)!=4)c[j+216>>2]=1;g[j+220>>2]=0.0}if(a[b+64>>0]|0?Eb[c[(c[d>>2]|0)+28>>2]&63](d,j,k)|0:0){h=c[b+28>>2]|0;if((h|0)==(c[b+32>>2]|0)?(t=h|0?h<<1:1,(h|0)<(t|0)):0){if(!t)k=0;else{c[5637]=(c[5637]|0)+1;h=qG((t<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}k=h;h=c[b+28>>2]|0}if((h|0)>0){j=0;do{c[k+(j<<2)>>2]=c[(c[b+36>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[b+36>>2]|0;if(j){if(a[b+40>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0);h=c[b+28>>2]|0}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=k;c[b+32>>2]=t}c[(c[b+36>>2]|0)+(h<<2)>>2]=l;c[b+28>>2]=h+1}}n=n+1|0}while((n|0)<(m|0))}h=c[2006]|0;t=(c[h+16>>2]|0)+-1|0;c[h+16>>2]=t;do if(!t){if(c[h+4>>2]|0){kb(u|0,0)|0;t=c[5649]|0;g[h+8>>2]=+g[h+8>>2]+ +(((c[u+4>>2]|0)-(c[t+4>>2]|0)+(((c[u>>2]|0)-(c[t>>2]|0)|0)*1e6|0)-(c[h+12>>2]|0)|0)>>>0)/1.0e3;if(c[h+16>>2]|0)break;h=c[2006]|0}c[2006]=c[h+20>>2]}while(0);t=c[b+8>>2]|0;fs(12558);if(a[b+64>>0]|0){r=c[b+28>>2]|0;if((r|0)>1)Ei(b+24|0,0,r+-1|0);if((t|0)>0){p=1;j=0;s=0;while(1){h=c[b+16>>2]|0;q=c[h+(j<<3)>>2]|0;b:do if((j|0)<(t|0)){m=c[b+48>>2]|0;k=c[b+52>>2]|0;o=1;while(1){n=c[(c[e+16>>2]|0)+(c[h+(j<<3)+4>>2]<<2)>>2]|0;if((m|0)==(k|0)){m=k|0?k<<1:1;if((k|0)<(m|0)){if(!m)h=0;else{c[5637]=(c[5637]|0)+1;h=qG((m<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}k=c[b+48>>2]|0}if((k|0)>0){l=0;do{c[h+(l<<2)>>2]=c[(c[b+56>>2]|0)+(l<<2)>>2];l=l+1|0}while((l|0)!=(k|0))}l=c[b+56>>2]|0;if(l){if(a[b+60>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[l+-4>>2]|0);k=c[b+48>>2]|0}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=h;c[b+52>>2]=m;h=k;k=m}else h=k}else h=m;c[(c[b+56>>2]|0)+(h<<2)>>2]=n;m=h+1|0;c[b+48>>2]=m;l=c[n+216>>2]|0;l=o&((l|0)==2|(l|0)==5);j=j+1|0;if((j|0)>=(t|0)){o=j;break b}h=c[b+16>>2]|0;if((c[h+(j<<3)>>2]|0)!=(q|0)){o=j;break}else o=l}}else{o=j;l=1}while(0);if((s|0)<(r|0)){n=c[b+36>>2]|0;h=n+(s<<2)|0;k=c[h>>2]|0;j=c[(c[k+740>>2]|0)+208>>2]|0;if((j|0)<=-1)j=c[(c[k+744>>2]|0)+208>>2]|0;if((j|0)==(q|0)){m=s;do{m=m+1|0;if((m|0)>=(r|0))break;k=c[n+(m<<2)>>2]|0;j=c[(c[k+740>>2]|0)+208>>2]|0;if((j|0)<=-1)j=c[(c[k+744>>2]|0)+208>>2]|0}while((q|0)==(j|0));k=m;j=m-s|0}else{k=p;j=0;h=0}}else{k=p;j=0;h=0}if(!l)Fb[c[(c[f>>2]|0)+8>>2]&7](f,c[b+56>>2]|0,c[b+48>>2]|0,h,j,q);s=(j|0)==0?s:k;h=c[b+48>>2]|0;if((h|0)<0){if((c[b+52>>2]|0)<0){j=c[b+56>>2]|0;if(j|0){if(a[b+60>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[j+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+52>>2]=0}do{c[(c[b+56>>2]|0)+(h<<2)>>2]=0;h=h+1|0}while((h|0)!=0)}c[b+48>>2]=0;if((o|0)>=(t|0))break;else{p=k;j=o}}}}else{t=vb[c[(c[d>>2]|0)+44>>2]&127](d)|0;b=vb[c[(c[d>>2]|0)+36>>2]&127](d)|0;Fb[c[(c[f>>2]|0)+8>>2]&7](f,c[e+16>>2]|0,c[e+8>>2]|0,t,b,-1)}h=c[2006]|0;b=(c[h+16>>2]|0)+-1|0;c[h+16>>2]=b;if(b|0){i=u;return}do if(c[h+4>>2]|0){kb(u|0,0)|0;b=c[5649]|0;g[h+8>>2]=+g[h+8>>2]+ +(((c[u+4>>2]|0)-(c[b+4>>2]|0)+(((c[u>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[h+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[h+16>>2]|0)){h=c[2006]|0;break}else{i=u;return}}while(0);c[2006]=c[h+20>>2];i=u;return}function Ei(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;while(1){k=c[a+12>>2]|0;l=c[k+(((b+d|0)/2|0)<<2)>>2]|0;e=b;f=d;while(1){j=c[(c[l+740>>2]|0)+208>>2]|0;if((j|0)>-1)while(1){h=c[k+(e<<2)>>2]|0;g=c[(c[h+740>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+744>>2]|0)+208>>2]|0;if((g|0)<(j|0))e=e+1|0;else break}else{i=c[(c[l+744>>2]|0)+208>>2]|0;while(1){h=c[k+(e<<2)>>2]|0;g=c[(c[h+740>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+744>>2]|0)+208>>2]|0;if((g|0)<(i|0))e=e+1|0;else break}}if((j|0)>-1)while(1){h=c[k+(f<<2)>>2]|0;g=c[(c[h+740>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+744>>2]|0)+208>>2]|0;if((j|0)<(g|0))f=f+-1|0;else break}else{i=c[(c[l+744>>2]|0)+208>>2]|0;while(1){h=c[k+(f<<2)>>2]|0;g=c[(c[h+740>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+744>>2]|0)+208>>2]|0;if((i|0)<(g|0))f=f+-1|0;else break}}if((e|0)<=(f|0)){i=k+(e<<2)|0;j=c[i>>2]|0;c[i>>2]=c[k+(f<<2)>>2];c[(c[a+12>>2]|0)+(f<<2)>>2]=j;e=e+1|0;f=f+-1|0}if((e|0)>(f|0))break;k=c[a+12>>2]|0}if((f|0)>(b|0))Ei(a,b,f);if((e|0)<(d|0))b=e;else break}return}function Fi(b){b=b|0;var d=0;c[b>>2]=4512;if(!(a[b+8>>0]|0))return;d=c[b+12>>2]|0;if(!d)return;b=c[b+4>>2]|0;tb[c[(c[b>>2]|0)+16>>2]&127](b,d);return}function Gi(b){b=b|0;var d=0,e=0;c[b>>2]=4512;if(!(a[b+8>>0]|0)){rG(b);return}d=c[b+12>>2]|0;if(!d){rG(b);return}e=c[b+4>>2]|0;tb[c[(c[e>>2]|0)+16>>2]&127](e,d);rG(b);return}function Hi(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0;q=i;i=i+32|0;p=c[a+12>>2]|0;if(!p){i=q;return}c[f+4>>2]=p;a=c[b+4>>2]|0;r=c[d+4>>2]|0;b=c[b+12>>2]|0;e=c[d+12>>2]|0;h=+g[b+48>>2]-+g[e+48>>2];j=+g[b+52>>2]-+g[e+52>>2];l=+g[b+56>>2]-+g[e+56>>2];m=+O(+(h*h+j*j+l*l));n=+g[r+32>>2]*+g[r+16>>2];o=+g[a+32>>2]*+g[a+16>>2]+n;if(m>o){if(!(c[p+748>>2]|0)){i=q;return}a=c[p+740>>2]|0;b=c[(c[f+8>>2]|0)+8>>2]|0;e=c[(c[f+12>>2]|0)+8>>2]|0;if((a|0)==(b|0)){Xn(p,a+4|0,e+4|0);i=q;return}else{Xn(p,e+4|0,b+4|0);i=q;return}}c[q+16>>2]=1065353216;c[q+16+4>>2]=0;c[q+16+8>>2]=0;g[q+16+12>>2]=0.0;if(m>1.1920928955078125e-07){g[q+16>>2]=h*(1.0/m);g[q+16+4>>2]=j*(1.0/m);g[q+16+8>>2]=l*(1.0/m);g[q+16+12>>2]=0.0;k=h*(1.0/m);j=j*(1.0/m);h=l*(1.0/m)}else{k=1.0;j=0.0;h=0.0}j=n*j+ +g[e+52>>2];l=n*h+ +g[e+56>>2];g[q>>2]=n*k+ +g[e+48>>2];g[q+4>>2]=j;g[q+8>>2]=l;g[q+12>>2]=0.0;Yb[c[(c[f>>2]|0)+16>>2]&15](f,q+16|0,q,m-o);a=c[f+4>>2]|0;do if(c[a+748>>2]|0){b=c[a+740>>2]|0;d=c[(c[f+8>>2]|0)+8>>2]|0;e=c[(c[f+12>>2]|0)+8>>2]|0;if((b|0)==(d|0)){Xn(a,b+4|0,e+4|0);break}else{Xn(a,e+4|0,d+4|0);break}}while(0);i=q;return}function Ii(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function Ji(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[b+12>>2]|0;if(!e)return;if(!(a[b+8>>0]|0))return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(h=f|0?f<<1:1,(f|0)<(h|0)):0){if(!h)e=0;else{c[5637]=(c[5637]|0)+1;e=qG((h<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[d+4>>2]|0}if((f|0)>0){g=0;do{c[e+(g<<2)>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}g=c[d+12>>2]|0;if(g){if(a[d+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[g+-4>>2]|0);f=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=e;c[d+8>>2]=h;e=c[b+12>>2]|0}c[(c[d+12>>2]|0)+(f<<2)>>2]=e;c[d+4>>2]=f+1;return}function Ki(b){b=b|0;var d=0;c[b>>2]=4540;if(!(a[b+8>>0]|0))return;d=c[b+12>>2]|0;if(!d)return;b=c[b+4>>2]|0;tb[c[(c[b>>2]|0)+16>>2]&127](b,d);return}function Li(b){b=b|0;var d=0,e=0;c[b>>2]=4540;if(!(a[b+8>>0]|0)){rG(b);return}d=c[b+12>>2]|0;if(!d){rG(b);return}e=c[b+4>>2]|0;tb[c[(c[e>>2]|0)+16>>2]&127](e,d);rG(b);return}function Mi(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0;l=i;i=i+160|0;j=c[b+12>>2]|0;if(!j){i=l;return}m=(a[b+16>>0]|0)!=0;n=m?e:d;e=m?d:e;p=c[n+4>>2]|0;o=c[e+4>>2]|0;c[h+4>>2]=j;d=c[j+752>>2]|0;c[l+136>>2]=4568;c[l+136+4>>2]=p;c[l+136+8>>2]=o;c[l+136+12>>2]=d;g[l+128>>2]=999999984306749440.0;d=c[n+12>>2]|0;c[l>>2]=c[d>>2];c[l+4>>2]=c[d+4>>2];c[l+8>>2]=c[d+8>>2];c[l+12>>2]=c[d+12>>2];c[l+16>>2]=c[d+16>>2];c[l+16+4>>2]=c[d+16+4>>2];c[l+16+8>>2]=c[d+16+8>>2];c[l+16+12>>2]=c[d+16+12>>2];c[l+32>>2]=c[d+32>>2];c[l+32+4>>2]=c[d+32+4>>2];c[l+32+8>>2]=c[d+32+8>>2];c[l+32+12>>2]=c[d+32+12>>2];c[l+48>>2]=c[d+48>>2];c[l+48+4>>2]=c[d+48+4>>2];c[l+48+8>>2]=c[d+48+8>>2];c[l+48+12>>2]=c[d+48+12>>2];e=c[e+12>>2]|0;c[l+64>>2]=c[e>>2];c[l+64+4>>2]=c[e+4>>2];c[l+64+8>>2]=c[e+8>>2];c[l+64+12>>2]=c[e+12>>2];c[l+80>>2]=c[e+16>>2];c[l+80+4>>2]=c[e+16+4>>2];c[l+80+8>>2]=c[e+16+8>>2];c[l+80+12>>2]=c[e+16+12>>2];c[l+96>>2]=c[e+32>>2];c[l+96+4>>2]=c[e+32+4>>2];c[l+96+8>>2]=c[e+32+8>>2];c[l+96+12>>2]=c[e+32+12>>2];c[l+112>>2]=c[e+48>>2];c[l+112+4>>2]=c[e+48+4>>2];c[l+112+8>>2]=c[e+48+8>>2];c[l+112+12>>2]=c[e+48+12>>2];Ri(l+136|0,l,h,c[f+20>>2]|0,m);do if(a[b+8>>0]|0?(k=c[h+4>>2]|0,c[k+748>>2]|0):0){d=c[k+740>>2]|0;e=c[(c[h+8>>2]|0)+8>>2]|0;j=c[(c[h+12>>2]|0)+8>>2]|0;if((d|0)==(e|0)){Xn(k,d+4|0,j+4|0);break}else{Xn(k,j+4|0,e+4|0);break}}while(0);i=l;return}function Ni(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function Oi(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[b+12>>2]|0;if(!e)return;if(!(a[b+8>>0]|0))return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(h=f|0?f<<1:1,(f|0)<(h|0)):0){if(!h)e=0;else{c[5637]=(c[5637]|0)+1;e=qG((h<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[d+4>>2]|0}if((f|0)>0){g=0;do{c[e+(g<<2)>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}g=c[d+12>>2]|0;if(g){if(a[d+16>>0]|0){c[5638]=(c[5638]|0)+1;rG(c[g+-4>>2]|0);f=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=e;c[d+8>>2]=h;e=c[b+12>>2]|0}c[(c[d+12>>2]|0)+(f<<2)>>2]=e;c[d+4>>2]=f+1;return}function Pi(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;while(1){j=c[a+12>>2]|0;k=c[j+(((b+d|0)/2|0)<<3)>>2]|0;e=b;f=d;while(1){while(1){h=e+1|0;if((c[j+(e<<3)>>2]|0)<(k|0))e=h;else{i=f;break}}while(1){g=j+(i<<3)|0;f=i+-1|0;if((k|0)<(c[g>>2]|0))i=f;else break}if((e|0)>(i|0))f=i;else{e=j+(e<<3)|0;l=c[e>>2]|0;j=c[e+4>>2]|0;m=c[g+4>>2]|0;c[e>>2]=c[g>>2];c[e+4>>2]=m;e=(c[a+12>>2]|0)+(i<<3)|0;c[e>>2]=l;c[e+4>>2]=j;e=h}if((e|0)>(f|0))break;j=c[a+12>>2]|0}if((f|0)>(b|0))Pi(a,b,f);if((e|0)<(d|0))b=e;else break}return}function Qi(a){a=a|0;rG(a);return}function Ri(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0;E=i;i=i+64|0;A=+g[b+48>>2]-+g[b+112>>2];h=+g[b+52>>2]-+g[b+116>>2];D=+g[b+56>>2]-+g[b+120>>2];B=A*+g[b+64>>2]+h*+g[b+80>>2]+D*+g[b+96>>2];C=A*+g[b+68>>2]+h*+g[b+84>>2]+D*+g[b+100>>2];D=A*+g[b+72>>2]+h*+g[b+88>>2]+D*+g[b+104>>2];e=c[a+8>>2]|0;z=c[a+4>>2]|0;h=+g[z+32>>2]*+g[z+16>>2];A=h+ +g[a+12>>2];p=+g[e+76>>2];q=+g[e+60>>2];r=+g[e+80>>2];s=+g[e+64>>2];t=+g[e+84>>2];u=+g[e+68>>2];v=+g[e+92>>2];w=+g[e+96>>2];x=+g[e+100>>2];k=(r-s)*(x-u)-(t-u)*(w-s);m=(t-u)*(v-q)-(p-q)*(x-u);o=(p-q)*(w-s)-(r-s)*(v-q);n=1.0/+O(+(o*o+(k*k+m*m)));j=(B-q)*(n*k)+(C-s)*(n*m)+n*o*(D-u);if(j<0.0){y=-j;l=-(n*k);j=-(n*m);k=-(n*o)}else{y=j;l=n*k;j=n*m;k=n*o}if(!(y<A)){i=E;return}o=(D-u)*((p-q)*j-(r-s)*l)+((B-q)*((r-s)*k-(t-u)*j)+(C-s)*((t-u)*l-(p-q)*k));t=(D-t)*((v-p)*j-(w-r)*l)+((B-p)*((w-r)*k-(x-t)*j)+(C-r)*((x-t)*l-(v-p)*k));x=(D-x)*((q-v)*j-(s-w)*l)+((B-v)*((s-w)*k-(u-x)*j)+(C-w)*((u-x)*l-(q-v)*k));if(!(x>0.0&(o>0.0&t>0.0))?!(x<=0.0&(o<=0.0&t<=0.0)):0){if((vb[c[(c[e>>2]|0)+100>>2]&127](e)|0)<=0){i=E;return}s=0.0;r=0.0;q=0.0;e=0;z=0;do{F=c[a+8>>2]|0;bc[c[(c[F>>2]|0)+104>>2]&127](F,z,E+48|0,E+32|0);m=+g[E+48>>2];w=+g[E+48+4>>2];u=+g[E+48+8>>2];n=+g[E+32>>2]-m;x=+g[E+32+4>>2]-w;v=+g[E+32+8>>2]-u;do if((B-m)*n+(C-w)*x+(D-u)*v>0.0)if((B-m)*n+(C-w)*x+(D-u)*v<n*n+x*x+v*v){y=((B-m)*n+(C-w)*x+(D-u)*v)/(n*n+x*x+v*v);o=B-m-n*y;p=C-w-x*y;t=D-u-v*y;break}else{o=B-m-n;p=C-w-x;t=D-u-v;y=1.0;break}else{o=B-m;p=C-w;t=D-u;y=0.0}while(0);if(o*o+p*p+t*t<A*A){s=m+n*y;r=u+v*y;q=w+x*y;e=1}z=z+1|0;F=c[a+8>>2]|0}while((z|0)<(vb[c[(c[F>>2]|0)+100>>2]&127](F)|0));if(!(e&1)){i=E;return}else p=A*A}else{p=A*A;s=B-y*l;r=D-y*k;q=C-y*j}n=B-s;o=C-q;m=D-r;if(!(n*n+o*o+m*m<p)){i=E;return}if(n*n+o*o+m*m>1.1920928955078125e-07){j=+O(+(n*n+o*o+m*m));h=h-j;l=n*(1.0/j);k=m*(1.0/j);j=o*(1.0/j)}h=-h;if(f){x=+g[b+64>>2];y=+g[b+68>>2];A=+g[b+72>>2];B=x*l+y*j+A*k;o=+g[b+80>>2];p=+g[b+84>>2];t=+g[b+88>>2];C=l*o+j*p+k*t;u=+g[b+96>>2];v=+g[b+100>>2];w=+g[b+104>>2];D=l*u+j*v+k*w;g[E+48>>2]=-B;g[E+48+4>>2]=-C;g[E+48+8>>2]=-D;g[E+48+12>>2]=0.0;C=s*o+q*p+r*t+ +g[b+116>>2]+C*h;D=s*u+q*v+r*w+ +g[b+120>>2]+D*h;g[E+32>>2]=s*x+q*y+r*A+ +g[b+112>>2]+B*h;g[E+32+4>>2]=C;g[E+32+8>>2]=D;g[E+32+12>>2]=0.0;Yb[c[(c[d>>2]|0)+16>>2]&15](d,E+48|0,E+32|0,h);i=E;return}else{F=c[(c[d>>2]|0)+16>>2]|0;y=+g[b+64>>2];A=+g[b+68>>2];B=+g[b+72>>2];u=+g[b+80>>2];v=+g[b+84>>2];C=+g[b+88>>2];w=+g[b+96>>2];x=+g[b+100>>2];D=+g[b+104>>2];g[E+16>>2]=y*l+A*j+B*k;g[E+16+4>>2]=l*u+j*v+k*C;g[E+16+8>>2]=l*w+j*x+k*D;g[E+16+12>>2]=0.0;C=s*u+q*v+r*C+ +g[b+116>>2];D=s*w+q*x+r*D+ +g[b+120>>2];g[E>>2]=s*y+q*A+r*B+ +g[b+112>>2];g[E+4>>2]=C;g[E+8>>2]=D;g[E+12>>2]=0.0;Yb[F&15](d,E+16|0,E,h);i=E;return}}function Si(a){a=a|0;var b=0,d=0;c[a>>2]=6248;b=c[a+56>>2]|0;if(b|0?(rb[c[c[b>>2]>>2]&255](b),d=c[a+56>>2]|0,d|0):0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function Ti(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0;i=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);m=i+ +g[a+32>>2];k=i+ +g[a+36>>2];i=i+ +g[a+40>>2];u=+N(+(+g[b>>2]));t=+N(+(+g[b+4>>2]));s=+N(+(+g[b+8>>2]));q=+N(+(+g[b+16>>2]));p=+N(+(+g[b+20>>2]));o=+N(+(+g[b+24>>2]));l=+N(+(+g[b+32>>2]));j=+N(+(+g[b+36>>2]));h=+N(+(+g[b+40>>2]));r=+g[b+48>>2];n=+g[b+52>>2];f=+g[b+56>>2];g[d>>2]=r-(m*u+k*t+i*s);g[d+4>>2]=n-(m*q+k*p+i*o);g[d+8>>2]=f-(m*l+k*j+i*h);g[d+12>>2]=0.0;g[e>>2]=m*u+k*t+i*s+r;g[e+4>>2]=m*q+k*p+i*o+n;g[e+8>>2]=m*l+k*j+i*h+f;g[e+12>>2]=0.0;return}function Ui(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0;k=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);d=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);m=(k+ +g[a+32>>2])/+g[a+16>>2];j=(h+ +g[a+36>>2])/+g[a+20>>2];f=(d+ +g[a+40>>2])/+g[a+24>>2];l=+N(+(+g[b>>2]));i=+N(+(+g[b+4>>2]));e=+N(+(+g[b+8>>2]));g[a+16>>2]=l;g[a+20>>2]=i;g[a+24>>2]=e;g[a+28>>2]=0.0;g[a+32>>2]=m*l-k;g[a+36>>2]=j*i-h;g[a+40>>2]=f*e-d;g[a+44>>2]=0.0;return}function Vi(a,b,d){a=a|0;b=+b;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;i=+g[a+32>>2];f=+g[a+36>>2];j=+g[a+40>>2];h=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);j=(j+ +Hb[c[(c[a>>2]|0)+48>>2]&15](a))*2.0;g[d>>2]=b/12.0*((f+e)*2.0*((f+e)*2.0)+j*j);g[d+4>>2]=b/12.0*((i+h)*2.0*((i+h)*2.0)+j*j);g[d+8>>2]=b/12.0*((i+h)*2.0*((i+h)*2.0)+(f+e)*2.0*((f+e)*2.0));g[d+12>>2]=0.0;return}function Wi(a){a=a|0;return 12683}function Xi(a,b){a=a|0;b=+b;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0;h=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);i=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);h=h+ +g[a+32>>2];e=e+ +g[a+36>>2];i=i+ +g[a+40>>2];g[a+48>>2]=b;f=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);d=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);b=i-+Hb[c[(c[a>>2]|0)+48>>2]&15](a);g[a+32>>2]=h-f;g[a+36>>2]=e-d;g[a+40>>2]=b;g[a+44>>2]=0.0;return}function Yi(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;i=+g[b+32>>2];j=+g[b+36>>2];e=+g[b+40>>2];h=+Hb[c[(c[b>>2]|0)+48>>2]&15](b);f=+Hb[c[(c[b>>2]|0)+48>>2]&15](b);e=e+ +Hb[c[(c[b>>2]|0)+48>>2]&15](b);f=+g[d+4>>2]>=0.0?j+f:-(j+f);e=+g[d+8>>2]>=0.0?e:-e;g[a>>2]=+g[d>>2]>=0.0?i+h:-(i+h);g[a+4>>2]=f;g[a+8>>2]=e;g[a+12>>2]=0.0;return}function Zi(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0;f=+g[b+32>>2];e=+g[b+36>>2];e=+g[c+4>>2]>=0.0?e:-e;d=+g[b+40>>2];d=+g[c+8>>2]>=0.0?d:-d;g[a>>2]=+g[c>>2]>=0.0?f:-f;g[a+4>>2]=e;g[a+8>>2]=d;g[a+12>>2]=0.0;return}function _i(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0;if((d|0)<=0)return;e=0;do{i=+g[a+32>>2];h=+g[a+36>>2];h=+g[b+(e<<4)+4>>2]>=0.0?h:-h;f=+g[a+40>>2];f=+g[b+(e<<4)+8>>2]>=0.0?f:-f;g[c+(e<<4)>>2]=+g[b+(e<<4)>>2]>=0.0?i:-i;g[c+(e<<4)+4>>2]=h;g[c+(e<<4)+8>>2]=f;g[c+(e<<4)+12>>2]=0.0;e=e+1|0}while((e|0)!=(d|0));return}function $i(a){a=a|0;return 6}function aj(a,b,d){a=a|0;b=b|0;d=d|0;switch(b|0){case 0:{c[d>>2]=1065353216;c[d+4>>2]=0;c[d+8>>2]=0;g[d+12>>2]=0.0;return}case 1:{c[d>>2]=-1082130432;c[d+4>>2]=0;c[d+8>>2]=0;g[d+12>>2]=0.0;return}case 2:{c[d>>2]=0;c[d+4>>2]=1065353216;c[d+8>>2]=0;g[d+12>>2]=0.0;return}case 3:{c[d>>2]=0;c[d+4>>2]=-1082130432;c[d+8>>2]=0;g[d+12>>2]=0.0;return}case 4:{c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=1065353216;g[d+12>>2]=0.0;return}case 5:{c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=-1082130432;g[d+12>>2]=0.0;return}default:return}}function bj(a){a=a|0;return 8}function cj(a){a=a|0;return 12}function dj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;do switch(b|0){case 0:{f=0;b=1;break}case 1:{f=0;b=2;break}case 2:{f=1;b=3;break}case 3:{f=2;break}case 4:{f=0;break}case 5:{f=1;break}case 6:{f=2;break}case 7:{f=3;break}case 8:{f=4;b=5;break}case 9:{f=4;b=6;break}case 10:{f=5;b=7;break}case 11:{f=6;b=7;break}default:{f=0;b=0}}while(0);Zb[c[(c[a>>2]|0)+108>>2]&127](a,f,d);Zb[c[(c[a>>2]|0)+108>>2]&127](a,b,e);return}function ej(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;j=+g[a+32>>2];h=+g[a+36>>2];e=+g[a+40>>2];i=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);e=e+ +Hb[c[(c[a>>2]|0)+48>>2]&15](a);g[d>>2]=+(b&1^1|0)*(j+i)-+(b&1|0)*(j+i);g[d+4>>2]=+(b>>>1&1^1|0)*(h+f)-+(b>>>1&1|0)*(h+f);g[d+8>>2]=+(b>>>2&1^1|0)*e-+(b>>>2&1|0)*e;g[d+12>>2]=0.0;return}function fj(a){a=a|0;return 6}function gj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,l=0.0,m=0,n=0;f=i;i=i+48|0;Zb[c[(c[a>>2]|0)+124>>2]&127](a,f+32|0,e);n=c[f+32>>2]|0;m=c[f+32+4>>2]|0;e=c[f+32+8>>2]|0;c[b>>2]=n;c[b+4>>2]=m;c[b+8>>2]=e;g[b+12>>2]=0.0;b=c[(c[a>>2]|0)+64>>2]|0;l=-(c[k>>2]=n,+g[k>>2]);j=-(c[k>>2]=m,+g[k>>2]);h=-(c[k>>2]=e,+g[k>>2]);g[f>>2]=l;g[f+4>>2]=j;g[f+8>>2]=h;g[f+12>>2]=0.0;Zb[b&127](f+16|0,a,f);c[d>>2]=c[f+16>>2];c[d+4>>2]=c[f+16+4>>2];c[d+8>>2]=c[f+16+8>>2];c[d+12>>2]=c[f+16+12>>2];i=f;return}function hj(a,b,c){a=a|0;b=b|0;c=+c;var d=0.0,e=0.0,f=0.0,h=0.0;e=+g[a+32>>2];f=+g[a+36>>2];h=+g[a+40>>2];d=+g[b>>2];if(!(d<=e+c)){b=0;return b|0}if(!(d>=-e-c)){b=0;return b|0}d=+g[b+4>>2];if(!(d<=f+c)){b=0;return b|0}if(!(d>=-f-c)){b=0;return b|0}d=+g[b+8>>2];if(!(d<=h+c)){b=0;return b|0}b=d>=-h-c;return b|0}function ij(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0;f=+g[a+32>>2];h=+g[a+36>>2];e=+g[a+40>>2];switch(d|0){case 0:{c[b>>2]=1065353216;c[b+4>>2]=0;c[b+8>>2]=0;g[b+12>>2]=-f;return}case 1:{c[b>>2]=-1082130432;c[b+4>>2]=0;c[b+8>>2]=0;g[b+12>>2]=-f;return}case 2:{c[b>>2]=0;c[b+4>>2]=1065353216;c[b+8>>2]=0;g[b+12>>2]=-h;return}case 3:{c[b>>2]=0;c[b+4>>2]=-1082130432;c[b+8>>2]=0;g[b+12>>2]=-h;return}case 4:{c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=1065353216;g[b+12>>2]=-e;return}case 5:{c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=-1082130432;g[b+12>>2]=-e;return}default:return}}function jj(a,b){a=a|0;b=b|0;var d=0.0,e=0,f=0.0,h=0.0,i=0.0,j=0.0;c[a+8>>2]=0;c[a+12>>2]=-1;c[a+16>>2]=1065353216;c[a+20>>2]=1065353216;c[a+24>>2]=1065353216;g[a+28>>2]=0.0;g[a+48>>2]=.03999999910593033;c[a+56>>2]=0;c[a>>2]=4588;c[a+4>>2]=0;h=+g[b>>2];f=+g[b+4>>2];d=+g[b+8>>2];d=+g[b+((h<f?(h<d?0:2):f<d?1:2)<<2)>>2]*.10000000149011612;if(d<.03999999910593033){j=+Mg(a);i=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);j=j+ +g[a+32>>2];i=i+ +g[a+36>>2];h=h+ +g[a+40>>2];g[a+48>>2]=d;d=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);h=h-+Hb[c[(c[a>>2]|0)+48>>2]&15](a);g[a+32>>2]=j-d;g[a+36>>2]=i-f;g[a+40>>2]=h;g[a+44>>2]=0.0;e=c[a>>2]|0}else e=4588;h=+Hb[c[e+48>>2]&15](a);i=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);j=+Hb[c[(c[a>>2]|0)+48>>2]&15](a);i=+g[b+4>>2]*+g[a+20>>2]-i;j=+g[b+8>>2]*+g[a+24>>2]-j;g[a+32>>2]=+g[b>>2]*+g[a+16>>2]-h;g[a+36>>2]=i;g[a+40>>2]=j;g[a+44>>2]=0.0;return}function kj(b){b=b|0;var d=0;c[b>>2]=4724;if(!(a[b+65>>0]|0))return;d=c[b+56>>2]|0;rb[c[c[d>>2]>>2]&255](d);b=c[b+56>>2]|0;if(!b)return;c[5638]=(c[5638]|0)+1;rG(c[b+-4>>2]|0);return}function lj(b){b=b|0;var d=0;c[b>>2]=4724;if(a[b+65>>0]|0?(d=c[b+56>>2]|0,rb[c[c[d>>2]>>2]&255](d),d=c[b+56>>2]|0,d|0):0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}c[5638]=(c[5638]|0)+1;rG(c[b+-4>>2]|0);return}function mj(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0;j=vb[c[(c[b>>2]|0)+28>>2]&127](b)|0;i=+g[j>>2]-+g[d>>2];h=+g[j+4>>2]-+g[d+4>>2];f=+g[j+8>>2]-+g[d+8>>2];if(!(i*i+h*h+f*f>1.1920928955078125e-07))return;fn(b,d);if((a[b+65>>0]|0)!=0?(e=c[b+56>>2]|0,rb[c[c[e>>2]>>2]&255](e),e=c[b+56>>2]|0,(e|0)!=0):0){c[5638]=(c[5638]|0)+1;rG(c[e+-4>>2]|0);d=b+56|0}else d=b+56|0;c[5637]=(c[5637]|0)+1;e=qG(191)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[e+52>>2]=284;a[e+60>>0]=0;a[e+80>>0]=1;c[e+76>>2]=0;c[e+68>>2]=0;c[e+72>>2]=0;a[e+100>>0]=1;c[e+96>>2]=0;c[e+88>>2]=0;c[e+92>>2]=0;a[e+120>>0]=1;c[e+116>>2]=0;c[e+108>>2]=0;c[e+112>>2]=0;a[e+140>>0]=1;c[e+136>>2]=0;c[e+128>>2]=0;c[e+132>>2]=0;c[e+144>>2]=0;a[e+164>>0]=1;c[e+160>>2]=0;c[e+152>>2]=0;c[e+156>>2]=0;c[e+168>>2]=0;c[e+4>>2]=-8388609;c[e+8>>2]=-8388609;c[e+12>>2]=-8388609;g[e+16>>2]=0.0;c[e+20>>2]=2139095039;c[e+24>>2]=2139095039;c[e+28>>2]=2139095039;g[e+32>>2]=0.0;c[e>>2]=6168;c[d>>2]=e;Zl(e,c[b+52>>2]|0,(a[b+64>>0]|0)!=0,b+20|0,b+36|0);a[b+65>>0]=1;return}function nj(a){a=a|0;return 12712}function oj(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function pj(a){a=a|0;return +(+g[a+16>>2])}function qj(a){a=a|0;return 60}function rj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=Ob[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;g=Ob[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=g;if(g|0)tb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];g=c[a+52>>2]|0;Eb[c[(c[g>>2]|0)+56>>2]&63](g,b+12|0,d)|0;c[b+52>>2]=c[a+16>>2];do if((c[a+56>>2]|0)!=0?((vb[c[(c[d>>2]|0)+52>>2]&127](d)|0)&1|0)==0:0){e=Ob[c[(c[d>>2]|0)+24>>2]&31](d,c[a+56>>2]|0)|0;if(!e){c[b+40>>2]=Ob[c[(c[d>>2]|0)+28>>2]&31](d,c[a+56>>2]|0)|0;c[b+44>>2]=0;e=c[a+56>>2]|0;e=vb[c[(c[e>>2]|0)+12>>2]&127](e)|0;e=Eb[c[(c[d>>2]|0)+16>>2]&63](d,e,1)|0;g=c[a+56>>2]|0;g=Eb[c[(c[g>>2]|0)+16>>2]&63](g,c[e+8>>2]|0,d)|0;pb[c[(c[d>>2]|0)+20>>2]&31](d,e,g,1213612625,c[a+56>>2]|0);break}else{c[b+40>>2]=e;c[b+44>>2]=0;break}}else f=8;while(0);if((f|0)==8){c[b+40>>2]=0;c[b+44>>2]=0}if(c[a+60>>2]|0?((vb[c[(c[d>>2]|0)+52>>2]&127](d)|0)&2|0)==0:0){e=Ob[c[(c[d>>2]|0)+24>>2]&31](d,c[a+60>>2]|0)|0;if(!e){c[b+48>>2]=Ob[c[(c[d>>2]|0)+28>>2]&31](d,c[a+60>>2]|0)|0;b=c[a+60>>2]|0;b=vb[c[(c[b>>2]|0)+8>>2]&127](b)|0;b=Eb[c[(c[d>>2]|0)+16>>2]&63](d,b,1)|0;g=c[a+60>>2]|0;g=Eb[c[(c[g>>2]|0)+12>>2]&63](g,c[b+8>>2]|0,d)|0;pb[c[(c[d>>2]|0)+20>>2]&31](d,b,g,1346456916,c[a+60>>2]|0);return 12728}else{c[b+48>>2]=e;return 12728}}c[b+48>>2]=0;return 12728}function sj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+64|0;g=c[a+52>>2]|0;c[f>>2]=4816;c[f+4>>2]=g;c[f+8>>2]=b;me(c[a+56>>2]|0,f,d,e);i=f;return}function tj(a){a=a|0;rG(a);return}function uj(a,b,f){a=a|0;b=b|0;f=f|0;var j=0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=i;i=i+32|0;o=c[a+4>>2]|0;Nb[c[(c[o>>2]|0)+16>>2]&3](o,t+28|0,t+24|0,t+20|0,t+16|0,t+12|0,t+8|0,t+4|0,t,b);o=(c[t+12>>2]|0)+(_(c[t+8>>2]|0,f)|0)|0;s=c[a+4>>2]|0;n=c[t>>2]|0;switch(n|0){case 3:{j=e[o+4>>1]|0;break}case 2:{j=c[o+8>>2]|0;break}default:j=d[o+2>>0]|0}r=(c[t+20>>2]|0)==0;p=c[t+28>>2]|0;q=c[t+16>>2]|0;j=p+(_(q,j)|0)|0;if(r){l=+g[j+8>>2]*+g[s+12>>2];m=+g[j+4>>2]*+g[s+8>>2];k=+g[j>>2]*+g[s+4>>2]}else{l=+h[j+16>>3]*+g[s+12>>2];m=+h[j+8>>3]*+g[s+8>>2];k=+h[j>>3]*+g[s+4>>2]}g[a+44>>2]=k;g[a+48>>2]=m;g[a+52>>2]=l;g[a+56>>2]=0.0;switch(n|0){case 3:{j=e[o+2>>1]|0;break}case 2:{j=c[o+4>>2]|0;break}default:j=d[o+1>>0]|0}j=p+(_(q,j)|0)|0;if(r){l=+g[j+8>>2]*+g[s+12>>2];m=+g[j+4>>2]*+g[s+8>>2];k=+g[j>>2]*+g[s+4>>2]}else{l=+h[j+16>>3]*+g[s+12>>2];m=+h[j+8>>3]*+g[s+8>>2];k=+h[j>>3]*+g[s+4>>2]}g[a+28>>2]=k;g[a+32>>2]=m;g[a+36>>2]=l;g[a+40>>2]=0.0;switch(n|0){case 3:{j=e[o>>1]|0;break}case 2:{j=c[o>>2]|0;break}default:j=d[o>>0]|0}j=p+(_(q,j)|0)|0;if(r){m=+g[j+8>>2]*+g[s+12>>2];l=+g[j+4>>2]*+g[s+8>>2];k=+g[j>>2]*+g[s+4>>2];r=a+12|0;g[r>>2]=k;r=a+16|0;g[r>>2]=l;r=a+20|0;g[r>>2]=m;r=a+24|0;g[r>>2]=0.0;r=a+8|0;r=c[r>>2]|0;q=c[r>>2]|0;q=q+8|0;q=c[q>>2]|0;s=a+12|0;bc[q&127](r,s,b,f);a=c[a+4>>2]|0;f=c[a>>2]|0;f=f+24|0;f=c[f>>2]|0;tb[f&127](a,b);i=t;return}else{m=+h[j+16>>3]*+g[s+12>>2];l=+h[j+8>>3]*+g[s+8>>2];k=+h[j>>3]*+g[s+4>>2];r=a+12|0;g[r>>2]=k;r=a+16|0;g[r>>2]=l;r=a+20|0;g[r>>2]=m;r=a+24|0;g[r>>2]=0.0;r=a+8|0;r=c[r>>2]|0;q=c[r>>2]|0;q=q+8|0;q=c[q>>2]|0;s=a+12|0;bc[q&127](r,s,b,f);a=c[a+4>>2]|0;f=c[a>>2]|0;f=f+24|0;f=c[f>>2]|0;tb[f&127](a,b);i=t;return}}function vj(a,b,d){a=a|0;b=b|0;d=d|0;Zb[c[(c[b>>2]|0)+68>>2]&127](a,b,d);return}function wj(a,b){a=a|0;b=b|0;var d=0,e=0;d=c[a+56>>2]|0;if(!d)return;e=vb[c[(c[d>>2]|0)+12>>2]&127](d)|0;e=Eb[c[(c[b>>2]|0)+16>>2]&63](b,e,1)|0;d=c[a+56>>2]|0;d=Eb[c[(c[d>>2]|0)+16>>2]&63](d,c[e+8>>2]|0,b)|0;pb[c[(c[b>>2]|0)+20>>2]&31](b,e,d,1213612625,c[a+56>>2]|0);return}function xj(a,b){a=a|0;b=b|0;var d=0,e=0;d=c[a+60>>2]|0;if(!d)return;e=vb[c[(c[d>>2]|0)+8>>2]&127](d)|0;e=Eb[c[(c[b>>2]|0)+16>>2]&63](b,e,1)|0;d=c[a+60>>2]|0;d=Eb[c[(c[d>>2]|0)+12>>2]&63](d,c[e+8>>2]|0,b)|0;pb[c[(c[b>>2]|0)+20>>2]&31](b,e,d,1346456916,c[a+60>>2]|0);return}function yj(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0;h=i;i=i+48|0;c[b+8>>2]=0;c[b+12>>2]=-1;g[b+16>>2]=0.0;c[b>>2]=6692;c[b+52>>2]=d;c[b+4>>2]=21;if(vb[c[(c[d>>2]|0)+40>>2]&127](d)|0)Zb[c[(c[d>>2]|0)+48>>2]&127](d,b+20|0,b+36|0);else{c[h+32>>2]=0;c[h+32+4>>2]=0;c[h+32+8>>2]=0;c[h+32+12>>2]=0;g[h+32>>2]=1.0;Zb[c[(c[b>>2]|0)+68>>2]&127](h+16|0,b,h+32|0);g[b+36>>2]=+g[h+16>>2]+ +g[b+16>>2];g[h+32>>2]=-1.0;Zb[c[(c[b>>2]|0)+68>>2]&127](h,b,h+32|0);c[h+16>>2]=c[h>>2];c[h+16+4>>2]=c[h+4>>2];c[h+16+8>>2]=c[h+8>>2];c[h+16+12>>2]=c[h+12>>2];g[b+20>>2]=+g[h+16>>2]-+g[b+16>>2];c[h+32>>2]=0;c[h+32+4>>2]=0;c[h+32+8>>2]=0;c[h+32+12>>2]=0;g[h+32+4>>2]=1.0;Zb[c[(c[b>>2]|0)+68>>2]&127](h+16|0,b,h+32|0);g[b+40>>2]=+g[h+16+4>>2]+ +g[b+16>>2];g[h+32+4>>2]=-1.0;Zb[c[(c[b>>2]|0)+68>>2]&127](h,b,h+32|0);c[h+16>>2]=c[h>>2];c[h+16+4>>2]=c[h+4>>2];c[h+16+8>>2]=c[h+8>>2];c[h+16+12>>2]=c[h+12>>2];g[b+24>>2]=+g[h+16+4>>2]-+g[b+16>>2];c[h+32>>2]=0;c[h+32+4>>2]=0;c[h+32+8>>2]=0;c[h+32+12>>2]=0;g[h+32+8>>2]=1.0;Zb[c[(c[b>>2]|0)+68>>2]&127](h+16|0,b,h+32|0);g[b+44>>2]=+g[h+16+8>>2]+ +g[b+16>>2];g[h+32+8>>2]=-1.0;Zb[c[(c[b>>2]|0)+68>>2]&127](h,b,h+32|0);c[h+16>>2]=c[h>>2];c[h+16+4>>2]=c[h+4>>2];c[h+16+8>>2]=c[h+8>>2];c[h+16+12>>2]=c[h+12>>2];g[b+28>>2]=+g[h+16+8>>2]-+g[b+16>>2]}c[b>>2]=4724;c[b+56>>2]=0;c[b+60>>2]=0;a[b+64>>0]=e&1;a[b+65>>0]=0;c[b+4>>2]=21;if(!f){i=h;return}c[5637]=(c[5637]|0)+1;f=qG(191)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}c[f+52>>2]=284;a[f+60>>0]=0;a[f+80>>0]=1;c[f+76>>2]=0;c[f+68>>2]=0;c[f+72>>2]=0;a[f+100>>0]=1;c[f+96>>2]=0;c[f+88>>2]=0;c[f+92>>2]=0;a[f+120>>0]=1;c[f+116>>2]=0;c[f+108>>2]=0;c[f+112>>2]=0;a[f+140>>0]=1;c[f+136>>2]=0;c[f+128>>2]=0;c[f+132>>2]=0;c[f+144>>2]=0;a[f+164>>0]=1;c[f+160>>2]=0;c[f+152>>2]=0;c[f+156>>2]=0;c[f+168>>2]=0;c[f+4>>2]=-8388609;c[f+8>>2]=-8388609;c[f+12>>2]=-8388609;g[f+16>>2]=0.0;c[f+20>>2]=2139095039;c[f+24>>2]=2139095039;c[f+28>>2]=2139095039;g[f+32>>2]=0.0;c[f>>2]=6168;c[b+56>>2]=f;Zl(f,c[b+52>>2]|0,(a[b+64>>0]|0)!=0,b+20|0,b+36|0);a[b+65>>0]=1;i=h;return}function zj(a){a=a|0;rG(a);return}
function cc(a){a=a|0;var b=0;b=i;i=i+a|0;i=i+15&-16;return b|0}function dc(){return i|0}function ec(a){a=a|0;i=a}function fc(a,b){a=a|0;b=b|0;i=a;j=b}function gc(a,b){a=a|0;b=b|0;if(!n){n=a;o=b}}function hc(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0]}function ic(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0];a[k+4>>0]=a[b+4>>0];a[k+5>>0]=a[b+5>>0];a[k+6>>0]=a[b+6>>0];a[k+7>>0]=a[b+7>>0]}function jc(a){a=a|0;C=a}function kc(){return C|0}function lc(d,f,h,i,j,k){d=d|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0.0,m=0.0,n=0.0;c[d>>2]=2552;b[d+4>>1]=-2;b[d+6>>1]=-1;c[d+92>>2]=j;c[d+96>>2]=0;a[d+100>>0]=0;c[d+104>>2]=0;c[d+108>>2]=0;if(!j){c[5637]=(c[5637]|0)+1;j=qG(91)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}de(j);c[d+92>>2]=j;a[d+100>>0]=1}if(!k){c[5637]=(c[5637]|0)+1;j=qG(43)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16};c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[j+16>>2]=0;c[j+20>>2]=0;c[j>>2]=2616;a[j+20>>0]=1;c[j+16>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[d+112>>2]=j;c[5637]=(c[5637]|0)+1;j=qG(215)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}Gd(j,c[d+112>>2]|0);c[d+108>>2]=j;a[j+193>>0]=1};c[d+8>>2]=c[f>>2];c[d+8+4>>2]=c[f+4>>2];c[d+8+8>>2]=c[f+8>>2];c[d+8+12>>2]=c[f+12>>2];c[d+24>>2]=c[h>>2];c[d+24+4>>2]=c[h+4>>2];c[d+24+8>>2]=c[h+8>>2];c[d+24+12>>2]=c[h+12>>2];n=+(e[d+6>>1]|0);m=n/(+g[d+28>>2]-+g[d+12>>2]);l=n/(+g[d+32>>2]-+g[d+16>>2]);g[d+40>>2]=n/(+g[d+24>>2]-+g[d+8>>2]);g[d+44>>2]=m;g[d+48>>2]=l;g[d+52>>2]=0.0;f=(i&65535)+1&65535;c[5637]=(c[5637]|0)+1;j=qG(f<<6|19)|0;if(!j)h=0;else{c[(j+4+15&-16)+-4>>2]=j;h=j+4+15&-16}if(f|0){j=h+(f<<6)|0;k=h;do{c[k>>2]=0;c[k+8>>2]=0;k=k+64|0}while((k|0)!=(j|0))}c[d+60>>2]=h;b[d+58>>1]=(i&65535)+1;b[d+56>>1]=0;b[d+64>>1]=1;if(f>>>0>1){j=1;k=1;do{b[h+(j<<6)+48>>1]=j+1;k=k+1<<16>>16;j=k&65535}while(j>>>0<f>>>0)}b[h+(f+-1<<6)+48>>1]=0;c[5637]=(c[5637]|0)+1;j=qG((f<<3|3)+16|0)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}c[d+80>>2]=j;c[d+68>>2]=j;c[5637]=(c[5637]|0)+1;j=qG((f<<3|3)+16|0)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}c[d+84>>2]=j;c[d+72>>2]=j;c[5637]=(c[5637]|0)+1;j=qG((f<<3|3)+16|0)|0;if(!j){h=0;i=d+88|0;c[i>>2]=h;i=d+76|0;c[i>>2]=h;h=c[d+60>>2]|0;c[h>>2]=0;f=h+48|0;b[f>>1]=0;f=h+54|0;b[f>>1]=1;f=c[d+68>>2]|0;b[f>>1]=0;k=f+2|0;b[k>>1]=0;k=b[d+6>>1]|0;j=f+4|0;b[j>>1]=k;f=f+6|0;b[f>>1]=0;f=h+50|0;b[f>>1]=0;f=h+56|0;b[f>>1]=1;f=c[d+72>>2]|0;b[f>>1]=0;j=f+2|0;b[j>>1]=0;j=b[d+6>>1]|0;k=f+4|0;b[k>>1]=j;f=f+6|0;b[f>>1]=0;f=h+52|0;b[f>>1]=0;h=h+58|0;b[h>>1]=1;i=c[i>>2]|0;b[i>>1]=0;h=i+2|0;b[h>>1]=0;h=b[d+6>>1]|0;f=i+4|0;b[f>>1]=h;i=i+6|0;b[i>>1]=0;c[d>>2]=2488;return}c[(j+4+15&-16)+-4>>2]=j;h=j+4+15&-16;i=d+88|0;c[i>>2]=h;i=d+76|0;c[i>>2]=h;h=c[d+60>>2]|0;c[h>>2]=0;f=h+48|0;b[f>>1]=0;f=h+54|0;b[f>>1]=1;f=c[d+68>>2]|0;b[f>>1]=0;k=f+2|0;b[k>>1]=0;k=b[d+6>>1]|0;j=f+4|0;b[j>>1]=k;f=f+6|0;b[f>>1]=0;f=h+50|0;b[f>>1]=0;f=h+56|0;b[f>>1]=1;f=c[d+72>>2]|0;b[f>>1]=0;j=f+2|0;b[j>>1]=0;j=b[d+6>>1]|0;k=f+4|0;b[k>>1]=j;f=f+6|0;b[f>>1]=0;f=h+52|0;b[f>>1]=0;h=h+58|0;b[h>>1]=1;i=c[i>>2]|0;b[i>>1]=0;h=i+2|0;b[h>>1]=0;h=b[d+6>>1]|0;f=i+4|0;b[f>>1]=h;i=i+6|0;b[i>>1]=0;c[d>>2]=2488;return}function mc(b){b=b|0;var d=0;c[b>>2]=2552;if(c[b+108>>2]|0){d=c[b+112>>2]|0;rb[c[c[d>>2]>>2]&255](d);d=c[b+112>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+108>>2]|0;rb[c[c[d>>2]>>2]&255](d);d=c[b+108>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}}d=c[b+88>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+84>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+80>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}d=c[b+60>>2]|0;if(d|0){c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0)}if(!(a[b+100>>0]|0))return;d=c[b+92>>2]|0;rb[c[c[d>>2]>>2]&255](d);d=c[b+92>>2]|0;if(!d)return;c[5638]=(c[5638]|0)+1;rG(c[d+-4>>2]|0);return}function nc(a){a=a|0;mc(a);if(!a)return;c[5638]=(c[5638]|0)+1;rG(c[a+-4>>2]|0);return}function oc(a,d,f,h,j,k,l,m,n){a=a|0;d=d|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=i;i=i+16|0;Tc(a,w+6|0,+g[d>>2],+g[d+4>>2],+g[d+8>>2],0);Tc(a,w,+g[f>>2],+g[f+4>>2],+g[f+8>>2],1);v=b[a+64>>1]|0;u=c[a+60>>2]|0;b[a+64>>1]=b[u+((v&65535)<<6)+48>>1]|0;o=(b[a+56>>1]|0)+1<<16>>16;b[a+56>>1]=o;c[u+((v&65535)<<6)+12>>2]=v&65535;c[u+((v&65535)<<6)>>2]=j;b[u+((v&65535)<<6)+4>>1]=k;b[u+((v&65535)<<6)+6>>1]=l;c[u+((v&65535)<<6)+8>>2]=n;q=(o&65535)<<1&65534;b[u+54>>1]=(e[u+54>>1]|0)+2;p=c[a+68>>2]|0;n=e[p+(q+-1<<2)>>1]|e[p+(q+-1<<2)+2>>1]<<16;b[p+((q|1)<<2)>>1]=n;b[p+((q|1)<<2)+2>>1]=n>>>16;p=c[a+68>>2]|0;b[p+(q+-1<<2)>>1]=b[w+6>>1]|0;b[p+(q+-1<<2)+2>>1]=v;b[p+(q<<2)>>1]=b[w>>1]|0;b[p+(q<<2)+2>>1]=v;b[u+((v&65535)<<6)+48>>1]=q+-1;b[u+((v&65535)<<6)+54>>1]=(o&65535)<<1;p=(c[a+60>>2]|0)+56|0;b[p>>1]=(e[p>>1]|0)+2;p=c[a+72>>2]|0;n=e[p+(q+-1<<2)>>1]|e[p+(q+-1<<2)+2>>1]<<16;b[p+((q|1)<<2)>>1]=n;b[p+((q|1)<<2)+2>>1]=n>>>16;p=c[a+72>>2]|0;b[p+(q+-1<<2)>>1]=b[w+6+2>>1]|0;b[p+(q+-1<<2)+2>>1]=v;b[p+(q<<2)>>1]=b[w+2>>1]|0;b[p+(q<<2)+2>>1]=v;b[u+((v&65535)<<6)+50>>1]=q+-1;b[u+((v&65535)<<6)+56>>1]=(o&65535)<<1;p=(c[a+60>>2]|0)+58|0;b[p>>1]=(e[p>>1]|0)+2;p=c[a+76>>2]|0;n=e[p+(q+-1<<2)>>1]|e[p+(q+-1<<2)+2>>1]<<16;b[p+((q|1)<<2)>>1]=n;b[p+((q|1)<<2)+2>>1]=n>>>16;p=c[a+76>>2]|0;b[p+(q+-1<<2)>>1]=b[w+6+4>>1]|0;b[p+(q+-1<<2)+2>>1]=v;b[p+(q<<2)>>1]=b[w+4>>1]|0;b[p+(q<<2)+2>>1]=v;b[u+((v&65535)<<6)+52>>1]=q+-1;b[u+((v&65535)<<6)+58>>1]=(o&65535)<<1;o=c[a+68>>2]|0;q=e[u+((v&65535)<<6)+48>>1]|0;p=c[a+60>>2]|0;n=b[o+(q<<2)+-4>>1]|0;if((e[o+(q<<2)>>1]|0)<(n&65535)){s=p+((e[o+(q<<2)+2>>1]|0)<<6)+48|0;r=o+(q<<2)|0;q=o+(q<<2)+-4|0;while(1){o=e[r+-2>>1]|0;if(!(n&1)){t=p+(o<<6)+48|0;b[t>>1]=(b[t>>1]|0)+1<<16>>16}else{t=p+(o<<6)+54|0;b[t>>1]=(b[t>>1]|0)+1<<16>>16}b[s>>1]=(b[s>>1]|0)+-1<<16>>16;o=e[r>>1]|e[r+2>>1]<<16;n=e[q>>1]|e[q+2>>1]<<16;b[r>>1]=n;b[r+2>>1]=n>>>16;b[q>>1]=o;b[q+2>>1]=o>>>16;o=r+-4|0;q=q+-4|0;n=b[q>>1]|0;if((e[o>>1]|0)>=(n&65535))break;p=c[a+60>>2]|0;r=o}o=c[a+68>>2]|0}n=e[u+((v&65535)<<6)+54>>1]|0;q=o+(n<<2)|0;p=b[q+-4>>1]|0;a:do if((e[q>>1]|0)<(p&65535)){s=c[a+60>>2]|0;t=s+((e[o+(n<<2)+2>>1]|0)<<6)+54|0;n=p;r=q;p=q+-4|0;while(1){o=e[r+-2>>1]|0;if(!(n&1)){s=s+(o<<6)+48|0;b[s>>1]=(b[s>>1]|0)+1<<16>>16}else{s=s+(o<<6)+54|0;b[s>>1]=(b[s>>1]|0)+1<<16>>16}b[t>>1]=(b[t>>1]|0)+-1<<16>>16;o=e[r>>1]|e[r+2>>1]<<16;n=e[p>>1]|e[p+2>>1]<<16;b[r>>1]=n;b[r+2>>1]=n>>>16;b[p>>1]=o;b[p+2>>1]=o>>>16;o=r+-4|0;p=p+-4|0;n=b[p>>1]|0;if((e[o>>1]|0)>=(n&65535))break a;s=c[a+60>>2]|0;r=o}}while(0);o=c[a+72>>2]|0;q=e[u+((v&65535)<<6)+50>>1]|0;p=c[a+60>>2]|0;n=b[o+(q<<2)+-4>>1]|0;if((e[o+(q<<2)>>1]|0)<(n&65535)){s=p+((e[o+(q<<2)+2>>1]|0)<<6)+50|0;r=o+(q<<2)|0;q=o+(q<<2)+-4|0;while(1){o=e[r+-2>>1]|0;if(!(n&1)){t=p+(o<<6)+50|0;b[t>>1]=(b[t>>1]|0)+1<<16>>16}else{t=p+(o<<6)+56|0;b[t>>1]=(b[t>>1]|0)+1<<16>>16}b[s>>1]=(b[s>>1]|0)+-1<<16>>16;o=e[r>>1]|e[r+2>>1]<<16;n=e[q>>1]|e[q+2>>1]<<16;b[r>>1]=n;b[r+2>>1]=n>>>16;b[q>>1]=o;b[q+2>>1]=o>>>16;o=r+-4|0;q=q+-4|0;n=b[q>>1]|0;if((e[o>>1]|0)>=(n&65535))break;p=c[a+60>>2]|0;r=o}o=c[a+72>>2]|0}n=e[u+((v&65535)<<6)+56>>1]|0;q=o+(n<<2)|0;p=b[q+-4>>1]|0;b:do if((e[q>>1]|0)<(p&65535)){s=c[a+60>>2]|0;t=s+((e[o+(n<<2)+2>>1]|0)<<6)+56|0;n=p;r=q;p=q+-4|0;while(1){o=e[r+-2>>1]|0;if(!(n&1)){s=s+(o<<6)+50|0;b[s>>1]=(b[s>>1]|0)+1<<16>>16}else{s=s+(o<<6)+56|0;b[s>>1]=(b[s>>1]|0)+1<<16>>16}b[t>>1]=(b[t>>1]|0)+-1<<16>>16;o=e[r>>1]|e[r+2>>1]<<16;n=e[p>>1]|e[p+2>>1]<<16;b[r>>1]=n;b[r+2>>1]=n>>>16;b[p>>1]=o;b[p+2>>1]=o>>>16;o=r+-4|0;p=p+-4|0;n=b[p>>1]|0;if((e[o>>1]|0)>=(n&65535))break b;s=c[a+60>>2]|0;r=o}}while(0);Uc(a,2,b[u+((v&65535)<<6)+52>>1]|0);Vc(a,2,b[u+((v&65535)<<6)+58>>1]|0,m);o=c[a+60>>2]|0;n=c[a+108>>2]|0;if(!n){j=o+((v&65535)<<6)|0;i=w;return j|0}c[o+((v&65535)<<6)+60>>2]=Xb[c[(c[n>>2]|0)+8>>2]&3](n,d,f,h,j,k,l,m,0)|0;j=o+((v&65535)<<6)|0;i=w;return j|0}function pc(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;g=c[a+108>>2]|0;if(g|0)Zb[c[(c[g>>2]|0)+12>>2]&127](g,c[d+60>>2]|0,f);q=c[d+12>>2]|0;p=c[a+60>>2]|0;o=c[a+92>>2]|0;if(!(vb[c[(c[o>>2]|0)+56>>2]&127](o)|0)){o=c[a+92>>2]|0;Zb[c[(c[o>>2]|0)+16>>2]&127](o,p+((q&65535)<<6)|0,f)}m=e[a+56>>1]|0;g=c[a+60>>2]|0;b[g+54>>1]=(e[g+54>>1]|0)+65534;b[g+56>>1]=(e[g+56>>1]|0)+65534;b[g+58>>1]=(e[g+58>>1]|0)+65534;g=b[a+6>>1]|0;o=0;do{l=a+68+(o<<2)|0;n=c[l>>2]|0;f=e[p+((q&65535)<<6)+54+(o<<1)>>1]|0;b[n+(f<<2)>>1]=g;d=b[n+(f<<2)+6>>1]|0;if(!(d<<16>>16))f=n;else{k=(c[a+60>>2]|0)+((e[n+(f<<2)+2>>1]|0)<<6)+54+(o<<1)|0;i=n+(f<<2)|0;while(1){j=i;i=i+4|0;h=b[i>>1]|0;if((g&65535)<(h&65535))break;f=c[a+60>>2]|0;g=d&65535;if(!(h&1)){h=f+(g<<6)+48+(o<<1)|0;b[h>>1]=(b[h>>1]|0)+-1<<16>>16}else{h=f+(g<<6)+54+(o<<1)|0;b[h>>1]=(b[h>>1]|0)+-1<<16>>16}b[k>>1]=(b[k>>1]|0)+1<<16>>16;g=e[j>>1]|e[j+2>>1]<<16;d=e[i>>1]|e[i+2>>1]<<16;b[j>>1]=d;b[j+2>>1]=d>>>16;b[i>>1]=g;b[i+2>>1]=g>>>16;d=b[j+10>>1]|0;if(!(d<<16>>16))break;else g=g&65535}g=b[a+6>>1]|0;f=c[l>>2]|0}d=e[p+((q&65535)<<6)+48+(o<<1)>>1]|0;b[n+(d<<2)>>1]=g;i=f+(d<<2)|0;h=b[i+6>>1]|0;if(h<<16>>16){k=(c[a+60>>2]|0)+((e[f+(d<<2)+2>>1]|0)<<6)+48+(o<<1)|0;g=b[i>>1]|0;while(1){j=i;i=i+4|0;f=b[i>>1]|0;if((g&65535)<(f&65535))break;d=c[a+60>>2]|0;g=h&65535;if(!(f&1)){l=d+(g<<6)+48+(o<<1)|0;b[l>>1]=(b[l>>1]|0)+-1<<16>>16}else{l=d+(g<<6)+54+(o<<1)|0;b[l>>1]=(b[l>>1]|0)+-1<<16>>16}b[k>>1]=(b[k>>1]|0)+1<<16>>16;g=e[j>>1]|e[j+2>>1]<<16;h=e[i>>1]|e[i+2>>1]<<16;b[j>>1]=h;b[j+2>>1]=h>>>16;b[i>>1]=g;b[i+2>>1]=g>>>16;h=b[j+10>>1]|0;if(!(h<<16>>16))break;else g=g&65535}g=b[a+6>>1]|0}b[n+((m<<1)+-1<<2)+2>>1]=0;b[n+((m<<1)+-1<<2)>>1]=g;o=o+1|0}while((o|0)!=3);b[(c[a+60>>2]|0)+((q&65535)<<6)+48>>1]=b[a+64>>1]|0;b[a+64>>1]=q;b[a+56>>1]=(b[a+56>>1]|0)+-1<<16>>16;return}function qc(a,d,f,h,j){a=a|0;d=d|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;I=i;i=i+16|0;c[d+16>>2]=c[f>>2];c[d+16+4>>2]=c[f+4>>2];c[d+16+8>>2]=c[f+8>>2];c[d+16+12>>2]=c[f+12>>2];c[d+32>>2]=c[h>>2];c[d+32+4>>2]=c[h+4>>2];c[d+32+8>>2]=c[h+8>>2];c[d+32+12>>2]=c[h+12>>2];D=c[a+60>>2]|0;E=c[d+12>>2]&65535;Tc(a,I+6|0,+g[f>>2],+g[f+4>>2],+g[f+8>>2],0);Tc(a,I,+g[h>>2],+g[h+4>>2],+g[h+8>>2],1);H=0;do{t=b[D+(E<<6)+48+(H<<1)>>1]|0;w=b[D+(E<<6)+54+(H<<1)>>1]|0;q=b[I+6+(H<<1)>>1]|0;l=a+68+(H<<2)|0;s=c[l>>2]|0;m=(q&65535)-(e[s+((t&65535)<<2)>>1]|0)|0;r=b[I+(H<<1)>>1]|0;y=(r&65535)-(e[s+((w&65535)<<2)>>1]|0)|0;b[s+((t&65535)<<2)>>1]=q;b[s+((w&65535)<<2)>>1]=r;if((m|0)<0)Uc(a,H,t);a:do if((y|0)>0?(z=c[l>>2]|0,A=c[a+60>>2]|0,B=e[z+((w&65535)<<2)+2>>1]|0,C=b[z+((w&65535)<<2)+6>>1]|0,C<<16>>16):0){n=1<<H&3;o=A+(B<<6)+54+(H<<1)|0;k=C;r=z+((w&65535)<<2)|0;do{s=r;r=r+4|0;p=b[r>>1]|0;if((e[s>>1]|0)<(p&65535))break a;q=c[a+60>>2]|0;k=k&65535;if(!(p&1)){if(((((e[A+(B<<6)+54+(n<<1)>>1]|0)>=(e[q+(k<<6)+48+(n<<1)>>1]|0)?(e[q+(k<<6)+54+(n<<1)>>1]|0)>=(e[A+(B<<6)+48+(n<<1)>>1]|0):0)?(e[A+(B<<6)+54+((1<<n&3)<<1)>>1]|0)>=(e[q+(k<<6)+48+((1<<n&3)<<1)>>1]|0):0)?(e[q+(k<<6)+54+((1<<n&3)<<1)>>1]|0)>=(e[A+(B<<6)+48+((1<<n&3)<<1)>>1]|0):0)?(G=c[a+92>>2]|0,F=q+((e[s+2>>1]|0)<<6)|0,Eb[c[(c[G>>2]|0)+8>>2]&63](G,F,q+(k<<6)|0)|0,G=c[a+96>>2]|0,G|0):0)Eb[c[(c[G>>2]|0)+8>>2]&63](G,F,q+(k<<6)|0)|0;q=q+(k<<6)+48+(H<<1)|0;b[q>>1]=(b[q>>1]|0)+-1<<16>>16}else{q=q+(k<<6)+54+(H<<1)|0;b[q>>1]=(b[q>>1]|0)+-1<<16>>16}b[o>>1]=(b[o>>1]|0)+1<<16>>16;k=e[s>>1]|e[s+2>>1]<<16;q=e[r>>1]|e[r+2>>1]<<16;b[s>>1]=q;b[s+2>>1]=q>>>16;b[r>>1]=k;b[r+2>>1]=k>>>16;k=b[s+10>>1]|0}while(k<<16>>16!=0)}while(0);b:do if((m|0)>0?(u=c[l>>2]|0,v=b[u+((t&65535)<<2)+6>>1]|0,v<<16>>16):0){p=(c[a+60>>2]|0)+((e[u+((t&65535)<<2)+2>>1]|0)<<6)+48+(H<<1)|0;q=1<<H&3;l=v;n=u+((t&65535)<<2)|0;do{o=n;n=n+4|0;k=b[n>>1]|0;if((e[o>>1]|0)<(k&65535))break b;m=c[a+60>>2]|0;l=l&65535;if(!(k&1)){t=m+(l<<6)+48+(H<<1)|0;b[t>>1]=(b[t>>1]|0)+-1<<16>>16}else{k=e[o+2>>1]|0;if(((((e[m+(k<<6)+54+(q<<1)>>1]|0)>=(e[m+(l<<6)+48+(q<<1)>>1]|0)?(e[m+(l<<6)+54+(q<<1)>>1]|0)>=(e[m+(k<<6)+48+(q<<1)>>1]|0):0)?(e[m+(k<<6)+54+((1<<q&3)<<1)>>1]|0)>=(e[m+(l<<6)+48+((1<<q&3)<<1)>>1]|0):0)?(e[m+(l<<6)+54+((1<<q&3)<<1)>>1]|0)>=(e[m+(k<<6)+48+((1<<q&3)<<1)>>1]|0):0)?(x=c[a+92>>2]|0,zb[c[(c[x>>2]|0)+12>>2]&31](x,m+(k<<6)|0,m+(l<<6)|0,j)|0,x=c[a+96>>2]|0,x|0):0)zb[c[(c[x>>2]|0)+12>>2]&31](x,m+(k<<6)|0,m+(l<<6)|0,j)|0;t=m+(l<<6)+54+(H<<1)|0;b[t>>1]=(b[t>>1]|0)+-1<<16>>16}b[p>>1]=(b[p>>1]|0)+1<<16>>16;l=e[o>>1]|e[o+2>>1]<<16;t=e[n>>1]|e[n+2>>1]<<16;b[o>>1]=t;b[o+2>>1]=t>>>16;b[n>>1]=l;b[n+2>>1]=l>>>16;l=b[o+10>>1]|0}while(l<<16>>16!=0)}while(0);if((y|0)<0)Vc(a,H,w,j);H=H+1|0}while((H|0)!=3);k=c[a+108>>2]|0;if(!k){i=I;return}pb[c[(c[k>>2]|0)+16>>2]&31](k,c[d+60>>2]|0,f,h,j);i=I;return}function rc(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[d>>2]=c[b+16>>2];c[d+4>>2]=c[b+16+4>>2];c[d+8>>2]=c[b+16+8>>2];c[d+12>>2]=c[b+16+12>>2];c[e>>2]=c[b+32>>2];c[e+4>>2]=c[b+32+4>>2];c[e+8>>2]=c[b+32+8>>2];c[e+12>>2]=c[b+32+12>>2];return}function sc(a,d,f,g,h,i){a=a|0;d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0;j=c[a+108>>2]|0;if(j|0){Fb[c[(c[j>>2]|0)+24>>2]&7](j,d,f,g,h,i);return}j=b[a+56>>1]|0;if((j&65535)<<1>>>0<=1)return;d=1;h=1;do{i=c[a+68>>2]|0;if(b[i+(d<<2)>>1]&1){Ob[c[(c[g>>2]|0)+8>>2]&31](g,(c[a+60>>2]|0)+((e[i+(d<<2)+2>>1]|0)<<6)|0)|0;j=b[a+56>>1]|0}h=h+1<<16>>16;d=h&65535}while(d>>>0<((j&65535)<<1|1)>>>0);return}function tc(a,d,f,h){a=a|0;d=d|0;f=f|0;h=h|0;var i=0,j=0,k=0,l=0,m=0;i=c[a+108>>2]|0;if(i|0){bc[c[(c[i>>2]|0)+28>>2]&127](i,d,f,h);return}i=b[a+56>>1]|0;if((i&65535)<<1>>>0<=1)return;k=1;m=1;do{j=c[a+68>>2]|0;if(b[j+(k<<2)>>1]&1){l=c[a+60>>2]|0;k=e[j+(k<<2)+2>>1]|0;if(!(+g[d>>2]>+g[l+(k<<6)+32>>2])?!(+g[f>>2]<+g[l+(k<<6)+16>>2]):0)j=1;else j=0;if(!(!(+g[d+8>>2]>+g[l+