/**
 * Copyright 2023 Hasnae Rehioui
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from 'react';
import { IntlProvider } from 'react-intl-next';

import { ReactRenderer } from '@atlaskit/renderer';
import { Provider } from '@atlaskit/smart-card';

import { Content } from '../../apis';

import { dataProviders } from './data-providers';
import { extensionHandlers } from './extension-handlers';
import { MediaViewerProvider } from './media-viewer-provider';
import { SimpleCardClient } from './simple-card-client';

type ContentRendererProps = {
    content: Content;
};

export const ContentRenderer = ({ content }: ContentRendererProps) => {
    const attachments = content.attachments ?? [];
    return (
        <Provider client={new SimpleCardClient()}>
            <IntlProvider locale="en">
                <MediaViewerProvider attachments={attachments}>
                    <ReactRenderer
                        document={content.body}
                        allowCopyToClipboard={true}
                        dataProviders={dataProviders()}
                        extensionHandlers={extensionHandlers(content)}
                    />
                </MediaViewerProvider>
            </IntlProvider>
        </Provider>
    );
};
