/**
 * Copyright 2023 Hasnae Rehioui
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import axios from 'axios';

import { confluenceApi } from '../../apis';
import { environment } from '../conf';

const confluenceClient = () => {
    const siteName = environment.CONFLUENCE_SITE_NAME;
    const username = environment.CONFLUENCE_USERNAME;
    const apiToken = environment.CONFLUENCE_API_TOKEN;
    return confluenceApi(
        axios.create({
            baseURL: `https://${siteName}`,
            auth: {
                username,
                password: apiToken
            }
        })
    );
};

const confluence = confluenceClient();
export { confluence };
