<img src="https://raw.githubusercontent.com/veselink1/refl-cpp/master/branding/logo.svg?sanitize=true" alt="refl-cpp Logo" style="max-width: 100%;" height="140">

[![Contributors](https://img.shields.io/github/contributors/veselink1/refl-cpp.svg)](https://github.com/veselink1/refl-cpp/graphs/contributors)
[![Activity](https://img.shields.io/github/commit-activity/m/veselink1/refl-cpp.svg)](https://github.com/veselink1/refl-cpp/pulse)
[![CircleCI](https://circleci.com/gh/veselink1/refl-cpp.svg?style=shield)](https://circleci.com/gh/veselink1/refl-cpp)
[![Gitter](https://badges.gitter.im/refl-cpp/community.svg)](https://gitter.im/refl-cpp/community?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)
[![AUR version](https://img.shields.io/aur/version/refl-cpp?logo=arch-linux)](https://aur.archlinux.org/packages/refl-cpp)
[![Donate via PayPal](https://shields.io/badge/Donate-gold?logo=paypal&style=flat)](https://www.paypal.com/donate/?hosted_button_id=TTR5538T85QJE)


[Documentation](https://veselink1.github.io/refl-cpp/md__r_e_a_d_m_e.html)

refl-cpp is a header-only library which provides compile-time reflection and introspection capabilities to C++. By encoding type metadata in the type system, refl-cpp allows you to process types and their fields and functions via constexpr and template metaprogramming. 

**Using refl-cpp in your project?** I want to hear about it: contact me by email (see my profile), open an issue or add the [#refl-cpp](https://github.com/topics/refl-cpp) tag to your topics!

**Have a question?** Try asking in the [Gitter channel](https://gitter.im/refl-cpp/community?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge).

**Want to support refl-cpp?** Consider making a [donation](https://www.paypal.com/donate/?hosted_button_id=TTR5538T85QJE).

# Table of Contents
- [Introduction](#introduction)
    - [Examples](#examples)
    - [Motivation](#motivation)
    - [Performance](#performance)
- [Integration](#integration)
    - [Requirements](#requirements)
    - [CMake](#cmake)
    - [Packages](#packages)
- [Documentation](#documentation)
- [Testing](#testing)
- [Contributors](#contributors)
- [License](#license)

---
# Introduction

refl-cpp aims to provide a generic reflection system that is flexible enough to suit your needs while maintaining a relatively small API surface. 

Some nice things refl-cpp supports out-of-the-box:
- **custom attributes** - constexpr `std::tuple`s associated with types and member descriptors
- **proxy types** - build generic `proxy<T>` types with the same members as `T` that can be used to wrap or extend functionality
- **overloaded functions** - you only declare your overloaded function once - refl-cpp knows how to work with it
- **template types** - use reflection with your containers and other templates; template types are perfectly-well supported
- **template functions** - refl-cpp also works with template functions, when the template parameters can be inferred from the function parameters

## Examples

- **Implement a simple serialization system** - [example-serialization.cpp](https://github.com/veselink1/refl-cpp/blob/master/examples/example-serialization.cpp) - [View in Compiler Explorer](https://godbolt.org/#z:OYLghAFBqd5QCxAYwPYBMCmBRdBLAF1QCcAaPECAMzwBtMA7AQwFtMQByARg9KtQYEAysib0QXACx8BBAKoBnTAAUAHpwAMvAFYTStJg1DIApACYAQuYukl9ZATwDKjdAGFUtAK4sGe1wAyeAyYAHI%2BAEaYxHoADqgKhE4MHt6%2BcQlJAkEh4SxRMVy2mPaOAkIETMQEqT5%2BRXaYDskVVQQ5YZHRegqV1bXpDX3twZ353VwAlLaoXsTI7BwA9ABUKyYaAIIA1Cu7awBK2JsAIgCy2GvrW7vbAJIM2wQIeArbAG7RAJ7biSyx9G2mFUrABmG2AHdwVgaCFtkxtsgvL1UCx4QQCMQ8BEvARMBsdntRLR6OhftE8GI8AAvJgRQGGMmzYjbVAQx5KLFU2llR7EWaOOEQl7IBAE25YPEON7PcGxYiYJQMBasqhPF5vJgYrE4vHwhhkxrNT60H6cym0GmK8V7WXbNjjYhvVBqu3y1DvPBYMnvMReTAAOhtSwJ5gAzMFkN4sNsTGG3E5egrWHHsKGzBHldHwXG3Mgk8FgKn05mo14Y7mC0Zi1tw5Hs7H4wok5gU2G07WM/Xyzn458HCQa5s61me423IYvkOR2WK/HRM3ogRp13R3O3F4GCQsAr0AB9FhMWIr0sN3PIQ/PE/d9cIDGxBQgJZLYhMCEB4CEBBeHGctCCRgCADNAWCWT47GCABrLgX0wKhaAAWmQWJYiWQ9emiJYb0wWD4IDBAUOnLZn22GFRn1IF/gIH5D0g6J0UxbFcXBIhtiibZkUwJlHhoEp0E1A1tioTdmgEZ0GFNAkky8BxyS5S1aXpcEQG2BV4JAEAtUxDTkSYYB2BAXjaHQUhVLg2gNK0mIQF0/SNOE5VeVDAB2Kxa2ck44zc4ctjxf4DD1XNqNiRhWHBAAVId3lQL05ItK0IF6dANISTFWxYcwADZWQUUzIrMTKso%2BP1MEmFzvO2SrthIwhoi1cEPXou0HQKZ01Uim4qv4Yg91bUUIDUiyQEGpoCAgX1vFKgMWuiXLYwAVisAqTHmk4ICYXFUHtTBHTKzrKpMVzxSqk6aoUPdk3QOlAVFJpILePBXQQcEZpZV54W2LcGCQsSCCEvA%2BOOk7KpIkgPo0BCqmARFfoQgBHLwqV4skHNEx5D2IOiyQhL9tndELqh%2BKymLxIHgcemGGAw1R5W2CBXgu1srqUiBXsmWNloKsz1JALAFGQLFYiIayECYc7id1fEmwpblrql7BWZ2gpJj2nZgYOo79vVqqSP0gg93wBQASYL492YNg8bU2b1XBKgsVcU0zbC1Ubct1ACeo1lPhZO1Ud5T6wrJ7WcvHXNtj1g3XmN03zcwRXdtD%2BMObMONPLMFOwwq4OdaWbbHXGkr2YVAg5ipj6rYVZUWK232AeM1kWWJWgZWet2PaJ5AFmbQcteDhJE7cPOCgLyb2dzMPzAzpap6DqrDs8rX57KzOXIXnzNmk2TlBiwRyrJ%2BDUC1bZVC8/faEPv6pxX2stYPo/D2ABhCB7CB2f/XoycOrP1eL0vfgIZKIAFBw2qBAVQtxwHWG2D8PYXxl7f1jB5Vep8b6bGirFLAOJgB7niMEMaSUUothTFzBIpl35/W3ngoqQtVZfzJv3ceSdJ4QEngPPGQFIHxgnunUyrDGGDyFgGH4/Dk5lXTig4cSDUEkTtDiOgBAELBFIpgLBuYABiqYGI6mYoiQwTwmB0Q%2Bn7ZIrIIjaFGk8LaUQCQkU4ijMG8o8GFldpgrw0MBSxFxEJMGdpgo4SMugJY%2BMlxTmIrnCIYtrTxnCgoAMcTNHvQRH5Y2eoJr%2Bi0STcEwo8Cil0Y8didjLE2NzkbJoj0fiyMiU8L4IU2ofSjGLWJBIjhqICHucKABNZQCtKGCFMq44AEABk4J3gQaYbFIkKEYdgVWJ0WltLUXcbAAQ1qqFMuaWWLMVbVVzs9BUkJwScTipswEAhTTwk1PaAx0QybzL3Is5Za0vjrJlgpOWr9ZlVTuWouQoQ3Csz0k/EuWBVZ3OwKENeBI8FXOCK/PeWsCEoAFGwyeG4URog2W83kKlJ4SJOpihKiK0C4lMr05crlthFEpYgk48DQwIoARpYlf0RG4vmm4BgFgvDyMUY8AZdMFBeBQiQAgmpiAREIK%2BYgPx/yVFGE6SYOLxHXzVpVRF/Zha5jJZooWUyKVfw0KQLg89eGuSKBoeeNKJFkxIvynGJJLbQrtPyhU8pFSAS1CYl0rs0nV1dkQjKKrTq526tU2pkJcZRE/AwV%2B%2BoySuFfqZQaSEUIRodRtIgl4cliEklrGqAFXx6kaj7VufQ9bFUmnGx1ggfUlU1G8KEJIgw3wAJyDQ0sQTcjg2AaQGYlRlSKSXsIUHS1B%2BKB3MrYYih21qPIcGmBZDg81eB%2BA4FoUgqBOBuGsFAhQzIVThh4KQAgmh53TEgiATKZgAwtucpleaGguBhg0PNSQAAOZ90hF2SBXaejdnBeCPkNSetd87SBwFgDARASL/h0GiOQSgIFYhwZiMALgGgzB8HkbNSgEQ/0SuYNKzgR6QJsEEAAeQkl8P9WBDxGHEKB0g%2BAFTGkVH%2B4ETRmJ/rwSUP9loIhSq%2BB4LAxHeCMRYKJ6Y8E9IKAAGoAwhORkKq6j38EECIMQ7ApAyEEIoFQ6hGO6CKAYIwKAd2WH0NiR8kBpju15I%2BDgCEkqp1MJYawXBnLbAQuRswgGSijWSC4A0Ax6ikECKMPIBQMiJF5CF6LWQGAdEixMYopQWjDDiw0fzaNWjVCS10QotgMueDqD0YY%2BXHQSGmHuuYCw9BpUWDwBdnBl2kFXeuzdHBVBvsyghTKkhw6d0pRoAMZg6bbrcxZ7YuBCBg0PaZDwsH6AskPZMMTp6VakAvWGLgAZ5pvoKvNFtLbH1hnmmGD9mHv28Akw%2Btrf7OuAZAMBjb4GoMQCQB4klFAIBIZQ/4fAws9BqeEMSdgb6dPyCUGoP9EJXyxEk/oFrv7GOdfI7iTxf1vXdd6/1wbyBhujfG6iZDy2OY7bW8ejb0xnpMB3JQZrHAf2kFu4a9rvBHu2Ge1T0Dm3tvOQDBhsMkgW09ZbZIeaXBMrHaRxwMMKOOsAZ51oTbi7fP3dR0rkDKvpje0SM4SQQA%3D%3D)
    Implements an efficient generic serialization procedure from scratch

- **Simple SQL database abstraction** - [example-dao.cpp](https://github.com/veselink1/refl-cpp/blob/master/examples/example-dao.cpp) - [View in Compiler Explorer](https://godbolt.org/#z:OYLghAFBqd5QCxAYwPYBMCmBRdBLAF1QCcAaPECAMzwBtMA7AQwFtMQByARg9KtQYEAysib0QXACx8BBAKoBnTAAUAHpwAMvAFYTStJg1DIApACYAQuYukl9ZATwDKjdAGFUtAK4sGe1wAyeAyYAHI%2BAEaYxHoADqgKhE4MHt6%2BcQlJAkEh4SxRMVy2mPaOAkIETMQEqT5%2BRXaYDskVVQQ5YZHRegqV1bXpDX3twZ353VwAlLaoXsTI7BwA9ABUKyYaAIIA1Cu7awBK2JsAIgCy2GvrW7vbACoIeArbmKqssfTbCgioAO7PP1%2B2yYBAIxDwES8BEwz1EDG2UW2XiU6G2RARXjoqPiv2iVC8tA2Oz2TAivWITGaAgUADptgAJaKYba4pGOWh4ABezIIv1QSKUxAAtFgaCFUSCwRCoTC0agibdgIxoiDmUIAIoBbYARy80Twst%2Bj2QCG2wUFBBe9DYgmewXRTG26BBpKYShpCr2DzVmp1evBsqqzKVIQp0IltFowMtaBYsTomCFjjYAuCwG2aAYvQA%2BuS07TPUsieYAMzBZDeLDbEwltzIXr4QQ17DFsxlhgVrxVmtuBTkzCsZut9ud7u1pz9wclltbYflyvMnsIUGxBQgJZLCm/GnAQgILyQwWZ6GCGmxpYANxhJWCAGsuJvMFRaELkLFYksWG7ocQlvOu5gj7PjSCDvkOs5bKseybPCkrgpC0LbPwxBfLETR4FQACeabAtsJwWGipL0GAHDPLExCoGh1QGs8KxFls5JeA49xEcyIDbMQT60CAIBwTxyJMEqPEEJhaHFgA7FYNzbDJma9BmCBVHszBsDWUmbAqMkZtS0KqORLERPQEByTGinEMprCYJM2wMKgrwLLEBCaVpWnsSpmAQO5kzOdWkk%2BSY4knBJQUlupRKMD4GYGH2eEuncomYBJ6kuQAkicpA%2BXc2AABp3Bls6BWpxaQWs2wwdGUoIcyyGoehWE4Y6%2BHaWkDAkWRFFUY4sp0USjHMQM8LsZxz48XxIACUJIA0CU6BJT5JkKUpNmWUV0myTpsWVPFaFOi62YiWJoXFTsWkma8%2BkDcZG0mkt7mkJtTDbcyzpbQl1m2fZmCOT5LluZZnmWdMu2VPtCUQC9j1vf5km%2BUFBUhWFJV7Io0QsnQUaClewLPAQCCLmYZgsBgJTmGYSEkGiePVgTKPEDjrGk7s9GbH1lq03Na1fAQ6D8faJZmPtZqzUdnMNjxeZGC8X50KtGmFSLGlI3hT6jJTzLDaUyTbGwlQQ%2BTKG48yRNYFGPVbEcABiATZpsch3AA8hAPkHR5tP3XcDN%2BTTgoKKTAUnNMPnTbQ6AQHg6D3QNAVWATaWk/dJxxQlPFx4Fgec8HoeYNLtCR54dTR6T2A5/HD1PTxWW5f73lbN5CtEtCcYGIhPYu%2B52xnNnBTgZsZ16ShTBQvyX63pgubarQ2aZ7maHIBAnfjMQNdy8lWnIjh7kKLElLq1xsvzTp50D0PzXViWJxOjCyDgo5JA8UqBDZnB0rQj2UfTvPXfRIXaf75zGHaSzLpfSEBE6vTQinC%2BNYQoXzQLQGkENQZoWsoXTmLkNyAKvNUNWgD5I3XMsDR0bBF5ylwhrHiJlcxSiMD2UIPcXLoKWNsTyTQYQKCqJhUhiJWKkPQPyWM8Z6BJjwCmCW6ZMyiAIMvBhWlOIEDmPCS21szibAANLYGzG4e2oQhB3GzLog4KVQgAHErrwK8tTAijN7TbGUIYlRBwACa2x1GOL9grFy/sfIlCUGaKguDgEoVAUnCBIBK53DPjA5qCC9ouxQX5NBsjMDyOIIo7AVtswqPUZo7Ruj9F3EMSYsxNILHWGpmTcJ7jV4yS8fDY6UFPTbDcJxVUzxHRuCOJsLK9xNgWACNgbYGotS6miJhD0Nw9gHGSQonGVMRnEE4W6MhXEKE6SoeCGhtY6HTnGcSZmjcPiqjPm4Null7g9z7vpQe6IR5jwUBPbM18BzQn2qxCAy9UEnRkuvSWm9t4LA4nvDxa9EiSzuKiaBaIErZiwAoa%2BeBb7EB7HcIc9dOYYIAGr6iwpTEEOCXbbEUrM5kHtDLMmflVXZLleggjwMgJ%2BfZogEHBlfG%2BRAYggCJU/UE8EZTIoZh/cFP8A510Rl87YGCPAdlVMwRCYgoyG21l/OmJFmp1EvmKLIWY5QPzxkizmlzj7okzs8SFlJkA%2BAJKqCA4KeLEIKAofK4rPEAFYrAupOBAa5/JzX3W9Uqxe8TqkyKSSk2CyBkCWPKRlF1bgGAmFjU5AmUbbnj0ntPLeTQID2uiKKn6Wl/b3VTZQsR7zpEhppAc5uzIFAHnJD2MwzZ3lqQlUwziRMsaKuCEkMQ0aE1xr9hBcVhrgQnwIIZSJl84VsrviAB%2B3LKp8trKS%2BgTahV%2BV/sCmSGDMxYMtIqha%2BC9h6xzQbH1gKRooDWWI2h9CtIYJYQsPsHCuHkrJbw/hqA4wJmEaI6h4iBCSPLetIBR9R3onHZPdukKlGZLURorROi9EGKMaYyDJTAZ/3FRguRCicGcVrbQRwksBE/uTDW/9PlcOpPKR0443S7i9P6eUqNkHszQcsCxp2sb43JrKSaqNfseN5oJvvQqQ6bHSwYM2gqwaMH3KjE8bYqB/EEpLZRrZzYWR6uZKEM0xLtj0CMLjZTqm8Y%2BR3V%2BwRiZyNcw2cAKlp1D793A/yBTk7U0KceS0l5lQyU9nZh/PNotuarKhMcnsXwJ4RdrOU/tvHG1bq5jzK94WeyRdJnkAopnFoUgcNENcLH0uxcSNyFTEAFPWSFNsLgMW3BxZ41U4KHBpjcQ4C63gfgOBaFIKgTgbhrBlIULMeY%2BMSw8FIAQTQLXpi3hAAANjMDSAAnOJebLqNBcBLBoF1kgAAc23pBtckJ16bvXOC8DXBoSb03phwFgDARAV7v30DIBQK6L3ujAC4BoMwfA6A/jXBACIZ2IjBA4ZwCbsYbQEHtgwWgmEztYC/EYcQ3XeD4E4s0K8a50ekFeE0GUZ37QlDOxyCIFIFkeCwJD3gUoWC0%2BmM%2BQSCgMUGl%2BPbNCXWJv8EECIMQ7ApAyEECjNQZ3dBFAMEYFAg3LD6AhGuSA0xKJlCzJwIUDZoGmEsNYLg4lthCntmYS7JQmiq5cAwdw%2BdBj48tx0LLExSDxESKrgaGQXfJHt10QoxRNblGGG7hopuqQMFaNUL3i8egB%2Bt/UWwwwI8FAkNMYbcwFh6DBJgRYPBWucA66QLrPW%2BscFUHt%2BbQp5uSG2MACNNWNA0jJhAAbOu5fbFwIQCmpYihNKswmFCnfJh09u7NkA42aQur22Ydby3lubZLC6ksB2/vHd4Azjb%2BeztF8uyAa7U30d3cexAJAswCCxChOQSgpHXv%2BHwOyvQvPhCiHEHt4X8glBi7x78CksRGf6Fz6dvHRe9sUIp%2BloKm2wJeZeFeVeNeP29ezCHgn2febYUwg%2Be%2B0weMTAWAMQ7yv%2BHAJ2pAq%2B12BevAm%2Btg2%2BN2aBpAc2JY4kNIv2JYkgy2pey2kgLqXA820%2BuBJY/%2BheF2FBWgkwOeHAxu6%2BABfBu%2BAh0wWCiQzgkgQAA%3D%3D%3D)
    Implements a basic ORM system which can generate SQL statements at compile-time from model classes using custom properties

- **Iterate base classes with `bases<>`** - [example-inheritance.cpp](https://github.com/veselink1/refl-cpp/blob/master/examples/example-inheritance.cpp) - [View in Compiler Explorer](https://godbolt.org/#z:OYLghAFBqd5QCxAYwPYBMCmBRdBLAF1QCcAaPECAMzwBtMA7AQwFtMQByARg9KtQYEAysib0QXACx8BBAKoBnTAAUAHpwAMvAFYTStJg1DIApACYAQuYukl9ZATwDKjdAGFUtAK4sGIABz%2BpK4AMngMmAByPgBGmMQgAJykAA6oCoRODB7evgFBaRmOAmER0SxxCcl2mA5ZQgRMxAQ5Pn6Btpj2xQwNTQSlUbHxSbaNza15HQrjA%2BFDFSOJAJS2qF7EyOwcAPQAVHsmGgCCANR75wcAStjHACIAstgHhyfnpwAqCHgKp5iqrBS9FOCgQqAA7qIlL8CAhMKcIuDTuE4cRCIYtgBaYhdJgETDoU5UTB4jaYX7hAjEDBeLaE8KnABuGgAdFwuCzWUczhcABLxeHg%2BEIJiM%2BFMEF4FhA%2BEZIz0TEo%2BLohhbU5wvDEJrIBAAT1OEBiXgIpxYXlojhlyIYqJVap%2BpzEClQIK8KTSzQJyxZ3PeX3hMSYSlOBF1KXhxwYUrEpFOWBoEUJEqoXlVPWtyIIvzYjXQeIlWGQBi1PRZn2%2B2cwufzyJhcIY1tt%2BPQvouMX1sPhWDRYsJRaD0NOqCoIbhp0j0dop37CgUZf9p0DwZnv2HjunBlntZB4eQeBoBNO4MICHXS/JJgAzG4r9hHQQqXgjfifW89jtueZL%2BEi14sKcrzcJwZhxVhb0/Mxv1Vbx/0AhAHxSBQQB2HYtXBFlgBPLwjSUTZZEYAgWTQFgdjFOxwgAay4VDMCoWhMWQd0dhYIN8WIHYfxgzAaLolkEHdcCTm5FdxyjFjaE/AB2KwThSbDaDwZAQF9U5VMZTUCC8MQQQIdAQBAEDwmAU5gCrAB9BRdzwckIGWacBBmADLzuU4NCvGTjhMSS7ncz8ThuAAxEIzOOOQPgAeQgFTVNDcMIAncTVmiolU2QaBzMs2prIUWMUmpcNml1Wzlm5EqhJOESAHVPBHEBTjkmIFOQUTJykjyGqa5S3lUnS9IMx8jBMjKrJsuy0AYRzUDFYg0SwZKvI8nqltOHFNOIBtzDMNxDAdbw5IUTbfO61SvJ8oTvKOzz/OwIKQrCyLYswCBqtoKhY3PA7rwSsRb2WMqruOES7lQYy6o6xTTheqg2u5cGlOSmY%2BsMwbTIICyRoUWz7Imk0pviWbMHm6TkqW1aNg2swtp2349q8X4qFYOg8CaH5DsvRaetOqSfPZvzjkC4LQoiiBHogYHgHeoML2vKHfv%2B7l8WlAx8SctxHuYNhPkE45GVQPBCTyykzI%2B2yYeO7GZn%2BPLHWNF1HqclycTo/Sne6QCPlvU3efNxH9LQY1VcAkMw0wFkNfhQCg82xtlSzIlqRYADKcu5L9wt/FVGtkWQ5ZQtiwJY2pbnDIAC9MH%2BpaFpJnr%2BGIMySR1CBXdqNHHsxx7c9qfP0EL6FVgAgBWKwB7uCAmFtkMK%2BWk7ifN6fVN9lB1hNSPrxDMPWAj68o8ppOzEu%2BeAO8krvbOefF/9lft7XsAOBMAe3AYW%2BD85i7za6JQiY56eL%2BXwO182gwVAsIjL30fmzb%2BR8zqeTfgDSkpomDhFNudSBhtBC92lm4b6ElLzYC9qgtE6CPqAVlrg/ByU0Fo2IdecWnsT4eWSuLOMVcLqnyWr/AOq83B73tuLZSD8GAQOSrXeuTBG6uxdrRN2NCQZ0JZGwRYxAcqDysGYAAbPfUe48iCmkwIouyVc549Q4VfG8ADd573/tw1GZl8CWQMLqMy4cIAKMqAY6%2B3Do5RV3lw3RiiN6a18ZtdxLkhFGNUhIkAxBUyODYPpLARpgAQBMbGVx8QIDoD%2Bi/H%2Buk/Z/yCcnARYSz4zzuPQ7mHBVi0E4APXgfgOBaFIKgTgN5LDWBBOsTYEdII8FIAQTQlTVgURAGoswLJEiSTUQPDQXBLwaAHpIfwczpDVI4JIOpAymmcF4EhDQfSBmrDgLAGAiAl7SjoPEcglBiIpAuQkYAXANBmD4HQNiSFDSbJiOEJoupOC9OImwQQ4UGC0F%2BQ03gWAWLym2I0/AOI6hkU2f8WoxoYW8EpF0TZCkYhamILqDwWA/m8EfCwIlqw6JMGAAoAAatZcE4Vwz1N6fwQQIgxDsCkDIQQigVDqHBaQXQXB9CGGMNYaw%2BgnxIUgKsVAKQehIQ4JiRGV47imDaZYLgklTiYnCmYHZXQW5ZBcAwdwng2h6FCPMcolQ9CFEyAISYfghV2p6IMa1IwhU1DqAIPoEwzV5E9Qa71vRZhuuGAkT1sxHV6BmP0MNiiJCrGdBsLYegqSYG2DwKpNSNn8uaRwVQ/g1GYjUZIEyyBmqPJZGYA0rTVE2FOLgQgJAk6XiFacDw5z6DEFbVwZYxKDlDJAG2lkA9/DqIHokRIMzLwD0vEs55qz1mkFJdM0g9TGn5p2SAPZ/TwWHJORAJAy85IECuRAG5dyLX4CIBGrlwhRDiCCCy%2BQSg1CbPBFqFIZL9A5vXZs/N4VjSnqHCOQtxbS3lsrayGtEBO23O7b2/t%2Bz92rDhEwbslBs1rN4KuvZG7eBbtsDulDWg/qkGGZeSSnJIKSESEWxIkgB5cDUVO39HBLy5s3ds0jgz2N6v/Xmnje6yOrGmhkZwkggA)
    Uses the built-in `bases<>` attribute to iterate over a type's base classes

- **Access reflection information at runtime** - [example-custom-rtti.cpp](https://github.com/veselink1/refl-cpp/blob/master/examples/example-custom-rtti.cpp) - [View in Compiler Explorer](https://godbolt.org/#z:OYLghAFBqd5QCxAYwPYBMCmBRdBLAF1QCcAaPECAMzwBtMA7AQwFtMQByARg9KtQYEAysib0QXACx8BBAKoBnTAAUAHpwAMvAFYTStJg1DIApACYAQuYukl9ZATwDKjdAGFUtAK4sGIABz%2BpK4AMngMmAByPgBGmMQSGqQADqgKhE4MHt6%2BAUGp6Y4CYRHRLHEJXEl2mA6ZQgRMxATZPn6Btpj2RQwNTQQlUbHxibaNza25HQrjA%2BFD5SNVAJS2qF7EyOwcAPQAVHsmGgCCANR75wcAStjHACIAstgHhyfnpwAqCHgKp5iqrGS9FOCgQqAA7qIlL8weDTkxTsQvII8GxEZgqN1MiCAJ4zTAsU6iBinOKnVFAgmMAiYdCnARHM4XIjJelUdGYgC0yGSrIgCHimHpDFoONOBAFp2YaNQ7IlQoIOOSQp%2BpMw4WAIKIxFppFJXgI4u%2Bv2Jar%2BqhpDCw6GWADpGecHRcAOpCppCmYkDVGoVIlFo8L8YgsJg9ckkj5KzAASQY/Ftnyjsf48NoClQpwQTF%2BCKoTAcJDFbAlGCJYno6CdpwA4pgCCYAMxuD6N7B68HfZAIIk60OYHMk8IzQxbNmJ5XJjMxMVedJGU7FpjoUO54ioQk6rk85L2t57HaM8wN8LIbxYU6NtxQpTNVuHszHhinrzny8IAgEZIKEA7HbEJjgrawCEAgXgxLO8RoII1K2mgLA7AAbv2XThAA1lwf4YrQ3K8jsIb4sQOwnmemCYZitoILyd4nIyv49pgfbwkSBgKL8RCZp4dJ%2Bo4aKKsq4ZBiGPSMqe2a/JGE5xqgh4AOxWCcyRgbQeDICAh5vKcml0UOjRPv2ZYkmSqAxI08x0gIopGmuXjAN2oi0Gm4oZrWBAQMsDqaeKBJAoxl58YwrBCi2DbYB5mnDo4yBEgIMzjjGUnmAAbDWdZuWFF5yelnmnHRAo6qc4JCsgvY0j6IIavQRCDgww56acQZGqqyT9CpXgGMQ4pRllnkRSp0U1YaEnxSmjgQJutAgCA421PWTbBdgbnuQ28lnNlnk6gQGwko4jYrdlJgyXc6mrZpUGxTM6CTTMxAaklpyRIFbn9TM6UHXta2aRtW1SoFAD6u2vYdx3JDdCF9mpNEaVpOwFYKwqWZ6N3zvKP1og1WAsDFBD/mGinEAU/akOldHgYaEqqqaZL/Ja1pORxtDmfKHUg6gyrNHg%2BnZrDDnpRdV3Y960qYP9y3HdldHAUhJIIv5v1YAoxV4Mk2rtkVWNIg4TFDZOxMw%2BCIGprQZWLsujSw2W%2BVMDE6yGhAyAbDqgiWRZYpC%2B5UNeSwPmlX5UZC58er%2BULtoh6cABiHMMwo1EnXFk5jVhk2y/LivKyQl7zeKNrdZpICo8LEAEOgtpu4D72aQdR2Q8clcA9XdGFQVdBG2Ss7euTvwxNmKrQcQeajuxCjKsgeBUGKEqhkx/nktHJx0dNDhW8Ck/caiQpt/O6wdfbnqEgoeI0oSVuoEhIksb8VxYTNS%2BYLJK2KTEymqelCF4M0XhiM9g1JglZjJS52spJPTOoaRsdxTgaDrjXIGot64wywDQCITEoJSw5nVEMxUMzsSYAaVAFJ6BsEEClAggD%2BBpRog%2BBB8xTgPAAJohGjBYX6Nww4hGwM2Y4Fg2FPRMAAVjcC/N%2Bm1P4gLjr/f%2BdZSGoGAVjekSFiA3VfPwsuF5lEe2yl9YgEYf78Emi5S8k1xpJ3/IQQxBIT7CwAI4f2UjQeIChfqzTcFgU8/kIB7A7ktUKIU0rLVUQIj2tdq6iVYqcY4BYOp50vpia%2Bj9b40UygpJSKkIax20gwbQM1iFSPJF7Wg6U6EMKYSwthHCuELXdjXD2r936fwAH7hO1E9BgqB/hbGVmXQGVdoFHVgVU44dFioMVKuNHCrITYrkZCU36xw5AfAAPKFyjBARpJBliVNojDcIeVCAcm6DfTqyoz5iVOMoACJI84PyfmEiJd9GRXJSbrOR8RFFCgATojM%2BsJSnCwKDWkuSgQFPoYw5h2BWHsI%2BJw7hGzqlCJsacOpZzwQMGaa01Q7T6yBMSbHIJPSoFTLBSEGZczFluKRQwdZx0Qm/AjsQGYyh7ECA8IINcDl4inEuckqK5K7lJMfo8j2dEmDACYOEPUFiFF4HPO8ySKYvndhZmzAF%2BSPaFJBSUiFUKKli08uEQ0AoxDfLAacKokC%2BmCNqUbOptL6WMqyLIVl9BiCoraZgDpWLy4ZW6bXc1JxpmzIWRAdKbibUEAZXSplDrPBOtWOlOxDN%2BQMVoBKSpMLjh6oXKKlFGzsXZVDeG9M9qWXRvZVQZIpg%2BnZR5X/U4zVkUXgbOAstFaLA5RhpudlEprK2Vre6Ih/l0qiKkXdOtDAcnGtHbaGVw1pFLVbRLOsRJZxEEJNPQM0lq7ixhvmLYoSUb%2By7esHtW8xEpmMpkhw6UxLxFcqOqRtoHpsB4Y2415gzD5rtcy7GJbiBvrnbJO4HBVgTQ4Lw3gfgOBaFIKgTgAjLDWBBFvUcR4eCkAIJoIDqxUIgESmYW0ABOGSiVeEaC4A2DQvDJD%2BHI9IEDkhwMYeg5wXg34kjocg0B0gcBYAwEQCgdcyQ6DxHIJQOCgmnUgGAFUMwfA6A0jpZQGIjGYjhCaDiTgqG4KEIIPMkU6mOOkAxoYYA4gDP4B1HUJC34DP/FqAabYUG9VdEY8pGI/5iA4g8FgDTvABYsB86sTEwqFAADUObgnmcqCDqH%2BCCBEGIdgUgZCCEUCodQBndBcH0MZlA1hrD6DwDEb8kBVisx6NZzkF0wGmHg5YLgMlTicnmWYFjXQZqZBcFaSYfgsuhHmGUCoegCgZEjTkHrKQ0gjYYIMAbSxOhYgEH0CYng2h6BqHURbswZvDEqGMfo3W1tbf6ztiQqx0wbC2HobGmBtg8GA5wMDpAINQZgxwVQ/hEqckSpIU4wBkBRSqLaMwpwIBwasJYPUuBCAkAvA%2BLLpwPBeyEx1FDyxfMYfWaQbDDYuC2l4f4P%2BvD8P4dIw2XhDZqMybo7wfzJGnuMdeyxkAbGMdcd4/yEANtFIEBE3bATyO9C0mh7t2Lwh7LsCCKL1LahGPgn/MkAL%2BgHsMYM69%2BZBpudjne5977v3/smo0EDkHiPxPstR%2BjjjmODW/MoPdjg9HSC06SM93gjPbDM7QxjrDIAGwyVtBoB8kh8Mffw5IXhXBErE6VxwBsKuXvMc95bu3LX6eq4T%2BxrQmP5HpGcJIIAA%3D%3D)
    Implements a basic runtime abstraction over refl-cpp which provides access to the reflection metadata at runtime via custom metadata objects

- **XML-based GUI with strongly-types properties** - [example-binding.cpp](https://github.com/veselink1/refl-cpp/blob/master/examples/example-binding.cpp) - [View in Compiler Explorer](https://godbolt.org/#z:OYLghAFBqd5QCxAYwPYBMCmBRdBLAF1QCcAaPECAMzwBtMA7AQwFtMQByARg9KtQYEAysib0QXACx8BBAKoBnTAAUAHpwAMvAFYTStJg1DIApACYAQuYukl9ZATwDKjdAGFUtAK4sGIAMwA7KSuADJ4DJgAcj4ARpjEIGZm/qQADqgKhE4MHt6%2BAcEZWY4C4ZExLPGJyal2mA45QgRMxAR5Pn5Btpj2pQzNrQTl0XEJSSm2LW0dBd0K08MRo1XjtQCUtqhexMjsHAD0AFRHJhoAggDUR9cnAErY5wAiALLYJ6cX15cAKgh4CkumFUrDS9EudG8C2ITAImEBhiBIJYYMwly8CiYwDRCj2zGITku/GIZyuN2ImCotAAtMg0mkQJdlAliSwIsAiUwFpcCABPNKYakJLmYdCXLBKAliPAAL1hOUu1GIqBYlwAGi9QutSd8AO6EBA8hBotkMPAsHyXYpZWLg1jbQSXVBUS7ELyCc1o1AANwSxqY6AAdDqbldkBiiKq3R62K7KX0FQpeQtMKqARCUfQ2IJRZdjRTFUo0XI8Ngs4wCC9MC10LCmOtg18bgBJAgQwEEY0MdFKMVEUiXWGu92ONgD5AU2FoiILQx7QHOo1oilUhpwvv8%2BGDhjoEMQs2OaUytGdzB4YhW5UCtp4Lf6zuXb1iLxbydiqjK1Ua0KNskHUnmP4ETIN4WCXCY/huAgBAEGkCggAcBwwrqgbAAaXixBiCRoDmgiBmgLAHL6dgRAA1lwSHxrS9IHCwXJwsQBzAaBmCUVSgYIPSEHYABKTMV4YEQW4TjQpgrDcbxQEMCBAlokJFLYqoEkXIB/GCZBhi8sp5yqdJLHgZBVDuo0AhiNppIYuylwlmWqYVsoV4JI4W4QU8lwLOgIAgO6JBYBS6AAPp0WkQkeV50LsgOYUgBFRgSf4VgXJZRjWaW5aCG4k5EBernuQQnkgJpEBHOsEA4dyNnpQQDmoNezkKOYABs2oJQBFyMJaIFcoCJY1XVvI/JuAGBIlVyXONTyUkwXi0G2uUaLEGikDq42XHcmAAI5eOeubzbEXDLV8q0eLhc3%2BG5C1cEtK3jetW07e4sgVgZbl3dt/ngYEbiXCdcKCIdOmBE8EGjaScKZlOBluHyArMLGyitJK2nQl4DipX1Tm8pcjIrrQXmwgQiTeZi2JeTQvS7ipI03Zc5VtgjxCSlaiMJCDNN0%2BjjltANm48kNrUqUd4108CaQXr1XN8mVAjcgzSNmI1zOMwk2pC6t42MmkLPEBAWvK8Qqtjer40DjDmAQBLtWY4NApeZNVDTbNhvqyY1Nq67wOC0btMy3Cqhi5zVvcxbeAY9zNsnpu46%2B0y2tNUrkrO8bGsJwkuva0nyem5uEBm5nn2jS7QPDcDAs6RclV2YIYf1anAVi0H9UQNFsUctChuu4Xq2zo4yA%2Bww3LRbEXJ4MgAUKcCQnIAgrTcZetXrYpEB3OYZjIRAJgAKxuAoRwb9vurWC1wPJPvVjbw129CFvTwlav6zIffbNq5X2bVZLt6Ag3cHP%2BX3st3RAg09LiAOnvCX%2B6tdT/HBM3fKXkJ6qACkoVo09YFkBAbCMBCgBzf0XsCdY6wC403VtNIgTV47fyiKwOS50MFAONJfCwXAb4QOToOLwZCFYUKvAANWfDQtyoCGFbwsGYFhZc2HzzgoGGcTkN4jSkVQtggZoQQE2FIvh3hMAqMJmoz6TwWpd2TtCF6dCsEqK8FQGgqg1E6J1oYmmHs2rewpAQHY3Zv4NTLk4r2XUFA9TSlXSs1YAx1mGqNNIGFaCjxAM49W4MwSQyEmbOGaIfjaXVj3UeqVbJvyrDWOstMsqYCCiE2sLQ1GOLdt7dWIt/YXlIagPmApTG43gfGNcQl0n%2BGwJUiRbDX4VnyaEloIDdz9OTiwIMqSAqmLNoGVJ%2BEkG6IcWrdWUz8JZRILM3KTVBmCGGeUpgXkJxiThAFEcm5xluG6TxCZxtXHuLGaw8aPi/6ZLgYVBgWNTlTgCjOFo0lzYc32e/Run9uG1QUIQumVSjEPOrE8352UAq6yvNCl5%2Bi4nd0%2Ba3AK3pby6kuKkvRsL3bVMkY84g3YZmYreaSMWeAnxwliV7D5BVW7EuoQFTFoLMpnJIEUgVxAeXeLVgkgwcIoYpOob8DJOL5R92ippIVfzLkCnQNLAebZQU1whQrKRGLyXwvVj8fcs4gWdycfc9WxIApiVQW0kAuNOmQVubYtgqxGYDhEeQzeTwICNJAamaohCrVrLYXgF0dSA4QCdRKCceA0jZS8jPBQAUCYEkwnCISlt%2BrcQgJ60NYaKWSLYY08hBrv6tPjF5BNBJk0kC8tiAgGaYJZo4ZgXNodJZaR6YWkNKtMVltWlGxUQbv6tgSKYzxgYaA7gHV6hZ1C7FqMMVIqdF4wBgFyrO1wa6iERpHeswdOsAVzkwGG2h39Ax60lGi2qm7qTcSUDhdAqyanHrecerFR79EfuIatY4nxP2rRuHah1hpaCoFqoOWIPo0TwiUB6MQtAsYtsBARNIdBcxEBATNRwqIFwulPESTw0H9QpV1koASqBaQYEvay0D40bhjsDRwppk6GIzvRXOiImrV5Vi9TpZI66uPTu3bu3j%2B6CGHuY98dW56gWBiE9UK4Unaq3u1g%2BtIT6X0NAEO%2B4d6sbjfskUcf8bK2FUu7EpvYdLi5e2taDC4fiAm5IrIvAEhMtJUwiVEmJ2LxpZL7qCrz0ItIGpbZU41gHgstF7jkqq4WfPmsBfZm1q0bNpYvQ5z27zVqgsOYU%2BdmqW6E3ZPiwlQIqpKMvf3BYcK4vsLw4QaduVoqlf%2BVQAdBSWiBniGhBgaiBxsD60wQMMmfWbysFw/17HOGNXjqoEtJrrOIupZcVQy62B6NcrlXoQS6vGdeUDD9ki2NtZyudXKY2RkTZk6t5r8SEDKiJdFaMo4SkJGVDrVeoLiWoDbPwd0u5RMnd/cx7LRwrt5aCzyVMiSpXJM3KkuVPSabelQHgMUClvMJACmbGL3tw3Mbu0c29GIEABWHsgUiIcPMHLKXWE5xTSnja6QWghcOvaMuZeweH0VfQOBIN2xnwSOc9ODZLlz3swuYDQhFvb1Ni5isBqXWXbnY6M3ZNgYgv3sZWgC0qz5n3PT2v16LvzNNkpt1NyOc3P2m3Ood2wC3v3f7OecZJLA860QvAAJoBTcAAeSiG4c4PxUXnAHBYQhIn/CAVBikX3yxLiB%2BD2HiPPwIAx8uHH9PQfQ/h8j9H2PHcU%2BUjT3IZsAVsChGwG8KIUeHgAHFmxCB%2BNgO4EAI51cISF/cbYM/F%2BzxAAKwBoPD1oAFdAPgWC8gCgOAKme5DN%2B7yvq9bkGfJYV954gvJm3VlsXjlMIqzZdM3Md/t6iNAd3agwTqBh/GXBDwSCs8oBDhJpgACRILKWQMQAGdWHhJyUeIAkuT3C4N/W8QQT/DxFmAKf/D/foWBDlCrIwKrTAd7QmDuUtcaNjExfbWhVeBAf/GUQA2ge%2BOTSlDbbsGAlAnILyP/AkCguAqg%2B5MzcaXoJQCEF0NBF6XZZIX0G8UQKg0TGg9bNxTbBguA/oLyUA0QsyTgxzb2HguSfA42TsN7bXLIIwPXX7DeZINwQwBgIHVOcCZISwiwPKdAgkIwNBMNSwSwswQcQEWQhLHIJ%2BFQ/LelC4LHHHcUTATCYAJA9/OQnINAryTIQmMSFgeOTIAcDw%2BAx8fhPA%2BFTIKGISRUJ8LRQQ2hZI%2BQkAFggA9ggyAAMRcJKLYJaHENcMZFXkUN7jMnB28VUNJAeHKNCACnODkB%2BBD1zhzkKJyAHCwBCM7iCJCLCNgM8IEH/Xv3OBRjRkGDpwRkiCoOtzVmGLmOQIiK/3uXK3sI5Bwj%2BgICgP/k8JNzsKsjvRKROIrCiJigwNCIJWwP7lOPzlJ1oOkO7HuLwiOT6XhXpVV1l06O6N6P6I3nFRzhWNIjWN6E2BpnJloE1V2NmIYAHDzUxiMMaluOmMYIEAIWANWmRM1T%2BIIExJ7Ubl5BDhrh5lthADegel%2BgrB9QVlhPhLxhADxPJO5wuAWJrzrwbybxb2wHb0727wgA5MMARPOI5mnlaBuFeN1EJ0R0lQETWlXiEggnKILUcUgmlPWKdHCPRP22SDINYMoK1Klx/16GgwHAAHUSAUTt0oYDhDTehtIWo3AdSJJkhziIg2w6IIhicvicUCph4sgx4EEp4Z4SQpdVAWBaA8EbEV5kh14hJ943BD5LBSpfVN47keJ/U75%2B18yd4t43Br5izvT/wL5Tht5mE6zuIH4mAcyzAAM1ZDirJlSIBlTVSIY4Rztwz2lEk9hezCUBs99ht1FlTJsF11EwAOAKyGBFyBxFzLhFyOyLiOUhEzFhF7koEcNCxTcFdgQkExJdgEBxzsDRtMEGEBxEzkzTyVsns/02MhF4QVFZRzYr1vpJBXz5NVptDUAcCCozc3cnc/tkgDDBUIh1RNRU5iBJNWi1tTtfC/0K0uEDUWhgA6tTEPzGFGyNdmtMKlsDVM08Bs0XJaECKRExF/UIdSL45yT8K7zwEZtE8GK1dJFoo0AOEsjIIXCXg2L4IXCIdiRCxvzCcIRTFmEEoZLsiCKvzjxASIRrAj5JCR0mKDVdzbsRKRE8BxFULjZeLtgzofTBLV4jDXDtTBLdLIJsin5/TMs0LmtTL%2BLbLvpFzlzvLuKBlAk349UtxPEZ1EDv4wD4RA121KLO0FBV1ucXLDVfVkhyStT/VTFUq/Lk4itmdRlydClcp5dFcfMj8CBbFStc4sQ6t4qhzjFPkVVDs358LcqJtkUSk7NzZPEtyLt%2BCPTaAbgFA0hTFlVvkApRBGsDSWhViZSODekmpGqKxZMwyR13LzLHLkhUBYhtA1xBw5orDPL3IhqDrV5TFrTjL1YnVwL2AQAxivBgBHi%2BKKTrhBrarjY/DmNVqBKvKlzt4VylzErlTWL6FPyFBLFrFbFVFXr3r2UTkzKvrbCvJXAODQYgYOBNg8YOBN5eA/AOAtBSBUBOAfTLBrB3Jthdg5IUgeBSACBNA0bNhSIQBN4AAOQMRqTeK6DQDQJmwIDQfwZIXm/QTgSQbG2m/GzgXgeCJaGm3GtG0gOAWAGARAFAFUbDegMgCgaWFEHDRIYAK6MwPgOgBieCCAWIUW2ICIVoQ/bgXgAiN%2BEPBgNDUWrAOiIwcQGW0gfACkRoYiUW4EBoTtUWwM3oUW6JWIGEA/DwLATgKmirFgaO2WqkLEBQHhQlEPWGeOmQQQEQMQdgKQTO%2BQJQNQUW3QA6AwIwFAdSywfQSi%2BCSATYWqfoeCDgakDyVyUwYmywLgQIS4akEPMwCWw7EyPwCAVwWYPwA6MIZYSoaoPQYobIAQMe2ezIeehgEYae8YA6eoIewYGYTwToPQLe/oHepYCoMYRITexYRei%2BoYNes%2BiQTYBQMmvYPQWI/YHgdGzgLG0gHGvGgmjgVQJmxqakRqSQS4YAZAPuK6QMVwiAIm2bGwS4XAQgQVQCA6H6FW7Wyw/wLgdYXgaWrQIkhm7BwMZmhWTeAATnIY0C4H8E3n8CZr5sFo4GFtIDjs3iWh/t4D/olpACltps2HlqVrMsiQpI1qw21r0FFGQfPvzuzvECZvzsUBUHUHdt1BhAZGto/sxpFvdr/pDw4REadBdAAaAZAbAYgcuCgZgY8C1rVqwZwbwf4c2H9D8koC0ZYbYY4dFu4dsF4epqcdIAZskC4EDH8EkCZsofIa4DMHIcakCECEoaYf8B0d/vFv8ZlqJIxv7u/u8bSfwbptIBEKyGcEkCAA%3D%3D)
    Implements a system for reading XML resources with refl-cpp, by building a custom runtime reflection layer on top of refl-cpp

- **Implement a generic builder class factory** - [example-builders.cpp](https://github.com/veselink1/refl-cpp/blob/master/examples/example-builders.cpp) - [View in Compiler Explorer](https://godbolt.org/#z:OYLghAFBqd5QCxAYwPYBMCmBRdBLAF1QCcAaPECAMzwBtMA7AQwFtMQByARg9KtQYEAysib0QXACx8BBAKoBnTAAUAHpwAMvAFYTStJg1DIApACYAQuYukl9ZATwDKjdAGFUtAK4sGe1wAyeAyYAHI%2BAEaYxHoADqgKhE4MHt6%2BcQlJAkEh4SxRMVy2mPaOAkIETMQEqT5%2BRXaYDskVVQQ5YZHRegqV1bXpDX3twZ353VwAlLaoXsTI7BwA9ABUKyYaAIIA1Cu7awBK2JsAIgCy2GvrW7vbACoIeArbmKqssfTbCgioAO7PP1%2B2yI2y8Sm2xEwVFoAFpkLFYttYsRUKo8JhniCIl46OhttjcdEYb0AJ6fKhMBwkdEKDY7Pb8YgQqGlJgRT4EEmxDEAOnuP3BVUwwK5GOBCCYBG2EoAbsKlAQCNFtmwCD90M9foQENtmGxnokWHQqsDUHTbmqEsLUFRxcLOdz8ZhgsB8TjaARSNtDHimG7cRBJirMJa8b9HsgdZCCHMGJiEMLIQovB6XdsZWIvJgeea9g9hULQUo8SC0HGCMQvA5tqgItomlKtWqVYYSUiUdzqjSvQpUGwa7bw3hIyq8MAEFKGKgpVFmQBHHGQ9A5m7XenbUIkFhiWgkr2W8EE2hYJkOsWy%2B2oJ0thheHdt37EQhKhgw2aet2N7Xt1Hd8WS7ZRAYXNryYLwiG3JVl1zJY6XMABmYJkG8LBthMeC3AnAhYgUEAliWYgmF%2BHlgG1LxsSUeZZEYAgeTQFgljlOxggAay4AiWThBElm3XpoiWJCUMwDjoR5BAEXQ7A4LMRCGGQrxUPQtxRAUSiCEkuCtnw5loS4xFkV/MVgiVBZYilURaFoTErzuMAOGeNhxmIWktKWb0GDxXpJWHe9tiwJViCNEI7WDJy/IxZAnzMkh3PQOltLPAcQrBIkDJlPAsDxCUPPoYgV02eK3M2BgXjeFgPmtW0/WARhomHIsiSwGgQjxI8T2JTlyUpIhiBJOklXKgwlTQjCzz1YU7g0rZkKYVT/WPZUQCRcjaHqyFoRAEBK0EPA2E2gzVD6jC2uiJTJvg7AvXO7A0IAdisLZYhW4cQE0nZtg%2BgaPklYUlLG1hsx5PlNmIYBaQu80Pvmk8IBBsHzAANkRoG%2BSqMHJkhqGoaWjNvEwAB9CBenQTbGV%2BKo4owuHwewCA0YUSYUYxm4oZMe7Mbuk43qx7SAElBGiUyCGeCyrNNe47IczAnM1bUOe0v0WHAtlPhWNUnli70vhdT40Z8GiOa%2BobftG0Vxu2M5pYKfczYB7YADVM0wKb3o%2BrzHGQaHTrMBHtmCGVUBYgndo%2BCATuIRGvhKKgvUdvHEcj3Gs2Z127oe1OebctxIR%2Bv3y0MBYkvdnzLJJGF/OiILMDxRyCg5zPwoUSK8Gi08rxS6USk7WXm1OAIYVoVBA68WJ66hss%2BNUZELat5Va9O%2BD06xhvWg93y5SfKg2zVAC1XtNGQ1Cgo/c1J9KnZZ2WeXr5Kg9/HZrUiAnnxx9CBVzAIHn4hJgxxex4%2B7SQhD573TE7JKIC%2Bg1SlDQEocUr7Ly/kTaOPIk4EyDOhE4N8SYgDJhTJSccsySQgKg3%2BS9r7bG0gcEMsYdLREYIXLE7oTz/2ZDGYgJU7BUHQmQj6bMuZbA5ncaGgYOZsx4cvaMNDiabRYKgOUxCnb41IaI26/CCqPSfBmJUr14FCNQfjbhFC3IWEpCxNMtZ6wODgqo7hb1eiVmrIoU6Aj2bwInlKQeRg/aU3EdIkA9i0zSyYHQWx8C/EBK8TQZyBB8bjVCancJFY0wGF6LEgG8SOZOOIBATxroMop3IdsJaGUxElJsfArGXogkhPZuUjOUMvRRNSXE2pajClehSTElpVg6lYzESotRfCMlbCOAAMQCPjTYcg7gAHk6QQENqKCAWTpgcxgceJ%2B6BVnwPWegCA1TaDbNTrs6geBolpLYEcrGJzOkXMwCnFOhUZ6VHQJKP0TAMzGgvt6cyfZYh0EwDCRw/Z9mEWLD8iEXgdqXKeTCSS2wABe0RUBwgSFKYyKIFDcmaAIPO2w3DWGsFwW6aFRkaBMAATlGZSyQJhNgAFY6TF2QPfVS0QCAQHWrQTaXKGxKSyUQxmX8FA8kSEikaXN4KYMkMogRWxjItmCCIlx4jtJZPLlCUYrUmFElJF1KkT4xSMncm2XlDh34im5GAMApLyVUppXSxlbiBC9G2FkhqTIMFewjhhAVF0IBcA0AU8h2keQZQgJIMw6CMIwm2KM4JYsAL0X%2BfQIFu1hRPwUC/M%2BFqMFeopFZe5LCeQHIWWYMw2h0CoEwAAAVeO8egdE%2BzmCjcWppXSAZlrMAAKVQAgYC5bg3Xx5Lc8aXaTjVpbUO5ePI2oiL/nK1OD92UQBSnlA5EqvUtsrdWutZUKpNpYFOjJqiODTG5RwelvA/AcC0KQVAnACWWGsF8WY8xfoyR4KQAgmgz3TBYiAelAAOHkCN6WBo0BoIDt0NDwXLbB/QnBJDXt/fezgvBcIaG/b%2B6YcBYAwEQCgP5AKyAUAgMmkjIBgCBrMHwOgAVcJh1QxEYIVQSScC/fRNgggZkMF3KhrA24jDiFvbwfAkJmhMVQ68Jo4FFh3uMiUVDq0IiEV6h4LAHHeBJJYFp6Y0ImBg3tuiX4MzuQ3q/fwQQIgxDsCkDIQQTi1Cod0EUAwRgUCEssPoPAERcKQGmKgMyyRcIcA6pTE4phn2WGJdsGEMyzAYZKA2ZILgPIDHqKQQIow8gFAyIkMoKRPB1Hy1kBgHRcsTGKKUFowwMs9GSzihgrRqgVa6IUWwdXiuDE620NrTkJDTF7HMBYegKyYEWDwc9nAr2kBvXeh9HBVBAYRjCBGkhtjAGQJ7QNPIzDbAgE%2Bqw3nti4EIDFBCRR8XEdymhT9kxtM4f/SAeCXAeTAZ9vSilFKNBcHgvS%2BCQG4OIY4Mh0gun6VYfm7wRbGGQBYZ/aJ3DBGIBIHfE9T0ZGKO5X8PgHqegrPCAsuwIDDn5BKGc6J0gj4mCxD0yD2b0O0McBmeBDHSVlurfW5t7b2xdv7cOzd5Ul2HvYaR9MBMTATyUGm6D3gEOoeodh7YeHYutA/1IAByQb34KSCA99ilXAzAUoRrdW632QfwRQ1T5XiP1ey8S3NpX6G1d/tIBvRIzhJBAA%3D%3D%3D)
    Defines a generic `builder<T>` class, which implements the builder pattern for any type `T`.

- **Convert fields to accessor methods** - [example-proxy.cpp](https://github.com/veselink1/refl-cpp/blob/master/examples/example-proxy.cpp) - [View in Compiler Explorer](https://godbolt.org/#z:OYLghAFBqd5QCxAYwPYBMCmBRdBLAF1QCcAaPECAMzwBtMA7AQwFtMQByARg9KtQYEAysib0QXACx8BBAKoBnTAAUAHpwAMvAFYTStJg1DIApACYAQuYukl9ZATwDKjdAGFUtAK4sGIABz%2BpK4AMngMmAByPgBGmMQSAOykAA6oCoRODB7evgFBaRmOAmER0SxxCVzJdpgOWUIETMQEOT5%2BgbaY9sUMjc0EpVGx8Um2TS1teZ0KE4PhwxWj1QCUtqhexMjsHAD0AFT7JhoAggDU%2BxeHAErYJwAiALLYh0enF2fKxKiqeJgKZ2amEBZ2ImDEtAAnmc0gB3eJULy0M5UcEETbA1BUUGYKi0AC0yBSKQAdMdzpcACoITDQiGoWFnAg0s5eJTEJmoM7IMFMAjAgiQlL/M6whB4ZAIM54FiEPkCmnkj7hfnEKhMbZnLGAhioZnxJlC4FiujAsQKLn02HhYBMxXvS4q%2BLbFK9LXY/XciEAoh2/7AthLYgKMkOs4nBjoP1nOKzGEDaUEO18wG0ZHa5kpvAA9ACM0EJWXNAsFKm/GONiiwhSgBe8S5xC8ghlmIAbvEaUx0KGKYWzgAJeLG4FKM0w76qaGC4VetOYKOtsReTAAfRSE%2BhJslfZlcv5PpZTrVGsx2KY49QrbwWCj0%2BBlNIMa8BbD5stz9QLD5Eoh0JlKXoNhBAPYE0AYONKXMAA2M5A0qSJWEwCAVm5ARZj7QwF1Qa9YMwIMELYCAwIg6CUI1bYFAtYMURIaMaG6dAAQzFkJmATACB7C5dnJcwAGZwmQbwsDOExeLcJxZl5FhROwHizH4hhBK8YTRLcURKPiAteNk04%2BIEoTgVUhACAIFIFBAXZdmIJhYRJYBqy8GI2WdWRGA44tdnbOxwgAay4KzcQJIkUl2L9ZniXZ9OUzAArxEkEGJGSeNOSyzgAeQiL0GG5Xl%2BRBdcfmhGJoQURzBKYSibRRb4WBxPEQBARtmzYBqCsnVT7niPB23QR9KWaNitJ0k5UupYEaGDJN%2BRLAw8pSZpENVaUQLOUqYnKyqjENYVH09JQwKjbNo1Y9jtswHtpoA%2BURLEu9mErSDtPJSSvAcM5F28Vc2uhEA6toBqmordgQG%2B1SPuXNcN1Ux7sD6pLdMSKx3jOFHUrBerGqbIHWo3VNaAZFbnI5X0CqvYT9TwDkGQYJUUbOVLZhIJg2Nw5kMBo4mWXQPkmE4unKSZAb2NEpGTlp1Hdk%2Bb4ydAtCCEbBwSABfgOXBr6Nz5lHiP5VR13epd1cKoi5bOSCzBgk6CBWcW6ZR37LYgS3reRlGTERm23fuZLzjp7XMF11WDcho2zag6DBeIQbnZ9227YjwaIFmdAGpYS8kKd6Pbbd0Ws8SL3dJdpk8KuvLVLuxCSUr8NI4UeGY9Q8Cdb1tXg8nCAThr6DoMrklARrzPY7jh2k4alXYWadBVI74Ba%2B0iABoUFYe4H133cLz3vdthmmkcZBpQYVtUB81d/1oVTHjwyoZIgIRuioLvzcfafa/N7vK5Qo7PQEKEcQARy8Sm84bapTYGzKMKsLyTk5KKEgPle4AEkkyDQBKIOcUYxSMEwO2Dk544IGm1C3UGhdUpHVQfQbspsWRglKrQJMzFQIQmWqKBA8psFMLBOiYgERwE1X3ofY%2BK5T6ayLjNa6ZcjT3WBBfIMu0JGITOLfWgVBZHCkkT3auM86621mN%2BPefsA5nCwIJO888PwfwPkfE%2BM0b53wfjBOwyiNEvzDubdRC8V4iTXvXLeks3C5TNNlcIOjFKnjONIyo0DSrEhIEmZ8dBCDQkRIpXoIYba230XrcJBo8HEGzhvXiOdB700ll8FU%2B8VZfjdEwGIGwkxbilDkphcQqpkPnMI7RBBk4oFqTdNwqkRJmDMG4CEVVzBmF6f0waK4sBOWACuSREAckoVUv0sZVZmQDLMCLNJdNUqlMEHjPuwBly%2BAIACUm155zQMzEmUBCAMDtLpujf6mNmrAxmV4OZEJE6dIamgZ8j4F7L22YXDpXT/lJhWWJM4YAOAmAAKxuAYLCkFYtQV0zwNiDJHIIDZhXPRWg6BFmX3iCsZZXiimxx0bvFcFV2QEETngOsWIe7t37hM3i9wzhcEfGM%2BBB8xA4QYCMKmZ5I4%2BDcuc6WlzwG0QKsKFokIwBgDGdbApOzB6pQymacVQFbngnAsmKa4oARHXPEoEy8R8SzEhPQVm9zuwatjpihu4UDGMuZVQVlz9lmctElyrg5LCmUs1b4mkyAfLSg9CyNWTDYTEDlDEegjyQ2rR3hKWlGkWi4oUCueNib6DEqDGS1FqbQ3hkqsAbKno1a90UMCS5zZBTQKCfLV6xqUz6jBEw7%2BdJVo2jtQNCVggU0hpyYnO%2BJJLaPhHiAMeE8p6dznu44F6r0WDw3uu2OqUABa9YjnDrObhQwAJzyDXtQ8p1ttuhKE8cGstEszhuHDZGl1NaDbsPBNzJN50r1FOpRmulmkc0rl5N%2BwtSy1X3ofala47FNjZXPNrOqQ4QnXJjQbUdlKOEIb%2Bg1OJLyvwCO1kWyoE6lFTqFlbKDf7V7528XTTdDGUY3sMhSstqV4HRoDCSjkR1dRJnPPKzSkIZ2n2hFgegwBrqejIbR4pLaj0kDwPZZgyJT54Tct%2BAQWGnnwa4bhIM5GvXTrTV0%2BdxBJ5iWftfFd79S1FKY7nej%2BTRbkkkQoeampU6SZ4uxlGL03r1tyevfzsdkP4y2teBzg9Z2SSqnhJgdAYueK9musWedva3AAGIhBXCcOQlI0qOyNIsjA3QGrBbWCiP4hLcXoGqwSoliW6AloLiNSWwWqxpjOLqRkLD2zRiPOqTU2dAQfmlESoF9mCnjd9C12g88a6rosKl8ko0WT%2ByaG9O8TExXHL1aeyM0YcMGbvO6aMOSATWh63EQx85XpAJSpLKgvD32fVbkqjgpqLECNPhex1pw2RVS6/6/WH3QZiR8xVkAwWkrpfJGUr84RkJ%2BfvV1omeTEbco0GtzLCPC5AezUTEk15kI3TSwGjQNHiGSxJ2Trg1OFPqjoNd6sIIAN7yJ26ED%2Bamg/tI6S6ONtucQBJwt5CJJi6CmQjT%2Bu4vkeLbGdoVACAGAAAF/asAAudYsqqUui4V0lxbvrKebJV2rzXqhtfJr14MuXNtnkAyxi2BqHzgA/PBbU3l5sSdOxS7OiFHK3BmYaq4M%2BBP66c8zfSz3DU8UKEQiuVsqkjG0NK0bugsvHzIbi/LG0XdtJy46bomPwHZ0J6TynsSaeTGZ6V4M1V1XD7RaL6iz2HA1j/Q4PC3gfgOBaFIKgTgfTLDWFWhsLYhl5I8FIAQTQne1g%2BRAPC/wJIoLwsZxoDQ/hEgaF4oM/f%2BhOCSD7wvofnBeDmQ0HPhfaw4CwBgIgbpJZTRkAoMbV/9AEjAEZ2YPgdAqo5kEAMQ5%2BMQ4QzQkInAs%2BxYeqGUUI5%2BWAX4Rg4gA%2BvA%2BAYI9QXk5%2B/sdQz4Owg%2BTo3eg%2BtAeAMQ1kxAkIHgWA0BvA%2BeLAtBaweIzMCgAAan8LCGlKorQTIIICIGIOwFILwfIEoGoOfroDygYEYCgNYNYPoGQeZJAGsKgK6FkOZBwNap0v6qYGPpYNUGcPiGlGYFft0HUL0C4JGFMH4DyqEAsOUJUHoIUJkAIFYY4ekM4QwEMPYcsF0D0A0HMK4TyrUPUAIP0C0F4SKnoDopMJ4O0FEXMBEUGBIGsBaJsNsHoPLJgDsDwF3pwL3qQP3oPsPhwKoP4FBPiFBJIGcMAMgHvIziSOMhAKPlYJYI%2BLgIQLRHxDyk%2Bp%2BKWN/gMrxIGnQXfkviAIMSSKvubPCgAJzTEaBcC8Twq8T%2BAH7H4cCn6kAMHwo36FG8DFFX4gA37z5oH35P4QBIC1IpAAof7Fh9E%2BHzgdFVDCH8HiBBD8CCD1piFoGkDxpMApCMFrH5G7EX4cBpTPhXF0LYilHlGVHVG1E44NFnBNG9Fv4DFDG34nFrCdhYAJDIRrEbFbE7Hn77G2CHEYlaBkqkDL6SBcAki8SSD%2BCzHTFcBmDTFQSJCJCzFrG8Rn7fEknHEUm5EcDGEFHEmX7kmL6kDYIZDOCSBAA%3D%3D%3D)
    Uses the proxy feature to create a generic type `value_proxy<T>` which exposes all fields of `T` through accessors methods

- **View an array of structs as a struct of arrays** - [example-struct-of-arrays.cpp](https://github.com/veselink1/refl-cpp/blob/master/examples/example-struct-of-arrays.cpp) - [View in Compiler Explorer](https://godbolt.org/#z:OYLghAFBqd5QCxAYwPYBMCmBRdBLAF1QCcAaPECAMzwBtMA7AQwFtMQByARg9KtQYEAysib0QXACx8BBAKoBnTAAUAHpwAMvAFYTStJg1DIApACYAQuYukl9ZATwDKjdAGFUtAK4sGIABz%2BpK4AMngMmAByPgBGmMR6AA6oCoRODB7evgFByamOAmER0SxxCVy2mPYFDEIETMQEmT5%2BgZXV6XUNBEVRsfF6CvWNzdltQ929JWUSAJS2qF7EyOwc5gDM4cjeWADUJutuCAQEiQogAPQXxEwA7gB0wIQIXjFeSsuyjAT3aCwXADdMHZwgBrLjXTBUWgAWmQiUSFxYTCG8QuWx2mEh0PuCARB2wJg0AEENhivHsDm4nENiJhWASiaSzJsGNsKZh9ocgQ4SIySUyLgAqEWisXiiWSsUXJkETAsRIGOVctwEACeiUYrE5ABV%2BcS0AxUapEsRdkwvERdnSmOgmDF6AB9NileIKLkAEV2NFocuIEDp0JAIBdZUdtDwQypevWhIA7FY4x7SPsAKxWVMeiAWq2h%2BKzfYJ62YAhLBi7SOOm12h2YCB54izA4WQsepvrKwCklyhVKzlU9Wa5hsXYxwkk97hYDF232p0N8ORgie3ZDdDBuksVBAx2GoaOghUrDbQd16tzzDO%2BVlBTRgntwkdpmCkVM3ZC0cITmn3YEL8zmt6F2Bti1LYgjV2W4v3LcIAVQUFMHQe43yFGVu3lRUmGVAcNS1EcACV6UAzAAFlr3ifVJyMXYvAYLBiFoNUpwPXCV0DWhgwIG5CA3eVt0vABHLwxDwGg3QPI9MBPXCIEI2dazI11/VmCA12DY9aABMQqT3ZdT2HTk5OIxSZhADSGmY09zAANgJCBZgcxkny7Yke0w7DDn07VR31WkvAcVcuP8ghHVQKhHQaG41XdEBiyDEBiFoxw2GDU1UFUNUqT8hxQvCyKmGiu9YxTNSEr4ndkABCTDjHAlC07YlEleCNkBAZ8SV2TqaNSajz1rK8lPdA4vT6%2BdyOIRco0OUrN343cqsPGqnMfBqusCrC8GQCKFA%2BAgAyIi8BpvYNUgAL37WNdg0FNzDMHVWIQFFdgYVBvTwKp0AUMAwFu9sGrfLrspCsKIuIKKFFUvBzoPXZRESJhkEINUV0kJsOq6kwEwBzrMY9driTWuC8HQXYmoUBBHRiBHQQgXSfLMazdi07xMDRgmMax9G1s6/gJvpZAEH2%2BSxsG%2BrcZu9MbJMTNs0tV6GxKqHL2XcIsFUAtMdW7ntd0zATTNHNXrwNioQ4kAuKYHiQFVvXcsdAFJOkzV63G%2BYAMOhtb1jZtse1wGCHXEBgBLKk8DsoYSCYYPHVme4yYpqnkBphsIGZrxWb%2B321txzOudbfHCdQYnSdQRJKep%2Bzfc1rOut5x1%2BcF0bL096ukwlqwGelrNDeA12xbzv3YYEY1TXNOWKxN%2BKLatm3VDth3Dg008XaUt2m6Ot0nK1wfOtK4PFupcOiBuaPY%2BSMvE5p3P2e1nOfbz3GC66nVzT2s7lYrOi9YLXSq85m/uYv0PFjJM98AFrTrg3IWxEN7EFvCA5MaYO62Rlj3BsGt/47y6rrfWY8rTG2GnFM208CDBlnvPR2voZLoJTOvFu3tnLgL9nvEOhww6xlUsfKOl4z6l3LknSujDB53yERzPGLk1puT7CqLyI4TIUW9nnQ2Nldil3iFhPkksZbyMbH/be3McGjx7gQ9YI1TacW4qQ62X854gwXm4HRtCDr9XoStGunU6RgXLCwg%2B7DsCcMjqfMB2dQESK6lIrCF1VS4QMrsHR%2Bo1p02UQzVRmobjH2lhmLMOif7D0PA/TBftDEG3HiYsxU9LFkJsRQw4jj3YuPGl7NxA8uqeLLIFQO%2B9Q5H0CTw4JYin67yVjDd%2B9kh5GnyQA6uLSPElnaT4qkGgeknx4fcUZ18QniNJHnCJHlolDm8nU2RnIhBVCoAk/2G1kB4KNgwOCCFHR4F7BAU5tBzmdxSXYKgitoYqxsQWGEdUl4yUNmzEJ%2BjEl5L1kY0pk9iGVOsWrGpDjxpOOFs3RpW93E3KliknkK4FlsPDmctZXCgmiO1m08CTMpL3CwhAWeGyBkuVNHgLSco2phM6rsqJxzdhGQvPExRACgbASYA8iOKy9HYqotOH8hDSo8gyYcWi9FGKWVwlSAVClxrLX6TjUBjDfbsQsZbKxKIDxeEVMrKkJrzYIuRGXA%2ByIJVkswGimBri6qSu4Y6MBj8jXoV7JElU78YaRBTHy2qJJkmM33pwxKOUQb5UKktb2nzUBMDZtMgBsre5KThaaq2%2B9qpuAjb%2BGJ3kgZ2xTV7NwY5eLotgU0/VoF5mZsyQ2VueNMz%2BtCds1yGFpFZWGcuctUb9RJLlio%2BNdNq3JrBgVOttUM1ZufIUzqeaQKELtSQ4MJaD7jsrSOedeVF2pvrQSRtnrMUMP0VS7xHb0xdoQV3PtWymQGQUPDFYHT136J5TI49uoLm7yCgFUs1rHTvyyuB4GZ7wZFUfOOKZG7uYTEcNc4pq5R1MzEOnAlcGa3nuXVesqTbPYnSVq2gN/0dlDpDSO35uwj0HJHNGkVcHfxWqdFUeU3wqTltPaDRDabkPSpmd1KcuwsAKGQMQPAiRj6FvtWa/dJZS2sbwpyYTtakPXo9re5pTDN09TlaxQhwLnalQ0szWDib4MiaXUhuyTZ0yyfk4pjJr7MxMoNXjI1/aXxShC6F6U%2BNtgondGgWgfIBT/yag6TanKB2Qti8pFcWAqAWl9P6vOMWSDUFi1ha0KZoSZuXMAMrxXlwxDBX7WK/pGwpmANAN2MQIB1Yk6hj9edyslbpOgMZdNNZtupcQZs%2Bc85ExJkoEKg2isVbwyzDBLYzSELTpgSbj8uXehq7sYAdJGDDbyfVMb5ZgDbf7YXYuc3HSHcwMd/ry5NurYOyuTbV3esAOe7sB06cTsTLOw%2Bv7X3fYzdXBp/7dZfuvbOzED7%2BGtsdimwO1l7L2C%2B1%2B2QA7KYYjvry8SfC2AABiIRHTEjkDqAA8hAX2y8CvNax7RZA%2B10ApjSmk9U9k3ZUBZ6pDTg2OfEDUY0NUPPSDM7ZNAI7DBhei%2B5w5Mr/O7sPcYPLrn4uldS9Z9DjX8RFe85V1Dlm%2Buxc86ZGzYUYWbdSjQgO8Iy5kThErvF/RumSM6U8HyS6jOvb6L93Hd4CcK6M9G/cDQ3zdj3FTFHmPVBWx%2BaHulhQQfyb8JpmHosEe4%2Bx5TDnxPrbA/xwz7Tb3E3s95%2Bj1X%2BPhfA0ANjUgwbu5Hpy4O7Llvhg8cs07wwLuK4/eE7WqVNAloVRUn2GYMwMHTG3XH4cZPJBU/rPn24SfZhpZuD71P1tvNdiQ2Y2Uq6k2TFr8D%2Bsk/1hrCrexSPxYy4qQT9uhN2fU/V/FnQL3zJYdMzv9uqQS7V/Mwd/NXBgL/dMH/L0R/Bff/fHIA9/aHcAiwSAv/HfVMLfW6GjILJMDgeYDiDgVMXgPwDgLQUgVATgNwK/SwVcRYZYfsFkHgUgUhEg3A%2BYUEEAVMfwe4ayVMLgDQfg/wOMDQdYKfYQ/QTgSQIgzQXgcgjgXgc4a6ZgrQeYOAWAGARAFAVABUOgeIcgSgP4RIHQhIYAPgswPgOgP0c4TraQ0gGIcIBoNUTgRgv4NgQQanBgRiGwrAZEIwcQFg0gfAOkBwNlYEGwvWKSS0VYUgx3KoGwiMGIG4YgNUDwLAJw3gLiJ5NI%2BYaEKOBQAANXeluGpyHDSJkEEBEDEHYCkDKPkCUDUBsN0AqAMCMBQCoJsHiPOEgHmFLhqHOA4BhDXGGlMEsGsC4DjF2BhGpzMHkL42COcAgFcFGD8AqFCHCD6CUiSBSDSAECWM2PyHSCmH6HKHaCkhqC6BGE8BaEGFmLOOGB6DWOmAGAqAmAuKyGWNsDuMOI2K4HmAUFoJWD0C4keyyPEIIKkP8NkNUH8GshhGskkAO2QGuT4PuGAIgEoJGMsBTFwEIBIEn3WAqF2A8G0PoHWwYNmHSOkKV3YPxJj38AZlTAAE4GSNAuB1hUx1h/ARDQTJDSAWAODrpiDSDZD5CQBFDKTSBVCND78moCA9Cy9iSnjgh8Bj49B%2BByjRBxAgg1TaiVB1B/DbgbhEgQT8DCDSBBSZDOBqdLQZTVEE8oSYS4SESkSNAUT98iTDCSS8SfiKSWClcvxbQBh7JuTeA%2BTUwBSbDhTbBRSmDKS2CQBJAuB7h1hJB/AmSGSuAzAGTrI4w4wmTQT1hwShTOAfTlC8DOBpizSIziyYzfT5ggQ4F0h4ygA%3D%3D)
    Uses the proxy feature to create a generic type `struct_of_arrays<T>` which stores all members of `T` in `std::vector`, but also has an `T operator[](int)` which constructs the individual objects on-demand

- **Generate a struct of `std::optional` members** - [example-partials.cpp](https://github.com/veselink1/refl-cpp/blob/master/examples/example-partials.cpp) - [View in Compiler Explorer](https://godbolt.org/#z:OYLghAFBqd5QCxAYwPYBMCmBRdBLAF1QCcAaPECAMzwBtMA7AQwFtMQByARg9KtQYEAysib0QXACx8BBAKoBnTAAUAHpwAMvAFYTStJg1DIApACYAQuYukl9ZATwDKjdAGFUtAK4sGIABz%2BpK4AMngMmAByPgBGmMQSZqQADqgKhE4MHt6%2BAUGp6Y4CYRHRLHEJXEl2mA6ZQgRMxATZPn6Btpj2RQwNTQQlUbHxibaNza25HQrjA%2BFD5SNVAJS2qF7EyOwcAPQAVHsmGgCCANR75wcAStjHACIAstgHhyfnpwAqCHgKp5iqrGS9FOCgQqAA7qIlL8weDTsliKhVHhML9RAxTnFTl4lOhTkRTkwvMA2IJCfiAJ7JTD41CnZDETBMAg0nGYKheWhHM4XLyOWiECmU6kKAB0pwAEvEaeCaVgaBFyeYzMl%2BngxMr4YjVEKCFTMKRTuDvsgEKcBQBrGliWhapEohSkbnvBBMX5sRbEU4chh1AS/cGEM2YACOXjwADcxIwCKdmGxfgSCAgaR6Kr9UFR8Sn8U1gJgCIaYnzTuEWYyZuFgLQKU63hdk2lU5hPYTkFsFDMSL9GQQNhiZugQCBUMkemIxZ9vmjDJjWUoObaCQjUBG8Fh4WqNfXTlHvKjTpnCRjUDFtLUCKLna8eZ8mFbybRUKgLYTY8nWcl0MzMBBlt6vF9Ho5yfOECSUGlYWvEEvFNTdmnVW1T3PBwZwxLE2TxcCugvSMuiFJRYyYI0wWBZCLzADh3RbdMr3rHZuXMABmcJkG8DcTCYtwEAIAhkgUEAdh2YgmHBUVgCDLxiyUTZZBjUU0BYHYI1RLpwgtLhhPZWgAFpkGSZIdhYN1yx2Vj2MwLSqFoUUEAMzjsEYswWN9CzTk4twnBmRlWAcpyXLYrwOK40dxy5JjHJObl9hvd5FEwPFA2TfERMIYdjOSAB9d86RXNcNy7ET82FGl%2BC9D9TjTeI6J5BiThZFggR/dyuL1al4xpB4aPiPyTm82DY2Mq1MtCzIxEywqmHzRiAHYrDeU5FpxKtsQYLBiBrKtsv1Fq7lOLA2La38us9Ew5rOu4IEHYcDtoPcPLQBgZhKjrThOiobtqAxiC2o7zAANgcv9lmWTj5rORbsXSIwSt2kECCHEcxzG8K3EZazhwIVKCGHRkWFXTBMrDMQ8BoeIFGyjzAPWzajG26k/IisHZruZmopOGLoLOFcdRIvA4MKg8V2pBCDyPCrxnzd8drdeHEdGgQJxq846uOBqmpZFq3CO16Pl6442LdX5VQQsRThAeEpIFZBTnR2hccAxw2GHHmKQ8k3HA1Li9Yiw0fci44zvB5Irf5kBGIWxahNOAAxFFaHQX5DDxYX4j1U4pfLMVnUhmZmX5%2Bl/RZVQEUJPk6Sq4hfk4vaaFocsIDt9LuuITKBRmDz/aDi7DRMABWKw%2B8uokCUr/8g9tgt%2B1LCmfO/GJ6AgMf3LMQHV9OV0KfBH6G7HsH3Jmu5QaY8Gc6W6HgEqlu25%2BWMa7l3GWwJzLkAjSmuNuo6l5bhRj8ck%2BI4QyjjsT4IlkgZwLOWekNps6R3xC2DWNIPI61YJ1FuhoUFsFOEILoVAMH6g6qKIhpxjjEGAAofWkN4b5xtp/fUEAR6oH/OECML5CZ4EarQCAODaBUABgDEEuDQZwO7nAqhedHDIEykbNOEAfiZTnkwBex0W7d0PiDNmQCqGTz7MQAcuDRTqwMJrKWHl3o9Qin%2BTRVCLqAKodHD4YDBG8XiNA2gtBYFaKMc1ZBBDUFvXQS9fxPC8FBKwQANTEF4TAlDc6NEkbuVA65SwMFYcNDhQJuG4P4evOwoTIn7hyf9XcUTMDCK0aIrR4j4n82kZ2WR8jt6ECUYvcxxA1FH2PuDbRkNlow0zvEbKcM6HUmgAWBRTJ1oQDaR0jRACxG5wMd4kxBYPIDNbgQIG48mJ7WuiAMq4ImjoA8gU6JQM9zRK6WfA%2BrN2ZeIQcYpBrU/FYJmUzOBjCBFSysSI86CzFqPRmP8Uu6QABehNYzrlUHDJuIAsZMDSiAcIWBVAjSoJlCMZjAmVxvh3Jm8yqlxJoXUmSBA5HoGhWAMA98dJcCuf8nR09YV8joMOUxXEoVA2/I0elFTD52Mhssp52sXloNOu8rRgKiLly%2BQWP8hcnqbN%2Bd0npCqgUly9GCiFpYKUwu0pjbGw5kX/DRRirFnpDQ4vbps/FKqekSNqTI5o5LKXUp2acWlvLVWMr0ZPDGIAWX2xAOyzyFKuXMiYF6yGti7kIkjD%2BcOdyqF9Mvjiya%2BZcV33dbC%2BFiKMrvzcENQmCtmC0AmkQIqBor6ekzYzU%2BcCc2GpAG6bKXggQQo8mmitU1CbWocvtCNmiWZDvqg8nxzz2r%2BK7icVhyS23ct/HrdeksCyGilfBT2qMu65PWJsMps07XehIJlJkporq7q2KKSujp3ID34UPBh5dq0VHHn8wl58Vo4qOsMr6X894Eu9VK4FXpGFGh3q4%2B%2BUtMpNN3i3KNPTQOhQxaUuGCgL2YEMWOlZNrC3Xz%2BpY%2BD2jSanAgEhi5ZSD6Hu9TB%2BIEAV2FnOGR0phGbH8t%2BUfIdbHA59SxgNU4FhnwWgPdyEOC8w4CsWgJl8EB117O8lWARjgCD0DXUXB%2BIB5NGAESPMEZAUmxlVPmX%2B1yqEWyU/QTKdHCD0FWGXRsrdH32ds4Z1ElmXPGeVdcmN3HJVqbk1jBTy7rO/n/OuievZp7mcJvvbzVDZ14kItlYLMm/MI2HJp4AAjyOvosPiYLmU4bkZi1x65sm0saYC1p9eOmSDyrC3NH1GIaut2K7crR8XnHSL5LplLir1MZay8xyjdndMFfvkVk%2BNyJP6c3EZuranwtT19e5zKrXrkdcS%2B5uRZJsvDZW4V0pa3Y0/SjCyRNWj/M/RhlF1bAG4mIwyyN491jIZllm65zjrMCXchuDHEImVjhyA%2BAAeQgNcr%2BUmLSrGuT6ZAVnlNVtTs0CkwNDSw6uuMqLhokd6lRzDwCcPmvY8RCLXHIM0cE4xwQLr9niejjTij8n%2BPfQQHc3T0njPbPo82z2m9OPOfcnKdyN7xlwg/MDm%2BqhkPMSCbB2YMwHxgvKl7vL443WSDK9OBoXl1yPaIQ8pD/tevxoxEEyOi75W0Alg8h5FeZgouHizMb20cQyo0kSw7%2B%2BmobdcQ3YhTKpuXyGOS8sUU5GRrEDl2YDyDBORPjHH5eX2y3C28ov3NwDA093cWs7gPgnRQe%2BS8qSImA4SK4R8qQjeyrdZpT775UDujzO8JFQKBheEdw291xW3ufA8WmDwjv8YfSkR6jzHuPoVE9mGT6njg6fM9z%2B%2B3A6v6xa%2B24b8Fx3MuXxzjd9iL8469pd7r24bf/eovyp96ftPfcM9Z8PfOn8EA%2B/Y63GWvvVfLer61uv%2BXjesx94t5QKP6axe7y4/6%2B594D6Lwz6%2B43536L71oW6Iw14QGn57KuDhSnyHwcCrD2wcB9y8B%2BAcBaCkCoCcAp6WDWAgjoYrxMQ8CkA4wkG4GrAWggB9z%2BCij/R9xcAaB8H%2BAzQaBMTy5CH6CcCSBEGaC8DkEcC8ACQaCMFSGrBwCwAwCIAoCoCNR0DxDkCUCKTJDaEJDAC8FJB1xZyUAxBSGkAxDhBNAUicAMGKSkgEDA4MA1hWFYDGRGDiDMGkD4CMh1AqQCS%2BH/C1B8jbCkFlhdBWECgxAiTEAUgeBYAOG8ABYsApGrDWRTQKDhIojgjA7tQpEyCCAiDRgSDSD8CCDxRqBWG6BcD6CGDGDWDWD6B4AxACSQCrAlrBE6SDg1ymBUGWBcAzQerA5mByE4R%2Bh%2BAQCuCTB%2BD1GhDzBlAfT1EFAZACBzF6BrE9CDDLFLCdDdD1CzCbH1E1BTF9DNC7HDCVBjD9AnG3GXFLHXESCrBoYbBbB6BYyYDbA8B4GcCEGkDEGkEyGqD%2BD/Q6T/SSAZztinC8GihmAkaUFWCWCGi4CEAkB0H1GnAeBaH0BejMR0qpFKGsEgD0GigcGrx9wACcVJGgXATEfcTE/gwhYhHAEhpA6RfcChQJ0hnAchIAChTBWgyhahEASAq%2BIchYFAKWuJ%2BxCU6JNxlRwgog4gQQSp1R6gvh28TAyQGRrJAJPJZBnAwOfIkpW%2BoJ4JkJ0JNscJCJEAOJBheJmJywRJzB5OKYTA60lAfxbJvAnJ3JVhMh/JgpxJpAbBkgXAooTEkg/gNJVJVQVJ/0M0M0NJrJTEkhvhQZihbpPp4xgJgZfJ2ZwpqwKkVcmQIAkgQAA%3D%3D%3D)
    Uses the proxy feature to create a generic type `partial<T>` which wraps all members of `T` in `std::optional`

## Motivation
I started developing refl-cpp during my final year in high-school. I was supposed to be studying for exams, but I had just read the original [Static Reflection (2017)](http://www.open-std.org/jtc1/sc22/wg21/docs/papers/2017/p0194r3.html) proposal, and after realising that it wasn't coming anytime soon, I decided that I had to try to cram as many of those features at possible into a compile-time library.

The library has grown and changed a lot since the early days, but even after several years, I still haven't seen another reflection library that supports constexpr and template metaprogramming. With other libraries, you often have to walk a metadata structure at runtime, invoke function pointers, and use type-erasure. With refl-cpp, you process the type metadata at compile-time, via [`for_each`](https://veselink1.github.io/refl-cpp/namespacerefl_1_1util.html#a19919596cdd45c858d891c91a7826b22) loops, all the types are there, and the compiler can often inline everything and generate the same code that you would have hand-written. 

## Performance
All utility functions in refl-cpp are constexpr (except the ones in `refl::runtime`). Compilers will generally inline all loops and other constructs (when using `-O2`) and generate code that runs just as fast as if it was hand-written. 

Thanks to some special compile-time optimisations, type metadata is generally not instantiated (no code-gen needs to happen) when the types themselves are not used in reflection. With 0.12.2, there have also been some major reductions in compilation time when using properties [#60](https://github.com/veselink1/refl-cpp/pull/60). 

That being said, a word of caution: I have observed that after around the 250 reflected members mark, compilation times start to grow rapidly. If your codebase contains lots of huge classes (+250 functions), and you *need* to have all of them reflected with `refl-cpp`, this might be a deal breaker - benchmark before using.

# Integration

## Requirements
- Minimum language standard: C++17

## Single-header library
To use refl-cpp as a single-header library, copy [`include/refl.hpp`](https://github.com/veselink1/refl-cpp/blob/master/include/refl.hpp) to your include directory. 

## CMake
You can also consume refl-cpp as a CMake dependecy (3.14+ required, thanks @friendlyanon).

## Packages
- `vcpkg install refl-cpp` (thanks @Vennor)
- `conan install refl-cpp`
- AUR (thanks @otreblan)

# Documentation
The [online documentation](https://veselink1.github.io/refl-cpp/md__r_e_a_d_m_e.html) is built with Doxygen. Run `doxygen Doxyfile` in `docs/` to update it.

# Testing
Run CMake with `-Drefl-cpp_DEVELOPER_MODE=ON` and make the `refl-cpp-tests` target. 

# Contributors
Run CMake with `-Drefl-cpp_DEVELOPER_MODE=ON` flag. You may also want to setup a custom preset for a more convenient developer experience ([see this comment](https://github.com/veselink1/refl-cpp/pull/44#issuecomment-811878328) on #44).
- Issue tracker - [refl-cpp/issues](https://github.com/veselink1/refl-cpp/issues)
- Source code - [refl-cpp](https://github.com/veselink1/refl-cpp)
- Contributors - [refl-cpp/contributors.md](https://github.com/veselink1/refl-cpp/blob/master/contributors.md)

# License
- MIT License (for more details, see the [license file](https://github.com/veselink1/refl-cpp/blob/master/LICENSE))
