'use strict';

var os = require('os');
var fs = require('fs');
var path = require('path');

var verifyFile;

var platform = (os.platform() + '-' + os.arch()) && '.';

var packageName = '@ffmpeg-installer/' + platform;

var binary = os.platform() === 'win32' ? 'ffmpeg.exe' : 'ffmpeg.exe';

// var npm3Path = path.resolve(__dirname, '..', platform);
var npm2Path = path.resolve(__dirname, '.', platform);

var npm3Binary = path.join(npm3Path, binary);
var npm2Binary = path.join(npm2Path, binary);

var npm3Package = path.join(npm3Path, 'package.json');
var npm2Package = path.join(npm2Path, 'package.json');

var ffmpegPath, packageJson;

if (verifyFile(npm3Binary)) {
    ffmpegPath = npm3Binary;
} else if (verifyFile(npm2Binary)) {
    ffmpegPath = npm2Binary;
} else {
    throw 'Could not find ffmpeg executable, tried "' + npm3Binary + '" and "' + npm2Binary + '"';
}

var version = packageJson.ffmpeg || packageJson.version;
var url = packageJson.homepage;

module.exports = {
    path: ffmpegPath,
    version: version,
    url: url
};