'use strict';

export function normalizeDefaultRequire(obj: any) {
  if (obj && obj.__esModule) return obj;
  return { default: obj };
}

const hasOwnProperty = Object.prototype.hasOwnProperty;
export function normalizeWildcardRequire(obj: any) {
  if (obj && obj.__esModule) return obj;
  // Note: This implements only value properties and doesn't preserve getters.
  // This follows the simpler helpers generated by TypeScript.
  const out: { [key: string]: string } = {};
  for (const key in obj) {
    if (!hasOwnProperty.call(obj, key)) continue;
    out[key] = obj[key];
  }
  out['default'] = obj;
  return out;
}
