/*
 * Decompiled with CFR 0.152.
 */
package ru.zinin.redis.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.SessionIdGenerator;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.util.SessionIdGeneratorBase;
import org.apache.catalina.util.StandardSessionIdGenerator;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import ru.zinin.redis.session.RedisEventListenerThread;
import ru.zinin.redis.session.RedisHttpSession;
import ru.zinin.redis.session.RedisSessionKeys;

public class RedisManager
extends ManagerBase
implements Manager,
PropertyChangeListener {
    public static int SESSION_ID_LENGTH_UNSET = -1;
    private final Log log = LogFactory.getLog(RedisManager.class);
    private static final String info = "RedisManager/1.0";
    private static final StringManager sm = StringManager.getManager("ru.zinin.redis.session");
    private int maxInactiveInterval = 1800;
    private int sessionIdLength = 32;
    private int maxActiveSessions = -1;
    private String secureRandomClass = null;
    private String secureRandomAlgorithm = "SHA1PRNG";
    private String secureRandomProvider = null;
    private SessionIdGenerator sessionIdGenerator = null;
    private String jedisJndiName = "pool/jedis";
    private String redisHostname = "localhost";
    private int redisPort = 6379;
    private int redisTimeout = 2000;
    private String redisPassword;
    private JedisPool pool;
    private boolean disableListeners = false;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final RedisEventListenerThread eventListenerThread = new RedisEventListenerThread(this);

    @Override
    public String getName() {
        return info;
    }

    @Override
    public long getSessionCounter() {
        this.log.trace("EXEC getSessionCounter();");
        return 0L;
    }

    @Override
    public void setSessionCounter(long sessionCounter) {
        this.log.trace(String.format("EXEC setSessionCounter(%d);", sessionCounter));
    }

    @Override
    public int getMaxActive() {
        this.log.trace("EXEC getMaxActive();");
        return 0;
    }

    @Override
    public void setMaxActive(int maxActive) {
        this.log.trace(String.format("EXEC setMaxActive(%d);", maxActive));
    }

    @Override
    public int getMaxActiveSessions() {
        this.log.trace("EXEC getMaxActiveSessions();");
        return this.maxActiveSessions;
    }

    @Override
    public void setMaxActiveSessions(int max) {
        this.log.trace(String.format("EXEC setMaxActiveSessions(%d);", max));
        int oldMaxActiveSessions = this.maxActiveSessions;
        this.maxActiveSessions = max;
        this.support.firePropertyChange("maxActiveSessions", (Object)oldMaxActiveSessions, (Object)this.maxActiveSessions);
    }

    @Override
    public int getActiveSessions() {
        Long result;
        this.log.trace("EXEC getActiveSessions();");
        String key = RedisSessionKeys.getSessionsKey();
        Jedis jedis = this.pool.getResource();
        try {
            result = jedis.zcard(key);
            this.pool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
        return result.intValue();
    }

    @Override
    public long getExpiredSessions() {
        this.log.trace("EXEC getExpiredSessions();");
        return 0L;
    }

    @Override
    public void setExpiredSessions(long expiredSessions) {
        this.log.trace(String.format("EXEC setExpiredSessions(%d);", expiredSessions));
    }

    @Override
    public int getRejectedSessions() {
        this.log.trace("EXEC getRejectedSessions();");
        return 0;
    }

    @Override
    public int getSessionMaxAliveTime() {
        this.log.trace("EXEC getSessionMaxAliveTime();");
        return 0;
    }

    @Override
    public void setSessionMaxAliveTime(int sessionMaxAliveTime) {
        this.log.trace(String.format("EXEC setSessionMaxAliveTime(%d);", sessionMaxAliveTime));
    }

    @Override
    public int getSessionAverageAliveTime() {
        this.log.trace("EXEC getSessionAverageAliveTime();");
        return 0;
    }

    @Override
    public int getSessionCreateRate() {
        this.log.trace("EXEC getSessionCreateRate();");
        return 0;
    }

    @Override
    public int getSessionExpireRate() {
        this.log.trace("EXEC getSessionExpireRate();");
        return 0;
    }

    @Override
    public void add(Session session) {
        this.log.trace(String.format("EXEC add(%s);", session));
    }

    @Override
    public Session createEmptySession() {
        this.log.trace("EXEC createEmptySession();");
        throw new UnsupportedOperationException("Cannot create empty session.");
    }

    @Override
    public Session createSession(String sessionId) {
        this.log.trace(String.format("EXEC createSession(%s);", sessionId));
        if (this.maxActiveSessions >= 0 && this.getActiveSessions() >= this.maxActiveSessions) {
            throw new IllegalStateException(sm.getString("managerBase.createSession.ise"));
        }
        String id = sessionId;
        if (id == null) {
            id = this.generateSessionId();
        }
        return new RedisHttpSession(id, this, this.maxInactiveInterval);
    }

    @Override
    public Session findSession(String id) throws IOException {
        String lastAccessTime;
        this.log.trace(String.format("EXEC findSession(%s);", id));
        if (id == null) {
            return null;
        }
        String key = RedisSessionKeys.getLastAccessTimeKey(id);
        Jedis jedis = this.pool.getResource();
        try {
            lastAccessTime = jedis.get(key);
            this.pool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
        if (lastAccessTime == null) {
            return null;
        }
        return new RedisHttpSession(id, this);
    }

    @Override
    public Session[] findSessions() {
        Set<String> sessionIds;
        this.log.trace("EXEC findSessions();");
        Jedis jedis = this.pool.getResource();
        try {
            sessionIds = jedis.zrangeByScore(RedisSessionKeys.getSessionsKey(), 0.0, Double.MAX_VALUE);
            this.pool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
        HashSet<RedisHttpSession> result = new HashSet<RedisHttpSession>(sessionIds.size());
        for (String sessionId : sessionIds) {
            RedisHttpSession session = new RedisHttpSession(sessionId, this);
            if (!session.isValid()) continue;
            result.add(session);
        }
        return result.toArray(new Session[0]);
    }

    @Override
    public void load() throws ClassNotFoundException, IOException {
        this.log.trace("EXEC load();");
    }

    @Override
    public void remove(Session session) {
        this.log.trace(String.format("EXEC remove(%s);", session));
        this.remove(session, false);
    }

    @Override
    public void remove(Session session, boolean update) {
        this.log.trace(String.format("EXEC remove(%s, %s);", session, update));
    }

    @Override
    public void unload() throws IOException {
        this.log.trace("EXEC unload();");
    }

    @Override
    public void backgroundProcess() {
        Set<String> sessionIds;
        this.log.trace("EXEC backgroundProcess();");
        long max = System.currentTimeMillis() - (long)(this.maxInactiveInterval * 1000);
        Jedis jedis = this.pool.getResource();
        try {
            sessionIds = jedis.zrangeByScore(RedisSessionKeys.getSessionsKey(), 0.0, (double)max);
            this.pool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
        this.log.debug(sessionIds.size() + " sessions expired.");
        HashSet<String> removedIds = new HashSet<String>();
        if (!sessionIds.isEmpty()) {
            jedis = this.pool.getResource();
            try {
                for (String sessionId : sessionIds) {
                    if (jedis.zrem(RedisSessionKeys.getSessionsKey(), sessionId) <= 0L) continue;
                    removedIds.add(sessionId);
                }
                this.pool.returnResource(jedis);
            }
            catch (Throwable e) {
                this.pool.returnBrokenResource(jedis);
                throw new RuntimeException(e);
            }
            for (String sessionId : removedIds) {
                RedisHttpSession session = new RedisHttpSession(sessionId, this);
                session.expire();
            }
        }
    }

    public String getJedisJndiName() {
        return this.jedisJndiName;
    }

    public void setJedisJndiName(String jedisJndiName) {
        this.jedisJndiName = jedisJndiName;
    }

    public String getRedisHostname() {
        return this.redisHostname;
    }

    public void setRedisHostname(String redisHostname) {
        this.redisHostname = redisHostname;
    }

    public int getRedisPort() {
        return this.redisPort;
    }

    public void setRedisPort(int redisPort) {
        this.redisPort = redisPort;
    }

    public int getRedisTimeout() {
        return this.redisTimeout;
    }

    public void setRedisTimeout(int redisTimeout) {
        this.redisTimeout = redisTimeout;
    }

    public String getRedisPassword() {
        return this.redisPassword;
    }

    public void setRedisPassword(String redisPassword) {
        this.redisPassword = redisPassword;
    }

    public JedisPool getPool() {
        return this.pool;
    }

    public boolean isDisableListeners() {
        return this.disableListeners;
    }

    public void setDisableListeners(boolean disableListeners) {
        this.disableListeners = disableListeners;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        this.log.trace("EXEC startInternal();");
        while (this.sessionCreationTiming.size() < 100) {
            this.sessionCreationTiming.add(null);
        }
        while (this.sessionExpirationTiming.size() < 100) {
            this.sessionExpirationTiming.add(null);
        }
        SessionIdGenerator sessionIdGenerator = this.getSessionIdGenerator();
        if (sessionIdGenerator == null) {
            sessionIdGenerator = new StandardSessionIdGenerator();
            this.setSessionIdGenerator(sessionIdGenerator);
        }
        if (this.sessionIdLength != SESSION_ID_LENGTH_UNSET) {
            sessionIdGenerator.setSessionIdLength(this.sessionIdLength);
        }
        sessionIdGenerator.setJvmRoute(this.getJvmRoute());
        if (sessionIdGenerator instanceof SessionIdGeneratorBase) {
            SessionIdGeneratorBase sig = (SessionIdGeneratorBase)sessionIdGenerator;
            sig.setSecureRandomAlgorithm(this.getSecureRandomAlgorithm());
            sig.setSecureRandomClass(this.getSecureRandomClass());
            sig.setSecureRandomProvider(this.getSecureRandomProvider());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Force random number initialization starting");
        }
        sessionIdGenerator.generateSessionId();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Force random number initialization completed");
        }
        this.log.debug("Trying to get jedis pool from JNDI...");
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            this.pool = (JedisPool)initialContext.lookup("java:/comp/env/" + this.jedisJndiName);
        }
        catch (NamingException e) {
            this.log.warn("JedisPool not found in JNDI");
        }
        this.log.debug("Pool from JNDI: " + this.pool);
        if (this.pool == null) {
            JedisPoolConfig config = new JedisPoolConfig();
            this.pool = new JedisPool((GenericObjectPoolConfig)config, this.redisHostname, this.redisPort, this.redisTimeout, this.redisPassword);
        }
        if (!this.disableListeners) {
            Executors.newSingleThreadExecutor().execute(this.eventListenerThread);
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.setState(LifecycleState.STOPPING);
        if (!this.disableListeners) {
            this.eventListenerThread.stop();
        }
        this.pool.destroy();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }
}

