/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.socket.nio.AbstractNioWorker;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.internal.ExecutorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNioWorkerPool<E extends AbstractNioWorker>
implements WorkerPool<E>,
ExternalResourceReleasable {
    private final AbstractNioWorker[] workers;
    private final AtomicInteger workerIndex = new AtomicInteger();
    private final Executor workerExecutor;
    private final boolean allowShutDownOnIdle;

    AbstractNioWorkerPool(Executor workerExecutor, int workerCount, boolean allowShutDownOnIdle) {
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        if (workerCount <= 0) {
            throw new IllegalArgumentException("workerCount (" + workerCount + ") " + "must be a positive integer.");
        }
        this.workers = new AbstractNioWorker[workerCount];
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = this.createWorker(workerExecutor);
        }
        this.allowShutDownOnIdle = allowShutDownOnIdle;
        this.workerExecutor = workerExecutor;
    }

    AbstractNioWorkerPool(Executor workerExecutor, int workerCount) {
        this(workerExecutor, workerCount, false);
    }

    @Deprecated
    protected abstract E createWorker(Executor var1, boolean var2);

    protected E createWorker(Executor executor) {
        return this.createWorker(executor, this.allowShutDownOnIdle);
    }

    @Override
    public E nextWorker() {
        return (E)this.workers[Math.abs(this.workerIndex.getAndIncrement() % this.workers.length)];
    }

    @Override
    public void releaseExternalResources() {
        ExecutorUtil.terminate(this.workerExecutor);
    }
}

