/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.http;

import com.couchbase.client.ViewConnection;
import com.couchbase.client.protocol.views.HttpOperation;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import net.spy.memcached.compat.log.Logger;
import net.spy.memcached.compat.log.LoggerFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;

public class HttpResponseCallback
implements FutureCallback<HttpResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResponseCallback.class);
    private final HttpOperation op;
    private final ViewConnection vconn;
    private final HttpHost host;

    public HttpResponseCallback(HttpOperation op, ViewConnection vconn, HttpHost host) {
        this.op = op;
        this.vconn = vconn;
        this.host = host;
    }

    @Override
    public void completed(HttpResponse response) {
        try {
            response.setEntity(new BufferedHttpEntity(response.getEntity()));
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not convert HttpEntity content.");
        }
        int statusCode = response.getStatusLine().getStatusCode();
        boolean shouldRetry = HttpResponseCallback.shouldRetry(statusCode, response);
        if (shouldRetry) {
            LOGGER.debug("Operation returned, but needs to be retried because of: " + response.getStatusLine());
            this.retryOperation(this.op);
        } else {
            this.op.handleResponse(response);
        }
    }

    private void retryOperation(HttpOperation op) {
        if (!op.isTimedOut() && !op.isCancelled()) {
            LOGGER.debug("Retrying HTTP operation from node (" + this.host.toHostString() + "), Request: " + op.getRequest().getRequestLine());
            this.vconn.addOp(op);
        }
    }

    @Override
    public void failed(Exception e) {
        if (e instanceof SocketTimeoutException) {
            this.retryOperation(this.op);
        } else if (e instanceof ConnectionClosedException || e instanceof ConnectException) {
            this.retryOperation(this.op);
            this.vconn.signalOutdatedConfig();
        } else {
            LOGGER.info((Object)("View Operation " + this.op.getRequest().getRequestLine() + " failed because of: "), e);
            this.op.cancel();
        }
    }

    @Override
    public void cancelled() {
        LOGGER.info("View Operation " + this.op.getRequest().getRequestLine() + " got cancelled.");
        this.op.cancel();
    }

    private static boolean shouldRetry(int statusCode, HttpResponse response) {
        switch (statusCode) {
            case 200: {
                return false;
            }
            case 404: {
                return HttpResponseCallback.analyse404Response(response);
            }
            case 500: {
                return HttpResponseCallback.analyse500Response(response);
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 401: 
            case 408: 
            case 409: 
            case 412: 
            case 416: 
            case 417: 
            case 501: 
            case 502: 
            case 503: 
            case 504: {
                return true;
            }
        }
        return false;
    }

    private static boolean analyse404Response(HttpResponse response) {
        try {
            String body = EntityUtils.toString(response.getEntity());
            if (body.contains("not_found") && (body.contains("missing") || body.contains("deleted"))) {
                LOGGER.debug("Design Document not found, body: " + body);
                return false;
            }
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    private static boolean analyse500Response(HttpResponse response) {
        try {
            String body = EntityUtils.toString(response.getEntity());
            if (body.contains("error") && body.contains("{not_found, missing_named_view}")) {
                LOGGER.debug("Design Document not found, body: " + body);
                return false;
            }
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }
}

