pub mod runtime_arch;
pub mod cli_host;

mod dialogs_const;
mod dialogs_common;
#[cfg(target_os = "windows")]
mod dialogs_windows;
#[cfg(target_os = "macos")]
mod dialogs_osx;
#[cfg(target_os = "linux")]
mod dialogs_linux;

pub mod dialogs {
    pub use super::dialogs_const::*;
    pub use super::dialogs_common::*;
    #[cfg(target_os = "windows")]
    pub use super::dialogs_windows::*;
    #[cfg(target_os = "macos")]
    pub use super::dialogs_osx::*;
    #[cfg(target_os = "linux")]
    pub use super::dialogs_linux::*;
}

mod util_common;
pub use util_common::*;

#[cfg(target_os = "windows")]
mod util_windows;
#[cfg(target_os = "windows")]
pub use util_windows::*;

#[cfg(target_os = "macos")]
mod util_osx;
#[cfg(target_os = "macos")]
pub use util_osx::*;

#[cfg(target_os = "linux")]
mod util_linux;
#[cfg(target_os = "linux")]
pub use util_linux::*;
