# Generated by Django 5.0.6 on 2024-07-07 14:38
import uuid

import django.contrib.postgres.indexes
import django.db.models.deletion
import django.db.models.manager
import parler.fields
import parler.models
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="Tag",
            fields=[
                (
                    "sort_order",
                    models.IntegerField(
                        db_index=True,
                        editable=False,
                        null=True,
                        verbose_name="Sort Order",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created At"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Updated At"),
                ),
                (
                    "uuid",
                    models.UUIDField(default=uuid.uuid4, editable=False, unique=True),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("active", models.BooleanField(default=True, verbose_name="Active")),
            ],
            options={
                "verbose_name": "Blog Tag",
                "verbose_name_plural": "Blog Tags",
                "ordering": ["sort_order"],
                "indexes": [
                    django.contrib.postgres.indexes.BTreeIndex(
                        fields=["created_at"], name="tag_created_at_idx"
                    ),
                    django.contrib.postgres.indexes.BTreeIndex(
                        fields=["updated_at"], name="tag_updated_at_idx"
                    ),
                    django.contrib.postgres.indexes.BTreeIndex(
                        fields=["sort_order"], name="tag_sort_order_idx"
                    ),
                    django.contrib.postgres.indexes.BTreeIndex(
                        fields=["active"], name="tag_tag_active_5d272a_btree"
                    ),
                ],
            },
            bases=(parler.models.TranslatableModelMixin, models.Model),
            managers=[
                ("active_tags", django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="TaggedItem",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created At"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Updated At"),
                ),
                (
                    "uuid",
                    models.UUIDField(default=uuid.uuid4, editable=False, unique=True),
                ),
                ("object_id", models.PositiveIntegerField()),
                (
                    "content_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "tag",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="tag.tag"
                    ),
                ),
            ],
            options={
                "verbose_name": "Tagged Item",
                "verbose_name_plural": "Tagged Items",
                "indexes": [
                    models.Index(
                        fields=["content_type", "object_id"],
                        name="tag_taggedi_content_cd6f88_idx",
                    )
                ],
            },
        ),
        migrations.CreateModel(
            name="TagTranslation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "language_code",
                    models.CharField(
                        db_index=True, max_length=15, verbose_name="Language"
                    ),
                ),
                (
                    "label",
                    models.CharField(
                        blank=True, max_length=255, null=True, verbose_name="Label"
                    ),
                ),
                (
                    "master",
                    parler.fields.TranslationsForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="tag.tag",
                    ),
                ),
            ],
            options={
                "verbose_name": "Blog Tag Translation",
                "db_table": "tag_tag_translation",
                "db_tablespace": "",
                "managed": True,
                "default_permissions": (),
                "unique_together": {("language_code", "master")},
            },
            bases=(parler.models.TranslatedFieldsModelMixin, models.Model),
        ),
    ]
