# Generated by Django 5.0.8 on 2024-08-18 19:17
import uuid
from decimal import Decimal

import django.core.serializers.json
import django.db.models.deletion
import djmoney.models.fields
import measurement.measures.mass
import mptt.fields
import simple_history.models
from django.conf import settings
from django.db import migrations
from django.db import models

import core.fields.measurement
import core.weight


class Migration(migrations.Migration):
    dependencies = [
        ("product", "0016_remove_product_product_pro_final_p_0230ad_btree_and_more"),
        ("vat", "0004_alter_vat_value"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.AddField(
            model_name="product",
            name="changed_by",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="changed_products",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.CreateModel(
            name="HistoricalProduct",
            fields=[
                (
                    "created_at",
                    models.DateTimeField(
                        blank=True, editable=False, verbose_name="Created At"
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        blank=True, editable=False, verbose_name="Updated At"
                    ),
                ),
                (
                    "uuid",
                    models.UUIDField(db_index=True, default=uuid.uuid4, editable=False),
                ),
                (
                    "private_metadata",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=django.core.serializers.json.DjangoJSONEncoder,
                    ),
                ),
                (
                    "metadata",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=django.core.serializers.json.DjangoJSONEncoder,
                    ),
                ),
                ("deleted_at", models.DateTimeField(blank=True, null=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "seo_title",
                    models.CharField(
                        blank=True, max_length=70, null=True, verbose_name="Seo Title"
                    ),
                ),
                (
                    "seo_description",
                    models.TextField(
                        blank=True,
                        max_length=300,
                        null=True,
                        verbose_name="Seo Description",
                    ),
                ),
                (
                    "seo_keywords",
                    models.CharField(
                        blank=True,
                        max_length=255,
                        null=True,
                        verbose_name="Seo Keywords",
                    ),
                ),
                ("id", models.BigIntegerField(blank=True, db_index=True)),
                (
                    "product_code",
                    models.CharField(
                        db_index=True,
                        default=uuid.uuid4,
                        max_length=100,
                        verbose_name="Product Code",
                    ),
                ),
                ("slug", models.SlugField(max_length=255, verbose_name="Slug")),
                (
                    "price_currency",
                    djmoney.models.fields.CurrencyField(
                        choices=[("EUR", "EUR €"), ("USD", "USD $")],
                        default="EUR",
                        editable=False,
                        max_length=3,
                    ),
                ),
                (
                    "price",
                    djmoney.models.fields.MoneyField(
                        decimal_places=2,
                        default=Decimal("0"),
                        max_digits=11,
                        verbose_name="Price",
                    ),
                ),
                ("active", models.BooleanField(default=True, verbose_name="Active")),
                ("stock", models.PositiveIntegerField(default=0, verbose_name="Stock")),
                (
                    "discount_percent",
                    models.DecimalField(
                        decimal_places=2,
                        default=Decimal("0"),
                        max_digits=11,
                        verbose_name="Discount Percent",
                    ),
                ),
                (
                    "view_count",
                    models.PositiveBigIntegerField(
                        default=0, verbose_name="View Count"
                    ),
                ),
                (
                    "weight",
                    core.fields.measurement.MeasurementField(
                        default=core.weight.zero_weight,
                        measurement=measurement.measures.mass.Mass,
                        verbose_name="Weight",
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "category",
                    mptt.fields.TreeForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="product.productcategory",
                    ),
                ),
                (
                    "changed_by",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "vat",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="vat.vat",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Product",
                "verbose_name_plural": "historical Products",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
