# Generated by Django 4.2.9 on 2024-02-10 14:39
import uuid
from decimal import Decimal

import django.contrib.postgres.search
import django.core.serializers.json
import django.core.validators
import django.db.models.deletion
import djmoney.models.fields
import parler.fields
import parler.models
import tinymce.models
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Product",
            fields=[
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created At"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Updated At"),
                ),
                (
                    "uuid",
                    models.UUIDField(default=uuid.uuid4, editable=False, unique=True),
                ),
                (
                    "private_metadata",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=django.core.serializers.json.DjangoJSONEncoder,
                    ),
                ),
                (
                    "metadata",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=django.core.serializers.json.DjangoJSONEncoder,
                    ),
                ),
                ("deleted_at", models.DateTimeField(blank=True, null=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "seo_title",
                    models.CharField(
                        blank=True,
                        max_length=70,
                        null=True,
                        verbose_name="Seo Title",
                    ),
                ),
                (
                    "seo_description",
                    models.TextField(
                        blank=True,
                        max_length=300,
                        null=True,
                        verbose_name="Seo Description",
                    ),
                ),
                (
                    "seo_keywords",
                    models.CharField(
                        blank=True,
                        max_length=255,
                        null=True,
                        verbose_name="Seo Keywords",
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "product_code",
                    models.CharField(
                        default=uuid.uuid4,
                        max_length=100,
                        unique=True,
                        verbose_name="Product Code",
                    ),
                ),
                (
                    "slug",
                    models.SlugField(max_length=255, unique=True, verbose_name="Slug"),
                ),
                (
                    "price_currency",
                    djmoney.models.fields.CurrencyField(
                        choices=[("EUR", "EUR €"), ("USD", "USD $")],
                        default="EUR",
                        editable=False,
                        max_length=3,
                    ),
                ),
                (
                    "price",
                    djmoney.models.fields.MoneyField(
                        decimal_places=2,
                        default=Decimal("0"),
                        max_digits=11,
                        verbose_name="Price",
                    ),
                ),
                (
                    "active",
                    models.BooleanField(default=True, verbose_name="Active"),
                ),
                (
                    "stock",
                    models.PositiveIntegerField(default=0, verbose_name="Stock"),
                ),
                (
                    "discount_percent",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        max_digits=11,
                        validators=[
                            django.core.validators.MinValueValidator(0.0),
                            django.core.validators.MaxValueValidator(100.0),
                        ],
                        verbose_name="Discount Percent",
                    ),
                ),
                (
                    "hits",
                    models.PositiveIntegerField(default=0, verbose_name="Hits"),
                ),
                (
                    "weight",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        max_digits=11,
                        verbose_name="Weight (kg)",
                    ),
                ),
                (
                    "final_price_currency",
                    djmoney.models.fields.CurrencyField(
                        choices=[("EUR", "EUR €"), ("USD", "USD $")],
                        default="EUR",
                        editable=False,
                        max_length=3,
                    ),
                ),
                (
                    "final_price",
                    djmoney.models.fields.MoneyField(
                        decimal_places=2,
                        default=Decimal("0"),
                        editable=False,
                        max_digits=11,
                        verbose_name="Final Price",
                    ),
                ),
                (
                    "discount_value_currency",
                    djmoney.models.fields.CurrencyField(
                        choices=[("EUR", "EUR €"), ("USD", "USD $")],
                        default="EUR",
                        editable=False,
                        max_length=3,
                    ),
                ),
                (
                    "discount_value",
                    djmoney.models.fields.MoneyField(
                        decimal_places=2,
                        default=Decimal("0"),
                        editable=False,
                        max_digits=11,
                        verbose_name="Discount Value",
                    ),
                ),
                (
                    "price_save_percent",
                    models.DecimalField(
                        decimal_places=2,
                        default=0.0,
                        editable=False,
                        max_digits=11,
                        verbose_name="Price Save Percent",
                    ),
                ),
                (
                    "search_vector",
                    django.contrib.postgres.search.SearchVectorField(
                        blank=True, null=True
                    ),
                ),
            ],
            options={
                "verbose_name": "Product",
                "verbose_name_plural": "Products",
                "ordering": ["-created_at"],
                "abstract": False,
            },
            bases=(parler.models.TranslatableModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name="ProductCategory",
            fields=[
                (
                    "sort_order",
                    models.IntegerField(
                        db_index=True,
                        editable=False,
                        null=True,
                        verbose_name="Sort Order",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created At"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Updated At"),
                ),
                (
                    "uuid",
                    models.UUIDField(default=uuid.uuid4, editable=False, unique=True),
                ),
                (
                    "seo_title",
                    models.CharField(
                        blank=True,
                        max_length=70,
                        null=True,
                        verbose_name="Seo Title",
                    ),
                ),
                (
                    "seo_description",
                    models.TextField(
                        blank=True,
                        max_length=300,
                        null=True,
                        verbose_name="Seo Description",
                    ),
                ),
                (
                    "seo_keywords",
                    models.CharField(
                        blank=True,
                        max_length=255,
                        null=True,
                        verbose_name="Seo Keywords",
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "slug",
                    models.SlugField(max_length=255, unique=True, verbose_name="Slug"),
                ),
                (
                    "menu_image_one",
                    models.ImageField(
                        blank=True,
                        null=True,
                        upload_to="uploads/categories/",
                        verbose_name="Menu Image One",
                    ),
                ),
                (
                    "menu_image_two",
                    models.ImageField(
                        blank=True,
                        null=True,
                        upload_to="uploads/categories/",
                        verbose_name="Menu Image Two",
                    ),
                ),
                (
                    "menu_main_banner",
                    models.ImageField(
                        blank=True,
                        null=True,
                        upload_to="uploads/categories/",
                        verbose_name="Menu Main Banner",
                    ),
                ),
                ("lft", models.PositiveIntegerField(editable=False)),
                ("rght", models.PositiveIntegerField(editable=False)),
                (
                    "tree_id",
                    models.PositiveIntegerField(db_index=True, editable=False),
                ),
                ("level", models.PositiveIntegerField(editable=False)),
            ],
            options={
                "verbose_name": "Product Category",
                "verbose_name_plural": "Product Categories",
                "ordering": ["sort_order"],
            },
            bases=(parler.models.TranslatableModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name="ProductCategoryTranslation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "language_code",
                    models.CharField(
                        db_index=True, max_length=15, verbose_name="Language"
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True,
                        max_length=255,
                        null=True,
                        verbose_name="Name",
                    ),
                ),
                (
                    "description",
                    tinymce.models.HTMLField(
                        blank=True, null=True, verbose_name="Description"
                    ),
                ),
            ],
            options={
                "verbose_name": "Product Category Translation",
                "db_table": "product_productcategory_translation",
                "db_tablespace": "",
                "managed": True,
                "default_permissions": (),
            },
            bases=(parler.models.TranslatedFieldsModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name="ProductFavourite",
            fields=[
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created At"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Updated At"),
                ),
                (
                    "uuid",
                    models.UUIDField(default=uuid.uuid4, editable=False, unique=True),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
            ],
            options={
                "verbose_name": "Product Favourite",
                "verbose_name_plural": "Product Favourites",
                "ordering": ["-updated_at"],
            },
        ),
        migrations.CreateModel(
            name="ProductImage",
            fields=[
                (
                    "sort_order",
                    models.IntegerField(
                        db_index=True,
                        editable=False,
                        null=True,
                        verbose_name="Sort Order",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created At"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Updated At"),
                ),
                (
                    "uuid",
                    models.UUIDField(default=uuid.uuid4, editable=False, unique=True),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "image",
                    models.ImageField(
                        upload_to="uploads/products/", verbose_name="Image"
                    ),
                ),
                (
                    "thumbnail",
                    models.ImageField(
                        blank=True,
                        null=True,
                        upload_to="uploads/products/thumbnails/",
                        verbose_name="Thumbnail",
                    ),
                ),
                (
                    "is_main",
                    models.BooleanField(default=False, verbose_name="Is Main"),
                ),
            ],
            options={
                "verbose_name": "Product Image",
                "verbose_name_plural": "Product Images",
                "ordering": ["sort_order"],
            },
            bases=(parler.models.TranslatableModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name="ProductImageTranslation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "language_code",
                    models.CharField(
                        db_index=True, max_length=15, verbose_name="Language"
                    ),
                ),
                (
                    "title",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="Title",
                    ),
                ),
            ],
            options={
                "verbose_name": "Product Image Translation",
                "db_table": "product_productimage_translation",
                "db_tablespace": "",
                "managed": True,
                "default_permissions": (),
            },
            bases=(parler.models.TranslatedFieldsModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name="ProductReview",
            fields=[
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created At"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Updated At"),
                ),
                (
                    "uuid",
                    models.UUIDField(default=uuid.uuid4, editable=False, unique=True),
                ),
                (
                    "published_at",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="Published At"
                    ),
                ),
                (
                    "is_published",
                    models.BooleanField(default=False, verbose_name="Is Published"),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "rate",
                    models.PositiveSmallIntegerField(
                        choices=[
                            (1, "One"),
                            (2, "Two"),
                            (3, "Three"),
                            (4, "Four"),
                            (5, "Five"),
                            (6, "Six"),
                            (7, "Seven"),
                            (8, "Eight"),
                            (9, "Nine"),
                            (10, "Ten"),
                        ],
                        verbose_name="Rate",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("NEW", "New"),
                            ("TRUE", "True"),
                            ("FALSE", "False"),
                        ],
                        default="NEW",
                        max_length=250,
                        verbose_name="Status",
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="product_review_product",
                        to="product.product",
                    ),
                ),
            ],
            options={
                "verbose_name": "Product Review",
                "verbose_name_plural": "Product Reviews",
                "ordering": ["-created_at"],
            },
            bases=(parler.models.TranslatableModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name="ProductTranslation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "language_code",
                    models.CharField(
                        db_index=True, max_length=15, verbose_name="Language"
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        max_length=255,
                        null=True,
                        verbose_name="Name",
                    ),
                ),
                (
                    "description",
                    tinymce.models.HTMLField(
                        blank=True,
                        db_index=True,
                        null=True,
                        verbose_name="Description",
                    ),
                ),
                (
                    "master",
                    parler.fields.TranslationsForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="product.product",
                    ),
                ),
            ],
            options={
                "verbose_name": "Product Translation",
                "db_table": "product_product_translation",
                "db_tablespace": "",
                "managed": True,
                "default_permissions": (),
            },
            bases=(parler.models.TranslatedFieldsModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name="ProductReviewTranslation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "language_code",
                    models.CharField(
                        db_index=True, max_length=15, verbose_name="Language"
                    ),
                ),
                (
                    "comment",
                    models.TextField(blank=True, null=True, verbose_name="Comment"),
                ),
                (
                    "master",
                    parler.fields.TranslationsForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="translations",
                        to="product.productreview",
                    ),
                ),
            ],
            options={
                "verbose_name": "Product Review Translation",
                "db_table": "product_productreview_translation",
                "db_tablespace": "",
                "managed": True,
                "default_permissions": (),
            },
            bases=(parler.models.TranslatedFieldsModelMixin, models.Model),
        ),
    ]
