# Generated by Django 5.1 on 2024-08-24 22:51
import django.core.validators
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):
    dependencies = [
        ("country", "0004_alter_country_options"),
    ]

    operations = [
        migrations.AlterField(
            model_name="country",
            name="alpha_2",
            field=models.CharField(
                max_length=2,
                primary_key=True,
                serialize=False,
                unique=True,
                validators=[
                    django.core.validators.RegexValidator(
                        message="Enter a valid 2-letter country code.",
                        regex="^[A-Z]{2}$",
                    )
                ],
                verbose_name="Country Code Alpha 2",
            ),
        ),
        migrations.AlterField(
            model_name="country",
            name="alpha_3",
            field=models.CharField(
                max_length=3,
                unique=True,
                validators=[
                    django.core.validators.RegexValidator(
                        message="Enter a valid 3-letter country code.",
                        regex="^[A-Z]{3}$",
                    )
                ],
                verbose_name="Country Code Alpha 3",
            ),
        ),
        migrations.AlterField(
            model_name="country",
            name="sort_order",
            field=models.IntegerField(
                editable=False, null=True, verbose_name="Sort Order"
            ),
        ),
        migrations.AddIndex(
            model_name="country",
            index=models.Index(
                fields=["alpha_2"], name="country_cou_alpha_2_398383_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="country",
            index=models.Index(
                fields=["alpha_3"], name="country_cou_alpha_3_c813cd_idx"
            ),
        ),
    ]
