const mongoose = require('mongoose');
const fs = require('fs');
const dotevn = require('dotenv');

const Tour = require('../../models/tour-model');
const User = require('../../models/user-model');
const Review = require('../../models/review-model');

dotevn.config({
  path: '../../config.env',
});

const database = process.env.DATABASE.replace(
  '<PASSWORD>',
  process.env.DATABASE_PASSWORD
);

mongoose
  .connect(database, {
    useNewUrlParser: true,
    useCreateIndex: true,
    useFindAndModify: false,
    useUnifiedTopology: true,
  })
  .then(() => console.log(`Database connected successfully!`));

const tours = JSON.parse(
  fs.readFileSync(`${__dirname}/tours-imagekit.json`, 'utf-8')
);
const users = JSON.parse(
  fs.readFileSync(`${__dirname}/users-imagekit.json`, 'utf-8')
);
const reviews = JSON.parse(
  fs.readFileSync(`${__dirname}/reviews.json`, 'utf-8')
);

// IMPORT DATA AND STORE IN DATABASE -
const importData = async () => {
  try {
    // await Tour.create(tours);
    await User.create(users, { validateBeforeSave: false });
    // await Review.create(reviews);
    console.log(`Data successfully loaded!`);
  } catch (error) {
    console.log(error);
  }
  process.exit();
};

// DELETE DATA FROM DATABASE -
const deleteData = async () => {
  try {
    await Tour.deleteMany();
    await User.deleteMany();
    await Review.deleteMany();
    console.log(`All data deleted successfully!`);
  } catch (error) {
    console.log(error);
  }
  process.exit();
};

if (process.argv[2] === '--import') {
  importData();
} else if (process.argv[2] === '--delete') {
  deleteData();
}
