/*
 * Copyright 2018, gRPC Authors All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import Dispatch
import Foundation
import SwiftProtobuf

public enum HandleMethodError: Error {
  case unknownMethod
}

// Helper protocol to let one `ServiceServer` serve multiple gRPC services.
// Implementations for these methods are usually provided by the code generated by our protoc plugin.
public protocol ServiceProvider {
  // The name of the service (including package names) provided by this object, e.g. "echo.Echo".
  var serviceName: String { get }
  
  /// Handle the given method. Needs to be overridden by actual implementations.
  func handleMethod(_ method: String, handler: Handler) throws -> ServerStatus?
}
