[![Build Status](https://travis-ci.org/grpc/grpc-swift.svg?branch=master)](https://travis-ci.org/grpc/grpc-swift)

# Swift gRPC

This repository contains an experimental Swift gRPC API
and code generator.

It is intended for use with Apple's
[swift-protobuf](https://github.com/apple/swift-protobuf)
support for Protocol Buffers. Both projects contain
code generation plugins for `protoc`, Google's
Protocol Buffer compiler, and both contain libraries
of supporting code that is needed to build and run
the generated code.

APIs and generated code is provided for both gRPC clients
and servers, and can be built either with Xcode or the Swift
Package Manager. Support is provided for all four gRPC
API styles (Unary, Server Streaming, Client Streaming,
and Bidirectional Streaming) and connections can be made
either over secure (TLS) or insecure channels.

The [Echo](Examples/EchoXcode/Echo) example provides a comprehensive
demonstration of currently-supported features.

Swift Package Manager builds may also be made on Linux
systems. Please see [DOCKER.md](DOCKER.md) and
[LINUX.md](LINUX.md) for details.

## CocoaPods integration

Swift gRPC is currently available [from CocoaPods](https://cocoapods.org/pods/SwiftGRPC).
To integrate, add the following line to your `Podfile`:

    pod 'SwiftGRPC'

Then, run `pod install` from command line and use your project's generated
`.xcworkspace` file.

## Manual integration

When not using CocoaPods, Swift gRPC includes **vendored copies** of the
gRPC Core library and BoringSSL (an OpenSSL fork that is used by
the gRPC Core). These are built automatically in Swift Package
Manager builds.

After [building your project](#building-your-project), add the generated
`SwiftGRPC.xcodeproj` to your project, and add build dependencies
on **BoringSSL**, **CgRPC**, and **SwiftGRPC**.

Please also note that your project will need to include the
`SwiftProtobuf.xcodeproj` from
[Swift Protobuf](https://github.com/apple/swift-protobuf) and
the source files that you generate with `protoc`/[plugins](#getting-the-plugins).

See [Echo](Examples/EchoXcode) for a working Xcode-based
example, and don't hesitate to file issues if you find any problems.

## Usage

The recommended way to use Swift gRPC is to first define an API using the
[Protocol Buffer](https://developers.google.com/protocol-buffers/)
language and then use the
[Protocol Buffer Compiler](https://github.com/google/protobuf)
and the [Swift Protobuf](https://github.com/apple/swift-protobuf)
and [Swift gRPC](https://github.com/grpc/grpc-swift) plugins to
generate the necessary support code.

### Getting the plugins

Binary releases of `protoc`, the Protocol Buffer Compiler, are
available on [GitHub](https://github.com/google/protobuf/releases).

To build the plugins, run `make` in the main directory.
This uses the Swift Package Manager to build both of the necessary
plugins: `protoc-gen-swift`, which generates Protocol Buffer support code
and `protoc-gen-swiftgrpc`, which generates gRPC interface code.

### Using the plugins

To use the plugins, `protoc` and both plugins should be in your
search path. Invoke them with commands like the following:

    protoc <your proto files> \
        --swift_out=. \
        --swiftgrpc_out=.

By convention the `--swift_out` option invokes the `protoc-gen-swift`
plugin and `--swiftgrpc_out` invokes `protoc-gen-swiftgrpc`.

#### Parameters
To pass extra parameters to the plugin, use a comma-separated parameter list
separated from the output directory by a colon.

| Flag | Values | Default | Description |
|:-|:-|:-|:-|
| `Visibility` | `Internal`/`Public` | `Internal` | ACL of generated code |
| `Server` |  `true`/`false` | `true` | Whether to generate server code |
| `Client` |  `true`/`false` | `true` | Whether to generate client code |
| `TestStubs` |  `true`/`false` | `false` | Whether to generate test stub code |

Example:

    $ protoc <your proto> --swiftgrpc_out=Client=true,Server=false:.

### Building your project

Most `grpc-swift` development is done with the Swift Package Manager.
For usage in Xcode projects, we rely on the `swift package generate-xcodeproj`
command to generate an Xcode project for the `grpc-swift` core libraries.

The top-level Makefile uses the Swift Package Manager to
generate an Xcode project for the SwiftGRPC package:

    $ make && make project

This will create `SwiftGRPC.xcodeproj`, which you should
add to your project, along with setting the necessary build dependencies
mentioned [above](#manual-integration).

### Low-level gRPC

While the recommended way to use gRPC is with Protocol Buffers
and generated code, at its core gRPC is a powerful HTTP/2-based
communication system that can support arbitrary payloads. As such,
each gRPC library includes low-level interfaces that can be used
to directly build API clients and servers with no generated code.
For an example of this in Swift, please see the
[Simple](Examples/SimpleXcode) example.

## Having build problems?

grpc-swift depends on Swift, Xcode, and swift-protobuf. We are currently
testing with the following versions:

- Xcode 9.1
- Swift 4.0
- swift-protobuf 1.1.1

## License

grpc-swift is released under the same license as
[gRPC](https://github.com/grpc/grpc), repeated in
[LICENSE](LICENSE).

## Contributing

Please get involved! See our [guidelines for contributing](CONTRIBUTING.md).

### Releasing

Prior to creating a new release tag for SwiftGRPC, the `.podspec` file's version should be bumped, and the
CocoaPods spec linter should be run to ensure that there are no new warnings/errors:

    $ pod spec lint SwiftGRPC.podspec

Once a new release tag is created, the updated CocoaPods spec should also be pushed to the master specs repo:

    $ pod trunk push SwiftGRPC.podspec
