# Contributing to validator.js
Welcome to validator.js repository!! We appreciate your interest in contributing to this open library and for helping our community grow. 

## How to Contribute
### Code Contribution
In general, we follow the "fork-and-pull" Git workflow.

1. [Fork](https://docs.github.com/en/get-started/exploring-projects-on-github/contributing-to-a-project) the repository on GitHub
2. Clone the project to your local machine
3. Work on your fork
    * Make your changes and additions
        - Most of your changes should be focused on src/ and test/ folders and/or [README.md](https://github.com/validatorjs/validator.js/blob/master/README.md).
        - Files such as validator.js, validator.min.js and files in lib/ folder are autogenerated when running tests (npm test) and need not to be changed **manually**.
    * Change or add tests if needed
    * Run tests and make sure they pass
    * Add changes to README.md if needed
4. Commit changes to your own branch
5. **Make sure** you merge the latest from "upstream" and resolve conflicts if there is any
6. Repeat step 3(3) above
7. Push your work back up to your fork
8. Submit a Pull request so that we can review your changes

#### Run Tests
Tests are using mocha. To run the tests use:

```sh
$ npm test
```

### Financial Contribution
We welcome financial contributions on our [open collective](https://opencollective.com/validatorjs).

You can opt to become a [backer](https://opencollective.com/validatorjs#backer) or a [sponsor](https://opencollective.com/validatorjs#sponsor) and help our project sustain over time.

Thank you to the people who have already contributed:

<a href="https://github.com/validatorjs/validator.js/graphs/contributors"><img src="https://opencollective.com/validatorjs/contributors.svg?width=890" /></a>