# awesome-mobile-security ![awesome](https://awesome.re/badge.svg)


Maintained by [@vaib25vicky](https://twitter.com/vaib25vicky) with contributions from the security and developer communities.
 

## Android

### General - Blogs, Papers, How To's

* [Android: Gaining access to arbitrary* Content Providers](https://blog.oversecured.com/Gaining-access-to-arbitrary-Content-Providers/)
* [Evernote: Universal-XSS, theft of all cookies from all sites, and more](https://blog.oversecured.com/Evernote-Universal-XSS-theft-of-all-cookies-from-all-sites-and-more/)
* [Interception of Android implicit intents](https://blog.oversecured.com/Interception-of-Android-implicit-intents/)
* [TikTok: three persistent arbitrary code executions and one theft of arbitrary files](https://blog.oversecured.com/Oversecured-detects-dangerous-vulnerabilities-in-the-TikTok-Android-app/)
* [Persistent arbitrary code execution in Android's Google Play Core Library: details, explanation and the PoC - CVE-2020-8913](https://blog.oversecured.com/Oversecured-automatically-discovers-persistent-code-execution-in-the-Google-Play-Core-Library/)
* [Android: Access to app protected components](https://blog.oversecured.com/Android-Access-to-app-protected-components/)
* [Android: arbitrary code execution via third-party package contexts](https://blog.oversecured.com/Android-arbitrary-code-execution-via-third-party-package-contexts/)
* [Android Pentesting Labs - Step by Step guide for beginners](https://medium.com/bugbountywriteup/android-pentesting-lab-4a6fe1a1d2e0)
* [An Android Hacking Primer](https://medium.com/swlh/an-android-hacking-primer-3390fef4e6a0)
* [Secure an Android Device](https://source.android.com/security)
* [Security tips](https://developer.android.com/training/articles/security-tips)
* [OWASP Mobile Security Testing Guide](https://www.owasp.org/index.php/OWASP_Mobile_Security_Testing_Guide)
* [Security Testing for Android Cross Platform Application](https://3xpl01tc0d3r.blogspot.com/2019/09/security-testing-for-android-app-part1.html)
* [Dive deep into Android Application Security](https://blog.0daylabs.com/2019/09/18/deep-dive-into-Android-security/)
* [Pentesting Android Apps Using Frida](https://www.notsosecure.com/pentesting-android-apps-using-frida/)
* [Mobile Security Testing Guide](https://mobile-security.gitbook.io/mobile-security-testing-guide/)
* [Mobile Application Penetration Testing Cheat Sheet](https://github.com/sh4hin/MobileApp-Pentest-Cheatsheet)
* [Android Applications Reversing 101](https://www.evilsocket.net/2017/04/27/Android-Applications-Reversing-101/#.WQND0G3TTOM.reddit)
* [Android Security Guidelines](https://developer.box.com/en/guides/security/)
* [Android WebView Vulnerabilities](https://pentestlab.blog/2017/02/12/android-webview-vulnerabilities/)
* [OWASP Mobile Top 10](https://www.owasp.org/index.php/OWASP_Mobile_Top_10)
* [Practical Android Phone Forensics](https://resources.infosecinstitute.com/practical-android-phone-forensics/)
* [Mobile Reverse Engineering Unleashed](http://www.vantagepoint.sg/blog/83-mobile-reverse-engineering-unleashed)
* [Android Root Detection Bypass Using Objection and Frida Scripts](https://medium.com/@GowthamR1/android-root-detection-bypass-using-objection-and-frida-scripts-d681d30659a7)
* [quark-engine - An Obfuscation-Neglect Android Malware Scoring System](https://github.com/quark-engine/quark-engine)
* [Root Detection Bypass By Manual Code Manipulation.](https://medium.com/@sarang6489/root-detection-bypass-by-manual-code-manipulation-5478858f4ad1)
* [Application and Network Usage in Android](https://www.sans.org/cyber-security-summit/archives/file/summit-archive-1528491463.pdf)
* [GEOST BOTNET - the discovery story of a new Android banking trojan](http://public.avast.com/research/VB2019-Garcia-etal.pdf)
* [Mobile Pentesting With Frida](https://drive.google.com/file/d/1JccmMLi6YTnyRrp_rk6vzKrUX3oXK_Yw/view)
* [Magisk Systemless Root - Detection and Remediation](https://www.mobileiron.com/en/blog/magisk-android-rooting)
* [AndrODet: An adaptive Android obfuscation detector](https://arxiv.org/pdf/1910.06192.pdf)
* [Hands On Mobile API Security](https://hackernoon.com/hands-on-mobile-api-security-get-rid-of-client-secrets-a79f111b6844)
* [Zero to Hero - Mobile Application Testing - Android Platform](https://nileshsapariya.blogspot.com/2016/11/zero-to-hero-mobile-application-testing.html)
* [How to use FRIDA to bruteforce Secure Startup with FDE-encryption on a Samsung G935F running Android 8](https://github.com/Magpol/fridafde)
* [Android Malware Adventures](https://docs.google.com/presentation/d/1pYB522E71hXrp4m3fL3E3fnAaOIboJKqpbyE5gSsOes/edit)
* [AAPG - Android application penetration testing guide](https://nightowl131.github.io/AAPG/)
* [Bypassing Android Anti-Emulation](https://www.juanurs.com/Bypassing-Android-Anti-Emulation-Part-I/)
* [Bypassing Xamarin Certificate Pinning](https://www.gosecure.net/blog/2020/04/06/bypassing-xamarin-certificate-pinning-on-android/)
* [Configuring Burp Suite With Android Nougat](https://blog.ropnop.com/configuring-burp-suite-with-android-nougat/)

    
### Books

 * [SEI CERT Android Secure Coding Standard](https://www.securecoding.cert.org/confluence/display/android/Android+Secure+Coding+Standard)
 * [Android Security Internals](https://www.oreilly.com/library/view/android-security-internals/9781457185496/)
 * [Android Cookbook](https://androidcookbook.com/)
 * [Android Hacker's Handbook](https://www.amazon.com/Android-Hackers-Handbook-Joshua-Drake/dp/111860864X)
 * [Android Security Cookbook](https://www.packtpub.com/in/application-development/android-security-cookbook)
 * [The Mobile Application Hacker's Handbook](https://www.amazon.in/Mobile-Application-Hackers-Handbook-ebook/dp/B00TSA6KLG)
 * [Android Malware and Analysis](https://www.oreilly.com/library/view/android-malware-and/9781482252200/)
 * [Android Security: Attacks and Defenses](https://www.crcpress.com/Android-Security-Attacks-and-Defenses/Misra-Dubey/p/book/9780367380182)
 
### Courses
 
* [Learning-Android-Security](https://www.lynda.com/Android-tutorials/Learning-Android-Security/689762-2.html)
* [Mobile Application Security and Penetration Testing](https://www.elearnsecurity.com/course/mobile_application_security_and_penetration_testing/)
* [Advanced Android Development](https://developer.android.com/courses/advanced-training/overview)
* [Learn the art of mobile app development](https://www.edx.org/professional-certificate/harvardx-computer-science-and-mobile-apps)
* [Learning Android Malware Analysis](https://www.linkedin.com/learning/learning-android-malware-analysis)
* [Android App Reverse Engineering 101](https://maddiestone.github.io/AndroidAppRE/)
* [Android Pentesting for Beginners](https://manifestsecurity.com/android-application-security/)
  
### Tools
     
#### Static Analysis

* [Amandroid – A Static Analysis Framework](http://pag.arguslab.org/argus-saf)
* [Androwarn – Yet Another Static Code Analyzer](https://github.com/maaaaz/androwarn/)
* [APK Analyzer – Static and Virtual Analysis Tool](https://github.com/sonyxperiadev/ApkAnalyser)
* [APK Inspector – A Powerful GUI Tool](https://github.com/honeynet/apkinspector/)
* [Droid Hunter – Android application vulnerability analysis and Android pentest tool](https://github.com/hahwul/droid-hunter)
* [Error Prone – Static Analysis Tool](https://github.com/google/error-prone)
* [Findbugs – Find Bugs in Java Programs](http://findbugs.sourceforge.net/downloads.html)
* [Find Security Bugs – A SpotBugs plugin for security audits of Java web applications.](https://github.com/find-sec-bugs/find-sec-bugs/)
* [Flow Droid – Static Data Flow Tracker](https://github.com/secure-software-engineering/FlowDroid)
* [Smali/Baksmali – Assembler/Disassembler for the dex format](https://github.com/JesusFreke/smali)
* [Smali-CFGs – Smali Control Flow Graph’s](https://github.com/EugenioDelfa/Smali-CFGs)
* [SPARTA – Static Program Analysis for Reliable Trusted Apps](https://www.cs.washington.edu/sparta)
* [Thresher – To check heap reachability properties](https://plv.colorado.edu/projects/thresher/)
* [Vector Attack Scanner – To search vulnerable points to attack](https://github.com/Sukelluskello/VectorAttackScanner)
* [Gradle Static Analysis Plugin](https://github.com/novoda/gradle-static-analysis-plugin)
* [Checkstyle – A tool for checking Java source code](https://github.com/checkstyle/checkstyle)
* [PMD – An extensible multilanguage static code analyzer](https://github.com/pmd/pmd)
* [Soot – A Java Optimization Framework](https://github.com/Sable/soot)
* [Android Quality Starter](https://github.com/pwittchen/android-quality-starter)
* [QARK – Quick Android Review Kit](https://github.com/linkedin/qark)
* [Infer – A Static Analysis tool for Java, C, C++ and Objective-C](https://github.com/facebook/infer)
* [Android Check – Static Code analysis plugin for Android Project](https://github.com/noveogroup/android-check)
* [FindBugs-IDEA Static byte code analysis to look for bugs in Java code](https://plugins.jetbrains.com/plugin/3847-findbugs-idea)
* [APK Leaks – Scanning APK file for URIs, endpoints & secrets](https://github.com/dwisiswant0/apkleaks)
      
#### Dynamic Analysis

* [Adhrit - Android Security Suite for in-depth reconnaissance and static bytecode analysis based on Ghera benchmarks](https://github.com/abhi-r3v0/Adhrit)
* [Android Hooker - Opensource project for dynamic analyses of Android applications](https://github.com/AndroidHooker/hooker)
* [AppAudit - Online tool ( including an API) uses dynamic and static analysis](http://appaudit.io/)
* [AppAudit - A bare-metal analysis tool on Android devices](https://github.com/ucsb-seclab/baredroid)
* [CuckooDroid - Extension of Cuckoo Sandbox the Open Source software](https://github.com/idanr1986/cuckoo-droid)
* [DroidBox - Dynamic analysis of Android applications](https://code.google.com/p/droidbox/)
* [Droid-FF - Android File Fuzzing Framework](https://github.com/antojoseph/droid-ff)
* [Drozer](https://www.mwrinfosecurity.com/products/drozer/)
* [Marvin - Analyzes Android applications and allows tracking of an app](https://github.com/programa-stic/marvin-django)
* [Inspeckage](https://github.com/ac-pm/Inspeckage)
* [PATDroid - Collection of tools and data structures for analyzing Android applications](https://github.com/mingyuan-xia/PATDroid)
* [AndroL4b - Android security virtual machine based on ubuntu-mate](https://github.com/sh4hin/Androl4b)
* [Radare2 - Unix-like reverse engineering framework and commandline tools](https://github.com/radareorg/radare2)
* [Cutter - Free and Open Source RE Platform powered by radare2](https://cutter.re/)
* [ByteCodeViewer - Android APK Reverse Engineering Suite (Decompiler, Editor, Debugger)](https://bytecodeviewer.com/)
* [Mobile-Security-Framework MobSF](https://github.com/MobSF/Mobile-Security-Framework-MobSF)
* [CobraDroid - Custom build of the Android operating system geared specifically for application security ](https://thecobraden.com/projects/cobradroid/)
* [Magisk v20.2 - Root & Universal Systemless Interface](https://forum.xda-developers.com/apps/magisk/official-magisk-v7-universal-systemless-t3473445)
* [Runtime Mobile Security (RMS) - is a powerful web interface that helps you to manipulate Android and iOS Apps at Runtime](https://github.com/m0bilesecurity/RMS-Runtime-Mobile-Security)
* [MOBEXLER - A Mobile Application Penetration Testing Platform](https://mobexler.com/)

        
#### Android Online APK Analyzers

* [Oversecured](https://oversecured.com/) - A static vulnerability scanner for Android apps (APK files) containing 90+ vulnerability categories
* [Android Observatory APK Scan](https://androidobservatory.org/upload)
* [Android APK Decompiler](http://www.decompileandroid.com/)
* [AndroTotal](http://andrototal.org/)
* [NVISO ApkScan](https://apkscan.nviso.be/)
* [VirusTotal](https://www.virustotal.com/#/home/upload)
* [Scan Your APK](https://scanyourapk.com/)
* [AVC Undroid](https://undroid.av-comparatives.org/index.php)
* [OPSWAT](https://metadefender.opswat.com/#!/)
* [ImmuniWeb Mobile App Scanner](https://www.htbridge.com/mobile/)
* [Ostor Lab](https://www.ostorlab.co/scan/mobile/)
* [Quixxi](https://quixxisecurity.com/)
* [TraceDroid](http://tracedroid.few.vu.nl/submit.php)
* [Visual Threat](http://www.visualthreat.com/UIupload.action)
* [App Critique](https://appcritique.boozallen.com/)
        
### Labs
  
* [OVAA (Oversecured Vulnerable Android App)](https://github.com/oversecured/ovaa)
* [DIVA (Damn insecure and vulnerable App)](https://github.com/payatu/diva-android)
* [SecurityShepherd](https://github.com/OWASP/SecurityShepherd)
* [Damn Vulnerable Hybrid Mobile App (DVHMA)](https://github.com/logicalhacking/DVHMA)
* [OWASP-mstg](https://github.com/OWASP/owasp-mstg/tree/master/Crackmes)
* [VulnerableAndroidAppOracle](https://github.com/dan7800/VulnerableAndroidAppOracle)
* [Android InsecureBankv2](https://github.com/dineshshetty/Android-InsecureBankv2)
* [Purposefully Insecure and Vulnerable Android Application (PIIVA)](https://github.com/htbridge/pivaa)
* [Sieve app](https://github.com/mwrlabs/drozer/releases/download/2.3.4/sieve.apk)
* [DodoVulnerableBank](https://github.com/CSPF-Founder/DodoVulnerableBank)
* [Digitalbank](https://github.com/CyberScions/Digitalbank)
* [OWASP GoatDroid](https://github.com/jackMannino/OWASP-GoatDroid-Project)
* [AppKnox Vulnerable Application](https://github.com/appknox/vulnerable-application)
* [Vulnerable Android Application](https://github.com/Lance0312/VulnApp)
* [MoshZuk](https://dl.dropboxusercontent.com/u/37776965/Work/MoshZuk.apk)
* [Hackme Bank](http://www.mcafee.com/us/downloads/free-tools/hacme-bank-android.aspx)
* [Android Security Labs](https://github.com/SecurityCompass/AndroidLabs)
* [Android-InsecureBankv2](https://github.com/dineshshetty/Android-InsecureBankv2)
* [Android-security](https://github.com/rafaeltoledo/android-security)
* [VulnDroid](https://github.com/shahenshah99/VulnDroid)
* [FridaLab](https://rossmarks.uk/blog/fridalab/)
* [Santoku Linux - Mobile Security VM](https://santoku-linux.com/)
* [Vuldroid](https://github.com/jaiswalakshansh/Vuldroid)

  
### Talks

* [Blowing the Cover of Android Binary Fuzzing (Slides)](https://speakerdeck.com/flankerhqd/blowing-the-cover-of-android-binary-fuzzing)
* [One Step Ahead of Cheaters -- Instrumenting Android Emulators](https://www.youtube.com/watch?v=L3AniAxp_G4)
* [Vulnerable Out of the Box: An Evaluation of Android Carrier Devices](https://www.youtube.com/watch?v=R2brQvQeTvM)
* [Rock appround the clock: Tracking malware developers by Android](https://www.youtube.com/watch?v=wd5OU9NvxjU)
* [Chaosdata - Ghost in the Droid: Possessing Android Applications with ParaSpectre](https://www.youtube.com/watch?v=ohjTWylMGEA)
* [Remotely Compromising Android and iOS via a Bug in Broadcom's Wi-Fi Chipsets](https://www.youtube.com/watch?v=TDk2RId8LFo)
* [Honey, I Shrunk the Attack Surface – Adventures in Android Security Hardening](https://www.youtube.com/watch?v=EkL1sDMXRVk)
* [Hide Android Applications in Images](https://www.youtube.com/watch?v=hajOlvLhYJY)
* [Scary Code in the Heart of Android](https://www.youtube.com/watch?v=71YP65UANP0)
* [Fuzzing Android: A Recipe For Uncovering Vulnerabilities Inside System Components In Android](https://www.youtube.com/watch?v=q_HibdrbIxo)
* [Unpacking the Packed Unpacker: Reverse Engineering an Android Anti-Analysis Native Library](https://www.youtube.com/watch?v=s0Tqi7fuOSU)
* [Android FakeID Vulnerability Walkthrough](https://www.youtube.com/watch?v=5eJYCucZ-Tc)
* [Unleashing D* on Android Kernel Drivers](https://www.youtube.com/watch?v=1XavjjmfZAY)
* [The Smarts Behind Hacking Dumb Devices](https://www.youtube.com/watch?v=yU1BrY1ZB2o)
* [Overview of common Android app vulnerabilities](https://www.bugcrowd.com/resources/webinars/overview-of-common-android-app-vulnerabilities/)
* [Android Dev Summit 2019](https://developer.android.com/dev-summit)
* [Android security architecture](https://www.youtube.com/watch?v=3asW-nBU-JU)
* [Get the Ultimate Privilege of Android Phone](https://vimeo.com/335948808)
  
### Misc.
    
* [Android-Reports-and-Resources](https://github.com/B3nac/Android-Reports-and-Resources/blob/master/README.md)
* [android-security-awesome](https://github.com/ashishb/android-security-awesome)
* [Android Penetration Testing Courses](https://medium.com/mobile-penetration-testing/android-penetration-testing-courses-4effa36ac5ed)
* [Lesser-known Tools for Android Application PenTesting](https://captmeelo.com/pentest/2019/12/30/lesser-known-tools-for-android-pentest.html)
* [android-device-check - a set of scripts to check Android device security configuration](https://github.com/nelenkov/android-device-check)
* [apk-mitm - a CLI application that prepares Android APK files for HTTPS inspection](https://github.com/shroudedcode/apk-mitm)
* [Andriller - is software utility with a collection of forensic tools for smartphones](https://github.com/den4uk/andriller)
* [Dexofuzzy: Android malware similarity clustering method using opcode sequence-Paper](https://www.virusbulletin.com/virusbulletin/2019/11/dexofuzzy-android-malware-similarity-clustering-method-using-opcode-sequence/)
* [Chasing the Joker](https://docs.google.com/presentation/d/1sFGAERaNRuEORaH06MmZKeFRqpJo1ol1xFieUa1X_OA/edit#slide=id.p1)
* [Side Channel Attacks in 4G and 5G Cellular Networks-Slides](https://i.blackhat.com/eu-19/Thursday/eu-19-Hussain-Side-Channel-Attacks-In-4G-And-5G-Cellular-Networks.pdf)
* [Shodan.io-mobile-app for Android](https://github.com/PaulSec/Shodan.io-mobile-app)
* [Popular Android Malware 2018](https://github.com/sk3ptre/AndroidMalware_2018)
* [Popular Android Malware 2019](https://github.com/sk3ptre/AndroidMalware_2019)
* [Popular Android Malware 2020](https://github.com/sk3ptre/AndroidMalware_2020)    
    
   
## iOS

### General - Blogs, Papers, How to's

* [iOS Security](https://www.cse.wustl.edu/~jain/cse571-14/ftp/ios_security/index.html)
* [Basic iOS Apps Security Testing lab](https://medium.com/@ehsahil/basic-ios-apps-security-testing-lab-1-2bf37c2a7d15)
* [IOS Application security – Setting up a mobile pentesting platform](https://resources.infosecinstitute.com/ios-application-security-part-1-setting-up-a-mobile-pentesting-platform/#gref)
* [Collection of the most common vulnerabilities found in iOS applications](https://github.com/felixgr/secure-ios-app-dev)
* [IOS_Application_Security_Testing_Cheat_Sheet](https://www.owasp.org/index.php/IOS_Application_Security_Testing_Cheat_Sheet)
* [OWASP iOS Basic Security Testing](https://mobile-security.gitbook.io/mobile-security-testing-guide/ios-testing-guide/0x06b-basic-security-testing)
* [Dynamic analysis of iOS apps w/o Jailbreak](https://medium.com/@ansjdnakjdnajkd/dynamic-analysis-of-ios-apps-wo-jailbreak-1481ab3020d8)
* [iOS Application Injection](https://arjunbrar.com/post/ios-application-injection)
* [Low-Hanging Apples: Hunting Credentials and Secrets in iOS Apps](https://spaceraccoon.dev/low-hanging-apples-hunting-credentials-and-secrets-in-ios-apps)
* [Checkra1n Era - series](https://blog.digital-forensics.it/)
* [BFU Extraction: Forensic Analysis of Locked and Disabled iPhones](https://blog.elcomsoft.com/2019/12/bfu-extraction-forensic-analysis-of-locked-and-disabled-iphones/)
* [HowTo-decrypt-Signal.sqlite-for-IOS](https://github.com/Magpol/HowTo-decrypt-Signal.sqlite-for-IOS)
* [Can I Jailbreak?](https://canijailbreak.com/)
* [How to Extract Screen Time Passcodes and Voice Memos from iCloud](https://blog.elcomsoft.com/2019/10/how-to-extract-screen-time-passcodes-and-voice-memos-from-icloud/)
* [Reverse Engineering Swift Apps](https://github.com/iOS-Reverse-Engineering-Dev/Swift-Apps-Reverse-Engineering/blob/master/Reverse%20Engineering%20Swift%20Applications.pdf)
* [Mettle your iOS with FRIDA](https://sensepost.com/blog/2019/mettle-your-ios-with-frida/)
* [A run-time approach for pentesting iOS applications](https://blog.securelayer7.net/a-run-time-approach-for-pen-testing-ios-applications-part-ii-objection-in-action/)
* [iOS Internals vol 2](http://newosxbook.com/bonus/iBoot.pdf)
* [Understanding usbmux and the iOS lockdown service](https://medium.com/@jon.gabilondo.angulo_7635/understanding-usbmux-and-the-ios-lockdown-service-7f2a1dfd07ae)
* [A Deep Dive into iOS Code Signing](https://blog.umangis.me/a-deep-dive-into-ios-code-signing/)
* [AirDoS: remotely render any nearby iPhone or iPad unusable](https://kishanbagaria.com/airdos/)
* [How to access and traverse a #checkra1n jailbroken iPhone File system using SSH](https://aboutdfir.com/jailbreaking-checkra1n-configuration/)
* [Deep dive into iOS Exploit chains found in the wild - Project Zero](https://googleprojectzero.blogspot.com/2019/08/a-very-deep-dive-into-ios-exploit.html)
* [The Fully Remote Attack Surface of the iPhone - Project Zero](https://googleprojectzero.blogspot.com/2019/08/the-fully-remote-attack-surface-of.html)


### Books

* [Hacking and Securing iOS Applications: Stealing Data, Hijacking Software, and How to Prevent It](https://www.amazon.com/Hacking-Securing-iOS-Applications-Hijacking/dp/1449318746)
* [iOS Penetration Testing](https://www.apress.com/gp/book/9781484223543)
* [iOS App Security, Penetration Testing, and Development](https://www.allysonomalley.com/)
* [IOS Hacker's Handbook](https://www.amazon.com/iOS-Hackers-Handbook-Charlie-Miller/dp/1118204123)
* [Hacking iOS Applications a detailed testing guide](https://web.securityinnovation.com/hubfs/iOS%20Hacking%20Guide.pdf)
* [Develop iOS Apps (Swift)](https://developer.apple.com/library/archive/referencelibrary/GettingStarted/DevelopiOSAppsSwift/)
* [iOS Programming Cookbook](https://www.packtpub.com/in/application-development/ios-programming-cookbook)

### Courses

* [Pentesting iOS Applications](https://www.pentesteracademy.com/course?id=2)
* [Reverse Engineering iOS Applications](https://github.com/ivRodriguezCA/RE-iOS-Apps)
* [App Design and Development for iOS](https://www.coursera.org/learn/ios-app-design-development)

### Tools

* [Cydia Impactor](http://www.cydiaimpactor.com/)
* [checkra1n jailbreak](https://checkra.in/)
* [idb - iOS App Security Assessment Tool](https://www.idbtool.com/)
* [Frida](https://github.com/frida/frida/releases)
* [Objection - mobile exploration toolkit by Frida](https://github.com/sensepost/objection)
* [Bfinject](https://github.com/BishopFox/bfinject)
* [iFunbox](http://www.i-funbox.com/)
* [Libimobiledevice - library to communicate with the services of the Apple ios devices](https://www.libimobiledevice.org/)
* [iRET (iOS Reverse Engineering Toolkit)](https://www.veracode.com/sites/default/files/Resources/Tools/iRETTool.zip) - includes oTool, dumpDecrypted, SQLite, Theos, Keychain_dumper, Plutil
* [Myriam iOS](https://github.com/GeoSn0w/Myriam)
* [iWep Pro - wireless suite of useful applications used to turn your iOS device into a wireless network diagnostic tool](https://itunes.apple.com/us/app/iweppro/id578135585?mt=8)
* [Burp Suite](https://portswigger.net/burp/communitydownload)
* [Cycript](https://cydia.saurik.com/api/latest/3)
* [needle - The iOS Security Testing Framework](https://github.com/FSecureLABS/needle)
* [iLEAPP - iOS Logs, Events, And Preferences Parser](https://github.com/abrignoni/iLEAPP)
* [Cutter - Free and Open Source RE Platform powered by radare2](https://cutter.re/)
* [decrypt0r - automatically download and decrypt SecureRom stuff](https://github.com/shinvou/decrypt0r)
* [iOS Security Suite - an advanced and easy-to-use platform security & anti-tampering library](https://github.com/securing/IOSSecuritySuite)

### Labs

* [OWASP iGoat](https://www.owasp.org/index.php/OWASP_iGoat_Tool_Project)
* [Damn Vulnerable iOS App (DVIA) v2](https://github.com/prateek147/DVIA-v2)
* [Damn Vulnerable iOS App (DVIA) v1](https://github.com/prateek147/DVIA)
* [iPhoneLabs](https://github.com/SecurityCompass/iPhoneLabs)
* [iOS-Attack-Defense](https://github.com/ManicodeSecurity/iOS-Attack-Defense)

### Talks

* [Behind the Scenes of iOS Security](https://www.youtube.com/watch?v=BLGFriOKz6U)
* [Modern iOS Application Security](https://www.infoq.com/presentations/ios-security/)
* [Demystifying the Secure Enclave Processor](https://www.youtube.com/watch?v=7UNeUT_sRos)
* [HackPac Hacking Pointer Authentication in iOS User Space](https://www.youtube.com/watch?v=DJFxhShJ6Ns)
* [Analyzing and Attacking Apple Kernel Drivers](https://www.youtube.com/watch?v=07VqX4bbXTI)
* [Remotely Compromising iOS via Wi-Fi and Escaping the Sandbox](https://www.youtube.com/watch?v=bP5VP7vLLKo)
* [Reverse Engineering iOS Mobile Apps](https://www.bugcrowd.com/resources/webinars/reverse-engineering-ios-mobile-apps/)
* [iOS 10 Kernel Heap Revisited](https://www.youtube.com/watch?v=DNW6Im31lQo)
* [KTRW: The journey to build a debuggable iPhone](https://media.ccc.de/v/36c3-10806-ktrw_the_journey_to_build_a_debuggable_iphone)
* [The One Weird Trick SecureROM Hates](https://media.ccc.de/v/36c3-11238-the_one_weird_trick_securerom_hates)
* [Tales of old: untethering iOS 11-Spoiler: Apple is bad at patching](https://media.ccc.de/v/36c3-11034-tales_of_old_untethering_ios_11)
* [Messenger Hacking: Remotely Compromising an iPhone through iMessage](https://media.ccc.de/v/36c3-10497-messenger_hacking_remotely_compromising_an_iphone_through_imessage)
* [Recreating An iOS 0-Day Jailbreak Out Of Apple's Security Updates](https://www.youtube.com/watch?v=p512McKXukU)
* [Reverse Engineering the iOS Simulator’s SpringBoard](https://vimeo.com/231806976)
* [Attacking iPhone XS Max](https://www.youtube.com/watch?v=8cOx7vfszZU&feature=youtu.be)



### Misc.
  
* [Most usable tools for iOS penetration testing](https://github.com/ansjdnakjdnajkd/iOS)
* [iOS-Security-Guides](https://github.com/0xmachos/iOS-Security-Guides)
* [osx-security-awesome - OSX and iOS related security tools](https://github.com/ashishb/osx-and-ios-security-awesome)    
* [Trust in Apple's Secret Garden: Exploring & Reversing Apple's Continuity Protocol-Slides](https://i.blackhat.com/eu-19/Thursday/eu-19-Yen-Trust-In-Apples-Secret-Garden-Exploring-Reversing-Apples-Continuity-Protocol-3.pdf)
* [Apple Platform Security](https://manuals.info.apple.com/MANUALS/1000/MA1902/en_US/apple-platform-security-guide.pdf)
* [Mobile security, forensics & malware analysis with Santoku Linux](https://2013.appsecusa.org/2013/wp-content/uploads/2013/12/viaForensics-AppSecUSA-Nov-2013.pdf)

    
