# Welcome to Asyncord

<p align="center">
  <img src="assets/logo_thumbnail.png" alt="Asyncord Logo">
</p>

# :material-book-open-page-variant: Introduction

Welcome to Asyncord, the next-generation library for building powerful and efficient Discord bots with Python!

Asyncord makes bot development seamless and enjoyable by closely following the official Discord API. It ensures your bots are fast and responsive. Whether you're a seasoned developer or a beginner, Asyncord provides the tools and documentation to create bots that handle everything from simple commands to complex interactions.

# :material-star-four-points: Key Features

<div class="grid cards" markdown>

-   :material-clock-fast:{ .lg .middle } __Fully Asynchronous__

    ---

    Asyncord is built with asynchronous programming from the ground up.

-   :material-code-tags-check:{ .lg .middle } __Total Type Hints Coverage__

    ---

    The library is fully typed, with type hints for all functions and classes, and includes comprehensive Pydantic schema coverage to ensure robust data validation and management.

-   :material-api:{ .lg .middle } __Full Discord Bot API Coverage__

    ---

    The library offers complete coverage of the Discord Bot API, enabling access to all the functionalities that Discord provides for bots. This includes handling messages, managing servers, user interactions, and more.

-   :material-book-open-page-variant:{ .lg .middle } __Clarity and Comprehensibility__

    ---

    Asyncord is designed to be more clear and understandable than other libraries, as it closely follows the official Discord API documentation. This adherence makes it easier for developers to implement and maintain their bots.

</div>

# :material-tools: Installing

To install the library, run the following command:

```bash
pip install asyncord
```

That's it! You're ready to start building your Discord bot. 🤖

# :material-handshake: Contributing
Contributions of all sizes are welcome. We appreciate any help, whether it's fixing a bug, improving the documentation, or adding a new feature. If you're interested in contributing, please read our contributing guidelines to get started. 🚀

# :material-file-document: License
This project is licensed under the MIT License. For more information, please refer to the LICENSE file. 📄
