# The Algorithms - Python

[![Contributors](https://img.shields.io/github/contributors/vJechsmayr/PythonAlgorithms)](https://github.com/vJechsmayr/PythonAlgorithms/graphs/contributors)
[![Issues](https://img.shields.io/github/issues/vJechsmayr/PythonAlgorithms)](https://github.com/vJechsmayr/PythonAlgorithms/issues)
[![Open Pull Requests](https://img.shields.io/github/issues-pr-raw/vJechsmayr/PythonAlgorithms)](https://github.com/vJechsmayr/PythonAlgorithms/pulls)
[![Last Commit](https://img.shields.io/github/last-commit/vJechsmayr/PythonAlgorithms)](https://github.com/vJechsmayr/PythonAlgorithms)
[![Stars](https://img.shields.io/github/stars/vJechsmayr/PythonAlgorithms)](https://github.com/vJechsmayr/PythonAlgorithms/stargazers)
[![Forks](https://img.shields.io/github/forks/vJechsmayr/PythonAlgorithms)](https://github.com/vJechsmayr/PythonAlgorithms/network/members)
[![Watchers](https://img.shields.io/github/watchers/vJechsmayr/PythonAlgorithms)](https://github.com/vJechsmayr/PythonAlgorithms/watchers)
[![License](https://img.shields.io/github/license/vJechsmayr/PythonAlgorithms)](https://github.com/vJechsmayr/PythonAlgorithms/blob/master/LICENSE)


## Table of Contents
* [Inspiration and Motivation](#inspiration)
* [Contributing Guidelines](#contributing-guidelines)
* [Start Here](#getting-started)




### All algorithms implemented in Python 3 (for education)
There implementations are for learning purposes. If you want to contribute more efficient solutions feel free to open an issue and commit your solution.

## Inspiration

You can look for Algorithms to implement at: [LeetCode Algorithms](https://leetcode.com/problemset/algorithms/) 

To contribute make sure the Algorithm isn't commited yet! Make sure to add the number of the Issue in your PR.

## Contributing Guidelines

### Folders and Files
Please make sure your file is in the `LeetCode`-Folder and Named like this:
`0001_TwoSum.py` -> 4-digit Number of the LeetCode Issue, Underscore, LeetCodeName

### Opening Issues
When you open an issue, please make sure the Problem is not already implemented (Look at Code/Leetcode for the Problemnumber). 
Opened Issues by existing Problem will be closed & PR made to this Issue marked as **spam**
The Contributer who opened an issue will be assigned prefered to the issue. If there is no PR within about 7 Days the issue will be assigned to another Contributer.

### Pull Requests
Only Pull Requests **joined with an Issue** and matching the **naming-conventions** (See Folders and Files) will be merged!
If there is no Issue joined in the PR your PR will be labeld as **spam** and closed.
If your code don't passes the Check on LeetCode.com your PR will be labeld as **"invalid"** and the Issue stays open for the next PR!
If your PR doesn' follow the Contributing Guidelines of this Repository it will be also marked as **spam** and closed!

### Spam Users
Users who spam this Repo with PRs/Issues that does not align the Contribution Guidelines will be **blocked**.

## Getting Started
* Fork this repository (Click the Form button, top right of this page)
* Clone your fork down to your local machine
```markdown
git clone https://github.com/your-username/pythonalgorithms.git
```
* Comment to the Issue you want to work on - so I can assign you to it OR create a new Issue from a LeetCode Problem that is not implemented yet
* Create a branch for a new feature
```markdown
git checkout -b feature/branch-name
```
* Or if its a bugfix to a file
```markdown
git checkout -b bugfix/branch-name
```
* Make your changes (choose from the Tasks above!)
* Commit and Push
```markdown
git add .
git commit -m 'commit message'
git push origin branch-name
```
* Create a New Pull Request from your forked repository ( Click the 'New Pull Request' Button located at the top of your repo)
* Wait for your PR review and merge approval!
* __Star this repository__ if you had fun!

## Which PR will be accepted?
* Ones you are assigned to
* Your PR has to link the Issue
* Your Solution must be correct - you can check first on LeetCode (submit) if it works on different test-cases

## Which PRs will be NOT accepted?
* Ones you are NOT assigned to
* Your PR is NOT linked to the Issue you are linked to
* Your Solution is not correct
* Your PR contains more than the .py file
* PRs that "correct" Typos or spam files with comments
* PRs that "correct" Coding Styles - Please accept that everybody has a different style

## Hacktoberfest 2020
During October there come pretty much PRs and Issues - Please be patient because of my fulltime job I cannot be online 24/7 - I do my best to work through your PRs as soon as possible.
This Repository is open for **Hacktoberfest 2020 ONLY**! No PRs/Issues for Hacktoberfest 2021 or later will be accepted and marked as **invalid/spam**

__Thank You!__ 
