# Introduction

## What is Floky ?

Floky is a MVC (Model-View-Controller) framework for developing web applications in PHP. It provides an organized structure for your code, powerful features, and flexibility to create robust and scalable web applications.

## Main Features

- **MVC architecture**: Organize your code in a clean and modular way.
- **Powerful Routing**: Manage URLs flexibly to direct requests to the appropriate controllers.
- **Database Management**: Facilitate interaction with databases thanks to [NexaORM](https://github.com/v1p3r75/NexaORM/) (a powerful and easy to use flexible new generation ORM in hand).
- **Security**: Integrate security mechanisms to protect your application against common vulnerabilities.
- **Flexible View**: Use the [BladeOne](https://github.com/EFTEC/BladeOne/) template engine to design rich and dynamic views.
- **Dependency Container**: Use a dependency container to manage your application's services efficiently.
- **More Elegant Tests**: Take advantage of [Pest](https://pestphp.com/), an elegant testing framework for PHP, to write clean, readable and expressive tests for your application.
- **Reusable Components**: Take advantage of libraries and tools to accelerate development.
- **Complete Documentation**: A detailed guide to help you get started quickly.

## Why Floky ?

The idea behind Floky is not to **reinvent the wheel**, but to provide a set of well-designed, easy-to-use tools for smaller projects. We sought to simplify development by avoiding unnecessary complexity, while still providing flexibility to create quality web applications.
Floky was designed to meet a fundamental need: to allow developers to quickly start a project without having to spend weeks understanding how many tools work. We understand that sometimes you just need a lightweight and efficient tool to bring your ideas to life without being overwhelmed by a multitude of unnecessary features.


Here's why Floky may be the perfect choice for your next project:

- **Quick Start**

With Floky, you can quickly set up your app structure and start writing working code in no time. Our simple, modular architecture allows you to focus on the logic of your application without having to worry about complex configurations.

- **Less Learning Curve**

Unlike many massive frameworks, Floky is designed to be intuitive. You don't need to spend hours understanding documentation or learning abstract concepts. Getting to grips with things like routes, middleware, and other key Floky concepts is a quick and seamless process.

- **Lightweight and Adaptable**

Floky is a lightweight framework that doesn't overload your project with unnecessary features. It is ideal for smaller projects, providing you with the essential tools to create effective web applications.

Whether your project is a small website, a simple web application, or a prototype, Floky can help you move forward quickly without sacrificing quality. It provides the flexibility you need to focus on what really matters: bringing your project to life.

So why wait? Try Floky today and start developing your ideas without unnecessary hassle and complications.

## Installation

- Make sure you have Composer installed on your system. If not, you can download and install it from the official website of [Composer](https://getcomposer.org/download/).

- Run the Composer command to create and install the application dependencies:

     ```bash
     composer create-project v1p3r75/floky
     ```

- You will now have the most recent version of your framework and all dependencies correctly installed.

## Documentation

[Visit documentation](https:/floky-docs.vercel.app/) for more about **Floky**.


## Contributors

Development of **Floky** is currently underway, and we welcome any contribution from the community.

The core development team currently includes the following contributors:

- [Fortunatus KIDJE (v1p3r75)](https://github.com/v1p3r75) - Founder and lead developer
- [Kabirou ALASSANE (BlakvGhost)](https://github.com/BlakvGhost) - Associate developer

We are excited to grow this project and add new features to meet the needs of the PHP developer community. Join us in this adventure and help make **Floky** an even lighter and more powerful tool for developing web applications in PHP.

## Licence

This project is licensed under the [MIT](https://en.wikipedia.org/wiki/MIT_License).