# Java Data Structures and Algorithms Collection

This repository contains educational code examples for various data structures and algorithms implemented in Java. It is designed to help learners understand and apply fundamental concepts in data structures and algorithms. Each file and folder includes detailed comments to explain the code and concepts.

## Contents

### Data Structures

#### Basic Data Structures

- Array
- Linked List
  - Singly Linked List
  - Doubly Linked List
  - Circular Linked List
- Stack
- Queue
- Priority Queue
- Hash Table
- Set
  - HashSet
  - TreeSet
- Map
  - HashMap
  - TreeMap

#### Trees

- Binary Tree
- Binary Search Tree (BST)
- AVL Tree
- Red-Black Tree
- Segment Tree
- Fenwick Tree (Binary Indexed Tree)
- Ternary Tree
- N-Ary Tree

#### Graphs

- Directed Graph
- Undirected Graph
- Weighted Graph

### Algorithms

#### Sorting Algorithms

- Bubble Sort
- Selection Sort
- Insertion Sort
- Merge Sort
- Quick Sort
- Heap Sort
- Counting Sort
- Radix Sort
- Bucket Sort
- Bingo Sort
- Shell Sort
- Comb Sort
- Cocktail Sort

#### Searching Algorithms

- Linear Search
- Binary Search
- Depth First Search (DFS)
- Breadth First Search (BFS)
- Jump Search
- Fibonacci Search

#### Graph Algorithms

- Dijkstra's Algorithm
- Bellman-Ford Algorithm
- Floyd-Warshall Algorithm
- Kruskal's Algorithm
- Prim's Algorithm
- Topological Sort
- A* Search Algorithm
- Huffman Algorithm

#### Dynamic Programming

- Fibonacci Series
- Longest Common Subsequence (LCS)
- Longest Increasing Subsequence (LIS)
- Matrix Chain Multiplication

#### Discrete Math and Combinatorial Algorithms

- Permutations and Combinations
- Subset Sum Problem
- Travelling Salesman Problem (TSP)
- Graph Coloring

## How to Use

Each Java file and folder is named to indicate the data structure or algorithm it covers. For instance, within the `Algorithms` folder, the `1-sorting_algorithms` folder contains `1-bubble_sort`, which deals with the Bubble Sort algorithm in Java.

## Contributing

If you'd like to contribute to this repository, feel free to submit a pull request. You can add new examples, improve existing code, or fix any issues. Contributions of all levels are welcome!

## License

This repository is licensed under the MIT License. See the [LICENSE](LICENSE) file for more information.

---

**Note:** This repository is intended for educational purposes to help learn and understand data structures and algorithms in Java.

**Remember to star the repository if you find it useful!**
