/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.bwcaptcha;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;

public class Captcha
extends org.zkoss.zul.Image {
    private static final long serialVersionUID = 1L;
    private boolean _smartDrawCaptcha;
    private transient EventListener _smartDrawCaptchaListener;
    private Random generator = new Random();
    private static final Font DEFAULT_FONTS = new Font("Courier", 1, 32);
    private int _intWidth = 135;
    private int _intHeight = 55;
    private int _bgColor = 0x8888FF;
    private int _fontColor = 0xFF6666;
    private int _fontBgColor = 0xFFDDFF;
    private int _lineColor = 0x7777DD;
    private Font _font;
    private int _thickness = 3;
    private String _value = "";
    private int _len = 5;
    private char[] _captchars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public Captcha() {
        this.setWidth("135px");
        this.setHeight("55px");
        this.randomValue();
        this.smartDrawCaptcha();
    }

    public Font getDefaultFonts() {
        return DEFAULT_FONTS;
    }

    public Font getFont() {
        return this._font == null ? this.getDefaultFonts() : this._font;
    }

    public void setFont(Font font) {
        if (!Objects.equals((Object)this._font, (Object)font)) {
            this._font = font;
            this.smartDrawCaptcha();
        }
    }

    public int getFontColor() {
        return this._fontColor;
    }

    public void setFontColor(int fontColor) {
        if (this._fontColor != fontColor) {
            this._fontColor = fontColor;
            this.smartDrawCaptcha();
        }
    }

    public int getBgColor() {
        return this._bgColor;
    }

    public void setBgColor(int bgColor) {
        if (this._bgColor != bgColor) {
            this._bgColor = bgColor;
            this.smartDrawCaptcha();
        }
    }

    public int getFontBgColor() {
        return this._fontBgColor;
    }

    public void setFontBgColor(int fontBgColor) {
        if (this._fontBgColor != fontBgColor) {
            this._fontBgColor = fontBgColor;
            this.smartDrawCaptcha();
        }
    }

    public int getLineColor() {
        return this._lineColor;
    }

    public void setLineColor(int lineColor) {
        if (this._lineColor != lineColor) {
            this._lineColor = lineColor;
            this.smartDrawCaptcha();
        }
    }

    public int getThickness() {
        return this._thickness;
    }

    public void setThickness(int thickness) {
        if (this._thickness != thickness) {
            this._thickness = thickness;
            this.smartDrawCaptcha();
        }
    }

    public void setWidth(String w) {
        if (Objects.equals((Object)w, (Object)this.getWidth())) {
            return;
        }
        this._intWidth = this.stringToInt(w);
        super.setWidth(w);
        this.smartDrawCaptcha();
    }

    public int getIntWidth() {
        return this._intWidth;
    }

    public void setHeight(String h) {
        if (Objects.equals((Object)h, (Object)this.getHeight())) {
            return;
        }
        this._intHeight = this.stringToInt(h);
        super.setHeight(h);
        this.smartDrawCaptcha();
    }

    public int getIntHeight() {
        return this._intHeight;
    }

    public String getValue() {
        if (this._value == null) {
            throw new IllegalStateException("value haven't generated.");
        }
        return this._value;
    }

    public void setValue(String text) throws WrongValueException {
        if (Strings.isBlank((String)text)) {
            throw new WrongValueException("empty not allowed");
        }
        if (!Objects.equals((Object)text, (Object)this._value)) {
            this._value = text;
            this.smartDrawCaptcha();
        }
    }

    public void setLength(int len) {
        if (len != this._len) {
            this._len = len;
            this.randomValue();
            this.smartDrawCaptcha();
        }
    }

    public int getLength() {
        return this._len;
    }

    public char[] getCaptchars() {
        return this._captchars;
    }

    public void setCaptchars(char[] captchars) {
        if (captchars == null || captchars.length < 1) {
            return;
        }
        if (!Arrays.equals(this._captchars, captchars)) {
            this._captchars = captchars;
            this.randomValue();
            this.smartDrawCaptcha();
        }
    }

    public String randomValue() {
        int car = this._captchars.length - 1;
        int len = this._len;
        StringBuffer sb = new StringBuffer(len);
        while (len > 0) {
            char c = this._captchars[this.generator.nextInt(car) + 1];
            if (!Character.isLetterOrDigit(c)) continue;
            sb.append(c);
            --len;
        }
        this.setValue(sb.toString());
        return this.getValue();
    }

    protected void smartDrawCaptcha() {
        if (this._smartDrawCaptcha) {
            return;
        }
        this._smartDrawCaptcha = true;
        if (this._smartDrawCaptchaListener == null) {
            this._smartDrawCaptchaListener = new EventListener(){

                public void onEvent(Event event) {
                    if (Strings.isBlank((String)Captcha.this.getWidth())) {
                        throw new UiException("captcha must specify width");
                    }
                    if (Strings.isBlank((String)Captcha.this.getHeight())) {
                        throw new UiException("captcha must specify height");
                    }
                    try {
                        byte[] bytes = Captcha.this.nextImageImpl(Captcha.this.getValue());
                        AImage media = new AImage("captcha" + new Date().getTime(), bytes);
                        Captcha.this.setContent((Image)media);
                    }
                    catch (IOException e) {
                        throw new UiException(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        Captcha.this._smartDrawCaptcha = false;
                    }
                }
            };
            this.addEventListener("onSmartDrawCaptcha", this._smartDrawCaptchaListener);
        }
        Events.postEvent((String)"onSmartDrawCaptcha", (Component)this, null);
    }

    private byte[] nextImageImpl(String captchaValue) {
        BufferedImage bi = new BufferedImage(this._intWidth, this._intHeight, 13);
        Color bgC = new Color(this._bgColor);
        Color fontC = new Color(this._fontColor);
        Color lineC = new Color(this._lineColor);
        Graphics2D graphics = bi.createGraphics();
        graphics.setBackground(bgC);
        graphics.setColor(bgC);
        graphics.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        Font font = this.getFont();
        TextLayout textTl = new TextLayout(captchaValue, font, new FontRenderContext(null, true, false));
        float x = 10.0f;
        float y = this._intHeight - (this._intHeight / 2 - font.getSize() / 2);
        graphics.setColor(new Color(this._fontBgColor));
        textTl.draw(graphics, x + 7.0f, y + 7.0f);
        graphics.setColor(fontC);
        textTl.draw(graphics, x, y);
        this.shear(graphics, bi.getWidth(), bi.getHeight(), bgC);
        this.drawThickLine(graphics, 0, this.generator.nextInt(this._intHeight) + 1, this._intWidth, this.generator.nextInt(this._intHeight) + 1, this._thickness, lineC);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageOutputStream ios = ImageIO.createImageOutputStream(baos);
            ImageWriter writer = null;
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
            if (iter.hasNext()) {
                writer = iter.next();
            }
            writer.setOutput(ios);
            CompressQualityParam iwparam = new CompressQualityParam();
            iwparam.setCompressionMode(2);
            iwparam.setCompressionQuality(0.9f);
            writer.write(null, new IIOImage(bi, null, null), iwparam);
            ios.flush();
            writer.dispose();
            ios.close();
            baos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return baos.toByteArray();
    }

    private void shear(Graphics g, int w1, int h1, Color color) {
        this.shearX(g, w1, h1, color);
        this.shearY(g, w1, h1, color);
    }

    private void shearX(Graphics g, int w1, int h1, Color color) {
        int period = this.generator.nextInt(10) + 5;
        boolean borderGap = true;
        int frames = 15;
        int phase = this.generator.nextInt(5) + 2;
        for (int i = 0; i < h1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * (double)phase / (double)frames);
            g.copyArea(0, i, w1, 1, (int)d, 0);
            if (!borderGap) continue;
            g.setColor(color);
            g.drawLine((int)d, i, 0, i);
            g.drawLine((int)d + w1, i, w1, i);
        }
    }

    private void shearY(Graphics g, int w1, int h1, Color color) {
        int period = this.generator.nextInt(30) + 10;
        boolean borderGap = true;
        int frames = 15;
        int phase = 7;
        for (int i = 0; i < w1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(i, 0, 1, h1, 0, (int)d);
            if (!borderGap) continue;
            g.setColor(color);
            g.drawLine(i, (int)d, i, 0);
            g.drawLine(i, (int)d + h1, i, h1);
        }
    }

    private void drawThickLine(Graphics g, int x1, int y1, int x2, int y2, int thickness, Color c) {
        g.setColor(c);
        int dX = x2 - x1;
        int dY = y2 - y1;
        double lineLength = Math.sqrt(dX * dX + dY * dY);
        double scale = (double)thickness / (2.0 * lineLength);
        double ddx = -scale * (double)dY;
        double ddy = scale * (double)dX;
        double d = ddy > 0.0 ? 0.5 : -0.5;
        int dx = (int)(ddx += ddx > 0.0 ? 0.5 : -0.5);
        int dy = (int)(ddy += d);
        int[] xPoints = new int[4];
        int[] yPoints = new int[4];
        xPoints[0] = x1 + dx;
        yPoints[0] = y1 + dy;
        xPoints[1] = x1 - dx;
        yPoints[1] = y1 - dy;
        xPoints[2] = x2 - dx;
        yPoints[2] = y2 - dy;
        xPoints[3] = x2 + dx;
        yPoints[3] = y2 + dy;
        g.fillPolygon(xPoints, yPoints, 4);
    }

    private int stringToInt(String str) {
        int j = str.lastIndexOf("px");
        if (j > 0) {
            String num = str.substring(0, j);
            return Integer.parseInt(num);
        }
        j = str.lastIndexOf("pt");
        if (j > 0) {
            String num = str.substring(0, j);
            return (int)((double)Integer.parseInt(num) * 1.3333);
        }
        j = str.lastIndexOf("em");
        if (j > 0) {
            String num = str.substring(0, j);
            return (int)((double)Integer.parseInt(num) * 13.3333);
        }
        return Integer.parseInt(str);
    }

    private class CompressQualityParam
    extends JPEGImageWriteParam {
        public CompressQualityParam() {
            super(Locale.getDefault());
        }

        public void setCompressionQuality(float quality) {
            if (quality < 0.0f || quality > 1.0f) {
                throw new IllegalArgumentException("Quality Out-Of-Bounds.");
            }
            this.compressionQuality = 256.0f - quality * 256.0f;
        }
    }
}

