/* Copyright (C) 2011, 2012 The uOFW team
   See the file COPYING for copying permission.
*/

#ifndef REBOOT_H
#define REBOOT_H

#include <common_imp.h>

typedef int (*Callback1)(int, int, int);
typedef int (*Callback2)(int, int);
typedef int (*Callback3)(int, int);
typedef int (*Callback4)(int);
typedef int (*Callback5)(int);

typedef void (*OutCharCb)(int, int);
typedef int (*InStrCb)(short, char*, int);
typedef int (*OutStrCb)(short, char*, int);

extern int *resetVectorInfo; // 0x88630C44
extern int resetVectorAddr; // 0x88630C48

void applySegmentRelocs(int arg0, int arg1, int arg2, int arg3, int arg4);
int sub_5678(int arg0, int arg1);
int sub_5EF8(Callback1 arg);
int sub_5F08(Callback2 arg);
int sub_5F18(Callback3 arg);
int sub_5F28(Callback4 arg);
int sub_5F38(Callback5 arg);
int sub_5F48(int arg0, int arg1);
int sub_6014(int arg);
int sub_60FC(int arg0, int arg1);
int sub_6284(int arg0, int arg1);
int sub_6350(int arg0, int arg1, int arg2, int arg3);
int sub_6428(int arg);
void sub_653C(int arg);
void sub_68E8(int arg0, int arg1);
void sub_6A44(int arg0, int arg1);
void applyRelocs(int arg0, int arg1); // 666C
int applySectionRelocs(int arg0, int arg1, int arg2, int arg3, int arg4);
int sub_7D74(int arg0, int arg1);
int sub_9A84(int arg0, int arg1);
void sub_01D4();
int sub_01E4();
int sub_0928();
int sub_11970(int arg0, int arg1);
void sub_1810(int arg0, int arg1);
int sub_18E4();
int sub_1B7C(int arg);
int sub_3A84();
void sub_3AB0(int ic);
void sub_4D30(int arg);
void sub_5174();
int sub_11994();
void sub_11C8C(int arg0, int arg1);
int sub_26FC(int arg0, int arg1, int arg2, int arg3, int arg4);
int sub_2874(int arg);
int sub_49B8();
int putstringToUart4(char *s, int n);
int getStringFromUart4(char *s, int n);
int putStringToUart4Opt(short unused, char *s, int n);
int getStringFromUart4Opt(int unused, char *s, int n);
int putCharToUart4(int arg0, int arg1);
int sub_5204(int arg0, int arg1, int arg2, int arg3, int arg4);
int sub_0BB8(int arg0, int arg1, int arg2);
int sub_0CC4(int arg0, int arg1, int arg2);
int sub_0DE4(int arg0, int arg1, int arg2);
int sub_1568(int arg0, int arg1);
int sub_15C4(int arg0, int arg1);
int sub_1730(int arg0, int arg1);
void _start();
void sub_1DF8(int arg0, int arg1, int arg2, int arg3);
int sub_28F4(int arg0, int arg1, int arg2, int arg3);
int sub_4E38(int arg0, int arg1);
int sub_4FB4(int arg0, int arg1);
int sub_52C4(char *str);
int sub_707C(int arg0, int arg1, int arg2, int arg3);
int sub_71A8(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6);
int sub_11860();
int sub_9508(int arg0, char *flashName, char *lflashName, int arg3);
int sub_C28C();
int sub_C2DC(int arg0, int arg1, int arg2, int arg3);
int sub_C934(int arg);
int sub_C988(char *path, int arg1, int arg2);
int sub_DDA4(int arg);
int sub_E568(int arg0, int arg1, int arg2, int arg3, int arg4);
int sub_E984(int arg);
int sub_EAB8(int arg0, int arg1, int arg2);
void sub_EDFC(int arg0, int arg1, int arg2, int arg3);
int sub_EFCC();
int sub_F0C4();
int sub_F0D4(int arg);
int sub_F144(int arg);
int sub_F198(int arg);
int sub_F234(int arg0, int arg1);
int sub_F72C(int arg0, int arg1, int arg2);
int sub_F8A8();
int memcmp(char *s1, char *s2, int n);
int bcmp(int arg0, int arg1, int n);
int writeFormatToCallback(int arg0, int arg1, int *arg2, int arg3);
int printf(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7);
void setOutCharCb(OutCharCb cb);
int setInStrCb(InStrCb cb);
int setOutStrCb(OutStrCb cb);
int bzero(int addr, int n);
char sub_3BCC(int arg); // ???????????
int memchr(char *s, char c, int n);
int memset(void *s, int c, int n);
int strncmp(char *s1, char *s2, int cnt);
int strcmp(char *s1, char *s2);
int strlen(char *str);
int strchr(char *s, char c);
int strncmp(char *s1, char *s2, int count);
int strncpy(char *dst, char *src, int count);
int strrchr(char *s, char c);
int readFormatFromCallback(int arg0, int arg1, int arg2, int arg3);
int snprintf(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7);
void sub_48F0(int arg0, int arg1);
int sub_10184();
int sub_103C8(int arg0, int arg1, int arg2);
int sub_1047C(int arg0, int arg1, int arg2);
int sub_10500(int arg0, int arg1, int arg2);
int sub_10650(int arg);
int sub_106C4(int arg);
int sub_10750(int arg);
int sub_109DC(int arg);
int sub_10D1C();
int sub_10D28();
int sub_10D34();
int sub_10DA0(int arg);
int sub_88610FE8(int arg0, int arg1);
int sub_11004(int arg0, int arg1, int arg2);
int sub_113F0();
u64 sub_11548();
int sub_17E8(unsigned int arg);
int sub_17FC(unsigned int arg);
int sub_37F4(int arg);
int sub_3804(int arg0, int arg1, int arg2);
int sub_3824(int arg);
int sub_3874();
int sub_3880();
int sub_388C(int arg);
int sub_397C(int arg0, int arg1);
int sub_5220(int arg0, int arg1);
u64 sub_7470(int arg0, int arg1, int arg2, int arg3, int arg4);
int sub_76A0(int arg0, int arg1, int arg2, int arg3);
u64 sub_7888(int arg0, int arg1, int arg2, int arg3);
int sub_78AC(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7);
int sub_7CE0();
int sub_8124(int flashNum, int arg1, int arg2);
int sub_822C(char *name);
int sub_82C8(int arg0, int arg1);
int sub_82E4();
int sub_8344();
int sub_83A0(int arg0, int arg1);
int sub_83E0(int arg0, int arg1, int arg2);
int sub_8434(int arg);
int sub_8534(int arg0, int arg1);
int sub_861C(int arg0, int arg1, int arg2, int arg3);
int sub_8B08(int arg0, int arg1);
int sub_8B74(int arg0, int arg1, int arg2, int arg3);
int sub_8DB8(int arg0, int arg1);
int sub_8E54(int arg);
int sub_8EBC(int arg0, int arg1);
int sub_8F9C(int arg0, int arg1, int arg2, int arg3);
int sub_90C8(int arg0, int arg1);
int sub_9158(int arg0, char *name, int arg2, int arg3);
int sub_93AC(int arg);
int sub_9450(int arg0, int arg1, int arg2);
int sub_99B8(int arg);
int sub_9B34(int arg);
int sub_9BAC(int arg0, int arg1, int arg2, int arg3);
int sub_9C6C(int arg0, int arg1, int arg2, int arg3);
int sub_9E70(int arg0, int arg1, int arg2, int arg3, int arg4);
int sub_A004(int arg0, int arg1, int arg2, int arg3, int arg4);
int sub_A0F8(int arg0, int arg1);
int sub_A188(int arg0, int arg1);
int sub_A240(int arg0, int arg1, int arg2, int arg3);
int sub_A2C0(int arg0, int arg1, int arg2, char *name, int arg4);
int sub_A558(int arg0, char *name, int arg2, int arg3, int arg4, int arg5);
int sub_A6DC(int arg0, int arg1);
int sub_A7F0(int arg0, int arg1, int arg2, int arg3);
int sub_A8C8(int arg0, int arg1, int arg2, int arg3);
int sub_A9B4(int arg0, int arg1, int arg2, int arg3);
int sub_AC5C(int arg0, int arg1, int arg2, int arg3, int arg4);
void sub_AE38(int arg0, int arg1);
int sub_AEA8(int arg0, int arg1);
int sub_AF34(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5);
int sub_B090(int arg0, int arg1);
int sub_B0E4(int arg0, int arg1, int arg2);
int sub_B274(int arg0, int arg1, int arg2, int arg3);
int sub_B60C(int arg0, int arg1, int arg2, int arg3, int arg4);
int sub_B714(int arg0, int arg1);
int sub_B7F4(int arg0, int arg1, int arg2, int arg3);
void sub_B970(int arg0, int arg1, int arg2, int arg3, int arg4);
int sub_BA7C(int arg);
void sub_BB34(char *arg);
char sub_BB48(char *arg);
char sub_BB5C(char *arg);
void sub_BB70(char *arg);
short sub_BB7C(char *arg);
void sub_BB90(char *arg0, int arg1);
short sub_BBA0(int arg0, int arg1);
int sub_BC04(int arg0, int arg1, int arg2);
int sub_BCF0(int arg);
int sub_BE34(int arg);
int sub_BEB8(int arg0, int arg1, int arg2);
int sub_BEEC(int arg);
int sub_BF3C();
int sub_BF64(int arg);
int sub_C318(int arg);
int sub_C3E4(int arg0, int arg1, int arg2);
u64 sub_C6C0(int arg0, int arg1, int arg2, int arg3, int arg4);
int sub_C7A0(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5);
int sub_CA80(int arg0, int arg1, int arg2, int arg3, int arg4);
int sub_CB58();
int sub_CBC0(int arg0, int arg1);
int sub_CBDC(int arg0, int arg1);
int sub_CC10();
int sub_CC70(int arg);
u64 sub_CCC4(int arg0, int arg1, int arg2);
int sub_CD28(int arg0, int arg1);
void sub_CD78();
int sub_CFBC(int arg0, int arg1, int arg2);
void sub_D1B4(int arg0, int arg1);
int sub_D224(int arg0, short arg1, int arg2);
int sub_D374();
int sub_D3F4(int arg0, int arg1, int arg2);
int sub_D500(int arg0, int arg1, short arg2);
int sub_D590(int arg);
int sub_D794(int arg0, int arg1, int arg2);
int sub_D8F0(int arg0, int arg1, int arg2);
int sub_D9A4(int arg0, int arg1, int arg2);
int sub_DB8C(int arg0, int arg1);
int sub_DD24(int arg0, int arg1);
void sub_DF30(int arg);
int sub_E3C8(int arg);
int sub_E438(int arg0, int arg1, int arg2, int arg3, int arg4);
int sub_E73C(int arg0, int arg1);
int sub_E7E8(int arg0, int arg1, short arg2);
int sub_E83C(int arg0, int arg1);
int sub_E8C8(int arg0, int arg1, int arg2, int arg3);
int sub_EA54(int arg0, int arg1, int arg2, int arg3);
int sub_EEA8(int arg0, int arg1);
int sub_F188();
int sub_F28C(int arg0, int arg1, int arg2, int arg3);
int sub_F458(int arg0, int arg1, int arg2, int arg3, int arg4);
int sub_F640(int arg);
int sub_F8DC(int arg);
int sub_F8EC(int arg0, int arg1, int arg2, int arg3);
int sub_F930(int arg0, int arg1, int arg2, int arg3);
int sub_F958(int arg0, int arg1, int arg2, int arg3);
int sub_F974(int arg0, int arg1, int arg2, int arg3);
int sub_F998(int arg0, int arg1, int arg2, int arg3);
int sub_F9D0(int arg0, int arg1, int arg2, int arg3);
int sub_FC40();
int sub_FF60(int arg0, int arg1, int arg2, int arg3);

#endif

