/* Copyright (C) 2011 - 2016 The uOFW team
   See the file COPYING for copying permission.
*/

/**
 * uofw/include/utility/utility_screenshot.h
 *
 */

#ifndef UTILITY_SCREENSHOT_H
#define	UTILITY_SCREENSHOT_H

/* Screenshot utility specific error codes (0x80111200 - 0x801112ff). */

#define SCE_UTILITY_SCREENSHOT_ERROR_INVALID_DISPLAY_PIXEL_FORMAT       (0x80111206)    /*!< The specified display pixel format is invalid. */
#define SCE_UTILITY_SCREENSHOT_ERROR_INVALID_SCREENSHOT_EXTENT			(0x80111207)    /*!< The specified rectangular screenshot area is invalid. */
#define SCE_UTILITY_SCREENSHOT_ERROR_POINTER_IS_NULL					(0x80111208)    /*!< Detected NULL pointer error. */
#define SCE_UTILITY_SCREENSHOT_ERROR_INVALID_IMAGE_TYPE					(0x80111209)    /*!< The specified image type is invalid. */
#define SCE_UTILITY_SCREENSHOT_ERROR_OPEN_FILE							(0x8011120b)
#define SCE_UTILITY_SCREENSHOT_ERROR_CANT_WRITE_SCREENSHOT_IMAGE		(0x8011120c)
#define SCE_UTILITY_SCREENSHOT_ERROR_LOAD_NO_MS							(0x8011120d)
#define SCE_UTILITY_SCREENSHOT_ERROR_SAVE_MS_PROTECTED					(0x8011120e)
#define SCE_UTILITY_SCREENSHOT_ERROR_FAILED_MAKE_SCREENSHOT_ROOT_DIR	(0x8011120f)
#define SCE_UTILITY_SCREENSHOT_ERROR_FAILED_MAKE_SAVE_DIR				(0x80111210)
#define SCE_UTILITY_SCREENSHOT_ERROR_FAILED_OPEN_SAVE_DIR				(0x80111211)
#define SCE_UTILITY_SCREENSHOT_ERROR_FAILED_READ_SAVE_DIR_INFO			(0x80111212)
#define SCE_UTILITY_SCREENSHOT_ERROR_INVALID_FILE_NAME					(0x80111213)
#define SCE_UTILITY_SCREENSHOT_ERROR_LOAD_EJECT_MS						(0x80111214)
#define SCE_UTILITY_SCREENSHOT_ERROR_SAVE_MS_NOSPACE					(0x80111215)
#define SCE_UTILITY_SCREENSHOT_ERROR_SAVE_ACCESS_ERROR					(0x80111216)
#define SCE_UTILITY_SCREENSHOT_ERROR_INVALID_FRAMEBUFFER				(0x80111219)
#define SCE_UTILITY_SCREENSHOT_ERROR_INVALID_TITLE_ID					(0x8011121b)
#define SCE_UTILITY_SCREENSHOT_ERROR_INVALID_BOOT_PARAM					(0x8011121c)
#define SCE_UTILITY_SCREENSHOT_ERROR_NOT_FOUND_PSCMDAT_IMAGE_FILE		(0x8011121d)
#define SCE_UTILITY_SCREENSHOT_ERROR_INVALID_FILE_SIZE					(0x8011121e)
#define SCE_UTILITY_SCREENSHOT_ERROR_INVALID_PATH_SIZE					(0x8011121f)
#define SCE_UTILITY_SCREENSHOT_ERROR_FAILED_OPEN_PSCMDAT				(0x80111220)
#define SCE_UTILITY_SCREENSHOT_ERROR_FAILED_WRITE_PSCMDAT				(0x80111221)
#define SCE_UTILITY_SCREENSHOT_ERROR_FAILED_OPEN_SRCFILE_FOR_PSCMDAT	(0x80111222)
#define SCE_UTILITY_SCREENSHOT_ERROR_FAILED_READ_SRCFILE_FOR_PSCMDAT	(0x80111223)
#define SCE_UTILITY_SCREENSHOT_ERROR_FAILED_SAVE_SCREENSHOT_WITH_NUMBER	(0x80111224)
#define SCE_UTILITY_SCREENSHOT_ERROR_INVALID_COMMENT_PARAMS				(0x80111225)
#define SCE_UTILITY_SCREENSHOT_ERROR_DETECTED_INVALID_STRING			(0x80111226)
#define SCE_UTILITY_SCREENSHOT_ERROR_INVALID_UTILITY_TYPE				(0x80111227)
#define SCE_UTILITY_SCREENSHOT_ERROR_INCOMPLETE_WRITING_IMAGE			(0x80111228)
#define SCE_UTILITY_SCREENSHOT_ERROR_HAVE_NOT_CONT_MODE_START_YET		(0x80111229)
#define SCE_UTILITY_SCREENSHOT_ERROR_LOAD_EJECT_MS2						(0x80111233)

#define SCE_UTILITY_SCREENSHOT_ERROR_NOT_FOUND_THE_TARGET_DIR_FOR_VIEW	(0x8011123c)	
#define SCE_UTILITY_SCREENSHOT_ERROR_FOUND_SAME_FILE_NAME				(0x8011123d)
#define SCE_UTILITY_SCREENSHOT_ERROR_VAST_THE_MAX_NUMBER_OF_IMAGE_FILE	(0x8011123e)	
#define SCE_UTILITY_SCREENSHOT_ERROR_VIEW_ACCESS_ERROR					(0x80111241)

#endif	/* UTILITY_SCREENSHOT_H */

