// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/LICENSE

// codemirror: v.5.61.1
// modified by unixman

(function(mod) {
	if (typeof exports == "object" && typeof module == "object") // CommonJS
		mod(require("../../lib/codemirror"), require("../htmlmixed/htmlmixed"),
				require("../../addon/mode/multiplex"));
	else if (typeof define == "function" && define.amd) // AMD
		define(["../../lib/codemirror", "../htmlmixed/htmlmixed",
						"../../addon/mode/multiplex"], mod);
	else // Plain browser env
		mod(CodeMirror);
})(function(CodeMirror) {
	"use strict";

	CodeMirror.defineMode("htmlembedded", function(config, parserConfig) {
		var closeComment = parserConfig.closeComment || "--%>"
		return CodeMirror.multiplexingMode(CodeMirror.getMode(config, "htmlmixed"), {
			open: parserConfig.openComment || "<%--",
			close: closeComment,
			delimStyle: "comment",
			mode: {token: function(stream) {
				stream.skipTo(closeComment) || stream.skipToEnd()
				return "comment"
			}}
		}, {
			open: parserConfig.open || parserConfig.scriptStartRegex || "<%",
			close: parserConfig.close || parserConfig.scriptEndRegex || "%>",
			mode: CodeMirror.getMode(config, parserConfig.scriptingModeSpec)
		});
	}, "htmlmixed");

	CodeMirror.defineMIME("application/x-ejs", {name: "htmlembedded", scriptingModeSpec:"javascript"});
	// unixman: deleted the rest ... not supported in framework but in modules !
});

// #END
