
// # JS Package: addons.pak.js :: #START# :: @ generated from lib/js/jseditcode/codemirror/addon/%/*.js
// Included Addons: mode/simple.js ; fold/foldcode.js ; fold/foldgutter.js ; fold/brace-fold.js ; fold/indent-fold.js ; fold/comment-fold.js ; fold/markdown-fold.js ; fold/xml-fold.js ; edit/matchtags.js ; edit/matchbrackets.js ; dialog/dialog.js ; search/searchcursor.js ; search/search.js ; selection/active-line.js ; display/fullscreen.js #

// ### DO NOT EDIT THIS FILE AS IT WILL BE OVERWRITTEN EACH TIME THE INCLUDED SCRIPTS WILL CHANGE !!! ###

// ===== mode/simple.js
// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/LICENSE

// codemirror: v.5.61.1

(function(mod) {
	if (typeof exports == "object" && typeof module == "object") // CommonJS
		mod(require("../../lib/codemirror"));
	else if (typeof define == "function" && define.amd) // AMD
		define(["../../lib/codemirror"], mod);
	else // Plain browser env
		mod(CodeMirror);
})(function(CodeMirror) {
	"use strict";

	CodeMirror.defineSimpleMode = function(name, states) {
		CodeMirror.defineMode(name, function(config) {
			return CodeMirror.simpleMode(config, states);
		});
	};

	CodeMirror.simpleMode = function(config, states) {
		ensureState(states, "start");
		var states_ = {}, meta = states.meta || {}, hasIndentation = false;
		for (var state in states) if (state != meta && states.hasOwnProperty(state)) {
			var list = states_[state] = [], orig = states[state];
			for (var i = 0; i < orig.length; i++) {
				var data = orig[i];
				list.push(new Rule(data, states));
				if (data.indent || data.dedent) hasIndentation = true;
			}
		}
		var mode = {
			startState: function() {
				return {state: "start", pending: null,
								local: null, localState: null,
								indent: hasIndentation ? [] : null};
			},
			copyState: function(state) {
				var s = {state: state.state, pending: state.pending,
								 local: state.local, localState: null,
								 indent: state.indent && state.indent.slice(0)};
				if (state.localState)
					s.localState = CodeMirror.copyState(state.local.mode, state.localState);
				if (state.stack)
					s.stack = state.stack.slice(0);
				for (var pers = state.persistentStates; pers; pers = pers.next)
					s.persistentStates = {mode: pers.mode,
																spec: pers.spec,
																state: pers.state == state.localState ? s.localState : CodeMirror.copyState(pers.mode, pers.state),
																next: s.persistentStates};
				return s;
			},
			token: tokenFunction(states_, config),
			innerMode: function(state) { return state.local && {mode: state.local.mode, state: state.localState}; },
			indent: indentFunction(states_, meta)
		};
		if (meta) for (var prop in meta) if (meta.hasOwnProperty(prop))
			mode[prop] = meta[prop];
		return mode;
	};

	function ensureState(states, name) {
		if (!states.hasOwnProperty(name))
			throw new Error("Undefined state " + name + " in simple mode");
	}

	function toRegex(val, caret) {
		if (!val) return /(?:)/;
		var flags = "";
		if (val instanceof RegExp) {
			if (val.ignoreCase) flags = "i";
			if (val.unicode) flags += "u"
			val = val.source;
		} else {
			val = String(val);
		}
		return new RegExp((caret === false ? "" : "^") + "(?:" + val + ")", flags);
	}

	function asToken(val) {
		if (!val) return null;
		if (val.apply) return val
		if (typeof val == "string") return val.replace(/\./g, " ");
		var result = [];
		for (var i = 0; i < val.length; i++)
			result.push(val[i] && val[i].replace(/\./g, " "));
		return result;
	}

	function Rule(data, states) {
		if (data.next || data.push) ensureState(states, data.next || data.push);
		this.regex = toRegex(data.regex);
		this.token = asToken(data.token);
		this.data = data;
	}

	function tokenFunction(states, config) {
		return function(stream, state) {
			if (state.pending) {
				var pend = state.pending.shift();
				if (state.pending.length == 0) state.pending = null;
				stream.pos += pend.text.length;
				return pend.token;
			}

			if (state.local) {
				if (state.local.end && stream.match(state.local.end)) {
					var tok = state.local.endToken || null;
					state.local = state.localState = null;
					return tok;
				} else {
					var tok = state.local.mode.token(stream, state.localState), m;
					if (state.local.endScan && (m = state.local.endScan.exec(stream.current())))
						stream.pos = stream.start + m.index;
					return tok;
				}
			}

			var curState = states[state.state];
			for (var i = 0; i < curState.length; i++) {
				var rule = curState[i];
				var matches = (!rule.data.sol || stream.sol()) && stream.match(rule.regex);
				if (matches) {
					if (rule.data.next) {
						state.state = rule.data.next;
					} else if (rule.data.push) {
						(state.stack || (state.stack = [])).push(state.state);
						state.state = rule.data.push;
					} else if (rule.data.pop && state.stack && state.stack.length) {
						state.state = state.stack.pop();
					}

					if (rule.data.mode)
						enterLocalMode(config, state, rule.data.mode, rule.token);
					if (rule.data.indent)
						state.indent.push(stream.indentation() + config.indentUnit);
					if (rule.data.dedent)
						state.indent.pop();
					var token = rule.token
					if (token && token.apply) token = token(matches)
					if (matches.length > 2 && rule.token && typeof rule.token != "string") {
						for (var j = 2; j < matches.length; j++)
							if (matches[j])
								(state.pending || (state.pending = [])).push({text: matches[j], token: rule.token[j - 1]});
						stream.backUp(matches[0].length - (matches[1] ? matches[1].length : 0));
						return token[0];
					} else if (token && token.join) {
						return token[0];
					} else {
						return token;
					}
				}
			}
			stream.next();
			return null;
		};
	}

	function cmp(a, b) {
		if (a === b) return true;
		if (!a || typeof a != "object" || !b || typeof b != "object") return false;
		var props = 0;
		for (var prop in a) if (a.hasOwnProperty(prop)) {
			if (!b.hasOwnProperty(prop) || !cmp(a[prop], b[prop])) return false;
			props++;
		}
		for (var prop in b) if (b.hasOwnProperty(prop)) props--;
		return props == 0;
	}

	function enterLocalMode(config, state, spec, token) {
		var pers;
		if (spec.persistent) for (var p = state.persistentStates; p && !pers; p = p.next)
			if (spec.spec ? cmp(spec.spec, p.spec) : spec.mode == p.mode) pers = p;
		var mode = pers ? pers.mode : spec.mode || CodeMirror.getMode(config, spec.spec);
		var lState = pers ? pers.state : CodeMirror.startState(mode);
		if (spec.persistent && !pers)
			state.persistentStates = {mode: mode, spec: spec.spec, state: lState, next: state.persistentStates};

		state.localState = lState;
		state.local = {mode: mode,
									 end: spec.end && toRegex(spec.end),
									 endScan: spec.end && spec.forceEnd !== false && toRegex(spec.end, false),
									 endToken: token && token.join ? token[token.length - 1] : token};
	}

	function indexOf(val, arr) {
		for (var i = 0; i < arr.length; i++) if (arr[i] === val) return true;
	}

	function indentFunction(states, meta) {
		return function(state, textAfter, line) {
			if (state.local && state.local.mode.indent)
				return state.local.mode.indent(state.localState, textAfter, line);
			if (state.indent == null || state.local || meta.dontIndentStates && indexOf(state.state, meta.dontIndentStates) > -1)
				return CodeMirror.Pass;

			var pos = state.indent.length - 1, rules = states[state.state];
			scan: for (;;) {
				for (var i = 0; i < rules.length; i++) {
					var rule = rules[i];
					if (rule.data.dedent && rule.data.dedentIfLineStart !== false) {
						var m = rule.regex.exec(textAfter);
						if (m && m[0]) {
							pos--;
							if (rule.next || rule.push) rules = states[rule.next || rule.push];
							textAfter = textAfter.slice(m[0].length);
							continue scan;
						}
					}
				}
				break;
			}
			return pos < 0 ? 0 : state.indent[pos];
		};
	}
});

// #END

// ===== fold/foldcode.js
// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/5/LICENSE

// codemirror: v.5.65.15

(function(mod) {
	if (typeof exports == "object" && typeof module == "object") // CommonJS
		mod(require("../../lib/codemirror"));
	else if (typeof define == "function" && define.amd) // AMD
		define(["../../lib/codemirror"], mod);
	else // Plain browser env
		mod(CodeMirror);
})(function(CodeMirror) {
	"use strict";

	function doFold(cm, pos, options, force) {
		if (options && options.call) {
			var finder = options;
			options = null;
		} else {
			var finder = getOption(cm, options, "rangeFinder");
		}
		if (typeof pos == "number") pos = CodeMirror.Pos(pos, 0);
		var minSize = getOption(cm, options, "minFoldSize");

		function getRange(allowFolded) {
			var range = finder(cm, pos);
			if (!range || range.to.line - range.from.line < minSize) return null;
			if (force === "fold") return range;

			var marks = cm.findMarksAt(range.from);
			for (var i = 0; i < marks.length; ++i) {
				if (marks[i].__isFold) {
					if (!allowFolded) return null;
					range.cleared = true;
					marks[i].clear();
				}
			}
			return range;
		}

		var range = getRange(true);
		if (getOption(cm, options, "scanUp")) while (!range && pos.line > cm.firstLine()) {
			pos = CodeMirror.Pos(pos.line - 1, 0);
			range = getRange(false);
		}
		if (!range || range.cleared || force === "unfold") return;

		var myWidget = makeWidget(cm, options, range);
		CodeMirror.on(myWidget, "mousedown", function(e) {
			myRange.clear();
			CodeMirror.e_preventDefault(e);
		});
		var myRange = cm.markText(range.from, range.to, {
			replacedWith: myWidget,
			clearOnEnter: getOption(cm, options, "clearOnEnter"),
			__isFold: true
		});
		myRange.on("clear", function(from, to) {
			CodeMirror.signal(cm, "unfold", cm, from, to);
		});
		CodeMirror.signal(cm, "fold", cm, range.from, range.to);
	}

	function makeWidget(cm, options, range) {
		var widget = getOption(cm, options, "widget");

		if (typeof widget == "function") {
			widget = widget(range.from, range.to);
		}

		if (typeof widget == "string") {
			var text = document.createTextNode(widget);
			widget = document.createElement("span");
			widget.appendChild(text);
			widget.className = "CodeMirror-foldmarker";
		} else if (widget) {
			widget = widget.cloneNode(true)
		}
		return widget;
	}

	// Clumsy backwards-compatible interface
	CodeMirror.newFoldFunction = function(rangeFinder, widget) {
		return function(cm, pos) { doFold(cm, pos, {rangeFinder: rangeFinder, widget: widget}); };
	};

	// New-style interface
	CodeMirror.defineExtension("foldCode", function(pos, options, force) {
		doFold(this, pos, options, force);
	});

	CodeMirror.defineExtension("isFolded", function(pos) {
		var marks = this.findMarksAt(pos);
		for (var i = 0; i < marks.length; ++i)
			if (marks[i].__isFold) return true;
	});

	CodeMirror.commands.toggleFold = function(cm) {
		cm.foldCode(cm.getCursor());
	};
	CodeMirror.commands.fold = function(cm) {
		cm.foldCode(cm.getCursor(), null, "fold");
	};
	CodeMirror.commands.unfold = function(cm) {
		cm.foldCode(cm.getCursor(), { scanUp: false }, "unfold");
	};
	CodeMirror.commands.foldAll = function(cm) {
		cm.operation(function() {
			for (var i = cm.firstLine(), e = cm.lastLine(); i <= e; i++)
				cm.foldCode(CodeMirror.Pos(i, 0), { scanUp: false }, "fold");
		});
	};
	CodeMirror.commands.unfoldAll = function(cm) {
		cm.operation(function() {
			for (var i = cm.firstLine(), e = cm.lastLine(); i <= e; i++)
				cm.foldCode(CodeMirror.Pos(i, 0), { scanUp: false }, "unfold");
		});
	};

	CodeMirror.registerHelper("fold", "combine", function() {
		var funcs = Array.prototype.slice.call(arguments, 0);
		return function(cm, start) {
			for (var i = 0; i < funcs.length; ++i) {
				var found = funcs[i](cm, start);
				if (found) return found;
			}
		};
	});

	CodeMirror.registerHelper("fold", "auto", function(cm, start) {
		var helpers = cm.getHelpers(start, "fold");
		for (var i = 0; i < helpers.length; i++) {
			var cur = helpers[i](cm, start);
			if (cur) return cur;
		}
	});

	var defaultOptions = {
		rangeFinder: CodeMirror.fold.auto,
		widget: "\u2194",
		minFoldSize: 0,
		scanUp: false,
		clearOnEnter: true
	};

	CodeMirror.defineOption("foldOptions", null);

	function getOption(cm, options, name) {
		if (options && options[name] !== undefined)
			return options[name];
		var editorOptions = cm.options.foldOptions;
		if (editorOptions && editorOptions[name] !== undefined)
			return editorOptions[name];
		return defaultOptions[name];
	}

	CodeMirror.defineExtension("foldOption", function(options, name) {
		return getOption(this, options, name);
	});
});

// #END

// ===== fold/foldgutter.js
// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/5/LICENSE

// codemirror: v.5.65.15

(function(mod) {
	if (typeof exports == "object" && typeof module == "object") // CommonJS
		mod(require("../../lib/codemirror"), require("./foldcode"));
	else if (typeof define == "function" && define.amd) // AMD
		define(["../../lib/codemirror", "./foldcode"], mod);
	else // Plain browser env
		mod(CodeMirror);
})(function(CodeMirror) {
	"use strict";

	CodeMirror.defineOption("foldGutter", false, function(cm, val, old) {
		if (old && old != CodeMirror.Init) {
			cm.clearGutter(cm.state.foldGutter.options.gutter);
			cm.state.foldGutter = null;
			cm.off("gutterClick", onGutterClick);
			cm.off("changes", onChange);
			cm.off("viewportChange", onViewportChange);
			cm.off("fold", onFold);
			cm.off("unfold", onFold);
			cm.off("swapDoc", onChange);
			cm.off("optionChange", optionChange);
		}
		if (val) {
			cm.state.foldGutter = new State(parseOptions(val));
			updateInViewport(cm);
			cm.on("gutterClick", onGutterClick);
			cm.on("changes", onChange);
			cm.on("viewportChange", onViewportChange);
			cm.on("fold", onFold);
			cm.on("unfold", onFold);
			cm.on("swapDoc", onChange);
			cm.on("optionChange", optionChange);
		}
	});

	var Pos = CodeMirror.Pos;

	function State(options) {
		this.options = options;
		this.from = this.to = 0;
	}

	function parseOptions(opts) {
		if (opts === true) opts = {};
		if (opts.gutter == null) opts.gutter = "CodeMirror-foldgutter";
		if (opts.indicatorOpen == null) opts.indicatorOpen = "CodeMirror-foldgutter-open";
		if (opts.indicatorFolded == null) opts.indicatorFolded = "CodeMirror-foldgutter-folded";
		return opts;
	}

	function isFolded(cm, line) {
		var marks = cm.findMarks(Pos(line, 0), Pos(line + 1, 0));
		for (var i = 0; i < marks.length; ++i) {
			if (marks[i].__isFold) {
				var fromPos = marks[i].find(-1);
				if (fromPos && fromPos.line === line)
					return marks[i];
			}
		}
	}

	function marker(spec) {
		if (typeof spec == "string") {
			var elt = document.createElement("div");
			elt.className = spec + " CodeMirror-guttermarker-subtle";
			return elt;
		} else {
			return spec.cloneNode(true);
		}
	}

	function updateFoldInfo(cm, from, to) {
		var opts = cm.state.foldGutter.options, cur = from - 1;
		var minSize = cm.foldOption(opts, "minFoldSize");
		var func = cm.foldOption(opts, "rangeFinder");
		// we can reuse the built-in indicator element if its className matches the new state
		var clsFolded = typeof opts.indicatorFolded == "string" && classTest(opts.indicatorFolded);
		var clsOpen = typeof opts.indicatorOpen == "string" && classTest(opts.indicatorOpen);
		cm.eachLine(from, to, function(line) {
			++cur;
			var mark = null;
			var old = line.gutterMarkers;
			if (old) old = old[opts.gutter];
			if (isFolded(cm, cur)) {
				if (clsFolded && old && clsFolded.test(old.className)) return;
				mark = marker(opts.indicatorFolded);
			} else {
				var pos = Pos(cur, 0);
				var range = func && func(cm, pos);
				if (range && range.to.line - range.from.line >= minSize) {
					if (clsOpen && old && clsOpen.test(old.className)) return;
					mark = marker(opts.indicatorOpen);
				}
			}
			if (!mark && !old) return;
			cm.setGutterMarker(line, opts.gutter, mark);
		});
	}

	// copied from CodeMirror/src/util/dom.js
	function classTest(cls) { return new RegExp("(^|\\s)" + cls + "(?:$|\\s)\\s*") }

	function updateInViewport(cm) {
		var vp = cm.getViewport(), state = cm.state.foldGutter;
		if (!state) return;
		cm.operation(function() {
			updateFoldInfo(cm, vp.from, vp.to);
		});
		state.from = vp.from; state.to = vp.to;
	}

	function onGutterClick(cm, line, gutter) {
		var state = cm.state.foldGutter;
		if (!state) return;
		var opts = state.options;
		if (gutter != opts.gutter) return;
		var folded = isFolded(cm, line);
		if (folded) folded.clear();
		else cm.foldCode(Pos(line, 0), opts);
	}

	function optionChange(cm, option) {
		if (option == "mode") onChange(cm)
	}

	function onChange(cm) {
		var state = cm.state.foldGutter;
		if (!state) return;
		var opts = state.options;
		state.from = state.to = 0;
		clearTimeout(state.changeUpdate);
		state.changeUpdate = setTimeout(function() { updateInViewport(cm); }, opts.foldOnChangeTimeSpan || 600);
	}

	function onViewportChange(cm) {
		var state = cm.state.foldGutter;
		if (!state) return;
		var opts = state.options;
		clearTimeout(state.changeUpdate);
		state.changeUpdate = setTimeout(function() {
			var vp = cm.getViewport();
			if (state.from == state.to || vp.from - state.to > 20 || state.from - vp.to > 20) {
				updateInViewport(cm);
			} else {
				cm.operation(function() {
					if (vp.from < state.from) {
						updateFoldInfo(cm, vp.from, state.from);
						state.from = vp.from;
					}
					if (vp.to > state.to) {
						updateFoldInfo(cm, state.to, vp.to);
						state.to = vp.to;
					}
				});
			}
		}, opts.updateViewportTimeSpan || 400);
	}

	function onFold(cm, from) {
		var state = cm.state.foldGutter;
		if (!state) return;
		var line = from.line;
		if (line >= state.from && line < state.to)
			updateFoldInfo(cm, line, line + 1);
	}
});

// #END

// ===== fold/brace-fold.js
// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/5/LICENSE

// codemirror: v.5.65.15

(function(mod) {
	if (typeof exports == "object" && typeof module == "object") // CommonJS
		mod(require("../../lib/codemirror"));
	else if (typeof define == "function" && define.amd) // AMD
		define(["../../lib/codemirror"], mod);
	else // Plain browser env
		mod(CodeMirror);
})(function(CodeMirror) {
"use strict";

function bracketFolding(pairs) {
	return function(cm, start) {
		var line = start.line, lineText = cm.getLine(line);

		function findOpening(pair) {
			var tokenType;
			for (var at = start.ch, pass = 0;;) {
				var found = at <= 0 ? -1 : lineText.lastIndexOf(pair[0], at - 1);
				if (found == -1) {
					if (pass == 1) break;
					pass = 1;
					at = lineText.length;
					continue;
				}
				if (pass == 1 && found < start.ch) break;
				tokenType = cm.getTokenTypeAt(CodeMirror.Pos(line, found + 1));
				if (!/^(comment|string)/.test(tokenType)) return {ch: found + 1, tokenType: tokenType, pair: pair};
				at = found - 1;
			}
		}

		function findRange(found) {
			var count = 1, lastLine = cm.lastLine(), end, startCh = found.ch, endCh
			outer: for (var i = line; i <= lastLine; ++i) {
				var text = cm.getLine(i), pos = i == line ? startCh : 0;
				for (;;) {
					var nextOpen = text.indexOf(found.pair[0], pos), nextClose = text.indexOf(found.pair[1], pos);
					if (nextOpen < 0) nextOpen = text.length;
					if (nextClose < 0) nextClose = text.length;
					pos = Math.min(nextOpen, nextClose);
					if (pos == text.length) break;
					if (cm.getTokenTypeAt(CodeMirror.Pos(i, pos + 1)) == found.tokenType) {
						if (pos == nextOpen) ++count;
						else if (!--count) { end = i; endCh = pos; break outer; }
					}
					++pos;
				}
			}

			if (end == null || line == end) return null
			return {from: CodeMirror.Pos(line, startCh),
							to: CodeMirror.Pos(end, endCh)};
		}

		var found = []
		for (var i = 0; i < pairs.length; i++) {
			var open = findOpening(pairs[i])
			if (open) found.push(open)
		}
		found.sort(function(a, b) { return a.ch - b.ch })
		for (var i = 0; i < found.length; i++) {
			var range = findRange(found[i])
			if (range) return range
		}
		return null
	}
}

CodeMirror.registerHelper("fold", "brace", bracketFolding([["{", "}"], ["[", "]"]]));

CodeMirror.registerHelper("fold", "brace-paren", bracketFolding([["{", "}"], ["[", "]"], ["(", ")"]]));

CodeMirror.registerHelper("fold", "import", function(cm, start) {
	function hasImport(line) {
		if (line < cm.firstLine() || line > cm.lastLine()) return null;
		var start = cm.getTokenAt(CodeMirror.Pos(line, 1));
		if (!/\S/.test(start.string)) start = cm.getTokenAt(CodeMirror.Pos(line, start.end + 1));
		if (start.type != "keyword" || start.string != "import") return null;
		// Now find closing semicolon, return its position
		for (var i = line, e = Math.min(cm.lastLine(), line + 10); i <= e; ++i) {
			var text = cm.getLine(i), semi = text.indexOf(";");
			if (semi != -1) return {startCh: start.end, end: CodeMirror.Pos(i, semi)};
		}
	}

	var startLine = start.line, has = hasImport(startLine), prev;
	if (!has || hasImport(startLine - 1) || ((prev = hasImport(startLine - 2)) && prev.end.line == startLine - 1))
		return null;
	for (var end = has.end;;) {
		var next = hasImport(end.line + 1);
		if (next == null) break;
		end = next.end;
	}
	return {from: cm.clipPos(CodeMirror.Pos(startLine, has.startCh + 1)), to: end};
});

CodeMirror.registerHelper("fold", "include", function(cm, start) {
	function hasInclude(line) {
		if (line < cm.firstLine() || line > cm.lastLine()) return null;
		var start = cm.getTokenAt(CodeMirror.Pos(line, 1));
		if (!/\S/.test(start.string)) start = cm.getTokenAt(CodeMirror.Pos(line, start.end + 1));
		if (start.type == "meta" && start.string.slice(0, 8) == "#include") return start.start + 8;
	}

	var startLine = start.line, has = hasInclude(startLine);
	if (has == null || hasInclude(startLine - 1) != null) return null;
	for (var end = startLine;;) {
		var next = hasInclude(end + 1);
		if (next == null) break;
		++end;
	}
	return {from: CodeMirror.Pos(startLine, has + 1),
					to: cm.clipPos(CodeMirror.Pos(end))};
});

});

// #END

// ===== fold/indent-fold.js
// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/5/LICENSE

// codemirror: v.5.65.15

(function(mod) {
	if (typeof exports == "object" && typeof module == "object") // CommonJS
		mod(require("../../lib/codemirror"));
	else if (typeof define == "function" && define.amd) // AMD
		define(["../../lib/codemirror"], mod);
	else // Plain browser env
		mod(CodeMirror);
})(function(CodeMirror) {
"use strict";

function lineIndent(cm, lineNo) {
	var text = cm.getLine(lineNo)
	var spaceTo = text.search(/\S/)
	if (spaceTo == -1 || /\bcomment\b/.test(cm.getTokenTypeAt(CodeMirror.Pos(lineNo, spaceTo + 1))))
		return -1
	return CodeMirror.countColumn(text, null, cm.getOption("tabSize"))
}

CodeMirror.registerHelper("fold", "indent", function(cm, start) {
	var myIndent = lineIndent(cm, start.line)
	if (myIndent < 0) return
	var lastLineInFold = null

	// Go through lines until we find a line that definitely doesn't belong in
	// the block we're folding, or to the end.
	for (var i = start.line + 1, end = cm.lastLine(); i <= end; ++i) {
		var indent = lineIndent(cm, i)
		if (indent == -1) {
		} else if (indent > myIndent) {
			// Lines with a greater indent are considered part of the block.
			lastLineInFold = i;
		} else {
			// If this line has non-space, non-comment content, and is
			// indented less or equal to the start line, it is the start of
			// another block.
			break;
		}
	}
	if (lastLineInFold) return {
		from: CodeMirror.Pos(start.line, cm.getLine(start.line).length),
		to: CodeMirror.Pos(lastLineInFold, cm.getLine(lastLineInFold).length)
	};
});

});

// #END

// ===== fold/comment-fold.js
// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/5/LICENSE

// codemirror: v.5.65.15

(function(mod) {
	if (typeof exports == "object" && typeof module == "object") // CommonJS
		mod(require("../../lib/codemirror"));
	else if (typeof define == "function" && define.amd) // AMD
		define(["../../lib/codemirror"], mod);
	else // Plain browser env
		mod(CodeMirror);
})(function(CodeMirror) {
"use strict";

CodeMirror.registerGlobalHelper("fold", "comment", function(mode) {
	return mode.blockCommentStart && mode.blockCommentEnd;
}, function(cm, start) {
	var mode = cm.getModeAt(start), startToken = mode.blockCommentStart, endToken = mode.blockCommentEnd;
	if (!startToken || !endToken) return;
	var line = start.line, lineText = cm.getLine(line);

	var startCh;
	for (var at = start.ch, pass = 0;;) {
		var found = at <= 0 ? -1 : lineText.lastIndexOf(startToken, at - 1);
		if (found == -1) {
			if (pass == 1) return;
			pass = 1;
			at = lineText.length;
			continue;
		}
		if (pass == 1 && found < start.ch) return;
		if (/comment/.test(cm.getTokenTypeAt(CodeMirror.Pos(line, found + 1))) &&
				(found == 0 || lineText.slice(found - endToken.length, found) == endToken ||
				 !/comment/.test(cm.getTokenTypeAt(CodeMirror.Pos(line, found))))) {
			startCh = found + startToken.length;
			break;
		}
		at = found - 1;
	}

	var depth = 1, lastLine = cm.lastLine(), end, endCh;
	outer: for (var i = line; i <= lastLine; ++i) {
		var text = cm.getLine(i), pos = i == line ? startCh : 0;
		for (;;) {
			var nextOpen = text.indexOf(startToken, pos), nextClose = text.indexOf(endToken, pos);
			if (nextOpen < 0) nextOpen = text.length;
			if (nextClose < 0) nextClose = text.length;
			pos = Math.min(nextOpen, nextClose);
			if (pos == text.length) break;
			if (pos == nextOpen) ++depth;
			else if (!--depth) { end = i; endCh = pos; break outer; }
			++pos;
		}
	}
	if (end == null || line == end && endCh == startCh) return;
	return {from: CodeMirror.Pos(line, startCh),
					to: CodeMirror.Pos(end, endCh)};
});

});

// #END

// ===== fold/markdown-fold.js
// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/5/LICENSE

// codemirror: v.5.65.15

(function(mod) {
	if (typeof exports == "object" && typeof module == "object") // CommonJS
		mod(require("../../lib/codemirror"));
	else if (typeof define == "function" && define.amd) // AMD
		define(["../../lib/codemirror"], mod);
	else // Plain browser env
		mod(CodeMirror);
})(function(CodeMirror) {
"use strict";

CodeMirror.registerHelper("fold", "markdown", function(cm, start) {
	var maxDepth = 100;

	function isHeader(lineNo) {
		var tokentype = cm.getTokenTypeAt(CodeMirror.Pos(lineNo, 0));
		return tokentype && /\bheader\b/.test(tokentype);
	}

	function headerLevel(lineNo, line, nextLine) {
		var match = line && line.match(/^#+/);
		if (match && isHeader(lineNo)) return match[0].length;
		match = nextLine && nextLine.match(/^[=\-]+\s*$/);
		if (match && isHeader(lineNo + 1)) return nextLine[0] == "=" ? 1 : 2;
		return maxDepth;
	}

	var firstLine = cm.getLine(start.line), nextLine = cm.getLine(start.line + 1);
	var level = headerLevel(start.line, firstLine, nextLine);
	if (level === maxDepth) return undefined;

	var lastLineNo = cm.lastLine();
	var end = start.line, nextNextLine = cm.getLine(end + 2);
	while (end < lastLineNo) {
		if (headerLevel(end + 1, nextLine, nextNextLine) <= level) break;
		++end;
		nextLine = nextNextLine;
		nextNextLine = cm.getLine(end + 2);
	}

	return {
		from: CodeMirror.Pos(start.line, firstLine.length),
		to: CodeMirror.Pos(end, cm.getLine(end).length)
	};
});

});

// #END

// ===== fold/xml-fold.js
// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/5/LICENSE

// codemirror: v.5.65.15

(function(mod) {
	if (typeof exports == "object" && typeof module == "object") // CommonJS
		mod(require("../../lib/codemirror"));
	else if (typeof define == "function" && define.amd) // AMD
		define(["../../lib/codemirror"], mod);
	else // Plain browser env
		mod(CodeMirror);
})(function(CodeMirror) {
	"use strict";

	var Pos = CodeMirror.Pos;
	function cmp(a, b) { return a.line - b.line || a.ch - b.ch; }

	var nameStartChar = "A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD";
	var nameChar = nameStartChar + "\-\:\.0-9\\u00B7\\u0300-\\u036F\\u203F-\\u2040";
	var xmlTagStart = new RegExp("<(/?)([" + nameStartChar + "][" + nameChar + "]*)", "g");

	function Iter(cm, line, ch, range) {
		this.line = line; this.ch = ch;
		this.cm = cm; this.text = cm.getLine(line);
		this.min = range ? Math.max(range.from, cm.firstLine()) : cm.firstLine();
		this.max = range ? Math.min(range.to - 1, cm.lastLine()) : cm.lastLine();
	}

	function tagAt(iter, ch) {
		var type = iter.cm.getTokenTypeAt(Pos(iter.line, ch));
		return type && /\btag\b/.test(type);
	}

	function nextLine(iter) {
		if (iter.line >= iter.max) return;
		iter.ch = 0;
		iter.text = iter.cm.getLine(++iter.line);
		return true;
	}
	function prevLine(iter) {
		if (iter.line <= iter.min) return;
		iter.text = iter.cm.getLine(--iter.line);
		iter.ch = iter.text.length;
		return true;
	}

	function toTagEnd(iter) {
		for (;;) {
			var gt = iter.text.indexOf(">", iter.ch);
			if (gt == -1) { if (nextLine(iter)) continue; else return; }
			if (!tagAt(iter, gt + 1)) { iter.ch = gt + 1; continue; }
			var lastSlash = iter.text.lastIndexOf("/", gt);
			var selfClose = lastSlash > -1 && !/\S/.test(iter.text.slice(lastSlash + 1, gt));
			iter.ch = gt + 1;
			return selfClose ? "selfClose" : "regular";
		}
	}
	function toTagStart(iter) {
		for (;;) {
			var lt = iter.ch ? iter.text.lastIndexOf("<", iter.ch - 1) : -1;
			if (lt == -1) { if (prevLine(iter)) continue; else return; }
			if (!tagAt(iter, lt + 1)) { iter.ch = lt; continue; }
			xmlTagStart.lastIndex = lt;
			iter.ch = lt;
			var match = xmlTagStart.exec(iter.text);
			if (match && match.index == lt) return match;
		}
	}

	function toNextTag(iter) {
		for (;;) {
			xmlTagStart.lastIndex = iter.ch;
			var found = xmlTagStart.exec(iter.text);
			if (!found) { if (nextLine(iter)) continue; else return; }
			if (!tagAt(iter, found.index + 1)) { iter.ch = found.index + 1; continue; }
			iter.ch = found.index + found[0].length;
			return found;
		}
	}
	function toPrevTag(iter) {
		for (;;) {
			var gt = iter.ch ? iter.text.lastIndexOf(">", iter.ch - 1) : -1;
			if (gt == -1) { if (prevLine(iter)) continue; else return; }
			if (!tagAt(iter, gt + 1)) { iter.ch = gt; continue; }
			var lastSlash = iter.text.lastIndexOf("/", gt);
			var selfClose = lastSlash > -1 && !/\S/.test(iter.text.slice(lastSlash + 1, gt));
			iter.ch = gt + 1;
			return selfClose ? "selfClose" : "regular";
		}
	}

	function findMatchingClose(iter, tag) {
		var stack = [];
		for (;;) {
			var next = toNextTag(iter), end, startLine = iter.line, startCh = iter.ch - (next ? next[0].length : 0);
			if (!next || !(end = toTagEnd(iter))) return;
			if (end == "selfClose") continue;
			if (next[1]) { // closing tag
				for (var i = stack.length - 1; i >= 0; --i) if (stack[i] == next[2]) {
					stack.length = i;
					break;
				}
				if (i < 0 && (!tag || tag == next[2])) return {
					tag: next[2],
					from: Pos(startLine, startCh),
					to: Pos(iter.line, iter.ch)
				};
			} else { // opening tag
				stack.push(next[2]);
			}
		}
	}
	function findMatchingOpen(iter, tag) {
		var stack = [];
		for (;;) {
			var prev = toPrevTag(iter);
			if (!prev) return;
			if (prev == "selfClose") { toTagStart(iter); continue; }
			var endLine = iter.line, endCh = iter.ch;
			var start = toTagStart(iter);
			if (!start) return;
			if (start[1]) { // closing tag
				stack.push(start[2]);
			} else { // opening tag
				for (var i = stack.length - 1; i >= 0; --i) if (stack[i] == start[2]) {
					stack.length = i;
					break;
				}
				if (i < 0 && (!tag || tag == start[2])) return {
					tag: start[2],
					from: Pos(iter.line, iter.ch),
					to: Pos(endLine, endCh)
				};
			}
		}
	}

	CodeMirror.registerHelper("fold", "xml", function(cm, start) {
		var iter = new Iter(cm, start.line, 0);
		for (;;) {
			var openTag = toNextTag(iter)
			if (!openTag || iter.line != start.line) return
			var end = toTagEnd(iter)
			if (!end) return
			if (!openTag[1] && end != "selfClose") {
				var startPos = Pos(iter.line, iter.ch);
				var endPos = findMatchingClose(iter, openTag[2]);
				return endPos && cmp(endPos.from, startPos) > 0 ? {from: startPos, to: endPos.from} : null
			}
		}
	});
	CodeMirror.findMatchingTag = function(cm, pos, range) {
		var iter = new Iter(cm, pos.line, pos.ch, range);
		if (iter.text.indexOf(">") == -1 && iter.text.indexOf("<") == -1) return;
		var end = toTagEnd(iter), to = end && Pos(iter.line, iter.ch);
		var start = end && toTagStart(iter);
		if (!end || !start || cmp(iter, pos) > 0) return;
		var here = {from: Pos(iter.line, iter.ch), to: to, tag: start[2]};
		if (end == "selfClose") return {open: here, close: null, at: "open"};

		if (start[1]) { // closing tag
			return {open: findMatchingOpen(iter, start[2]), close: here, at: "close"};
		} else { // opening tag
			iter = new Iter(cm, to.line, to.ch, range);
			return {open: here, close: findMatchingClose(iter, start[2]), at: "open"};
		}
	};

	CodeMirror.findEnclosingTag = function(cm, pos, range, tag) {
		var iter = new Iter(cm, pos.line, pos.ch, range);
		for (;;) {
			var open = findMatchingOpen(iter, tag);
			if (!open) break;
			var forward = new Iter(cm, pos.line, pos.ch, range);
			var close = findMatchingClose(forward, open.tag);
			if (close) return {open: open, close: close};
		}
	};

	// Used by addon/edit/closetag.js
	CodeMirror.scanForClosingTag = function(cm, pos, name, end) {
		var iter = new Iter(cm, pos.line, pos.ch, end ? {from: 0, to: end} : null);
		return findMatchingClose(iter, name);
	};
});

// #END

// ===== edit/matchtags.js
// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/LICENSE

// codemirror: v.5.61.1

(function(mod) {
	if (typeof exports == "object" && typeof module == "object") // CommonJS
		mod(require("../../lib/codemirror"), require("../fold/xml-fold"));
	else if (typeof define == "function" && define.amd) // AMD
		define(["../../lib/codemirror", "../fold/xml-fold"], mod);
	else // Plain browser env
		mod(CodeMirror);
})(function(CodeMirror) {
	"use strict";

	CodeMirror.defineOption("matchTags", false, function(cm, val, old) {
		if (old && old != CodeMirror.Init) {
			cm.off("cursorActivity", doMatchTags);
			cm.off("viewportChange", maybeUpdateMatch);
			clear(cm);
		}
		if (val) {
			cm.state.matchBothTags = typeof val == "object" && val.bothTags;
			cm.on("cursorActivity", doMatchTags);
			cm.on("viewportChange", maybeUpdateMatch);
			doMatchTags(cm);
		}
	});

	function clear(cm) {
		if (cm.state.tagHit) cm.state.tagHit.clear();
		if (cm.state.tagOther) cm.state.tagOther.clear();
		cm.state.tagHit = cm.state.tagOther = null;
	}

	function doMatchTags(cm) {
		cm.state.failedTagMatch = false;
		cm.operation(function() {
			clear(cm);
			if (cm.somethingSelected()) return;
			var cur = cm.getCursor(), range = cm.getViewport();
			range.from = Math.min(range.from, cur.line); range.to = Math.max(cur.line + 1, range.to);
			var match = CodeMirror.findMatchingTag(cm, cur, range);
			if (!match) return;
			if (cm.state.matchBothTags) {
				var hit = match.at == "open" ? match.open : match.close;
				if (hit) cm.state.tagHit = cm.markText(hit.from, hit.to, {className: "CodeMirror-matchingtag"});
			}
			var other = match.at == "close" ? match.open : match.close;
			if (other)
				cm.state.tagOther = cm.markText(other.from, other.to, {className: "CodeMirror-matchingtag"});
			else
				cm.state.failedTagMatch = true;
		});
	}

	function maybeUpdateMatch(cm) {
		if (cm.state.failedTagMatch) doMatchTags(cm);
	}

	CodeMirror.commands.toMatchingTag = function(cm) {
		var found = CodeMirror.findMatchingTag(cm, cm.getCursor());
		if (found) {
			var other = found.at == "close" ? found.open : found.close;
			if (other) cm.extendSelection(other.to, other.from);
		}
	};
});

// #END

// ===== edit/matchbrackets.js
// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/LICENSE

// codemirror: v.5.61.1

(function(mod) {
	if (typeof exports == "object" && typeof module == "object") // CommonJS
		mod(require("../../lib/codemirror"));
	else if (typeof define == "function" && define.amd) // AMD
		define(["../../lib/codemirror"], mod);
	else // Plain browser env
		mod(CodeMirror);
})(function(CodeMirror) {
	var ie_lt8 = /MSIE \d/.test(navigator.userAgent) &&
		(document.documentMode == null || document.documentMode < 8);

	var Pos = CodeMirror.Pos;

	var matching = {"(": ")>", ")": "(<", "[": "]>", "]": "[<", "{": "}>", "}": "{<", "<": ">>", ">": "<<"};

	function bracketRegex(config) {
		return config && config.bracketRegex || /[(){}[\]]/
	}

	function findMatchingBracket(cm, where, config) {
		var line = cm.getLineHandle(where.line), pos = where.ch - 1;
		var afterCursor = config && config.afterCursor
		if (afterCursor == null)
			afterCursor = /(^| )cm-fat-cursor($| )/.test(cm.getWrapperElement().className)
		var re = bracketRegex(config)

		// A cursor is defined as between two characters, but in in vim command mode
		// (i.e. not insert mode), the cursor is visually represented as a
		// highlighted box on top of the 2nd character. Otherwise, we allow matches
		// from before or after the cursor.
		var match = (!afterCursor && pos >= 0 && re.test(line.text.charAt(pos)) && matching[line.text.charAt(pos)]) ||
				re.test(line.text.charAt(pos + 1)) && matching[line.text.charAt(++pos)];
		if (!match) return null;
		var dir = match.charAt(1) == ">" ? 1 : -1;
		if (config && config.strict && (dir > 0) != (pos == where.ch)) return null;
		var style = cm.getTokenTypeAt(Pos(where.line, pos + 1));

		var found = scanForBracket(cm, Pos(where.line, pos + (dir > 0 ? 1 : 0)), dir, style, config);
		if (found == null) return null;
		return {from: Pos(where.line, pos), to: found && found.pos,
						match: found && found.ch == match.charAt(0), forward: dir > 0};
	}

	// bracketRegex is used to specify which type of bracket to scan
	// should be a regexp, e.g. /[[\]]/
	//
	// Note: If "where" is on an open bracket, then this bracket is ignored.
	//
	// Returns false when no bracket was found, null when it reached
	// maxScanLines and gave up
	function scanForBracket(cm, where, dir, style, config) {
		var maxScanLen = (config && config.maxScanLineLength) || 10000;
		var maxScanLines = (config && config.maxScanLines) || 1000;

		var stack = [];
		var re = bracketRegex(config)
		var lineEnd = dir > 0 ? Math.min(where.line + maxScanLines, cm.lastLine() + 1)
													: Math.max(cm.firstLine() - 1, where.line - maxScanLines);
		for (var lineNo = where.line; lineNo != lineEnd; lineNo += dir) {
			var line = cm.getLine(lineNo);
			if (!line) continue;
			var pos = dir > 0 ? 0 : line.length - 1, end = dir > 0 ? line.length : -1;
			if (line.length > maxScanLen) continue;
			if (lineNo == where.line) pos = where.ch - (dir < 0 ? 1 : 0);
			for (; pos != end; pos += dir) {
				var ch = line.charAt(pos);
				if (re.test(ch) && (style === undefined ||
														(cm.getTokenTypeAt(Pos(lineNo, pos + 1)) || "") == (style || ""))) {
					var match = matching[ch];
					if (match && (match.charAt(1) == ">") == (dir > 0)) stack.push(ch);
					else if (!stack.length) return {pos: Pos(lineNo, pos), ch: ch};
					else stack.pop();
				}
			}
		}
		return lineNo - dir == (dir > 0 ? cm.lastLine() : cm.firstLine()) ? false : null;
	}

	function matchBrackets(cm, autoclear, config) {
		// Disable brace matching in long lines, since it'll cause hugely slow updates
		var maxHighlightLen = cm.state.matchBrackets.maxHighlightLineLength || 1000,
			highlightNonMatching = config && config.highlightNonMatching;
		var marks = [], ranges = cm.listSelections();
		for (var i = 0; i < ranges.length; i++) {
			var match = ranges[i].empty() && findMatchingBracket(cm, ranges[i].head, config);
			if (match && (match.match || highlightNonMatching !== false) && cm.getLine(match.from.line).length <= maxHighlightLen) {
				var style = match.match ? "CodeMirror-matchingbracket" : "CodeMirror-nonmatchingbracket";
				marks.push(cm.markText(match.from, Pos(match.from.line, match.from.ch + 1), {className: style}));
				if (match.to && cm.getLine(match.to.line).length <= maxHighlightLen)
					marks.push(cm.markText(match.to, Pos(match.to.line, match.to.ch + 1), {className: style}));
			}
		}

		if (marks.length) {
			// Kludge to work around the IE bug from issue #1193, where text
			// input stops going to the textarea whenever this fires.
			if (ie_lt8 && cm.state.focused) cm.focus();

			var clear = function() {
				cm.operation(function() {
					for (var i = 0; i < marks.length; i++) marks[i].clear();
				});
			};
			if (autoclear) setTimeout(clear, 800);
			else return clear;
		}
	}

	function doMatchBrackets(cm) {
		cm.operation(function() {
			if (cm.state.matchBrackets.currentlyHighlighted) {
				cm.state.matchBrackets.currentlyHighlighted();
				cm.state.matchBrackets.currentlyHighlighted = null;
			}
			cm.state.matchBrackets.currentlyHighlighted = matchBrackets(cm, false, cm.state.matchBrackets);
		});
	}

	function clearHighlighted(cm) {
		if (cm.state.matchBrackets && cm.state.matchBrackets.currentlyHighlighted) {
			cm.state.matchBrackets.currentlyHighlighted();
			cm.state.matchBrackets.currentlyHighlighted = null;
		}
	}

	CodeMirror.defineOption("matchBrackets", false, function(cm, val, old) {
		if (old && old != CodeMirror.Init) {
			cm.off("cursorActivity", doMatchBrackets);
			cm.off("focus", doMatchBrackets)
			cm.off("blur", clearHighlighted)
			clearHighlighted(cm);
		}
		if (val) {
			cm.state.matchBrackets = typeof val == "object" ? val : {};
			cm.on("cursorActivity", doMatchBrackets);
			cm.on("focus", doMatchBrackets)
			cm.on("blur", clearHighlighted)
		}
	});

	CodeMirror.defineExtension("matchBrackets", function() {matchBrackets(this, true);});
	CodeMirror.defineExtension("findMatchingBracket", function(pos, config, oldConfig){
		// Backwards-compatibility kludge
		if (oldConfig || typeof config == "boolean") {
			if (!oldConfig) {
				config = config ? {strict: true} : null
			} else {
				oldConfig.strict = config
				config = oldConfig
			}
		}
		return findMatchingBracket(this, pos, config)
	});
	CodeMirror.defineExtension("scanForBracket", function(pos, dir, style, config){
		return scanForBracket(this, pos, dir, style, config);
	});
});

// #END

// ===== edit/trailingspace.js
// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/LICENSE

// codemirror: v.5.61.1

(function(mod) {
	if (typeof exports == "object" && typeof module == "object") // CommonJS
		mod(require("../../lib/codemirror"));
	else if (typeof define == "function" && define.amd) // AMD
		define(["../../lib/codemirror"], mod);
	else // Plain browser env
		mod(CodeMirror);
})(function(CodeMirror) {
	CodeMirror.defineOption("showTrailingSpace", false, function(cm, val, prev) {
		if (prev == CodeMirror.Init) prev = false;
		if (prev && !val)
			cm.removeOverlay("trailingspace");
		else if (!prev && val)
			cm.addOverlay({
				token: function(stream) {
					for (var l = stream.string.length, i = l; i && /\s/.test(stream.string.charAt(i - 1)); --i) {}
					if (i > stream.pos) { stream.pos = i; return null; }
					stream.pos = l;
					return "trailingspace";
				},
				name: "trailingspace"
			});
	});
});

// #END

// ===== dialog/dialog.js
// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/LICENSE
// Open simple dialogs on top of an editor. Relies on dialog.css.

// codemirror: v.5.61.1

(function(mod) {
	if (typeof exports == "object" && typeof module == "object") // CommonJS
		mod(require("../../lib/codemirror"));
	else if (typeof define == "function" && define.amd) // AMD
		define(["../../lib/codemirror"], mod);
	else // Plain browser env
		mod(CodeMirror);
})(function(CodeMirror) {
	function dialogDiv(cm, template, bottom) {
		var wrap = cm.getWrapperElement();
		var dialog;
		dialog = wrap.appendChild(document.createElement("div"));
		if (bottom)
			dialog.className = "CodeMirror-dialog CodeMirror-dialog-bottom";
		else
			dialog.className = "CodeMirror-dialog CodeMirror-dialog-top";

		if (typeof template == "string") {
			dialog.innerHTML = template;
		} else { // Assuming it's a detached DOM element.
			dialog.appendChild(template);
		}
		CodeMirror.addClass(wrap, 'dialog-opened');
		return dialog;
	}

	function closeNotification(cm, newVal) {
		if (cm.state.currentNotificationClose)
			cm.state.currentNotificationClose();
		cm.state.currentNotificationClose = newVal;
	}

	CodeMirror.defineExtension("openDialog", function(template, callback, options) {
		if (!options) options = {};

		closeNotification(this, null);

		var dialog = dialogDiv(this, template, options.bottom);
		var closed = false, me = this;
		function close(newVal) {
			if (typeof newVal == 'string') {
				inp.value = newVal;
			} else {
				if (closed) return;
				closed = true;
				CodeMirror.rmClass(dialog.parentNode, 'dialog-opened');
				dialog.parentNode.removeChild(dialog);
				me.focus();

				if (options.onClose) options.onClose(dialog);
			}
		}

		var inp = dialog.getElementsByTagName("input")[0], button;
		if (inp) {
			inp.focus();

			if (options.value) {
				inp.value = options.value;
				if (options.selectValueOnOpen !== false) {
					inp.select();
				}
			}

			if (options.onInput)
				CodeMirror.on(inp, "input", function(e) { options.onInput(e, inp.value, close);});
			if (options.onKeyUp)
				CodeMirror.on(inp, "keyup", function(e) {options.onKeyUp(e, inp.value, close);});

			CodeMirror.on(inp, "keydown", function(e) {
				if (options && options.onKeyDown && options.onKeyDown(e, inp.value, close)) { return; }
				if (e.keyCode == 27 || (options.closeOnEnter !== false && e.keyCode == 13)) {
					inp.blur();
					CodeMirror.e_stop(e);
					close();
				}
				if (e.keyCode == 13) callback(inp.value, e);
			});

			if (options.closeOnBlur !== false) CodeMirror.on(dialog, "focusout", function (evt) {
				if (evt.relatedTarget !== null) close();
			});
		} else if (button = dialog.getElementsByTagName("button")[0]) {
			CodeMirror.on(button, "click", function() {
				close();
				me.focus();
			});

			if (options.closeOnBlur !== false) CodeMirror.on(button, "blur", close);

			button.focus();
		}
		return close;
	});

	CodeMirror.defineExtension("openConfirm", function(template, callbacks, options) {
		closeNotification(this, null);
		var dialog = dialogDiv(this, template, options && options.bottom);
		var buttons = dialog.getElementsByTagName("button");
		var closed = false, me = this, blurring = 1;
		function close() {
			if (closed) return;
			closed = true;
			CodeMirror.rmClass(dialog.parentNode, 'dialog-opened');
			dialog.parentNode.removeChild(dialog);
			me.focus();
		}
		buttons[0].focus();
		for (var i = 0; i < buttons.length; ++i) {
			var b = buttons[i];
			(function(callback) {
				CodeMirror.on(b, "click", function(e) {
					CodeMirror.e_preventDefault(e);
					close();
					if (callback) callback(me);
				});
			})(callbacks[i]);
			CodeMirror.on(b, "blur", function() {
				--blurring;
				setTimeout(function() { if (blurring <= 0) close(); }, 200);
			});
			CodeMirror.on(b, "focus", function() { ++blurring; });
		}
	});

	/*
	 * openNotification
	 * Opens a notification, that can be closed with an optional timer
	 * (default 5000ms timer) and always closes on click.
	 *
	 * If a notification is opened while another is opened, it will close the
	 * currently opened one and open the new one immediately.
	 */
	CodeMirror.defineExtension("openNotification", function(template, options) {
		closeNotification(this, close);
		var dialog = dialogDiv(this, template, options && options.bottom);
		var closed = false, doneTimer;
		var duration = options && typeof options.duration !== "undefined" ? options.duration : 5000;

		function close() {
			if (closed) return;
			closed = true;
			clearTimeout(doneTimer);
			CodeMirror.rmClass(dialog.parentNode, 'dialog-opened');
			dialog.parentNode.removeChild(dialog);
		}

		CodeMirror.on(dialog, 'click', function(e) {
			CodeMirror.e_preventDefault(e);
			close();
		});

		if (duration)
			doneTimer = setTimeout(close, duration);

		return close;
	});
});

// #END

// ===== search/searchcursor.js
// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/5/LICENSE

// codemirror: v.5.65.15

(function(mod) {
	if (typeof exports == "object" && typeof module == "object") // CommonJS
		mod(require("../../lib/codemirror"))
	else if (typeof define == "function" && define.amd) // AMD
		define(["../../lib/codemirror"], mod)
	else // Plain browser env
		mod(CodeMirror)
})(function(CodeMirror) {
	"use strict"
	var Pos = CodeMirror.Pos

	function regexpFlags(regexp) {
		var flags = regexp.flags
		return flags != null ? flags : (regexp.ignoreCase ? "i" : "")
			+ (regexp.global ? "g" : "")
			+ (regexp.multiline ? "m" : "")
	}

	function ensureFlags(regexp, flags) {
		var current = regexpFlags(regexp), target = current
		for (var i = 0; i < flags.length; i++) if (target.indexOf(flags.charAt(i)) == -1)
			target += flags.charAt(i)
		return current == target ? regexp : new RegExp(regexp.source, target)
	}

	function maybeMultiline(regexp) {
		return /\\s|\\n|\n|\\W|\\D|\[\^/.test(regexp.source)
	}

	function searchRegexpForward(doc, regexp, start) {
		regexp = ensureFlags(regexp, "g")
		for (var line = start.line, ch = start.ch, last = doc.lastLine(); line <= last; line++, ch = 0) {
			regexp.lastIndex = ch
			var string = doc.getLine(line), match = regexp.exec(string)
			if (match)
				return {from: Pos(line, match.index),
								to: Pos(line, match.index + match[0].length),
								match: match}
		}
	}

	function searchRegexpForwardMultiline(doc, regexp, start) {
		if (!maybeMultiline(regexp)) return searchRegexpForward(doc, regexp, start)

		regexp = ensureFlags(regexp, "gm")
		var string, chunk = 1
		for (var line = start.line, last = doc.lastLine(); line <= last;) {
			// This grows the search buffer in exponentially-sized chunks
			// between matches, so that nearby matches are fast and don't
			// require concatenating the whole document (in case we're
			// searching for something that has tons of matches), but at the
			// same time, the amount of retries is limited.
			for (var i = 0; i < chunk; i++) {
				if (line > last) break
				var curLine = doc.getLine(line++)
				string = string == null ? curLine : string + "\n" + curLine
			}
			chunk = chunk * 2
			regexp.lastIndex = start.ch
			var match = regexp.exec(string)
			if (match) {
				var before = string.slice(0, match.index).split("\n"), inside = match[0].split("\n")
				var startLine = start.line + before.length - 1, startCh = before[before.length - 1].length
				return {from: Pos(startLine, startCh),
								to: Pos(startLine + inside.length - 1,
												inside.length == 1 ? startCh + inside[0].length : inside[inside.length - 1].length),
								match: match}
			}
		}
	}

	function lastMatchIn(string, regexp, endMargin) {
		var match, from = 0
		while (from <= string.length) {
			regexp.lastIndex = from
			var newMatch = regexp.exec(string)
			if (!newMatch) break
			var end = newMatch.index + newMatch[0].length
			if (end > string.length - endMargin) break
			if (!match || end > match.index + match[0].length)
				match = newMatch
			from = newMatch.index + 1
		}
		return match
	}

	function searchRegexpBackward(doc, regexp, start) {
		regexp = ensureFlags(regexp, "g")
		for (var line = start.line, ch = start.ch, first = doc.firstLine(); line >= first; line--, ch = -1) {
			var string = doc.getLine(line)
			var match = lastMatchIn(string, regexp, ch < 0 ? 0 : string.length - ch)
			if (match)
				return {from: Pos(line, match.index),
								to: Pos(line, match.index + match[0].length),
								match: match}
		}
	}

	function searchRegexpBackwardMultiline(doc, regexp, start) {
		if (!maybeMultiline(regexp)) return searchRegexpBackward(doc, regexp, start)
		regexp = ensureFlags(regexp, "gm")
		var string, chunkSize = 1, endMargin = doc.getLine(start.line).length - start.ch
		for (var line = start.line, first = doc.firstLine(); line >= first;) {
			for (var i = 0; i < chunkSize && line >= first; i++) {
				var curLine = doc.getLine(line--)
				string = string == null ? curLine : curLine + "\n" + string
			}
			chunkSize *= 2

			var match = lastMatchIn(string, regexp, endMargin)
			if (match) {
				var before = string.slice(0, match.index).split("\n"), inside = match[0].split("\n")
				var startLine = line + before.length, startCh = before[before.length - 1].length
				return {from: Pos(startLine, startCh),
								to: Pos(startLine + inside.length - 1,
												inside.length == 1 ? startCh + inside[0].length : inside[inside.length - 1].length),
								match: match}
			}
		}
	}

	var doFold, noFold
	if (String.prototype.normalize) {
		doFold = function(str) { return str.normalize("NFD").toLowerCase() }
		noFold = function(str) { return str.normalize("NFD") }
	} else {
		doFold = function(str) { return str.toLowerCase() }
		noFold = function(str) { return str }
	}

	// Maps a position in a case-folded line back to a position in the original line
	// (compensating for codepoints increasing in number during folding)
	function adjustPos(orig, folded, pos, foldFunc) {
		if (orig.length == folded.length) return pos
		for (var min = 0, max = pos + Math.max(0, orig.length - folded.length);;) {
			if (min == max) return min
			var mid = (min + max) >> 1
			var len = foldFunc(orig.slice(0, mid)).length
			if (len == pos) return mid
			else if (len > pos) max = mid
			else min = mid + 1
		}
	}

	function searchStringForward(doc, query, start, caseFold) {
		// Empty string would match anything and never progress, so we
		// define it to match nothing instead.
		if (!query.length) return null
		var fold = caseFold ? doFold : noFold
		var lines = fold(query).split(/\r|\n\r?/)

		search: for (var line = start.line, ch = start.ch, last = doc.lastLine() + 1 - lines.length; line <= last; line++, ch = 0) {
			var orig = doc.getLine(line).slice(ch), string = fold(orig)
			if (lines.length == 1) {
				var found = string.indexOf(lines[0])
				if (found == -1) continue search
				var start = adjustPos(orig, string, found, fold) + ch
				return {from: Pos(line, adjustPos(orig, string, found, fold) + ch),
								to: Pos(line, adjustPos(orig, string, found + lines[0].length, fold) + ch)}
			} else {
				var cutFrom = string.length - lines[0].length
				if (string.slice(cutFrom) != lines[0]) continue search
				for (var i = 1; i < lines.length - 1; i++)
					if (fold(doc.getLine(line + i)) != lines[i]) continue search
				var end = doc.getLine(line + lines.length - 1), endString = fold(end), lastLine = lines[lines.length - 1]
				if (endString.slice(0, lastLine.length) != lastLine) continue search
				return {from: Pos(line, adjustPos(orig, string, cutFrom, fold) + ch),
								to: Pos(line + lines.length - 1, adjustPos(end, endString, lastLine.length, fold))}
			}
		}
	}

	function searchStringBackward(doc, query, start, caseFold) {
		if (!query.length) return null
		var fold = caseFold ? doFold : noFold
		var lines = fold(query).split(/\r|\n\r?/)

		search: for (var line = start.line, ch = start.ch, first = doc.firstLine() - 1 + lines.length; line >= first; line--, ch = -1) {
			var orig = doc.getLine(line)
			if (ch > -1) orig = orig.slice(0, ch)
			var string = fold(orig)
			if (lines.length == 1) {
				var found = string.lastIndexOf(lines[0])
				if (found == -1) continue search
				return {from: Pos(line, adjustPos(orig, string, found, fold)),
								to: Pos(line, adjustPos(orig, string, found + lines[0].length, fold))}
			} else {
				var lastLine = lines[lines.length - 1]
				if (string.slice(0, lastLine.length) != lastLine) continue search
				for (var i = 1, start = line - lines.length + 1; i < lines.length - 1; i++)
					if (fold(doc.getLine(start + i)) != lines[i]) continue search
				var top = doc.getLine(line + 1 - lines.length), topString = fold(top)
				if (topString.slice(topString.length - lines[0].length) != lines[0]) continue search
				return {from: Pos(line + 1 - lines.length, adjustPos(top, topString, top.length - lines[0].length, fold)),
								to: Pos(line, adjustPos(orig, string, lastLine.length, fold))}
			}
		}
	}

	function SearchCursor(doc, query, pos, options) {
		this.atOccurrence = false
		this.afterEmptyMatch = false
		this.doc = doc
		pos = pos ? doc.clipPos(pos) : Pos(0, 0)
		this.pos = {from: pos, to: pos}

		var caseFold
		if (typeof options == "object") {
			caseFold = options.caseFold
		} else { // Backwards compat for when caseFold was the 4th argument
			caseFold = options
			options = null
		}

		if (typeof query == "string") {
			if (caseFold == null) caseFold = false
			this.matches = function(reverse, pos) {
				return (reverse ? searchStringBackward : searchStringForward)(doc, query, pos, caseFold)
			}
		} else {
			query = ensureFlags(query, "gm")
			if (!options || options.multiline !== false)
				this.matches = function(reverse, pos) {
					return (reverse ? searchRegexpBackwardMultiline : searchRegexpForwardMultiline)(doc, query, pos)
				}
			else
				this.matches = function(reverse, pos) {
					return (reverse ? searchRegexpBackward : searchRegexpForward)(doc, query, pos)
				}
		}
	}

	SearchCursor.prototype = {
		findNext: function() {return this.find(false)},
		findPrevious: function() {return this.find(true)},

		find: function(reverse) {
			var head = this.doc.clipPos(reverse ? this.pos.from : this.pos.to);
			if (this.afterEmptyMatch && this.atOccurrence) {
				// do not return the same 0 width match twice
				head = Pos(head.line, head.ch)
				if (reverse) {
					head.ch--;
					if (head.ch < 0) {
						head.line--;
						head.ch = (this.doc.getLine(head.line) || "").length;
					}
				} else {
					head.ch++;
					if (head.ch > (this.doc.getLine(head.line) || "").length) {
						head.ch = 0;
						head.line++;
					}
				}
				if (CodeMirror.cmpPos(head, this.doc.clipPos(head)) != 0) {
					 return this.atOccurrence = false
				}
			}
			var result = this.matches(reverse, head)
			this.afterEmptyMatch = result && CodeMirror.cmpPos(result.from, result.to) == 0

			if (result) {
				this.pos = result
				this.atOccurrence = true
				return this.pos.match || true
			} else {
				var end = Pos(reverse ? this.doc.firstLine() : this.doc.lastLine() + 1, 0)
				this.pos = {from: end, to: end}
				return this.atOccurrence = false
			}
		},

		from: function() {if (this.atOccurrence) return this.pos.from},
		to: function() {if (this.atOccurrence) return this.pos.to},

		replace: function(newText, origin) {
			if (!this.atOccurrence) return
			var lines = CodeMirror.splitLines(newText)
			this.doc.replaceRange(lines, this.pos.from, this.pos.to, origin)
			this.pos.to = Pos(this.pos.from.line + lines.length - 1,
												lines[lines.length - 1].length + (lines.length == 1 ? this.pos.from.ch : 0))
		}
	}

	CodeMirror.defineExtension("getSearchCursor", function(query, pos, caseFold) {
		return new SearchCursor(this.doc, query, pos, caseFold)
	})
	CodeMirror.defineDocExtension("getSearchCursor", function(query, pos, caseFold) {
		return new SearchCursor(this, query, pos, caseFold)
	})

	CodeMirror.defineExtension("selectMatches", function(query, caseFold) {
		var ranges = []
		var cur = this.getSearchCursor(query, this.getCursor("from"), caseFold)
		while (cur.findNext()) {
			if (CodeMirror.cmpPos(cur.to(), this.getCursor("to")) > 0) break
			ranges.push({anchor: cur.from(), head: cur.to()})
		}
		if (ranges.length)
			this.setSelections(ranges, 0)
	})
});

// #END

// ===== search/search.js
// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/5/LICENSE
// Define search commands. Depends on dialog.js or another
// implementation of the openDialog method.
// Replace works a little oddly -- it will do the replace on the next
// Ctrl-G (or whatever is bound to findNext) press. You prevent a
// replace by making sure the match is no longer selected when hitting
// Ctrl-G.

// codemirror: v.5.65.15

(function(mod) {
	if (typeof exports == "object" && typeof module == "object") // CommonJS
		mod(require("../../lib/codemirror"), require("./searchcursor"), require("../dialog/dialog"));
	else if (typeof define == "function" && define.amd) // AMD
		define(["../../lib/codemirror", "./searchcursor", "../dialog/dialog"], mod);
	else // Plain browser env
		mod(CodeMirror);
})(function(CodeMirror) {
	"use strict";

	// default search panel location
	CodeMirror.defineOption("search", {bottom: false});

	function searchOverlay(query, caseInsensitive) {
		if (typeof query == "string")
			query = new RegExp(query.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&"), caseInsensitive ? "gi" : "g");
		else if (!query.global)
			query = new RegExp(query.source, query.ignoreCase ? "gi" : "g");

		return {token: function(stream) {
			query.lastIndex = stream.pos;
			var match = query.exec(stream.string);
			if (match && match.index == stream.pos) {
				stream.pos += match[0].length || 1;
				return "searching";
			} else if (match) {
				stream.pos = match.index;
			} else {
				stream.skipToEnd();
			}
		}};
	}

	function SearchState() {
		this.posFrom = this.posTo = this.lastQuery = this.query = null;
		this.overlay = null;
	}

	function getSearchState(cm) {
		return cm.state.search || (cm.state.search = new SearchState());
	}

	function queryCaseInsensitive(query) {
		return typeof query == "string" && query == query.toLowerCase();
	}

	function getSearchCursor(cm, query, pos) {
		// Heuristic: if the query string is all lowercase, do a case insensitive search.
		return cm.getSearchCursor(query, pos, {caseFold: queryCaseInsensitive(query), multiline: true});
	}

	function persistentDialog(cm, text, deflt, onEnter, onKeyDown) {
		cm.openDialog(text, onEnter, {
			value: deflt,
			selectValueOnOpen: true,
			closeOnEnter: false,
			onClose: function() { clearSearch(cm); },
			onKeyDown: onKeyDown,
			bottom: cm.options.search.bottom
		});
	}

	function dialog(cm, text, shortText, deflt, f) {
		if (cm.openDialog) cm.openDialog(text, f, {value: deflt, selectValueOnOpen: true, bottom: cm.options.search.bottom});
		else f(prompt(shortText, deflt));
	}

	function confirmDialog(cm, text, shortText, fs) {
		if (cm.openConfirm) cm.openConfirm(text, fs);
		else if (confirm(shortText)) fs[0]();
	}

	function parseString(string) {
		return string.replace(/\\([nrt\\])/g, function(match, ch) {
			if (ch == "n") return "\n"
			if (ch == "r") return "\r"
			if (ch == "t") return "\t"
			if (ch == "\\") return "\\"
			return match
		})
	}

	function parseQuery(query) {
		var isRE = query.match(/^\/(.*)\/([a-z]*)$/);
		if (isRE) {
			try { query = new RegExp(isRE[1], isRE[2].indexOf("i") == -1 ? "" : "i"); }
			catch(e) {} // Not a regular expression after all, do a string search
		} else {
			query = parseString(query)
		}
		if (typeof query == "string" ? query == "" : query.test(""))
			query = /x^/;
		return query;
	}

	function startSearch(cm, state, query) {
		state.queryText = query;
		state.query = parseQuery(query);
		cm.removeOverlay(state.overlay, queryCaseInsensitive(state.query));
		state.overlay = searchOverlay(state.query, queryCaseInsensitive(state.query));
		cm.addOverlay(state.overlay);
		if (cm.showMatchesOnScrollbar) {
			if (state.annotate) { state.annotate.clear(); state.annotate = null; }
			state.annotate = cm.showMatchesOnScrollbar(state.query, queryCaseInsensitive(state.query));
		}
	}

	function doSearch(cm, rev, persistent, immediate) {
		var state = getSearchState(cm);
		if (state.query) return findNext(cm, rev);
		var q = cm.getSelection() || state.lastQuery;
		if (q instanceof RegExp && q.source == "x^") q = null
		if (persistent && cm.openDialog) {
			var hiding = null
			var searchNext = function(query, event) {
				CodeMirror.e_stop(event);
				if (!query) return;
				if (query != state.queryText) {
					startSearch(cm, state, query);
					state.posFrom = state.posTo = cm.getCursor();
				}
				if (hiding) hiding.style.opacity = 1
				findNext(cm, event.shiftKey, function(_, to) {
					var dialog
					if (to.line < 3 && document.querySelector &&
							(dialog = cm.display.wrapper.querySelector(".CodeMirror-dialog")) &&
							dialog.getBoundingClientRect().bottom - 4 > cm.cursorCoords(to, "window").top)
						(hiding = dialog).style.opacity = .4
				})
			};
			persistentDialog(cm, getQueryDialog(cm), q, searchNext, function(event, query) {
				var keyName = CodeMirror.keyName(event)
				var extra = cm.getOption('extraKeys'), cmd = (extra && extra[keyName]) || CodeMirror.keyMap[cm.getOption("keyMap")][keyName]
				if (cmd == "findNext" || cmd == "findPrev" ||
					cmd == "findPersistentNext" || cmd == "findPersistentPrev") {
					CodeMirror.e_stop(event);
					startSearch(cm, getSearchState(cm), query);
					cm.execCommand(cmd);
				} else if (cmd == "find" || cmd == "findPersistent") {
					CodeMirror.e_stop(event);
					searchNext(query, event);
				}
			});
			if (immediate && q) {
				startSearch(cm, state, q);
				findNext(cm, rev);
			}
		} else {
			dialog(cm, getQueryDialog(cm), "Search for:", q, function(query) {
				if (query && !state.query) cm.operation(function() {
					startSearch(cm, state, query);
					state.posFrom = state.posTo = cm.getCursor();
					findNext(cm, rev);
				});
			});
		}
	}

	function findNext(cm, rev, callback) {cm.operation(function() {
		var state = getSearchState(cm);
		var cursor = getSearchCursor(cm, state.query, rev ? state.posFrom : state.posTo);
		if (!cursor.find(rev)) {
			cursor = getSearchCursor(cm, state.query, rev ? CodeMirror.Pos(cm.lastLine()) : CodeMirror.Pos(cm.firstLine(), 0));
			if (!cursor.find(rev)) return;
		}
		cm.setSelection(cursor.from(), cursor.to());
		cm.scrollIntoView({from: cursor.from(), to: cursor.to()}, 20);
		state.posFrom = cursor.from(); state.posTo = cursor.to();
		if (callback) callback(cursor.from(), cursor.to())
	});}

	function clearSearch(cm) {cm.operation(function() {
		var state = getSearchState(cm);
		state.lastQuery = state.query;
		if (!state.query) return;
		state.query = state.queryText = null;
		cm.removeOverlay(state.overlay);
		if (state.annotate) { state.annotate.clear(); state.annotate = null; }
	});}

	function el(tag, attrs) {
		var element = tag ? document.createElement(tag) : document.createDocumentFragment();
		for (var key in attrs) {
			element[key] = attrs[key];
		}
		for (var i = 2; i < arguments.length; i++) {
			var child = arguments[i]
			element.appendChild(typeof child == "string" ? document.createTextNode(child) : child);
		}
		return element;
	}

	function getQueryDialog(cm)  {
		var label = el("label", {className: "CodeMirror-search-label"},
									 cm.phrase("Search:"),
									 el("input", {type: "text", "style": "width: 10em", className: "CodeMirror-search-field",
																id: "CodeMirror-search-field"}));
		label.setAttribute("for","CodeMirror-search-field");
		return el("", null, label, " ",
							el("span", {style: "color: #666", className: "CodeMirror-search-hint"},
								 cm.phrase("(Use /re/ syntax for regexp search)")));
	}
	function getReplaceQueryDialog(cm) {
		return el("", null, " ",
							el("input", {type: "text", "style": "width: 10em", className: "CodeMirror-search-field"}), " ",
							el("span", {style: "color: #666", className: "CodeMirror-search-hint"},
								 cm.phrase("(Use /re/ syntax for regexp search)")));
	}
	function getReplacementQueryDialog(cm) {
		return el("", null,
							el("span", {className: "CodeMirror-search-label"}, cm.phrase("With:")), " ",
							el("input", {type: "text", "style": "width: 10em", className: "CodeMirror-search-field"}));
	}
	function getDoReplaceConfirm(cm) {
		return el("", null,
							el("span", {className: "CodeMirror-search-label"}, cm.phrase("Replace?")), " ",
							el("button", {}, cm.phrase("Yes")), " ",
							el("button", {}, cm.phrase("No")), " ",
							el("button", {}, cm.phrase("All")), " ",
							el("button", {}, cm.phrase("Stop")));
	}

	function replaceAll(cm, query, text) {
		cm.operation(function() {
			for (var cursor = getSearchCursor(cm, query); cursor.findNext();) {
				if (typeof query != "string") {
					var match = cm.getRange(cursor.from(), cursor.to()).match(query);
					cursor.replace(text.replace(/\$(\d)/g, function(_, i) {return match[i];}));
				} else cursor.replace(text);
			}
		});
	}

	function replace(cm, all) {
		if (cm.getOption("readOnly")) return;
		var query = cm.getSelection() || getSearchState(cm).lastQuery;
		var dialogText = all ? cm.phrase("Replace all:") : cm.phrase("Replace:")
		var fragment = el("", null,
											el("span", {className: "CodeMirror-search-label"}, dialogText),
											getReplaceQueryDialog(cm))
		dialog(cm, fragment, dialogText, query, function(query) {
			if (!query) return;
			query = parseQuery(query);
			dialog(cm, getReplacementQueryDialog(cm), cm.phrase("Replace with:"), "", function(text) {
				text = parseString(text)
				if (all) {
					replaceAll(cm, query, text)
				} else {
					clearSearch(cm);
					var cursor = getSearchCursor(cm, query, cm.getCursor("from"));
					var advance = function() {
						var start = cursor.from(), match;
						if (!(match = cursor.findNext())) {
							cursor = getSearchCursor(cm, query);
							if (!(match = cursor.findNext()) ||
									(start && cursor.from().line == start.line && cursor.from().ch == start.ch)) return;
						}
						cm.setSelection(cursor.from(), cursor.to());
						cm.scrollIntoView({from: cursor.from(), to: cursor.to()});
						confirmDialog(cm, getDoReplaceConfirm(cm), cm.phrase("Replace?"),
													[function() {doReplace(match);}, advance,
													 function() {replaceAll(cm, query, text)}]);
					};
					var doReplace = function(match) {
						cursor.replace(typeof query == "string" ? text :
													 text.replace(/\$(\d)/g, function(_, i) {return match[i];}));
						advance();
					};
					advance();
				}
			});
		});
	}

	CodeMirror.commands.find = function(cm) {clearSearch(cm); doSearch(cm);};
	CodeMirror.commands.findPersistent = function(cm) {clearSearch(cm); doSearch(cm, false, true);};
	CodeMirror.commands.findPersistentNext = function(cm) {doSearch(cm, false, true, true);};
	CodeMirror.commands.findPersistentPrev = function(cm) {doSearch(cm, true, true, true);};
	CodeMirror.commands.findNext = doSearch;
	CodeMirror.commands.findPrev = function(cm) {doSearch(cm, true);};
	CodeMirror.commands.clearSearch = clearSearch;
	CodeMirror.commands.replace = replace;
	CodeMirror.commands.replaceAll = function(cm) {replace(cm, true);};
});

// #END

// ===== selection/active-line.js
// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/LICENSE

// codemirror: v.5.61.1

(function(mod) {
	if (typeof exports == "object" && typeof module == "object") // CommonJS
		mod(require("../../lib/codemirror"));
	else if (typeof define == "function" && define.amd) // AMD
		define(["../../lib/codemirror"], mod);
	else // Plain browser env
		mod(CodeMirror);
})(function(CodeMirror) {
	"use strict";
	var WRAP_CLASS = "CodeMirror-activeline";
	var BACK_CLASS = "CodeMirror-activeline-background";
	var GUTT_CLASS = "CodeMirror-activeline-gutter";

	CodeMirror.defineOption("styleActiveLine", false, function(cm, val, old) {
		var prev = old == CodeMirror.Init ? false : old;
		if (val == prev) return
		if (prev) {
			cm.off("beforeSelectionChange", selectionChange);
			clearActiveLines(cm);
			delete cm.state.activeLines;
		}
		if (val) {
			cm.state.activeLines = [];
			updateActiveLines(cm, cm.listSelections());
			cm.on("beforeSelectionChange", selectionChange);
		}
	});

	function clearActiveLines(cm) {
		for (var i = 0; i < cm.state.activeLines.length; i++) {
			cm.removeLineClass(cm.state.activeLines[i], "wrap", WRAP_CLASS);
			cm.removeLineClass(cm.state.activeLines[i], "background", BACK_CLASS);
			cm.removeLineClass(cm.state.activeLines[i], "gutter", GUTT_CLASS);
		}
	}

	function sameArray(a, b) {
		if (a.length != b.length) return false;
		for (var i = 0; i < a.length; i++)
			if (a[i] != b[i]) return false;
		return true;
	}

	function updateActiveLines(cm, ranges) {
		var active = [];
		for (var i = 0; i < ranges.length; i++) {
			var range = ranges[i];
			var option = cm.getOption("styleActiveLine");
			if (typeof option == "object" && option.nonEmpty ? range.anchor.line != range.head.line : !range.empty())
				continue
			var line = cm.getLineHandleVisualStart(range.head.line);
			if (active[active.length - 1] != line) active.push(line);
		}
		if (sameArray(cm.state.activeLines, active)) return;
		cm.operation(function() {
			clearActiveLines(cm);
			for (var i = 0; i < active.length; i++) {
				cm.addLineClass(active[i], "wrap", WRAP_CLASS);
				cm.addLineClass(active[i], "background", BACK_CLASS);
				cm.addLineClass(active[i], "gutter", GUTT_CLASS);
			}
			cm.state.activeLines = active;
		});
	}

	function selectionChange(cm, sel) {
		updateActiveLines(cm, sel.ranges);
	}
});

// #END

// ===== display/fullscreen.js
// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: https://codemirror.net/LICENSE

// codemirror: v.5.61.1

(function(mod) {
	if (typeof exports == "object" && typeof module == "object") // CommonJS
		mod(require("../../lib/codemirror"));
	else if (typeof define == "function" && define.amd) // AMD
		define(["../../lib/codemirror"], mod);
	else // Plain browser env
		mod(CodeMirror);
})(function(CodeMirror) {
	"use strict";

	CodeMirror.defineOption("fullScreen", false, function(cm, val, old) {
		if (old == CodeMirror.Init) old = false;
		if (!old == !val) return;
		if (val) setFullscreen(cm);
		else setNormal(cm);
	});

	function setFullscreen(cm) {
		var wrap = cm.getWrapperElement();
		cm.state.fullScreenRestore = {scrollTop: window.pageYOffset, scrollLeft: window.pageXOffset,
																	width: wrap.style.width, height: wrap.style.height};
		wrap.style.width = "";
		wrap.style.height = "auto";
		wrap.className += " CodeMirror-fullscreen";
		document.documentElement.style.overflow = "hidden";
		cm.refresh();
	}

	function setNormal(cm) {
		var wrap = cm.getWrapperElement();
		wrap.className = wrap.className.replace(/\s*CodeMirror-fullscreen\b/, "");
		document.documentElement.style.overflow = "";
		var info = cm.state.fullScreenRestore;
		wrap.style.width = info.width; wrap.style.height = info.height;
		window.scrollTo(info.scrollLeft, info.scrollTop);
		cm.refresh();
	}
});

// #END

// ===== [#]

// # JS Package: addons.pak.js :: #END#

