#!/bin/sh

# PAK: Combine all required CodeMirror Addons Javascript JS Source scripts from lib/js/jseditcode/codemirror/addon/%/*.js into one package JS file: lib/js/jseditcode/codemirror/addons.pak.js # r.20210605
# PAK: Combine all required CodeMirror Addons StyleSheet CSS Source scripts from lib/js/jseditcode/codemirror/addon/%/*.css into one package JS file: lib/js/jseditcode/codemirror/addons.pak.css # r.20210605

THE_JS_FILE=../lib/js/jseditcode/codemirror/addons.pak.js
THE_CSS_FILE=../lib/js/jseditcode/codemirror/addons.pak.css

echo "Regenerating CodeMirror Addons Javascript and CSS Packages: ${THE_JS_FILE} ; ${THE_CSS_FILE}"

echo "" > ${THE_JS_FILE}
echo "// # JS Package: addons.pak.js :: #START# :: @ generated from lib/js/jseditcode/codemirror/addon/%/*.js" >> ${THE_JS_FILE}
echo "// Included Addons: mode/simple.js ; fold/foldcode.js ; fold/foldgutter.js ; fold/brace-fold.js ; fold/indent-fold.js ; fold/comment-fold.js ; fold/markdown-fold.js ; fold/xml-fold.js ; edit/matchtags.js ; edit/matchbrackets.js ; dialog/dialog.js ; search/searchcursor.js ; search/search.js ; selection/active-line.js ; display/fullscreen.js #" >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}
echo "// ### DO NOT EDIT THIS FILE AS IT WILL BE OVERWRITTEN EACH TIME THE INCLUDED SCRIPTS WILL CHANGE !!! ###" >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}

echo "" > ${THE_CSS_FILE}
echo "/* # CSS Package: addons.pak.css :: #START# :: @ generated from lib/js/jseditcode/codemirror/addon/%/*.css */" >> ${THE_CSS_FILE}
echo "/* Included Addons: fold/foldgutter.css ; dialog/dialog.css ; display/fullscreen.css # */" >> ${THE_CSS_FILE}
echo "" >> ${THE_CSS_FILE}
echo "/* ### DO NOT EDIT THIS FILE AS IT WILL BE OVERWRITTEN EACH TIME THE INCLUDED SCRIPTS WILL CHANGE !!! ### */" >> ${THE_CSS_FILE}
echo "" >> ${THE_CSS_FILE}

echo "// ===== mode/simple.js" >> ${THE_JS_FILE}
cat ../lib/js/jseditcode/codemirror/addon/mode/simple.js >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}

echo "// ===== fold/foldcode.js" >> ${THE_JS_FILE}
cat ../lib/js/jseditcode/codemirror/addon/fold/foldcode.js >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}

echo "// ===== fold/foldgutter.js" >> ${THE_JS_FILE}
cat ../lib/js/jseditcode/codemirror/addon/fold/foldgutter.js >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}
echo "/* ===== fold/foldgutter.css */" >> ${THE_CSS_FILE}
cat ../lib/js/jseditcode/codemirror/addon/fold/foldgutter.css >> ${THE_CSS_FILE}
echo "" >> ${THE_CSS_FILE}

echo "// ===== fold/brace-fold.js" >> ${THE_JS_FILE}
cat ../lib/js/jseditcode/codemirror/addon/fold/brace-fold.js >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}

echo "// ===== fold/indent-fold.js" >> ${THE_JS_FILE}
cat ../lib/js/jseditcode/codemirror/addon/fold/indent-fold.js >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}

echo "// ===== fold/comment-fold.js" >> ${THE_JS_FILE}
cat ../lib/js/jseditcode/codemirror/addon/fold/comment-fold.js >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}

echo "// ===== fold/markdown-fold.js" >> ${THE_JS_FILE}
cat ../lib/js/jseditcode/codemirror/addon/fold/markdown-fold.js >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}

echo "// ===== fold/xml-fold.js" >> ${THE_JS_FILE}
cat ../lib/js/jseditcode/codemirror/addon/fold/xml-fold.js >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}

echo "// ===== edit/matchtags.js" >> ${THE_JS_FILE}
cat ../lib/js/jseditcode/codemirror/addon/edit/matchtags.js >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}

echo "// ===== edit/matchbrackets.js" >> ${THE_JS_FILE}
cat ../lib/js/jseditcode/codemirror/addon/edit/matchbrackets.js >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}

echo "// ===== edit/trailingspace.js" >> ${THE_JS_FILE}
cat ../lib/js/jseditcode/codemirror/addon/edit/trailingspace.js >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}

echo "// ===== dialog/dialog.js" >> ${THE_JS_FILE}
cat ../lib/js/jseditcode/codemirror/addon/dialog/dialog.js >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}
echo "/* ===== dialog/dialog.css */" >> ${THE_CSS_FILE}
cat ../lib/js/jseditcode/codemirror/addon/dialog/dialog.css >> ${THE_CSS_FILE}
echo "" >> ${THE_CSS_FILE}

echo "// ===== search/searchcursor.js" >> ${THE_JS_FILE}
cat ../lib/js/jseditcode/codemirror/addon/search/searchcursor.js >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}

echo "// ===== search/search.js" >> ${THE_JS_FILE}
cat ../lib/js/jseditcode/codemirror/addon/search/search.js >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}

echo "// ===== selection/active-line.js" >> ${THE_JS_FILE}
cat ../lib/js/jseditcode/codemirror/addon/selection/active-line.js >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}

echo "// ===== display/fullscreen.js" >> ${THE_JS_FILE}
cat ../lib/js/jseditcode/codemirror/addon/display/fullscreen.js >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}
echo "/* ===== display/fullscreen.css */" >> ${THE_CSS_FILE}
cat ../lib/js/jseditcode/codemirror/addon/display/fullscreen.css >> ${THE_CSS_FILE}
echo "" >> ${THE_CSS_FILE}

echo "// ===== [#]" >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}
echo "// # JS Package: addons.pak.js :: #END#" >> ${THE_JS_FILE}
echo "" >> ${THE_JS_FILE}

echo "/* ===== [#] */" >> ${THE_CSS_FILE}
echo "" >> ${THE_CSS_FILE}
echo "/* # JS Package: addons.pak.css :: #END# */" >> ${THE_CSS_FILE}
echo "" >> ${THE_CSS_FILE}

echo "[DONE !]"

# END
