#!/bin/sh

# PAK: Combine all required Charts Javascript Source scripts from lib/js/jscharts/src/Chart.*.js into one package JS file: lib/js/jscharts/charts.pak.js # r.20191126

THE_FILE=../lib/js/jscharts/charts.pak.js

echo "Regenerating Charts Javascript Package: ${THE_FILE}"

echo "" > ${THE_FILE}
echo "// # JS Package: charts.pak.js :: #START# :: @ generated from lib/js/jscharts/src/Chart.*.js" >> ${THE_FILE}
echo "// Included Files: Chart.Core.js ; Chart.Line.js ; Chart.StackedArea.js ; Chart.Stem.js ; Chart.Bar.js ; Chart.StackedBar.js ; Chart.Doughnut.js ; Chart.PolarArea.js ; Chart.Radar.js #" >> ${THE_FILE}
echo "" >> ${THE_FILE}
echo "// ### DO NOT EDIT THIS FILE AS IT WILL BE OVERWRITTEN EACH TIME THE INCLUDED SCRIPTS WILL CHANGE !!! ###" >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "// ===== Chart.Core.js" >> ${THE_FILE}
cat ../lib/js/jscharts/src/Chart.Core.js >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "// ===== Chart.Line.js" >> ${THE_FILE}
cat ../lib/js/jscharts/src/Chart.Line.js >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "// ===== Chart.StackedArea.js" >> ${THE_FILE}
cat ../lib/js/jscharts/src/Chart.StackedArea.js >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "// ===== Chart.Stem.js" >> ${THE_FILE}
cat ../lib/js/jscharts/src/Chart.Stem.js >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "// ===== Chart.Bar.js" >> ${THE_FILE}
cat ../lib/js/jscharts/src/Chart.Bar.js >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "// ===== Chart.StackedBar.js" >> ${THE_FILE}
cat ../lib/js/jscharts/src/Chart.StackedBar.js >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "// ===== Chart.Doughnut.js" >> ${THE_FILE}
cat ../lib/js/jscharts/src/Chart.Doughnut.js >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "// ===== Chart.PolarArea.js" >> ${THE_FILE}
cat ../lib/js/jscharts/src/Chart.PolarArea.js >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "// ===== Chart.Radar.js" >> ${THE_FILE}
cat ../lib/js/jscharts/src/Chart.Radar.js >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "// ===== [#]" >> ${THE_FILE}
echo "" >> ${THE_FILE}
echo "// # JS Package: charts.pak.js :: #END#" >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "[DONE !]"

# END
