#!/bin/sh

# PAK: Combine all required App CSS scripts from lib/css/app.css into one package CSS file: lib/css/app.pak.css # r.20221228

THE_FILE=../lib/css/app.pak.css

echo "Regenerating App CSS Package: ${THE_FILE}"

echo "" > ${THE_FILE}
echo "/* # CSS Package: app.pak.css :: #START# :: @ generated from lib/css/app.css */" >> ${THE_FILE}
echo "/* Included Files: toolkit/ux-toolkit.css ; toolkit/ux-toolkit-responsive.css ; plugins/markdown.css ; plugins/tpl-highlight.css # */" >> ${THE_FILE}
echo "" >> ${THE_FILE}
echo "/* ### DO NOT EDIT THIS FILE AS IT WILL BE OVERWRITTEN EACH TIME THE INCLUDED SCRIPTS WILL CHANGE !!! ### */" >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "/* ===== toolkit/ux-toolkit.css */" >> ${THE_FILE}
cat ../lib/css/toolkit/ux-toolkit.css >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "/* ===== toolkit/ux-toolkit-responsive.css */" >> ${THE_FILE}
cat ../lib/css/toolkit/ux-toolkit-responsive.css >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "/* ===== plugins/markdown.css */" >> ${THE_FILE}
cat ../lib/css/plugins/markdown.css >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "/* ===== plugins/tpl-highlight.css */" >> ${THE_FILE}
cat ../lib/css/plugins/tpl-highlight.css >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "/* ===== [#] */" >> ${THE_FILE}
echo "" >> ${THE_FILE}
echo "/* # CSS Package: app.pak.css :: #END# */" >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "[DONE !]"

# END
