#!/bin/sh

# PAK: Combine all required App Core CSS scripts from lib/core/css/app.css into one package CSS file: lib/core/css/app.pak.css # r.20221228

THE_FILE=../lib/core/css/app.pak.css

echo "Regenerating App Core CSS Package: ${THE_FILE}"

echo "" > ${THE_FILE}
echo "/* # CSS Package: core/app.pak.css :: #START# :: @ generated from lib/core/css/app.css */" >> ${THE_FILE}
echo "/* Included Files: custom.css ; notifications.css ; notifications-icons.css # */" >> ${THE_FILE}
echo "" >> ${THE_FILE}
echo "/* ### DO NOT EDIT THIS FILE AS IT WILL BE OVERWRITTEN EACH TIME THE INCLUDED SCRIPTS WILL CHANGE !!! ### */" >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "/* ===== core/custom.css */" >> ${THE_FILE}
cat ../lib/core/css/custom.css >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "/* ===== core/notifications.css */" >> ${THE_FILE}
cat ../lib/core/css/notifications.css >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "/* ===== core/notifications-icons.css */" >> ${THE_FILE}
cat ../lib/core/css/notifications-icons.css >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "/* ===== [#] */" >> ${THE_FILE}
echo "" >> ${THE_FILE}
echo "/* # CSS Package: core/app.pak.css :: #END# */" >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "[DONE !]"

# END
