#!/bin/sh

# PAK: Combine all required App Core.Plugins CSS scripts from lib/core/plugins/css/app.css into one package CSS file: lib/core/plugins/css/app.pak.css # r.20231020

THE_FILE=../lib/core/plugins/css/app.pak.css

echo "Regenerating App Core CSS Package: ${THE_FILE}"

echo "" > ${THE_FILE}
echo "/* # CSS Package: core/plugins/app.pak.css :: #START# :: @ generated from lib/core/plugins/css/app.css */" >> ${THE_FILE}
echo "/* Included Files: navpager.css ; email.css ; v-timeline/style.css ; v-timeline/style-responsive.css ; s2org-flow/style.css ; txt-columns/style.css ; txt-columns/style-responsive.css # */" >> ${THE_FILE}
echo "" >> ${THE_FILE}
echo "/* ### DO NOT EDIT THIS FILE AS IT WILL BE OVERWRITTEN EACH TIME THE INCLUDED SCRIPTS WILL CHANGE !!! ### */" >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "/* ===== core/plugins/navpager.css */" >> ${THE_FILE}
cat ../lib/core/plugins/css/navpager.css >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "/* ===== core/plugins/email.css */" >> ${THE_FILE}
cat ../lib/core/plugins/css/email.css >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "/* ===== core/plugins/v-timeline/style.css */" >> ${THE_FILE}
cat ../lib/core/plugins/css/v-timeline/style.css >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "/* ===== core/plugins/v-timeline/style-responsive.css */" >> ${THE_FILE}
cat ../lib/core/plugins/css/v-timeline/style-responsive.css >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "/* ===== core/plugins/s2org-flow/style.css */" >> ${THE_FILE}
cat ../lib/core/plugins/css/s2org-flow/style.css >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "/* ===== core/plugins/txt-columns/style.css */" >> ${THE_FILE}
cat ../lib/core/plugins/css/txt-columns/style.css >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "/* ===== core/plugins/txt-columns/style-responsive.css */" >> ${THE_FILE}
cat ../lib/core/plugins/css/txt-columns/style-responsive.css >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "/* ===== [#] */" >> ${THE_FILE}
echo "" >> ${THE_FILE}
echo "/* # CSS Package: core/plugins/app.pak.css :: #END# */" >> ${THE_FILE}
echo "" >> ${THE_FILE}

echo "[DONE !]"

# END
