/* taken from musl */

#include <stdint.h>
#include <string.h>

static char *twobyte_strstr(const unsigned char *h, const unsigned char *n)
{
	__u16 nw = n[0] << 8 | n[1], hw = h[0] << 8 | h[1];

	for (h++; *h && hw != nw; hw = hw << 8 | *++h)
		;

	return *h ? (char *)h - 1 : 0;
}

static char *threebyte_strstr(const unsigned char *h, const unsigned char *n)
{
	__u32 nw = (__u32)n[0] << 24 | n[1] << 16 | n[2] << 8;
	__u32 hw = (__u32)h[0] << 24 | h[1] << 16 | h[2] << 8;

	for (h += 2; *h && hw != nw; hw = (hw | *++h) << 8)
		;

	return *h ? (char *)h - 2 : 0;
}

static char *fourbyte_strstr(const unsigned char *h, const unsigned char *n)
{
	__u32 nw = (__u32)n[0] << 24 | n[1] << 16 | n[2] << 8  | n[3];
	__u32 hw = (__u32)h[0] << 24 | h[1] << 16 | h[2] << 8 | h[3];

	for (h += 3; *h && hw != nw; hw = hw << 8 | *++h)
		;

	return *h ? (char *)h - 3 : 0;
}

#define MAX(a, b) ((a) > (b) ? (a) : (b))
#define MIN(a, b) ((a) < (b) ? (a) : (b))

#define BITOP(a, b, op)						\
	((a)[(__sz)(b) / (8 * sizeof *(a))] op			\
	 (__sz)1 << ((__sz)(b) % (8 * sizeof *(a))))

static char *twoway_strstr(const unsigned char *h, const unsigned char *n)
{
	__sz l, ip, jp, k, p, ms, p0, mem, mem0;
	__sz byteset[32 / sizeof(__sz)] = { 0 };
	const unsigned char *z;
	__sz shift[256];

	/* Computing length of needle and fill shift table */
	for (l = 0; n[l] && h[l]; l++)
		BITOP(byteset, n[l], |=), shift[n[l]] = l + 1;

	if (n[l])
		return 0; /* hit the end of h */

	/* Compute maximal suffix */
	ip = -1;
	jp = 0;
	k = 1;
	p = 1;
	while (jp + k < l) {
		if (n[ip + k] == n[jp + k]) {
			if (k == p) {
				jp += p;
				k = 1;
			} else {
				k++;
			}
		} else if (n[ip + k] > n[jp + k]) {
			jp += k;
			k = 1;
			p = jp - ip;
		} else {
			ip = jp++;
			k = 1;
			p = 1;
		}
	}

	ms = ip;
	p0 = p;

	/* And with the opposite comparison */
	ip = -1;
	jp = 0;
	k = 1;
	p = 1;
	while (jp + k < l) {
		if (n[ip + k] == n[jp + k]) {
			if (k == p) {
				jp += p;
				k = 1;
			} else {
				k++;
			}
		} else if (n[ip + k] < n[jp + k]) {
			jp += k;
			k = 1;
			p = jp - ip;
		} else {
			ip = jp++;
			k = 1;
			p = 1;
		}
	}

	if (ip + 1 > ms + 1)
		ms = ip;
	else
		p = p0;

	/* Periodic needle? */
	if (memcmp(n, n + p, ms + 1)) {
		mem0 = 0;
		p = MAX(ms, l - ms - 1) + 1;
	} else {
		mem0 = l - p;
	}

	mem = 0;

	/* Initialize incremental end-of-haystack pointer */
	z = h;

	/* Search loop */
	for (;;) {
		/* Update incremental end-of-haystack pointer */
		if (z - h < (long)l) {
			/* Fast estimate for MAX(l, 63) */
			__sz grow = l | 63;
			const unsigned char *z2 = memchr(z, 0, grow);

			if (z2) {
				z = z2;
				if (z - h < (long)l)
					return 0;
			} else {
				z += grow;
			}
		}

		/* Check last byte first; advance by shift on mismatch */
		if (BITOP(byteset, h[l - 1], &)) {
			k = l - shift[h[l - 1]];
			if (k) {
				if (k < mem)
					k = mem;

				h += k;
				mem = 0;
				continue;
			}
		} else {
			h += l;
			mem = 0;
			continue;
		}

		/* Compare right half */
		for (k = MAX(ms + 1, mem); n[k] && n[k] == h[k]; k++)
			;

		if (n[k]) {
			h += k - ms;
			mem = 0;
			continue;
		}

		/* Compare left half */
		for (k = ms + 1; k > mem && n[k - 1] == h[k - 1]; k--)
			;

		if (k <= mem)
			return (char *)h;

		h += p;
		mem = mem0;
	}
}

char *strstr(const char *h, const char *n)
{
	/* Return immediately on empty needle */
	if (!n[0])
		return (char *)h;

	/* Use faster algorithms for short needles */
	h = strchr(h, *n);
	if (!h || !n[1])
		return (char *)h;
	if (!h[1])
		return 0;
	if (!n[2])
		return twobyte_strstr((void *)h, (void *)n);
	if (!h[2])
		return 0;
	if (!n[3])
		return threebyte_strstr((void *)h, (void *)n);
	if (!h[3])
		return 0;
	if (!n[4])
		return fourbyte_strstr((void *)h, (void *)n);

	return twoway_strstr((void *)h, (void *)n);
}
