import Vue from 'vue'

const filters = {
    devide_10k: function (num) {
        return num >= 10000 ? (num / 10000).toFixed(1) + '万' : num
    },
    // 时间格式化
    formatTime: function (time, formatType) {
        if (arguments.length === 0) {
            return null
        }
        const format = formatType || '{y}-{m}-{d} {h}:{i}:{s}'
        let date
        if (typeof time === 'object') {
            date = time
        } else {
            if (('' + time).length === 10) time = parseInt(time) * 1000
            date = new Date(time)
        }
        const formatObj = {
            y: date.getFullYear(),
            m: date.getMonth() + 1,
            d: date.getDate(),
            h: date.getHours(),
            i: date.getMinutes(),
            s: date.getSeconds(),
            a: date.getDay()
        }
        const time_str = format.replace(/{(y|m|d|h|i|s|a)+}/g, (result, key) => {
            let value = formatObj[key]
            if (key === 'a') return ['一', '二', '三', '四', '五', '六', '日'][value - 1]
            if (result.length > 0 && value < 10) {
                value = '0' + value
            }
            return value || 0
        })
        return time_str
    }
}

// 注册全局过滤
Object.keys(filters).forEach(key => {
    Vue.filter(key, filters[key])
})
// 挂在到全局
Vue.prototype.$filter = filters
