﻿using JetBrains.Annotations;

namespace ImplicitNullability.Samples.CodeWithIN.Highlighting.IncorrectNullableAttributeUsageAnalyzer
{
    public static class OtherWarningsSample
    {
        // Test that our problem analyzer, which hides IncorrectNullableAttributeUsageAnalyzer still passes the remaining warnings.

        public interface IInterface
        {
            void ExplicitCanBeNull([CanBeNull] string a);

            string Property { get; set; }
        }

        public class Implementation : IInterface
        {
            public void ExplicitCanBeNull([NotNull] /*Expect:AnnotationConflictInHierarchy*/ string a)
            {
            }

            [NotNull] /*Expect:AnnotationRedundancyAtValueType*/
            public void AnnotationOnVoid()
            {
            }

            [NotNull] /*Expect:AnnotationRedundancyAtValueType*/
            public int AnnotationOnStruct() => 0;

            [ItemNotNull] /*Expect:ContainerAnnotationRedundancy*/
            public object NonAsyncMethod() => "";

            [NotNull, CanBeNull]
            public string MultipleAnnotations /*Expect:MultipleNullableAttributesUsage*/() => "";

            [NotNull] /*Expect:NotObservableAnnotationRedundancy[!Implicit]*/
            // In case of enabled IN, the (suppressed) AnnotationRedundancyInHierarchy hides the NotObservableAnnotationRedundancy
            // ReSharper disable once NotNullMemberIsNotInitialized - it's not about this warning
            string IInterface.Property { get; set; }
        }
    }
}
