#include "string_table.h"

const char *string_table[] = {
	"",
	"\0",
	"\0",
	"\n",
	" (Shape)",
	" Created by Blender",
	" FBX ?.?.?",
	" Parameters/Connections",
	" Parameters/Connections|",
	"$",
	"%6u:%s: %s\n",
	"%s",
	"%u (max %u)",
	"%zu",
	"&",
	"&cr;",
	"&lf;",
	"&quot;",
	"(internal)",
	"(usemtl|mtllib)\\s+\\S.*",
	"(vn?\\s+\\F|vt)\\s+\\F\\s+\\F.*",
	"*3 { 1,2,3 }",
	"+r",
	"-->",
	"-Watomic-implicit-seq-cst",
	"-Wbad-function-cast",
	"-Wc90-c99-compat",
	"-Wc99-c11-compat",
	"-Wcast-align",
	"-Wcast-qual",
	"-Wcovered-switch-default",
	"-Wdeclaration-after-statement",
	"-Wdouble-promotion",
	"-Wfloat-equal",
	"-Wformat-nonliteral",
	"-Wlong-long",
	"-Wmissing-braces",
	"-Wmissing-field-initializers",
	"-Wold-style-cast",
	"-Wpadded",
	"-Wpedantic",
	"-Wswitch-enum",
	"-Wunused-function",
	"-Wunused-parameter",
	"-Wzero-as-null-pointer-constant",
	"-[A-Za-z][\\-A-Za-z0-9_]*",
	".%s",
	".Offset R",
	".Offset S",
	".Offset T",
	".Weight",
	".connected",
	".shader",
	"0 - 15: Represent code lengths of 0 - 15",
	"16: Copy the previous code length 3 - 6 times. The next 2 bits indicate repeat length.",
	"17: Repeat a code length of 0 for 3 - 10 times. (3 bits of length)",
	"18: Repeat a code length of 0 for 11 - 138 times (7 bits of length)",
	"3dsMax|",
	"3dsMax|ClassIDa",
	"3dsMax|ClassIDb",
	"3dsMax|MaxTexture",
	"3dsMax|Parameters|",
	"3dsMax|Parameters|base_color",
	"3dsMax|main|",
	"3dsMax|parameters",
	"3dsMax|params|OSLCode",
	"3dsMax|params|OSLShaderName",
	": ",
	"::",
	"; FBX 7.7.0 project file",
	";\\s*FBX\\s*\\d+\\.\\d+\\.\\d+\\s*project\\s+file",
	"=a",
	"=d",
	"=m",
	">",
	"?>",
	"A",
	"A+",
	"ARNOLD_SHADER_ID",
	"Active",
	"Affect",
	"AffectRotation",
	"AffectScale",
	"AffectTranslation",
	"Aim",
	"Aim At Object",
	"AimVector",
	"AllSame",
	"Allocation limit exceeded",
	"Alphas",
	"Ambient",
	"AmbientColor",
	"AmbientFactor",
	"Animated",
	"AnimationCurve",
	"AnimationCurveNode",
	"AnimationLayer",
	"AnimationStack",
	"Aperture",
	"ApertureFormat",
	"ApertureMode",
	"AreaLightShape",
	"AspectH",
	"AspectHeight",
	"AspectRatioMode",
	"AspectType",
	"AspectW",
	"AspectWidth",
	"AssociateModel",
	"Autodesk_Cache_File",
	"AxisLen",
	"B",
	"Bad DEFLATE data",
	"Bad NURBS geometry",
	"Bad UTF-8 string",
	"Bad array dst type",
	"Bad array encoding",
	"Bad array source type",
	"Bad array type",
	"Bad attrib value",
	"Bad boundary mode",
	"Bad data_encoding",
	"Bad data_format",
	"Bad endian swap size",
	"Bad format char",
	"Bad index",
	"Bad interpolation mode",
	"Bad multivalue array type",
	"Bad value type",
	"BaseLayer",
	"BinaryData",
	"BindPose",
	"BindingTable",
	"Binormals",
	"BinormalsIndex",
	"BinormalsW",
	"Blend",
	"BlendMode",
	"BlendModes",
	"BlendShape",
	"BlendShapeChannel",
	"BlendWeights",
	"Blob",
	"Bool",
	"Boolean",
	"Boundary",
	"BoundaryRule",
	"Bump",
	"BumpFactor",
	"ByEdge",
	"ByPolygon",
	"ByPolygonVertex",
	"ByVertex",
	"ByVertice",
	"C",
	"CC",
	"CDATA[",
	"Cache",
	"CacheAbsoluteFileName",
	"CacheFileName",
	"CacheFileType",
	"Camera",
	"CameraAperture",
	"CameraIndexName",
	"CameraProjectionType",
	"CameraStereo",
	"CameraSwitcher",
	"Cancelled",
	"CastLight",
	"CastShadows",
	"Channel",
	"ChannelInterpretation",
	"ChannelName",
	"ChannelType",
	"Channels",
	"Character",
	"Children",
	"Clamped index",
	"Closed",
	"Cluster",
	"Collection",
	"CollectionExclusive",
	"Color",
	"ColorAndAlpha",
	"ColorIndex",
	"ColorRGB",
	"Colors",
	"Comment",
	"Compound",
	"Cone angle",
	"ConeAngle",
	"Connect",
	"Connections",
	"Constrained Object",
	"Constrained object (Child)",
	"Constraint",
	"Content",
	"CoordAxis",
	"CoordAxisSign",
	"Corrupted or missing vertex attribute (%u) at %zu",
	"Corrupted topology structure",
	"Could not open .mtl file: %s",
	"Count",
	"Creator",
	"Cropping",
	"CurrentTextureBlendMode",
	"CurrentTimeMarker",
	"CustomFrameRate",
	"CustomHeight",
	"CustomWidth",
	"Cyclic node hierarchy",
	"D",
	"DateTime",
	"DecayType",
	"Default",
	"DefaultAttributeIndex",
	"DefaultCamera",
	"Definitions",
	"DeformPercent",
	"Deformer",
	"Diffuse",
	"DiffuseColor",
	"DiffuseFactor",
	"Dimension",
	"Dimensions",
	"Displacement",
	"DisplacementFactor",
	"DisplayLayer",
	"DisplayLevels|Level%zu",
	"Distance",
	"Distance codes 0-31 are represented by (fixed-length) 5-bit codes",
	"Document",
	"DocumentUrl",
	"Documents",
	"DualQuaternion",
	"Duplicate connection to %u",
	"Duplicate object ID",
	"Duplicate override",
	"Edge index out of bounds",
	"EdgeCrease",
	"EdgeIndexArray",
	"Edges",
	"Effector",
	"Emissive",
	"EmissiveColor",
	"EmissiveFactor",
	"Empty face has been removed",
	"Enabled",
	"End Joint",
	"EndTime",
	"Entry",
	"Expected a 'Name:' token",
	"Expected at least mesh.num_indices (%zu), got %zu",
	"External file not found",
	"FBXHeaderExtension",
	"FBXHeaderExtension:.*",
	"FBXVersion",
	"FKEffector",
	"FOR4",
	"FOR8",
	"Face index begin (%u) out of bounds (%zu)",
	"Face index end (%u + %u) out of bounds (%zu)",
	"Face needs at least %zu indices for triangles, got space for %zu",
	"Failed to bake anim",
	"Failed to create anim",
	"Failed to evaluate",
	"Failed to generate indices",
	"Failed to load",
	"Failed to load geometry cache",
	"Failed to open geometry cache: %s",
	"Failed to open memory",
	"Failed to subdivide",
	"Failed to tessellate",
	"FarPlane",
	"Fbx",
	"FbxPropertyEntry",
	"FbxSemanticEntry",
	"Feature disabled",
	"FieldOfView",
	"FieldOfViewX",
	"FieldOfViewXProperty",
	"FieldOfViewY",
	"FieldOfViewYProperty",
	"File not found",
	"FileId",
	"FileName",
	"Filename",
	"FilmHeight",
	"FilmSqueezeRatio",
	"FilmWidth",
	"First Joint",
	"FlipNormals",
	"Float",
	"FocalLength",
	"Focused",
	"Form",
	"Format",
	"Frame%u.%s",
	"Frame%uTick%u.%s",
	"FrameRate",
	"Freeze",
	"FrontAxis",
	"FrontAxisSign",
	"FullWeights",
	"GCC unroll 0",
	"GateFit",
	"GeometricRotation",
	"GeometricScaling",
	"GeometricTranslation",
	"Geometry",
	"GeometryUVInfo",
	"GlobalSettings",
	"Hole",
	"HotSpot",
	"I",
	"II",
	"IKEffector",
	"IO error",
	"ImageData",
	"Implementation",
	"Indexes",
	"InheritType",
	"InnerAngle",
	"Integer",
	"Intensity",
	"Invalid UTF-8",
	"Invalid mapping",
	"IsTheNodeInSet",
	"KString",
	"KTime",
	"Ka",
	"Kaydara FBX Binary  \0",
	"Kd",
	"Ke",
	"Key",
	"KeyAttrDataFloat",
	"KeyAttrFlags",
	"KeyAttrRefCount",
	"KeyCount",
	"KeyTime",
	"KeyValueFloat",
	"KnotVector",
	"KnotVectorU",
	"KnotVectorV",
	"Ks",
	"L",
	"LL",
	"LODBox",
	"LODGroup",
	"Lambert",
	"LastSaved|ApplicationName",
	"LastSaved|ApplicationVendor",
	"LastSaved|ApplicationVersion",
	"Layer",
	"LayerElement",
	"LayerElementBinormal",
	"LayerElementColor",
	"LayerElementDiffuseFactorTextures",
	"LayerElementEdgeCrease",
	"LayerElementEmissive_Textures",
	"LayerElementHole",
	"LayerElementMaterial",
	"LayerElementNormal",
	"LayerElementPolygonGroup",
	"LayerElementSmoothing",
	"LayerElementTangent",
	"LayerElementTexture",
	"LayerElementUV",
	"LayerElementVertexCrease",
	"LayerElementVisibility",
	"LayeredTexture",
	"Lcl Rotation",
	"Lcl Scaling",
	"Lcl Translation",
	"LeftCamera",
	"Light",
	"LightType",
	"Limb",
	"LimbLength",
	"LimbNode",
	"Line",
	"Linear",
	"Link",
	"LocalStart",
	"LocalStop",
	"LocalTime",
	"LodGroup",
	"LookAtProperty",
	"Low Line",
	"Lss",
	"MRGB",
	"MULTIOUTPUT_TO_OSLMap",
	"Map",
	"MappingInformationType",
	"Marker",
	"Mat",
	"Material",
	"MaterialAssignation",
	"Materials",
	"Matrix",
	"MaxDampRangeX",
	"MaxDampRangeY",
	"MaxDampRangeZ",
	"MaxDampStrengthX",
	"MaxDampStrengthY",
	"MaxDampStrengthZ",
	"MaxDistance",
	"Media",
	"Member",
	"Memory limit exceeded",
	"Mesh",
	"MinDampRangeX",
	"MinDampRangeY",
	"MinDampRangeZ",
	"MinDampStrengthX",
	"MinDampStrengthY",
	"MinDampStrengthZ",
	"MinDistance",
	"MinMaxDistance",
	"Missing geometry data: %s",
	"Model",
	"Model::Scene",
	"ModelUVScaling",
	"ModelUVTranslation",
	"Name",
	"Name\0Type",
	"NearPlane",
	"NegativePercentShapeSupport",
	"Ni",
	"Node",
	"Node:",
	"NodeAttribute",
	"NodeAttributeName",
	"Non-negated last index",
	"Non-node element connected to root",
	"Normal index (%d) out of bounds (%zu) at %zu",
	"NormalMap",
	"Normals",
	"NormalsIndex",
	"NormalsW",
	"Not an FBX file",
	"Ns",
	"Null",
	"Number",
	"Nurbs",
	"NurbsCurve",
	"NurbsSurface",
	"NurbsSurfaceOrder",
	"OO",
	"OO\0",
	"OP",
	"OP\0",
	"OSL",
	"OSLBitmap",
	"OSLBitmap2",
	"OSLMap",
	"Object",
	"ObjectMetaData",
	"ObjectType",
	"Objects",
	"OneFile",
	"OneFilePerFrame",
	"Open",
	"Opened .mtl file derived from .obj filename: %s",
	"Order",
	"OriginalUnitScaleFactor",
	"OriginalUpAxis",
	"OriginalUpAxisSign",
	"Original|ApplicationName",
	"Original|ApplicationVendor",
	"Original|ApplicationVersion",
	"OrthoZoom",
	"Out of memory",
	"OuterAngle",
	"P",
	"PO",
	"PO\0",
	"POINTCACHE2",
	"PP",
	"PP\0",
	"Parent-Child",
	"Pc",
	"Pcr",
	"Periodic",
	"Phong",
	"Pm",
	"Points",
	"PointsIndex",
	"Pole Vector Object",
	"PoleVectorType",
	"PolygonGroup",
	"PolygonIndexArray",
	"PolygonVertexIndex",
	"Pose",
	"PoseNode",
	"Position From Positions",
	"PostRotation",
	"Pr",
	"PreRotation",
	"PreferedAngleX",
	"PreferedAngleY",
	"PreferedAngleZ",
	"PreviewDivisionLevels",
	"Properties",
	"Properties60",
	"Properties70",
	"Property",
	"PropertyTemplate",
	"Ps",
	"QuaternionInterpolate",
	"Question Mark",
	"R",
	"R\0\0",
	"RRR",
	"R_",
	"Real",
	"Reference",
	"ReferenceStart",
	"ReferenceStop",
	"ReferenceTime",
	"References",
	"Reflection",
	"ReflectionColor",
	"ReflectionFactor",
	"Relations",
	"RelativeFileName",
	"RelativeFilename",
	"RenderAPI",
	"RenderDivisionLevels",
	"Replacement Character",
	"Required mesh.num_indices (%zu) indices, got %zu",
	"RightCamera",
	"Rigid",
	"Root",
	"RootNode",
	"Rotation",
	"Rotation From Rotations",
	"RotationAccumulationMode",
	"RotationActive",
	"RotationMax",
	"RotationMaxX",
	"RotationMaxY",
	"RotationMaxZ",
	"RotationMin",
	"RotationMinX",
	"RotationMinY",
	"RotationMinZ",
	"RotationOffset",
	"RotationOrder",
	"RotationPivot",
	"RotationSpaceForLimitOnly",
	"RotationStiffnessX",
	"RotationStiffnessY",
	"RotationStiffnessZ",
	"Roughness_Map",
	"S",
	"S\0\0",
	"SC",
	"SCSC",
	"SFX_PBS_SHADER",
	"SamplingRate",
	"Scale From Scales",
	"ScaleAccumulationMode",
	"Scaling",
	"ScalingActive",
	"ScalingMax",
	"ScalingMaxX",
	"ScalingMaxY",
	"ScalingMaxZ",
	"ScalingMin",
	"ScalingMinX",
	"ScalingMinY",
	"ScalingMinZ",
	"ScalingOffset",
	"ScalingPivot",
	"Scene\0Model",
	"SceneGenericPersistence",
	"SceneInfo",
	"Segment scale compensate",
	"SelectionNode",
	"SelectionSet",
	"Settings",
	"ShaderGraph",
	"ShadingModel",
	"Shape",
	"Shininess",
	"ShininessExponent",
	"Show",
	"Single Chain IK",
	"Size",
	"Skin",
	"SkinningType",
	"Smoothing",
	"Smoothness",
	"SnapOnFrameMode",
	"Source",
	"Source (Parent)",
	"Specular",
	"SpecularColor",
	"SpecularFactor",
	"SqueezeRatio",
	"StartTime",
	"Step",
	"String",
	"SubDeformer",
	"Switcher",
	"T",
	"T\0\0",
	"TEX_",
	"Take",
	"Takes",
	"Tangents",
	"TangentsIndex",
	"TangentsW",
	"Texture",
	"Texture alpha",
	"TextureId",
	"TextureName",
	"TextureRotationPivot",
	"TextureScalingPivot",
	"TextureUV",
	"TextureUVVerticeIndex",
	"Textures",
	"Tf",
	"ThresholdsUsedAsPercentage",
	"Thresholds|Level%zu",
	"Thumbnail",
	"TimeMarker",
	"TimeMode",
	"TimePerFrame",
	"TimeProtocol",
	"TimeSpanStart",
	"TimeSpanStop",
	"Transform",
	"TransformAssociateModel",
	"TransformLink",
	"Translation",
	"TranslationActive",
	"TranslationMax",
	"TranslationMaxX",
	"TranslationMaxY",
	"TranslationMaxZ",
	"TranslationMin",
	"TranslationMinX",
	"TranslationMinY",
	"TranslationMinZ",
	"TransparencyFactor",
	"Transparent",
	"TransparentColor",
	"TransparentFactor",
	"Triangulation disabled",
	"TrimNurbsSurface",
	"Truncated array: %s",
	"Truncated file",
	"Truncated vertex stream",
	"Type",
	"TypedIndex",
	"UFBXI_FEATURE_ANIMATION_BAKING",
	"UFBXI_FEATURE_FORMAT_OBJ",
	"UFBXI_FEATURE_GEOMETRY_CACHE",
	"UFBXI_FEATURE_INDEX_GENERATION",
	"UFBXI_FEATURE_SCENE_EVALUATION",
	"UFBXI_FEATURE_SKINNING_EVALUATION",
	"UFBXI_FEATURE_SUBDIVISION",
	"UFBXI_FEATURE_TESSELLATION",
	"UFBX_ENABLE_ANIMATION_BAKING",
	"UFBX_ENABLE_FORMAT_OBJ",
	"UFBX_ENABLE_GEOMETRY_CACHE",
	"UFBX_ENABLE_INDEX_GENERATION",
	"UFBX_ENABLE_SCENE_EVALUATION",
	"UFBX_ENABLE_SKINNING_EVALUATION",
	"UFBX_ENABLE_SUBDIVISION",
	"UFBX_ENABLE_TESSELLATION",
	"UFBX_INDEX_ERROR_HANDLING_ABORT_LOADING",
	"UV",
	"UV\0",
	"UVIndex",
	"UVSet",
	"UVSwap",
	"UberBitmap",
	"UberBitmap2",
	"Unexpected aperture mode",
	"Unexpected aspect mode",
	"Unexpected constraint prop",
	"Unexpected gate fit",
	"Unhandled format",
	"Unhandled index_error_handling",
	"Unhandled legacy fmt",
	"Unhandled match character",
	"Uninitialized options",
	"UnitScaleFactor",
	"Unknown .obj directive, skipped line",
	"Unknown error",
	"Unknown key mode",
	"Unknown slope mode",
	"Unknown tag",
	"Unknown weight mode",
	"Unreachable, set to vertical/horizontal above",
	"Unrecognized file format",
	"Unsafe options",
	"UpAxis",
	"UpAxisSign",
	"UpVector",
	"UpVectorProperty",
	"Vector",
	"Vector3D",
	"VectorDisplacement",
	"VectorDisplacementFactor",
	"Version",
	"Version5",
	"VertexCacheDeformer",
	"VertexCrease",
	"VertexCreaseIndex",
	"VertexIndexArray",
	"Vertices",
	"Video",
	"Visibility",
	"Visibility Inheritance",
	"Weight",
	"Weights",
	"World Up Object",
	"WorldSpace",
	"WorldUpType",
	"WrapModeU",
	"WrapModeV",
	"X",
	"X\0\0",
	"Y",
	"Y\0\0",
	"Z",
	"Z\0\0",
	"ZZ",
	"Zero vertex size",
	"[0-9]",
	"[\\-+]?[0-9]+(\\.[0-9]+)?([eE][\\-+]?[0-9]+)?",
	"\\c.obj",
	"\\c\\.fbx",
	"\\c\\.mtl",
	"\\c\\.obj",
	"\\cnormals?",
	"\\cpoints?",
	"\\cpositions?",
	"\\s*#\\s*File exported by ZBrush.*",
	"]]>",
	"_LL",
	"_LLS",
	"_LSL",
	"_LSLS",
	"_R",
	"_cc",
	"_ccs",
	"_csc",
	"_cscs",
	"_map",
	"_map_on",
	"a",
	"adjust",
	"aiEnableMatte",
	"aiMatteColor",
	"aiMatteColorA",
	"ai_image",
	"allocator",
	"amp",
	"aniso",
	"aniso_angle",
	"anisoangle",
	"anisor",
	"anisotropy",
	"ao",
	"apos",
	"array",
	"ator->num_allocs < ator->max_allocs",
	"b",
	"base",
	"base-class",
	"base64-string",
	"baseColor",
	"base_color",
	"base_weight",
	"blender version ?.?",
	"blender- ?.?",
	"blender-- ?.?.?",
	"bool",
	"borrow",
	"borrowed",
	"bump",
	"bump_map_amt",
	"c",
	"cacheTimePerFrame",
	"cacheType",
	"canonical",
	"caustics",
	"clang loop unroll(disable)",
	"clang loop vectorize(disable)",
	"clearcoat_bump_map_amt",
	"cm",
	"coat",
	"coatAnisotropy",
	"coatColor",
	"coatIOR",
	"coatNormal",
	"coatRotation",
	"coatRoughness",
	"coat_IOR",
	"coat_affect_color",
	"coat_affect_roughness",
	"coat_anisotropy",
	"coat_bump",
	"coat_color",
	"coat_ior",
	"coat_normal",
	"coat_rotation",
	"coat_rough",
	"coat_roughness",
	"coat_roughness_inv",
	"coating",
	"code length",
	"color",
	"container",
	"cutout",
	"d",
	"dielectricPriority",
	"diff_rough",
	"diff_roughness",
	"diffuseRoughness",
	"diffuse_roughness",
	"disabled",
	"disp",
	"displacement",
	"displacement_amt",
	"displacement_map_amt",
	"divq %[v]",
	"double",
	"d|X",
	"d|Y",
	"d|Z",
	"element %u prop \\",
	"emission",
	"emissionColor",
	"emission_color",
	"emissive",
	"emissive_intensity",
	"emit_color",
	"enum",
	"exitToBackground",
	"extension|Specular",
	"extension|clearcoat",
	"extension|clearcoatNormal",
	"extension|clearcoatRoughness",
	"extension|enableClearCoat",
	"extension|enableIndexOfRefraction",
	"extension|enableSheen",
	"extension|enableSpecular",
	"extension|enableTransmission",
	"extension|indexOfRefraction",
	"extension|sheenColor",
	"extension|sheenRoughness",
	"extension|specular",
	"extension|specularColor",
	"extension|specularcolor",
	"extension|transmission",
	"extension|unlit",
	"extra",
	"f\\s+[\\-/0-9]+\\s+[\\-/0-9]+\\s*[\\-/0-9]+.*",
	"fbx sdk/fbx plugins build ?",
	"fbx sdk/fbx plugins version ?.?",
	"fbx unity export version ?.?",
	"fbx unity export version ?.?.?",
	"filename",
	"geometry transforms",
	"glossiness",
	"gt",
	"hole",
	"index (%d) out of bounds (%zu)",
	"index (%zu) out of range (%zu)",
	"indirectDiffuse",
	"indirectSpecular",
	"int",
	"internalReflections",
	"lambert",
	"layer_ids out of bounds",
	"leak",
	"list",
	"lock; xaddl %0, %1;",
	"lock; xaddq %0, %1;",
	"logical",
	"lt",
	"m",
	"made using asset forge",
	"main|Alpha",
	"main|DoubleSided",
	"main|ambientOcclusion",
	"main|baseColor",
	"main|emission",
	"main|emissionColor",
	"main|metalness",
	"main|normal",
	"main|roughness",
	"map_",
	"material_mode",
	"mc",
	"mcc",
	"mcx",
	"memory",
	"metallic",
	"metalness",
	"model created by kenney",
	"motionbuilder version ?.?",
	"motionbuilder/mocap/online version ?.?",
	"mtllib",
	"newmtl",
	"newmtl\\s+\\S.*",
	"non standard",
	"norm",
	"normal",
	"normalCamera",
	"notes",
	"object",
	"obj|args",
	"off",
	"on",
	"opacity",
	"open_file_fn()",
	"outputChannelIndex",
	"override_layer_weights[] count must match layer_ids[] count",
	"packed_size != 0",
	"phong",
	"points",
	"preset",
	"ptr",
	"quot",
	"r",
	"rb",
	"refl_color",
	"reflectivity",
	"regression",
	"result",
	"roughness",
	"roughness_inv",
	"s",
	"scattering",
	"sheen",
	"sheenColor",
	"sheenRoughness",
	"sheen_color",
	"sheen_roughness",
	"sourceMap",
	"specular",
	"specularAnisotropy",
	"specularColor",
	"specularIOR",
	"specularRotation",
	"specularRoughness",
	"specular_IOR",
	"specular_anisotropy",
	"specular_color",
	"specular_rotation",
	"specular_roughness",
	"ss",
	"sss_color",
	"sss_depth",
	"sss_scale",
	"sss_scatter_color",
	"sub_type",
	"subsurface",
	"subsurfaceAnisotropy",
	"subsurfaceColor",
	"subsurfaceRadius",
	"subsurfaceScale",
	"subsurfaceType",
	"subsurface_anisotropy",
	"subsurface_color",
	"subsurface_radius",
	"subsurface_scale",
	"tangent",
	"temp",
	"thinFilmIOR",
	"thinFilmThickness",
	"thinWalled",
	"thin_film_IOR",
	"thin_film_thickness",
	"thin_walled",
	"total <= ator->max_size - ator->current_size",
	"trans_color",
	"trans_depth",
	"trans_ior",
	"trans_rough",
	"trans_roughness",
	"trans_roughness_inv",
	"trans_roughness_lock",
	"transmission",
	"transmissionColor",
	"transmissionDepth",
	"transmissionDispersion",
	"transmissionExtraRoughness",
	"transmissionScatter",
	"transmissionScatterAnisotropy",
	"transmission_color",
	"transmission_depth",
	"transmission_dispersion",
	"transmission_extra_roughness",
	"transmission_scatter",
	"transmission_scatter_anisotropy",
	"transmitAovs",
	"transparency",
	"type",
	"type::name",
	"ufbx panic: ",
	"ufbx panic: See stderr for more information",
	"ufbx trace: %s:%d: %s\n",
	"ufbx v%u.%u.%u error: %s\n",
	"ufbx v%u.%u.%u error: %s (%.*s)\n",
	"ufbx.h",
	"ufbx_deleter() unsupported for type",
	"ufbx_shared_ptr unsupported for type",
	"ufbx_unique_ptr unsupported for type",
	"ufbxi_obj_load_mtl()",
	"unknown",
	"useGlossiness",
	"use_",
	"usemtl",
	"user_streams[i].vertex_count < num_indices",
	"vertex",
	"vertex (%zu) out of bounds (%zu)",
	"virtual",
	"|",
	"",
};

const char *unknown_string_table[] = {
	"\t",
	"\t\t\t",
	"'&",
	", Model::",
	"../../../temporary.png",
	"..\\..\\..\\..\\directory\\inner.png",
	"..\\..\\tiny_clouds.png",
	"..\\temporary.png",
	"01/04/2020 11:38:42.024",
	"01/04/2020 12:25:19.818",
	"01/04/2020 12:36:14.746",
	"01/04/2020 13:14:08.515",
	"01/08/2021 15:13:30.098",
	"01/08/2021 15:15:28.507",
	"01/08/2021 16:56:04.959",
	"01/08/2021 16:57:08.903",
	"01/08/2021 17:09:28.151",
	"01/08/2021 17:14:28.160",
	"01/08/2021 21:00:11.853",
	"01/08/2021 21:48:37.961",
	"01/09/2021 14:13:46.406",
	"01/09/2023 11:24:00.913",
	"01/09/2023 12:42:30.972",
	"02/08/2021 16:47:30.644",
	"02/08/2021 17:28:51.295",
	"02/09/2023 20:37:09.096",
	"03/06/2023 16:48:03.196",
	"03/12/2022 18:08:28.413",
	"04/04/2020 12:48:03.848",
	"04/04/2020 12:48:47.308",
	"04/04/2020 12:51:02.948",
	"04/04/2020 12:52:11.991",
	"05/11/2022 02:04:08.527",
	"06/06/2022 09:32:49.952",
	"06/06/2022 09:58:09.208",
	"06/06/2022 12:37:58.509",
	"06/08/2021 10:38:29.266",
	"06/08/2021 12:52:24.108",
	"06/08/2021 16:18:26.630",
	"06/10/2023 12:27:21.618",
	"06/10/2023 12:27:32.590",
	"06/10/2023 17:11:25.191",
	"06/10/2023 20:20:42.168",
	"07/04/2020 17:38:23.511",
	"07/04/2020 17:40:49.650",
	"07/04/2020 17:50:51.650",
	"07/04/2020 18:05:24.759",
	"07/06/2022 11:12:02.614",
	"07/06/2022 11:12:28.250",
	"07/06/2022 12:04:18.926",
	"07/06/2022 12:04:58.259",
	"07/06/2022 12:32:13.222",
	"07/06/2022 20:17:45.517",
	"07/12/2022 16:33:36.818",
	"07/12/2022 16:34:18.390",
	"08/04/2020 17:00:01.191",
	"08/04/2020 17:00:44.620",
	"08/04/2020 17:04:24.873",
	"08/04/2020 17:05:24.300",
	"08/08/2021 12:11:42.964",
	"08/08/2021 13:06:10.393",
	"08/08/2021 13:26:59.176",
	"08/11/2023 01:58:56.182",
	"08/12/2022 00:36:28.225",
	"08/12/2022 00:37:33.283",
	"08/12/2022 03:01:56.394",
	"08/12/2022 03:02:08.904",
	"08/12/2022 20:11:21.630",
	"08/12/2022 20:13:17.687",
	"08/12/2022 22:18:24.374",
	"08/12/2022 23:13:13.153",
	"09/06/2022 12:25:29.652",
	"09/06/2022 13:06:51.123",
	"09/06/2022 13:32:22.987",
	"1.0.1",
	"10/02/2022 16:56:44.208",
	"10/02/2022 17:30:55.870",
	"10/08/2021 19:04:58.706",
	"10/08/2021 20:11:10.667",
	"10/09/2021 16:49:40.647",
	"10/09/2021 17:50:50.384",
	"10/09/2021 20:17:45.613",
	"10/09/2021 20:19:29.103",
	"10/09/2021 20:35:48.687",
	"10/09/2021 20:59:48.096",
	"10/09/2021 21:44:50.332",
	"10/09/2021 21:46:07.941",
	"10/09/2021 22:10:48.991",
	"10/09/2021 22:13:31.312",
	"10/12/2022 18:27:44.570",
	"11/05/2022 14:59:06.228",
	"11/05/2022 15:01:34.443",
	"11/05/2022 15:04:58.867",
	"11/05/2022 15:05:51.238",
	"11/05/2022 15:23:07.656",
	"11/06/2022 13:47:41.672",
	"11/06/2022 14:18:58.949",
	"11/06/2022 16:38:24.072",
	"11/09/2021 10:26:04.173",
	"11/09/2021 20:48:15.910",
	"11/09/2021 22:33:31.086",
	"11/09/2021 22:34:42.619",
	"12/08/2021 18:53:09.064",
	"12/09/2021 14:46:20.777",
	"13/06/2022 12:06:47.821",
	"13/06/2022 12:15:53.959",
	"13/06/2022 16:43:25.259",
	"13/06/2022 16:57:20.634",
	"13/06/2022 17:03:56.749",
	"13/08/2021 14:06:14.311",
	"13/08/2021 15:51:53.112",
	"13/08/2021 15:53:17.361",
	"14/01/2023 23:29:43.335",
	"14/01/2023 23:30:08.940",
	"15/07/2021 09:08:58.196",
	"15/07/2021 09:09:49.062",
	"15/08/2021 19:58:42.337",
	"16/02/2023 17:29:15.548",
	"16/02/2023 17:34:43.987",
	"16/05/2022 19:41:02.688",
	"16/05/2022 19:42:17.186",
	"16/05/2022 21:57:07.815",
	"16/05/2022 23:43:58.794",
	"16/08/2021 15:47:36.249",
	"17/06/2022 12:25:00.604",
	"17/06/2022 12:38:54.889",
	"17/06/2022 18:24:01.028",
	"17/07/2021 16:42:58.670",
	"17/09/2023 18:10:17.698",
	"17/09/2023 18:40:05.388",
	"17/09/2023 19:06:32.306",
	"17/09/2023 19:24:52.138",
	"18/04/2022 11:19:48.926",
	"18/04/2022 11:22:41.874",
	"18/06/2022 17:56:07.398",
	"18/12/2022 14:22:40.935",
	"18/12/2022 14:40:25.556",
	"18/12/2022 20:38:02.739",
	"18/12/2022 21:28:16.130",
	"19/01/2023 16:26:28.285",
	"19/01/2023 16:36:20.363",
	"19/09/2023 17:25:03.779",
	"19/11/2022 22:23:01.933",
	"19/11/2022 22:23:26.471",
	"19/11/2022 22:32:38.063",
	"19/11/2022 22:34:04.191",
	"19/11/2022 22:39:10.685",
	"19/11/2022 22:39:23.613",
	"20/08/2021 15:09:34.044",
	"20/08/2021 15:17:38.829",
	"20/09/2021 19:20:56.695",
	"20/09/2021 19:31:57.619",
	"2009.0",
	"201900",
	"2020",
	"2020-01-19 15:41:02:000",
	"2020-03-31 20:42:49:000",
	"2020-03-31 20:51:20:000",
	"2020-04-01 16:34:23:000",
	"2020-04-04 14:55:53:000",
	"2020-09-13 13:58:54:000",
	"2020-09-13 14:16:18:000",
	"202000",
	"202001",
	"202004",
	"2021-08-23 22:21:17:000",
	"2021-08-29 11:37:14:227",
	"2021-08-29 13:52:37:132",
	"2022",
	"2022-05-11 18:03:16:000",
	"2022-11-29 19:28:13:000",
	"2023",
	"2023-09-01 14:23:15:117",
	"2023-09-01 14:24:00:913",
	"2023-09-01 15:41:53:983",
	"2023-09-01 15:42:30:972",
	"21/01/2022 21:30:01.947",
	"21/03/2020 21:54:26.428",
	"21/03/2020 22:00:25.546",
	"21/03/2020 22:27:54.500",
	"21/06/2022 14:21:11.392",
	"21/06/2022 18:33:56.170",
	"21/06/2022 19:08:46.329",
	"21/06/2022 19:09:16.610",
	"21/06/2022 19:26:38.737",
	"21/06/2022 19:30:36.626",
	"21/06/2022 19:31:14.568",
	"21/06/2022 19:31:56.366",
	"21/09/2023 20:37:31.326",
	"22/01/2022 18:53:56.678",
	"22/01/2022 20:36:52.487",
	"22/01/2022 20:38:41.388",
	"22/01/2022 21:22:18.008",
	"22/01/2022 21:34:33.474",
	"22/01/2022 21:51:16.554",
	"22/01/2022 22:11:08.537",
	"22/01/2022 23:28:02.086",
	"22/01/2022 23:40:11.765",
	"22/03/2020 11:19:53.759",
	"22/03/2020 11:20:20.452",
	"22/05/2022 12:17:00.120",
	"22/05/2022 12:17:56.577",
	"22/08/2021 01:04:33.295",
	"22/08/2021 01:05:26.501",
	"22/09/2023 20:22:25.622",
	"23/01/2022 02:32:19.964",
	"23/08/2021 19:03:32.223",
	"23/08/2021 19:03:42.110",
	"23/08/2021 19:54:12.814",
	"24",
	"24/03/2020 18:19:03.584",
	"24/03/2020 18:24:40.950",
	"25/09/2021 19:46:47.505",
	"25/09/2021 19:50:59.071",
	"25/12/2022 17:52:59.454",
	"25/12/2022 18:03:44.209",
	"25/12/2022 18:32:16.957",
	"26/03/2020 11:36:12.530",
	"26/03/2020 11:36:45.786",
	"26/05/2022 12:33:29.130",
	"26/06/2022 15:52:42.100",
	"26/09/2023 14:08:44.157",
	"27/03/2020 20:15:02.887",
	"27/03/2020 20:17:20.197",
	"27/07/2021 15:39:37.968",
	"27/09/2023 11:32:50.477",
	"28",
	"28/07/2021 18:55:10.386",
	"28/08/2021 19:51:31.976",
	"28/08/2021 19:52:35.930",
	"28/08/2021 19:53:28.367",
	"28/08/2021 19:54:16.225",
	"28/09/2023 23:36:59.070",
	"29/05/2023 11:10:36.456",
	"29/05/2023 11:23:00.184",
	"29/05/2023 12:04:09.995",
	"29/05/2023 14:01:41.309",
	"29/07/2021 19:11:31.362",
	"29/07/2021 20:00:06.390",
	"29/07/2021 20:06:06.796",
	"29/08/2021 20:52:37.132",
	"2D Magnifier X",
	"2D Magnifier Y",
	"2D Magnifier Zoom",
	"30",
	"31/03/2020 11:36:29.421",
	"31/03/2020 11:37:31.839",
	"31/03/2020 16:10:50.258",
	"31/03/2020 16:11:13.072",
	"31/03/2020 18:33:51.517",
	"31/03/2020 18:34:52.325",
	"31/03/2020 18:36:10.811",
	"31/03/2020 18:36:34.162",
	"31/03/2020 19:40:26.668",
	"31/03/2020 19:55:56.349",
	"31/03/2022 19:28:24.920",
	"31/03/2022 19:43:16.146",
	"31/07/2020 14:51:02.622",
	"31/07/2021 20:13:49.138",
	"31/07/2021 20:14:34.978",
	"3ds Max",
	"3dsMax",
	"3dsMax|Checker",
	"3dsMax|Checker|Color1",
	"3dsMax|Checker|Color1_map",
	"3dsMax|Checker|Color2",
	"3dsMax|Checker|Color2_map",
	"3dsMax|Checker|Scale",
	"3dsMax|Checker|Scale_map",
	"3dsMax|Checker|UVW_map",
	"3dsMax|ColorAdd",
	"3dsMax|ColorAdd|A",
	"3dsMax|ColorAdd|A_Amount",
	"3dsMax|ColorAdd|A_Amount_map",
	"3dsMax|ColorAdd|A_map",
	"3dsMax|ColorAdd|B",
	"3dsMax|ColorAdd|B_Amount",
	"3dsMax|ColorAdd|B_Amount_map",
	"3dsMax|ColorAdd|B_map",
	"3dsMax|ColorAdd|Clamp",
	"3dsMax|ColorAdd|Clamp_map",
	"3dsMax|ColorMax",
	"3dsMax|ColorMax|A",
	"3dsMax|ColorMax|A_map",
	"3dsMax|ColorMax|B",
	"3dsMax|ColorMax|B_map",
	"3dsMax|ColorMul",
	"3dsMax|ColorMul|A",
	"3dsMax|ColorMul|A_map",
	"3dsMax|ColorMul|B",
	"3dsMax|ColorMul|B_map",
	"3dsMax|ColorMul|Clamp",
	"3dsMax|ColorMul|Clamp_map",
	"3dsMax|ColorTweak",
	"3dsMax|ColorTweak|Clamp",
	"3dsMax|ColorTweak|Clamp_map",
	"3dsMax|ColorTweak|HSV",
	"3dsMax|ColorTweak|HSV_map",
	"3dsMax|ColorTweak|Input",
	"3dsMax|ColorTweak|InputMax",
	"3dsMax|ColorTweak|InputMax_map",
	"3dsMax|ColorTweak|InputMin",
	"3dsMax|ColorTweak|InputMin_map",
	"3dsMax|ColorTweak|Input_map",
	"3dsMax|ColorTweak|MidTones",
	"3dsMax|ColorTweak|MidTones_map",
	"3dsMax|ColorTweak|OutputMax",
	"3dsMax|ColorTweak|OutputMax_map",
	"3dsMax|ColorTweak|OutputMin",
	"3dsMax|ColorTweak|OutputMin_map",
	"3dsMax|ORIGINAL_MTL",
	"3dsMax|OSLBitmap2",
	"3dsMax|OSLBitmap2|AutoGamma",
	"3dsMax|OSLBitmap2|Filename",
	"3dsMax|OSLBitmap2|Filename_UDIMList",
	"3dsMax|OSLBitmap2|Filename_UDIMList_map",
	"3dsMax|OSLBitmap2|Filename_map",
	"3dsMax|OSLBitmap2|LoadUDIM",
	"3dsMax|OSLBitmap2|ManualGamma",
	"3dsMax|OSLBitmap2|ManualGamma_map",
	"3dsMax|OSLBitmap2|Pos_map",
	"3dsMax|OSLBitmap2|Scale",
	"3dsMax|OSLBitmap2|Scale_map",
	"3dsMax|OSLBitmap2|UDIM",
	"3dsMax|OSLBitmap2|WrapMode",
	"3dsMax|OSLBitmap2|WrapMode_map",
	"3dsMax|ParamBlock_0|Aspect Ratio",
	"3dsMax|ParamBlock_0|Atmosphere Color Amount",
	"3dsMax|ParamBlock_0|Atmosphere Opacity",
	"3dsMax|ParamBlock_0|Attenuation Far End",
	"3dsMax|ParamBlock_0|Attenuation Far Start",
	"3dsMax|ParamBlock_0|Attenuation Near End",
	"3dsMax|ParamBlock_0|Attenuation Near Start",
	"3dsMax|ParamBlock_0|Color",
	"3dsMax|ParamBlock_0|Contrast",
	"3dsMax|ParamBlock_0|Decay Falloff",
	"3dsMax|ParamBlock_0|Diffuse Soften",
	"3dsMax|ParamBlock_0|Falloff",
	"3dsMax|ParamBlock_0|Hotspot",
	"3dsMax|ParamBlock_0|Multiplier",
	"3dsMax|ParamBlock_0|Shadow Color",
	"3dsMax|ParamBlock_0|Shadow Density",
	"3dsMax|ParamBlock_0|Target Distance",
	"3dsMax|ParamBlock_0|_Unnamed_Parameter_10",
	"3dsMax|ParamBlock_0|_Unnamed_Parameter_13",
	"3dsMax|ParamBlock_0|_Unnamed_Parameter_14",
	"3dsMax|ParamBlock_0|_Unnamed_Parameter_17",
	"3dsMax|Parameters",
	"3dsMax|Parameters|aniso_angle_map",
	"3dsMax|Parameters|aniso_angle_map_on",
	"3dsMax|Parameters|aniso_channel",
	"3dsMax|Parameters|aniso_mode",
	"3dsMax|Parameters|anisoangle",
	"3dsMax|Parameters|anisotropy",
	"3dsMax|Parameters|anisotropy_map",
	"3dsMax|Parameters|anisotropy_map_on",
	"3dsMax|Parameters|base_color_map",
	"3dsMax|Parameters|base_color_map_on",
	"3dsMax|Parameters|base_weight",
	"3dsMax|Parameters|base_weight_map",
	"3dsMax|Parameters|base_weight_map_on",
	"3dsMax|Parameters|brdf_curve",
	"3dsMax|Parameters|brdf_high",
	"3dsMax|Parameters|brdf_low",
	"3dsMax|Parameters|brdf_mode",
	"3dsMax|Parameters|bump_map",
	"3dsMax|Parameters|bump_map_amt",
	"3dsMax|Parameters|bump_map_on",
	"3dsMax|Parameters|clearcoat_bump_map_amt",
	"3dsMax|Parameters|coat_affect_color",
	"3dsMax|Parameters|coat_affect_roughness",
	"3dsMax|Parameters|coat_aniso_angle_map",
	"3dsMax|Parameters|coat_aniso_angle_map_on",
	"3dsMax|Parameters|coat_aniso_map",
	"3dsMax|Parameters|coat_aniso_map_on",
	"3dsMax|Parameters|coat_anisoangle",
	"3dsMax|Parameters|coat_anisotropy",
	"3dsMax|Parameters|coat_bump_map",
	"3dsMax|Parameters|coat_bump_map_on",
	"3dsMax|Parameters|coat_color",
	"3dsMax|Parameters|coat_color_map",
	"3dsMax|Parameters|coat_color_map_on",
	"3dsMax|Parameters|coat_ior",
	"3dsMax|Parameters|coat_map",
	"3dsMax|Parameters|coat_map_on",
	"3dsMax|Parameters|coat_rough_map",
	"3dsMax|Parameters|coat_rough_map_on",
	"3dsMax|Parameters|coat_roughness",
	"3dsMax|Parameters|coat_roughness_inv",
	"3dsMax|Parameters|coating",
	"3dsMax|Parameters|cutout_map",
	"3dsMax|Parameters|cutout_map_on",
	"3dsMax|Parameters|diff_rough_map",
	"3dsMax|Parameters|diff_rough_map_on",
	"3dsMax|Parameters|diff_roughness",
	"3dsMax|Parameters|dispersion",
	"3dsMax|Parameters|displacement_map",
	"3dsMax|Parameters|displacement_map_amt",
	"3dsMax|Parameters|displacement_map_on",
	"3dsMax|Parameters|emission",
	"3dsMax|Parameters|emission_map",
	"3dsMax|Parameters|emission_map_on",
	"3dsMax|Parameters|emit_color",
	"3dsMax|Parameters|emit_color_map",
	"3dsMax|Parameters|emit_color_map_on",
	"3dsMax|Parameters|emit_kelvin",
	"3dsMax|Parameters|emit_luminance",
	"3dsMax|Parameters|mapM0",
	"3dsMax|Parameters|mapM1",
	"3dsMax|Parameters|mapM10",
	"3dsMax|Parameters|mapM11",
	"3dsMax|Parameters|mapM12",
	"3dsMax|Parameters|mapM13",
	"3dsMax|Parameters|mapM14",
	"3dsMax|Parameters|mapM15",
	"3dsMax|Parameters|mapM16",
	"3dsMax|Parameters|mapM17",
	"3dsMax|Parameters|mapM18",
	"3dsMax|Parameters|mapM19",
	"3dsMax|Parameters|mapM2",
	"3dsMax|Parameters|mapM20",
	"3dsMax|Parameters|mapM3",
	"3dsMax|Parameters|mapM4",
	"3dsMax|Parameters|mapM5",
	"3dsMax|Parameters|mapM6",
	"3dsMax|Parameters|mapM7",
	"3dsMax|Parameters|mapM8",
	"3dsMax|Parameters|mapM9",
	"3dsMax|Parameters|material_mode",
	"3dsMax|Parameters|metalness",
	"3dsMax|Parameters|metalness_map",
	"3dsMax|Parameters|metalness_map_on",
	"3dsMax|Parameters|normalCamera",
	"3dsMax|Parameters|normalCameraFactor",
	"3dsMax|Parameters|normalCameraUsedAs",
	"3dsMax|Parameters|refl_color",
	"3dsMax|Parameters|refl_color_map",
	"3dsMax|Parameters|refl_color_map_on",
	"3dsMax|Parameters|reflectivity",
	"3dsMax|Parameters|reflectivity_map",
	"3dsMax|Parameters|reflectivity_map_on",
	"3dsMax|Parameters|roughness",
	"3dsMax|Parameters|roughness_inv",
	"3dsMax|Parameters|roughness_map",
	"3dsMax|Parameters|roughness_map_on",
	"3dsMax|Parameters|scattering",
	"3dsMax|Parameters|scattering_map",
	"3dsMax|Parameters|scattering_map_on",
	"3dsMax|Parameters|sheen",
	"3dsMax|Parameters|sheen_color",
	"3dsMax|Parameters|sheen_color_map",
	"3dsMax|Parameters|sheen_color_map_on",
	"3dsMax|Parameters|sheen_map",
	"3dsMax|Parameters|sheen_map_on",
	"3dsMax|Parameters|sheen_rough_map",
	"3dsMax|Parameters|sheen_rough_map_on",
	"3dsMax|Parameters|sheen_roughness",
	"3dsMax|Parameters|sss_color",
	"3dsMax|Parameters|sss_color_map",
	"3dsMax|Parameters|sss_color_map_on",
	"3dsMax|Parameters|sss_depth",
	"3dsMax|Parameters|sss_scale",
	"3dsMax|Parameters|sss_scale_map",
	"3dsMax|Parameters|sss_scale_map_on",
	"3dsMax|Parameters|sss_scatter_color",
	"3dsMax|Parameters|thin_film",
	"3dsMax|Parameters|thin_film_ior",
	"3dsMax|Parameters|thin_film_ior_map",
	"3dsMax|Parameters|thin_film_ior_map_on",
	"3dsMax|Parameters|thin_film_map",
	"3dsMax|Parameters|thin_film_map_on",
	"3dsMax|Parameters|thin_film_thickness",
	"3dsMax|Parameters|thin_walled",
	"3dsMax|Parameters|trans_color",
	"3dsMax|Parameters|trans_color_map",
	"3dsMax|Parameters|trans_color_map_on",
	"3dsMax|Parameters|trans_depth",
	"3dsMax|Parameters|trans_ior",
	"3dsMax|Parameters|trans_ior_map",
	"3dsMax|Parameters|trans_ior_map_on",
	"3dsMax|Parameters|trans_rough_map",
	"3dsMax|Parameters|trans_rough_map_on",
	"3dsMax|Parameters|trans_roughness",
	"3dsMax|Parameters|trans_roughness_inv",
	"3dsMax|Parameters|trans_roughness_lock",
	"3dsMax|Parameters|trans_scatter_aniso",
	"3dsMax|Parameters|trans_scatter_color",
	"3dsMax|Parameters|transparency",
	"3dsMax|Parameters|transparency_map",
	"3dsMax|Parameters|transparency_map_on",
	"3dsMax|RandomTilingBitmap",
	"3dsMax|RandomTilingBitmap|AutoGamma",
	"3dsMax|RandomTilingBitmap|EdgeFuzz",
	"3dsMax|RandomTilingBitmap|EdgeFuzz_map",
	"3dsMax|RandomTilingBitmap|Filename",
	"3dsMax|RandomTilingBitmap|Filename_UDIMList",
	"3dsMax|RandomTilingBitmap|Filename_map",
	"3dsMax|RandomTilingBitmap|HSVMax",
	"3dsMax|RandomTilingBitmap|HSVMax_map",
	"3dsMax|RandomTilingBitmap|HSVMin",
	"3dsMax|RandomTilingBitmap|HSVMin_map",
	"3dsMax|RandomTilingBitmap|LoadUDIM",
	"3dsMax|RandomTilingBitmap|ManualGamma",
	"3dsMax|RandomTilingBitmap|ManualGamma_map",
	"3dsMax|RandomTilingBitmap|NormalFlipG",
	"3dsMax|RandomTilingBitmap|NormalFlipR",
	"3dsMax|RandomTilingBitmap|NormalMap",
	"3dsMax|RandomTilingBitmap|Pos_map",
	"3dsMax|RandomTilingBitmap|RandScale",
	"3dsMax|RandomTilingBitmap|RandScale_map",
	"3dsMax|RandomTilingBitmap|Randomize",
	"3dsMax|RandomTilingBitmap|RandomizePos",
	"3dsMax|RandomTilingBitmap|RotMax",
	"3dsMax|RandomTilingBitmap|RotMax_map",
	"3dsMax|RandomTilingBitmap|RotMin",
	"3dsMax|RandomTilingBitmap|RotMin_map",
	"3dsMax|RandomTilingBitmap|Scale",
	"3dsMax|RandomTilingBitmap|ScaleMax",
	"3dsMax|RandomTilingBitmap|ScaleMax_map",
	"3dsMax|RandomTilingBitmap|ScaleMin",
	"3dsMax|RandomTilingBitmap|ScaleMin_map",
	"3dsMax|RandomTilingBitmap|Scale_map",
	"3dsMax|RandomTilingBitmap|Seed",
	"3dsMax|RandomTilingBitmap|Seed_map",
	"3dsMax|RandomTilingBitmap|UDIM",
	"3dsMax|RandomTilingBitmap|UOffset",
	"3dsMax|RandomTilingBitmap|UOffset_map",
	"3dsMax|RandomTilingBitmap|VOffset",
	"3dsMax|RandomTilingBitmap|VOffset_map",
	"3dsMax|RandomTilingBitmap|WiggleAmount",
	"3dsMax|RandomTilingBitmap|WiggleAmount_map",
	"3dsMax|RandomTilingBitmap|WiggleScale",
	"3dsMax|RandomTilingBitmap|WiggleScale_map",
	"3dsMax|RandomTilingBitmap|WrapMode",
	"3dsMax|RandomTilingBitmap|WrapMode_map",
	"3dsMax|SuperClassID",
	"3dsMax|TriTone",
	"3dsMax|TriTone|Highlights",
	"3dsMax|TriTone|Highlights_map",
	"3dsMax|TriTone|Input_map",
	"3dsMax|TriTone|MidtoneLum",
	"3dsMax|TriTone|MidtoneLum_map",
	"3dsMax|TriTone|Midtones",
	"3dsMax|TriTone|Midtones_map",
	"3dsMax|TriTone|Shadows",
	"3dsMax|TriTone|Shadows_map",
	"3dsMax|UberBitmap2",
	"3dsMax|UberBitmap2|AutoGamma",
	"3dsMax|UberBitmap2|Filename",
	"3dsMax|UberBitmap2|Filename_UDIMList",
	"3dsMax|UberBitmap2|Filename_UDIMList_map",
	"3dsMax|UberBitmap2|Filename_map",
	"3dsMax|UberBitmap2|LoadUDIM",
	"3dsMax|UberBitmap2|ManualGamma",
	"3dsMax|UberBitmap2|ManualGamma_map",
	"3dsMax|UberBitmap2|Offset",
	"3dsMax|UberBitmap2|Offset_map",
	"3dsMax|UberBitmap2|RealHeight",
	"3dsMax|UberBitmap2|RealHeight_map",
	"3dsMax|UberBitmap2|RealWidth",
	"3dsMax|UberBitmap2|RealWidth_map",
	"3dsMax|UberBitmap2|RealWorld",
	"3dsMax|UberBitmap2|RotAxis",
	"3dsMax|UberBitmap2|RotAxis_map",
	"3dsMax|UberBitmap2|RotCenter",
	"3dsMax|UberBitmap2|RotCenter_map",
	"3dsMax|UberBitmap2|Rotate",
	"3dsMax|UberBitmap2|Rotate_map",
	"3dsMax|UberBitmap2|Scale",
	"3dsMax|UberBitmap2|Scale_map",
	"3dsMax|UberBitmap2|Tiling",
	"3dsMax|UberBitmap2|Tiling_map",
	"3dsMax|UberBitmap2|UDIM",
	"3dsMax|UberBitmap2|UVSet",
	"3dsMax|UberBitmap2|UVSet_map",
	"3dsMax|UberBitmap2|WrapMode",
	"3dsMax|UberBitmap2|WrapMode_map",
	"3dsMax|VectorAdd",
	"3dsMax|VectorAdd|A",
	"3dsMax|VectorAdd|A_Amount",
	"3dsMax|VectorAdd|A_Amount_map",
	"3dsMax|VectorAdd|A_map",
	"3dsMax|VectorAdd|B",
	"3dsMax|VectorAdd|B_Amount",
	"3dsMax|VectorAdd|B_Amount_map",
	"3dsMax|VectorAdd|B_map",
	"3dsMax|ai_add Parameter Wrapper",
	"3dsMax|ai_add Parameter Wrapper|Shader Version",
	"3dsMax|ai_add Parameter Wrapper|TheList",
	"3dsMax|ai_add Parameters/Connections",
	"3dsMax|ai_add Parameters/Connections|input1",
	"3dsMax|ai_add Parameters/Connections|input1.connected",
	"3dsMax|ai_add Parameters/Connections|input1.shader",
	"3dsMax|ai_add Parameters/Connections|input2",
	"3dsMax|ai_add Parameters/Connections|input2.connected",
	"3dsMax|ai_add Parameters/Connections|input2.shader",
	"3dsMax|ai_add Results",
	"3dsMax|ai_bump2d Parameter Wrapper",
	"3dsMax|ai_bump2d Parameter Wrapper|Shader Version",
	"3dsMax|ai_bump2d Parameter Wrapper|TheList",
	"3dsMax|ai_bump2d Parameters/Connections",
	"3dsMax|ai_bump2d Parameters/Connections|bump_height",
	"3dsMax|ai_bump2d Parameters/Connections|bump_height.connected",
	"3dsMax|ai_bump2d Parameters/Connections|bump_height.shader",
	"3dsMax|ai_bump2d Parameters/Connections|bump_map",
	"3dsMax|ai_bump2d Parameters/Connections|bump_map.connected",
	"3dsMax|ai_bump2d Parameters/Connections|bump_map.shader",
	"3dsMax|ai_bump2d Parameters/Connections|normal",
	"3dsMax|ai_bump2d Parameters/Connections|normal.connected",
	"3dsMax|ai_bump2d Parameters/Connections|normal.shader",
	"3dsMax|ai_bump2d Results",
	"3dsMax|ai_checkerboard Parameter Wrapper",
	"3dsMax|ai_checkerboard Parameter Wrapper|Shader Version",
	"3dsMax|ai_checkerboard Parameter Wrapper|TheList",
	"3dsMax|ai_checkerboard Parameters/Connections",
	"3dsMax|ai_checkerboard Parameters/Connections|color1",
	"3dsMax|ai_checkerboard Parameters/Connections|color1.connected",
	"3dsMax|ai_checkerboard Parameters/Connections|color1.shader",
	"3dsMax|ai_checkerboard Parameters/Connections|color2",
	"3dsMax|ai_checkerboard Parameters/Connections|color2.connected",
	"3dsMax|ai_checkerboard Parameters/Connections|color2.shader",
	"3dsMax|ai_checkerboard Parameters/Connections|contrast",
	"3dsMax|ai_checkerboard Parameters/Connections|contrast.connected",
	"3dsMax|ai_checkerboard Parameters/Connections|contrast.shader",
	"3dsMax|ai_checkerboard Parameters/Connections|filter_offset",
	"3dsMax|ai_checkerboard Parameters/Connections|filter_strength",
	"3dsMax|ai_checkerboard Parameters/Connections|u_frequency",
	"3dsMax|ai_checkerboard Parameters/Connections|u_frequency.shader",
	"3dsMax|ai_checkerboard Parameters/Connections|u_offset",
	"3dsMax|ai_checkerboard Parameters/Connections|u_offset.connected",
	"3dsMax|ai_checkerboard Parameters/Connections|u_offset.shader",
	"3dsMax|ai_checkerboard Parameters/Connections|uvset",
	"3dsMax|ai_checkerboard Parameters/Connections|v_frequency",
	"3dsMax|ai_checkerboard Parameters/Connections|v_frequency.shader",
	"3dsMax|ai_checkerboard Parameters/Connections|v_offset",
	"3dsMax|ai_checkerboard Parameters/Connections|v_offset.connected",
	"3dsMax|ai_checkerboard Parameters/Connections|v_offset.shader",
	"3dsMax|ai_checkerboard Results",
	"3dsMax|ai_dot Parameter Wrapper",
	"3dsMax|ai_dot Parameter Wrapper|Shader Version",
	"3dsMax|ai_dot Parameter Wrapper|TheList",
	"3dsMax|ai_dot Parameters/Connections",
	"3dsMax|ai_dot Parameters/Connections|input1",
	"3dsMax|ai_dot Parameters/Connections|input1.connected",
	"3dsMax|ai_dot Parameters/Connections|input1.shader",
	"3dsMax|ai_dot Parameters/Connections|input2",
	"3dsMax|ai_dot Parameters/Connections|input2.connected",
	"3dsMax|ai_dot Parameters/Connections|input2.shader",
	"3dsMax|ai_dot Results",
	"3dsMax|ai_image Parameter Wrapper",
	"3dsMax|ai_image Parameter Wrapper|Shader Version",
	"3dsMax|ai_image Parameter Wrapper|TheList",
	"3dsMax|ai_image Parameters/Connections",
	"3dsMax|ai_image Parameters/Connections|Image Frame Number",
	"3dsMax|ai_image Parameters/Connections|color_space",
	"3dsMax|ai_image Parameters/Connections|filename",
	"3dsMax|ai_image Parameters/Connections|filter",
	"3dsMax|ai_image Parameters/Connections|ignore_missing_textures",
	"3dsMax|ai_image Parameters/Connections|mipmap_bias",
	"3dsMax|ai_image Parameters/Connections|missing_texture_color",
	"3dsMax|ai_image Parameters/Connections|multiply",
	"3dsMax|ai_image Parameters/Connections|multiply.connected",
	"3dsMax|ai_image Parameters/Connections|multiply.shader",
	"3dsMax|ai_image Parameters/Connections|offset",
	"3dsMax|ai_image Parameters/Connections|offset.connected",
	"3dsMax|ai_image Parameters/Connections|offset.shader",
	"3dsMax|ai_image Parameters/Connections|sflip",
	"3dsMax|ai_image Parameters/Connections|single_channel",
	"3dsMax|ai_image Parameters/Connections|soffset",
	"3dsMax|ai_image Parameters/Connections|sscale",
	"3dsMax|ai_image Parameters/Connections|start_channel",
	"3dsMax|ai_image Parameters/Connections|swap_st",
	"3dsMax|ai_image Parameters/Connections|swrap",
	"3dsMax|ai_image Parameters/Connections|tflip",
	"3dsMax|ai_image Parameters/Connections|toffset",
	"3dsMax|ai_image Parameters/Connections|tscale",
	"3dsMax|ai_image Parameters/Connections|twrap",
	"3dsMax|ai_image Parameters/Connections|uvcoords.connected",
	"3dsMax|ai_image Parameters/Connections|uvcoords.shader",
	"3dsMax|ai_image Parameters/Connections|uvset",
	"3dsMax|ai_image Results",
	"3dsMax|ai_mix_rgba Parameter Wrapper",
	"3dsMax|ai_mix_rgba Parameter Wrapper|Shader Version",
	"3dsMax|ai_mix_rgba Parameter Wrapper|TheList",
	"3dsMax|ai_mix_rgba Parameters/Connections",
	"3dsMax|ai_mix_rgba Parameters/Connections|input1",
	"3dsMax|ai_mix_rgba Parameters/Connections|input1.connected",
	"3dsMax|ai_mix_rgba Parameters/Connections|input1.shader",
	"3dsMax|ai_mix_rgba Parameters/Connections|input2",
	"3dsMax|ai_mix_rgba Parameters/Connections|input2.connected",
	"3dsMax|ai_mix_rgba Parameters/Connections|input2.shader",
	"3dsMax|ai_mix_rgba Parameters/Connections|mix",
	"3dsMax|ai_mix_rgba Parameters/Connections|mix.connected",
	"3dsMax|ai_mix_rgba Parameters/Connections|mix.shader",
	"3dsMax|ai_mix_rgba Results",
	"3dsMax|extension",
	"3dsMax|extension|Specular",
	"3dsMax|extension|clearcoat",
	"3dsMax|extension|clearcoatMap",
	"3dsMax|extension|clearcoatNormal",
	"3dsMax|extension|clearcoatNormalMap",
	"3dsMax|extension|clearcoatRoughness",
	"3dsMax|extension|clearcoatRoughnessMap",
	"3dsMax|extension|enableClearCoat",
	"3dsMax|extension|enableIndexOfRefraction",
	"3dsMax|extension|enableSheen",
	"3dsMax|extension|enableSpecular",
	"3dsMax|extension|enableTransmission",
	"3dsMax|extension|enableVolume",
	"3dsMax|extension|indexOfRefraction",
	"3dsMax|extension|sheenColor",
	"3dsMax|extension|sheenColorMap",
	"3dsMax|extension|sheenRoughness",
	"3dsMax|extension|sheenRoughnessMap",
	"3dsMax|extension|specularColorMap",
	"3dsMax|extension|specularMap",
	"3dsMax|extension|specularcolor",
	"3dsMax|extension|transmission",
	"3dsMax|extension|transmissionMap",
	"3dsMax|extension|unlit",
	"3dsMax|extension|volumeColor",
	"3dsMax|extension|volumeDistance",
	"3dsMax|extension|volumeThickness",
	"3dsMax|extension|volumeThicknessMap",
	"3dsMax|main",
	"3dsMax|main|AlphaMap",
	"3dsMax|main|DoubleSided",
	"3dsMax|main|Roughness_Map",
	"3dsMax|main|Specular",
	"3dsMax|main|alphaCutoff",
	"3dsMax|main|alphaMode",
	"3dsMax|main|ambientOcclusion",
	"3dsMax|main|ambientOcclusionMap",
	"3dsMax|main|ao_map",
	"3dsMax|main|baseColor",
	"3dsMax|main|baseColorMap",
	"3dsMax|main|base_color_map",
	"3dsMax|main|bump_map_amt",
	"3dsMax|main|displacement_amt",
	"3dsMax|main|displacement_map",
	"3dsMax|main|emissionColor",
	"3dsMax|main|emissionMap",
	"3dsMax|main|emit_color",
	"3dsMax|main|emit_color_map",
	"3dsMax|main|glossiness",
	"3dsMax|main|glossiness_map",
	"3dsMax|main|metalness",
	"3dsMax|main|metalnessMap",
	"3dsMax|main|metalness_map",
	"3dsMax|main|norm_map",
	"3dsMax|main|normal",
	"3dsMax|main|normalMap",
	"3dsMax|main|opacity_map",
	"3dsMax|main|roughness",
	"3dsMax|main|roughnessMap",
	"3dsMax|main|specular_map",
	"3dsMax|main|useGlossiness",
	"3dsMax|parameters|color1",
	"3dsMax|parameters|color2",
	"3dsMax|parameters|lower",
	"3dsMax|parameters|map1",
	"3dsMax|parameters|map1Enabled",
	"3dsMax|parameters|map2",
	"3dsMax|parameters|map2Enabled",
	"3dsMax|parameters|mask",
	"3dsMax|parameters|maskEnabled",
	"3dsMax|parameters|mixAmount",
	"3dsMax|parameters|output",
	"3dsMax|parameters|outputChannelIndex",
	"3dsMax|parameters|sourceMap",
	"3dsMax|parameters|upper",
	"3dsMax|parameters|useCurve",
	"3dsMax|params",
	"3dsMax|params|OSLAutoUpdate",
	"3dsMax|params|OSLPath",
	"3dsMax|params|OSLPresetName",
	"3dsMax|settings",
	"3dsMax|settings|ao_affects_diffuse",
	"3dsMax|settings|ao_affects_reflection",
	"3dsMax|settings|normal_flip_green",
	"3dsMax|settings|normal_flip_red",
	"4.2",
	"A+L1M4",
	"A+L2M2",
	"A+L4M1",
	"A+L7",
	"A+L7M7",
	"A+M7",
	"A+N",
	"A+U",
	"AAAJKop",
	"AL7",
	"AN",
	"APGAmLj",
	"AccessMode",
	"Action",
	"ActiveAnimStackName",
	"ActiveControl",
	"Actor",
	"Add",
	"AffectRotationX",
	"AffectRotationY",
	"AffectRotationZ",
	"AffectScalingX",
	"AffectScalingY",
	"AffectScalingZ",
	"AffectTranslationX",
	"AffectTranslationY",
	"AffectTranslationZ",
	"AffectX",
	"AffectY",
	"AffectZ",
	"AiOSL",
	"Aim.Weight",
	"Alpha",
	"Alpha_Black",
	"AlsoKeyOnFOVProperty",
	"Ambient Color",
	"Anchors",
	"AnimCurve::",
	"AnimCurveNode::Color",
	"AnimCurveNode::DeformPercent",
	"AnimCurveNode::DiffuseColor",
	"AnimCurveNode::FilmHeight",
	"AnimCurveNode::FilmOffsetX",
	"AnimCurveNode::FilmWidth",
	"AnimCurveNode::FocalLength",
	"AnimCurveNode::FocusDistance",
	"AnimCurveNode::Intensity",
	"AnimCurveNode::R",
	"AnimCurveNode::S",
	"AnimCurveNode::T",
	"AnimCurveNode::TopH",
	"AnimCurveNode::TopV",
	"AnimCurveNode::Visibility",
	"AnimCurveNode::Weight",
	"AnimCurveNode::lockInfluenceWeights",
	"AnimCurveNode::pull",
	"AnimCurveNode::stiffness",
	"AnimLayer::AnimLayer1",
	"AnimLayer::Base",
	"AnimLayer::Base Layer",
	"AnimLayer::BaseLayer",
	"AnimLayer::Rotation",
	"AnimLayer::Take 001:AnimLayer1",
	"AnimLayer::Take 001:BaseAnimation",
	"AnimLayer::X",
	"AnimLayer::Y",
	"AnimStack::Default animation",
	"AnimStack::Idle",
	"AnimStack::Take 001",
	"AnimStack::X",
	"AnimStack::Y",
	"AnimStack::Z",
	"AnimStack::wiggle",
	"AnkleDisplacementDamping",
	"AnkleDisplacementDampingMode",
	"AnkleHeightCompensation",
	"AnkleHeightCompensationMode",
	"AnkleProximityCompensation",
	"AnkleProximityCompensationMode",
	"AnkleStabilizationAngularPerimeter",
	"AnkleStabilizationAngularPerimeterMode",
	"AnkleStabilizationDamping",
	"AnkleStabilizationDampingMode",
	"AnkleStabilizationFloorProximity",
	"AnkleStabilizationFloorProximityMode",
	"AnkleStabilizationPerimeter",
	"AnkleStabilizationPerimeterMode",
	"AnkleStabilizationRecoveryTime",
	"AnkleStabilizationRecoveryTimeMode",
	"AnkleStabilizationTime",
	"AnkleStabilizationTimeMode",
	"AntialiasingIntensity",
	"AntialiasingMethod",
	"ApplyLimits",
	"AudioColor",
	"AutoComputeClipPanes",
	"Autodesk",
	"BBoxMax",
	"BBoxMin",
	"BIiMTNT",
	"BJKKUfZ",
	"Back",
	"BackPlaneDistance",
	"BackPlaneDistanceMode",
	"BackPlaneOffsetX",
	"BackPlaneOffsetY",
	"BackPlaneRotation",
	"BackPlaneScaleX",
	"BackPlaneScaleY",
	"BackPlateCenter",
	"BackPlateCrop",
	"BackPlateFitImage",
	"BackPlateKeepRatio",
	"Background Texture",
	"BackgroundAlphaTreshold",
	"BackgroundBrush",
	"BackgroundColor",
	"BackgroundMode",
	"Base",
	"Base.tak",
	"Batch Tool (scripted)",
	"BbAJerP",
	"Binary",
	"BindingTable::root 1",
	"BindingTable::root 2",
	"BindingTable::root 3",
	"BindingTable::root 4",
	"BindingTable::root 6",
	"BindingTable::root 8",
	"Black",
	"BlendModeBypass",
	"Blender version 2.79 (sub 0)",
	"BoneColor",
	"BorderStyle",
	"BottomBarnDoor",
	"Box",
	"BpgrcZR",
	"C:\\Documents and Settings\\XP3\\My Documents\\tiny_clouds.png",
	"C:\\Program Files\\Autodesk\\3ds Max 2023\\OSL\\ColorAdd.osl",
	"C:\\Program Files\\Autodesk\\3ds Max 2023\\OSL\\ColorMax.osl",
	"C:\\Program Files\\Autodesk\\3ds Max 2023\\OSL\\ColorMul.osl",
	"C:\\Program Files\\Autodesk\\3ds Max 2023\\OSL\\ColorTweak.osl",
	"C:\\Program Files\\Autodesk\\3ds Max 2023\\OSL\\OSLBitmap.osl",
	"C:\\Program Files\\Autodesk\\3ds Max 2023\\OSL\\TriTone.osl",
	"C:\\Program Files\\Autodesk\\3ds Max 2023\\OSL\\UberBitmap.osl",
	"C:\\Program Files\\Autodesk\\3ds Max 2023\\OSL\\VectorAdd.osl",
	"C:\\Program Files\\Autodesk\\3ds Max 2023\\OSL\\checker.osl",
	"C:\\Users\\Datacube\\Documents\\3ds Max 2023",
	"C:\\Users\\Datacube\\Documents\\3ds Max 2023\\scenes\\geogeo.max",
	"C:\\Users\\Datacube\\Documents\\3ds Max 2023\\scenes\\maxmaps.max",
	"C:\\Users\\Datacube\\Documents\\3ds Max 2023\\scenes\\rgbcubes.max",
	"C:\\Users\\Datacube\\Documents\\3ds Max 2023\\scenes\\shadergraph.max",
	"C:\\Users\\Datacube\\Documents\\3dsMax\\Projects\\galleria_oma",
	"Cache::VertexCache_YShape.xml",
	"Cache::VertexCache_pCubeShape1.xml",
	"Cache::VertexCache_pCubeShape2.xml",
	"Cache::marvelous_quad",
	"CacheSet",
	"Camera Index",
	"CameraFormat",
	"CameraViewingMode",
	"Caption",
	"CastLightOnObject",
	"Casts Shadows",
	"Category",
	"Center",
	"Character Selection/Key Controls",
	"Characterize",
	"Checker",
	"Chest Offset R",
	"Chest Offset T",
	"ChestEndEffector",
	"ChestEndEffectorRPin",
	"ChestEndEffectorTPin",
	"ChestOriginEffector",
	"ChestOriginEffectorRPin",
	"ChestOriginEffectorTPin",
	"ChestPosition",
	"ChestReduction",
	"ChestTOffset",
	"Clip",
	"ClipGroupClip",
	"ClipIn",
	"ClipOut",
	"Clips",
	"CodeAbsoluteURL",
	"CodeRelativeURL",
	"CodeTAG",
	"CollarReduction",
	"CollarStiffnessX",
	"CollarStiffnessY",
	"CollarStiffnessZ",
	"ColorA",
	"ColorAdd",
	"ColorB",
	"ColorMax",
	"ColorMul",
	"ColorRGBA",
	"ColorTweak",
	"Compressor",
	"Constants",
	"Constraint::Actor",
	"Constraint::Character1",
	"Constraint::IKHandle",
	"Constraint::IKHandle_ncl1_2",
	"Constraint::Node_parentConstraint1",
	"Constraint::Node_pointConstraint1",
	"Constraint::joint10_aimConstraint1",
	"Constraint::joint1_parentConstraint1",
	"Constraint::joint2_aimConstraint1",
	"Constraint::joint3_orientConstraint1",
	"Constraint::joint4_scaleConstraint1",
	"Constraint::joint5_pointConstraint1",
	"Constraints",
	"ContactBehaviour",
	"ControlSet",
	"ControlSetPlug",
	"ControlSetPlug::Character1_ControlRig",
	"ControlSetType",
	"Crop",
	"CtrlChestPullLeftHand",
	"CtrlChestPullRightHand",
	"CtrlEnforceGravity",
	"CtrlNeckStiffness",
	"CtrlPullHead",
	"CtrlPullLeftElbow",
	"CtrlPullLeftFingerBase",
	"CtrlPullLeftFoot",
	"CtrlPullLeftHand",
	"CtrlPullLeftKnee",
	"CtrlPullLeftToeBase",
	"CtrlPullRightElbow",
	"CtrlPullRightFingerBase",
	"CtrlPullRightFoot",
	"CtrlPullRightHand",
	"CtrlPullRightKnee",
	"CtrlPullRightToeBase",
	"CtrlResistChestOrientation",
	"CtrlResistChestPosition",
	"CtrlResistCompressionFactorLeftElbow",
	"CtrlResistCompressionFactorLeftKnee",
	"CtrlResistCompressionFactorRightElbow",
	"CtrlResistCompressionFactorRightKnee",
	"CtrlResistHipsOrientation",
	"CtrlResistHipsPosition",
	"CtrlResistLeftCollar",
	"CtrlResistLeftElbow",
	"CtrlResistLeftKnee",
	"CtrlResistMaximumExtensionLeftElbow",
	"CtrlResistMaximumExtensionLeftKnee",
	"CtrlResistMaximumExtensionRightElbow",
	"CtrlResistMaximumExtensionRightKnee",
	"CtrlResistRightCollar",
	"CtrlResistRightElbow",
	"CtrlResistRightKnee",
	"CtrlSpineStiffness",
	"CullingMode",
	"CullingOff",
	"CurrentCallbackIndex",
	"CurrentCamera",
	"CurrentMappingType",
	"Custom",
	"CustomKeyIndex",
	"CustomKeyTypeIndex",
	"D:/Dev/clean/ufbx/data/marvelous_quad_diffuse_100-1.png",
	"D:/Dev/clean/ufbx/data/marvelous_quad_normal_100-1.png",
	"D:/Dev/clean/ufbx/data/textures/_diffuse.png",
	"D:/Dev/clean/ufbx/data/textures/checkerboard_ambient.png",
	"D:/Dev/clean/ufbx/data/textures/checkerboard_bump.png",
	"D:/Dev/clean/ufbx/data/textures/checkerboard_diffuse.png",
	"D:/Dev/clean/ufbx/data/textures/checkerboard_emissive.png",
	"D:/Dev/clean/ufbx/data/textures/checkerboard_metallic.png",
	"D:/Dev/clean/ufbx/data/textures/checkerboard_normal.png",
	"D:/Dev/clean/ufbx/data/textures/checkerboard_reflection.png",
	"D:/Dev/clean/ufbx/data/textures/checkerboard_roughness.png",
	"D:/Dev/clean/ufbx/data/textures/checkerboard_specular.png",
	"D:/Dev/clean/ufbx/data/textures/checkerboard_transparency.png",
	"D:/Dev/clean/ufbx/data/textures/checkerboard_weight.png",
	"D:/Dev/clean/ufbx/data/textures/tiny_clouds.png",
	"D:/Dev/clean/ufbx/directory/inner.png",
	"D:/Dev/clean/ufbx/temporary.png",
	"D:/dealers-dungeon/Assets/Temp/Slime/Skin_Base_Color.png",
	"D:\\Dev\\clean\\ufbx",
	"D:\\Dev\\clean\\ufbx\\data",
	"D:\\Dev\\clean\\ufbx\\data\\PolyMesh3D1_TXTR.tga",
	"D:\\Dev\\clean\\ufbx\\data\\marvelous_quad.xml",
	"D:\\Dev\\clean\\ufbx\\data\\marvelous_quad_diffuse_100-1.png",
	"D:\\Dev\\clean\\ufbx\\data\\marvelous_quad_normal_100-1.png",
	"D:\\Dev\\clean\\ufbx\\data\\max_colon_name_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_colon_name_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_cube_quote_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_edge_visibility_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_edge_visibility_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_geometry_transform_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_geometry_transform_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_geometry_transform_instances.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_gltf_material_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_gltf_material_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_instanced_material_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_instanced_material_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_line_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_nurbs_curve_rational_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_nurbs_curve_rational_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_nurbs_to_line_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_pbr_material_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_pbr_metal_material_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_pbr_textures_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_quote_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_quote_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_selection_sets.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_selection_sets_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_shadergraph_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_texture_mapping_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_texture_mapping_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_transformed_skin_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_transformed_skin_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_unicode_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\max_unicode_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_anim_diffuse_curve_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_anim_interpolation_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_anim_interpolation_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_anim_layer_anim_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_anim_linear_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_anim_no_inherit_scale_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_anim_pivot_rotate_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_arnold_properties_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_arnold_textures_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_arnold_textures_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_axes_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_axes_anim_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_axes_anim_7700_ascii_fpc\\YShape.xml",
	"D:\\Dev\\clean\\ufbx\\data\\maya_blend_inbetween_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_blend_shape_cube_7100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_bone_radius_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_bone_radius_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_cache_sine_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_cache_sine_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_camera_axes_y_up_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_child_pivots_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_child_pivots_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_constraint_multi_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_constraint_zoo_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_constraint_zoo_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_cube_blinky_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_cube_blinky_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_cube_hidden_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_cube_hidden_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_cube_unicode_7400_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_different_shaders_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_different_shaders_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_display_layers_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_display_layers_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_double_parent_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_dq_weights_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_dual_quaternion_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_dual_quaternion_scale_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_duplicated_texture_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_edge_smoothing_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_game_anim_xyz.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_hidden_cube_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_human_ik_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_human_ik_7400_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_lock_mute_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_lod_group_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_lod_group_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_long_keyframes_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_long_keyframes_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_material_anim_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_mixed_inherit_mode_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_no_smoothing_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_node_attribute_zoo_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_node_attribute_zoo_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_notes_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_notes_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_nurbs_curve_form_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_nurbs_curve_form_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_nurbs_curve_linear_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_nurbs_low_sphere_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_nurbs_surface_plane_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_nurbs_surface_plane_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_nurbs_surface_sphere_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_ortho_camera_200x300_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_ortho_camera_200x300_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_ortho_camera_400x200_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_ortho_camera_400x200_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_ortho_camera_size_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_ortho_camera_size_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_osl_properties_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_osl_properties_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_parented_cubes_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_phong_properties_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_planar_ngon_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_polygon_hole_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_polygon_hole_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_scale_no_inherit_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_scale_no_inherit_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_shaderfx_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_shaderfx_pbs_textures_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_shared_textures_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_shared_textures_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_skeleton_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_skeleton_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_subsurf_3x_cube_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_subsurf_cube_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_subsurf_max_crease_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_subsurf_plane_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_texture_blend_modes_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_texture_blend_modes_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_texture_layers_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_texture_layers_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_textured_cube_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_textured_cube_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_transform_animation_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_transform_animation_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_unicode_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_vertex_crease_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_vertex_crease_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\maya_vertex_crease_single_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\mb_cube_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\motionbuilder_actor_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\motionbuilder_lights_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\motionbuilder_sausage_rrss_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\motionbuilder_smoothing_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\motionbuilder_thumbnail_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\synthetic_bind_to_root_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\synthetic_cursed_geometry_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\synthetic_duplicate_id_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\synthetic_duplicate_id_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\synthetic_duplicate_prop_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\synthetic_duplicate_prop_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\synthetic_geometric_squish_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\synthetic_invalid_nurbs_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\synthetic_node_dag_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\synthetic_parent_directory_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\synthetic_unnormalized_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\synthetic_vertex_gaps_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\textures\\checkerboard_ambient.png",
	"D:\\Dev\\clean\\ufbx\\data\\textures\\checkerboard_bump.png",
	"D:\\Dev\\clean\\ufbx\\data\\textures\\checkerboard_diffuse.png",
	"D:\\Dev\\clean\\ufbx\\data\\textures\\checkerboard_displacement.png",
	"D:\\Dev\\clean\\ufbx\\data\\textures\\checkerboard_emissive.png",
	"D:\\Dev\\clean\\ufbx\\data\\textures\\checkerboard_metallic.png",
	"D:\\Dev\\clean\\ufbx\\data\\textures\\checkerboard_normal.png",
	"D:\\Dev\\clean\\ufbx\\data\\textures\\checkerboard_reflection.png",
	"D:\\Dev\\clean\\ufbx\\data\\textures\\checkerboard_roughness.png",
	"D:\\Dev\\clean\\ufbx\\data\\textures\\checkerboard_specular.png",
	"D:\\Dev\\clean\\ufbx\\data\\textures\\checkerboard_transparency.png",
	"D:\\Dev\\clean\\ufbx\\data\\textures\\checkerboard_weight.png",
	"D:\\Dev\\clean\\ufbx\\data\\zbrush_d20_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\zbrush_d20_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\zbrush_d20_selection_set_6100_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\zbrush_d20_selection_set_7700_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\zbrush_sphere_7500_ascii.fbx",
	"D:\\Dev\\clean\\ufbx\\data\\zbrush_vertex_color_7500_ascii.fbx",
	"D:\\Dev\\ufbx",
	"D:\\Dev\\ufbx\\data",
	"D:\\Dev\\ufbx\\data\\maya_anim_layers_7500_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_anim_layers_7500_transform_acc_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_anim_layers_over_7500_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_anim_layers_over_acc_7500_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_anim_light_6100_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_anim_light_7500_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_auto_clamp_6100_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_auto_clamp_7100_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_auto_clamp_7700_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_blend_shape_cube_6100_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_blend_shape_cube_7500_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_color_sets_6100_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_color_sets_7500_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_cone_6100_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_cone_7500_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_cube_6100_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_cube_7100_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_cube_7400_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_cube_7500_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_game_sausage_6100_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_game_sausage_6100_ascii_wiggle.fbx",
	"D:\\Dev\\ufbx\\data\\maya_game_sausage_7500_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_game_sausage_7500_ascii_wiggle.fbx",
	"D:\\Dev\\ufbx\\data\\maya_interpolation_modes_6100_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_interpolation_modes_7500_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_pivots_6100_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_pivots_7500_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_post_rotate_order_6100_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_pre_rotate_order_7500_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_resampled_6100_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_resampled_7500_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_rotation_order_6100_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_rotation_order_7500_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_uv_and_color_sets_6100_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_uv_and_color_sets_7500_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_uv_set_tangents_6100_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_uv_set_tangents_7500_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_uv_sets_6100_ascii.fbx",
	"D:\\Dev\\ufbx\\data\\maya_uv_sets_7500_ascii.fbx",
	"D:\\dealers-dungeon\\Assets\\Temp",
	"D:\\dealers-dungeon\\Assets\\Temp\\Slime\\Slime_anim_Idle.fbx",
	"Damping",
	"Darken",
	"DecayStart",
	"Default Take",
	"Default animation",
	"DefaultHUD",
	"DefaultKeyingGroup",
	"DefaultKeyingGroupEnum",
	"Default_Take.tak",
	"Default_animation.tak",
	"Deformer::",
	"Deformer::KeyBlend",
	"Deformer::PolyMesh3D1_Blendshape",
	"Deformer::Shape",
	"Deformer::Skin Box001",
	"Deformer::Skin Skin",
	"Deformer::Skin pCube1",
	"Deformer::Squish",
	"Deformer::VertexCacheDeformer",
	"Deformer::VertexCacheDeformer_ncl1_1",
	"Deformer::VertexCacheDeformer_ncl1_2",
	"Deformer::VertexCacheDeformer_ncl1_3",
	"Deformer::blendShape2",
	"Deformer::marvelous_quad",
	"DescAbsoluteURL",
	"DescRelativeURL",
	"DescTAG",
	"Description",
	"DestinationObject",
	"Difference",
	"Diffuse Layer",
	"DiffuseUV",
	"Direct",
	"DisplacementColor",
	"DisplacementDamping",
	"DisplacementDampingMode",
	"DisplacementMemory",
	"DisplacementMemoryMode",
	"Display2DMagnifierFrame",
	"DisplayBoundingBox",
	"DisplayHierarchicalBoundingBox",
	"DisplayLayer::LayerA",
	"DisplayLayer::LayerB",
	"DisplayLayer::LayerC",
	"DisplayLayer::Slime_002:defaultLayer",
	"DisplayLevels",
	"DisplayLevels|Level0",
	"DisplayLevels|Level1",
	"DisplayLevels|Level2",
	"DisplayMemory",
	"DisplayNormal",
	"DisplaySafeArea",
	"DisplaySafeAreaOnRender",
	"DisplayStatistics",
	"DisplayStereoManipulator",
	"DisplayTurnTableIcon",
	"DrawFrontFacingVolumetricLight",
	"DrawGroundProjection",
	"DrawLink",
	"DrawMode",
	"DrawVolumetricLight",
	"Edit root",
	"Elgato Screen Link",
	"Empty",
	"EnableBarnDoor",
	"EnableFarAttenuation",
	"EnableNearAttenuation",
	"EvaluateTSAnim",
	"ExtraCollarRatio",
	"FBX Export",
	"FBX SDK/FBX Plugins build 20070228",
	"FBX SDK/FBX Plugins build 20080212",
	"FBX SDK/FBX Plugins version 2019.2",
	"FBX SDK/FBX Plugins version 2020.0",
	"FBX SDK/FBX Plugins version 2020.0.1",
	"FBX SDK/FBX Plugins version 2020.1",
	"FBX SDK/FBX Plugins version 2020.1.1",
	"FBX SDK/FBX Plugins version 2020.3",
	"FCurve",
	"FKFingerMultiplier",
	"FKFingerTipMultiplier",
	"FKThumbTipMultiplier",
	"FarAttenuationEnd",
	"FarAttenuationStart",
	"FbxAnimCurve",
	"FbxAnimCurveNode",
	"FbxAnimLayer",
	"FbxAnimStack",
	"FbxBindingTable",
	"FbxCache",
	"FbxCacheExport",
	"FbxCamera",
	"FbxCharacter",
	"FbxConstraintParent",
	"FbxConstraintPosition",
	"FbxControlSetPlug",
	"FbxDisplayLayer",
	"FbxFileTexture",
	"FbxImplementation",
	"FbxLODGroup",
	"FbxLayeredTexture",
	"FbxLight",
	"FbxLine",
	"FbxMesh",
	"FbxNode",
	"FbxNull",
	"FbxNurbsCurve",
	"FbxNurbsSurface",
	"FbxSelectionSet",
	"FbxSkeleton",
	"FbxSurfaceLambert",
	"FbxSurfaceMaterial",
	"FbxSurfacePhong",
	"FbxThumbnail",
	"FbxVertexCacheDeformer",
	"FbxVideo",
	"FilmAspectRatio",
	"FilmFormatIndex",
	"FilmOffsetLeftCam",
	"FilmOffsetRightCam",
	"FilmOffsetX",
	"FilmOffsetY",
	"FilmRollOrder",
	"FilmRollPivotX",
	"FilmRollPivotY",
	"FilmRollValue",
	"FilmTranslateX",
	"FilmTranslateY",
	"FingerSolving",
	"FitImage",
	"Fixed Resolution",
	"Focus Model",
	"FocusAngle",
	"FocusDistance",
	"FocusSource",
	"Fog",
	"Fog Begin",
	"Fog Color",
	"Fog Density",
	"Fog End",
	"FogEnable",
	"FogMode",
	"Folder",
	"Folder::Constraints",
	"Folder::Poses",
	"Folder::Takes",
	"FolderType: &quot;Constraints&quot;&lf;",
	"FolderType: &quot;Poses&quot;&lf;",
	"FolderType: &quot;Takes&quot;&lf;",
	"FootAutomaticToes",
	"FootBackToAnkle",
	"FootBottomToAnkle",
	"FootContactSize",
	"FootContactStiffness",
	"FootContactType",
	"FootFingerContact",
	"FootFingerContactMode",
	"FootFingerContactRollStiffness",
	"FootFloorContact",
	"FootFloorPivot",
	"FootFrontToMiddle",
	"FootInToAnkle",
	"FootMiddleToAnkle",
	"FootOutToAnkle",
	"ForceActorSpace",
	"Foreground Opacity",
	"Foreground Texture",
	"ForegroundTransparent",
	"FrameColor",
	"FrameSamplingCount",
	"FrameSamplingType",
	"FreeRunning",
	"FrontPlaneDistance",
	"FrontPlaneDistanceMode",
	"FrontPlaneOffsetX",
	"FrontPlaneOffsetY",
	"FrontPlaneRotation",
	"FrontPlaneScaleX",
	"FrontPlaneScaleY",
	"FrontPlateCenter",
	"FrontPlateCrop",
	"FrontPlateFitImage",
	"FrontPlateKeepRatio",
	"GameModeParentLeftElbowLink",
	"GameModeParentLeftElbowRollLink",
	"GameModeParentLeftHipRollLink",
	"GameModeParentLeftKneeLink",
	"GameModeParentLeftKneeRollLink",
	"GameModeParentLeftShoulderRollLink",
	"GameModeParentRightElbowLink",
	"GameModeParentRightElbowRollLink",
	"GameModeParentRightHipRollLink",
	"GameModeParentRightKneeLink",
	"GameModeParentRightKneeRollLink",
	"GameModeParentRightShoulderRollLink",
	"GeometricCenterVisibility",
	"Geometry::",
	"Geometry::&quot;'&&quot;_ncl1_1",
	"Geometry::&quot;_ncl1_1",
	"Geometry::20 Sided",
	"Geometry::20 Sided_ncl1_1",
	"Geometry::8 Sided",
	"Geometry::A_ncl1_1",
	"Geometry::B_ncl1_1",
	"Geometry::Back",
	"Geometry::Box001_ncl1_1",
	"Geometry::Box002_ncl1_1",
	"Geometry::Box01",
	"Geometry::Child__ncl1_1",
	"Geometry::Cube::Model_ncl1_1",
	"Geometry::Curve001_ncl1_1",
	"Geometry::Cylinder001_ncl1_1",
	"Geometry::Green_ncl1_1",
	"Geometry::KeyBlend.LiftTop0",
	"Geometry::KeyBlend.MoveToSide0",
	"Geometry::KeyBlend.MoveToSide1",
	"Geometry::LiftTop",
	"Geometry::Mesh_ncl1_1",
	"Geometry::Morph",
	"Geometry::MoveToSide",
	"Geometry::NodeA_ncl1_1",
	"Geometry::NodeAttribute 10",
	"Geometry::NodeAttribute 13",
	"Geometry::NodeAttribute 14",
	"Geometry::NodeAttribute 15",
	"Geometry::NodeAttribute 16",
	"Geometry::NodeAttribute 17",
	"Geometry::NodeAttribute 18",
	"Geometry::NodeAttribute 19",
	"Geometry::NodeAttribute 20",
	"Geometry::NodeB_ncl1_1",
	"Geometry::NodeC_ncl1_1",
	"Geometry::NodeFree_ncl1_1",
	"Geometry::NurbsCurve_ncl1_1",
	"Geometry::NurbsSurface_ncl1_1",
	"Geometry::NurbsTrim_ncl1_1",
	"Geometry::Parent_ncl1_1",
	"Geometry::Plane001_ncl1_1",
	"Geometry::PolyMesh3D1",
	"Geometry::PolyMesh3D1_ncl1_1",
	"Geometry::PolySphere",
	"Geometry::Surface001_ncl1_1",
	"Geometry::Target",
	"Geometry::TopH",
	"Geometry::TopV",
	"Geometry::X1",
	"Geometry::XYZ_ncl1_1",
	"Geometry::XZY_ncl1_1",
	"Geometry::YXZ_ncl1_1",
	"Geometry::YZX_ncl1_1",
	"Geometry::ZXY_ncl1_1",
	"Geometry::ZYX_ncl1_1",
	"Geometry::_ncl1_10",
	"Geometry::_ncl1_11",
	"Geometry::_ncl1_12",
	"Geometry::_ncl1_13",
	"Geometry::_ncl1_14",
	"Geometry::_ncl1_15",
	"Geometry::_ncl1_16",
	"Geometry::_ncl1_17",
	"Geometry::_ncl1_18",
	"Geometry::_ncl1_19",
	"Geometry::_ncl1_20",
	"Geometry::_ncl1_4",
	"Geometry::_ncl1_5",
	"Geometry::_ncl1_6",
	"Geometry::_ncl1_7",
	"Geometry::_ncl1_8",
	"Geometry::_ncl1_9",
	"Geometry::a____ncl1_1",
	"Geometry::a_ncl1_1",
	"Geometry::circleClosed_ncl1_1",
	"Geometry::circleOpen_ncl1_1",
	"Geometry::circlePeriodic_ncl1_1",
	"Geometry::curve1_ncl1_1",
	"Geometry::marvelous_quad",
	"Geometry::nurbsPlane1_ncl1_1",
	"Geometry::pCone1_ncl1_1",
	"Geometry::pCube1_ncl1_1",
	"Geometry::pCube2_ncl1_1",
	"Geometry::pCube3_ncl1_1",
	"Geometry::pPlane1_ncl1_1",
	"Geometry::pPlatonic1_ncl1_3",
	"Geometry::pPlatonic1_ncl1_4",
	"Geometry::pPlatonic1_ncl1_5",
	"Geometry::pSphere1_ncl1_1",
	"Geometry::pSphere1_ncl1_2",
	"Geometry::pSphere1_ncl1_3",
	"Global Light",
	"GlobalInfo",
	"GlobalNLE:  {&lf;    Version: 7&lf;}&lf;",
	"GlobalSettings::Settings",
	"GlobalShading",
	"GoboProperty",
	"H",
	"HN",
	"HandAutomaticFingers",
	"HandBackToWrist",
	"HandBottomToWrist",
	"HandContactSize",
	"HandContactStiffness",
	"HandContactType",
	"HandFingerContact",
	"HandFingerContactMode",
	"HandFingerContactRollStiffness",
	"HandFloorContact",
	"HandFloorPivot",
	"HandFrontToMiddle",
	"HandInToWrist",
	"HandMiddleToWrist",
	"HandOutToWrist",
	"Head",
	"Head Offset R",
	"Head Offset T",
	"HeadEffector",
	"HeadEffectorRPin",
	"HeadEffectorTPin",
	"HeadLink",
	"HeadPosition",
	"HeadReduction",
	"Height",
	"Hide",
	"HideManipulatorsOnManip",
	"HideManipulatorsOnPlayback",
	"HierarchicalCenterVisibility",
	"HierarchyView",
	"HikVersion",
	"Hint",
	"HintIsTextCompletion",
	"HintMouse",
	"HintMouseHeight",
	"HintMouseLeft",
	"HintMouseTop",
	"HintMouseWidth",
	"Hips",
	"Hips Offset R",
	"Hips Offset T",
	"HipsDisplacementDamping",
	"HipsDisplacementDampingMode",
	"HipsEffector",
	"HipsEffectorRPin",
	"HipsEffectorTPin",
	"HipsHeightCompensation",
	"HipsHeightCompensationMode",
	"HipsLink",
	"HipsPosition",
	"HipsTOffset",
	"HipsTranslationLink",
	"HipsTranslationMode",
	"HumanFingerLimits",
	"IDBufferPickingAlpha",
	"IK Pull",
	"IK Pull Hips",
	"IK Reach Rotation",
	"IK Reach Translation",
	"IKPivot",
	"IKSync",
	"Idle",
	"Idle.tak",
	"Image",
	"ImageName",
	"ImageSequence",
	"ImageSequenceOffset",
	"Implementation::01 - Default_Implementation",
	"Implementation::Material #25_Implementation",
	"Implementation::StingrayPBS1_Implementation",
	"Implementation::aiStandardSurface1_Implementation",
	"Implementation::standardSurface2_Implementation",
	"Index",
	"IndexToDirect",
	"InteraxialSeparation",
	"InterestPosition",
	"InterlaceMode",
	"KAudioManager",
	"KCharacterHelper",
	"KEEPACTIVE: 0&lf;",
	"KFbxScene",
	"KHUDManager",
	"KMotionTriggerManager",
	"KNLEManager",
	"KNamespacePropertiesManager",
	"KSerialManager",
	"KTimeWarpManager",
	"KTimelineXManager",
	"KVideoRenderer",
	"KeepRatio",
	"Keyboard Shortcuts Editor",
	"KtHierarchyView",
	"KtViewer",
	"LastFrame",
	"LastSaved",
	"LastSaved|DateTime_GMT",
	"LayerElementAmbientTextures",
	"LayerElementAmbientUV",
	"LayerElementBumpTextures",
	"LayerElementBumpUV",
	"LayerElementDiffuseFactorUV",
	"LayerElementEmissiveUV",
	"LayerElementReflectionTextures",
	"LayerElementReflectionUV",
	"LayerElementShininessTextures",
	"LayerElementSpecularTextures",
	"LayerElementSpecularUV",
	"LayerElementTransparentTextures",
	"LayerElementTransparentUV",
	"LayeredTexture::layeredTexture1",
	"LeafLeftArmRoll1",
	"LeafLeftArmRoll1Link",
	"LeafLeftArmRoll1Mode",
	"LeafLeftArmRoll2",
	"LeafLeftArmRoll2Link",
	"LeafLeftArmRoll2Mode",
	"LeafLeftArmRoll3",
	"LeafLeftArmRoll3Link",
	"LeafLeftArmRoll3Mode",
	"LeafLeftArmRoll4",
	"LeafLeftArmRoll4Link",
	"LeafLeftArmRoll4Mode",
	"LeafLeftArmRoll5",
	"LeafLeftArmRoll5Link",
	"LeafLeftArmRoll5Mode",
	"LeafLeftForeArmRoll1",
	"LeafLeftForeArmRoll1Link",
	"LeafLeftForeArmRoll1Mode",
	"LeafLeftForeArmRoll2",
	"LeafLeftForeArmRoll2Link",
	"LeafLeftForeArmRoll2Mode",
	"LeafLeftForeArmRoll3",
	"LeafLeftForeArmRoll3Link",
	"LeafLeftForeArmRoll3Mode",
	"LeafLeftForeArmRoll4",
	"LeafLeftForeArmRoll4Link",
	"LeafLeftForeArmRoll4Mode",
	"LeafLeftForeArmRoll5",
	"LeafLeftForeArmRoll5Link",
	"LeafLeftForeArmRoll5Mode",
	"LeafLeftLegRoll1",
	"LeafLeftLegRoll1Link",
	"LeafLeftLegRoll1Mode",
	"LeafLeftLegRoll2",
	"LeafLeftLegRoll2Link",
	"LeafLeftLegRoll2Mode",
	"LeafLeftLegRoll3",
	"LeafLeftLegRoll3Link",
	"LeafLeftLegRoll3Mode",
	"LeafLeftLegRoll4",
	"LeafLeftLegRoll4Link",
	"LeafLeftLegRoll4Mode",
	"LeafLeftLegRoll5",
	"LeafLeftLegRoll5Link",
	"LeafLeftLegRoll5Mode",
	"LeafLeftUpLegRoll1",
	"LeafLeftUpLegRoll1Link",
	"LeafLeftUpLegRoll1Mode",
	"LeafLeftUpLegRoll2",
	"LeafLeftUpLegRoll2Link",
	"LeafLeftUpLegRoll2Mode",
	"LeafLeftUpLegRoll3",
	"LeafLeftUpLegRoll3Link",
	"LeafLeftUpLegRoll3Mode",
	"LeafLeftUpLegRoll4",
	"LeafLeftUpLegRoll4Link",
	"LeafLeftUpLegRoll4Mode",
	"LeafLeftUpLegRoll5",
	"LeafLeftUpLegRoll5Link",
	"LeafLeftUpLegRoll5Mode",
	"LeafRightArmRoll1",
	"LeafRightArmRoll1Link",
	"LeafRightArmRoll1Mode",
	"LeafRightArmRoll2",
	"LeafRightArmRoll2Link",
	"LeafRightArmRoll2Mode",
	"LeafRightArmRoll3",
	"LeafRightArmRoll3Link",
	"LeafRightArmRoll3Mode",
	"LeafRightArmRoll4",
	"LeafRightArmRoll4Link",
	"LeafRightArmRoll4Mode",
	"LeafRightArmRoll5",
	"LeafRightArmRoll5Link",
	"LeafRightArmRoll5Mode",
	"LeafRightForeArmRoll1",
	"LeafRightForeArmRoll1Link",
	"LeafRightForeArmRoll1Mode",
	"LeafRightForeArmRoll2",
	"LeafRightForeArmRoll2Link",
	"LeafRightForeArmRoll2Mode",
	"LeafRightForeArmRoll3",
	"LeafRightForeArmRoll3Link",
	"LeafRightForeArmRoll3Mode",
	"LeafRightForeArmRoll4",
	"LeafRightForeArmRoll4Link",
	"LeafRightForeArmRoll4Mode",
	"LeafRightForeArmRoll5",
	"LeafRightForeArmRoll5Link",
	"LeafRightForeArmRoll5Mode",
	"LeafRightLegRoll1",
	"LeafRightLegRoll1Link",
	"LeafRightLegRoll1Mode",
	"LeafRightLegRoll2",
	"LeafRightLegRoll2Link",
	"LeafRightLegRoll2Mode",
	"LeafRightLegRoll3",
	"LeafRightLegRoll3Link",
	"LeafRightLegRoll3Mode",
	"LeafRightLegRoll4",
	"LeafRightLegRoll4Link",
	"LeafRightLegRoll4Mode",
	"LeafRightLegRoll5",
	"LeafRightLegRoll5Link",
	"LeafRightLegRoll5Mode",
	"LeafRightUpLegRoll1",
	"LeafRightUpLegRoll1Link",
	"LeafRightUpLegRoll1Mode",
	"LeafRightUpLegRoll2",
	"LeafRightUpLegRoll2Link",
	"LeafRightUpLegRoll2Mode",
	"LeafRightUpLegRoll3",
	"LeafRightUpLegRoll3Link",
	"LeafRightUpLegRoll3Mode",
	"LeafRightUpLegRoll4",
	"LeafRightUpLegRoll4Link",
	"LeafRightUpLegRoll4Mode",
	"LeafRightUpLegRoll5",
	"LeafRightUpLegRoll5Link",
	"LeafRightUpLegRoll5Mode",
	"Left",
	"Left Ankle Offset R",
	"Left Ankle Offset T",
	"Left Collar Offset R",
	"Left Collar Offset T",
	"Left Elbow Offset R",
	"Left Elbow Offset T",
	"Left Foot Offset R",
	"Left Foot Offset T",
	"Left Hip Offset R",
	"Left Hip Offset T",
	"Left Index A Offset R",
	"Left Index A Offset T",
	"Left Index B Offset R",
	"Left Index B Offset T",
	"Left Index C Offset R",
	"Left Index C Offset T",
	"Left Knee Offset R",
	"Left Knee Offset T",
	"Left Middle A Offset R",
	"Left Middle A Offset T",
	"Left Middle B Offset R",
	"Left Middle B Offset T",
	"Left Middle C Offset R",
	"Left Middle C Offset T",
	"Left Pinky A Offset R",
	"Left Pinky A Offset T",
	"Left Pinky B Offset R",
	"Left Pinky B Offset T",
	"Left Pinky C Offset R",
	"Left Pinky C Offset T",
	"Left Ring A Offset R",
	"Left Ring A Offset T",
	"Left Ring B Offset R",
	"Left Ring B Offset T",
	"Left Ring C Offset R",
	"Left Ring C Offset T",
	"Left Shoulder Offset R",
	"Left Shoulder Offset T",
	"Left Thumb A Offset R",
	"Left Thumb A Offset T",
	"Left Thumb B Offset R",
	"Left Thumb B Offset T",
	"Left Thumb C Offset R",
	"Left Thumb C Offset T",
	"Left Wrist Offset R",
	"Left Wrist Offset T",
	"LeftAnkleEffector",
	"LeftAnkleEffectorRPin",
	"LeftAnkleEffectorTPin",
	"LeftAnklePosition",
	"LeftArm",
	"LeftArmFullRollExtraction",
	"LeftArmLink",
	"LeftArmMaxExtensionAngle",
	"LeftArmRoll",
	"LeftArmRollEx",
	"LeftArmRollExLink",
	"LeftArmRollExMode",
	"LeftArmRollLink",
	"LeftArmRollMode",
	"LeftBarnDoor",
	"LeftCollarPosition",
	"LeftElbowEffector",
	"LeftElbowEffectorRPin",
	"LeftElbowEffectorTPin",
	"LeftElbowKillPitch",
	"LeftElbowPosition",
	"LeftFingerBase",
	"LeftFingerBaseLink",
	"LeftFloorContact",
	"LeftFloorContactLink",
	"LeftFoot",
	"LeftFootEffector",
	"LeftFootEffectorRPin",
	"LeftFootEffectorTPin",
	"LeftFootExtraFinger1",
	"LeftFootExtraFinger1Link",
	"LeftFootExtraFinger2",
	"LeftFootExtraFinger2Link",
	"LeftFootExtraFinger3",
	"LeftFootExtraFinger3Link",
	"LeftFootExtraFinger4",
	"LeftFootExtraFinger4Link",
	"LeftFootExtraFingerEffector",
	"LeftFootExtraFingerTip",
	"LeftFootIndex1",
	"LeftFootIndex1Link",
	"LeftFootIndex2",
	"LeftFootIndex2Link",
	"LeftFootIndex3",
	"LeftFootIndex3Link",
	"LeftFootIndex4",
	"LeftFootIndex4Link",
	"LeftFootIndexEffector",
	"LeftFootIndexTip",
	"LeftFootLink",
	"LeftFootMiddle1",
	"LeftFootMiddle1Link",
	"LeftFootMiddle2",
	"LeftFootMiddle2Link",
	"LeftFootMiddle3",
	"LeftFootMiddle3Link",
	"LeftFootMiddle4",
	"LeftFootMiddle4Link",
	"LeftFootMiddleEffector",
	"LeftFootMiddleTip",
	"LeftFootPinky1",
	"LeftFootPinky1Link",
	"LeftFootPinky2",
	"LeftFootPinky2Link",
	"LeftFootPinky3",
	"LeftFootPinky3Link",
	"LeftFootPinky4",
	"LeftFootPinky4Link",
	"LeftFootPinkyEffector",
	"LeftFootPinkyTip",
	"LeftFootPosition",
	"LeftFootRing1",
	"LeftFootRing1Link",
	"LeftFootRing2",
	"LeftFootRing2Link",
	"LeftFootRing3",
	"LeftFootRing3Link",
	"LeftFootRing4",
	"LeftFootRing4Link",
	"LeftFootRingEffector",
	"LeftFootRingTip",
	"LeftFootThumb1",
	"LeftFootThumb1Link",
	"LeftFootThumb2",
	"LeftFootThumb2Link",
	"LeftFootThumb3",
	"LeftFootThumb3Link",
	"LeftFootThumb4",
	"LeftFootThumb4Link",
	"LeftFootThumbEffector",
	"LeftFootThumbTip",
	"LeftForeArm",
	"LeftForeArmLink",
	"LeftForeArmRoll",
	"LeftForeArmRollEx",
	"LeftForeArmRollExLink",
	"LeftForeArmRollExMode",
	"LeftForeArmRollLink",
	"LeftForeArmRollMode",
	"LeftGlove",
	"LeftHand",
	"LeftHandEffector",
	"LeftHandExtraFinger1",
	"LeftHandExtraFinger1Link",
	"LeftHandExtraFinger2",
	"LeftHandExtraFinger2Link",
	"LeftHandExtraFinger3",
	"LeftHandExtraFinger3Link",
	"LeftHandExtraFinger4",
	"LeftHandExtraFinger4Link",
	"LeftHandExtraFingerEffector",
	"LeftHandExtraFingerTip",
	"LeftHandFloorContactLink",
	"LeftHandIndex1",
	"LeftHandIndex1Link",
	"LeftHandIndex2",
	"LeftHandIndex2Link",
	"LeftHandIndex3",
	"LeftHandIndex3Link",
	"LeftHandIndex4",
	"LeftHandIndex4Link",
	"LeftHandIndexEffector",
	"LeftHandIndexEffectorRPin",
	"LeftHandIndexEffectorTPin",
	"LeftHandIndexIndex",
	"LeftHandIndexMiddle",
	"LeftHandIndexPinky",
	"LeftHandIndexRing",
	"LeftHandIndexTip",
	"LeftHandLink",
	"LeftHandMiddle1",
	"LeftHandMiddle1Link",
	"LeftHandMiddle2",
	"LeftHandMiddle2Link",
	"LeftHandMiddle3",
	"LeftHandMiddle3Link",
	"LeftHandMiddle4",
	"LeftHandMiddle4Link",
	"LeftHandMiddleEffector",
	"LeftHandMiddleEffectorRPin",
	"LeftHandMiddleEffectorTPin",
	"LeftHandMiddleIndex",
	"LeftHandMiddleMiddle",
	"LeftHandMiddlePinky",
	"LeftHandMiddleRing",
	"LeftHandMiddleTip",
	"LeftHandPinky1",
	"LeftHandPinky1Link",
	"LeftHandPinky2",
	"LeftHandPinky2Link",
	"LeftHandPinky3",
	"LeftHandPinky3Link",
	"LeftHandPinky4",
	"LeftHandPinky4Link",
	"LeftHandPinkyEffector",
	"LeftHandPinkyEffectorRPin",
	"LeftHandPinkyEffectorTPin",
	"LeftHandPinkyIndex",
	"LeftHandPinkyMiddle",
	"LeftHandPinkyPinky",
	"LeftHandPinkyRing",
	"LeftHandPinkyTip",
	"LeftHandRing1",
	"LeftHandRing1Link",
	"LeftHandRing2",
	"LeftHandRing2Link",
	"LeftHandRing3",
	"LeftHandRing3Link",
	"LeftHandRing4",
	"LeftHandRing4Link",
	"LeftHandRingEffector",
	"LeftHandRingEffectorRPin",
	"LeftHandRingEffectorTPin",
	"LeftHandRingIndex",
	"LeftHandRingMiddle",
	"LeftHandRingPinky",
	"LeftHandRingRing",
	"LeftHandRingTip",
	"LeftHandThumb1",
	"LeftHandThumb1Link",
	"LeftHandThumb2",
	"LeftHandThumb2Link",
	"LeftHandThumb3",
	"LeftHandThumb3Link",
	"LeftHandThumb4",
	"LeftHandThumb4Link",
	"LeftHandThumbEffector",
	"LeftHandThumbEffectorRPin",
	"LeftHandThumbEffectorTPin",
	"LeftHandThumbTip",
	"LeftHipEffector",
	"LeftHipEffectorRPin",
	"LeftHipEffectorTPin",
	"LeftHipPosition",
	"LeftInFootExtraFinger",
	"LeftInFootExtraFingerLink",
	"LeftInFootIndex",
	"LeftInFootIndexLink",
	"LeftInFootMiddle",
	"LeftInFootMiddleLink",
	"LeftInFootPinky",
	"LeftInFootPinkyLink",
	"LeftInFootRing",
	"LeftInFootRingLink",
	"LeftInFootThumb",
	"LeftInFootThumbLink",
	"LeftInHandExtraFinger",
	"LeftInHandExtraFingerLink",
	"LeftInHandIndex",
	"LeftInHandIndexLink",
	"LeftInHandMiddle",
	"LeftInHandMiddleLink",
	"LeftInHandPinky",
	"LeftInHandPinkyLink",
	"LeftInHandRing",
	"LeftInHandRingLink",
	"LeftInHandThumb",
	"LeftInHandThumbLink",
	"LeftKneeEffector",
	"LeftKneeEffectorRPin",
	"LeftKneeEffectorTPin",
	"LeftKneeKillPitch",
	"LeftKneePosition",
	"LeftLeg",
	"LeftLegFullRollExtraction",
	"LeftLegLink",
	"LeftLegMaxExtensionAngle",
	"LeftLegRoll",
	"LeftLegRollEx",
	"LeftLegRollExLink",
	"LeftLegRollExMode",
	"LeftLegRollLink",
	"LeftLegRollMode",
	"LeftShoulder",
	"LeftShoulderEffector",
	"LeftShoulderEffectorRPin",
	"LeftShoulderEffectorTPin",
	"LeftShoulderExtra",
	"LeftShoulderExtraLink",
	"LeftShoulderLink",
	"LeftShoulderPosition",
	"LeftToeBase",
	"LeftToeBaseLink",
	"LeftUpLeg",
	"LeftUpLegLink",
	"LeftUpLegRoll",
	"LeftUpLegRollEx",
	"LeftUpLegRollExLink",
	"LeftUpLegRollExMode",
	"LeftUpLegRollLink",
	"LeftUpLegRollMode",
	"LeftWristEffector",
	"LeftWristEffectorRPin",
	"LeftWristEffectorTPin",
	"LeftWristPosition",
	"LegacyStyle",
	"LightIntensityInfluenceFog",
	"Lighten",
	"Live",
	"Load UDIM...",
	"LocalTranslationRefVisibility",
	"Lock",
	"LockInterestNavigation",
	"LockMode",
	"LockedByParent",
	"Logi Capture",
	"Look",
	"Loop",
	"Luminosity",
	"MainViewer",
	"ManipulateOffsets",
	"ManipulationMode",
	"MarkerSet",
	"MarkerSize",
	"MassCenterCompensation",
	"Material::&&q&qu&quo&quot&quot;&quot;",
	"Material::01 - Default",
	"Material::02 - Default",
	"Material::20 Sided",
	"Material::20 Sided_ncl1_2",
	"Material::8 Sided",
	"Material::BlueMat",
	"Material::Clouds",
	"Material::Front",
	"Material::GreenMat",
	"Material::InvertedMaterial",
	"Material::Left",
	"Material::Material",
	"Material::Material #25",
	"Material::Material #27",
	"Material::Material #28",
	"Material::Material #29",
	"Material::Material75041",
	"Material::Material::Pink",
	"Material::Material_",
	"Material::Material_001",
	"Material::PhysicalMaterial",
	"Material::PolyMesh3D1",
	"Material::PolyMesh3D1_ncl1_2",
	"Material::PolySphere",
	"Material::Red",
	"Material::RedMat",
	"Material::Right",
	"Material::Shared",
	"Material::Slime_002:Skin",
	"Material::Special",
	"Material::StingrayPBS1",
	"Material::Top",
	"Material::White",
	"Material::aiStandardSurface1",
	"Material::lambert1",
	"Material::lambert2",
	"Material::lambert3",
	"Material::lambert4",
	"Material::phong1",
	"Material::standardSurface2",
	"Material::typeBlinn1",
	"Material::typeBlinn2",
	"Material::typeBlinn3",
	"Material::unnamed",
	"MaxHSize",
	"MaxHandle",
	"MaxWSize",
	"Maya",
	"Maya|TEX_ao_map",
	"Maya|TEX_brdf_lut",
	"Maya|TEX_color_map",
	"Maya|TEX_emissive_map",
	"Maya|TEX_global_diffuse_cube",
	"Maya|TEX_global_specular_cube",
	"Maya|TEX_metallic_map",
	"Maya|TEX_normal_map",
	"Maya|TEX_roughness_map",
	"Maya|TypeId",
	"Maya|aiEnableMatte",
	"Maya|aiMatteColor",
	"Maya|aiMatteColorA",
	"Maya|aovId1",
	"Maya|aovId2",
	"Maya|aovId3",
	"Maya|aovId4",
	"Maya|aovId5",
	"Maya|aovId6",
	"Maya|aovId7",
	"Maya|aovId8",
	"Maya|base",
	"Maya|baseColor",
	"Maya|base_color",
	"Maya|caustics",
	"Maya|coat",
	"Maya|coatAffectColor",
	"Maya|coatAffectRoughness",
	"Maya|coatAnisotropy",
	"Maya|coatColor",
	"Maya|coatIOR",
	"Maya|coatNormal",
	"Maya|coatRotation",
	"Maya|coatRoughness",
	"Maya|dielectricPriority",
	"Maya|diffuseRoughness",
	"Maya|emission",
	"Maya|emissionColor",
	"Maya|emissive",
	"Maya|emissive_intensity",
	"Maya|exitToBackground",
	"Maya|id1",
	"Maya|id2",
	"Maya|id3",
	"Maya|id4",
	"Maya|id5",
	"Maya|id6",
	"Maya|id7",
	"Maya|id8",
	"Maya|indirectDiffuse",
	"Maya|indirectSpecular",
	"Maya|internalReflections",
	"Maya|metallic",
	"Maya|metalness",
	"Maya|normalCamera",
	"Maya|normalCameraFactor",
	"Maya|normalCameraUsedAs",
	"Maya|opacity",
	"Maya|outAlpha",
	"Maya|roughness",
	"Maya|sheen",
	"Maya|sheenColor",
	"Maya|sheenRoughness",
	"Maya|specular",
	"Maya|specularAnisotropy",
	"Maya|specularColor",
	"Maya|specularIOR",
	"Maya|specularRotation",
	"Maya|specularRoughness",
	"Maya|subsurface",
	"Maya|subsurfaceAnisotropy",
	"Maya|subsurfaceColor",
	"Maya|subsurfaceRadius",
	"Maya|subsurfaceScale",
	"Maya|subsurfaceType",
	"Maya|tangent",
	"Maya|thinFilmIOR",
	"Maya|thinFilmThickness",
	"Maya|thinWalled",
	"Maya|transmission",
	"Maya|transmissionColor",
	"Maya|transmissionDepth",
	"Maya|transmissionDispersion",
	"Maya|transmissionExtraRoughness",
	"Maya|transmissionScatter",
	"Maya|transmissionScatterAnisotropy",
	"Maya|transmitAovs",
	"Maya|use_ao_map",
	"Maya|use_color_map",
	"Maya|use_emissive_map",
	"Maya|use_metallic_map",
	"Maya|use_normal_map",
	"Maya|use_roughness_map",
	"Maya|uv_offset",
	"Maya|uv_scale",
	"MentalRay",
	"MentalRaySL",
	"MeshColor",
	"MinHSize",
	"MinWSize",
	"MirrorMode",
	"MoBuAttrBlindData",
	"MoBuObjectFullName",
	"MoBuRelationBlindData",
	"MoBuSubTypeName",
	"MoBuTypeName",
	"Model::&quot;",
	"Model::&quot;'&&quot;",
	"Model::20 Sided",
	"Model::8 Sided",
	"Model::A",
	"Model::Aim",
	"Model::Armature",
	"Model::ArrowX",
	"Model::ArrowY",
	"Model::ArrowZ",
	"Model::B",
	"Model::Bezier",
	"Model::Blue",
	"Model::Bone",
	"Model::Bone001",
	"Model::Bone002",
	"Model::Bone003",
	"Model::Bone004",
	"Model::Bone005",
	"Model::Bone_001",
	"Model::Bone_002",
	"Model::Bone_003",
	"Model::Bottom",
	"Model::Box001",
	"Model::Box002",
	"Model::Box003",
	"Model::Box004",
	"Model::Box01",
	"Model::C",
	"Model::Camera",
	"Model::Camera Switcher",
	"Model::Camera001",
	"Model::Camera01",
	"Model::Character1_Ctrl_ChestEndEffector",
	"Model::Character1_Ctrl_ChestOriginEffector",
	"Model::Character1_Ctrl_Head",
	"Model::Character1_Ctrl_HeadEffector",
	"Model::Character1_Ctrl_Hips",
	"Model::Character1_Ctrl_HipsEffector",
	"Model::Character1_Ctrl_LeftAnkleEffector",
	"Model::Character1_Ctrl_LeftArm",
	"Model::Character1_Ctrl_LeftElbowEffector",
	"Model::Character1_Ctrl_LeftFoot",
	"Model::Character1_Ctrl_LeftFootEffector",
	"Model::Character1_Ctrl_LeftForeArm",
	"Model::Character1_Ctrl_LeftHand",
	"Model::Character1_Ctrl_LeftHandIndex1",
	"Model::Character1_Ctrl_LeftHandIndex2",
	"Model::Character1_Ctrl_LeftHandIndex3",
	"Model::Character1_Ctrl_LeftHandIndex4",
	"Model::Character1_Ctrl_LeftHandIndexEffector",
	"Model::Character1_Ctrl_LeftHandMiddle1",
	"Model::Character1_Ctrl_LeftHandMiddle2",
	"Model::Character1_Ctrl_LeftHandMiddle3",
	"Model::Character1_Ctrl_LeftHandMiddle4",
	"Model::Character1_Ctrl_LeftHandMiddleEffector",
	"Model::Character1_Ctrl_LeftHandPinky1",
	"Model::Character1_Ctrl_LeftHandPinky2",
	"Model::Character1_Ctrl_LeftHandPinky3",
	"Model::Character1_Ctrl_LeftHandPinky4",
	"Model::Character1_Ctrl_LeftHandPinkyEffector",
	"Model::Character1_Ctrl_LeftHandRing1",
	"Model::Character1_Ctrl_LeftHandRing2",
	"Model::Character1_Ctrl_LeftHandRing3",
	"Model::Character1_Ctrl_LeftHandRing4",
	"Model::Character1_Ctrl_LeftHandRingEffector",
	"Model::Character1_Ctrl_LeftHandThumb1",
	"Model::Character1_Ctrl_LeftHandThumb2",
	"Model::Character1_Ctrl_LeftHandThumb3",
	"Model::Character1_Ctrl_LeftHandThumb4",
	"Model::Character1_Ctrl_LeftHandThumbEffector",
	"Model::Character1_Ctrl_LeftHipEffector",
	"Model::Character1_Ctrl_LeftKneeEffector",
	"Model::Character1_Ctrl_LeftLeg",
	"Model::Character1_Ctrl_LeftShoulder",
	"Model::Character1_Ctrl_LeftShoulderEffector",
	"Model::Character1_Ctrl_LeftToeBase",
	"Model::Character1_Ctrl_LeftUpLeg",
	"Model::Character1_Ctrl_LeftWristEffector",
	"Model::Character1_Ctrl_Neck",
	"Model::Character1_Ctrl_Reference",
	"Model::Character1_Ctrl_RightAnkleEffector",
	"Model::Character1_Ctrl_RightArm",
	"Model::Character1_Ctrl_RightElbowEffector",
	"Model::Character1_Ctrl_RightFoot",
	"Model::Character1_Ctrl_RightFootEffector",
	"Model::Character1_Ctrl_RightForeArm",
	"Model::Character1_Ctrl_RightHand",
	"Model::Character1_Ctrl_RightHandIndex1",
	"Model::Character1_Ctrl_RightHandIndex2",
	"Model::Character1_Ctrl_RightHandIndex3",
	"Model::Character1_Ctrl_RightHandIndex4",
	"Model::Character1_Ctrl_RightHandIndexEffector",
	"Model::Character1_Ctrl_RightHandMiddle1",
	"Model::Character1_Ctrl_RightHandMiddle2",
	"Model::Character1_Ctrl_RightHandMiddle3",
	"Model::Character1_Ctrl_RightHandMiddle4",
	"Model::Character1_Ctrl_RightHandMiddleEffector",
	"Model::Character1_Ctrl_RightHandPinky1",
	"Model::Character1_Ctrl_RightHandPinky2",
	"Model::Character1_Ctrl_RightHandPinky3",
	"Model::Character1_Ctrl_RightHandPinky4",
	"Model::Character1_Ctrl_RightHandPinkyEffector",
	"Model::Character1_Ctrl_RightHandRing1",
	"Model::Character1_Ctrl_RightHandRing2",
	"Model::Character1_Ctrl_RightHandRing3",
	"Model::Character1_Ctrl_RightHandRing4",
	"Model::Character1_Ctrl_RightHandRingEffector",
	"Model::Character1_Ctrl_RightHandThumb1",
	"Model::Character1_Ctrl_RightHandThumb2",
	"Model::Character1_Ctrl_RightHandThumb3",
	"Model::Character1_Ctrl_RightHandThumb4",
	"Model::Character1_Ctrl_RightHandThumbEffector",
	"Model::Character1_Ctrl_RightHipEffector",
	"Model::Character1_Ctrl_RightKneeEffector",
	"Model::Character1_Ctrl_RightLeg",
	"Model::Character1_Ctrl_RightShoulder",
	"Model::Character1_Ctrl_RightShoulderEffector",
	"Model::Character1_Ctrl_RightToeBase",
	"Model::Character1_Ctrl_RightUpLeg",
	"Model::Character1_Ctrl_RightWristEffector",
	"Model::Character1_Ctrl_Spine",
	"Model::Character1_Ctrl_Spine1",
	"Model::Character1_Ctrl_Spine2",
	"Model::Character1_Head",
	"Model::Character1_Hips",
	"Model::Character1_LeftArm",
	"Model::Character1_LeftFoot",
	"Model::Character1_LeftForeArm",
	"Model::Character1_LeftHand",
	"Model::Character1_LeftHandIndex1",
	"Model::Character1_LeftHandIndex2",
	"Model::Character1_LeftHandIndex3",
	"Model::Character1_LeftHandIndex4",
	"Model::Character1_LeftHandMiddle1",
	"Model::Character1_LeftHandMiddle2",
	"Model::Character1_LeftHandMiddle3",
	"Model::Character1_LeftHandMiddle4",
	"Model::Character1_LeftHandPinky1",
	"Model::Character1_LeftHandPinky2",
	"Model::Character1_LeftHandPinky3",
	"Model::Character1_LeftHandPinky4",
	"Model::Character1_LeftHandRing1",
	"Model::Character1_LeftHandRing2",
	"Model::Character1_LeftHandRing3",
	"Model::Character1_LeftHandRing4",
	"Model::Character1_LeftHandThumb1",
	"Model::Character1_LeftHandThumb2",
	"Model::Character1_LeftHandThumb3",
	"Model::Character1_LeftHandThumb4",
	"Model::Character1_LeftLeg",
	"Model::Character1_LeftShoulder",
	"Model::Character1_LeftToeBase",
	"Model::Character1_LeftUpLeg",
	"Model::Character1_Neck",
	"Model::Character1_Reference",
	"Model::Character1_RightArm",
	"Model::Character1_RightFoot",
	"Model::Character1_RightForeArm",
	"Model::Character1_RightHand",
	"Model::Character1_RightHandIndex1",
	"Model::Character1_RightHandIndex2",
	"Model::Character1_RightHandIndex3",
	"Model::Character1_RightHandIndex4",
	"Model::Character1_RightHandMiddle1",
	"Model::Character1_RightHandMiddle2",
	"Model::Character1_RightHandMiddle3",
	"Model::Character1_RightHandMiddle4",
	"Model::Character1_RightHandPinky1",
	"Model::Character1_RightHandPinky2",
	"Model::Character1_RightHandPinky3",
	"Model::Character1_RightHandPinky4",
	"Model::Character1_RightHandRing1",
	"Model::Character1_RightHandRing2",
	"Model::Character1_RightHandRing3",
	"Model::Character1_RightHandRing4",
	"Model::Character1_RightHandThumb1",
	"Model::Character1_RightHandThumb2",
	"Model::Character1_RightHandThumb3",
	"Model::Character1_RightHandThumb4",
	"Model::Character1_RightLeg",
	"Model::Character1_RightShoulder",
	"Model::Character1_RightToeBase",
	"Model::Character1_RightUpLeg",
	"Model::Character1_Spine",
	"Model::Character1_Spine1",
	"Model::Character1_Spine2",
	"Model::Child",
	"Model::Child_",
	"Model::Circle",
	"Model::Cube",
	"Model::Cube::Model",
	"Model::Curve001",
	"Model::Cylinder001",
	"Model::D",
	"Model::FDirect02",
	"Model::Fill",
	"Model::First",
	"Model::Fspot01",
	"Model::Green",
	"Model::Horizontal",
	"Model::IKHandle",
	"Model::IKTarget",
	"Model::Icosphere",
	"Model::LOD_0",
	"Model::LOD_0_ncl1_1",
	"Model::LOD_1",
	"Model::LOD_1_ncl1_1",
	"Model::LOD_2",
	"Model::LOD_2_ncl1_1",
	"Model::LOD_Group_1",
	"Model::LOD_Group_2",
	"Model::Lamp",
	"Model::Left",
	"Model::Left_Tip",
	"Model::Light",
	"Model::Line",
	"Model::Line001",
	"Model::LodGroup",
	"Model::Mesh",
	"Model::Mid",
	"Model::Middle",
	"Model::Node",
	"Model::NodeA",
	"Model::NodeB",
	"Model::NodeC",
	"Model::NodeFree",
	"Model::Null",
	"Model::Nurbs",
	"Model::NurbsCurve",
	"Model::NurbsSurface",
	"Model::NurbsTrim",
	"Model::Omni01",
	"Model::Omni1",
	"Model::Ortho_10",
	"Model::Ortho_100",
	"Model::Ortho_30",
	"Model::Ortho_35",
	"Model::Overscan",
	"Model::Parent",
	"Model::ParentA",
	"Model::ParentB",
	"Model::Plane",
	"Model::Plane001",
	"Model::PointConstant",
	"Model::PointCubic",
	"Model::PointLinear",
	"Model::PointQuadratic",
	"Model::Pole",
	"Model::PolyMesh3D1",
	"Model::PolySphere",
	"Model::Polyline",
	"Model::Position",
	"Model::Producer Back",
	"Model::Producer Bottom",
	"Model::Producer Front",
	"Model::Producer Left",
	"Model::Producer Perspective",
	"Model::Producer Right",
	"Model::Producer Top",
	"Model::Pyramid04",
	"Model::Pyramid05",
	"Model::Pyramid06",
	"Model::Pyramid07",
	"Model::Pyramid08",
	"Model::Pyramid09",
	"Model::Pyramid10",
	"Model::Pyramid11",
	"Model::Pyramid12",
	"Model::Pyramid13",
	"Model::Pyramid14",
	"Model::Pyramid15",
	"Model::Pyramid16",
	"Model::Pyramid17",
	"Model::Pyramid18",
	"Model::Pyramid19",
	"Model::Red",
	"Model::Right",
	"Model::Right_Tip",
	"Model::Root",
	"Model::Scale",
	"Model::Skeleton",
	"Model::Skin",
	"Model::Slime_002:Ctrl_bottom",
	"Model::Slime_002:Ctrl_master",
	"Model::Slime_002:Ctrl_middle",
	"Model::Slime_002:Ctrl_top",
	"Model::Slime_002:Slime_Body_high",
	"Model::Slime_002:Slime_Body_low",
	"Model::Slime_002:bnd_bottom",
	"Model::Slime_002:bnd_middle",
	"Model::Slime_002:bnd_top",
	"Model::Slime_002:grpCtrl_bottom",
	"Model::Slime_002:grpCtrl_middle",
	"Model::Slime_002:grpCtrl_top",
	"Model::Slime_002:grp_Ctrl",
	"Model::Slime_002:grp_Slime",
	"Model::Slime_002:grp_geo",
	"Model::Slime_002:grp_joint",
	"Model::SpotConstant",
	"Model::SpotCubic",
	"Model::SpotLinear",
	"Model::SpotLook",
	"Model::SpotQuadratic",
	"Model::StereoCamera",
	"Model::Surface001",
	"Model::TargetA",
	"Model::TargetB",
	"Model::Top",
	"Model::Up",
	"Model::Vertical",
	"Model::X",
	"Model::XYZ",
	"Model::XZY",
	"Model::Y",
	"Model::YXZ",
	"Model::YZX",
	"Model::Z",
	"Model::ZXY",
	"Model::ZYX",
	"Model::a___",
	"Model::a",
	"Model::circleClosed",
	"Model::circleOpen",
	"Model::circlePeriodic",
	"Model::curve1",
	"Model::forwardCamera",
	"Model::forwardLight",
	"Model::joint1",
	"Model::joint10",
	"Model::joint11",
	"Model::joint2",
	"Model::joint3",
	"Model::joint4",
	"Model::joint5",
	"Model::joint6",
	"Model::joint7",
	"Model::joint8",
	"Model::joint9",
	"Model::marvelous_quad",
	"Model::nurbsPlane1",
	"Model::nurbsSphere1",
	"Model::pCone1",
	"Model::pCube1",
	"Model::pCube2",
	"Model::pCube3",
	"Model::pDisc1",
	"Model::pPlane1",
	"Model::pPlatonic1",
	"Model::pPlatonic1_ncl1_1",
	"Model::pPlatonic1_ncl1_2",
	"Model::pSphere1",
	"Model::pSphere1_ncl1_1",
	"Model::pointLight1",
	"Model::pointLight2",
	"Model::sine1Handle",
	"Model::squash1Handle",
	"Model::transform1",
	"Model::transform2",
	"Model::transform3",
	"Model::transform4",
	"ModelView",
	"ModelView0",
	"ModelView1",
	"ModelView2",
	"ModelView3",
	"Modulate",
	"Morph",
	"Motion Blur Intensity",
	"MotionBuilder",
	"MotionBuilder_Generic",
	"MotionBuilder_System",
	"MultiLayer",
	"MultiTake",
	"Mute",
	"Muted",
	"MutedByParent",
	"MutedForSolo",
	"N",
	"NbTakesWithLinks: 0&lf;",
	"NearAttenuationEnd",
	"NearAttenuationStart",
	"Neck",
	"Neck Offset R",
	"Neck Offset T",
	"Neck1",
	"Neck1Link",
	"Neck2",
	"Neck2Link",
	"Neck3",
	"Neck3Link",
	"Neck4",
	"Neck4Link",
	"Neck5",
	"Neck5Link",
	"Neck6",
	"Neck6Link",
	"Neck7",
	"Neck7Link",
	"Neck8",
	"Neck8Link",
	"Neck9",
	"Neck9Link",
	"NeckLink",
	"NeckPosition",
	"NeckReduction",
	"NoMappingInformation",
	"NodeAttribute::",
	"NodeAttribute::Aim_ncl1_1",
	"NodeAttribute::Bone001_ncl1_1",
	"NodeAttribute::Bone002_ncl1_1",
	"NodeAttribute::Bone003_ncl1_1",
	"NodeAttribute::Bone004_ncl1_1",
	"NodeAttribute::Bone005_ncl1_1",
	"NodeAttribute::Bone_ncl1_1",
	"NodeAttribute::Camera",
	"NodeAttribute::Camera Switcher",
	"NodeAttribute::Camera_ncl1_1",
	"NodeAttribute::Character1_Ctrl_ChestEndEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_ChestOriginEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_HeadEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_Head_ncl1_1",
	"NodeAttribute::Character1_Ctrl_HipsEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_Hips_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftAnkleEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftArm_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftElbowEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftFootEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftFoot_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftForeArm_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandIndex1_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandIndex2_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandIndex3_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandIndex4_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandIndexEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandMiddle1_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandMiddle2_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandMiddle3_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandMiddle4_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandMiddleEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandPinky1_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandPinky2_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandPinky3_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandPinky4_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandPinkyEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandRing1_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandRing2_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandRing3_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandRing4_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandRingEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandThumb1_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandThumb2_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandThumb3_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandThumb4_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHandThumbEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHand_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftHipEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftKneeEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftLeg_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftShoulderEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftShoulder_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftToeBase_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftUpLeg_ncl1_1",
	"NodeAttribute::Character1_Ctrl_LeftWristEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_Neck_ncl1_1",
	"NodeAttribute::Character1_Ctrl_Reference_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightAnkleEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightArm_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightElbowEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightFootEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightFoot_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightForeArm_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandIndex1_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandIndex2_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandIndex3_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandIndex4_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandIndexEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandMiddle1_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandMiddle2_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandMiddle3_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandMiddle4_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandMiddleEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandPinky1_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandPinky2_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandPinky3_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandPinky4_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandPinkyEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandRing1_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandRing2_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandRing3_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandRing4_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandRingEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandThumb1_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandThumb2_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandThumb3_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandThumb4_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHandThumbEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHand_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightHipEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightKneeEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightLeg_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightShoulderEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightShoulder_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightToeBase_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightUpLeg_ncl1_1",
	"NodeAttribute::Character1_Ctrl_RightWristEffector_ncl1_1",
	"NodeAttribute::Character1_Ctrl_Spine1_ncl1_1",
	"NodeAttribute::Character1_Ctrl_Spine2_ncl1_1",
	"NodeAttribute::Character1_Ctrl_Spine_ncl1_1",
	"NodeAttribute::Character1_Head_ncl1_1",
	"NodeAttribute::Character1_Hips_ncl1_1",
	"NodeAttribute::Character1_LeftArm_ncl1_1",
	"NodeAttribute::Character1_LeftFoot_ncl1_1",
	"NodeAttribute::Character1_LeftForeArm_ncl1_1",
	"NodeAttribute::Character1_LeftHandIndex1_ncl1_1",
	"NodeAttribute::Character1_LeftHandIndex2_ncl1_1",
	"NodeAttribute::Character1_LeftHandIndex3_ncl1_1",
	"NodeAttribute::Character1_LeftHandIndex4_ncl1_1",
	"NodeAttribute::Character1_LeftHandMiddle1_ncl1_1",
	"NodeAttribute::Character1_LeftHandMiddle2_ncl1_1",
	"NodeAttribute::Character1_LeftHandMiddle3_ncl1_1",
	"NodeAttribute::Character1_LeftHandMiddle4_ncl1_1",
	"NodeAttribute::Character1_LeftHandPinky1_ncl1_1",
	"NodeAttribute::Character1_LeftHandPinky2_ncl1_1",
	"NodeAttribute::Character1_LeftHandPinky3_ncl1_1",
	"NodeAttribute::Character1_LeftHandPinky4_ncl1_1",
	"NodeAttribute::Character1_LeftHandRing1_ncl1_1",
	"NodeAttribute::Character1_LeftHandRing2_ncl1_1",
	"NodeAttribute::Character1_LeftHandRing3_ncl1_1",
	"NodeAttribute::Character1_LeftHandRing4_ncl1_1",
	"NodeAttribute::Character1_LeftHandThumb1_ncl1_1",
	"NodeAttribute::Character1_LeftHandThumb2_ncl1_1",
	"NodeAttribute::Character1_LeftHandThumb3_ncl1_1",
	"NodeAttribute::Character1_LeftHandThumb4_ncl1_1",
	"NodeAttribute::Character1_LeftHand_ncl1_1",
	"NodeAttribute::Character1_LeftLeg_ncl1_1",
	"NodeAttribute::Character1_LeftShoulder_ncl1_1",
	"NodeAttribute::Character1_LeftToeBase_ncl1_1",
	"NodeAttribute::Character1_LeftUpLeg_ncl1_1",
	"NodeAttribute::Character1_Neck_ncl1_1",
	"NodeAttribute::Character1_Reference_ncl1_1",
	"NodeAttribute::Character1_RightArm_ncl1_1",
	"NodeAttribute::Character1_RightFoot_ncl1_1",
	"NodeAttribute::Character1_RightForeArm_ncl1_1",
	"NodeAttribute::Character1_RightHandIndex1_ncl1_1",
	"NodeAttribute::Character1_RightHandIndex2_ncl1_1",
	"NodeAttribute::Character1_RightHandIndex3_ncl1_1",
	"NodeAttribute::Character1_RightHandIndex4_ncl1_1",
	"NodeAttribute::Character1_RightHandMiddle1_ncl1_1",
	"NodeAttribute::Character1_RightHandMiddle2_ncl1_1",
	"NodeAttribute::Character1_RightHandMiddle3_ncl1_1",
	"NodeAttribute::Character1_RightHandMiddle4_ncl1_1",
	"NodeAttribute::Character1_RightHandPinky1_ncl1_1",
	"NodeAttribute::Character1_RightHandPinky2_ncl1_1",
	"NodeAttribute::Character1_RightHandPinky3_ncl1_1",
	"NodeAttribute::Character1_RightHandPinky4_ncl1_1",
	"NodeAttribute::Character1_RightHandRing1_ncl1_1",
	"NodeAttribute::Character1_RightHandRing2_ncl1_1",
	"NodeAttribute::Character1_RightHandRing3_ncl1_1",
	"NodeAttribute::Character1_RightHandRing4_ncl1_1",
	"NodeAttribute::Character1_RightHandThumb1_ncl1_1",
	"NodeAttribute::Character1_RightHandThumb2_ncl1_1",
	"NodeAttribute::Character1_RightHandThumb3_ncl1_1",
	"NodeAttribute::Character1_RightHandThumb4_ncl1_1",
	"NodeAttribute::Character1_RightHand_ncl1_1",
	"NodeAttribute::Character1_RightLeg_ncl1_1",
	"NodeAttribute::Character1_RightShoulder_ncl1_1",
	"NodeAttribute::Character1_RightToeBase_ncl1_1",
	"NodeAttribute::Character1_RightUpLeg_ncl1_1",
	"NodeAttribute::Character1_Spine1_ncl1_1",
	"NodeAttribute::Character1_Spine2_ncl1_1",
	"NodeAttribute::Character1_Spine_ncl1_1",
	"NodeAttribute::FDirect02",
	"NodeAttribute::Fill",
	"NodeAttribute::Fill_ncl1_1",
	"NodeAttribute::Horizontal",
	"NodeAttribute::Horizontal_ncl1_1",
	"NodeAttribute::IKHandle_ncl1_1",
	"NodeAttribute::IKTarget_ncl1_1",
	"NodeAttribute::LOD_0_ncl1_1",
	"NodeAttribute::LOD_0_ncl1_2",
	"NodeAttribute::LOD_0_ncl1_3",
	"NodeAttribute::LOD_1_ncl1_1",
	"NodeAttribute::LOD_1_ncl1_2",
	"NodeAttribute::LOD_1_ncl1_3",
	"NodeAttribute::LOD_2_ncl1_2",
	"NodeAttribute::LOD_2_ncl1_3",
	"NodeAttribute::LOD_Group_1_ncl1_1",
	"NodeAttribute::LOD_Group_2_ncl1_1",
	"NodeAttribute::Light_ncl1_1",
	"NodeAttribute::LodGroup_ncl1_1",
	"NodeAttribute::Null_ncl1_1",
	"NodeAttribute::Ortho_10",
	"NodeAttribute::Ortho_100",
	"NodeAttribute::Ortho_100_ncl1_1",
	"NodeAttribute::Ortho_10_ncl1_1",
	"NodeAttribute::Ortho_30",
	"NodeAttribute::Ortho_30_ncl1_1",
	"NodeAttribute::Ortho_35",
	"NodeAttribute::Ortho_35_ncl1_1",
	"NodeAttribute::Overscan",
	"NodeAttribute::Overscan_ncl1_1",
	"NodeAttribute::Parent_ncl1_1",
	"NodeAttribute::PointConstant",
	"NodeAttribute::PointCubic",
	"NodeAttribute::PointLinear",
	"NodeAttribute::PointQuadratic",
	"NodeAttribute::Pole_ncl1_1",
	"NodeAttribute::Position_ncl1_1",
	"NodeAttribute::Producer Back",
	"NodeAttribute::Producer Bottom",
	"NodeAttribute::Producer Front",
	"NodeAttribute::Producer Left",
	"NodeAttribute::Producer Perspective",
	"NodeAttribute::Producer Right",
	"NodeAttribute::Producer Top",
	"NodeAttribute::Scale_ncl1_1",
	"NodeAttribute::SpotConstant",
	"NodeAttribute::SpotCubic",
	"NodeAttribute::SpotLinear",
	"NodeAttribute::SpotLook",
	"NodeAttribute::SpotQuadratic",
	"NodeAttribute::StereoCamera",
	"NodeAttribute::StereoCamera_ncl1_1",
	"NodeAttribute::StereoLeftShape",
	"NodeAttribute::StereoRightShape",
	"NodeAttribute::Up_ncl1_1",
	"NodeAttribute::Vertical",
	"NodeAttribute::Vertical_ncl1_1",
	"NodeAttribute::_ncl1_1",
	"NodeAttribute::_ncl1_2",
	"NodeAttribute::_ncl1_3",
	"NodeAttribute::forwardCamera",
	"NodeAttribute::forwardCamera_ncl1_1",
	"NodeAttribute::forwardLight_ncl1_1",
	"NodeAttribute::joint10_ncl1_1",
	"NodeAttribute::joint11_ncl1_1",
	"NodeAttribute::joint1_ncl1_1",
	"NodeAttribute::joint2_ncl1_1",
	"NodeAttribute::joint3_ncl1_1",
	"NodeAttribute::joint4_ncl1_1",
	"NodeAttribute::joint5_ncl1_1",
	"NodeAttribute::joint6_ncl1_1",
	"NodeAttribute::joint7_ncl1_1",
	"NodeAttribute::joint8_ncl1_1",
	"NodeAttribute::joint9_ncl1_1",
	"NodeAttribute::pointLight1_ncl1_1",
	"NodeAttribute::pointLight2_ncl1_1",
	"NodeAttribute::sine1Handle_ncl1_1",
	"NodeAttribute::squash1Handle_ncl1_1",
	"None",
	"Normal",
	"NurbsSetIndex",
	"OBS Virtual Camera",
	"Offset",
	"Online",
	"Opacity",
	"OpticalCenterX",
	"OpticalCenterY",
	"OrientationDamping",
	"OrientationDampingMode",
	"Original",
	"Original|ApplicationActiveProject",
	"Original|ApplicationNativeFile",
	"Original|DateTime_GMT",
	"Original|FileName",
	"OuterBoundary",
	"Output",
	"OutputMarkerSet",
	"Over",
	"Overscan",
	"PHYSICAL_MTL",
	"PaneCount",
	"Parent.Offset R",
	"Parent.Offset T",
	"Parent.Weight",
	"ParentA.Offset R",
	"ParentA.Offset T",
	"ParentA.Weight",
	"ParentB.Offset R",
	"ParentB.Offset T",
	"ParentB.Weight",
	"ParentCollapseVisibility",
	"Path",
	"PerFace",
	"Pickable",
	"PickingEnabled",
	"PivotColor",
	"PivotSize",
	"PivotsVisibility",
	"PixelAspectRatio",
	"PlaySpeed",
	"Pole.Weight",
	"PoleVector",
	"PolyMesh3D1_TXTR.tga",
	"Pose::BIND_POSES",
	"Pose::Slime_002:skinCluster1",
	"Pose::skinCluster1",
	"Poses",
	"Position",
	"Position.Weight",
	"Posture",
	"PreScale",
	"PrecompFileName",
	"PremultiplyAlpha",
	"Primary Visibility",
	"Producer Front",
	"Producer Left",
	"Producer Perspective",
	"Producer Top",
	"Props0Link",
	"Props1Link",
	"Props2Link",
	"Props3Link",
	"Props4Link",
	"PullIterationCount",
	"Python Tool Manager",
	"RGBCube",
	"RandomTilingBitmap",
	"ReachActorChest",
	"ReachActorChestRotation",
	"ReachActorHead",
	"ReachActorHeadRotation",
	"ReachActorLeftAnkle",
	"ReachActorLeftAnkleRotation",
	"ReachActorLeftElbow",
	"ReachActorLeftFingerBase",
	"ReachActorLeftFingerBaseRotation",
	"ReachActorLeftKnee",
	"ReachActorLeftToesBase",
	"ReachActorLeftToesBaseRotation",
	"ReachActorLeftWrist",
	"ReachActorLeftWristRotation",
	"ReachActorLowerChestRotation",
	"ReachActorRightAnkle",
	"ReachActorRightAnkleRotation",
	"ReachActorRightElbow",
	"ReachActorRightFingerBase",
	"ReachActorRightFingerBaseRotation",
	"ReachActorRightKnee",
	"ReachActorRightToesBase",
	"ReachActorRightToesBaseRotation",
	"ReachActorRightWrist",
	"ReachActorRightWristRotation",
	"ReadOnly",
	"RealisticShoulder",
	"Receive Shadows",
	"RecordAudio",
	"RecordClipPath",
	"RecordPath",
	"RecordToFile",
	"ReferenceLink",
	"ReferenceProperty",
	"ReferentialSize",
	"Reflectivity",
	"RelPath",
	"RelativePrecompFileName",
	"RenderAPIVersion",
	"RenderCallbackIndex",
	"RenderCallbackPrefIndex",
	"Renderable",
	"Renderer",
	"Renderer::Renderer",
	"RenderingHints",
	"ResetCamera",
	"ResetLight",
	"ResolutionFR",
	"ResolutionMode",
	"Right Ankle Offset R",
	"Right Ankle Offset T",
	"Right Collar Offset R",
	"Right Collar Offset T",
	"Right Elbow Offset R",
	"Right Elbow Offset T",
	"Right Foot Offset R",
	"Right Foot Offset T",
	"Right Hip Offset R",
	"Right Hip Offset T",
	"Right Index A Offset R",
	"Right Index A Offset T",
	"Right Index B Offset R",
	"Right Index B Offset T",
	"Right Index C Offset R",
	"Right Index C Offset T",
	"Right Knee Offset R",
	"Right Knee Offset T",
	"Right Middle A Offset R",
	"Right Middle A Offset T",
	"Right Middle B Offset R",
	"Right Middle B Offset T",
	"Right Middle C Offset R",
	"Right Middle C Offset T",
	"Right Pinky A Offset R",
	"Right Pinky A Offset T",
	"Right Pinky B Offset R",
	"Right Pinky B Offset T",
	"Right Pinky C Offset R",
	"Right Pinky C Offset T",
	"Right Ring A Offset R",
	"Right Ring A Offset T",
	"Right Ring B Offset R",
	"Right Ring B Offset T",
	"Right Ring C Offset R",
	"Right Ring C Offset T",
	"Right Shoulder Offset R",
	"Right Shoulder Offset T",
	"Right Thumb A Offset R",
	"Right Thumb A Offset T",
	"Right Thumb B Offset R",
	"Right Thumb B Offset T",
	"Right Thumb C Offset R",
	"Right Thumb C Offset T",
	"Right Wrist Offset R",
	"Right Wrist Offset T",
	"RightAnkleEffector",
	"RightAnkleEffectorRPin",
	"RightAnkleEffectorTPin",
	"RightAnklePosition",
	"RightArm",
	"RightArmFullRollExtraction",
	"RightArmLink",
	"RightArmMaxExtensionAngle",
	"RightArmRoll",
	"RightArmRollEx",
	"RightArmRollExLink",
	"RightArmRollExMode",
	"RightArmRollLink",
	"RightArmRollMode",
	"RightBarnDoor",
	"RightCollarPosition",
	"RightElbowEffector",
	"RightElbowEffectorRPin",
	"RightElbowEffectorTPin",
	"RightElbowKillPitch",
	"RightElbowPosition",
	"RightFingerBase",
	"RightFingerBaseLink",
	"RightFloorContact",
	"RightFloorContactLink",
	"RightFoot",
	"RightFootEffector",
	"RightFootEffectorRPin",
	"RightFootEffectorTPin",
	"RightFootExtraFinger1",
	"RightFootExtraFinger1Link",
	"RightFootExtraFinger2",
	"RightFootExtraFinger2Link",
	"RightFootExtraFinger3",
	"RightFootExtraFinger3Link",
	"RightFootExtraFinger4",
	"RightFootExtraFinger4Link",
	"RightFootExtraFingerEffector",
	"RightFootExtraFingerTip",
	"RightFootIndex1",
	"RightFootIndex1Link",
	"RightFootIndex2",
	"RightFootIndex2Link",
	"RightFootIndex3",
	"RightFootIndex3Link",
	"RightFootIndex4",
	"RightFootIndex4Link",
	"RightFootIndexEffector",
	"RightFootIndexTip",
	"RightFootLink",
	"RightFootMiddle1",
	"RightFootMiddle1Link",
	"RightFootMiddle2",
	"RightFootMiddle2Link",
	"RightFootMiddle3",
	"RightFootMiddle3Link",
	"RightFootMiddle4",
	"RightFootMiddle4Link",
	"RightFootMiddleEffector",
	"RightFootMiddleTip",
	"RightFootPinky1",
	"RightFootPinky1Link",
	"RightFootPinky2",
	"RightFootPinky2Link",
	"RightFootPinky3",
	"RightFootPinky3Link",
	"RightFootPinky4",
	"RightFootPinky4Link",
	"RightFootPinkyEffector",
	"RightFootPinkyTip",
	"RightFootPosition",
	"RightFootRing1",
	"RightFootRing1Link",
	"RightFootRing2",
	"RightFootRing2Link",
	"RightFootRing3",
	"RightFootRing3Link",
	"RightFootRing4",
	"RightFootRing4Link",
	"RightFootRingEffector",
	"RightFootRingTip",
	"RightFootThumb1",
	"RightFootThumb1Link",
	"RightFootThumb2",
	"RightFootThumb2Link",
	"RightFootThumb3",
	"RightFootThumb3Link",
	"RightFootThumb4",
	"RightFootThumb4Link",
	"RightFootThumbEffector",
	"RightFootThumbTip",
	"RightForeArm",
	"RightForeArmLink",
	"RightForeArmRoll",
	"RightForeArmRollEx",
	"RightForeArmRollExLink",
	"RightForeArmRollExMode",
	"RightForeArmRollLink",
	"RightForeArmRollMode",
	"RightGlove",
	"RightHand",
	"RightHandEffector",
	"RightHandExtraFinger1",
	"RightHandExtraFinger1Link",
	"RightHandExtraFinger2",
	"RightHandExtraFinger2Link",
	"RightHandExtraFinger3",
	"RightHandExtraFinger3Link",
	"RightHandExtraFinger4",
	"RightHandExtraFinger4Link",
	"RightHandExtraFingerEffector",
	"RightHandExtraFingerTip",
	"RightHandFloorContactLink",
	"RightHandIndex1",
	"RightHandIndex1Link",
	"RightHandIndex2",
	"RightHandIndex2Link",
	"RightHandIndex3",
	"RightHandIndex3Link",
	"RightHandIndex4",
	"RightHandIndex4Link",
	"RightHandIndexEffector",
	"RightHandIndexEffectorRPin",
	"RightHandIndexEffectorTPin",
	"RightHandIndexIndex",
	"RightHandIndexMiddle",
	"RightHandIndexPinky",
	"RightHandIndexRing",
	"RightHandIndexTip",
	"RightHandLink",
	"RightHandMiddle1",
	"RightHandMiddle1Link",
	"RightHandMiddle2",
	"RightHandMiddle2Link",
	"RightHandMiddle3",
	"RightHandMiddle3Link",
	"RightHandMiddle4",
	"RightHandMiddle4Link",
	"RightHandMiddleEffector",
	"RightHandMiddleEffectorRPin",
	"RightHandMiddleEffectorTPin",
	"RightHandMiddleIndex",
	"RightHandMiddleMiddle",
	"RightHandMiddlePinky",
	"RightHandMiddleRing",
	"RightHandMiddleTip",
	"RightHandPinky1",
	"RightHandPinky1Link",
	"RightHandPinky2",
	"RightHandPinky2Link",
	"RightHandPinky3",
	"RightHandPinky3Link",
	"RightHandPinky4",
	"RightHandPinky4Link",
	"RightHandPinkyEffector",
	"RightHandPinkyEffectorRPin",
	"RightHandPinkyEffectorTPin",
	"RightHandPinkyIndex",
	"RightHandPinkyMiddle",
	"RightHandPinkyPinky",
	"RightHandPinkyRing",
	"RightHandPinkyTip",
	"RightHandRing1",
	"RightHandRing1Link",
	"RightHandRing2",
	"RightHandRing2Link",
	"RightHandRing3",
	"RightHandRing3Link",
	"RightHandRing4",
	"RightHandRing4Link",
	"RightHandRingEffector",
	"RightHandRingEffectorRPin",
	"RightHandRingEffectorTPin",
	"RightHandRingIndex",
	"RightHandRingMiddle",
	"RightHandRingPinky",
	"RightHandRingRing",
	"RightHandRingTip",
	"RightHandThumb1",
	"RightHandThumb1Link",
	"RightHandThumb2",
	"RightHandThumb2Link",
	"RightHandThumb3",
	"RightHandThumb3Link",
	"RightHandThumb4",
	"RightHandThumb4Link",
	"RightHandThumbEffector",
	"RightHandThumbEffectorRPin",
	"RightHandThumbEffectorTPin",
	"RightHandThumbTip",
	"RightHipEffector",
	"RightHipEffectorRPin",
	"RightHipEffectorTPin",
	"RightHipPosition",
	"RightInFootExtraFinger",
	"RightInFootExtraFingerLink",
	"RightInFootIndex",
	"RightInFootIndexLink",
	"RightInFootMiddle",
	"RightInFootMiddleLink",
	"RightInFootPinky",
	"RightInFootPinkyLink",
	"RightInFootRing",
	"RightInFootRingLink",
	"RightInFootThumb",
	"RightInFootThumbLink",
	"RightInHandExtraFinger",
	"RightInHandExtraFingerLink",
	"RightInHandIndex",
	"RightInHandIndexLink",
	"RightInHandMiddle",
	"RightInHandMiddleLink",
	"RightInHandPinky",
	"RightInHandPinkyLink",
	"RightInHandRing",
	"RightInHandRingLink",
	"RightInHandThumb",
	"RightInHandThumbLink",
	"RightKneeEffector",
	"RightKneeEffectorRPin",
	"RightKneeEffectorTPin",
	"RightKneeKillPitch",
	"RightKneePosition",
	"RightLeg",
	"RightLegFullRollExtraction",
	"RightLegLink",
	"RightLegMaxExtensionAngle",
	"RightLegRoll",
	"RightLegRollEx",
	"RightLegRollExLink",
	"RightLegRollExMode",
	"RightLegRollLink",
	"RightLegRollMode",
	"RightShoulder",
	"RightShoulderEffector",
	"RightShoulderEffectorRPin",
	"RightShoulderEffectorTPin",
	"RightShoulderExtra",
	"RightShoulderExtraLink",
	"RightShoulderLink",
	"RightShoulderPosition",
	"RightToeBase",
	"RightToeBaseLink",
	"RightUpLeg",
	"RightUpLegLink",
	"RightUpLegRoll",
	"RightUpLegRollEx",
	"RightUpLegRollExLink",
	"RightUpLegRollExMode",
	"RightUpLegRollLink",
	"RightUpLegRollMode",
	"RightWristEffector",
	"RightWristEffectorRPin",
	"RightWristEffectorTPin",
	"RightWristPosition",
	"Roll",
	"RollExtractionMode",
	"RootBindingName",
	"RootGroup",
	"RootGroup|LiftTop",
	"RootGroup|MoveToSide",
	"RootGroup|Target",
	"RootGroup|Top",
	"RootGroup|Top|TopH",
	"RootGroup|Top|TopV",
	"RootGroup|X1",
	"Rot0",
	"Rot180",
	"Rot270",
	"Rot90",
	"RotationAxisVisibility",
	"RotationLimitsVisibility",
	"RotationRefVisibility",
	"Row",
	"SFX",
	"SafeAreaAspectRatio",
	"SafeAreaDisplayStyle",
	"Saturation",
	"Scale.Weight",
	"ScaleCompensation",
	"ScaleCompensationMode",
	"ScalingPivotUpdateOffset",
	"ScalingRefVisibility",
	"Scene",
	"SceneInfo::GlobalInfo",
	"Selection",
	"SelectionForceSnapPointsDisplay",
	"SelectionNode::20 Sided_100_SelectionNode",
	"SelectionNode::20 Sided_105_SelectionNode",
	"SelectionNode::20 Sided_10_SelectionNode",
	"SelectionNode::20 Sided_15_SelectionNode",
	"SelectionNode::20 Sided_20_SelectionNode",
	"SelectionNode::20 Sided_25_SelectionNode",
	"SelectionNode::20 Sided_30_SelectionNode",
	"SelectionNode::20 Sided_35_SelectionNode",
	"SelectionNode::20 Sided_40_SelectionNode",
	"SelectionNode::20 Sided_45_SelectionNode",
	"SelectionNode::20 Sided_50_SelectionNode",
	"SelectionNode::20 Sided_55_SelectionNode",
	"SelectionNode::20 Sided_60_SelectionNode",
	"SelectionNode::20 Sided_65_SelectionNode",
	"SelectionNode::20 Sided_70_SelectionNode",
	"SelectionNode::20 Sided_75_SelectionNode",
	"SelectionNode::20 Sided_80_SelectionNode",
	"SelectionNode::20 Sided_85_SelectionNode",
	"SelectionNode::20 Sided_90_SelectionNode",
	"SelectionNode::20 Sided_95_SelectionNode",
	"SelectionNode::8 Sided_10_SelectionNode",
	"SelectionNode::8 Sided_15_SelectionNode",
	"SelectionNode::8 Sided_20_SelectionNode",
	"SelectionNode::8 Sided_25_SelectionNode",
	"SelectionNode::8 Sided_30_SelectionNode",
	"SelectionNode::8 Sided_35_SelectionNode",
	"SelectionNode::8 Sided_40_SelectionNode",
	"SelectionNode::8 Sided_45_SelectionNode",
	"SelectionNode::Box001_BottomEdges_Edge_SelectionNode",
	"SelectionNode::Box001_BottomFace_Face_SelectionNode",
	"SelectionNode::Box001_BottomVerts_Vertex_SelectionNode",
	"SelectionNode::Box001_FullCube_Face_SelectionNode",
	"SelectionNode::Box001_SelectionNode",
	"SelectionNode::Box001_SideFaces_Face_SelectionNode",
	"SelectionNode::Box001_TopEdges_Edge_SelectionNode",
	"SelectionNode::Box001_TopFace_Face_SelectionNode",
	"SelectionNode::Box001_TopVerts_Vertex_SelectionNode",
	"SelectionNode::PolyMesh3D1_15349_SelectionNode",
	"SelectionNode::PolyMesh3D1_9598_SelectionNode",
	"SelectionOverride",
	"SelectionOverrideColor",
	"SelectionOverrideTransparency",
	"SelectionSet::20 Sided_10",
	"SelectionSet::20 Sided_100",
	"SelectionSet::20 Sided_105",
	"SelectionSet::20 Sided_15",
	"SelectionSet::20 Sided_20",
	"SelectionSet::20 Sided_25",
	"SelectionSet::20 Sided_30",
	"SelectionSet::20 Sided_35",
	"SelectionSet::20 Sided_40",
	"SelectionSet::20 Sided_45",
	"SelectionSet::20 Sided_50",
	"SelectionSet::20 Sided_55",
	"SelectionSet::20 Sided_60",
	"SelectionSet::20 Sided_65",
	"SelectionSet::20 Sided_70",
	"SelectionSet::20 Sided_75",
	"SelectionSet::20 Sided_80",
	"SelectionSet::20 Sided_85",
	"SelectionSet::20 Sided_90",
	"SelectionSet::20 Sided_95",
	"SelectionSet::8 Sided_10",
	"SelectionSet::8 Sided_15",
	"SelectionSet::8 Sided_20",
	"SelectionSet::8 Sided_25",
	"SelectionSet::8 Sided_30",
	"SelectionSet::8 Sided_35",
	"SelectionSet::8 Sided_40",
	"SelectionSet::8 Sided_45",
	"SelectionSet::Box001_BottomEdges_Edge",
	"SelectionSet::Box001_BottomFace_Face",
	"SelectionSet::Box001_BottomVerts_Vertex",
	"SelectionSet::Box001_FullCube_Face",
	"SelectionSet::Box001_SideFaces_Face",
	"SelectionSet::Box001_TopEdges_Edge",
	"SelectionSet::Box001_TopFace_Face",
	"SelectionSet::Box001_TopVerts_Vertex",
	"SelectionSet::ObjectCube",
	"SelectionSet::PolyMesh3D1_15349",
	"SelectionSet::PolyMesh3D1_9598",
	"SelectionSetAnnotation",
	"SetPreferedAngle",
	"ShaderLanguage",
	"ShaderLanguageVersion",
	"ShadowColor",
	"Shot",
	"Shot Track",
	"ShoulderCorrection",
	"ShowAudio",
	"ShowAzimut",
	"ShowBackplate",
	"ShowFrontplate",
	"ShowGrid",
	"ShowInfoOnMoving",
	"ShowLabel",
	"ShowManipulators",
	"ShowName",
	"ShowOpticalCenter",
	"ShowTimeCode",
	"ShowTrajectories",
	"Skeleton",
	"SkinContext",
	"Skin_Base_Color.png",
	"SnSNeckFreedom",
	"SnSReachChestEnd",
	"SnSReachHead",
	"SnSReachLeftAnkle",
	"SnSReachLeftWrist",
	"SnSReachRightAnkle",
	"SnSReachRightWrist",
	"SnSScaleArmsAndLegs",
	"SnSScaleNeck",
	"SnSScaleSpine",
	"SnSScaleSpineChildren",
	"SnSSpineFreedom",
	"Snap",
	"Solo",
	"Soloed",
	"SolverType",
	"SourceObject",
	"Spin",
	"Spin.tak",
	"Spine",
	"Spine1",
	"Spine1Link",
	"Spine2",
	"Spine2Link",
	"Spine3",
	"Spine3Link",
	"Spine4",
	"Spine4Link",
	"Spine5",
	"Spine5Link",
	"Spine6",
	"Spine6Link",
	"Spine7",
	"Spine7Link",
	"Spine8",
	"Spine8Link",
	"Spine9",
	"Spine9Link",
	"SpineLink",
	"SrcDocumentUrl",
	"SrcModel",
	"SrcModelReference",
	"Stabilization",
	"StandardSSL",
	"StartFrame",
	"StartHSize",
	"StartWSize",
	"StartXPos",
	"StartYPos",
	"State: 0&lf;ViewMinimized: 0&lf;TrackHeight: 0&lf;",
	"Stereo",
	"StereoCamera",
	"StopFrame",
	"Story root",
	"StretchStartArmsAndLegs",
	"StretchStopArmsAndLegs",
	"SubDeformer::",
	"SubDeformer::Cluster Bone001",
	"SubDeformer::Cluster Bone002",
	"SubDeformer::Cluster Bone003",
	"SubDeformer::Cluster Bone004",
	"SubDeformer::Cluster Bone005",
	"SubDeformer::Cluster Skin Bottom",
	"SubDeformer::Cluster Skin Middle",
	"SubDeformer::Cluster Skin Top",
	"SubDeformer::Cluster joint1",
	"SubDeformer::Cluster joint2",
	"SubDeformer::Cluster joint3",
	"SubDeformer::KeyBlend.LiftTop",
	"SubDeformer::KeyBlend.MoveToSide",
	"SubDeformer::Shape.Target",
	"SubDeformer::Squish.TopH",
	"SubDeformer::Squish.TopV",
	"SubDeformer::blendShape2.X1",
	"Subtract",
	"SyncMode",
	"TEX_ao_map",
	"TEX_brdf_lut",
	"TEX_color_map",
	"TEX_emissive_map",
	"TEX_global_diffuse_cube",
	"TEX_global_specular_cube",
	"TEX_metallic_map",
	"TEX_normal_map",
	"TEX_roughness_map",
	"Take 001",
	"Take_001.tak",
	"TargetA.Weight",
	"TargetB.Weight",
	"TargetName",
	"TargetType",
	"Texture::",
	"Texture::Clouds",
	"Texture::D:/Dev/clean/ufbx/data/marvelous_quad_diffuse_100-1.png",
	"Texture::D:/Dev/clean/ufbx/data/marvelous_quad_normal_100-1.png",
	"Texture::Diffuse Texture",
	"Texture::Map #1",
	"Texture::Map #10",
	"Texture::Map #11",
	"Texture::Map #12",
	"Texture::Map #13",
	"Texture::Map #14",
	"Texture::Map #15",
	"Texture::Map #16",
	"Texture::Map #17",
	"Texture::Map #18",
	"Texture::Map #19",
	"Texture::Map #2",
	"Texture::Map #20",
	"Texture::Map #21",
	"Texture::Map #22",
	"Texture::Map #23",
	"Texture::Map #24",
	"Texture::Map #25",
	"Texture::Map #26",
	"Texture::Map #28",
	"Texture::Map #29",
	"Texture::Map #3",
	"Texture::Map #30",
	"Texture::Map #31",
	"Texture::Map #32",
	"Texture::Map #4",
	"Texture::Map #5",
	"Texture::Map #6",
	"Texture::Map #7",
	"Texture::Map #8",
	"Texture::Map #9",
	"Texture::Slime_002:file1",
	"Texture::file1",
	"Texture::file10",
	"Texture::file2",
	"Texture::file3",
	"Texture::file3_ncl1_1",
	"Texture::file4",
	"Texture::file5",
	"Texture::file6",
	"Texture::file7",
	"Texture::file8",
	"Texture::file9",
	"TextureTypeUse",
	"TextureVideoClip",
	"Thresholds",
	"Thresholds|Level0",
	"Thresholds|Level1",
	"Time",
	"Timeline::Edit root",
	"Timeline::Story root",
	"TimelineTrack::Shot Track",
	"TimelineX",
	"TimelineXTrack",
	"Timelines",
	"ToeInAdjust",
	"Tool",
	"Top",
	"TopBarnDoor",
	"TopH",
	"TopV",
	"Tracks",
	"Transformable",
	"Translucent",
	"Transport",
	"TriTone",
	"True",
	"TurnTable",
	"Twist",
	"U",
	"UH",
	"ULongLong",
	"UVA",
	"UVB",
	"UVChannel_1",
	"UV_Map",
	"Unknown",
	"Unknown::BaseLayer",
	"Unknown::GlobalInfo",
	"Url",
	"Use2DMagnifierZoom",
	"UseAccumulationBuffer",
	"UseAntialiasing",
	"UseAxis",
	"UseDepthOfField",
	"UseFrameColor",
	"UseMaterial",
	"UseMipMap",
	"UseMipMap: 0&lf;",
	"UseMotionBlur",
	"UseRealTimeDOFAndAA",
	"UseRealTimeMotionBlur",
	"UserData",
	"Vector2",
	"Vector2D",
	"VectorAdd",
	"VectorDisplacementColor",
	"Video Output 1",
	"Video::Clouds",
	"Video::D:/Dev/clean/ufbx/data/marvelous_quad_diffuse_100-1.png",
	"Video::D:/Dev/clean/ufbx/data/marvelous_quad_normal_100-1.png",
	"Video::Diffuse Texture",
	"Video::Elgato Screen Link",
	"Video::Logi Capture",
	"Video::Map #1",
	"Video::Map #10",
	"Video::Map #11",
	"Video::Map #12",
	"Video::Map #13",
	"Video::Map #14",
	"Video::Map #15",
	"Video::Map #16",
	"Video::Map #17",
	"Video::Map #18",
	"Video::Map #19",
	"Video::Map #2",
	"Video::Map #20",
	"Video::Map #21",
	"Video::Map #22",
	"Video::Map #23",
	"Video::Map #24",
	"Video::Map #25",
	"Video::Map #3",
	"Video::Map #32",
	"Video::Map #4",
	"Video::Map #5",
	"Video::Map #6",
	"Video::Map #7",
	"Video::Map #8",
	"Video::Map #9",
	"Video::OBS Virtual Camera",
	"Video::Slime_002:file1",
	"Video::Video Output 1",
	"Video::file1",
	"Video::file10",
	"Video::file2",
	"Video::file3",
	"Video::file3_ncl1_1",
	"Video::file4",
	"Video::file5",
	"Video::file6",
	"Video::file7",
	"Video::file8",
	"Video::file9",
	"ViewCameraToLookAt",
	"ViewFrustum",
	"ViewFrustumBackPlaneMode",
	"ViewFrustumFrontPlaneMode",
	"ViewFrustumNearFarPlane",
	"Visible",
	"W:\\Temp\\maya_auto_clamp.mb",
	"W:\\Temp\\ufbx_test_source",
	"W:\\Temp\\ufbx_test_source\\anim_layer_orders.mb",
	"W:\\Temp\\ufbx_test_source\\animation_interpolation.mb",
	"W:\\Temp\\ufbx_test_source\\animation_layers.mb",
	"W:\\Temp\\ufbx_test_source\\arnold_material.mb",
	"W:\\Temp\\ufbx_test_source\\attribute_zoo.mb",
	"W:\\Temp\\ufbx_test_source\\blend_between.ma",
	"W:\\Temp\\ufbx_test_source\\color_sets.mb",
	"W:\\Temp\\ufbx_test_source\\constraint_multi.mb",
	"W:\\Temp\\ufbx_test_source\\cube_blend.ma",
	"W:\\Temp\\ufbx_test_source\\different_materials.mb",
	"W:\\Temp\\ufbx_test_source\\dual_quaternion.mb",
	"W:\\Temp\\ufbx_test_source\\duplicate_textures.mb",
	"W:\\Temp\\ufbx_test_source\\geometric_cube.mb",
	"W:\\Temp\\ufbx_test_source\\max_Lines.max",
	"W:\\Temp\\ufbx_test_source\\maya_anim_light.mb",
	"W:\\Temp\\ufbx_test_source\\maya_axes_skin.ma",
	"W:\\Temp\\ufbx_test_source\\maya_constraints.mb",
	"W:\\Temp\\ufbx_test_source\\maya_display_layers.mb",
	"W:\\Temp\\ufbx_test_source\\maya_dq_blend.mb",
	"W:\\Temp\\ufbx_test_source\\maya_nurbs_plane.mb",
	"W:\\Temp\\ufbx_test_source\\maya_rotation_order.mb",
	"W:\\Temp\\ufbx_test_source\\maya_suzanne_lod.mb",
	"W:\\Temp\\ufbx_test_source\\mixed_inherit_mode.mb",
	"W:\\Temp\\ufbx_test_source\\nurbs_form.mb",
	"W:\\Temp\\ufbx_test_source\\quot.max",
	"W:\\Temp\\ufbx_test_source\\sausage.fbx",
	"W:\\Temp\\ufbx_test_source\\scale_no_inherit_anim.mb",
	"W:\\Temp\\ufbx_test_source\\selection_sets.max",
	"W:\\Temp\\ufbx_test_source\\shared_material.mb",
	"W:\\Temp\\ufbx_test_source\\sine_cube.mb",
	"W:\\Temp\\ufbx_test_source\\texture_blend_modes.mb",
	"W:\\Temp\\ufbx_test_source\\texture_layers.mb",
	"W:\\Temp\\ufbx_test_source\\transformed_skin.max",
	"W:\\Temp\\ufbx_test_source\\utf_identity.mb",
	"W:\\Temp\\ufbx_test_source\\xyz_anim.mb",
	"Waist Offset R",
	"Waist Offset T",
	"WaistPosition",
	"White",
	"Width",
	"Wiggle",
	"Wiggle.tak",
	"WorldUpVector",
	"WristDisplacementDamping",
	"WristDisplacementDampingMode",
	"WriteReference",
	"X.tak",
	"XRefUrl",
	"Y.tak",
	"YShape",
	"YShape_normals",
	"Yes",
	"Z.tak",
	"ZeroParallax",
	"__FBTool",
	"aniso_angle_map_on",
	"aniso_channel",
	"aniso_mode",
	"anisotropy_map_on",
	"aovId1",
	"aovId2",
	"aovId3",
	"aovId4",
	"aovId5",
	"aovId6",
	"aovId7",
	"aovId8",
	"base_color_map_on",
	"base_weight_map_on",
	"brdf_curve",
	"brdf_high",
	"brdf_low",
	"brdf_mode",
	"charptr",
	"coat_aniso_angle_map_on",
	"coat_aniso_map_on",
	"coat_color_map_on",
	"coat_map_on",
	"coat_rough_map_on",
	"currentUVSet",
	"cutout_map_on",
	"default",
	"diff_rough_map_on",
	"displacement_map",
	"displacement_map_on",
	"d|DeformPercent",
	"d|FilmHeight",
	"d|FilmOffsetX",
	"d|FilmWidth",
	"d|FocalLength",
	"d|FocusDistance",
	"d|Intensity",
	"d|TopH",
	"d|TopV",
	"d|Visibility",
	"d|Weight",
	"d|lockInfluenceWeights",
	"d|pull",
	"d|stiffness",
	"emission_map_on",
	"emit_color_map_on",
	"emit_kelvin",
	"emit_luminance",
	"fbx Scene",
	"float",
	"id1",
	"id2",
	"id3",
	"id4",
	"id5",
	"id6",
	"id7",
	"id8",
	"joint1.Weight",
	"lockInfluenceWeights",
	"mLayerID",
	"mRotationProperty",
	"mScalingProperty",
	"mTranslationProperty",
	"map1",
	"map2",
	"map3",
	"marvelous_quad",
	"marvelous_quad.xml",
	"maya_axes_anim_7700_ascii_fpc\\YShape.xml",
	"maya_cache_sine_6100_ascii_fpc\\pCubeShape1.xml",
	"maya_cache_sine_6100_ascii_fpc\\pCubeShape2.xml",
	"maya_cache_sine_7500_ascii_fpc\\pCubeShape1.xml",
	"maya_cache_sine_7500_ascii_fpc\\pCubeShape2.xml",
	"metalness_map_on",
	"missing_cache.xml",
	"normalCameraFactor",
	"normalCameraUsedAs",
	"outAlpha",
	"pCubeShape1",
	"pCubeShape1_normals",
	"pCubeShape2",
	"pCubeShape2_normals",
	"periodic",
	"pull",
	"refl_color_map_on",
	"reflectivity_map_on",
	"root",
	"roughness_map_on",
	"scattering_map_on",
	"second",
	"shader",
	"sheen_color_map_on",
	"sheen_map_on",
	"sheen_rough_map_on",
	"sss_color_map_on",
	"sss_scale_map_on",
	"stereoRigType",
	"stiffness",
	"textures\\_diffuse.png",
	"textures\\checkerboard_ambient.png",
	"textures\\checkerboard_bump.png",
	"textures\\checkerboard_diffuse.png",
	"textures\\checkerboard_displacement.png",
	"textures\\checkerboard_emissive.png",
	"textures\\checkerboard_metallic.png",
	"textures\\checkerboard_normal.png",
	"textures\\checkerboard_reflection.png",
	"textures\\checkerboard_roughness.png",
	"textures\\checkerboard_specular.png",
	"textures\\checkerboard_transparency.png",
	"textures\\checkerboard_vector_displacement.png",
	"textures\\checkerboard_weight.png",
	"textures\\tiny_clouds.png",
	"thin_film",
	"thin_film_ior_map_on",
	"thin_film_map_on",
	"tiny_clouds",
	"trans_color_map_on",
	"trans_ior_map_on",
	"trans_rough_map_on",
	"transmisison_dispersion",
	"transparency_map_on",
	"use_ao_map",
	"use_color_map",
	"use_emissive_map",
	"use_metallic_map",
	"use_normal_map",
	"use_roughness_map",
	"uv_offset",
	"uv_scale",
	"wiggle",
	"wiggle.tak",
};
