props_str = """
P: "QuaternionInterpolate", "enum", "", "",0
P: "RotationOffset", "Vector3D", "Vector", "",0,0,0
P: "RotationPivot", "Vector3D", "Vector", "",0,0,0
P: "ScalingOffset", "Vector3D", "Vector", "",0,0,0
P: "ScalingPivot", "Vector3D", "Vector", "",0,0,0
P: "TranslationActive", "bool", "", "",0
P: "TranslationMin", "Vector3D", "Vector", "",0,0,0
P: "TranslationMax", "Vector3D", "Vector", "",0,0,0
P: "TranslationMinX", "bool", "", "",0
P: "TranslationMinY", "bool", "", "",0
P: "TranslationMinZ", "bool", "", "",0
P: "TranslationMaxX", "bool", "", "",0
P: "TranslationMaxY", "bool", "", "",0
P: "TranslationMaxZ", "bool", "", "",0
P: "RotationOrder", "enum", "", "",0
P: "RotationSpaceForLimitOnly", "bool", "", "",0
P: "RotationStiffnessX", "double", "Number", "",0
P: "RotationStiffnessY", "double", "Number", "",0
P: "RotationStiffnessZ", "double", "Number", "",0
P: "AxisLen", "double", "Number", "",10
P: "PreRotation", "Vector3D", "Vector", "",0,0,0
P: "PostRotation", "Vector3D", "Vector", "",0,0,0
P: "RotationActive", "bool", "", "",0
P: "RotationMin", "Vector3D", "Vector", "",0,0,0
P: "RotationMax", "Vector3D", "Vector", "",0,0,0
P: "RotationMinX", "bool", "", "",0
P: "RotationMinY", "bool", "", "",0
P: "RotationMinZ", "bool", "", "",0
P: "RotationMaxX", "bool", "", "",0
P: "RotationMaxY", "bool", "", "",0
P: "RotationMaxZ", "bool", "", "",0
P: "InheritType", "enum", "", "",0
P: "ScalingActive", "bool", "", "",0
P: "ScalingMin", "Vector3D", "Vector", "",0,0,0
P: "ScalingMax", "Vector3D", "Vector", "",1,1,1
P: "ScalingMinX", "bool", "", "",0
P: "ScalingMinY", "bool", "", "",0
P: "ScalingMinZ", "bool", "", "",0
P: "ScalingMaxX", "bool", "", "",0
P: "ScalingMaxY", "bool", "", "",0
P: "ScalingMaxZ", "bool", "", "",0
P: "GeometricTranslation", "Vector3D", "Vector", "",0,0,0
P: "GeometricRotation", "Vector3D", "Vector", "",0,0,0
P: "GeometricScaling", "Vector3D", "Vector", "",1,1,1
P: "MinDampRangeX", "double", "Number", "",0
P: "MinDampRangeY", "double", "Number", "",0
P: "MinDampRangeZ", "double", "Number", "",0
P: "MaxDampRangeX", "double", "Number", "",0
P: "MaxDampRangeY", "double", "Number", "",0
P: "MaxDampRangeZ", "double", "Number", "",0
P: "MinDampStrengthX", "double", "Number", "",0
P: "MinDampStrengthY", "double", "Number", "",0
P: "MinDampStrengthZ", "double", "Number", "",0
P: "MaxDampStrengthX", "double", "Number", "",0
P: "MaxDampStrengthY", "double", "Number", "",0
P: "MaxDampStrengthZ", "double", "Number", "",0
P: "PreferedAngleX", "double", "Number", "",0
P: "PreferedAngleY", "double", "Number", "",0
P: "PreferedAngleZ", "double", "Number", "",0
P: "LookAtProperty", "object", "", ""
P: "UpVectorProperty", "object", "", ""
P: "Show", "bool", "", "",1
P: "NegativePercentShapeSupport", "bool", "", "",1
P: "DefaultAttributeIndex", "int", "Integer", "",-1
P: "Freeze", "bool", "", "",0
P: "LODBox", "bool", "", "",0
P: "Lcl Translation", "Lcl Translation", "", "A",0,0,0
P: "Lcl Rotation", "Lcl Rotation", "", "A",0,0,0
P: "Lcl Scaling", "Lcl Scaling", "", "A",1,1,1
P: "Visibility", "Visibility", "", "A",1
P: "Visibility Inheritance", "Visibility Inheritance", "", "",1

P: "ShadingModel", "KString", "", "", "Lambert"
P: "MultiLayer", "bool", "", "",0
P: "EmissiveColor", "Color", "", "A",0,0,0
P: "EmissiveFactor", "Number", "", "A",1
P: "AmbientColor", "Color", "", "A",0.2,0.2,0.2
P: "AmbientFactor", "Number", "", "A",1
P: "DiffuseColor", "Color", "", "A",0.8,0.8,0.8
P: "DiffuseFactor", "Number", "", "A",1
P: "Bump", "Vector3D", "Vector", "",0,0,0
P: "NormalMap", "Vector3D", "Vector", "",0,0,0
P: "BumpFactor", "double", "Number", "",1
P: "TransparentColor", "Color", "", "A",0,0,0
P: "TransparencyFactor", "Number", "", "A",0
P: "DisplacementColor", "ColorRGB", "Color", "",0,0,0
P: "DisplacementFactor", "double", "Number", "",1
P: "VectorDisplacementColor", "ColorRGB", "Color", "",0,0,0
P: "VectorDisplacementFactor", "double", "Number", "",1

P: "Color", "ColorRGB", "Color", "",0.8,0.8,0.8
P: "BBoxMin", "Vector3D", "Vector", "",0,0,0
P: "BBoxMax", "Vector3D", "Vector", "",0,0,0
P: "Primary Visibility", "bool", "", "",1
P: "Casts Shadows", "bool", "", "",1
P: "Receive Shadows", "bool", "", "",1

P: "CastLightOnObject", "bool", "", "",1
P: "DrawVolumetricLight", "bool", "", "",1
P: "DrawGroundProjection", "bool", "", "",1
P: "DrawFrontFacingVolumetricLight", "bool", "", "",0
P: "Intensity", "Number", "", "A",100
P: "InnerAngle", "Number", "", "A",0
P: "OuterAngle", "Number", "", "A",45
P: "Fog", "Number", "", "A",50
P: "DecayType", "enum", "", "",0
P: "DecayStart", "Number", "", "A",0
P: "FileName", "KString", "", "", ""
P: "EnableNearAttenuation", "bool", "", "",0
P: "NearAttenuationStart", "Number", "", "A",0
P: "NearAttenuationEnd", "Number", "", "A",0
P: "EnableFarAttenuation", "bool", "", "",0
P: "FarAttenuationStart", "Number", "", "A",0
P: "FarAttenuationEnd", "Number", "", "A",0
P: "CastShadows", "bool", "", "",0
P: "ShadowColor", "Color", "", "A",0,0,0
P: "AreaLightShape", "enum", "", "",0
P: "LeftBarnDoor", "Float", "", "A",20
P: "RightBarnDoor", "Float", "", "A",20
P: "TopBarnDoor", "Float", "", "A",20
P: "BottomBarnDoor", "Float", "", "A",20
P: "EnableBarnDoor", "Bool", "", "A",0
"""

props = [tuple(p.strip("\" ") for p in l.lstrip("P: ").split(",")) for l in props_str.splitlines()]
props = sorted(props, key=lambda l: l[0])

type_map = {
    "Boolean": "UFBX_PROP_BOOLEAN", 
    "bool": "UFBX_PROP_BOOLEAN",
    "Bool": "UFBX_PROP_BOOLEAN", 
    "Integer": "UFBX_PROP_INTEGER", 
    "int": "UFBX_PROP_INTEGER", 
    "enum": "UFBX_PROP_INTEGER",
    "Visibility": "UFBX_PROP_INTEGER", 
    "Visibility Inheritance": "UFBX_PROP_INTEGER", 
    "Number": "UFBX_PROP_NUMBER", 
    "double": "UFBX_PROP_NUMBER", 
    "Real": "UFBX_PROP_NUMBER",
    "Float": "UFBX_PROP_NUMBER", 
    "Intensity": "UFBX_PROP_NUMBER", 
    "Vector": "UFBX_PROP_VECTOR", 
    "Vector3D": "UFBX_PROP_VECTOR", 
    "Color": "UFBX_PROP_COLOR", 
    "ColorRGB": "UFBX_PROP_COLOR", 
    "String": "UFBX_PROP_STRING", 
    "KString": "UFBX_PROP_STRING",
    "object": "UFBX_PROP_STRING", 
    "DateTime": "UFBX_PROP_DATE_TIME", 
    "Lcl Translation": "UFBX_PROP_TRANSLATION", 
    "Lcl Rotation": "UFBX_PROP_ROTATION", 
    "Lcl Scaling": "UFBX_PROP_SCALING", 
}

print("static const ufbx_prop ufbxi_default_props[] = {")

for p in props:
    if len(p) < 2: continue
    name = p[0]
    prop_type = type_map[p[1]]
    v = p[4:]
    if prop_type == "UFBX_PROP_STRING" or prop_type == "UFBX_PROP_DATE_TIME":
        if v:
            value = "\"{}\"".format(v[0], len(v[0]))
        else:
            value = "0"
    elif prop_type == "UFBX_PROP_BOOLEAN" or prop_type == "UFBX_PROP_INTEGER" or prop_type == "UFBX_PROP_NUMBER":
        value = "0, {}".format(float(v[0]))
    else:
        value = "0, {}, {}, {}".format(float(v[0]), float(v[1]), float(v[2]))

    print("\t{{ \"{}\", {}, {}, {} }},".format(name, len(name), prop_type, value))

print("};")
