#pragma once
/*
    #version:1# (machine generated, don't edit!)

    Generated by sokol-shdc (https://github.com/floooh/sokol-tools)

    Cmdline: sokol-shdc --input mesh.glsl --output mesh.h --slang glsl330:hlsl5:metal_macos -b

    Overview:

        Shader program 'skinned_lit':
            Get shader desc: skinned_lit_shader_desc(sg_query_backend());
            Vertex shader: skinned_vertex
                Attribute slots:
                    ATTR_skinned_vertex_a_position = 0
                    ATTR_skinned_vertex_a_normal = 1
                    ATTR_skinned_vertex_a_uv = 2
                    ATTR_skinned_vertex_a_vertex_index = 3
                    ATTR_skinned_vertex_a_bone_indices = 4
                    ATTR_skinned_vertex_a_bone_weights = 5
                Uniform block 'mesh_vertex_ubo':
                    C struct: mesh_vertex_ubo_t
                    Bind slot: SLOT_mesh_vertex_ubo = 0
                Uniform block 'skin_vertex_ubo':
                    C struct: skin_vertex_ubo_t
                    Bind slot: SLOT_skin_vertex_ubo = 1
                Image 'blend_shapes':
                    Type: SG_IMAGETYPE_ARRAY
                    Component Type: SG_SAMPLERTYPE_FLOAT
                    Bind slot: SLOT_blend_shapes = 0
            Fragment shader: lit_pixel

        Shader program 'static_lit':
            Get shader desc: static_lit_shader_desc(sg_query_backend());
            Vertex shader: static_vertex
                Attribute slots:
                    ATTR_static_vertex_a_position = 0
                    ATTR_static_vertex_a_normal = 1
                    ATTR_static_vertex_a_uv = 2
                    ATTR_static_vertex_a_vertex_index = 3
                Uniform block 'mesh_vertex_ubo':
                    C struct: mesh_vertex_ubo_t
                    Bind slot: SLOT_mesh_vertex_ubo = 0
                Image 'blend_shapes':
                    Type: SG_IMAGETYPE_ARRAY
                    Component Type: SG_SAMPLERTYPE_FLOAT
                    Bind slot: SLOT_blend_shapes = 0
            Fragment shader: lit_pixel


    Shader descriptor structs:

        sg_shader skinned_lit = sg_make_shader(skinned_lit_shader_desc(sg_query_backend()));
        sg_shader static_lit = sg_make_shader(static_lit_shader_desc(sg_query_backend()));

    Vertex attribute locations for vertex shader 'static_vertex':

        sg_pipeline pip = sg_make_pipeline(&(sg_pipeline_desc){
            .layout = {
                .attrs = {
                    [ATTR_static_vertex_a_position] = { ... },
                    [ATTR_static_vertex_a_normal] = { ... },
                    [ATTR_static_vertex_a_uv] = { ... },
                    [ATTR_static_vertex_a_vertex_index] = { ... },
                },
            },
            ...});

    Vertex attribute locations for vertex shader 'skinned_vertex':

        sg_pipeline pip = sg_make_pipeline(&(sg_pipeline_desc){
            .layout = {
                .attrs = {
                    [ATTR_skinned_vertex_a_position] = { ... },
                    [ATTR_skinned_vertex_a_normal] = { ... },
                    [ATTR_skinned_vertex_a_uv] = { ... },
                    [ATTR_skinned_vertex_a_vertex_index] = { ... },
                    [ATTR_skinned_vertex_a_bone_indices] = { ... },
                    [ATTR_skinned_vertex_a_bone_weights] = { ... },
                },
            },
            ...});

    Image bind slots, use as index in sg_bindings.vs_images[] or .fs_images[]

        SLOT_blend_shapes = 0;

    Bind slot and C-struct for uniform block 'mesh_vertex_ubo':

        mesh_vertex_ubo_t mesh_vertex_ubo = {
            .geometry_to_world = ...;
            .normal_to_world = ...;
            .world_to_clip = ...;
            .blend_weights = ...;
            .f_num_blend_shapes = ...;
        };
        sg_apply_uniforms(SG_SHADERSTAGE_[VS|FS], SLOT_mesh_vertex_ubo, &SG_RANGE(mesh_vertex_ubo));

    Bind slot and C-struct for uniform block 'skin_vertex_ubo':

        skin_vertex_ubo_t skin_vertex_ubo = {
            .bones = ...;
        };
        sg_apply_uniforms(SG_SHADERSTAGE_[VS|FS], SLOT_skin_vertex_ubo, &SG_RANGE(skin_vertex_ubo));

*/
#include <stdint.h>
#include <stdbool.h>
#include <string.h>
#include <stddef.h>
#if !defined(SOKOL_SHDC_ALIGN)
  #if defined(_MSC_VER)
    #define SOKOL_SHDC_ALIGN(a) __declspec(align(a))
  #else
    #define SOKOL_SHDC_ALIGN(a) __attribute__((aligned(a)))
  #endif
#endif
#define ATTR_static_vertex_a_position (0)
#define ATTR_static_vertex_a_normal (1)
#define ATTR_static_vertex_a_uv (2)
#define ATTR_static_vertex_a_vertex_index (3)
#define ATTR_skinned_vertex_a_position (0)
#define ATTR_skinned_vertex_a_normal (1)
#define ATTR_skinned_vertex_a_uv (2)
#define ATTR_skinned_vertex_a_vertex_index (3)
#define ATTR_skinned_vertex_a_bone_indices (4)
#define ATTR_skinned_vertex_a_bone_weights (5)
#define SLOT_blend_shapes (0)
#define SLOT_mesh_vertex_ubo (0)
#pragma pack(push,1)
SOKOL_SHDC_ALIGN(16) typedef struct mesh_vertex_ubo_t {
    um_mat geometry_to_world;
    um_mat normal_to_world;
    um_mat world_to_clip;
    um_vec4 blend_weights[16];
    float f_num_blend_shapes;
    uint8_t _pad_452[12];
} mesh_vertex_ubo_t;
#pragma pack(pop)
#define SLOT_skin_vertex_ubo (1)
#pragma pack(push,1)
SOKOL_SHDC_ALIGN(16) typedef struct skin_vertex_ubo_t {
    um_mat bones[64];
} skin_vertex_ubo_t;
#pragma pack(pop)
/*
    #version 330
    
    uniform vec4 mesh_vertex_ubo[29];
    uniform sampler2DArray blend_shapes;
    
    layout(location = 0) in vec3 a_position;
    layout(location = 3) in float a_vertex_index;
    out vec3 v_normal;
    layout(location = 1) in vec3 a_normal;
    out vec2 v_uv;
    layout(location = 2) in vec2 a_uv;
    
    vec3 evaluate_blend_shape(int vertex_index)
    {
        int _21 = vertex_index & 2047;
        int _24 = vertex_index >> 11;
        int _39 = int(mesh_vertex_ubo[28].x);
        vec3 offset = vec3(0.0);
        for (int i = 0; i < _39; i++)
        {
            vec4 _packed = mesh_vertex_ubo[(i >> 2) * 1 + 12];
            offset += (texelFetch(blend_shapes, ivec3(_21, _24, i), 0).xyz * _packed[i & 3]);
        }
        return offset;
    }
    
    void main()
    {
        vec3 local_pos = a_position;
        int param = int(a_vertex_index);
        vec3 _104 = local_pos;
        vec3 _105 = _104 + evaluate_blend_shape(param);
        local_pos = _105;
        gl_Position = mat4(mesh_vertex_ubo[8], mesh_vertex_ubo[9], mesh_vertex_ubo[10], mesh_vertex_ubo[11]) * vec4((mat4(mesh_vertex_ubo[0], mesh_vertex_ubo[1], mesh_vertex_ubo[2], mesh_vertex_ubo[3]) * vec4(_105, 1.0)).xyz, 1.0);
        v_normal = normalize((mat4(mesh_vertex_ubo[4], mesh_vertex_ubo[5], mesh_vertex_ubo[6], mesh_vertex_ubo[7]) * vec4(a_normal, 0.0)).xyz);
        v_uv = a_uv;
    }
    
*/
static const char static_vertex_source_glsl330[1259] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x33,0x33,0x30,0x0a,0x0a,0x75,0x6e,
    0x69,0x66,0x6f,0x72,0x6d,0x20,0x76,0x65,0x63,0x34,0x20,0x6d,0x65,0x73,0x68,0x5f,
    0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x32,0x39,0x5d,0x3b,0x0a,
    0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x20,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x32,
    0x44,0x41,0x72,0x72,0x61,0x79,0x20,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,
    0x70,0x65,0x73,0x3b,0x0a,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,
    0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x30,0x29,0x20,0x69,0x6e,0x20,0x76,0x65,
    0x63,0x33,0x20,0x61,0x5f,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x6c,
    0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,
    0x20,0x33,0x29,0x20,0x69,0x6e,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x61,0x5f,0x76,
    0x65,0x72,0x74,0x65,0x78,0x5f,0x69,0x6e,0x64,0x65,0x78,0x3b,0x0a,0x6f,0x75,0x74,
    0x20,0x76,0x65,0x63,0x33,0x20,0x76,0x5f,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x3b,0x0a,
    0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,
    0x3d,0x20,0x31,0x29,0x20,0x69,0x6e,0x20,0x76,0x65,0x63,0x33,0x20,0x61,0x5f,0x6e,
    0x6f,0x72,0x6d,0x61,0x6c,0x3b,0x0a,0x6f,0x75,0x74,0x20,0x76,0x65,0x63,0x32,0x20,
    0x76,0x5f,0x75,0x76,0x3b,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,
    0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x32,0x29,0x20,0x69,0x6e,0x20,0x76,0x65,
    0x63,0x32,0x20,0x61,0x5f,0x75,0x76,0x3b,0x0a,0x0a,0x76,0x65,0x63,0x33,0x20,0x65,
    0x76,0x61,0x6c,0x75,0x61,0x74,0x65,0x5f,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,
    0x61,0x70,0x65,0x28,0x69,0x6e,0x74,0x20,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x69,
    0x6e,0x64,0x65,0x78,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,
    0x5f,0x32,0x31,0x20,0x3d,0x20,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x69,0x6e,0x64,
    0x65,0x78,0x20,0x26,0x20,0x32,0x30,0x34,0x37,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,
    0x6e,0x74,0x20,0x5f,0x32,0x34,0x20,0x3d,0x20,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,
    0x69,0x6e,0x64,0x65,0x78,0x20,0x3e,0x3e,0x20,0x31,0x31,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x69,0x6e,0x74,0x20,0x5f,0x33,0x39,0x20,0x3d,0x20,0x69,0x6e,0x74,0x28,0x6d,
    0x65,0x73,0x68,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x32,
    0x38,0x5d,0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,
    0x6f,0x66,0x66,0x73,0x65,0x74,0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x28,0x30,0x2e,
    0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6f,0x72,0x20,0x28,0x69,0x6e,0x74,
    0x20,0x69,0x20,0x3d,0x20,0x30,0x3b,0x20,0x69,0x20,0x3c,0x20,0x5f,0x33,0x39,0x3b,
    0x20,0x69,0x2b,0x2b,0x29,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x34,0x20,0x5f,0x70,0x61,0x63,0x6b,0x65,0x64,
    0x20,0x3d,0x20,0x6d,0x65,0x73,0x68,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,
    0x62,0x6f,0x5b,0x28,0x69,0x20,0x3e,0x3e,0x20,0x32,0x29,0x20,0x2a,0x20,0x31,0x20,
    0x2b,0x20,0x31,0x32,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x6f,
    0x66,0x66,0x73,0x65,0x74,0x20,0x2b,0x3d,0x20,0x28,0x74,0x65,0x78,0x65,0x6c,0x46,
    0x65,0x74,0x63,0x68,0x28,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,0x65,
    0x73,0x2c,0x20,0x69,0x76,0x65,0x63,0x33,0x28,0x5f,0x32,0x31,0x2c,0x20,0x5f,0x32,
    0x34,0x2c,0x20,0x69,0x29,0x2c,0x20,0x30,0x29,0x2e,0x78,0x79,0x7a,0x20,0x2a,0x20,
    0x5f,0x70,0x61,0x63,0x6b,0x65,0x64,0x5b,0x69,0x20,0x26,0x20,0x33,0x5d,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,
    0x6e,0x20,0x6f,0x66,0x66,0x73,0x65,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x76,0x6f,0x69,
    0x64,0x20,0x6d,0x61,0x69,0x6e,0x28,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x76,
    0x65,0x63,0x33,0x20,0x6c,0x6f,0x63,0x61,0x6c,0x5f,0x70,0x6f,0x73,0x20,0x3d,0x20,
    0x61,0x5f,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x69,0x6e,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,0x3d,0x20,0x69,0x6e,0x74,0x28,
    0x61,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x69,0x6e,0x64,0x65,0x78,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x5f,0x31,0x30,0x34,0x20,0x3d,
    0x20,0x6c,0x6f,0x63,0x61,0x6c,0x5f,0x70,0x6f,0x73,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x76,0x65,0x63,0x33,0x20,0x5f,0x31,0x30,0x35,0x20,0x3d,0x20,0x5f,0x31,0x30,0x34,
    0x20,0x2b,0x20,0x65,0x76,0x61,0x6c,0x75,0x61,0x74,0x65,0x5f,0x62,0x6c,0x65,0x6e,
    0x64,0x5f,0x73,0x68,0x61,0x70,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x6c,0x6f,0x63,0x61,0x6c,0x5f,0x70,0x6f,0x73,0x20,0x3d,0x20,
    0x5f,0x31,0x30,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x67,0x6c,0x5f,0x50,0x6f,0x73,
    0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x6d,0x61,0x74,0x34,0x28,0x6d,0x65,0x73,
    0x68,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x38,0x5d,0x2c,
    0x20,0x6d,0x65,0x73,0x68,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,
    0x5b,0x39,0x5d,0x2c,0x20,0x6d,0x65,0x73,0x68,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,
    0x5f,0x75,0x62,0x6f,0x5b,0x31,0x30,0x5d,0x2c,0x20,0x6d,0x65,0x73,0x68,0x5f,0x76,
    0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x31,0x31,0x5d,0x29,0x20,0x2a,
    0x20,0x76,0x65,0x63,0x34,0x28,0x28,0x6d,0x61,0x74,0x34,0x28,0x6d,0x65,0x73,0x68,
    0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x30,0x5d,0x2c,0x20,
    0x6d,0x65,0x73,0x68,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,
    0x31,0x5d,0x2c,0x20,0x6d,0x65,0x73,0x68,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,
    0x75,0x62,0x6f,0x5b,0x32,0x5d,0x2c,0x20,0x6d,0x65,0x73,0x68,0x5f,0x76,0x65,0x72,
    0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x33,0x5d,0x29,0x20,0x2a,0x20,0x76,0x65,
    0x63,0x34,0x28,0x5f,0x31,0x30,0x35,0x2c,0x20,0x31,0x2e,0x30,0x29,0x29,0x2e,0x78,
    0x79,0x7a,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x5f,
    0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x20,0x3d,0x20,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x69,
    0x7a,0x65,0x28,0x28,0x6d,0x61,0x74,0x34,0x28,0x6d,0x65,0x73,0x68,0x5f,0x76,0x65,
    0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x34,0x5d,0x2c,0x20,0x6d,0x65,0x73,
    0x68,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x35,0x5d,0x2c,
    0x20,0x6d,0x65,0x73,0x68,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,
    0x5b,0x36,0x5d,0x2c,0x20,0x6d,0x65,0x73,0x68,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,
    0x5f,0x75,0x62,0x6f,0x5b,0x37,0x5d,0x29,0x20,0x2a,0x20,0x76,0x65,0x63,0x34,0x28,
    0x61,0x5f,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x2c,0x20,0x30,0x2e,0x30,0x29,0x29,0x2e,
    0x78,0x79,0x7a,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x5f,0x75,0x76,0x20,0x3d,
    0x20,0x61,0x5f,0x75,0x76,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #version 330
    
    uniform vec4 mesh_vertex_ubo[29];
    uniform vec4 skin_vertex_ubo[256];
    uniform sampler2DArray blend_shapes;
    
    layout(location = 4) in vec4 a_bone_indices;
    layout(location = 5) in vec4 a_bone_weights;
    layout(location = 0) in vec3 a_position;
    layout(location = 3) in float a_vertex_index;
    layout(location = 1) in vec3 a_normal;
    out vec3 v_normal;
    out vec2 v_uv;
    layout(location = 2) in vec2 a_uv;
    
    vec3 evaluate_blend_shape(int vertex_index)
    {
        int _21 = vertex_index & 2047;
        int _24 = vertex_index >> 11;
        int _39 = int(mesh_vertex_ubo[28].x);
        vec3 offset = vec3(0.0);
        for (int i = 0; i < _39; i++)
        {
            vec4 _packed = mesh_vertex_ubo[(i >> 2) * 1 + 12];
            offset += (texelFetch(blend_shapes, ivec3(_21, _24, i), 0).xyz * _packed[i & 3]);
        }
        return offset;
    }
    
    void main()
    {
        mat4 _114 = mat4(skin_vertex_ubo[int(a_bone_indices.x) * 4 + 0], skin_vertex_ubo[int(a_bone_indices.x) * 4 + 1], skin_vertex_ubo[int(a_bone_indices.x) * 4 + 2], skin_vertex_ubo[int(a_bone_indices.x) * 4 + 3]) * a_bone_weights.x;
        mat4 _123 = mat4(skin_vertex_ubo[int(a_bone_indices.y) * 4 + 0], skin_vertex_ubo[int(a_bone_indices.y) * 4 + 1], skin_vertex_ubo[int(a_bone_indices.y) * 4 + 2], skin_vertex_ubo[int(a_bone_indices.y) * 4 + 3]) * a_bone_weights.y;
        mat4 _145 = mat4(skin_vertex_ubo[int(a_bone_indices.z) * 4 + 0], skin_vertex_ubo[int(a_bone_indices.z) * 4 + 1], skin_vertex_ubo[int(a_bone_indices.z) * 4 + 2], skin_vertex_ubo[int(a_bone_indices.z) * 4 + 3]) * a_bone_weights.z;
        mat4 _167 = mat4(skin_vertex_ubo[int(a_bone_indices.w) * 4 + 0], skin_vertex_ubo[int(a_bone_indices.w) * 4 + 1], skin_vertex_ubo[int(a_bone_indices.w) * 4 + 2], skin_vertex_ubo[int(a_bone_indices.w) * 4 + 3]) * a_bone_weights.w;
        mat4 _180 = mat4(((_114[0] + _123[0]) + _145[0]) + _167[0], ((_114[1] + _123[1]) + _145[1]) + _167[1], ((_114[2] + _123[2]) + _145[2]) + _167[2], ((_114[3] + _123[3]) + _145[3]) + _167[3]);
        vec3 local_pos = a_position;
        int param = int(a_vertex_index);
        vec3 _190 = local_pos;
        vec3 _191 = _190 + evaluate_blend_shape(param);
        local_pos = _191;
        gl_Position = mat4(mesh_vertex_ubo[8], mesh_vertex_ubo[9], mesh_vertex_ubo[10], mesh_vertex_ubo[11]) * vec4((_180 * vec4(_191, 1.0)).xyz, 1.0);
        v_normal = normalize((_180 * vec4(a_normal, 0.0)).xyz);
        v_uv = a_uv;
    }
    
*/
static const char skinned_vertex_source_glsl330[2350] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x33,0x33,0x30,0x0a,0x0a,0x75,0x6e,
    0x69,0x66,0x6f,0x72,0x6d,0x20,0x76,0x65,0x63,0x34,0x20,0x6d,0x65,0x73,0x68,0x5f,
    0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x32,0x39,0x5d,0x3b,0x0a,
    0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x20,0x76,0x65,0x63,0x34,0x20,0x73,0x6b,0x69,
    0x6e,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x32,0x35,0x36,
    0x5d,0x3b,0x0a,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x20,0x73,0x61,0x6d,0x70,0x6c,
    0x65,0x72,0x32,0x44,0x41,0x72,0x72,0x61,0x79,0x20,0x62,0x6c,0x65,0x6e,0x64,0x5f,
    0x73,0x68,0x61,0x70,0x65,0x73,0x3b,0x0a,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,
    0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x34,0x29,0x20,0x69,0x6e,
    0x20,0x76,0x65,0x63,0x34,0x20,0x61,0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x69,0x6e,0x64,
    0x69,0x63,0x65,0x73,0x3b,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,
    0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x35,0x29,0x20,0x69,0x6e,0x20,0x76,0x65,
    0x63,0x34,0x20,0x61,0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x77,0x65,0x69,0x67,0x68,0x74,
    0x73,0x3b,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,
    0x6f,0x6e,0x20,0x3d,0x20,0x30,0x29,0x20,0x69,0x6e,0x20,0x76,0x65,0x63,0x33,0x20,
    0x61,0x5f,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x6c,0x61,0x79,0x6f,
    0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x33,0x29,
    0x20,0x69,0x6e,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x61,0x5f,0x76,0x65,0x72,0x74,
    0x65,0x78,0x5f,0x69,0x6e,0x64,0x65,0x78,0x3b,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,
    0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x31,0x29,0x20,0x69,
    0x6e,0x20,0x76,0x65,0x63,0x33,0x20,0x61,0x5f,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x3b,
    0x0a,0x6f,0x75,0x74,0x20,0x76,0x65,0x63,0x33,0x20,0x76,0x5f,0x6e,0x6f,0x72,0x6d,
    0x61,0x6c,0x3b,0x0a,0x6f,0x75,0x74,0x20,0x76,0x65,0x63,0x32,0x20,0x76,0x5f,0x75,
    0x76,0x3b,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,
    0x6f,0x6e,0x20,0x3d,0x20,0x32,0x29,0x20,0x69,0x6e,0x20,0x76,0x65,0x63,0x32,0x20,
    0x61,0x5f,0x75,0x76,0x3b,0x0a,0x0a,0x76,0x65,0x63,0x33,0x20,0x65,0x76,0x61,0x6c,
    0x75,0x61,0x74,0x65,0x5f,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,0x65,
    0x28,0x69,0x6e,0x74,0x20,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x69,0x6e,0x64,0x65,
    0x78,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x5f,0x32,0x31,
    0x20,0x3d,0x20,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x69,0x6e,0x64,0x65,0x78,0x20,
    0x26,0x20,0x32,0x30,0x34,0x37,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,
    0x5f,0x32,0x34,0x20,0x3d,0x20,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x69,0x6e,0x64,
    0x65,0x78,0x20,0x3e,0x3e,0x20,0x31,0x31,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,
    0x74,0x20,0x5f,0x33,0x39,0x20,0x3d,0x20,0x69,0x6e,0x74,0x28,0x6d,0x65,0x73,0x68,
    0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x32,0x38,0x5d,0x2e,
    0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x6f,0x66,0x66,
    0x73,0x65,0x74,0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x28,0x30,0x2e,0x30,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6f,0x72,0x20,0x28,0x69,0x6e,0x74,0x20,0x69,0x20,
    0x3d,0x20,0x30,0x3b,0x20,0x69,0x20,0x3c,0x20,0x5f,0x33,0x39,0x3b,0x20,0x69,0x2b,
    0x2b,0x29,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x76,0x65,0x63,0x34,0x20,0x5f,0x70,0x61,0x63,0x6b,0x65,0x64,0x20,0x3d,0x20,
    0x6d,0x65,0x73,0x68,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,
    0x28,0x69,0x20,0x3e,0x3e,0x20,0x32,0x29,0x20,0x2a,0x20,0x31,0x20,0x2b,0x20,0x31,
    0x32,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x6f,0x66,0x66,0x73,
    0x65,0x74,0x20,0x2b,0x3d,0x20,0x28,0x74,0x65,0x78,0x65,0x6c,0x46,0x65,0x74,0x63,
    0x68,0x28,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,0x65,0x73,0x2c,0x20,
    0x69,0x76,0x65,0x63,0x33,0x28,0x5f,0x32,0x31,0x2c,0x20,0x5f,0x32,0x34,0x2c,0x20,
    0x69,0x29,0x2c,0x20,0x30,0x29,0x2e,0x78,0x79,0x7a,0x20,0x2a,0x20,0x5f,0x70,0x61,
    0x63,0x6b,0x65,0x64,0x5b,0x69,0x20,0x26,0x20,0x33,0x5d,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6f,
    0x66,0x66,0x73,0x65,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x76,0x6f,0x69,0x64,0x20,0x6d,
    0x61,0x69,0x6e,0x28,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x74,0x34,
    0x20,0x5f,0x31,0x31,0x34,0x20,0x3d,0x20,0x6d,0x61,0x74,0x34,0x28,0x73,0x6b,0x69,
    0x6e,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x69,0x6e,0x74,
    0x28,0x61,0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,0x73,0x2e,
    0x78,0x29,0x20,0x2a,0x20,0x34,0x20,0x2b,0x20,0x30,0x5d,0x2c,0x20,0x73,0x6b,0x69,
    0x6e,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x69,0x6e,0x74,
    0x28,0x61,0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,0x73,0x2e,
    0x78,0x29,0x20,0x2a,0x20,0x34,0x20,0x2b,0x20,0x31,0x5d,0x2c,0x20,0x73,0x6b,0x69,
    0x6e,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x69,0x6e,0x74,
    0x28,0x61,0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,0x73,0x2e,
    0x78,0x29,0x20,0x2a,0x20,0x34,0x20,0x2b,0x20,0x32,0x5d,0x2c,0x20,0x73,0x6b,0x69,
    0x6e,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x69,0x6e,0x74,
    0x28,0x61,0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,0x73,0x2e,
    0x78,0x29,0x20,0x2a,0x20,0x34,0x20,0x2b,0x20,0x33,0x5d,0x29,0x20,0x2a,0x20,0x61,
    0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x77,0x65,0x69,0x67,0x68,0x74,0x73,0x2e,0x78,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x74,0x34,0x20,0x5f,0x31,0x32,0x33,0x20,0x3d,
    0x20,0x6d,0x61,0x74,0x34,0x28,0x73,0x6b,0x69,0x6e,0x5f,0x76,0x65,0x72,0x74,0x65,
    0x78,0x5f,0x75,0x62,0x6f,0x5b,0x69,0x6e,0x74,0x28,0x61,0x5f,0x62,0x6f,0x6e,0x65,
    0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,0x73,0x2e,0x79,0x29,0x20,0x2a,0x20,0x34,0x20,
    0x2b,0x20,0x30,0x5d,0x2c,0x20,0x73,0x6b,0x69,0x6e,0x5f,0x76,0x65,0x72,0x74,0x65,
    0x78,0x5f,0x75,0x62,0x6f,0x5b,0x69,0x6e,0x74,0x28,0x61,0x5f,0x62,0x6f,0x6e,0x65,
    0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,0x73,0x2e,0x79,0x29,0x20,0x2a,0x20,0x34,0x20,
    0x2b,0x20,0x31,0x5d,0x2c,0x20,0x73,0x6b,0x69,0x6e,0x5f,0x76,0x65,0x72,0x74,0x65,
    0x78,0x5f,0x75,0x62,0x6f,0x5b,0x69,0x6e,0x74,0x28,0x61,0x5f,0x62,0x6f,0x6e,0x65,
    0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,0x73,0x2e,0x79,0x29,0x20,0x2a,0x20,0x34,0x20,
    0x2b,0x20,0x32,0x5d,0x2c,0x20,0x73,0x6b,0x69,0x6e,0x5f,0x76,0x65,0x72,0x74,0x65,
    0x78,0x5f,0x75,0x62,0x6f,0x5b,0x69,0x6e,0x74,0x28,0x61,0x5f,0x62,0x6f,0x6e,0x65,
    0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,0x73,0x2e,0x79,0x29,0x20,0x2a,0x20,0x34,0x20,
    0x2b,0x20,0x33,0x5d,0x29,0x20,0x2a,0x20,0x61,0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x77,
    0x65,0x69,0x67,0x68,0x74,0x73,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,
    0x74,0x34,0x20,0x5f,0x31,0x34,0x35,0x20,0x3d,0x20,0x6d,0x61,0x74,0x34,0x28,0x73,
    0x6b,0x69,0x6e,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x69,
    0x6e,0x74,0x28,0x61,0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,
    0x73,0x2e,0x7a,0x29,0x20,0x2a,0x20,0x34,0x20,0x2b,0x20,0x30,0x5d,0x2c,0x20,0x73,
    0x6b,0x69,0x6e,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x69,
    0x6e,0x74,0x28,0x61,0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,
    0x73,0x2e,0x7a,0x29,0x20,0x2a,0x20,0x34,0x20,0x2b,0x20,0x31,0x5d,0x2c,0x20,0x73,
    0x6b,0x69,0x6e,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x69,
    0x6e,0x74,0x28,0x61,0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,
    0x73,0x2e,0x7a,0x29,0x20,0x2a,0x20,0x34,0x20,0x2b,0x20,0x32,0x5d,0x2c,0x20,0x73,
    0x6b,0x69,0x6e,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x69,
    0x6e,0x74,0x28,0x61,0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,
    0x73,0x2e,0x7a,0x29,0x20,0x2a,0x20,0x34,0x20,0x2b,0x20,0x33,0x5d,0x29,0x20,0x2a,
    0x20,0x61,0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x77,0x65,0x69,0x67,0x68,0x74,0x73,0x2e,
    0x7a,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x74,0x34,0x20,0x5f,0x31,0x36,0x37,
    0x20,0x3d,0x20,0x6d,0x61,0x74,0x34,0x28,0x73,0x6b,0x69,0x6e,0x5f,0x76,0x65,0x72,
    0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x69,0x6e,0x74,0x28,0x61,0x5f,0x62,0x6f,
    0x6e,0x65,0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,0x73,0x2e,0x77,0x29,0x20,0x2a,0x20,
    0x34,0x20,0x2b,0x20,0x30,0x5d,0x2c,0x20,0x73,0x6b,0x69,0x6e,0x5f,0x76,0x65,0x72,
    0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x69,0x6e,0x74,0x28,0x61,0x5f,0x62,0x6f,
    0x6e,0x65,0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,0x73,0x2e,0x77,0x29,0x20,0x2a,0x20,
    0x34,0x20,0x2b,0x20,0x31,0x5d,0x2c,0x20,0x73,0x6b,0x69,0x6e,0x5f,0x76,0x65,0x72,
    0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x69,0x6e,0x74,0x28,0x61,0x5f,0x62,0x6f,
    0x6e,0x65,0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,0x73,0x2e,0x77,0x29,0x20,0x2a,0x20,
    0x34,0x20,0x2b,0x20,0x32,0x5d,0x2c,0x20,0x73,0x6b,0x69,0x6e,0x5f,0x76,0x65,0x72,
    0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x69,0x6e,0x74,0x28,0x61,0x5f,0x62,0x6f,
    0x6e,0x65,0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,0x73,0x2e,0x77,0x29,0x20,0x2a,0x20,
    0x34,0x20,0x2b,0x20,0x33,0x5d,0x29,0x20,0x2a,0x20,0x61,0x5f,0x62,0x6f,0x6e,0x65,
    0x5f,0x77,0x65,0x69,0x67,0x68,0x74,0x73,0x2e,0x77,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x6d,0x61,0x74,0x34,0x20,0x5f,0x31,0x38,0x30,0x20,0x3d,0x20,0x6d,0x61,0x74,0x34,
    0x28,0x28,0x28,0x5f,0x31,0x31,0x34,0x5b,0x30,0x5d,0x20,0x2b,0x20,0x5f,0x31,0x32,
    0x33,0x5b,0x30,0x5d,0x29,0x20,0x2b,0x20,0x5f,0x31,0x34,0x35,0x5b,0x30,0x5d,0x29,
    0x20,0x2b,0x20,0x5f,0x31,0x36,0x37,0x5b,0x30,0x5d,0x2c,0x20,0x28,0x28,0x5f,0x31,
    0x31,0x34,0x5b,0x31,0x5d,0x20,0x2b,0x20,0x5f,0x31,0x32,0x33,0x5b,0x31,0x5d,0x29,
    0x20,0x2b,0x20,0x5f,0x31,0x34,0x35,0x5b,0x31,0x5d,0x29,0x20,0x2b,0x20,0x5f,0x31,
    0x36,0x37,0x5b,0x31,0x5d,0x2c,0x20,0x28,0x28,0x5f,0x31,0x31,0x34,0x5b,0x32,0x5d,
    0x20,0x2b,0x20,0x5f,0x31,0x32,0x33,0x5b,0x32,0x5d,0x29,0x20,0x2b,0x20,0x5f,0x31,
    0x34,0x35,0x5b,0x32,0x5d,0x29,0x20,0x2b,0x20,0x5f,0x31,0x36,0x37,0x5b,0x32,0x5d,
    0x2c,0x20,0x28,0x28,0x5f,0x31,0x31,0x34,0x5b,0x33,0x5d,0x20,0x2b,0x20,0x5f,0x31,
    0x32,0x33,0x5b,0x33,0x5d,0x29,0x20,0x2b,0x20,0x5f,0x31,0x34,0x35,0x5b,0x33,0x5d,
    0x29,0x20,0x2b,0x20,0x5f,0x31,0x36,0x37,0x5b,0x33,0x5d,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x6c,0x6f,0x63,0x61,0x6c,0x5f,0x70,0x6f,0x73,
    0x20,0x3d,0x20,0x61,0x5f,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,0x3d,0x20,0x69,
    0x6e,0x74,0x28,0x61,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x69,0x6e,0x64,0x65,
    0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x5f,0x31,0x39,
    0x30,0x20,0x3d,0x20,0x6c,0x6f,0x63,0x61,0x6c,0x5f,0x70,0x6f,0x73,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x5f,0x31,0x39,0x31,0x20,0x3d,0x20,0x5f,
    0x31,0x39,0x30,0x20,0x2b,0x20,0x65,0x76,0x61,0x6c,0x75,0x61,0x74,0x65,0x5f,0x62,
    0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6c,0x6f,0x63,0x61,0x6c,0x5f,0x70,0x6f,0x73,
    0x20,0x3d,0x20,0x5f,0x31,0x39,0x31,0x3b,0x0a,0x20,0x20,0x20,0x20,0x67,0x6c,0x5f,
    0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x6d,0x61,0x74,0x34,0x28,
    0x6d,0x65,0x73,0x68,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,
    0x38,0x5d,0x2c,0x20,0x6d,0x65,0x73,0x68,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,
    0x75,0x62,0x6f,0x5b,0x39,0x5d,0x2c,0x20,0x6d,0x65,0x73,0x68,0x5f,0x76,0x65,0x72,
    0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x31,0x30,0x5d,0x2c,0x20,0x6d,0x65,0x73,
    0x68,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x5b,0x31,0x31,0x5d,
    0x29,0x20,0x2a,0x20,0x76,0x65,0x63,0x34,0x28,0x28,0x5f,0x31,0x38,0x30,0x20,0x2a,
    0x20,0x76,0x65,0x63,0x34,0x28,0x5f,0x31,0x39,0x31,0x2c,0x20,0x31,0x2e,0x30,0x29,
    0x29,0x2e,0x78,0x79,0x7a,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x76,0x5f,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x20,0x3d,0x20,0x6e,0x6f,0x72,0x6d,
    0x61,0x6c,0x69,0x7a,0x65,0x28,0x28,0x5f,0x31,0x38,0x30,0x20,0x2a,0x20,0x76,0x65,
    0x63,0x34,0x28,0x61,0x5f,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x2c,0x20,0x30,0x2e,0x30,
    0x29,0x29,0x2e,0x78,0x79,0x7a,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x5f,0x75,
    0x76,0x20,0x3d,0x20,0x61,0x5f,0x75,0x76,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #version 330
    
    in vec3 v_normal;
    in vec2 v_uv;
    layout(location = 0) out vec4 o_color;
    
    void main()
    {
        float _33 = ((dot(v_normal, vec3(0.57735025882720947265625)) + (v_uv.x * 9.9999997473787516355514526367188e-05)) * 0.5) + 0.5;
        o_color = vec4(_33, _33, _33, 1.0);
    }
    
*/
static const char lit_pixel_source_glsl330[275] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x33,0x33,0x30,0x0a,0x0a,0x69,0x6e,
    0x20,0x76,0x65,0x63,0x33,0x20,0x76,0x5f,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x3b,0x0a,
    0x69,0x6e,0x20,0x76,0x65,0x63,0x32,0x20,0x76,0x5f,0x75,0x76,0x3b,0x0a,0x6c,0x61,
    0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,
    0x30,0x29,0x20,0x6f,0x75,0x74,0x20,0x76,0x65,0x63,0x34,0x20,0x6f,0x5f,0x63,0x6f,
    0x6c,0x6f,0x72,0x3b,0x0a,0x0a,0x76,0x6f,0x69,0x64,0x20,0x6d,0x61,0x69,0x6e,0x28,
    0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x33,
    0x33,0x20,0x3d,0x20,0x28,0x28,0x64,0x6f,0x74,0x28,0x76,0x5f,0x6e,0x6f,0x72,0x6d,
    0x61,0x6c,0x2c,0x20,0x76,0x65,0x63,0x33,0x28,0x30,0x2e,0x35,0x37,0x37,0x33,0x35,
    0x30,0x32,0x35,0x38,0x38,0x32,0x37,0x32,0x30,0x39,0x34,0x37,0x32,0x36,0x35,0x36,
    0x32,0x35,0x29,0x29,0x20,0x2b,0x20,0x28,0x76,0x5f,0x75,0x76,0x2e,0x78,0x20,0x2a,
    0x20,0x39,0x2e,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x34,0x37,0x33,0x37,0x38,0x37,
    0x35,0x31,0x36,0x33,0x35,0x35,0x35,0x31,0x34,0x35,0x32,0x36,0x33,0x36,0x37,0x31,
    0x38,0x38,0x65,0x2d,0x30,0x35,0x29,0x29,0x20,0x2a,0x20,0x30,0x2e,0x35,0x29,0x20,
    0x2b,0x20,0x30,0x2e,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x5f,0x63,0x6f,0x6c,
    0x6f,0x72,0x20,0x3d,0x20,0x76,0x65,0x63,0x34,0x28,0x5f,0x33,0x33,0x2c,0x20,0x5f,
    0x33,0x33,0x2c,0x20,0x5f,0x33,0x33,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x7d,
    0x0a,0x0a,0x00,
};
/*
    cbuffer mesh_vertex_ubo : register(b0)
    {
        row_major float4x4 _34_geometry_to_world : packoffset(c0);
        row_major float4x4 _34_normal_to_world : packoffset(c4);
        row_major float4x4 _34_world_to_clip : packoffset(c8);
        float4 _34_blend_weights[16] : packoffset(c12);
        float _34_f_num_blend_shapes : packoffset(c28);
    };
    
    Texture2DArray<float4> blend_shapes : register(t0);
    SamplerState _blend_shapes_sampler : register(s0);
    
    static float4 gl_Position;
    static float3 a_position;
    static float a_vertex_index;
    static float3 v_normal;
    static float3 a_normal;
    static float2 v_uv;
    static float2 a_uv;
    
    struct SPIRV_Cross_Input
    {
        float3 a_position : TEXCOORD0;
        float3 a_normal : TEXCOORD1;
        float2 a_uv : TEXCOORD2;
        float a_vertex_index : TEXCOORD3;
    };
    
    struct SPIRV_Cross_Output
    {
        float3 v_normal : TEXCOORD0;
        float2 v_uv : TEXCOORD1;
        float4 gl_Position : SV_Position;
    };
    
    #line 20 "mesh.glsl"
    float3 evaluate_blend_shape(int vertex_index)
    {
    #line 20 "mesh.glsl"
        int _21 = vertex_index & 2047;
        int _24 = vertex_index >> 11;
    #line 21 "mesh.glsl"
        int _39 = int(_34_f_num_blend_shapes);
    #line 22 "mesh.glsl"
        float3 offset = 0.0f.xxx;
    #line 23 "mesh.glsl"
        for (int i = 0; i < _39; i++)
        {
    #line 24 "mesh.glsl"
            float4 _packed = _34_blend_weights[i >> 2];
    #line 25 "mesh.glsl"
    #line 26 "mesh.glsl"
            offset += (blend_shapes.Load(int4(int3(_21, _24, i), 0)).xyz * _packed[i & 3]);
        }
    #line 28 "mesh.glsl"
        return offset;
    }
    
    #line 42 "mesh.glsl"
    void vert_main()
    {
    #line 42 "mesh.glsl"
        float3 local_pos = a_position;
    #line 43 "mesh.glsl"
        int param = int(a_vertex_index);
        float3 _104 = local_pos;
        float3 _105 = _104 + evaluate_blend_shape(param);
        local_pos = _105;
    #line 45 "mesh.glsl"
    #line 46 "mesh.glsl"
        gl_Position = mul(float4(mul(float4(_105, 1.0f), _34_geometry_to_world).xyz, 1.0f), _34_world_to_clip);
    #line 47 "mesh.glsl"
        v_normal = normalize(mul(float4(a_normal, 0.0f), _34_normal_to_world).xyz);
    #line 48 "mesh.glsl"
        v_uv = a_uv;
    }
    
    SPIRV_Cross_Output main(SPIRV_Cross_Input stage_input)
    {
        a_position = stage_input.a_position;
        a_vertex_index = stage_input.a_vertex_index;
        a_normal = stage_input.a_normal;
        a_uv = stage_input.a_uv;
        vert_main();
        SPIRV_Cross_Output stage_output;
        stage_output.gl_Position = gl_Position;
        stage_output.v_normal = v_normal;
        stage_output.v_uv = v_uv;
        return stage_output;
    }
*/
static const uint8_t static_vertex_bytecode_hlsl5[2276] = {
    0x44,0x58,0x42,0x43,0x6c,0xed,0xd7,0x37,0xf7,0x0a,0xfa,0x2c,0xe9,0x2d,0x2c,0x39,
    0x0f,0x86,0xc9,0xbd,0x01,0x00,0x00,0x00,0xe4,0x08,0x00,0x00,0x05,0x00,0x00,0x00,
    0x34,0x00,0x00,0x00,0xcc,0x02,0x00,0x00,0x48,0x03,0x00,0x00,0xb8,0x03,0x00,0x00,
    0x48,0x08,0x00,0x00,0x52,0x44,0x45,0x46,0x90,0x02,0x00,0x00,0x01,0x00,0x00,0x00,
    0x9c,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,0x05,0xfe,0xff,
    0x10,0x81,0x00,0x00,0x68,0x02,0x00,0x00,0x52,0x44,0x31,0x31,0x3c,0x00,0x00,0x00,
    0x18,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x28,0x00,0x00,0x00,0x24,0x00,0x00,0x00,
    0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7c,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
    0x05,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
    0x01,0x00,0x00,0x00,0x0d,0x00,0x00,0x00,0x89,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,
    0x61,0x70,0x65,0x73,0x00,0x6d,0x65,0x73,0x68,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,
    0x5f,0x75,0x62,0x6f,0x00,0xab,0xab,0xab,0x89,0x00,0x00,0x00,0x05,0x00,0x00,0x00,
    0xb4,0x00,0x00,0x00,0xd0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x7c,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
    0x9c,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
    0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0x00,0x40,0x00,0x00,0x00,
    0x40,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x9c,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
    0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
    0xd4,0x01,0x00,0x00,0x80,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
    0x9c,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
    0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xe6,0x01,0x00,0x00,0xc0,0x00,0x00,0x00,
    0x00,0x01,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,
    0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
    0x24,0x02,0x00,0x00,0xc0,0x01,0x00,0x00,0x04,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
    0x44,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
    0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x5f,0x33,0x34,0x5f,0x67,0x65,0x6f,0x6d,
    0x65,0x74,0x72,0x79,0x5f,0x74,0x6f,0x5f,0x77,0x6f,0x72,0x6c,0x64,0x00,0x66,0x6c,
    0x6f,0x61,0x74,0x34,0x78,0x34,0x00,0xab,0x02,0x00,0x03,0x00,0x04,0x00,0x04,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x01,0x00,0x00,0x5f,0x33,0x34,0x5f,
    0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x5f,0x74,0x6f,0x5f,0x77,0x6f,0x72,0x6c,0x64,0x00,
    0x5f,0x33,0x34,0x5f,0x77,0x6f,0x72,0x6c,0x64,0x5f,0x74,0x6f,0x5f,0x63,0x6c,0x69,
    0x70,0x00,0x5f,0x33,0x34,0x5f,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x77,0x65,0x69,0x67,
    0x68,0x74,0x73,0x00,0x66,0x6c,0x6f,0x61,0x74,0x34,0x00,0xab,0x01,0x00,0x03,0x00,
    0x01,0x00,0x04,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,
    0x5f,0x33,0x34,0x5f,0x66,0x5f,0x6e,0x75,0x6d,0x5f,0x62,0x6c,0x65,0x6e,0x64,0x5f,
    0x73,0x68,0x61,0x70,0x65,0x73,0x00,0x66,0x6c,0x6f,0x61,0x74,0x00,0xab,0xab,0xab,
    0x00,0x00,0x03,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x3b,0x02,0x00,0x00,0x4d,0x69,0x63,0x72,0x6f,0x73,0x6f,0x66,0x74,0x20,0x28,0x52,
    0x29,0x20,0x48,0x4c,0x53,0x4c,0x20,0x53,0x68,0x61,0x64,0x65,0x72,0x20,0x43,0x6f,
    0x6d,0x70,0x69,0x6c,0x65,0x72,0x20,0x31,0x30,0x2e,0x31,0x00,0x49,0x53,0x47,0x4e,
    0x74,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x68,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x07,0x07,0x00,0x00,0x68,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x03,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x07,0x07,0x00,0x00,0x68,0x00,0x00,0x00,
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
    0x03,0x03,0x00,0x00,0x68,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x03,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x54,0x45,0x58,0x43,
    0x4f,0x4f,0x52,0x44,0x00,0xab,0xab,0xab,0x4f,0x53,0x47,0x4e,0x68,0x00,0x00,0x00,
    0x03,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x08,0x00,0x00,
    0x50,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,
    0x01,0x00,0x00,0x00,0x03,0x0c,0x00,0x00,0x59,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
    0x54,0x45,0x58,0x43,0x4f,0x4f,0x52,0x44,0x00,0x53,0x56,0x5f,0x50,0x6f,0x73,0x69,
    0x74,0x69,0x6f,0x6e,0x00,0xab,0xab,0xab,0x53,0x48,0x45,0x58,0x88,0x04,0x00,0x00,
    0x50,0x00,0x01,0x00,0x22,0x01,0x00,0x00,0x6a,0x08,0x00,0x01,0x35,0x18,0x00,0x00,
    0x12,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x80,0x3f,0x59,0x08,0x00,0x04,0x46,0x8e,0x20,0x00,0x00,0x00,0x00,0x00,
    0x1d,0x00,0x00,0x00,0x58,0x40,0x00,0x04,0x00,0x70,0x10,0x00,0x00,0x00,0x00,0x00,
    0x55,0x55,0x00,0x00,0x5f,0x00,0x00,0x03,0x72,0x10,0x10,0x00,0x00,0x00,0x00,0x00,
    0x5f,0x00,0x00,0x03,0x72,0x10,0x10,0x00,0x01,0x00,0x00,0x00,0x5f,0x00,0x00,0x03,
    0x32,0x10,0x10,0x00,0x02,0x00,0x00,0x00,0x5f,0x00,0x00,0x03,0x12,0x10,0x10,0x00,
    0x03,0x00,0x00,0x00,0x65,0x00,0x00,0x03,0x72,0x20,0x10,0x00,0x00,0x00,0x00,0x00,
    0x65,0x00,0x00,0x03,0x32,0x20,0x10,0x00,0x01,0x00,0x00,0x00,0x67,0x00,0x00,0x04,
    0xf2,0x20,0x10,0x00,0x02,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x68,0x00,0x00,0x02,
    0x04,0x00,0x00,0x00,0x1b,0x00,0x00,0x05,0x12,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
    0x0a,0x10,0x10,0x00,0x03,0x00,0x00,0x00,0x01,0x00,0x00,0x07,0x12,0x00,0x10,0x00,
    0x01,0x00,0x00,0x00,0x0a,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x01,0x40,0x00,0x00,
    0xff,0x07,0x00,0x00,0x2a,0x00,0x00,0x07,0x22,0x00,0x10,0x00,0x01,0x00,0x00,0x00,
    0x0a,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x01,0x40,0x00,0x00,0x0b,0x00,0x00,0x00,
    0x1b,0x00,0x00,0x06,0x12,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x0a,0x80,0x20,0x00,
    0x00,0x00,0x00,0x00,0x1c,0x00,0x00,0x00,0x36,0x00,0x00,0x05,0x82,0x00,0x10,0x00,
    0x01,0x00,0x00,0x00,0x01,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x36,0x00,0x00,0x08,
    0xe2,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x02,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x36,0x00,0x00,0x05,
    0x42,0x00,0x10,0x00,0x01,0x00,0x00,0x00,0x01,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
    0x30,0x00,0x00,0x01,0x21,0x00,0x00,0x07,0x12,0x00,0x10,0x00,0x02,0x00,0x00,0x00,
    0x2a,0x00,0x10,0x00,0x01,0x00,0x00,0x00,0x0a,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
    0x03,0x00,0x04,0x03,0x0a,0x00,0x10,0x00,0x02,0x00,0x00,0x00,0x2a,0x00,0x00,0x07,
    0x12,0x00,0x10,0x00,0x02,0x00,0x00,0x00,0x2a,0x00,0x10,0x00,0x01,0x00,0x00,0x00,
    0x01,0x40,0x00,0x00,0x02,0x00,0x00,0x00,0x2d,0x00,0x00,0x89,0x02,0x02,0x00,0x80,
    0x43,0x55,0x15,0x00,0xe2,0x00,0x10,0x00,0x02,0x00,0x00,0x00,0x46,0x0e,0x10,0x00,
    0x01,0x00,0x00,0x00,0x36,0x79,0x10,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x07,
    0x12,0x00,0x10,0x00,0x03,0x00,0x00,0x00,0x2a,0x00,0x10,0x00,0x01,0x00,0x00,0x00,
    0x01,0x40,0x00,0x00,0x03,0x00,0x00,0x00,0x11,0x00,0x00,0x0b,0x12,0x00,0x10,0x00,
    0x02,0x00,0x00,0x00,0x46,0x8e,0x20,0x06,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,
    0x0a,0x00,0x10,0x00,0x02,0x00,0x00,0x00,0x46,0x9e,0x90,0x00,0x0a,0x00,0x10,0x00,
    0x03,0x00,0x00,0x00,0x32,0x00,0x00,0x09,0xe2,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
    0x56,0x0e,0x10,0x00,0x02,0x00,0x00,0x00,0x06,0x00,0x10,0x00,0x02,0x00,0x00,0x00,
    0x56,0x0e,0x10,0x00,0x00,0x00,0x00,0x00,0x1e,0x00,0x00,0x07,0x42,0x00,0x10,0x00,
    0x01,0x00,0x00,0x00,0x2a,0x00,0x10,0x00,0x01,0x00,0x00,0x00,0x01,0x40,0x00,0x00,
    0x01,0x00,0x00,0x00,0x16,0x00,0x00,0x01,0x00,0x00,0x00,0x07,0x72,0x00,0x10,0x00,
    0x00,0x00,0x00,0x00,0x96,0x07,0x10,0x00,0x00,0x00,0x00,0x00,0x46,0x12,0x10,0x00,
    0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x08,0x72,0x00,0x10,0x00,0x01,0x00,0x00,0x00,
    0x56,0x05,0x10,0x00,0x00,0x00,0x00,0x00,0x46,0x82,0x20,0x00,0x00,0x00,0x00,0x00,
    0x01,0x00,0x00,0x00,0x32,0x00,0x00,0x0a,0xb2,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
    0x06,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x46,0x88,0x20,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x46,0x08,0x10,0x00,0x01,0x00,0x00,0x00,0x32,0x00,0x00,0x0a,
    0x72,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0xa6,0x0a,0x10,0x00,0x00,0x00,0x00,0x00,
    0x46,0x82,0x20,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x46,0x03,0x10,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x72,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
    0x46,0x02,0x10,0x00,0x00,0x00,0x00,0x00,0x46,0x82,0x20,0x00,0x00,0x00,0x00,0x00,
    0x03,0x00,0x00,0x00,0x38,0x00,0x00,0x08,0xf2,0x00,0x10,0x00,0x01,0x00,0x00,0x00,
    0x56,0x05,0x10,0x00,0x00,0x00,0x00,0x00,0x46,0x8e,0x20,0x00,0x00,0x00,0x00,0x00,
    0x09,0x00,0x00,0x00,0x32,0x00,0x00,0x0a,0xf2,0x00,0x10,0x00,0x01,0x00,0x00,0x00,
    0x06,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x46,0x8e,0x20,0x00,0x00,0x00,0x00,0x00,
    0x08,0x00,0x00,0x00,0x46,0x0e,0x10,0x00,0x01,0x00,0x00,0x00,0x32,0x00,0x00,0x0a,
    0xf2,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0xa6,0x0a,0x10,0x00,0x00,0x00,0x00,0x00,
    0x46,0x8e,0x20,0x00,0x00,0x00,0x00,0x00,0x0a,0x00,0x00,0x00,0x46,0x0e,0x10,0x00,
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0xf2,0x20,0x10,0x00,0x02,0x00,0x00,0x00,
    0x46,0x0e,0x10,0x00,0x00,0x00,0x00,0x00,0x46,0x8e,0x20,0x00,0x00,0x00,0x00,0x00,
    0x0b,0x00,0x00,0x00,0x38,0x00,0x00,0x08,0x72,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
    0x56,0x15,0x10,0x00,0x01,0x00,0x00,0x00,0x46,0x82,0x20,0x00,0x00,0x00,0x00,0x00,
    0x05,0x00,0x00,0x00,0x32,0x00,0x00,0x0a,0x72,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
    0x06,0x10,0x10,0x00,0x01,0x00,0x00,0x00,0x46,0x82,0x20,0x00,0x00,0x00,0x00,0x00,
    0x04,0x00,0x00,0x00,0x46,0x02,0x10,0x00,0x00,0x00,0x00,0x00,0x32,0x00,0x00,0x0a,
    0x72,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0xa6,0x1a,0x10,0x00,0x01,0x00,0x00,0x00,
    0x46,0x82,0x20,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x46,0x02,0x10,0x00,
    0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x07,0x82,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
    0x46,0x02,0x10,0x00,0x00,0x00,0x00,0x00,0x46,0x02,0x10,0x00,0x00,0x00,0x00,0x00,
    0x44,0x00,0x00,0x05,0x82,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x3a,0x00,0x10,0x00,
    0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x07,0x72,0x20,0x10,0x00,0x00,0x00,0x00,0x00,
    0xf6,0x0f,0x10,0x00,0x00,0x00,0x00,0x00,0x46,0x02,0x10,0x00,0x00,0x00,0x00,0x00,
    0x36,0x00,0x00,0x05,0x32,0x20,0x10,0x00,0x01,0x00,0x00,0x00,0x46,0x10,0x10,0x00,
    0x02,0x00,0x00,0x00,0x3e,0x00,0x00,0x01,0x53,0x54,0x41,0x54,0x94,0x00,0x00,0x00,
    0x22,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x07,0x00,0x00,0x00,
    0x11,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,
};
/*
    cbuffer mesh_vertex_ubo : register(b0)
    {
        row_major float4x4 _34_geometry_to_world : packoffset(c0);
        row_major float4x4 _34_normal_to_world : packoffset(c4);
        row_major float4x4 _34_world_to_clip : packoffset(c8);
        float4 _34_blend_weights[16] : packoffset(c12);
        float _34_f_num_blend_shapes : packoffset(c28);
    };
    
    cbuffer skin_vertex_ubo : register(b1)
    {
        row_major float4x4 _100_bones[64] : packoffset(c0);
    };
    
    Texture2DArray<float4> blend_shapes : register(t0);
    SamplerState _blend_shapes_sampler : register(s0);
    
    static float4 gl_Position;
    static int4 a_bone_indices;
    static float4 a_bone_weights;
    static float3 a_position;
    static float a_vertex_index;
    static float3 a_normal;
    static float3 v_normal;
    static float2 v_uv;
    static float2 a_uv;
    
    struct SPIRV_Cross_Input
    {
        float3 a_position : TEXCOORD0;
        float3 a_normal : TEXCOORD1;
        float2 a_uv : TEXCOORD2;
        float a_vertex_index : TEXCOORD3;
        int4 a_bone_indices : TEXCOORD4;
        float4 a_bone_weights : TEXCOORD5;
    };
    
    struct SPIRV_Cross_Output
    {
        float3 v_normal : TEXCOORD0;
        float2 v_uv : TEXCOORD1;
        float4 gl_Position : SV_Position;
    };
    
    #line 20 "mesh.glsl"
    float3 evaluate_blend_shape(int vertex_index)
    {
    #line 20 "mesh.glsl"
        int _21 = vertex_index & 2047;
        int _24 = vertex_index >> 11;
    #line 21 "mesh.glsl"
        int _39 = int(_34_f_num_blend_shapes);
    #line 22 "mesh.glsl"
        float3 offset = 0.0f.xxx;
    #line 23 "mesh.glsl"
        for (int i = 0; i < _39; i++)
        {
    #line 24 "mesh.glsl"
            float4 _packed = _34_blend_weights[i >> 2];
    #line 25 "mesh.glsl"
    #line 26 "mesh.glsl"
            offset += (blend_shapes.Load(int4(int3(_21, _24, i), 0)).xyz * _packed[i & 3]);
        }
    #line 28 "mesh.glsl"
        return offset;
    }
    
    #line 52 "mesh.glsl"
    void vert_main()
    {
    #line 52 "mesh.glsl"
    #line 56 "mesh.glsl"
    #line 55 "mesh.glsl"
    #line 54 "mesh.glsl"
    #line 53 "mesh.glsl"
        float4x4 _116 = _100_bones[a_bone_indices.x] * a_bone_weights.x;
    #line 54 "mesh.glsl"
        float4x4 _124 = _100_bones[a_bone_indices.y] * a_bone_weights.y;
    #line 55 "mesh.glsl"
        float4x4 _145 = _100_bones[a_bone_indices.z] * a_bone_weights.z;
    #line 56 "mesh.glsl"
        float4x4 _166 = _100_bones[a_bone_indices.w] * a_bone_weights.w;
        float4x4 _179 = float4x4(((_116[0] + _124[0]) + _145[0]) + _166[0], ((_116[1] + _124[1]) + _145[1]) + _166[1], ((_116[2] + _124[2]) + _145[2]) + _166[2], ((_116[3] + _124[3]) + _145[3]) + _166[3]);
    #line 58 "mesh.glsl"
        float3 local_pos = a_position;
    #line 59 "mesh.glsl"
        int param = int(a_vertex_index);
        float3 _189 = local_pos;
        float3 _190 = _189 + evaluate_blend_shape(param);
        local_pos = _190;
    #line 60 "mesh.glsl"
    #line 61 "mesh.glsl"
    #line 63 "mesh.glsl"
        gl_Position = mul(float4(mul(float4(_190, 1.0f), _179).xyz, 1.0f), _34_world_to_clip);
    #line 64 "mesh.glsl"
        v_normal = normalize(mul(float4(a_normal, 0.0f), _179).xyz);
    #line 65 "mesh.glsl"
        v_uv = a_uv;
    }
    
    SPIRV_Cross_Output main(SPIRV_Cross_Input stage_input)
    {
        a_bone_indices = stage_input.a_bone_indices;
        a_bone_weights = stage_input.a_bone_weights;
        a_position = stage_input.a_position;
        a_vertex_index = stage_input.a_vertex_index;
        a_normal = stage_input.a_normal;
        a_uv = stage_input.a_uv;
        vert_main();
        SPIRV_Cross_Output stage_output;
        stage_output.gl_Position = gl_Position;
        stage_output.v_normal = v_normal;
        stage_output.v_uv = v_uv;
        return stage_output;
    }
*/
static const uint8_t skinned_vertex_bytecode_hlsl5[3256] = {
    0x44,0x58,0x42,0x43,0x5a,0x40,0xb2,0x39,0x29,0x69,0xf1,0xab,0x52,0xfb,0x80,0xe4,
    0xe1,0xd6,0xbd,0x80,0x01,0x00,0x00,0x00,0xb8,0x0c,0x00,0x00,0x05,0x00,0x00,0x00,
    0x34,0x00,0x00,0x00,0x6c,0x03,0x00,0x00,0x18,0x04,0x00,0x00,0x88,0x04,0x00,0x00,
    0x1c,0x0c,0x00,0x00,0x52,0x44,0x45,0x46,0x30,0x03,0x00,0x00,0x02,0x00,0x00,0x00,
    0xcc,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,0x05,0xfe,0xff,
    0x10,0x81,0x00,0x00,0x08,0x03,0x00,0x00,0x52,0x44,0x31,0x31,0x3c,0x00,0x00,0x00,
    0x18,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x28,0x00,0x00,0x00,0x24,0x00,0x00,0x00,
    0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9c,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
    0x05,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
    0x01,0x00,0x00,0x00,0x0d,0x00,0x00,0x00,0xa9,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0xb9,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,
    0x61,0x70,0x65,0x73,0x00,0x6d,0x65,0x73,0x68,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,
    0x5f,0x75,0x62,0x6f,0x00,0x73,0x6b,0x69,0x6e,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,
    0x5f,0x75,0x62,0x6f,0x00,0xab,0xab,0xab,0xa9,0x00,0x00,0x00,0x05,0x00,0x00,0x00,
    0xfc,0x00,0x00,0x00,0xd0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0xb9,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0xb0,0x02,0x00,0x00,0x00,0x10,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc4,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
    0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe4,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
    0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
    0x08,0x02,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0xe4,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
    0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x1c,0x02,0x00,0x00,0x80,0x00,0x00,0x00,
    0x40,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0xe4,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
    0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
    0x2e,0x02,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x02,0x00,0x00,0x00,
    0x48,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
    0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x6c,0x02,0x00,0x00,0xc0,0x01,0x00,0x00,
    0x04,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x8c,0x02,0x00,0x00,0x00,0x00,0x00,0x00,
    0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
    0x5f,0x33,0x34,0x5f,0x67,0x65,0x6f,0x6d,0x65,0x74,0x72,0x79,0x5f,0x74,0x6f,0x5f,
    0x77,0x6f,0x72,0x6c,0x64,0x00,0x66,0x6c,0x6f,0x61,0x74,0x34,0x78,0x34,0x00,0xab,
    0x02,0x00,0x03,0x00,0x04,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0xda,0x01,0x00,0x00,0x5f,0x33,0x34,0x5f,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x5f,0x74,
    0x6f,0x5f,0x77,0x6f,0x72,0x6c,0x64,0x00,0x5f,0x33,0x34,0x5f,0x77,0x6f,0x72,0x6c,
    0x64,0x5f,0x74,0x6f,0x5f,0x63,0x6c,0x69,0x70,0x00,0x5f,0x33,0x34,0x5f,0x62,0x6c,
    0x65,0x6e,0x64,0x5f,0x77,0x65,0x69,0x67,0x68,0x74,0x73,0x00,0x66,0x6c,0x6f,0x61,
    0x74,0x34,0x00,0xab,0x01,0x00,0x03,0x00,0x01,0x00,0x04,0x00,0x10,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x40,0x02,0x00,0x00,0x5f,0x33,0x34,0x5f,0x66,0x5f,0x6e,0x75,
    0x6d,0x5f,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,0x65,0x73,0x00,0x66,
    0x6c,0x6f,0x61,0x74,0x00,0xab,0xab,0xab,0x00,0x00,0x03,0x00,0x01,0x00,0x01,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x83,0x02,0x00,0x00,0xd8,0x02,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x02,0x00,0x00,0x00,0xe4,0x02,0x00,0x00,
    0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,
    0x00,0x00,0x00,0x00,0x5f,0x31,0x30,0x30,0x5f,0x62,0x6f,0x6e,0x65,0x73,0x00,0xab,
    0x02,0x00,0x03,0x00,0x04,0x00,0x04,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0xda,0x01,0x00,0x00,0x4d,0x69,0x63,0x72,0x6f,0x73,0x6f,0x66,0x74,0x20,0x28,0x52,
    0x29,0x20,0x48,0x4c,0x53,0x4c,0x20,0x53,0x68,0x61,0x64,0x65,0x72,0x20,0x43,0x6f,
    0x6d,0x70,0x69,0x6c,0x65,0x72,0x20,0x31,0x30,0x2e,0x31,0x00,0x49,0x53,0x47,0x4e,
    0xa4,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x98,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x07,0x07,0x00,0x00,0x98,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x03,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x07,0x07,0x00,0x00,0x98,0x00,0x00,0x00,
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
    0x03,0x03,0x00,0x00,0x98,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x03,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x98,0x00,0x00,0x00,
    0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x04,0x00,0x00,0x00,
    0x0f,0x0f,0x00,0x00,0x98,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x03,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x0f,0x0f,0x00,0x00,0x54,0x45,0x58,0x43,
    0x4f,0x4f,0x52,0x44,0x00,0xab,0xab,0xab,0x4f,0x53,0x47,0x4e,0x68,0x00,0x00,0x00,
    0x03,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x08,0x00,0x00,
    0x50,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,
    0x01,0x00,0x00,0x00,0x03,0x0c,0x00,0x00,0x59,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
    0x54,0x45,0x58,0x43,0x4f,0x4f,0x52,0x44,0x00,0x53,0x56,0x5f,0x50,0x6f,0x73,0x69,
    0x74,0x69,0x6f,0x6e,0x00,0xab,0xab,0xab,0x53,0x48,0x45,0x58,0x8c,0x07,0x00,0x00,
    0x50,0x00,0x01,0x00,0xe3,0x01,0x00,0x00,0x6a,0x08,0x00,0x01,0x35,0x18,0x00,0x00,
    0x12,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x80,0x3f,0x59,0x08,0x00,0x04,0x46,0x8e,0x20,0x00,0x00,0x00,0x00,0x00,
    0x1d,0x00,0x00,0x00,0x59,0x08,0x00,0x04,0x46,0x8e,0x20,0x00,0x01,0x00,0x00,0x00,
    0x00,0x01,0x00,0x00,0x58,0x40,0x00,0x04,0x00,0x70,0x10,0x00,0x00,0x00,0x00,0x00,
    0x55,0x55,0x00,0x00,0x5f,0x00,0x00,0x03,0x72,0x10,0x10,0x00,0x00,0x00,0x00,0x00,
    0x5f,0x00,0x00,0x03,0x72,0x10,0x10,0x00,0x01,0x00,0x00,0x00,0x5f,0x00,0x00,0x03,
    0x32,0x10,0x10,0x00,0x02,0x00,0x00,0x00,0x5f,0x00,0x00,0x03,0x12,0x10,0x10,0x00,
    0x03,0x00,0x00,0x00,0x5f,0x00,0x00,0x03,0xf2,0x10,0x10,0x00,0x04,0x00,0x00,0x00,
    0x5f,0x00,0x00,0x03,0xf2,0x10,0x10,0x00,0x05,0x00,0x00,0x00,0x65,0x00,0x00,0x03,
    0x72,0x20,0x10,0x00,0x00,0x00,0x00,0x00,0x65,0x00,0x00,0x03,0x32,0x20,0x10,0x00,
    0x01,0x00,0x00,0x00,0x67,0x00,0x00,0x04,0xf2,0x20,0x10,0x00,0x02,0x00,0x00,0x00,
    0x01,0x00,0x00,0x00,0x68,0x00,0x00,0x02,0x07,0x00,0x00,0x00,0x29,0x00,0x00,0x0a,
    0xf2,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x46,0x1e,0x10,0x00,0x04,0x00,0x00,0x00,
    0x02,0x40,0x00,0x00,0x02,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
    0x02,0x00,0x00,0x00,0x38,0x00,0x00,0x09,0x72,0x00,0x10,0x00,0x01,0x00,0x00,0x00,
    0x56,0x15,0x10,0x00,0x05,0x00,0x00,0x00,0x46,0x82,0x20,0x04,0x01,0x00,0x00,0x00,
    0x1a,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x0a,0x72,0x00,0x10,0x00,
    0x02,0x00,0x00,0x00,0x56,0x15,0x10,0x00,0x05,0x00,0x00,0x00,0x46,0x82,0x20,0x06,
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x1a,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
    0x38,0x00,0x00,0x0a,0x72,0x00,0x10,0x00,0x03,0x00,0x00,0x00,0x56,0x15,0x10,0x00,
    0x05,0x00,0x00,0x00,0x46,0x82,0x20,0x06,0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
    0x1a,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x0a,0x72,0x00,0x10,0x00,
    0x04,0x00,0x00,0x00,0x56,0x15,0x10,0x00,0x05,0x00,0x00,0x00,0x46,0x82,0x20,0x06,
    0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x1a,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
    0x32,0x00,0x00,0x0b,0x72,0x00,0x10,0x00,0x01,0x00,0x00,0x00,0x46,0x82,0x20,0x04,
    0x01,0x00,0x00,0x00,0x0a,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x06,0x10,0x10,0x00,
    0x05,0x00,0x00,0x00,0x46,0x02,0x10,0x00,0x01,0x00,0x00,0x00,0x32,0x00,0x00,0x0b,
    0x72,0x00,0x10,0x00,0x01,0x00,0x00,0x00,0x46,0x82,0x20,0x04,0x01,0x00,0x00,0x00,
    0x2a,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0xa6,0x1a,0x10,0x00,0x05,0x00,0x00,0x00,
    0x46,0x02,0x10,0x00,0x01,0x00,0x00,0x00,0x32,0x00,0x00,0x0b,0x72,0x00,0x10,0x00,
    0x01,0x00,0x00,0x00,0x46,0x82,0x20,0x04,0x01,0x00,0x00,0x00,0x3a,0x00,0x10,0x00,
    0x00,0x00,0x00,0x00,0xf6,0x1f,0x10,0x00,0x05,0x00,0x00,0x00,0x46,0x02,0x10,0x00,
    0x01,0x00,0x00,0x00,0x32,0x00,0x00,0x0c,0x72,0x00,0x10,0x00,0x02,0x00,0x00,0x00,
    0x46,0x82,0x20,0x06,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x0a,0x00,0x10,0x00,
    0x00,0x00,0x00,0x00,0x06,0x10,0x10,0x00,0x05,0x00,0x00,0x00,0x46,0x02,0x10,0x00,
    0x02,0x00,0x00,0x00,0x32,0x00,0x00,0x0c,0x72,0x00,0x10,0x00,0x02,0x00,0x00,0x00,
    0x46,0x82,0x20,0x06,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x2a,0x00,0x10,0x00,
    0x00,0x00,0x00,0x00,0xa6,0x1a,0x10,0x00,0x05,0x00,0x00,0x00,0x46,0x02,0x10,0x00,
    0x02,0x00,0x00,0x00,0x32,0x00,0x00,0x0c,0x72,0x00,0x10,0x00,0x02,0x00,0x00,0x00,
    0x46,0x82,0x20,0x06,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x3a,0x00,0x10,0x00,
    0x00,0x00,0x00,0x00,0xf6,0x1f,0x10,0x00,0x05,0x00,0x00,0x00,0x46,0x02,0x10,0x00,
    0x02,0x00,0x00,0x00,0x32,0x00,0x00,0x0c,0x72,0x00,0x10,0x00,0x03,0x00,0x00,0x00,
    0x46,0x82,0x20,0x06,0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x0a,0x00,0x10,0x00,
    0x00,0x00,0x00,0x00,0x06,0x10,0x10,0x00,0x05,0x00,0x00,0x00,0x46,0x02,0x10,0x00,
    0x03,0x00,0x00,0x00,0x32,0x00,0x00,0x0c,0x72,0x00,0x10,0x00,0x03,0x00,0x00,0x00,
    0x46,0x82,0x20,0x06,0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x2a,0x00,0x10,0x00,
    0x00,0x00,0x00,0x00,0xa6,0x1a,0x10,0x00,0x05,0x00,0x00,0x00,0x46,0x02,0x10,0x00,
    0x03,0x00,0x00,0x00,0x32,0x00,0x00,0x0c,0x72,0x00,0x10,0x00,0x03,0x00,0x00,0x00,
    0x46,0x82,0x20,0x06,0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x3a,0x00,0x10,0x00,
    0x00,0x00,0x00,0x00,0xf6,0x1f,0x10,0x00,0x05,0x00,0x00,0x00,0x46,0x02,0x10,0x00,
    0x03,0x00,0x00,0x00,0x32,0x00,0x00,0x0c,0x72,0x00,0x10,0x00,0x04,0x00,0x00,0x00,
    0x46,0x82,0x20,0x06,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x0a,0x00,0x10,0x00,
    0x00,0x00,0x00,0x00,0x06,0x10,0x10,0x00,0x05,0x00,0x00,0x00,0x46,0x02,0x10,0x00,
    0x04,0x00,0x00,0x00,0x32,0x00,0x00,0x0c,0x72,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
    0x46,0x82,0x20,0x06,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x2a,0x00,0x10,0x00,
    0x00,0x00,0x00,0x00,0xa6,0x1a,0x10,0x00,0x05,0x00,0x00,0x00,0x46,0x02,0x10,0x00,
    0x04,0x00,0x00,0x00,0x32,0x00,0x00,0x0c,0x72,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
    0x46,0x82,0x20,0x06,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x3a,0x00,0x10,0x00,
    0x00,0x00,0x00,0x00,0xf6,0x1f,0x10,0x00,0x05,0x00,0x00,0x00,0x46,0x02,0x10,0x00,
    0x00,0x00,0x00,0x00,0x1b,0x00,0x00,0x05,0x82,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
    0x0a,0x10,0x10,0x00,0x03,0x00,0x00,0x00,0x01,0x00,0x00,0x07,0x12,0x00,0x10,0x00,
    0x04,0x00,0x00,0x00,0x3a,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x01,0x40,0x00,0x00,
    0xff,0x07,0x00,0x00,0x2a,0x00,0x00,0x07,0x22,0x00,0x10,0x00,0x04,0x00,0x00,0x00,
    0x3a,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x01,0x40,0x00,0x00,0x0b,0x00,0x00,0x00,
    0x1b,0x00,0x00,0x06,0x82,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x0a,0x80,0x20,0x00,
    0x00,0x00,0x00,0x00,0x1c,0x00,0x00,0x00,0x36,0x00,0x00,0x05,0x82,0x00,0x10,0x00,
    0x04,0x00,0x00,0x00,0x01,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x36,0x00,0x00,0x08,
    0x72,0x00,0x10,0x00,0x05,0x00,0x00,0x00,0x02,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x36,0x00,0x00,0x05,
    0x42,0x00,0x10,0x00,0x04,0x00,0x00,0x00,0x01,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
    0x30,0x00,0x00,0x01,0x21,0x00,0x00,0x07,0x82,0x00,0x10,0x00,0x01,0x00,0x00,0x00,
    0x2a,0x00,0x10,0x00,0x04,0x00,0x00,0x00,0x3a,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
    0x03,0x00,0x04,0x03,0x3a,0x00,0x10,0x00,0x01,0x00,0x00,0x00,0x2a,0x00,0x00,0x07,
    0x82,0x00,0x10,0x00,0x01,0x00,0x00,0x00,0x2a,0x00,0x10,0x00,0x04,0x00,0x00,0x00,
    0x01,0x40,0x00,0x00,0x02,0x00,0x00,0x00,0x2d,0x00,0x00,0x89,0x02,0x02,0x00,0x80,
    0x43,0x55,0x15,0x00,0x72,0x00,0x10,0x00,0x06,0x00,0x00,0x00,0x46,0x0e,0x10,0x00,
    0x04,0x00,0x00,0x00,0x46,0x7e,0x10,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x07,
    0x82,0x00,0x10,0x00,0x02,0x00,0x00,0x00,0x2a,0x00,0x10,0x00,0x04,0x00,0x00,0x00,
    0x01,0x40,0x00,0x00,0x03,0x00,0x00,0x00,0x11,0x00,0x00,0x0b,0x82,0x00,0x10,0x00,
    0x01,0x00,0x00,0x00,0x46,0x8e,0x20,0x06,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,
    0x3a,0x00,0x10,0x00,0x01,0x00,0x00,0x00,0x46,0x9e,0x90,0x00,0x3a,0x00,0x10,0x00,
    0x02,0x00,0x00,0x00,0x32,0x00,0x00,0x09,0x72,0x00,0x10,0x00,0x05,0x00,0x00,0x00,
    0x46,0x02,0x10,0x00,0x06,0x00,0x00,0x00,0xf6,0x0f,0x10,0x00,0x01,0x00,0x00,0x00,
    0x46,0x02,0x10,0x00,0x05,0x00,0x00,0x00,0x1e,0x00,0x00,0x07,0x42,0x00,0x10,0x00,
    0x04,0x00,0x00,0x00,0x2a,0x00,0x10,0x00,0x04,0x00,0x00,0x00,0x01,0x40,0x00,0x00,
    0x01,0x00,0x00,0x00,0x16,0x00,0x00,0x01,0x00,0x00,0x00,0x07,0x72,0x00,0x10,0x00,
    0x04,0x00,0x00,0x00,0x46,0x02,0x10,0x00,0x05,0x00,0x00,0x00,0x46,0x12,0x10,0x00,
    0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x07,0x72,0x00,0x10,0x00,0x05,0x00,0x00,0x00,
    0x46,0x02,0x10,0x00,0x02,0x00,0x00,0x00,0x56,0x05,0x10,0x00,0x04,0x00,0x00,0x00,
    0x32,0x00,0x00,0x09,0xb2,0x00,0x10,0x00,0x04,0x00,0x00,0x00,0x06,0x00,0x10,0x00,
    0x04,0x00,0x00,0x00,0x46,0x08,0x10,0x00,0x01,0x00,0x00,0x00,0x46,0x08,0x10,0x00,
    0x05,0x00,0x00,0x00,0x32,0x00,0x00,0x09,0x72,0x00,0x10,0x00,0x04,0x00,0x00,0x00,
    0xa6,0x0a,0x10,0x00,0x04,0x00,0x00,0x00,0x46,0x02,0x10,0x00,0x03,0x00,0x00,0x00,
    0x46,0x03,0x10,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x72,0x00,0x10,0x00,
    0x00,0x00,0x00,0x00,0x46,0x02,0x10,0x00,0x00,0x00,0x00,0x00,0x46,0x02,0x10,0x00,
    0x04,0x00,0x00,0x00,0x38,0x00,0x00,0x08,0xf2,0x00,0x10,0x00,0x04,0x00,0x00,0x00,
    0x56,0x05,0x10,0x00,0x00,0x00,0x00,0x00,0x46,0x8e,0x20,0x00,0x00,0x00,0x00,0x00,
    0x09,0x00,0x00,0x00,0x32,0x00,0x00,0x0a,0xf2,0x00,0x10,0x00,0x04,0x00,0x00,0x00,
    0x06,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x46,0x8e,0x20,0x00,0x00,0x00,0x00,0x00,
    0x08,0x00,0x00,0x00,0x46,0x0e,0x10,0x00,0x04,0x00,0x00,0x00,0x32,0x00,0x00,0x0a,
    0xf2,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0xa6,0x0a,0x10,0x00,0x00,0x00,0x00,0x00,
    0x46,0x8e,0x20,0x00,0x00,0x00,0x00,0x00,0x0a,0x00,0x00,0x00,0x46,0x0e,0x10,0x00,
    0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0xf2,0x20,0x10,0x00,0x02,0x00,0x00,0x00,
    0x46,0x0e,0x10,0x00,0x00,0x00,0x00,0x00,0x46,0x8e,0x20,0x00,0x00,0x00,0x00,0x00,
    0x0b,0x00,0x00,0x00,0x38,0x00,0x00,0x07,0x72,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
    0x46,0x02,0x10,0x00,0x02,0x00,0x00,0x00,0x56,0x15,0x10,0x00,0x01,0x00,0x00,0x00,
    0x32,0x00,0x00,0x09,0x72,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x06,0x10,0x10,0x00,
    0x01,0x00,0x00,0x00,0x46,0x02,0x10,0x00,0x01,0x00,0x00,0x00,0x46,0x02,0x10,0x00,
    0x00,0x00,0x00,0x00,0x32,0x00,0x00,0x09,0x72,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
    0xa6,0x1a,0x10,0x00,0x01,0x00,0x00,0x00,0x46,0x02,0x10,0x00,0x03,0x00,0x00,0x00,
    0x46,0x02,0x10,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x07,0x82,0x00,0x10,0x00,
    0x00,0x00,0x00,0x00,0x46,0x02,0x10,0x00,0x00,0x00,0x00,0x00,0x46,0x02,0x10,0x00,
    0x00,0x00,0x00,0x00,0x44,0x00,0x00,0x05,0x82,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
    0x3a,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x07,0x72,0x20,0x10,0x00,
    0x00,0x00,0x00,0x00,0xf6,0x0f,0x10,0x00,0x00,0x00,0x00,0x00,0x46,0x02,0x10,0x00,
    0x00,0x00,0x00,0x00,0x36,0x00,0x00,0x05,0x32,0x20,0x10,0x00,0x01,0x00,0x00,0x00,
    0x46,0x10,0x10,0x00,0x02,0x00,0x00,0x00,0x3e,0x00,0x00,0x01,0x53,0x54,0x41,0x54,
    0x94,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x04,0x00,0x00,0x00,
    0x09,0x00,0x00,0x00,0x21,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};
/*
    static float3 v_normal;
    static float2 v_uv;
    static float4 o_color;
    
    struct SPIRV_Cross_Input
    {
        float3 v_normal : TEXCOORD0;
        float2 v_uv : TEXCOORD1;
    };
    
    struct SPIRV_Cross_Output
    {
        float4 o_color : SV_Target0;
    };
    
    #line 14 "mesh.glsl"
    void frag_main()
    {
    #line 14 "mesh.glsl"
    #line 15 "mesh.glsl"
    #line 16 "mesh.glsl"
        float _33 = ((dot(v_normal, 0.57735025882720947265625f.xxx) + (v_uv.x * 9.9999997473787516355514526367188e-05f)) * 0.5f) + 0.5f;
    #line 17 "mesh.glsl"
        o_color = float4(_33, _33, _33, 1.0f);
    }
    
    SPIRV_Cross_Output main(SPIRV_Cross_Input stage_input)
    {
        v_normal = stage_input.v_normal;
        v_uv = stage_input.v_uv;
        frag_main();
        SPIRV_Cross_Output stage_output;
        stage_output.o_color = o_color;
        return stage_output;
    }
*/
static const uint8_t lit_pixel_bytecode_hlsl5[668] = {
    0x44,0x58,0x42,0x43,0x50,0xf7,0x82,0xcc,0x02,0xd4,0xfd,0xd7,0x10,0x5d,0x90,0x3b,
    0x73,0xee,0x77,0x0c,0x01,0x00,0x00,0x00,0x9c,0x02,0x00,0x00,0x05,0x00,0x00,0x00,
    0x34,0x00,0x00,0x00,0xa0,0x00,0x00,0x00,0xec,0x00,0x00,0x00,0x20,0x01,0x00,0x00,
    0x00,0x02,0x00,0x00,0x52,0x44,0x45,0x46,0x64,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,0x05,0xff,0xff,
    0x10,0x81,0x00,0x00,0x3c,0x00,0x00,0x00,0x52,0x44,0x31,0x31,0x3c,0x00,0x00,0x00,
    0x18,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x28,0x00,0x00,0x00,0x24,0x00,0x00,0x00,
    0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4d,0x69,0x63,0x72,0x6f,0x73,0x6f,0x66,
    0x74,0x20,0x28,0x52,0x29,0x20,0x48,0x4c,0x53,0x4c,0x20,0x53,0x68,0x61,0x64,0x65,
    0x72,0x20,0x43,0x6f,0x6d,0x70,0x69,0x6c,0x65,0x72,0x20,0x31,0x30,0x2e,0x31,0x00,
    0x49,0x53,0x47,0x4e,0x44,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x08,0x00,0x00,0x00,
    0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x07,0x07,0x00,0x00,0x38,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x03,0x01,0x00,0x00,
    0x54,0x45,0x58,0x43,0x4f,0x4f,0x52,0x44,0x00,0xab,0xab,0xab,0x4f,0x53,0x47,0x4e,
    0x2c,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x20,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x0f,0x00,0x00,0x00,0x53,0x56,0x5f,0x54,0x61,0x72,0x67,0x65,0x74,0x00,0xab,0xab,
    0x53,0x48,0x45,0x58,0xd8,0x00,0x00,0x00,0x50,0x00,0x00,0x00,0x36,0x00,0x00,0x00,
    0x6a,0x08,0x00,0x01,0x62,0x10,0x00,0x03,0x72,0x10,0x10,0x00,0x00,0x00,0x00,0x00,
    0x62,0x10,0x00,0x03,0x12,0x10,0x10,0x00,0x01,0x00,0x00,0x00,0x65,0x00,0x00,0x03,
    0xf2,0x20,0x10,0x00,0x00,0x00,0x00,0x00,0x68,0x00,0x00,0x02,0x01,0x00,0x00,0x00,
    0x10,0x00,0x00,0x0a,0x12,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x46,0x12,0x10,0x00,
    0x00,0x00,0x00,0x00,0x02,0x40,0x00,0x00,0x3a,0xcd,0x13,0x3f,0x3a,0xcd,0x13,0x3f,
    0x3a,0xcd,0x13,0x3f,0x00,0x00,0x00,0x00,0x32,0x00,0x00,0x09,0x12,0x00,0x10,0x00,
    0x00,0x00,0x00,0x00,0x0a,0x10,0x10,0x00,0x01,0x00,0x00,0x00,0x01,0x40,0x00,0x00,
    0x17,0xb7,0xd1,0x38,0x0a,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x32,0x00,0x00,0x0f,
    0x72,0x20,0x10,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
    0x02,0x40,0x00,0x00,0x00,0x00,0x00,0x3f,0x00,0x00,0x00,0x3f,0x00,0x00,0x00,0x3f,
    0x00,0x00,0x00,0x00,0x02,0x40,0x00,0x00,0x00,0x00,0x00,0x3f,0x00,0x00,0x00,0x3f,
    0x00,0x00,0x00,0x3f,0x00,0x00,0x00,0x00,0x36,0x00,0x00,0x05,0x82,0x20,0x10,0x00,
    0x00,0x00,0x00,0x00,0x01,0x40,0x00,0x00,0x00,0x00,0x80,0x3f,0x3e,0x00,0x00,0x01,
    0x53,0x54,0x41,0x54,0x94,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};
/*
    #pragma clang diagnostic ignored "-Wmissing-prototypes"
    
    #include <metal_stdlib>
    #include <simd/simd.h>
    
    using namespace metal;
    
    struct mesh_vertex_ubo
    {
        float4x4 geometry_to_world;
        float4x4 normal_to_world;
        float4x4 world_to_clip;
        float4 blend_weights[16];
        float f_num_blend_shapes;
    };
    
    struct main0_out
    {
        float3 v_normal [[user(locn0)]];
        float2 v_uv [[user(locn1)]];
        float4 gl_Position [[position]];
    };
    
    struct main0_in
    {
        float3 a_position [[attribute(0)]];
        float3 a_normal [[attribute(1)]];
        float2 a_uv [[attribute(2)]];
        float a_vertex_index [[attribute(3)]];
    };
    
    #line 20 "mesh.glsl"
    static inline __attribute__((always_inline))
    float3 evaluate_blend_shape(thread const int& vertex_index, constant mesh_vertex_ubo& v_34, thread texture2d_array<float> blend_shapes, thread const sampler blend_shapesSmplr)
    {
    #line 20 "mesh.glsl"
        int _21 = vertex_index & 2047;
        int _24 = vertex_index >> 11;
    #line 21 "mesh.glsl"
        int _39 = int(v_34.f_num_blend_shapes);
    #line 22 "mesh.glsl"
        float3 offset = float3(0.0);
    #line 23 "mesh.glsl"
        for (int i = 0; i < _39; i++)
        {
    #line 24 "mesh.glsl"
            float4 _packed = v_34.blend_weights[i >> 2];
    #line 25 "mesh.glsl"
    #line 26 "mesh.glsl"
            int3 _81 = int3(_21, _24, i);
            offset += (blend_shapes.read(uint2(_81.xy), uint(_81.z), 0).xyz * _packed[i & 3]);
        }
    #line 28 "mesh.glsl"
        return offset;
    }
    
    #line 42 "mesh.glsl"
    vertex main0_out main0(main0_in in [[stage_in]], constant mesh_vertex_ubo& v_34 [[buffer(0)]], texture2d_array<float> blend_shapes [[texture(0)]], sampler blend_shapesSmplr [[sampler(0)]])
    {
        main0_out out = {};
    #line 42 "mesh.glsl"
        float3 local_pos = in.a_position;
    #line 43 "mesh.glsl"
        int param = int(in.a_vertex_index);
        float3 _104 = local_pos;
        float3 _105 = _104 + evaluate_blend_shape(param, v_34, blend_shapes, blend_shapesSmplr);
        local_pos = _105;
    #line 45 "mesh.glsl"
    #line 46 "mesh.glsl"
        out.gl_Position = v_34.world_to_clip * float4((v_34.geometry_to_world * float4(_105, 1.0)).xyz, 1.0);
    #line 47 "mesh.glsl"
        out.v_normal = fast::normalize((v_34.normal_to_world * float4(in.a_normal, 0.0)).xyz);
    #line 48 "mesh.glsl"
        out.v_uv = in.a_uv;
        return out;
    }
    
*/
static const char static_vertex_source_metal_macos[2248] = {
    0x23,0x70,0x72,0x61,0x67,0x6d,0x61,0x20,0x63,0x6c,0x61,0x6e,0x67,0x20,0x64,0x69,
    0x61,0x67,0x6e,0x6f,0x73,0x74,0x69,0x63,0x20,0x69,0x67,0x6e,0x6f,0x72,0x65,0x64,
    0x20,0x22,0x2d,0x57,0x6d,0x69,0x73,0x73,0x69,0x6e,0x67,0x2d,0x70,0x72,0x6f,0x74,
    0x6f,0x74,0x79,0x70,0x65,0x73,0x22,0x0a,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,
    0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,
    0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,
    0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,
    0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,
    0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x65,0x73,0x68,0x5f,0x76,0x65,0x72,
    0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x34,0x78,0x34,0x20,0x67,0x65,0x6f,0x6d,0x65,0x74,0x72,0x79,0x5f,
    0x74,0x6f,0x5f,0x77,0x6f,0x72,0x6c,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x34,0x78,0x34,0x20,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x5f,0x74,0x6f,
    0x5f,0x77,0x6f,0x72,0x6c,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x34,0x78,0x34,0x20,0x77,0x6f,0x72,0x6c,0x64,0x5f,0x74,0x6f,0x5f,0x63,0x6c,
    0x69,0x70,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x62,
    0x6c,0x65,0x6e,0x64,0x5f,0x77,0x65,0x69,0x67,0x68,0x74,0x73,0x5b,0x31,0x36,0x5d,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x66,0x5f,0x6e,0x75,
    0x6d,0x5f,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,0x65,0x73,0x3b,0x0a,
    0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,
    0x5f,0x6f,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x33,0x20,0x76,0x5f,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x20,0x5b,0x5b,0x75,0x73,0x65,
    0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x76,0x5f,0x75,0x76,0x20,0x5b,0x5b,0x75,0x73,
    0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x31,0x29,0x5d,0x5d,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,
    0x69,0x6f,0x6e,0x20,0x5b,0x5b,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x5d,0x5d,
    0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,
    0x6e,0x30,0x5f,0x69,0x6e,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x33,0x20,0x61,0x5f,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x5b,0x5b,
    0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x28,0x30,0x29,0x5d,0x5d,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x61,0x5f,0x6e,0x6f,0x72,
    0x6d,0x61,0x6c,0x20,0x5b,0x5b,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x28,
    0x31,0x29,0x5d,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x61,0x5f,0x75,0x76,0x20,0x5b,0x5b,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,
    0x65,0x28,0x32,0x29,0x5d,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x61,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x69,0x6e,0x64,0x65,0x78,
    0x20,0x5b,0x5b,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x28,0x33,0x29,0x5d,
    0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x30,0x20,
    0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x73,0x74,0x61,0x74,
    0x69,0x63,0x20,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,0x74,0x74,0x72,
    0x69,0x62,0x75,0x74,0x65,0x5f,0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,0x79,0x73,0x5f,
    0x69,0x6e,0x6c,0x69,0x6e,0x65,0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,
    0x65,0x76,0x61,0x6c,0x75,0x61,0x74,0x65,0x5f,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,
    0x68,0x61,0x70,0x65,0x28,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,
    0x74,0x20,0x69,0x6e,0x74,0x26,0x20,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x69,0x6e,
    0x64,0x65,0x78,0x2c,0x20,0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,0x6d,0x65,
    0x73,0x68,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x26,0x20,0x76,
    0x5f,0x33,0x34,0x2c,0x20,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x74,0x65,0x78,0x74,
    0x75,0x72,0x65,0x32,0x64,0x5f,0x61,0x72,0x72,0x61,0x79,0x3c,0x66,0x6c,0x6f,0x61,
    0x74,0x3e,0x20,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,0x65,0x73,0x2c,
    0x20,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x73,0x61,
    0x6d,0x70,0x6c,0x65,0x72,0x20,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,
    0x65,0x73,0x53,0x6d,0x70,0x6c,0x72,0x29,0x0a,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,
    0x20,0x32,0x30,0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,
    0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x5f,0x32,0x31,0x20,0x3d,0x20,0x76,0x65,
    0x72,0x74,0x65,0x78,0x5f,0x69,0x6e,0x64,0x65,0x78,0x20,0x26,0x20,0x32,0x30,0x34,
    0x37,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x5f,0x32,0x34,0x20,0x3d,
    0x20,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x69,0x6e,0x64,0x65,0x78,0x20,0x3e,0x3e,
    0x20,0x31,0x31,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x31,0x20,0x22,0x6d,
    0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,
    0x74,0x20,0x5f,0x33,0x39,0x20,0x3d,0x20,0x69,0x6e,0x74,0x28,0x76,0x5f,0x33,0x34,
    0x2e,0x66,0x5f,0x6e,0x75,0x6d,0x5f,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,
    0x70,0x65,0x73,0x29,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x32,0x20,0x22,
    0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x33,0x20,0x6f,0x66,0x66,0x73,0x65,0x74,0x20,0x3d,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x33,0x28,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x23,0x6c,0x69,0x6e,
    0x65,0x20,0x32,0x33,0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6f,0x72,0x20,0x28,0x69,0x6e,0x74,0x20,0x69,0x20,
    0x3d,0x20,0x30,0x3b,0x20,0x69,0x20,0x3c,0x20,0x5f,0x33,0x39,0x3b,0x20,0x69,0x2b,
    0x2b,0x29,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,
    0x34,0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x5f,0x70,0x61,
    0x63,0x6b,0x65,0x64,0x20,0x3d,0x20,0x76,0x5f,0x33,0x34,0x2e,0x62,0x6c,0x65,0x6e,
    0x64,0x5f,0x77,0x65,0x69,0x67,0x68,0x74,0x73,0x5b,0x69,0x20,0x3e,0x3e,0x20,0x32,
    0x5d,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x35,0x20,0x22,0x6d,0x65,0x73,
    0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x36,
    0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x33,0x20,0x5f,0x38,0x31,0x20,0x3d,0x20,
    0x69,0x6e,0x74,0x33,0x28,0x5f,0x32,0x31,0x2c,0x20,0x5f,0x32,0x34,0x2c,0x20,0x69,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x6f,0x66,0x66,0x73,0x65,
    0x74,0x20,0x2b,0x3d,0x20,0x28,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,
    0x65,0x73,0x2e,0x72,0x65,0x61,0x64,0x28,0x75,0x69,0x6e,0x74,0x32,0x28,0x5f,0x38,
    0x31,0x2e,0x78,0x79,0x29,0x2c,0x20,0x75,0x69,0x6e,0x74,0x28,0x5f,0x38,0x31,0x2e,
    0x7a,0x29,0x2c,0x20,0x30,0x29,0x2e,0x78,0x79,0x7a,0x20,0x2a,0x20,0x5f,0x70,0x61,
    0x63,0x6b,0x65,0x64,0x5b,0x69,0x20,0x26,0x20,0x33,0x5d,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x7d,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x38,0x20,0x22,0x6d,0x65,
    0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,
    0x75,0x72,0x6e,0x20,0x6f,0x66,0x66,0x73,0x65,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x23,
    0x6c,0x69,0x6e,0x65,0x20,0x34,0x32,0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,
    0x73,0x6c,0x22,0x0a,0x76,0x65,0x72,0x74,0x65,0x78,0x20,0x6d,0x61,0x69,0x6e,0x30,
    0x5f,0x6f,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,0x6e,0x30,
    0x5f,0x69,0x6e,0x20,0x69,0x6e,0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,
    0x6e,0x5d,0x5d,0x2c,0x20,0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,0x6d,0x65,
    0x73,0x68,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x26,0x20,0x76,
    0x5f,0x33,0x34,0x20,0x5b,0x5b,0x62,0x75,0x66,0x66,0x65,0x72,0x28,0x30,0x29,0x5d,
    0x5d,0x2c,0x20,0x74,0x65,0x78,0x74,0x75,0x72,0x65,0x32,0x64,0x5f,0x61,0x72,0x72,
    0x61,0x79,0x3c,0x66,0x6c,0x6f,0x61,0x74,0x3e,0x20,0x62,0x6c,0x65,0x6e,0x64,0x5f,
    0x73,0x68,0x61,0x70,0x65,0x73,0x20,0x5b,0x5b,0x74,0x65,0x78,0x74,0x75,0x72,0x65,
    0x28,0x30,0x29,0x5d,0x5d,0x2c,0x20,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x20,0x62,
    0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,0x65,0x73,0x53,0x6d,0x70,0x6c,0x72,
    0x20,0x5b,0x5b,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x28,0x30,0x29,0x5d,0x5d,0x29,
    0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,
    0x20,0x6f,0x75,0x74,0x20,0x3d,0x20,0x7b,0x7d,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,
    0x20,0x34,0x32,0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x6c,0x6f,0x63,0x61,0x6c,
    0x5f,0x70,0x6f,0x73,0x20,0x3d,0x20,0x69,0x6e,0x2e,0x61,0x5f,0x70,0x6f,0x73,0x69,
    0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x34,0x33,0x20,0x22,
    0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x69,
    0x6e,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,0x3d,0x20,0x69,0x6e,0x74,0x28,0x69,
    0x6e,0x2e,0x61,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x69,0x6e,0x64,0x65,0x78,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x5f,0x31,
    0x30,0x34,0x20,0x3d,0x20,0x6c,0x6f,0x63,0x61,0x6c,0x5f,0x70,0x6f,0x73,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x5f,0x31,0x30,0x35,0x20,
    0x3d,0x20,0x5f,0x31,0x30,0x34,0x20,0x2b,0x20,0x65,0x76,0x61,0x6c,0x75,0x61,0x74,
    0x65,0x5f,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,0x65,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x2c,0x20,0x76,0x5f,0x33,0x34,0x2c,0x20,0x62,0x6c,0x65,0x6e,0x64,
    0x5f,0x73,0x68,0x61,0x70,0x65,0x73,0x2c,0x20,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,
    0x68,0x61,0x70,0x65,0x73,0x53,0x6d,0x70,0x6c,0x72,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x6c,0x6f,0x63,0x61,0x6c,0x5f,0x70,0x6f,0x73,0x20,0x3d,0x20,0x5f,0x31,0x30,
    0x35,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x34,0x35,0x20,0x22,0x6d,0x65,0x73,
    0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x34,0x36,
    0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,
    0x20,0x6f,0x75,0x74,0x2e,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,
    0x20,0x3d,0x20,0x76,0x5f,0x33,0x34,0x2e,0x77,0x6f,0x72,0x6c,0x64,0x5f,0x74,0x6f,
    0x5f,0x63,0x6c,0x69,0x70,0x20,0x2a,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x28,0x28,
    0x76,0x5f,0x33,0x34,0x2e,0x67,0x65,0x6f,0x6d,0x65,0x74,0x72,0x79,0x5f,0x74,0x6f,
    0x5f,0x77,0x6f,0x72,0x6c,0x64,0x20,0x2a,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x28,
    0x5f,0x31,0x30,0x35,0x2c,0x20,0x31,0x2e,0x30,0x29,0x29,0x2e,0x78,0x79,0x7a,0x2c,
    0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x34,0x37,0x20,
    0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,
    0x6f,0x75,0x74,0x2e,0x76,0x5f,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x20,0x3d,0x20,0x66,
    0x61,0x73,0x74,0x3a,0x3a,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x69,0x7a,0x65,0x28,0x28,
    0x76,0x5f,0x33,0x34,0x2e,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x5f,0x74,0x6f,0x5f,0x77,
    0x6f,0x72,0x6c,0x64,0x20,0x2a,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x28,0x69,0x6e,
    0x2e,0x61,0x5f,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x2c,0x20,0x30,0x2e,0x30,0x29,0x29,
    0x2e,0x78,0x79,0x7a,0x29,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x34,0x38,0x20,
    0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,
    0x6f,0x75,0x74,0x2e,0x76,0x5f,0x75,0x76,0x20,0x3d,0x20,0x69,0x6e,0x2e,0x61,0x5f,
    0x75,0x76,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6f,
    0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #pragma clang diagnostic ignored "-Wmissing-prototypes"
    
    #include <metal_stdlib>
    #include <simd/simd.h>
    
    using namespace metal;
    
    struct mesh_vertex_ubo
    {
        float4x4 geometry_to_world;
        float4x4 normal_to_world;
        float4x4 world_to_clip;
        float4 blend_weights[16];
        float f_num_blend_shapes;
    };
    
    struct skin_vertex_ubo
    {
        float4x4 bones[64];
    };
    
    struct main0_out
    {
        float3 v_normal [[user(locn0)]];
        float2 v_uv [[user(locn1)]];
        float4 gl_Position [[position]];
    };
    
    struct main0_in
    {
        float3 a_position [[attribute(0)]];
        float3 a_normal [[attribute(1)]];
        float2 a_uv [[attribute(2)]];
        float a_vertex_index [[attribute(3)]];
        int4 a_bone_indices [[attribute(4)]];
        float4 a_bone_weights [[attribute(5)]];
    };
    
    #line 20 "mesh.glsl"
    static inline __attribute__((always_inline))
    float3 evaluate_blend_shape(thread const int& vertex_index, constant mesh_vertex_ubo& v_34, thread texture2d_array<float> blend_shapes, thread const sampler blend_shapesSmplr)
    {
    #line 20 "mesh.glsl"
        int _21 = vertex_index & 2047;
        int _24 = vertex_index >> 11;
    #line 21 "mesh.glsl"
        int _39 = int(v_34.f_num_blend_shapes);
    #line 22 "mesh.glsl"
        float3 offset = float3(0.0);
    #line 23 "mesh.glsl"
        for (int i = 0; i < _39; i++)
        {
    #line 24 "mesh.glsl"
            float4 _packed = v_34.blend_weights[i >> 2];
    #line 25 "mesh.glsl"
    #line 26 "mesh.glsl"
            int3 _81 = int3(_21, _24, i);
            offset += (blend_shapes.read(uint2(_81.xy), uint(_81.z), 0).xyz * _packed[i & 3]);
        }
    #line 28 "mesh.glsl"
        return offset;
    }
    
    #line 52 "mesh.glsl"
    vertex main0_out main0(main0_in in [[stage_in]], constant mesh_vertex_ubo& v_34 [[buffer(0)]], constant skin_vertex_ubo& _100 [[buffer(1)]], texture2d_array<float> blend_shapes [[texture(0)]], sampler blend_shapesSmplr [[sampler(0)]])
    {
        main0_out out = {};
    #line 52 "mesh.glsl"
    #line 56 "mesh.glsl"
    #line 55 "mesh.glsl"
    #line 54 "mesh.glsl"
    #line 53 "mesh.glsl"
        float4x4 _116 = _100.bones[in.a_bone_indices.x] * in.a_bone_weights.x;
    #line 54 "mesh.glsl"
        float4x4 _124 = _100.bones[in.a_bone_indices.y] * in.a_bone_weights.y;
    #line 55 "mesh.glsl"
        float4x4 _145 = _100.bones[in.a_bone_indices.z] * in.a_bone_weights.z;
    #line 56 "mesh.glsl"
        float4x4 _166 = _100.bones[in.a_bone_indices.w] * in.a_bone_weights.w;
        float4x4 _179 = float4x4(((_116[0] + _124[0]) + _145[0]) + _166[0], ((_116[1] + _124[1]) + _145[1]) + _166[1], ((_116[2] + _124[2]) + _145[2]) + _166[2], ((_116[3] + _124[3]) + _145[3]) + _166[3]);
    #line 58 "mesh.glsl"
        float3 local_pos = in.a_position;
    #line 59 "mesh.glsl"
        int param = int(in.a_vertex_index);
        float3 _189 = local_pos;
        float3 _190 = _189 + evaluate_blend_shape(param, v_34, blend_shapes, blend_shapesSmplr);
        local_pos = _190;
    #line 60 "mesh.glsl"
    #line 61 "mesh.glsl"
    #line 63 "mesh.glsl"
        out.gl_Position = v_34.world_to_clip * float4((_179 * float4(_190, 1.0)).xyz, 1.0);
    #line 64 "mesh.glsl"
        out.v_normal = fast::normalize((_179 * float4(in.a_normal, 0.0)).xyz);
    #line 65 "mesh.glsl"
        out.v_uv = in.a_uv;
        return out;
    }
    
*/
static const char skinned_vertex_source_metal_macos[3090] = {
    0x23,0x70,0x72,0x61,0x67,0x6d,0x61,0x20,0x63,0x6c,0x61,0x6e,0x67,0x20,0x64,0x69,
    0x61,0x67,0x6e,0x6f,0x73,0x74,0x69,0x63,0x20,0x69,0x67,0x6e,0x6f,0x72,0x65,0x64,
    0x20,0x22,0x2d,0x57,0x6d,0x69,0x73,0x73,0x69,0x6e,0x67,0x2d,0x70,0x72,0x6f,0x74,
    0x6f,0x74,0x79,0x70,0x65,0x73,0x22,0x0a,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,
    0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,
    0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,
    0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,
    0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,
    0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x65,0x73,0x68,0x5f,0x76,0x65,0x72,
    0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x34,0x78,0x34,0x20,0x67,0x65,0x6f,0x6d,0x65,0x74,0x72,0x79,0x5f,
    0x74,0x6f,0x5f,0x77,0x6f,0x72,0x6c,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x34,0x78,0x34,0x20,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x5f,0x74,0x6f,
    0x5f,0x77,0x6f,0x72,0x6c,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x34,0x78,0x34,0x20,0x77,0x6f,0x72,0x6c,0x64,0x5f,0x74,0x6f,0x5f,0x63,0x6c,
    0x69,0x70,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x62,
    0x6c,0x65,0x6e,0x64,0x5f,0x77,0x65,0x69,0x67,0x68,0x74,0x73,0x5b,0x31,0x36,0x5d,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x66,0x5f,0x6e,0x75,
    0x6d,0x5f,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,0x65,0x73,0x3b,0x0a,
    0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x73,0x6b,0x69,0x6e,0x5f,
    0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x78,0x34,0x20,0x62,0x6f,0x6e,0x65,0x73,0x5b,
    0x36,0x34,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,
    0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x76,0x5f,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x20,
    0x5b,0x5b,0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,0x29,0x5d,0x5d,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x76,0x5f,0x75,0x76,
    0x20,0x5b,0x5b,0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x31,0x29,0x5d,0x5d,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x67,0x6c,0x5f,
    0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x5b,0x5b,0x70,0x6f,0x73,0x69,0x74,
    0x69,0x6f,0x6e,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,
    0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x61,0x5f,0x70,0x6f,0x73,0x69,0x74,0x69,
    0x6f,0x6e,0x20,0x5b,0x5b,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x28,0x30,
    0x29,0x5d,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,
    0x61,0x5f,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x20,0x5b,0x5b,0x61,0x74,0x74,0x72,0x69,
    0x62,0x75,0x74,0x65,0x28,0x31,0x29,0x5d,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x20,0x61,0x5f,0x75,0x76,0x20,0x5b,0x5b,0x61,0x74,0x74,
    0x72,0x69,0x62,0x75,0x74,0x65,0x28,0x32,0x29,0x5d,0x5d,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x61,0x5f,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,
    0x69,0x6e,0x64,0x65,0x78,0x20,0x5b,0x5b,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,
    0x65,0x28,0x33,0x29,0x5d,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x34,
    0x20,0x61,0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,0x73,0x20,
    0x5b,0x5b,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x28,0x34,0x29,0x5d,0x5d,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x61,0x5f,0x62,
    0x6f,0x6e,0x65,0x5f,0x77,0x65,0x69,0x67,0x68,0x74,0x73,0x20,0x5b,0x5b,0x61,0x74,
    0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x28,0x35,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,
    0x0a,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x30,0x20,0x22,0x6d,0x65,0x73,0x68,
    0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x69,0x6e,
    0x6c,0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,
    0x5f,0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,0x79,0x73,0x5f,0x69,0x6e,0x6c,0x69,0x6e,
    0x65,0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x65,0x76,0x61,0x6c,0x75,
    0x61,0x74,0x65,0x5f,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,0x65,0x28,
    0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x69,0x6e,0x74,
    0x26,0x20,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,0x69,0x6e,0x64,0x65,0x78,0x2c,0x20,
    0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,0x6d,0x65,0x73,0x68,0x5f,0x76,0x65,
    0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x26,0x20,0x76,0x5f,0x33,0x34,0x2c,0x20,
    0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x74,0x65,0x78,0x74,0x75,0x72,0x65,0x32,0x64,
    0x5f,0x61,0x72,0x72,0x61,0x79,0x3c,0x66,0x6c,0x6f,0x61,0x74,0x3e,0x20,0x62,0x6c,
    0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,0x65,0x73,0x2c,0x20,0x74,0x68,0x72,0x65,
    0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,
    0x20,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,0x65,0x73,0x53,0x6d,0x70,
    0x6c,0x72,0x29,0x0a,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x30,0x20,0x22,
    0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x69,
    0x6e,0x74,0x20,0x5f,0x32,0x31,0x20,0x3d,0x20,0x76,0x65,0x72,0x74,0x65,0x78,0x5f,
    0x69,0x6e,0x64,0x65,0x78,0x20,0x26,0x20,0x32,0x30,0x34,0x37,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x69,0x6e,0x74,0x20,0x5f,0x32,0x34,0x20,0x3d,0x20,0x76,0x65,0x72,0x74,
    0x65,0x78,0x5f,0x69,0x6e,0x64,0x65,0x78,0x20,0x3e,0x3e,0x20,0x31,0x31,0x3b,0x0a,
    0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x31,0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,
    0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x5f,0x33,0x39,
    0x20,0x3d,0x20,0x69,0x6e,0x74,0x28,0x76,0x5f,0x33,0x34,0x2e,0x66,0x5f,0x6e,0x75,
    0x6d,0x5f,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,0x65,0x73,0x29,0x3b,
    0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x32,0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,
    0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,
    0x20,0x6f,0x66,0x66,0x73,0x65,0x74,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,
    0x28,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x33,0x20,
    0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6f,0x72,0x20,0x28,0x69,0x6e,0x74,0x20,0x69,0x20,0x3d,0x20,0x30,0x3b,0x20,
    0x69,0x20,0x3c,0x20,0x5f,0x33,0x39,0x3b,0x20,0x69,0x2b,0x2b,0x29,0x0a,0x20,0x20,
    0x20,0x20,0x7b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x34,0x20,0x22,0x6d,0x65,
    0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x5f,0x70,0x61,0x63,0x6b,0x65,0x64,0x20,
    0x3d,0x20,0x76,0x5f,0x33,0x34,0x2e,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x77,0x65,0x69,
    0x67,0x68,0x74,0x73,0x5b,0x69,0x20,0x3e,0x3e,0x20,0x32,0x5d,0x3b,0x0a,0x23,0x6c,
    0x69,0x6e,0x65,0x20,0x32,0x35,0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,
    0x6c,0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x32,0x36,0x20,0x22,0x6d,0x65,0x73,
    0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x69,0x6e,0x74,0x33,0x20,0x5f,0x38,0x31,0x20,0x3d,0x20,0x69,0x6e,0x74,0x33,0x28,
    0x5f,0x32,0x31,0x2c,0x20,0x5f,0x32,0x34,0x2c,0x20,0x69,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x6f,0x66,0x66,0x73,0x65,0x74,0x20,0x2b,0x3d,0x20,
    0x28,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,0x65,0x73,0x2e,0x72,0x65,
    0x61,0x64,0x28,0x75,0x69,0x6e,0x74,0x32,0x28,0x5f,0x38,0x31,0x2e,0x78,0x79,0x29,
    0x2c,0x20,0x75,0x69,0x6e,0x74,0x28,0x5f,0x38,0x31,0x2e,0x7a,0x29,0x2c,0x20,0x30,
    0x29,0x2e,0x78,0x79,0x7a,0x20,0x2a,0x20,0x5f,0x70,0x61,0x63,0x6b,0x65,0x64,0x5b,
    0x69,0x20,0x26,0x20,0x33,0x5d,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x23,
    0x6c,0x69,0x6e,0x65,0x20,0x32,0x38,0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,
    0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6f,
    0x66,0x66,0x73,0x65,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,
    0x35,0x32,0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x76,
    0x65,0x72,0x74,0x65,0x78,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,
    0x6d,0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x20,0x69,
    0x6e,0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,0x5d,0x5d,0x2c,0x20,
    0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,0x6d,0x65,0x73,0x68,0x5f,0x76,0x65,
    0x72,0x74,0x65,0x78,0x5f,0x75,0x62,0x6f,0x26,0x20,0x76,0x5f,0x33,0x34,0x20,0x5b,
    0x5b,0x62,0x75,0x66,0x66,0x65,0x72,0x28,0x30,0x29,0x5d,0x5d,0x2c,0x20,0x63,0x6f,
    0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,0x73,0x6b,0x69,0x6e,0x5f,0x76,0x65,0x72,0x74,
    0x65,0x78,0x5f,0x75,0x62,0x6f,0x26,0x20,0x5f,0x31,0x30,0x30,0x20,0x5b,0x5b,0x62,
    0x75,0x66,0x66,0x65,0x72,0x28,0x31,0x29,0x5d,0x5d,0x2c,0x20,0x74,0x65,0x78,0x74,
    0x75,0x72,0x65,0x32,0x64,0x5f,0x61,0x72,0x72,0x61,0x79,0x3c,0x66,0x6c,0x6f,0x61,
    0x74,0x3e,0x20,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,0x65,0x73,0x20,
    0x5b,0x5b,0x74,0x65,0x78,0x74,0x75,0x72,0x65,0x28,0x30,0x29,0x5d,0x5d,0x2c,0x20,
    0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x20,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,
    0x61,0x70,0x65,0x73,0x53,0x6d,0x70,0x6c,0x72,0x20,0x5b,0x5b,0x73,0x61,0x6d,0x70,
    0x6c,0x65,0x72,0x28,0x30,0x29,0x5d,0x5d,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,
    0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6f,0x75,0x74,0x20,0x3d,0x20,
    0x7b,0x7d,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x35,0x32,0x20,0x22,0x6d,0x65,
    0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x35,
    0x36,0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x23,0x6c,
    0x69,0x6e,0x65,0x20,0x35,0x35,0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,
    0x6c,0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x35,0x34,0x20,0x22,0x6d,0x65,0x73,
    0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x35,0x33,
    0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x78,0x34,0x20,0x5f,0x31,0x31,0x36,0x20,0x3d,
    0x20,0x5f,0x31,0x30,0x30,0x2e,0x62,0x6f,0x6e,0x65,0x73,0x5b,0x69,0x6e,0x2e,0x61,
    0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,0x73,0x2e,0x78,0x5d,
    0x20,0x2a,0x20,0x69,0x6e,0x2e,0x61,0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x77,0x65,0x69,
    0x67,0x68,0x74,0x73,0x2e,0x78,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x35,0x34,
    0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x78,0x34,0x20,0x5f,0x31,0x32,0x34,0x20,0x3d,
    0x20,0x5f,0x31,0x30,0x30,0x2e,0x62,0x6f,0x6e,0x65,0x73,0x5b,0x69,0x6e,0x2e,0x61,
    0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,0x73,0x2e,0x79,0x5d,
    0x20,0x2a,0x20,0x69,0x6e,0x2e,0x61,0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x77,0x65,0x69,
    0x67,0x68,0x74,0x73,0x2e,0x79,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x35,0x35,
    0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x78,0x34,0x20,0x5f,0x31,0x34,0x35,0x20,0x3d,
    0x20,0x5f,0x31,0x30,0x30,0x2e,0x62,0x6f,0x6e,0x65,0x73,0x5b,0x69,0x6e,0x2e,0x61,
    0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,0x73,0x2e,0x7a,0x5d,
    0x20,0x2a,0x20,0x69,0x6e,0x2e,0x61,0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x77,0x65,0x69,
    0x67,0x68,0x74,0x73,0x2e,0x7a,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x35,0x36,
    0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x78,0x34,0x20,0x5f,0x31,0x36,0x36,0x20,0x3d,
    0x20,0x5f,0x31,0x30,0x30,0x2e,0x62,0x6f,0x6e,0x65,0x73,0x5b,0x69,0x6e,0x2e,0x61,
    0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x69,0x6e,0x64,0x69,0x63,0x65,0x73,0x2e,0x77,0x5d,
    0x20,0x2a,0x20,0x69,0x6e,0x2e,0x61,0x5f,0x62,0x6f,0x6e,0x65,0x5f,0x77,0x65,0x69,
    0x67,0x68,0x74,0x73,0x2e,0x77,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x34,0x78,0x34,0x20,0x5f,0x31,0x37,0x39,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x34,0x78,0x34,0x28,0x28,0x28,0x5f,0x31,0x31,0x36,0x5b,0x30,0x5d,0x20,0x2b,
    0x20,0x5f,0x31,0x32,0x34,0x5b,0x30,0x5d,0x29,0x20,0x2b,0x20,0x5f,0x31,0x34,0x35,
    0x5b,0x30,0x5d,0x29,0x20,0x2b,0x20,0x5f,0x31,0x36,0x36,0x5b,0x30,0x5d,0x2c,0x20,
    0x28,0x28,0x5f,0x31,0x31,0x36,0x5b,0x31,0x5d,0x20,0x2b,0x20,0x5f,0x31,0x32,0x34,
    0x5b,0x31,0x5d,0x29,0x20,0x2b,0x20,0x5f,0x31,0x34,0x35,0x5b,0x31,0x5d,0x29,0x20,
    0x2b,0x20,0x5f,0x31,0x36,0x36,0x5b,0x31,0x5d,0x2c,0x20,0x28,0x28,0x5f,0x31,0x31,
    0x36,0x5b,0x32,0x5d,0x20,0x2b,0x20,0x5f,0x31,0x32,0x34,0x5b,0x32,0x5d,0x29,0x20,
    0x2b,0x20,0x5f,0x31,0x34,0x35,0x5b,0x32,0x5d,0x29,0x20,0x2b,0x20,0x5f,0x31,0x36,
    0x36,0x5b,0x32,0x5d,0x2c,0x20,0x28,0x28,0x5f,0x31,0x31,0x36,0x5b,0x33,0x5d,0x20,
    0x2b,0x20,0x5f,0x31,0x32,0x34,0x5b,0x33,0x5d,0x29,0x20,0x2b,0x20,0x5f,0x31,0x34,
    0x35,0x5b,0x33,0x5d,0x29,0x20,0x2b,0x20,0x5f,0x31,0x36,0x36,0x5b,0x33,0x5d,0x29,
    0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x35,0x38,0x20,0x22,0x6d,0x65,0x73,0x68,
    0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x33,0x20,0x6c,0x6f,0x63,0x61,0x6c,0x5f,0x70,0x6f,0x73,0x20,0x3d,0x20,0x69,0x6e,
    0x2e,0x61,0x5f,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x23,0x6c,0x69,
    0x6e,0x65,0x20,0x35,0x39,0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,
    0x22,0x0a,0x20,0x20,0x20,0x20,0x69,0x6e,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,
    0x3d,0x20,0x69,0x6e,0x74,0x28,0x69,0x6e,0x2e,0x61,0x5f,0x76,0x65,0x72,0x74,0x65,
    0x78,0x5f,0x69,0x6e,0x64,0x65,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x33,0x20,0x5f,0x31,0x38,0x39,0x20,0x3d,0x20,0x6c,0x6f,0x63,0x61,
    0x6c,0x5f,0x70,0x6f,0x73,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x33,0x20,0x5f,0x31,0x39,0x30,0x20,0x3d,0x20,0x5f,0x31,0x38,0x39,0x20,0x2b,0x20,
    0x65,0x76,0x61,0x6c,0x75,0x61,0x74,0x65,0x5f,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,
    0x68,0x61,0x70,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x2c,0x20,0x76,0x5f,0x33,0x34,
    0x2c,0x20,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,0x65,0x73,0x2c,0x20,
    0x62,0x6c,0x65,0x6e,0x64,0x5f,0x73,0x68,0x61,0x70,0x65,0x73,0x53,0x6d,0x70,0x6c,
    0x72,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6c,0x6f,0x63,0x61,0x6c,0x5f,0x70,0x6f,
    0x73,0x20,0x3d,0x20,0x5f,0x31,0x39,0x30,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,
    0x36,0x30,0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x23,
    0x6c,0x69,0x6e,0x65,0x20,0x36,0x31,0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,
    0x73,0x6c,0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x36,0x33,0x20,0x22,0x6d,0x65,
    0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,
    0x2e,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x76,
    0x5f,0x33,0x34,0x2e,0x77,0x6f,0x72,0x6c,0x64,0x5f,0x74,0x6f,0x5f,0x63,0x6c,0x69,
    0x70,0x20,0x2a,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x28,0x28,0x5f,0x31,0x37,0x39,
    0x20,0x2a,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x28,0x5f,0x31,0x39,0x30,0x2c,0x20,
    0x31,0x2e,0x30,0x29,0x29,0x2e,0x78,0x79,0x7a,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,
    0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x36,0x34,0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,
    0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,0x2e,0x76,0x5f,
    0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x20,0x3d,0x20,0x66,0x61,0x73,0x74,0x3a,0x3a,0x6e,
    0x6f,0x72,0x6d,0x61,0x6c,0x69,0x7a,0x65,0x28,0x28,0x5f,0x31,0x37,0x39,0x20,0x2a,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x28,0x69,0x6e,0x2e,0x61,0x5f,0x6e,0x6f,0x72,
    0x6d,0x61,0x6c,0x2c,0x20,0x30,0x2e,0x30,0x29,0x29,0x2e,0x78,0x79,0x7a,0x29,0x3b,
    0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x36,0x35,0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,
    0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,0x2e,0x76,0x5f,
    0x75,0x76,0x20,0x3d,0x20,0x69,0x6e,0x2e,0x61,0x5f,0x75,0x76,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6f,0x75,0x74,0x3b,0x0a,0x7d,0x0a,
    0x0a,0x00,
};
/*
    #include <metal_stdlib>
    #include <simd/simd.h>
    
    using namespace metal;
    
    struct main0_out
    {
        float4 o_color [[color(0)]];
    };
    
    struct main0_in
    {
        float3 v_normal [[user(locn0)]];
        float2 v_uv [[user(locn1)]];
    };
    
    #line 14 "mesh.glsl"
    fragment main0_out main0(main0_in in [[stage_in]])
    {
        main0_out out = {};
    #line 14 "mesh.glsl"
    #line 15 "mesh.glsl"
    #line 16 "mesh.glsl"
        float _33 = ((dot(in.v_normal, float3(0.57735025882720947265625)) + (in.v_uv.x * 9.9999997473787516355514526367188e-05)) * 0.5) + 0.5;
    #line 17 "mesh.glsl"
        out.o_color = float4(_33, _33, _33, 1.0);
        return out;
    }
    
*/
static const char lit_pixel_source_metal_macos[607] = {
    0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,
    0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,
    0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,
    0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,
    0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,
    0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x20,0x6f,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x5b,0x5b,
    0x63,0x6f,0x6c,0x6f,0x72,0x28,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,
    0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x0a,
    0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x76,0x5f,0x6e,
    0x6f,0x72,0x6d,0x61,0x6c,0x20,0x5b,0x5b,0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,
    0x6e,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x76,0x5f,0x75,0x76,0x20,0x5b,0x5b,0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,
    0x63,0x6e,0x31,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x23,0x6c,0x69,0x6e,
    0x65,0x20,0x31,0x34,0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,
    0x0a,0x66,0x72,0x61,0x67,0x6d,0x65,0x6e,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,
    0x6f,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,0x6e,0x30,0x5f,
    0x69,0x6e,0x20,0x69,0x6e,0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,
    0x5d,0x5d,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,
    0x6f,0x75,0x74,0x20,0x6f,0x75,0x74,0x20,0x3d,0x20,0x7b,0x7d,0x3b,0x0a,0x23,0x6c,
    0x69,0x6e,0x65,0x20,0x31,0x34,0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,
    0x6c,0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x35,0x20,0x22,0x6d,0x65,0x73,
    0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x36,
    0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x33,0x33,0x20,0x3d,0x20,0x28,0x28,0x64,
    0x6f,0x74,0x28,0x69,0x6e,0x2e,0x76,0x5f,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x2c,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x33,0x28,0x30,0x2e,0x35,0x37,0x37,0x33,0x35,0x30,0x32,
    0x35,0x38,0x38,0x32,0x37,0x32,0x30,0x39,0x34,0x37,0x32,0x36,0x35,0x36,0x32,0x35,
    0x29,0x29,0x20,0x2b,0x20,0x28,0x69,0x6e,0x2e,0x76,0x5f,0x75,0x76,0x2e,0x78,0x20,
    0x2a,0x20,0x39,0x2e,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x34,0x37,0x33,0x37,0x38,
    0x37,0x35,0x31,0x36,0x33,0x35,0x35,0x35,0x31,0x34,0x35,0x32,0x36,0x33,0x36,0x37,
    0x31,0x38,0x38,0x65,0x2d,0x30,0x35,0x29,0x29,0x20,0x2a,0x20,0x30,0x2e,0x35,0x29,
    0x20,0x2b,0x20,0x30,0x2e,0x35,0x3b,0x0a,0x23,0x6c,0x69,0x6e,0x65,0x20,0x31,0x37,
    0x20,0x22,0x6d,0x65,0x73,0x68,0x2e,0x67,0x6c,0x73,0x6c,0x22,0x0a,0x20,0x20,0x20,
    0x20,0x6f,0x75,0x74,0x2e,0x6f,0x5f,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x28,0x5f,0x33,0x33,0x2c,0x20,0x5f,0x33,0x33,0x2c,0x20,
    0x5f,0x33,0x33,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,
    0x65,0x74,0x75,0x72,0x6e,0x20,0x6f,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
#if !defined(SOKOL_GFX_INCLUDED)
  #error "Please include sokol_gfx.h before mesh.h"
#endif
static inline const sg_shader_desc* skinned_lit_shader_desc(sg_backend backend) {
  if (backend == SG_BACKEND_GLCORE33) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.attrs[0].name = "a_position";
      desc.attrs[1].name = "a_normal";
      desc.attrs[2].name = "a_uv";
      desc.attrs[3].name = "a_vertex_index";
      desc.attrs[4].name = "a_bone_indices";
      desc.attrs[5].name = "a_bone_weights";
      desc.vs.source = skinned_vertex_source_glsl330;
      desc.vs.entry = "main";
      desc.vs.uniform_blocks[0].size = 464;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.vs.uniform_blocks[0].uniforms[0].name = "mesh_vertex_ubo";
      desc.vs.uniform_blocks[0].uniforms[0].type = SG_UNIFORMTYPE_FLOAT4;
      desc.vs.uniform_blocks[0].uniforms[0].array_count = 29;
      desc.vs.uniform_blocks[1].size = 4096;
      desc.vs.uniform_blocks[1].layout = SG_UNIFORMLAYOUT_STD140;
      desc.vs.uniform_blocks[1].uniforms[0].name = "skin_vertex_ubo";
      desc.vs.uniform_blocks[1].uniforms[0].type = SG_UNIFORMTYPE_FLOAT4;
      desc.vs.uniform_blocks[1].uniforms[0].array_count = 256;
      desc.vs.images[0].name = "blend_shapes";
      desc.vs.images[0].image_type = SG_IMAGETYPE_ARRAY;
      desc.vs.images[0].sampler_type = SG_SAMPLERTYPE_FLOAT;
      desc.fs.source = lit_pixel_source_glsl330;
      desc.fs.entry = "main";
      desc.label = "skinned_lit_shader";
    }
    return &desc;
  }
  if (backend == SG_BACKEND_D3D11) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.attrs[0].sem_name = "TEXCOORD";
      desc.attrs[0].sem_index = 0;
      desc.attrs[1].sem_name = "TEXCOORD";
      desc.attrs[1].sem_index = 1;
      desc.attrs[2].sem_name = "TEXCOORD";
      desc.attrs[2].sem_index = 2;
      desc.attrs[3].sem_name = "TEXCOORD";
      desc.attrs[3].sem_index = 3;
      desc.attrs[4].sem_name = "TEXCOORD";
      desc.attrs[4].sem_index = 4;
      desc.attrs[5].sem_name = "TEXCOORD";
      desc.attrs[5].sem_index = 5;
      desc.vs.bytecode.ptr = skinned_vertex_bytecode_hlsl5;
      desc.vs.bytecode.size = 3256;
      desc.vs.entry = "main";
      desc.vs.uniform_blocks[0].size = 464;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.vs.uniform_blocks[1].size = 4096;
      desc.vs.uniform_blocks[1].layout = SG_UNIFORMLAYOUT_STD140;
      desc.vs.images[0].name = "blend_shapes";
      desc.vs.images[0].image_type = SG_IMAGETYPE_ARRAY;
      desc.vs.images[0].sampler_type = SG_SAMPLERTYPE_FLOAT;
      desc.fs.bytecode.ptr = lit_pixel_bytecode_hlsl5;
      desc.fs.bytecode.size = 668;
      desc.fs.entry = "main";
      desc.label = "skinned_lit_shader";
    }
    return &desc;
  }
  if (backend == SG_BACKEND_METAL_MACOS) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.vs.source = skinned_vertex_source_metal_macos;
      desc.vs.entry = "main0";
      desc.vs.uniform_blocks[0].size = 464;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.vs.uniform_blocks[1].size = 4096;
      desc.vs.uniform_blocks[1].layout = SG_UNIFORMLAYOUT_STD140;
      desc.vs.images[0].name = "blend_shapes";
      desc.vs.images[0].image_type = SG_IMAGETYPE_ARRAY;
      desc.vs.images[0].sampler_type = SG_SAMPLERTYPE_FLOAT;
      desc.fs.source = lit_pixel_source_metal_macos;
      desc.fs.entry = "main0";
      desc.label = "skinned_lit_shader";
    }
    return &desc;
  }
  return 0;
}
static inline const sg_shader_desc* static_lit_shader_desc(sg_backend backend) {
  if (backend == SG_BACKEND_GLCORE33) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.attrs[0].name = "a_position";
      desc.attrs[1].name = "a_normal";
      desc.attrs[2].name = "a_uv";
      desc.attrs[3].name = "a_vertex_index";
      desc.vs.source = static_vertex_source_glsl330;
      desc.vs.entry = "main";
      desc.vs.uniform_blocks[0].size = 464;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.vs.uniform_blocks[0].uniforms[0].name = "mesh_vertex_ubo";
      desc.vs.uniform_blocks[0].uniforms[0].type = SG_UNIFORMTYPE_FLOAT4;
      desc.vs.uniform_blocks[0].uniforms[0].array_count = 29;
      desc.vs.images[0].name = "blend_shapes";
      desc.vs.images[0].image_type = SG_IMAGETYPE_ARRAY;
      desc.vs.images[0].sampler_type = SG_SAMPLERTYPE_FLOAT;
      desc.fs.source = lit_pixel_source_glsl330;
      desc.fs.entry = "main";
      desc.label = "static_lit_shader";
    }
    return &desc;
  }
  if (backend == SG_BACKEND_D3D11) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.attrs[0].sem_name = "TEXCOORD";
      desc.attrs[0].sem_index = 0;
      desc.attrs[1].sem_name = "TEXCOORD";
      desc.attrs[1].sem_index = 1;
      desc.attrs[2].sem_name = "TEXCOORD";
      desc.attrs[2].sem_index = 2;
      desc.attrs[3].sem_name = "TEXCOORD";
      desc.attrs[3].sem_index = 3;
      desc.vs.bytecode.ptr = static_vertex_bytecode_hlsl5;
      desc.vs.bytecode.size = 2276;
      desc.vs.entry = "main";
      desc.vs.uniform_blocks[0].size = 464;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.vs.images[0].name = "blend_shapes";
      desc.vs.images[0].image_type = SG_IMAGETYPE_ARRAY;
      desc.vs.images[0].sampler_type = SG_SAMPLERTYPE_FLOAT;
      desc.fs.bytecode.ptr = lit_pixel_bytecode_hlsl5;
      desc.fs.bytecode.size = 668;
      desc.fs.entry = "main";
      desc.label = "static_lit_shader";
    }
    return &desc;
  }
  if (backend == SG_BACKEND_METAL_MACOS) {
    static sg_shader_desc desc;
    static bool valid;
    if (!valid) {
      valid = true;
      desc.vs.source = static_vertex_source_metal_macos;
      desc.vs.entry = "main0";
      desc.vs.uniform_blocks[0].size = 464;
      desc.vs.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
      desc.vs.images[0].name = "blend_shapes";
      desc.vs.images[0].image_type = SG_IMAGETYPE_ARRAY;
      desc.vs.images[0].sampler_type = SG_SAMPLERTYPE_FLOAT;
      desc.fs.source = lit_pixel_source_metal_macos;
      desc.fs.entry = "main0";
      desc.label = "static_lit_shader";
    }
    return &desc;
  }
  return 0;
}
