package example;/*
 * This Java source file was generated by the Gradle 'init' task.
 */

import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.*;

import java.util.LinkedList;
import java.util.List;

import static java.time.Duration.ofMillis;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;
import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

@DisplayName("A special tests collection for junit and mockito")
class LibraryTest {

    @BeforeAll
    static void initTestEnv() {
    }

    @BeforeEach
    void initEveryMethod() {
    }

    @Test
    @DisplayName("test Some example.Library Method")
    void testSomeLibraryMethod() {
        Library classUnderTest = new Library();
        Assertions.assertTrue(classUnderTest.someLibraryMethod(), "someLibraryMethod should return 'true'");
        MatcherAssert.assertThat(classUnderTest.someLibraryMethod(), is(true));
    }

    @Test
    @SuppressWarnings("unchecked")
    void testMockClass() throws Exception {
        // you can mock concrete classes, not only interfaces
        LinkedList mockedList = mock(LinkedList.class);

        // stubbing appears before the actual execution
        String value = "first";
        when(mockedList.get(0)).thenReturn(value);

        assertEquals(mockedList.get(0), value);
    }

    @Test
    @SuppressWarnings("unchecked")
    void test_mock_verify() {
        // mock creation
        List<String> mockedList = mock(List.class);
        // using mock object - it does not throw any "unexpected interaction" exception
        mockedList.add("one");
        mockedList.clear();
        // selective, explicit, highly readable verification
        verify(mockedList).add("one");
        verify(mockedList).clear();
    }

    @Test
    void groupedAssertions() {
        // In a grouped assertion all assertions are executed, and any
        // failures will be reported together.
        String firstName = "John";
        String lastName = "Doe";

        assertAll("person",
                () -> assertEquals("John", firstName),
                () -> assertEquals("Doe", lastName)
        );
    }

    @Test
    void exceptionTesting() {
        Throwable exception = assertThrows(IllegalArgumentException.class, () -> {
            throw new IllegalArgumentException("a message");
        });
        assertEquals("a message", exception.getMessage());
    }

    @Test
    @Disabled
    void timeoutExceeded() {
        // The following assertion fails with an error message similar to:
        // execution exceeded timeout of 10 ms by 91 ms
        assertTimeout(ofMillis(10), () -> {
            // Simulate task that takes more than 10 ms.
            Thread.sleep(100);
        });
    }
}
