package com.github.twitch4j.pubsub.domain;

import com.github.twitch4j.common.util.TypeConvert;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

import java.time.Instant;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertNotNull;

@Tag("unittest")
class HypeLevelUpTest {

    @Test
    void deserialize() {
        HypeLevelUp data = TypeConvert.jsonToObject(
            "{\"time_to_expire\":1719598934000,\"progress\":{\"level\":{\"value\":2,\"goal\":4500,\"rewards\":[{\"type\":\"EMOTE\",\"id\":\"emotesv2_e7c9f4491c9b44d68e41aff832851872\",\"group_id\":\"\",\"reward_level\":0,\"set_id\":\"8a15970c-7e72-46d4-b560-1cb4997f4b0a\",\"token\":\"AGiftForYou\",\"reward_end_date\":\"0001-01-01T00:00:00Z\"},{\"type\":\"EMOTE\",\"id\":\"emotesv2_3969f334f5a2425d9fad53daabb06982\",\"group_id\":\"\",\"reward_level\":0,\"set_id\":\"8a15970c-7e72-46d4-b560-1cb4997f4b0a\",\"token\":\"KittyHype\",\"reward_end_date\":\"0001-01-01T00:00:00Z\"},{\"type\":\"EMOTE\",\"id\":\"emotesv2_da6ee66bc259434085eb866429687941\",\"group_id\":\"\",\"reward_level\":0,\"set_id\":\"8a15970c-7e72-46d4-b560-1cb4997f4b0a\",\"token\":\"DangerDance\",\"reward_end_date\":\"0001-01-01T00:00:00Z\"},{\"type\":\"EMOTE\",\"id\":\"emotesv2_20a5c29af55240d4a276e0ffd828db3e\",\"group_id\":\"\",\"reward_level\":0,\"set_id\":\"8a15970c-7e72-46d4-b560-1cb4997f4b0a\",\"token\":\"PersonalBest\",\"reward_end_date\":\"0001-01-01T00:00:00Z\"},{\"type\":\"EMOTE\",\"id\":\"emotesv2_18479de9ad48456aab82a8c9e24e864b\",\"group_id\":\"\",\"reward_level\":0,\"set_id\":\"8a15970c-7e72-46d4-b560-1cb4997f4b0a\",\"token\":\"HenloThere\",\"reward_end_date\":\"0001-01-01T00:00:00Z\"},{\"type\":\"EMOTE\",\"id\":\"emotesv2_0d9792a1c8d3499cac7c2b517dc0f682\",\"group_id\":\"\",\"reward_level\":0,\"set_id\":\"8a15970c-7e72-46d4-b560-1cb4997f4b0a\",\"token\":\"GimmeDat\",\"reward_end_date\":\"0001-01-01T00:00:00Z\"}]},\"value\":0,\"goal\":2500,\"total\":2000,\"remaining_seconds\":299,\"all_time_high_state\":\"NONE\"},\"is_boost_train\":false,\"hype_train\":{\"__typename\":\"HypeTrainExecution\",\"id\":\"d5562d1b-41a6-49dd-a8dd-1c10ac8ba3b7\",\"startedAt\":\"2024-06-28T18:16:07.283925942Z\",\"expiresAt\":\"2024-06-28T18:22:14.747855254Z\",\"updatedAt\":\"2024-06-28T18:17:14.7353802Z\",\"endedAt\":null,\"endReason\":\"IN_PROGRESS\",\"isGoldenKappaTrain\":false,\"progress\":{\"__typename\":\"HypeTrainProgress\",\"id\":\"d5562d1b-41a6-49dd-a8dd-1c10ac8ba3b7\",\"goal\":2500,\"progression\":0,\"total\":2000,\"level\":{\"__typename\":\"HypeTrainLevel\",\"id\":\"173164131:MEDIUM:2\",\"value\":2,\"goal\":4500,\"rewards\":[{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_e7c9f4491c9b44d68e41aff832851872\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_e7c9f4491c9b44d68e41aff832851872\",\"token\":\"AGiftForYou\"}},{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_3969f334f5a2425d9fad53daabb06982\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_3969f334f5a2425d9fad53daabb06982\",\"token\":\"KittyHype\"}},{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_da6ee66bc259434085eb866429687941\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_da6ee66bc259434085eb866429687941\",\"token\":\"DangerDance\"}},{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_20a5c29af55240d4a276e0ffd828db3e\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_20a5c29af55240d4a276e0ffd828db3e\",\"token\":\"PersonalBest\"}},{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_18479de9ad48456aab82a8c9e24e864b\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_18479de9ad48456aab82a8c9e24e864b\",\"token\":\"HenloThere\"}},{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_0d9792a1c8d3499cac7c2b517dc0f682\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_0d9792a1c8d3499cac7c2b517dc0f682\",\"token\":\"GimmeDat\"}}]},\"allTimeHighState\":\"NONE\"},\"conductors\":[{\"__typename\":\"HypeTrainConductor\",\"id\":\"d5562d1b-41a6-49dd-a8dd-1c10ac8ba3b7-SUBS\",\"source\":\"SUBS\",\"participation\":[{\"__typename\":\"HypeTrainParticipation\",\"source\":\"SUBS\",\"action\":\"TIER_1_SUB\",\"quantity\":1}],\"user\":{\"__typename\":\"User\",\"id\":\"100371732\",\"displayName\":\"\",\"login\":\"\",\"profileImageURL\":\"\"}}],\"config\":{\"__typename\":\"HypeTrainConfig\",\"id\":\"173164131:d5562d1b-41a6-49dd-a8dd-1c10ac8ba3b7\",\"willUseCreatorColor\":false,\"primaryHexColor\":null,\"conductorRewards\":[{\"__typename\":\"HypeTrainConductorReward\",\"source\":\"BITS\",\"type\":\"CURRENT\",\"rewards\":[{\"__typename\":\"HypeTrainBadgeReward\",\"id\":\"1\",\"type\":\"BADGE\",\"badge\":{\"__typename\":\"Badge\",\"id\":\"aHlwZS10cmFpbjsxOzE3MzE2NDEzMQ==\",\"setID\":\"hype-train\",\"imageURL\":\"https://static-cdn.jtvnw.net/badges/v1/fae4086c-3190-44d4-83c8-8ef0cbe1a515/2\"}}]},{\"__typename\":\"HypeTrainConductorReward\",\"source\":\"BITS\",\"type\":\"FORMER\",\"rewards\":[{\"__typename\":\"HypeTrainBadgeReward\",\"id\":\"2\",\"type\":\"BADGE\",\"badge\":{\"__typename\":\"Badge\",\"id\":\"aHlwZS10cmFpbjsyOzE3MzE2NDEzMQ==\",\"setID\":\"hype-train\",\"imageURL\":\"https://static-cdn.jtvnw.net/badges/v1/9c8d038a-3a29-45ea-96d4-5031fb1a7a81/2\"}}]},{\"__typename\":\"HypeTrainConductorReward\",\"source\":\"SUBS\",\"type\":\"CURRENT\",\"rewards\":[{\"__typename\":\"HypeTrainBadgeReward\",\"id\":\"1\",\"type\":\"BADGE\",\"badge\":{\"__typename\":\"Badge\",\"id\":\"aHlwZS10cmFpbjsxOzE3MzE2NDEzMQ==\",\"setID\":\"hype-train\",\"imageURL\":\"https://static-cdn.jtvnw.net/badges/v1/fae4086c-3190-44d4-83c8-8ef0cbe1a515/2\"}}]},{\"__typename\":\"HypeTrainConductorReward\",\"source\":\"SUBS\",\"type\":\"FORMER\",\"rewards\":[{\"__typename\":\"HypeTrainBadgeReward\",\"id\":\"2\",\"type\":\"BADGE\",\"badge\":{\"__typename\":\"Badge\",\"id\":\"aHlwZS10cmFpbjsyOzE3MzE2NDEzMQ==\",\"setID\":\"hype-train\",\"imageURL\":\"https://static-cdn.jtvnw.net/badges/v1/9c8d038a-3a29-45ea-96d4-5031fb1a7a81/2\"}}]},{\"__typename\":\"HypeTrainConductorReward\",\"source\":\"EXPLICIT_PURCHASE\",\"type\":\"CURRENT\",\"rewards\":[{\"__typename\":\"HypeTrainBadgeReward\",\"id\":\"1\",\"type\":\"BADGE\",\"badge\":{\"__typename\":\"Badge\",\"id\":\"aHlwZS10cmFpbjsxOzE3MzE2NDEzMQ==\",\"setID\":\"hype-train\",\"imageURL\":\"https://static-cdn.jtvnw.net/badges/v1/fae4086c-3190-44d4-83c8-8ef0cbe1a515/2\"}}]},{\"__typename\":\"HypeTrainConductorReward\",\"source\":\"EXPLICIT_PURCHASE\",\"type\":\"FORMER\",\"rewards\":[{\"__typename\":\"HypeTrainBadgeReward\",\"id\":\"2\",\"type\":\"BADGE\",\"badge\":{\"__typename\":\"Badge\",\"id\":\"aHlwZS10cmFpbjsyOzE3MzE2NDEzMQ==\",\"setID\":\"hype-train\",\"imageURL\":\"https://static-cdn.jtvnw.net/badges/v1/9c8d038a-3a29-45ea-96d4-5031fb1a7a81/2\"}}]}],\"participationConversionRates\":[{\"__typename\":\"HypeTrainParticipationConversionRate\",\"action\":\"UNKNOWN\",\"source\":\"UNKNOWN\",\"value\":0},{\"__typename\":\"HypeTrainParticipationConversionRate\",\"action\":\"TIER_2_GIFTED_SUB\",\"source\":\"SUBS\",\"value\":1000},{\"__typename\":\"HypeTrainParticipationConversionRate\",\"action\":\"CHEER\",\"source\":\"BITS\",\"value\":1},{\"__typename\":\"HypeTrainParticipationConversionRate\",\"action\":\"BITS_ON_EXTENSION\",\"source\":\"BITS\",\"value\":1},{\"__typename\":\"HypeTrainParticipationConversionRate\",\"action\":\"TIER_3_SUB\",\"source\":\"SUBS\",\"value\":2500},{\"__typename\":\"HypeTrainParticipationConversionRate\",\"action\":\"TIER_2_SUB\",\"source\":\"SUBS\",\"value\":1000},{\"__typename\":\"HypeTrainParticipationConversionRate\",\"action\":\"TIER_1_GIFTED_SUB\",\"source\":\"SUBS\",\"value\":500},{\"__typename\":\"HypeTrainParticipationConversionRate\",\"action\":\"POLLS\",\"source\":\"BITS\",\"value\":1},{\"__typename\":\"HypeTrainParticipationConversionRate\",\"action\":\"TIER_1_SUB\",\"source\":\"SUBS\",\"value\":500},{\"__typename\":\"HypeTrainParticipationConversionRate\",\"action\":\"TIER_3_GIFTED_SUB\",\"source\":\"SUBS\",\"value\":2500}],\"calloutEmote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_00659fc4ae6948a6b23585e83f62d477\",\"token\":\"PogChomp\"},\"difficulty\":\"MEDIUM\",\"difficultySettings\":[{\"__typename\":\"HypeTrainDifficultySettings\",\"difficulty\":\"MEDIUM\",\"maxLevel\":289}],\"potentialRewards\":[{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"5:emotesv2_1d68d57fa07a4636aa3325e95c85f19a\",\"level\":5,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_1d68d57fa07a4636aa3325e95c85f19a\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_1d68d57fa07a4636aa3325e95c85f19a\",\"token\":\"RaccoonPop\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"5:emotesv2_f033a950174e447cb68a3380ed9da914\",\"level\":5,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_f033a950174e447cb68a3380ed9da914\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_f033a950174e447cb68a3380ed9da914\",\"token\":\"GoblinJam\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"5:emotesv2_b13f48e4ca704d1cb13123631467616e\",\"level\":5,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_b13f48e4ca704d1cb13123631467616e\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_b13f48e4ca704d1cb13123631467616e\",\"token\":\"YouMissed\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"5:emotesv2_c7aefc45412147b284273098a518c94b\",\"level\":5,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_c7aefc45412147b284273098a518c94b\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_c7aefc45412147b284273098a518c94b\",\"token\":\"GriddyGoose\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"5:emotesv2_b308322f860543f78e046294a9614c68\",\"level\":5,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_b308322f860543f78e046294a9614c68\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_b308322f860543f78e046294a9614c68\",\"token\":\"CheersToThat\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"5:emotesv2_827188949087491ab7d44ecfbfb4e58c\",\"level\":5,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_827188949087491ab7d44ecfbfb4e58c\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_827188949087491ab7d44ecfbfb4e58c\",\"token\":\"StirThePot\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"106:emotesv2_6d23a98b64ad45d9a9c78cb7e48908d6\",\"level\":106,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_6d23a98b64ad45d9a9c78cb7e48908d6\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_6d23a98b64ad45d9a9c78cb7e48908d6\",\"token\":\"DidIBreakIt\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"2:emotesv2_e7c9f4491c9b44d68e41aff832851872\",\"level\":2,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_e7c9f4491c9b44d68e41aff832851872\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_e7c9f4491c9b44d68e41aff832851872\",\"token\":\"AGiftForYou\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"2:emotesv2_3969f334f5a2425d9fad53daabb06982\",\"level\":2,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_3969f334f5a2425d9fad53daabb06982\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_3969f334f5a2425d9fad53daabb06982\",\"token\":\"KittyHype\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"2:emotesv2_da6ee66bc259434085eb866429687941\",\"level\":2,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_da6ee66bc259434085eb866429687941\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_da6ee66bc259434085eb866429687941\",\"token\":\"DangerDance\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"2:emotesv2_20a5c29af55240d4a276e0ffd828db3e\",\"level\":2,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_20a5c29af55240d4a276e0ffd828db3e\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_20a5c29af55240d4a276e0ffd828db3e\",\"token\":\"PersonalBest\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"2:emotesv2_18479de9ad48456aab82a8c9e24e864b\",\"level\":2,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_18479de9ad48456aab82a8c9e24e864b\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_18479de9ad48456aab82a8c9e24e864b\",\"token\":\"HenloThere\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"2:emotesv2_0d9792a1c8d3499cac7c2b517dc0f682\",\"level\":2,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_0d9792a1c8d3499cac7c2b517dc0f682\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_0d9792a1c8d3499cac7c2b517dc0f682\",\"token\":\"GimmeDat\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"10:emotesv2_bf888b2af57b4abd80653dff26768ae5\",\"level\":10,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_bf888b2af57b4abd80653dff26768ae5\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_bf888b2af57b4abd80653dff26768ae5\",\"token\":\"BleedPurpleHD\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"25:emotesv2_132feb3980ee410e856244931d63fd31\",\"level\":25,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_132feb3980ee410e856244931d63fd31\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_132feb3980ee410e856244931d63fd31\",\"token\":\"HeyHeyGuys\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"1:emotesv2_a3cdcbfcae9b41bb8215b012362eea35\",\"level\":1,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_a3cdcbfcae9b41bb8215b012362eea35\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_a3cdcbfcae9b41bb8215b012362eea35\",\"token\":\"FrogPonder\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"1:emotesv2_7fa0ba50748c418d956afa59c2e94883\",\"level\":1,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_7fa0ba50748c418d956afa59c2e94883\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_7fa0ba50748c418d956afa59c2e94883\",\"token\":\"ChillGirl\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"1:emotesv2_92d34a3642744c6bb540b091d3e9e9b0\",\"level\":1,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_92d34a3642744c6bb540b091d3e9e9b0\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_92d34a3642744c6bb540b091d3e9e9b0\",\"token\":\"ButtonMash\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"1:emotesv2_bc2ca1d0a58b4731a9fc3432cb175c86\",\"level\":1,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_bc2ca1d0a58b4731a9fc3432cb175c86\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_bc2ca1d0a58b4731a9fc3432cb175c86\",\"token\":\"BatterUp\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"1:emotesv2_692f743d3e7147068bb1ddf842f9b99d\",\"level\":1,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_692f743d3e7147068bb1ddf842f9b99d\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_692f743d3e7147068bb1ddf842f9b99d\",\"token\":\"GoodOne\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"1:emotesv2_aa8db3de21e1465dab81bedfa47e29f2\",\"level\":1,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_aa8db3de21e1465dab81bedfa47e29f2\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_aa8db3de21e1465dab81bedfa47e29f2\",\"token\":\"MegaConsume\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"100:emotesv2_ae9328d25e4b424c8dd2af714045e538\",\"level\":100,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_ae9328d25e4b424c8dd2af714045e538\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_ae9328d25e4b424c8dd2af714045e538\",\"token\":\"KappaInfinite\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"3:emotesv2_2a52b54c6fb04a6fbb6b9eb51fa8e0d0\",\"level\":3,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_2a52b54c6fb04a6fbb6b9eb51fa8e0d0\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_2a52b54c6fb04a6fbb6b9eb51fa8e0d0\",\"token\":\"MegaMlep\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"3:emotesv2_91b3e913c6484fca894830ab953aa16b\",\"level\":3,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_91b3e913c6484fca894830ab953aa16b\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_91b3e913c6484fca894830ab953aa16b\",\"token\":\"RawkOut\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"3:emotesv2_8120b15b9e054b31a200a5cb6cade4c7\",\"level\":3,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_8120b15b9e054b31a200a5cb6cade4c7\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_8120b15b9e054b31a200a5cb6cade4c7\",\"token\":\"FallDamage\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"3:emotesv2_a83f8ade02cd4b37b8ae079584407c66\",\"level\":3,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_a83f8ade02cd4b37b8ae079584407c66\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_a83f8ade02cd4b37b8ae079584407c66\",\"token\":\"RedCard\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"3:emotesv2_c3db311615df4ecb9e3be0c492fbfc8b\",\"level\":3,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_c3db311615df4ecb9e3be0c492fbfc8b\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_c3db311615df4ecb9e3be0c492fbfc8b\",\"token\":\"ApplauseBreak\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"3:emotesv2_871fb6fa55d54fae8e807198c59e082f\",\"level\":3,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_871fb6fa55d54fae8e807198c59e082f\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_871fb6fa55d54fae8e807198c59e082f\",\"token\":\"TouchOfSalt\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"50:emotesv2_00659fc4ae6948a6b23585e83f62d477\",\"level\":50,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_00659fc4ae6948a6b23585e83f62d477\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_00659fc4ae6948a6b23585e83f62d477\",\"token\":\"PogChomp\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"4:emotesv2_3e61175d445245838665fff146bd2bb0\",\"level\":4,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_3e61175d445245838665fff146bd2bb0\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_3e61175d445245838665fff146bd2bb0\",\"token\":\"KittyLove\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"4:emotesv2_8b79f878cfff4671ae0fb7522c69ea07\",\"level\":4,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_8b79f878cfff4671ae0fb7522c69ea07\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_8b79f878cfff4671ae0fb7522c69ea07\",\"token\":\"TurnUp\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"4:emotesv2_1cce76af186d4022821e8e67bb367055\",\"level\":4,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_1cce76af186d4022821e8e67bb367055\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_1cce76af186d4022821e8e67bb367055\",\"token\":\"CatScare\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"4:emotesv2_e8236afbc65347ebb4938c6507a78012\",\"level\":4,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_e8236afbc65347ebb4938c6507a78012\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_e8236afbc65347ebb4938c6507a78012\",\"token\":\"LateSave\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"4:emotesv2_94736686188047bab48c9e2ca9666496\",\"level\":4,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_94736686188047bab48c9e2ca9666496\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_94736686188047bab48c9e2ca9666496\",\"token\":\"NoTheyDidNot\"}}},{\"__typename\":\"HypeTrainPotentialReward\",\"id\":\"4:emotesv2_cef4e35f8d134fbc8172fe622bc51bfe\",\"level\":4,\"value\":{\"__typename\":\"HypeTrainEmoteReward\",\"id\":\"emotesv2_cef4e35f8d134fbc8172fe622bc51bfe\",\"type\":\"EMOTE\",\"emote\":{\"__typename\":\"Emote\",\"id\":\"emotesv2_cef4e35f8d134fbc8172fe622bc51bfe\",\"token\":\"BeholdThis\"}}}]},\"allTimeHigh\":{\"__typename\":\"HypeTrainCompleted\",\"goal\":87500,\"progression\":52310,\"total\":580210,\"level\":{\"__typename\":\"HypeTrainLevel\",\"id\":\"173164131:MEDIUM:20\",\"value\":20}},\"isFastMode\":false,\"participations\":[{\"__typename\":\"HypeTrainParticipation\",\"source\":\"SUBS\",\"action\":\"TIER_1_GIFTED_SUB\",\"quantity\":1},{\"__typename\":\"HypeTrainParticipation\",\"source\":\"SUBS\",\"action\":\"TIER_1_SUB\",\"quantity\":3}]}}",
            HypeLevelUp.class
        );

        assertEquals(Instant.ofEpochMilli(1719598934000L), data.getTimeToExpire());
        assertFalse(data.isBoostTrain());
        assertEquals(0, data.getProgress().getValue());
        assertEquals(2500, data.getProgress().getGoal());
        assertEquals(2000, data.getProgress().getTotal());
        assertEquals(299, data.getProgress().getRemainingSeconds());
        assertEquals("NONE", data.getProgress().getAllTimeHighState());
        assertEquals(2, data.getProgress().getLevel().getValue());
        assertEquals(4500, data.getProgress().getLevel().getGoal());
        assertEquals("AGiftForYou", data.getProgress().getLevel().getRewards().get(0).getToken());

        assertFalse(data.getHypeTrain().isGoldenKappaTrain());
        assertFalse(data.getHypeTrain().isFastMode());
        assertEquals("d5562d1b-41a6-49dd-a8dd-1c10ac8ba3b7", data.getHypeTrain().getId());
        assertEquals(Instant.parse("2024-06-28T18:16:07.283925942Z"), data.getHypeTrain().getStartedAt());
        assertEquals(Instant.parse("2024-06-28T18:17:14.7353802Z"), data.getHypeTrain().getUpdatedAt());
        assertEquals(Instant.parse("2024-06-28T18:22:14.747855254Z"), data.getHypeTrain().getExpiresAt());

        assertEquals(87500, data.getHypeTrain().getAllTimeHigh().getGoal());
        assertEquals(52310, data.getHypeTrain().getAllTimeHigh().getProgression());
        assertEquals(580210, data.getHypeTrain().getAllTimeHigh().getTotal());
        assertEquals(20, data.getHypeTrain().getAllTimeHigh().getLevel().getValue());

        HypeConductor conductor = data.getHypeTrain().getConductors().get(0);
        assertEquals("SUBS", conductor.getSource());
        assertEquals(1, conductor.getParticipation().get(0).getQuantity());
        assertEquals("100371732", conductor.getUser().getId());
        assertEquals(3, data.getHypeTrain().getContributions().get(1).getQuantity());

        HypeTrainConfig config = data.getHypeTrain().getConfig();
        assertFalse(config.getUseCreatorColor());
        assertNotNull(config.getLeaderRewards().get(0).getRewards().get(0).getBadge());
        assertEquals("TIER_2_GIFTED_SUB", config.getConversionRates().get(1).getAction());
        assertEquals(1000, config.getConversionRates().get(1).getQuantity());
        assertEquals("emotesv2_00659fc4ae6948a6b23585e83f62d477", config.getCalloutEmote().getId());
        assertEquals("MEDIUM", config.getDifficulty());
        assertEquals(289, config.getDifficultySetting().get(0).getMaxLevel());
        HypeTrainPotentialReward potentialReward = config.getPotentialRewards().get(0);
        assertEquals("emotesv2_1d68d57fa07a4636aa3325e95c85f19a", potentialReward.getValue().getId());
    }

}
