# Security Policy

## Supported Versions

Please focus your analysis on the [latest](https://github.com/twitch4j/twitch4j/releases/latest) stable version of the library.

If the project maintainers deem the issue to be particularly significant, a patch may be backported to some previous versions.


## Reporting a Vulnerability

Please privately report any vulnerabilities as a [Github Security Advisory](https://github.com/twitch4j/twitch4j/security/advisories/new) (or you can email `security@philippheuer.me` and `gitprodigy@proton.me`).

We will acknowledge the report within a week and begin investigating.
If you do not receive this acknowledgement, please nudge us via [Discord](https://discord.gg/FQ5vgW3) or a Github Issue,
but refrain from including any details of the vulnerability in public forums.

### Disclosure

Our vulnerability disclosure guidelines are similar to Google's [Project Zero rules](https://googleprojectzero.blogspot.com/p/vulnerability-disclosure-policy.html).

Once you report a vulnerability, we have 90 days to make a patch available for users.
Once a patch is released, you may publicly disclose the vulnerability details after 30 more days (so users have time to upgrade).
If we do not release a patch within this period, you can publicly disclose the details of the vulnerability without further delay.

If the vulnerability is shown to be already exploited "in the wild," the 90-day period is replaced by a 10-day period.
However, the 30 additional days before public disclosure still apply, if we are able to publish a patch within the period.

Lastly, early disclosure is permitted only if mutually agreed upon by the issue reporter and the project maintainers.
