//
// win32.h
// Created by Tuyen Mai on 9/10/19.
// Copyright (c) 2019 Tuyen Mai. All rights reserved.
//


#ifndef OPENKEY_WIN32_H
#define OPENKEY_WIN32_H
#include <windows.h>

//define Key code for Windows keyboard
#define KEY_ESC                                 VK_ESCAPE
#define KEY_DELETE                              VK_BACK
#define KEY_TAB                                 VK_TAB
#define KEY_ENTER                               VK_RETURN
#define KEY_RETURN                              VK_RETURN
#define KEY_SPACE                               VK_SPACE
#define KEY_LEFT                                VK_LEFT
#define KEY_RIGHT                               VK_RIGHT
#define KEY_DOWN                                VK_DOWN
#define KEY_UP                                  VK_UP

#define KEY_EMPTY                               256
#define KEY_A                                   0x41
#define KEY_B                                   0x42
#define KEY_C                                   0x43
#define KEY_D                                   0x44
#define KEY_E                                   0x45
#define KEY_F                                   0x46
#define KEY_G                                   0x47
#define KEY_H                                   0x48
#define KEY_I                                   0x49
#define KEY_J                                   0x4A
#define KEY_K                                   0x4B
#define KEY_L                                   0x4C
#define KEY_M                                   0x4D
#define KEY_N                                   0x4E
#define KEY_O                                   0x4F
#define KEY_P                                   0x50
#define KEY_Q                                   0x51
#define KEY_R                                   0x52
#define KEY_S                                   0x53
#define KEY_T                                   0x54
#define KEY_U                                   0x55
#define KEY_V                                   0x56
#define KEY_W                                   0x57
#define KEY_X                                   0x58
#define KEY_Y                                   0x59
#define KEY_Z                                   0x5A

#define KEY_1                                   0x31
#define KEY_2                                   0x32
#define KEY_3                                   0x33
#define KEY_4                                   0x34
#define KEY_5                                   0x35
#define KEY_6                                   0x36
#define KEY_7                                   0x37
#define KEY_8                                   0x38
#define KEY_9                                   0x39
#define KEY_0                                   0x30

#define KEY_LEFT_BRACKET                        0xDB //note
#define KEY_RIGHT_BRACKET                       0xDD

#define KEY_LEFT_SHIFT                          160
#define KEY_RIGHT_SHIFT                         161
#define KEY_DOT                                 VK_OEM_PERIOD

#define KEY_BACKQUOTE                           220
#define KEY_MINUS                               189
#define KEY_EQUALS                              187
#define KEY_BACK_SLASH                          222
#define KEY_SEMICOLON                           186
#define KEY_QUOTE                               192
#define KEY_COMMA                               VK_OEM_COMMA
#define KEY_SLASH                               191

#endif //OPENKEY_WIN32_H