/* Automatically generated nanopb header */
/* Generated by nanopb-0.4.8 */

#ifndef PB_MESHTASTIC_MESHTASTIC_MODULE_CONFIG_PB_H_INCLUDED
#define PB_MESHTASTIC_MESHTASTIC_MODULE_CONFIG_PB_H_INCLUDED
#include <pb.h>

#if PB_PROTO_HEADER_VERSION != 40
#error Regenerate this file with the current version of nanopb generator.
#endif

/* Enum definitions */
typedef enum _meshtastic_RemoteHardwarePinType {
    /* Unset/unused */
    meshtastic_RemoteHardwarePinType_UNKNOWN = 0,
    /* GPIO pin can be read (if it is high / low) */
    meshtastic_RemoteHardwarePinType_DIGITAL_READ = 1,
    /* GPIO pin can be written to (high / low) */
    meshtastic_RemoteHardwarePinType_DIGITAL_WRITE = 2
} meshtastic_RemoteHardwarePinType;

/* Baudrate for codec2 voice */
typedef enum _meshtastic_ModuleConfig_AudioConfig_Audio_Baud {
    meshtastic_ModuleConfig_AudioConfig_Audio_Baud_CODEC2_DEFAULT = 0,
    meshtastic_ModuleConfig_AudioConfig_Audio_Baud_CODEC2_3200 = 1,
    meshtastic_ModuleConfig_AudioConfig_Audio_Baud_CODEC2_2400 = 2,
    meshtastic_ModuleConfig_AudioConfig_Audio_Baud_CODEC2_1600 = 3,
    meshtastic_ModuleConfig_AudioConfig_Audio_Baud_CODEC2_1400 = 4,
    meshtastic_ModuleConfig_AudioConfig_Audio_Baud_CODEC2_1300 = 5,
    meshtastic_ModuleConfig_AudioConfig_Audio_Baud_CODEC2_1200 = 6,
    meshtastic_ModuleConfig_AudioConfig_Audio_Baud_CODEC2_700 = 7,
    meshtastic_ModuleConfig_AudioConfig_Audio_Baud_CODEC2_700B = 8
} meshtastic_ModuleConfig_AudioConfig_Audio_Baud;

/* TODO: REPLACE */
typedef enum _meshtastic_ModuleConfig_SerialConfig_Serial_Baud {
    meshtastic_ModuleConfig_SerialConfig_Serial_Baud_BAUD_DEFAULT = 0,
    meshtastic_ModuleConfig_SerialConfig_Serial_Baud_BAUD_110 = 1,
    meshtastic_ModuleConfig_SerialConfig_Serial_Baud_BAUD_300 = 2,
    meshtastic_ModuleConfig_SerialConfig_Serial_Baud_BAUD_600 = 3,
    meshtastic_ModuleConfig_SerialConfig_Serial_Baud_BAUD_1200 = 4,
    meshtastic_ModuleConfig_SerialConfig_Serial_Baud_BAUD_2400 = 5,
    meshtastic_ModuleConfig_SerialConfig_Serial_Baud_BAUD_4800 = 6,
    meshtastic_ModuleConfig_SerialConfig_Serial_Baud_BAUD_9600 = 7,
    meshtastic_ModuleConfig_SerialConfig_Serial_Baud_BAUD_19200 = 8,
    meshtastic_ModuleConfig_SerialConfig_Serial_Baud_BAUD_38400 = 9,
    meshtastic_ModuleConfig_SerialConfig_Serial_Baud_BAUD_57600 = 10,
    meshtastic_ModuleConfig_SerialConfig_Serial_Baud_BAUD_115200 = 11,
    meshtastic_ModuleConfig_SerialConfig_Serial_Baud_BAUD_230400 = 12,
    meshtastic_ModuleConfig_SerialConfig_Serial_Baud_BAUD_460800 = 13,
    meshtastic_ModuleConfig_SerialConfig_Serial_Baud_BAUD_576000 = 14,
    meshtastic_ModuleConfig_SerialConfig_Serial_Baud_BAUD_921600 = 15
} meshtastic_ModuleConfig_SerialConfig_Serial_Baud;

/* TODO: REPLACE */
typedef enum _meshtastic_ModuleConfig_SerialConfig_Serial_Mode {
    meshtastic_ModuleConfig_SerialConfig_Serial_Mode_DEFAULT = 0,
    meshtastic_ModuleConfig_SerialConfig_Serial_Mode_SIMPLE = 1,
    meshtastic_ModuleConfig_SerialConfig_Serial_Mode_PROTO = 2,
    meshtastic_ModuleConfig_SerialConfig_Serial_Mode_TEXTMSG = 3,
    meshtastic_ModuleConfig_SerialConfig_Serial_Mode_NMEA = 4,
    /* NMEA messages specifically tailored for CalTopo */
    meshtastic_ModuleConfig_SerialConfig_Serial_Mode_CALTOPO = 5
} meshtastic_ModuleConfig_SerialConfig_Serial_Mode;

/* TODO: REPLACE */
typedef enum _meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar {
    /* TODO: REPLACE */
    meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_NONE = 0,
    /* TODO: REPLACE */
    meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_UP = 17,
    /* TODO: REPLACE */
    meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_DOWN = 18,
    /* TODO: REPLACE */
    meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_LEFT = 19,
    /* TODO: REPLACE */
    meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_RIGHT = 20,
    /* '\n' */
    meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_SELECT = 10,
    /* TODO: REPLACE */
    meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_BACK = 27,
    /* TODO: REPLACE */
    meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_CANCEL = 24
} meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar;

/* Struct definitions */
/* Settings for reporting unencrypted information about our node to a map via MQTT */
typedef struct _meshtastic_ModuleConfig_MapReportSettings {
    /* How often we should report our info to the map (in seconds) */
    uint32_t publish_interval_secs;
    /* Bits of precision for the location sent (default of 32 is full precision). */
    uint32_t position_precision;
} meshtastic_ModuleConfig_MapReportSettings;

/* MQTT Client Config */
typedef struct _meshtastic_ModuleConfig_MQTTConfig {
    /* If a meshtastic node is able to reach the internet it will normally attempt to gateway any channels that are marked as
 is_uplink_enabled or is_downlink_enabled. */
    bool enabled;
    /* The server to use for our MQTT global message gateway feature.
 If not set, the default server will be used */
    char address[64];
    /* MQTT username to use (most useful for a custom MQTT server).
 If using a custom server, this will be honoured even if empty.
 If using the default server, this will only be honoured if set, otherwise the device will use the default username */
    char username[64];
    /* MQTT password to use (most useful for a custom MQTT server).
 If using a custom server, this will be honoured even if empty.
 If using the default server, this will only be honoured if set, otherwise the device will use the default password */
    char password[64];
    /* Whether to send encrypted or decrypted packets to MQTT.
 This parameter is only honoured if you also set server
 (the default official mqtt.meshtastic.org server can handle encrypted packets)
 Decrypted packets may be useful for external systems that want to consume meshtastic packets */
    bool encryption_enabled;
    /* Whether to send / consume json packets on MQTT */
    bool json_enabled;
    /* If true, we attempt to establish a secure connection using TLS */
    bool tls_enabled;
    /* The root topic to use for MQTT messages. Default is "msh".
 This is useful if you want to use a single MQTT server for multiple meshtastic networks and separate them via ACLs */
    char root[32];
    /* If true, we can use the connected phone / client to proxy messages to MQTT instead of a direct connection */
    bool proxy_to_client_enabled;
    /* If true, we will periodically report unencrypted information about our node to a map via MQTT */
    bool map_reporting_enabled;
    /* Settings for reporting information about our node to a map via MQTT */
    bool has_map_report_settings;
    meshtastic_ModuleConfig_MapReportSettings map_report_settings;
} meshtastic_ModuleConfig_MQTTConfig;

/* NeighborInfoModule Config */
typedef struct _meshtastic_ModuleConfig_NeighborInfoConfig {
    /* Whether the Module is enabled */
    bool enabled;
    /* Interval in seconds of how often we should try to send our
 Neighbor Info to the mesh */
    uint32_t update_interval;
} meshtastic_ModuleConfig_NeighborInfoConfig;

/* Detection Sensor Module Config */
typedef struct _meshtastic_ModuleConfig_DetectionSensorConfig {
    /* Whether the Module is enabled */
    bool enabled;
    /* Interval in seconds of how often we can send a message to the mesh when a state change is detected */
    uint32_t minimum_broadcast_secs;
    /* Interval in seconds of how often we should send a message to the mesh with the current state regardless of changes
 When set to 0, only state changes will be broadcasted
 Works as a sort of status heartbeat for peace of mind */
    uint32_t state_broadcast_secs;
    /* Send ASCII bell with alert message
 Useful for triggering ext. notification on bell */
    bool send_bell;
    /* Friendly name used to format message sent to mesh
 Example: A name "Motion" would result in a message "Motion detected"
 Maximum length of 20 characters */
    char name[20];
    /* GPIO pin to monitor for state changes */
    uint8_t monitor_pin;
    /* Whether or not the GPIO pin state detection is triggered on HIGH (1)
 Otherwise LOW (0) */
    bool detection_triggered_high;
    /* Whether or not use INPUT_PULLUP mode for GPIO pin
 Only applicable if the board uses pull-up resistors on the pin */
    bool use_pullup;
} meshtastic_ModuleConfig_DetectionSensorConfig;

/* Audio Config for codec2 voice */
typedef struct _meshtastic_ModuleConfig_AudioConfig {
    /* Whether Audio is enabled */
    bool codec2_enabled;
    /* PTT Pin */
    uint8_t ptt_pin;
    /* The audio sample rate to use for codec2 */
    meshtastic_ModuleConfig_AudioConfig_Audio_Baud bitrate;
    /* I2S Word Select */
    uint8_t i2s_ws;
    /* I2S Data IN */
    uint8_t i2s_sd;
    /* I2S Data OUT */
    uint8_t i2s_din;
    /* I2S Clock */
    uint8_t i2s_sck;
} meshtastic_ModuleConfig_AudioConfig;

/* Config for the Paxcounter Module */
typedef struct _meshtastic_ModuleConfig_PaxcounterConfig {
    /* Enable the Paxcounter Module */
    bool enabled;
    uint32_t paxcounter_update_interval;
} meshtastic_ModuleConfig_PaxcounterConfig;

/* Serial Config */
typedef struct _meshtastic_ModuleConfig_SerialConfig {
    /* Preferences for the SerialModule */
    bool enabled;
    /* TODO: REPLACE */
    bool echo;
    /* RX pin (should match Arduino gpio pin number) */
    uint32_t rxd;
    /* TX pin (should match Arduino gpio pin number) */
    uint32_t txd;
    /* Serial baud rate */
    meshtastic_ModuleConfig_SerialConfig_Serial_Baud baud;
    /* TODO: REPLACE */
    uint32_t timeout;
    /* Mode for serial module operation */
    meshtastic_ModuleConfig_SerialConfig_Serial_Mode mode;
    /* Overrides the platform's defacto Serial port instance to use with Serial module config settings
 This is currently only usable in output modes like NMEA / CalTopo and may behave strangely or not work at all in other modes
 Existing logging over the Serial Console will still be present */
    bool override_console_serial_port;
} meshtastic_ModuleConfig_SerialConfig;

/* External Notifications Config */
typedef struct _meshtastic_ModuleConfig_ExternalNotificationConfig {
    /* Enable the ExternalNotificationModule */
    bool enabled;
    /* When using in On/Off mode, keep the output on for this many
 milliseconds. Default 1000ms (1 second). */
    uint32_t output_ms;
    /* Define the output pin GPIO setting Defaults to
 EXT_NOTIFY_OUT if set for the board.
 In standalone devices this pin should drive the LED to match the UI. */
    uint32_t output;
    /* IF this is true, the 'output' Pin will be pulled active high, false
 means active low. */
    bool active;
    /* True: Alert when a text message arrives (output) */
    bool alert_message;
    /* True: Alert when the bell character is received (output) */
    bool alert_bell;
    /* use a PWM output instead of a simple on/off output. This will ignore
 the 'output', 'output_ms' and 'active' settings and use the
 device.buzzer_gpio instead. */
    bool use_pwm;
    /* Optional: Define a secondary output pin for a vibra motor
 This is used in standalone devices to match the UI. */
    uint8_t output_vibra;
    /* Optional: Define a tertiary output pin for an active buzzer
 This is used in standalone devices to to match the UI. */
    uint8_t output_buzzer;
    /* True: Alert when a text message arrives (output_vibra) */
    bool alert_message_vibra;
    /* True: Alert when a text message arrives (output_buzzer) */
    bool alert_message_buzzer;
    /* True: Alert when the bell character is received (output_vibra) */
    bool alert_bell_vibra;
    /* True: Alert when the bell character is received (output_buzzer) */
    bool alert_bell_buzzer;
    /* The notification will toggle with 'output_ms' for this time of seconds.
 Default is 0 which means don't repeat at all. 60 would mean blink
 and/or beep for 60 seconds */
    uint16_t nag_timeout;
    /* When true, enables devices with native I2S audio output to use the RTTTL over speaker like a buzzer
 T-Watch S3 and T-Deck for example have this capability */
    bool use_i2s_as_buzzer;
} meshtastic_ModuleConfig_ExternalNotificationConfig;

/* Store and Forward Module Config */
typedef struct _meshtastic_ModuleConfig_StoreForwardConfig {
    /* Enable the Store and Forward Module */
    bool enabled;
    /* TODO: REPLACE */
    bool heartbeat;
    /* TODO: REPLACE */
    uint32_t records;
    /* TODO: REPLACE */
    uint32_t history_return_max;
    /* TODO: REPLACE */
    uint32_t history_return_window;
} meshtastic_ModuleConfig_StoreForwardConfig;

/* Preferences for the RangeTestModule */
typedef struct _meshtastic_ModuleConfig_RangeTestConfig {
    /* Enable the Range Test Module */
    bool enabled;
    /* Send out range test messages from this node */
    uint32_t sender;
    /* Bool value indicating that this node should save a RangeTest.csv file.
 ESP32 Only */
    bool save;
} meshtastic_ModuleConfig_RangeTestConfig;

/* Configuration for both device and environment metrics */
typedef struct _meshtastic_ModuleConfig_TelemetryConfig {
    /* Interval in seconds of how often we should try to send our
 device metrics to the mesh */
    uint32_t device_update_interval;
    uint32_t environment_update_interval;
    /* Preferences for the Telemetry Module (Environment)
 Enable/Disable the telemetry measurement module measurement collection */
    bool environment_measurement_enabled;
    /* Enable/Disable the telemetry measurement module on-device display */
    bool environment_screen_enabled;
    /* We'll always read the sensor in Celsius, but sometimes we might want to
 display the results in Fahrenheit as a "user preference". */
    bool environment_display_fahrenheit;
    /* Enable/Disable the air quality metrics */
    bool air_quality_enabled;
    /* Interval in seconds of how often we should try to send our
 air quality metrics to the mesh */
    uint32_t air_quality_interval;
    /* Interval in seconds of how often we should try to send our
 air quality metrics to the mesh */
    bool power_measurement_enabled;
    /* Interval in seconds of how often we should try to send our
 air quality metrics to the mesh */
    uint32_t power_update_interval;
    /* Interval in seconds of how often we should try to send our
 air quality metrics to the mesh */
    bool power_screen_enabled;
} meshtastic_ModuleConfig_TelemetryConfig;

/* TODO: REPLACE */
typedef struct _meshtastic_ModuleConfig_CannedMessageConfig {
    /* Enable the rotary encoder #1. This is a 'dumb' encoder sending pulses on both A and B pins while rotating. */
    bool rotary1_enabled;
    /* GPIO pin for rotary encoder A port. */
    uint32_t inputbroker_pin_a;
    /* GPIO pin for rotary encoder B port. */
    uint32_t inputbroker_pin_b;
    /* GPIO pin for rotary encoder Press port. */
    uint32_t inputbroker_pin_press;
    /* Generate input event on CW of this kind. */
    meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar inputbroker_event_cw;
    /* Generate input event on CCW of this kind. */
    meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar inputbroker_event_ccw;
    /* Generate input event on Press of this kind. */
    meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar inputbroker_event_press;
    /* Enable the Up/Down/Select input device. Can be RAK rotary encoder or 3 buttons. Uses the a/b/press definitions from inputbroker. */
    bool updown1_enabled;
    /* Enable/disable CannedMessageModule. */
    bool enabled;
    /* Input event origin accepted by the canned message module.
 Can be e.g. "rotEnc1", "upDownEnc1" or keyword "_any" */
    char allow_input_source[16];
    /* CannedMessageModule also sends a bell character with the messages.
 ExternalNotificationModule can benefit from this feature. */
    bool send_bell;
} meshtastic_ModuleConfig_CannedMessageConfig;

/* Ambient Lighting Module - Settings for control of onboard LEDs to allow users to adjust the brightness levels and respective color levels.
Initially created for the RAK14001 RGB LED module. */
typedef struct _meshtastic_ModuleConfig_AmbientLightingConfig {
    /* Sets LED to on or off. */
    bool led_state;
    /* Sets the current for the LED output. Default is 10. */
    uint8_t current;
    /* Sets the red LED level. Values are 0-255. */
    uint8_t red;
    /* Sets the green LED level. Values are 0-255. */
    uint8_t green;
    /* Sets the blue LED level. Values are 0-255. */
    uint8_t blue;
} meshtastic_ModuleConfig_AmbientLightingConfig;

/* A GPIO pin definition for remote hardware module */
typedef struct _meshtastic_RemoteHardwarePin {
    /* GPIO Pin number (must match Arduino) */
    uint8_t gpio_pin;
    /* Name for the GPIO pin (i.e. Front gate, mailbox, etc) */
    char name[15];
    /* Type of GPIO access available to consumers on the mesh */
    meshtastic_RemoteHardwarePinType type;
} meshtastic_RemoteHardwarePin;

/* RemoteHardwareModule Config */
typedef struct _meshtastic_ModuleConfig_RemoteHardwareConfig {
    /* Whether the Module is enabled */
    bool enabled;
    /* Whether the Module allows consumers to read / write to pins not defined in available_pins */
    bool allow_undefined_pin_access;
    /* Exposes the available pins to the mesh for reading and writing */
    pb_size_t available_pins_count;
    meshtastic_RemoteHardwarePin available_pins[4];
} meshtastic_ModuleConfig_RemoteHardwareConfig;

/* Module Config */
typedef struct _meshtastic_ModuleConfig {
    pb_size_t which_payload_variant;
    union {
        /* TODO: REPLACE */
        meshtastic_ModuleConfig_MQTTConfig mqtt;
        /* TODO: REPLACE */
        meshtastic_ModuleConfig_SerialConfig serial;
        /* TODO: REPLACE */
        meshtastic_ModuleConfig_ExternalNotificationConfig external_notification;
        /* TODO: REPLACE */
        meshtastic_ModuleConfig_StoreForwardConfig store_forward;
        /* TODO: REPLACE */
        meshtastic_ModuleConfig_RangeTestConfig range_test;
        /* TODO: REPLACE */
        meshtastic_ModuleConfig_TelemetryConfig telemetry;
        /* TODO: REPLACE */
        meshtastic_ModuleConfig_CannedMessageConfig canned_message;
        /* TODO: REPLACE */
        meshtastic_ModuleConfig_AudioConfig audio;
        /* TODO: REPLACE */
        meshtastic_ModuleConfig_RemoteHardwareConfig remote_hardware;
        /* TODO: REPLACE */
        meshtastic_ModuleConfig_NeighborInfoConfig neighbor_info;
        /* TODO: REPLACE */
        meshtastic_ModuleConfig_AmbientLightingConfig ambient_lighting;
        /* TODO: REPLACE */
        meshtastic_ModuleConfig_DetectionSensorConfig detection_sensor;
        /* TODO: REPLACE */
        meshtastic_ModuleConfig_PaxcounterConfig paxcounter;
    } payload_variant;
} meshtastic_ModuleConfig;


#ifdef __cplusplus
extern "C" {
#endif

/* Helper constants for enums */
#define _meshtastic_RemoteHardwarePinType_MIN meshtastic_RemoteHardwarePinType_UNKNOWN
#define _meshtastic_RemoteHardwarePinType_MAX meshtastic_RemoteHardwarePinType_DIGITAL_WRITE
#define _meshtastic_RemoteHardwarePinType_ARRAYSIZE ((meshtastic_RemoteHardwarePinType)(meshtastic_RemoteHardwarePinType_DIGITAL_WRITE+1))

#define _meshtastic_ModuleConfig_AudioConfig_Audio_Baud_MIN meshtastic_ModuleConfig_AudioConfig_Audio_Baud_CODEC2_DEFAULT
#define _meshtastic_ModuleConfig_AudioConfig_Audio_Baud_MAX meshtastic_ModuleConfig_AudioConfig_Audio_Baud_CODEC2_700B
#define _meshtastic_ModuleConfig_AudioConfig_Audio_Baud_ARRAYSIZE ((meshtastic_ModuleConfig_AudioConfig_Audio_Baud)(meshtastic_ModuleConfig_AudioConfig_Audio_Baud_CODEC2_700B+1))

#define _meshtastic_ModuleConfig_SerialConfig_Serial_Baud_MIN meshtastic_ModuleConfig_SerialConfig_Serial_Baud_BAUD_DEFAULT
#define _meshtastic_ModuleConfig_SerialConfig_Serial_Baud_MAX meshtastic_ModuleConfig_SerialConfig_Serial_Baud_BAUD_921600
#define _meshtastic_ModuleConfig_SerialConfig_Serial_Baud_ARRAYSIZE ((meshtastic_ModuleConfig_SerialConfig_Serial_Baud)(meshtastic_ModuleConfig_SerialConfig_Serial_Baud_BAUD_921600+1))

#define _meshtastic_ModuleConfig_SerialConfig_Serial_Mode_MIN meshtastic_ModuleConfig_SerialConfig_Serial_Mode_DEFAULT
#define _meshtastic_ModuleConfig_SerialConfig_Serial_Mode_MAX meshtastic_ModuleConfig_SerialConfig_Serial_Mode_CALTOPO
#define _meshtastic_ModuleConfig_SerialConfig_Serial_Mode_ARRAYSIZE ((meshtastic_ModuleConfig_SerialConfig_Serial_Mode)(meshtastic_ModuleConfig_SerialConfig_Serial_Mode_CALTOPO+1))

#define _meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_MIN meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_NONE
#define _meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_MAX meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_BACK
#define _meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_ARRAYSIZE ((meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar)(meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_BACK+1))







#define meshtastic_ModuleConfig_AudioConfig_bitrate_ENUMTYPE meshtastic_ModuleConfig_AudioConfig_Audio_Baud


#define meshtastic_ModuleConfig_SerialConfig_baud_ENUMTYPE meshtastic_ModuleConfig_SerialConfig_Serial_Baud
#define meshtastic_ModuleConfig_SerialConfig_mode_ENUMTYPE meshtastic_ModuleConfig_SerialConfig_Serial_Mode





#define meshtastic_ModuleConfig_CannedMessageConfig_inputbroker_event_cw_ENUMTYPE meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar
#define meshtastic_ModuleConfig_CannedMessageConfig_inputbroker_event_ccw_ENUMTYPE meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar
#define meshtastic_ModuleConfig_CannedMessageConfig_inputbroker_event_press_ENUMTYPE meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar


#define meshtastic_RemoteHardwarePin_type_ENUMTYPE meshtastic_RemoteHardwarePinType


/* Initializer values for message structs */
#define meshtastic_ModuleConfig_init_default     {0, {meshtastic_ModuleConfig_MQTTConfig_init_default}}
#define meshtastic_ModuleConfig_MQTTConfig_init_default {0, "", "", "", 0, 0, 0, "", 0, 0, false, meshtastic_ModuleConfig_MapReportSettings_init_default}
#define meshtastic_ModuleConfig_MapReportSettings_init_default {0, 0}
#define meshtastic_ModuleConfig_RemoteHardwareConfig_init_default {0, 0, 0, {meshtastic_RemoteHardwarePin_init_default, meshtastic_RemoteHardwarePin_init_default, meshtastic_RemoteHardwarePin_init_default, meshtastic_RemoteHardwarePin_init_default}}
#define meshtastic_ModuleConfig_NeighborInfoConfig_init_default {0, 0}
#define meshtastic_ModuleConfig_DetectionSensorConfig_init_default {0, 0, 0, 0, "", 0, 0, 0}
#define meshtastic_ModuleConfig_AudioConfig_init_default {0, 0, _meshtastic_ModuleConfig_AudioConfig_Audio_Baud_MIN, 0, 0, 0, 0}
#define meshtastic_ModuleConfig_PaxcounterConfig_init_default {0, 0}
#define meshtastic_ModuleConfig_SerialConfig_init_default {0, 0, 0, 0, _meshtastic_ModuleConfig_SerialConfig_Serial_Baud_MIN, 0, _meshtastic_ModuleConfig_SerialConfig_Serial_Mode_MIN, 0}
#define meshtastic_ModuleConfig_ExternalNotificationConfig_init_default {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
#define meshtastic_ModuleConfig_StoreForwardConfig_init_default {0, 0, 0, 0, 0}
#define meshtastic_ModuleConfig_RangeTestConfig_init_default {0, 0, 0}
#define meshtastic_ModuleConfig_TelemetryConfig_init_default {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
#define meshtastic_ModuleConfig_CannedMessageConfig_init_default {0, 0, 0, 0, _meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_MIN, _meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_MIN, _meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_MIN, 0, 0, "", 0}
#define meshtastic_ModuleConfig_AmbientLightingConfig_init_default {0, 0, 0, 0, 0}
#define meshtastic_RemoteHardwarePin_init_default {0, "", _meshtastic_RemoteHardwarePinType_MIN}
#define meshtastic_ModuleConfig_init_zero        {0, {meshtastic_ModuleConfig_MQTTConfig_init_zero}}
#define meshtastic_ModuleConfig_MQTTConfig_init_zero {0, "", "", "", 0, 0, 0, "", 0, 0, false, meshtastic_ModuleConfig_MapReportSettings_init_zero}
#define meshtastic_ModuleConfig_MapReportSettings_init_zero {0, 0}
#define meshtastic_ModuleConfig_RemoteHardwareConfig_init_zero {0, 0, 0, {meshtastic_RemoteHardwarePin_init_zero, meshtastic_RemoteHardwarePin_init_zero, meshtastic_RemoteHardwarePin_init_zero, meshtastic_RemoteHardwarePin_init_zero}}
#define meshtastic_ModuleConfig_NeighborInfoConfig_init_zero {0, 0}
#define meshtastic_ModuleConfig_DetectionSensorConfig_init_zero {0, 0, 0, 0, "", 0, 0, 0}
#define meshtastic_ModuleConfig_AudioConfig_init_zero {0, 0, _meshtastic_ModuleConfig_AudioConfig_Audio_Baud_MIN, 0, 0, 0, 0}
#define meshtastic_ModuleConfig_PaxcounterConfig_init_zero {0, 0}
#define meshtastic_ModuleConfig_SerialConfig_init_zero {0, 0, 0, 0, _meshtastic_ModuleConfig_SerialConfig_Serial_Baud_MIN, 0, _meshtastic_ModuleConfig_SerialConfig_Serial_Mode_MIN, 0}
#define meshtastic_ModuleConfig_ExternalNotificationConfig_init_zero {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
#define meshtastic_ModuleConfig_StoreForwardConfig_init_zero {0, 0, 0, 0, 0}
#define meshtastic_ModuleConfig_RangeTestConfig_init_zero {0, 0, 0}
#define meshtastic_ModuleConfig_TelemetryConfig_init_zero {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
#define meshtastic_ModuleConfig_CannedMessageConfig_init_zero {0, 0, 0, 0, _meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_MIN, _meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_MIN, _meshtastic_ModuleConfig_CannedMessageConfig_InputEventChar_MIN, 0, 0, "", 0}
#define meshtastic_ModuleConfig_AmbientLightingConfig_init_zero {0, 0, 0, 0, 0}
#define meshtastic_RemoteHardwarePin_init_zero   {0, "", _meshtastic_RemoteHardwarePinType_MIN}

/* Field tags (for use in manual encoding/decoding) */
#define meshtastic_ModuleConfig_MapReportSettings_publish_interval_secs_tag 1
#define meshtastic_ModuleConfig_MapReportSettings_position_precision_tag 2
#define meshtastic_ModuleConfig_MQTTConfig_enabled_tag 1
#define meshtastic_ModuleConfig_MQTTConfig_address_tag 2
#define meshtastic_ModuleConfig_MQTTConfig_username_tag 3
#define meshtastic_ModuleConfig_MQTTConfig_password_tag 4
#define meshtastic_ModuleConfig_MQTTConfig_encryption_enabled_tag 5
#define meshtastic_ModuleConfig_MQTTConfig_json_enabled_tag 6
#define meshtastic_ModuleConfig_MQTTConfig_tls_enabled_tag 7
#define meshtastic_ModuleConfig_MQTTConfig_root_tag 8
#define meshtastic_ModuleConfig_MQTTConfig_proxy_to_client_enabled_tag 9
#define meshtastic_ModuleConfig_MQTTConfig_map_reporting_enabled_tag 10
#define meshtastic_ModuleConfig_MQTTConfig_map_report_settings_tag 11
#define meshtastic_ModuleConfig_NeighborInfoConfig_enabled_tag 1
#define meshtastic_ModuleConfig_NeighborInfoConfig_update_interval_tag 2
#define meshtastic_ModuleConfig_DetectionSensorConfig_enabled_tag 1
#define meshtastic_ModuleConfig_DetectionSensorConfig_minimum_broadcast_secs_tag 2
#define meshtastic_ModuleConfig_DetectionSensorConfig_state_broadcast_secs_tag 3
#define meshtastic_ModuleConfig_DetectionSensorConfig_send_bell_tag 4
#define meshtastic_ModuleConfig_DetectionSensorConfig_name_tag 5
#define meshtastic_ModuleConfig_DetectionSensorConfig_monitor_pin_tag 6
#define meshtastic_ModuleConfig_DetectionSensorConfig_detection_triggered_high_tag 7
#define meshtastic_ModuleConfig_DetectionSensorConfig_use_pullup_tag 8
#define meshtastic_ModuleConfig_AudioConfig_codec2_enabled_tag 1
#define meshtastic_ModuleConfig_AudioConfig_ptt_pin_tag 2
#define meshtastic_ModuleConfig_AudioConfig_bitrate_tag 3
#define meshtastic_ModuleConfig_AudioConfig_i2s_ws_tag 4
#define meshtastic_ModuleConfig_AudioConfig_i2s_sd_tag 5
#define meshtastic_ModuleConfig_AudioConfig_i2s_din_tag 6
#define meshtastic_ModuleConfig_AudioConfig_i2s_sck_tag 7
#define meshtastic_ModuleConfig_PaxcounterConfig_enabled_tag 1
#define meshtastic_ModuleConfig_PaxcounterConfig_paxcounter_update_interval_tag 2
#define meshtastic_ModuleConfig_SerialConfig_enabled_tag 1
#define meshtastic_ModuleConfig_SerialConfig_echo_tag 2
#define meshtastic_ModuleConfig_SerialConfig_rxd_tag 3
#define meshtastic_ModuleConfig_SerialConfig_txd_tag 4
#define meshtastic_ModuleConfig_SerialConfig_baud_tag 5
#define meshtastic_ModuleConfig_SerialConfig_timeout_tag 6
#define meshtastic_ModuleConfig_SerialConfig_mode_tag 7
#define meshtastic_ModuleConfig_SerialConfig_override_console_serial_port_tag 8
#define meshtastic_ModuleConfig_ExternalNotificationConfig_enabled_tag 1
#define meshtastic_ModuleConfig_ExternalNotificationConfig_output_ms_tag 2
#define meshtastic_ModuleConfig_ExternalNotificationConfig_output_tag 3
#define meshtastic_ModuleConfig_ExternalNotificationConfig_active_tag 4
#define meshtastic_ModuleConfig_ExternalNotificationConfig_alert_message_tag 5
#define meshtastic_ModuleConfig_ExternalNotificationConfig_alert_bell_tag 6
#define meshtastic_ModuleConfig_ExternalNotificationConfig_use_pwm_tag 7
#define meshtastic_ModuleConfig_ExternalNotificationConfig_output_vibra_tag 8
#define meshtastic_ModuleConfig_ExternalNotificationConfig_output_buzzer_tag 9
#define meshtastic_ModuleConfig_ExternalNotificationConfig_alert_message_vibra_tag 10
#define meshtastic_ModuleConfig_ExternalNotificationConfig_alert_message_buzzer_tag 11
#define meshtastic_ModuleConfig_ExternalNotificationConfig_alert_bell_vibra_tag 12
#define meshtastic_ModuleConfig_ExternalNotificationConfig_alert_bell_buzzer_tag 13
#define meshtastic_ModuleConfig_ExternalNotificationConfig_nag_timeout_tag 14
#define meshtastic_ModuleConfig_ExternalNotificationConfig_use_i2s_as_buzzer_tag 15
#define meshtastic_ModuleConfig_StoreForwardConfig_enabled_tag 1
#define meshtastic_ModuleConfig_StoreForwardConfig_heartbeat_tag 2
#define meshtastic_ModuleConfig_StoreForwardConfig_records_tag 3
#define meshtastic_ModuleConfig_StoreForwardConfig_history_return_max_tag 4
#define meshtastic_ModuleConfig_StoreForwardConfig_history_return_window_tag 5
#define meshtastic_ModuleConfig_RangeTestConfig_enabled_tag 1
#define meshtastic_ModuleConfig_RangeTestConfig_sender_tag 2
#define meshtastic_ModuleConfig_RangeTestConfig_save_tag 3
#define meshtastic_ModuleConfig_TelemetryConfig_device_update_interval_tag 1
#define meshtastic_ModuleConfig_TelemetryConfig_environment_update_interval_tag 2
#define meshtastic_ModuleConfig_TelemetryConfig_environment_measurement_enabled_tag 3
#define meshtastic_ModuleConfig_TelemetryConfig_environment_screen_enabled_tag 4
#define meshtastic_ModuleConfig_TelemetryConfig_environment_display_fahrenheit_tag 5
#define meshtastic_ModuleConfig_TelemetryConfig_air_quality_enabled_tag 6
#define meshtastic_ModuleConfig_TelemetryConfig_air_quality_interval_tag 7
#define meshtastic_ModuleConfig_TelemetryConfig_power_measurement_enabled_tag 8
#define meshtastic_ModuleConfig_TelemetryConfig_power_update_interval_tag 9
#define meshtastic_ModuleConfig_TelemetryConfig_power_screen_enabled_tag 10
#define meshtastic_ModuleConfig_CannedMessageConfig_rotary1_enabled_tag 1
#define meshtastic_ModuleConfig_CannedMessageConfig_inputbroker_pin_a_tag 2
#define meshtastic_ModuleConfig_CannedMessageConfig_inputbroker_pin_b_tag 3
#define meshtastic_ModuleConfig_CannedMessageConfig_inputbroker_pin_press_tag 4
#define meshtastic_ModuleConfig_CannedMessageConfig_inputbroker_event_cw_tag 5
#define meshtastic_ModuleConfig_CannedMessageConfig_inputbroker_event_ccw_tag 6
#define meshtastic_ModuleConfig_CannedMessageConfig_inputbroker_event_press_tag 7
#define meshtastic_ModuleConfig_CannedMessageConfig_updown1_enabled_tag 8
#define meshtastic_ModuleConfig_CannedMessageConfig_enabled_tag 9
#define meshtastic_ModuleConfig_CannedMessageConfig_allow_input_source_tag 10
#define meshtastic_ModuleConfig_CannedMessageConfig_send_bell_tag 11
#define meshtastic_ModuleConfig_AmbientLightingConfig_led_state_tag 1
#define meshtastic_ModuleConfig_AmbientLightingConfig_current_tag 2
#define meshtastic_ModuleConfig_AmbientLightingConfig_red_tag 3
#define meshtastic_ModuleConfig_AmbientLightingConfig_green_tag 4
#define meshtastic_ModuleConfig_AmbientLightingConfig_blue_tag 5
#define meshtastic_RemoteHardwarePin_gpio_pin_tag 1
#define meshtastic_RemoteHardwarePin_name_tag    2
#define meshtastic_RemoteHardwarePin_type_tag    3
#define meshtastic_ModuleConfig_RemoteHardwareConfig_enabled_tag 1
#define meshtastic_ModuleConfig_RemoteHardwareConfig_allow_undefined_pin_access_tag 2
#define meshtastic_ModuleConfig_RemoteHardwareConfig_available_pins_tag 3
#define meshtastic_ModuleConfig_mqtt_tag         1
#define meshtastic_ModuleConfig_serial_tag       2
#define meshtastic_ModuleConfig_external_notification_tag 3
#define meshtastic_ModuleConfig_store_forward_tag 4
#define meshtastic_ModuleConfig_range_test_tag   5
#define meshtastic_ModuleConfig_telemetry_tag    6
#define meshtastic_ModuleConfig_canned_message_tag 7
#define meshtastic_ModuleConfig_audio_tag        8
#define meshtastic_ModuleConfig_remote_hardware_tag 9
#define meshtastic_ModuleConfig_neighbor_info_tag 10
#define meshtastic_ModuleConfig_ambient_lighting_tag 11
#define meshtastic_ModuleConfig_detection_sensor_tag 12
#define meshtastic_ModuleConfig_paxcounter_tag   13

/* Struct field encoding specification for nanopb */
#define meshtastic_ModuleConfig_FIELDLIST(X, a) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,mqtt,payload_variant.mqtt),   1) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,serial,payload_variant.serial),   2) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,external_notification,payload_variant.external_notification),   3) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,store_forward,payload_variant.store_forward),   4) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,range_test,payload_variant.range_test),   5) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,telemetry,payload_variant.telemetry),   6) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,canned_message,payload_variant.canned_message),   7) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,audio,payload_variant.audio),   8) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,remote_hardware,payload_variant.remote_hardware),   9) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,neighbor_info,payload_variant.neighbor_info),  10) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,ambient_lighting,payload_variant.ambient_lighting),  11) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,detection_sensor,payload_variant.detection_sensor),  12) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,paxcounter,payload_variant.paxcounter),  13)
#define meshtastic_ModuleConfig_CALLBACK NULL
#define meshtastic_ModuleConfig_DEFAULT NULL
#define meshtastic_ModuleConfig_payload_variant_mqtt_MSGTYPE meshtastic_ModuleConfig_MQTTConfig
#define meshtastic_ModuleConfig_payload_variant_serial_MSGTYPE meshtastic_ModuleConfig_SerialConfig
#define meshtastic_ModuleConfig_payload_variant_external_notification_MSGTYPE meshtastic_ModuleConfig_ExternalNotificationConfig
#define meshtastic_ModuleConfig_payload_variant_store_forward_MSGTYPE meshtastic_ModuleConfig_StoreForwardConfig
#define meshtastic_ModuleConfig_payload_variant_range_test_MSGTYPE meshtastic_ModuleConfig_RangeTestConfig
#define meshtastic_ModuleConfig_payload_variant_telemetry_MSGTYPE meshtastic_ModuleConfig_TelemetryConfig
#define meshtastic_ModuleConfig_payload_variant_canned_message_MSGTYPE meshtastic_ModuleConfig_CannedMessageConfig
#define meshtastic_ModuleConfig_payload_variant_audio_MSGTYPE meshtastic_ModuleConfig_AudioConfig
#define meshtastic_ModuleConfig_payload_variant_remote_hardware_MSGTYPE meshtastic_ModuleConfig_RemoteHardwareConfig
#define meshtastic_ModuleConfig_payload_variant_neighbor_info_MSGTYPE meshtastic_ModuleConfig_NeighborInfoConfig
#define meshtastic_ModuleConfig_payload_variant_ambient_lighting_MSGTYPE meshtastic_ModuleConfig_AmbientLightingConfig
#define meshtastic_ModuleConfig_payload_variant_detection_sensor_MSGTYPE meshtastic_ModuleConfig_DetectionSensorConfig
#define meshtastic_ModuleConfig_payload_variant_paxcounter_MSGTYPE meshtastic_ModuleConfig_PaxcounterConfig

#define meshtastic_ModuleConfig_MQTTConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     enabled,           1) \
X(a, STATIC,   SINGULAR, STRING,   address,           2) \
X(a, STATIC,   SINGULAR, STRING,   username,          3) \
X(a, STATIC,   SINGULAR, STRING,   password,          4) \
X(a, STATIC,   SINGULAR, BOOL,     encryption_enabled,   5) \
X(a, STATIC,   SINGULAR, BOOL,     json_enabled,      6) \
X(a, STATIC,   SINGULAR, BOOL,     tls_enabled,       7) \
X(a, STATIC,   SINGULAR, STRING,   root,              8) \
X(a, STATIC,   SINGULAR, BOOL,     proxy_to_client_enabled,   9) \
X(a, STATIC,   SINGULAR, BOOL,     map_reporting_enabled,  10) \
X(a, STATIC,   OPTIONAL, MESSAGE,  map_report_settings,  11)
#define meshtastic_ModuleConfig_MQTTConfig_CALLBACK NULL
#define meshtastic_ModuleConfig_MQTTConfig_DEFAULT NULL
#define meshtastic_ModuleConfig_MQTTConfig_map_report_settings_MSGTYPE meshtastic_ModuleConfig_MapReportSettings

#define meshtastic_ModuleConfig_MapReportSettings_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   publish_interval_secs,   1) \
X(a, STATIC,   SINGULAR, UINT32,   position_precision,   2)
#define meshtastic_ModuleConfig_MapReportSettings_CALLBACK NULL
#define meshtastic_ModuleConfig_MapReportSettings_DEFAULT NULL

#define meshtastic_ModuleConfig_RemoteHardwareConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     enabled,           1) \
X(a, STATIC,   SINGULAR, BOOL,     allow_undefined_pin_access,   2) \
X(a, STATIC,   REPEATED, MESSAGE,  available_pins,    3)
#define meshtastic_ModuleConfig_RemoteHardwareConfig_CALLBACK NULL
#define meshtastic_ModuleConfig_RemoteHardwareConfig_DEFAULT NULL
#define meshtastic_ModuleConfig_RemoteHardwareConfig_available_pins_MSGTYPE meshtastic_RemoteHardwarePin

#define meshtastic_ModuleConfig_NeighborInfoConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     enabled,           1) \
X(a, STATIC,   SINGULAR, UINT32,   update_interval,   2)
#define meshtastic_ModuleConfig_NeighborInfoConfig_CALLBACK NULL
#define meshtastic_ModuleConfig_NeighborInfoConfig_DEFAULT NULL

#define meshtastic_ModuleConfig_DetectionSensorConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     enabled,           1) \
X(a, STATIC,   SINGULAR, UINT32,   minimum_broadcast_secs,   2) \
X(a, STATIC,   SINGULAR, UINT32,   state_broadcast_secs,   3) \
X(a, STATIC,   SINGULAR, BOOL,     send_bell,         4) \
X(a, STATIC,   SINGULAR, STRING,   name,              5) \
X(a, STATIC,   SINGULAR, UINT32,   monitor_pin,       6) \
X(a, STATIC,   SINGULAR, BOOL,     detection_triggered_high,   7) \
X(a, STATIC,   SINGULAR, BOOL,     use_pullup,        8)
#define meshtastic_ModuleConfig_DetectionSensorConfig_CALLBACK NULL
#define meshtastic_ModuleConfig_DetectionSensorConfig_DEFAULT NULL

#define meshtastic_ModuleConfig_AudioConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     codec2_enabled,    1) \
X(a, STATIC,   SINGULAR, UINT32,   ptt_pin,           2) \
X(a, STATIC,   SINGULAR, UENUM,    bitrate,           3) \
X(a, STATIC,   SINGULAR, UINT32,   i2s_ws,            4) \
X(a, STATIC,   SINGULAR, UINT32,   i2s_sd,            5) \
X(a, STATIC,   SINGULAR, UINT32,   i2s_din,           6) \
X(a, STATIC,   SINGULAR, UINT32,   i2s_sck,           7)
#define meshtastic_ModuleConfig_AudioConfig_CALLBACK NULL
#define meshtastic_ModuleConfig_AudioConfig_DEFAULT NULL

#define meshtastic_ModuleConfig_PaxcounterConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     enabled,           1) \
X(a, STATIC,   SINGULAR, UINT32,   paxcounter_update_interval,   2)
#define meshtastic_ModuleConfig_PaxcounterConfig_CALLBACK NULL
#define meshtastic_ModuleConfig_PaxcounterConfig_DEFAULT NULL

#define meshtastic_ModuleConfig_SerialConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     enabled,           1) \
X(a, STATIC,   SINGULAR, BOOL,     echo,              2) \
X(a, STATIC,   SINGULAR, UINT32,   rxd,               3) \
X(a, STATIC,   SINGULAR, UINT32,   txd,               4) \
X(a, STATIC,   SINGULAR, UENUM,    baud,              5) \
X(a, STATIC,   SINGULAR, UINT32,   timeout,           6) \
X(a, STATIC,   SINGULAR, UENUM,    mode,              7) \
X(a, STATIC,   SINGULAR, BOOL,     override_console_serial_port,   8)
#define meshtastic_ModuleConfig_SerialConfig_CALLBACK NULL
#define meshtastic_ModuleConfig_SerialConfig_DEFAULT NULL

#define meshtastic_ModuleConfig_ExternalNotificationConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     enabled,           1) \
X(a, STATIC,   SINGULAR, UINT32,   output_ms,         2) \
X(a, STATIC,   SINGULAR, UINT32,   output,            3) \
X(a, STATIC,   SINGULAR, BOOL,     active,            4) \
X(a, STATIC,   SINGULAR, BOOL,     alert_message,     5) \
X(a, STATIC,   SINGULAR, BOOL,     alert_bell,        6) \
X(a, STATIC,   SINGULAR, BOOL,     use_pwm,           7) \
X(a, STATIC,   SINGULAR, UINT32,   output_vibra,      8) \
X(a, STATIC,   SINGULAR, UINT32,   output_buzzer,     9) \
X(a, STATIC,   SINGULAR, BOOL,     alert_message_vibra,  10) \
X(a, STATIC,   SINGULAR, BOOL,     alert_message_buzzer,  11) \
X(a, STATIC,   SINGULAR, BOOL,     alert_bell_vibra,  12) \
X(a, STATIC,   SINGULAR, BOOL,     alert_bell_buzzer,  13) \
X(a, STATIC,   SINGULAR, UINT32,   nag_timeout,      14) \
X(a, STATIC,   SINGULAR, BOOL,     use_i2s_as_buzzer,  15)
#define meshtastic_ModuleConfig_ExternalNotificationConfig_CALLBACK NULL
#define meshtastic_ModuleConfig_ExternalNotificationConfig_DEFAULT NULL

#define meshtastic_ModuleConfig_StoreForwardConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     enabled,           1) \
X(a, STATIC,   SINGULAR, BOOL,     heartbeat,         2) \
X(a, STATIC,   SINGULAR, UINT32,   records,           3) \
X(a, STATIC,   SINGULAR, UINT32,   history_return_max,   4) \
X(a, STATIC,   SINGULAR, UINT32,   history_return_window,   5)
#define meshtastic_ModuleConfig_StoreForwardConfig_CALLBACK NULL
#define meshtastic_ModuleConfig_StoreForwardConfig_DEFAULT NULL

#define meshtastic_ModuleConfig_RangeTestConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     enabled,           1) \
X(a, STATIC,   SINGULAR, UINT32,   sender,            2) \
X(a, STATIC,   SINGULAR, BOOL,     save,              3)
#define meshtastic_ModuleConfig_RangeTestConfig_CALLBACK NULL
#define meshtastic_ModuleConfig_RangeTestConfig_DEFAULT NULL

#define meshtastic_ModuleConfig_TelemetryConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   device_update_interval,   1) \
X(a, STATIC,   SINGULAR, UINT32,   environment_update_interval,   2) \
X(a, STATIC,   SINGULAR, BOOL,     environment_measurement_enabled,   3) \
X(a, STATIC,   SINGULAR, BOOL,     environment_screen_enabled,   4) \
X(a, STATIC,   SINGULAR, BOOL,     environment_display_fahrenheit,   5) \
X(a, STATIC,   SINGULAR, BOOL,     air_quality_enabled,   6) \
X(a, STATIC,   SINGULAR, UINT32,   air_quality_interval,   7) \
X(a, STATIC,   SINGULAR, BOOL,     power_measurement_enabled,   8) \
X(a, STATIC,   SINGULAR, UINT32,   power_update_interval,   9) \
X(a, STATIC,   SINGULAR, BOOL,     power_screen_enabled,  10)
#define meshtastic_ModuleConfig_TelemetryConfig_CALLBACK NULL
#define meshtastic_ModuleConfig_TelemetryConfig_DEFAULT NULL

#define meshtastic_ModuleConfig_CannedMessageConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     rotary1_enabled,   1) \
X(a, STATIC,   SINGULAR, UINT32,   inputbroker_pin_a,   2) \
X(a, STATIC,   SINGULAR, UINT32,   inputbroker_pin_b,   3) \
X(a, STATIC,   SINGULAR, UINT32,   inputbroker_pin_press,   4) \
X(a, STATIC,   SINGULAR, UENUM,    inputbroker_event_cw,   5) \
X(a, STATIC,   SINGULAR, UENUM,    inputbroker_event_ccw,   6) \
X(a, STATIC,   SINGULAR, UENUM,    inputbroker_event_press,   7) \
X(a, STATIC,   SINGULAR, BOOL,     updown1_enabled,   8) \
X(a, STATIC,   SINGULAR, BOOL,     enabled,           9) \
X(a, STATIC,   SINGULAR, STRING,   allow_input_source,  10) \
X(a, STATIC,   SINGULAR, BOOL,     send_bell,        11)
#define meshtastic_ModuleConfig_CannedMessageConfig_CALLBACK NULL
#define meshtastic_ModuleConfig_CannedMessageConfig_DEFAULT NULL

#define meshtastic_ModuleConfig_AmbientLightingConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     led_state,         1) \
X(a, STATIC,   SINGULAR, UINT32,   current,           2) \
X(a, STATIC,   SINGULAR, UINT32,   red,               3) \
X(a, STATIC,   SINGULAR, UINT32,   green,             4) \
X(a, STATIC,   SINGULAR, UINT32,   blue,              5)
#define meshtastic_ModuleConfig_AmbientLightingConfig_CALLBACK NULL
#define meshtastic_ModuleConfig_AmbientLightingConfig_DEFAULT NULL

#define meshtastic_RemoteHardwarePin_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   gpio_pin,          1) \
X(a, STATIC,   SINGULAR, STRING,   name,              2) \
X(a, STATIC,   SINGULAR, UENUM,    type,              3)
#define meshtastic_RemoteHardwarePin_CALLBACK NULL
#define meshtastic_RemoteHardwarePin_DEFAULT NULL

extern const pb_msgdesc_t meshtastic_ModuleConfig_msg;
extern const pb_msgdesc_t meshtastic_ModuleConfig_MQTTConfig_msg;
extern const pb_msgdesc_t meshtastic_ModuleConfig_MapReportSettings_msg;
extern const pb_msgdesc_t meshtastic_ModuleConfig_RemoteHardwareConfig_msg;
extern const pb_msgdesc_t meshtastic_ModuleConfig_NeighborInfoConfig_msg;
extern const pb_msgdesc_t meshtastic_ModuleConfig_DetectionSensorConfig_msg;
extern const pb_msgdesc_t meshtastic_ModuleConfig_AudioConfig_msg;
extern const pb_msgdesc_t meshtastic_ModuleConfig_PaxcounterConfig_msg;
extern const pb_msgdesc_t meshtastic_ModuleConfig_SerialConfig_msg;
extern const pb_msgdesc_t meshtastic_ModuleConfig_ExternalNotificationConfig_msg;
extern const pb_msgdesc_t meshtastic_ModuleConfig_StoreForwardConfig_msg;
extern const pb_msgdesc_t meshtastic_ModuleConfig_RangeTestConfig_msg;
extern const pb_msgdesc_t meshtastic_ModuleConfig_TelemetryConfig_msg;
extern const pb_msgdesc_t meshtastic_ModuleConfig_CannedMessageConfig_msg;
extern const pb_msgdesc_t meshtastic_ModuleConfig_AmbientLightingConfig_msg;
extern const pb_msgdesc_t meshtastic_RemoteHardwarePin_msg;

/* Defines for backwards compatibility with code written before nanopb-0.4.0 */
#define meshtastic_ModuleConfig_fields &meshtastic_ModuleConfig_msg
#define meshtastic_ModuleConfig_MQTTConfig_fields &meshtastic_ModuleConfig_MQTTConfig_msg
#define meshtastic_ModuleConfig_MapReportSettings_fields &meshtastic_ModuleConfig_MapReportSettings_msg
#define meshtastic_ModuleConfig_RemoteHardwareConfig_fields &meshtastic_ModuleConfig_RemoteHardwareConfig_msg
#define meshtastic_ModuleConfig_NeighborInfoConfig_fields &meshtastic_ModuleConfig_NeighborInfoConfig_msg
#define meshtastic_ModuleConfig_DetectionSensorConfig_fields &meshtastic_ModuleConfig_DetectionSensorConfig_msg
#define meshtastic_ModuleConfig_AudioConfig_fields &meshtastic_ModuleConfig_AudioConfig_msg
#define meshtastic_ModuleConfig_PaxcounterConfig_fields &meshtastic_ModuleConfig_PaxcounterConfig_msg
#define meshtastic_ModuleConfig_SerialConfig_fields &meshtastic_ModuleConfig_SerialConfig_msg
#define meshtastic_ModuleConfig_ExternalNotificationConfig_fields &meshtastic_ModuleConfig_ExternalNotificationConfig_msg
#define meshtastic_ModuleConfig_StoreForwardConfig_fields &meshtastic_ModuleConfig_StoreForwardConfig_msg
#define meshtastic_ModuleConfig_RangeTestConfig_fields &meshtastic_ModuleConfig_RangeTestConfig_msg
#define meshtastic_ModuleConfig_TelemetryConfig_fields &meshtastic_ModuleConfig_TelemetryConfig_msg
#define meshtastic_ModuleConfig_CannedMessageConfig_fields &meshtastic_ModuleConfig_CannedMessageConfig_msg
#define meshtastic_ModuleConfig_AmbientLightingConfig_fields &meshtastic_ModuleConfig_AmbientLightingConfig_msg
#define meshtastic_RemoteHardwarePin_fields &meshtastic_RemoteHardwarePin_msg

/* Maximum encoded size of messages (where known) */
#define MESHTASTIC_MESHTASTIC_MODULE_CONFIG_PB_H_MAX_SIZE meshtastic_ModuleConfig_size
#define meshtastic_ModuleConfig_AmbientLightingConfig_size 14
#define meshtastic_ModuleConfig_AudioConfig_size 19
#define meshtastic_ModuleConfig_CannedMessageConfig_size 49
#define meshtastic_ModuleConfig_DetectionSensorConfig_size 44
#define meshtastic_ModuleConfig_ExternalNotificationConfig_size 42
#define meshtastic_ModuleConfig_MQTTConfig_size  254
#define meshtastic_ModuleConfig_MapReportSettings_size 12
#define meshtastic_ModuleConfig_NeighborInfoConfig_size 8
#define meshtastic_ModuleConfig_PaxcounterConfig_size 8
#define meshtastic_ModuleConfig_RangeTestConfig_size 10
#define meshtastic_ModuleConfig_RemoteHardwareConfig_size 96
#define meshtastic_ModuleConfig_SerialConfig_size 28
#define meshtastic_ModuleConfig_StoreForwardConfig_size 22
#define meshtastic_ModuleConfig_TelemetryConfig_size 36
#define meshtastic_ModuleConfig_size             257
#define meshtastic_RemoteHardwarePin_size        21

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
