# フォークガイドライン
このガイドラインは、Town Of Host(以下"当mod")の開発者が当modのフォークする上でのルールを定めるものです。  
双方の効率的なmod開発のためにも、当modをフォークする際はこのガイドラインに従うようお願いいたします。  
また、当modはAmong Usのmodであるため、Innerslothが定める[Among Us Mod Policy](https://www.innersloth.com/among-us-mod-policy/)にも従ってください。  

> *Warning*
> 当ガイドラインは予告なく変更する場合があります。

## 定義
このガイドラインではフォークを二つの分類に分けます。  
分類と定義は以下の通りです。
### パブリックフォーク
- ソースコードが公開されており、かつビルド済みのファイルが不特定多数がアクセスできる場所に公開されているもの。
### プライベートフォーク
- ビルド済みのファイルが不特定多数がアクセスできる場所に公開されていないもの。

## 禁止事項
### 共通
- README内のDiscordサーバーの招待リンクを変更・削除しないままREADMEを公開すること
- `Main.ForkId`を変更しないまま使用・配布すること
- 当modのフォークしてないバージョンであると自称して使用・配布すること
- Among Us及び当modのゲーム上で不正行為を行うことのできる機能を追加すること
### パブリックフォーク
- タイトル画面にあるDiscordサーバーへの招待リンクを変更・削除しないまま配布すること
- `Main.ModName`を変更しないまま配布すること
- ソースコードを公開しないまま配布すること
- ソースコードの公開サイトとmod配布サイトへ当modのフォークである旨の文章とフォーク元のリンクの記載をせずに配布すること
- 当modのフォークしてないバージョンであると誤認させるような仕様のまま配布すること
### プライベートフォーク
- ビルド済みのファイルを不特定多数がアクセスできる場所に公開すること
- 参加者に使用中のmodが当modのプライベートフォーク(非公式バージョン)であることを伝えないままゲームを開始すること
- プライベートフォークを導入した状態で公開ルームを建てること

## 例外事項
- GitHubのフォーク機能を使用した場合、GitHub側のフォーク表記を当modのフォークである旨の文章かつフォーク元のリンクとして認めます。  
また、modの配布もGitHubのリリース機能を使用して行っている場合、リリースノートに当modのフォークである旨の文章とフォーク元のリンクを記載する必要はありません。
- 4/1のみ、非公開ルームで友人を楽しませる目的に限って当modのフォークしてないバージョンのバージョンであることを自称してプレイすることを認めます。
ただし、4/2になる前に必ずネタバラシを行ってください。
偽った状態での不特定多数への配布は認められません。
- 明らかに活動していないと分かるフォークやアーカイブされたフォークに限り、READMEに関する禁止事項の適用を免除します。

## プログラム設定について
main.csにあるプログラム設定は、フォーク開発者向けに作られたフォーク固有の設定を簡単に変更するための機能です。  
項目と説明は以下の通りです。
<!-- VSCode視点で崩れてますが、備考が長いせいです -->
| 項目名                   | 概要                            | 初期値                                | 備考                                                           |
| ------------------------ | ------------------------------- | ------------------------------------- | -------------------------------------------------------------- |
| `Main.ModName`           | modの表示名です                 | TownOfHost                            | タイトル画面とゲーム中に右上に表示されます                     |
| `Main.ModColor`          | modの色です                     | #00bfff                               | mod名表示の色として使用されます                                |
| `Main.AllowPublicRoom`   | 公開ルームを許可するか          | true                                  | プライベートフォークの場合はfalseに変更してください            |
| `Main.ForkId`            | フォーク固有のID                | OriginalTOH                           | バージョン判定に使われるので、必ず固有のものに変更してください |
| `Main.ShowDiscordButton` | Discordボタンを表示するかどうか | true                                  | Discordサーバーがない場合はfalseに変更してください             |
| `Main.DiscordInviteUrl`  | Discordボタンのリンク先         | [省略](https://discord.gg/W5ug6hXB9V) | Discordボタンを表示する場合は必ず変更してください              |
