#!/usr/bin/env bash

# Copyright (c) 2021-2024 tteck
# Author: tteck (tteckster)
# License: MIT
# https://github.com/tteck/Proxmox/raw/main/LICENSE

source /dev/stdin <<< "$FUNCTIONS_FILE_PATH"
color
verb_ip6
catch_errors
setting_up_container
network_check
update_os

msg_info "Installing Dependencies"
$STD apt-get install -y curl
$STD apt-get install -y sudo
$STD apt-get install -y mc
$STD apt-get install -y apt-transport-https
$STD apt-get install -y composer
$STD apt-get install -y php8.2-{bz2,curl,sqlite3,zip,xml}
msg_ok "Installed Dependencies"

RELEASE=$(curl -sX GET "https://api.github.com/repos/linuxserver/Heimdall/releases/latest" | awk '/tag_name/{print $4;exit}' FS='[""]')
echo "${RELEASE}" >/opt/${APPLICATION}_version.txt
msg_info "Installing Heimdall Dashboard ${RELEASE}"
wget -q https://github.com/linuxserver/Heimdall/archive/${RELEASE}.tar.gz
tar xzf ${RELEASE}.tar.gz
VER=$(curl -s https://api.github.com/repos/linuxserver/Heimdall/releases/latest | grep "tag_name" | awk '{print substr($2, 3, length($2)-4) }')
rm -rf ${RELEASE}.tar.gz
mv Heimdall-${VER} /opt/Heimdall
cd /opt/Heimdall
cp .env.example .env
$STD php artisan key:generate
msg_ok "Installed Heimdall Dashboard ${RELEASE}"

msg_info "Creating Service"
service_path="/etc/systemd/system/heimdall.service"
echo "[Unit]
Description=Heimdall
After=network.target

[Service]
Restart=always
RestartSec=5
Type=simple
User=root
WorkingDirectory=/opt/Heimdall
ExecStart="/usr/bin/php" artisan serve --port 7990 --host 0.0.0.0
TimeoutStopSec=30

[Install]
WantedBy=multi-user.target" >$service_path
systemctl enable -q --now heimdall.service
cd /opt/Heimdall
COMPOSER_ALLOW_SUPERUSER=1 composer dump-autoload &>/dev/null
systemctl restart heimdall.service
msg_ok "Created Service"

motd_ssh
customize

msg_info "Cleaning up"
$STD apt-get -y autoremove
$STD apt-get -y autoclean
msg_ok "Cleaned"
