// Copyright 2018 tsuru authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package v1

import (
	"github.com/tsuru/tsuru/types/provision"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// +genclient
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// App is a specification for a App resource
type App struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata,omitempty"`

	Spec AppSpec `json:"spec"`
}

// AppSpec is the spec for a App resource
type AppSpec struct {
	NamespaceName        string                               `json:"namespaceName"`
	ServiceAccountName   string                               `json:"serviceAccountName"`
	Deployments          map[string][]string                  `json:"deployments"`
	Services             map[string][]string                  `json:"services"`
	PodDisruptionBudgets map[string][]string                  `json:"podDisruptionBudgets"`
	Configs              *provision.TsuruYamlKubernetesConfig `json:"configs"`
}

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// FooList is a list of Foo resources
type AppList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`

	Items []App `json:"items"`
}
