using System.Text.RegularExpressions;

namespace LangChain.Databases;

/// <summary>
/// Vector collection(table).
/// One database can have multiple collections.
/// One collection can have multiple vectors.
/// </summary>
public class VectorCollection(
    string name = VectorCollection.DefaultName,
    string? id = null)
{
    public const string DefaultName = "langchain";

    /// <summary>
    /// Identifier of collection generated by Vector Database.
    /// </summary>
    public string Id { get; set; } = id ?? Guid.NewGuid().ToString();

    /// <summary>
    /// Collection name provided by client.
    /// </summary>
    public string Name { get; set; } = name;


    protected static bool IsValidJsonKey(string input)
    {
        // Only allow letters, numbers, and underscores
        return Regex.IsMatch(input, @"^\w+$");
    }
}