
#nullable enable

namespace AI21
{
    /// <summary>
    /// 
    /// </summary>
    public sealed partial class Message
    {
        /// <summary>
        /// The role of an individual message.<br/>
        /// - `user`:  Input provided by the user. Any instructions given here that conflict<br/>
        ///   with instructions given in the `system` prompt take precedence over the `system`<br/>
        ///   prompt instructions.<br/>
        /// - `assistant`:  Response generated by the model.<br/>
        /// - `system`:  Initial instructions provided to the system to provide general guidance<br/>
        ///   on the tone and voice of the generated message. An initial system message is<br/>
        ///   optional but recommended to provide guidance on the tone of the chat. For<br/>
        ///   example, "You are a helpful chatbot with a background in earth sciences and a<br/>
        ///   charming French accent."
        /// </summary>
        [global::System.Text.Json.Serialization.JsonPropertyName("role")]
        [global::System.Text.Json.Serialization.JsonConverter(typeof(global::AI21.JsonConverters.MessageRoleJsonConverter))]
        [global::System.Text.Json.Serialization.JsonRequired]
        public required global::AI21.MessageRole Role { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [global::System.Text.Json.Serialization.JsonPropertyName("content")]
        [global::System.Text.Json.Serialization.JsonRequired]
        public required string Content { get; set; }

        /// <summary>
        /// Additional properties that are not explicitly defined in the schema
        /// </summary>
        [global::System.Text.Json.Serialization.JsonExtensionData]
        public global::System.Collections.Generic.IDictionary<string, object> AdditionalProperties { get; set; } = new global::System.Collections.Generic.Dictionary<string, object>();

        /// <summary>
        /// Initializes a new instance of the <see cref="Message" /> class.
        /// </summary>
        /// <param name="role">
        /// The role of an individual message.<br/>
        /// - `user`:  Input provided by the user. Any instructions given here that conflict<br/>
        ///   with instructions given in the `system` prompt take precedence over the `system`<br/>
        ///   prompt instructions.<br/>
        /// - `assistant`:  Response generated by the model.<br/>
        /// - `system`:  Initial instructions provided to the system to provide general guidance<br/>
        ///   on the tone and voice of the generated message. An initial system message is<br/>
        ///   optional but recommended to provide guidance on the tone of the chat. For<br/>
        ///   example, "You are a helpful chatbot with a background in earth sciences and a<br/>
        ///   charming French accent."
        /// </param>
        /// <param name="content"></param>
        [global::System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
        public Message(
            global::AI21.MessageRole role,
            string content)
        {
            this.Role = role;
            this.Content = content ?? throw new global::System.ArgumentNullException(nameof(content));
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="Message" /> class.
        /// </summary>
        public Message()
        {
        }
    }
}